

#declare Beach = height_field
{                         
        png "beach.png"
        smooth         
        translate <-0.5,-0.5,-0.5>
        scale <20,2,20>
        texture { SandC_T }
}                    

             
#declare Sky = sphere 
{ <0, -39000, 0>, 40000
   inverse

   pigment { Sky_C }
   finish {
      ambient 1
      diffuse 0
   }
}                  
                      
  
#declare  Sea = plane
{
        y, -0.5
        texture { Sea_T }
}                                         


#declare Liegestuhl_Gebaelk = union
{
        union
        {
                difference
                {
                        box { <-0.2,0,-0.1>, <0.2,5,0.1> }
                        cylinder { <0,0.25,-0.125>, <0,0.25,2.125>, 0.105 }
                        cylinder { <0,4.75,-0.125>, <0,4.75,2.125>, 0.105 }
                        cylinder { <0,1.5,-0.125>, <0,1.5,2.125>, 0.105 }
                        cylinder { <0,0.25,-0.125>, <0,0.25,2.125>, 0.105 }
                        
                        texture { My_Wood_T translate z*0.1974 }
                }
                difference
                {
                        box { <-0.2,0,-0.1>, <0.2,5,0.1> translate z*2 }
                        cylinder { <0,0.25,-0.125>, <0,0.25,2.125>, 0.105 }
                        cylinder { <0,4.75,-0.125>, <0,4.75,2.125>, 0.105 }
                        cylinder { <0,1.5,-0.125>, <0,1.5,2.125>, 0.105 }
                        cylinder { <0,0.25,-0.125>, <0,0.25,2.125>, 0.105 }
                        
                        texture { My_Wood_T translate z*0.3974 }
                }
                cylinder { <0,0.25,-0.125>, <0,0.25,2.125>, 0.1 texture { My_Wood_T rotate x*90 } }
                cylinder { <0,4.75,-0.125>, <0,4.75,2.125>, 0.1 texture { My_Wood_T rotate x*90 } }

//                translate y*-2
//                rotate z*70
//                translate y*2
        }
        
        union
        {
                difference
                {
                        box { <-0.2,0,-0.1>, <0.2,5,0.1> translate z*0.21 }
                        cylinder { <0,0.25,-0.125>, <0,0.25,2.125>, 0.105 }
                        cylinder { <0,4.75,-0.125>, <0,4.75,2.125>, 0.105 }
                        cylinder { <0,1.5,-0.125>, <0,1.5,2.125>, 0.105 }
                        // Kerben
                        box { <-0.075,-0.075,-1>, <0.075,0.075,3> rotate z*45 translate <-0.2,2.9,0> }
                        box { <-0.075,-0.075,-1>, <0.075,0.075,3> rotate z*45 translate <-0.2,3.3,0> }
                        box { <-0.075,-0.075,-1>, <0.075,0.075,3> rotate z*45 translate <-0.2,3.7,0> }
                        box { <-0.075,-0.075,-1>, <0.075,0.075,3> rotate z*45 translate <-0.2,4.1,0> }
                        box { <-0.075,-0.075,-1>, <0.075,0.075,3> rotate z*45 translate <-0.2,4.5,0> }
                        
                        texture { My_Wood_T translate z*0.4711 }
                }
                difference
                {
                        box { <-0.2,0,-0.1>, <0.2,5,0.1> translate z*1.79 }
                        cylinder { <0,0.25,-0.125>, <0,0.25,2.125>, 0.105 }
                        cylinder { <0,4.75,-0.125>, <0,4.75,2.125>, 0.105 }
                        cylinder { <0,1.5,-0.125>, <0,1.5,2.125>, 0.105 }
                        // Kerben
                        box { <-0.075,-0.075,-1>, <0.075,0.075,3> rotate z*45 translate <-0.2,2.9,0> }
                        box { <-0.075,-0.075,-1>, <0.075,0.075,3> rotate z*45 translate <-0.2,3.3,0> }
                        box { <-0.075,-0.075,-1>, <0.075,0.075,3> rotate z*45 translate <-0.2,3.7,0> }
                        box { <-0.075,-0.075,-1>, <0.075,0.075,3> rotate z*45 translate <-0.2,4.1,0> }
                        box { <-0.075,-0.075,-1>, <0.075,0.075,3> rotate z*45 translate <-0.2,4.5,0> }
                        
                        texture { My_Wood_T translate z*0.0815 }
                }                                              
                cylinder { <0,0.25,0.096>, <0,0.25,1.996>, 0.1 texture { My_Wood_T rotate x*90 } }
                cylinder { <0,4.75,0.096>, <0,4.75,1.996>, 0.1 texture { My_Wood_T rotate x*90 } }

                translate y*-1.5
                rotate z*-60
                translate y*1.5
        }
        union
        {
                difference
                {
                        box { <-0.2,0,-0.1>, <0.2,2.025,0.1> translate z*0.21 }
                        cylinder { <0,0.25,-0.125>, <0,0.25,2.125>, 0.105 }
                        
                        texture { My_Wood_T translate z*0.0815 }
                }   
                difference
                {
                        box { <-0.2,0,-0.1>, <0.2,2.025,0.1> translate z*1.79 }
                        cylinder { <0,0.25,-0.125>, <0,0.25,2.125>, 0.105 }
                        
                        texture { My_Wood_T translate z*0.4711 }
                }     
                
                cylinder { <0,0.25,-0.125>, <0,0.25,0.335>, 0.1 texture { My_Wood_T rotate x*90 } }
                cylinder { <0,0.25,1.665>, <0,0.25,2.125>, 0.1 texture { My_Wood_T rotate x*90 } }
                

                translate y*-0.25
                rotate z*-119
                translate <0,3.5,0>
        }
        cylinder { <0,1.5,-0.125>, <0,1.5,0.335>, 0.1 texture { My_Wood_T rotate x*90 } }
        cylinder { <0,1.5,1.665>, <0,1.5,2.125>, 0.1 texture { My_Wood_T rotate x*90 } }

        
//        texture { pigment { Gray50 } }   
        
        translate y*-0.25
        rotate z*-45.2
        translate y*0.25
}       


#declare Liegestuhl= union
{
        object { Liegestuhl_Gebaelk }  
        object { Liegestuhl_Decke texture { Liegestuhl_Decke_T } scale <1.3,1.55,0.8> translate y*3 rotate z*-44.5 translate <-0.25,0.1,1> }  
//        rotate y*-90  
//        translate y*-0.1
}  
  

#declare Glas = difference
{
        cylinder { <0,0,0>, <0,0.4,0>, 0.1 }
        cylinder { <0,0.05,0>, <0,0.5,0>, 0.095 }

        texture { My_Glass_T }
        interior { ior 1.5 }

}                

#declare TequilaSunrise = cylinder
{
        <0,0.050000001,0>, <0,0.35,0>, 0.09499999999
        texture { TequilaSunrise_T }
}
             
#declare twirl_name = "Straw_bend"
#declare twirl_object =  union
{
        cylinder { <0,0,0>, <0,0.005,0>, 0.015 }
//        cone { <0,0,0>, 0.0125 , <0,0.005,0>, 0.0175 }
//        cone { <0,0.005,0>, 0.0175 , <0,0.01,0>, 0.0125 }
}        
#declare twirl_turns_z = 0.13;
#declare twirl_offset_x = 0.0001;
#declare twirl_offset_y = 0.005;
#declare twirl_offset_z = 0.0;
#declare twirl_angle_offset_z = 10;
#declare twirl_scale_inc_x = 0;
#declare twirl_scale_inc_y = 0;
#declare twirl_scale_inc_z = 0;
#declare Straw_bend = object { #include "twirl.inc" }
             

             
#declare Straw_not = union
{

        difference
        {
                cylinder { <0,0.05,0>, <0,0.425,0>, 0.0125 }
                cylinder { <0,0,0>, <0,0.55,0>, 0.0124 }
        }
        object { Straw_bend translate y*0.425 } 
        difference
        {
                cylinder { <0,0,0>, <0,0.125,0>, 0.0125 }
                cylinder { <0,-0.5,0>, <0,0.165,0>, 0.0124 }
                
                rotate z*44
                translate <-0.01,0.4425,0>
        }
        
        texture { pigment { Black } }
        rotate z*11
}    

#declare Orange_Fruit = union
{
        #declare OCnt = 0;
        #while (OCnt < 8)
            prism 
            {
                linear_spline
                linear_sweep    
                -0.031, 0.001, 5
                <0,0.01>, <-0.02,0.065>, <0,0.07>, <0.02,0.065>, <0,0.01>
                texture
                {
                        Orange_T
                } 
                
                rotate x*-90  
                rotate z*(45*OCnt)
            }
            #declare OCnt = OCnt +1;
        #end                          
        rotate z*22.5
}

#declare Orange_Disc = union
{
        difference 
        {
                cylinder 
                { 
                        <0,0,0>, <0,0,0.03>, 0.08 
                        texture 
                        { 
                                pigment { White }
                                finish 
                                { 
                                        reflection 0.0 
                                        diffuse 0.6 
                                        specular 0.2 
                                        roughness 0.4 
                                }
                        } 
                } 
                object { Orange_Fruit }
        }
        difference
        {
                cylinder { <0,0,0>, <0,0,0.03>, 0.081 }
                cylinder { <0,0,-0.01>, <0,0,0.04>, 0.08 }
                texture 
                { 
                        pigment { color ((Yellow+Red)/2) }
                        finish 
                        { 
                                reflection 0.0 
                                diffuse 0.5 
                                specular 0.5 
                                roughness 0.04 
                                phong 0.4
                                phong_size 0.01
                        }
                        normal
                        {
                                bumps 0.5
                                scale 0.0035
                        }
                } 
        } 
        object { Orange_Fruit }
        
//        rotate x*-45
        translate <0.0975,0.425,0>
}

#declare Cocktail = union
{
        object { Glas }
        object { TequilaSunrise } 
        object { Straw scale 0.075 texture { Straw_T } translate y*0.055 rotate z*11 }

        object { Orange_Disc }
        
        rotate y*90
        scale 1.5
}

#declare twirl_name = "Shell"
#declare twirl_object =  union
{
        sphere { <0, 0.0,0>, 0.2 }             
        texture { Shell_T translate z*-0.01 }
}        
#declare twirl_turns_z = 3;
#declare twirl_offset_x = 0.015;
#declare twirl_angle_offset_z = 20;
#declare twirl_scale_inc_x = 0.01;
#declare twirl_scale_inc_y = 0.05;
#declare twirl_scale_inc_z = 0.01;
#declare Shell = object { #include "twirl.inc" }

#declare twirl_object =  union
{
        sphere { <0, 0.0,0>, 0.2 }             
        texture { Shell2_T translate z*-0.01 }
}        
#declare twirl_turns_z = 2.5;
#declare twirl_offset_x = 0.015;
#declare twirl_angle_offset_z = 20;
#declare twirl_scale_inc_x = 0.01;
#declare twirl_scale_inc_y = 0.05;
#declare twirl_scale_inc_z = 0.01;
#declare Shell2 = object { #include "twirl.inc" }
                                                   
#declare Sunshade = union
{
        object { Sunshade_pole texture { My_Wood_T } }
        object { Sunshade_shade texture { Sunshade_shade_T } } 
}
    
    
#declare Maennchen = union
{
        object { Maennchen_main texture { Maennchen_T } }
        object { Sunglasses_glass texture { Sunglasses_glass_T } }
        object { Sunglasses_frame texture { Sunglasses_frame_T } }
        
        scale 0.9                     
}                  
        
#declare Stones = union
{        
        sphere { <0,0,0>, 0.075 texture { Stone_T } scale <1.2,0.65,1> rotate y*68 translate <-0.5,-0.2,1> }
        sphere { <0,0,0>, 0.075 texture { Stone_T } scale <1.2,0.65,1> rotate y*37 translate <-1,0.21,4> }
        sphere { <0,0,0>, 0.075 texture { Stone_T } scale <1.2,0.65,1> rotate y*42 translate <2.5,0.38,8> }
        sphere { <0,0,0>, 0.075 texture { Stone_T } scale <1.2,0.65,1> rotate y*50 translate <3,0.34,7> }
        sphere { <0,0,0>, 0.075 texture { Stone_T } scale <1,0.6,0.9> rotate y*11 translate <-0.5,0.55,9> }

        sphere { <0,0,0>, 0.075 texture { Stone_T } scale <1.2,0.65,1> rotate y*68 translate <2.75,-0.1,0.5> }
        sphere { <0,0,0>, 0.075 texture { Stone_T } scale <1.3,0.5,0.8> rotate y*23 translate <5.2,0.115,3> }
        sphere { <0,0,0>, 0.075 texture { Stone_T } scale <1.2,0.5,0.9> rotate y*68 translate <9,0.25,1> }
        sphere { <0,0,0>, 0.075 texture { Stone_T } scale <1.3,0.4,1.2> rotate y*68 translate <7,-0.025,-1> }
}

#declare Beachobjects = union
{
        object { Starfish texture { Starfish_T } scale 0.4 rotate <-10,3,4> translate <-1.6,-0.005,2.4> }
        object { Starfish texture { Starfish_T } scale 0.45 rotate <-7,3,-7> translate <7,0.1,2> }
        object { Shell rotate <-55,30,180> scale 0.2 translate <-1.4,0.35,5.7> }        
        object { Shell2 rotate <55,200,180> scale 0.2 translate <1.6,-0.255,-0.6> }        
        object { Shell2 rotate <55,110,180> scale 0.2 translate <0.6,0.45,7> }        
}                                                                                
      
#declare Sandcastle_flag = union
{
    object
    {
        union
        {
            #declare flag_xsize = 5;
            #declare flag_xsteps = 20;
            #declare flag_xwave = 1.5;
            #declare flag_xanim = 2/3;
            #declare flag_ysize = 4;
            #declare flag_ysteps = 20;
            #declare flag_ywave = 1;
            #declare flag_yanim = 1/2;
            #declare flag_amp = 0.5;
            #declare flag_angle = 40;
            #declare flag_clock = 0;
            object { #include "flag.inc"}
        }
      texture
      {
                Liegestuhl_Decke_T 
                scale 2.5
                rotate x*90
                translate y*-1.65
      }
      //rotate -y*45
      translate y*8
   }
   cylinder { <0,0,0>, <0,12.5,0>, 0.25 texture { My_Wood_T } }

   scale 0.05     
   translate <0,0.8,0>
}

      
#declare Sandcastle_wall = difference
{
        box { <-1,0,-0.75>, <1,0.5,-1.25> }
        plane { z, 0 rotate x*17 translate z*-1.25 }
        plane { z, 0 rotate x*163 translate z*-0.75 }
        box { <-0.1,0.3,-2>, <0.1,0.6,2> translate x*-0.4 }
        box { <-0.1,0.3,-2>, <0.1,0.6,2> }
        box { <-0.1,0.3,-2>, <0.1,0.6,2> translate x*0.4 }
}                

      
#declare Sandcastle_sand = union
{
        box { <-1,0,-1>, <1,0.1,1> }
        cone { <-1,0,-1>, 0.45 <-1,0.75,-1>, 0.3 }
        cone { < 1,0,-1>, 0.45 < 1,0.75,-1>, 0.3 }
        cone { <-1,0, 1>, 0.45 <-1,0.75, 1>, 0.3 }
        cone { < 1,0, 1>, 0.45 < 1,0.75, 1>, 0.3 }  

        cone { < 0,0.1, 0>, 0.45 < 0,0.85, 0>, 0.3 }  
        
        object { Sandcastle_wall translate z*2 }
        object { Sandcastle_wall }
        object { Sandcastle_wall rotate y*90 }
        object { Sandcastle_wall rotate y*-90 }
        
        texture { SandC_T } 
        
}

#declare Sandcastle = union
{
        object { Sandcastle_sand }
        object { Sandcastle_flag }

        rotate y*20
        translate <5,0.2,9>
}    

#declare Bucket = union
{
        object { Bucket_body texture { pigment { Red } finish { Shiny } } }
        object { Bucket_handle texture { pigment { White } finish { Shiny } } }
} 



#declare Crab = union
{
        object { Crab_body texture { Crab_body_T } }
        object { Crab_legs texture { Crab_legs_T } }
        object { Crab_feelers texture { Starfish_T } }
        object { Crab_eyes texture { pigment { Black } finish { Shiny } } }
        object { Crab_scissors texture { Crab_scissors_T } }
}                                                 

#declare Seagull1 = union
{
        object { Seagull_body texture { Seagull_T } }
        object { Seagull_eyes texture { pigment { Black } finish { Shiny } } }
}                                       

#declare Seagull2 = union
{
        object { Seagull2_body texture { Seagull_T } }
        object { Seagull2_eyes texture { pigment { Black } finish { Shiny } } }
}                                       

#declare Seagull3 = union
{
        object { Seagull3_body texture { Seagull_T } }
        object { Seagull3_eyes texture { pigment { Black } finish { Shiny } } }
}                                       

#declare Seagull4 = union
{
        object { Seagull4_body texture { Seagull_T } }
        object { Seagull4_eyes texture { pigment { Black } finish { Shiny } } }
}                                       

#declare Seagulls = union
{
        object { Seagull1 scale 0.5 rotate y*9 translate <11.0,10,43.0> }
        object { Seagull2 scale 0.5 rotate y*8 translate <12.0,12,40.5> }
        object { Seagull3 scale 0.5 rotate y*5 translate <13.0,11,39.5> }
        object { Seagull4 scale 0.5 rotate y*10 translate <14.5,9.5,38.5> }
} 

   

#declare Dolphin = union
{
        object { Dolphin_body texture { Dolphin_T } }
        object { Dolphin_eyes texture { pigment { Black } finish { Shiny } } }
}

#declare Dolphin2 = union
{
        object { Dolphin2_body texture { Dolphin_T } }
        object { Dolphin2_eyes texture { pigment { Black } finish { Shiny } } }
}
                         
#declare Dolphins = union
{
        union
        {
                object { Dolphin2 rotate z*40 }
                object { Splash scale <3,1,3> texture { Foam_T scale 0.5 } translate <-0.35,-0.75,0.35> }
 
                rotate y*45
                translate <20,0.25,55>
        }               

        union
        {
                object { Dolphin rotate z*10 }
                object { Splash scale <5,1,2> texture { Foam_T scale 0.5 } translate <0.75,0,0> }

                rotate y*55 
                translate <15,-0.75,51>    
        }

        union
        {
                object { Dolphin rotate z*-20 }
                object { Splash scale <5,1,2> texture { Foam_T scale 0.5 } translate <-0.75,0,0> }

                rotate y*50  
                translate <18,-0.5,45>     
        }

        translate <0,0,-8>
}                         