#render "Twirl INC v0.95 - Copyright 2000 Binary Designs\n\n"

#ifndef (twirl_name) #declare twirl_name = "default" #end
#ifndef (twirl_object) #declare twirl_object = sphere { <0,0,0>,1 } #end
#ifndef (twirl_turns_z) #declare twirl_turns_z = 3; #end
#ifndef (twirl_angle_offset_x) #declare twirl_angle_offset_x = 0; #end
#ifndef (twirl_angle_offset_y) #declare twirl_angle_offset_y = 0; #end
#ifndef (twirl_angle_offset_z) #declare twirl_angle_offset_z = 0; #end
#ifndef (twirl_offset_x) #declare twirl_offset_x = 0; #end
#ifndef (twirl_offset_y) #declare twirl_offset_y = 0; #end
#ifndef (twirl_offset_z) #declare twirl_offset_z = 0; #end
#ifndef (twirl_scale_inc_x) #declare twirl_scale_inc_x = 0; #end
#ifndef (twirl_scale_inc_y) #declare twirl_scale_inc_y = 0; #end
#ifndef (twirl_scale_inc_z) #declare twirl_scale_inc_z = 0; #end

#render concat("object: ",twirl_name,"\n")
#render concat("turns: ",str(twirl_turns_z,0,2),"\n")
#render concat("angle_offset: <",str(twirl_angle_offset_x,0,2),",",str(twirl_angle_offset_y,0,2),",",str(twirl_angle_offset_z,0,2),">\n")
#render concat("offset: <",str(twirl_offset_x,0,2),",",str(twirl_offset_y,0,2),",",str(twirl_offset_z,0,2),">\n")
#render concat("scale_inc: <",str(twirl_scale_inc_x,0,2),",",str(twirl_scale_inc_y,0,2),",",str(twirl_scale_inc_z,0,2),">\n")

#render "\n"

union
{
#local act_turns_z = 0;
#local act_angle_x = 0;
#local act_angle_y = 0;
#local act_angle_z = 0;
#local act_offset_x = 0;
#local act_offset_y = 0;
#local act_offset_z = 0;
#local act_scale_inc_x = 1;
#local act_scale_inc_y = 1;
#local act_scale_inc_z = 1;
#local objects = 0;

#while (act_turns_z <= twirl_turns_z)
        object 
        { 
                twirl_object 
                scale <act_scale_inc_x,act_scale_inc_y,act_scale_inc_z> 
                translate <act_offset_x,act_offset_y,act_offset_z> 
                rotate <act_angle_x,act_angle_y,act_angle_z> 
        }
        #local objects = objects + 1;
        #local act_angle_x = act_angle_x + twirl_angle_offset_x;
        #local act_angle_y = act_angle_y + twirl_angle_offset_y;
        #local act_angle_z = act_angle_z + twirl_angle_offset_z;
        #if (act_angle_z > 360)
                #local act_angle_z = act_angle_z - 360;
                #local act_turns_z = act_turns_z + 1;
        #end
        #local act_offset_x = act_offset_x + twirl_offset_x;
        #local act_offset_y = act_offset_y + twirl_offset_y;
        #local act_offset_z = act_offset_z + twirl_offset_z;
        #local act_scale_inc_x = act_scale_inc_x + twirl_scale_inc_x;
        #local act_scale_inc_y = act_scale_inc_y + twirl_scale_inc_y;
        #local act_scale_inc_z = act_scale_inc_z + twirl_scale_inc_z;
        #local act_turns_z = int(act_turns_z) + (act_angle_z/360); 
        #debug concat ("act_turns_z = ",str (act_turns_z,0,5),"\n" )
#end
} 

#render concat ("number of objects = ",str(objects,0,0), "\n\n")