/*
SPLASH!
blobbed particle system
by Tek
*/


#declare splash_seed = seed(17)

#declare splash_gravity = -9.81; //N.B. this is totally arbitrary, as time has no meaning in a still picture :o)

#macro splash( splash_pos, splash_rad )
	blob {
	
		/* progress round the perimeter of the splash, varying the strength and creating droplets */
		#local base_power = 1.9;//2.2;
		#local base_drops = 20;//60;//35;
		#local launch_ang = pi/16;
		
		#local ang = 0;
		#local ang_step = 1.5;
		
		#while ( ang < 360 )
		
			//modify power, and compute firing angle and number of drops accordingly
			#local power_mod	= 0.08*sin(5*ang+pi/2)+0.04*sin(7*ang)+1.0;
			#local power			= base_power*power_mod;
			
			#local launch_dir	= <cos(ang)*sin(launch_ang*(2-power_mod)),cos(launch_ang*(2-power_mod)),sin(ang)*sin(launch_ang*(2-power_mod))>;
			#local launch_pos	= splash_rad*<cos(ang),0,sin(ang)> + splash_pos;

			#local launch_dir	= launch_dir * power_mod;
			#local ndrop			= int(base_drops * power_mod);
			
			#while (ndrop > 0)
				droplet( launch_pos, launch_dir, power )
							
				#local ndrop = ndrop - 1;
			#end
		
			#local ang = ang+ang_step;
		#end 
		
	}
#end



/*
Droplet:
	Given a start position, firing direction, and power, create a droplet
	randomize the firing angle and power a little, and the point in time at which the drop exists.
*/

#macro droplet( drop_start_pos, drop_vector, drop_power )
	//randomize values
	#local drop_power = drop_power*rand_power();
	#local drop_vector = drop_vector + (rand_vector()*drop_power);
	
	#local vel0 = drop_vector*drop_power;

	//compute time of landing
	#local time1 = 0.4;//nope, better distribution if we don't: -2*vel0.y/splash_gravity; //from s=ut+(1/2)a(t^2)
	
	//choose random time
	#local time = time1*rand_time();

	//find new position using s=ut+(1/2)a(t^2)
	#local pos = drop_start_pos + time*<vel0.x,0,vel0.z>;
	
	#local pos = <pos.x, pos.y + vel0.y*time + time*time*splash_gravity/2, pos.z>;
	  
	  
	#if (pos.y >= drop_start_pos.y)
		sphere { pos, 0.013, 1.0 } //0.02
	#end
#end


#macro rand_power()
//	(rand(splash_seed)*0.03+0.985)
	1 //SO RANDOM!
#end

#macro rand_vector()
	(<rand(splash_seed)-0.5,rand(splash_seed)-0.5,rand(splash_seed)-0.5>*0.02)
#end

#macro rand_time()
	(rand(splash_seed)*sqrt(rand(splash_seed))) //concentrate more towards lower numbers, looks better.
#end




