// POV file adapted from topo example by Russell Towle

#include "colors.inc"
#include "textures.inc"

camera {
   location <0, 1, -20>
   //direction <0,0,2.18>
   //up <0,1,0>
   //right <1.33,0,0>
   look_at <0,0,0>
}

#default {
  pigment {rgb <1,1,1>}
 }


light_source { <300, 300, -400> color rgb 1}//red 0.75 green 0.5 blue 0.3 }
//light_source { <-300, 210, 5>   color red 0.25 green 0.1 blue 0.0 }
// light_source { <0, 1500, 0>     color red 0.15 green 0.25 blue 0.1 }


// The heightfield object is in the X-Z plane, centered on the origin, 
// and extends +/- 0.5 units in the X and Z directions

/*
object{
         height_field {gif "test.gif" }
         water_level  0.51 
         //smooth
         texture {
         pigment { image_map { gif "test.gif" } }
         rotate <90,0,0>
       
       }
         
         scale < 1, 0.256, 1 >      // reduce height
         translate <-.5, -0.135, -.5>
         scale 2
         
       }
*/

#declare Roche = texture {
   pigment {
     granite
     color_map {
       [ 0.000  color rgb<0.400, 0.400, 0.400> ]
       [ 0.500  color rgb<0.500, 0.500, 0.500> ]
       [ 0.750  color rgb<0.550, 0.550, 0.550> ]
       [ 0.875  color rgb<0.575, 0.575, 0.575> ]
       [ 1.000  color rgb<0.600, 0.600, 0.600> ]
     }
     turbulence 0.950  scale .1
   }
   finish {
     diffuse 0.500
     ambient 0.200
    // specular 0.400
     //roughness 0.0100
   }

}



height_field { tga "montagne.tga"//gif "test.gif"
  water_level 0.51 smooth 
       //pigment { rgb <0,0,1> }
        
        texture { 
        Roche
         //pigment { image_map { gif "test1.gif" } }
         //rotate <90,0,0>
       
       }
       
       translate -.52*y
       scale <1,.256,1>
       scale 30000
       translate <-15000,0,-7000>
    }



/*
plane{
  y,  0 
  texture {
    pigment { rgbf <0.0,0.2,0.2,0.5> }
    finish { phong 1.0 reflection 0.5 phong_size 100 }
    normal { bumps 0.13 scale <2,4,6> }
    rotate <0,30,0>
    scale .1
  }
}
*/





     

  sphere { <0,-100000,0>,100000 
  
  
  texture {
    pigment { rgbf <0.0,0.2,0.2,0.5> }
    finish { phong 1.0 reflection 0.5 phong_size 100 }
    normal { bumps 0.13 scale <2,4,6> }
    rotate <0,30,0>
    scale .1
  }}
   


#include "skies.inc"
sky_sphere { S_Cloud1 }


#include "nautilusb.pov"
object {nautilus  rotate 47*y translate <-5,-.2,7> }