// ==== Standard POV-Ray Includes ====
#version unofficial MegaPov 0.5;

#include "seatex.inc"	// Main texture Include File

#declare Wave = difference {
	sphere { 0, 1 }
	sphere { z*.4, 1 }
	plane { y, 0 }
	scale <1.5, 0.4, 0.4>
}

#declare Waterline = plane { 
	y, 0 
	Water(0)
	hollow
}

#declare SeaFloor = plane {
	<-1, 100, 1>, 0
	translate y*-50
	texture { BottomCol }
}

#macro AltPos(xx,zz)
	< xx, ( xx - zz ) *.01 - 50, zz >
#end

#declare WaveLine = union {
	object { Wave translate x*-24 }
	object { Wave translate x*-18 }
	object { Wave translate x*-12 }
	object { Wave translate x*- 6 }
	object { Wave translate x*  0 }
	object { Wave translate x*  6 }
	object { Wave translate x* 12 }
	object { Wave translate x* 18 }
	object { Wave translate x* 24 }
}

// Coral
#declare BranchCoral = object { #include "coral.inc" }

// Tree
#declare Leaf = object { #include "palmleaf.inc" }

#declare Tree = union {
	object { #include "palm.inc" }
	object { #include "palmfol.inc" texture { txtLeaf_3 } }
}

// Bird

#declare InnerWing = object { #include "inwing.inc" }
#declare OuterWing = object { #include "outwing.inc" }

#declare BirdWing = union {
	object { InnerWing }
	object { OuterWing scale<-1,1,1> translate x*-6.0 }
	translate <-1.70, -1.20, 0.20 >
	scale .6
}

#macro BirdRear(Len,Rot) 
	blob {
		threshold 0.34
		cylinder { < 0, 0, -Len >, < 0, 0, 0 >, .3, 1 }
		cylinder { <-0.12, 0.00, -Len+0.25 >, <-0.60, -0.08, -Len-0.10>, 0.07, 1 }
		cylinder { <-0.08, 0.00, -Len+0.24 >, <-0.40, -0.06, -Len-0.25>, 0.07, 1 }
		cylinder { <-0.04, 0.00, -Len+0.23 >, <-0.20, -0.05, -Len-0.35>, 0.07, 1 }
		cylinder { <-0.00, 0.00, -Len+0.22 >, < 0.00, -0.04, -Len-0.40>, 0.07, 1 }
		cylinder { < 0.04, 0.00, -Len+0.23 >, < 0.20, -0.05, -Len-0.35>, 0.07, 1 }
		cylinder { < 0.08, 0.00, -Len+0.24 >, < 0.40, -0.06, -Len-0.25>, 0.07, 1 }
		cylinder { < 0.12, 0.00, -Len+0.25 >, < 0.60, -0.08, -Len-0.10>, 0.07, 1 }
		scale <2, .5, 1>
		rotate x*Rot
	}
#end

#declare EyePos = < 0.15, 0.15, 2.10 >;

#declare BirdIris = sphere { 0, .06 scale <1, .7, 1> }

#declare BirdFront = union {
	sphere {
		0, .15
		scale <3, 1, 8>
		translate z*1.0
	}
	difference {
		sphere { 0, .24 scale <1, .6, 1> translate <0, 0.07, 2.1> }
		object { BirdIris translate EyePos }
		object { BirdIris translate EyePos  scale <-1, 1, 1> }
	}
}

#declare BirdBody = union {
	object { BirdRear(2,-15) }
	object { BirdFront }
	object { BirdWing }
	object { BirdWing scale <-1,1,1> }
	texture { Feathers }
}

#declare BirdEye = union {
	object { BirdIris texture { BirdEyeCol } interior { ior 1.4 } }
	sphere { 0, .02 pigment { Black } }
}	

#declare BeakUpper = difference {
	sphere { 0, 1 }
	sphere { 
		0, .99
		scale <1, 1, 1.3>
		translate <0, -.02, -.4>
	}
	plane { z, -.1 }
	scale <.2, .10, .5>
}

#declare BeakLower = difference {
	sphere { 0, 1 }
	sphere { 
		0, .99
		scale <1, 1, 1.5>
		translate <0,  .01, -.6>
	}
	plane { z, -.1 }
	scale <.2, .10, .4>
	texture { BeakCol }
}

#macro Beak(Angle)
	union {
		object { BeakUpper rotate x*-Angle }
		object { BeakLower rotate x*Angle }
		texture { BeakCol }
		translate < 0.00, 0.07, 2.23 >
	}
#end

#declare Bird = union {
	object { BirdBody }
	Beak(10)
	object { BirdEye translate EyePos }
	object { BirdEye translate EyePos scale <-1, 1, 1> }
	scale .6
}

// Fish

#declare Fin = difference {
	intersection {
		sphere { 0, 1 }
		plane { x, 0 rotate z*5 }
		plane { -x, 0 rotate -z*5 }
		plane { -z, 0 }
	}
	sphere { 0, 1 scale <2, 0.3, 1> }
	rotate x*-90
}

#declare EyeBall = union {
	sphere { 0, .20 texture { EyeballCol } interior { ior 1.3 } }
	sphere { 0, .07 pigment { Black } }
	scale <1, 1, .4>
}	

#declare MouthCut = cone { 
	z*3.5, .4, z*2, 0
	pigment { rgb <.8, .6, .1> }
}

#declare GillCut = intersection {
	cone { 0, 0.5, z*-.5, 0 }
	cone { z*0.1, 0.6, z*-.5, 0 scale <1.00, 0.80, 1> inverse }
	plane { y, 0 }
	rotate z*90
	rotate y*40
	pigment { Black }
}

#declare FishBody = merge {
	sphere { 0, 1 scale <.6, 1, 3> }
	object { Fin scale <1.0, 1.3, 3.0> rotate x*20 translate <0, 0.7,-0.7> }
	object { Fin scale <1.0, 1.3, 3.0> rotate x*20 translate <0, 0.7,-0.7> rotate z*180 }
	object { Fin scale <0.5, 1.0, 3.0> rotate x*10 translate <0,-0.1,-4.5> }
	object { Fin scale <0.5, 1.0, 3.0> rotate x*10 translate <0,-0.1,-4.5> rotate z*180 }
	object { Fin scale <1.5, 1.0, 2.0> translate <0, 0.4,-0.7> rotate z* 90 }
	object { Fin scale <1.5, 1.0, 2.0> translate <0, 0.4,-0.7> rotate z*270 }
	texture { FishCol }
}


#declare Fish = union {
	difference { 
		object { FishBody }
		object { MouthCut }
		object { GillCut translate <-0.7, 0.2, 2.2> }
		object { GillCut translate <-0.7, 0.2, 2.2> rotate z*180 }
		object { GillCut translate <-0.7, 0.2, 2.3> }
		object { GillCut translate <-0.7, 0.2, 2.3> rotate z*180 }
		object { GillCut translate <-0.7, 0.2, 2.4> }
		object { GillCut translate <-0.7, 0.2, 2.4> rotate z*180 }
		object { GillCut translate <-0.7, 0.2, 2.5> }
		object { GillCut translate <-0.7, 0.2, 2.5> rotate z*180 }
	}
	object { EyeBall rotate <-40, 80, 0> translate <.20, .4, 2.5> }
	object { EyeBall rotate <-40,-80, 0> translate <-.20, .4, 2.5> }
	scale 0.4
}

#declare School = union {
	object { Fish }
	object { Fish translate <-1.0, -.2, -1.7> }
	object { Fish translate < 1.0, -.2, -1.7> }
	object { Fish translate <-2.0, -.4, -3.4> }
	object { Fish translate < 0.0, -.4, -3.4> }
	object { Fish translate < 2.0, -.4, -3.4> }
}

// Turtle

#declare UpperMain = union {
	intersection {
		sphere { 0, 1 }
		sphere { 0, .95 inverse }
		plane { -y, -.5 }
	}
	torus { .85, .03 scale <1, 2, 1> translate y*.5 }
}

#declare UpperShell = union {
	intersection {
		object { UpperMain }
		plane { z, .7 }
	}
	intersection {
		object { UpperMain }
		torus { .68, .04 rotate x*90 translate z*.7 }
	}
	scale <1.0, 0.9, 1.5>
	translate y*-.4
	texture { UpperCol }
}

#macro LowerRib(Start, End)
	merge {
		intersection {
			sphere { 0, 1 }
			sphere { 0, .96 inverse }
			plane { y, 0 rotate x*End }
			plane { -y, 0 rotate x*Start }
		}
		union {
			torus { 0.98, 0.02 clipped_by { plane { z, 0 } } rotate x*Start }
			torus { 0.98, 0.02 clipped_by { plane { z, 0 } } rotate x*End }
		}
	}
#end

#macro RibPair(Start,End)
	union {
		intersection {
			object { LowerRib(Start, End) rotate y*10 }
			plane { x, 0 }
		}
		intersection {
			object { LowerRib(Start, End) rotate y*-10 }
			plane { -x, 0 }
		}
	}
#end

#declare LowerShell = union {
	RibPair(0, 34)
	RibPair(40, 66)
	RibPair(70, 88)
	RibPair(92, 110)
	RibPair(114, 140)
	intersection {
		RibPair(146, 180)
		plane { <0, -1, 2>, 0 translate z*0.8 }
	}
	scale < 0.8,-0.4, 1.3>
	texture { RibCol }
}

#declare TurtleInner = blob {
	threshold .1
	sphere { 0, 0.6 , 1 scale <1.2, 0.8, 1.5> } // Body center
	sphere { <0, .05, .6>, 0.4 , 1 scale <1.2, .6, 1.5> } // Head
	sphere { < 0.17, 0.14, 1.3>, .05, -1 } // Eye
	sphere { <-0.17, 0.14, 1.3>, .05, -1 } // Eye
	cylinder { <-.2, .02, 0.64>, <0.2, .02, 0.64>, .06, -1 scale <1, 1, 2> } // Mouth
	// Left foreleg
	cylinder { <-.50, 0.1, 0.5>, <-.70, -.25, 0.6>, 0.12, 1 }
	cylinder { <-.80, -.6, 0.65>, <-.70, -.25, 0.6>, 0.12, 1 }
	sphere { <-.70, -.25, 0.6>, 0.12, -1 }
	// Right foreleg
	cylinder { <0.50, 0.1, 0.5>, <0.65, -.25, 0.65>, 0.12, 1 }
	cylinder { <0.70, -.6, 0.6>, <0.65, -.25, 0.65>, 0.12, 1 }
	sphere { <0.65, -.25, 0.65>, 0.12, -1 }
	// Left hindleg
	cylinder { <-.50, 0.1,-0.5>, <-.65, -.30,-0.6>, 0.12, 1 }
	cylinder { <-.75, -.6,-0.7>, <-.65, -.30,-0.6>, 0.12, 1 }
	sphere { <-.65, -.30,-0.6>, 0.12, -1 }
	// Right hindleg
	cylinder { <0.50, 0.1,-0.5>, <0.75, -.20,-0.55>, 0.12, 1 }
	cylinder { <0.80, -.6,-0.6>, <0.75, -.20,-0.55>, 0.12, 1 }
	sphere { <0.75, -.20,-0.55>, 0.12, -1 }
	// Color
	texture { InnerCol }
}

#declare TurtleEye = union {
	sphere { 0, .02 texture { TurtleEyeCol } }
	sphere { 0, .015 pigment { rgb <0, .2, .1> } }
}

#declare Turtle = union {
	object { UpperShell }
	object { TurtleInner }
	object { TurtleEye translate < 0.17, 0.11, 1.3> }
	object { TurtleEye translate <-0.17, 0.11, 1.3> }
	object { LowerShell }
}