#version unofficial MegaPov 0.5;

#include "seacoast.inc"
#include "lights.inc"

LightStar( <0, 50000, 0>, 30 )

camera {
  location  < 0.0 , 2.0 , 4.5>
  look_at   < 0.0 , 0.0 , 0.0>
}

sky_sphere {
	pigment { image_map { png "sky3.png" } scale .7 }
}

object { SeaFloor }
object { Waterline }

#declare tSeed = seed(4928);

object { Tree rotate y*360*rand(tSeed) translate AltPos(1456, -7393) }
object { Tree rotate y*360*rand(tSeed) translate AltPos(-923, -8293) }
object { Tree rotate y*360*rand(tSeed) translate AltPos( -67, -7751) }
object { Tree rotate y*360*rand(tSeed) translate AltPos( 825, -6393) }
object { Tree rotate y*360*rand(tSeed) translate AltPos(2163, -5605) }
object { Tree rotate y*360*rand(tSeed) translate AltPos(1792, -6223) }
object { Tree rotate y*360*rand(tSeed) translate AltPos(2545, -5282) }

object { Bird rotate <-20,  35,  8> translate < -1.00, 1.50, -20> }
object { Bird rotate < 15, 125, -2> translate <  5.00, 3.50, -8> }
object { Bird rotate <  0, -75, 18> translate <-12.00, 1.75, -35> }
object { Bird rotate <  0, -75, 18> translate <-16.00, 2.00, -40> }
object { Bird rotate <  0, -75, 18> translate <-16.00, 1.50, -30> }

#declare cSeed = seed(9385);

object { 
	BranchCoral
	rotate y*360*rand(cSeed)
	scale 3
	translate AltPos(-3, -149)
}
object { 
	BranchCoral
	rotate y*360*rand(cSeed)
	scale 3
	translate AltPos(20, -115)
}
object { 
	BranchCoral
	rotate y*360*rand(cSeed)
	scale 3
	translate AltPos(-15, -106)
}

object { School rotate <-10, 50, 0> translate < 4.0,-0.5,-5.0> }
object { Fish rotate < 30, 0, 0> translate < 1.5, -0.4, 1.0> }
object { Turtle rotate <0, -30, 0> translate <-2, 0, -1> }
