// -----  Hugh S. Steele
#version unofficial MegaPov 0.5;

// -----

  #include "AirBubbles.inc"
  #include "Scuba_Mask.inc"
  #include "Scuba_Fins.inc"
  #include "Scuba_Tank.inc"
  #include "SkullCup.inc"


// -----

  #declare Dark_Green_Water = material
  {
    texture
    {
      pigment{ color rgbft <1,1,1, 0.3> }
      normal{ waves 24  scale <1,1,2> }
      normal{ bumps 24  scale 12 }
      finish
      {
        ambient 0.1
        diffuse 0.1
        reflection .00125
        roughness 0.001
      }
      translate <-100,0,-100>
    }
    interior
    {
      ior 1.33
      media
      {
        method 2
        absorption <.001, .00025, .0005>
        samples 1, 1
      }
    }
  }


  #declare RanTex2 = texture
  {
	  pigment
	  {
		  granite
		  color_map
		  {
			  [0.00 rgbt <0.643, 0.963, 0.999, 0.8>]
			  [0.25 rgbf <0.381, 0.220, 0.139, 0.6>]
			  [0.50 rgbt <0.795, 1.000, 0.600, 0.9>]
			  [0.75 rgbf <0.492, 0.750, 0.353, 0.7>]
			  [1.00 rgbt <0.397, 0.212, 0.791, 0.5>]
		  }
	    turbulence 0.889
  	  scale 180
	  }
    normal
    {
      waves 10
      warp
      {
        turbulence <0.500164, 0.500364, 0.499804>
        omega 0.500404
        lambda 1.999712
      }
  	  scale <10,5,10>
    }      
	  finish
	  {
		  phong 0.987
	  }
  }


  #declare RoughStone = texture
  {      
    pigment
    {
      granite
      color_map
      {
        [ 0.0     rgbft <0.499564, 0.499564, 0.499564, 0.0, 0.0> ]
        [ 0.25    rgbft <0.649707, 0.649707, 0.649707, 0.0, 0.0> ]
        [ 0.5     rgbft <0.499858, 0.499858, 0.499858, 0.0, 0.0> ]
        [ 0.75    rgbft <0.699587, 0.699587, 0.699587, 0.0, 0.0> ]
        [ 1.0     rgbft <0.499644, 0.499644, 0.499644, 0.0, 0.0> ]
      }
      frequency 100.0
      ramp_wave
    }      
    normal
    {
      crackle 1.0
      warp
      {
        turbulence <0.500164, 0.500364, 0.499804>
        omega 0.500404
        lambda 1.999712
      }
    }      
    finish
    {
      ambient 0.1
      diffuse 0.549996
      specular 0.100002
      roughness 1.0
    }      
    //  This texture was originally designed by Charles Fusner.
  }

// ----- stage setting

  background{ color <0,0,0> }

  sky_sphere
  {
    pigment
    {
      gradient y
      color_map
      {
        [0.0 color rgb <0.2,0.3,0.4>]
        [0.1 color rgb <0.7,0.7,1.0>]
        [1.0 color rgb <0.2,0.3,0.7>]
      }
    }
  }

  // Sea Water
  cylinder
  {
    <0,-10,0>, <0,300,0> 10000 hollow
    material{ Dark_Green_Water }
  }

  fog
  {
    distance 250
    color rgbf <0.23, 0.45, 0.34, 0.3>
    fog_type 2
    fog_offset -10
    fog_alt 190
  }

  // Sea Bottom
  plane
  {
    y, -5
    hollow on
    material
    {
      texture{ pigment{ rgb <0.3,0.2,0.1> }}
      texture{ RoughStone  scale 5 }
      texture{ RoughStone  scale 10 }
      texture{ RanTex2  translate 200*z }
    }
  }



// ----- actors and props

  object{ SkullGoblet( 40, <18,25,28>, <0,-4,0> ) }


// -----  Spear and Speargun

  #declare Spear = cylinder
  {
    <0,0,0>, <35,0,0> .25
    texture{ pigment{ rgb <0.5,0.9,0.7> }}
  }

  #declare SpearGun = union
  {
    cylinder{ <-2,0,0>, <30,0,0> 1 }
    cylinder{ <-2,0,0>, <-5,-4,0> 1 }

    texture{ pigment{ rgb <0.125,0.125,0.125> }}
  }


// -----

//  #declare BM_Ears = 0;
//  #declare BM_Navel = 0;
//  #declare BM_Nipples = 0;
//  #declare BM_Nails = 0;

  #include "BMPeople.inc"


  #declare BM_Head_Object = union
  {
    object{ BM_Head_Object }
    object
    {
      Scuba_Mask( MaskBodyTex, MaskLensTex, MaskStrapTex )
      scale <2.5,2.5,2.5>
      rotate -12*x
    }
  }

  #declare BM_Foot_R_Object = union
  {
    object{ BM_Foot_R_Object }
    object
    {
      Scuba_Fins
      texture{ pigment{ rgb .5 }}
      scale <4.5,3,3.5>
      translate <0, -2, 1>
    }
  }

  #declare BM_Foot_L_Object = union
  {
    object{ BM_Foot_L_Object }
    object
    {
      Scuba_Fins
      texture{ pigment{ rgb .5 }}
      scale <4.5,3,3.5>
      translate <0, -2, 1>
    }
  }

  #declare BM_Torso_Object = union
  {
    object{ BM_Torso_Object }
    object
    {
      Scuba_Tank
      scale <5,5,5>
      rotate <0,90,90>
      translate <0, -12, 6.5>
    }
  }

  #declare BM_Head_Object = union
  {
    object{ BM_Head_Object }
    object{ AirBubbles( <0,0,0>, <0,0,0> )  translate <2,10,-5> }
  }

  #include "Diver_1.inc"
  #include "Diver_2.inc"

    #declare BM_Hand_R_Object = union
    {
      object{ BM_Hand_R_Object }
      object
      {
        SpearGun
        rotate <-90,20,-75>
        translate <2,-5,-3>
      }
    }

  #include "Diver_3.inc"

    #declare BM_Hand_R_Object = union
    {
      object{ BM_Hand_R_Object }
      object
      {
        Spear
        translate <0,2,0>
        rotate <-90,20,-75>
      }
    }

  #include "Diver_4.inc"
  #include "Diver_5.inc"

// ----- Camera and lights

  #declare Camera_Location = < -48.0, 3.0, 6.0 >;
  #declare Camera_Target = < 0.0, 13.0, -6.0 >;

  // camera
  camera
  {
    location  Camera_Location   // position camera at this location <X Y Z>
    direction z
    up y
    right     4/3*x
    look_at   Camera_Target     // point camera at this location <X Y Z>
  }

  // camera light
  light_source
  {
    Camera_Location
    color rgb .6
    shadowless
    fade_distance 20
    fade_power 0.5
  }


// -----

  // create a point "spotlight" (conical directed) light source
  light_source
  {
    0*x
    color rgb <0.7, 0.9, 0.8>
    spotlight
    translate <-300,200,0>
    point_at <0,0,0>
    radius 15
    tightness 25
    falloff 50
  }

  // create a point "spotlight" (conical directed) light source
  light_source
  {
    0*x
    color rgb <0.7, 0.9, 0.8>
    spotlight
    translate <-110,200,-62>
    point_at <113,76,-52>
    radius 15
    tightness 25
    falloff 40
  }

//  light_source{ 0  color rgb <0.5, 0.5, 0.5>  fade_distance 400.0  fade_power 0.5  translate <120, 2000, 300> }
//  light_source{ 0  color rgb <0.7, 0.7, 0.7>  fade_distance 400.0  fade_power 0.5  translate <-250, 1400, 100> }
//  light_source{ 0  color rgb <0.6, 0.6, 0.6>  fade_distance 400.0  fade_power 0.5  translate <400, 3000, 200> }

  light_source{ 0  color rgb <0.6, 0.6, 0.6>  translate <-400, 3000, 200> }
