// -----  Hugh S. Steele
#version unofficial MegaPov 0.5;

// SkullCup.inc

  #include "FullSkull.inc"
  #include "CupBase.inc"


  #declare Bone_Texture = texture
  {      
    pigment
    {
      color rgb <0.6, 0.7, 0.7>
    }      
    finish
    {
      ambient 0.4
      diffuse 0.5
      phong_size 0.0
      specular 0.007
    }
  }

  #declare Gold_Texture = texture
  {
    pigment{ color rgb <0.988, 0.584, 0.024> }
    normal
    {
        waves , 0.04
        turbulence 1.14
        frequency 4.3
        phase 0.37
        ramp_wave
    }
    finish
    {
        ambient 0.1
        diffuse 0.8
        reflection 0.19
    }
  }

  #declare Silver_Texture = texture
  {      
    pigment{ color rgb <0.9, 0.91, 0.98> }      
    finish
    {
      ambient 0.2
      diffuse 0.7
      brilliance 6.0
      phong 0.75
      phong_size 80.0
      reflection 0.25
    }
  }


// -----

#declare SkullLid = union
{
  // jaw inverted with a sphere clipped out of it.
  object
  {
    JawMesh
    translate <0,0,-18.5>
    rotate 7.5*x
    clipped_by{ cylinder{ <0,0,1.5>, <0,0,-2>, 2 inverse }}
  }

  // lid inserted into jaw
  union
  {
    difference
    {
      sphere{ <0,0,0>, 2.0 }
      sphere{ <0,0,0>, 1.9 }
      clipped_by{ cylinder{ <0,0,0>, <0,0,-2.1>, 2.55 }}
      scale <1,1,0.5>
      translate -0.5*z
    }

    difference
    {
      cylinder{ <0, 0, 0.0>, <0, 0, -0.5>, 2.0 }
      cylinder{ <0, 0, 0.1>, <0, 0, -0.6>, 1.9 }
    }

    torus{ 1.95, 0.05  rotate 90*x }
    texture{ Gold_Texture }

    translate -0.05*z
  }
}

#declare SkullCup = union
{
  // skull inverted with a cylinder clipped out of it.
  object
  {
    SkullMesh
    translate <0,0,-18.5>
    rotate 7.5*x
    clipped_by{ cylinder{ <0,0,5.5>, <0,0,-0.1>, 2 inverse }}
  }

  // cup inserted into skull
  union
  {
    difference
    {
      cylinder{ <0,0,0>, <0,0,5.5>, 2.0 }
      cylinder{ <0,0,-0.1>, <0,0,5.4>, 1.9 }
    }

    torus{ 1.95, 0.05  rotate 90*x }
    texture{ Gold_Texture }
    translate 0.05*z 
  }

  // base holding skull
  union
  {
    object
    {
      CupBase
      texture{ Gold_Texture }
    }

    object
    {
      CupStem
      texture
      {
      	pigment { rgb < 0.4784, 0.5373, 0.6706 > }
  	    finish { phong 0.9 }
      }
    }

    object
    {
      CupRings
	    texture
	    {
    	  pigment { rgb < 0.549, 0.6745, 0.4667 > }
	      finish { phong 0.9 }
      }
    }

    scale 2
    rotate -90*x
    translate 8.5*z
  }
}

  #macro SkullGoblet( pOpen, pRotate, pTranslate )
    union
    {
      object{ SkullCup }
      object
      {
        SkullLid
        translate 2.125*y
        rotate -pOpen*x
        translate -2.125*y
      }

      rotate pRotate
      translate pTranslate
    }
  #end


/*
light_source{ <-20, 40, -20>  color red 0.6  green 0.6  blue 0.6 }
light_source{ <20, 0, 0>  color red 0.6  green 0.6  blue 0.6 }

camera
{
  location  <20, 0, 0>
  direction z
  up        y
  right     4/3*x
  look_at   <0,0,0>
  orthographic
}

SkullGoblet( 45, 90*x, 0 )
*/
