// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//

#version 3.1


#include "colors.inc"
#include "finish.inc"
#include "textures.inc"
 
global_settings{
  assumed_gamma 2.2
  max_trace_level 50
} 

#declare clear= 
texture{
  pigment{rgbf 1}
}        




#declare rocks=
texture {
  pigment {
    bozo
    turbulence 0.60
    omega 0.80
    lambda 3.00
    color_map {
      [0.00 color rgb <0.51, 0.41-.05, 0.41-.05>]
      [1.00 color rgb <1.00, .9-.05, .9-.05>]
    }
  }

  normal {
    bumps 1.00
    turbulence 0.60
    octaves 5
    omega 0.65
    lambda 3.00
    scale <1,4,1>
  }

  finish {
    ambient 0.15
    specular 0.20
  }  
  scale 2
}



#declare birdDrop=
texture{rocks}
texture{
  pigment {
    spotted
    turbulence 0.56
    color_map {
        [0.0 rgbf<1,1,1,1>]    
        [0.60 rgbf<1,1,1,1>]    
        [0.65 rgb 1.5]
        [1.0 rgb 1.5]
    }
  }
    
    normal {
      bumps 1.00
      turbulence 0.60
      octaves 5
      omega 0.65
      lambda 3.00
      scale <1,4,1>*150
    }


    finish {
      ambient 0.15
      specular 0.20
    }  
    scale 2/150
}


#declare seatexture2 = 
texture {
  pigment {color rgb<0.10, 0.3, 0.4>*.90} 
    finish {ambient .3
            specular 0.5
            roughness 0.08
            reflection 0.4
    }    
      
    normal {wrinkles -4
            turbulence .5 
            scale <20,25,15> * 2
    }
}





#declare ladder=
union{
  object{
    torus{3,0.25 }
    clipped_by{plane{z,0}}
    rotate<90,0,0> 
    translate<0,0,1.5>
  }  

  object{
    torus{3,0.25 }
    clipped_by{plane{z,0}}
    rotate<90,0,0> 
    translate<0,0,-1.5>
  }  

  cylinder{<-3,0,-1.5>,<-3,-25,-1.5>,0.25}
  cylinder{<-3,0,1.5>,<-3,-25,1.5>,0.25}
    
  #declare yy=0;
  #while (yy > -25)  
    cylinder{<-3,yy,1.5>,<-3,yy,-1.5>,0.25}  
    #declare yy=yy-1.5;
  
  #end
  texture{Rusty_Iron}
}         

#declare lightHouse=
union{
  light_source{
    <0,114,0>
    color (White + Yellow)/4
    looks_like { sphere { 0*x, 1 pigment { Yellow*10 } } }
    fade_power  2 
    fade_distance 30 
  }


   difference{
     cone{<0,-50,0>,18, <0,100,0,>,12}
     cone{<0,-50.1,0>,17, <0,100.1,0,>,11 pigment{ White}}
     box{<-1.75,-25,-19>,<1.75,-25+7,15>}
     box{<-1.5,0,-19>,<1.5,4,15>}
     box{<-1.5,45,-19>,<1.5,4+45,15> rotate<0,30,0>}
     box{<-1.5,75,-19>,<1.5,4+75,15> rotate<0,-30,0>}

     texture{
       pigment {
           gradient y
           color_map {
               [0.25 rgb <1,.3,.2>*.95]
               [0.25 rgb <1,1,1>]
               [0.75 rgb <1,1,1>]
               [0.75 rgb <1,.3,.2>*.95]
           }
           scale 50
       }


       finish{ambient .3}
       normal{brick normal{bumps 0.3}, normal{granite 0.2}  scale .3}
     }


     texture{
       pigment{
         bozo
  //       spotted
  //       wrinkles
         turbulence .5
         color_map {
           [0.0 rgbf<1,1,1,1>]
           [1.0 rgbf<1,1,1,.5>*.6]
         }
       }
       finish{ambient .3}
       scale <.125,10,1>
     }
   } 
   
   
   box{<-1.75,-25,-17>,<1.75,-25+7,-16.75> pigment{MediumWood }}  
   box{<+1.5,0,-17>,<1.5,4,-16.98> texture{NBoldglass}}
   box{<+1.5,45,-17+1>,<1.5,4+45,-16.98+1> rotate<0,30,0> texture{NBoldglass}}
   box{<+1.5,75,-17+1>,<1.5,4+75,-16.98+1> rotate<0,-30,0> texture{NBoldglass}}   

   union{
     cone{<0,-50.1,0>,30, <0,-27,0>,25}
     cylinder{<0,-40,0>,<0,-25,0>, 23}
     torus{23,2 translate<0,-27,0>}
     texture{
       pigment{White*.75}
       finish{ambient .3 crand .3}
       normal{crackle 60  scale 3}
     }
   }

   cylinder{<0,99.5,0>,<0,101,0>, 15.5
     texture{
       pigment{rgb <1,.3,.2>*.95}
       finish{ambient .3}
     }

     texture{
       pigment{
         bozo
         turbulence .5
         color_map {
           [0.0 rgbf<1,1,1,1>]
           [1.0 rgbf<1,1,1,.65>]
         }
       }
       finish{ambient .3}
       scale <.125,10,1>
     }
   
     texture{
       pigment{
         bozo
  //       spotted
  //       wrinkles
         turbulence .5
         color_map {
           [0.0 rgbf<1,1,1,1>]
           [1.0 rgbf<1,1,1,.5>*.6]
         }
       }
       finish{ambient .3}
       scale <.125,10,1>
     }
   }

   torus{15.25,3/12
     texture{New_Brass }
     texture{ Copper_Texture }
     translate<0,101.75,0>
   }

   torus{15.25,3/12
     texture{New_Brass}
     texture{ Copper_Texture }
     translate<0,104,0>
   }

   #declare yy=0;
   #while (yy<360)
     cylinder{<0,101,15.25>,<0,104,15.25>, 3/12
       texture{Copper_Texture}
       rotate<0,yy,0>
     }
     #declare yy=yy+30;
   #end

   cylinder{<0,101,0>,<0,108,0>, 10
     texture{
       pigment{White}
       finish{ambient .3}
       normal{brick normal{bumps 0.4}, normal{granite 0.2}  scale .3}
     }
   }

   cylinder{<0,107.5,0>,<0,108.5,0>, 10.75
     texture{
       pigment{MediumWood }
       finish{ambient .3}
     }
   }

   #declare yy=0;
   #while (yy<360)
     cylinder{<0,108.5,10.25>,<0,112,10.25>, 3/12
       texture{Copper_Texture}
       rotate<0,yy-15,0>
     }
     #declare yy=yy+30;
   #end

   torus{10.25,3/12
     texture{ Copper_Texture }
     translate<0,112,0>
   }

   #declare yy=0;
   #while (yy<360)
     box{<-2.07055,108.5,7.7274>,<2.07055,117.5,7.7274-0.04>
       texture{NBoldglass}
       rotate<0,yy,0>
     }
     #declare yy=yy+30;
   #end

   #declare yy=0;
   #while (yy<360)
     box{<-.25,108.5,7.7274+.125>,<.25,117.5,7.7274-.125>
       texture{ Copper_Texture }
       rotate<0,yy+15,0>
     }
     #declare yy=yy+30;
   #end

   difference{
     cone{<0,117.5,0>,8.75, <0,122.5,0,>,0}
     cone{<0,117.5-.01,0>,8.75, <0,122.5-.02,0,>,0}
     texture{ Copper_Texture }
   }
   sphere{<0,123.5,0>,1 texture{ Copper_Texture } }
    
  object{ladder rotate<0,0,-12.25> translate<-23.5,-25,0> rotate<0,-35,0> }
}


       
#declare rightInnerWing=
difference{
  prism {
    linear_sweep
    linear_spline 
   -.25,
    .25,
    28,
    <  2-186, 38>,  < 12-186, 39>,  < 23-186, 39>, < 52-186, 38>,  < 66-186, 40>,  < 75-186, 40>,  < 80-186, 37>,
    < 84-186, 31>,  < 84-186, 35>,  < 86-186, 41>,  <102-186, 46>,  <119-186, 51>,  <136-186, 55>,  <154-186, 58>,
    <168-186, 59>,  <186-186, 57>,  <186-186, 24>,  <186-186,  4>,  <166-186,  9>,  <149-186, 10>,  <130-186, 12>,
    <113-186,  8>,  < 97-186,  5>,  < 75-186,  5>,  < 54-186,  9>,  < 36-186, 15>,  < 21-186, 24>,  <  2-186, 38>   
  }
  box{<-65,-.75,-100>,<-1000,.750,100> pigment{ color rgbf <1,1,1,.5>}}    
  pigment { White*1.25 }  
  finish{ambient .5}
  } 
  
#declare rightOuterWing=
difference{
  prism {
    linear_sweep
    linear_spline 
   -.25, 
    .25,
    28, 
    <  2-121, 38>,  < 12-121, 39>,  < 23-121, 39>, < 52-121, 38>,  < 66-121, 40>,  < 75-121, 40>,  < 80-121, 37>,
    < 84-121, 31>,  < 84-121, 35>,  < 86-121, 41>,  <102-121, 46>,  <119-121, 51>,  <136-121, 55>,  <154-121, 58>,
    <168-121, 59>,  <186-121, 57>,  <186-121, 24>,  <186-121,  4>,  <166-121,  9>,  <149-121, 10>,  <130-121, 12>,
    <113-121,  8>,  < 97-121,  5>,  < 75-121,  5>,  < 54-121,  9>,  < 36-121, 15>,  < 21-121, 24>,  <  2-121, 38>   
  }
  box{<0,-.75,-100>,<1000,.750,100> pigment{ color rgbf <1,1,1,.5>}}    
  pigment { White*1.25 } 
  finish{ambient .5}
}   

  
#declare leftInnerWing=
difference{
  prism {
    linear_sweep
    linear_spline 
   -.25, 
    .25, 
    28,
    <  2-186, 38>,  < 12-186, 39>,  < 23-186, 39>, < 52-186, 38>,  < 66-186, 40>,  < 75-186, 40>,  < 80-186, 37>,
    < 84-186, 31>,  < 84-186, 35>,  < 86-186, 41>,  <102-186, 46>,  <119-186, 51>,  <136-186, 55>,  <154-186, 58>,
    <168-186, 59>,  <186-186, 57>,  <186-186, 24>,  <186-186,  4>,  <166-186,  9>,  <149-186, 10>,  <130-186, 12>,
    <113-186,  8>,  < 97-186,  5>,  < 75-186,  5>,  < 54-186,  9>,  < 36-186, 15>,  < 21-186, 24>,  <  2-186, 38>   
  }
  box{<-65,-.75,-100>,<-1000,.750,100> pigment{ color rgbf <1,1,1,.5>}}    
  rotate<0,0,180>
  pigment { White*1.25 } 
  finish{ambient .5}
} 
  
#declare leftOuterWing=
difference{
  prism {
    linear_sweep
    linear_spline 
   -.25, 
    .25, 
    28, 
    <  2-121, 38>,  < 12-121, 39>,  < 23-121, 39>, < 52-121, 38>,  < 66-121, 40>,  < 75-121, 40>,  < 80-121, 37>,
    < 84-121, 31>,  < 84-121, 35>,  < 86-121, 41>,  <102-121, 46>,  <119-121, 51>,  <136-121, 55>,  <154-121, 58>,
    <168-121, 59>,  <186-121, 57>,  <186-121, 24>,  <186-121,  4>,  <166-121,  9>,  <149-121, 10>,  <130-121, 12>,
    <113-121,  8>,  < 97-121,  5>,  < 75-121,  5>,  < 54-121,  9>,  < 36-121, 15>,  < 21-121, 24>,  <  2-121, 38>   
  }
  box{<0,-.75,-100>,<1000,.750,100> pigment{ color rgbf <1,1,1,.5>}} 
  rotate<0,0,180>   
  pigment { White*1.25 } 
  finish{ambient .5}
}        
  
#macro makeSeagull(theSeed)
  union{ 
    #declare R1 = seed(theSeed);      
    box{<-4,-.25,0>,<4,.25,50> rotate<0,-10,0> translate<0,0,16*5> pigment{White*1.5} finish{ambient .3}}
    box{<-4,-.25,0>,<4,.25,50> rotate<0,10,0> translate<0,0,16*5> pigment{White*1.5} finish{ambient .3}}  
    cylinder{<0,0,0>,<0,0,-20>, 3 rotate<-20,0,0> translate<0,0,-16*5> pigment{Yellow*1.5} finish{ambient .3}}
    sphere{<0,0,0>, 16 scale<1,1,5> pigment{White*1.5} finish{ambient .3}}
     
    #declare innerWingRotate=rand(R1)*60;     
    #declare outerWingRotate=rand(R1)*60;
                                                 
    union{
      object{rightInnerWing translate<-14,0,-30> }                 
      object{rightOuterWing rotate<0,0,30-(outerWingRotate)> translate<-14-65,0,-30> }                              
      rotate<0,0,30-innerWingRotate>                                              
    }

    union{
      object{leftInnerWing translate<14,0,-30> }                 
      object{leftOuterWing rotate<0,0,-30+(outerWingRotate)> translate<14+65,0,-30> }                              
      rotate<0,0,-30+innerWingRotate>                                              
    }
    scale 1/10
                                                     
    rotate<-15+(30*rand(R1)),-40+(80*rand(R1)),-15+(30*rand(R1))>
    translate<-200-(250*rand(R1)), 15+(20*rand(R1)),1200+(20*R1)>
   } 
 #end 
 

#declare boatHalf=
  prism {
    linear_sweep
    linear_spline 
   -12, 
    12,     
    13, 
    <27-27 ,132-132>,
    <46-27 ,122-132>,
    <67-27 ,114-132>,
    <88-27 ,105-132>,
    <115-27, 98-132>,
    <139-27, 94-132>,
    <164-27, 93-132>,
    <194-27, 94-132>,
    <217-27, 96-132>,
    <241-27, 99-132>,
    <266-27,103-132>,
    <266-27,132-132>,  
    <27-27 ,132-132>
    pigment{White*.9} 
    finish{ambient .5}
    rotate<0,0,0>
  } 
  
#declare boatHull=
union{
  object{boatHalf}
  object{boatHalf rotate<180,0,0> translate<0,0,-.01>}
}

#declare boat=
  difference{
    object{boatHull}
    object{boatHull scale <.9,1,.90> translate<.5,5,0>}  
  } 
  



//==================<<< assemble scene >>>=======================
camera{
   location  <0.0, 350, -4.0>
   direction 1.5*z
   right     4/2*x
   look_at   <0.0, 350,  0>
}


light_source{<-10000000, 10000000/.99, -1700000> color White  }   
light_source{<-10000000, 10000000/.99, -1700000> color White  shadowless} 

sky_sphere{
   pigment  {
     gradient y
     color_map { [0.0 Blue+White*.3] [1.0  White*1.0] }
   }
   rotate<-20,0,0>
}


plane {y, 0 texture { seatexture2 scale 2}}
plane {y, -2  pigment {color rgb<0.15, 0.35, 0.4>}}    

object{boat scale <.3,.5,.3> rotate<-10,105,0> rotate<0,0,0> translate<290,0,2225>}   
object{lightHouse scale 5 translate<500,250,2260>} 

// add 40 seaguls
 #declare i=0;
 #while (i<40) 
   makeSeagull(i*200)
   #declare i=i+1;
 #end  

fog{
  fog_type   2
  distance   50000-30000
  color      rgb <0.90, 0.90, 0.98>*.9-.2
  fog_offset -1000
  fog_alt    1000
}  

// add the rocks
height_field{
  tga "land2.tga"     
  translate<-.5,0,-.5>
  rotate<0,90,0> 
  scale<2000,300,2000> 
  
  texture {
    gradient y     
    texture_map {
      [0.0 rocks ]
      [0.7 rocks]
      [0.75 birdDrop]
      [1.0  birdDrop]
    }
    scale<50,300,50>
  }  
  translate <100,-50,1400>
//  [smooth]        // make smoother surface
}  


// add the clouds
#include "i_stsky2.inc"

#declare dark_color= SkyBlue*.5+White*.42
#declare light_color= White*1.1

#declare height=15000;
#declare cloud_level=.13;
#declare planes=35;   //60
#declare pdist=2;
#declare pdist=planes;
#declare ppatt=pigment{bumps}
#declare pturb=1.0;
#declare pocta=9;
#declare plamb=3.5;
#declare pomeg=.45;
#declare tdist=2;
#declare tdist=planes;
#declare sfactor=10000;
#declare dfactor=.75-.1;
#declare border=.2;
#declare fstart=.75; //7
#declare fend=.95;

object{
  clouds(
    dark_color,         // color for lower parts
    light_color,        // color for upper parts
    height,             // heigth to first layer
    cloud_level,        // level of "cloudiness"(?)
    planes,             // number of planes
    pdist,              // distance between planes
    ppatt,              // pigment pattern
    pturb,              // amount of turbulence
    pocta,              // and its modifiers
    plamb,
    pomeg,
    tdist,              // distance between textures
    sfactor,            // scaling factor
    dfactor,            // darkening factor
    border,             // width of change zone
    fstart,             // filter for lower layer
    fend                // filter for upper layer
  )
  hollow
// no_shadow
  rotate 4.75*y
  translate<16000-800,100,-50000+10000>
}


