#include "colors.inc"   
#include "shapes.inc"   
#include "textures.inc" 
#include "metals.inc"
#include "glass.inc"
#include "skies.inc"

global_settings { max_trace_level 64 } // needed for the sky stack 

camera {
   location <2, 13, -90>
   direction <0, 0, 1.5>
   up <0, 1, 0>
   right <1.33333, 0, 0>
   look_at   < 0, 6, 0>
   angle 65 
}

#declare Trace_Clouds = 2; //0=off, 1=partial, 2=full
#declare Trace_Water = 2; //0=off, 1=on, 2=smooth (hf)
#declare Trace_Semi = 1;

light_source { <2,90,-90> color White } //Camera Light
light_source { <-100, 100, -100> color White }
light_source { <100, 100, -100> color White }

#if (Trace_Semi=1)
#declare Chrome = texture { T_Chrome_4D }
#include "semi.inc"
#include "semtop.inc"
#include "semright.inc"
#include "semleft.inc"
#include "semfront.inc"
#include "semback.inc"
#include "semirest.inc"
#declare CabRest = object { SemiRest texture { pigment {color Aquamarine } finish { metallic } } }
#declare CabBack = object { SemiBack
                            texture {pigment {color Aquamarine } finish { metallic } }
                            texture { finish { ambient .3  diffuse .7  
                                              phong .6  phong_size 20  metallic
                                             }
                                      pigment { image_map { gif "cabback.gif" interpolate 2 once }
                                                translate <-.5, -.5, 0>
                                                rotate <0, 90, 0>
                                                scale <1, 160, 205>
                                              } 
                                    }
                          }
#declare CabFront = object { SemiFront 
                             texture {pigment {color Aquamarine } finish { metallic } }
                             texture { finish { ambient .3  diffuse .7  
                                                phong .6  phong_size 20  metallic
                                              }
                                       pigment { image_map { gif "truckfr1.gif" interpolate 2 once }
                                                 translate <-.5, -.5, 0>
                                                 rotate <0, 90, 0>
                                                 scale <1, 180, 250>
                                                 translate <0, 5, 5>
                                               } 
                                     }                
                           }
#declare CabTop = object { SemiTop 
                           texture { finish { ambient .3  diffuse .7  
                                              phong .6  phong_size 20  metallic
                                            }
                                     pigment { image_map { gif "cabtop.gif" interpolate 2 once }
                                               translate <-.5, -.5, 0>
                                               rotate <0, 0, 90>
                                               rotate <90, 0, 0>
                                               scale <128, 1, 163>
                                               translate <125, 0, 0>
                                             } 
                                   }
                         }
#declare CabRight = object { SemiRight 
                             texture { finish { ambient .3  diffuse .7 
                                                phong .6  phong_size 20  metallic
                                              }
                                       pigment { image_map { gif "cabright.gif" interpolate 2 once }
                                                 scale <198, 150, 1>
                                                 translate <30, -65, 0>
                                                 
                                               } 
                                     }
                           }          
#declare CabLeft = object { SemiLeft
                            texture { finish { ambient .3  diffuse .7  
                                               phong .6  phong_size 20  metallic
                                             }
                                      pigment { image_map { gif "cableft.gif" interpolate 2 once }
                                                translate <-.5, -.5, 0>
                                                rotate <0, 180, 0>
                                                scale <198, 150, 1>
                                                translate <130, 10, 0>
                                                
                                               } 
                                    }
                          }          
#declare _DOORS = object { _DOORS texture { Glass } }
#declare _UNDERCAR = object { _UNDERCAR texture { Chrome } }
#declare _TANKS = object { _TANKS texture { Chrome } }
#declare _STACK = object { _STACK texture { Chrome } }
#declare _WHEELSAX = object { _WHEELSAX texture { Chrome } }
#declare _STEPS = object { _STEPS texture { Chrome } }
#declare _TIRES = object { _TIRES texture { pigment {color Gray20} 
                                            finish {ambient 1 diffuse 0 } } }
#declare _MIRROR_1 = object { _MIRROR_1 texture { Chrome } }
#declare _MIRROR = object { _MIRROR texture { Chrome } }
#declare _LIGHTS = object { _LIGHTS 
                            texture { pigment { color Yellow } finish { Shiny } } 
                            texture { T_Ruby_Glass pigment { rgbf<.9, .1, .8, .4> } } 
                          }
#declare _HEADLIGH = object { _HEADLIGH 
                              texture { pigment { color White } finish { Shiny } }
                              texture { T_Old_Glass pigment { rgbf<.8, .9, .85, .3> }}
                            }
#declare _CHROME_R = object { _CHROME_R texture { Chrome } }
#declare _CAB_CHRO = object { _CAB_CHRO texture { Chrome } }
#declare _HANDLES = object { _HANDLES texture { Chrome } }
#declare _WINDSHIE = object { _WINDSHIE texture { Glass } }

#declare Semi = union {
                       object { CabFront }
                       object { CabRest }
                       object { CabRight }
                       object { CabLeft }
                       object { CabTop }
                       object { CabBack }
                       object { _DOORS }  //Windows
                       object { _UNDERCAR }
                       object { _TANKS }
                       object { _STACK }  
                       object { _WHEELSAX }
                       object { _STEPS }
                       object { _TIRES }
                       object { _MIRROR_1 }
                       object { _MIRROR }
                       object { _LIGHTS }
                       object { _HEADLIGH }
                       object { _CHROME_R }  
                       object { _CAB_CHRO }
                       object { _HANDLES }
                       object { _WINDSHIE }
                      }
                       
object { Semi  //#1 
         scale .05
         rotate<0, -10, 0>
         rotate <0, 150, 0>
         translate <-5, 7, -60>
       }
object { Semi  //#2 
         scale .05
         rotate <0, -10, 0>
         rotate <0, 135, 0>
         translate <15, 7.5, -45>
       }
object { Semi  //#3 
         scale .05
         rotate <0, -10, 0>
         rotate <0, 70, 0>
         translate <10, 8, -15>
       }
object { Semi  //#4 
         scale .05
         rotate <0, -10, 0>
         rotate <0, 40, 0>
         translate <-10, 8, 10>
       }
object { Semi  //#5 
         scale .05
         rotate <0, -10, 0>
         rotate <0, 40, 0>
         translate <-30, 8, 40>
       }
#end


//The Sky
//Stormy Sky -----------------------------------
//Code shamelessly lifted from "19141918" by Ian Shumsky who got it
//from "Canyon" by Jaime Piqueres
#if (Trace_Clouds>0)  
#declare sky_color=SkyBlue*0.8; 
#declare sun_color = <240 / 255, 247 / 255, 253 / 255>;
sky_sphere { S_Cloud4 rotate <30,0,0>} //pigment { sky_color } }
//
// The cloud planes. 
	#if (Trace_Clouds = 1)
		#declare num_planes = 4;
	#else
		#declare num_planes = 20;
	#end
  #declare StormySky = union {
	#declare clouds_height = 5000;
	#declare plane_dist = 40;
	#declare textu_dist = 40;
	#declare cnt_planes = 1;
	// First cloud layer. This layer is quite dark and broody.
	//
        union
	{ #while (cnt_planes <= num_planes)
	    #declare p = sky_color * .5 + White * .5;
	    #declare p1 = p * (1 - (cnt_planes / num_planes)) + White * (cnt_planes / num_planes);
	    #declare p2 = p * .9 * (1 - (cnt_planes / num_planes)) + White * .9 * (cnt_planes / num_planes);
            plane { y, 0 texture { pigment { agate
					     octaves 9
					     lambda 3
					     turbulence 4
				   color_map {
				              [0.0 Clear]
					      [0.6 Clear]
					      [0.7 p1 filter 0.7 + 0.1 * (cnt_planes / num_planes)]
					      [1.0 p2 filter 0.7 + 0.1 * (cnt_planes / num_planes)]
					     }
					      scale 1000000
				           }
				  finish { ambient sun_color }
				  translate (clouds_height + textu_dist * cnt_planes) * y
				 }
                                no_shadow
				translate (clouds_height + plane_dist * cnt_planes) * y
			}
                        #declare cnt_planes = cnt_planes + 1;
		#end
		translate 7000 * z
	}
        // The second layer of clouds. This layer has a different base texture
	// which gives a more 'solid' type cloud. It is also higher than the first
	// level.
	//
        #declare clouds_height = 7500;
	#declare cnt_planes = 1;
        union
	{
		#while (cnt_planes <= num_planes)
			#declare p = sky_color * .5 + White * .5;
			#declare p1 = p * (1 - (cnt_planes / num_planes)) + White * (cnt_planes / num_planes);
			#declare p2 = p * .9 * (1 - (cnt_planes / num_planes)) + White * .9 * (cnt_planes / num_planes);

			plane
			{
				y, 0
				texture
				{
					pigment
					{
						marble
						octaves 9
						lambda 3
						turbulence 4
						color_map
						{
							[0.0 Clear]
							[0.6 Clear]
							[0.7 p1 filter 0.7 + 0.1 * (cnt_planes / num_planes)]
							[1.0 p2 filter 0.7 + 0.1 * (cnt_planes / num_planes)]
						}
						scale 1000000
					}
					finish
					{
						ambient sun_color
					}
					translate (clouds_height + textu_dist * cnt_planes) * y
				}

				no_shadow
				translate (clouds_height + plane_dist * cnt_planes) * y
			}

			#declare cnt_planes = cnt_planes + 1;
		#end
		translate 7000 * z
	}
        // Finally, place a third level of clouds for a final 'whispy' set
	// of clouds.
	//
        #declare num_planes = 2;
	#declare clouds_height = 15000;
	#declare plane_dist = 40;
	#declare textu_dist = 40;
	#declare cnt_planes = 1;
        union
	{
		#while (cnt_planes <= num_planes)
			#declare p = White*1.2;
			#declare p1 = p*(1-(cnt_planes/num_planes))+White*(cnt_planes/num_planes);
			#declare p2 = p*.9*(1-(cnt_planes/num_planes))+White*.9*(cnt_planes/num_planes);

			plane
			{
				y, 0
				texture
				{
					pigment
					{
						ripples
						octaves 9
						lambda 3
						turbulence 4
						color_map
						{
							[0.0 Clear]
							[0.4 Clear]
							[0.7 p1 filter 0.8+0.1*(cnt_planes/num_planes)]
							[1.0 p2 filter 0.8+0.1*(cnt_planes/num_planes)]
						}
						scale 100000
					}
					finish
					{
						ambient sun_color
					}
					translate (clouds_height+textu_dist*cnt_planes)*y
				}
				no_shadow
				translate (clouds_height+plane_dist*cnt_planes)*y
			}
			#declare cnt_planes = cnt_planes+1;
		#end
		rotate y*45
	}
   } //End StormySky union
object { StormySky
         rotate <0,225,0>
         rotate <5,0,0>
       }     
#end //If Clouds    



//  This is the water. 
#if (Trace_Water>0)
#declare MedGreen = color red 0.258824 green 0.435294 blue 0.358824; 
#declare LightSteel = color rgb <0.560784 0.560784 0.737255>;
height_field {
              gif "cvgocean.gif"
              scale <10,2,10>
              texture { pigment { color rgbt<.1,.2,.4,.35> }
                        normal { bumps 0.5 scale .8 }
                        finish { phong 1 reflection .35 ambient 0.3 diffuse 0.3 }
                      }    
              translate <-5, 0, -5>
              rotate <0, 45, 0>
              scale <12, 5, 12>
              #if (Trace_Water=2) smooth  #end
             }
#end




