// *** BODY SECTION ***
#macro curved_section(rds)
union{
object{curved_board(rds) translate 20*0*z}
object{curved_board(rds) translate 20*1*z}
object{curved_pillar(rds) translate 20*1.5*z}
object{curved_board(rds) translate 20*2*z}
object{curved_board(rds) translate 20*3*z}
object{curved_pillar(rds) translate 20*3.5*z}
}
#end

// *** BACK WALL ***
#declare back_wall=
box{
 -.5,.5
 scale <300,250,2>
 texture{
  t_madera
  rotate 90*x
  scale 10
  translate 100*rand(rds)
 }
}

// *** CROSS PILLARS ***
#macro pillar(rds)
union{
 object{plain_board(5,100,5,rds)
  texture{
   t_madera
   rotate 90*x
   scale 10
   translate 100*rand(rds)
  }
 }
 object{plain_board(5,150,5,rds)
  texture{
   t_madera
   rotate 90*x
   scale 10
   translate 100*rand(rds)
  }
  rotate 90*z
  translate -5*y
 }
}
#end

// *** BEAMS ***
#macro beam(rds)
object{plain_board(5,5,500,rds)
 texture{
  t_madera
  scale 10
  translate 100*rand(rds)
 }
}
#end
#macro supp_beam(rds)
object{plain_board(2,2,500,rds)
 texture{
  t_madera
  scale 10
  translate 100*rand(rds)
 }
}
#end

// *** FLOOR WOODS ***
#declare r_f=seed(457);
#declare board_width=210/6;
#declare ts=<.99,.9,.9>;
#declare t_madera=
texture{t_wood scale 6}
#declare boards_row1=
union{
 object{plain_board(board_width,1,10,r_f)
  scale ts
  texture{
   t_madera
   rotate 90*y
   scale 10
   translate 100*rand(r_f)*x
  }
 }
 object{plain_board(board_width,1,10,r_f)
  scale ts
  texture{
   t_madera
   rotate 90*y
   scale 10
   translate 100*rand(r_f)*x
  }
  translate <board_width*2,0,0>
 }
 object{plain_board(board_width,1,10,r_f)
  scale ts
  texture{
   t_madera
   rotate 90*y
   scale 10
   translate 100*rand(r_f)*x
  }
  translate <-board_width*2,0,0>
 }
}
#declare boards_row2=
union{
 object{plain_board(board_width,1,10,r_f)
  scale ts
  texture{
   t_madera
   rotate 90*y
   scale 10
   translate 100*rand(r_f)*x
  }
 }
 object{plain_board(board_width,1,10,r_f)
  scale ts
  texture{
   t_madera
   rotate 90*y
   scale 10
   translate 100*rand(r_f)*x
  }
  translate <board_width*2,0,0>
 }
 object{plain_board(board_width,1,10,r_f)
  scale ts
  texture{
   t_madera
   rotate 90*y
   scale 10
   translate 100*rand(r_f)*x
  }
  translate <-board_width*2,0,0>
 }
 object{plain_board(board_width,1,10,r_f)
  scale ts
  texture{
   t_madera
   rotate 90*y
   scale 10
   translate 100*rand(r_f)*x
  }
  translate <-board_width*3,0,0>
 }
 translate board_width*.5*x
}
#declare boards_floor=
union{
 object{boards_row1 rotate 180*y translate -20*2*z}
 object{boards_row1 rotate 180*y translate -20*1*z}
 object{boards_row1 translate 20*0*z}
 object{boards_row2 translate 20*1*z}
 object{boards_row1 rotate 180*y translate 20*2*z}
 object{boards_row2 rotate 180*y translate 20*3*z}
 object{boards_row1 translate 20*4*z}
 object{boards_row2 translate 20*5*z}
 object{boards_row1 rotate 180*y translate 20*6*z}
 object{boards_row2 rotate 180*y translate 20*7*z}
 object{boards_row1 translate 20*8*z}
 object{boards_row2 translate 20*9*z}
 object{boards_row1 rotate 180*y translate 20*10*z}
 object{boards_row2 rotate 180*y translate 20*11*z}
 object{boards_row1 translate 20*12*z}
 object{boards_row2 translate 20*13*z}
 object{boards_row1 rotate 180*y translate 20*14*z}
 object{boards_row2 rotate 180*y translate 20*15*z}
 object{boards_row1 translate 20*16*z}
 object{boards_row2 translate 20*17*z}
 object{boards_row1 rotate 180*y translate 20*18*z}
 object{boards_row2 rotate 180*y translate 20*19*z}
 object{boards_row1 translate 20*20*z}
 object{boards_row2 translate 20*21*z}
 object{boards_row1 rotate 180*y translate 20*22*z}
 object{boards_row2 rotate 180*y translate 20*23*z}
 object{boards_row1 translate 20*24*z}
 object{boards_row2 translate 20*25*z}
 object{boards_row1 rotate 180*y translate 20*26*z}
 object{boards_row2 rotate 180*y translate 20*27*z}
 object{boards_row1 translate 20*28*z}
 object{boards_row2 translate 20*29*z}
 object{boards_row1 rotate 180*y translate 20*30*z}
 object{boards_row2 rotate 180*y translate 20*31*z}
}

// *** step ***
#declare woodstep=
union{
 object{plain_board(1,50,5,rds)
  texture{
   t_madera
   rotate 90*x
   scale 10
   translate 100*rand(rds)
  }
  translate -10*x
 }
 object{plain_board(1,50,5,rds)
  texture{
   t_madera
   rotate 90*x
   scale 10
   translate 100*rand(rds)
  }
  translate 10*x
 }
 #declare cnt=1;
 #while (cnt<=10)
 object{plain_board(10,.8,4,rds)
  texture{
   t_madera
   rotate 90*y
   scale 10
   translate 100*rand(rds)
  }
  rotate -20*x
  translate (-50+10*(cnt-1))*y
 }
 #declare cnt=cnt+1;
 #end
}

#declare lamp_nail=
union{
 cylinder{<0,0,0>,<0,0,6>,.15}
 sphere{<0,0,6>,.15}
 cylinder{<0,0,6>,<0,1,6>,.15}
 texture{Chrome_Metal}
}


// CUERDA
#declare num_v=64;
#declare cnt_v=1;
#declare radio_c=1;
#declare radio_mi=15;
#declare radio_me=25;
#declare alto_m=8;
#declare r_cuerda=seed(962);
#declare monton_cuerda=
union{
 #while (cnt_v<=num_v)
  torus{radio_mi+(radio_me-radio_mi)*rand(r_cuerda),radio_c
   rotate (-1+2*rand(r_cuerda))*x
   rotate (-1+2*rand(r_cuerda))*z
   rotate (-1+2*rand(r_cuerda))*y
   translate alto_m*rand(r_cuerda)*y
  }
  #declare cnt_v=cnt_v+1;
 #end
 intersection{
  torus{radio_me,radio_c}
  plane{z,0}
  plane{x,0}
  translate radio_me*x
  rotate -14*x
  rotate 10*y
  translate -radio_me*.9*x
  translate alto_m*.9*y
 }
 texture{
  pigment{
   radial
   color_map{
    [0.0 DarkBrown]
    [0.5 Tan]
    [1.0 DarkBrown]
   }
   frequency 150
  }
 }
}
