// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1g.wmp.0.5a
// Desc: Basic Scene Example
// Date: dd/mm/yy
// Auth: Tom Melly, http://www.tomandlu.f9.co.uk, tom@tomandlu.f9.co.uk
//

#version unofficial MegaPov 0.5;

// ----------------------------------------

#macro Make_Bolt(LArraySize, LSeed, LWidth, LHeight, LSpread, LBranch, LCutoff, LLightColour, LSpike)

  #declare myArray = array[LArraySize]
  #declare checkCount = -1;
  #declare highCount = 0;
  #declare arrayCount = 0;
  #declare myArray[arrayCount] = <0,0,0>;
  #declare lightCount = 0;
  
  #declare myRand = seed(LSeed); 

  #declare Lightning_Bolt =
  union{
    #while (checkCount < highCount)
      #declare checkCount = checkCount + 1;  
      #declare segPosA = myArray[arrayCount];
      #declare arrayCount = arrayCount + 1;
      #declare xPlus = (rand(myRand)-0.5)*LSpread;
      #declare zPlus = (rand(myRand)-0.5)*LSpread;
      #while(segPosA.y < LHeight)
        #declare xShift = segPosA.x + ((rand(myRand)-0.5)*LSpike) + xPlus;
        #declare yShift = segPosA.y + (rand(myRand)/5);
        #declare zShift = segPosA.z + ((rand(myRand)-0.5)*LSpike) + zPlus;
        #if (yShift > LHeight)
          #declare yShift = LHeight;
        #end
        #declare segPosB = <xShift, yShift, zShift>;
        cylinder{segPosA, segPosB, LWidth}
        sphere{segPosB, LWidth + 0.0001}
        #declare lightCount = lightCount + 1;
        #if(lightCount = 10)
          light_source{segPosB color LLightColour fade_distance LHeight/10 fade_power 2}
          #declare lightCount = 0;
        #end
        #declare segPosA = segPosB;          //#debug concat("segPosB: ", str(segPosB.y, 5,5),"\n")
        #declare randNum = rand(myRand);          //#debug concat("randNum: ", str(randNum, 5,5),"\n")
        #if (randNum < LBranch & segPosA.y > LCutoff)
          #declare highCount = highCount + 1;
          #declare myArray[highCount] = segPosA;          //#debug concat("highCount: ", str(highCount,-4,0), "\n")
        #end
      #end
    #end
  }
#end

