// Persistence of Vision Ray Tracer Scene Description File
// File: sea.inc
// Vers: 3.1g.wmp.0.5a
// Desc: iso sea inc
// Date: dd/mm/yy
// Auth: Tom Melly, http://www.tomandlu.f9.co.uk, tom@tomandlu.f9.co.uk
//

#version unofficial MegaPov 0.5;

#declare seaPig =
pigment{rgbf <0.75,0.95,0.8,1>}
#declare foamPig =
pigment{rgb<0.8,0.8,0.8>}

#declare allseaPig =
pigment{
  crackle turbulence 0.1 scale 0.2
  pigment_map{
    [0.1 agate scale 0.1 pigment_map{[0.6 seaPig][1.0 foamPig]}]
    [0.5 seaPig]
  }
}

#declare oldallseaPig =
pigment{
  bozo scale 0.1
  pigment_map{
    [0.4 seaPig]
    [0.6 agate scale 0.05 pigment_map{[0.6 seaPig][0.8 foamPig]}]
  }
}
#declare seaTexture =
texture{
  pigment{allseaPig}
  finish{
    specular 1 roughness 0.01 diffuse 0
    reflection_min .1
    reflection_max .5
    reflection_falloff 2
    conserve_energy
  } 
}

#declare iso1 =
  isosurface{
    #declare My_Ripples = function { cos(2*pi*sqrt(sqr(x)+sqr(z)))/1 }
    #declare Water_Surface = function { y + 0.2*My_Ripples }
    #declare f1 = function{Water_Surface(x*1+30,y*3,z*1-10)} //big waves from +z
    #declare f2 = function{Water_Surface(x*8+20,y*4,z*8+10)} //medium waves from -z
    #declare f3 = function{Water_Surface(x*3+10,y*6,z*3-0)} //small waves from z=0
    #declare f4 = function{y + noise3d(x*2,y*2,z*2)/2} //random noise, swells?
    function{ f1/1 - f2/2 - f3/2 + f4/0.1 - f4(x*15,y*15,z*15)/4 - 4 }
    max_gradient 16
    eval
    threshold 1
    sign 1
    accuracy .001
    contained_by{box{<-1,-1,-1>,<1,2,1>}}

    pigment{allseaPig}
    interior{ 
      ior 1.33
      media{
        method 3
        absorption <0.65,0.5,0.5> 
        samples 2, 2
      }
    }
    hollow on
  }

#declare isoFrame =
object{
  base_cup_cut
  scale<0.98, 1,0.98> scale<1.24,1,1.24>// translate y*0.5
}

#declare isoStorm =
intersection{
  object{iso1}
  object{isoFrame pigment{rgbf 1}}
  translate y*0.61
}
