// Persistence of Vision Ray Tracer Scene Description File
// File: tmstormc.pov
// Vers: 3.1g.wmp.0.5a
// Desc: irtc sea entry
// Date: 28/07/00
// Auth: Tom Melly, http://www.tomandlu.co.uk, tom@tomandlu.co.uk
//

#version unofficial MegaPov 0.5;

#declare do_Radiosity = 1;
#declare do_Cup =       1;
#declare do_Rim =       1;
#declare do_Bolt =      1;
#declare do_Cloud =     1;
#declare do_Sea =       1;
#declare do_Room =      1;
#declare do_Table =     1;
#declare do_Sky =       1;

#include "colors.inc"
#include "metals.inc"
#include "skies.inc"
#include "woods.inc"
#include "textures.inc"
#include "glass.inc"
#include "cup.inc"
#include "sea.inc"
#include "lightning.inc"
#include "cloud.inc"

#if (do_Radiosity = 1)
  $Q=1;
  global_settings{
    max_trace_level 10
    // post_process{focal_blur{1,2,6,0}}
    ambient_light 0.001 // not 0 for lightning
    assumed_gamma 1.0 // IMPORTANT, set also Display_Gamma in povray.ini
    ini_option "+qr"
    radiosity{
      pretrace_start 0.04
      pretrace_end 0.02/Q
      count 150*Q
      recursion_limit 4 
      nearest_count 3+(Q-1)*10
      error_bound 1/Q
    }
  }
#else
  global_settings{
    max_trace_level 10
    ambient_light 0.001 // not 0 for lightning
    ini_option "+q9"
  }
  light_source{0*x color rgb<1,1,1>/3 translate y*20 shadowless}
  light_source{0*x color rgb<1,1,1>/2 translate y*50 shadowless}
#end

camera{location<2,2.75,-2.5> look_at<0,1,0>}

light_source{
  0*x
  color rgb <1,1,0.9>*0.8
  translate <6000, 3000,-1000>
  fade_power 2
  fade_distance 5000
}

#declare myFinish=
finish{diffuse 0.7}

#declare myT_Wood19 =
texture{
  T_Wood6 scale 2 // was 19
  finish{myFinish  brilliance 0.5 reflection_type 1 reflection_max 0.40 reflection_min 0.20}
  normal{bozo 0.1}
}

//sky
#if (do_Sky = 1)
  sphere{
    0, 10000
    inverse
    pigment{
      wrinkles scale 1000
      pigment_map{
        [0 White]
        [1 SkyBlue]
      }
    }
    finish{myFinish}
  }
#end

#if (do_Room = 1)
  #declare window =
    box{<0,0,0>,<15,20,3> texture{T_Wood3}} // hole in wall for a diff
  
  #declare windowFrame =
  union{
    difference{
      box{<-2,-2,0>,<17,22,3> texture{T_Wood3}} // outer wooden frame
      box{<0.1,0.1,-1>,<14.9,19.9,4> texture{T_Wood3}} // hole in outerframe
    }
    box{<7,0,0.2>,<8,20,2.8> texture{T_Wood3}}// vertical bar
    box{<0,9,0.1>,<15,10,2.9> texture{T_Wood3}}// horizontal bar
    box{<0,0,1.7>,<15,20,2.3> texture{T_Glass1} normal{bozo 0.1} interior{ I_Glass}} // glass
  }  
  
  #declare room_pigment =
  pigment{
    marble scale 5 rotate y*45
    pigment_map{
      [0.0 Goldenrod]
      [0.5 PaleGreen]
      [1.0 Wheat]
    }
  }
  #declare room =
  union{
    difference{
      box{<0,0,0>,<85,45,80> pigment{room_pigment} finish{myFinish}}// main shell
      box{<1,1,1>,<84,44,79> pigment{room_pigment} finish{myFinish}}// cutout center
    
      object{window translate <15,10,78>} // nw window
      object{window translate <50,10,78>} // ne window
    
      object{window rotate y*-90 translate <86,10,60>}// en window
      object{window rotate y*-90 translate <86,10,37>}// ee window
      object{window rotate y*-90 translate <86,10,10>}// es window
    }
    object{windowFrame translate <15,10,78>} // nw window frame
    object{windowFrame translate <50,10,78>} // ne window frame - don't bother with e frames
    
    box{<5,-1,5>,<80,1.1,75> pigment{Gold} finish{myFinish} normal{agate 0.2}}// carpet
    plane{y, -1 pigment{bozo pigment_map{[0 GreenYellow][1 ForestGreen]}} finish{myFinish}}// lawn
  }
  object{room translate<-70,-15,-45>}
#end

#if (do_Cup = 1)
  object{cup_and_saucer rotate y*-45}
  #if (do_Sea = 1)
    object{isoStorm rotate y*-45}
  #end
#end

#if (do_Table = 1)
  #declare table =
  cylinder {
     <0,0,0>, <0,1,0>, 8  texture{myT_Wood19}
  }
  object{table translate y*-1.01}
#end

#if (do_Bolt = 1)
  // #macro Make_Bolt(LArraySize, LSeed, LWidth, LHeight, LSpread, LBranch, LCutoff, LLightColour, LSpike)
  Make_Bolt(500, 75364, 0.075, 6, 0.5, 0.02, 0.5, <0.05,0.05,0.05>, 0.5)
  #declare bolt =
  object{
    Lightning_Bolt
    pigment{rgb <0.85,0.65,1.00>}
    finish{ambient rgb <0.85,0.65,1.00>*1000}
    scale 0.1
    rotate x*180
    rotate y*-10
    no_shadow
  }
  object{bolt rotate <-45,0,-45> scale <1,0.5,1> translate <0,2,0>}
#end

#if (do_Cloud = 1)
  object{Cloud_Mass scale <0.1,0.07,0.1> translate y*2}
#end
