#include "colors.inc"
#include "seagull.inc"
#include "Whale.inc"
#include "sailboat.inc"
#include "mainsail.inc"
#include "jib.inc"
#include "sailboat1.inc"

light_source{<0,50,-50> White}

light_source {
   <0, 0, 0> color White
   looks_like{
    sphere{0,200                         //the sun
     pigment{rgbf <1,1,159/255, .9>}
     finish{ambient 3}
    }
   }
  translate <-2600,1800,4000>
}
    

camera{
 location <0,2,-20>
 look_at y*2
}

sky_sphere{
 pigment{ gradient y
  color_map{                           //sky
   [0  rgb <125/255,125/255,1>]
   [.5 rgb <126/255,190/255,254/255>]
   }
  scale .75
  rotate z* 20
 }
}

plane { y, 300.0
   hollow on
   pigment {
      bozo
      turbulence 0.5
      color_map {
         [0.0 0.4  color rgbf <1,1,1,1>
                   color rgbf <1,1,1,1>]                    //clouds
         [0.4 0.7  color rgbf <1,1,1,1>
                   color rgbf < 230/255, 230/255, 230/255>]
         [0.7 1  color rgbf <247/255,247/255,247/255,.1>
                 color rgbf <1,1,1,.1>]
      }
      scale <1000.0, 200.0, 800.0>
   }
   finish {
      ambient 0.7
      diffuse 0.0
   }

   translate -450*x
   rotate 6*y
}
 

height_field {
   png "fract003.png"
   smooth 
   pigment {rgb <219/255,144/255,7.5/255>}              //rocks
   scale <100,25,100>
   translate <-60,-17,0>
   finish{phong .2 diffuse .2 crand .03 ambient .4}
} 

plane{y*-2,0
hollow on
 pigment{Aquamarine}
 normal{
  waves .06
  frequency 5000
  scale 900                                 //water
 }
 finish{ambient .1 diffuse .1 reflection .8}
}

plane{y*-5,3
hollow on
 pigment{rgb <1,.6,0>}
 finish{crand .05 ambient .8}
}

object{sailboat1 scale <2,2,2> rotate y*250 translate <-20,0,10>}
object{Whale translate <-8,0,40>} //Whale
object{seagull rotate z*20 translate y*10}  
object{seagull rotate y*90 rotate x*30 translate <10,10,10>}
object{seagull rotate x*20 rotate z*-20 translate <-5,5,-10>}
object{seagull rotate z*20 rotate y*-20 translate <5,6,-10>}   //seagulls
object{seagull rotate x*-20 rotate z*30 translate <0,8,7>}
object{seagull rotate x*-20 rotate z*30 translate <-12,6,7>}
object{seagull rotate y*200 rotate z*30 rotate x*-20 translate <-4,6,-8>}

