global_settings { assumed_gamma 1.35} // 1 = Home 1.5 = Work
 
 #include "textures.inc"
 #include "colors.inc"
 #include "woods.inc"
 #include "metals.inc"
 #include "stones1.inc"
  
  //object include files 
 #include "table.inc" 
 #include "book.inc"
 #include "microscope.inc"
 #include "bookcase.inc"
 #include "picture.inc"
 #include "test_tubes.inc"
 #include "stack_book.inc"
 #include "pencil.inc"
 
#declare overhead =
        camera {location <0,100,0> look_at <0,0,0>}                                                  
#declare frontview = 
        camera {location <10,51.6,-48> look_at <0,51.6,8>}                                                  
#declare finalview = 
        camera {location <60,50,-80> look_at <40,30,0>}                                                  


//camera {overhead}
//camera {frontview}
camera {finalview}


light_source {<0, 1000, -1000> White*1.5 shadowless}                
light_source {<100, 100, -100> White*.8}      

//light_source {
//    <40,100,-60>
//    color Silver2_Colour
//    spotlight              //over table
//    radius 100
//    falloff 15
//    tightness 70
//    point_at <40,37,-60>
//  }

light_source {
    <100,100,12>
    color White*0.25
    spotlight               //window light
    radius 10
    falloff 20
    tightness 10
    point_at <48,40,-50>
  }

////////////////////////////////////////
////////////textures////////////////////
////////////////////////////////////////
#declare glass_tx = texture {
  pigment { color <0.9560784 , 0.9560784 , 0.9560784, .7>}  
  finish { 
    ambient 0.014
   reflection .1
  }
}


/////////////////////////////////////////

background {Orange}
plane {<0,0,1>,-300 pigment {Brown}}
plane {<0,1,0>,3000 pigment {Gold}}
#declare beaker = merge { 
          difference {
             merge {
               cone {<0,0.4,0>,2.2 <0,6,0>,2.4 }
               torus {1.8, .4 translate <0,0.4,0>}
               cone {<0,0.1,0>,1.8 <0,.8,0>,2.2 }
              pigment { image_map {gif "beakerlabel.gif" transmit 0, 1.0 map_type 0 once} scale <2,1,1> translate <0,4.75,0>}
             }
            cylinder {<0,0.6,0> <0,6.1,0>,2.15 }
           }
          torus {2.3, .15  scale <1,0.8,1> translate <0,6,0>
          }}

// wall
  box {<-400,-100,15.5> <400,400,16.51> pigment { image_map {gif "concrete_03.gif"  map_type 0 interpolate 2}scale <50,50,1>}}
//window 
  object {windowframe scale <5,10,5> translate <100,60,14>}

// slide tray
union {
     difference {
        box {<35,35.7,-65> <45,36,-55> texture {T_Chrome_3B}}
        box {<35.2,35.8,-64.8> <44.8,36.1,-55.2> texture {T_Chrome_3B}}
        }
       // box {<36,35.8,-64> <44,35.81,-56> texture{T_Stone2}}
// slides 
#declare S1=seed(1);
#declare slide_count = 0;
#while (slide_count < 5)
        union {
        box {<35,35.8,-57.25> <38,35.9,-58> texture {glass_tx}}
        box {<36.3,35.9,-57.4> <36.9,35.91,-57.8> texture {Red_Marble scale .5 translate <slide_count*5,0,slide_count*5>}}
        box {<39,35.8,-57.25> <42,35.9,-58> texture {glass_tx}}
        box {<40.3,35.9,-57.4> <40.9,35.91,-57.8> texture {Brown_Agate translate <slide_count*5,0,slide_count*5>}}
        translate <2-rand(S1),0,-slide_count*1.5>
        }
        #declare slide_count = slide_count +1;
#end
 }
        
//broom handle
merge {
    sphere {<0,40,0>,1}
    cone {<0,40,0>,1.05 <10,0,5>,0.5 }
    translate <71,0,12> texture{T_Wood8 rotate <0,0,0> scale 10}
    }

object {Table scale <1,0.5,0.75> translate <50, 0, -60> }  // object is centered on <0,0,0> legs sitting on y=0

object {bookcase translate <  21,  0,3.5> pigment {DMFDarkOak rotate <0,90,0>}}  
object {bookcase translate < -27,-32,3.5> pigment {DMFDarkOak rotate <0,90,0>}}  
object {bookcase translate < -75,-16,3.5> pigment {DMFDarkOak rotate <0,90,0>}}  

object {painting rotate <-5,0,-1> scale 5 translate <-5,74,14>}

union { object {beaker texture {glass_tx} rotate <0,90,0> }
        cylinder {<0,0.6,0> <0,3.1,0>,2.15  pigment {
    granite
    color_map {
      [ 0 rgbf <0,.92,0,.7> ]
      [ 0.99 rgbf <0,0.5,.45,.85> ]
     } 
      scale <1,5,1>
     }
        scale 0.9 translate <-10,51.6,11>}
    }

union {object {beaker  texture {glass_tx} rotate <0,85,0> }
        cylinder {<0,0.6,0> <0,3.1,0>,2.15 pigment {
    granite
    color_map {
      [ 0 rgbf <0.,0.22,0,.7> ]
      [ 0.99 rgbf <0,0.7,.81,.85> ]
     } 
      scale <1,5,1>
    }}
        scale 0.75 translate <15,51.6,11>}
       
union {object {beaker  texture {glass_tx} rotate <0,45,0>}
        cylinder {<0,0.6,0> <0,3.1,0>,2.15  pigment {
    granite
    color_map {
      [ 0 rgbf <.1,0.1,0.4,.7> ]
      [ 0.99 rgbf <0,0.5,0.5,.85> ]
     } 
      scale <1,5,1>
    }}
        scale 0.88 translate <10,51.6,12>} 
        
union {object {beaker  texture {glass_tx} rotate <0,50,0>}
        cylinder {<0,0.6,0> <0,3.1,0>,2.15  pigment {
    granite
    color_map {
      [ 0 rgbf <0,0.7,0,.7> ]
      [ 0.99 rgbf <0.8,0.0,0.62,.85> ]
     } 
      scale <1,5,1>
    }}
        scale 0.80 translate <8,51.6,8>}
      
union {object {beaker  texture {glass_tx} rotate <0,75,0>}
        cylinder {<0,0.6,0> <0,3.1,0>,2.15  pigment { rgbf <0.3, 0.6, 0, 0.5>}}
        scale 1 translate <0,51.6,12>}

 // beakers on desk
union {object {beaker  texture {glass_tx} rotate <0,45,0>}
        cylinder {<0,0.6,0> <0,3.1,0>,2.15 pigment {
    granite
    color_map {
      [ 0 rgbf <.1,0.1,0.4,.7> ]
      [ 0.99 rgbf <0,0.5,0.5,.85> ]
     } 
      scale <1,5,1>
    }}
        scale 0.58 translate <53,35.7,-55>} 
        
union {object {beaker  texture {glass_tx} rotate <0,50,0>}
        cylinder {<0,0.6,0> <0,3.1,0>,2.15  pigment {
    granite
    color_map {
      [ 0 rgbf <0,0.7,0,.7> ]
      [ 0.99 rgbf <0.8,0.0,0.62,.85> ]
     } 
      scale <1,5,1>
    }}
        scale 0.80 translate <48,35.7,-50>}
       
union {object {beaker  texture {glass_tx} rotate <0,75,0>}
        cylinder {<0,0.6,0> <0,3.1,0>,2.15  pigment {
    granite
    color_map {
      [ 0 rgbf <0.8,0.3,0.4,.7> ]
      [ 0.99 rgbf <.1,0.5,0.4,.85> ]
     } 
      scale <1,5,1>
    }}
        scale 0.68 translate <42,35.7,-48>}

object {journal scale <.8,1,.58> rotate <90,25,0> translate <62,35.7,-57>}
object {test_tube_rack rotate <0,20,0> translate <64,35.7,-50>}
object {Microscope rotate <0,-70,0> scale 1.5 translate <50,35.5,-64>texture { T_Microscope_Base }}
object {books_on_side scale .75 rotate <0,-45,0> translate <25,35.5,-60>}
object {pencil rotate <35,0,90> translate <55,35.5,-63>}