//#include "textures.inc"
//#include "colors.inc"
//#include "test_wall.inc" 
//#include "woods.inc"
//
//global_settings { assumed_gamma 1 } // 1 = bright 1.5 = normal
//
//camera {
//        location <0,60,-100>
//        look_at <0,15,0>
//       }
//
//light_source {<-100, 500, -500> White*1}
//background {White}
//plane {<0,1,0>,0 pigment {Green}}    
//object {bookcase translate < 0,0,0> texture {DMFDarkOak rotate <0,90,0>}}  

// >>> DMFDarkOak (from file "textures.inc", line 559) <<<
#declare DMFDarkOak = pigment {
  wood
  turbulence 0.04 
  octaves 3
  scale <0.2, 0.2, 1> 
  color_map {
    [0.1 rgb <0.30, 0.15, 0.09>]
    [0.9 rgb <0.20, 0.10, 0.06>]
  }
}
//////////////////////////
//  Bookcase with books //
//////////////////////////
#declare detail = 1;       //1=yes, 0=no books

#declare height = 84;     //bookcase height
#declare bc_width = 48;    //bookcase width
#declare space = 16;       //distance between shelves
#declare shelf_ht = 3;     //starting location of bottom shelf (above skirt)
#declare bookcount = 17;   //number of books to create
#declare num_covers = 22;  //number of unique book cover gif's
#declare counter = 0;      //counter for books
#declare num_shelves = 5;  //number of shelves the books will be on
#declare num_of_books = 0; //number of books per shelf
#declare R1 = seed(5);     //random number
#declare y_loc = 3.1;        //bottom shelf height for books
#declare cases = 0;         //counter for number of bookcases

#declare bookcase = union {
box {<0,0,-3> <0.75, height, 12> }                  //left side
box {<bc_width-.75, 0, -3> <bc_width, height, 12> } //right side
box {<0.75, 0, -2.5> <bc_width-0.75, 3, 12> }       //skirt side
box {<0, 0, 11.9> <bc_width, height, 12> }         //back
 #while (shelf_ht < height)                        //shelves loop
   box {<0.75, shelf_ht, -2.75> <bc_width-0.75, shelf_ht+0.75, 12> }
   #declare shelf_ht = shelf_ht + space;
 #end


//////////////////////////////////////////
// creates several books with different //
//////////////////////////////////////////
#if (detail = 1) //if 1, show books, no books with any other number
    #while (counter < num_shelves)
     #declare x_loc = 0.75;  //starting location x
     #declare z_loc = 3;  //starting location z
      #while (num_of_books <bookcount)
          
         #declare covers = int(num_covers*rand(R1))+1; //randomly pick a book cover image
         #declare book_height = (10+(2*rand(R1)));     //random height between 10-12
         #declare book_width = 2+rand(R1);             //random width between 2-3
         #declare book_angle = rand(R1)*4;             //rendom book tilt angle between 0-5 degrees
        
         box {<0,0,0> <1,1,1> pigment {  
              image_map {gif concat("book test", str(covers,1,0), ".gif") map_type 0 interpolate 2}}
              scale <book_width,book_height,8> 
              #if (book_angle > 2)    //only tilts book if 2-3 degrees
                rotate <0,0,book_angle> 
                #declare rotate_dist = (book_height*sin(book_angle*pi/180))*0.85;
              #else                   
                #declare rotate_dist = 0;
              #end
              #declare x_loc=x_loc+rotate_dist;
                #if (x_loc+book_width < bc_width-0.75)
                  translate <x_loc, y_loc, z_loc>
                #else
                  #declare num_of_books = bookcount;
                #end     
             }
          #declare x_loc = x_loc + book_width;
          #declare num_of_books = num_of_books + 1;
        #end
      #declare counter=counter+1;
      #declare num_of_books = 0;
      #declare y_loc=y_loc+space;
     #end  
   #end
  }


/*------------------------- Objects ----------------------------------*/

//object {bookcase translate < -30,0,0> texture {DMFDarkOak rotate <0,90,0>}}  
