// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//

//#version 3.1;

/*
Although plain, undecorated ceramic tiles were traditionally a common
       flooring material in many parts of the Americas, especially in Latin and
       South America, ceramic floor and roof tiles were probably not made in
       the North American Colonies until the late-16th or early-17th century. It
       was, however, in the Victorian era that ceramic tile flooring first became
       so prevalent in the United States. The production of decorative tiles in
       America began about 1870 and flourished until about 1930. 
       
In the 19th century Britain pioneered mass-produced tiles. English tile
                 making expanded rapidly during the industrial revolution, peaked in the
                 late 1800s and slumped soon after the turn of the century. American
                 tile makers enjoyed a similar period of prosperity to their counterparts
                 but had to compete with English imports. The Arts & Crafts movement
                 reinvigorated the handcraft of tile making, and it was used extensively
                 in interiors for fireplace surrounds as well as wall decoration.        
       
       

*/ 
  
  

#include "colors.inc"
#include "textures.inc"
#include "metals.inc"


#declare useGlassTextures = true;  
#declare notIncludeFile = false;  
#include "lamp.pov"
#include "scope.pov"
#include "testtube.pov"
#include "glassjar.pov"

global_settings{
  assumed_gamma 2.2 
  max_trace_level 70  
}

// ----------------------------------------
camera{  
  location  <0.0, 4.0, -4>
  direction 2.0*z
  right     4/3*x 
  look_at   <-.25+.06, 32.5/12,  0.0>     
} 


/*
sky_sphere
{
  pigment
  {
    gradient y
    color_map { [0.0 color blue 0.6] [1.0 color rgb 1] }
  }
}    
*/


light_source{ <-5, 15, -15> color White*.3 
  shadowless
  fade_distance 21.75
  fade_power 3  
}  


light_source{ <2, 55/12, -1.5> color White*.65
  fade_distance 2.75
  fade_power 3  
  area_light
  <.1, 0, 0> <0, 0, .1> // lights spread out across this distance (x * z)
  2, 2               // total number of lights in grid (4x*4z = 16 lights)
  adaptive 1          // 0,1,2,3... 
  jitter              // adds random softening of light
}

// ----------------------------------------

// tablet of paper  
#declare paperTablet=
union{ 
  union{
    bicubic_patch { type 1 flatness 0.0001  u_steps 5  v_steps 5
       < 0.5, 0.5, 2.5>, < 1.0, 0.0, 3.0>, < 2.0, 0.0, 3.0>, < 3.0, 0.0, 3.0>,  
       < 0.0, 0.0, 2.0>, < 1.0, 0.0, 2.0>, < 2.0, 0.0, 2.0>, < 3.0, 0.0, 2.0>,  
       < 0.0, 0.0, 1.0>, < 1.0, 0.0, 1.0>, < 2.0, 0.0, 1.0>, < 3.0, 0.0, 1.0>,  
       < 0.0, 0.0, 0.0>, < 1.0, 0.0, 0.0>, < 2.0, 0.0, 0.0>, < 3.0, 0.0, 0.0>  }
        
    bicubic_patch { type 1 flatness 0.0001  u_steps 5  v_steps 5
     
       < 0.0, 0.0, -0.0>, < 1.0, 0.0, -0.0>, < 2.0, 0.0, -0.0>, < 3.0, 0.0, -0.0>,  
       < 0.0, 0.0, -1.0>, < 1.0, 0.0, -1.0>, < 2.0, 0.0, -1.0>, < 3.0, 0.0, -1.0>,  
       < 0.0, 0.0, -2.0>, < 1.0, 0.0, -2.0>, < 2.0, 0.0, -2.0>, < 3.0, 0.2, -2.0>,  
       < 0.0, 0.0, -3.0>, < 1.0, 0.1, -3.0>, < 2.0, 0.0, -3.0>, < 3.0, 0.0, -3.0> }
      
    texture{ pigment { rgb <1, 1, 0.9>*.85} 
          normal {
        bumps   0.125 turbulence .1
        scale <.25,.2,.25>/12 
      }
    }    
             
    texture{
      pigment {
        image_map {
//          tga "sketch.tga"
          gif "sketch.gif"
          interpolate 2
          once
          filter 255 1.0
        } 
      } 
      rotate<90,0,0>
      translate<-.0625,0,-.5> 
      scale <3,1,4.5>    }   
      finish{ambient -.375 roughness 0.2}      
  
      normal {
        bumps   0.1875 turbulence .1
        scale <.25,.2,.25>/12 
      }
    }  
  

  box{<0,0,0>,<3,-.125,-3> 
     texture{
       pigment { rgb <1, 1, 0.9>*.9}   
       normal {
         bumps -0.95
         scale <5, .0001, .01>
         rotate<-90,0,0>
       }
     }  
  }   
     
  box{<0,-.15625,3>,<3,.03125,3.375> 
     texture{
       pigment {MediumWood*.75}    
     }  
  } 

  box{<0,-.15625,0>,<3,-.125,-3> 
     texture{
       pigment {White*.75}    
     }  
  } 
  
}
//==================================================================
 
#declare labTable=
union{           
  object{paperTablet   
    scale <.75,1,.625>/5   
    rotate<0,20,0>
    translate <.35,30.15625/12,-1.0>
  }  

  #include "pencil.inc"
  object{Pencil rotate<0,135,0> scale .05/4.5 translate <.52,30.25/12,-1.3>}


  object{glassJar scale .55 translate<1.1,30/12,1.6-1> } 
  object{glassJar3  scale .55 translate<-1.375,30/12,1.6-1> } 

  box{<-4,28.5/12,15/12>,<5,30.1/12,16.5/12>  
    texture{
      pigment {
        wood
        turbulence 0.05            // For best results,  keep this low!
        scale <0.2, 0.2, 1>        // Scaled for a unit object
        color_map {
            [0.1 rgb <0.42, 0.26, 0.15>]
            [0.9 rgb <0.52, 0.37, 0.26>]
        }
      }      
      normal{ 
        wood 
        turbulence 0.05 
        scale <0.2, 0.0002, 1>  
      } 
      scale .04 rotate<0,90,0>
      finish {specular 0.5 roughness 0.075}
    }  
  }

  union{ 
    object{scope scale .20 translate<-.7,0,0> rotate<0,-75,0> }   
    object{scopeLamp  scale .9  }
    rotate<0,30,0> 
    translate<.05,30/12,-.75>    
  }  
  
  object{testTubes   rotate<0,60,0> translate<.50,30/12,7/12>}

// add the tiles to the table top
  #declare zz= -18;
  #declare xx= -30;
  #while (zz < 30-12)
    #while (xx < 24)  
      superellipsoid { <.1, .075> 
        scale<2.9375,.125,2.9375>/12
        translate<0,-.125,0>/12
        texture{
          pigment{SteelBlue*3}
          finish  {
            ambient 0.1
            diffuse 0.1
            reflection 0.1
            specular 0.6
            roughness 0.003
          }
          normal {bumps 0.2 turbulence .1 scale <.0025,.002,.0025>}
        }  
        translate<xx,30,zz>/12
      }   
      #declare xx = xx + 6;
    #end  
    #declare xx= -30;
    #declare zz=zz + 6;
  #end 
  box{<-30,29.96875,-24>/12,<30,29.875,24-12>/12 pigment{White*.7}}
}  
//=============================================================================

object{labTable}


// add the back wall  
box{<-15,-100,15><15,8,16>      
  texture{
    pigment{LightWood}    
 
    finish{ambient .2 crand .2}
      normal{
      crackle .2
      scale <0.4,.4,.4>*.75
      turbulence .2
    }
  }
}



   
   

