#version 3.1
        
//#declare notIncludeFile=false;        
//#declare useGlassTextures = false;  



//==============================================================

#if (notIncludeFile)         
//  #declare useGlassTextures = true;  

  #include "colors.inc"
  #include "textures.inc"
  #include "metals.inc"
  
  global_settings
  {
    assumed_gamma 2.2  
     max_trace_level 40
  }
  
  // ----------------------------------------
  camera
  {
    location  <0.0, 6.5, -20>/4
    direction 1.5*z
    right     4/3*x
    look_at   <0.0, 4,  0.0>/4
  } 
  
  
    sky_sphere{  
      pigment{Bright_Blue_Sky scale 1} 
    //  pigment{White*.17}
    } 
 
  light_source
  {
    0*x // light's position (translated below)
    color red 1.0  green 1.0  blue 1.0  // light's color
    translate <-20, 30, -30> *25
  }
  
  // ----------------------------------------
  //plane { y, -.5 pigment {color rgb <0.7,0.5,0.3>}}
#end  

#declare redFluid = 
#if (useGlassTextures)
  texture {
    pigment {color rgbft <.99,.7,.7,.95,.05>}
//    pigment {color rgbf <.99,.7,.7,.95>*.9}
    finish {
      reflection 0.1
//    phong 1.0 

    }
  }
#else
  texture{pigment{White.8} finish{ambient 1}}
#end

 
#declare lidTexture=
texture{
  T_Silver_2A  
  finish{roughness .05}
  normal {
    bumps .03  
 //   scale .0002
    scale <.0002, .00002,.00002>
  }  
}
       




 
 
#declare  yellowFluid= 
#if (useGlassTextures)
  texture {
   pigment {color rgbft <.99,.99,.5+.2,.95,.05>}
    finish {
      reflection 0.1
    }
  }
#else
  texture{pigment{White.8} finish{ambient 1}}
#end


    
#declare brain=    
difference{              
  union{
    sphere { <-4, 0, 0>, 23}
    sphere { <4, 0, 0>, 25}
  }  
  torus{25,1 rotate<0,0,90>}
  pigment {White*.8}
  finish{crand .005}

   normal {
      bump_map {
//         gif "c:\pov-ra~1\include\plasma2.gif"
         gif "plasma2.gif"
         bump_size 18
         interpolate 2  
         once
      }
      scale <50,50,50>              /* scaled and translated into position  */
      translate <-25, -25, 0>
   }
//   finish {ambient 0.2 diffuse 0.7 specular 0.6}   
   scale<.5,1,1>*.9
}
  
  
#declare jarGlass=   
#if (useGlassTextures)
  texture {

    pigment { 
      rgbft <0.98, .98, 0.98, 0.995,.1> }
    finish {
        ambient 0.1
        diffuse 0.1
        reflection 0.1
   //     refraction 0.9
        specular .7
       roughness .002

    } 
  } 
#else
  texture{pigment{White*.75}  finish{ambient .5}}
#end  


#declare jarGlass2 =
#if (useGlassTextures)
  texture {
      pigment { rgbft <0.92, 0.95, 0.92, 0.95,.1>}
      finish {
          ambient 0.1
          diffuse 0.1
          reflection .10
          ior 1.5
          specular .9
          roughness .01
      }
  }
#else
  texture{pigment{White*.75}  finish{ambient .5}}
#end  
    
    
#declare thick=.06 
#declare glassJar=
union{              


  object{brain  scale <.12,.12,.06> rotate<0,35,0> rotate<0,0,-38> translate<0,2,0> }
  union{
    difference{
      torus{2.5,.25}
      torus{2.5,.25-thick}  
      cylinder{<0,-2,0>,<0,2,0>,2.5}
      box{<-10,0,10>,<10,3,-10>}
    } 
    cylinder{<0,-.25,0>,<0,-.25+thick,0>,2.5} 
    difference{
      cylinder{<0,0,0>,<0,.75,0>,2.75}
      cylinder{<0,3,0>,<0,-2,0>,2.75-thick}   
    }  

    texture{lidTexture}  
  }
  

  difference{
    cylinder{<0,0,0>,<0,6,0>,2.75-thick}
    cylinder{<0,-3,0>,<0,10,0>,2.75-thick-thick}  
     interior { ior 1.3  } 
    texture{jarGlass2} 
  } 
  cylinder{<0,0,0>,<0,4.75,0>,2.75-thick-thick
    interior { ior 1.15  } 
    texture{redFluid} 
  }  

   
  union{ 
    difference{
      cylinder{<0,5.55,0>,<0,6,0>,2.75}
      cylinder{<0,3,0>,<0,10,0>,2.75-thick}   
    }  
    
    difference{
      sphere{<0,0,0>,2.75}
      sphere{<0,0,0>,2.75-thick}
      box{<-8,0,8>,<8,-8,-8>} 
      scale<1,.2,1>
     translate<0,6,0> 
    }   
    sphere{<0,7.0,0>,.5 }
    
    texture{lidTexture}            
  }  
  translate<0,.5,0>
  scale 1/4
}
                 
#declare glassJar3=
union{              
  union{
    difference{
      torus{1.5,.25}
      torus{1.5,.25-thick}  
      cylinder{<0,-2,0>,<0,2,0>,1.5}
      box{<-10,0,10>,<10,3,-10>} 
    } 
    cylinder{<0,-.25,0>,<0,-.25+thick,0>,1.5} 
    difference{
      cylinder{<0,0,0>,<0,.5,0>,1.75}
      cylinder{<0,3,0>,<0,-2,0>,1.75-thick}   
    }  
    texture{lidTexture}
  }
  

  difference{
    cylinder{<0,0,0>,<0,6,0>,1.75-thick}
    cylinder{<0,-3,0>,<0,10,0>,1.75-thick-thick}  
     interior { ior 1.5  } 
    texture{jarGlass2} 
  } 
  cylinder{<0,0,0>,<0,4,0>,1.75-thick-thick
    interior { ior 1.15  } 
    texture{yellowFluid}
  }  

   
  union{ 
    difference{
      cylinder{<0,5.65,0>,<0,6,0>,1.75}
      cylinder{<0,3,0>,<0,10,0>,1.75-thick}   
    }  
    
    difference{
      sphere{<0,0,0>,1.75}
      sphere{<0,0,0>,1.75-thick}
      box{<-8,0,8>,<8,-8,-8>} 
      scale<1,.2,1>
     translate<0,6,0> 
    }   
    sphere{<0,6.67,0>,.35 }
    texture{lidTexture} 
  }  
  translate<0,.5,0>
  scale 1/4
}
                 
#declare glassJar2=
union{              
  union{
    difference{
      torus{2.5,.25}
      torus{2.5,.25-thick}  
      cylinder{<0,-2,0>,<0,2,0>,2.5}
      box{<-10,0,10>,<10,3,-10>} 
    } 
    cylinder{<0,-.25,0>,<0,-.25+thick,0>,2.5} 
    difference{
      cylinder{<0,0,0>,<0,.75,0>,2.75}
      cylinder{<0,3,0>,<0,-2,0>,2.75-thick}   
    }  
      
     texture{T_Silver_2B
       finish{roughness .05}
     }
  }
  

  difference{
    cylinder{<0,0,0>,<0,6,0>,2.75-thick}
    cylinder{<0,-3,0>,<0,10,0>,2.75-thick-thick}  
     interior { ior 1.5  } 
    texture{jarGlass2} 
  } 
  cylinder{<0,0,0>,<0,4,0>,2.75-thick-thick
    interior { ior 1.15  } 
    texture{yellowFluid}
  }  

   
  union{ 
    difference{
      cylinder{<0,5.55,0>,<0,6,0>,2.75}
      cylinder{<0,3,0>,<0,10,0>,2.75-thick}   
    }  
    
    difference{
      sphere{<0,0,0>,2.75}
      sphere{<0,0,0>,2.75-thick}
      box{<-8,0,8>,<8,-8,-8>} 
      scale<1,.2,1>
     translate<0,6,0> 
    }   
    sphere{<0,7.0,0>,.5 }
    texture{T_Silver_2B}
  }  
  translate<0,.5,0>
  scale 1/4
}
                 
#if (notIncludeFile)                         
  //glassJar 
  union{
    object{glassJar}
    box{<-1,0,-1>,<1,-.001,1> pigment{Red}}   
    rotate<0,0,0> 
  }  
#end  
  
  
       
    
    