// Persistence of Vision Ray Tracer Scene Description File
// Vers: 3.1
// Date: 10/6/2000
// Auth: Bob Franke

// a copy of an English, 4th quarter 19th century, paraffin oil 
// microscope lamp by WATSON & SONS, 313 High Holborn, LONDON.



//#declare notIncludeFile = true
//#declare notIncludeFile = false   
//#declare useGlassTextures = true;  

#if (notIncludeFile) 
  #version 3.1  
  #include "colors.inc"
  #include "textures.inc"
  #include "metals.inc"
  
  global_settings{
    assumed_gamma 2.2  
    max_trace_level 50
  }

  // --------------------------------------------------------
  camera{
    location  <0.0, 6/12, -2>
    direction 1.5*z
    right     4/3*x
    look_at   <0.0, 6.5/12,  0.0>
  }
  
  sky_sphere{  
  //  pigment{Bright_Blue_Sky scale 1} 
    pigment{White*.25}
  }     
  
  light_source{<-30, 30, -30>*100  color White*1 }
  //light_source{<-20, 30, -30>*100  color White media_interaction off}
  //light_source{<30, -30, -30>*100  color White media_interaction off}
  
  // ----------------------------------------
  //plane { y, 0 pigment {color rgb <0.7,0.5,0.3>}} 
#end

  
#declare Density1=
density {
  spherical
  ramp_wave
  color_map {
    [0.0 color rgb <0.0, 0.0, 0.0>]
    [0.55 color rgb <1.0, .5, 0.0*.5>]
    [0.75 color rgb <1.0, .75, 0.0>*.5]
    [1.0 color rgb <1.0, 1.0, 0.1*.5>]
  } 
}

#declare lampMetal=
texture{
  T_Brass_3C                  
  finish {roughness .1}
}

#declare lampMetal2=
texture{
  T_Brass_3C                 
  finish { ambient .4 roughness .1}    
}
          
          
#declare yellowWhiteFinish=  
  finish{
    ambient 0.25
    reflection .25
    specular .95
    roughness .1
  }   
  
#declare innerShadeFinish=  
  finish{
    ambient 0.15
    reflection .1
    specular 1
    roughness .001
  }


#declare YellowWhite_Glass=
texture { 
  pigment { rgbf <1, 1, 0.8, 0.001>*.99}
    finish {yellowWhiteFinish}
} 

#declare innerShadeGlass=
texture { 
  pigment { rgbf <1, 1, 0.8, 0.001>*.85}
  finish {innerShadeFinish}
} 


#declare fuelTexture = 
#if (useGlassTextures)
  texture {
    pigment {color rgbft <.98,.98,.5+.2,.95,.2>*.85}
    finish {
      reflection 0.2
      phong 1.0
    }
  }
#else
  texture{pigment{White.8} finish{ambient 1}}
#end


#declare glass= 
#if (useGlassTextures)
  texture {
    pigment { rgbf <0.88, .88, 0.88, 0.98> }
    finish {
      ambient 0.1
      diffuse 0.1
      reflection .25
      specular .9
      roughness .02
    }
  }
#else
  texture{pigment{White*.75}  finish{ambient .5}}
#end  
// --------------------------------------------------------
#declare bottleGlass= 
#if (useGlassTextures)
  texture {
//    pigment { rgbf <0.88, .88, 0.88, 0.99> }
    pigment { rgbf <0.92, .92, 0.92, 0.99> }
    finish {
      ambient 0.1
      diffuse 0.1
      reflection .125
      specular 1
      roughness .006
    }
  }
#else
  texture{pigment{White*.75}  finish{ambient .5}}
#end  
// --------------------------------------------------------

#declare stack =
object{
  lathe {
    cubic_spline
    14,
    <0.75, 0.000000>,
    <0.75, 0.000000>,
    <0.75, 0.5>,
    <1.25, 1.25>,
    <1.25, 3.5> 
    <0.75, 5.5> 

    <0.75,      7.5>,
    <0.75-.02,  7.5>,

    <0.75-.02, 5.5> 
    <1.25-.02, 3.5> 
    <1.25-.02, 1.25>,
    <0.75-.02, .5> 
    <0.75-.02, 0.00> 
    <0.75-.02, 0.00> 
    #if (useGlassTextures)
      interior { ior 1.5}
    #end  
    
    texture {
      glass   
//      finish {specular .8 roughness .01+.01 } 
      finish {reflection .2  specular 1 roughness .04 } 
    }
  }
}   
// --------------------------------------------------------

#declare shade=
union{
  difference{ 
    union{   
      difference{
        cylinder{<0,6,0>/12,<0,12,0>/12, 1.8125/12 }
        cylinder{<0,3,0>/12,<0,14,0>/12, 1.78125/12  } 
        texture{YellowWhite_Glass}
      }    
      difference{
        cylinder{<0,6,0>/12,<0,10,0>/12, 1.78125/12 }
        cylinder{<0,3,0>/12,<0,14,0>/12, 1.750/12  } 
        texture{innerShadeGlass}
      }    

      difference{  
        cylinder{<0,11.75,0>/12,<0,11.6,0>/12, 1.8126/12}
        cylinder{<0,12,0>/12,<0,11,0>/12, 1.8125/12}
        pigment{Red} 
        finish {yellowWhiteFinish} 
      }  
      difference{
        cylinder{<0,6.25,0>/12,<0,6.4,0>/12, 1.8126/12 }
        cylinder{<0,6.0,0>/12,<0,6.9,0>/12, 1.8125/12 }
        pigment{Red} 
        finish {yellowWhiteFinish}
      }

      difference{
        torus{1.8125/12, 0.09/12 }
        cylinder{<0,-2.0,0>/12,<0,2,0>/12, 1.8125/12 }
        translate<0,9.25,0>/12
        texture{YellowWhite_Glass}
      } 
    }  
  
    cylinder{<0,7.75,-10>/12,<0,7.75,0>/12, 1/12  } 
    box{<-1,0,-10>/12,<1,7.75,0>/12}
  }

  difference{  
    cylinder{<0,9.125,0>/12,<0,8.875,0>/12, 1.86/12  }   
    cylinder{<0,10,0>/12,<0,8,0>/12, 1.8125/12  }   
    texture{lampMetal} 
  } 
}    
// --------------------------------------------------------

#declare bottle = 
union{
  object{
    lathe {
      cubic_spline   
      16,
      <1.5, 0.000000>,
      <1.5, 0.000000>,
      <1.5,      1.0>,
      <1.5,      2.75>,
      <1.38,     3.5>,
      <1.25,     3.75>,
      <1.0,      4.0>,
      <1.0,      4.5>,
      <1.0-.03,  4.5>,
      <1.0-.03,  4.0>,
      <1.25-.03, 3.75>,
      <1.38-.03, 3.5>,
      <1.5-.03,  2.75>,
      <1.5-.03,  1.0>,
      <1.5-.03,  0.0>  
      <1.5-.03,  0.0>  
    }  
    texture {bottleGlass}
  }
  cylinder{<0,0,0>,<0,2.5,0>, 1.47     
    #if (useGlassTextures)
      interior { ior 1.3  }  
    #end  
    texture{fuelTexture}
  }
}
// --------------------------------------------------------


#declare wickAndFlame=
  light_source{<0,7.25,-.03>/12  
//    color rgb <1,1,.8>*1.5    
    color rgb <1,1,.8>*1.25*.75      
    fade_distance .8
    fade_power 3

    area_light
      <.012, 0, 0> <0, 0, .012> // lights spread out across this distance (x * z)
      4, 4                      // total number of lights in grid (4x*4z = 16 lights)
      adaptive 2                // 0,1,2,3... 
      jitter                    // adds random softening of light

  /*
    media_interaction off  

    
    looks_like{
      sphere { 0, 1
        pigment { color rgbf<1, 1, 1, 1> }
        finish { ambient 0 diffuse 0 }
        interior { 
          media {
            emission 0.05*20000
            intervals 5+20
            samples 1, 10
            confidence 0.9999
            variance 1/1000
            density {
              Density1        
            }
          } 
        }
        scale<1,1.5,.10>/35
        no_shadow
        hollow 
        translate<0,-0.6875/12,0>  
        rotate<0,45,0> 
      } 
    }
    
 */   
  
  }
// --------------------------------------------------------

#declare knob2=
union{   
  cylinder{<0,0,0>,<-.1,0,0>, .42 texture{T_Silver_2C} }
  cylinder{<0,0,0>,<-2,0,0>, .05 texture{T_Silver_2C} }
  difference{
    cylinder{<0,0,0>,<-.1,0,0>, .45  } 
    cylinder{<-2,0,0>,<1,0,0>, .42  }
    texture{
    //  lampMetal
      T_Silver_2C
      normal {
        bumps -0.95
        scale <4, .0003, .5>
      }  
    }    
  }
}   
// --------------------------------------------------------   

#declare thick=.06  
#declare wick=
prism {
  cubic_spline    
  linear_sweep  
  0,
  0.5
  30,


  <0.0, 0.0>,
  <0.0, 0.0>, 
  <0.0, 0.05>,
  <0.0, 0.07>,
  <0.93, 0.07>,
  <1.23, 0.33>, 
  <1.55, 0.4>, 
 <2.00, 0.75>, 
  <2.50, 0.9>, 
  <2.90, 0.54>, 
  <3.00, 0.25>, 
  <2.80, -0.35>, 
  <2.25, -0.6>, 
  <2.0, -0.5>,  
  
  <2.0,  -0.5+thick>,  
  <2.25, -0.6+thick>, 
  <2.80, -0.35+thick>,
  <3.00, 0.25-thick>, 
  <2.90, 0.54-thick>, 
  <2.50, 0.9-thick>,
  <1.55, 0.4-thick>, 
  <2.00, 0.75-thick>,    
  <1.55, 0.4-thick>, 
  <1.23, 0.33-thick>, 
  <0.93, 0.07-thick>,
  <0.0, 0.07-thick>,
  <0.0, 0.05-thick>,
  <0.0, 0.0-thick>, 
  <0.0, 0.0> 
  <0.0, 0.0> 

  sturm
  texture {
    normal { quilted 1 scale <.2,.2,.1>*.3 }
    pigment { White*1.5 }
    finish {
      crand .05   
    }
  }    
  rotate<-90,0,-90>
} 
//--------------------------------------------------------------------------



#declare bottleTop=
union{       
  object{knob2 scale 1/20 rotate<0,90,0> translate<0,.92,-1.3125>/12 
//     rotate<0,15,0>
  }
  object{wick  rotate<0,-150,0> translate<.25,.5,0> scale <.07,.1,.1> }  

  cylinder{<0,0,0>,<0,.5,0>/12, 1.03125/12} 
  torus{1.03125/12, 0.07/12 rotate<0,0,3> translate<0,.125,0>/12 }
  torus{1.03125/12, 0.07/12  rotate<0,0,3> translate<0,.3125,0>/12 } 
  torus{1.03125/12, 0.04/12 translate<0,0.5-.04,0>/12}
  
  cone { <0,.5,0>/12, 1.03125/12, <0,.8125,0>/12, .67/12 }
  cylinder{<0,.8125,0>/12,<0,1.0,0>/12, .67/12}
    
  difference{
    cylinder{<0,1,0>/12,<0,1.188,0>/12, .73/12}
    cylinder{<0,0,0>/12,<0,2,0>/12, .7/12}
      
    #declare yy=0;  
    #while (yy < 360)  
      box{<-.03,-.06+1.1,0>/12,<.03,.06+1.1,-2>/12 rotate<0,yy,0>}
      #declare yy=yy+10;
    #end                                   
  }
  
  difference{
    cylinder{<0,1.188,0>/12,<0,1.4,0>/12, .8125/12}
    cylinder{<0,1.188+.03125,0>/12,<0,2,0>/12, .78125/12}
  }   
  
  difference{
    cylinder{<0,1.188,0>/12,<0,1.65,0>/12, .5/12}
    cylinder{<0,1.0,0>/12,<0,1.8,0>/12, .46875/12}
  }  
     
  difference{   
    sphere{<0,1.65,0>/12,.5/12}
    sphere{<0,1.65,0>/12,.46845/12}
    box{<-2,1.65,-2>/12,<2,-5,2>/12}
    box{<-.06,1.65,-2>/12,<.06,5,2>/12}
  }   
    
  #declare tab=
  union{                                                  
    cylinder{<0,1.5,.75>/12,<0,1.5,.78125>/12, .12/12}
    box{<-.12,1.5,.75>/12,<.12,1.19,.78125>/12}
    texture{ T_Brass_3C }
  }
      
  #declare yy=0;  
  #while (yy < 360)  
     object{tab rotate<0,yy,0>}
     #declare yy=yy+30;  
  #end   
   texture{ T_Brass_3C}
}  
// --------------------------------------------------------

#declare lampBase=
union{
  union{
    difference{
      torus{2.25/12, 0.5/12}
      box{<-4,.375,-4>/12,<4,2,4>/12} 
      texture{lampMetal2}   
    }  
  
    cylinder{<-2.75+.52,0,0>/12,<-2.75+.52,13,0>/12, .3125/2/12   }
    cylinder{<-2.75+.52,0.5,0>/12,<-2.75+.52,1.25,0>/12, .375/12  }  
    box{<-2.375,.625,-.0625>/12,<-1.56,1.125,.0625>/12 }
    torus{.28125/12, 0.07/12 translate<-2.75+.52,1.25,0>/12 }
    torus{.28125/12, 0.07/12 translate<-2.75+.52,0.5,0>/12 }   
    cylinder{<-2.75+.52,.5,0>/12,<-2.75+.52,1.375,0>/12, .24/12  }
    torus{.28125/12, 0.07/12 translate<-2.75+.52,.34375,0>/12}
     cylinder{<-3.375+.52,.875,0>/12,<-3.34375+.52,.875,0>/12, .25/12  }  
    cylinder{<-3.375+.52,.875,0>/12,<-3+.52,.875,0>/12, .03125/12 }  
  
    cone {<-3.34375+.52,.875,0>/12, .1875/12, <-3.18+.52,.875,0>/12, .09375/12}


    union{
      cylinder{<-2.75+.52,0.5,0>/12,<-2.75+.52,1.25,0>/12, .375/12  }  
      box{<-2.375,.8125,-.0625>/12,<-1.75625,1.0625>/12 }
      torus{.28125/12, 0.07/12 translate<-2.75+.52,1.25,0>/12 }
      torus{.28125/12, 0.07/12 translate<-2.75+.52,0.5,0>/12 }   
      cylinder{<-2.75+.52,.5,0>/12,<-2.75+.52,1.375,0>/12, .24/12  }  
      
      torus{.28125/12, 0.07/12 translate<-2.75+.52,0.5,0>/12 }

      cylinder{<-3.375+.52,.875,0>/12,<-3.34375+.52,.875,0>/12, .25/12  }  
      cylinder{<-3.375+.52,.875,0>/12,<-3+.52,.875,0>/12, .03125/12}  
      cone {<-3.34375+.52,.875,0>/12, .1875/12, <-3.18+.52,.875,0>/12, .09375/12 }
      translate<0,8.25,0>/12
    }  

    difference{
      cylinder{<0,.5,0>/12,<0,2.125,0>/12, 1.59/12  }
      cylinder{<0,.503125,0>/12,<0,5,0>/12, 1.5/12  } 
      texture{lampMetal2 
  //      finish{ reflection 0.1875 ambient 0.4} 
      }   
     }  

    texture{lampMetal2}
  }                        
}
// --------------------------------------------------------
     
#declare scopeLamp=
union{
  object{lampBase rotate<0,160,0>}  
  object{wickAndFlame}
  object{shade}           
  object{bottle scale 1/12 translate<0,.503,0>/12}
  #if (useGlassTextures) object{stack scale 1/12 translate<0,5.75,0>/12} #end
  object{bottleTop translate<0,4.5,0>/12  rotate<0,-45,0>}
} 


#if (notIncludeFile) 
  scopeLamp
#end  

   





