// Persistence of Vision Raytracer 3.1
// Standard textures include file
// See textures.doc for info.

#declare Pencil_Inc_Temp = version

#include "colors.inc"
#include "textures.inc"
#include "shapes.inc"
#include "shapes2.inc"


#declare body=
object{ Hexagon
texture {
//  pigment {color red .9 green 0.45 blue 0.0 } 
  pigment {color rgb <.97,.61,.09>}

  finish {
    ambient 0.2
    diffuse 0.6
    specular 0.8
    roughness 0.01
  }
} // End Texture
   scale<20,1,1>
   rotate<0,0,0>
}

#declare body2=
object{ Hexagon
         texture { 
           pigment {color rgb <.97,.61,.09>}
                   finish { ambient 0.2
                            diffuse 0.6
                            specular 0.8
                            roughness 0.01 }
                 } // End Texture
         scale<14,1,1>
         rotate<0,0,0>
      }

#declare xcone=
  cone { <3,0,0>,1.15470 // Center and radius of one end
         <11,0,0>,.1     // Center and radius of other end 
         texture{
           pigment {MediumWood }
           finish{ambient .2}
         }   
       }

#declare graphite=
  cone { <10,0,0>,0.231838 // Center and radius of one end
         <11,0,0>,.1       // Center and radius of other end
         texture { pigment { Black }
                   finish { ambient 0.2
                            diffuse 0.75
                            specular 0.65
                            roughness 0.01}
                 } // End Texture
       }

#declare inters=
intersection{ object{body}
              object{xcone}
            }


#declare xx = -25.07
#declare tscale = 1.0

#declare MetalRing =
  torus{ 1.0847,0.07
         texture { Silver1 }
         rotate<0,0,90>
         translate<xx,0.0,0.0>
       }

#declare PencilEnd =
  union{ object {MetalRing scale tscale }
         object {MetalRing translate<-0.14,0.0,0.0> scale tscale}
         object {MetalRing translate<-0.28,0.0,0.0> scale tscale}
         object {MetalRing translate<-0.42,0.0,0.0> scale tscale}
         object {MetalRing translate<-0.56,0.0,0.0> scale tscale}

         cylinder { <-25.7,0.0,0.0>,<-26.0,0.0,0.0>, 1.118
                   texture { pigment {NavyBlue}
                             finish { Shiny}
                            } // End Texture
                   scale tscale
                  }

         object {MetalRing translate<-1.0,0.0,0.0> scale tscale}
         object {MetalRing translate<-1.14,0.0,0.0> scale tscale}
         object {MetalRing translate<-1.28,0.0,0.0> scale tscale}
         object {MetalRing translate<-1.42,0.0,0.0> scale tscale}
         object {MetalRing translate<-1.56,0.0,0.0> scale tscale}

         cylinder { <-26.7,0.0,0.0>,<-27.1,0.0,0.0>, 1.118
                    texture { pigment {Brown}
                              finish { crand 0.2}
                            } // End Texture
                    scale tscale
                  }

         sphere { <-27.1,0.0,0.0>, 1.118
                  texture { pigment {Brown}
                            finish { crand 0.1}
                          } // End Texture
                 }
     bounded_by{ box{<-25.0,-1.1548,-1.1547>,<-28.219,1.1548,1.1548>}}
}

#declare Pencil=
union{ object{inters}
       object{graphite}
       object{body2 translate<-11,0,0>}
       object{PencilEnd}
     }


