// Persistence of Vision Ray Tracer Scene Description File
// Vers: 3.1
// Date: 10/6/2000
// Auth: Bob Franke

// A copy of a lacquered - brass monocular microscopeE 
// by Schiek in Berlin, ca. 1860

//#declare notIncludeFile = true
//#declare notIncludeFile = false   
//#declare useGlassTextures = true;  


#if (notIncludeFile) 
  global_settings { 
    assumed_gamma 2.2 
    max_trace_level 70 
 }
  
  #include "colors.inc"
  #include "textures.inc"
  #include "metals.inc"
  
  camera {
    location <0, 4.5, -7>
    look_at <0, 2.75, 0>
  }
  
  light_source { <90, 20, -60> colour White*1}
  light_source { <-90, 30, -60> colour White*.25  shadowless}
  
//  light_source { <-90, 100, -60>/120 colour White
  light_source { <-90, 100, -60>/120 colour White
      spotlight
      point_at <0,0,0>
      radius 1
      falloff 25
      scale 12-2
  }
  
  background { color SkyBlue*.01 }
  
  plane { y, 0
     pigment { rgb <0.75, 0.5, 1.0> }
     finish {
        ambient 0.2
        diffuse 0.8
     }
  }
#end
//--------------------------------------------------------------------    

#declare tmirror = 
texture {
    pigment { rgb <1,1,1>*.15 }
    finish {
        reflection 0.95
        roughness 0.01
    }
}    
    
#declare scopeMetal=
texture{
  T_Brass_3C                 
    finish { ambient 0.25+.15 roughness .1}
} 
#declare scopeMetal2=
texture{
  T_Brass_3B                 
    finish {ambient 0.30+.15 roughness .1}
} 

#declare slideGlass=
  texture {
    pigment { rgbf <0.99, .99, 0.99, 0.9> }
    finish {
        ambient 0.2
        diffuse 0.1
        reflection .25
        ior 1.5
        specular .8
        roughness .05
    }
  }

#declare topTube =
union{
  cylinder{<0,1.25,0>,<0,1.78125,0>,.57/2 
    texture{
      scopeMetal
      normal {
        bumps -0.5
        scale <.001, 1, 0.0005>
      }  
    }
  }
  lathe {
    cubic_spline
    19,
    <0.79/2, 0.000000>,
    <0.79/2, 0.000000>,
    <0.69/2, 0.07>,
    <0.67/2, 0.19>,
    <0.625/2, 0.25>,
    <0.625/2, 1.25>,
    <0.5625/2, 1.25>,
    <0.5625/2, 1.71875>,  
    <0.75/2, 1.75>,
    <0.75/2, 1.78125>,
    <0.625/2, 1.8125>,
    <0.625/2, 1.97>,
    <0.75/2, 2.00>,
    <0.75/2, 2.03>,
    <0.625/2, 2.06>,
    <0.625/2, 2.37>,
    <0.72/2, 2.465>,
    <0.72/2, 2.5>,
    <0.72/2, 2.5>
    texture{scopeMetal }
  } 
}   
 
 
#declare mirror=
union{  
  union{
    difference{
      cylinder{<0,0.9375,-.09375>,<0,0.9375,.09375>, 0.6875}
      cylinder{<0,0.9375,-.225>,<0,0.9375,.225>, 0.6875-.03125}
      box{<-1,.9375,-1>,<1,2.5,1>} 
    } 
    box{<0.6875,0.9375,-0.09375>,<0.6875-.03125,1.0625,0.09375>}
    box{<-0.6875,0.9375,-0.09375>,<-0.6875+.03125,1.0625,0.09375>} 
    sphere{<-.6675,.9375,0>,.05}
    sphere{<.6675,.9375,0>,.05 }
    texture{T_Brass_3C}
  }  
  
  union{
    difference{
      cylinder{<0,-.0625,0>,<0,.0625,0>,0.625  } 
      cylinder{<0,-.03125,0>,<0,.09375,0>,0.59375}
      texture{scopeMetal2}
    }  
   
    difference{
      cylinder{<0,-.03125,0>,<0,.09375,0>,0.59375  pigment{White*.4} }
      sphere{<0,4.052,0>,4 texture{tmirror}} 
     
    }  
    rotate<-30,0,0>
    translate<0,.9375,0>
  }
}  

#declare screw=
difference{
  sphere{<0,0,0>, 0.125}  
  box{<-.008,.03,-1>,<.008,1,1>} 
  scale<1,.5,1>*.5
  texture{T_Silver_2C}
}
 
#declare slideClip= 
prism {
  cubic_spline    
  linear_sweep  
  0,
  0.375
  14,

  <0.0, 0.0>,
  <0.0, 0.0>, 
  <0.8, 0.0>,
  <2.2, 0.10>,
  <3.4, 0.0>,
  <3.9, 0.1>, 
  <3.9, 0.15>, 
  

  <3.9, 0.15>,
  <3.4, 0.05>,
  <2.2, 0.15>,
  <0.8, 0.05>,
 
  < 0.0, 0.05>,
  <0.0, 0.0>,
  <0.0, 0.0> 
  sturm
  texture{   
  T_Silver_2B
  }
  rotate<-90,0,0>
} 

#declare plate1=
prism {
  cubic_spline    
  linear_sweep  
  3,
  3-.1875,
  15,

  < 0.5, 0>,
  < 0.5, 0>, 
  < 0.375, .35>, 
  < 0.0, .5> 
  <-.7, .22> 
  <-1, .25>   
  <-1.2, .14> 
  <-1.25, 0> 
  <-1.2, -.14> 
  <-1, -.25>  
  <-.7, -.22> 
  < 0.0, -.5> 
  < 0.375, -.35>, 
  < 0.5, 0>,
  < 0.5, 0>
  sturm
  texture{scopeMetal }
}   

#declare knob=
union{   
  cylinder{<0,0,0>,<-.1,0,0>, .42 texture{T_Brass_3C} }
  cylinder{<0,0,0>,<.4,0,0>, .05 texture{T_Brass_3C} }
  difference{
    cylinder{<0,0,0>,<-.1,0,0>, .45  } 
    cylinder{<-2,0,0>,<1,0,0>, .42  }
    texture{scopeMetal
      normal {
        bumps -0.95
        scale <4, .0006, .5>
      }  
    }    
  }
}


#declare scope=
  union{
  cylinder{<0,2.8125,0>,<0,2.6875,0>, 0.375
    texture{scopeMetal
      normal {
        bumps -0.95
        scale <.0005, 2, .5>
      }  
    }
  }
                                               
  cylinder{<0,2.65625,0>,<0,2.6875,0>,0.38 texture{scopeMetal}}                                          
  cylinder{<0,2.65625,0>,<0,2.35,0>,0.2 texture{scopeMetal}} 
  cylinder{<0,2.55,0>,<0,2.45,0>,0.212 
    texture{scopeMetal
      normal {
        bumps -0.95
        scale <.0005, 2, .5>
      }  
    }  
  }  
  
  cone{<0,2.35,0>, 0.2 <0,2.25,0>, 0.15 texture{scopeMetal}}                                         
  
  object{topTube translate<0,3,0> }   
  object{knob scale .5 translate <-1.3125,1.125,0>}
  object{knob scale .375 translate <-1.30,1.885,0>}
  object{plate1}  
  object{mirror translate<0,.055,0> rotate<0,-90,0> scale.8}
  
  cylinder{<-1.0,0,0>,<-1.0,3,0>.1875 texture{scopeMetal}}
  cylinder{<-1.0,0,0>,<-1.0,1.5,0>.1875+.018 texture{scopeMetal}}
  
  superellipsoid { <.35, .15> 
    rotate<90,0,0>  
    scale<1.3,.25/2,.8>
    translate<-.125,.25/2,0>
    texture{scopeMetal2 }
  }   


  difference{
    superellipsoid { <.35, .15> 
      rotate<90,0,0>  
      scale<1.0,.15625/2,.75>
    }
    cylinder{<.25,2,0>,<.25,-2,0>,.3125}
     
    translate<-.25,1.875,0>
    texture{scopeMetal2 }
  } 
      
      
  union{    
    box{<-.3125,0,.875>,<.3125,0.05,-1> texture{slideGlass} }
    cylinder{<0,0,0>,<0,0.0502,0>,.3125
      texture{
        slideGlass
        finish {ambient 0.25 roughness .2}
      }
    }
     translate<0,1.9525,0>
  }                  
  
  
  // create a point "spotlight" (cylindrical directed) light source
light_source
{
  <0,1.5,0 >               // light's position (translated below)
  color rgb <1,1,1>*.65      // light's color   
      fade_distance .35
    fade_power 2 

  spotlight               // this kind of light source
  cylinder                // this variation
  point_at <0,2.5,0>      // direction of spotlight
  radius .125              // hotspot (inner, in degrees)
  tightness 5           // tightness of falloff (1...100) lower is softer, higher is tighter
  falloff .25              // intensity falloff radius (outer, in degrees)
}

  
  
  
  object{slideClip scale 1/2.5 rotate<0,0,1.25> translate<-.9375+.02,1.94875,-.48>}  
  object{screw rotate<0,30,0> translate<-.82+.02,1.94875+.02,-.55> }
  object{slideClip scale 1/2.5  rotate<0,0,1.25> translate<-.9375+.02,1.94875,.65>}
  object{screw rotate<0,-45,0> translate<-.82+.02,1.94875+.02,.57> }


  torus{0.1875,0.0625 texture{scopeMetal } translate<-1,.25,0> }
  
  cone{ <-1,.0625+.25,0>, .26
        <-1,.25+.25,0>, .20  
        texture{scopeMetal }
  }
}


#if (notIncludeFile) 
  object{scope rotate<0,15,0>}
#end  





