// Persistence of Vision Ray Tracer Scene Description File
// Vers: 3.1
// Date: 10/6/2000
// Auth: Bob Franke

// A wood rack of test tubes


#version 3.1
    
//#declare notIncludeFile = true


#if (notIncludeFile)    
  #include "colors.inc"
  #include "textures.inc" 
  #include "metals.inc"
    
  global_settings{
    assumed_gamma 2.2 
    max_trace_level 40
  }
     
     
  // ----------------------------------------
  camera{
    location  <-0/12,8/12, -2>
    direction 1.5*z
    right     4/3*x
    look_at   <-0/12,2/12,  0.0>
  }
  
  sky_sphere{  
    pigment{Bright_Blue_Sky scale 1} 
  //  pigment{White*.17}
  } 
  
  light_source{
    0*x // light's position (translated below)
    color White
    translate <-30, 30, -60>
  }
  
  light_source{
    0*x // light's position (translated below)
    color White
    translate <30, 30, -60>
  }
  
  // ----------------------------------------
  //plane { y, 0 pigment {color rgb <0.7,0.5,0.3>}}  
#end
//-----------------------------------------------------

#declare tubeGlass=   
#if (useGlassTextures)
  texture {
    pigment { rgbf <0.8, .8, 0.8, 0.98> }
    finish {
        ambient 0.2+.03
        diffuse 0.4
        reflection .2
        specular .8
        roughness .04
    }
  } 
#else
  texture{pigment{White*.75}  finish{ambient .5}}
#end  
 
   
#declare thick=.03
#declare testTube=
merge{ 
  difference{
    merge{
      sphere{<0,0,0>, 0.3125/12}
      cylinder{<0,0,0>,<0,5/12,0>,0.3125/12}
    }
    merge{
      sphere{<0,0,0>, (0.3125-thick)/12}
      cylinder{<0,0,0>,<0,8,0>,(0.3125-thick)/12}
    }
  }  
  torus{0.3125/12,thick/12 translate<0,5/12,0>}  
  #if (useGlassTextures)
    interior { ior 1.3  }  
  #end  
  texture{tubeGlass}
}  

#declare oakMult= 1.5
#declare tubeRackOak =
texture{
  pigment {
      wood
      turbulence 0.05            // For best results,  keep this low!
      scale <0.2, 0.2, 1>        // Scaled for a unit object
      color_map {
          [0.0, 0.1 color rgb <0.42, 0.26, 0.15>*oakMult
                    color rgb <0.42, 0.26, 0.15>*oakMult]
          [0.1, 0.9 color rgb <0.42, 0.26, 0.15>*oakMult
                    color rgb <0.52, 0.37, 0.26>*oakMult]
          [0.9, 1.0 color rgb <0.52, 0.37, 0.26>*oakMult
                    color rgb <0.52, 0.37, 0.26>*oakMult]
      }  
      scale 1/24
  }   
  finish {specular .7 roughness 0.02}
//  finish{Dull}
}  




#declare testTubes=
union{ 
  difference{
    superellipsoid { <.1, .1>  
      scale<3.125,.5,1>  
    } 
    box{<-6,0,-2>,<6,-5,2>}
    #declare xx=-2.25;
    #while (xx < 2.5) 
      sphere{<xx,1.0,0>,.625} 
  //    cylinder{<xx,3,0><xx,6,0>,.375}
      #declare xx = xx + .875;
    #end 
    scale 1/12 
    texture{tubeRackOak rotate<0,89,0> rotate<89,0,0> scale<1,.3,.7> }
  }  
    
  difference{  
    superellipsoid { <.1, .1>  
      scale<3.125,.1875,.75>  
      rotate<0,0,0>
      
    }   
    #declare xx=-2.25;
    #while (xx < 2.5) 
      cylinder{<xx,-2,0><xx,2,0>,.375}
      #declare xx = xx + .875;
    #end    
    scale 1/12
    texture{tubeRackOak rotate<0,89,0> rotate<89,0,0> scale<1,.3,.7> }
    translate<0,4.5,0>/12   
  }          
    

  #declare xx=-2.25;
  #while (xx < 2.5) 
    object{testTube translate<xx,.6875,0>/12}
    #declare xx = xx + .875;
  #end    
        
  difference{      
    superellipsoid { <.15, .05>  
      scale<.1875,2.75,1.05>/12  
      texture{tubeRackOak  rotate<89,0,0>  scale<.15,1,.7> translate<0,0,-.03> }
      translate<-2.94,2.4,0>/12

    } 
    box{<-6,0,-2>,<6,-5,2>}        
  }
  
  
  difference{  
    superellipsoid { <.15, .05>  
      scale<.1875,2.75,1.05>/12  
      texture{tubeRackOak  rotate<89,0,0>  scale<.15,1,.7>  translate<0,0,.06>}
      translate<2.94,2.4,0>/12
    } 
    box{<-6,0,-2>,<6,-5,2>}
  }    
}  

 
#if (notIncludeFile) 
  testTubes
#end 
 
 
     
