//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 2 lights, 22 materials and 90 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.2 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 10/17/2000    (17.10.2000)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam1
  location  <    -26.241,     -25.074,       8.896>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35836,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         40.00000    // Vertical      30.000
  look_at   <      7.555,     -12.110,       5.742>
}

//    Other cameras are commented out.
/*
camera {  //  Camera StdCam
  location  <    -18.781,     -39.548,      15.000>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35836,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         40.00000    // Vertical      30.000
  look_at   <      7.555,     -12.110,       2.324>
}

*/

/*
camera {  //  Camera SpotCam001
  location  <    -14.474,     -44.205,       7.000> // Attached to Spotlight001
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35747,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         39.32011    // Vertical      29.490
  look_at   <    -13.982,     -43.334,       7.000> // Following Spotlight001
}

*/

//
// *******  L I G H T S *******
//

light_source {   // Spotlight Spotlight001
  <0.0, 0.0, 0.0>
  color rgb <1.000, 1.000, 0.643>
  spotlight
    point_at  <0.0, 0.0, -2.000>
    falloff    15.000  // outer radius (in deg)
    radius     13.000  // inner radius
    tightness  0.000
  rotate <90.0, -0.0, -29.469862>
  translate  <-14.473903, -44.205106, 7.0>
}


//
// ********  MATERIALS  *******
//

#include "frog.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare pata_diff = difference {
  torus { // Torus002
    1.5, 0.25  rotate -x*90
    rotate -90.0*x
    translate  -3.024045*z
  }
  box { // Cube038
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.5, 2.0>
    translate  <2.0, 0.0, -3.0>
  }
  box { // Cube039
    <-1, -1, -1>, <1, 1, 1>
    scale <2.0, 0.5, 2.0>
    rotate 10.0*y
    translate  <-1.500272, 0.0, -4.750136>
  }
}
#declare pata1 = union {
  object { pata_diff }
  cylinder { // Cylndr012
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 11.5>
    rotate <180.0, -10.0, 180.0>
    translate  <-1.469275, 0.0, -2.721527>
  }
  material {
    blanco_txt
  }
  translate  -0.3*x
}


#declare CSG002 = merge {
  sphere { // Sphere001
    <0,0,0>,1
    scale 0.25
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 4.0>
  }
}
#declare CSG003 = merge {
  sphere { // Sphere002
    <0,0,0>,1
    scale 0.25
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <0.25, 0.25, 4.2>
  }
  scale 0.95
  translate  0.05*z
}
#declare tubo_ensayo = difference {
  object { CSG002 }
  object { CSG003 }
  material {
    Glass_1
  }
}
#declare Cylndr003 = object {
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    scale <0.3, 0.3, 4.0>
  }
}


#declare Cube010 = object {
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <10.2, 0.2, 0.2>
    translate  20.0*z
  }
}
#declare Cube001 = object {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 0.2, 10.0>
    translate  <-10.0, 0.0, 10.0>
  }
}




//
// ********  OBJECTS  *******
//

#declare frasco = lathe {
  cubic_spline
  10  // control points
  <-2.118856, -0.365505>,
  <0.033959, 0.000447>,
  <1.203441, 0.012265>,
  <1.369991, 0.288561>,
  <1.384786, 1.932724>,
  <1.37533, 3.42604>,
  <1.204892, 3.943291>,
  <0.477396, 4.177637>,
  <0.373548, 4.557194>,
  <0.052726, 4.985702>
  rotate <90,0,90>
  material {
    frascoetiq_mat
  }
}
#declare tapon_suma = union {
  cylinder { // Cylndr015
    <0,0,1>, <0,0,0>, 1 
    scale <0.575, 0.575, 0.1>
    translate  4.3*z
  }
  cone { // Cone003
    <0,0,0>, 0.55, <0,0,1>, 0.5
    scale <1.0, 1.0, 0.05>
    translate  5.0*z
  }
  cylinder { // Cylndr014
    <0,0,1>, <0,0,0>, 1 
    material {
      rosca_mat
    }
    scale <0.55, 0.55, 0.7>
    translate  4.3*z
  }
}
#declare tapon = difference {
  object { tapon_suma }
  cylinder { // Cylndr016
    <0,0,1>, <0,0,0>, 1 
    scale <0.45, 0.45, 0.7>
    translate  4.25*z
  }
  material {
    tapa_txt
  }
  translate  0.008589*z
}
union { // frasco_y_tapon
  object { frasco }
  object { tapon }
  scale 0.7
  translate  <1.550775, -23.356923, 0.6>
}




#declare porta_tizas = difference {
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 0.5, 2.0>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <19.5, 0.5, 1.55>
    translate  <0.0, 0.227479, 0.040621>
  }
  translate  <0.0, -14.58445, 1.68954>
}
#declare marco_pizarra = difference {
  box { // pizarra_verde1
    <-1, -1, -1>, <1, 1, 1>
    scale <20.5, 15.375, 0.205>
  }
  box { // pizarra_verde2
    <-1, -1, -1>, <1, 1, 1>
    scale <19.0, 14.25, 0.3>
  }
}
union { // pizarra
  box { // pizarra_verde
    <-1, -1, -1>, <1, 1, 1>
    material {
      pizarra_frase_mat
    }
    scale <20.0, 15.0, 0.01>
  }
  object { porta_tizas }
  object { marco_pizarra }
  material {
    BallWood
  }
  scale 0.8
  rotate <90.0, 0.0, -90.0>
  translate  <26.968789, -29.51551, 12.059804>
}


union { // taburet
  cylinder { // Cylndr013
    <0,0,1>, <0,0,0>, 1 
    scale 0.8
    translate  -1.863449*z
  }
  object { // pata3->pata1
    pata1
    rotate 120.0*z
  }
  object { // pata2->pata1
    pata1
    rotate -120.0*z
  }
  object { pata1 }
  torus { // Torus001
    4.0, 0.01  rotate -x*90
    translate  0.800496*z
  }
  superellipsoid { // SuperQ001
    <1.0, 0.1>
    scale <4.0, 4.0, 0.875>
  }
  cylinder { // Cylndr011
    <0,0,1>, <0,0,0>, 1 
    material {
      blanco_txt
    }
    scale <0.75, 0.75, 2.0>
    rotate <180.0, 0.0, 180.0>
  }
  material {
    negro_txt
  }
  scale 0.75
  rotate 30.0*z
  translate  <23.245013, 1.383875, -3.333726>
}


union { // platorana
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.005679, -0.012238, -0.018927>, <0.003975, -0.146623, -0.018927>, <0.001704, -0.325803, -0.018927>, <0.000000, -0.460188, -0.018927>, 
      <-0.363852, -0.302969, -0.018927>, <-0.365555, -0.437354, -0.018927>, <0.001704, -0.482149, -0.018927>, <0.000000, -0.616534, -0.018927>, 
      <-0.856630, -0.690573, -0.024496>, <-0.488804, -0.690573, -0.024496>, <-0.367827, -0.825091, -0.024401>, <0.000000, -0.825091, -0.024401>, 
      <-1.226089, -0.981341, -0.018927>, <-0.858262, -0.981341, -0.018927>, <-0.367827, -0.981341, -0.018927>, <0.000000, -0.981341, -0.018927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.574763, -0.000377, -0.018927>, <-0.400631, -0.003935, -0.018927>, <-0.168454, -0.008680, -0.018927>, <0.005679, -0.012238, -0.018927>, 
      <-0.770161, -0.000405, -0.018927>, <-0.596028, -0.003963, -0.018927>, <-0.537984, -0.299411, -0.018927>, <-0.363852, -0.302969, -0.018927>, 
      <-1.030768, -0.000442, -0.024402>, <-1.030768, -0.294704, -0.024402>, <-0.856630, -0.396311, -0.024496>, <-0.856630, -0.690573, -0.024496>, 
      <-1.226089, -0.000470, -0.018927>, <-1.226089, -0.294731, -0.018927>, <-1.226089, -0.687080, -0.018927>, <-1.226089, -0.981341, -0.018927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000631, -0.012238, -0.018927>, <0.366626, -0.305034, -0.018927>, <0.858509, -0.690590, -0.024496>, <1.226089, -0.981341, -0.018927>, 
      <0.000442, -0.146623, -0.018927>, <0.366437, -0.439419, -0.018927>, <0.490683, -0.690590, -0.024496>, <0.858262, -0.981341, -0.018927>, 
      <0.000189, -0.325803, -0.018927>, <0.000189, -0.482149, -0.018927>, <0.367827, -0.825091, -0.024401>, <0.367827, -0.981341, -0.018927>, 
      <0.000000, -0.460188, -0.018927>, <0.000000, -0.616534, -0.018927>, <0.000000, -0.825091, -0.024401>, <0.000000, -0.981341, -0.018927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000631, -0.012238, -0.018927>, <-0.171987, -0.008680, -0.018927>, <-0.402145, -0.003935, -0.018927>, <-0.574763, -0.000377, -0.018927>, 
      <-0.369039, 0.283498, -0.018927>, <-0.541657, 0.287056, -0.018927>, <-0.597543, -0.003963, -0.018927>, <-0.770161, -0.000405, -0.018927>, 
      <-0.858066, 0.682670, -0.024497>, <-0.858066, 0.388409, -0.024497>, <-1.030768, 0.293819, -0.024402>, <-1.030768, -0.000442, -0.024402>, 
      <-1.226089, 0.980402, -0.018927>, <-1.226089, 0.686140, -0.018927>, <-1.226089, 0.293792, -0.018927>, <-1.226089, -0.000470, -0.018927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.459651, -0.018927>, <0.000189, 0.318084, -0.018927>, <0.000442, 0.129329, -0.018927>, <0.000631, -0.012238, -0.018927>, 
      <0.000000, 0.616016, -0.018927>, <0.000189, 0.474449, -0.018927>, <-0.369228, 0.425065, -0.018927>, <-0.369039, 0.283498, -0.018927>, 
      <0.000000, 0.824597, -0.024401>, <-0.367827, 0.824458, -0.024401>, <-0.490240, 0.682810, -0.024497>, <-0.858066, 0.682670, -0.024497>, 
      <0.000000, 0.980866, -0.018927>, <-0.367827, 0.980727, -0.018927>, <-0.858262, 0.980541, -0.018927>, <-1.226089, 0.980402, -0.018927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000630, -0.013535, -0.018927>, <0.000441, 0.128421, -0.018927>, <0.000189, 0.317695, -0.018927>, <0.000000, 0.459651, -0.018927>, 
      <0.368268, 0.284785, -0.018927>, <0.368079, 0.426741, -0.018927>, <0.000189, 0.474060, -0.018927>, <0.000000, 0.616016, -0.018927>, 
      <0.858438, 0.682614, -0.024497>, <0.490611, 0.682614, -0.024497>, <0.367827, 0.824597, -0.024401>, <0.000000, 0.824597, -0.024401>, 
      <1.226089, 0.980866, -0.018927>, <0.858262, 0.980866, -0.018927>, <0.367827, 0.980866, -0.018927>, <0.000000, 0.980866, -0.018927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.574763, -0.000160, -0.018927>, <0.402523, -0.004173, -0.018927>, <0.172870, -0.009523, -0.018927>, <0.000630, -0.013535, -0.018927>, 
      <0.770161, -0.000114, -0.018927>, <0.597921, -0.004126, -0.018927>, <0.540508, 0.288798, -0.018927>, <0.368268, 0.284785, -0.018927>, 
      <1.030768, -0.000052, -0.024402>, <1.030768, 0.294209, -0.024402>, <0.858438, 0.388352, -0.024497>, <0.858438, 0.682614, -0.024497>, 
      <1.226089, -0.000006, -0.018927>, <1.226089, 0.294256, -0.018927>, <1.226089, 0.686604, -0.018927>, <1.226089, 0.980866, -0.018927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.574763, -0.000160, -0.018927>, <0.770161, -0.000114, -0.018927>, <1.030768, -0.000052, -0.024402>, <1.226089, -0.000006, -0.018927>, 
      <0.402523, -0.003783, -0.018927>, <0.597921, -0.003737, -0.018927>, <1.030768, -0.294453, -0.024402>, <1.226089, -0.294407, -0.018927>, 
      <0.172871, -0.008615, -0.018927>, <0.538866, -0.301411, -0.018927>, <0.858509, -0.396190, -0.024496>, <1.226089, -0.686940, -0.018927>, 
      <0.000631, -0.012238, -0.018927>, <0.366626, -0.305034, -0.018927>, <0.858509, -0.690590, -0.024496>, <1.226089, -0.981341, -0.018927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.250000, -1.000473, 0.000000>, <-1.244461, -0.996041, -0.008143>, <-1.234575, -0.988020, -0.018799>, <-1.226089, -0.981341, -0.018927>, 
      <-0.875000, -1.000473, 0.000000>, <-0.869461, -0.996041, -0.008143>, <-0.866749, -0.988020, -0.018799>, <-0.858262, -0.981341, -0.018927>, 
      <-0.375000, -1.000473, 0.000000>, <-0.375000, -0.996613, -0.007091>, <-0.367827, -0.989410, -0.018644>, <-0.367827, -0.981341, -0.018927>, 
      <0.000000, -1.000473, 0.000000>, <0.000000, -0.996613, -0.007091>, <0.000000, -0.989410, -0.018644>, <0.000000, -0.981341, -0.018927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.250000, -0.000473, 0.000000>, <-1.244855, -0.000472, -0.007564>, <-1.235234, -0.000471, -0.018671>, <-1.226089, -0.000470, -0.018927>, 
      <-1.250000, -0.300473, 0.000000>, <-1.244855, -0.300472, -0.007564>, <-1.235234, -0.294733, -0.018671>, <-1.226089, -0.294731, -0.018927>, 
      <-1.250000, -0.700473, 0.000000>, <-1.244461, -0.696041, -0.008143>, <-1.234575, -0.693758, -0.018799>, <-1.226089, -0.687080, -0.018927>, 
      <-1.250000, -1.000473, 0.000000>, <-1.244461, -0.996041, -0.008143>, <-1.234575, -0.988020, -0.018799>, <-1.226089, -0.981341, -0.018927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.250000, 0.999527, 0.000000>, <-1.244461, 0.995097, -0.008143>, <-1.234484, 0.987193, -0.018800>, <-1.226089, 0.980402, -0.018927>, 
      <-1.250000, 0.699527, 0.000000>, <-1.244461, 0.695097, -0.008143>, <-1.234484, 0.692932, -0.018800>, <-1.226089, 0.686140, -0.018927>, 
      <-1.250000, 0.299527, 0.000000>, <-1.244855, 0.299528, -0.007564>, <-1.235234, 0.293790, -0.018671>, <-1.226089, 0.293792, -0.018927>, 
      <-1.250000, -0.000473, 0.000000>, <-1.244855, -0.000472, -0.007564>, <-1.235234, -0.000471, -0.018671>, <-1.226089, -0.000470, -0.018927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 1.000000, 0.000000>, <0.000000, 0.996140, -0.007091>, <0.000000, 0.988935, -0.018644>, <0.000000, 0.980866, -0.018927>, 
      <-0.375000, 0.999858, 0.000000>, <-0.375000, 0.995998, -0.007091>, <-0.367827, 0.988796, -0.018644>, <-0.367827, 0.980727, -0.018927>, 
      <-0.875000, 0.999669, 0.000000>, <-0.869461, 0.995239, -0.008143>, <-0.866657, 0.987333, -0.018800>, <-0.858262, 0.980541, -0.018927>, 
      <-1.250000, 0.999527, 0.000000>, <-1.244461, 0.995097, -0.008143>, <-1.234484, 0.987193, -0.018800>, <-1.226089, 0.980402, -0.018927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.250000, 1.000000, 0.000000>, <1.244461, 0.995567, -0.008143>, <1.234476, 0.987670, -0.018800>, <1.226089, 0.980866, -0.018927>, 
      <0.875000, 1.000000, 0.000000>, <0.869461, 0.995567, -0.008143>, <0.866649, 0.987670, -0.018800>, <0.858262, 0.980866, -0.018927>, 
      <0.375000, 1.000000, 0.000000>, <0.375000, 0.996140, -0.007091>, <0.367827, 0.988935, -0.018644>, <0.367827, 0.980866, -0.018927>, 
      <0.000000, 1.000000, 0.000000>, <0.000000, 0.996140, -0.007091>, <0.000000, 0.988935, -0.018644>, <0.000000, 0.980866, -0.018927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.250000, 0.000000, 0.000000>, <1.244855, -0.000001, -0.007564>, <1.235234, -0.000004, -0.018671>, <1.226089, -0.000006, -0.018927>, 
      <1.250000, 0.300000, 0.000000>, <1.244855, 0.299999, -0.007564>, <1.235234, 0.294258, -0.018671>, <1.226089, 0.294256, -0.018927>, 
      <1.250000, 0.700000, 0.000000>, <1.244461, 0.695567, -0.008143>, <1.234476, 0.693408, -0.018800>, <1.226089, 0.686604, -0.018927>, 
      <1.250000, 1.000000, 0.000000>, <1.244461, 0.995567, -0.008143>, <1.234476, 0.987670, -0.018800>, <1.226089, 0.980866, -0.018927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.250000, -1.000473, 0.000000>, <1.244461, -0.996041, -0.008143>, <1.234559, -0.988041, -0.018799>, <1.226089, -0.981341, -0.018927>, 
      <1.250000, -0.700331, 0.000000>, <1.244461, -0.695899, -0.008143>, <1.234559, -0.693640, -0.018799>, <1.226089, -0.686940, -0.018927>, 
      <1.250000, -0.300142, 0.000000>, <1.244855, -0.300143, -0.007564>, <1.235234, -0.294404, -0.018671>, <1.226089, -0.294407, -0.018927>, 
      <1.250000, 0.000000, 0.000000>, <1.244855, -0.000001, -0.007564>, <1.235234, -0.000004, -0.018671>, <1.226089, -0.000006, -0.018927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.250000, -1.000473, 0.000000>, <0.875000, -1.000473, 0.000000>, <0.375000, -1.000473, 0.000000>, <0.000000, -1.000473, 0.000000>, 
      <1.244461, -0.996041, -0.008143>, <0.869461, -0.996041, -0.008143>, <0.375000, -0.996613, -0.007091>, <0.000000, -0.996613, -0.007091>, 
      <1.234559, -0.988041, -0.018799>, <0.866732, -0.988041, -0.018799>, <0.367827, -0.989410, -0.018644>, <0.000000, -0.989410, -0.018644>, 
      <1.226089, -0.981341, -0.018927>, <0.858262, -0.981341, -0.018927>, <0.367827, -0.981341, -0.018927>, <0.000000, -0.981341, -0.018927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.376409, -1.101618, 0.107256>, <-1.380396, -1.104809, 0.118612>, <-1.396063, -1.117344, 0.135696>, <-1.389700, -1.112253, 0.145110>, 
      <-0.963486, -1.101618, 0.107256>, <-0.967474, -1.104809, 0.118612>, <-0.979153, -1.117344, 0.135696>, <-0.972790, -1.112253, 0.145110>, 
      <-0.412923, -1.101618, 0.107256>, <-0.412923, -1.104809, 0.118612>, <-0.416910, -1.117864, 0.134734>, <-0.416910, -1.112253, 0.145110>, 
      <0.000000, -1.101618, 0.107256>, <0.000000, -1.104809, 0.118612>, <0.000000, -1.117864, 0.134734>, <0.000000, -1.112253, 0.145110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.376409, -0.000491, 0.107256>, <-1.380396, -0.000492, 0.118612>, <-1.396440, -0.000494, 0.135138>, <-1.389700, -0.000493, 0.145110>, 
      <-1.376409, -0.330829, 0.107256>, <-1.380396, -0.330830, 0.118612>, <-1.396440, -0.334022, 0.135138>, <-1.389700, -0.334021, 0.145110>, 
      <-1.376409, -0.771280, 0.107256>, <-1.380396, -0.774470, 0.118612>, <-1.396063, -0.783816, 0.135696>, <-1.389700, -0.778725, 0.145110>, 
      <-1.376409, -1.101618, 0.107256>, <-1.380396, -1.104809, 0.118612>, <-1.396063, -1.117344, 0.135696>, <-1.389700, -1.112253, 0.145110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.376409, 1.100636, 0.107256>, <-1.380396, 1.103825, 0.118612>, <-1.396064, 1.116357, 0.135695>, <-1.389700, 1.111267, 0.145110>, 
      <-1.376409, 0.770298, 0.107256>, <-1.380396, 0.773487, 0.118612>, <-1.396064, 0.782829, 0.135695>, <-1.389700, 0.777739, 0.145110>, 
      <-1.376409, 0.329847, 0.107256>, <-1.380396, 0.329846, 0.118612>, <-1.396440, 0.333034, 0.135138>, <-1.389700, 0.333035, 0.145110>, 
      <-1.376409, -0.000491, 0.107256>, <-1.380396, -0.000492, 0.118612>, <-1.396440, -0.000494, 0.135138>, <-1.389700, -0.000493, 0.145110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 1.101157, 0.107256>, <0.000000, 1.104348, 0.118612>, <0.000000, 1.117405, 0.134734>, <0.000000, 1.111793, 0.145110>, 
      <-0.412923, 1.101001, 0.107256>, <-0.412923, 1.104192, 0.118612>, <-0.416910, 1.117247, 0.134734>, <-0.416910, 1.111635, 0.145110>, 
      <-0.963486, 1.100792, 0.107256>, <-0.967474, 1.103982, 0.118612>, <-0.979154, 1.116514, 0.135695>, <-0.972790, 1.111425, 0.145110>, 
      <-1.376409, 1.100636, 0.107256>, <-1.380396, 1.103825, 0.118612>, <-1.396064, 1.116357, 0.135695>, <-1.389700, 1.111267, 0.145110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.376409, 1.101157, 0.107256>, <1.380396, 1.104348, 0.118612>, <1.396063, 1.116885, 0.135696>, <1.389700, 1.111793, 0.145110>, 
      <0.963486, 1.101157, 0.107256>, <0.967474, 1.104348, 0.118612>, <0.979153, 1.116885, 0.135696>, <0.972790, 1.111793, 0.145110>, 
      <0.412923, 1.101157, 0.107256>, <0.412923, 1.104348, 0.118612>, <0.416910, 1.117405, 0.134734>, <0.416910, 1.111793, 0.145110>, 
      <0.000000, 1.101157, 0.107256>, <0.000000, 1.104348, 0.118612>, <0.000000, 1.117405, 0.134734>, <0.000000, 1.111793, 0.145110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.376409, 0.000030, 0.107256>, <1.380396, 0.000031, 0.118612>, <1.396440, 0.000035, 0.135138>, <1.389700, 0.000033, 0.145110>, 
      <1.376409, 0.330368, 0.107256>, <1.380396, 0.330369, 0.118612>, <1.396440, 0.333563, 0.135138>, <1.389700, 0.333561, 0.145110>, 
      <1.376409, 0.770819, 0.107256>, <1.380396, 0.774010, 0.118612>, <1.396063, 0.783357, 0.135696>, <1.389700, 0.778265, 0.145110>, 
      <1.376409, 1.101157, 0.107256>, <1.380396, 1.104348, 0.118612>, <1.396063, 1.116885, 0.135696>, <1.389700, 1.111793, 0.145110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.376409, -1.101618, 0.107256>, <1.380396, -1.104809, 0.118612>, <1.396063, -1.117344, 0.135696>, <1.389700, -1.112253, 0.145110>, 
      <1.376409, -0.771124, 0.107256>, <1.380396, -0.774314, 0.118612>, <1.396063, -0.783659, 0.135696>, <1.389700, -0.778567, 0.145110>, 
      <1.376409, -0.330464, 0.107256>, <1.380396, -0.330464, 0.118612>, <1.396440, -0.333651, 0.135138>, <1.389700, -0.333653, 0.145110>, 
      <1.376409, 0.000030, 0.107256>, <1.380396, 0.000031, 0.118612>, <1.396440, 0.000035, 0.135138>, <1.389700, 0.000033, 0.145110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.376409, -1.101618, 0.107256>, <0.963486, -1.101618, 0.107256>, <0.412923, -1.101618, 0.107256>, <0.000000, -1.101618, 0.107256>, 
      <1.380396, -1.104809, 0.118612>, <0.967474, -1.104809, 0.118612>, <0.412923, -1.104809, 0.118612>, <0.000000, -1.104809, 0.118612>, 
      <1.396063, -1.117344, 0.135696>, <0.979153, -1.117344, 0.135696>, <0.416910, -1.117864, 0.134734>, <0.000000, -1.117864, 0.134734>, 
      <1.389700, -1.112253, 0.145110>, <0.972790, -1.112253, 0.145110>, <0.416910, -1.112253, 0.145110>, <0.000000, -1.112253, 0.145110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.363616, -1.091382, 0.126183>, <-0.954531, -1.091382, 0.126183>, <-0.409085, -1.091382, 0.126183>, <0.000000, -1.091382, 0.126183>, 
      <-1.371349, -1.097569, 0.132065>, <-0.962264, -1.097569, 0.132065>, <-0.409085, -1.097508, 0.132007>, <0.000000, -1.097508, 0.132007>, 
      <-1.383814, -1.107543, 0.153819>, <-0.966904, -1.107543, 0.153819>, <-0.416910, -1.108232, 0.152545>, <0.000000, -1.108232, 0.152545>, 
      <-1.389700, -1.112253, 0.145110>, <-0.972790, -1.112253, 0.145110>, <-0.416910, -1.112253, 0.145110>, <0.000000, -1.112253, 0.145110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.363616, -0.000489, 0.126183>, <-1.363616, -0.327757, 0.126183>, <-1.363616, -0.764114, 0.126183>, <-1.363616, -1.091382, 0.126183>, 
      <-1.371311, -0.000490, 0.132037>, <-1.371311, -0.327758, 0.132037>, <-1.371349, -0.770301, 0.132065>, <-1.371349, -1.097569, 0.132065>, 
      <-1.384286, -0.000492, 0.153120>, <-1.384286, -0.334020, 0.153120>, <-1.383814, -0.774015, 0.153819>, <-1.383814, -1.107543, 0.153819>, 
      <-1.389700, -0.000493, 0.145110>, <-1.389700, -0.334021, 0.145110>, <-1.389700, -0.778725, 0.145110>, <-1.389700, -1.112253, 0.145110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.363616, 1.090404, 0.126183>, <-1.363616, 0.763136, 0.126183>, <-1.363616, 0.326779, 0.126183>, <-1.363616, -0.000489, 0.126183>, 
      <-1.371349, 1.096589, 0.132065>, <-1.371349, 0.769321, 0.132065>, <-1.371311, 0.326778, 0.132037>, <-1.371311, -0.000490, 0.132037>, 
      <-1.383814, 1.106559, 0.153819>, <-1.383814, 0.773031, 0.153819>, <-1.384286, 0.333036, 0.153120>, <-1.384286, -0.000492, 0.153120>, 
      <-1.389700, 1.111267, 0.145110>, <-1.389700, 0.777739, 0.145110>, <-1.389700, 0.333035, 0.145110>, <-1.389700, -0.000493, 0.145110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 1.090920, 0.126183>, <-0.409085, 1.090765, 0.126183>, <-0.954531, 1.090559, 0.126183>, <-1.363616, 1.090404, 0.126183>, 
      <0.000000, 1.097047, 0.132007>, <-0.409085, 1.096892, 0.132007>, <-0.962264, 1.096744, 0.132065>, <-1.371349, 1.096589, 0.132065>, 
      <0.000000, 1.107772, 0.152545>, <-0.416910, 1.107614, 0.152545>, <-0.966904, 1.106717, 0.153819>, <-1.383814, 1.106559, 0.153819>, 
      <0.000000, 1.111793, 0.145110>, <-0.416910, 1.111635, 0.145110>, <-0.972790, 1.111425, 0.145110>, <-1.389700, 1.111267, 0.145110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.363616, 1.090920, 0.126183>, <0.954531, 1.090920, 0.126183>, <0.409085, 1.090920, 0.126183>, <0.000000, 1.090920, 0.126183>, 
      <1.371349, 1.097108, 0.132065>, <0.962264, 1.097108, 0.132065>, <0.409085, 1.097047, 0.132007>, <0.000000, 1.097047, 0.132007>, 
      <1.383814, 1.107083, 0.153819>, <0.966903, 1.107083, 0.153819>, <0.416910, 1.107772, 0.152545>, <0.000000, 1.107772, 0.152545>, 
      <1.389700, 1.111793, 0.145110>, <0.972790, 1.111793, 0.145110>, <0.416910, 1.111793, 0.145110>, <0.000000, 1.111793, 0.145110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.363616, 0.000027, 0.126183>, <1.363616, 0.327295, 0.126183>, <1.363616, 0.763652, 0.126183>, <1.363616, 1.090920, 0.126183>, 
      <1.371311, 0.000029, 0.132037>, <1.371311, 0.327297, 0.132037>, <1.371349, 0.769840, 0.132065>, <1.371349, 1.097108, 0.132065>, 
      <1.384286, 0.000032, 0.153120>, <1.384286, 0.333560, 0.153120>, <1.383814, 0.773555, 0.153819>, <1.383814, 1.107083, 0.153819>, 
      <1.389700, 0.000033, 0.145110>, <1.389700, 0.333561, 0.145110>, <1.389700, 0.778265, 0.145110>, <1.389700, 1.111793, 0.145110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.363616, -1.091382, 0.126183>, <1.363616, -0.763959, 0.126183>, <1.363616, -0.327396, 0.126183>, <1.363616, 0.000027, 0.126183>, 
      <1.371349, -1.097569, 0.132065>, <1.371349, -0.770147, 0.132065>, <1.371311, -0.327394, 0.132037>, <1.371311, 0.000029, 0.132037>, 
      <1.383814, -1.107543, 0.153819>, <1.383814, -0.773857, 0.153819>, <1.384286, -0.333654, 0.153120>, <1.384286, 0.000032, 0.153120>, 
      <1.389700, -1.112253, 0.145110>, <1.389700, -0.778567, 0.145110>, <1.389700, -0.333653, 0.145110>, <1.389700, 0.000033, 0.145110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.363616, -1.091382, 0.126183>, <1.371349, -1.097569, 0.132065>, <1.383814, -1.107543, 0.153819>, <1.389700, -1.112253, 0.145110>, 
      <0.954531, -1.091382, 0.126183>, <0.962264, -1.097569, 0.132065>, <0.966904, -1.107543, 0.153819>, <0.972790, -1.112253, 0.145110>, 
      <0.409085, -1.091382, 0.126183>, <0.409085, -1.097508, 0.132007>, <0.416910, -1.108232, 0.152545>, <0.416910, -1.112253, 0.145110>, 
      <0.000000, -1.091382, 0.126183>, <0.000000, -1.097508, 0.132007>, <0.000000, -1.108232, 0.152545>, <0.000000, -1.112253, 0.145110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.281881, -1.025982, 0.063091>, <-0.897317, -1.025982, 0.063091>, <-0.384564, -1.025982, 0.063091>, <0.000000, -1.025982, 0.063091>, 
      <-1.303511, -1.043289, 0.087113>, <-0.918947, -1.043289, 0.087113>, <-0.384564, -1.041918, 0.085210>, <0.000000, -1.041918, 0.085210>, 
      <-1.339001, -1.071686, 0.107458>, <-0.929916, -1.071686, 0.107458>, <-0.409085, -1.071624, 0.107399>, <0.000000, -1.071624, 0.107399>, 
      <-1.363616, -1.091382, 0.126183>, <-0.954531, -1.091382, 0.126183>, <-0.409085, -1.091382, 0.126183>, <0.000000, -1.091382, 0.126183>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.281881, -1.025982, 0.063091>, <-1.268582, -1.015341, 0.048321>, <-1.261563, -1.009725, 0.016999>, <-1.250000, -1.000473, 0.000000>, 
      <-0.897317, -1.025982, 0.063091>, <-0.884017, -1.015341, 0.048321>, <-0.886563, -1.009725, 0.016999>, <-0.875000, -1.000473, 0.000000>, 
      <-0.384564, -1.025982, 0.063091>, <-0.384564, -1.014048, 0.046526>, <-0.375000, -1.010233, 0.017932>, <-0.375000, -1.000473, 0.000000>, 
      <0.000000, -1.025982, 0.063091>, <0.000000, -1.014048, 0.046526>, <0.000000, -1.010233, 0.017932>, <0.000000, -1.000473, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.281881, -0.000478, 0.063091>, <-1.281881, -0.308129, 0.063091>, <-1.281881, -0.718331, 0.063091>, <-1.281881, -1.025982, 0.063091>, 
      <-1.302608, -0.000481, 0.086111>, <-1.302608, -0.308132, 0.086111>, <-1.303511, -0.735638, 0.087113>, <-1.303511, -1.043289, 0.087113>, 
      <-1.338963, -0.000486, 0.107429>, <-1.338963, -0.327753, 0.107429>, <-1.339001, -0.744418, 0.107458>, <-1.339001, -1.071686, 0.107458>, 
      <-1.363616, -0.000489, 0.126183>, <-1.363616, -0.327757, 0.126183>, <-1.363616, -0.764114, 0.126183>, <-1.363616, -1.091382, 0.126183>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.281881, -0.000478, 0.063091>, <-1.267691, -0.000476, 0.047331>, <-1.261928, -0.000475, 0.017534>, <-1.250000, -0.000473, 0.000000>, 
      <-1.281881, -0.308129, 0.063091>, <-1.267691, -0.308127, 0.047331>, <-1.261928, -0.300475, 0.017534>, <-1.250000, -0.300473, 0.000000>, 
      <-1.281881, -0.718331, 0.063091>, <-1.268582, -0.707689, 0.048321>, <-1.261563, -0.709725, 0.016999>, <-1.250000, -0.700473, 0.000000>, 
      <-1.281881, -1.025982, 0.063091>, <-1.268582, -1.015341, 0.048321>, <-1.261563, -1.009725, 0.016999>, <-1.250000, -1.000473, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.281881, 1.025027, 0.063091>, <-1.281881, 0.717376, 0.063091>, <-1.281881, 0.307173, 0.063091>, <-1.281881, -0.000478, 0.063091>, 
      <-1.303510, 1.042328, 0.087113>, <-1.303510, 0.734676, 0.087113>, <-1.302608, 0.307171, 0.086111>, <-1.302608, -0.000481, 0.086111>, 
      <-1.339001, 1.070715, 0.107458>, <-1.339001, 0.743447, 0.107458>, <-1.338963, 0.326782, 0.107429>, <-1.338963, -0.000486, 0.107429>, 
      <-1.363616, 1.090404, 0.126183>, <-1.363616, 0.763136, 0.126183>, <-1.363616, 0.326779, 0.126183>, <-1.363616, -0.000489, 0.126183>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.281881, 1.025027, 0.063091>, <-1.268581, 1.014389, 0.048320>, <-1.261564, 1.008776, 0.016999>, <-1.250000, 0.999527, 0.000000>, 
      <-1.281881, 0.717376, 0.063091>, <-1.268581, 0.706737, 0.048320>, <-1.261564, 0.708776, 0.016999>, <-1.250000, 0.699527, 0.000000>, 
      <-1.281881, 0.307173, 0.063091>, <-1.267691, 0.307175, 0.047331>, <-1.261928, 0.299525, 0.017534>, <-1.250000, 0.299527, 0.000000>, 
      <-1.281881, -0.000478, 0.063091>, <-1.267691, -0.000476, 0.047331>, <-1.261928, -0.000475, 0.017534>, <-1.250000, -0.000473, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 1.025512, 0.063091>, <0.000000, 1.013577, 0.046527>, <0.000000, 1.009761, 0.017932>, <0.000000, 1.000000, 0.000000>, 
      <-0.384564, 1.025367, 0.063091>, <-0.384564, 1.013431, 0.046527>, <-0.375000, 1.009619, 0.017932>, <-0.375000, 0.999858, 0.000000>, 
      <-0.897317, 1.025173, 0.063091>, <-0.884017, 1.014534, 0.048320>, <-0.886564, 1.008918, 0.016999>, <-0.875000, 0.999669, 0.000000>, 
      <-1.281881, 1.025027, 0.063091>, <-1.268581, 1.014389, 0.048320>, <-1.261564, 1.008776, 0.016999>, <-1.250000, 0.999527, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 1.025512, 0.063091>, <-0.384564, 1.025367, 0.063091>, <-0.897317, 1.025173, 0.063091>, <-1.281881, 1.025027, 0.063091>, 
      <0.000000, 1.041450, 0.085210>, <-0.384564, 1.041305, 0.085210>, <-0.918946, 1.042473, 0.087113>, <-1.303510, 1.042328, 0.087113>, 
      <0.000000, 1.071160, 0.107399>, <-0.409085, 1.071005, 0.107399>, <-0.929916, 1.070870, 0.107458>, <-1.339001, 1.070715, 0.107458>, 
      <0.000000, 1.090920, 0.126183>, <-0.409085, 1.090765, 0.126183>, <-0.954531, 1.090559, 0.126183>, <-1.363616, 1.090404, 0.126183>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.281881, 1.025512, 0.063091>, <0.897317, 1.025512, 0.063091>, <0.384564, 1.025512, 0.063091>, <0.000000, 1.025512, 0.063091>, 
      <1.303511, 1.042821, 0.087113>, <0.918947, 1.042821, 0.087113>, <0.384564, 1.041450, 0.085210>, <0.000000, 1.041450, 0.085210>, 
      <1.339001, 1.071222, 0.107458>, <0.929916, 1.071222, 0.107458>, <0.409085, 1.071160, 0.107399>, <0.000000, 1.071160, 0.107399>, 
      <1.363616, 1.090920, 0.126183>, <0.954531, 1.090920, 0.126183>, <0.409085, 1.090920, 0.126183>, <0.000000, 1.090920, 0.126183>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.281881, 1.025512, 0.063091>, <1.268582, 1.014870, 0.048321>, <1.261563, 1.009253, 0.016999>, <1.250000, 1.000000, 0.000000>, 
      <0.897317, 1.025512, 0.063091>, <0.884018, 1.014870, 0.048321>, <0.886563, 1.009253, 0.016999>, <0.875000, 1.000000, 0.000000>, 
      <0.384564, 1.025512, 0.063091>, <0.384564, 1.013577, 0.046527>, <0.375000, 1.009761, 0.017932>, <0.375000, 1.000000, 0.000000>, 
      <0.000000, 1.025512, 0.063091>, <0.000000, 1.013577, 0.046527>, <0.000000, 1.009761, 0.017932>, <0.000000, 1.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.281881, 0.000008, 0.063091>, <1.281881, 0.307659, 0.063091>, <1.281881, 0.717861, 0.063091>, <1.281881, 1.025512, 0.063091>, 
      <1.302608, 0.000013, 0.086111>, <1.302608, 0.307664, 0.086111>, <1.303511, 0.735170, 0.087113>, <1.303511, 1.042821, 0.087113>, 
      <1.338963, 0.000021, 0.107429>, <1.338963, 0.327289, 0.107429>, <1.339001, 0.743954, 0.107458>, <1.339001, 1.071222, 0.107458>, 
      <1.363616, 0.000027, 0.126183>, <1.363616, 0.327295, 0.126183>, <1.363616, 0.763652, 0.126183>, <1.363616, 1.090920, 0.126183>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.281881, 0.000008, 0.063091>, <1.267691, 0.000005, 0.047331>, <1.261928, 0.000003, 0.017534>, <1.250000, 0.000000, 0.000000>, 
      <1.281881, 0.307659, 0.063091>, <1.267691, 0.307656, 0.047331>, <1.261928, 0.300003, 0.017534>, <1.250000, 0.300000, 0.000000>, 
      <1.281881, 0.717861, 0.063091>, <1.268582, 0.707218, 0.048321>, <1.261563, 0.709253, 0.016999>, <1.250000, 0.700000, 0.000000>, 
      <1.281881, 1.025512, 0.063091>, <1.268582, 1.014870, 0.048321>, <1.261563, 1.009253, 0.016999>, <1.250000, 1.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.281881, -1.025982, 0.063091>, <1.281881, -0.718185, 0.063091>, <1.281881, -0.307789, 0.063091>, <1.281881, 0.000008, 0.063091>, 
      <1.303511, -1.043289, 0.087113>, <1.303511, -0.735492, 0.087113>, <1.302608, -0.307784, 0.086111>, <1.302608, 0.000013, 0.086111>, 
      <1.339001, -1.071686, 0.107458>, <1.339001, -0.744264, 0.107458>, <1.338963, -0.327401, 0.107429>, <1.338963, 0.000021, 0.107429>, 
      <1.363616, -1.091382, 0.126183>, <1.363616, -0.763959, 0.126183>, <1.363616, -0.327396, 0.126183>, <1.363616, 0.000027, 0.126183>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.281881, -1.025982, 0.063091>, <1.268582, -1.015341, 0.048321>, <1.261563, -1.009725, 0.016999>, <1.250000, -1.000473, 0.000000>, 
      <1.281881, -0.718185, 0.063091>, <1.268582, -0.707544, 0.048321>, <1.261563, -0.709583, 0.016999>, <1.250000, -0.700331, 0.000000>, 
      <1.281881, -0.307789, 0.063091>, <1.267691, -0.307792, 0.047331>, <1.261928, -0.300139, 0.017534>, <1.250000, -0.300142, 0.000000>, 
      <1.281881, 0.000008, 0.063091>, <1.267691, 0.000005, 0.047331>, <1.261928, 0.000003, 0.017534>, <1.250000, 0.000000, 0.000000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.281881, -1.025982, 0.063091>, <1.303511, -1.043289, 0.087113>, <1.339001, -1.071686, 0.107458>, <1.363616, -1.091382, 0.126183>, 
      <0.897317, -1.025982, 0.063091>, <0.918947, -1.043289, 0.087113>, <0.929916, -1.071686, 0.107458>, <0.954531, -1.091382, 0.126183>, 
      <0.384564, -1.025982, 0.063091>, <0.384564, -1.041918, 0.085210>, <0.409085, -1.071624, 0.107399>, <0.409085, -1.091382, 0.126183>, 
      <0.000000, -1.025982, 0.063091>, <0.000000, -1.041918, 0.085210>, <0.000000, -1.071624, 0.107399>, <0.000000, -1.091382, 0.126183>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.281881, -1.025982, 0.063091>, <0.897317, -1.025982, 0.063091>, <0.384564, -1.025982, 0.063091>, <0.000000, -1.025982, 0.063091>, 
      <1.268582, -1.015341, 0.048321>, <0.884017, -1.015341, 0.048321>, <0.384564, -1.014048, 0.046526>, <0.000000, -1.014048, 0.046526>, 
      <1.261563, -1.009725, 0.016999>, <0.886563, -1.009725, 0.016999>, <0.375000, -1.010233, 0.017932>, <0.000000, -1.010233, 0.017932>, 
      <1.250000, -1.000473, 0.000000>, <0.875000, -1.000473, 0.000000>, <0.375000, -1.000473, 0.000000>, <0.000000, -1.000473, 0.000000>
    }
  }
  material {
    Material3
  }
  scale <3.5, 3.5, 4.0>
  translate  <0.0, -24.41369, 0.622988>
}


union { // bisturi
  cone { // Cone001
    <0,0,0>, 1.1, <0,0,1>, 0.8
    material {
      Brushed_Aluminum
    }
    scale <1.0, 1.0, 0.5>
    translate  15.090514*z
  }
  cylinder { // Cylndr010
    <0,0,1>, <0,0,0>, 1 
    material {
      Brushed_Aluminum
    }
    scale <1.15, 1.15, 2.0>
    translate  13.08961*z
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 15.0>
  }
  sphere { // Sphere003
    <0,0,0>,1
    scale <1.0, 1.0, 0.5>
  }
  cone { // Cone002
    <0,0,0>, 0.0, <0,0,1>, 1.0
    material {
      Chrome_Metal
    }
    scale <0.05, 1.2, 1.4>
    rotate -90.0*x
    translate  <0.0, -0.697737, 17.891861>
  }
  box { // Cube037
    <-1, -1, -1>, <1, 1, 1>
    material {
      Chrome_Metal
    }
    scale <0.05, 0.7, 2.0>
    translate  15.891861*z
  }
  material {
    Silver_Textur1
  }
  scale <0.15, 0.15, 0.3>
  rotate <-90.0, -138.583664, 90.0>
  translate  <3.74509, -21.808061, 0.727924>
}


#declare sPatchObj4 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.353822, -1.352396, 0.066807>, <-2.292490, -1.398290, 0.057043>, <-2.234977, -1.390835, -0.018188>, <-2.216604, -1.346518, -0.078699>, 
      <-2.419594, -1.442187, 0.002103>, <-2.358262, -1.488081, -0.007662>, <-2.305589, -1.484574, -0.063374>, <-2.287216, -1.440257, -0.123885>, 
      <-2.517503, -1.562341, -0.074602>, <-2.486812, -1.583280, -0.067042>, <-2.430748, -1.587482, -0.095936>, <-2.417895, -1.559629, -0.118220>, 
      <-2.576846, -1.664920, -0.124911>, <-2.546154, -1.685859, -0.117351>, <-2.493986, -1.692289, -0.124768>, <-2.481133, -1.664436, -0.147052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.437931, -1.180901, -0.043462>, <-2.458184, -1.229751, 0.023238>, <-2.421427, -1.301808, 0.077570>, <-2.353822, -1.352396, 0.066807>, 
      <-2.494434, -1.292307, -0.094861>, <-2.514687, -1.341157, -0.028160>, <-2.487199, -1.391599, 0.012866>, <-2.419594, -1.442187, 0.002103>, 
      <-2.568841, -1.451143, -0.139311>, <-2.585247, -1.486695, -0.110867>, <-2.556679, -1.535613, -0.084251>, <-2.517503, -1.562341, -0.074602>, 
      <-2.626384, -1.565338, -0.182830>, <-2.642790, -1.600890, -0.154385>, <-2.616022, -1.638192, -0.134561>, <-2.576846, -1.664920, -0.124911>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.275494, -1.163465, -0.191161>, <-2.343002, -1.112949, -0.180413>, <-2.417707, -1.132121, -0.110067>, <-2.437931, -1.180901, -0.043462>, 
      <-2.353003, -1.277966, -0.226650>, <-2.420511, -1.227450, -0.215902>, <-2.474211, -1.243527, -0.161465>, <-2.494434, -1.292307, -0.094861>, 
      <-2.462107, -1.441767, -0.182020>, <-2.492799, -1.420827, -0.189580>, <-2.555987, -1.423289, -0.161596>, <-2.568841, -1.451143, -0.139311>, 
      <-2.530668, -1.564853, -0.204972>, <-2.561360, -1.543913, -0.212532>, <-2.613530, -1.537484, -0.205115>, <-2.626384, -1.565338, -0.182830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.275494, -1.163465, -0.191161>, <-2.353003, -1.277966, -0.226650>, <-2.462107, -1.441767, -0.182020>, <-2.530668, -1.564853, -0.204972>, 
      <-2.207211, -1.214560, -0.202032>, <-2.284720, -1.329061, -0.237521>, <-2.422931, -1.468495, -0.172370>, <-2.491492, -1.591581, -0.195322>, 
      <-2.196148, -1.297178, -0.146068>, <-2.266761, -1.390917, -0.191254>, <-2.401489, -1.524077, -0.146665>, <-2.464727, -1.628883, -0.175497>, 
      <-2.216604, -1.346518, -0.078699>, <-2.287216, -1.440257, -0.123885>, <-2.417895, -1.559629, -0.118220>, <-2.481133, -1.664436, -0.147052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.705132, -1.776592, -0.310053>, <-2.659896, -1.708140, -0.292393>, <-2.623691, -1.614107, -0.237143>, <-2.588787, -1.544470, -0.205896>, 
      <-2.714033, -1.776323, -0.307630>, <-2.668797, -1.707871, -0.289970>, <-2.631160, -1.614145, -0.235415>, <-2.596256, -1.544508, -0.204168>, 
      <-2.725784, -1.777828, -0.302396>, <-2.677962, -1.711734, -0.283548>, <-2.642315, -1.615934, -0.230486>, <-2.606117, -1.546683, -0.200410>, 
      <-2.732686, -1.780799, -0.297039>, <-2.684864, -1.714705, -0.278191>, <-2.648223, -1.619213, -0.226862>, <-2.612024, -1.549962, -0.196786>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.668760, -1.782729, -0.314442>, <-2.625692, -1.713713, -0.296149>, <-2.592779, -1.619607, -0.240471>, <-2.560216, -1.549697, -0.208769>, 
      <-2.679476, -1.779673, -0.314515>, <-2.636408, -1.710656, -0.296222>, <-2.601041, -1.616709, -0.240602>, <-2.568478, -1.546800, -0.208900>, 
      <-2.694384, -1.776917, -0.312979>, <-2.649148, -1.708464, -0.295319>, <-2.615160, -1.614063, -0.239116>, <-2.580256, -1.544426, -0.207869>, 
      <-2.705132, -1.776592, -0.310053>, <-2.659896, -1.708140, -0.292393>, <-2.623691, -1.614107, -0.237143>, <-2.588787, -1.544470, -0.205896>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.629098, -1.798279, -0.309537>, <-2.590748, -1.727772, -0.291706>, <-2.570157, -1.635746, -0.218192>, <-2.530668, -1.564853, -0.204972>, 
      <-2.640357, -1.792670, -0.312237>, <-2.602006, -1.722163, -0.294405>, <-2.578273, -1.630208, -0.220191>, <-2.538785, -1.559315, -0.206972>, 
      <-2.656389, -1.786258, -0.314358>, <-2.613320, -1.717242, -0.296065>, <-2.583318, -1.622925, -0.240320>, <-2.550755, -1.553015, -0.208619>, 
      <-2.668760, -1.782729, -0.314442>, <-2.625692, -1.713713, -0.296149>, <-2.592779, -1.619607, -0.240471>, <-2.560216, -1.549697, -0.208769>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.592200, -1.820870, -0.296084>, <-2.561065, -1.748759, -0.277771>, <-2.530905, -1.657596, -0.225379>, <-2.504636, -1.587621, -0.195077>, 
      <-2.602285, -1.813350, -0.301233>, <-2.571150, -1.741239, -0.282919>, <-2.537676, -1.650051, -0.229080>, <-2.511407, -1.580077, -0.198778>, 
      <-2.617203, -1.804205, -0.306685>, <-2.578852, -1.733698, -0.288853>, <-2.561422, -1.641706, -0.216040>, <-2.521933, -1.570813, -0.202820>, 
      <-2.629098, -1.798279, -0.309537>, <-2.590748, -1.727772, -0.291706>, <-2.570157, -1.635746, -0.218192>, <-2.530668, -1.564853, -0.204972>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.563672, -1.847064, -0.276135>, <-2.538680, -1.774551, -0.257518>, <-2.509355, -1.684299, -0.209258>, <-2.486076, -1.614542, -0.180596>, 
      <-2.570832, -1.838666, -0.283137>, <-2.545840, -1.766153, -0.264520>, <-2.513593, -1.675779, -0.214213>, <-2.490314, -1.606022, -0.185551>, 
      <-2.582503, -1.828100, -0.291133>, <-2.551368, -1.755989, -0.272820>, <-2.524174, -1.665096, -0.221700>, <-2.497905, -1.595121, -0.191398>, 
      <-2.592200, -1.820870, -0.296084>, <-2.561065, -1.748759, -0.277771>, <-2.530905, -1.657596, -0.225379>, <-2.504636, -1.587621, -0.195077>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.547859, -1.872878, -0.252723>, <-2.529499, -1.800502, -0.232816>, <-2.498834, -1.710925, -0.190429>, <-2.477824, -1.641517, -0.163732>, 
      <-2.550624, -1.864949, -0.260552>, <-2.532263, -1.792573, -0.240645>, <-2.499642, -1.702770, -0.195912>, <-2.478632, -1.633362, -0.169215>, 
      <-2.557383, -1.854441, -0.269985>, <-2.532390, -1.781928, -0.251367>, <-2.505460, -1.692128, -0.204704>, <-2.482181, -1.622372, -0.176042>, 
      <-2.563672, -1.847064, -0.276135>, <-2.538680, -1.774551, -0.257518>, <-2.509355, -1.684299, -0.209258>, <-2.486076, -1.614542, -0.180596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.547173, -1.894381, -0.229413>, <-2.536919, -1.821668, -0.210192>, <-2.519303, -1.727697, -0.164455>, <-2.481133, -1.664436, -0.147052>, 
      <-2.544875, -1.888508, -0.236539>, <-2.534621, -1.815795, -0.217318>, <-2.516401, -1.721407, -0.169486>, <-2.478230, -1.658147, -0.152084>, 
      <-2.545567, -1.879450, -0.246233>, <-2.527207, -1.807074, -0.226327>, <-2.498133, -1.718007, -0.185669>, <-2.477123, -1.648598, -0.158971>, 
      <-2.547859, -1.872878, -0.252723>, <-2.529499, -1.800502, -0.232816>, <-2.498834, -1.710925, -0.190429>, <-2.477824, -1.641517, -0.163732>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.561713, -1.908290, -0.209757>, <-2.544518, -1.837822, -0.190776>, <-2.515362, -1.748355, -0.156094>, <-2.495497, -1.679812, -0.133096>, 
      <-2.555402, -1.905574, -0.214656>, <-2.538207, -1.835105, -0.195675>, <-2.509526, -1.745116, -0.159675>, <-2.489661, -1.676572, -0.136677>, 
      <-2.549211, -1.899589, -0.223094>, <-2.538956, -1.826877, -0.203872>, <-2.521871, -1.733261, -0.160003>, <-2.483701, -1.670001, -0.142600>, 
      <-2.547173, -1.894381, -0.229413>, <-2.536919, -1.821668, -0.210192>, <-2.519303, -1.727697, -0.164455>, <-2.481133, -1.664436, -0.147052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.589266, -1.912498, -0.196741>, <-2.565806, -1.843725, -0.179724>, <-2.539890, -1.753464, -0.145813>, <-2.518729, -1.685306, -0.123986>, 
      <-2.580365, -1.912766, -0.199165>, <-2.556906, -1.843994, -0.182147>, <-2.532422, -1.753425, -0.147540>, <-2.511261, -1.685268, -0.125714>, 
      <-2.568615, -1.911261, -0.204400>, <-2.551420, -1.840792, -0.185419>, <-2.521268, -1.751634, -0.152471>, <-2.501403, -1.683090, -0.129472>, 
      <-2.561713, -1.908290, -0.209757>, <-2.544518, -1.837822, -0.190776>, <-2.515362, -1.748355, -0.156094>, <-2.495497, -1.679812, -0.133096>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.625641, -1.906363, -0.192350>, <-2.596309, -1.839508, -0.175388>, <-2.570799, -1.747962, -0.142483>, <-2.547295, -1.680076, -0.121112>, 
      <-2.614924, -1.909420, -0.192278>, <-2.585592, -1.842565, -0.175315>, <-2.562538, -1.750860, -0.142352>, <-2.539035, -1.682974, -0.120981>, 
      <-2.600015, -1.912174, -0.193814>, <-2.576555, -1.843401, -0.176797>, <-2.548419, -1.753507, -0.143839>, <-2.527258, -1.685349, -0.122013>, 
      <-2.589266, -1.912498, -0.196741>, <-2.565806, -1.843725, -0.179724>, <-2.539890, -1.753464, -0.145813>, <-2.518729, -1.685306, -0.123986>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.665297, -1.890811, -0.197255>, <-2.627174, -1.826989, -0.181735>, <-2.611851, -1.725430, -0.154588>, <-2.576846, -1.664920, -0.124911>, 
      <-2.654040, -1.896420, -0.194556>, <-2.615916, -1.832598, -0.179036>, <-2.603734, -1.730969, -0.152589>, <-2.568728, -1.670459, -0.122912>, 
      <-2.638011, -1.902835, -0.192434>, <-2.608678, -1.835980, -0.175471>, <-2.580261, -1.744643, -0.142634>, <-2.556757, -1.676757, -0.121263>, 
      <-2.625641, -1.906363, -0.192350>, <-2.596309, -1.839508, -0.175388>, <-2.570799, -1.747962, -0.142483>, <-2.547295, -1.680076, -0.121112>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.702198, -1.868218, -0.210706>, <-2.659174, -1.805790, -0.194657>, <-2.632675, -1.709970, -0.157573>, <-2.602880, -1.642149, -0.134802>, 
      <-2.692113, -1.875738, -0.205557>, <-2.649089, -1.813310, -0.189508>, <-2.625904, -1.717515, -0.153872>, <-2.596109, -1.649694, -0.131101>, 
      <-2.677193, -1.884884, -0.200107>, <-2.639069, -1.821062, -0.184587>, <-2.620587, -1.719470, -0.156739>, <-2.585582, -1.658959, -0.127062>, 
      <-2.665297, -1.890811, -0.197255>, <-2.627174, -1.826989, -0.181735>, <-2.611851, -1.725430, -0.154588>, <-2.576846, -1.664920, -0.124911>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.730726, -1.842021, -0.230658>, <-2.685858, -1.778548, -0.214596>, <-2.654224, -1.683268, -0.173696>, <-2.621438, -1.615231, -0.149284>, 
      <-2.723566, -1.850419, -0.223655>, <-2.678698, -1.786946, -0.207593>, <-2.649986, -1.691787, -0.168741>, <-2.617200, -1.623750, -0.144329>, 
      <-2.711895, -1.860987, -0.215657>, <-2.668871, -1.798558, -0.199607>, <-2.639406, -1.702470, -0.161252>, <-2.609611, -1.634649, -0.138481>, 
      <-2.702198, -1.868218, -0.210706>, <-2.659174, -1.805790, -0.194657>, <-2.632675, -1.709970, -0.157573>, <-2.602880, -1.642149, -0.134802>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.746539, -1.816211, -0.254070>, <-2.696277, -1.754794, -0.236667>, <-2.664746, -1.656642, -0.192525>, <-2.629692, -1.588256, -0.166148>, 
      <-2.743774, -1.824139, -0.246241>, <-2.693511, -1.762722, -0.228838>, <-2.663938, -1.664797, -0.187042>, <-2.628884, -1.596411, -0.160665>, 
      <-2.737015, -1.834645, -0.236809>, <-2.692147, -1.771172, -0.220747>, <-2.658120, -1.675438, -0.178250>, <-2.625333, -1.607401, -0.153838>, 
      <-2.730726, -1.842021, -0.230658>, <-2.685858, -1.778548, -0.214596>, <-2.654224, -1.683268, -0.173696>, <-2.621438, -1.615231, -0.149284>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.747229, -1.794711, -0.277379>, <-2.693458, -1.734890, -0.257782>, <-2.661652, -1.635329, -0.209503>, <-2.626384, -1.565338, -0.182830>, 
      <-2.749527, -1.800584, -0.270253>, <-2.695755, -1.740763, -0.250656>, <-2.664554, -1.641618, -0.204471>, <-2.629286, -1.571628, -0.177798>, 
      <-2.748831, -1.809640, -0.260559>, <-2.698569, -1.748223, -0.243156>, <-2.665448, -1.649561, -0.197286>, <-2.630394, -1.581175, -0.170909>, 
      <-2.746539, -1.816211, -0.254070>, <-2.696277, -1.754794, -0.236667>, <-2.664746, -1.656642, -0.192525>, <-2.629692, -1.588256, -0.166148>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.747229, -1.794711, -0.277379>, <-2.745191, -1.789502, -0.283700>, <-2.738999, -1.783516, -0.292139>, <-2.732686, -1.780799, -0.297039>, 
      <-2.693458, -1.734890, -0.257782>, <-2.691420, -1.729681, -0.264102>, <-2.691177, -1.717422, -0.273291>, <-2.684864, -1.714705, -0.278191>, 
      <-2.661652, -1.635329, -0.209503>, <-2.659085, -1.629765, -0.213954>, <-2.654058, -1.622452, -0.223282>, <-2.648223, -1.619213, -0.226862>, 
      <-2.626384, -1.565338, -0.182830>, <-2.623817, -1.559774, -0.187282>, <-2.617860, -1.553201, -0.193206>, <-2.612024, -1.549962, -0.196786>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.837528, -1.920872, -0.303003>, <-2.876375, -1.953963, -0.295709>, <-2.973475, -2.002502, -0.309692>, <-2.978154, -2.009160, -0.258790>, 
      <-2.846075, -1.912781, -0.300013>, <-2.884921, -1.945872, -0.292719>, <-2.973265, -2.002442, -0.313330>, <-2.977945, -2.009100, -0.262428>, 
      <-2.847930, -1.895068, -0.296113>, <-2.889029, -1.922092, -0.297131>, <-2.949121, -1.948712, -0.304425>, <-2.990063, -1.975904, -0.302257>, 
      <-2.855118, -1.885935, -0.292596>, <-2.896216, -1.912959, -0.293614>, <-2.961106, -1.930724, -0.305879>, <-3.002048, -1.957916, -0.303710>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.837528, -1.920872, -0.303003>, <-2.793229, -1.883137, -0.311321>, <-2.736816, -1.824537, -0.322422>, <-2.705132, -1.776592, -0.310053>, 
      <-2.846075, -1.912781, -0.300013>, <-2.801775, -1.875046, -0.308330>, <-2.745716, -1.824268, -0.319999>, <-2.714033, -1.776323, -0.307630>, 
      <-2.847930, -1.895068, -0.296113>, <-2.807471, -1.868464, -0.295111>, <-2.753446, -1.816059, -0.313299>, <-2.725784, -1.777828, -0.302396>, 
      <-2.855118, -1.885935, -0.292596>, <-2.814659, -1.859331, -0.291594>, <-2.760348, -1.819030, -0.307941>, <-2.732686, -1.780799, -0.297039>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.801635, -1.936566, -0.311309>, <-2.833508, -1.975189, -0.308989>, <-2.876091, -2.026668, -0.303205>, <-2.904055, -2.067855, -0.297316>, 
      <-2.811759, -1.930132, -0.310644>, <-2.843632, -1.968755, -0.308324>, <-2.898114, -2.005635, -0.306429>, <-2.926078, -2.046822, -0.300540>, 
      <-2.829072, -1.928877, -0.305962>, <-2.867919, -1.961967, -0.298668>, <-2.973179, -2.002417, -0.314835>, <-2.977859, -2.009075, -0.263933>, 
      <-2.837528, -1.920872, -0.303003>, <-2.876375, -1.953963, -0.295709>, <-2.973475, -2.002502, -0.309692>, <-2.978154, -2.009160, -0.258790>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.801635, -1.936566, -0.311309>, <-2.762857, -1.889575, -0.314132>, <-2.700262, -1.833211, -0.327822>, <-2.668760, -1.782729, -0.314442>, 
      <-2.811759, -1.930132, -0.310644>, <-2.772980, -1.883141, -0.313466>, <-2.710979, -1.830154, -0.327895>, <-2.679476, -1.779673, -0.314515>, 
      <-2.829072, -1.928877, -0.305962>, <-2.784773, -1.891141, -0.314279>, <-2.726068, -1.824861, -0.325348>, <-2.694384, -1.776917, -0.312979>, 
      <-2.837528, -1.920872, -0.303003>, <-2.793229, -1.883137, -0.311321>, <-2.736816, -1.824537, -0.322422>, <-2.705132, -1.776592, -0.310053>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.753398, -1.974340, -0.308533>, <-2.786515, -2.021346, -0.298666>, <-2.848969, -2.115528, -0.298261>, <-2.858307, -2.123621, -0.241244>, 
      <-2.769524, -1.965616, -0.310071>, <-2.802641, -2.012622, -0.300204>, <-2.848704, -2.115452, -0.302864>, <-2.858042, -2.123545, -0.245847>, 
      <-2.786130, -1.946420, -0.312328>, <-2.818003, -1.985043, -0.310008>, <-2.856380, -2.045493, -0.300319>, <-2.884344, -2.086680, -0.294430>, 
      <-2.801635, -1.936566, -0.311309>, <-2.833508, -1.975189, -0.308989>, <-2.876091, -2.026668, -0.303205>, <-2.904055, -2.067855, -0.297316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.753398, -1.974340, -0.308533>, <-2.716697, -1.922246, -0.319468>, <-2.659256, -1.853725, -0.323560>, <-2.629098, -1.798279, -0.309537>, 
      <-2.769524, -1.965616, -0.310071>, <-2.732823, -1.913521, -0.321006>, <-2.670515, -1.848116, -0.326259>, <-2.640357, -1.792670, -0.312237>, 
      <-2.786130, -1.946420, -0.312328>, <-2.747352, -1.899429, -0.315151>, <-2.687891, -1.836739, -0.327738>, <-2.656389, -1.786258, -0.314358>, 
      <-2.801635, -1.936566, -0.311309>, <-2.762857, -1.889575, -0.314132>, <-2.700262, -1.833211, -0.327822>, <-2.668760, -1.782729, -0.314442>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.683007, -2.000743, -0.299993>, <-2.656835, -1.946280, -0.302037>, <-2.615540, -1.874927, -0.309812>, <-2.592200, -1.820870, -0.296084>, 
      <-2.703953, -1.992891, -0.303846>, <-2.677781, -1.938428, -0.305890>, <-2.625625, -1.867408, -0.314961>, <-2.602285, -1.813350, -0.301233>, 
      <-2.733503, -1.985103, -0.306635>, <-2.696802, -1.933008, -0.317570>, <-2.647361, -1.859651, -0.320707>, <-2.617203, -1.804205, -0.306685>, 
      <-2.753398, -1.974340, -0.308533>, <-2.716697, -1.922246, -0.319468>, <-2.659256, -1.853725, -0.323560>, <-2.629098, -1.798279, -0.309537>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.683007, -2.000743, -0.299993>, <-2.702707, -2.041738, -0.298455>, <-2.728439, -2.096345, -0.290233>, <-2.744781, -2.138383, -0.284168>, 
      <-2.703953, -1.992891, -0.303846>, <-2.723653, -2.033885, -0.302308>, <-2.763212, -2.084827, -0.292111>, <-2.779554, -2.126865, -0.286046>, 
      <-2.733503, -1.985103, -0.306635>, <-2.766620, -2.032109, -0.296768>, <-2.848614, -2.115427, -0.304421>, <-2.857953, -2.123519, -0.247404>, 
      <-2.753398, -1.974340, -0.308533>, <-2.786515, -2.021346, -0.298666>, <-2.848969, -2.115528, -0.298261>, <-2.858307, -2.123621, -0.241244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.626481, -2.021919, -0.285186>, <-2.643613, -2.071972, -0.278544>, <-2.670594, -2.173790, -0.283411>, <-2.678693, -2.183114, -0.231543>, 
      <-2.644066, -2.018396, -0.290286>, <-2.661198, -2.068449, -0.283644>, <-2.670317, -2.173711, -0.288227>, <-2.678416, -2.183034, -0.236359>, 
      <-2.665801, -2.007193, -0.296828>, <-2.685501, -2.048188, -0.295289>, <-2.701252, -2.105350, -0.288765>, <-2.717593, -2.147388, -0.282700>, 
      <-2.683007, -2.000743, -0.299993>, <-2.702707, -2.041738, -0.298455>, <-2.728439, -2.096345, -0.290233>, <-2.744781, -2.138383, -0.284168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.626481, -2.021919, -0.285186>, <-2.608551, -1.969533, -0.292137>, <-2.581342, -1.898334, -0.289298>, <-2.563672, -1.847064, -0.276135>, 
      <-2.644066, -2.018396, -0.290286>, <-2.626136, -1.966010, -0.297237>, <-2.588502, -1.889936, -0.296300>, <-2.570832, -1.838666, -0.283137>, 
      <-2.665801, -2.007193, -0.296828>, <-2.639629, -1.952730, -0.298872>, <-2.605843, -1.882158, -0.304862>, <-2.582503, -1.828100, -0.291133>, 
      <-2.683007, -2.000743, -0.299993>, <-2.656835, -1.946280, -0.302037>, <-2.615540, -1.874927, -0.309812>, <-2.592200, -1.820870, -0.296084>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.574469, -2.022488, -0.268517>, <-2.580318, -2.065161, -0.271739>, <-2.584061, -2.122868, -0.278907>, <-2.587991, -2.165688, -0.274830>, 
      <-2.589349, -2.019743, -0.274808>, <-2.595197, -2.062417, -0.278030>, <-2.614582, -2.125037, -0.279306>, <-2.618512, -2.167856, -0.275229>, 
      <-2.611027, -2.025015, -0.280704>, <-2.628159, -2.075068, -0.274062>, <-2.670298, -2.173705, -0.288550>, <-2.678398, -2.183029, -0.236682>, 
      <-2.626481, -2.021919, -0.285186>, <-2.643613, -2.071972, -0.278544>, <-2.670594, -2.173790, -0.283411>, <-2.678693, -2.183114, -0.231543>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.574469, -2.022488, -0.268517>, <-2.568263, -1.977206, -0.265098>, <-2.558749, -1.915804, -0.264530>, <-2.547859, -1.872878, -0.252723>, 
      <-2.589349, -2.019743, -0.274808>, <-2.583142, -1.974461, -0.271389>, <-2.561513, -1.907875, -0.272359>, <-2.550624, -1.864949, -0.260552>, 
      <-2.611027, -2.025015, -0.280704>, <-2.593096, -1.972629, -0.287656>, <-2.575053, -1.905711, -0.283148>, <-2.557383, -1.854441, -0.269985>, 
      <-2.626481, -2.021919, -0.285186>, <-2.608551, -1.969533, -0.292137>, <-2.581342, -1.898334, -0.289298>, <-2.563672, -1.847064, -0.276135>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.533953, -2.038987, -0.246064>, <-2.530585, -2.079205, -0.246080>, <-2.521415, -2.132191, -0.234863>, <-2.523914, -2.172117, -0.229521>, 
      <-2.531559, -2.035826, -0.260273>, <-2.528192, -2.076044, -0.260288>, <-2.520059, -2.131802, -0.258443>, <-2.522559, -2.171728, -0.253101>, 
      <-2.561074, -2.024959, -0.262853>, <-2.566923, -2.067632, -0.266075>, <-2.560501, -2.121194, -0.278599>, <-2.564430, -2.164014, -0.274522>, 
      <-2.574469, -2.022488, -0.268517>, <-2.580318, -2.065161, -0.271739>, <-2.584061, -2.122868, -0.278907>, <-2.587991, -2.165688, -0.274830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.533953, -2.038987, -0.246064>, <-2.537612, -1.995292, -0.246047>, <-2.553096, -1.936384, -0.240517>, <-2.547173, -1.894381, -0.229413>, 
      <-2.531559, -2.035826, -0.260273>, <-2.535219, -1.992131, -0.260256>, <-2.550798, -1.930511, -0.247643>, <-2.544875, -1.888508, -0.236539>, 
      <-2.561074, -2.024959, -0.262853>, <-2.554868, -1.979677, -0.259435>, <-2.556457, -1.922377, -0.258040>, <-2.545567, -1.879450, -0.246233>, 
      <-2.574469, -2.022488, -0.268517>, <-2.568263, -1.977206, -0.265098>, <-2.558749, -1.915804, -0.264530>, <-2.547859, -1.872878, -0.252723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.581322, -2.031539, -0.227833>, <-2.586397, -2.073587, -0.224379>, <-2.589302, -2.125377, -0.195593>, <-2.592953, -2.167114, -0.188494>, 
      <-2.566761, -2.032050, -0.232790>, <-2.571836, -2.074098, -0.229336>, <-2.565225, -2.123666, -0.195279>, <-2.568876, -2.165403, -0.188180>, 
      <-2.536450, -2.042285, -0.231240>, <-2.533082, -2.082503, -0.231256>, <-2.522799, -2.132590, -0.210767>, <-2.525299, -2.172515, -0.205425>, 
      <-2.533953, -2.038987, -0.246064>, <-2.530585, -2.079205, -0.246080>, <-2.521415, -2.132191, -0.234863>, <-2.523914, -2.172117, -0.229521>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.581322, -2.031539, -0.227833>, <-2.576804, -1.994105, -0.230908>, <-2.570389, -1.943845, -0.219334>, <-2.561713, -1.908290, -0.209757>, 
      <-2.566761, -2.032050, -0.232790>, <-2.562243, -1.994617, -0.235866>, <-2.564077, -1.941129, -0.224233>, <-2.555402, -1.905574, -0.214656>, 
      <-2.536450, -2.042285, -0.231240>, <-2.540109, -1.998590, -0.231223>, <-2.555134, -1.941593, -0.234197>, <-2.549211, -1.899589, -0.223094>, 
      <-2.533953, -2.038987, -0.246064>, <-2.537612, -1.995292, -0.246047>, <-2.553096, -1.936384, -0.240517>, <-2.547173, -1.894381, -0.229413>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.638128, -2.035327, -0.210597>, <-2.625709, -1.997745, -0.205764>, <-2.601800, -1.949243, -0.205833>, <-2.589266, -1.912498, -0.196741>, 
      <-2.621046, -2.038974, -0.214250>, <-2.608627, -2.001392, -0.209417>, <-2.592900, -1.949511, -0.208257>, <-2.580365, -1.912766, -0.199165>, 
      <-2.598206, -2.030946, -0.222085>, <-2.593687, -1.993512, -0.225160>, <-2.577291, -1.946816, -0.213976>, <-2.568615, -1.911261, -0.204400>, 
      <-2.581322, -2.031539, -0.227833>, <-2.576804, -1.994105, -0.230908>, <-2.570389, -1.943845, -0.219334>, <-2.561713, -1.908290, -0.209757>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.638128, -2.035327, -0.210597>, <-2.652581, -2.079062, -0.216222>, <-2.685742, -2.191228, -0.186402>, <-2.678693, -2.183114, -0.231543>, 
      <-2.621046, -2.038974, -0.214250>, <-2.635499, -2.082709, -0.219875>, <-2.686023, -2.191309, -0.181501>, <-2.678975, -2.183195, -0.226643>, 
      <-2.598206, -2.030946, -0.222085>, <-2.603281, -2.072994, -0.218631>, <-2.618405, -2.127445, -0.195973>, <-2.622057, -2.169182, -0.188874>, 
      <-2.581322, -2.031539, -0.227833>, <-2.586397, -2.073587, -0.224379>, <-2.589302, -2.125377, -0.195593>, <-2.592953, -2.167114, -0.188494>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.691205, -2.008079, -0.204332>, <-2.674030, -1.975900, -0.204990>, <-2.639919, -1.938904, -0.200606>, <-2.625641, -1.906363, -0.192350>, 
      <-2.674229, -2.013991, -0.205207>, <-2.657054, -1.981811, -0.205865>, <-2.629201, -1.941961, -0.200534>, <-2.614924, -1.909420, -0.192278>, 
      <-2.655356, -2.031649, -0.206913>, <-2.642936, -1.994067, -0.202079>, <-2.612549, -1.948919, -0.202907>, <-2.600015, -1.912174, -0.193814>, 
      <-2.638128, -2.035327, -0.210597>, <-2.625709, -1.997745, -0.205764>, <-2.601800, -1.949243, -0.205833>, <-2.589266, -1.912498, -0.196741>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.691205, -2.008079, -0.204332>, <-2.711757, -2.046585, -0.203544>, <-2.734696, -2.099497, -0.192297>, <-2.750332, -2.139980, -0.187570>, 
      <-2.674229, -2.013991, -0.205207>, <-2.694781, -2.052497, -0.204419>, <-2.707825, -2.108397, -0.190846>, <-2.723461, -2.148880, -0.186119>, 
      <-2.655356, -2.031649, -0.206913>, <-2.669808, -2.075384, -0.212537>, <-2.686015, -2.191307, -0.181642>, <-2.678967, -2.183193, -0.226783>, 
      <-2.638128, -2.035327, -0.210597>, <-2.652581, -2.079062, -0.216222>, <-2.685742, -2.191228, -0.186402>, <-2.678693, -2.183114, -0.231543>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.770556, -1.989209, -0.203771>, <-2.743227, -1.956244, -0.197542>, <-2.687019, -1.927175, -0.206098>, <-2.665297, -1.890811, -0.197255>, 
      <-2.748331, -1.999292, -0.201993>, <-2.721002, -1.966327, -0.195765>, <-2.675761, -1.932784, -0.203399>, <-2.654040, -1.896420, -0.194556>, 
      <-2.714286, -2.000041, -0.203142>, <-2.697111, -1.967862, -0.203801>, <-2.652288, -1.935376, -0.200690>, <-2.638011, -1.902835, -0.192434>, 
      <-2.691205, -2.008079, -0.204332>, <-2.674030, -1.975900, -0.204990>, <-2.639919, -1.938904, -0.200606>, <-2.625641, -1.906363, -0.192350>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.770556, -1.989209, -0.203771>, <-2.801789, -2.026882, -0.210889>, <-2.866222, -2.130480, -0.192915>, <-2.858307, -2.123621, -0.241244>, 
      <-2.748331, -1.999292, -0.201993>, <-2.779564, -2.036965, -0.209111>, <-2.866575, -2.130582, -0.186785>, <-2.858659, -2.123722, -0.235114>, 
      <-2.714286, -2.000041, -0.203142>, <-2.734838, -2.038547, -0.202354>, <-2.769304, -2.088033, -0.194166>, <-2.784940, -2.128517, -0.189439>, 
      <-2.691205, -2.008079, -0.204332>, <-2.711757, -2.046585, -0.203544>, <-2.734696, -2.099497, -0.192297>, <-2.750332, -2.139980, -0.187570>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.816039, -1.951445, -0.214318>, <-2.848875, -1.983248, -0.211337>, <-2.884542, -2.031913, -0.196753>, <-2.910116, -2.069598, -0.191827>, 
      <-2.802421, -1.962275, -0.209647>, <-2.835257, -1.994078, -0.206666>, <-2.865191, -2.050394, -0.193920>, <-2.890765, -2.088079, -0.188994>, 
      <-2.786918, -1.981786, -0.205080>, <-2.818151, -2.019459, -0.212198>, <-2.866482, -2.130555, -0.188396>, <-2.858567, -2.123696, -0.236725>, 
      <-2.770556, -1.989209, -0.203771>, <-2.801789, -2.026882, -0.210889>, <-2.866222, -2.130480, -0.192915>, <-2.858307, -2.123621, -0.241244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.816039, -1.951445, -0.214318>, <-2.785705, -1.922065, -0.217072>, <-2.725692, -1.902308, -0.219470>, <-2.702198, -1.868218, -0.210706>, 
      <-2.802421, -1.962275, -0.209647>, <-2.772087, -1.932894, -0.212401>, <-2.715607, -1.909829, -0.214322>, <-2.692113, -1.875738, -0.205557>, 
      <-2.786918, -1.981786, -0.205080>, <-2.759589, -1.948821, -0.198851>, <-2.698914, -1.921248, -0.208950>, <-2.677193, -1.884884, -0.200107>, 
      <-2.770556, -1.989209, -0.203771>, <-2.743227, -1.956244, -0.197542>, <-2.687019, -1.927175, -0.206098>, <-2.665297, -1.890811, -0.197255>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.844324, -1.930542, -0.229074>, <-2.808678, -1.906463, -0.225021>, <-2.755150, -1.876573, -0.239402>, <-2.730726, -1.842021, -0.230658>, 
      <-2.836705, -1.937716, -0.224447>, <-2.801059, -1.913637, -0.220394>, <-2.747990, -1.884972, -0.232399>, <-2.723566, -1.850419, -0.223655>, 
      <-2.824688, -1.944566, -0.217285>, <-2.794354, -1.915186, -0.220039>, <-2.735390, -1.895077, -0.224421>, <-2.711895, -1.860987, -0.215657>, 
      <-2.816039, -1.951445, -0.214318>, <-2.785705, -1.922065, -0.217072>, <-2.725692, -1.902308, -0.219470>, <-2.702198, -1.868218, -0.210706>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.844324, -1.930542, -0.229074>, <-2.883437, -1.956963, -0.233521>, <-2.982457, -2.015284, -0.211975>, <-2.978154, -2.009160, -0.258790>, 
      <-2.836705, -1.937716, -0.224447>, <-2.875818, -1.964137, -0.228894>, <-2.982785, -2.015378, -0.206283>, <-2.978481, -2.009254, -0.253098>, 
      <-2.824688, -1.944566, -0.217285>, <-2.857524, -1.976369, -0.214303>, <-2.908918, -2.008632, -0.200322>, <-2.934492, -2.046317, -0.195396>, 
      <-2.816039, -1.951445, -0.214318>, <-2.848875, -1.983248, -0.211337>, <-2.884542, -2.031913, -0.196753>, <-2.910116, -2.069598, -0.191827>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.878663, -1.892481, -0.252352>, <-2.838804, -1.870570, -0.257456>, <-2.774854, -1.850810, -0.263874>, <-2.746539, -1.816211, -0.254070>, 
      <-2.871190, -1.905097, -0.243970>, <-2.831331, -1.883186, -0.249074>, <-2.772089, -1.858737, -0.256045>, <-2.743774, -1.824139, -0.246241>, 
      <-2.855571, -1.919953, -0.235904>, <-2.819925, -1.895874, -0.231852>, <-2.761439, -1.869197, -0.245552>, <-2.737015, -1.834645, -0.236809>, 
      <-2.844324, -1.930542, -0.229074>, <-2.808678, -1.906463, -0.225021>, <-2.755150, -1.876573, -0.239402>, <-2.730726, -1.842021, -0.230658>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.878663, -1.892481, -0.252352>, <-2.917312, -1.913727, -0.247403>, <-2.970433, -1.934372, -0.225773>, <-3.006815, -1.959285, -0.220743>, 
      <-2.871190, -1.905097, -0.243970>, <-2.909840, -1.926343, -0.239021>, <-2.958986, -1.951551, -0.224385>, <-2.995368, -1.976465, -0.219355>, 
      <-2.855571, -1.919953, -0.235904>, <-2.894684, -1.946374, -0.240352>, <-2.982657, -2.015341, -0.208500>, <-2.978354, -2.009217, -0.255315>, 
      <-2.844324, -1.930542, -0.229074>, <-2.883437, -1.956963, -0.233521>, <-2.982457, -2.015284, -0.211975>, <-2.978154, -2.009160, -0.258790>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.888149, -1.856552, -0.278233>, <-2.845750, -1.838357, -0.279887>, <-2.777215, -1.828071, -0.288308>, <-2.747229, -1.794711, -0.277379>, 
      <-2.894943, -1.858441, -0.266621>, <-2.852543, -1.840245, -0.268275>, <-2.779513, -1.833944, -0.281182>, <-2.749527, -1.800584, -0.270253>, 
      <-2.884674, -1.882333, -0.259094>, <-2.844814, -1.860422, -0.264198>, <-2.777146, -1.844239, -0.270363>, <-2.748831, -1.809640, -0.260559>, 
      <-2.878663, -1.892481, -0.252352>, <-2.838804, -1.870570, -0.257456>, <-2.774854, -1.850810, -0.263874>, <-2.746539, -1.816211, -0.254070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.888149, -1.856552, -0.278233>, <-2.933031, -1.875812, -0.276482>, <-2.996648, -1.893575, -0.269907>, <-3.037921, -1.919458, -0.266038>, 
      <-2.894943, -1.858441, -0.266621>, <-2.939824, -1.877701, -0.264870>, <-2.998150, -1.894006, -0.243762>, <-3.039423, -1.919889, -0.239894>, 
      <-2.884674, -1.882333, -0.259094>, <-2.923323, -1.903579, -0.254145>, <-2.981696, -1.917467, -0.227139>, <-3.018078, -1.942381, -0.222109>, 
      <-2.878663, -1.892481, -0.252352>, <-2.917312, -1.913727, -0.247403>, <-2.970433, -1.934372, -0.225773>, <-3.006815, -1.959285, -0.220743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.888149, -1.856552, -0.278233>, <-2.933031, -1.875812, -0.276482>, <-2.996648, -1.893575, -0.269907>, <-3.037921, -1.919458, -0.266038>, 
      <-2.881176, -1.854613, -0.290152>, <-2.926057, -1.873874, -0.288401>, <-2.995216, -1.893163, -0.294829>, <-3.036489, -1.919047, -0.290961>, 
      <-2.863373, -1.875446, -0.288557>, <-2.904471, -1.902470, -0.289575>, <-2.971843, -1.914609, -0.307181>, <-3.012785, -1.941801, -0.305012>, 
      <-2.855118, -1.885935, -0.292596>, <-2.896216, -1.912959, -0.293614>, <-2.961106, -1.930724, -0.305879>, <-3.002048, -1.957916, -0.303710>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.888149, -1.856552, -0.278233>, <-2.881176, -1.854613, -0.290152>, <-2.863373, -1.875446, -0.288557>, <-2.855118, -1.885935, -0.292596>, 
      <-2.845750, -1.838357, -0.279887>, <-2.838776, -1.836418, -0.291807>, <-2.822914, -1.848843, -0.287555>, <-2.814659, -1.859331, -0.291594>, 
      <-2.777215, -1.828071, -0.288308>, <-2.775178, -1.822862, -0.294629>, <-2.766661, -1.821747, -0.303042>, <-2.760348, -1.819030, -0.307941>, 
      <-2.747229, -1.794711, -0.277379>, <-2.745191, -1.789502, -0.283700>, <-2.738999, -1.783516, -0.292139>, <-2.732686, -1.780799, -0.297039>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.525670, -2.363471, -0.301221>, <-3.513397, -2.379078, -0.299430>, <-3.501922, -2.397346, -0.289722>, <-3.506604, -2.400437, -0.270593>, 
      <-3.525670, -2.363471, -0.301221>, <-3.522248, -2.384216, -0.295529>, <-3.517681, -2.394468, -0.292548>, <-3.522363, -2.397559, -0.273419>, 
      <-3.525670, -2.363471, -0.301221>, <-3.522248, -2.384216, -0.295529>, <-3.539985, -2.383781, -0.287395>, <-3.542558, -2.385479, -0.276885>, 
      <-3.525670, -2.363471, -0.301221>, <-3.534521, -2.368609, -0.297320>, <-3.550000, -2.371046, -0.288856>, <-3.552572, -2.372744, -0.278346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.466382, -2.388483, -0.262889>, <-3.476333, -2.396374, -0.264475>, <-3.494205, -2.402701, -0.268369>, <-3.506604, -2.400437, -0.270593>, 
      <-3.459972, -2.384248, -0.289083>, <-3.469923, -2.392139, -0.290669>, <-3.489523, -2.399610, -0.287499>, <-3.501922, -2.397346, -0.289722>, 
      <-3.475692, -2.359238, -0.302375>, <-3.485559, -2.366929, -0.304018>, <-3.503201, -2.373158, -0.303925>, <-3.513397, -2.379078, -0.299430>, 
      <-3.492497, -2.337867, -0.304827>, <-3.502364, -2.345557, -0.306470>, <-3.515474, -2.357551, -0.305716>, <-3.525670, -2.363471, -0.301221>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.557908, -2.335196, -0.278080>, <-3.560312, -2.346289, -0.278865>, <-3.559577, -2.363837, -0.279368>, <-3.552572, -2.372744, -0.278346>, 
      <-3.557908, -2.335196, -0.278080>, <-3.555895, -2.343374, -0.296910>, <-3.557004, -2.362138, -0.289878>, <-3.550000, -2.371046, -0.288856>, 
      <-3.557908, -2.335196, -0.278080>, <-3.555895, -2.343374, -0.296910>, <-3.546098, -2.353887, -0.299009>, <-3.534521, -2.368609, -0.297320>, 
      <-3.557908, -2.335196, -0.278080>, <-3.553491, -2.332280, -0.296125>, <-3.537248, -2.348748, -0.302911>, <-3.525670, -2.363471, -0.301221>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.557908, -2.335196, -0.278080>, <-3.555237, -2.322868, -0.277208>, <-3.546588, -2.306777, -0.274726>, <-3.536627, -2.299152, -0.273140>, 
      <-3.553491, -2.332280, -0.296125>, <-3.550820, -2.319952, -0.295253>, <-3.540542, -2.302783, -0.299432>, <-3.530581, -2.295158, -0.297846>, 
      <-3.537248, -2.348748, -0.302911>, <-3.527051, -2.342829, -0.307405>, <-3.518215, -2.325401, -0.308783>, <-3.508347, -2.317710, -0.307140>, 
      <-3.525670, -2.363471, -0.301221>, <-3.515474, -2.357551, -0.305716>, <-3.502364, -2.345557, -0.306470>, <-3.492497, -2.337867, -0.304827>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.557908, -2.335196, -0.278080>, <-3.553491, -2.332280, -0.296125>, <-3.537248, -2.348748, -0.302911>, <-3.525670, -2.363471, -0.301221>, 
      <-3.560312, -2.346289, -0.278865>, <-3.555895, -2.343374, -0.296910>, <-3.524974, -2.364355, -0.301119>, <-3.513397, -2.379078, -0.299430>, 
      <-3.559577, -2.363837, -0.279368>, <-3.549562, -2.376571, -0.277907>, <-3.517681, -2.394468, -0.292548>, <-3.501922, -2.397346, -0.289722>, 
      <-3.552572, -2.372744, -0.278346>, <-3.542558, -2.385479, -0.276885>, <-3.522363, -2.397559, -0.273419>, <-3.506604, -2.400437, -0.270593>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.538830, -2.372159, -0.247455>, <-3.531400, -2.368100, -0.239126>, <-3.519817, -2.357015, -0.232617>, <-3.510514, -2.349769, -0.231203>, 
      <-3.551103, -2.356552, -0.249246>, <-3.543673, -2.352493, -0.240917>, <-3.536622, -2.335644, -0.235069>, <-3.527319, -2.328398, -0.233655>, 
      <-3.562590, -2.338287, -0.258951>, <-3.559919, -2.325959, -0.258078>, <-3.552998, -2.311012, -0.248532>, <-3.543037, -2.303386, -0.246946>, 
      <-3.557908, -2.335196, -0.278080>, <-3.555237, -2.322868, -0.277208>, <-3.546588, -2.306777, -0.274726>, <-3.536627, -2.299152, -0.273140>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.538830, -2.372159, -0.247455>, <-3.545177, -2.375626, -0.254569>, <-3.554955, -2.374317, -0.268612>, <-3.552572, -2.372744, -0.278346>, 
      <-3.538830, -2.372159, -0.247455>, <-3.557450, -2.360019, -0.256360>, <-3.561960, -2.365409, -0.269634>, <-3.559577, -2.363837, -0.279368>, 
      <-3.538830, -2.372159, -0.247455>, <-3.557450, -2.360019, -0.256360>, <-3.564994, -2.349380, -0.259735>, <-3.560312, -2.346289, -0.278865>, 
      <-3.538830, -2.372159, -0.247455>, <-3.551103, -2.356552, -0.249246>, <-3.562590, -2.338287, -0.258951>, <-3.557908, -2.335196, -0.278080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.538830, -2.372159, -0.247455>, <-3.545177, -2.375626, -0.254569>, <-3.554955, -2.374317, -0.268612>, <-3.552572, -2.372744, -0.278346>, 
      <-3.551103, -2.356552, -0.249246>, <-3.557450, -2.360019, -0.256360>, <-3.552382, -2.372619, -0.279122>, <-3.550000, -2.371046, -0.288856>, 
      <-3.562590, -2.338287, -0.258951>, <-3.558174, -2.335371, -0.276996>, <-3.546098, -2.353887, -0.299009>, <-3.534521, -2.368609, -0.297320>, 
      <-3.557908, -2.335196, -0.278080>, <-3.553491, -2.332280, -0.296125>, <-3.537248, -2.348748, -0.302911>, <-3.525670, -2.363471, -0.301221>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.538830, -2.372159, -0.247455>, <-3.551103, -2.356552, -0.249246>, <-3.562590, -2.338287, -0.258951>, <-3.557908, -2.335196, -0.278080>, 
      <-3.527254, -2.386879, -0.245766>, <-3.539528, -2.371272, -0.247557>, <-3.564994, -2.349380, -0.259735>, <-3.560312, -2.346289, -0.278865>, 
      <-3.511020, -2.403352, -0.252551>, <-3.526779, -2.400475, -0.255377>, <-3.549562, -2.376571, -0.277907>, <-3.559577, -2.363837, -0.279368>, 
      <-3.506604, -2.400437, -0.270593>, <-3.522363, -2.397559, -0.273419>, <-3.542558, -2.385479, -0.276885>, <-3.552572, -2.372744, -0.278346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.538830, -2.372159, -0.247455>, <-3.545177, -2.375626, -0.254569>, <-3.554955, -2.374317, -0.268612>, <-3.552572, -2.372744, -0.278346>, 
      <-3.538830, -2.372159, -0.247455>, <-3.533601, -2.390346, -0.252880>, <-3.544940, -2.387052, -0.267150>, <-3.542558, -2.385479, -0.276885>, 
      <-3.538830, -2.372159, -0.247455>, <-3.533601, -2.390346, -0.252880>, <-3.526779, -2.400475, -0.255377>, <-3.522363, -2.397559, -0.273419>, 
      <-3.538830, -2.372159, -0.247455>, <-3.527254, -2.386879, -0.245766>, <-3.511020, -2.403352, -0.252551>, <-3.506604, -2.400437, -0.270593>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.538830, -2.372159, -0.247455>, <-3.531400, -2.368100, -0.239126>, <-3.519817, -2.357015, -0.232617>, <-3.510514, -2.349769, -0.231203>, 
      <-3.527254, -2.386879, -0.245766>, <-3.519824, -2.382820, -0.237437>, <-3.503966, -2.377172, -0.230304>, <-3.494664, -2.369926, -0.228890>, 
      <-3.511020, -2.403352, -0.252551>, <-3.498621, -2.405617, -0.250327>, <-3.482379, -2.400368, -0.239769>, <-3.472428, -2.392477, -0.238183>, 
      <-3.506604, -2.400437, -0.270593>, <-3.494205, -2.402701, -0.268369>, <-3.476333, -2.396374, -0.264475>, <-3.466382, -2.388483, -0.262889>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.538830, -2.372159, -0.247455>, <-3.527254, -2.386879, -0.245766>, <-3.511020, -2.403352, -0.252551>, <-3.506604, -2.400437, -0.270593>, 
      <-3.545177, -2.375626, -0.254569>, <-3.533601, -2.390346, -0.252880>, <-3.506338, -2.400261, -0.271680>, <-3.501922, -2.397346, -0.289722>, 
      <-3.554955, -2.374317, -0.268612>, <-3.552382, -2.372619, -0.279122>, <-3.522248, -2.384216, -0.295529>, <-3.513397, -2.379078, -0.299430>, 
      <-3.552572, -2.372744, -0.278346>, <-3.550000, -2.371046, -0.288856>, <-3.534521, -2.368609, -0.297320>, <-3.525670, -2.363471, -0.301221>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.493096, -2.285581, -0.267762>, <-3.488753, -2.282714, -0.285505>, <-3.472779, -2.298902, -0.292177>, <-3.461395, -2.313377, -0.290516>, 
      <-3.503982, -2.293916, -0.269080>, <-3.499639, -2.291049, -0.286822>, <-3.482692, -2.306617, -0.293470>, <-3.471308, -2.321092, -0.291809>, 
      <-3.525776, -2.290845, -0.271413>, <-3.519730, -2.286851, -0.296118>, <-3.498472, -2.310014, -0.305495>, <-3.482622, -2.330170, -0.303182>, 
      <-3.536627, -2.299152, -0.273140>, <-3.530581, -2.295158, -0.297846>, <-3.508347, -2.317710, -0.307140>, <-3.492497, -2.337867, -0.304827>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.474335, -2.321921, -0.237652>, <-3.486402, -2.306577, -0.239413>, <-3.497700, -2.288621, -0.248954>, <-3.493096, -2.285581, -0.267762>, 
      <-3.485212, -2.330380, -0.238869>, <-3.497279, -2.315036, -0.240629>, <-3.508586, -2.296956, -0.250272>, <-3.503982, -2.293916, -0.269080>, 
      <-3.499679, -2.341329, -0.229556>, <-3.516484, -2.319958, -0.232009>, <-3.532186, -2.295080, -0.245219>, <-3.525776, -2.290845, -0.271413>, 
      <-3.510514, -2.349769, -0.231203>, <-3.527319, -2.328398, -0.233655>, <-3.543037, -2.303386, -0.246946>, <-3.536627, -2.299152, -0.273140>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.442652, -2.349724, -0.260402>, <-3.446994, -2.352591, -0.242663>, <-3.462953, -2.336393, -0.235991>, <-3.474335, -2.321921, -0.237652>, 
      <-3.453316, -2.358154, -0.261690>, <-3.457658, -2.361021, -0.243951>, <-3.473830, -2.344853, -0.237208>, <-3.485212, -2.330380, -0.238869>, 
      <-3.455766, -2.380064, -0.261197>, <-3.461812, -2.384058, -0.236491>, <-3.483829, -2.361486, -0.227243>, <-3.499679, -2.341329, -0.229556>, 
      <-3.466382, -2.388483, -0.262889>, <-3.472428, -2.392477, -0.238183>, <-3.494664, -2.369926, -0.228890>, <-3.510514, -2.349769, -0.231203>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.442652, -2.349724, -0.260402>, <-3.453316, -2.358154, -0.261690>, <-3.455766, -2.380064, -0.261197>, <-3.466382, -2.388483, -0.262889>, 
      <-3.438048, -2.346684, -0.279210>, <-3.448712, -2.355114, -0.280498>, <-3.449356, -2.375830, -0.287391>, <-3.459972, -2.384248, -0.289083>, 
      <-3.449328, -2.328721, -0.288755>, <-3.459241, -2.336437, -0.290048>, <-3.465816, -2.351542, -0.300730>, <-3.475692, -2.359238, -0.302375>, 
      <-3.461395, -2.313377, -0.290516>, <-3.471308, -2.321092, -0.291809>, <-3.482622, -2.330170, -0.303182>, <-3.492497, -2.337867, -0.304827>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.277324, -2.100613, -0.241753>, <-3.275931, -2.100212, -0.265998>, <-3.256688, -2.123694, -0.274299>, <-3.241735, -2.142709, -0.272116>, 
      <-3.344037, -2.154274, -0.242006>, <-3.342644, -2.153873, -0.266251>, <-3.322813, -2.174864, -0.272399>, <-3.307860, -2.193879, -0.270217>, 
      <-3.425429, -2.233771, -0.259571>, <-3.421086, -2.230903, -0.277314>, <-3.407125, -2.247806, -0.283613>, <-3.395742, -2.262281, -0.281952>, 
      <-3.493096, -2.285581, -0.267762>, <-3.488753, -2.282714, -0.285505>, <-3.472779, -2.298902, -0.292177>, <-3.461395, -2.313377, -0.290516>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.277324, -2.100613, -0.241753>, <-3.206915, -2.043979, -0.241486>, <-3.114232, -1.967315, -0.258885>, <-3.037921, -1.919458, -0.266038>, 
      <-3.275931, -2.100212, -0.265998>, <-3.205522, -2.043578, -0.265731>, <-3.112800, -1.966903, -0.283807>, <-3.036489, -1.919047, -0.290961>, 
      <-3.256688, -2.123694, -0.274299>, <-3.184510, -2.067840, -0.276372>, <-3.088756, -1.992258, -0.300988>, <-3.012785, -1.941801, -0.305012>, 
      <-3.241735, -2.142709, -0.272116>, <-3.169557, -2.086855, -0.274189>, <-3.078019, -2.008373, -0.299686>, <-3.002048, -1.957916, -0.303710>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.245788, -2.143876, -0.201591>, <-3.174093, -2.088265, -0.198998>, <-3.081227, -2.010240, -0.210454>, <-3.006815, -1.959285, -0.220743>, 
      <-3.261690, -2.123655, -0.203912>, <-3.189995, -2.068044, -0.201319>, <-3.092490, -1.993335, -0.211820>, <-3.018078, -1.942381, -0.222109>, 
      <-3.278806, -2.101040, -0.215970>, <-3.208397, -2.044406, -0.215703>, <-3.115734, -1.967746, -0.232740>, <-3.039423, -1.919889, -0.239894>, 
      <-3.277324, -2.100613, -0.241753>, <-3.206915, -2.043979, -0.241486>, <-3.114232, -1.967315, -0.258885>, <-3.037921, -1.919458, -0.266038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.245788, -2.143876, -0.201591>, <-3.261690, -2.123655, -0.203912>, <-3.278806, -2.101040, -0.215970>, <-3.277324, -2.100613, -0.241753>, 
      <-3.314966, -2.197535, -0.204093>, <-3.330868, -2.177313, -0.206414>, <-3.345519, -2.154701, -0.216222>, <-3.344037, -2.154274, -0.242006>, 
      <-3.405467, -2.268358, -0.229949>, <-3.417534, -2.253014, -0.231709>, <-3.430032, -2.236811, -0.240764>, <-3.425429, -2.233771, -0.259571>, 
      <-3.474335, -2.321921, -0.237652>, <-3.486402, -2.306577, -0.239413>, <-3.497700, -2.288621, -0.248954>, <-3.493096, -2.285581, -0.267762>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.210202, -2.185969, -0.231955>, <-3.139323, -2.134002, -0.231709>, <-2.981408, -1.994899, -0.260943>, <-2.978154, -2.009160, -0.258790>, 
      <-3.211595, -2.186370, -0.207711>, <-3.140716, -2.134403, -0.207465>, <-2.981608, -1.994956, -0.257468>, <-2.978354, -2.009217, -0.255315>, 
      <-3.230836, -2.162890, -0.199408>, <-3.159141, -2.107279, -0.196815>, <-3.069780, -2.027420, -0.209066>, <-2.995368, -1.976465, -0.219355>, 
      <-3.245788, -2.143876, -0.201591>, <-3.174093, -2.088265, -0.198998>, <-3.081227, -2.010240, -0.210454>, <-3.006815, -1.959285, -0.220743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.210202, -2.185969, -0.231955>, <-3.211595, -2.186370, -0.207711>, <-3.230836, -2.162890, -0.199408>, <-3.245788, -2.143876, -0.201591>, 
      <-3.279338, -2.236659, -0.232195>, <-3.280731, -2.237060, -0.207951>, <-3.300014, -2.216548, -0.201910>, <-3.314966, -2.197535, -0.204093>, 
      <-3.375700, -2.296797, -0.252317>, <-3.380042, -2.299664, -0.234579>, <-3.394086, -2.282831, -0.228288>, <-3.405467, -2.268358, -0.229949>, 
      <-3.442652, -2.349724, -0.260402>, <-3.446994, -2.352591, -0.242663>, <-3.462953, -2.336393, -0.235991>, <-3.474335, -2.321921, -0.237652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.210202, -2.185969, -0.231955>, <-3.279338, -2.236659, -0.232195>, <-3.375700, -2.296797, -0.252317>, <-3.442652, -2.349724, -0.260402>, 
      <-3.208720, -2.185543, -0.257737>, <-3.277856, -2.236232, -0.257977>, <-3.371096, -2.293757, -0.271126>, <-3.438048, -2.346684, -0.279210>, 
      <-3.225834, -2.162930, -0.269795>, <-3.291959, -2.214100, -0.267896>, <-3.383674, -2.277626, -0.280191>, <-3.449328, -2.328721, -0.288755>, 
      <-3.241735, -2.142709, -0.272116>, <-3.307860, -2.193879, -0.270217>, <-3.395742, -2.262281, -0.281952>, <-3.461395, -2.313377, -0.290516>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.210202, -2.185969, -0.231955>, <-3.208720, -2.185543, -0.257737>, <-3.225834, -2.162930, -0.269795>, <-3.241735, -2.142709, -0.272116>, 
      <-3.139323, -2.134002, -0.231709>, <-3.137841, -2.133575, -0.257491>, <-3.153656, -2.107075, -0.271868>, <-3.169557, -2.086855, -0.274189>, 
      <-2.981408, -1.994899, -0.260943>, <-2.981199, -1.994838, -0.264581>, <-3.066034, -2.026361, -0.298232>, <-3.078019, -2.008373, -0.299686>, 
      <-2.978154, -2.009160, -0.258790>, <-2.977945, -2.009100, -0.262428>, <-2.990063, -1.975904, -0.302257>, <-3.002048, -1.957916, -0.303710>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.352988, -2.777879, -0.270309>, <-3.331820, -2.791088, -0.268534>, <-3.309989, -2.808106, -0.256213>, <-3.314382, -2.813281, -0.232137>, 
      <-3.352988, -2.777879, -0.270309>, <-3.340258, -2.801004, -0.263152>, <-3.330126, -2.811481, -0.259142>, <-3.334519, -2.816656, -0.235067>, 
      <-3.352988, -2.777879, -0.270309>, <-3.340258, -2.801004, -0.263152>, <-3.361434, -2.807942, -0.252195>, <-3.363909, -2.810857, -0.238634>, 
      <-3.352988, -2.777879, -0.270309>, <-3.361426, -2.787796, -0.264927>, <-3.378890, -2.797050, -0.253658>, <-3.381364, -2.799965, -0.240097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.271599, -2.781568, -0.224126>, <-3.280006, -2.795277, -0.225679>, <-3.298610, -2.810637, -0.229842>, <-3.314382, -2.813281, -0.232137>, 
      <-3.265581, -2.774483, -0.257092>, <-3.273988, -2.788192, -0.258646>, <-3.294217, -2.805463, -0.253918>, <-3.309989, -2.808106, -0.256213>, 
      <-3.295470, -2.751173, -0.273968>, <-3.303922, -2.764703, -0.275610>, <-3.322215, -2.779800, -0.274661>, <-3.331820, -2.791088, -0.268534>, 
      <-3.324455, -2.733086, -0.276397>, <-3.332907, -2.746615, -0.278039>, <-3.343383, -2.766592, -0.276435>, <-3.352988, -2.777879, -0.270309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.404155, -2.757263, -0.239663>, <-3.402168, -2.771622, -0.240519>, <-3.393653, -2.792297, -0.241127>, <-3.381364, -2.799965, -0.240097>, 
      <-3.404155, -2.757263, -0.239663>, <-3.397891, -2.766584, -0.263960>, <-3.391178, -2.789382, -0.254688>, <-3.378890, -2.797050, -0.253658>, 
      <-3.404155, -2.757263, -0.239663>, <-3.397891, -2.766584, -0.263960>, <-3.382036, -2.774935, -0.266654>, <-3.361426, -2.787796, -0.264927>, 
      <-3.404155, -2.757263, -0.239663>, <-3.399878, -2.752225, -0.263104>, <-3.373598, -2.765018, -0.272037>, <-3.352988, -2.777879, -0.270309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.404155, -2.757263, -0.239663>, <-3.406352, -2.741381, -0.238716>, <-3.403109, -2.718343, -0.235992>, <-3.394521, -2.704862, -0.234428>, 
      <-3.399878, -2.752225, -0.263104>, <-3.402075, -2.736343, -0.262157>, <-3.397250, -2.711445, -0.268090>, <-3.388661, -2.697964, -0.266526>, 
      <-3.373598, -2.765018, -0.272037>, <-3.363993, -2.753731, -0.278163>, <-3.361130, -2.729004, -0.280404>, <-3.352677, -2.715475, -0.278762>, 
      <-3.352988, -2.777879, -0.270309>, <-3.343383, -2.766592, -0.276435>, <-3.332907, -2.746615, -0.278039>, <-3.324455, -2.733086, -0.276397>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.404155, -2.757263, -0.239663>, <-3.399878, -2.752225, -0.263104>, <-3.373598, -2.765018, -0.272037>, <-3.352988, -2.777879, -0.270309>, 
      <-3.402168, -2.771622, -0.240519>, <-3.397891, -2.766584, -0.263960>, <-3.352430, -2.778227, -0.270262>, <-3.331820, -2.791088, -0.268534>, 
      <-3.393653, -2.792297, -0.241127>, <-3.376198, -2.803189, -0.239664>, <-3.330126, -2.811481, -0.259142>, <-3.309989, -2.808106, -0.256213>, 
      <-3.381364, -2.799965, -0.240097>, <-3.363909, -2.810857, -0.238634>, <-3.334519, -2.816656, -0.235067>, <-3.314382, -2.813281, -0.232137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.365546, -2.792671, -0.201488>, <-3.358494, -2.784389, -0.191197>, <-3.349566, -2.765981, -0.183523>, <-3.341659, -2.753338, -0.182159>, 
      <-3.386716, -2.779461, -0.203263>, <-3.379664, -2.771179, -0.192972>, <-3.378550, -2.747894, -0.185952>, <-3.370644, -2.735251, -0.184588>, 
      <-3.408548, -2.762438, -0.215585>, <-3.410746, -2.746557, -0.214638>, <-3.409128, -2.725428, -0.203026>, <-3.400539, -2.711946, -0.201462>, 
      <-3.404155, -2.757263, -0.239663>, <-3.406352, -2.741381, -0.238716>, <-3.403109, -2.718343, -0.235992>, <-3.394521, -2.704862, -0.234428>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.365546, -2.792671, -0.201488>, <-3.371530, -2.799699, -0.210221>, <-3.383596, -2.802593, -0.227867>, <-3.381364, -2.799965, -0.240097>, 
      <-3.365546, -2.792671, -0.201488>, <-3.392701, -2.786489, -0.211996>, <-3.395884, -2.794925, -0.228897>, <-3.393653, -2.792297, -0.241127>, 
      <-3.365546, -2.792671, -0.201488>, <-3.392701, -2.786489, -0.211996>, <-3.406562, -2.776798, -0.216441>, <-3.402168, -2.771622, -0.240519>, 
      <-3.365546, -2.792671, -0.201488>, <-3.386716, -2.779461, -0.203263>, <-3.408548, -2.762438, -0.215585>, <-3.404155, -2.757263, -0.239663>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.365546, -2.792671, -0.201488>, <-3.371530, -2.799699, -0.210221>, <-3.383596, -2.802593, -0.227867>, <-3.381364, -2.799965, -0.240097>, 
      <-3.386716, -2.779461, -0.203263>, <-3.392701, -2.786489, -0.211996>, <-3.381121, -2.799679, -0.241428>, <-3.378890, -2.797050, -0.253658>, 
      <-3.408548, -2.762438, -0.215585>, <-3.404271, -2.757400, -0.239026>, <-3.382036, -2.774935, -0.266654>, <-3.361426, -2.787796, -0.264927>, 
      <-3.404155, -2.757263, -0.239663>, <-3.399878, -2.752225, -0.263104>, <-3.373598, -2.765018, -0.272037>, <-3.352988, -2.777879, -0.270309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.365546, -2.792671, -0.201488>, <-3.386716, -2.779461, -0.203263>, <-3.408548, -2.762438, -0.215585>, <-3.404155, -2.757263, -0.239663>, 
      <-3.344937, -2.805531, -0.199760>, <-3.366107, -2.792320, -0.201535>, <-3.406562, -2.776798, -0.216441>, <-3.402168, -2.771622, -0.240519>, 
      <-3.318659, -2.818319, -0.208697>, <-3.338796, -2.821694, -0.211627>, <-3.376198, -2.803189, -0.239664>, <-3.393653, -2.792297, -0.241127>, 
      <-3.314382, -2.813281, -0.232137>, <-3.334519, -2.816656, -0.235067>, <-3.363909, -2.810857, -0.238634>, <-3.381364, -2.799965, -0.240097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.365546, -2.792671, -0.201488>, <-3.371530, -2.799699, -0.210221>, <-3.383596, -2.802593, -0.227867>, <-3.381364, -2.799965, -0.240097>, 
      <-3.365546, -2.792671, -0.201488>, <-3.350921, -2.812559, -0.208493>, <-3.366141, -2.813485, -0.226404>, <-3.363909, -2.810857, -0.238634>, 
      <-3.365546, -2.792671, -0.201488>, <-3.350921, -2.812559, -0.208493>, <-3.338796, -2.821694, -0.211627>, <-3.334519, -2.816656, -0.235067>, 
      <-3.365546, -2.792671, -0.201488>, <-3.344937, -2.805531, -0.199760>, <-3.318659, -2.818319, -0.208697>, <-3.314382, -2.813281, -0.232137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.365546, -2.792671, -0.201488>, <-3.358494, -2.784389, -0.191197>, <-3.349566, -2.765981, -0.183523>, <-3.341659, -2.753338, -0.182159>, 
      <-3.344937, -2.805531, -0.199760>, <-3.337885, -2.797249, -0.189470>, <-3.321345, -2.783591, -0.181158>, <-3.313438, -2.770948, -0.179794>, 
      <-3.318659, -2.818319, -0.208697>, <-3.302887, -2.815675, -0.206402>, <-3.285866, -2.802175, -0.193582>, <-3.277459, -2.788466, -0.192029>, 
      <-3.314382, -2.813281, -0.232137>, <-3.298610, -2.810637, -0.229842>, <-3.280006, -2.795277, -0.225679>, <-3.271599, -2.781568, -0.224126>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.365546, -2.792671, -0.201488>, <-3.344937, -2.805531, -0.199760>, <-3.318659, -2.818319, -0.208697>, <-3.314382, -2.813281, -0.232137>, 
      <-3.371530, -2.799699, -0.210221>, <-3.350921, -2.812559, -0.208493>, <-3.314266, -2.813144, -0.232773>, <-3.309989, -2.808106, -0.256213>, 
      <-3.383596, -2.802593, -0.227867>, <-3.381121, -2.799679, -0.241428>, <-3.340258, -2.801004, -0.263152>, <-3.331820, -2.791088, -0.268534>, 
      <-3.381364, -2.799965, -0.240097>, <-3.378890, -2.797050, -0.253658>, <-3.361426, -2.787796, -0.264927>, <-3.352988, -2.777879, -0.270309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.348452, -2.669826, -0.229521>, <-3.344246, -2.664874, -0.252569>, <-3.318408, -2.677450, -0.261352>, <-3.298144, -2.690095, -0.259654>, 
      <-3.357800, -2.684485, -0.230696>, <-3.353594, -2.679533, -0.253744>, <-3.326843, -2.690916, -0.262537>, <-3.306579, -2.703561, -0.260839>, 
      <-3.385203, -2.690235, -0.232731>, <-3.379343, -2.683337, -0.264830>, <-3.344279, -2.702033, -0.277131>, <-3.316057, -2.719644, -0.274765>, 
      <-3.394521, -2.704862, -0.234428>, <-3.388661, -2.697964, -0.266526>, <-3.352677, -2.715475, -0.278762>, <-3.324455, -2.733086, -0.276397>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.310492, -2.704635, -0.191989>, <-3.331305, -2.691647, -0.193733>, <-3.352772, -2.674913, -0.205849>, <-3.348452, -2.669826, -0.229521>, 
      <-3.319824, -2.719515, -0.193041>, <-3.340637, -2.706527, -0.194786>, <-3.362120, -2.689572, -0.207024>, <-3.357800, -2.684485, -0.230696>, 
      <-3.332368, -2.738482, -0.180556>, <-3.361353, -2.720394, -0.182985>, <-3.391221, -2.697320, -0.199765>, <-3.385203, -2.690235, -0.232731>, 
      <-3.341659, -2.753338, -0.182159>, <-3.370644, -2.735251, -0.184588>, <-3.400539, -2.711946, -0.201462>, <-3.394521, -2.704862, -0.234428>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.260185, -2.724906, -0.222124>, <-3.264391, -2.729859, -0.199076>, <-3.290228, -2.717280, -0.190291>, <-3.310492, -2.704635, -0.191989>, 
      <-3.269265, -2.739646, -0.223275>, <-3.273471, -2.744599, -0.200227>, <-3.299560, -2.732160, -0.191343>, <-3.319824, -2.719515, -0.193041>, 
      <-3.262571, -2.766846, -0.222458>, <-3.268430, -2.773744, -0.190361>, <-3.304148, -2.756092, -0.178191>, <-3.332368, -2.738482, -0.180556>, 
      <-3.271599, -2.781568, -0.224126>, <-3.277459, -2.788466, -0.192029>, <-3.313438, -2.770948, -0.179794>, <-3.341659, -2.753338, -0.182159>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.260185, -2.724906, -0.222124>, <-3.269265, -2.739646, -0.223275>, <-3.262571, -2.766846, -0.222458>, <-3.271599, -2.781568, -0.224126>, 
      <-3.255865, -2.719819, -0.245796>, <-3.264945, -2.734559, -0.246947>, <-3.256552, -2.759761, -0.255424>, <-3.265581, -2.774483, -0.257092>, 
      <-3.277331, -2.703083, -0.257910>, <-3.285766, -2.716548, -0.259095>, <-3.287072, -2.737731, -0.272336>, <-3.295470, -2.751173, -0.273968>, 
      <-3.298144, -2.690095, -0.259654>, <-3.306579, -2.703561, -0.260839>, <-3.316057, -2.719644, -0.274765>, <-3.324455, -2.733086, -0.276397>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.171582, -2.355228, -0.206403>, <-3.169777, -2.354710, -0.237798>, <-3.136891, -2.374533, -0.248544>, <-3.110277, -2.391142, -0.246313>, 
      <-3.224589, -2.449800, -0.202213>, <-3.222784, -2.449281, -0.233608>, <-3.193533, -2.463967, -0.243130>, <-3.166919, -2.480576, -0.240900>, 
      <-3.290254, -2.578554, -0.222205>, <-3.286048, -2.573602, -0.245253>, <-3.262296, -2.587865, -0.253471>, <-3.242033, -2.600510, -0.251772>, 
      <-3.348452, -2.669826, -0.229521>, <-3.344246, -2.664874, -0.252569>, <-3.318408, -2.677450, -0.261352>, <-3.298144, -2.690095, -0.259654>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.171582, -2.355228, -0.206403>, <-3.112968, -2.250653, -0.211036>, <-2.973712, -2.028627, -0.255851>, <-2.978154, -2.009160, -0.258790>, 
      <-3.169777, -2.354710, -0.237798>, <-3.111164, -2.250134, -0.242431>, <-2.973417, -2.028542, -0.260994>, <-2.977859, -2.009075, -0.263933>, 
      <-3.136891, -2.374533, -0.248544>, <-3.074878, -2.276618, -0.254470>, <-2.990816, -2.142169, -0.286907>, <-2.926078, -2.046822, -0.300540>, 
      <-3.110277, -2.391142, -0.246313>, <-3.048264, -2.293228, -0.252239>, <-2.968793, -2.163202, -0.283683>, <-2.904055, -2.067855, -0.297316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.115432, -2.392622, -0.156647>, <-3.053934, -2.295080, -0.156622>, <-2.974490, -2.164458, -0.179427>, <-2.910116, -2.069598, -0.191827>, 
      <-3.142808, -2.375537, -0.158941>, <-3.081311, -2.277996, -0.158916>, <-2.998867, -2.141177, -0.182996>, <-2.934492, -2.046317, -0.195396>, 
      <-3.173439, -2.355761, -0.174109>, <-3.114825, -2.251186, -0.178742>, <-2.974039, -2.028721, -0.250159>, <-2.978481, -2.009254, -0.253098>, 
      <-3.171582, -2.355228, -0.206403>, <-3.112968, -2.250653, -0.211036>, <-2.973712, -2.028627, -0.255851>, <-2.978154, -2.009160, -0.258790>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.115432, -2.392622, -0.156647>, <-3.142808, -2.375537, -0.158941>, <-3.173439, -2.355761, -0.174109>, <-3.171582, -2.355228, -0.206403>, 
      <-3.174577, -2.486432, -0.156671>, <-3.201953, -2.469347, -0.158965>, <-3.226445, -2.450333, -0.169919>, <-3.224589, -2.449800, -0.202213>, 
      <-3.251676, -2.610853, -0.185356>, <-3.272489, -2.597865, -0.187100>, <-3.294574, -2.583641, -0.198533>, <-3.290254, -2.578554, -0.222205>, 
      <-3.310492, -2.704635, -0.191989>, <-3.331305, -2.691647, -0.193733>, <-3.352772, -2.674913, -0.205849>, <-3.348452, -2.669826, -0.229521>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.054124, -2.428530, -0.196559>, <-2.993279, -2.337494, -0.199454>, <-2.876538, -2.120950, -0.241463>, <-2.858307, -2.123621, -0.241244>, 
      <-3.055929, -2.429048, -0.165164>, <-2.995084, -2.338013, -0.168059>, <-2.876798, -2.121024, -0.236945>, <-2.858567, -2.123696, -0.236725>, 
      <-3.088818, -2.409231, -0.154417>, <-3.027320, -2.311690, -0.154392>, <-2.955140, -2.182939, -0.176594>, <-2.890765, -2.088079, -0.188994>, 
      <-3.115432, -2.392622, -0.156647>, <-3.053934, -2.295080, -0.156622>, <-2.974490, -2.164458, -0.179427>, <-2.910116, -2.069598, -0.191827>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.054124, -2.428530, -0.196559>, <-3.055929, -2.429048, -0.165164>, <-3.088818, -2.409231, -0.154417>, <-3.115432, -2.392622, -0.156647>, 
      <-3.114429, -2.518757, -0.193690>, <-3.116234, -2.519275, -0.162295>, <-3.147963, -2.503041, -0.154440>, <-3.174577, -2.486432, -0.156671>, 
      <-3.203371, -2.632677, -0.214922>, <-3.207577, -2.637630, -0.191874>, <-3.231411, -2.623498, -0.183658>, <-3.251676, -2.610853, -0.185356>, 
      <-3.260185, -2.724906, -0.222124>, <-3.264391, -2.729859, -0.199076>, <-3.290228, -2.717280, -0.190291>, <-3.310492, -2.704635, -0.191989>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.054124, -2.428530, -0.196559>, <-3.114429, -2.518757, -0.193690>, <-3.203371, -2.632677, -0.214922>, <-3.260185, -2.724906, -0.222124>, 
      <-3.052268, -2.427997, -0.228852>, <-3.112572, -2.518224, -0.225983>, <-3.199052, -2.627591, -0.238594>, <-3.255865, -2.719819, -0.245796>, 
      <-3.082901, -2.408226, -0.244019>, <-3.139543, -2.497660, -0.238606>, <-3.221220, -2.613498, -0.250028>, <-3.277331, -2.703083, -0.257910>, 
      <-3.110277, -2.391142, -0.246313>, <-3.166919, -2.480576, -0.240900>, <-3.242033, -2.600510, -0.251772>, <-3.298144, -2.690095, -0.259654>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.054124, -2.428530, -0.196559>, <-3.052268, -2.427997, -0.228852>, <-3.082901, -2.408226, -0.244019>, <-3.110277, -2.391142, -0.246313>, 
      <-2.993279, -2.337494, -0.199454>, <-2.991422, -2.336961, -0.231747>, <-3.020888, -2.310312, -0.249945>, <-3.048264, -2.293228, -0.252239>, 
      <-2.876538, -2.120950, -0.241463>, <-2.876274, -2.120873, -0.246066>, <-2.949082, -2.182027, -0.280797>, <-2.968793, -2.163202, -0.283683>, 
      <-2.858307, -2.123621, -0.241244>, <-2.858042, -2.123545, -0.245847>, <-2.884344, -2.086680, -0.294430>, <-2.904055, -2.067855, -0.297316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.003860, -2.861854, -0.248766>, <-2.982520, -2.869418, -0.247530>, <-2.959454, -2.880362, -0.236381>, <-2.962423, -2.885535, -0.214505>, 
      <-3.003860, -2.861854, -0.248766>, <-2.988118, -2.879928, -0.242399>, <-2.976793, -2.887384, -0.238664>, <-2.979762, -2.892557, -0.216789>, 
      <-3.003860, -2.861854, -0.248766>, <-2.988118, -2.879928, -0.242399>, <-3.005505, -2.890202, -0.232004>, <-3.007202, -2.893160, -0.219494>, 
      <-3.003860, -2.861854, -0.248766>, <-3.009458, -2.872364, -0.243635>, <-3.023241, -2.883916, -0.233032>, <-3.024939, -2.886874, -0.220522>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.930573, -2.848655, -0.208094>, <-2.935322, -2.862561, -0.209311>, <-2.948857, -2.880041, -0.212718>, <-2.962423, -2.885535, -0.214505>, 
      <-2.926508, -2.841570, -0.238049>, <-2.931257, -2.855476, -0.239266>, <-2.945889, -2.874868, -0.234594>, <-2.959454, -2.880362, -0.236381>, 
      <-2.958087, -2.826581, -0.253320>, <-2.962928, -2.840382, -0.254621>, <-2.976182, -2.857517, -0.253340>, <-2.982520, -2.869418, -0.247530>, 
      <-2.987308, -2.816223, -0.255014>, <-2.992148, -2.830023, -0.256315>, <-2.997521, -2.849953, -0.254576>, <-3.003860, -2.861854, -0.248766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.053878, -2.853120, -0.219804>, <-3.049218, -2.865595, -0.220584>, <-3.037494, -2.882424, -0.221249>, <-3.024939, -2.886874, -0.220522>, 
      <-3.053878, -2.853120, -0.219804>, <-3.046264, -2.860449, -0.242350>, <-3.035796, -2.879466, -0.233759>, <-3.023241, -2.883916, -0.233032>, 
      <-3.053878, -2.853120, -0.219804>, <-3.046264, -2.860449, -0.242350>, <-3.030690, -2.864839, -0.244865>, <-3.009458, -2.872364, -0.243635>, 
      <-3.053878, -2.853120, -0.219804>, <-3.050924, -2.847973, -0.241569>, <-3.025092, -2.854329, -0.249996>, <-3.003860, -2.861854, -0.248766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.053878, -2.853120, -0.219804>, <-3.059023, -2.839346, -0.218942>, <-3.060779, -2.818071, -0.216583>, <-3.055799, -2.804264, -0.215354>, 
      <-3.050924, -2.847973, -0.241569>, <-3.056070, -2.834199, -0.240708>, <-3.056735, -2.811022, -0.246386>, <-3.051755, -2.797215, -0.245158>, 
      <-3.025092, -2.854329, -0.249996>, <-3.018753, -2.842428, -0.255806>, <-3.021222, -2.819717, -0.258000>, <-3.016381, -2.805917, -0.256700>, 
      <-3.003860, -2.861854, -0.248766>, <-2.997521, -2.849953, -0.254576>, <-2.992148, -2.830023, -0.256315>, <-2.987308, -2.816223, -0.255014>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.053878, -2.853120, -0.219804>, <-3.050924, -2.847973, -0.241569>, <-3.025092, -2.854329, -0.249996>, <-3.003860, -2.861854, -0.248766>, 
      <-3.049218, -2.865595, -0.220584>, <-3.046264, -2.860449, -0.242350>, <-3.003752, -2.861892, -0.248760>, <-2.982520, -2.869418, -0.247530>, 
      <-3.037494, -2.882424, -0.221249>, <-3.019757, -2.888710, -0.220222>, <-2.976793, -2.887384, -0.238664>, <-2.959454, -2.880362, -0.236381>, 
      <-3.024939, -2.886874, -0.220522>, <-3.007202, -2.893160, -0.219494>, <-2.979762, -2.892557, -0.216789>, <-2.962423, -2.885535, -0.214505>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.012440, -2.876805, -0.185541>, <-3.007829, -2.867868, -0.176263>, <-3.003578, -2.849570, -0.169493>, <-2.999056, -2.836700, -0.168436>, 
      <-3.033781, -2.869241, -0.186778>, <-3.029170, -2.860304, -0.177500>, <-3.032801, -2.839211, -0.171188>, <-3.028279, -2.826341, -0.170130>, 
      <-3.056847, -2.858294, -0.197927>, <-3.061992, -2.844520, -0.197065>, <-3.064844, -2.825156, -0.186625>, <-3.059864, -2.811349, -0.185397>, 
      <-3.053878, -2.853120, -0.219804>, <-3.059023, -2.839346, -0.218942>, <-3.060779, -2.818071, -0.216583>, <-3.055799, -2.804264, -0.215354>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.012440, -2.876805, -0.185541>, <-3.016330, -2.884347, -0.193370>, <-3.026451, -2.889508, -0.209382>, <-3.024939, -2.886874, -0.220522>, 
      <-3.012440, -2.876805, -0.185541>, <-3.037671, -2.876783, -0.194607>, <-3.039006, -2.885058, -0.210110>, <-3.037494, -2.882424, -0.221249>, 
      <-3.012440, -2.876805, -0.185541>, <-3.037671, -2.876783, -0.194607>, <-3.052186, -2.870769, -0.198708>, <-3.049218, -2.865595, -0.220584>, 
      <-3.012440, -2.876805, -0.185541>, <-3.033781, -2.869241, -0.186778>, <-3.056847, -2.858294, -0.197927>, <-3.053878, -2.853120, -0.219804>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.012440, -2.876805, -0.185541>, <-3.016330, -2.884347, -0.193370>, <-3.026451, -2.889508, -0.209382>, <-3.024939, -2.886874, -0.220522>, 
      <-3.033781, -2.869241, -0.186778>, <-3.037671, -2.876783, -0.194607>, <-3.024753, -2.886550, -0.221892>, <-3.023241, -2.883916, -0.233032>, 
      <-3.056847, -2.858294, -0.197927>, <-3.053893, -2.853147, -0.219692>, <-3.030690, -2.864839, -0.244865>, <-3.009458, -2.872364, -0.243635>, 
      <-3.053878, -2.853120, -0.219804>, <-3.050924, -2.847973, -0.241569>, <-3.025092, -2.854329, -0.249996>, <-3.003860, -2.861854, -0.248766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.012440, -2.876805, -0.185541>, <-3.033781, -2.869241, -0.186778>, <-3.056847, -2.858294, -0.197927>, <-3.053878, -2.853120, -0.219804>, 
      <-2.991208, -2.884330, -0.184311>, <-3.012549, -2.876766, -0.185547>, <-3.052186, -2.870769, -0.198708>, <-3.049218, -2.865595, -0.220584>, 
      <-2.965377, -2.890682, -0.192740>, <-2.982715, -2.897704, -0.195024>, <-3.019757, -2.888710, -0.220222>, <-3.037494, -2.882424, -0.221249>, 
      <-2.962423, -2.885535, -0.214505>, <-2.979762, -2.892557, -0.216789>, <-3.007202, -2.893160, -0.219494>, <-3.024939, -2.886874, -0.220522>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.012440, -2.876805, -0.185541>, <-3.016330, -2.884347, -0.193370>, <-3.026451, -2.889508, -0.209382>, <-3.024939, -2.886874, -0.220522>, 
      <-3.012440, -2.876805, -0.185541>, <-2.995099, -2.891872, -0.192140>, <-3.008714, -2.895795, -0.208355>, <-3.007202, -2.893160, -0.219494>, 
      <-3.012440, -2.876805, -0.185541>, <-2.995099, -2.891872, -0.192140>, <-2.982715, -2.897704, -0.195024>, <-2.979762, -2.892557, -0.216789>, 
      <-3.012440, -2.876805, -0.185541>, <-2.991208, -2.884330, -0.184311>, <-2.965377, -2.890682, -0.192740>, <-2.962423, -2.885535, -0.214505>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.012440, -2.876805, -0.185541>, <-3.007829, -2.867868, -0.176263>, <-3.003578, -2.849570, -0.169493>, <-2.999056, -2.836700, -0.168436>, 
      <-2.991208, -2.884330, -0.184311>, <-2.986598, -2.875393, -0.175033>, <-2.974508, -2.859875, -0.167808>, <-2.969986, -2.847005, -0.166751>, 
      <-2.965377, -2.890682, -0.192740>, <-2.951811, -2.885188, -0.190953>, <-2.939365, -2.869609, -0.179510>, <-2.934617, -2.855703, -0.178293>, 
      <-2.962423, -2.885535, -0.214505>, <-2.948857, -2.880041, -0.212718>, <-2.935322, -2.862561, -0.209311>, <-2.930573, -2.848655, -0.208094>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.012440, -2.876805, -0.185541>, <-2.991208, -2.884330, -0.184311>, <-2.965377, -2.890682, -0.192740>, <-2.962423, -2.885535, -0.214505>, 
      <-3.016330, -2.884347, -0.193370>, <-2.995099, -2.891872, -0.192140>, <-2.962408, -2.885509, -0.214616>, <-2.959454, -2.880362, -0.236381>, 
      <-3.026451, -2.889508, -0.209382>, <-3.024753, -2.886550, -0.221892>, <-2.988118, -2.879928, -0.242399>, <-2.982520, -2.869418, -0.247530>, 
      <-3.024939, -2.886874, -0.220522>, <-3.023241, -2.883916, -0.233032>, <-3.009458, -2.872364, -0.243635>, <-3.003860, -2.861854, -0.248766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.021661, -2.763799, -0.211856>, <-3.018758, -2.758739, -0.233257>, <-2.993356, -2.764988, -0.241543>, <-2.972480, -2.772388, -0.240333>, 
      <-3.027064, -2.778747, -0.212707>, <-3.024160, -2.773686, -0.234108>, <-2.998187, -2.778699, -0.242424>, <-2.977310, -2.786100, -0.241214>, 
      <-3.050417, -2.789343, -0.214026>, <-3.046373, -2.782295, -0.243830>, <-3.011580, -2.792228, -0.255409>, <-2.982507, -2.802533, -0.253724>, 
      <-3.055799, -2.804264, -0.215354>, <-3.051755, -2.797215, -0.245158>, <-3.016381, -2.805917, -0.256700>, <-2.987308, -2.816223, -0.255014>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.980914, -2.787087, -0.178169>, <-3.001898, -2.779649, -0.179385>, <-3.024580, -2.768885, -0.190345>, <-3.021661, -2.763799, -0.211856>, 
      <-2.986274, -2.802266, -0.178909>, <-3.007257, -2.794828, -0.180126>, <-3.029982, -2.783833, -0.191196>, <-3.027064, -2.778747, -0.212707>, 
      <-2.993730, -2.821542, -0.167190>, <-3.022953, -2.811183, -0.168885>, <-3.054482, -2.796429, -0.184069>, <-3.050417, -2.789343, -0.214026>, 
      <-2.999056, -2.836700, -0.168436>, <-3.028279, -2.826341, -0.170130>, <-3.059864, -2.811349, -0.185397>, <-3.055799, -2.804264, -0.215354>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.931736, -2.795676, -0.206644>, <-2.934639, -2.800736, -0.185244>, <-2.960039, -2.794487, -0.176959>, <-2.980914, -2.787087, -0.178169>, 
      <-2.936902, -2.810694, -0.207481>, <-2.939805, -2.815754, -0.186081>, <-2.965399, -2.809666, -0.177700>, <-2.986274, -2.802266, -0.178909>, 
      <-2.925451, -2.833656, -0.206782>, <-2.929494, -2.840705, -0.176981>, <-2.964660, -2.831847, -0.165505>, <-2.993730, -2.821542, -0.167190>, 
      <-2.930573, -2.848655, -0.208094>, <-2.934617, -2.855703, -0.178293>, <-2.969986, -2.847005, -0.166751>, <-2.999056, -2.836700, -0.168436>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.931736, -2.795676, -0.206644>, <-2.936902, -2.810694, -0.207481>, <-2.925451, -2.833656, -0.206782>, <-2.930573, -2.848655, -0.208094>, 
      <-2.928818, -2.790590, -0.228155>, <-2.933983, -2.805608, -0.228991>, <-2.921386, -2.826571, -0.236737>, <-2.926508, -2.841570, -0.238049>, 
      <-2.951497, -2.779826, -0.239117>, <-2.956327, -2.793538, -0.239998>, <-2.953286, -2.812892, -0.252030>, <-2.958087, -2.826581, -0.253320>, 
      <-2.972480, -2.772388, -0.240333>, <-2.977310, -2.786100, -0.241214>, <-2.982507, -2.802533, -0.253724>, <-2.987308, -2.816223, -0.255014>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.926741, -2.447196, -0.195028>, <-2.925069, -2.446715, -0.224121>, <-2.891972, -2.458002, -0.234206>, <-2.864543, -2.467725, -0.232616>, 
      <-2.951265, -2.543304, -0.190616>, <-2.949593, -2.542823, -0.219709>, <-2.924687, -2.549094, -0.227908>, <-2.897258, -2.558817, -0.226318>, 
      <-2.987960, -2.670558, -0.206548>, <-2.985057, -2.665498, -0.227950>, <-2.961189, -2.673672, -0.235674>, <-2.940313, -2.681073, -0.234464>, 
      <-3.021661, -2.763799, -0.211856>, <-3.018758, -2.758739, -0.233257>, <-2.993356, -2.764988, -0.241543>, <-2.972480, -2.772388, -0.240333>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.926741, -2.447196, -0.195028>, <-2.901995, -2.350219, -0.199480>, <-2.841632, -2.126065, -0.241044>, <-2.858307, -2.123621, -0.241244>, 
      <-2.925069, -2.446715, -0.224121>, <-2.900323, -2.349737, -0.228573>, <-2.841278, -2.125963, -0.247203>, <-2.857953, -2.123519, -0.247404>, 
      <-2.891972, -2.458002, -0.234206>, <-2.856130, -2.358204, -0.241106>, <-2.817713, -2.225025, -0.271884>, <-2.779554, -2.126865, -0.286046>, 
      <-2.864543, -2.467725, -0.232616>, <-2.828701, -2.367927, -0.239516>, <-2.782940, -2.236543, -0.270005>, <-2.744781, -2.138383, -0.284168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.869262, -2.469083, -0.150505>, <-2.833831, -2.369650, -0.151950>, <-2.788144, -2.237878, -0.176139>, <-2.750332, -2.139980, -0.187570>, 
      <-2.896841, -2.459307, -0.152104>, <-2.861410, -2.359874, -0.153548>, <-2.822752, -2.226415, -0.178009>, <-2.784940, -2.128517, -0.189439>, 
      <-2.928422, -2.447680, -0.165776>, <-2.903676, -2.350702, -0.170228>, <-2.841985, -2.126166, -0.234913>, <-2.858659, -2.123722, -0.235114>, 
      <-2.926741, -2.447196, -0.195028>, <-2.901995, -2.350219, -0.199480>, <-2.841632, -2.126065, -0.241044>, <-2.858307, -2.123621, -0.241244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.869262, -2.469083, -0.150505>, <-2.896841, -2.459307, -0.152104>, <-2.928422, -2.447680, -0.165776>, <-2.926741, -2.447196, -0.195028>, 
      <-2.903311, -2.564639, -0.149117>, <-2.930890, -2.554863, -0.150715>, <-2.952946, -2.543788, -0.161365>, <-2.951265, -2.543304, -0.190616>, 
      <-2.947174, -2.691525, -0.173508>, <-2.968158, -2.684087, -0.174724>, <-2.990879, -2.675645, -0.185037>, <-2.987960, -2.670558, -0.206548>, 
      <-2.980914, -2.787087, -0.178169>, <-3.001898, -2.779649, -0.179385>, <-3.024580, -2.768885, -0.190345>, <-3.021661, -2.763799, -0.211856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.807076, -2.489614, -0.188092>, <-2.768718, -2.396757, -0.191866>, <-2.695470, -2.185240, -0.231256>, <-2.678693, -2.183114, -0.231543>, 
      <-2.808748, -2.490095, -0.159003>, <-2.770389, -2.397238, -0.162777>, <-2.695744, -2.185319, -0.226496>, <-2.678967, -2.183193, -0.226783>, 
      <-2.841836, -2.478805, -0.148915>, <-2.806405, -2.379371, -0.150360>, <-2.761273, -2.246778, -0.174688>, <-2.723461, -2.148880, -0.186119>, 
      <-2.869262, -2.469083, -0.150505>, <-2.833831, -2.369650, -0.151950>, <-2.788144, -2.237878, -0.176139>, <-2.750332, -2.139980, -0.187570>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.807076, -2.489614, -0.188092>, <-2.808748, -2.490095, -0.159003>, <-2.841836, -2.478805, -0.148915>, <-2.869262, -2.469083, -0.150505>, 
      <-2.844961, -2.581326, -0.184364>, <-2.846633, -2.581807, -0.155275>, <-2.875885, -2.574361, -0.147527>, <-2.903311, -2.564639, -0.149117>, 
      <-2.899483, -2.701907, -0.201420>, <-2.902386, -2.706967, -0.180020>, <-2.926299, -2.698925, -0.172298>, <-2.947174, -2.691525, -0.173508>, 
      <-2.931736, -2.795676, -0.206644>, <-2.934639, -2.800736, -0.185244>, <-2.960039, -2.794487, -0.176959>, <-2.980914, -2.787087, -0.178169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.807076, -2.489614, -0.188092>, <-2.844961, -2.581326, -0.184364>, <-2.899483, -2.701907, -0.201420>, <-2.931736, -2.795676, -0.206644>, 
      <-2.805395, -2.489130, -0.217340>, <-2.843280, -2.580842, -0.213613>, <-2.896564, -2.696820, -0.222931>, <-2.928818, -2.790590, -0.228155>, 
      <-2.836967, -2.477500, -0.231018>, <-2.869682, -2.568592, -0.224720>, <-2.919330, -2.688511, -0.233248>, <-2.951497, -2.779826, -0.239117>, 
      <-2.864543, -2.467725, -0.232616>, <-2.897258, -2.558817, -0.226318>, <-2.940313, -2.681073, -0.234464>, <-2.972480, -2.772388, -0.240333>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.807076, -2.489614, -0.188092>, <-2.805395, -2.489130, -0.217340>, <-2.836967, -2.477500, -0.231018>, <-2.864543, -2.467725, -0.232616>, 
      <-2.768718, -2.396757, -0.191866>, <-2.767037, -2.396273, -0.221115>, <-2.801125, -2.377702, -0.237918>, <-2.828701, -2.367927, -0.239516>, 
      <-2.695470, -2.185240, -0.231256>, <-2.695193, -2.185161, -0.236071>, <-2.755752, -2.245548, -0.268537>, <-2.782940, -2.236543, -0.270005>, 
      <-2.678693, -2.183114, -0.231543>, <-2.678416, -2.183034, -0.236359>, <-2.717593, -2.147388, -0.282700>, <-2.744781, -2.138383, -0.284168>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.646040, -2.849867, -0.235431>, <-2.626122, -2.851578, -0.234790>, <-2.603490, -2.855810, -0.225066>, <-2.604970, -2.860622, -0.205709>, 
      <-2.646040, -2.849867, -0.235431>, <-2.628582, -2.861898, -0.230045>, <-2.616868, -2.865829, -0.226700>, <-2.618348, -2.870641, -0.207343>, 
      <-2.646040, -2.849867, -0.235431>, <-2.628582, -2.861898, -0.230045>, <-2.641090, -2.874554, -0.220395>, <-2.641950, -2.877350, -0.209147>, 
      <-2.646040, -2.849867, -0.235431>, <-2.648500, -2.860188, -0.230686>, <-2.657814, -2.873118, -0.220933>, <-2.658674, -2.875914, -0.209685>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.585942, -2.821443, -0.200804>, <-2.586844, -2.834528, -0.201742>, <-2.594495, -2.852777, -0.204430>, <-2.604970, -2.860622, -0.205709>, 
      <-2.583917, -2.814854, -0.227311>, <-2.584820, -2.827939, -0.228248>, <-2.593015, -2.847965, -0.223787>, <-2.603490, -2.855810, -0.225066>, 
      <-2.614908, -2.809059, -0.240623>, <-2.615916, -2.822104, -0.241637>, <-2.623345, -2.839924, -0.240148>, <-2.626122, -2.851578, -0.234790>, 
      <-2.642182, -2.806717, -0.241501>, <-2.643190, -2.819762, -0.242515>, <-2.643263, -2.838213, -0.240789>, <-2.646040, -2.849867, -0.235431>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.691446, -2.853196, -0.208492>, <-2.684553, -2.862950, -0.209257>, <-2.670592, -2.874891, -0.210069>, <-2.658674, -2.875914, -0.209685>, 
      <-2.691446, -2.853196, -0.208492>, <-2.683042, -2.858038, -0.229016>, <-2.669732, -2.872094, -0.221317>, <-2.657814, -2.873118, -0.220933>, 
      <-2.691446, -2.853196, -0.208492>, <-2.683042, -2.858038, -0.229016>, <-2.668831, -2.858442, -0.231340>, <-2.648500, -2.860188, -0.230686>, 
      <-2.691446, -2.853196, -0.208492>, <-2.689935, -2.848284, -0.228251>, <-2.666371, -2.848121, -0.236085>, <-2.646040, -2.849867, -0.235431>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.691446, -2.853196, -0.208492>, <-2.699053, -2.842430, -0.207648>, <-2.705479, -2.824403, -0.205565>, <-2.704348, -2.811277, -0.204616>, 
      <-2.689935, -2.848284, -0.228251>, <-2.697542, -2.837518, -0.227407>, <-2.703413, -2.817678, -0.232618>, <-2.702282, -2.804552, -0.231669>, 
      <-2.666371, -2.848121, -0.236085>, <-2.663594, -2.836468, -0.241444>, <-2.671026, -2.817373, -0.243411>, <-2.670018, -2.804327, -0.242397>, 
      <-2.646040, -2.849867, -0.235431>, <-2.643263, -2.838213, -0.240789>, <-2.643190, -2.819762, -0.242515>, <-2.642182, -2.806717, -0.241501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.691446, -2.853196, -0.208492>, <-2.689935, -2.848284, -0.228251>, <-2.666371, -2.848121, -0.236085>, <-2.646040, -2.849867, -0.235431>, 
      <-2.684553, -2.862950, -0.209257>, <-2.683042, -2.858038, -0.229016>, <-2.646454, -2.849832, -0.235444>, <-2.626122, -2.851578, -0.234790>, 
      <-2.670592, -2.874891, -0.210069>, <-2.653868, -2.876327, -0.209530>, <-2.616868, -2.865829, -0.226700>, <-2.603490, -2.855810, -0.225066>, 
      <-2.658674, -2.875914, -0.209685>, <-2.641950, -2.877350, -0.209147>, <-2.618348, -2.870641, -0.207343>, <-2.604970, -2.860622, -0.205709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.650373, -2.863952, -0.178771>, <-2.648485, -2.855035, -0.170595>, <-2.649057, -2.838184, -0.164727>, <-2.648108, -2.826003, -0.163919>, 
      <-2.670291, -2.862242, -0.179412>, <-2.668404, -2.853325, -0.171236>, <-2.676330, -2.835842, -0.165604>, <-2.675382, -2.823661, -0.164797>, 
      <-2.692926, -2.858008, -0.189134>, <-2.700534, -2.847242, -0.188290>, <-2.707504, -2.830992, -0.179059>, <-2.706373, -2.817866, -0.178110>, 
      <-2.691446, -2.853196, -0.208492>, <-2.699053, -2.842430, -0.207648>, <-2.705479, -2.824403, -0.205565>, <-2.704348, -2.811277, -0.204616>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.650373, -2.863952, -0.178771>, <-2.651953, -2.871417, -0.185616>, <-2.659433, -2.878380, -0.199764>, <-2.658674, -2.875914, -0.209685>, 
      <-2.650373, -2.863952, -0.178771>, <-2.671872, -2.869707, -0.186257>, <-2.671351, -2.877357, -0.200147>, <-2.670592, -2.874891, -0.210069>, 
      <-2.650373, -2.863952, -0.178771>, <-2.671872, -2.869707, -0.186257>, <-2.686034, -2.867762, -0.189899>, <-2.684553, -2.862950, -0.209257>, 
      <-2.650373, -2.863952, -0.178771>, <-2.670291, -2.862242, -0.179412>, <-2.692926, -2.858008, -0.189134>, <-2.691446, -2.853196, -0.208492>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.650373, -2.863952, -0.178771>, <-2.651953, -2.871417, -0.185616>, <-2.659433, -2.878380, -0.199764>, <-2.658674, -2.875914, -0.209685>, 
      <-2.670291, -2.862242, -0.179412>, <-2.671872, -2.869707, -0.186257>, <-2.658572, -2.875584, -0.211012>, <-2.657814, -2.873118, -0.220933>, 
      <-2.692926, -2.858008, -0.189134>, <-2.691415, -2.853096, -0.208893>, <-2.668831, -2.858442, -0.231340>, <-2.648500, -2.860188, -0.230686>, 
      <-2.691446, -2.853196, -0.208492>, <-2.689935, -2.848284, -0.228251>, <-2.666371, -2.848121, -0.236085>, <-2.646040, -2.849867, -0.235431>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.650373, -2.863952, -0.178771>, <-2.670291, -2.862242, -0.179412>, <-2.692926, -2.858008, -0.189134>, <-2.691446, -2.853196, -0.208492>, 
      <-2.630043, -2.865698, -0.178117>, <-2.649961, -2.863987, -0.178758>, <-2.686034, -2.867762, -0.189899>, <-2.684553, -2.862950, -0.209257>, 
      <-2.606481, -2.865533, -0.185951>, <-2.619859, -2.875553, -0.187585>, <-2.653868, -2.876327, -0.209530>, <-2.670592, -2.874891, -0.210069>, 
      <-2.604970, -2.860622, -0.205709>, <-2.618348, -2.870641, -0.207343>, <-2.641950, -2.877350, -0.209147>, <-2.658674, -2.875914, -0.209685>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.650373, -2.863952, -0.178771>, <-2.651953, -2.871417, -0.185616>, <-2.659433, -2.878380, -0.199764>, <-2.658674, -2.875914, -0.209685>, 
      <-2.650373, -2.863952, -0.178771>, <-2.631624, -2.873163, -0.184962>, <-2.642709, -2.879817, -0.199226>, <-2.641950, -2.877350, -0.209147>, 
      <-2.650373, -2.863952, -0.178771>, <-2.631624, -2.873163, -0.184962>, <-2.619859, -2.875553, -0.187585>, <-2.618348, -2.870641, -0.207343>, 
      <-2.650373, -2.863952, -0.178771>, <-2.630043, -2.865698, -0.178117>, <-2.606481, -2.865533, -0.185951>, <-2.604970, -2.860622, -0.205709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.650373, -2.863952, -0.178771>, <-2.648485, -2.855035, -0.170595>, <-2.649057, -2.838184, -0.164727>, <-2.648108, -2.826003, -0.163919>, 
      <-2.630043, -2.865698, -0.178117>, <-2.628155, -2.856781, -0.169940>, <-2.621221, -2.840574, -0.163830>, <-2.620272, -2.828393, -0.163023>, 
      <-2.606481, -2.865533, -0.185951>, <-2.596006, -2.857688, -0.184672>, <-2.588911, -2.841253, -0.174689>, <-2.588008, -2.828168, -0.173751>, 
      <-2.604970, -2.860622, -0.205709>, <-2.594495, -2.852777, -0.204430>, <-2.586844, -2.834528, -0.201742>, <-2.585942, -2.821443, -0.200804>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.650373, -2.863952, -0.178771>, <-2.630043, -2.865698, -0.178117>, <-2.606481, -2.865533, -0.185951>, <-2.604970, -2.860622, -0.205709>, 
      <-2.651953, -2.871417, -0.185616>, <-2.631624, -2.873163, -0.184962>, <-2.605000, -2.860721, -0.205308>, <-2.603490, -2.855810, -0.225066>, 
      <-2.659433, -2.878380, -0.199764>, <-2.658572, -2.875584, -0.211012>, <-2.628582, -2.861898, -0.230045>, <-2.626122, -2.851578, -0.234790>, 
      <-2.658674, -2.875914, -0.209685>, <-2.657814, -2.873118, -0.220933>, <-2.648500, -2.860188, -0.230686>, <-2.646040, -2.849867, -0.235431>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.684150, -2.768522, -0.202370>, <-2.682664, -2.763691, -0.221798>, <-2.659494, -2.763529, -0.229499>, <-2.639504, -2.765246, -0.228855>, 
      <-2.685381, -2.782658, -0.202966>, <-2.683895, -2.777827, -0.222393>, <-2.660517, -2.776505, -0.230140>, <-2.640527, -2.778222, -0.229496>, 
      <-2.703132, -2.797164, -0.203596>, <-2.701066, -2.790439, -0.230649>, <-2.669018, -2.791373, -0.241391>, <-2.641181, -2.793763, -0.240494>, 
      <-2.704348, -2.811277, -0.204616>, <-2.702282, -2.804552, -0.231669>, <-2.670018, -2.804327, -0.242397>, <-2.642182, -2.806717, -0.241501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.643764, -2.779098, -0.173146>, <-2.663349, -2.777416, -0.173777>, <-2.685606, -2.773255, -0.183336>, <-2.684150, -2.768522, -0.202370>, 
      <-2.644907, -2.793444, -0.173645>, <-2.664492, -2.791762, -0.174276>, <-2.686836, -2.787391, -0.183932>, <-2.685381, -2.782658, -0.202966>, 
      <-2.646992, -2.811677, -0.162969>, <-2.674266, -2.809336, -0.163847>, <-2.705157, -2.803753, -0.177089>, <-2.703132, -2.797164, -0.203596>, 
      <-2.648108, -2.826003, -0.163919>, <-2.675382, -2.823661, -0.164797>, <-2.706373, -2.817866, -0.178110>, <-2.704348, -2.811277, -0.204616>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.599121, -2.775826, -0.199630>, <-2.600607, -2.780656, -0.180204>, <-2.623775, -2.780815, -0.172502>, <-2.643764, -2.779098, -0.173146>, 
      <-2.600136, -2.790027, -0.200221>, <-2.601622, -2.794857, -0.180794>, <-2.624918, -2.795161, -0.173000>, <-2.644907, -2.793444, -0.173645>, 
      <-2.584964, -2.807264, -0.199788>, <-2.587030, -2.813989, -0.172734>, <-2.619156, -2.814067, -0.162073>, <-2.646992, -2.811677, -0.162969>, 
      <-2.585942, -2.821443, -0.200804>, <-2.588008, -2.828168, -0.173751>, <-2.620272, -2.828393, -0.163023>, <-2.648108, -2.826003, -0.163919>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.599121, -2.775826, -0.199630>, <-2.600136, -2.790027, -0.200221>, <-2.584964, -2.807264, -0.199788>, <-2.585942, -2.821443, -0.200804>, 
      <-2.597666, -2.771093, -0.218664>, <-2.598680, -2.785294, -0.219254>, <-2.582939, -2.800675, -0.226294>, <-2.583917, -2.814854, -0.227311>, 
      <-2.619919, -2.766928, -0.228224>, <-2.620943, -2.779904, -0.228865>, <-2.613908, -2.796104, -0.239616>, <-2.614908, -2.809059, -0.240623>, 
      <-2.639504, -2.765246, -0.228855>, <-2.640527, -2.778222, -0.229496>, <-2.641181, -2.793763, -0.240494>, <-2.642182, -2.806717, -0.241501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.674876, -2.472860, -0.190357>, <-2.673361, -2.472426, -0.216707>, <-2.642477, -2.474857, -0.226075>, <-2.616190, -2.477113, -0.225229>, 
      <-2.675703, -2.561562, -0.185937>, <-2.674188, -2.561127, -0.212287>, <-2.649879, -2.561017, -0.219469>, <-2.623593, -2.563273, -0.218622>, 
      <-2.676451, -2.680120, -0.198645>, <-2.674966, -2.675289, -0.218073>, <-2.652684, -2.677173, -0.225236>, <-2.632694, -2.678890, -0.224592>, 
      <-2.684150, -2.768522, -0.202370>, <-2.682664, -2.763691, -0.221798>, <-2.659494, -2.763529, -0.229499>, <-2.639504, -2.765246, -0.228855>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.674876, -2.472860, -0.190357>, <-2.674058, -2.385168, -0.194727>, <-2.664041, -2.181257, -0.231794>, <-2.678693, -2.183114, -0.231543>, 
      <-2.673361, -2.472426, -0.216707>, <-2.672544, -2.384733, -0.221077>, <-2.663746, -2.181172, -0.236933>, <-2.678398, -2.183029, -0.236682>, 
      <-2.642477, -2.474857, -0.226075>, <-2.634370, -2.380498, -0.233311>, <-2.627153, -2.262019, -0.266263>, <-2.618512, -2.167856, -0.275229>, 
      <-2.616190, -2.477113, -0.225229>, <-2.608083, -2.382754, -0.232465>, <-2.596632, -2.259851, -0.265864>, <-2.587991, -2.165688, -0.274830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.620409, -2.478323, -0.151838>, <-2.612603, -2.384308, -0.154196>, <-2.601062, -2.259802, -0.172728>, <-2.592953, -2.167114, -0.188494>, 
      <-2.646134, -2.476115, -0.152666>, <-2.638328, -2.382100, -0.155024>, <-2.630166, -2.261870, -0.173109>, <-2.622057, -2.169182, -0.188874>, 
      <-2.676358, -2.473285, -0.164571>, <-2.675541, -2.385593, -0.168941>, <-2.664323, -2.181338, -0.226894>, <-2.678975, -2.183195, -0.226643>, 
      <-2.674876, -2.472860, -0.190357>, <-2.674058, -2.385168, -0.194727>, <-2.664041, -2.181257, -0.231794>, <-2.678693, -2.183114, -0.231543>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.620409, -2.478323, -0.151838>, <-2.646134, -2.476115, -0.152666>, <-2.676358, -2.473285, -0.164571>, <-2.674876, -2.472860, -0.190357>, 
      <-2.627914, -2.568713, -0.149571>, <-2.653638, -2.566505, -0.150399>, <-2.677185, -2.561987, -0.160150>, <-2.675703, -2.561562, -0.185937>, 
      <-2.636563, -2.688709, -0.170005>, <-2.656148, -2.687027, -0.170636>, <-2.677907, -2.684852, -0.179611>, <-2.676451, -2.680120, -0.198645>, 
      <-2.643764, -2.779098, -0.173146>, <-2.663349, -2.777416, -0.173777>, <-2.685606, -2.773255, -0.183336>, <-2.684150, -2.768522, -0.202370>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.561723, -2.482571, -0.186714>, <-2.550030, -2.388711, -0.191361>, <-2.529779, -2.265800, -0.216987>, <-2.523914, -2.172117, -0.229521>, 
      <-2.563238, -2.483006, -0.160363>, <-2.551545, -2.389146, -0.165011>, <-2.531164, -2.266198, -0.192890>, <-2.525299, -2.172515, -0.205425>, 
      <-2.594121, -2.480579, -0.150992>, <-2.586316, -2.386564, -0.153350>, <-2.576985, -2.258091, -0.172414>, <-2.568876, -2.165403, -0.188180>, 
      <-2.620409, -2.478323, -0.151838>, <-2.612603, -2.384308, -0.154196>, <-2.601062, -2.259802, -0.172728>, <-2.592953, -2.167114, -0.188494>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.561723, -2.482571, -0.186714>, <-2.563238, -2.483006, -0.160363>, <-2.594121, -2.480579, -0.150992>, <-2.620409, -2.478323, -0.151838>, 
      <-2.572684, -2.570558, -0.182358>, <-2.574199, -2.570992, -0.156007>, <-2.601626, -2.570969, -0.148725>, <-2.627914, -2.568713, -0.149571>, 
      <-2.592798, -2.687354, -0.195951>, <-2.594284, -2.692185, -0.176525>, <-2.616574, -2.690426, -0.169361>, <-2.636563, -2.688709, -0.170005>, 
      <-2.599121, -2.775826, -0.199630>, <-2.600607, -2.780656, -0.180204>, <-2.623775, -2.780815, -0.172502>, <-2.643764, -2.779098, -0.173146>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.561723, -2.482571, -0.186714>, <-2.572684, -2.570558, -0.182358>, <-2.592798, -2.687354, -0.195951>, <-2.599121, -2.775826, -0.199630>, 
      <-2.560241, -2.482146, -0.212499>, <-2.571202, -2.570132, -0.208143>, <-2.591342, -2.682622, -0.214985>, <-2.597666, -2.771093, -0.218664>, 
      <-2.590466, -2.479321, -0.224401>, <-2.597869, -2.565480, -0.217794>, <-2.613109, -2.680572, -0.223961>, <-2.619919, -2.766928, -0.228224>, 
      <-2.616190, -2.477113, -0.225229>, <-2.623593, -2.563273, -0.218622>, <-2.632694, -2.678890, -0.224592>, <-2.639504, -2.765246, -0.228855>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.561723, -2.482571, -0.186714>, <-2.560241, -2.482146, -0.212499>, <-2.590466, -2.479321, -0.224401>, <-2.616190, -2.477113, -0.225229>, 
      <-2.550030, -2.388711, -0.191361>, <-2.548548, -2.388286, -0.217147>, <-2.582359, -2.384962, -0.231636>, <-2.608083, -2.382754, -0.232465>, 
      <-2.529779, -2.265800, -0.216987>, <-2.528424, -2.265410, -0.240567>, <-2.573071, -2.258177, -0.265556>, <-2.596632, -2.259851, -0.265864>, 
      <-2.523914, -2.172117, -0.229521>, <-2.522559, -2.171728, -0.253101>, <-2.564430, -2.164014, -0.274522>, <-2.587991, -2.165688, -0.274830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.342483, -1.307140, 0.409323>, <-0.344123, -1.354205, 0.280705>, <-0.318392, -1.302998, 0.126982>, <-0.293817, -1.175512, 0.083349>, 
      <-0.540673, -1.448775, 0.447341>, <-0.542312, -1.495840, 0.318723>, <-0.552988, -1.339357, 0.139387>, <-0.528413, -1.211871, 0.095754>, 
      <-0.806513, -1.634608, 0.570828>, <-0.714708, -1.660202, 0.343694>, <-0.770420, -1.385198, 0.238401>, <-0.876013, -1.174727, 0.166117>, 
      <-1.003116, -1.779255, 0.536050>, <-0.911311, -1.804849, 0.308916>, <-0.970211, -1.507179, 0.196985>, <-1.075804, -1.296708, 0.124700>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.287633, -0.997992, 0.568470>, <-0.312008, -1.124439, 0.611747>, <-0.340857, -1.260458, 0.536893>, <-0.342483, -1.307140, 0.409323>, 
      <-0.587533, -1.069919, 0.592316>, <-0.611908, -1.196366, 0.635594>, <-0.539047, -1.402093, 0.574911>, <-0.540673, -1.448775, 0.447341>, 
      <-1.023391, -1.079290, 0.678385>, <-0.920533, -1.284310, 0.748797>, <-0.895941, -1.609678, 0.792079>, <-0.806513, -1.634608, 0.570828>, 
      <-1.287300, -1.237747, 0.647958>, <-1.184442, -1.442766, 0.718370>, <-1.092543, -1.754324, 0.757301>, <-1.003116, -1.779255, 0.536050>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.238968, -0.770144, 0.225533>, <-0.237053, -0.715162, 0.375786>, <-0.258924, -0.849062, 0.517498>, <-0.287633, -0.997992, 0.568470>, 
      <-0.575273, -0.859482, 0.245399>, <-0.573357, -0.804500, 0.395652>, <-0.558824, -0.920988, 0.541344>, <-0.587533, -1.069919, 0.592316>, 
      <-1.060348, -0.894424, 0.331610>, <-1.118065, -0.878334, 0.474405>, <-1.089776, -0.946971, 0.632941>, <-1.023391, -1.079290, 0.678385>, 
      <-1.359984, -1.067938, 0.291754>, <-1.417701, -1.051848, 0.434549>, <-1.353685, -1.105427, 0.602514>, <-1.287300, -1.237747, 0.647958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.238968, -0.770144, 0.225533>, <-0.575273, -0.859482, 0.245399>, <-1.060348, -0.894424, 0.331610>, <-1.359984, -1.067938, 0.291754>, 
      <-0.240969, -0.827576, 0.068585>, <-0.577273, -0.916914, 0.088452>, <-1.002632, -0.910515, 0.188814>, <-1.302267, -1.084028, 0.148958>, 
      <-0.263829, -1.019946, 0.030106>, <-0.498425, -1.056305, 0.042511>, <-0.942398, -1.042407, 0.120673>, <-1.142189, -1.164388, 0.079256>, 
      <-0.293817, -1.175512, 0.083349>, <-0.528413, -1.211871, 0.095754>, <-0.876013, -1.174727, 0.166117>, <-1.075804, -1.296708, 0.124700>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.391123, -2.078657, 0.223822>, <-1.273229, -1.969731, 0.291846>, <-1.142132, -1.881533, 0.511459>, <-1.003116, -1.779255, 0.536050>, 
      <-1.326198, -2.090394, 0.069232>, <-1.208304, -1.981468, 0.137256>, <-1.050326, -1.907127, 0.284325>, <-0.911311, -1.804849, 0.308916>, 
      <-1.368293, -2.010177, -0.106615>, <-1.241672, -1.815123, -0.069893>, <-1.168076, -1.627984, 0.155967>, <-0.970211, -1.507179, 0.196985>, 
      <-1.483799, -1.902046, -0.163335>, <-1.357178, -1.706992, -0.126613>, <-1.273670, -1.417513, 0.083682>, <-1.075804, -1.296708, 0.124700>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.721704, -1.859039, 0.403133>, <-1.607187, -1.672537, 0.499160>, <-1.491205, -1.360176, 0.624449>, <-1.287300, -1.237747, 0.647958>, 
      <-1.606199, -1.967169, 0.459853>, <-1.491681, -1.780667, 0.555880>, <-1.388346, -1.565195, 0.694862>, <-1.184442, -1.442766, 0.718370>, 
      <-1.456047, -2.066920, 0.378411>, <-1.338154, -1.957995, 0.446435>, <-1.231559, -1.856603, 0.732709>, <-1.092543, -1.754324, 0.757301>, 
      <-1.391123, -2.078657, 0.223822>, <-1.273229, -1.969731, 0.291846>, <-1.142132, -1.881533, 0.511459>, <-1.003116, -1.779255, 0.536050>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.814373, -1.682432, 0.015983>, <-1.703680, -1.478358, 0.090223>, <-1.569530, -1.189282, 0.263881>, <-1.359984, -1.067938, 0.291754>, 
      <-1.879296, -1.670695, 0.170570>, <-1.768604, -1.466621, 0.244810>, <-1.627247, -1.173192, 0.406677>, <-1.417701, -1.051848, 0.434549>, 
      <-1.837208, -1.750910, 0.346414>, <-1.722690, -1.564408, 0.442441>, <-1.557589, -1.227856, 0.579005>, <-1.353685, -1.105427, 0.602514>, 
      <-1.721704, -1.859039, 0.403133>, <-1.607187, -1.672537, 0.499160>, <-1.491205, -1.360176, 0.624449>, <-1.287300, -1.237747, 0.647958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.814373, -1.682432, 0.015983>, <-1.749449, -1.694169, -0.138605>, <-1.599303, -1.793917, -0.220054>, <-1.483799, -1.902046, -0.163335>, 
      <-1.703680, -1.478358, 0.090223>, <-1.638756, -1.490094, -0.064364>, <-1.472683, -1.598863, -0.183332>, <-1.357178, -1.706992, -0.126613>, 
      <-1.569530, -1.189282, 0.263881>, <-1.511814, -1.205373, 0.121086>, <-1.340055, -1.285193, 0.038238>, <-1.273670, -1.417513, 0.083682>, 
      <-1.359984, -1.067938, 0.291754>, <-1.302267, -1.084028, 0.148958>, <-1.142189, -1.164388, 0.079256>, <-1.075804, -1.296708, 0.124700>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.742184, -2.462102, 0.109613>, <-1.611266, -2.375331, 0.138423>, <-1.499111, -2.178431, 0.161514>, <-1.391123, -2.078657, 0.223822>, 
      <-1.730442, -2.544121, 0.041671>, <-1.599524, -2.457350, 0.070481>, <-1.434187, -2.190167, 0.006923>, <-1.326198, -2.090394, 0.069232>, 
      <-1.823744, -2.606940, -0.048738>, <-1.642807, -2.467647, -0.031505>, <-1.491451, -2.199897, -0.142334>, <-1.368293, -2.010177, -0.106615>, 
      <-1.887794, -2.547544, -0.110793>, <-1.706857, -2.408251, -0.093561>, <-1.606957, -2.091766, -0.199053>, <-1.483799, -1.902046, -0.163335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.926319, -2.278449, 0.112116>, <-1.846120, -2.158736, 0.192481>, <-1.800761, -1.987791, 0.336841>, <-1.721704, -1.859039, 0.403133>, 
      <-1.866319, -2.334088, 0.170247>, <-1.786120, -2.214375, 0.250612>, <-1.685256, -2.095921, 0.393560>, <-1.606199, -1.967169, 0.459853>, 
      <-1.753184, -2.385270, 0.173258>, <-1.622266, -2.298499, 0.202068>, <-1.564036, -2.166694, 0.316103>, <-1.456047, -2.066920, 0.378411>, 
      <-1.742184, -2.462102, 0.109613>, <-1.611266, -2.375331, 0.138423>, <-1.499111, -2.178431, 0.161514>, <-1.391123, -2.078657, 0.223822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.991030, -2.231341, -0.131481>, <-1.929796, -2.077053, -0.065690>, <-1.895463, -1.831930, -0.038403>, <-1.814373, -1.682432, 0.015983>, 
      <-2.001874, -2.155592, -0.068733>, <-1.940640, -2.001304, -0.002942>, <-1.960386, -1.820193, 0.116184>, <-1.879296, -1.670695, 0.170570>, 
      <-1.985473, -2.223594, 0.054805>, <-1.905274, -2.103881, 0.135170>, <-1.916265, -1.879662, 0.280122>, <-1.837208, -1.750910, 0.346414>, 
      <-1.926319, -2.278449, 0.112116>, <-1.846120, -2.158736, 0.192481>, <-1.800761, -1.987791, 0.336841>, <-1.721704, -1.859039, 0.403133>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.991030, -2.231341, -0.131481>, <-1.976935, -2.329796, -0.213038>, <-1.964680, -2.476246, -0.185284>, <-1.887794, -2.547544, -0.110793>, 
      <-1.929796, -2.077053, -0.065690>, <-1.915700, -2.175508, -0.147247>, <-1.783743, -2.336953, -0.168051>, <-1.706857, -2.408251, -0.093561>, 
      <-1.895463, -1.831930, -0.038403>, <-1.830539, -1.843666, -0.192990>, <-1.722462, -1.983637, -0.255772>, <-1.606957, -2.091766, -0.199053>, 
      <-1.814373, -1.682432, 0.015983>, <-1.749449, -1.694169, -0.138605>, <-1.599303, -1.793917, -0.220054>, <-1.483799, -1.902046, -0.163335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.281748, -2.668953, 0.027829>, <-2.126887, -2.749208, 0.043045>, <-1.885729, -2.557242, 0.078024>, <-1.742184, -2.462102, 0.109613>, 
      <-2.345513, -2.699255, -0.068660>, <-2.190652, -2.779510, -0.053443>, <-1.873986, -2.639261, 0.010082>, <-1.730442, -2.544121, 0.041671>, 
      <-2.327318, -2.598820, -0.176370>, <-2.247518, -2.690571, -0.158973>, <-1.920802, -2.681659, -0.057982>, <-1.823744, -2.606940, -0.048738>, 
      <-2.275059, -2.511191, -0.238694>, <-2.195259, -2.602942, -0.221298>, <-1.984853, -2.622264, -0.120037>, <-1.887794, -2.547544, -0.110793>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.104203, -2.429998, 0.019843>, <-2.033461, -2.455556, 0.024689>, <-1.962957, -2.333139, 0.075402>, <-1.926319, -2.278449, 0.112116>, 
      <-2.154440, -2.514237, 0.079756>, <-2.083698, -2.539795, 0.084602>, <-1.902957, -2.388778, 0.133533>, <-1.866319, -2.334088, 0.170247>, 
      <-2.220450, -2.639823, 0.120584>, <-2.065589, -2.720079, 0.135801>, <-1.896728, -2.480409, 0.141669>, <-1.753184, -2.385270, 0.173258>, 
      <-2.281748, -2.668953, 0.027829>, <-2.126887, -2.749208, 0.043045>, <-1.885729, -2.557242, 0.078024>, <-1.742184, -2.462102, 0.109613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.055017, -2.288769, -0.242569>, <-2.031979, -2.323246, -0.235047>, <-2.005482, -2.267755, -0.147009>, <-1.991030, -2.231341, -0.131481>, 
      <-1.992848, -2.259225, -0.148495>, <-1.969810, -2.293702, -0.140973>, <-2.016326, -2.192006, -0.084261>, <-2.001874, -2.155592, -0.068733>, 
      <-2.053251, -2.344562, -0.040922>, <-1.982509, -2.370120, -0.036076>, <-2.022110, -2.278284, 0.018091>, <-1.985473, -2.223594, 0.054805>, 
      <-2.104203, -2.429998, 0.019843>, <-2.033461, -2.455556, 0.024689>, <-1.962957, -2.333139, 0.075402>, <-1.926319, -2.278449, 0.112116>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.055017, -2.288769, -0.242569>, <-2.119422, -2.319375, -0.340027>, <-2.222275, -2.422682, -0.301644>, <-2.275059, -2.511191, -0.238694>, 
      <-2.031979, -2.323246, -0.235047>, <-2.096385, -2.353852, -0.332504>, <-2.142474, -2.514433, -0.284248>, <-2.195259, -2.602942, -0.221298>, 
      <-2.005482, -2.267755, -0.147009>, <-1.991387, -2.366210, -0.228566>, <-2.061738, -2.550966, -0.194527>, <-1.984853, -2.622264, -0.120037>, 
      <-1.991030, -2.231341, -0.131481>, <-1.976935, -2.329796, -0.213038>, <-1.964680, -2.476246, -0.185284>, <-1.887794, -2.547544, -0.110793>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.359684, -2.142089, 0.048939>, <-2.361738, -2.299693, 0.021990>, <-2.423183, -2.595656, 0.013932>, <-2.281748, -2.668953, 0.027829>, 
      <-2.409301, -2.108858, -0.032685>, <-2.411355, -2.266462, -0.059634>, <-2.486948, -2.625958, -0.082557>, <-2.345513, -2.699255, -0.068660>, 
      <-2.368456, -2.088578, -0.144529>, <-2.379913, -2.212276, -0.163870>, <-2.408994, -2.504914, -0.194175>, <-2.327318, -2.598820, -0.176370>, 
      <-2.282022, -2.094278, -0.196734>, <-2.293479, -2.217975, -0.216075>, <-2.356734, -2.417284, -0.256499>, <-2.275059, -2.511191, -0.238694>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.101578, -2.215130, 0.100110>, <-2.113719, -2.279056, 0.077711>, <-2.168790, -2.406663, 0.015419>, <-2.104203, -2.429998, 0.019843>, 
      <-2.191648, -2.209191, 0.154511>, <-2.203789, -2.273116, 0.132112>, <-2.219028, -2.490902, 0.075331>, <-2.154440, -2.514237, 0.079756>, 
      <-2.307979, -2.176718, 0.133997>, <-2.310034, -2.334322, 0.107048>, <-2.361885, -2.566526, 0.106687>, <-2.220450, -2.639823, 0.120584>, 
      <-2.359684, -2.142089, 0.048939>, <-2.361738, -2.299693, 0.021990>, <-2.423183, -2.595656, 0.013932>, <-2.281748, -2.668953, 0.027829>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.036426, -2.163405, -0.146304>, <-2.047931, -2.207273, -0.161232>, <-2.081118, -2.249709, -0.251092>, <-2.055017, -2.288769, -0.242569>, 
      <-1.987183, -2.196385, -0.065296>, <-1.998688, -2.240253, -0.080224>, <-2.018948, -2.220165, -0.157018>, <-1.992848, -2.259225, -0.148495>, 
      <-2.015796, -2.220787, 0.048299>, <-2.027937, -2.284712, 0.025900>, <-2.117839, -2.321227, -0.045346>, <-2.053251, -2.344562, -0.040922>, 
      <-2.101578, -2.215130, 0.100110>, <-2.113719, -2.279056, 0.077711>, <-2.168790, -2.406663, 0.015419>, <-2.104203, -2.429998, 0.019843>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.036426, -2.163405, -0.146304>, <-2.085668, -2.130425, -0.227312>, <-2.196241, -2.099935, -0.248545>, <-2.282022, -2.094278, -0.196734>, 
      <-2.047931, -2.207273, -0.161232>, <-2.097173, -2.174293, -0.242240>, <-2.207698, -2.223632, -0.267885>, <-2.293479, -2.217975, -0.216075>, 
      <-2.081118, -2.249709, -0.251092>, <-2.145523, -2.280315, -0.348549>, <-2.303950, -2.328775, -0.319449>, <-2.356734, -2.417284, -0.256499>, 
      <-2.055017, -2.288769, -0.242569>, <-2.119422, -2.319375, -0.340027>, <-2.222275, -2.422682, -0.301644>, <-2.275059, -2.511191, -0.238694>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.228126, -1.188848, 0.218149>, <-2.192726, -1.244419, 0.211204>, <-2.146680, -1.237544, 0.128975>, <-2.130917, -1.199521, 0.077058>, 
      <-2.270189, -1.233361, 0.171889>, <-2.234789, -1.288932, 0.164944>, <-2.177587, -1.278371, 0.082426>, <-2.161825, -1.240349, 0.030509>, 
      <-2.314612, -1.298867, 0.105380>, <-2.253281, -1.344761, 0.095616>, <-2.196120, -1.339252, 0.006678>, <-2.177747, -1.294935, -0.053834>, 
      <-2.353822, -1.352396, 0.066807>, <-2.292490, -1.398290, 0.057043>, <-2.234977, -1.390835, -0.018188>, <-2.216604, -1.346518, -0.078699>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.303468, -0.928654, 0.110912>, <-2.330219, -0.993182, 0.199019>, <-2.288203, -1.094540, 0.229936>, <-2.228126, -1.188848, 0.218149>, 
      <-2.369550, -0.978187, 0.059160>, <-2.396301, -1.042715, 0.147268>, <-2.330266, -1.139053, 0.183676>, <-2.270189, -1.233361, 0.171889>, 
      <-2.397163, -1.100519, -0.006377>, <-2.417415, -1.149369, 0.060324>, <-2.382217, -1.248279, 0.116144>, <-2.314612, -1.298867, 0.105380>, 
      <-2.437931, -1.180901, -0.043462>, <-2.458184, -1.229751, 0.023238>, <-2.421427, -1.301808, 0.077570>, <-2.353822, -1.352396, 0.066807>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.152264, -1.005853, -0.031715>, <-2.197988, -0.934077, -0.022744>, <-2.283109, -0.879543, 0.043855>, <-2.303468, -0.928654, 0.110912>, 
      <-2.207584, -1.037505, -0.074474>, <-2.253308, -0.965729, -0.065503>, <-2.349191, -0.929076, -0.007896>, <-2.369550, -0.978187, 0.059160>, 
      <-2.233821, -1.101903, -0.172081>, <-2.301329, -1.051388, -0.161333>, <-2.376939, -1.051739, -0.072982>, <-2.397163, -1.100519, -0.006377>, 
      <-2.275494, -1.163465, -0.191161>, <-2.343002, -1.112949, -0.180413>, <-2.417707, -1.132121, -0.110067>, <-2.437931, -1.180901, -0.043462>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.152264, -1.005853, -0.031715>, <-2.207584, -1.037505, -0.074474>, <-2.233821, -1.101903, -0.172081>, <-2.275494, -1.163465, -0.191161>, 
      <-2.106248, -1.078088, -0.040743>, <-2.161568, -1.109740, -0.083502>, <-2.165539, -1.152999, -0.182952>, <-2.207211, -1.214560, -0.202032>, 
      <-2.110428, -1.150096, 0.009573>, <-2.141335, -1.190924, -0.036976>, <-2.157291, -1.245595, -0.121203>, <-2.196148, -1.297178, -0.146068>, 
      <-2.130917, -1.199521, 0.077058>, <-2.161825, -1.240349, 0.030509>, <-2.177747, -1.294935, -0.053834>, <-2.216604, -1.346518, -0.078699>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.105953, -1.090091, 0.339407>, <-2.137842, -1.174485, 0.285569>, <-2.172893, -1.244717, 0.155188>, <-2.104721, -1.198726, 0.089802>, 
      <-2.124220, -1.035099, 0.325747>, <-2.156110, -1.119493, 0.271909>, <-2.176007, -1.240624, 0.162258>, <-2.107835, -1.194634, 0.096872>, 
      <-2.195498, -1.154319, 0.254033>, <-2.160098, -1.209890, 0.247087>, <-2.142775, -1.232386, 0.134855>, <-2.127012, -1.194363, 0.082939>, 
      <-2.228126, -1.188848, 0.218149>, <-2.192726, -1.244419, 0.211204>, <-2.146680, -1.237544, 0.128975>, <-2.130917, -1.199521, 0.077058>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.963655, -0.825401, 0.327961>, <-2.038967, -0.876208, 0.400195>, <-2.070724, -0.996858, 0.398884>, <-2.105953, -1.090091, 0.339407>, 
      <-2.045280, -0.743711, 0.280461>, <-2.120591, -0.794519, 0.352695>, <-2.088991, -0.941866, 0.385224>, <-2.124220, -1.035099, 0.325747>, 
      <-2.218802, -0.865192, 0.177217>, <-2.245553, -0.929720, 0.265324>, <-2.255575, -1.060011, 0.265820>, <-2.195498, -1.154319, 0.254033>, 
      <-2.303468, -0.928654, 0.110912>, <-2.330219, -0.993182, 0.199019>, <-2.288203, -1.094540, 0.229936>, <-2.228126, -1.188848, 0.218149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.875291, -0.934481, 0.118173>, <-1.845721, -0.856225, 0.168096>, <-1.900441, -0.782756, 0.267331>, <-1.963655, -0.825401, 0.327961>, 
      <-1.949933, -0.877743, 0.093800>, <-1.920363, -0.799487, 0.143722>, <-1.982066, -0.701066, 0.219831>, <-2.045280, -0.743711, 0.280461>, 
      <-2.082438, -0.965901, 0.022256>, <-2.128162, -0.894124, 0.031227>, <-2.198443, -0.816081, 0.110160>, <-2.218802, -0.865192, 0.177217>, 
      <-2.152264, -1.005853, -0.031715>, <-2.197988, -0.934077, -0.022744>, <-2.283109, -0.879543, 0.043855>, <-2.303468, -0.928654, 0.110912>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.875291, -0.934481, 0.118173>, <-1.949933, -0.877743, 0.093800>, <-2.082438, -0.965901, 0.022256>, <-2.152264, -1.005853, -0.031715>, 
      <-1.916420, -1.043327, 0.048736>, <-1.991062, -0.986589, 0.024362>, <-2.036423, -1.038136, 0.013228>, <-2.106248, -1.078088, -0.040743>, 
      <-2.016797, -1.139410, 0.005472>, <-2.019911, -1.135318, 0.012542>, <-2.106523, -1.144939, 0.015454>, <-2.110428, -1.150096, 0.009573>, 
      <-2.104721, -1.198726, 0.089802>, <-2.107835, -1.194634, 0.096872>, <-2.127012, -1.194363, 0.082939>, <-2.130917, -1.199521, 0.077058>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.172483, -1.356359, 0.259758>, <-2.227857, -1.330188, 0.167306>, <-2.197447, -1.263542, 0.054896>, <-2.100148, -1.239956, 0.007198>, 
      <-2.149488, -1.276127, 0.279361>, <-2.204862, -1.249956, 0.186909>, <-2.192130, -1.238884, 0.066418>, <-2.094831, -1.215299, 0.018719>, 
      <-2.079648, -1.169282, 0.359078>, <-2.111537, -1.253677, 0.305239>, <-2.163016, -1.257697, 0.132762>, <-2.094844, -1.211706, 0.067376>, 
      <-2.105953, -1.090091, 0.339407>, <-2.137842, -1.174485, 0.285569>, <-2.172893, -1.244717, 0.155188>, <-2.104721, -1.198726, 0.089802>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.896011, -1.336435, 0.348024>, <-1.994514, -1.360312, 0.396313>, <-2.116424, -1.382854, 0.353353>, <-2.172483, -1.356359, 0.259758>, 
      <-1.894390, -1.182087, 0.359247>, <-1.992893, -1.205964, 0.407535>, <-2.093429, -1.302622, 0.372956>, <-2.149488, -1.276127, 0.279361>, 
      <-1.862487, -0.926649, 0.386834>, <-1.937799, -0.977456, 0.459067>, <-2.044418, -1.076050, 0.418555>, <-2.079648, -1.169282, 0.359078>, 
      <-1.963655, -0.825401, 0.327961>, <-2.038967, -0.876208, 0.400195>, <-2.070724, -0.996858, 0.398884>, <-2.105953, -1.090091, 0.339407>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.807534, -1.267894, 0.080851>, <-1.751713, -1.294276, 0.174049>, <-1.797927, -1.312659, 0.299941>, <-1.896011, -1.336435, 0.348024>, 
      <-1.804879, -1.167353, 0.101533>, <-1.749059, -1.193735, 0.194731>, <-1.796306, -1.158310, 0.311164>, <-1.894390, -1.182087, 0.359247>, 
      <-1.796175, -0.994620, 0.144007>, <-1.766605, -0.916364, 0.193930>, <-1.799273, -0.884004, 0.326204>, <-1.862487, -0.926649, 0.386834>, 
      <-1.875291, -0.934481, 0.118173>, <-1.845721, -0.856225, 0.168096>, <-1.900441, -0.782756, 0.267331>, <-1.963655, -0.825401, 0.327961>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.807534, -1.267894, 0.080851>, <-1.804879, -1.167353, 0.101533>, <-1.796175, -0.994620, 0.144007>, <-1.875291, -0.934481, 0.118173>, 
      <-1.865930, -1.240295, -0.016647>, <-1.863276, -1.139754, 0.004035>, <-1.837304, -1.103466, 0.074570>, <-1.916420, -1.043327, 0.048736>, 
      <-1.997538, -1.215083, -0.043104>, <-1.992222, -1.190426, -0.031582>, <-2.006920, -1.152391, -0.016955>, <-2.016797, -1.139410, 0.005472>, 
      <-2.100148, -1.239956, 0.007198>, <-2.094831, -1.215299, 0.018719>, <-2.094844, -1.211706, 0.067376>, <-2.104721, -1.198726, 0.089802>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.268562, -1.657456, 0.200786>, <-2.327770, -1.617803, 0.103388>, <-2.292186, -1.589557, -0.031179>, <-2.190223, -1.595267, -0.095485>, 
      <-2.246933, -1.566671, 0.225145>, <-2.306140, -1.527018, 0.127746>, <-2.269030, -1.480786, -0.005215>, <-2.167067, -1.486497, -0.069521>, 
      <-2.198353, -1.446623, 0.237704>, <-2.253726, -1.420452, 0.145253>, <-2.219341, -1.365084, 0.007450>, <-2.122042, -1.341498, -0.040248>, 
      <-2.172483, -1.356359, 0.259758>, <-2.227857, -1.330188, 0.167306>, <-2.197447, -1.263542, 0.054896>, <-2.100148, -1.239956, 0.007198>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.268562, -1.657456, 0.200786>, <-2.303274, -1.803153, 0.161694>, <-2.357695, -1.989524, 0.075026>, <-2.359684, -2.142089, 0.048939>, 
      <-2.327770, -1.617803, 0.103388>, <-2.362482, -1.763500, 0.064296>, <-2.407312, -1.956293, -0.006598>, <-2.409301, -2.108858, -0.032685>, 
      <-2.292186, -1.589557, -0.031179>, <-2.323659, -1.737395, -0.066469>, <-2.354311, -1.935863, -0.120651>, <-2.368456, -2.088578, -0.144529>, 
      <-2.190223, -1.595267, -0.095485>, <-2.221696, -1.743106, -0.130775>, <-2.267877, -1.941563, -0.172856>, <-2.282022, -2.094278, -0.196734>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.973266, -1.740570, 0.261417>, <-2.075231, -1.734859, 0.325724>, <-2.209354, -1.697110, 0.298186>, <-2.268562, -1.657456, 0.200786>, 
      <-1.945558, -1.622134, 0.294833>, <-2.047523, -1.616423, 0.359139>, <-2.187724, -1.606324, 0.322544>, <-2.246933, -1.566671, 0.225145>, 
      <-1.897332, -1.462237, 0.338877>, <-1.995835, -1.486114, 0.387165>, <-2.142294, -1.473117, 0.331300>, <-2.198353, -1.446623, 0.237704>, 
      <-1.896011, -1.336435, 0.348024>, <-1.994514, -1.360312, 0.396313>, <-2.116424, -1.382854, 0.353353>, <-2.172483, -1.356359, 0.259758>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.973266, -1.740570, 0.261417>, <-2.007360, -1.886306, 0.220299>, <-2.074194, -2.070943, 0.150633>, <-2.101578, -2.215130, 0.100110>, 
      <-2.075231, -1.734859, 0.325724>, <-2.109325, -1.880596, 0.284606>, <-2.164264, -2.065004, 0.205034>, <-2.191648, -2.209191, 0.154511>, 
      <-2.209354, -1.697110, 0.298186>, <-2.244066, -1.842806, 0.259094>, <-2.305990, -2.024153, 0.160084>, <-2.307979, -2.176718, 0.133997>, 
      <-2.268562, -1.657456, 0.200786>, <-2.303274, -1.803153, 0.161694>, <-2.357695, -1.989524, 0.075026>, <-2.359684, -2.142089, 0.048939>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.894932, -1.678381, -0.034854>, <-1.932259, -1.824417, -0.071898>, <-1.999024, -2.020794, -0.097773>, <-2.036426, -2.163405, -0.146304>, 
      <-1.835725, -1.718034, 0.062544>, <-1.873052, -1.864070, 0.025500>, <-1.949781, -2.053774, -0.016765>, <-1.987183, -2.196385, -0.065296>, 
      <-1.871303, -1.746280, 0.197112>, <-1.905398, -1.892017, 0.155994>, <-1.988412, -2.076600, 0.098822>, <-2.015796, -2.220787, 0.048299>, 
      <-1.973266, -1.740570, 0.261417>, <-2.007360, -1.886306, 0.220299>, <-2.074194, -2.070943, 0.150633>, <-2.101578, -2.215130, 0.100110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.894932, -1.678381, -0.034854>, <-1.835725, -1.718034, 0.062544>, <-1.871303, -1.746280, 0.197112>, <-1.973266, -1.740570, 0.261417>, 
      <-1.863524, -1.555502, -0.003684>, <-1.804317, -1.595155, 0.093713>, <-1.843596, -1.627844, 0.230527>, <-1.945558, -1.622134, 0.294833>, 
      <-1.810910, -1.395776, 0.054545>, <-1.755090, -1.422158, 0.147743>, <-1.799248, -1.438461, 0.290793>, <-1.897332, -1.462237, 0.338877>, 
      <-1.807534, -1.267894, 0.080851>, <-1.751713, -1.294276, 0.174049>, <-1.797927, -1.312659, 0.299941>, <-1.896011, -1.336435, 0.348024>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.894932, -1.678381, -0.034854>, <-1.863524, -1.555502, -0.003684>, <-1.810910, -1.395776, 0.054545>, <-1.807534, -1.267894, 0.080851>, 
      <-1.954139, -1.638728, -0.132252>, <-1.922732, -1.515849, -0.101083>, <-1.869307, -1.368177, -0.042953>, <-1.865930, -1.240295, -0.016647>, 
      <-2.088260, -1.600977, -0.159791>, <-2.065104, -1.492207, -0.133827>, <-2.019433, -1.316625, -0.090550>, <-1.997538, -1.215083, -0.043104>, 
      <-2.190223, -1.595267, -0.095485>, <-2.167067, -1.486497, -0.069521>, <-2.122042, -1.341498, -0.040248>, <-2.100148, -1.239956, 0.007198>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.894932, -1.678381, -0.034854>, <-1.954139, -1.638728, -0.132252>, <-2.088260, -1.600977, -0.159791>, <-2.190223, -1.595267, -0.095485>, 
      <-1.932259, -1.824417, -0.071898>, <-1.991466, -1.784764, -0.169296>, <-2.119733, -1.748816, -0.195081>, <-2.221696, -1.743106, -0.130775>, 
      <-1.999024, -2.020794, -0.097773>, <-2.048266, -1.987814, -0.178781>, <-2.182096, -1.947219, -0.224667>, <-2.267877, -1.941563, -0.172856>, 
      <-2.036426, -2.163405, -0.146304>, <-2.085668, -2.130425, -0.227312>, <-2.196241, -2.099935, -0.248545>, <-2.282022, -2.094278, -0.196734>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.353821, -1.352396, 0.066807>, <2.292489, -1.398290, 0.057043>, <2.234977, -1.390835, -0.018188>, <2.216604, -1.346518, -0.078699>, 
      <2.419593, -1.442187, 0.002103>, <2.358261, -1.488081, -0.007661>, <2.305590, -1.484573, -0.063374>, <2.287216, -1.440256, -0.123885>, 
      <2.517502, -1.562341, -0.074602>, <2.486811, -1.583280, -0.067042>, <2.430748, -1.587481, -0.095936>, <2.417895, -1.559628, -0.118220>, 
      <2.576844, -1.664920, -0.124911>, <2.546153, -1.685859, -0.117351>, <2.493985, -1.692287, -0.124768>, <2.481133, -1.664435, -0.147052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.437931, -1.180902, -0.043463>, <2.458184, -1.229752, 0.023238>, <2.421426, -1.301808, 0.077570>, <2.353821, -1.352396, 0.066807>, 
      <2.494434, -1.292307, -0.094861>, <2.514687, -1.341158, -0.028161>, <2.487198, -1.391599, 0.012866>, <2.419593, -1.442187, 0.002103>, 
      <2.568841, -1.451143, -0.139311>, <2.585247, -1.486695, -0.110867>, <2.556678, -1.535613, -0.084252>, <2.517502, -1.562341, -0.074602>, 
      <2.626384, -1.565338, -0.182830>, <2.642790, -1.600891, -0.154385>, <2.616020, -1.638192, -0.134561>, <2.576844, -1.664920, -0.124911>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.275493, -1.163465, -0.191161>, <2.343001, -1.112949, -0.180413>, <2.417707, -1.132122, -0.110068>, <2.437931, -1.180902, -0.043463>, 
      <2.353002, -1.277966, -0.226650>, <2.420511, -1.227450, -0.215902>, <2.474211, -1.243527, -0.161466>, <2.494434, -1.292307, -0.094861>, 
      <2.462107, -1.441767, -0.182020>, <2.492799, -1.420827, -0.189580>, <2.555988, -1.423289, -0.161596>, <2.568841, -1.451143, -0.139311>, 
      <2.530668, -1.564853, -0.204972>, <2.561360, -1.543913, -0.212532>, <2.613531, -1.537484, -0.205115>, <2.626384, -1.565338, -0.182830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.275493, -1.163465, -0.191161>, <2.353002, -1.277966, -0.226650>, <2.462107, -1.441767, -0.182020>, <2.530668, -1.564853, -0.204972>, 
      <2.207210, -1.214560, -0.202032>, <2.284719, -1.329061, -0.237520>, <2.422931, -1.468495, -0.172370>, <2.491492, -1.591580, -0.195322>, 
      <2.196148, -1.297178, -0.146068>, <2.266761, -1.390916, -0.191254>, <2.401490, -1.524076, -0.146665>, <2.464727, -1.628883, -0.175497>, 
      <2.216604, -1.346518, -0.078699>, <2.287216, -1.440256, -0.123885>, <2.417895, -1.559628, -0.118220>, <2.481133, -1.664435, -0.147052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.705132, -1.776592, -0.310053>, <2.659896, -1.708140, -0.292393>, <2.623690, -1.614107, -0.237143>, <2.588786, -1.544470, -0.205896>, 
      <2.714032, -1.776323, -0.307630>, <2.668796, -1.707871, -0.289970>, <2.631159, -1.614145, -0.235415>, <2.596256, -1.544508, -0.204168>, 
      <2.725782, -1.777828, -0.302396>, <2.677960, -1.711735, -0.283548>, <2.642314, -1.615934, -0.230486>, <2.606116, -1.546683, -0.200410>, 
      <2.732684, -1.780799, -0.297039>, <2.684861, -1.714705, -0.278191>, <2.648221, -1.619213, -0.226862>, <2.612023, -1.549962, -0.196786>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.668760, -1.782729, -0.314442>, <2.625692, -1.713713, -0.296149>, <2.592778, -1.619607, -0.240471>, <2.560215, -1.549698, -0.208769>, 
      <2.679476, -1.779673, -0.314515>, <2.636408, -1.710657, -0.296222>, <2.601040, -1.616710, -0.240602>, <2.568477, -1.546801, -0.208900>, 
      <2.694384, -1.776917, -0.312979>, <2.649148, -1.708464, -0.295319>, <2.615159, -1.614063, -0.239116>, <2.580255, -1.544426, -0.207869>, 
      <2.705132, -1.776592, -0.310053>, <2.659896, -1.708140, -0.292393>, <2.623690, -1.614107, -0.237143>, <2.588786, -1.544470, -0.205896>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.629098, -1.798279, -0.309537>, <2.590748, -1.727772, -0.291706>, <2.570157, -1.635746, -0.218192>, <2.530668, -1.564853, -0.204972>, 
      <2.640357, -1.792670, -0.312237>, <2.602006, -1.722163, -0.294405>, <2.578273, -1.630208, -0.220191>, <2.538784, -1.559315, -0.206972>, 
      <2.656389, -1.786258, -0.314358>, <2.613321, -1.717242, -0.296065>, <2.583318, -1.622925, -0.240320>, <2.550754, -1.553016, -0.208619>, 
      <2.668760, -1.782729, -0.314442>, <2.625692, -1.713713, -0.296149>, <2.592778, -1.619607, -0.240471>, <2.560215, -1.549698, -0.208769>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.592200, -1.820870, -0.296084>, <2.561065, -1.748759, -0.277771>, <2.530905, -1.657596, -0.225379>, <2.504636, -1.587621, -0.195077>, 
      <2.602285, -1.813351, -0.301232>, <2.571150, -1.741240, -0.282919>, <2.537676, -1.650051, -0.229080>, <2.511407, -1.580077, -0.198778>, 
      <2.617203, -1.804205, -0.306685>, <2.578853, -1.733698, -0.288853>, <2.561422, -1.641706, -0.216040>, <2.521933, -1.570813, -0.202820>, 
      <2.629098, -1.798279, -0.309537>, <2.590748, -1.727772, -0.291706>, <2.570157, -1.635746, -0.218192>, <2.530668, -1.564853, -0.204972>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.563670, -1.847064, -0.276136>, <2.538677, -1.774551, -0.257519>, <2.509353, -1.684299, -0.209258>, <2.486074, -1.614542, -0.180596>, 
      <2.570830, -1.838666, -0.283138>, <2.545838, -1.766153, -0.264521>, <2.513591, -1.675779, -0.214213>, <2.490313, -1.606022, -0.185551>, 
      <2.582503, -1.828101, -0.291134>, <2.551368, -1.755990, -0.272820>, <2.524174, -1.665096, -0.221700>, <2.497905, -1.595122, -0.191398>, 
      <2.592200, -1.820870, -0.296084>, <2.561065, -1.748759, -0.277771>, <2.530905, -1.657596, -0.225379>, <2.504636, -1.587621, -0.195077>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.547859, -1.872878, -0.252723>, <2.529499, -1.800502, -0.232816>, <2.498834, -1.710925, -0.190429>, <2.477824, -1.641517, -0.163732>, 
      <2.550624, -1.864949, -0.260552>, <2.532264, -1.792573, -0.240645>, <2.499642, -1.702771, -0.195912>, <2.478631, -1.633362, -0.169215>, 
      <2.557380, -1.854441, -0.269985>, <2.532388, -1.781928, -0.251368>, <2.505458, -1.692128, -0.204704>, <2.482179, -1.622372, -0.176042>, 
      <2.563670, -1.847064, -0.276136>, <2.538677, -1.774551, -0.257519>, <2.509353, -1.684299, -0.209258>, <2.486074, -1.614542, -0.180596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.547171, -1.894381, -0.229413>, <2.536917, -1.821668, -0.210191>, <2.519303, -1.727696, -0.164455>, <2.481133, -1.664435, -0.147052>, 
      <2.544873, -1.888508, -0.236539>, <2.534619, -1.815795, -0.217318>, <2.516401, -1.721406, -0.169486>, <2.478230, -1.658146, -0.152083>, 
      <2.545567, -1.879450, -0.246233>, <2.527207, -1.807074, -0.226326>, <2.498133, -1.718006, -0.185669>, <2.477123, -1.648598, -0.158971>, 
      <2.547859, -1.872878, -0.252723>, <2.529499, -1.800502, -0.232816>, <2.498834, -1.710925, -0.190429>, <2.477824, -1.641517, -0.163732>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.561713, -1.908290, -0.209757>, <2.544518, -1.837822, -0.190777>, <2.515362, -1.748355, -0.156095>, <2.495497, -1.679812, -0.133097>, 
      <2.555401, -1.905574, -0.214656>, <2.538206, -1.835105, -0.195676>, <2.509526, -1.745116, -0.159676>, <2.489661, -1.676572, -0.136678>, 
      <2.549209, -1.899590, -0.223094>, <2.538955, -1.826877, -0.203872>, <2.521871, -1.733261, -0.160003>, <2.483701, -1.670000, -0.142600>, 
      <2.547171, -1.894381, -0.229413>, <2.536917, -1.821668, -0.210191>, <2.519303, -1.727696, -0.164455>, <2.481133, -1.664435, -0.147052>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.589266, -1.912498, -0.196741>, <2.565806, -1.843725, -0.179724>, <2.539889, -1.753464, -0.145813>, <2.518728, -1.685306, -0.123986>, 
      <2.580365, -1.912766, -0.199165>, <2.556906, -1.843994, -0.182147>, <2.532421, -1.753425, -0.147540>, <2.511260, -1.685268, -0.125714>, 
      <2.568615, -1.911261, -0.204400>, <2.551420, -1.840792, -0.185419>, <2.521268, -1.751634, -0.152472>, <2.501403, -1.683091, -0.129473>, 
      <2.561713, -1.908290, -0.209757>, <2.544518, -1.837822, -0.190777>, <2.515362, -1.748355, -0.156095>, <2.495497, -1.679812, -0.133097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.625640, -1.906363, -0.192350>, <2.596308, -1.839508, -0.175388>, <2.570797, -1.747962, -0.142484>, <2.547293, -1.680076, -0.121113>, 
      <2.614923, -1.909420, -0.192278>, <2.585591, -1.842565, -0.175316>, <2.562537, -1.750860, -0.142353>, <2.539033, -1.682974, -0.120982>, 
      <2.600014, -1.912174, -0.193814>, <2.576555, -1.843401, -0.176797>, <2.548418, -1.753507, -0.143839>, <2.527257, -1.685349, -0.122013>, 
      <2.589266, -1.912498, -0.196741>, <2.565806, -1.843725, -0.179724>, <2.539889, -1.753464, -0.145813>, <2.518728, -1.685306, -0.123986>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.665295, -1.890811, -0.197255>, <2.627171, -1.826989, -0.181735>, <2.611849, -1.725430, -0.154588>, <2.576844, -1.664920, -0.124911>, 
      <2.654038, -1.896420, -0.194556>, <2.615914, -1.832597, -0.179036>, <2.603732, -1.730969, -0.152589>, <2.568727, -1.670459, -0.122912>, 
      <2.638009, -1.902835, -0.192434>, <2.608677, -1.835980, -0.175472>, <2.580259, -1.744643, -0.142635>, <2.556755, -1.676757, -0.121264>, 
      <2.625640, -1.906363, -0.192350>, <2.596308, -1.839508, -0.175388>, <2.570797, -1.747962, -0.142484>, <2.547293, -1.680076, -0.121113>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.702198, -1.868218, -0.210706>, <2.659174, -1.805790, -0.194657>, <2.632675, -1.709970, -0.157573>, <2.602880, -1.642149, -0.134802>, 
      <2.692112, -1.875739, -0.205557>, <2.649089, -1.813310, -0.189508>, <2.625904, -1.717515, -0.153872>, <2.596108, -1.649694, -0.131101>, 
      <2.677191, -1.884884, -0.200107>, <2.639067, -1.821061, -0.184587>, <2.620585, -1.719469, -0.156739>, <2.585580, -1.658959, -0.127062>, 
      <2.665295, -1.890811, -0.197255>, <2.627171, -1.826989, -0.181735>, <2.611849, -1.725430, -0.154588>, <2.576844, -1.664920, -0.124911>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.730726, -1.842021, -0.230658>, <2.685858, -1.778547, -0.214596>, <2.654224, -1.683267, -0.173696>, <2.621438, -1.615230, -0.149284>, 
      <2.723566, -1.850419, -0.223655>, <2.678698, -1.786946, -0.207593>, <2.649986, -1.691786, -0.168741>, <2.617200, -1.623749, -0.144329>, 
      <2.711895, -1.860987, -0.215657>, <2.668872, -1.798558, -0.199607>, <2.639406, -1.702470, -0.161252>, <2.609611, -1.634649, -0.138481>, 
      <2.702198, -1.868218, -0.210706>, <2.659174, -1.805790, -0.194657>, <2.632675, -1.709970, -0.157573>, <2.602880, -1.642149, -0.134802>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.746537, -1.816211, -0.254070>, <2.696275, -1.754794, -0.236667>, <2.664745, -1.656642, -0.192525>, <2.629691, -1.588256, -0.166148>, 
      <2.743772, -1.824139, -0.246241>, <2.693510, -1.762721, -0.228838>, <2.663936, -1.664797, -0.187042>, <2.628883, -1.596410, -0.160665>, 
      <2.737015, -1.834645, -0.236808>, <2.692147, -1.771171, -0.220746>, <2.658119, -1.675438, -0.178250>, <2.625333, -1.607401, -0.153838>, 
      <2.730726, -1.842021, -0.230658>, <2.685858, -1.778547, -0.214596>, <2.654224, -1.683267, -0.173696>, <2.621438, -1.615230, -0.149284>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.747227, -1.794711, -0.277379>, <2.693456, -1.734890, -0.257782>, <2.661652, -1.635328, -0.209503>, <2.626384, -1.565338, -0.182830>, 
      <2.749524, -1.800584, -0.270253>, <2.695753, -1.740763, -0.250656>, <2.664554, -1.641618, -0.204471>, <2.629286, -1.571628, -0.177798>, 
      <2.748829, -1.809640, -0.260559>, <2.698567, -1.748223, -0.243156>, <2.665447, -1.649561, -0.197286>, <2.630393, -1.581175, -0.170909>, 
      <2.746537, -1.816211, -0.254070>, <2.696275, -1.754794, -0.236667>, <2.664745, -1.656642, -0.192525>, <2.629691, -1.588256, -0.166148>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.747227, -1.794711, -0.277379>, <2.745189, -1.789502, -0.283700>, <2.738997, -1.783516, -0.292139>, <2.732684, -1.780799, -0.297039>, 
      <2.693456, -1.734890, -0.257782>, <2.691418, -1.729681, -0.264102>, <2.691174, -1.717423, -0.273291>, <2.684861, -1.714705, -0.278191>, 
      <2.661652, -1.635328, -0.209503>, <2.659085, -1.629764, -0.213954>, <2.654057, -1.622452, -0.223282>, <2.648221, -1.619213, -0.226862>, 
      <2.626384, -1.565338, -0.182830>, <2.623817, -1.559774, -0.187282>, <2.617859, -1.553201, -0.193206>, <2.612023, -1.549962, -0.196786>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.837527, -1.920872, -0.303003>, <2.876374, -1.953963, -0.295709>, <2.973475, -2.002502, -0.309692>, <2.978153, -2.009160, -0.258790>, 
      <2.846074, -1.912781, -0.300013>, <2.884921, -1.945872, -0.292719>, <2.973265, -2.002442, -0.313330>, <2.977944, -2.009100, -0.262428>, 
      <2.847930, -1.895068, -0.296113>, <2.889029, -1.922092, -0.297131>, <2.949121, -1.948712, -0.304425>, <2.990063, -1.975904, -0.302257>, 
      <2.855118, -1.885935, -0.292596>, <2.896216, -1.912959, -0.293614>, <2.961106, -1.930724, -0.305879>, <3.002048, -1.957916, -0.303710>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.837527, -1.920872, -0.303003>, <2.793228, -1.883137, -0.311321>, <2.736816, -1.824537, -0.322422>, <2.705132, -1.776592, -0.310053>, 
      <2.846074, -1.912781, -0.300013>, <2.801775, -1.875046, -0.308330>, <2.745716, -1.824268, -0.319999>, <2.714032, -1.776323, -0.307630>, 
      <2.847930, -1.895068, -0.296113>, <2.807471, -1.868464, -0.295111>, <2.753445, -1.816060, -0.313298>, <2.725782, -1.777828, -0.302396>, 
      <2.855118, -1.885935, -0.292596>, <2.814659, -1.859331, -0.291594>, <2.760346, -1.819030, -0.307941>, <2.732684, -1.780799, -0.297039>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.801633, -1.936566, -0.311309>, <2.833506, -1.975189, -0.308989>, <2.876088, -2.026668, -0.303205>, <2.904053, -2.067855, -0.297316>, 
      <2.811757, -1.930132, -0.310644>, <2.843630, -1.968755, -0.308324>, <2.898112, -2.005635, -0.306429>, <2.926076, -2.046822, -0.300540>, 
      <2.829071, -1.928877, -0.305962>, <2.867918, -1.961968, -0.298668>, <2.973179, -2.002417, -0.314835>, <2.977857, -2.009075, -0.263933>, 
      <2.837527, -1.920872, -0.303003>, <2.876374, -1.953963, -0.295709>, <2.973475, -2.002502, -0.309692>, <2.978153, -2.009160, -0.258790>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.801633, -1.936566, -0.311309>, <2.762855, -1.889576, -0.314132>, <2.700262, -1.833210, -0.327822>, <2.668760, -1.782729, -0.314442>, 
      <2.811757, -1.930132, -0.310644>, <2.772979, -1.883141, -0.313466>, <2.710978, -1.830154, -0.327895>, <2.679476, -1.779673, -0.314515>, 
      <2.829071, -1.928877, -0.305962>, <2.784772, -1.891141, -0.314279>, <2.726068, -1.824861, -0.325348>, <2.694384, -1.776917, -0.312979>, 
      <2.837527, -1.920872, -0.303003>, <2.793228, -1.883137, -0.311321>, <2.736816, -1.824537, -0.322422>, <2.705132, -1.776592, -0.310053>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.753397, -1.974341, -0.308533>, <2.786513, -2.021347, -0.298666>, <2.848966, -2.115529, -0.298261>, <2.858305, -2.123621, -0.241244>, 
      <2.769523, -1.965617, -0.310071>, <2.802639, -2.012623, -0.300204>, <2.848702, -2.115453, -0.302864>, <2.858041, -2.123545, -0.245847>, 
      <2.786129, -1.946420, -0.312328>, <2.818002, -1.985043, -0.310008>, <2.856378, -2.045493, -0.300319>, <2.884342, -2.086680, -0.294430>, 
      <2.801633, -1.936566, -0.311309>, <2.833506, -1.975189, -0.308989>, <2.876088, -2.026668, -0.303205>, <2.904053, -2.067855, -0.297316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.753397, -1.974341, -0.308533>, <2.716696, -1.922246, -0.319468>, <2.659256, -1.853725, -0.323560>, <2.629098, -1.798279, -0.309537>, 
      <2.769523, -1.965617, -0.310071>, <2.732822, -1.913522, -0.321007>, <2.670515, -1.848116, -0.326259>, <2.640357, -1.792670, -0.312237>, 
      <2.786129, -1.946420, -0.312328>, <2.747351, -1.899429, -0.315151>, <2.687891, -1.836739, -0.327738>, <2.656389, -1.786258, -0.314358>, 
      <2.801633, -1.936566, -0.311309>, <2.762855, -1.889576, -0.314132>, <2.700262, -1.833210, -0.327822>, <2.668760, -1.782729, -0.314442>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.683006, -2.000743, -0.299993>, <2.656834, -1.946280, -0.302037>, <2.615540, -1.874927, -0.309812>, <2.592200, -1.820870, -0.296084>, 
      <2.703952, -1.992891, -0.303846>, <2.677780, -1.938428, -0.305890>, <2.625625, -1.867408, -0.314961>, <2.602285, -1.813351, -0.301232>, 
      <2.733502, -1.985104, -0.306635>, <2.696801, -1.933009, -0.317570>, <2.647361, -1.859651, -0.320707>, <2.617203, -1.804205, -0.306685>, 
      <2.753397, -1.974341, -0.308533>, <2.716696, -1.922246, -0.319468>, <2.659256, -1.853725, -0.323560>, <2.629098, -1.798279, -0.309537>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.683006, -2.000743, -0.299993>, <2.702706, -2.041738, -0.298455>, <2.728439, -2.096345, -0.290234>, <2.744781, -2.138383, -0.284169>, 
      <2.703952, -1.992891, -0.303846>, <2.723652, -2.033885, -0.302308>, <2.763212, -2.084827, -0.292112>, <2.779554, -2.126865, -0.286047>, 
      <2.733502, -1.985104, -0.306635>, <2.766619, -2.032110, -0.296768>, <2.848612, -2.115427, -0.304420>, <2.857951, -2.123519, -0.247404>, 
      <2.753397, -1.974341, -0.308533>, <2.786513, -2.021347, -0.298666>, <2.848966, -2.115529, -0.298261>, <2.858305, -2.123621, -0.241244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.626481, -2.021919, -0.285186>, <2.643613, -2.071971, -0.278544>, <2.670592, -2.173790, -0.283412>, <2.678691, -2.183114, -0.231544>, 
      <2.644066, -2.018396, -0.290285>, <2.661198, -2.068448, -0.283644>, <2.670315, -2.173711, -0.288228>, <2.678414, -2.183034, -0.236360>, 
      <2.665801, -2.007193, -0.296828>, <2.685501, -2.048187, -0.295290>, <2.701251, -2.105350, -0.288766>, <2.717593, -2.147388, -0.282701>, 
      <2.683006, -2.000743, -0.299993>, <2.702706, -2.041738, -0.298455>, <2.728439, -2.096345, -0.290234>, <2.744781, -2.138383, -0.284169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.626481, -2.021919, -0.285186>, <2.608551, -1.969533, -0.292137>, <2.581341, -1.898334, -0.289299>, <2.563670, -1.847064, -0.276136>, 
      <2.644066, -2.018396, -0.290285>, <2.626136, -1.966010, -0.297237>, <2.588501, -1.889936, -0.296301>, <2.570830, -1.838666, -0.283138>, 
      <2.665801, -2.007193, -0.296828>, <2.639628, -1.952730, -0.298872>, <2.605843, -1.882158, -0.304862>, <2.582503, -1.828101, -0.291134>, 
      <2.683006, -2.000743, -0.299993>, <2.656834, -1.946280, -0.302037>, <2.615540, -1.874927, -0.309812>, <2.592200, -1.820870, -0.296084>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.574467, -2.022488, -0.268518>, <2.580316, -2.065161, -0.271740>, <2.584061, -2.122868, -0.278907>, <2.587991, -2.165688, -0.274830>, 
      <2.589347, -2.019743, -0.274809>, <2.595196, -2.062417, -0.278031>, <2.614582, -2.125036, -0.279306>, <2.618511, -2.167856, -0.275229>, 
      <2.611026, -2.025015, -0.280704>, <2.628158, -2.075068, -0.274063>, <2.670296, -2.173705, -0.288551>, <2.678396, -2.183029, -0.236683>, 
      <2.626481, -2.021919, -0.285186>, <2.643613, -2.071971, -0.278544>, <2.670592, -2.173790, -0.283412>, <2.678691, -2.183114, -0.231544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.574467, -2.022488, -0.268518>, <2.568261, -1.977206, -0.265099>, <2.558748, -1.915804, -0.264530>, <2.547859, -1.872878, -0.252723>, 
      <2.589347, -2.019743, -0.274809>, <2.583141, -1.974462, -0.271390>, <2.561513, -1.907876, -0.272359>, <2.550624, -1.864949, -0.260552>, 
      <2.611026, -2.025015, -0.280704>, <2.593096, -1.972629, -0.287656>, <2.575051, -1.905711, -0.283149>, <2.557380, -1.854441, -0.269985>, 
      <2.626481, -2.021919, -0.285186>, <2.608551, -1.969533, -0.292137>, <2.581341, -1.898334, -0.289299>, <2.563670, -1.847064, -0.276136>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.533953, -2.038987, -0.246065>, <2.530585, -2.079205, -0.246081>, <2.521412, -2.132191, -0.234863>, <2.523912, -2.172117, -0.229521>, 
      <2.531559, -2.035826, -0.260273>, <2.528191, -2.076044, -0.260289>, <2.520057, -2.131802, -0.258444>, <2.522557, -2.171728, -0.253102>, 
      <2.561072, -2.024959, -0.262855>, <2.566921, -2.067632, -0.266076>, <2.560500, -2.121194, -0.278599>, <2.564430, -2.164014, -0.274522>, 
      <2.574467, -2.022488, -0.268518>, <2.580316, -2.065161, -0.271740>, <2.584061, -2.122868, -0.278907>, <2.587991, -2.165688, -0.274830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.533953, -2.038987, -0.246065>, <2.537612, -1.995292, -0.246048>, <2.553094, -1.936384, -0.240517>, <2.547171, -1.894381, -0.229413>, 
      <2.531559, -2.035826, -0.260273>, <2.535218, -1.992131, -0.260256>, <2.550797, -1.930511, -0.247643>, <2.544873, -1.888508, -0.236539>, 
      <2.561072, -2.024959, -0.262855>, <2.554866, -1.979677, -0.259436>, <2.556457, -1.922377, -0.258040>, <2.545567, -1.879450, -0.246233>, 
      <2.574467, -2.022488, -0.268518>, <2.568261, -1.977206, -0.265099>, <2.558748, -1.915804, -0.264530>, <2.547859, -1.872878, -0.252723>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.581322, -2.031539, -0.227833>, <2.586397, -2.073587, -0.224379>, <2.589302, -2.125377, -0.195593>, <2.592953, -2.167114, -0.188494>, 
      <2.566761, -2.032050, -0.232790>, <2.571836, -2.074098, -0.229336>, <2.565224, -2.123666, -0.195278>, <2.568876, -2.165403, -0.188179>, 
      <2.536451, -2.042285, -0.231241>, <2.533082, -2.082503, -0.231257>, <2.522797, -2.132590, -0.210766>, <2.525297, -2.172515, -0.205424>, 
      <2.533953, -2.038987, -0.246065>, <2.530585, -2.079205, -0.246081>, <2.521412, -2.132191, -0.234863>, <2.523912, -2.172117, -0.229521>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.581322, -2.031539, -0.227833>, <2.576804, -1.994105, -0.230908>, <2.570389, -1.943845, -0.219334>, <2.561713, -1.908290, -0.209757>, 
      <2.566761, -2.032050, -0.232790>, <2.562243, -1.994617, -0.235866>, <2.564077, -1.941129, -0.224232>, <2.555401, -1.905574, -0.214656>, 
      <2.536451, -2.042285, -0.231241>, <2.540110, -1.998590, -0.231224>, <2.555132, -1.941593, -0.234197>, <2.549209, -1.899590, -0.223094>, 
      <2.533953, -2.038987, -0.246065>, <2.537612, -1.995292, -0.246048>, <2.553094, -1.936384, -0.240517>, <2.547171, -1.894381, -0.229413>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.638128, -2.035327, -0.210597>, <2.625709, -1.997745, -0.205764>, <2.601801, -1.949243, -0.205833>, <2.589266, -1.912498, -0.196741>, 
      <2.621046, -2.038974, -0.214251>, <2.608627, -2.001392, -0.209417>, <2.592900, -1.949511, -0.208257>, <2.580365, -1.912766, -0.199165>, 
      <2.598206, -2.030946, -0.222085>, <2.593687, -1.993512, -0.225160>, <2.577291, -1.946816, -0.213976>, <2.568615, -1.911261, -0.204400>, 
      <2.581322, -2.031539, -0.227833>, <2.576804, -1.994105, -0.230908>, <2.570389, -1.943845, -0.219334>, <2.561713, -1.908290, -0.209757>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.638128, -2.035327, -0.210597>, <2.652580, -2.079062, -0.216222>, <2.685740, -2.191228, -0.186403>, <2.678691, -2.183114, -0.231544>, 
      <2.621046, -2.038974, -0.214251>, <2.635498, -2.082709, -0.219875>, <2.686021, -2.191309, -0.181503>, <2.678972, -2.183195, -0.226644>, 
      <2.598206, -2.030946, -0.222085>, <2.603281, -2.072994, -0.218630>, <2.618405, -2.127445, -0.195974>, <2.622056, -2.169182, -0.188874>, 
      <2.581322, -2.031539, -0.227833>, <2.586397, -2.073587, -0.224379>, <2.589302, -2.125377, -0.195593>, <2.592953, -2.167114, -0.188494>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.691203, -2.008079, -0.204332>, <2.674028, -1.975900, -0.204990>, <2.639917, -1.938904, -0.200606>, <2.625640, -1.906363, -0.192350>, 
      <2.674228, -2.013991, -0.205207>, <2.657052, -1.981811, -0.205865>, <2.629201, -1.941961, -0.200534>, <2.614923, -1.909420, -0.192278>, 
      <2.655355, -2.031649, -0.206913>, <2.642936, -1.994067, -0.202079>, <2.612549, -1.948919, -0.202907>, <2.600014, -1.912174, -0.193814>, 
      <2.638128, -2.035327, -0.210597>, <2.625709, -1.997745, -0.205764>, <2.601801, -1.949243, -0.205833>, <2.589266, -1.912498, -0.196741>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.691203, -2.008079, -0.204332>, <2.711755, -2.046585, -0.203544>, <2.734694, -2.099497, -0.192297>, <2.750330, -2.139980, -0.187570>, 
      <2.674228, -2.013991, -0.205207>, <2.694780, -2.052497, -0.204419>, <2.707823, -2.108397, -0.190846>, <2.723459, -2.148880, -0.186119>, 
      <2.655355, -2.031649, -0.206913>, <2.669807, -2.075384, -0.212537>, <2.686013, -2.191307, -0.181643>, <2.678964, -2.183193, -0.226784>, 
      <2.638128, -2.035327, -0.210597>, <2.652580, -2.079062, -0.216222>, <2.685740, -2.191228, -0.186403>, <2.678691, -2.183114, -0.231544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.770556, -1.989209, -0.203771>, <2.743226, -1.956244, -0.197542>, <2.687017, -1.927175, -0.206098>, <2.665295, -1.890811, -0.197255>, 
      <2.748331, -1.999292, -0.201993>, <2.721001, -1.966327, -0.195764>, <2.675760, -1.932784, -0.203399>, <2.654038, -1.896420, -0.194556>, 
      <2.714285, -2.000041, -0.203142>, <2.697109, -1.967861, -0.203801>, <2.652287, -1.935376, -0.200690>, <2.638009, -1.902835, -0.192434>, 
      <2.691203, -2.008079, -0.204332>, <2.674028, -1.975900, -0.204990>, <2.639917, -1.938904, -0.200606>, <2.625640, -1.906363, -0.192350>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.770556, -1.989209, -0.203771>, <2.801788, -2.026882, -0.210889>, <2.866221, -2.130480, -0.192915>, <2.858305, -2.123621, -0.241244>, 
      <2.748331, -1.999292, -0.201993>, <2.779563, -2.036965, -0.209111>, <2.866573, -2.130581, -0.186785>, <2.858657, -2.123722, -0.235114>, 
      <2.714285, -2.000041, -0.203142>, <2.734837, -2.038547, -0.202354>, <2.769302, -2.088034, -0.194166>, <2.784938, -2.128517, -0.189439>, 
      <2.691203, -2.008079, -0.204332>, <2.711755, -2.046585, -0.203544>, <2.734694, -2.099497, -0.192297>, <2.750330, -2.139980, -0.187570>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.816038, -1.951445, -0.214318>, <2.848873, -1.983248, -0.211337>, <2.884541, -2.031913, -0.196753>, <2.910115, -2.069598, -0.191827>, 
      <2.802421, -1.962275, -0.209647>, <2.835256, -1.994078, -0.206666>, <2.865190, -2.050394, -0.193920>, <2.890764, -2.088079, -0.188994>, 
      <2.786918, -1.981786, -0.205080>, <2.818151, -2.019459, -0.212198>, <2.866480, -2.130554, -0.188397>, <2.858565, -2.123696, -0.236725>, 
      <2.770556, -1.989209, -0.203771>, <2.801788, -2.026882, -0.210889>, <2.866221, -2.130480, -0.192915>, <2.858305, -2.123621, -0.241244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.816038, -1.951445, -0.214318>, <2.785704, -1.922065, -0.217072>, <2.725692, -1.902308, -0.219470>, <2.702198, -1.868218, -0.210706>, 
      <2.802421, -1.962275, -0.209647>, <2.772087, -1.932895, -0.212401>, <2.715607, -1.909829, -0.214321>, <2.692112, -1.875739, -0.205557>, 
      <2.786918, -1.981786, -0.205080>, <2.759588, -1.948821, -0.198851>, <2.698913, -1.921248, -0.208950>, <2.677191, -1.884884, -0.200107>, 
      <2.770556, -1.989209, -0.203771>, <2.743226, -1.956244, -0.197542>, <2.687017, -1.927175, -0.206098>, <2.665295, -1.890811, -0.197255>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.844322, -1.930542, -0.229074>, <2.808676, -1.906463, -0.225021>, <2.755150, -1.876573, -0.239401>, <2.730726, -1.842021, -0.230658>, 
      <2.836703, -1.937716, -0.224447>, <2.801058, -1.913637, -0.220394>, <2.747990, -1.884972, -0.232399>, <2.723566, -1.850419, -0.223655>, 
      <2.824687, -1.944566, -0.217285>, <2.794353, -1.915186, -0.220039>, <2.735390, -1.895077, -0.224421>, <2.711895, -1.860987, -0.215657>, 
      <2.816038, -1.951445, -0.214318>, <2.785704, -1.922065, -0.217072>, <2.725692, -1.902308, -0.219470>, <2.702198, -1.868218, -0.210706>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.844322, -1.930542, -0.229074>, <2.883435, -1.956963, -0.233521>, <2.982456, -2.015284, -0.211974>, <2.978153, -2.009160, -0.258790>, 
      <2.836703, -1.937716, -0.224447>, <2.875816, -1.964137, -0.228894>, <2.982783, -2.015378, -0.206282>, <2.978480, -2.009254, -0.253098>, 
      <2.824687, -1.944566, -0.217285>, <2.857522, -1.976369, -0.214303>, <2.908917, -2.008632, -0.200322>, <2.934491, -2.046317, -0.195396>, 
      <2.816038, -1.951445, -0.214318>, <2.848873, -1.983248, -0.211337>, <2.884541, -2.031913, -0.196753>, <2.910115, -2.069598, -0.191827>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.878661, -1.892481, -0.252353>, <2.838801, -1.870570, -0.257457>, <2.774852, -1.850810, -0.263874>, <2.746537, -1.816211, -0.254070>, 
      <2.871188, -1.905097, -0.243971>, <2.831328, -1.883186, -0.249075>, <2.772087, -1.858737, -0.256045>, <2.743772, -1.824139, -0.246241>, 
      <2.855568, -1.919953, -0.235905>, <2.819923, -1.895874, -0.231852>, <2.761439, -1.869197, -0.245552>, <2.737015, -1.834645, -0.236808>, 
      <2.844322, -1.930542, -0.229074>, <2.808676, -1.906463, -0.225021>, <2.755150, -1.876573, -0.239401>, <2.730726, -1.842021, -0.230658>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.878661, -1.892481, -0.252353>, <2.917310, -1.913727, -0.247404>, <2.970432, -1.934372, -0.225774>, <3.006814, -1.959285, -0.220743>, 
      <2.871188, -1.905097, -0.243971>, <2.909837, -1.926343, -0.239022>, <2.958985, -1.951551, -0.224385>, <2.995368, -1.976465, -0.219355>, 
      <2.855568, -1.919953, -0.235905>, <2.894682, -1.946374, -0.240352>, <2.982656, -2.015341, -0.208500>, <2.978353, -2.009217, -0.255315>, 
      <2.844322, -1.930542, -0.229074>, <2.883435, -1.956963, -0.233521>, <2.982456, -2.015284, -0.211974>, <2.978153, -2.009160, -0.258790>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.888149, -1.856551, -0.278233>, <2.845749, -1.838356, -0.279887>, <2.777214, -1.828071, -0.288308>, <2.747227, -1.794711, -0.277379>, 
      <2.894943, -1.858440, -0.266621>, <2.852543, -1.840245, -0.268275>, <2.779511, -1.833944, -0.281182>, <2.749524, -1.800584, -0.270253>, 
      <2.884672, -1.882333, -0.259095>, <2.844812, -1.860422, -0.264199>, <2.777144, -1.844239, -0.270363>, <2.748829, -1.809640, -0.260559>, 
      <2.878661, -1.892481, -0.252353>, <2.838801, -1.870570, -0.257457>, <2.774852, -1.850810, -0.263874>, <2.746537, -1.816211, -0.254070>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.888149, -1.856551, -0.278233>, <2.933030, -1.875811, -0.276482>, <2.996647, -1.893574, -0.269907>, <3.037920, -1.919457, -0.266038>, 
      <2.894943, -1.858440, -0.266621>, <2.939824, -1.877700, -0.264870>, <2.998149, -1.894005, -0.243762>, <3.039422, -1.919888, -0.239893>, 
      <2.884672, -1.882333, -0.259095>, <2.923321, -1.903579, -0.254146>, <2.981695, -1.917467, -0.227139>, <3.018077, -1.942380, -0.222109>, 
      <2.878661, -1.892481, -0.252353>, <2.917310, -1.913727, -0.247404>, <2.970432, -1.934372, -0.225774>, <3.006814, -1.959285, -0.220743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.888149, -1.856551, -0.278233>, <2.933030, -1.875811, -0.276482>, <2.996647, -1.893574, -0.269907>, <3.037920, -1.919457, -0.266038>, 
      <2.881176, -1.854612, -0.290153>, <2.926057, -1.873872, -0.288402>, <2.995216, -1.893162, -0.294830>, <3.036488, -1.919046, -0.290961>, 
      <2.863373, -1.875446, -0.288557>, <2.904471, -1.902470, -0.289575>, <2.971843, -1.914609, -0.307181>, <3.012785, -1.941801, -0.305012>, 
      <2.855118, -1.885935, -0.292596>, <2.896216, -1.912959, -0.293614>, <2.961106, -1.930724, -0.305879>, <3.002048, -1.957916, -0.303710>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.888149, -1.856551, -0.278233>, <2.881176, -1.854612, -0.290153>, <2.863373, -1.875446, -0.288557>, <2.855118, -1.885935, -0.292596>, 
      <2.845749, -1.838356, -0.279887>, <2.838776, -1.836417, -0.291807>, <2.822913, -1.848843, -0.287555>, <2.814659, -1.859331, -0.291594>, 
      <2.777214, -1.828071, -0.288308>, <2.775176, -1.822862, -0.294629>, <2.766659, -1.821747, -0.303042>, <2.760346, -1.819030, -0.307941>, 
      <2.747227, -1.794711, -0.277379>, <2.745189, -1.789502, -0.283700>, <2.738997, -1.783516, -0.292139>, <2.732684, -1.780799, -0.297039>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.525668, -2.363471, -0.301222>, <3.513395, -2.379078, -0.299431>, <3.501921, -2.397346, -0.289722>, <3.506604, -2.400437, -0.270593>, 
      <3.525668, -2.363471, -0.301222>, <3.522246, -2.384217, -0.295529>, <3.517680, -2.394469, -0.292548>, <3.522363, -2.397559, -0.273419>, 
      <3.525668, -2.363471, -0.301222>, <3.522246, -2.384217, -0.295529>, <3.539984, -2.383780, -0.287395>, <3.542558, -2.385479, -0.276885>, 
      <3.525668, -2.363471, -0.301222>, <3.534520, -2.368610, -0.297320>, <3.549999, -2.371046, -0.288857>, <3.552572, -2.372744, -0.278346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.466380, -2.388483, -0.262889>, <3.476332, -2.396374, -0.264475>, <3.494204, -2.402701, -0.268369>, <3.506604, -2.400437, -0.270593>, 
      <3.459970, -2.384248, -0.289083>, <3.469921, -2.392140, -0.290669>, <3.489522, -2.399611, -0.287498>, <3.501921, -2.397346, -0.289722>, 
      <3.475691, -2.359238, -0.302375>, <3.485558, -2.366928, -0.304018>, <3.503199, -2.373158, -0.303925>, <3.513395, -2.379078, -0.299431>, 
      <3.492496, -2.337867, -0.304827>, <3.502363, -2.345557, -0.306470>, <3.515472, -2.357552, -0.305716>, <3.525668, -2.363471, -0.301222>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.557908, -2.335196, -0.278080>, <3.560312, -2.346289, -0.278865>, <3.559577, -2.363837, -0.279368>, <3.552572, -2.372744, -0.278346>, 
      <3.557908, -2.335196, -0.278080>, <3.555894, -2.343374, -0.296911>, <3.557004, -2.362138, -0.289879>, <3.549999, -2.371046, -0.288857>, 
      <3.557908, -2.335196, -0.278080>, <3.555894, -2.343374, -0.296911>, <3.546097, -2.353887, -0.299010>, <3.534520, -2.368610, -0.297320>, 
      <3.557908, -2.335196, -0.278080>, <3.553490, -2.332280, -0.296126>, <3.537246, -2.348748, -0.302912>, <3.525668, -2.363471, -0.301222>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.557908, -2.335196, -0.278080>, <3.555237, -2.322868, -0.277208>, <3.546588, -2.306777, -0.274726>, <3.536627, -2.299152, -0.273140>, 
      <3.553490, -2.332280, -0.296126>, <3.550819, -2.319952, -0.295254>, <3.540542, -2.302783, -0.299432>, <3.530581, -2.295158, -0.297846>, 
      <3.537246, -2.348748, -0.302912>, <3.527050, -2.342829, -0.307406>, <3.518214, -2.325400, -0.308783>, <3.508346, -2.317710, -0.307140>, 
      <3.525668, -2.363471, -0.301222>, <3.515472, -2.357552, -0.305716>, <3.502363, -2.345557, -0.306470>, <3.492496, -2.337867, -0.304827>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.557908, -2.335196, -0.278080>, <3.553490, -2.332280, -0.296126>, <3.537246, -2.348748, -0.302912>, <3.525668, -2.363471, -0.301222>, 
      <3.560312, -2.346289, -0.278865>, <3.555894, -2.343374, -0.296911>, <3.524973, -2.364355, -0.301121>, <3.513395, -2.379078, -0.299431>, 
      <3.559577, -2.363837, -0.279368>, <3.549562, -2.376571, -0.277907>, <3.517680, -2.394469, -0.292548>, <3.501921, -2.397346, -0.289722>, 
      <3.552572, -2.372744, -0.278346>, <3.542558, -2.385479, -0.276885>, <3.522363, -2.397559, -0.273419>, <3.506604, -2.400437, -0.270593>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.538830, -2.372159, -0.247455>, <3.531400, -2.368100, -0.239126>, <3.519817, -2.357015, -0.232617>, <3.510514, -2.349769, -0.231203>, 
      <3.551103, -2.356552, -0.249246>, <3.543673, -2.352493, -0.240917>, <3.536622, -2.335644, -0.235069>, <3.527320, -2.328398, -0.233655>, 
      <3.562591, -2.338287, -0.258951>, <3.559920, -2.325959, -0.258079>, <3.552999, -2.311011, -0.248532>, <3.543038, -2.303386, -0.246946>, 
      <3.557908, -2.335196, -0.278080>, <3.555237, -2.322868, -0.277208>, <3.546588, -2.306777, -0.274726>, <3.536627, -2.299152, -0.273140>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.538830, -2.372159, -0.247455>, <3.545177, -2.375626, -0.254569>, <3.554955, -2.374317, -0.268612>, <3.552572, -2.372744, -0.278346>, 
      <3.538830, -2.372159, -0.247455>, <3.557450, -2.360019, -0.256360>, <3.561960, -2.365409, -0.269634>, <3.559577, -2.363837, -0.279368>, 
      <3.538830, -2.372159, -0.247455>, <3.557450, -2.360019, -0.256360>, <3.564994, -2.349380, -0.259736>, <3.560312, -2.346289, -0.278865>, 
      <3.538830, -2.372159, -0.247455>, <3.551103, -2.356552, -0.249246>, <3.562591, -2.338287, -0.258951>, <3.557908, -2.335196, -0.278080>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.538830, -2.372159, -0.247455>, <3.545177, -2.375626, -0.254569>, <3.554955, -2.374317, -0.268612>, <3.552572, -2.372744, -0.278346>, 
      <3.551103, -2.356552, -0.249246>, <3.557450, -2.360019, -0.256360>, <3.552382, -2.372618, -0.279123>, <3.549999, -2.371046, -0.288857>, 
      <3.562591, -2.338287, -0.258951>, <3.558173, -2.335371, -0.276997>, <3.546097, -2.353887, -0.299010>, <3.534520, -2.368610, -0.297320>, 
      <3.557908, -2.335196, -0.278080>, <3.553490, -2.332280, -0.296126>, <3.537246, -2.348748, -0.302912>, <3.525668, -2.363471, -0.301222>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.538830, -2.372159, -0.247455>, <3.551103, -2.356552, -0.249246>, <3.562591, -2.338287, -0.258951>, <3.557908, -2.335196, -0.278080>, 
      <3.527254, -2.386879, -0.245766>, <3.539528, -2.371272, -0.247557>, <3.564994, -2.349380, -0.259736>, <3.560312, -2.346289, -0.278865>, 
      <3.511021, -2.403352, -0.252551>, <3.526780, -2.400475, -0.255377>, <3.549562, -2.376571, -0.277907>, <3.559577, -2.363837, -0.279368>, 
      <3.506604, -2.400437, -0.270593>, <3.522363, -2.397559, -0.273419>, <3.542558, -2.385479, -0.276885>, <3.552572, -2.372744, -0.278346>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.538830, -2.372159, -0.247455>, <3.545177, -2.375626, -0.254569>, <3.554955, -2.374317, -0.268612>, <3.552572, -2.372744, -0.278346>, 
      <3.538830, -2.372159, -0.247455>, <3.533601, -2.390346, -0.252880>, <3.544940, -2.387052, -0.267150>, <3.542558, -2.385479, -0.276885>, 
      <3.538830, -2.372159, -0.247455>, <3.533601, -2.390346, -0.252880>, <3.526780, -2.400475, -0.255377>, <3.522363, -2.397559, -0.273419>, 
      <3.538830, -2.372159, -0.247455>, <3.527254, -2.386879, -0.245766>, <3.511021, -2.403352, -0.252551>, <3.506604, -2.400437, -0.270593>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.538830, -2.372159, -0.247455>, <3.531400, -2.368100, -0.239126>, <3.519817, -2.357015, -0.232617>, <3.510514, -2.349769, -0.231203>, 
      <3.527254, -2.386879, -0.245766>, <3.519824, -2.382820, -0.237437>, <3.503966, -2.377172, -0.230304>, <3.494663, -2.369926, -0.228890>, 
      <3.511021, -2.403352, -0.252551>, <3.498621, -2.405617, -0.250327>, <3.482378, -2.400368, -0.239769>, <3.472426, -2.392477, -0.238183>, 
      <3.506604, -2.400437, -0.270593>, <3.494204, -2.402701, -0.268369>, <3.476332, -2.396374, -0.264475>, <3.466380, -2.388483, -0.262889>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.538830, -2.372159, -0.247455>, <3.527254, -2.386879, -0.245766>, <3.511021, -2.403352, -0.252551>, <3.506604, -2.400437, -0.270593>, 
      <3.545177, -2.375626, -0.254569>, <3.533601, -2.390346, -0.252880>, <3.506338, -2.400262, -0.271680>, <3.501921, -2.397346, -0.289722>, 
      <3.554955, -2.374317, -0.268612>, <3.552382, -2.372618, -0.279123>, <3.522246, -2.384217, -0.295529>, <3.513395, -2.379078, -0.299431>, 
      <3.552572, -2.372744, -0.278346>, <3.549999, -2.371046, -0.288857>, <3.534520, -2.368610, -0.297320>, <3.525668, -2.363471, -0.301222>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.493094, -2.285581, -0.267763>, <3.488750, -2.282714, -0.285505>, <3.472776, -2.298901, -0.292178>, <3.461393, -2.313377, -0.290517>, 
      <3.503981, -2.293917, -0.269081>, <3.499637, -2.291049, -0.286823>, <3.482690, -2.306617, -0.293471>, <3.471306, -2.321092, -0.291810>, 
      <3.525776, -2.290845, -0.271413>, <3.519729, -2.286851, -0.296119>, <3.498471, -2.310013, -0.305495>, <3.482620, -2.330170, -0.303182>, 
      <3.536627, -2.299152, -0.273140>, <3.530581, -2.295158, -0.297846>, <3.508346, -2.317710, -0.307140>, <3.492496, -2.337867, -0.304827>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.474335, -2.321921, -0.237652>, <3.486402, -2.306576, -0.239413>, <3.497698, -2.288621, -0.248956>, <3.493094, -2.285581, -0.267763>, 
      <3.485212, -2.330380, -0.238869>, <3.497278, -2.315036, -0.240629>, <3.508585, -2.296957, -0.250273>, <3.503981, -2.293917, -0.269081>, 
      <3.499679, -2.341329, -0.229556>, <3.516484, -2.319958, -0.232009>, <3.532186, -2.295079, -0.245219>, <3.525776, -2.290845, -0.271413>, 
      <3.510514, -2.349769, -0.231203>, <3.527320, -2.328398, -0.233655>, <3.543038, -2.303386, -0.246946>, <3.536627, -2.299152, -0.273140>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.442652, -2.349724, -0.260403>, <3.446994, -2.352591, -0.242664>, <3.462954, -2.336394, -0.235991>, <3.474335, -2.321921, -0.237652>, 
      <3.453316, -2.358154, -0.261691>, <3.457658, -2.361021, -0.243952>, <3.473830, -2.344853, -0.237208>, <3.485212, -2.330380, -0.238869>, 
      <3.455764, -2.380065, -0.261198>, <3.461810, -2.384059, -0.236491>, <3.483828, -2.361486, -0.227243>, <3.499679, -2.341329, -0.229556>, 
      <3.466380, -2.388483, -0.262889>, <3.472426, -2.392477, -0.238183>, <3.494663, -2.369926, -0.228890>, <3.510514, -2.349769, -0.231203>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.442652, -2.349724, -0.260403>, <3.453316, -2.358154, -0.261691>, <3.455764, -2.380065, -0.261198>, <3.466380, -2.388483, -0.262889>, 
      <3.438048, -2.346684, -0.279211>, <3.448711, -2.355114, -0.280498>, <3.449354, -2.375830, -0.287392>, <3.459970, -2.384248, -0.289083>, 
      <3.449326, -2.328722, -0.288756>, <3.459240, -2.336437, -0.290050>, <3.465815, -2.351541, -0.300730>, <3.475691, -2.359238, -0.302375>, 
      <3.461393, -2.313377, -0.290517>, <3.471306, -2.321092, -0.291810>, <3.482620, -2.330170, -0.303182>, <3.492496, -2.337867, -0.304827>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.277324, -2.100613, -0.241753>, <3.275931, -2.100212, -0.265998>, <3.256687, -2.123694, -0.274299>, <3.241734, -2.142709, -0.272116>, 
      <3.344037, -2.154274, -0.242006>, <3.342644, -2.153873, -0.266251>, <3.322812, -2.174864, -0.272400>, <3.307859, -2.193879, -0.270217>, 
      <3.425427, -2.233771, -0.259572>, <3.421084, -2.230904, -0.277315>, <3.407123, -2.247806, -0.283614>, <3.395740, -2.262281, -0.281953>, 
      <3.493094, -2.285581, -0.267763>, <3.488750, -2.282714, -0.285505>, <3.472776, -2.298901, -0.292178>, <3.461393, -2.313377, -0.290517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.277324, -2.100613, -0.241753>, <3.206915, -2.043979, -0.241486>, <3.114232, -1.967314, -0.258885>, <3.037920, -1.919457, -0.266038>, 
      <3.275931, -2.100212, -0.265998>, <3.205522, -2.043578, -0.265731>, <3.112800, -1.966903, -0.283807>, <3.036488, -1.919046, -0.290961>, 
      <3.256687, -2.123694, -0.274299>, <3.184509, -2.067840, -0.276372>, <3.088756, -1.992258, -0.300988>, <3.012785, -1.941801, -0.305012>, 
      <3.241734, -2.142709, -0.272116>, <3.169556, -2.086855, -0.274189>, <3.078019, -2.008373, -0.299686>, <3.002048, -1.957916, -0.303710>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.245786, -2.143876, -0.201591>, <3.174091, -2.088266, -0.198998>, <3.081226, -2.010240, -0.210454>, <3.006814, -1.959285, -0.220743>, 
      <3.261688, -2.123654, -0.203912>, <3.189993, -2.068044, -0.201319>, <3.092489, -1.993335, -0.211820>, <3.018077, -1.942380, -0.222109>, 
      <3.278805, -2.101040, -0.215969>, <3.208396, -2.044406, -0.215702>, <3.115733, -1.967745, -0.232740>, <3.039422, -1.919888, -0.239893>, 
      <3.277324, -2.100613, -0.241753>, <3.206915, -2.043979, -0.241486>, <3.114232, -1.967314, -0.258885>, <3.037920, -1.919457, -0.266038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.245786, -2.143876, -0.201591>, <3.261688, -2.123654, -0.203912>, <3.278805, -2.101040, -0.215969>, <3.277324, -2.100613, -0.241753>, 
      <3.314964, -2.197535, -0.204093>, <3.330866, -2.177313, -0.206414>, <3.345518, -2.154701, -0.216222>, <3.344037, -2.154274, -0.242006>, 
      <3.405466, -2.268358, -0.229949>, <3.417533, -2.253014, -0.231709>, <3.430031, -2.236811, -0.240765>, <3.425427, -2.233771, -0.259572>, 
      <3.474335, -2.321921, -0.237652>, <3.486402, -2.306576, -0.239413>, <3.497698, -2.288621, -0.248956>, <3.493094, -2.285581, -0.267763>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.210202, -2.185969, -0.231955>, <3.139323, -2.134001, -0.231709>, <2.981407, -1.994899, -0.260943>, <2.978153, -2.009160, -0.258790>, 
      <3.211595, -2.186370, -0.207712>, <3.140716, -2.134403, -0.207466>, <2.981607, -1.994956, -0.257468>, <2.978353, -2.009217, -0.255315>, 
      <3.230834, -2.162890, -0.199408>, <3.159140, -2.107279, -0.196816>, <3.069779, -2.027419, -0.209066>, <2.995368, -1.976465, -0.219355>, 
      <3.245786, -2.143876, -0.201591>, <3.174091, -2.088266, -0.198998>, <3.081226, -2.010240, -0.210454>, <3.006814, -1.959285, -0.220743>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.210202, -2.185969, -0.231955>, <3.211595, -2.186370, -0.207712>, <3.230834, -2.162890, -0.199408>, <3.245786, -2.143876, -0.201591>, 
      <3.279338, -2.236659, -0.232195>, <3.280730, -2.237060, -0.207952>, <3.300013, -2.216548, -0.201910>, <3.314964, -2.197535, -0.204093>, 
      <3.375700, -2.296797, -0.252318>, <3.380042, -2.299664, -0.234580>, <3.394085, -2.282831, -0.228288>, <3.405466, -2.268358, -0.229949>, 
      <3.442652, -2.349724, -0.260403>, <3.446994, -2.352591, -0.242664>, <3.462954, -2.336394, -0.235991>, <3.474335, -2.321921, -0.237652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.210202, -2.185969, -0.231955>, <3.279338, -2.236659, -0.232195>, <3.375700, -2.296797, -0.252318>, <3.442652, -2.349724, -0.260403>, 
      <3.208721, -2.185543, -0.257737>, <3.277856, -2.236232, -0.257977>, <3.371096, -2.293757, -0.271126>, <3.438048, -2.346684, -0.279211>, 
      <3.225833, -2.162929, -0.269795>, <3.291958, -2.214099, -0.267896>, <3.383673, -2.277626, -0.280192>, <3.449326, -2.328722, -0.288756>, 
      <3.241734, -2.142709, -0.272116>, <3.307859, -2.193879, -0.270217>, <3.395740, -2.262281, -0.281953>, <3.461393, -2.313377, -0.290517>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.210202, -2.185969, -0.231955>, <3.208721, -2.185543, -0.257737>, <3.225833, -2.162929, -0.269795>, <3.241734, -2.142709, -0.272116>, 
      <3.139323, -2.134001, -0.231709>, <3.137841, -2.133575, -0.257491>, <3.153656, -2.107075, -0.271868>, <3.169556, -2.086855, -0.274189>, 
      <2.981407, -1.994899, -0.260943>, <2.981198, -1.994838, -0.264581>, <3.066034, -2.026361, -0.298232>, <3.078019, -2.008373, -0.299686>, 
      <2.978153, -2.009160, -0.258790>, <2.977944, -2.009100, -0.262428>, <2.990063, -1.975904, -0.302257>, <3.002048, -1.957916, -0.303710>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.352987, -2.777878, -0.270309>, <3.331818, -2.791087, -0.268534>, <3.309986, -2.808106, -0.256213>, <3.314380, -2.813281, -0.232137>, 
      <3.352987, -2.777878, -0.270309>, <3.340256, -2.801003, -0.263152>, <3.330123, -2.811481, -0.259143>, <3.334517, -2.816656, -0.235067>, 
      <3.352987, -2.777878, -0.270309>, <3.340256, -2.801003, -0.263152>, <3.361432, -2.807942, -0.252195>, <3.363907, -2.810857, -0.238635>, 
      <3.352987, -2.777878, -0.270309>, <3.361425, -2.787795, -0.264927>, <3.378887, -2.797050, -0.253659>, <3.381362, -2.799965, -0.240098>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.271597, -2.781568, -0.224126>, <3.280004, -2.795277, -0.225679>, <3.298608, -2.810637, -0.229842>, <3.314380, -2.813281, -0.232137>, 
      <3.265579, -2.774483, -0.257093>, <3.273986, -2.788192, -0.258646>, <3.294214, -2.805462, -0.253918>, <3.309986, -2.808106, -0.256213>, 
      <3.295469, -2.751173, -0.273968>, <3.303922, -2.764702, -0.275610>, <3.322214, -2.779799, -0.274661>, <3.331818, -2.791087, -0.268534>, 
      <3.324455, -2.733086, -0.276397>, <3.332908, -2.746615, -0.278039>, <3.343383, -2.766591, -0.276435>, <3.352987, -2.777878, -0.270309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.404154, -2.757264, -0.239663>, <3.402167, -2.771623, -0.240519>, <3.393651, -2.792297, -0.241128>, <3.381362, -2.799965, -0.240098>, 
      <3.404154, -2.757264, -0.239663>, <3.397890, -2.766585, -0.263960>, <3.391176, -2.789382, -0.254689>, <3.378887, -2.797050, -0.253659>, 
      <3.404154, -2.757264, -0.239663>, <3.397890, -2.766585, -0.263960>, <3.382035, -2.774935, -0.266654>, <3.361425, -2.787795, -0.264927>, 
      <3.404154, -2.757264, -0.239663>, <3.399876, -2.752225, -0.263103>, <3.373597, -2.765018, -0.272037>, <3.352987, -2.777878, -0.270309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.404154, -2.757264, -0.239663>, <3.406352, -2.741383, -0.238716>, <3.403109, -2.718344, -0.235992>, <3.394521, -2.704863, -0.234428>, 
      <3.399876, -2.752225, -0.263103>, <3.402074, -2.736344, -0.262157>, <3.397250, -2.711446, -0.268090>, <3.388662, -2.697965, -0.266526>, 
      <3.373597, -2.765018, -0.272037>, <3.363993, -2.753731, -0.278163>, <3.361130, -2.729004, -0.280404>, <3.352677, -2.715475, -0.278762>, 
      <3.352987, -2.777878, -0.270309>, <3.343383, -2.766591, -0.276435>, <3.332908, -2.746615, -0.278039>, <3.324455, -2.733086, -0.276397>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.404154, -2.757264, -0.239663>, <3.399876, -2.752225, -0.263103>, <3.373597, -2.765018, -0.272037>, <3.352987, -2.777878, -0.270309>, 
      <3.402167, -2.771623, -0.240519>, <3.397890, -2.766585, -0.263960>, <3.352428, -2.778226, -0.270262>, <3.331818, -2.791087, -0.268534>, 
      <3.393651, -2.792297, -0.241128>, <3.376196, -2.803189, -0.239665>, <3.330123, -2.811481, -0.259143>, <3.309986, -2.808106, -0.256213>, 
      <3.381362, -2.799965, -0.240098>, <3.363907, -2.810857, -0.238635>, <3.334517, -2.816656, -0.235067>, <3.314380, -2.813281, -0.232137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.365546, -2.792671, -0.201489>, <3.358494, -2.784389, -0.191198>, <3.349563, -2.765982, -0.183523>, <3.341657, -2.753339, -0.182159>, 
      <3.386716, -2.779461, -0.203264>, <3.379664, -2.771180, -0.192973>, <3.378549, -2.747895, -0.185952>, <3.370642, -2.735252, -0.184588>, 
      <3.408548, -2.762439, -0.215586>, <3.410745, -2.746558, -0.214639>, <3.409127, -2.725429, -0.203025>, <3.400539, -2.711948, -0.201461>, 
      <3.404154, -2.757264, -0.239663>, <3.406352, -2.741383, -0.238716>, <3.403109, -2.718344, -0.235992>, <3.394521, -2.704863, -0.234428>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.365546, -2.792671, -0.201489>, <3.371530, -2.799699, -0.210222>, <3.383594, -2.802594, -0.227868>, <3.381362, -2.799965, -0.240098>, 
      <3.365546, -2.792671, -0.201489>, <3.392700, -2.786489, -0.211996>, <3.395883, -2.794926, -0.228898>, <3.393651, -2.792297, -0.241128>, 
      <3.365546, -2.792671, -0.201489>, <3.392700, -2.786489, -0.211996>, <3.406561, -2.776799, -0.216442>, <3.402167, -2.771623, -0.240519>, 
      <3.365546, -2.792671, -0.201489>, <3.386716, -2.779461, -0.203264>, <3.408548, -2.762439, -0.215586>, <3.404154, -2.757264, -0.239663>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.365546, -2.792671, -0.201489>, <3.371530, -2.799699, -0.210222>, <3.383594, -2.802594, -0.227868>, <3.381362, -2.799965, -0.240098>, 
      <3.386716, -2.779461, -0.203264>, <3.392700, -2.786489, -0.211996>, <3.381119, -2.799679, -0.241429>, <3.378887, -2.797050, -0.253659>, 
      <3.408548, -2.762439, -0.215586>, <3.404270, -2.757401, -0.239026>, <3.382035, -2.774935, -0.266654>, <3.361425, -2.787795, -0.264927>, 
      <3.404154, -2.757264, -0.239663>, <3.399876, -2.752225, -0.263103>, <3.373597, -2.765018, -0.272037>, <3.352987, -2.777878, -0.270309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.365546, -2.792671, -0.201489>, <3.386716, -2.779461, -0.203264>, <3.408548, -2.762439, -0.215586>, <3.404154, -2.757264, -0.239663>, 
      <3.344936, -2.805531, -0.199761>, <3.366106, -2.792321, -0.201536>, <3.406561, -2.776799, -0.216442>, <3.402167, -2.771623, -0.240519>, 
      <3.318657, -2.818320, -0.208697>, <3.338794, -2.821694, -0.211627>, <3.376196, -2.803189, -0.239665>, <3.393651, -2.792297, -0.241128>, 
      <3.314380, -2.813281, -0.232137>, <3.334517, -2.816656, -0.235067>, <3.363907, -2.810857, -0.238635>, <3.381362, -2.799965, -0.240098>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.365546, -2.792671, -0.201489>, <3.371530, -2.799699, -0.210222>, <3.383594, -2.802594, -0.227868>, <3.381362, -2.799965, -0.240098>, 
      <3.365546, -2.792671, -0.201489>, <3.350921, -2.812558, -0.208494>, <3.366138, -2.813485, -0.226405>, <3.363907, -2.810857, -0.238635>, 
      <3.365546, -2.792671, -0.201489>, <3.350921, -2.812558, -0.208494>, <3.338794, -2.821694, -0.211627>, <3.334517, -2.816656, -0.235067>, 
      <3.365546, -2.792671, -0.201489>, <3.344936, -2.805531, -0.199761>, <3.318657, -2.818320, -0.208697>, <3.314380, -2.813281, -0.232137>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.365546, -2.792671, -0.201489>, <3.358494, -2.784389, -0.191198>, <3.349563, -2.765982, -0.183523>, <3.341657, -2.753339, -0.182159>, 
      <3.344936, -2.805531, -0.199761>, <3.337884, -2.797249, -0.189470>, <3.321342, -2.783592, -0.181158>, <3.313436, -2.770949, -0.179794>, 
      <3.318657, -2.818320, -0.208697>, <3.302885, -2.815676, -0.206402>, <3.285863, -2.802175, -0.193582>, <3.277456, -2.788466, -0.192029>, 
      <3.314380, -2.813281, -0.232137>, <3.298608, -2.810637, -0.229842>, <3.280004, -2.795277, -0.225679>, <3.271597, -2.781568, -0.224126>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.365546, -2.792671, -0.201489>, <3.344936, -2.805531, -0.199761>, <3.318657, -2.818320, -0.208697>, <3.314380, -2.813281, -0.232137>, 
      <3.371530, -2.799699, -0.210222>, <3.350921, -2.812558, -0.208494>, <3.314264, -2.813144, -0.232773>, <3.309986, -2.808106, -0.256213>, 
      <3.383594, -2.802594, -0.227868>, <3.381119, -2.799679, -0.241429>, <3.340256, -2.801003, -0.263152>, <3.331818, -2.791087, -0.268534>, 
      <3.381362, -2.799965, -0.240098>, <3.378887, -2.797050, -0.253659>, <3.361425, -2.787795, -0.264927>, <3.352987, -2.777878, -0.270309>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.348450, -2.669826, -0.229521>, <3.344243, -2.664874, -0.252568>, <3.318406, -2.677449, -0.261352>, <3.298142, -2.690095, -0.259654>, 
      <3.357798, -2.684486, -0.230696>, <3.353591, -2.679534, -0.253744>, <3.326840, -2.690916, -0.262537>, <3.306576, -2.703561, -0.260839>, 
      <3.385202, -2.690236, -0.232731>, <3.379343, -2.683337, -0.264830>, <3.344279, -2.702033, -0.277131>, <3.316057, -2.719644, -0.274765>, 
      <3.394521, -2.704863, -0.234428>, <3.388662, -2.697965, -0.266526>, <3.352677, -2.715475, -0.278762>, <3.324455, -2.733086, -0.276397>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.310492, -2.704635, -0.191990>, <3.331305, -2.691647, -0.193734>, <3.352771, -2.674913, -0.205849>, <3.348450, -2.669826, -0.229521>, 
      <3.319824, -2.719515, -0.193042>, <3.340636, -2.706527, -0.194787>, <3.362118, -2.689573, -0.207025>, <3.357798, -2.684486, -0.230696>, 
      <3.332366, -2.738482, -0.180556>, <3.361352, -2.720396, -0.182985>, <3.391220, -2.697320, -0.199765>, <3.385202, -2.690236, -0.232731>, 
      <3.341657, -2.753339, -0.182159>, <3.370642, -2.735252, -0.184588>, <3.400539, -2.711948, -0.201461>, <3.394521, -2.704863, -0.234428>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.260185, -2.724907, -0.222124>, <3.264392, -2.729860, -0.199076>, <3.290228, -2.717280, -0.190292>, <3.310492, -2.704635, -0.191990>, 
      <3.269265, -2.739647, -0.223275>, <3.273471, -2.744599, -0.200227>, <3.299560, -2.732160, -0.191344>, <3.319824, -2.719515, -0.193042>, 
      <3.262569, -2.766846, -0.222458>, <3.268428, -2.773744, -0.190361>, <3.304146, -2.756092, -0.178191>, <3.332366, -2.738482, -0.180556>, 
      <3.271597, -2.781568, -0.224126>, <3.277456, -2.788466, -0.192029>, <3.313436, -2.770949, -0.179794>, <3.341657, -2.753339, -0.182159>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.260185, -2.724907, -0.222124>, <3.269265, -2.739647, -0.223275>, <3.262569, -2.766846, -0.222458>, <3.271597, -2.781568, -0.224126>, 
      <3.255864, -2.719820, -0.245796>, <3.264944, -2.734560, -0.246947>, <3.256551, -2.759761, -0.255425>, <3.265579, -2.774483, -0.257093>, 
      <3.277329, -2.703083, -0.257910>, <3.285764, -2.716549, -0.259095>, <3.287071, -2.737731, -0.272336>, <3.295469, -2.751173, -0.273968>, 
      <3.298142, -2.690095, -0.259654>, <3.306576, -2.703561, -0.260839>, <3.316057, -2.719644, -0.274765>, <3.324455, -2.733086, -0.276397>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.171582, -2.355228, -0.206403>, <3.169778, -2.354710, -0.237798>, <3.136891, -2.374533, -0.248544>, <3.110277, -2.391142, -0.246313>, 
      <3.224588, -2.449799, -0.202213>, <3.222784, -2.449281, -0.233608>, <3.193533, -2.463967, -0.243130>, <3.166919, -2.480576, -0.240900>, 
      <3.290252, -2.578555, -0.222205>, <3.286046, -2.573602, -0.245253>, <3.262294, -2.587865, -0.253471>, <3.242030, -2.600511, -0.251772>, 
      <3.348450, -2.669826, -0.229521>, <3.344243, -2.664874, -0.252568>, <3.318406, -2.677449, -0.261352>, <3.298142, -2.690095, -0.259654>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.171582, -2.355228, -0.206403>, <3.112968, -2.250653, -0.211036>, <2.973711, -2.028627, -0.255851>, <2.978153, -2.009160, -0.258790>, 
      <3.169778, -2.354710, -0.237798>, <3.111164, -2.250134, -0.242431>, <2.973415, -2.028543, -0.260994>, <2.977857, -2.009075, -0.263933>, 
      <3.136891, -2.374533, -0.248544>, <3.074878, -2.276618, -0.254470>, <2.990814, -2.142169, -0.286907>, <2.926076, -2.046822, -0.300540>, 
      <3.110277, -2.391142, -0.246313>, <3.048264, -2.293227, -0.252239>, <2.968791, -2.163202, -0.283683>, <2.904053, -2.067855, -0.297316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.115430, -2.392622, -0.156647>, <3.053932, -2.295081, -0.156622>, <2.974489, -2.164458, -0.179427>, <2.910115, -2.069598, -0.191827>, 
      <3.142807, -2.375537, -0.158941>, <3.081309, -2.277996, -0.158916>, <2.998866, -2.141178, -0.182996>, <2.934491, -2.046317, -0.195396>, 
      <3.173438, -2.355761, -0.174109>, <3.114825, -2.251186, -0.178742>, <2.974038, -2.028721, -0.250159>, <2.978480, -2.009254, -0.253098>, 
      <3.171582, -2.355228, -0.206403>, <3.112968, -2.250653, -0.211036>, <2.973711, -2.028627, -0.255851>, <2.978153, -2.009160, -0.258790>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.115430, -2.392622, -0.156647>, <3.142807, -2.375537, -0.158941>, <3.173438, -2.355761, -0.174109>, <3.171582, -2.355228, -0.206403>, 
      <3.174576, -2.486432, -0.156671>, <3.201952, -2.469347, -0.158966>, <3.226444, -2.450332, -0.169919>, <3.224588, -2.449799, -0.202213>, 
      <3.251676, -2.610852, -0.185357>, <3.272488, -2.597865, -0.187101>, <3.294573, -2.583641, -0.198534>, <3.290252, -2.578555, -0.222205>, 
      <3.310492, -2.704635, -0.191990>, <3.331305, -2.691647, -0.193734>, <3.352771, -2.674913, -0.205849>, <3.348450, -2.669826, -0.229521>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.054122, -2.428530, -0.196559>, <2.993277, -2.337495, -0.199454>, <2.876536, -2.120950, -0.241463>, <2.858305, -2.123621, -0.241244>, 
      <3.055926, -2.429048, -0.165164>, <2.995081, -2.338013, -0.168059>, <2.876796, -2.121024, -0.236945>, <2.858565, -2.123696, -0.236725>, 
      <3.088815, -2.409231, -0.154417>, <3.027318, -2.311690, -0.154391>, <2.955138, -2.182939, -0.176594>, <2.890764, -2.088079, -0.188994>, 
      <3.115430, -2.392622, -0.156647>, <3.053932, -2.295081, -0.156622>, <2.974489, -2.164458, -0.179427>, <2.910115, -2.069598, -0.191827>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.054122, -2.428530, -0.196559>, <3.055926, -2.429048, -0.165164>, <3.088815, -2.409231, -0.154417>, <3.115430, -2.392622, -0.156647>, 
      <3.114427, -2.518758, -0.193690>, <3.116231, -2.519276, -0.162295>, <3.147961, -2.503041, -0.154441>, <3.174576, -2.486432, -0.156671>, 
      <3.203371, -2.632678, -0.214922>, <3.207578, -2.637630, -0.191875>, <3.231412, -2.623498, -0.183659>, <3.251676, -2.610852, -0.185357>, 
      <3.260185, -2.724907, -0.222124>, <3.264392, -2.729860, -0.199076>, <3.290228, -2.717280, -0.190292>, <3.310492, -2.704635, -0.191990>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.054122, -2.428530, -0.196559>, <3.114427, -2.518758, -0.193690>, <3.203371, -2.632678, -0.214922>, <3.260185, -2.724907, -0.222124>, 
      <3.052266, -2.427997, -0.228853>, <3.112571, -2.518224, -0.225984>, <3.199050, -2.627591, -0.238594>, <3.255864, -2.719820, -0.245796>, 
      <3.082901, -2.408226, -0.244019>, <3.139542, -2.497660, -0.238606>, <3.221218, -2.613498, -0.250028>, <3.277329, -2.703083, -0.257910>, 
      <3.110277, -2.391142, -0.246313>, <3.166919, -2.480576, -0.240900>, <3.242030, -2.600511, -0.251772>, <3.298142, -2.690095, -0.259654>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.054122, -2.428530, -0.196559>, <3.052266, -2.427997, -0.228853>, <3.082901, -2.408226, -0.244019>, <3.110277, -2.391142, -0.246313>, 
      <2.993277, -2.337495, -0.199454>, <2.991421, -2.336962, -0.231748>, <3.020887, -2.310312, -0.249945>, <3.048264, -2.293227, -0.252239>, 
      <2.876536, -2.120950, -0.241463>, <2.876272, -2.120873, -0.246066>, <2.949080, -2.182027, -0.280797>, <2.968791, -2.163202, -0.283683>, 
      <2.858305, -2.123621, -0.241244>, <2.858041, -2.123545, -0.245847>, <2.884342, -2.086680, -0.294430>, <2.904053, -2.067855, -0.297316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.003860, -2.861854, -0.248766>, <2.982520, -2.869418, -0.247530>, <2.959453, -2.880362, -0.236381>, <2.962422, -2.885535, -0.214505>, 
      <3.003860, -2.861854, -0.248766>, <2.988118, -2.879928, -0.242399>, <2.976792, -2.887384, -0.238664>, <2.979760, -2.892557, -0.216789>, 
      <3.003860, -2.861854, -0.248766>, <2.988118, -2.879928, -0.242399>, <3.005503, -2.890202, -0.232004>, <3.007200, -2.893160, -0.219494>, 
      <3.003860, -2.861854, -0.248766>, <3.009458, -2.872364, -0.243635>, <3.023239, -2.883916, -0.233031>, <3.024937, -2.886874, -0.220522>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.930572, -2.848655, -0.208094>, <2.935321, -2.862561, -0.209311>, <2.948856, -2.880041, -0.212718>, <2.962422, -2.885535, -0.214505>, 
      <2.926508, -2.841570, -0.238049>, <2.931257, -2.855476, -0.239266>, <2.945888, -2.874868, -0.234594>, <2.959453, -2.880362, -0.236381>, 
      <2.958087, -2.826581, -0.253320>, <2.962927, -2.840382, -0.254621>, <2.976182, -2.857517, -0.253340>, <2.982520, -2.869418, -0.247530>, 
      <2.987308, -2.816223, -0.255014>, <2.992148, -2.830023, -0.256315>, <2.997521, -2.849953, -0.254576>, <3.003860, -2.861854, -0.248766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.053876, -2.853121, -0.219804>, <3.049215, -2.865596, -0.220584>, <3.037492, -2.882424, -0.221249>, <3.024937, -2.886874, -0.220522>, 
      <3.053876, -2.853121, -0.219804>, <3.046262, -2.860449, -0.242349>, <3.035794, -2.879466, -0.233759>, <3.023239, -2.883916, -0.233031>, 
      <3.053876, -2.853121, -0.219804>, <3.046262, -2.860449, -0.242349>, <3.030689, -2.864839, -0.244865>, <3.009458, -2.872364, -0.243635>, 
      <3.053876, -2.853121, -0.219804>, <3.050923, -2.847974, -0.241568>, <3.025091, -2.854329, -0.249996>, <3.003860, -2.861854, -0.248766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.053876, -2.853121, -0.219804>, <3.059022, -2.839347, -0.218942>, <3.060779, -2.818072, -0.216583>, <3.055799, -2.804265, -0.215354>, 
      <3.050923, -2.847974, -0.241568>, <3.056068, -2.834201, -0.240707>, <3.056735, -2.811023, -0.246386>, <3.051756, -2.797216, -0.245158>, 
      <3.025091, -2.854329, -0.249996>, <3.018753, -2.842428, -0.255806>, <3.021222, -2.819718, -0.258000>, <3.016381, -2.805917, -0.256700>, 
      <3.003860, -2.861854, -0.248766>, <2.997521, -2.849953, -0.254576>, <2.992148, -2.830023, -0.256315>, <2.987308, -2.816223, -0.255014>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.053876, -2.853121, -0.219804>, <3.050923, -2.847974, -0.241568>, <3.025091, -2.854329, -0.249996>, <3.003860, -2.861854, -0.248766>, 
      <3.049215, -2.865596, -0.220584>, <3.046262, -2.860449, -0.242349>, <3.003751, -2.861893, -0.248760>, <2.982520, -2.869418, -0.247530>, 
      <3.037492, -2.882424, -0.221249>, <3.019755, -2.888710, -0.220222>, <2.976792, -2.887384, -0.238664>, <2.959453, -2.880362, -0.236381>, 
      <3.024937, -2.886874, -0.220522>, <3.007200, -2.893160, -0.219494>, <2.979760, -2.892557, -0.216789>, <2.962422, -2.885535, -0.214505>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.012439, -2.876805, -0.185542>, <3.007828, -2.867868, -0.176264>, <3.003577, -2.849570, -0.169494>, <2.999054, -2.836700, -0.168436>, 
      <3.033779, -2.869241, -0.186778>, <3.029169, -2.860304, -0.177500>, <3.032800, -2.839211, -0.171188>, <3.028277, -2.826341, -0.170130>, 
      <3.056844, -2.858294, -0.197928>, <3.061990, -2.844521, -0.197066>, <3.064843, -2.825157, -0.186625>, <3.059863, -2.811351, -0.185396>, 
      <3.053876, -2.853121, -0.219804>, <3.059022, -2.839347, -0.218942>, <3.060779, -2.818072, -0.216583>, <3.055799, -2.804265, -0.215354>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.012439, -2.876805, -0.185542>, <3.016330, -2.884347, -0.193371>, <3.026448, -2.889508, -0.209383>, <3.024937, -2.886874, -0.220522>, 
      <3.012439, -2.876805, -0.185542>, <3.037670, -2.876783, -0.194607>, <3.039003, -2.885058, -0.210110>, <3.037492, -2.882424, -0.221249>, 
      <3.012439, -2.876805, -0.185542>, <3.037670, -2.876783, -0.194607>, <3.052184, -2.870769, -0.198708>, <3.049215, -2.865596, -0.220584>, 
      <3.012439, -2.876805, -0.185542>, <3.033779, -2.869241, -0.186778>, <3.056844, -2.858294, -0.197928>, <3.053876, -2.853121, -0.219804>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.012439, -2.876805, -0.185542>, <3.016330, -2.884347, -0.193371>, <3.026448, -2.889508, -0.209383>, <3.024937, -2.886874, -0.220522>, 
      <3.033779, -2.869241, -0.186778>, <3.037670, -2.876783, -0.194607>, <3.024751, -2.886550, -0.221892>, <3.023239, -2.883916, -0.233031>, 
      <3.056844, -2.858294, -0.197928>, <3.053891, -2.853148, -0.219692>, <3.030689, -2.864839, -0.244865>, <3.009458, -2.872364, -0.243635>, 
      <3.053876, -2.853121, -0.219804>, <3.050923, -2.847974, -0.241568>, <3.025091, -2.854329, -0.249996>, <3.003860, -2.861854, -0.248766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.012439, -2.876805, -0.185542>, <3.033779, -2.869241, -0.186778>, <3.056844, -2.858294, -0.197928>, <3.053876, -2.853121, -0.219804>, 
      <2.991207, -2.884330, -0.184312>, <3.012548, -2.876767, -0.185548>, <3.052184, -2.870769, -0.198708>, <3.049215, -2.865596, -0.220584>, 
      <2.965375, -2.890682, -0.192740>, <2.982714, -2.897704, -0.195024>, <3.019755, -2.888710, -0.220222>, <3.037492, -2.882424, -0.221249>, 
      <2.962422, -2.885535, -0.214505>, <2.979760, -2.892557, -0.216789>, <3.007200, -2.893160, -0.219494>, <3.024937, -2.886874, -0.220522>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.012439, -2.876805, -0.185542>, <3.016330, -2.884347, -0.193371>, <3.026448, -2.889508, -0.209383>, <3.024937, -2.886874, -0.220522>, 
      <3.012439, -2.876805, -0.185542>, <2.995098, -2.891872, -0.192141>, <3.008712, -2.895795, -0.208355>, <3.007200, -2.893160, -0.219494>, 
      <3.012439, -2.876805, -0.185542>, <2.995098, -2.891872, -0.192141>, <2.982714, -2.897704, -0.195024>, <2.979760, -2.892557, -0.216789>, 
      <3.012439, -2.876805, -0.185542>, <2.991207, -2.884330, -0.184312>, <2.965375, -2.890682, -0.192740>, <2.962422, -2.885535, -0.214505>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.012439, -2.876805, -0.185542>, <3.007828, -2.867868, -0.176264>, <3.003577, -2.849570, -0.169494>, <2.999054, -2.836700, -0.168436>, 
      <2.991207, -2.884330, -0.184312>, <2.986597, -2.875393, -0.175034>, <2.974507, -2.859875, -0.167808>, <2.969984, -2.847005, -0.166751>, 
      <2.965375, -2.890682, -0.192740>, <2.951809, -2.885188, -0.190954>, <2.939364, -2.869609, -0.179510>, <2.934615, -2.855703, -0.178294>, 
      <2.962422, -2.885535, -0.214505>, <2.948856, -2.880041, -0.212718>, <2.935321, -2.862561, -0.209311>, <2.930572, -2.848655, -0.208094>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.012439, -2.876805, -0.185542>, <2.991207, -2.884330, -0.184312>, <2.965375, -2.890682, -0.192740>, <2.962422, -2.885535, -0.214505>, 
      <3.016330, -2.884347, -0.193371>, <2.995098, -2.891872, -0.192141>, <2.962407, -2.885509, -0.214616>, <2.959453, -2.880362, -0.236381>, 
      <3.026448, -2.889508, -0.209383>, <3.024751, -2.886550, -0.221892>, <2.988118, -2.879928, -0.242399>, <2.982520, -2.869418, -0.247530>, 
      <3.024937, -2.886874, -0.220522>, <3.023239, -2.883916, -0.233031>, <3.009458, -2.872364, -0.243635>, <3.003860, -2.861854, -0.248766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.021661, -2.763799, -0.211856>, <3.018758, -2.758739, -0.233257>, <2.993356, -2.764988, -0.241543>, <2.972480, -2.772388, -0.240333>, 
      <3.027064, -2.778747, -0.212707>, <3.024161, -2.773687, -0.234108>, <2.998187, -2.778699, -0.242424>, <2.977310, -2.786100, -0.241214>, 
      <3.050418, -2.789344, -0.214026>, <3.046374, -2.782295, -0.243830>, <3.011580, -2.792228, -0.255409>, <2.982507, -2.802533, -0.253724>, 
      <3.055799, -2.804265, -0.215354>, <3.051756, -2.797216, -0.245158>, <3.016381, -2.805917, -0.256700>, <2.987308, -2.816223, -0.255014>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.980912, -2.787087, -0.178169>, <3.001896, -2.779649, -0.179385>, <3.024579, -2.768885, -0.190344>, <3.021661, -2.763799, -0.211856>, 
      <2.986271, -2.802266, -0.178909>, <3.007255, -2.794828, -0.180126>, <3.029982, -2.783834, -0.191195>, <3.027064, -2.778747, -0.212707>, 
      <2.993727, -2.821542, -0.167190>, <3.022951, -2.811183, -0.168885>, <3.054482, -2.796429, -0.184069>, <3.050418, -2.789344, -0.214026>, 
      <2.999054, -2.836700, -0.168436>, <3.028277, -2.826341, -0.170130>, <3.059863, -2.811351, -0.185396>, <3.055799, -2.804265, -0.215354>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.931735, -2.795676, -0.206644>, <2.934638, -2.800736, -0.185244>, <2.960037, -2.794487, -0.176959>, <2.980912, -2.787087, -0.178169>, 
      <2.936901, -2.810694, -0.207481>, <2.939803, -2.815754, -0.186081>, <2.965396, -2.809666, -0.177700>, <2.986271, -2.802266, -0.178909>, 
      <2.925450, -2.833656, -0.206782>, <2.929493, -2.840705, -0.176982>, <2.964658, -2.831847, -0.165505>, <2.993727, -2.821542, -0.167190>, 
      <2.930572, -2.848655, -0.208094>, <2.934615, -2.855703, -0.178294>, <2.969984, -2.847005, -0.166751>, <2.999054, -2.836700, -0.168436>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.931735, -2.795676, -0.206644>, <2.936901, -2.810694, -0.207481>, <2.925450, -2.833656, -0.206782>, <2.930572, -2.848655, -0.208094>, 
      <2.928817, -2.790590, -0.228155>, <2.933983, -2.805608, -0.228992>, <2.921386, -2.826571, -0.236737>, <2.926508, -2.841570, -0.238049>, 
      <2.951497, -2.779826, -0.239117>, <2.956327, -2.793538, -0.239998>, <2.953285, -2.812892, -0.252030>, <2.958087, -2.826581, -0.253320>, 
      <2.972480, -2.772388, -0.240333>, <2.977310, -2.786100, -0.241214>, <2.982507, -2.802533, -0.253724>, <2.987308, -2.816223, -0.255014>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.926739, -2.447196, -0.195028>, <2.925067, -2.446715, -0.224121>, <2.891971, -2.458002, -0.234206>, <2.864542, -2.467725, -0.232616>, 
      <2.951263, -2.543305, -0.190616>, <2.949591, -2.542824, -0.219709>, <2.924686, -2.549094, -0.227908>, <2.897257, -2.558817, -0.226318>, 
      <2.987960, -2.670558, -0.206548>, <2.985057, -2.665498, -0.227950>, <2.961189, -2.673672, -0.235674>, <2.940312, -2.681073, -0.234464>, 
      <3.021661, -2.763799, -0.211856>, <3.018758, -2.758739, -0.233257>, <2.993356, -2.764988, -0.241543>, <2.972480, -2.772388, -0.240333>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.926739, -2.447196, -0.195028>, <2.901993, -2.350219, -0.199480>, <2.841630, -2.126065, -0.241044>, <2.858305, -2.123621, -0.241244>, 
      <2.925067, -2.446715, -0.224121>, <2.900321, -2.349738, -0.228573>, <2.841276, -2.125963, -0.247203>, <2.857951, -2.123519, -0.247404>, 
      <2.891971, -2.458002, -0.234206>, <2.856129, -2.358204, -0.241106>, <2.817713, -2.225025, -0.271884>, <2.779554, -2.126865, -0.286047>, 
      <2.864542, -2.467725, -0.232616>, <2.828700, -2.367927, -0.239516>, <2.782940, -2.236543, -0.270006>, <2.744781, -2.138383, -0.284169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.869262, -2.469082, -0.150505>, <2.833831, -2.369649, -0.151950>, <2.788142, -2.237878, -0.176139>, <2.750330, -2.139980, -0.187570>, 
      <2.896840, -2.459306, -0.152104>, <2.861409, -2.359873, -0.153548>, <2.822751, -2.226415, -0.178008>, <2.784938, -2.128517, -0.189439>, 
      <2.928421, -2.447680, -0.165777>, <2.903675, -2.350702, -0.170229>, <2.841982, -2.126166, -0.234913>, <2.858657, -2.123722, -0.235114>, 
      <2.926739, -2.447196, -0.195028>, <2.901993, -2.350219, -0.199480>, <2.841630, -2.126065, -0.241044>, <2.858305, -2.123621, -0.241244>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.869262, -2.469082, -0.150505>, <2.896840, -2.459306, -0.152104>, <2.928421, -2.447680, -0.165777>, <2.926739, -2.447196, -0.195028>, 
      <2.903311, -2.564638, -0.149117>, <2.930889, -2.554862, -0.150715>, <2.952945, -2.543788, -0.161365>, <2.951263, -2.543305, -0.190616>, 
      <2.947173, -2.691525, -0.173508>, <2.968157, -2.684086, -0.174724>, <2.990878, -2.675645, -0.185037>, <2.987960, -2.670558, -0.206548>, 
      <2.980912, -2.787087, -0.178169>, <3.001896, -2.779649, -0.179385>, <3.024579, -2.768885, -0.190344>, <3.021661, -2.763799, -0.211856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.807076, -2.489614, -0.188092>, <2.768717, -2.396756, -0.191867>, <2.695468, -2.185240, -0.231257>, <2.678691, -2.183114, -0.231544>, 
      <2.808748, -2.490095, -0.159003>, <2.770390, -2.397237, -0.162777>, <2.695741, -2.185319, -0.226497>, <2.678964, -2.183193, -0.226784>, 
      <2.841836, -2.478804, -0.148915>, <2.806405, -2.379371, -0.150360>, <2.761271, -2.246778, -0.174688>, <2.723459, -2.148880, -0.186119>, 
      <2.869262, -2.469082, -0.150505>, <2.833831, -2.369649, -0.151950>, <2.788142, -2.237878, -0.176139>, <2.750330, -2.139980, -0.187570>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.807076, -2.489614, -0.188092>, <2.808748, -2.490095, -0.159003>, <2.841836, -2.478804, -0.148915>, <2.869262, -2.469082, -0.150505>, 
      <2.844961, -2.581326, -0.184364>, <2.846634, -2.581806, -0.155275>, <2.875885, -2.574360, -0.147527>, <2.903311, -2.564638, -0.149117>, 
      <2.899482, -2.701907, -0.201420>, <2.902385, -2.706967, -0.180021>, <2.926298, -2.698924, -0.172298>, <2.947173, -2.691525, -0.173508>, 
      <2.931735, -2.795676, -0.206644>, <2.934638, -2.800736, -0.185244>, <2.960037, -2.794487, -0.176959>, <2.980912, -2.787087, -0.178169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.807076, -2.489614, -0.188092>, <2.844961, -2.581326, -0.184364>, <2.899482, -2.701907, -0.201420>, <2.931735, -2.795676, -0.206644>, 
      <2.805395, -2.489130, -0.217340>, <2.843280, -2.580842, -0.213612>, <2.896564, -2.696820, -0.222931>, <2.928817, -2.790590, -0.228155>, 
      <2.836967, -2.477500, -0.231018>, <2.869682, -2.568592, -0.224719>, <2.919329, -2.688511, -0.233248>, <2.951497, -2.779826, -0.239117>, 
      <2.864542, -2.467725, -0.232616>, <2.897257, -2.558817, -0.226318>, <2.940312, -2.681073, -0.234464>, <2.972480, -2.772388, -0.240333>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.807076, -2.489614, -0.188092>, <2.805395, -2.489130, -0.217340>, <2.836967, -2.477500, -0.231018>, <2.864542, -2.467725, -0.232616>, 
      <2.768717, -2.396756, -0.191867>, <2.767036, -2.396273, -0.221115>, <2.801125, -2.377702, -0.237918>, <2.828700, -2.367927, -0.239516>, 
      <2.695468, -2.185240, -0.231257>, <2.695191, -2.185161, -0.236072>, <2.755752, -2.245548, -0.268538>, <2.782940, -2.236543, -0.270006>, 
      <2.678691, -2.183114, -0.231544>, <2.678414, -2.183034, -0.236360>, <2.717593, -2.147388, -0.282701>, <2.744781, -2.138383, -0.284169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.646040, -2.849867, -0.235431>, <2.626122, -2.851578, -0.234790>, <2.603490, -2.855810, -0.225066>, <2.604970, -2.860622, -0.205709>, 
      <2.646040, -2.849867, -0.235431>, <2.628582, -2.861898, -0.230045>, <2.616868, -2.865829, -0.226700>, <2.618349, -2.870641, -0.207343>, 
      <2.646040, -2.849867, -0.235431>, <2.628582, -2.861898, -0.230045>, <2.641090, -2.874554, -0.220395>, <2.641950, -2.877350, -0.209147>, 
      <2.646040, -2.849867, -0.235431>, <2.648500, -2.860188, -0.230686>, <2.657814, -2.873118, -0.220933>, <2.658674, -2.875914, -0.209685>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.585940, -2.821443, -0.200804>, <2.586843, -2.834528, -0.201742>, <2.594495, -2.852777, -0.204430>, <2.604970, -2.860622, -0.205709>, 
      <2.583915, -2.814854, -0.227310>, <2.584817, -2.827939, -0.228248>, <2.593014, -2.847965, -0.223787>, <2.603490, -2.855810, -0.225066>, 
      <2.614906, -2.809058, -0.240623>, <2.615914, -2.822104, -0.241637>, <2.623345, -2.839924, -0.240148>, <2.626122, -2.851578, -0.234790>, 
      <2.642180, -2.806717, -0.241501>, <2.643188, -2.819762, -0.242515>, <2.643262, -2.838213, -0.240789>, <2.646040, -2.849867, -0.235431>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.691444, -2.853196, -0.208492>, <2.684552, -2.862950, -0.209257>, <2.670592, -2.874891, -0.210069>, <2.658674, -2.875914, -0.209685>, 
      <2.691444, -2.853196, -0.208492>, <2.683041, -2.858038, -0.229015>, <2.669732, -2.872094, -0.221317>, <2.657814, -2.873118, -0.220933>, 
      <2.691444, -2.853196, -0.208492>, <2.683041, -2.858038, -0.229015>, <2.668830, -2.858442, -0.231340>, <2.648500, -2.860188, -0.230686>, 
      <2.691444, -2.853196, -0.208492>, <2.689933, -2.848284, -0.228250>, <2.666370, -2.848121, -0.236085>, <2.646040, -2.849867, -0.235431>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.691444, -2.853196, -0.208492>, <2.699051, -2.842430, -0.207648>, <2.705477, -2.824404, -0.205565>, <2.704347, -2.811278, -0.204616>, 
      <2.689933, -2.848284, -0.228250>, <2.697540, -2.837519, -0.227406>, <2.703410, -2.817679, -0.232618>, <2.702280, -2.804553, -0.231669>, 
      <2.666370, -2.848121, -0.236085>, <2.663593, -2.836468, -0.241444>, <2.671024, -2.817373, -0.243411>, <2.670017, -2.804327, -0.242397>, 
      <2.646040, -2.849867, -0.235431>, <2.643262, -2.838213, -0.240789>, <2.643188, -2.819762, -0.242515>, <2.642180, -2.806717, -0.241501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.691444, -2.853196, -0.208492>, <2.689933, -2.848284, -0.228250>, <2.666370, -2.848121, -0.236085>, <2.646040, -2.849867, -0.235431>, 
      <2.684552, -2.862950, -0.209257>, <2.683041, -2.858038, -0.229015>, <2.646453, -2.849832, -0.235444>, <2.626122, -2.851578, -0.234790>, 
      <2.670592, -2.874891, -0.210069>, <2.653868, -2.876327, -0.209530>, <2.616868, -2.865829, -0.226700>, <2.603490, -2.855810, -0.225066>, 
      <2.658674, -2.875914, -0.209685>, <2.641950, -2.877350, -0.209147>, <2.618349, -2.870641, -0.207343>, <2.604970, -2.860622, -0.205709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.650373, -2.863952, -0.178772>, <2.648485, -2.855035, -0.170596>, <2.649057, -2.838184, -0.164727>, <2.648108, -2.826003, -0.163919>, 
      <2.670290, -2.862242, -0.179413>, <2.668403, -2.853325, -0.171237>, <2.676330, -2.835843, -0.165605>, <2.675381, -2.823662, -0.164797>, 
      <2.692924, -2.858008, -0.189135>, <2.700531, -2.847242, -0.188291>, <2.707503, -2.830993, -0.179059>, <2.706372, -2.817867, -0.178110>, 
      <2.691444, -2.853196, -0.208492>, <2.699051, -2.842430, -0.207648>, <2.705477, -2.824404, -0.205565>, <2.704347, -2.811278, -0.204616>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.650373, -2.863952, -0.178772>, <2.651953, -2.871417, -0.185617>, <2.659433, -2.878380, -0.199764>, <2.658674, -2.875914, -0.209685>, 
      <2.650373, -2.863952, -0.178772>, <2.671871, -2.869707, -0.186258>, <2.671350, -2.877357, -0.200148>, <2.670592, -2.874891, -0.210069>, 
      <2.650373, -2.863952, -0.178772>, <2.671871, -2.869707, -0.186258>, <2.686032, -2.867762, -0.189900>, <2.684552, -2.862950, -0.209257>, 
      <2.650373, -2.863952, -0.178772>, <2.670290, -2.862242, -0.179413>, <2.692924, -2.858008, -0.189135>, <2.691444, -2.853196, -0.208492>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.650373, -2.863952, -0.178772>, <2.651953, -2.871417, -0.185617>, <2.659433, -2.878380, -0.199764>, <2.658674, -2.875914, -0.209685>, 
      <2.670290, -2.862242, -0.179413>, <2.671871, -2.869707, -0.186258>, <2.658572, -2.875584, -0.211012>, <2.657814, -2.873118, -0.220933>, 
      <2.692924, -2.858008, -0.189135>, <2.691413, -2.853096, -0.208893>, <2.668830, -2.858442, -0.231340>, <2.648500, -2.860188, -0.230686>, 
      <2.691444, -2.853196, -0.208492>, <2.689933, -2.848284, -0.228250>, <2.666370, -2.848121, -0.236085>, <2.646040, -2.849867, -0.235431>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.650373, -2.863952, -0.178772>, <2.670290, -2.862242, -0.179413>, <2.692924, -2.858008, -0.189135>, <2.691444, -2.853196, -0.208492>, 
      <2.630043, -2.865698, -0.178118>, <2.649961, -2.863987, -0.178759>, <2.686032, -2.867762, -0.189900>, <2.684552, -2.862950, -0.209257>, 
      <2.606481, -2.865534, -0.185951>, <2.619860, -2.875553, -0.187585>, <2.653868, -2.876327, -0.209530>, <2.670592, -2.874891, -0.210069>, 
      <2.604970, -2.860622, -0.205709>, <2.618349, -2.870641, -0.207343>, <2.641950, -2.877350, -0.209147>, <2.658674, -2.875914, -0.209685>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.650373, -2.863952, -0.178772>, <2.651953, -2.871417, -0.185617>, <2.659433, -2.878380, -0.199764>, <2.658674, -2.875914, -0.209685>, 
      <2.650373, -2.863952, -0.178772>, <2.631624, -2.873163, -0.184963>, <2.642709, -2.879817, -0.199226>, <2.641950, -2.877350, -0.209147>, 
      <2.650373, -2.863952, -0.178772>, <2.631624, -2.873163, -0.184963>, <2.619860, -2.875553, -0.187585>, <2.618349, -2.870641, -0.207343>, 
      <2.650373, -2.863952, -0.178772>, <2.630043, -2.865698, -0.178118>, <2.606481, -2.865534, -0.185951>, <2.604970, -2.860622, -0.205709>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.650373, -2.863952, -0.178772>, <2.648485, -2.855035, -0.170596>, <2.649057, -2.838184, -0.164727>, <2.648108, -2.826003, -0.163919>, 
      <2.630043, -2.865698, -0.178118>, <2.628156, -2.856781, -0.169941>, <2.621220, -2.840574, -0.163830>, <2.620271, -2.828393, -0.163023>, 
      <2.606481, -2.865534, -0.185951>, <2.596006, -2.857689, -0.184672>, <2.588910, -2.841253, -0.174688>, <2.588007, -2.828168, -0.173750>, 
      <2.604970, -2.860622, -0.205709>, <2.594495, -2.852777, -0.204430>, <2.586843, -2.834528, -0.201742>, <2.585940, -2.821443, -0.200804>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.650373, -2.863952, -0.178772>, <2.630043, -2.865698, -0.178118>, <2.606481, -2.865534, -0.185951>, <2.604970, -2.860622, -0.205709>, 
      <2.651953, -2.871417, -0.185617>, <2.631624, -2.873163, -0.184963>, <2.605001, -2.860722, -0.205308>, <2.603490, -2.855810, -0.225066>, 
      <2.659433, -2.878380, -0.199764>, <2.658572, -2.875584, -0.211012>, <2.628582, -2.861898, -0.230045>, <2.626122, -2.851578, -0.234790>, 
      <2.658674, -2.875914, -0.209685>, <2.657814, -2.873118, -0.220933>, <2.648500, -2.860188, -0.230686>, <2.646040, -2.849867, -0.235431>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.684150, -2.768522, -0.202370>, <2.682665, -2.763691, -0.221798>, <2.659494, -2.763529, -0.229500>, <2.639504, -2.765246, -0.228856>, 
      <2.685381, -2.782658, -0.202966>, <2.683896, -2.777827, -0.222393>, <2.660518, -2.776504, -0.230141>, <2.640527, -2.778221, -0.229497>, 
      <2.703131, -2.797165, -0.203596>, <2.701064, -2.790440, -0.230649>, <2.669016, -2.791373, -0.241391>, <2.641179, -2.793763, -0.240495>, 
      <2.704347, -2.811278, -0.204616>, <2.702280, -2.804553, -0.231669>, <2.670017, -2.804327, -0.242397>, <2.642180, -2.806717, -0.241501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.643763, -2.779098, -0.173146>, <2.663348, -2.777416, -0.173777>, <2.685605, -2.773255, -0.183336>, <2.684150, -2.768522, -0.202370>, 
      <2.644906, -2.793444, -0.173645>, <2.664491, -2.791762, -0.174276>, <2.686836, -2.787391, -0.183931>, <2.685381, -2.782658, -0.202966>, 
      <2.646992, -2.811677, -0.162969>, <2.674265, -2.809336, -0.163847>, <2.705157, -2.803754, -0.177090>, <2.703131, -2.797165, -0.203596>, 
      <2.648108, -2.826003, -0.163919>, <2.675381, -2.823662, -0.164797>, <2.706372, -2.817867, -0.178110>, <2.704347, -2.811278, -0.204616>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.599120, -2.775826, -0.199630>, <2.600605, -2.780656, -0.180204>, <2.623774, -2.780815, -0.172502>, <2.643763, -2.779098, -0.173146>, 
      <2.600135, -2.790027, -0.200221>, <2.601620, -2.794857, -0.180794>, <2.624917, -2.795161, -0.173000>, <2.644906, -2.793444, -0.173645>, 
      <2.584962, -2.807264, -0.199788>, <2.587029, -2.813989, -0.172734>, <2.619155, -2.814067, -0.162073>, <2.646992, -2.811677, -0.162969>, 
      <2.585940, -2.821443, -0.200804>, <2.588007, -2.828168, -0.173750>, <2.620271, -2.828393, -0.163023>, <2.648108, -2.826003, -0.163919>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.599120, -2.775826, -0.199630>, <2.600135, -2.790027, -0.200221>, <2.584962, -2.807264, -0.199788>, <2.585940, -2.821443, -0.200804>, 
      <2.597665, -2.771093, -0.218664>, <2.598680, -2.785294, -0.219255>, <2.582936, -2.800675, -0.226294>, <2.583915, -2.814854, -0.227310>, 
      <2.619919, -2.766928, -0.228225>, <2.620942, -2.779904, -0.228866>, <2.613906, -2.796104, -0.239617>, <2.614906, -2.809058, -0.240623>, 
      <2.639504, -2.765246, -0.228856>, <2.640527, -2.778221, -0.229497>, <2.641179, -2.793763, -0.240495>, <2.642180, -2.806717, -0.241501>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.674876, -2.472860, -0.190357>, <2.673361, -2.472426, -0.216707>, <2.642476, -2.474857, -0.226075>, <2.616189, -2.477113, -0.225229>, 
      <2.675703, -2.561562, -0.185937>, <2.674188, -2.561127, -0.212287>, <2.649879, -2.561017, -0.219469>, <2.623592, -2.563273, -0.218622>, 
      <2.676451, -2.680119, -0.198645>, <2.674966, -2.675289, -0.218073>, <2.652685, -2.677172, -0.225237>, <2.632694, -2.678890, -0.224593>, 
      <2.684150, -2.768522, -0.202370>, <2.682665, -2.763691, -0.221798>, <2.659494, -2.763529, -0.229500>, <2.639504, -2.765246, -0.228856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.674876, -2.472860, -0.190357>, <2.674058, -2.385168, -0.194727>, <2.664039, -2.181257, -0.231795>, <2.678691, -2.183114, -0.231544>, 
      <2.673361, -2.472426, -0.216707>, <2.672543, -2.384733, -0.221078>, <2.663743, -2.181172, -0.236934>, <2.678396, -2.183029, -0.236683>, 
      <2.642476, -2.474857, -0.226075>, <2.634369, -2.380498, -0.233311>, <2.627153, -2.262019, -0.266263>, <2.618511, -2.167856, -0.275229>, 
      <2.616189, -2.477113, -0.225229>, <2.608082, -2.382754, -0.232464>, <2.596632, -2.259851, -0.265864>, <2.587991, -2.165688, -0.274830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.620409, -2.478323, -0.151838>, <2.612603, -2.384308, -0.154196>, <2.601062, -2.259802, -0.172728>, <2.592953, -2.167114, -0.188494>, 
      <2.646134, -2.476115, -0.152666>, <2.638328, -2.382100, -0.155024>, <2.630165, -2.261870, -0.173109>, <2.622056, -2.169182, -0.188874>, 
      <2.676359, -2.473285, -0.164571>, <2.675541, -2.385593, -0.168941>, <2.664320, -2.181338, -0.226895>, <2.678972, -2.183195, -0.226644>, 
      <2.674876, -2.472860, -0.190357>, <2.674058, -2.385168, -0.194727>, <2.664039, -2.181257, -0.231795>, <2.678691, -2.183114, -0.231544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.620409, -2.478323, -0.151838>, <2.646134, -2.476115, -0.152666>, <2.676359, -2.473285, -0.164571>, <2.674876, -2.472860, -0.190357>, 
      <2.627914, -2.568713, -0.149571>, <2.653638, -2.566505, -0.150399>, <2.677186, -2.561987, -0.160150>, <2.675703, -2.561562, -0.185937>, 
      <2.636562, -2.688709, -0.170005>, <2.656147, -2.687027, -0.170636>, <2.677907, -2.684852, -0.179611>, <2.676451, -2.680119, -0.198645>, 
      <2.643763, -2.779098, -0.173146>, <2.663348, -2.777416, -0.173777>, <2.685605, -2.773255, -0.183336>, <2.684150, -2.768522, -0.202370>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.561723, -2.482571, -0.186714>, <2.550030, -2.388711, -0.191361>, <2.529777, -2.265800, -0.216986>, <2.523912, -2.172117, -0.229521>, 
      <2.563238, -2.483006, -0.160363>, <2.551545, -2.389146, -0.165011>, <2.531162, -2.266198, -0.192889>, <2.525297, -2.172515, -0.205424>, 
      <2.594121, -2.480579, -0.150992>, <2.586316, -2.386564, -0.153350>, <2.576985, -2.258091, -0.172414>, <2.568876, -2.165403, -0.188179>, 
      <2.620409, -2.478323, -0.151838>, <2.612603, -2.384308, -0.154196>, <2.601062, -2.259802, -0.172728>, <2.592953, -2.167114, -0.188494>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.561723, -2.482571, -0.186714>, <2.563238, -2.483006, -0.160363>, <2.594121, -2.480579, -0.150992>, <2.620409, -2.478323, -0.151838>, 
      <2.572684, -2.570557, -0.182358>, <2.574199, -2.570992, -0.156007>, <2.601626, -2.570969, -0.148725>, <2.627914, -2.568713, -0.149571>, 
      <2.592797, -2.687354, -0.195951>, <2.594282, -2.692185, -0.176525>, <2.616573, -2.690426, -0.169361>, <2.636562, -2.688709, -0.170005>, 
      <2.599120, -2.775826, -0.199630>, <2.600605, -2.780656, -0.180204>, <2.623774, -2.780815, -0.172502>, <2.643763, -2.779098, -0.173146>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.561723, -2.482571, -0.186714>, <2.572684, -2.570557, -0.182358>, <2.592797, -2.687354, -0.195951>, <2.599120, -2.775826, -0.199630>, 
      <2.560240, -2.482146, -0.212499>, <2.571201, -2.570132, -0.208143>, <2.591342, -2.682621, -0.214986>, <2.597665, -2.771093, -0.218664>, 
      <2.590466, -2.479321, -0.224401>, <2.597868, -2.565480, -0.217794>, <2.613109, -2.680572, -0.223962>, <2.619919, -2.766928, -0.228225>, 
      <2.616189, -2.477113, -0.225229>, <2.623592, -2.563273, -0.218622>, <2.632694, -2.678890, -0.224593>, <2.639504, -2.765246, -0.228856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.561723, -2.482571, -0.186714>, <2.560240, -2.482146, -0.212499>, <2.590466, -2.479321, -0.224401>, <2.616189, -2.477113, -0.225229>, 
      <2.550030, -2.388711, -0.191361>, <2.548548, -2.388286, -0.217146>, <2.582359, -2.384962, -0.231636>, <2.608082, -2.382754, -0.232464>, 
      <2.529777, -2.265800, -0.216986>, <2.528422, -2.265410, -0.240567>, <2.573071, -2.258177, -0.265556>, <2.596632, -2.259851, -0.265864>, 
      <2.523912, -2.172117, -0.229521>, <2.522557, -2.171728, -0.253102>, <2.564430, -2.164014, -0.274522>, <2.587991, -2.165688, -0.274830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.342481, -1.307140, 0.409323>, <0.344121, -1.354205, 0.280705>, <0.318391, -1.302998, 0.126982>, <0.293816, -1.175512, 0.083349>, 
      <0.540671, -1.448775, 0.447341>, <0.542310, -1.495840, 0.318723>, <0.552987, -1.339357, 0.139387>, <0.528412, -1.211871, 0.095754>, 
      <0.806511, -1.634608, 0.570828>, <0.714706, -1.660202, 0.343694>, <0.770419, -1.385198, 0.238401>, <0.876013, -1.174727, 0.166117>, 
      <1.003114, -1.779255, 0.536050>, <0.911308, -1.804849, 0.308916>, <0.970210, -1.507179, 0.196985>, <1.075804, -1.296708, 0.124700>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.287632, -0.997992, 0.568470>, <0.312007, -1.124439, 0.611747>, <0.340855, -1.260458, 0.536893>, <0.342481, -1.307140, 0.409323>, 
      <0.587532, -1.069919, 0.592316>, <0.611907, -1.196366, 0.635594>, <0.539045, -1.402093, 0.574911>, <0.540671, -1.448775, 0.447341>, 
      <1.023391, -1.079290, 0.678385>, <0.920532, -1.284310, 0.748797>, <0.895939, -1.609678, 0.792079>, <0.806511, -1.634608, 0.570828>, 
      <1.287300, -1.237747, 0.647958>, <1.184441, -1.442767, 0.718370>, <1.092542, -1.754324, 0.757301>, <1.003114, -1.779255, 0.536050>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.238967, -0.770144, 0.225533>, <0.237052, -0.715162, 0.375786>, <0.258923, -0.849062, 0.517498>, <0.287632, -0.997992, 0.568470>, 
      <0.575272, -0.859482, 0.245399>, <0.573357, -0.804500, 0.395652>, <0.558824, -0.920988, 0.541344>, <0.587532, -1.069919, 0.592316>, 
      <1.060347, -0.894425, 0.331610>, <1.118064, -0.878334, 0.474405>, <1.089776, -0.946971, 0.632941>, <1.023391, -1.079290, 0.678385>, 
      <1.359983, -1.067938, 0.291754>, <1.417699, -1.051848, 0.434549>, <1.353685, -1.105428, 0.602514>, <1.287300, -1.237747, 0.647958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.238967, -0.770144, 0.225533>, <0.575272, -0.859482, 0.245399>, <1.060347, -0.894425, 0.331610>, <1.359983, -1.067938, 0.291754>, 
      <0.240968, -0.827576, 0.068585>, <0.577273, -0.916914, 0.088452>, <1.002631, -0.910515, 0.188814>, <1.302266, -1.084028, 0.148958>, 
      <0.263828, -1.019946, 0.030106>, <0.498425, -1.056305, 0.042511>, <0.942398, -1.042407, 0.120673>, <1.142189, -1.164388, 0.079256>, 
      <0.293816, -1.175512, 0.083349>, <0.528412, -1.211871, 0.095754>, <0.876013, -1.174727, 0.166117>, <1.075804, -1.296708, 0.124700>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.391122, -2.078657, 0.223822>, <1.273228, -1.969731, 0.291846>, <1.142130, -1.881533, 0.511459>, <1.003114, -1.779255, 0.536050>, 
      <1.326198, -2.090394, 0.069232>, <1.208304, -1.981468, 0.137255>, <1.050325, -1.907127, 0.284324>, <0.911308, -1.804849, 0.308916>, 
      <1.368293, -2.010177, -0.106615>, <1.241672, -1.815123, -0.069892>, <1.168076, -1.627984, 0.155967>, <0.970210, -1.507179, 0.196985>, 
      <1.483799, -1.902046, -0.163335>, <1.357178, -1.706992, -0.126612>, <1.273670, -1.417513, 0.083682>, <1.075804, -1.296708, 0.124700>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.721702, -1.859039, 0.403133>, <1.607185, -1.672537, 0.499160>, <1.491204, -1.360176, 0.624449>, <1.287300, -1.237747, 0.647958>, 
      <1.606197, -1.967169, 0.459853>, <1.491680, -1.780667, 0.555880>, <1.388346, -1.565195, 0.694862>, <1.184441, -1.442767, 0.718370>, 
      <1.456046, -2.066920, 0.378411>, <1.338152, -1.957995, 0.446435>, <1.231558, -1.856603, 0.732710>, <1.092542, -1.754324, 0.757301>, 
      <1.391122, -2.078657, 0.223822>, <1.273228, -1.969731, 0.291846>, <1.142130, -1.881533, 0.511459>, <1.003114, -1.779255, 0.536050>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.814373, -1.682432, 0.015982>, <1.703680, -1.478357, 0.090222>, <1.569530, -1.189282, 0.263881>, <1.359983, -1.067938, 0.291754>, 
      <1.879296, -1.670695, 0.170570>, <1.768603, -1.466621, 0.244810>, <1.627246, -1.173192, 0.406677>, <1.417699, -1.051848, 0.434549>, 
      <1.837206, -1.750910, 0.346414>, <1.722689, -1.564408, 0.442441>, <1.557589, -1.227856, 0.579005>, <1.353685, -1.105428, 0.602514>, 
      <1.721702, -1.859039, 0.403133>, <1.607185, -1.672537, 0.499160>, <1.491204, -1.360176, 0.624449>, <1.287300, -1.237747, 0.647958>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.814373, -1.682432, 0.015982>, <1.749450, -1.694169, -0.138606>, <1.599303, -1.793917, -0.220054>, <1.483799, -1.902046, -0.163335>, 
      <1.703680, -1.478357, 0.090222>, <1.638757, -1.490094, -0.064365>, <1.472683, -1.598864, -0.183331>, <1.357178, -1.706992, -0.126612>, 
      <1.569530, -1.189282, 0.263881>, <1.511813, -1.205373, 0.121086>, <1.340055, -1.285193, 0.038238>, <1.273670, -1.417513, 0.083682>, 
      <1.359983, -1.067938, 0.291754>, <1.302266, -1.084028, 0.148958>, <1.142189, -1.164388, 0.079256>, <1.075804, -1.296708, 0.124700>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.742183, -2.462102, 0.109613>, <1.611265, -2.375331, 0.138423>, <1.499110, -2.178431, 0.161514>, <1.391122, -2.078657, 0.223822>, 
      <1.730441, -2.544122, 0.041671>, <1.599523, -2.457351, 0.070481>, <1.434186, -2.190167, 0.006923>, <1.326198, -2.090394, 0.069232>, 
      <1.823743, -2.606940, -0.048739>, <1.642806, -2.467647, -0.031506>, <1.491451, -2.199897, -0.142333>, <1.368293, -2.010177, -0.106615>, 
      <1.887794, -2.547544, -0.110794>, <1.706857, -2.408251, -0.093562>, <1.606957, -2.091766, -0.199053>, <1.483799, -1.902046, -0.163335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.926319, -2.278449, 0.112116>, <1.846120, -2.158736, 0.192481>, <1.800759, -1.987791, 0.336841>, <1.721702, -1.859039, 0.403133>, 
      <1.866319, -2.334089, 0.170247>, <1.786119, -2.214375, 0.250612>, <1.685254, -2.095921, 0.393560>, <1.606197, -1.967169, 0.459853>, 
      <1.753183, -2.385270, 0.173259>, <1.622265, -2.298499, 0.202069>, <1.564034, -2.166694, 0.316103>, <1.456046, -2.066920, 0.378411>, 
      <1.742183, -2.462102, 0.109613>, <1.611265, -2.375331, 0.138423>, <1.499110, -2.178431, 0.161514>, <1.391122, -2.078657, 0.223822>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.991030, -2.231341, -0.131481>, <1.929796, -2.077053, -0.065690>, <1.895463, -1.831930, -0.038404>, <1.814373, -1.682432, 0.015982>, 
      <2.001874, -2.155592, -0.068733>, <1.940641, -2.001304, -0.002942>, <1.960386, -1.820193, 0.116184>, <1.879296, -1.670695, 0.170570>, 
      <1.985473, -2.223594, 0.054805>, <1.905274, -2.103881, 0.135170>, <1.916263, -1.879662, 0.280122>, <1.837206, -1.750910, 0.346414>, 
      <1.926319, -2.278449, 0.112116>, <1.846120, -2.158736, 0.192481>, <1.800759, -1.987791, 0.336841>, <1.721702, -1.859039, 0.403133>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.991030, -2.231341, -0.131481>, <1.976935, -2.329796, -0.213038>, <1.964680, -2.476246, -0.185284>, <1.887794, -2.547544, -0.110794>, 
      <1.929796, -2.077053, -0.065690>, <1.915701, -2.175508, -0.147248>, <1.783743, -2.336953, -0.168052>, <1.706857, -2.408251, -0.093562>, 
      <1.895463, -1.831930, -0.038404>, <1.830539, -1.843666, -0.192991>, <1.722462, -1.983638, -0.255773>, <1.606957, -2.091766, -0.199053>, 
      <1.814373, -1.682432, 0.015982>, <1.749450, -1.694169, -0.138606>, <1.599303, -1.793917, -0.220054>, <1.483799, -1.902046, -0.163335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.281746, -2.668953, 0.027829>, <2.126885, -2.749208, 0.043045>, <1.885727, -2.557241, 0.078024>, <1.742183, -2.462102, 0.109613>, 
      <2.345511, -2.699255, -0.068660>, <2.190650, -2.779510, -0.053443>, <1.873985, -2.639261, 0.010082>, <1.730441, -2.544122, 0.041671>, 
      <2.327318, -2.598820, -0.176370>, <2.247518, -2.690571, -0.158973>, <1.920802, -2.681660, -0.057982>, <1.823743, -2.606940, -0.048739>, 
      <2.275059, -2.511191, -0.238694>, <2.195259, -2.602942, -0.221298>, <1.984853, -2.622264, -0.120038>, <1.887794, -2.547544, -0.110794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.104203, -2.429998, 0.019843>, <2.033461, -2.455556, 0.024689>, <1.962957, -2.333138, 0.075402>, <1.926319, -2.278449, 0.112116>, 
      <2.154440, -2.514236, 0.079756>, <2.083698, -2.539795, 0.084602>, <1.902957, -2.388778, 0.133533>, <1.866319, -2.334089, 0.170247>, 
      <2.220448, -2.639823, 0.120584>, <2.065587, -2.720078, 0.135800>, <1.896727, -2.480409, 0.141670>, <1.753183, -2.385270, 0.173259>, 
      <2.281746, -2.668953, 0.027829>, <2.126885, -2.749208, 0.043045>, <1.885727, -2.557241, 0.078024>, <1.742183, -2.462102, 0.109613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.055016, -2.288769, -0.242569>, <2.031978, -2.323245, -0.235047>, <2.005482, -2.267755, -0.147008>, <1.991030, -2.231341, -0.131481>, 
      <1.992847, -2.259225, -0.148495>, <1.969809, -2.293702, -0.140973>, <2.016326, -2.192006, -0.084261>, <2.001874, -2.155592, -0.068733>, 
      <2.053252, -2.344562, -0.040922>, <1.982509, -2.370120, -0.036076>, <2.022111, -2.278284, 0.018092>, <1.985473, -2.223594, 0.054805>, 
      <2.104203, -2.429998, 0.019843>, <2.033461, -2.455556, 0.024689>, <1.962957, -2.333138, 0.075402>, <1.926319, -2.278449, 0.112116>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.055016, -2.288769, -0.242569>, <2.119422, -2.319375, -0.340027>, <2.222275, -2.422682, -0.301644>, <2.275059, -2.511191, -0.238694>, 
      <2.031978, -2.323245, -0.235047>, <2.096384, -2.353852, -0.332504>, <2.142475, -2.514432, -0.284248>, <2.195259, -2.602942, -0.221298>, 
      <2.005482, -2.267755, -0.147008>, <1.991387, -2.366210, -0.228566>, <2.061738, -2.550966, -0.194528>, <1.984853, -2.622264, -0.120038>, 
      <1.991030, -2.231341, -0.131481>, <1.976935, -2.329796, -0.213038>, <1.964680, -2.476246, -0.185284>, <1.887794, -2.547544, -0.110794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.359684, -2.142089, 0.048939>, <2.361738, -2.299693, 0.021990>, <2.423181, -2.595656, 0.013932>, <2.281746, -2.668953, 0.027829>, 
      <2.409301, -2.108858, -0.032685>, <2.411355, -2.266462, -0.059634>, <2.486946, -2.625958, -0.082557>, <2.345511, -2.699255, -0.068660>, 
      <2.368456, -2.088578, -0.144529>, <2.379913, -2.212276, -0.163870>, <2.408994, -2.504914, -0.194174>, <2.327318, -2.598820, -0.176370>, 
      <2.282022, -2.094278, -0.196734>, <2.293479, -2.217975, -0.216075>, <2.356734, -2.417284, -0.256499>, <2.275059, -2.511191, -0.238694>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.101578, -2.215130, 0.100110>, <2.113719, -2.279056, 0.077711>, <2.168790, -2.406663, 0.015419>, <2.104203, -2.429998, 0.019843>, 
      <2.191648, -2.209191, 0.154511>, <2.203789, -2.273116, 0.132112>, <2.219028, -2.490902, 0.075331>, <2.154440, -2.514236, 0.079756>, 
      <2.307979, -2.176718, 0.133997>, <2.310034, -2.334322, 0.107048>, <2.361883, -2.566526, 0.106687>, <2.220448, -2.639823, 0.120584>, 
      <2.359684, -2.142089, 0.048939>, <2.361738, -2.299693, 0.021990>, <2.423181, -2.595656, 0.013932>, <2.281746, -2.668953, 0.027829>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.036426, -2.163405, -0.146304>, <2.047931, -2.207273, -0.161232>, <2.081117, -2.249709, -0.251092>, <2.055016, -2.288769, -0.242569>, 
      <1.987183, -2.196385, -0.065296>, <1.998688, -2.240253, -0.080224>, <2.018947, -2.220165, -0.157018>, <1.992847, -2.259225, -0.148495>, 
      <2.015796, -2.220787, 0.048299>, <2.027937, -2.284712, 0.025900>, <2.117839, -2.321227, -0.045346>, <2.053252, -2.344562, -0.040922>, 
      <2.101578, -2.215130, 0.100110>, <2.113719, -2.279056, 0.077711>, <2.168790, -2.406663, 0.015419>, <2.104203, -2.429998, 0.019843>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.036426, -2.163405, -0.146304>, <2.085668, -2.130425, -0.227312>, <2.196241, -2.099935, -0.248545>, <2.282022, -2.094278, -0.196734>, 
      <2.047931, -2.207273, -0.161232>, <2.097173, -2.174293, -0.242240>, <2.207698, -2.223632, -0.267885>, <2.293479, -2.217975, -0.216075>, 
      <2.081117, -2.249709, -0.251092>, <2.145522, -2.280315, -0.348549>, <2.303950, -2.328775, -0.319449>, <2.356734, -2.417284, -0.256499>, 
      <2.055016, -2.288769, -0.242569>, <2.119422, -2.319375, -0.340027>, <2.222275, -2.422682, -0.301644>, <2.275059, -2.511191, -0.238694>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.228124, -1.188848, 0.218149>, <2.192723, -1.244419, 0.211204>, <2.146677, -1.237544, 0.128975>, <2.130915, -1.199521, 0.077058>, 
      <2.270187, -1.233361, 0.171889>, <2.234786, -1.288931, 0.164944>, <2.177585, -1.278371, 0.082426>, <2.161823, -1.240349, 0.030509>, 
      <2.314611, -1.298867, 0.105380>, <2.253279, -1.344761, 0.095616>, <2.196120, -1.339252, 0.006677>, <2.177747, -1.294935, -0.053834>, 
      <2.353821, -1.352396, 0.066807>, <2.292489, -1.398290, 0.057043>, <2.234977, -1.390835, -0.018188>, <2.216604, -1.346518, -0.078699>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.303468, -0.928654, 0.110912>, <2.330218, -0.993182, 0.199019>, <2.288202, -1.094540, 0.229936>, <2.228124, -1.188848, 0.218149>, 
      <2.369550, -0.978187, 0.059160>, <2.396301, -1.042715, 0.147268>, <2.330265, -1.139053, 0.183676>, <2.270187, -1.233361, 0.171889>, 
      <2.397162, -1.100520, -0.006378>, <2.417415, -1.149370, 0.060323>, <2.382216, -1.248279, 0.116143>, <2.314611, -1.298867, 0.105380>, 
      <2.437931, -1.180902, -0.043463>, <2.458184, -1.229752, 0.023238>, <2.421426, -1.301808, 0.077570>, <2.353821, -1.352396, 0.066807>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.152263, -1.005853, -0.031715>, <2.197987, -0.934077, -0.022744>, <2.283109, -0.879543, 0.043855>, <2.303468, -0.928654, 0.110912>, 
      <2.207583, -1.037506, -0.074474>, <2.253307, -0.965729, -0.065503>, <2.349191, -0.929076, -0.007897>, <2.369550, -0.978187, 0.059160>, 
      <2.233820, -1.101904, -0.172081>, <2.301328, -1.051388, -0.161333>, <2.376939, -1.051740, -0.072983>, <2.397162, -1.100520, -0.006378>, 
      <2.275493, -1.163465, -0.191161>, <2.343001, -1.112949, -0.180413>, <2.417707, -1.132122, -0.110068>, <2.437931, -1.180902, -0.043463>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.152263, -1.005853, -0.031715>, <2.207583, -1.037506, -0.074474>, <2.233820, -1.101904, -0.172081>, <2.275493, -1.163465, -0.191161>, 
      <2.106247, -1.078087, -0.040743>, <2.161566, -1.109740, -0.083502>, <2.165537, -1.152999, -0.182951>, <2.207210, -1.214560, -0.202032>, 
      <2.110426, -1.150096, 0.009573>, <2.141334, -1.190924, -0.036976>, <2.157291, -1.245595, -0.121203>, <2.196148, -1.297178, -0.146068>, 
      <2.130915, -1.199521, 0.077058>, <2.161823, -1.240349, 0.030509>, <2.177747, -1.294935, -0.053834>, <2.216604, -1.346518, -0.078699>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.105953, -1.090091, 0.339407>, <2.137842, -1.174485, 0.285569>, <2.172892, -1.244717, 0.155188>, <2.104720, -1.198726, 0.089802>, 
      <2.124219, -1.035099, 0.325747>, <2.156109, -1.119493, 0.271909>, <2.176006, -1.240625, 0.162258>, <2.107834, -1.194634, 0.096872>, 
      <2.195496, -1.154320, 0.254032>, <2.160095, -1.209890, 0.247087>, <2.142773, -1.232386, 0.134855>, <2.127010, -1.194363, 0.082938>, 
      <2.228124, -1.188848, 0.218149>, <2.192723, -1.244419, 0.211204>, <2.146677, -1.237544, 0.128975>, <2.130915, -1.199521, 0.077058>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.963655, -0.825401, 0.327961>, <2.038967, -0.876208, 0.400195>, <2.070724, -0.996858, 0.398884>, <2.105953, -1.090091, 0.339407>, 
      <2.045280, -0.743711, 0.280461>, <2.120591, -0.794519, 0.352695>, <2.088990, -0.941866, 0.385224>, <2.124219, -1.035099, 0.325747>, 
      <2.218803, -0.865192, 0.177217>, <2.245553, -0.929720, 0.265324>, <2.255574, -1.060012, 0.265819>, <2.195496, -1.154320, 0.254032>, 
      <2.303468, -0.928654, 0.110912>, <2.330218, -0.993182, 0.199019>, <2.288202, -1.094540, 0.229936>, <2.228124, -1.188848, 0.218149>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.875291, -0.934481, 0.118173>, <1.845721, -0.856225, 0.168096>, <1.900441, -0.782756, 0.267331>, <1.963655, -0.825401, 0.327961>, 
      <1.949933, -0.877743, 0.093800>, <1.920363, -0.799487, 0.143723>, <1.982066, -0.701066, 0.219831>, <2.045280, -0.743711, 0.280461>, 
      <2.082438, -0.965901, 0.022256>, <2.128162, -0.894125, 0.031227>, <2.198444, -0.816081, 0.110160>, <2.218803, -0.865192, 0.177217>, 
      <2.152263, -1.005853, -0.031715>, <2.197987, -0.934077, -0.022744>, <2.283109, -0.879543, 0.043855>, <2.303468, -0.928654, 0.110912>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.875291, -0.934481, 0.118173>, <1.949933, -0.877743, 0.093800>, <2.082438, -0.965901, 0.022256>, <2.152263, -1.005853, -0.031715>, 
      <1.916420, -1.043327, 0.048736>, <1.991062, -0.986589, 0.024363>, <2.036421, -1.038135, 0.013228>, <2.106247, -1.078087, -0.040743>, 
      <2.016796, -1.139411, 0.005472>, <2.019910, -1.135318, 0.012542>, <2.106521, -1.144939, 0.015454>, <2.110426, -1.150096, 0.009573>, 
      <2.104720, -1.198726, 0.089802>, <2.107834, -1.194634, 0.096872>, <2.127010, -1.194363, 0.082938>, <2.130915, -1.199521, 0.077058>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.172483, -1.356359, 0.259758>, <2.227857, -1.330188, 0.167306>, <2.197447, -1.263542, 0.054896>, <2.100148, -1.239956, 0.007198>, 
      <2.149488, -1.276127, 0.279361>, <2.204862, -1.249956, 0.186909>, <2.192130, -1.238884, 0.066417>, <2.094831, -1.215299, 0.018719>, 
      <2.079648, -1.169283, 0.359078>, <2.111538, -1.253677, 0.305239>, <2.163016, -1.257697, 0.132762>, <2.094843, -1.211706, 0.067376>, 
      <2.105953, -1.090091, 0.339407>, <2.137842, -1.174485, 0.285569>, <2.172892, -1.244717, 0.155188>, <2.104720, -1.198726, 0.089802>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.896011, -1.336435, 0.348024>, <1.994514, -1.360312, 0.396312>, <2.116424, -1.382854, 0.353353>, <2.172483, -1.356359, 0.259758>, 
      <1.894390, -1.182087, 0.359247>, <1.992893, -1.205964, 0.407535>, <2.093430, -1.302622, 0.372956>, <2.149488, -1.276127, 0.279361>, 
      <1.862487, -0.926649, 0.386834>, <1.937799, -0.977456, 0.459067>, <2.044419, -1.076050, 0.418555>, <2.079648, -1.169283, 0.359078>, 
      <1.963655, -0.825401, 0.327961>, <2.038967, -0.876208, 0.400195>, <2.070724, -0.996858, 0.398884>, <2.105953, -1.090091, 0.339407>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.807532, -1.267894, 0.080851>, <1.751711, -1.294276, 0.174049>, <1.797926, -1.312659, 0.299941>, <1.896011, -1.336435, 0.348024>, 
      <1.804878, -1.167353, 0.101533>, <1.749057, -1.193735, 0.194732>, <1.796305, -1.158311, 0.311164>, <1.894390, -1.182087, 0.359247>, 
      <1.796175, -0.994619, 0.144007>, <1.766605, -0.916364, 0.193930>, <1.799273, -0.884004, 0.326204>, <1.862487, -0.926649, 0.386834>, 
      <1.875291, -0.934481, 0.118173>, <1.845721, -0.856225, 0.168096>, <1.900441, -0.782756, 0.267331>, <1.963655, -0.825401, 0.327961>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.807532, -1.267894, 0.080851>, <1.804878, -1.167353, 0.101533>, <1.796175, -0.994619, 0.144007>, <1.875291, -0.934481, 0.118173>, 
      <1.865928, -1.240295, -0.016647>, <1.863274, -1.139753, 0.004035>, <1.837304, -1.103466, 0.074570>, <1.916420, -1.043327, 0.048736>, 
      <1.997538, -1.215083, -0.043104>, <1.992221, -1.190426, -0.031583>, <2.006919, -1.152391, -0.016955>, <2.016796, -1.139411, 0.005472>, 
      <2.100148, -1.239956, 0.007198>, <2.094831, -1.215299, 0.018719>, <2.094843, -1.211706, 0.067376>, <2.104720, -1.198726, 0.089802>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.268561, -1.657456, 0.200786>, <2.327768, -1.617803, 0.103388>, <2.292186, -1.589557, -0.031179>, <2.190223, -1.595267, -0.095485>, 
      <2.246931, -1.566671, 0.225145>, <2.306139, -1.527018, 0.127746>, <2.269030, -1.480786, -0.005215>, <2.167067, -1.486497, -0.069521>, 
      <2.198353, -1.446623, 0.237704>, <2.253726, -1.420452, 0.145253>, <2.219342, -1.365083, 0.007450>, <2.122043, -1.341498, -0.040248>, 
      <2.172483, -1.356359, 0.259758>, <2.227857, -1.330188, 0.167306>, <2.197447, -1.263542, 0.054896>, <2.100148, -1.239956, 0.007198>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.268561, -1.657456, 0.200786>, <2.303273, -1.803153, 0.161694>, <2.357695, -1.989524, 0.075026>, <2.359684, -2.142089, 0.048939>, 
      <2.327768, -1.617803, 0.103388>, <2.362481, -1.763500, 0.064296>, <2.407312, -1.956293, -0.006598>, <2.409301, -2.108858, -0.032685>, 
      <2.292186, -1.589557, -0.031179>, <2.323659, -1.737395, -0.066469>, <2.354311, -1.935863, -0.120651>, <2.368456, -2.088578, -0.144529>, 
      <2.190223, -1.595267, -0.095485>, <2.221696, -1.743106, -0.130775>, <2.267877, -1.941563, -0.172856>, <2.282022, -2.094278, -0.196734>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.973266, -1.740570, 0.261417>, <2.075230, -1.734860, 0.325724>, <2.209353, -1.697110, 0.298185>, <2.268561, -1.657456, 0.200786>, 
      <1.945558, -1.622134, 0.294833>, <2.047523, -1.616423, 0.359139>, <2.187723, -1.606324, 0.322544>, <2.246931, -1.566671, 0.225145>, 
      <1.897332, -1.462237, 0.338877>, <1.995835, -1.486114, 0.387165>, <2.142294, -1.473117, 0.331300>, <2.198353, -1.446623, 0.237704>, 
      <1.896011, -1.336435, 0.348024>, <1.994514, -1.360312, 0.396312>, <2.116424, -1.382854, 0.353353>, <2.172483, -1.356359, 0.259758>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.973266, -1.740570, 0.261417>, <2.007360, -1.886306, 0.220299>, <2.074194, -2.070943, 0.150633>, <2.101578, -2.215130, 0.100110>, 
      <2.075230, -1.734860, 0.325724>, <2.109324, -1.880596, 0.284606>, <2.164264, -2.065004, 0.205034>, <2.191648, -2.209191, 0.154511>, 
      <2.209353, -1.697110, 0.298185>, <2.244065, -1.842806, 0.259093>, <2.305991, -2.024153, 0.160084>, <2.307979, -2.176718, 0.133997>, 
      <2.268561, -1.657456, 0.200786>, <2.303273, -1.803153, 0.161694>, <2.357695, -1.989524, 0.075026>, <2.359684, -2.142089, 0.048939>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.894931, -1.678381, -0.034854>, <1.932258, -1.824417, -0.071898>, <1.999024, -2.020794, -0.097773>, <2.036426, -2.163405, -0.146304>, 
      <1.835724, -1.718034, 0.062544>, <1.873051, -1.864070, 0.025500>, <1.949781, -2.053774, -0.016765>, <1.987183, -2.196385, -0.065296>, 
      <1.871303, -1.746280, 0.197111>, <1.905398, -1.892017, 0.155994>, <1.988412, -2.076600, 0.098822>, <2.015796, -2.220787, 0.048299>, 
      <1.973266, -1.740570, 0.261417>, <2.007360, -1.886306, 0.220299>, <2.074194, -2.070943, 0.150633>, <2.101578, -2.215130, 0.100110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.894931, -1.678381, -0.034854>, <1.835724, -1.718034, 0.062544>, <1.871303, -1.746280, 0.197111>, <1.973266, -1.740570, 0.261417>, 
      <1.863523, -1.555502, -0.003684>, <1.804316, -1.595155, 0.093714>, <1.843596, -1.627844, 0.230527>, <1.945558, -1.622134, 0.294833>, 
      <1.810908, -1.395776, 0.054544>, <1.755087, -1.422158, 0.147743>, <1.799248, -1.438461, 0.290793>, <1.897332, -1.462237, 0.338877>, 
      <1.807532, -1.267894, 0.080851>, <1.751711, -1.294276, 0.174049>, <1.797926, -1.312659, 0.299941>, <1.896011, -1.336435, 0.348024>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.894931, -1.678381, -0.034854>, <1.863523, -1.555502, -0.003684>, <1.810908, -1.395776, 0.054544>, <1.807532, -1.267894, 0.080851>, 
      <1.954139, -1.638728, -0.132253>, <1.922730, -1.515849, -0.101083>, <1.869305, -1.368177, -0.042954>, <1.865928, -1.240295, -0.016647>, 
      <2.088260, -1.600977, -0.159791>, <2.065104, -1.492207, -0.133827>, <2.019432, -1.316625, -0.090550>, <1.997538, -1.215083, -0.043104>, 
      <2.190223, -1.595267, -0.095485>, <2.167067, -1.486497, -0.069521>, <2.122043, -1.341498, -0.040248>, <2.100148, -1.239956, 0.007198>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.894931, -1.678381, -0.034854>, <1.954139, -1.638728, -0.132253>, <2.088260, -1.600977, -0.159791>, <2.190223, -1.595267, -0.095485>, 
      <1.932258, -1.824417, -0.071898>, <1.991466, -1.784764, -0.169296>, <2.119733, -1.748816, -0.195081>, <2.221696, -1.743106, -0.130775>, 
      <1.999024, -2.020794, -0.097773>, <2.048266, -1.987814, -0.178781>, <2.182096, -1.947219, -0.224667>, <2.267877, -1.941563, -0.172856>, 
      <2.036426, -2.163405, -0.146304>, <2.085668, -2.130425, -0.227312>, <2.196241, -2.099935, -0.248545>, <2.282022, -2.094278, -0.196734>
    }
  }
}
#declare sPatchObj5 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.375451, -3.032475, 0.633677>, <-1.361592, -3.018557, 0.509203>, <-1.312261, -2.996830, 0.345609>, <-1.291306, -3.014098, 0.222555>, 
      <-1.311169, -3.066284, 0.636240>, <-1.297310, -3.052366, 0.511767>, <-1.291236, -3.017787, 0.354663>, <-1.270280, -3.035055, 0.231609>, 
      <-1.231005, -3.028676, 0.632986>, <-1.228039, -3.016378, 0.516818>, <-1.234360, -3.009591, 0.358835>, <-1.229591, -3.039444, 0.245959>, 
      <-1.200543, -2.962712, 0.634590>, <-1.197577, -2.950414, 0.518422>, <-1.219982, -2.982203, 0.361367>, <-1.215213, -3.012056, 0.248491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.433097, -2.840401, 0.625316>, <-1.403615, -2.856412, 0.497013>, <-1.338865, -2.881532, 0.332205>, <-1.313715, -2.913876, 0.206076>, 
      <-1.465565, -2.910710, 0.623606>, <-1.436083, -2.926721, 0.495304>, <-1.357461, -2.916955, 0.328930>, <-1.332312, -2.949299, 0.202800>, 
      <-1.443967, -2.996439, 0.630945>, <-1.430108, -2.982521, 0.506471>, <-1.339455, -2.969725, 0.333899>, <-1.318500, -2.986993, 0.210845>, 
      <-1.375451, -3.032475, 0.633677>, <-1.361592, -3.018557, 0.509203>, <-1.312261, -2.996830, 0.345609>, <-1.291306, -3.014098, 0.222555>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.249881, -2.760558, 0.640289>, <-1.243033, -2.790472, 0.513271>, <-1.245604, -2.864945, 0.353719>, <-1.237620, -2.911836, 0.232011>, 
      <-1.318296, -2.724575, 0.637561>, <-1.311448, -2.754489, 0.510543>, <-1.266630, -2.843987, 0.344665>, <-1.258646, -2.890879, 0.222957>, 
      <-1.400677, -2.770195, 0.627023>, <-1.371194, -2.786206, 0.498720>, <-1.324486, -2.854144, 0.334738>, <-1.299336, -2.886487, 0.208609>, 
      <-1.433097, -2.840401, 0.625316>, <-1.403615, -2.856412, 0.497013>, <-1.338865, -2.881532, 0.332205>, <-1.313715, -2.913876, 0.206076>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.249881, -2.760558, 0.640289>, <-1.178821, -2.797932, 0.643123>, <-1.166869, -2.889792, 0.636363>, <-1.200543, -2.962712, 0.634590>, 
      <-1.243033, -2.790472, 0.513271>, <-1.171973, -2.827846, 0.516105>, <-1.163903, -2.877494, 0.520195>, <-1.197577, -2.950414, 0.518422>, 
      <-1.245604, -2.864945, 0.353719>, <-1.218410, -2.892050, 0.365429>, <-1.201386, -2.946781, 0.364643>, <-1.219982, -2.982203, 0.361367>, 
      <-1.237620, -2.911836, 0.232011>, <-1.210426, -2.938941, 0.243721>, <-1.196617, -2.976634, 0.251767>, <-1.215213, -3.012056, 0.248491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.393749, -3.116980, 1.142641>, <-1.381071, -3.100785, 0.989136>, <-1.392484, -3.049581, 0.786661>, <-1.375451, -3.032475, 0.633677>, 
      <-1.358836, -3.158114, 1.176503>, <-1.346158, -3.141919, 1.022998>, <-1.328202, -3.083390, 0.789224>, <-1.311169, -3.066284, 0.636240>, 
      <-1.253518, -3.150487, 1.131166>, <-1.260480, -3.127682, 0.988769>, <-1.234669, -3.043871, 0.776517>, <-1.231005, -3.028676, 0.632986>, 
      <-1.236797, -3.101560, 1.093962>, <-1.243758, -3.078755, 0.951565>, <-1.204207, -2.977907, 0.778121>, <-1.200543, -2.962712, 0.634590>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.466537, -2.830884, 0.871141>, <-1.457151, -2.823594, 0.797614>, <-1.449655, -2.831409, 0.697375>, <-1.433097, -2.840401, 0.625316>, 
      <-1.507170, -2.949778, 0.961547>, <-1.497784, -2.942488, 0.888020>, <-1.482123, -2.901718, 0.695665>, <-1.465565, -2.910710, 0.623606>, 
      <-1.478589, -3.017023, 1.060356>, <-1.465911, -3.000828, 0.906851>, <-1.461000, -3.013546, 0.783929>, <-1.443967, -2.996439, 0.630945>, 
      <-1.393749, -3.116980, 1.142641>, <-1.381071, -3.100785, 0.989136>, <-1.392484, -3.049581, 0.786661>, <-1.375451, -3.032475, 0.633677>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.272125, -2.761103, 0.872035>, <-1.267933, -2.771068, 0.803033>, <-1.253541, -2.744569, 0.708179>, <-1.249881, -2.760558, 0.640289>, 
      <-1.315818, -2.709624, 0.829658>, <-1.311627, -2.719589, 0.760656>, <-1.321956, -2.708586, 0.705451>, <-1.318296, -2.724575, 0.637561>, 
      <-1.445611, -2.769652, 0.824581>, <-1.436225, -2.762363, 0.751054>, <-1.417235, -2.761204, 0.699082>, <-1.400677, -2.770195, 0.627023>, 
      <-1.466537, -2.830884, 0.871141>, <-1.457151, -2.823594, 0.797614>, <-1.449655, -2.831409, 0.697375>, <-1.433097, -2.840401, 0.625316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.272125, -2.761103, 0.872035>, <-1.185834, -2.862770, 0.955727>, <-1.195469, -2.980633, 1.002010>, <-1.236797, -3.101560, 1.093962>, 
      <-1.267933, -2.771068, 0.803033>, <-1.181642, -2.872735, 0.886725>, <-1.202431, -2.957828, 0.859613>, <-1.243758, -3.078755, 0.951565>, 
      <-1.253541, -2.744569, 0.708179>, <-1.182481, -2.781943, 0.711013>, <-1.170533, -2.904987, 0.779894>, <-1.204207, -2.977907, 0.778121>, 
      <-1.249881, -2.760558, 0.640289>, <-1.178821, -2.797932, 0.643123>, <-1.166869, -2.889792, 0.636363>, <-1.200543, -2.962712, 0.634590>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.432389, -3.105213, 1.323107>, <-1.430598, -3.103436, 1.267685>, <-1.398290, -3.122782, 1.197629>, <-1.393749, -3.116980, 1.142641>, 
      <-1.345300, -3.151000, 1.360988>, <-1.343509, -3.149224, 1.305566>, <-1.363377, -3.163916, 1.231491>, <-1.358836, -3.158114, 1.176503>, 
      <-1.197349, -3.180311, 1.381134>, <-1.216924, -3.196464, 1.298863>, <-1.249367, -3.164086, 1.216080>, <-1.253518, -3.150487, 1.131166>, 
      <-1.164546, -3.080634, 1.370916>, <-1.184120, -3.096787, 1.288645>, <-1.232646, -3.115159, 1.178876>, <-1.236797, -3.101560, 1.093962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.509143, -2.899462, 1.221028>, <-1.502602, -2.897481, 1.113521>, <-1.480112, -2.841427, 0.977485>, <-1.466537, -2.830884, 0.871141>, 
      <-1.538222, -2.987822, 1.230086>, <-1.531681, -2.985841, 1.122578>, <-1.520745, -2.960321, 1.067891>, <-1.507170, -2.949778, 0.961547>, 
      <-1.509590, -3.064625, 1.289527>, <-1.507799, -3.062848, 1.234105>, <-1.483130, -3.022825, 1.115344>, <-1.478589, -3.017023, 1.060356>, 
      <-1.432389, -3.105213, 1.323107>, <-1.430598, -3.103436, 1.267685>, <-1.398290, -3.122782, 1.197629>, <-1.393749, -3.116980, 1.142641>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.288641, -2.668414, 1.278331>, <-1.295360, -2.672050, 1.153446>, <-1.279634, -2.743252, 0.995646>, <-1.272125, -2.761103, 0.872035>, 
      <-1.392083, -2.614029, 1.233337>, <-1.398803, -2.617666, 1.108452>, <-1.323328, -2.691773, 0.953268>, <-1.315818, -2.709624, 0.829658>, 
      <-1.470180, -2.781068, 1.208892>, <-1.463640, -2.779088, 1.101384>, <-1.459186, -2.780196, 0.930925>, <-1.445611, -2.769652, 0.824581>, 
      <-1.509143, -2.899462, 1.221028>, <-1.502602, -2.897481, 1.113521>, <-1.480112, -2.841427, 0.977485>, <-1.466537, -2.830884, 0.871141>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.288641, -2.668414, 1.278331>, <-1.148265, -2.742217, 1.339390>, <-1.111672, -2.919968, 1.354446>, <-1.164546, -3.080634, 1.370916>, 
      <-1.295360, -2.672050, 1.153446>, <-1.154984, -2.745853, 1.214505>, <-1.131246, -2.936121, 1.272175>, <-1.184120, -3.096787, 1.288645>, 
      <-1.279634, -2.743252, 0.995646>, <-1.193343, -2.844918, 1.079338>, <-1.191318, -2.994232, 1.086924>, <-1.232646, -3.115159, 1.178876>, 
      <-1.272125, -2.761103, 0.872035>, <-1.185834, -2.862770, 0.955727>, <-1.195469, -2.980633, 1.002010>, <-1.236797, -3.101560, 1.093962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.406691, -3.129815, 1.543059>, <-1.415737, -3.116750, 1.478132>, <-1.434547, -3.107353, 1.389881>, <-1.432389, -3.105213, 1.323107>, 
      <-1.310618, -3.181651, 1.520673>, <-1.319664, -3.168586, 1.455746>, <-1.347458, -3.153141, 1.427762>, <-1.345300, -3.151000, 1.360988>, 
      <-1.197322, -3.133840, 1.462104>, <-1.203238, -3.131467, 1.436882>, <-1.191435, -3.175431, 1.405993>, <-1.197349, -3.180311, 1.381134>, 
      <-1.153835, -3.033100, 1.442648>, <-1.159751, -3.030727, 1.417426>, <-1.158631, -3.075753, 1.395775>, <-1.164546, -3.080634, 1.370916>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.506304, -2.842927, 1.524778>, <-1.515960, -2.840381, 1.432624>, <-1.514771, -2.901166, 1.313535>, <-1.509143, -2.899462, 1.221028>, 
      <-1.552124, -2.949074, 1.545278>, <-1.561781, -2.946527, 1.453123>, <-1.543850, -2.989526, 1.322593>, <-1.538222, -2.987822, 1.230086>, 
      <-1.507920, -3.075197, 1.566647>, <-1.516967, -3.062133, 1.501720>, <-1.511748, -3.066765, 1.356301>, <-1.509590, -3.064625, 1.289527>, 
      <-1.406691, -3.129815, 1.543059>, <-1.415737, -3.116750, 1.478132>, <-1.434547, -3.107353, 1.389881>, <-1.432389, -3.105213, 1.323107>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.240032, -2.743736, 1.468497>, <-1.254677, -2.728002, 1.409202>, <-1.285254, -2.666581, 1.341284>, <-1.288641, -2.668414, 1.278331>, 
      <-1.336413, -2.691734, 1.490955>, <-1.351058, -2.676000, 1.431660>, <-1.388696, -2.612196, 1.296290>, <-1.392083, -2.614029, 1.233337>, 
      <-1.462678, -2.741864, 1.505260>, <-1.472334, -2.739318, 1.413106>, <-1.475808, -2.782773, 1.301399>, <-1.470180, -2.781068, 1.208892>, 
      <-1.506304, -2.842927, 1.524778>, <-1.515960, -2.840381, 1.432624>, <-1.514771, -2.901166, 1.313535>, <-1.509143, -2.899462, 1.221028>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.240032, -2.743736, 1.468497>, <-1.139204, -2.798137, 1.445003>, <-1.108196, -2.927374, 1.422230>, <-1.153835, -3.033100, 1.442648>, 
      <-1.254677, -2.728002, 1.409202>, <-1.153849, -2.782403, 1.385708>, <-1.114113, -2.925000, 1.397008>, <-1.159751, -3.030727, 1.417426>, 
      <-1.285254, -2.666581, 1.341284>, <-1.144878, -2.740384, 1.402343>, <-1.105757, -2.915087, 1.379305>, <-1.158631, -3.075753, 1.395775>, 
      <-1.288641, -2.668414, 1.278331>, <-1.148265, -2.742217, 1.339390>, <-1.111672, -2.919968, 1.354446>, <-1.164546, -3.080634, 1.370916>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.358910, -3.211331, 1.850479>, <-1.410267, -3.194062, 1.770645>, <-1.393633, -3.148673, 1.636777>, <-1.406691, -3.129815, 1.543059>, 
      <-1.257618, -3.266475, 1.814936>, <-1.308975, -3.249207, 1.735102>, <-1.297560, -3.200509, 1.614390>, <-1.310618, -3.181651, 1.520673>, 
      <-1.123431, -3.225527, 1.792821>, <-1.177607, -3.197440, 1.696293>, <-1.171350, -3.144258, 1.572821>, <-1.197322, -3.133840, 1.462104>, 
      <-1.063475, -3.121176, 1.801789>, <-1.117650, -3.093090, 1.705261>, <-1.127864, -3.043518, 1.553366>, <-1.153835, -3.033100, 1.442648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.434644, -2.919107, 1.932031>, <-1.504876, -2.894636, 1.830149>, <-1.493164, -2.846392, 1.650184>, <-1.506304, -2.842927, 1.524778>, 
      <-1.494600, -3.023458, 1.923063>, <-1.564833, -2.998987, 1.821181>, <-1.538984, -2.952539, 1.670684>, <-1.552124, -2.949074, 1.545278>, 
      <-1.460202, -3.156186, 1.886022>, <-1.511559, -3.138918, 1.806188>, <-1.494863, -3.094055, 1.660365>, <-1.507920, -3.075197, 1.566647>, 
      <-1.358910, -3.211331, 1.850479>, <-1.410267, -3.194062, 1.770645>, <-1.393633, -3.148673, 1.636777>, <-1.406691, -3.129815, 1.543059>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.139209, -2.828953, 1.883341>, <-1.207630, -2.794022, 1.777721>, <-1.209706, -2.776317, 1.591281>, <-1.240032, -2.743736, 1.468497>, 
      <-1.240501, -2.773808, 1.918884>, <-1.308921, -2.738878, 1.813264>, <-1.306086, -2.724315, 1.613739>, <-1.336413, -2.691734, 1.490955>, 
      <-1.374688, -2.814756, 1.940999>, <-1.444920, -2.790285, 1.839117>, <-1.449538, -2.745329, 1.630667>, <-1.462678, -2.741864, 1.505260>, 
      <-1.434644, -2.919107, 1.932031>, <-1.504876, -2.894636, 1.830149>, <-1.493164, -2.846392, 1.650184>, <-1.506304, -2.842927, 1.524778>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.139209, -2.828953, 1.883341>, <-1.037917, -2.884098, 1.847798>, <-1.003519, -3.016825, 1.810757>, <-1.063475, -3.121176, 1.801789>, 
      <-1.207630, -2.794022, 1.777721>, <-1.106338, -2.849167, 1.742178>, <-1.057694, -2.988739, 1.714229>, <-1.117650, -3.093090, 1.705261>, 
      <-1.209706, -2.776317, 1.591281>, <-1.108877, -2.830718, 1.567787>, <-1.082225, -2.937791, 1.532947>, <-1.127864, -3.043518, 1.553366>, 
      <-1.240032, -2.743736, 1.468497>, <-1.139204, -2.798137, 1.445003>, <-1.108196, -2.927374, 1.422230>, <-1.153835, -3.033100, 1.442648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.939652, -3.286856, 2.269070>, <-1.065429, -3.264198, 2.143493>, <-1.263539, -3.243399, 1.998732>, <-1.358910, -3.211331, 1.850479>, 
      <-0.906692, -3.332721, 2.186093>, <-1.032469, -3.310064, 2.060516>, <-1.162248, -3.298543, 1.963189>, <-1.257618, -3.266475, 1.814936>, 
      <-0.847353, -3.298663, 2.089794>, <-0.923693, -3.271454, 2.013215>, <-1.070536, -3.252950, 1.887069>, <-1.123431, -3.225527, 1.792821>, 
      <-0.809006, -3.211872, 2.057053>, <-0.885347, -3.184663, 1.980474>, <-1.010579, -3.148599, 1.896037>, <-1.063475, -3.121176, 1.801789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.929783, -3.043807, 2.361106>, <-1.081241, -3.006397, 2.232383>, <-1.322031, -2.958345, 2.095393>, <-1.434644, -2.919107, 1.932031>, 
      <-0.968129, -3.130597, 2.393847>, <-1.119587, -3.093187, 2.265125>, <-1.381987, -3.062696, 2.086425>, <-1.494600, -3.023458, 1.923063>, 
      <-0.972612, -3.240991, 2.352046>, <-1.098389, -3.218333, 2.226469>, <-1.364831, -3.188254, 2.034276>, <-1.460202, -3.156186, 1.886022>, 
      <-0.939652, -3.286856, 2.269070>, <-1.065429, -3.264198, 2.143493>, <-1.263539, -3.243399, 1.998732>, <-1.358910, -3.211331, 1.850479>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.799138, -2.968826, 2.149095>, <-0.901159, -2.926864, 2.069369>, <-1.067904, -2.865356, 1.993413>, <-1.139209, -2.828953, 1.883341>, 
      <-0.832098, -2.922962, 2.232070>, <-0.934119, -2.881000, 2.152344>, <-1.169196, -2.810212, 2.028956>, <-1.240501, -2.773808, 1.918884>, 
      <-0.891437, -2.957018, 2.328365>, <-1.042896, -2.919608, 2.199643>, <-1.262075, -2.853995, 2.104361>, <-1.374688, -2.814756, 1.940999>, 
      <-0.929783, -3.043807, 2.361106>, <-1.081241, -3.006397, 2.232383>, <-1.322031, -2.958345, 2.095393>, <-1.434644, -2.919107, 1.932031>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.799138, -2.968826, 2.149095>, <-0.766178, -3.014691, 2.066119>, <-0.770660, -3.125082, 2.024312>, <-0.809006, -3.211872, 2.057053>, 
      <-0.901159, -2.926864, 2.069369>, <-0.868199, -2.972729, 1.986393>, <-0.847001, -3.097873, 1.947733>, <-0.885347, -3.184663, 1.980474>, 
      <-1.067904, -2.865356, 1.993413>, <-0.966612, -2.920501, 1.957870>, <-0.950623, -3.044248, 1.905005>, <-1.010579, -3.148599, 1.896037>, 
      <-1.139209, -2.828953, 1.883341>, <-1.037917, -2.884098, 1.847798>, <-1.003519, -3.016825, 1.810757>, <-1.063475, -3.121176, 1.801789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.264123, -2.979461, -0.008650>, <-1.254546, -2.947021, 0.055331>, <-1.275454, -2.918307, 0.148347>, <-1.280310, -2.892098, 0.215631>, 
      <-1.271598, -2.979635, -0.010716>, <-1.262021, -2.947196, 0.053265>, <-1.281468, -2.918468, 0.146297>, <-1.286324, -2.892260, 0.213581>, 
      <-1.281974, -2.982233, -0.012795>, <-1.270815, -2.952444, 0.051767>, <-1.291206, -2.921098, 0.144115>, <-1.294520, -2.894670, 0.210979>, 
      <-1.288652, -2.986137, -0.013382>, <-1.277493, -2.956348, 0.051180>, <-1.296384, -2.924473, 0.142634>, <-1.299698, -2.898046, 0.209498>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.236094, -2.984910, 0.001147>, <-1.228474, -2.952188, 0.064897>, <-1.251787, -2.923331, 0.156821>, <-1.258512, -2.896940, 0.223538>, 
      <-1.243927, -2.981766, -0.002136>, <-1.236307, -2.949044, 0.061615>, <-1.257878, -2.920515, 0.154483>, <-1.264604, -2.894124, 0.221201>, 
      <-1.255396, -2.979257, -0.006238>, <-1.245819, -2.946818, 0.057744>, <-1.268730, -2.918126, 0.150639>, <-1.273586, -2.891917, 0.217923>, 
      <-1.264123, -2.979461, -0.008650>, <-1.254546, -2.947021, 0.055331>, <-1.275454, -2.918307, 0.148347>, <-1.280310, -2.892098, 0.215631>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.208831, -3.001652, 0.014521>, <-1.204560, -2.967165, 0.076571>, <-1.233275, -2.937356, 0.165772>, <-1.237620, -2.911836, 0.232011>, 
      <-1.216097, -2.995466, 0.010378>, <-1.211826, -2.960980, 0.072428>, <-1.238766, -2.931882, 0.163407>, <-1.243112, -2.906362, 0.229646>, 
      <-1.227096, -2.988521, 0.004918>, <-1.219476, -2.955799, 0.068668>, <-1.244838, -2.926544, 0.159487>, <-1.251563, -2.900153, 0.226204>, 
      <-1.236094, -2.984910, 0.001147>, <-1.228474, -2.952188, 0.064897>, <-1.251787, -2.923331, 0.156821>, <-1.258512, -2.896940, 0.223538>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.186493, -3.027138, 0.029432>, <-1.187840, -2.991197, 0.089151>, <-1.210522, -2.962299, 0.176668>, <-1.220820, -2.934511, 0.239769>, 
      <-1.192048, -3.018608, 0.024987>, <-1.193396, -2.982666, 0.084707>, <-1.214593, -2.954797, 0.174612>, <-1.224891, -2.927008, 0.237713>, 
      <-1.201073, -3.008257, 0.018945>, <-1.196803, -2.973770, 0.080995>, <-1.227327, -2.943285, 0.168333>, <-1.231672, -2.917765, 0.234572>, 
      <-1.208831, -3.001652, 0.014521>, <-1.204560, -2.967165, 0.076571>, <-1.233275, -2.937356, 0.165772>, <-1.237620, -2.911836, 0.232011>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.172469, -3.057485, 0.043612>, <-1.178321, -3.020967, 0.100753>, <-1.199201, -2.990311, 0.185021>, <-1.210657, -2.961522, 0.245625>, 
      <-1.175273, -3.047772, 0.039552>, <-1.181124, -3.011254, 0.096693>, <-1.201104, -2.981798, 0.183621>, <-1.212561, -2.953010, 0.244225>, 
      <-1.181045, -3.035504, 0.033791>, <-1.182392, -2.999563, 0.093510>, <-1.206425, -2.969848, 0.178736>, <-1.216723, -2.942060, 0.241837>, 
      <-1.186493, -3.027138, 0.029432>, <-1.187840, -2.991197, 0.089151>, <-1.210522, -2.962299, 0.176668>, <-1.220820, -2.934511, 0.239769>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.168903, -3.088077, 0.054902>, <-1.179926, -3.051949, 0.109522>, <-1.196754, -3.018549, 0.190552>, <-1.208690, -2.988752, 0.248687>, 
      <-1.168266, -3.078715, 0.051939>, <-1.179288, -3.042586, 0.106559>, <-1.196015, -3.010354, 0.190087>, <-1.207951, -2.980557, 0.248222>, 
      <-1.169936, -3.066259, 0.047279>, <-1.175788, -3.029741, 0.104420>, <-1.197425, -2.998252, 0.186327>, <-1.208881, -2.969463, 0.246931>, 
      <-1.172469, -3.057485, 0.043612>, <-1.178321, -3.020967, 0.100753>, <-1.199201, -2.990311, 0.185021>, <-1.210657, -2.961522, 0.245625>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.176335, -3.114259, 0.061581>, <-1.192600, -3.076864, 0.112152>, <-1.212562, -3.028652, 0.185739>, <-1.215213, -3.012056, 0.248491>, 
      <-1.172260, -3.107016, 0.060307>, <-1.188525, -3.069622, 0.110878>, <-1.209199, -3.022246, 0.186332>, <-1.211850, -3.005649, 0.249084>, 
      <-1.169448, -3.096076, 0.057433>, <-1.180471, -3.059947, 0.112054>, <-1.197405, -3.025769, 0.190961>, <-1.209341, -2.995971, 0.249097>, 
      <-1.168903, -3.088077, 0.054902>, <-1.179926, -3.051949, 0.109522>, <-1.196754, -3.018549, 0.190552>, <-1.208690, -2.988752, 0.248687>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.193633, -3.132036, 0.062634>, <-1.204549, -3.096836, 0.114859>, <-1.218554, -3.059130, 0.190336>, <-1.229234, -3.027885, 0.245066>, 
      <-1.187222, -3.128288, 0.063198>, <-1.198138, -3.093087, 0.115423>, <-1.213319, -3.055717, 0.191834>, <-1.223999, -3.024472, 0.246564>, 
      <-1.179945, -3.120675, 0.062710>, <-1.196209, -3.083281, 0.113281>, <-1.215539, -3.034323, 0.185214>, <-1.218190, -3.017727, 0.247966>, 
      <-1.176335, -3.114259, 0.061581>, <-1.192600, -3.076864, 0.112152>, <-1.212562, -3.028652, 0.185739>, <-1.215213, -3.012056, 0.248491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.218163, -3.138713, 0.057904>, <-1.223479, -3.104177, 0.110837>, <-1.239481, -3.065299, 0.184626>, <-1.248617, -3.033836, 0.238935>, 
      <-1.210688, -3.138538, 0.059970>, <-1.216003, -3.104002, 0.112903>, <-1.233468, -3.065137, 0.186675>, <-1.242604, -3.033674, 0.240984>, 
      <-1.200311, -3.135940, 0.062047>, <-1.211227, -3.100740, 0.114272>, <-1.223730, -3.062505, 0.188856>, <-1.234411, -3.031260, 0.243585>, 
      <-1.193633, -3.132036, 0.062634>, <-1.204549, -3.096836, 0.114859>, <-1.218554, -3.059130, 0.190336>, <-1.229234, -3.027885, 0.245066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.246195, -3.133264, 0.048106>, <-1.247092, -3.100593, 0.102647>, <-1.263148, -3.060273, 0.176153>, <-1.270413, -3.028991, 0.231031>, 
      <-1.238361, -3.136408, 0.051389>, <-1.239258, -3.103737, 0.105929>, <-1.257057, -3.063089, 0.178491>, <-1.264322, -3.031807, 0.233368>, 
      <-1.226891, -3.138917, 0.055492>, <-1.232206, -3.104381, 0.108425>, <-1.246204, -3.065480, 0.182334>, <-1.255341, -3.034016, 0.236643>, 
      <-1.218163, -3.138713, 0.057904>, <-1.223479, -3.104177, 0.110837>, <-1.239481, -3.065299, 0.184626>, <-1.248617, -3.033836, 0.238935>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.273455, -3.116522, 0.034734>, <-1.266981, -3.085860, 0.090998>, <-1.280596, -3.022923, 0.159665>, <-1.291306, -3.014098, 0.222555>, 
      <-1.266190, -3.122707, 0.038876>, <-1.259716, -3.092045, 0.095141>, <-1.275104, -3.028397, 0.162029>, <-1.285814, -3.019572, 0.224919>, 
      <-1.255192, -3.129653, 0.044336>, <-1.256089, -3.096982, 0.098876>, <-1.270096, -3.057060, 0.173487>, <-1.277362, -3.025778, 0.228365>, 
      <-1.246195, -3.133264, 0.048106>, <-1.247092, -3.100593, 0.102647>, <-1.263148, -3.060273, 0.176153>, <-1.270413, -3.028991, 0.231031>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.295798, -3.091035, 0.019824>, <-1.285940, -3.062037, 0.078049>, <-1.304418, -3.021304, 0.156308>, <-1.308112, -2.991419, 0.214801>, 
      <-1.290242, -3.099566, 0.024269>, <-1.280384, -3.070568, 0.082493>, <-1.300345, -3.028808, 0.158363>, <-1.304040, -2.998923, 0.216857>, 
      <-1.281214, -3.109917, 0.030310>, <-1.274739, -3.079254, 0.086574>, <-1.286546, -3.016993, 0.157103>, <-1.297256, -3.008168, 0.219994>, 
      <-1.273455, -3.116522, 0.034734>, <-1.266981, -3.085860, 0.090998>, <-1.280596, -3.022923, 0.159665>, <-1.291306, -3.014098, 0.222555>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.309819, -3.060686, 0.005643>, <-1.298851, -3.031089, 0.065344>, <-1.315735, -2.993293, 0.147954>, <-1.318271, -2.964410, 0.208944>, 
      <-1.307016, -3.070399, 0.009703>, <-1.296048, -3.040802, 0.069404>, <-1.313833, -3.001805, 0.149353>, <-1.316368, -2.972922, 0.210343>, 
      <-1.301247, -3.082669, 0.015465>, <-1.291388, -3.053670, 0.073690>, <-1.308514, -3.013756, 0.154240>, <-1.312208, -2.983871, 0.212733>, 
      <-1.295798, -3.091035, 0.019824>, <-1.285940, -3.062037, 0.078049>, <-1.304418, -3.021304, 0.156308>, <-1.308112, -2.991419, 0.214801>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.313385, -3.030094, -0.005647>, <-1.298951, -3.003075, 0.056561>, <-1.318182, -2.965054, 0.142424>, <-1.320238, -2.937180, 0.205883>, 
      <-1.314022, -3.039456, -0.002684>, <-1.299589, -3.012437, 0.059525>, <-1.318921, -2.973249, 0.142889>, <-1.320977, -2.945375, 0.206348>, 
      <-1.312351, -3.051912, 0.001976>, <-1.301383, -3.022315, 0.061677>, <-1.317511, -2.985351, 0.146648>, <-1.320046, -2.956469, 0.207638>, 
      <-1.309819, -3.060686, 0.005643>, <-1.298851, -3.031089, 0.065344>, <-1.315735, -2.993293, 0.147954>, <-1.318271, -2.964410, 0.208944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.305954, -3.003914, -0.012327>, <-1.289912, -2.979470, 0.052273>, <-1.300268, -2.931170, 0.138636>, <-1.313715, -2.913876, 0.206076>, 
      <-1.310029, -3.011156, -0.011053>, <-1.293986, -2.986712, 0.053547>, <-1.303631, -2.937577, 0.138044>, <-1.317078, -2.920283, 0.205484>, 
      <-1.312841, -3.022096, -0.008179>, <-1.298407, -2.995077, 0.054030>, <-1.317531, -2.957835, 0.142014>, <-1.319587, -2.929961, 0.205473>, 
      <-1.313385, -3.030094, -0.005647>, <-1.298951, -3.003075, 0.056561>, <-1.318182, -2.965054, 0.142424>, <-1.320238, -2.937180, 0.205883>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.305954, -3.003914, -0.012327>, <-1.302344, -2.997497, -0.013456>, <-1.295064, -2.989885, -0.013946>, <-1.288652, -2.986137, -0.013382>, 
      <-1.289912, -2.979470, 0.052273>, <-1.286301, -2.973053, 0.051144>, <-1.283905, -2.960096, 0.050617>, <-1.277493, -2.956348, 0.051180>, 
      <-1.300268, -2.931170, 0.138636>, <-1.297292, -2.925499, 0.139160>, <-1.301619, -2.927886, 0.141137>, <-1.296384, -2.924473, 0.142634>, 
      <-1.313715, -2.913876, 0.206076>, <-1.310739, -2.908205, 0.206600>, <-1.304933, -2.901459, 0.208001>, <-1.299698, -2.898046, 0.209498>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.331236, -3.064587, -0.124576>, <-1.355429, -3.086321, -0.151082>, <-1.409993, -3.106277, -0.218400>, <-1.432988, -3.131164, -0.193659>, 
      <-1.340102, -3.059903, -0.122561>, <-1.364295, -3.081638, -0.149067>, <-1.408286, -3.104646, -0.220451>, <-1.431281, -3.129533, -0.195710>, 
      <-1.346515, -3.050102, -0.112809>, <-1.369003, -3.063224, -0.143140>, <-1.398327, -3.059771, -0.199816>, <-1.424454, -3.086594, -0.213809>, 
      <-1.354820, -3.045192, -0.109415>, <-1.377309, -3.058315, -0.139746>, <-1.409645, -3.045162, -0.197810>, <-1.435772, -3.071985, -0.211803>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.331236, -3.064587, -0.124576>, <-1.303780, -3.039922, -0.094495>, <-1.270424, -3.000803, -0.050744>, <-1.264123, -2.979461, -0.008650>, 
      <-1.340102, -3.059903, -0.122561>, <-1.312646, -3.035238, -0.092481>, <-1.277899, -3.000978, -0.052810>, <-1.271598, -2.979635, -0.010716>, 
      <-1.346515, -3.050102, -0.112809>, <-1.324452, -3.037227, -0.083053>, <-1.288054, -2.998464, -0.047973>, <-1.281974, -2.982233, -0.012795>, 
      <-1.354820, -3.045192, -0.109415>, <-1.332757, -3.032318, -0.079659>, <-1.294732, -3.002368, -0.048560>, <-1.288652, -2.986137, -0.013382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.299804, -3.074257, -0.121917>, <-1.315548, -3.097597, -0.151092>, <-1.337471, -3.130960, -0.187710>, <-1.352465, -3.157434, -0.214508>, 
      <-1.308299, -3.069281, -0.122935>, <-1.324043, -3.092621, -0.152110>, <-1.355600, -3.112239, -0.190090>, <-1.370594, -3.138713, -0.216888>, 
      <-1.322656, -3.069120, -0.126526>, <-1.346849, -3.090854, -0.153032>, <-1.407590, -3.103982, -0.221288>, <-1.430585, -3.128869, -0.196547>, 
      <-1.331236, -3.064587, -0.124576>, <-1.355429, -3.086321, -0.151082>, <-1.409993, -3.106277, -0.218400>, <-1.432988, -3.131164, -0.193659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.299804, -3.074257, -0.121917>, <-1.280596, -3.045781, -0.086322>, <-1.241324, -3.007371, -0.042613>, <-1.236094, -2.984910, 0.001147>, 
      <-1.308299, -3.069281, -0.122935>, <-1.289092, -3.040805, -0.087340>, <-1.249158, -3.004227, -0.045895>, <-1.243927, -2.981766, -0.002136>, 
      <-1.322656, -3.069120, -0.126526>, <-1.295200, -3.044455, -0.096445>, <-1.261697, -3.000599, -0.048331>, <-1.255396, -2.979257, -0.006238>, 
      <-1.331236, -3.064587, -0.124576>, <-1.303780, -3.039922, -0.094495>, <-1.270424, -3.000803, -0.050744>, <-1.264123, -2.979461, -0.008650>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.261587, -3.105384, -0.116230>, <-1.280704, -3.138382, -0.144855>, <-1.311487, -3.199409, -0.207654>, <-1.339681, -3.227516, -0.181410>, 
      <-1.273354, -3.097223, -0.120291>, <-1.292471, -3.130221, -0.148916>, <-1.309323, -3.197341, -0.210254>, <-1.337517, -3.225449, -0.184010>, 
      <-1.287028, -3.081740, -0.120386>, <-1.302772, -3.105080, -0.149561>, <-1.321145, -3.147818, -0.185567>, <-1.336139, -3.174293, -0.212365>, 
      <-1.299804, -3.074257, -0.121917>, <-1.315548, -3.097597, -0.151092>, <-1.337471, -3.130960, -0.187710>, <-1.352465, -3.157434, -0.214508>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.261587, -3.105384, -0.116230>, <-1.240534, -3.069044, -0.084706>, <-1.211984, -3.027116, -0.031296>, <-1.208831, -3.001652, 0.014521>, 
      <-1.273354, -3.097223, -0.120291>, <-1.252302, -3.060884, -0.088767>, <-1.219250, -3.020931, -0.035439>, <-1.216097, -2.995466, 0.010378>, 
      <-1.287028, -3.081740, -0.120386>, <-1.267821, -3.053264, -0.084791>, <-1.232327, -3.010982, -0.038842>, <-1.227096, -2.988521, 0.004918>, 
      <-1.299804, -3.074257, -0.121917>, <-1.280596, -3.045781, -0.086322>, <-1.241324, -3.007371, -0.042613>, <-1.236094, -2.984910, 0.001147>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.213334, -3.134227, -0.092073>, <-1.219986, -3.159900, -0.117596>, <-1.232641, -3.200953, -0.143085>, <-1.238180, -3.226619, -0.168880>, 
      <-1.226994, -3.124995, -0.100142>, <-1.233646, -3.150668, -0.125664>, <-1.258256, -3.188487, -0.154481>, <-1.263795, -3.214152, -0.180276>, 
      <-1.247076, -3.115448, -0.111222>, <-1.266193, -3.148446, -0.139847>, <-1.308669, -3.196717, -0.211039>, <-1.336864, -3.224824, -0.184796>, 
      <-1.261587, -3.105384, -0.116230>, <-1.280704, -3.138382, -0.144855>, <-1.311487, -3.199409, -0.207654>, <-1.339681, -3.227516, -0.181410>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.213334, -3.134227, -0.092073>, <-1.204433, -3.099874, -0.057922>, <-1.185541, -3.052530, -0.012758>, <-1.186493, -3.027138, 0.029432>, 
      <-1.226994, -3.124995, -0.100142>, <-1.218093, -3.090642, -0.065990>, <-1.191097, -3.044000, -0.017203>, <-1.192048, -3.018608, 0.024987>, 
      <-1.247076, -3.115448, -0.111222>, <-1.226023, -3.079108, -0.079698>, <-1.204226, -3.033721, -0.026872>, <-1.201073, -3.008257, 0.018945>, 
      <-1.261587, -3.105384, -0.116230>, <-1.240534, -3.069044, -0.084706>, <-1.211984, -3.027116, -0.031296>, <-1.208831, -3.001652, 0.014521>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.178620, -3.161458, -0.067224>, <-1.184514, -3.196213, -0.092388>, <-1.186796, -3.263115, -0.147772>, <-1.211858, -3.289728, -0.124544>, 
      <-1.188546, -3.154792, -0.076595>, <-1.194440, -3.189547, -0.101759>, <-1.184551, -3.260970, -0.150470>, <-1.209613, -3.287583, -0.127242>, 
      <-1.202029, -3.141868, -0.085396>, <-1.208681, -3.167541, -0.110918>, <-1.212230, -3.210887, -0.134005>, <-1.217770, -3.236553, -0.159800>, 
      <-1.213334, -3.134227, -0.092073>, <-1.219986, -3.159900, -0.117596>, <-1.232641, -3.200953, -0.143085>, <-1.238180, -3.226619, -0.168880>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.178620, -3.161458, -0.067224>, <-1.172410, -3.124844, -0.040714>, <-1.168546, -3.081965, 0.005307>, <-1.172469, -3.057485, 0.043612>, 
      <-1.188546, -3.154792, -0.076595>, <-1.182336, -3.118178, -0.050084>, <-1.171350, -3.072252, 0.001247>, <-1.175273, -3.047772, 0.039552>, 
      <-1.202029, -3.141868, -0.085396>, <-1.193128, -3.107515, -0.051244>, <-1.180093, -3.060896, -0.008399>, <-1.181045, -3.035504, 0.033791>, 
      <-1.213334, -3.134227, -0.092073>, <-1.204433, -3.099874, -0.057922>, <-1.185541, -3.052530, -0.012758>, <-1.186493, -3.027138, 0.029432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.151670, -3.175640, -0.033856>, <-1.146243, -3.201361, -0.057468>, <-1.133665, -3.238997, -0.084049>, <-1.131533, -3.265179, -0.107682>, 
      <-1.159018, -3.169157, -0.043218>, <-1.153591, -3.194877, -0.066830>, <-1.154566, -3.237068, -0.098879>, <-1.152434, -3.263250, -0.122512>, 
      <-1.169765, -3.167405, -0.058864>, <-1.175659, -3.202160, -0.084028>, <-1.184436, -3.260860, -0.150608>, <-1.209498, -3.287473, -0.127380>, 
      <-1.178620, -3.161458, -0.067224>, <-1.184514, -3.196213, -0.092388>, <-1.186796, -3.263115, -0.147772>, <-1.211858, -3.289728, -0.124544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.151670, -3.175640, -0.033856>, <-1.157470, -3.148154, -0.008623>, <-1.162635, -3.108620, 0.023845>, <-1.168903, -3.088077, 0.054902>, 
      <-1.159018, -3.169157, -0.043218>, <-1.164818, -3.141671, -0.017985>, <-1.161998, -3.099257, 0.020882>, <-1.168266, -3.078715, 0.051939>, 
      <-1.169765, -3.167405, -0.058864>, <-1.163555, -3.130791, -0.032353>, <-1.166014, -3.090739, 0.008974>, <-1.169936, -3.066259, 0.047279>, 
      <-1.178620, -3.161458, -0.067224>, <-1.172410, -3.124844, -0.040714>, <-1.168546, -3.081965, 0.005307>, <-1.172469, -3.057485, 0.043612>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.132551, -3.202108, -0.008528>, <-1.122993, -3.228687, -0.024880>, <-1.111657, -3.274840, -0.030457>, <-1.109849, -3.299144, -0.052166>, 
      <-1.125402, -3.194193, -0.014848>, <-1.115844, -3.220773, -0.031200>, <-1.100424, -3.264109, -0.043955>, <-1.098616, -3.288413, -0.065664>, 
      <-1.144949, -3.181571, -0.025292>, <-1.139521, -3.207292, -0.048905>, <-1.116928, -3.240542, -0.072174>, <-1.114796, -3.266724, -0.095807>, 
      <-1.151670, -3.175640, -0.033856>, <-1.146243, -3.201361, -0.057468>, <-1.133665, -3.238997, -0.084049>, <-1.131533, -3.265179, -0.107682>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.132551, -3.202108, -0.008528>, <-1.143148, -3.172638, 0.009603>, <-1.167275, -3.135089, 0.033412>, <-1.176335, -3.114259, 0.061581>, 
      <-1.125402, -3.194193, -0.014848>, <-1.136000, -3.164724, 0.003283>, <-1.163201, -3.127846, 0.032138>, <-1.172260, -3.107016, 0.060307>, 
      <-1.144949, -3.181571, -0.025292>, <-1.150748, -3.154085, -0.000060>, <-1.163180, -3.116618, 0.026377>, <-1.169448, -3.096076, 0.057433>, 
      <-1.151670, -3.175640, -0.033856>, <-1.157470, -3.148154, -0.008623>, <-1.162635, -3.108620, 0.023845>, <-1.168903, -3.088077, 0.054902>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.175301, -3.201802, -0.012965>, <-1.172827, -3.230732, -0.031496>, <-1.179389, -3.284211, -0.028497>, <-1.178418, -3.309972, -0.051342>, 
      <-1.162698, -3.201053, -0.010344>, <-1.160224, -3.229984, -0.028875>, <-1.162451, -3.285774, -0.016479>, <-1.161480, -3.311536, -0.039324>, 
      <-1.139987, -3.210340, -0.001955>, <-1.130428, -3.236919, -0.018307>, <-1.123024, -3.285701, -0.016797>, <-1.121217, -3.310004, -0.038506>, 
      <-1.132551, -3.202108, -0.008528>, <-1.122993, -3.228687, -0.024880>, <-1.111657, -3.274840, -0.030457>, <-1.109849, -3.299144, -0.052166>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.175301, -3.201802, -0.012965>, <-1.177552, -3.175473, 0.003900>, <-1.188279, -3.149299, 0.037022>, <-1.193633, -3.132036, 0.062634>, 
      <-1.162698, -3.201053, -0.010344>, <-1.164949, -3.174725, 0.006521>, <-1.181868, -3.145551, 0.037585>, <-1.187222, -3.128288, 0.063198>, 
      <-1.139987, -3.210340, -0.001955>, <-1.150584, -3.180870, 0.016176>, <-1.170885, -3.141505, 0.034540>, <-1.179945, -3.120675, 0.062710>, 
      <-1.132551, -3.202108, -0.008528>, <-1.143148, -3.172638, 0.009603>, <-1.167275, -3.135089, 0.033412>, <-1.176335, -3.114259, 0.061581>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.221900, -3.207417, -0.027111>, <-1.222773, -3.186503, -0.001844>, <-1.215413, -3.156579, 0.030521>, <-1.218163, -3.138713, 0.057904>, 
      <-1.207721, -3.209671, -0.023925>, <-1.208594, -3.188758, 0.001342>, <-1.207938, -3.156404, 0.032587>, <-1.210688, -3.138538, 0.059970>, 
      <-1.189675, -3.202656, -0.015955>, <-1.191926, -3.176327, 0.000910>, <-1.194957, -3.153203, 0.036435>, <-1.200311, -3.135940, 0.062047>, 
      <-1.175301, -3.201802, -0.012965>, <-1.177552, -3.175473, 0.003900>, <-1.188279, -3.149299, 0.037022>, <-1.193633, -3.132036, 0.062634>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.221900, -3.207417, -0.027111>, <-1.220879, -3.231882, -0.056668>, <-1.234068, -3.313312, -0.103960>, <-1.211858, -3.289728, -0.124544>, 
      <-1.207721, -3.209671, -0.023925>, <-1.206700, -3.234137, -0.053482>, <-1.236354, -3.315496, -0.101213>, <-1.214144, -3.291912, -0.121797>, 
      <-1.189675, -3.202656, -0.015955>, <-1.187201, -3.231586, -0.034486>, <-1.199635, -3.282342, -0.042862>, <-1.198665, -3.308103, -0.065708>, 
      <-1.175301, -3.201802, -0.012965>, <-1.172827, -3.230732, -0.031496>, <-1.179389, -3.284211, -0.028497>, <-1.178418, -3.309972, -0.051342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.266064, -3.187370, -0.033362>, <-1.259878, -3.167399, -0.011933>, <-1.245772, -3.148648, 0.022425>, <-1.246195, -3.133264, 0.048106>, 
      <-1.252947, -3.192549, -0.029319>, <-1.246760, -3.172578, -0.007890>, <-1.237939, -3.151792, 0.025708>, <-1.238361, -3.136408, 0.051389>, 
      <-1.236044, -3.205168, -0.030290>, <-1.236918, -3.184254, -0.005023>, <-1.224141, -3.156783, 0.028109>, <-1.226891, -3.138917, 0.055492>, 
      <-1.221900, -3.207417, -0.027111>, <-1.222773, -3.186503, -0.001844>, <-1.215413, -3.156579, 0.030521>, <-1.218163, -3.138713, 0.057904>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.266064, -3.187370, -0.033362>, <-1.273358, -3.210916, -0.058627>, <-1.286407, -3.253641, -0.079486>, <-1.290638, -3.276736, -0.105842>, 
      <-1.252947, -3.192549, -0.029319>, <-1.260240, -3.216094, -0.054584>, <-1.265869, -3.263637, -0.070349>, <-1.270100, -3.286732, -0.096705>, 
      <-1.236044, -3.205168, -0.030290>, <-1.235023, -3.229633, -0.059847>, <-1.236327, -3.315470, -0.101245>, <-1.214117, -3.291886, -0.121829>, 
      <-1.221900, -3.207417, -0.027111>, <-1.220879, -3.231882, -0.056668>, <-1.234068, -3.313312, -0.103960>, <-1.211858, -3.289728, -0.124544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.323643, -3.167248, -0.058468>, <-1.314383, -3.151728, -0.028245>, <-1.276995, -3.133288, 0.003970>, <-1.273455, -3.116522, 0.034734>, 
      <-1.307613, -3.177038, -0.052243>, <-1.298353, -3.161518, -0.022020>, <-1.269730, -3.139473, 0.008112>, <-1.266190, -3.122707, 0.038876>, 
      <-1.283757, -3.180385, -0.038815>, <-1.277570, -3.160414, -0.017385>, <-1.254770, -3.145037, 0.018655>, <-1.255192, -3.129653, 0.044336>, 
      <-1.266064, -3.187370, -0.033362>, <-1.259878, -3.167399, -0.011933>, <-1.245772, -3.148648, 0.022425>, <-1.246195, -3.133264, 0.048106>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.323643, -3.167248, -0.058468>, <-1.334518, -3.185475, -0.093963>, <-1.364135, -3.251894, -0.158648>, <-1.339681, -3.227516, -0.181410>, 
      <-1.307613, -3.177038, -0.052243>, <-1.318489, -3.195265, -0.087738>, <-1.366963, -3.254596, -0.155250>, <-1.342509, -3.230217, -0.178012>, 
      <-1.283757, -3.180385, -0.038815>, <-1.291050, -3.203931, -0.064080>, <-1.312118, -3.241127, -0.090924>, <-1.316349, -3.264223, -0.117280>, 
      <-1.266064, -3.187370, -0.033362>, <-1.273358, -3.210916, -0.058627>, <-1.286407, -3.253641, -0.079486>, <-1.290638, -3.276736, -0.105842>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.356046, -3.132416, -0.068303>, <-1.339363, -3.114683, -0.044075>, <-1.300945, -3.106174, -0.010575>, <-1.295798, -3.091035, 0.019824>, 
      <-1.347242, -3.143255, -0.064131>, <-1.330560, -3.125522, -0.039903>, <-1.295389, -3.114705, -0.006130>, <-1.290242, -3.099566, 0.024269>, 
      <-1.335449, -3.160038, -0.063052>, <-1.326189, -3.144518, -0.032829>, <-1.284754, -3.126683, -0.000454>, <-1.281214, -3.109917, 0.030310>, 
      <-1.323643, -3.167248, -0.058468>, <-1.314383, -3.151728, -0.028245>, <-1.276995, -3.133288, 0.003970>, <-1.273455, -3.116522, 0.034734>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.356046, -3.132416, -0.068303>, <-1.374027, -3.151530, -0.094417>, <-1.398013, -3.189138, -0.119158>, <-1.409750, -3.212162, -0.145668>, 
      <-1.347242, -3.143255, -0.064131>, <-1.365223, -3.162369, -0.090245>, <-1.381357, -3.206338, -0.116972>, <-1.393094, -3.229362, -0.143481>, 
      <-1.335449, -3.160038, -0.063052>, <-1.346325, -3.178265, -0.098547>, <-1.366343, -3.254003, -0.155995>, <-1.341889, -3.229625, -0.178757>, 
      <-1.323643, -3.167248, -0.058468>, <-1.334518, -3.185475, -0.093963>, <-1.364135, -3.251894, -0.158648>, <-1.339681, -3.227516, -0.181410>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.371571, -3.108240, -0.081179>, <-1.353950, -3.098157, -0.052666>, <-1.315504, -3.076026, -0.025301>, <-1.309819, -3.060686, 0.005643>, 
      <-1.367441, -3.116098, -0.077952>, <-1.349820, -3.106015, -0.049439>, <-1.312701, -3.085740, -0.021241>, <-1.307016, -3.070399, 0.009703>, 
      <-1.361752, -3.125391, -0.071007>, <-1.345069, -3.107658, -0.046779>, <-1.306394, -3.097808, -0.014934>, <-1.301247, -3.082669, 0.015465>, 
      <-1.356046, -3.132416, -0.068303>, <-1.339363, -3.114683, -0.044075>, <-1.300945, -3.106174, -0.010575>, <-1.295798, -3.091035, 0.019824>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.371571, -3.108240, -0.081179>, <-1.391233, -3.119491, -0.112995>, <-1.454395, -3.154332, -0.170627>, <-1.432988, -3.131164, -0.193659>, 
      <-1.367441, -3.116098, -0.077952>, <-1.387103, -3.127349, -0.109768>, <-1.457066, -3.156884, -0.167417>, <-1.435659, -3.133716, -0.190449>, 
      <-1.361752, -3.125391, -0.071007>, <-1.379733, -3.144505, -0.097121>, <-1.418168, -3.168326, -0.121804>, <-1.429904, -3.191350, -0.148314>, 
      <-1.356046, -3.132416, -0.068303>, <-1.374027, -3.151530, -0.094417>, <-1.398013, -3.189138, -0.119158>, <-1.409750, -3.212162, -0.145668>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.390012, -3.067794, -0.094838>, <-1.364335, -3.054769, -0.071527>, <-1.321096, -3.044529, -0.038881>, <-1.313385, -3.030094, -0.005647>, 
      <-1.386926, -3.080999, -0.091561>, <-1.361249, -3.067974, -0.068251>, <-1.321733, -3.053891, -0.035917>, <-1.314022, -3.039456, -0.002684>, 
      <-1.377671, -3.096634, -0.085945>, <-1.360050, -3.086551, -0.057432>, <-1.318036, -3.067252, -0.028968>, <-1.312351, -3.051912, 0.001976>, 
      <-1.371571, -3.108240, -0.081179>, <-1.353950, -3.098157, -0.052666>, <-1.315504, -3.076026, -0.025301>, <-1.309819, -3.060686, 0.005643>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.390012, -3.067794, -0.094838>, <-1.414986, -3.080463, -0.117511>, <-1.459054, -3.089551, -0.144434>, <-1.480827, -3.115031, -0.157662>, 
      <-1.386926, -3.080999, -0.091561>, <-1.411900, -3.093667, -0.114235>, <-1.447728, -3.104170, -0.146441>, <-1.469501, -3.129650, -0.159669>, 
      <-1.377671, -3.096634, -0.085945>, <-1.397334, -3.107885, -0.117761>, <-1.456103, -3.155963, -0.168575>, <-1.434696, -3.132796, -0.191607>, 
      <-1.371571, -3.108240, -0.081179>, <-1.391233, -3.119491, -0.112995>, <-1.454395, -3.154332, -0.170627>, <-1.432988, -3.131164, -0.193659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.389876, -3.029923, -0.100613>, <-1.363550, -3.021377, -0.075511>, <-1.314408, -3.016795, -0.046369>, <-1.305954, -3.003914, -0.012327>, 
      <-1.399007, -3.035788, -0.096831>, <-1.372681, -3.027241, -0.071728>, <-1.318482, -3.024037, -0.045095>, <-1.310029, -3.011156, -0.011053>, 
      <-1.392554, -3.056916, -0.097537>, <-1.366878, -3.043891, -0.074227>, <-1.320552, -3.036531, -0.041413>, <-1.312841, -3.022096, -0.008179>, 
      <-1.390012, -3.067794, -0.094838>, <-1.364335, -3.054769, -0.071527>, <-1.321096, -3.044529, -0.038881>, <-1.313385, -3.030094, -0.005647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.389876, -3.029923, -0.100613>, <-1.417703, -3.038956, -0.127146>, <-1.460538, -3.034580, -0.173104>, <-1.486232, -3.062438, -0.184222>, 
      <-1.399007, -3.035788, -0.096831>, <-1.426834, -3.044821, -0.123363>, <-1.473001, -3.046487, -0.158128>, <-1.498695, -3.074346, -0.169245>, 
      <-1.392554, -3.056916, -0.097537>, <-1.417529, -3.069585, -0.120211>, <-1.469861, -3.075601, -0.142518>, <-1.491634, -3.101081, -0.155747>, 
      <-1.390012, -3.067794, -0.094838>, <-1.414986, -3.080463, -0.117511>, <-1.459054, -3.089551, -0.144434>, <-1.480827, -3.115031, -0.157662>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.389876, -3.029923, -0.100613>, <-1.417703, -3.038956, -0.127146>, <-1.460538, -3.034580, -0.173104>, <-1.486232, -3.062438, -0.184222>, 
      <-1.380523, -3.023916, -0.104487>, <-1.408350, -3.032950, -0.131020>, <-1.448258, -3.022848, -0.187860>, <-1.473953, -3.050706, -0.198978>, 
      <-1.364379, -3.039541, -0.105509>, <-1.386867, -3.052664, -0.135839>, <-1.420293, -3.031418, -0.195923>, <-1.446420, -3.058241, -0.209916>, 
      <-1.354820, -3.045192, -0.109415>, <-1.377309, -3.058315, -0.139746>, <-1.409645, -3.045162, -0.197810>, <-1.435772, -3.071985, -0.211803>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.389876, -3.029923, -0.100613>, <-1.380523, -3.023916, -0.104487>, <-1.364379, -3.039541, -0.105509>, <-1.354820, -3.045192, -0.109415>, 
      <-1.363550, -3.021377, -0.075511>, <-1.354197, -3.015370, -0.079385>, <-1.342316, -3.026667, -0.075753>, <-1.332757, -3.032318, -0.079659>, 
      <-1.314408, -3.016795, -0.046369>, <-1.310797, -3.010378, -0.047498>, <-1.301144, -3.006116, -0.049124>, <-1.294732, -3.002368, -0.048560>, 
      <-1.305954, -3.003914, -0.012327>, <-1.302344, -2.997497, -0.013456>, <-1.295064, -2.989885, -0.013946>, <-1.288652, -2.986137, -0.013382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.718426, -3.293642, -0.450932>, <-1.707606, -3.300736, -0.461943>, <-1.703486, -3.315373, -0.474755>, <-1.714279, -3.328075, -0.478045>, 
      <-1.718426, -3.293642, -0.450932>, <-1.715101, -3.300516, -0.467926>, <-1.713228, -3.306535, -0.474948>, <-1.724021, -3.319237, -0.478238>, 
      <-1.718426, -3.293642, -0.450932>, <-1.715101, -3.300516, -0.467926>, <-1.732121, -3.300678, -0.469975>, <-1.738215, -3.307850, -0.471833>, 
      <-1.718426, -3.293642, -0.450932>, <-1.725921, -3.293422, -0.456915>, <-1.740499, -3.295185, -0.461449>, <-1.746593, -3.302357, -0.463307>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.693069, -3.350912, -0.462246>, <-1.697578, -3.345600, -0.470078>, <-1.706516, -3.335118, -0.477891>, <-1.714279, -3.328075, -0.478045>, 
      <-1.678291, -3.333518, -0.457739>, <-1.682800, -3.328206, -0.465571>, <-1.695723, -3.322416, -0.474601>, <-1.703486, -3.315373, -0.474755>, 
      <-1.683936, -3.313475, -0.440199>, <-1.688334, -3.308218, -0.447751>, <-1.699637, -3.300970, -0.455583>, <-1.707606, -3.300736, -0.461943>, 
      <-1.698753, -3.303761, -0.425121>, <-1.703151, -3.298504, -0.432673>, <-1.710458, -3.293876, -0.444572>, <-1.718426, -3.293642, -0.450932>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.757192, -3.299941, -0.434375>, <-1.756407, -3.298438, -0.443491>, <-1.752498, -3.298486, -0.457298>, <-1.746593, -3.302357, -0.463307>, 
      <-1.757192, -3.299941, -0.434375>, <-1.745958, -3.286140, -0.440305>, <-1.746404, -3.291314, -0.455440>, <-1.740499, -3.295185, -0.461449>, 
      <-1.757192, -3.299941, -0.434375>, <-1.745958, -3.286140, -0.440305>, <-1.736398, -3.286554, -0.446254>, <-1.725921, -3.293422, -0.456915>, 
      <-1.757192, -3.299941, -0.434375>, <-1.746742, -3.287643, -0.431189>, <-1.728902, -3.286774, -0.440271>, <-1.718426, -3.293642, -0.450932>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.757192, -3.299941, -0.434375>, <-1.758072, -3.301627, -0.424145>, <-1.756417, -3.307044, -0.410108>, <-1.751831, -3.312389, -0.402448>, 
      <-1.746742, -3.287643, -0.431189>, <-1.747623, -3.289330, -0.420959>, <-1.742110, -3.290204, -0.405744>, <-1.737525, -3.295549, -0.398085>, 
      <-1.728902, -3.286774, -0.440271>, <-1.720934, -3.287008, -0.433910>, <-1.717495, -3.289100, -0.418076>, <-1.713098, -3.294357, -0.410524>, 
      <-1.718426, -3.293642, -0.450932>, <-1.710458, -3.293876, -0.444572>, <-1.703151, -3.298504, -0.432673>, <-1.698753, -3.303761, -0.425121>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.757192, -3.299941, -0.434375>, <-1.746742, -3.287643, -0.431189>, <-1.728902, -3.286774, -0.440271>, <-1.718426, -3.293642, -0.450932>, 
      <-1.756407, -3.298438, -0.443491>, <-1.745958, -3.286140, -0.440305>, <-1.718082, -3.293868, -0.451282>, <-1.707606, -3.300736, -0.461943>, 
      <-1.752498, -3.298486, -0.457298>, <-1.744120, -3.303978, -0.465824>, <-1.713228, -3.306535, -0.474948>, <-1.703486, -3.315373, -0.474755>, 
      <-1.746593, -3.302357, -0.463307>, <-1.738215, -3.307850, -0.471833>, <-1.724021, -3.319237, -0.478238>, <-1.714279, -3.328075, -0.478045>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.753037, -3.334375, -0.461484>, <-1.752963, -3.343815, -0.457566>, <-1.750636, -3.354378, -0.447166>, <-1.746142, -3.359540, -0.439574>, 
      <-1.763857, -3.327281, -0.450473>, <-1.763783, -3.336722, -0.446555>, <-1.765453, -3.344664, -0.432088>, <-1.760959, -3.349826, -0.424496>, 
      <-1.767985, -3.312643, -0.437665>, <-1.768865, -3.314329, -0.427435>, <-1.771195, -3.324438, -0.414615>, <-1.766609, -3.329783, -0.406955>, 
      <-1.757192, -3.299941, -0.434375>, <-1.758072, -3.301627, -0.424145>, <-1.756417, -3.307044, -0.410108>, <-1.751831, -3.312389, -0.402448>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.753037, -3.334375, -0.461484>, <-1.753109, -3.325311, -0.465246>, <-1.752827, -3.309694, -0.465208>, <-1.746593, -3.302357, -0.463307>, 
      <-1.753037, -3.334375, -0.461484>, <-1.763929, -3.318218, -0.454235>, <-1.758732, -3.305822, -0.459198>, <-1.752498, -3.298486, -0.457298>, 
      <-1.753037, -3.334375, -0.461484>, <-1.763929, -3.318218, -0.454235>, <-1.767200, -3.311140, -0.446781>, <-1.756407, -3.298438, -0.443491>, 
      <-1.753037, -3.334375, -0.461484>, <-1.763857, -3.327281, -0.450473>, <-1.767985, -3.312643, -0.437665>, <-1.757192, -3.299941, -0.434375>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.753037, -3.334375, -0.461484>, <-1.753109, -3.325311, -0.465246>, <-1.752827, -3.309694, -0.465208>, <-1.746593, -3.302357, -0.463307>, 
      <-1.763857, -3.327281, -0.450473>, <-1.763929, -3.318218, -0.454235>, <-1.746733, -3.302522, -0.463350>, <-1.740499, -3.295185, -0.461449>, 
      <-1.767985, -3.312643, -0.437665>, <-1.757535, -3.300345, -0.434480>, <-1.736398, -3.286554, -0.446254>, <-1.725921, -3.293422, -0.456915>, 
      <-1.757192, -3.299941, -0.434375>, <-1.746742, -3.287643, -0.431189>, <-1.728902, -3.286774, -0.440271>, <-1.718426, -3.293642, -0.450932>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.753037, -3.334375, -0.461484>, <-1.763857, -3.327281, -0.450473>, <-1.767985, -3.312643, -0.437665>, <-1.757192, -3.299941, -0.434375>, 
      <-1.742562, -3.341242, -0.472144>, <-1.753382, -3.334149, -0.461133>, <-1.767200, -3.311140, -0.446781>, <-1.756407, -3.298438, -0.443491>, 
      <-1.724727, -3.340371, -0.481230>, <-1.734469, -3.331533, -0.481424>, <-1.744120, -3.303978, -0.465824>, <-1.752498, -3.298486, -0.457298>, 
      <-1.714279, -3.328075, -0.478045>, <-1.724021, -3.319237, -0.478238>, <-1.738215, -3.307850, -0.471833>, <-1.746593, -3.302357, -0.463307>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.753037, -3.334375, -0.461484>, <-1.753109, -3.325311, -0.465246>, <-1.752827, -3.309694, -0.465208>, <-1.746593, -3.302357, -0.463307>, 
      <-1.753037, -3.334375, -0.461484>, <-1.742634, -3.332179, -0.475905>, <-1.744449, -3.315186, -0.473733>, <-1.738215, -3.307850, -0.471833>, 
      <-1.753037, -3.334375, -0.461484>, <-1.742634, -3.332179, -0.475905>, <-1.734469, -3.331533, -0.481424>, <-1.724021, -3.319237, -0.478238>, 
      <-1.753037, -3.334375, -0.461484>, <-1.742562, -3.341242, -0.472144>, <-1.724727, -3.340371, -0.481230>, <-1.714279, -3.328075, -0.478045>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.753037, -3.334375, -0.461484>, <-1.752963, -3.343815, -0.457566>, <-1.750636, -3.354378, -0.447166>, <-1.746142, -3.359540, -0.439574>, 
      <-1.742562, -3.341242, -0.472144>, <-1.742488, -3.350683, -0.468226>, <-1.736292, -3.363781, -0.461762>, <-1.731799, -3.368943, -0.454170>, 
      <-1.724727, -3.340371, -0.481230>, <-1.716964, -3.347414, -0.481077>, <-1.711883, -3.362438, -0.474441>, <-1.707374, -3.367750, -0.466609>, 
      <-1.714279, -3.328075, -0.478045>, <-1.706516, -3.335118, -0.477891>, <-1.697578, -3.345600, -0.470078>, <-1.693069, -3.350912, -0.462246>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.753037, -3.334375, -0.461484>, <-1.742562, -3.341242, -0.472144>, <-1.724727, -3.340371, -0.481230>, <-1.714279, -3.328075, -0.478045>, 
      <-1.753109, -3.325311, -0.465246>, <-1.742634, -3.332179, -0.475905>, <-1.713934, -3.327669, -0.477940>, <-1.703486, -3.315373, -0.474755>, 
      <-1.752827, -3.309694, -0.465208>, <-1.746733, -3.302522, -0.463350>, <-1.715101, -3.300516, -0.467926>, <-1.707606, -3.300736, -0.461943>, 
      <-1.746593, -3.302357, -0.463307>, <-1.740499, -3.295185, -0.461449>, <-1.725921, -3.293422, -0.456915>, <-1.718426, -3.293642, -0.450932>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.727489, -3.334565, -0.384760>, <-1.717215, -3.322473, -0.381627>, <-1.699672, -3.321620, -0.390553>, <-1.689371, -3.328373, -0.401035>, 
      <-1.733387, -3.335722, -0.394227>, <-1.723112, -3.323631, -0.391094>, <-1.705184, -3.322863, -0.399648>, <-1.694883, -3.329616, -0.410130>, 
      <-1.746889, -3.318149, -0.394193>, <-1.732583, -3.301310, -0.389830>, <-1.708480, -3.299876, -0.402594>, <-1.694136, -3.309280, -0.417192>, 
      <-1.751831, -3.312389, -0.402448>, <-1.737525, -3.295549, -0.398085>, <-1.713098, -3.294357, -0.410524>, <-1.698753, -3.303761, -0.425121>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.723400, -3.368422, -0.411411>, <-1.734039, -3.361448, -0.400585>, <-1.738100, -3.347053, -0.387995>, <-1.727489, -3.334565, -0.384760>, 
      <-1.729252, -3.369514, -0.420877>, <-1.739891, -3.362539, -0.410051>, <-1.743998, -3.348211, -0.397463>, <-1.733387, -3.335722, -0.394227>, 
      <-1.741226, -3.365187, -0.431269>, <-1.756044, -3.355473, -0.416190>, <-1.761667, -3.335544, -0.398700>, <-1.746889, -3.318149, -0.394193>, 
      <-1.746142, -3.359540, -0.439574>, <-1.760959, -3.349826, -0.424496>, <-1.766609, -3.329783, -0.406955>, <-1.751831, -3.312389, -0.402448>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.685293, -3.362227, -0.427696>, <-1.695566, -3.374317, -0.430828>, <-1.713100, -3.375174, -0.421891>, <-1.723400, -3.368422, -0.411411>, 
      <-1.691009, -3.363454, -0.437194>, <-1.701282, -3.375544, -0.440327>, <-1.718952, -3.376266, -0.431357>, <-1.729252, -3.369514, -0.420877>, 
      <-1.688272, -3.356564, -0.453913>, <-1.702577, -3.373402, -0.458276>, <-1.726883, -3.374590, -0.445865>, <-1.741226, -3.365187, -0.431269>, 
      <-1.693069, -3.350912, -0.462246>, <-1.707374, -3.367750, -0.466609>, <-1.731799, -3.368943, -0.454170>, <-1.746142, -3.359540, -0.439574>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.685293, -3.362227, -0.427696>, <-1.691009, -3.363454, -0.437194>, <-1.688272, -3.356564, -0.453913>, <-1.693069, -3.350912, -0.462246>, 
      <-1.674681, -3.349738, -0.424460>, <-1.680397, -3.350965, -0.433959>, <-1.673494, -3.339170, -0.449406>, <-1.678291, -3.333518, -0.457739>, 
      <-1.678731, -3.335348, -0.411861>, <-1.684243, -3.336591, -0.420956>, <-1.679319, -3.318994, -0.432270>, <-1.683936, -3.313475, -0.440199>, 
      <-1.689371, -3.328373, -0.401035>, <-1.694883, -3.329616, -0.410130>, <-1.694136, -3.309280, -0.417192>, <-1.698753, -3.303761, -0.425121>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.627979, -3.288080, -0.203637>, <-1.616313, -3.270204, -0.202548>, <-1.594365, -3.268220, -0.216565>, <-1.580753, -3.277145, -0.230417>, 
      <-1.664895, -3.329719, -0.234322>, <-1.653229, -3.311843, -0.233233>, <-1.633342, -3.307626, -0.245649>, <-1.619730, -3.316551, -0.259501>, 
      <-1.694068, -3.328005, -0.331111>, <-1.683794, -3.315914, -0.327979>, <-1.667450, -3.314352, -0.337385>, <-1.657149, -3.321105, -0.347867>, 
      <-1.727489, -3.334565, -0.384760>, <-1.717215, -3.322473, -0.381627>, <-1.699672, -3.321620, -0.390553>, <-1.689371, -3.328373, -0.401035>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.627979, -3.288080, -0.203637>, <-1.581416, -3.235559, -0.164933>, <-1.538377, -3.118975, -0.206784>, <-1.486232, -3.062438, -0.184222>, 
      <-1.616313, -3.270204, -0.202548>, <-1.569751, -3.217683, -0.163844>, <-1.526098, -3.107243, -0.221540>, <-1.473953, -3.050706, -0.198978>, 
      <-1.594365, -3.268220, -0.216565>, <-1.547306, -3.220644, -0.181450>, <-1.495814, -3.108951, -0.236370>, <-1.446420, -3.058241, -0.209916>, 
      <-1.580753, -3.277145, -0.230417>, <-1.533694, -3.229568, -0.195302>, <-1.485166, -3.122695, -0.238257>, <-1.435772, -3.071985, -0.211803>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.619051, -3.335831, -0.233993>, <-1.573424, -3.288169, -0.186264>, <-1.530036, -3.172618, -0.187559>, <-1.480827, -3.115031, -0.157662>, 
      <-1.633131, -3.326600, -0.219665>, <-1.587503, -3.278937, -0.171935>, <-1.540843, -3.158669, -0.185644>, <-1.491634, -3.101081, -0.155747>, 
      <-1.640046, -3.306570, -0.204764>, <-1.593483, -3.254049, -0.166060>, <-1.550840, -3.130882, -0.191808>, <-1.498695, -3.074346, -0.169245>, 
      <-1.627979, -3.288080, -0.203637>, <-1.581416, -3.235559, -0.164933>, <-1.538377, -3.118975, -0.206784>, <-1.486232, -3.062438, -0.184222>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.619051, -3.335831, -0.233993>, <-1.633131, -3.326600, -0.219665>, <-1.640046, -3.306570, -0.204764>, <-1.627979, -3.288080, -0.203637>, 
      <-1.654079, -3.372422, -0.270635>, <-1.668159, -3.363190, -0.256307>, <-1.676961, -3.348209, -0.235449>, <-1.664895, -3.329719, -0.234322>, 
      <-1.690683, -3.362318, -0.358488>, <-1.701322, -3.355344, -0.347662>, <-1.704679, -3.340494, -0.334347>, <-1.694068, -3.328005, -0.331111>, 
      <-1.723400, -3.368422, -0.411411>, <-1.734039, -3.361448, -0.400585>, <-1.738100, -3.347053, -0.387995>, <-1.727489, -3.334565, -0.384760>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.571831, -3.324893, -0.260775>, <-1.526616, -3.283484, -0.218834>, <-1.436875, -3.127664, -0.182310>, <-1.432988, -3.131164, -0.193659>, 
      <-1.583496, -3.342768, -0.261864>, <-1.538281, -3.301359, -0.219923>, <-1.438583, -3.129296, -0.180257>, <-1.434696, -3.132796, -0.191607>, 
      <-1.605439, -3.344755, -0.247844>, <-1.559812, -3.297093, -0.200115>, <-1.518710, -3.187237, -0.189567>, <-1.469501, -3.129650, -0.159669>, 
      <-1.619051, -3.335831, -0.233993>, <-1.573424, -3.288169, -0.186264>, <-1.530036, -3.172618, -0.187559>, <-1.480827, -3.115031, -0.157662>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.571831, -3.324893, -0.260775>, <-1.583496, -3.342768, -0.261864>, <-1.605439, -3.344755, -0.247844>, <-1.619051, -3.335831, -0.233993>, 
      <-1.609312, -3.359218, -0.295542>, <-1.620977, -3.377093, -0.296631>, <-1.640468, -3.381346, -0.284487>, <-1.654079, -3.372422, -0.270635>, 
      <-1.653736, -3.355454, -0.375256>, <-1.664009, -3.367545, -0.378388>, <-1.680383, -3.369070, -0.368968>, <-1.690683, -3.362318, -0.358488>, 
      <-1.685293, -3.362227, -0.427696>, <-1.695566, -3.374317, -0.430828>, <-1.713100, -3.375174, -0.421891>, <-1.723400, -3.368422, -0.411411>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.571831, -3.324893, -0.260775>, <-1.609312, -3.359218, -0.295542>, <-1.653736, -3.355454, -0.375256>, <-1.685293, -3.362227, -0.427696>, 
      <-1.559765, -3.306404, -0.259648>, <-1.597246, -3.340729, -0.294415>, <-1.643124, -3.342965, -0.372020>, <-1.674681, -3.349738, -0.424460>, 
      <-1.566674, -3.286376, -0.244745>, <-1.605651, -3.325782, -0.273829>, <-1.646509, -3.328080, -0.358693>, <-1.678731, -3.335348, -0.411861>, 
      <-1.580753, -3.277145, -0.230417>, <-1.619730, -3.316551, -0.259501>, <-1.657149, -3.321105, -0.347867>, <-1.689371, -3.328373, -0.401035>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.571831, -3.324893, -0.260775>, <-1.559765, -3.306404, -0.259648>, <-1.566674, -3.286376, -0.244745>, <-1.580753, -3.277145, -0.230417>, 
      <-1.526616, -3.283484, -0.218834>, <-1.514550, -3.264995, -0.217707>, <-1.519615, -3.238799, -0.209630>, <-1.533694, -3.229568, -0.195302>, 
      <-1.436875, -3.127664, -0.182310>, <-1.435169, -3.126034, -0.184361>, <-1.473848, -3.137304, -0.240263>, <-1.485166, -3.122695, -0.238257>, 
      <-1.432988, -3.131164, -0.193659>, <-1.431281, -3.129533, -0.195710>, <-1.424454, -3.086594, -0.213809>, <-1.435772, -3.071985, -0.211803>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.541342, -3.121093, -0.627344>, <-1.524507, -3.131761, -0.635250>, <-1.515459, -3.152609, -0.646511>, <-1.528043, -3.169095, -0.651949>, 
      <-1.541342, -3.121093, -0.627344>, <-1.531553, -3.132777, -0.645248>, <-1.526957, -3.141800, -0.651969>, <-1.539541, -3.158286, -0.657407>, 
      <-1.541342, -3.121093, -0.627344>, <-1.531553, -3.132777, -0.645248>, <-1.551578, -3.133702, -0.653874>, <-1.558781, -3.143139, -0.656987>, 
      <-1.541342, -3.121093, -0.627344>, <-1.548388, -3.122110, -0.637342>, <-1.564689, -3.125394, -0.647717>, <-1.571892, -3.134831, -0.650830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.508853, -3.194090, -0.620909>, <-1.511273, -3.189079, -0.632955>, <-1.518906, -3.177685, -0.647612>, <-1.528043, -3.169095, -0.651949>, 
      <-1.491620, -3.171516, -0.613464>, <-1.494040, -3.166504, -0.625510>, <-1.506321, -3.161199, -0.642174>, <-1.515459, -3.152609, -0.646511>, 
      <-1.504007, -3.142967, -0.598039>, <-1.506406, -3.137947, -0.609749>, <-1.517065, -3.130687, -0.624690>, <-1.524507, -3.131761, -0.635250>, 
      <-1.527060, -3.128360, -0.587213>, <-1.529459, -3.123341, -0.598922>, <-1.533900, -3.120019, -0.616784>, <-1.541342, -3.121093, -0.627344>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.595363, -3.126437, -0.620334>, <-1.590993, -3.126310, -0.631312>, <-1.581170, -3.128952, -0.646473>, <-1.571892, -3.134831, -0.650830>, 
      <-1.595363, -3.126437, -0.620334>, <-1.578594, -3.110067, -0.625954>, <-1.573966, -3.119515, -0.643360>, <-1.564689, -3.125394, -0.647717>, 
      <-1.595363, -3.126437, -0.620334>, <-1.578594, -3.110067, -0.625954>, <-1.564974, -3.111600, -0.629552>, <-1.548388, -3.122110, -0.637342>, 
      <-1.595363, -3.126437, -0.620334>, <-1.582965, -3.110194, -0.614977>, <-1.557928, -3.110583, -0.619555>, <-1.541342, -3.121093, -0.627344>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.595363, -3.126437, -0.620334>, <-1.600253, -3.126580, -0.608050>, <-1.603623, -3.130576, -0.589536>, <-1.601038, -3.135680, -0.577616>, 
      <-1.582965, -3.110194, -0.614977>, <-1.587855, -3.110337, -0.602693>, <-1.586643, -3.108334, -0.582200>, <-1.584058, -3.113438, -0.570280>, 
      <-1.557928, -3.110583, -0.619555>, <-1.550486, -3.109509, -0.608994>, <-1.552173, -3.108948, -0.588255>, <-1.549774, -3.113968, -0.576546>, 
      <-1.541342, -3.121093, -0.627344>, <-1.533900, -3.120019, -0.616784>, <-1.529459, -3.123341, -0.598922>, <-1.527060, -3.128360, -0.587213>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.595363, -3.126437, -0.620334>, <-1.582965, -3.110194, -0.614977>, <-1.557928, -3.110583, -0.619555>, <-1.541342, -3.121093, -0.627344>, 
      <-1.590993, -3.126310, -0.631312>, <-1.578594, -3.110067, -0.625954>, <-1.541093, -3.121250, -0.627461>, <-1.524507, -3.131761, -0.635250>, 
      <-1.581170, -3.128952, -0.646473>, <-1.568059, -3.137260, -0.652630>, <-1.526957, -3.141800, -0.651969>, <-1.515459, -3.152609, -0.646511>, 
      <-1.571892, -3.134831, -0.650830>, <-1.558781, -3.143139, -0.656987>, <-1.539541, -3.158286, -0.657407>, <-1.528043, -3.169095, -0.651949>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.582065, -3.174441, -0.644941>, <-1.583874, -3.185455, -0.638403>, <-1.585322, -3.196541, -0.623028>, <-1.582827, -3.201411, -0.611307>, 
      <-1.598901, -3.163773, -0.637035>, <-1.600710, -3.174787, -0.630497>, <-1.608375, -3.181934, -0.612202>, <-1.605880, -3.186804, -0.600481>, 
      <-1.607948, -3.142924, -0.625772>, <-1.612838, -3.143066, -0.613488>, <-1.620856, -3.153150, -0.596982>, <-1.618271, -3.158254, -0.585062>, 
      <-1.595363, -3.126437, -0.620334>, <-1.600253, -3.126580, -0.608050>, <-1.603623, -3.130576, -0.589536>, <-1.601038, -3.135680, -0.577616>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.582065, -3.174441, -0.644941>, <-1.580332, -3.163887, -0.651206>, <-1.579167, -3.144361, -0.653974>, <-1.571892, -3.134831, -0.650830>, 
      <-1.582065, -3.174441, -0.644941>, <-1.597167, -3.153219, -0.643300>, <-1.588445, -3.138483, -0.649617>, <-1.581170, -3.128952, -0.646473>, 
      <-1.582065, -3.174441, -0.644941>, <-1.597167, -3.153219, -0.643300>, <-1.603578, -3.142796, -0.636750>, <-1.590993, -3.126310, -0.631312>, 
      <-1.582065, -3.174441, -0.644941>, <-1.598901, -3.163773, -0.637035>, <-1.607948, -3.142924, -0.625772>, <-1.595363, -3.126437, -0.620334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.582065, -3.174441, -0.644941>, <-1.580332, -3.163887, -0.651206>, <-1.579167, -3.144361, -0.653974>, <-1.571892, -3.134831, -0.650830>, 
      <-1.598901, -3.163773, -0.637035>, <-1.597167, -3.153219, -0.643300>, <-1.571964, -3.134925, -0.650861>, <-1.564689, -3.125394, -0.647717>, 
      <-1.607948, -3.142924, -0.625772>, <-1.595550, -3.126681, -0.620415>, <-1.564974, -3.111600, -0.629552>, <-1.548388, -3.122110, -0.637342>, 
      <-1.595363, -3.126437, -0.620334>, <-1.582965, -3.110194, -0.614977>, <-1.557928, -3.110583, -0.619555>, <-1.541342, -3.121093, -0.627344>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.582065, -3.174441, -0.644941>, <-1.598901, -3.163773, -0.637035>, <-1.607948, -3.142924, -0.625772>, <-1.595363, -3.126437, -0.620334>, 
      <-1.565478, -3.184951, -0.652730>, <-1.582314, -3.174283, -0.644824>, <-1.603578, -3.142796, -0.636750>, <-1.590993, -3.126310, -0.631312>, 
      <-1.540442, -3.185338, -0.657307>, <-1.551940, -3.174529, -0.662764>, <-1.568059, -3.137260, -0.652630>, <-1.581170, -3.128952, -0.646473>, 
      <-1.528043, -3.169095, -0.651949>, <-1.539541, -3.158286, -0.657407>, <-1.558781, -3.143139, -0.656987>, <-1.571892, -3.134831, -0.650830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.582065, -3.174441, -0.644941>, <-1.580332, -3.163887, -0.651206>, <-1.579167, -3.144361, -0.653974>, <-1.571892, -3.134831, -0.650830>, 
      <-1.582065, -3.174441, -0.644941>, <-1.563745, -3.174397, -0.658995>, <-1.566056, -3.152669, -0.660131>, <-1.558781, -3.143139, -0.656987>, 
      <-1.582065, -3.174441, -0.644941>, <-1.563745, -3.174397, -0.658995>, <-1.551940, -3.174529, -0.662764>, <-1.539541, -3.158286, -0.657407>, 
      <-1.582065, -3.174441, -0.644941>, <-1.565478, -3.184951, -0.652730>, <-1.540442, -3.185338, -0.657307>, <-1.528043, -3.169095, -0.651949>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.582065, -3.174441, -0.644941>, <-1.583874, -3.185455, -0.638403>, <-1.585322, -3.196541, -0.623028>, <-1.582827, -3.201411, -0.611307>, 
      <-1.565478, -3.184951, -0.652730>, <-1.567287, -3.195965, -0.646192>, <-1.562609, -3.210932, -0.633695>, <-1.560114, -3.215802, -0.621974>, 
      <-1.540442, -3.185338, -0.657307>, <-1.531304, -3.193927, -0.652970>, <-1.528252, -3.211320, -0.640291>, <-1.525832, -3.216331, -0.628245>, 
      <-1.528043, -3.169095, -0.651949>, <-1.518906, -3.177685, -0.647612>, <-1.511273, -3.189079, -0.632955>, <-1.508853, -3.194090, -0.620909>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.582065, -3.174441, -0.644941>, <-1.565478, -3.184951, -0.652730>, <-1.540442, -3.185338, -0.657307>, <-1.528043, -3.169095, -0.651949>, 
      <-1.580332, -3.163887, -0.651206>, <-1.563745, -3.174397, -0.658995>, <-1.527857, -3.168852, -0.651869>, <-1.515459, -3.152609, -0.646511>, 
      <-1.579167, -3.144361, -0.653974>, <-1.571964, -3.134925, -0.650861>, <-1.531553, -3.132777, -0.645248>, <-1.524507, -3.131761, -0.635250>, 
      <-1.571892, -3.134831, -0.650830>, <-1.564689, -3.125394, -0.647717>, <-1.548388, -3.122110, -0.637342>, <-1.541342, -3.121093, -0.627344>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.578651, -3.159432, -0.543274>, <-1.566460, -3.143461, -0.538007>, <-1.541843, -3.143843, -0.542508>, <-1.525533, -3.154177, -0.550167>, 
      <-1.582066, -3.148770, -0.552031>, <-1.569875, -3.132798, -0.546764>, <-1.544923, -3.133495, -0.550702>, <-1.528613, -3.143829, -0.558361>, 
      <-1.598259, -3.141167, -0.564802>, <-1.581279, -3.118924, -0.557466>, <-1.547266, -3.119216, -0.564303>, <-1.524552, -3.133608, -0.574970>, 
      <-1.601038, -3.135680, -0.577616>, <-1.584058, -3.113438, -0.570280>, <-1.549774, -3.113968, -0.576546>, <-1.527060, -3.128360, -0.587213>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.565572, -3.206631, -0.567465>, <-1.582126, -3.196143, -0.559691>, <-1.591025, -3.175642, -0.548620>, <-1.578651, -3.159432, -0.543274>, 
      <-1.568971, -3.196222, -0.576539>, <-1.585524, -3.185734, -0.568766>, <-1.594440, -3.164980, -0.557377>, <-1.582066, -3.148770, -0.552031>, 
      <-1.580084, -3.206765, -0.598421>, <-1.603137, -3.192158, -0.587595>, <-1.615492, -3.163741, -0.572248>, <-1.598259, -3.141167, -0.564802>, 
      <-1.582827, -3.201411, -0.611307>, <-1.605880, -3.186804, -0.600481>, <-1.618271, -3.158254, -0.585062>, <-1.601038, -3.135680, -0.577616>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.512458, -3.201372, -0.574359>, <-1.524648, -3.217342, -0.579626>, <-1.549263, -3.216964, -0.575124>, <-1.565572, -3.206631, -0.567465>, 
      <-1.515668, -3.190813, -0.583257>, <-1.527858, -3.206784, -0.588524>, <-1.552662, -3.206555, -0.584198>, <-1.568971, -3.196222, -0.576539>, 
      <-1.506268, -3.199443, -0.608040>, <-1.523247, -3.221685, -0.615375>, <-1.557371, -3.221156, -0.609088>, <-1.580084, -3.206765, -0.598421>, 
      <-1.508853, -3.194090, -0.620909>, <-1.525832, -3.216331, -0.628245>, <-1.560114, -3.215802, -0.621974>, <-1.582827, -3.201411, -0.611307>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.512458, -3.201372, -0.574359>, <-1.515668, -3.190813, -0.583257>, <-1.506268, -3.199443, -0.608040>, <-1.508853, -3.194090, -0.620909>, 
      <-1.500085, -3.185163, -0.569014>, <-1.503295, -3.174604, -0.577912>, <-1.489035, -3.176869, -0.600594>, <-1.491620, -3.171516, -0.613464>, 
      <-1.508981, -3.164665, -0.557940>, <-1.512061, -3.154317, -0.566134>, <-1.501499, -3.148215, -0.585797>, <-1.504007, -3.142967, -0.598039>, 
      <-1.525533, -3.154177, -0.550167>, <-1.528613, -3.143829, -0.558361>, <-1.524552, -3.133608, -0.574970>, <-1.527060, -3.128360, -0.587213>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.527711, -3.364614, -0.389587>, <-1.512733, -3.341662, -0.388189>, <-1.480871, -3.341920, -0.397379>, <-1.459324, -3.355918, -0.407016>, 
      <-1.557784, -3.370450, -0.461766>, <-1.542805, -3.347498, -0.460369>, <-1.516076, -3.341258, -0.465657>, <-1.494529, -3.355255, -0.475295>, 
      <-1.559812, -3.218250, -0.494965>, <-1.547620, -3.202279, -0.489698>, <-1.524384, -3.202494, -0.496064>, <-1.508075, -3.212828, -0.503723>, 
      <-1.578651, -3.159432, -0.543274>, <-1.566460, -3.143461, -0.538007>, <-1.541843, -3.143843, -0.542508>, <-1.525533, -3.154177, -0.550167>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.527711, -3.364614, -0.389587>, <-1.490990, -3.357488, -0.301450>, <-1.427978, -3.135675, -0.208287>, <-1.432988, -3.131164, -0.193659>, 
      <-1.512733, -3.341662, -0.388189>, <-1.476012, -3.334535, -0.300052>, <-1.425575, -3.133379, -0.211175>, <-1.430585, -3.128869, -0.196547>, 
      <-1.480871, -3.341920, -0.397379>, <-1.440118, -3.342687, -0.318339>, <-1.403482, -3.196783, -0.275666>, <-1.370594, -3.138713, -0.216888>, 
      <-1.459324, -3.355918, -0.407016>, <-1.418571, -3.356685, -0.327977>, <-1.385353, -3.215504, -0.273287>, <-1.352465, -3.157434, -0.214508>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.508017, -3.430533, -0.411560>, <-1.470820, -3.431853, -0.310871>, <-1.443782, -3.278921, -0.222536>, <-1.409750, -3.212162, -0.145668>, 
      <-1.529902, -3.416316, -0.401772>, <-1.492705, -3.417636, -0.301082>, <-1.463936, -3.258109, -0.225182>, <-1.429904, -3.191350, -0.148314>, 
      <-1.542924, -3.387926, -0.391007>, <-1.506203, -3.380800, -0.302870>, <-1.430649, -3.138227, -0.205078>, <-1.435659, -3.133716, -0.190449>, 
      <-1.527711, -3.364614, -0.389587>, <-1.490990, -3.357488, -0.301450>, <-1.427978, -3.135675, -0.208287>, <-1.432988, -3.131164, -0.193659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.508017, -3.430533, -0.411560>, <-1.529902, -3.416316, -0.401772>, <-1.542924, -3.387926, -0.391007>, <-1.527711, -3.364614, -0.389587>, 
      <-1.537003, -3.429504, -0.490022>, <-1.558888, -3.415287, -0.480234>, <-1.572997, -3.393762, -0.463186>, <-1.557784, -3.370450, -0.461766>, 
      <-1.545581, -3.267858, -0.514088>, <-1.562135, -3.257370, -0.506314>, <-1.572185, -3.234461, -0.500311>, <-1.559812, -3.218250, -0.494965>, 
      <-1.565572, -3.206631, -0.567465>, <-1.582126, -3.196143, -0.559691>, <-1.591025, -3.175642, -0.548620>, <-1.578651, -3.159432, -0.543274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.439624, -3.421837, -0.428985>, <-1.399824, -3.427860, -0.338467>, <-1.353947, -3.218951, -0.182342>, <-1.339681, -3.227516, -0.181410>, 
      <-1.454603, -3.444791, -0.430383>, <-1.414803, -3.450813, -0.339865>, <-1.356155, -3.221061, -0.179689>, <-1.341889, -3.229625, -0.178757>, 
      <-1.486468, -3.444532, -0.421198>, <-1.449271, -3.445852, -0.320509>, <-1.427126, -3.296121, -0.220349>, <-1.393094, -3.229362, -0.143481>, 
      <-1.508017, -3.430533, -0.411560>, <-1.470820, -3.431853, -0.310871>, <-1.443782, -3.278921, -0.222536>, <-1.409750, -3.212162, -0.145668>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.439624, -3.421837, -0.428985>, <-1.454603, -3.444791, -0.430383>, <-1.486468, -3.444532, -0.421198>, <-1.508017, -3.430533, -0.411560>, 
      <-1.472641, -3.416841, -0.504077>, <-1.487621, -3.439795, -0.505475>, <-1.515454, -3.443503, -0.499661>, <-1.537003, -3.429504, -0.490022>, 
      <-1.493851, -3.262583, -0.522776>, <-1.506042, -3.278554, -0.528042>, <-1.529272, -3.278191, -0.521746>, <-1.545581, -3.267858, -0.514088>, 
      <-1.512458, -3.201372, -0.574359>, <-1.524648, -3.217342, -0.579626>, <-1.549263, -3.216964, -0.575124>, <-1.565572, -3.206631, -0.567465>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.439624, -3.421837, -0.428985>, <-1.472641, -3.416841, -0.504077>, <-1.493851, -3.262583, -0.522776>, <-1.512458, -3.201372, -0.574359>, 
      <-1.424411, -3.398525, -0.427565>, <-1.457428, -3.393529, -0.502657>, <-1.481479, -3.246374, -0.517430>, <-1.500085, -3.185163, -0.569014>, 
      <-1.437439, -3.370135, -0.416805>, <-1.472643, -3.369472, -0.485083>, <-1.491522, -3.223316, -0.511496>, <-1.508981, -3.164665, -0.557940>, 
      <-1.459324, -3.355918, -0.407016>, <-1.494529, -3.355255, -0.475295>, <-1.508075, -3.212828, -0.503723>, <-1.525533, -3.154177, -0.550167>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.439624, -3.421837, -0.428985>, <-1.424411, -3.398525, -0.427565>, <-1.437439, -3.370135, -0.416805>, <-1.459324, -3.355918, -0.407016>, 
      <-1.399824, -3.427860, -0.338467>, <-1.384610, -3.404547, -0.337047>, <-1.396685, -3.370902, -0.337765>, <-1.418571, -3.356685, -0.327977>, 
      <-1.353947, -3.218951, -0.182342>, <-1.351784, -3.216884, -0.184942>, <-1.369027, -3.232363, -0.271143>, <-1.385353, -3.215504, -0.273287>, 
      <-1.339681, -3.227516, -0.181410>, <-1.337517, -3.225449, -0.184010>, <-1.336139, -3.174293, -0.212365>, <-1.352465, -3.157434, -0.214508>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.300021, -3.282429, -0.643577>, <-1.283791, -3.292823, -0.646685>, <-1.274158, -3.313018, -0.653069>, <-1.284956, -3.328441, -0.658232>, 
      <-1.300021, -3.282429, -0.643577>, <-1.288536, -3.294843, -0.656706>, <-1.283427, -3.303857, -0.661026>, <-1.294225, -3.319281, -0.666189>, 
      <-1.300021, -3.282429, -0.643577>, <-1.288536, -3.294843, -0.656706>, <-1.305158, -3.296684, -0.667648>, <-1.311391, -3.305587, -0.670629>, 
      <-1.300021, -3.282429, -0.643577>, <-1.304766, -3.284449, -0.653597>, <-1.317852, -3.288555, -0.665217>, <-1.324085, -3.297458, -0.668198>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.273317, -3.347631, -0.624615>, <-1.273387, -3.344414, -0.636307>, <-1.277595, -3.335716, -0.651913>, <-1.284956, -3.328441, -0.658232>, 
      <-1.258531, -3.326511, -0.617544>, <-1.258601, -3.323294, -0.629235>, <-1.266797, -3.320292, -0.646749>, <-1.274158, -3.313018, -0.653069>, 
      <-1.271717, -3.298859, -0.608800>, <-1.271824, -3.295592, -0.620211>, <-1.278793, -3.290695, -0.636132>, <-1.283791, -3.292823, -0.646685>, 
      <-1.293942, -3.284625, -0.604544>, <-1.294048, -3.281358, -0.615954>, <-1.295023, -3.280301, -0.633023>, <-1.300021, -3.282429, -0.643577>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.350242, -3.286631, -0.645729>, <-1.344449, -3.287693, -0.654833>, <-1.333099, -3.291685, -0.666472>, <-1.324085, -3.297458, -0.668198>, 
      <-1.350242, -3.286631, -0.645729>, <-1.333681, -3.272313, -0.649684>, <-1.326866, -3.282782, -0.663491>, <-1.317852, -3.288555, -0.665217>, 
      <-1.350242, -3.286631, -0.645729>, <-1.333681, -3.272313, -0.649684>, <-1.320951, -3.274084, -0.650498>, <-1.304766, -3.284449, -0.653597>, 
      <-1.350242, -3.286631, -0.645729>, <-1.339475, -3.271251, -0.640580>, <-1.316206, -3.272064, -0.640477>, <-1.300021, -3.282429, -0.643577>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.350242, -3.286631, -0.645729>, <-1.356716, -3.285444, -0.635555>, <-1.362954, -3.287053, -0.619145>, <-1.362715, -3.290376, -0.607494>, 
      <-1.339475, -3.271251, -0.640580>, <-1.345949, -3.270064, -0.630406>, <-1.348209, -3.265992, -0.612093>, <-1.347970, -3.269315, -0.600442>, 
      <-1.316206, -3.272064, -0.640477>, <-1.311208, -3.269936, -0.629924>, <-1.316212, -3.267164, -0.611710>, <-1.316105, -3.270431, -0.600299>, 
      <-1.300021, -3.282429, -0.643577>, <-1.295023, -3.280301, -0.633023>, <-1.294048, -3.281358, -0.615954>, <-1.293942, -3.284625, -0.604544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.350242, -3.286631, -0.645729>, <-1.339475, -3.271251, -0.640580>, <-1.316206, -3.272064, -0.640477>, <-1.300021, -3.282429, -0.643577>, 
      <-1.344449, -3.287693, -0.654833>, <-1.333681, -3.272313, -0.649684>, <-1.299975, -3.282458, -0.643586>, <-1.283791, -3.292823, -0.646685>, 
      <-1.333099, -3.291685, -0.666472>, <-1.320405, -3.299814, -0.668903>, <-1.283427, -3.303857, -0.661026>, <-1.274158, -3.313018, -0.653069>, 
      <-1.324085, -3.297458, -0.668198>, <-1.311391, -3.305587, -0.670629>, <-1.294225, -3.319281, -0.666189>, <-1.284956, -3.328441, -0.658232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.335176, -3.332643, -0.660388>, <-1.338157, -3.341906, -0.653659>, <-1.342277, -3.350259, -0.638975>, <-1.342081, -3.353386, -0.627566>, 
      <-1.351407, -3.322248, -0.657280>, <-1.354387, -3.331511, -0.650550>, <-1.364504, -3.336024, -0.634718>, <-1.364308, -3.339151, -0.623309>, 
      <-1.361040, -3.302055, -0.650893>, <-1.367515, -3.300868, -0.640719>, <-1.377741, -3.308175, -0.626216>, <-1.377502, -3.311497, -0.614566>, 
      <-1.350242, -3.286631, -0.645729>, <-1.356716, -3.285444, -0.635555>, <-1.362954, -3.287053, -0.619145>, <-1.362715, -3.290376, -0.607494>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.335176, -3.332643, -0.660388>, <-1.332326, -3.323786, -0.666823>, <-1.330342, -3.306395, -0.671190>, <-1.324085, -3.297458, -0.668198>, 
      <-1.335176, -3.332643, -0.660388>, <-1.348557, -3.313391, -0.663714>, <-1.339356, -3.300622, -0.669464>, <-1.333099, -3.291685, -0.666472>, 
      <-1.335176, -3.332643, -0.660388>, <-1.348557, -3.313391, -0.663714>, <-1.355247, -3.303117, -0.659996>, <-1.344449, -3.287693, -0.654833>, 
      <-1.335176, -3.332643, -0.660388>, <-1.351407, -3.322248, -0.657280>, <-1.361040, -3.302055, -0.650893>, <-1.350242, -3.286631, -0.645729>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.335176, -3.332643, -0.660388>, <-1.332326, -3.323786, -0.666823>, <-1.330342, -3.306395, -0.671190>, <-1.324085, -3.297458, -0.668198>, 
      <-1.351407, -3.322248, -0.657280>, <-1.348557, -3.313391, -0.663714>, <-1.324109, -3.297492, -0.668210>, <-1.317852, -3.288555, -0.665217>, 
      <-1.361040, -3.302055, -0.650893>, <-1.350273, -3.286675, -0.645744>, <-1.320951, -3.274084, -0.650498>, <-1.304766, -3.284449, -0.653597>, 
      <-1.350242, -3.286631, -0.645729>, <-1.339475, -3.271251, -0.640580>, <-1.316206, -3.272064, -0.640477>, <-1.300021, -3.282429, -0.643577>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.335176, -3.332643, -0.660388>, <-1.351407, -3.322248, -0.657280>, <-1.361040, -3.302055, -0.650893>, <-1.350242, -3.286631, -0.645729>, 
      <-1.318991, -3.343008, -0.663488>, <-1.335222, -3.332613, -0.660379>, <-1.355247, -3.303117, -0.659996>, <-1.344449, -3.287693, -0.654833>, 
      <-1.295723, -3.343821, -0.663381>, <-1.304992, -3.334660, -0.671338>, <-1.320405, -3.299814, -0.668903>, <-1.333099, -3.291685, -0.666472>, 
      <-1.284956, -3.328441, -0.658232>, <-1.294225, -3.319281, -0.666189>, <-1.311391, -3.305587, -0.670629>, <-1.324085, -3.297458, -0.668198>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.335176, -3.332643, -0.660388>, <-1.332326, -3.323786, -0.666823>, <-1.330342, -3.306395, -0.671190>, <-1.324085, -3.297458, -0.668198>, 
      <-1.335176, -3.332643, -0.660388>, <-1.316141, -3.334151, -0.669922>, <-1.317648, -3.314525, -0.673621>, <-1.311391, -3.305587, -0.670629>, 
      <-1.335176, -3.332643, -0.660388>, <-1.316141, -3.334151, -0.669922>, <-1.304992, -3.334660, -0.671338>, <-1.294225, -3.319281, -0.666189>, 
      <-1.335176, -3.332643, -0.660388>, <-1.318991, -3.343008, -0.663488>, <-1.295723, -3.343821, -0.663381>, <-1.284956, -3.328441, -0.658232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.335176, -3.332643, -0.660388>, <-1.338157, -3.341906, -0.653659>, <-1.342277, -3.350259, -0.638975>, <-1.342081, -3.353386, -0.627566>, 
      <-1.318991, -3.343008, -0.663488>, <-1.321972, -3.352271, -0.656758>, <-1.320116, -3.364452, -0.643219>, <-1.319920, -3.367578, -0.631810>, 
      <-1.295723, -3.343821, -0.663381>, <-1.288362, -3.351095, -0.657061>, <-1.288130, -3.365472, -0.643357>, <-1.288060, -3.368690, -0.631666>, 
      <-1.284956, -3.328441, -0.658232>, <-1.277595, -3.335716, -0.651913>, <-1.273387, -3.344414, -0.636307>, <-1.273317, -3.347631, -0.624615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.335176, -3.332643, -0.660388>, <-1.318991, -3.343008, -0.663488>, <-1.295723, -3.343821, -0.663381>, <-1.284956, -3.328441, -0.658232>, 
      <-1.332326, -3.323786, -0.666823>, <-1.316141, -3.334151, -0.669922>, <-1.284925, -3.328397, -0.658217>, <-1.274158, -3.313018, -0.653069>, 
      <-1.330342, -3.306395, -0.671190>, <-1.324109, -3.297492, -0.668210>, <-1.288536, -3.294843, -0.656706>, <-1.283791, -3.292823, -0.646685>, 
      <-1.324085, -3.297458, -0.668198>, <-1.317852, -3.288555, -0.665217>, <-1.304766, -3.284449, -0.653597>, <-1.300021, -3.282429, -0.643577>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.348699, -3.308079, -0.570524>, <-1.338113, -3.292956, -0.565461>, <-1.315233, -3.293757, -0.565359>, <-1.299319, -3.303949, -0.568407>, 
      <-1.349304, -3.298884, -0.579689>, <-1.338718, -3.283762, -0.574626>, <-1.315641, -3.284805, -0.573928>, <-1.299728, -3.294996, -0.576975>, 
      <-1.362459, -3.293939, -0.594999>, <-1.347714, -3.272878, -0.587947>, <-1.315994, -3.273843, -0.588380>, <-1.293831, -3.288038, -0.592624>, 
      <-1.362715, -3.290376, -0.607494>, <-1.347970, -3.269315, -0.600442>, <-1.316105, -3.270431, -0.600299>, <-1.293942, -3.284625, -0.604544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.333881, -3.353322, -0.584935>, <-1.349841, -3.343101, -0.581879>, <-1.359316, -3.323246, -0.575601>, <-1.348699, -3.308079, -0.570524>, 
      <-1.334462, -3.344403, -0.594407>, <-1.350421, -3.334182, -0.591351>, <-1.359921, -3.314051, -0.584766>, <-1.349304, -3.298884, -0.579689>, 
      <-1.341865, -3.356828, -0.615007>, <-1.364092, -3.342593, -0.610750>, <-1.377246, -3.315061, -0.602070>, <-1.362459, -3.293939, -0.594999>, 
      <-1.342081, -3.353386, -0.627566>, <-1.364308, -3.339151, -0.623309>, <-1.377502, -3.311497, -0.614566>, <-1.362715, -3.290376, -0.607494>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.284503, -3.349192, -0.582818>, <-1.295089, -3.364314, -0.587880>, <-1.317968, -3.363513, -0.587982>, <-1.333881, -3.353322, -0.584935>, 
      <-1.284910, -3.340114, -0.592099>, <-1.295495, -3.355236, -0.597161>, <-1.318548, -3.354594, -0.597455>, <-1.334462, -3.344403, -0.594407>, 
      <-1.273242, -3.351077, -0.612092>, <-1.287985, -3.372136, -0.619143>, <-1.319705, -3.371020, -0.619251>, <-1.341865, -3.356828, -0.615007>, 
      <-1.273317, -3.347631, -0.624615>, <-1.288060, -3.368690, -0.631666>, <-1.319920, -3.367578, -0.631810>, <-1.342081, -3.353386, -0.627566>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.284503, -3.349192, -0.582818>, <-1.284910, -3.340114, -0.592099>, <-1.273242, -3.351077, -0.612092>, <-1.273317, -3.347631, -0.624615>, 
      <-1.273886, -3.334025, -0.577741>, <-1.274293, -3.324947, -0.587022>, <-1.258456, -3.329957, -0.605021>, <-1.258531, -3.326511, -0.617544>, 
      <-1.283360, -3.314170, -0.571463>, <-1.283768, -3.305217, -0.580032>, <-1.271606, -3.302271, -0.596881>, <-1.271717, -3.298859, -0.608800>, 
      <-1.299319, -3.303949, -0.568407>, <-1.299728, -3.294996, -0.576975>, <-1.293831, -3.288038, -0.592624>, <-1.293942, -3.284625, -0.604544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.350550, -3.475310, -0.423165>, <-1.336744, -3.454154, -0.421876>, <-1.306567, -3.455172, -0.424748>, <-1.285537, -3.468772, -0.428303>, 
      <-1.352067, -3.488864, -0.488629>, <-1.338261, -3.467708, -0.487340>, <-1.316228, -3.467392, -0.487883>, <-1.295198, -3.480992, -0.491438>, 
      <-1.345587, -3.355389, -0.523369>, <-1.335001, -3.340266, -0.518306>, <-1.313090, -3.340711, -0.520421>, <-1.297176, -3.350903, -0.523469>, 
      <-1.348699, -3.308079, -0.570524>, <-1.338113, -3.292956, -0.565461>, <-1.315233, -3.293757, -0.565359>, <-1.299319, -3.303949, -0.568407>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.350550, -3.475310, -0.423165>, <-1.348193, -3.454249, -0.321441>, <-1.324717, -3.236499, -0.180432>, <-1.339681, -3.227516, -0.181410>, 
      <-1.336744, -3.454154, -0.421876>, <-1.334386, -3.433093, -0.320152>, <-1.321900, -3.233808, -0.183818>, <-1.336864, -3.224824, -0.184796>, 
      <-1.306567, -3.455172, -0.424748>, <-1.290609, -3.434988, -0.320468>, <-1.279959, -3.289047, -0.255547>, <-1.263795, -3.214152, -0.180276>, 
      <-1.285537, -3.468772, -0.428303>, <-1.269579, -3.448588, -0.324023>, <-1.254344, -3.301513, -0.244152>, <-1.238180, -3.226619, -0.168880>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.330127, -3.537099, -0.432467>, <-1.318953, -3.517309, -0.308667>, <-1.305724, -3.359092, -0.199825>, <-1.290638, -3.276736, -0.105842>, 
      <-1.351220, -3.523458, -0.428901>, <-1.340045, -3.503668, -0.305101>, <-1.331435, -3.346578, -0.211263>, <-1.316349, -3.264223, -0.117280>, 
      <-1.364398, -3.496529, -0.424458>, <-1.362040, -3.475468, -0.322734>, <-1.327545, -3.239201, -0.177034>, <-1.342509, -3.230217, -0.178012>, 
      <-1.350550, -3.475310, -0.423165>, <-1.348193, -3.454249, -0.321441>, <-1.324717, -3.236499, -0.180432>, <-1.339681, -3.227516, -0.181410>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.330127, -3.537099, -0.432467>, <-1.351220, -3.523458, -0.428901>, <-1.364398, -3.496529, -0.424458>, <-1.350550, -3.475310, -0.423165>, 
      <-1.336488, -3.548364, -0.502935>, <-1.357580, -3.534723, -0.499369>, <-1.365915, -3.510083, -0.489922>, <-1.352067, -3.488864, -0.488629>, 
      <-1.330688, -3.402390, -0.532826>, <-1.346648, -3.392168, -0.529770>, <-1.356204, -3.370556, -0.528446>, <-1.345587, -3.355389, -0.523369>, 
      <-1.333881, -3.353322, -0.584935>, <-1.349841, -3.343101, -0.581879>, <-1.359316, -3.323246, -0.575601>, <-1.348699, -3.308079, -0.570524>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.265123, -3.530556, -0.437607>, <-1.246555, -3.515357, -0.320474>, <-1.228257, -3.280064, -0.131047>, <-1.211858, -3.289728, -0.124544>, 
      <-1.278928, -3.551710, -0.438896>, <-1.260360, -3.536511, -0.321763>, <-1.230516, -3.282222, -0.128333>, <-1.214117, -3.291886, -0.121829>, 
      <-1.309100, -3.550697, -0.436022>, <-1.297926, -3.530907, -0.312222>, <-1.285186, -3.369088, -0.190688>, <-1.270100, -3.286732, -0.096705>, 
      <-1.330127, -3.537099, -0.432467>, <-1.318953, -3.517309, -0.308667>, <-1.305724, -3.359092, -0.199825>, <-1.290638, -3.276736, -0.105842>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.265123, -3.530556, -0.437607>, <-1.278928, -3.551710, -0.438896>, <-1.309100, -3.550697, -0.436022>, <-1.330127, -3.537099, -0.432467>, 
      <-1.275985, -3.539447, -0.506126>, <-1.289789, -3.560600, -0.507416>, <-1.315460, -3.561962, -0.506490>, <-1.336488, -3.548364, -0.502935>, 
      <-1.282313, -3.398076, -0.532843>, <-1.292899, -3.413198, -0.537905>, <-1.314775, -3.412581, -0.535874>, <-1.330688, -3.402390, -0.532826>, 
      <-1.284503, -3.349192, -0.582818>, <-1.295089, -3.364314, -0.587880>, <-1.317968, -3.363513, -0.587982>, <-1.333881, -3.353322, -0.584935>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.265123, -3.530556, -0.437607>, <-1.275985, -3.539447, -0.506126>, <-1.282313, -3.398076, -0.532843>, <-1.284503, -3.349192, -0.582818>, 
      <-1.251277, -3.509339, -0.436314>, <-1.262139, -3.518230, -0.504833>, <-1.271696, -3.382909, -0.527766>, <-1.273886, -3.334025, -0.577741>, 
      <-1.264447, -3.482411, -0.431868>, <-1.274108, -3.494631, -0.495003>, <-1.281216, -3.361124, -0.526525>, <-1.283360, -3.314170, -0.571463>, 
      <-1.285537, -3.468772, -0.428303>, <-1.295198, -3.480992, -0.491438>, <-1.297176, -3.350903, -0.523469>, <-1.299319, -3.303949, -0.568407>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.265123, -3.530556, -0.437607>, <-1.251277, -3.509339, -0.436314>, <-1.264447, -3.482411, -0.431868>, <-1.285537, -3.468772, -0.428303>, 
      <-1.246555, -3.515357, -0.320474>, <-1.232709, -3.494140, -0.319181>, <-1.248489, -3.462227, -0.327589>, <-1.269579, -3.448588, -0.324023>, 
      <-1.228257, -3.280064, -0.131047>, <-1.226012, -3.277920, -0.133745>, <-1.233934, -3.311447, -0.235071>, <-1.254344, -3.301513, -0.244152>, 
      <-1.211858, -3.289728, -0.124544>, <-1.209613, -3.287583, -0.127242>, <-1.217770, -3.236553, -0.159800>, <-1.238180, -3.226619, -0.168880>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.066140, -3.441805, -0.581876>, <-1.051669, -3.451180, -0.580212>, <-1.042503, -3.469841, -0.581452>, <-1.051378, -3.483985, -0.586061>, 
      <-1.066140, -3.441805, -0.581876>, <-1.053988, -3.454223, -0.589546>, <-1.048883, -3.462815, -0.591224>, <-1.057759, -3.476960, -0.595833>, 
      <-1.066140, -3.441805, -0.581876>, <-1.053988, -3.454223, -0.589546>, <-1.066472, -3.457308, -0.601924>, <-1.071641, -3.465546, -0.604608>, 
      <-1.066140, -3.441805, -0.581876>, <-1.068459, -3.444848, -0.591211>, <-1.077851, -3.449936, -0.603233>, <-1.083020, -3.458173, -0.605917>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.048096, -3.496628, -0.552430>, <-1.045840, -3.495252, -0.562926>, <-1.046308, -3.489567, -0.578297>, <-1.051378, -3.483985, -0.586061>, 
      <-1.035944, -3.477260, -0.546118>, <-1.033688, -3.475884, -0.556615>, <-1.037433, -3.475423, -0.573687>, <-1.042503, -3.469841, -0.581452>, 
      <-1.048496, -3.451709, -0.544421>, <-1.046322, -3.450252, -0.554702>, <-1.049231, -3.447980, -0.570395>, <-1.051669, -3.451180, -0.580212>, 
      <-1.068311, -3.438871, -0.546701>, <-1.066136, -3.437414, -0.556982>, <-1.063702, -3.438605, -0.572059>, <-1.066140, -3.441805, -0.581876>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.110003, -3.446003, -0.592804>, <-1.103205, -3.448035, -0.599437>, <-1.091134, -3.452916, -0.606850>, <-1.083020, -3.458173, -0.605917>, 
      <-1.110003, -3.446003, -0.592804>, <-1.094228, -3.433729, -0.594775>, <-1.085965, -3.444679, -0.604166>, <-1.077851, -3.449936, -0.603233>, 
      <-1.110003, -3.446003, -0.592804>, <-1.094228, -3.433729, -0.594775>, <-1.083095, -3.435365, -0.592894>, <-1.068459, -3.444848, -0.591211>, 
      <-1.110003, -3.446003, -0.592804>, <-1.101026, -3.431697, -0.588142>, <-1.080777, -3.432322, -0.583560>, <-1.066140, -3.441805, -0.581876>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.110003, -3.446003, -0.592804>, <-1.117600, -3.443732, -0.585392>, <-1.126263, -3.443138, -0.572210>, <-1.128373, -3.444616, -0.561666>, 
      <-1.101026, -3.431697, -0.588142>, <-1.108623, -3.429426, -0.580730>, <-1.113971, -3.423548, -0.565826>, <-1.116082, -3.425026, -0.555282>, 
      <-1.080777, -3.432322, -0.583560>, <-1.078338, -3.429122, -0.573743>, <-1.086178, -3.424430, -0.559288>, <-1.088353, -3.425886, -0.549007>, 
      <-1.066140, -3.441805, -0.581876>, <-1.063702, -3.438605, -0.572059>, <-1.066136, -3.437414, -0.556982>, <-1.068311, -3.438871, -0.546701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.110003, -3.446003, -0.592804>, <-1.101026, -3.431697, -0.588142>, <-1.080777, -3.432322, -0.583560>, <-1.066140, -3.441805, -0.581876>, 
      <-1.103205, -3.448035, -0.599437>, <-1.094228, -3.433729, -0.594775>, <-1.066306, -3.441698, -0.581895>, <-1.051669, -3.451180, -0.580212>, 
      <-1.091134, -3.452916, -0.606850>, <-1.079754, -3.460289, -0.605541>, <-1.048883, -3.462815, -0.591224>, <-1.042503, -3.469841, -0.581452>, 
      <-1.083020, -3.458173, -0.605917>, <-1.071641, -3.465546, -0.604608>, <-1.057759, -3.476960, -0.595833>, <-1.051378, -3.483985, -0.586061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.095240, -3.488181, -0.596989>, <-1.099409, -3.495513, -0.590599>, <-1.106061, -3.501040, -0.577681>, <-1.108155, -3.502374, -0.567395>, 
      <-1.109710, -3.478806, -0.598653>, <-1.113879, -3.486138, -0.592264>, <-1.125876, -3.488202, -0.579961>, <-1.127970, -3.489536, -0.569675>, 
      <-1.118878, -3.460147, -0.597413>, <-1.126475, -3.457876, -0.590001>, <-1.138415, -3.462506, -0.578521>, <-1.140526, -3.463984, -0.567978>, 
      <-1.110003, -3.446003, -0.592804>, <-1.117600, -3.443732, -0.585392>, <-1.126263, -3.443138, -0.572210>, <-1.128373, -3.444616, -0.561666>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.095240, -3.488181, -0.596989>, <-1.091267, -3.481195, -0.603078>, <-1.088186, -3.466406, -0.608600>, <-1.083020, -3.458173, -0.605917>, 
      <-1.095240, -3.488181, -0.596989>, <-1.105738, -3.471820, -0.604742>, <-1.096299, -3.461149, -0.609533>, <-1.091134, -3.452916, -0.606850>, 
      <-1.095240, -3.488181, -0.596989>, <-1.105738, -3.471820, -0.604742>, <-1.112080, -3.462179, -0.604046>, <-1.103205, -3.448035, -0.599437>, 
      <-1.095240, -3.488181, -0.596989>, <-1.109710, -3.478806, -0.598653>, <-1.118878, -3.460147, -0.597413>, <-1.110003, -3.446003, -0.592804>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.095240, -3.488181, -0.596989>, <-1.091267, -3.481195, -0.603078>, <-1.088186, -3.466406, -0.608600>, <-1.083020, -3.458173, -0.605917>, 
      <-1.109710, -3.478806, -0.598653>, <-1.105738, -3.471820, -0.604742>, <-1.083017, -3.458168, -0.605916>, <-1.077851, -3.449936, -0.603233>, 
      <-1.118878, -3.460147, -0.597413>, <-1.109901, -3.445840, -0.592751>, <-1.083095, -3.435365, -0.592894>, <-1.068459, -3.444848, -0.591211>, 
      <-1.110003, -3.446003, -0.592804>, <-1.101026, -3.431697, -0.588142>, <-1.080777, -3.432322, -0.583560>, <-1.066140, -3.441805, -0.581876>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.095240, -3.488181, -0.596989>, <-1.109710, -3.478806, -0.598653>, <-1.118878, -3.460147, -0.597413>, <-1.110003, -3.446003, -0.592804>, 
      <-1.080604, -3.497664, -0.595306>, <-1.095074, -3.488288, -0.596970>, <-1.112080, -3.462179, -0.604046>, <-1.103205, -3.448035, -0.599437>, 
      <-1.060355, -3.498291, -0.590723>, <-1.066735, -3.491265, -0.600495>, <-1.079754, -3.460289, -0.605541>, <-1.091134, -3.452916, -0.606850>, 
      <-1.051378, -3.483985, -0.586061>, <-1.057759, -3.476960, -0.595833>, <-1.071641, -3.465546, -0.604608>, <-1.083020, -3.458173, -0.605917>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.095240, -3.488181, -0.596989>, <-1.091267, -3.481195, -0.603078>, <-1.088186, -3.466406, -0.608600>, <-1.083020, -3.458173, -0.605917>, 
      <-1.095240, -3.488181, -0.596989>, <-1.076631, -3.490677, -0.601394>, <-1.076806, -3.473778, -0.607291>, <-1.071641, -3.465546, -0.604608>, 
      <-1.095240, -3.488181, -0.596989>, <-1.076631, -3.490677, -0.601394>, <-1.066735, -3.491265, -0.600495>, <-1.057759, -3.476960, -0.595833>, 
      <-1.095240, -3.488181, -0.596989>, <-1.080604, -3.497664, -0.595306>, <-1.060355, -3.498291, -0.590723>, <-1.051378, -3.483985, -0.586061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.095240, -3.488181, -0.596989>, <-1.099409, -3.495513, -0.590599>, <-1.106061, -3.501040, -0.577681>, <-1.108155, -3.502374, -0.567395>, 
      <-1.080604, -3.497664, -0.595306>, <-1.084773, -3.504995, -0.588916>, <-1.086021, -3.514024, -0.575375>, <-1.088114, -3.515358, -0.565089>, 
      <-1.060355, -3.498291, -0.590723>, <-1.055285, -3.503873, -0.582959>, <-1.058131, -3.514841, -0.569310>, <-1.060387, -3.516217, -0.558814>, 
      <-1.051378, -3.483985, -0.586061>, <-1.046308, -3.489567, -0.578297>, <-1.045840, -3.495252, -0.562926>, <-1.048096, -3.496628, -0.552430>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.095240, -3.488181, -0.596989>, <-1.080604, -3.497664, -0.595306>, <-1.060355, -3.498291, -0.590723>, <-1.051378, -3.483985, -0.586061>, 
      <-1.091267, -3.481195, -0.603078>, <-1.076631, -3.490677, -0.601394>, <-1.051479, -3.484146, -0.586114>, <-1.042503, -3.469841, -0.581452>, 
      <-1.088186, -3.466406, -0.608600>, <-1.083017, -3.458168, -0.605916>, <-1.053988, -3.454223, -0.589546>, <-1.051669, -3.451180, -0.580212>, 
      <-1.083020, -3.458173, -0.605917>, <-1.077851, -3.449936, -0.603233>, <-1.068459, -3.444848, -0.591211>, <-1.066140, -3.441805, -0.581876>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.123601, -3.455526, -0.524868>, <-1.114774, -3.441460, -0.520284>, <-1.094863, -3.442078, -0.515777>, <-1.080471, -3.451403, -0.514122>, 
      <-1.120970, -3.448125, -0.533408>, <-1.112144, -3.434058, -0.528824>, <-1.092191, -3.434831, -0.523734>, <-1.077799, -3.444156, -0.522079>, 
      <-1.130629, -3.446196, -0.550395>, <-1.118338, -3.426606, -0.544011>, <-1.090626, -3.427408, -0.538261>, <-1.070584, -3.440393, -0.535955>, 
      <-1.128373, -3.444616, -0.561666>, <-1.116082, -3.425026, -0.555282>, <-1.088353, -3.425886, -0.549007>, <-1.068311, -3.438871, -0.546701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.109083, -3.497001, -0.528983>, <-1.123312, -3.487782, -0.530619>, <-1.132328, -3.469434, -0.529401>, <-1.123601, -3.455526, -0.524868>, 
      <-1.106418, -3.489900, -0.537812>, <-1.120646, -3.480681, -0.539448>, <-1.129697, -3.462033, -0.537941>, <-1.120970, -3.448125, -0.533408>, 
      <-1.110458, -3.503842, -0.556081>, <-1.130273, -3.491003, -0.558361>, <-1.142782, -3.465564, -0.556706>, <-1.130629, -3.446196, -0.550395>, 
      <-1.108155, -3.502374, -0.567395>, <-1.127970, -3.489536, -0.569675>, <-1.140526, -3.463984, -0.567978>, <-1.128373, -3.444616, -0.561666>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.065953, -3.492879, -0.518239>, <-1.074780, -3.506946, -0.522824>, <-1.094692, -3.506326, -0.527328>, <-1.109083, -3.497001, -0.528983>, 
      <-1.063127, -3.485610, -0.526862>, <-1.071954, -3.499677, -0.531447>, <-1.092026, -3.499225, -0.536157>, <-1.106418, -3.489900, -0.537812>, 
      <-1.050519, -3.498106, -0.541155>, <-1.062810, -3.517696, -0.547539>, <-1.090417, -3.516826, -0.553775>, <-1.110458, -3.503842, -0.556081>, 
      <-1.048096, -3.496628, -0.552430>, <-1.060387, -3.516217, -0.558814>, <-1.088114, -3.515358, -0.565089>, <-1.108155, -3.502374, -0.567395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.065953, -3.492879, -0.518239>, <-1.063127, -3.485610, -0.526862>, <-1.050519, -3.498106, -0.541155>, <-1.048096, -3.496628, -0.552430>, 
      <-1.057226, -3.478971, -0.513706>, <-1.054400, -3.471702, -0.522329>, <-1.038367, -3.478738, -0.534844>, <-1.035944, -3.477260, -0.546118>, 
      <-1.066242, -3.460622, -0.512486>, <-1.063570, -3.453376, -0.520443>, <-1.050769, -3.453231, -0.533675>, <-1.048496, -3.451709, -0.544421>, 
      <-1.080471, -3.451403, -0.514122>, <-1.077799, -3.444156, -0.522079>, <-1.070584, -3.440393, -0.535955>, <-1.068311, -3.438871, -0.546701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.177315, -3.582302, -0.402785>, <-1.164885, -3.563254, -0.401625>, <-1.138056, -3.564209, -0.398266>, <-1.119031, -3.576451, -0.395648>, 
      <-1.166297, -3.603001, -0.452762>, <-1.153866, -3.583953, -0.451603>, <-1.132046, -3.586125, -0.446099>, <-1.113022, -3.598367, -0.443481>, 
      <-1.136117, -3.490738, -0.484236>, <-1.127291, -3.476672, -0.479651>, <-1.107621, -3.476687, -0.477779>, <-1.093230, -3.486012, -0.476124>, 
      <-1.123601, -3.455526, -0.524868>, <-1.114774, -3.441460, -0.520284>, <-1.094863, -3.442078, -0.515777>, <-1.080471, -3.451403, -0.514122>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.177315, -3.582302, -0.402785>, <-1.201579, -3.536721, -0.292728>, <-1.195185, -3.299554, -0.117932>, <-1.211858, -3.289728, -0.124544>, 
      <-1.164885, -3.563254, -0.401625>, <-1.189148, -3.517673, -0.291568>, <-1.192825, -3.297299, -0.120768>, <-1.209498, -3.287473, -0.127380>, 
      <-1.138056, -3.564209, -0.398266>, <-1.152498, -3.511538, -0.283311>, <-1.144755, -3.357551, -0.207633>, <-1.152434, -3.263250, -0.122512>, 
      <-1.119031, -3.576451, -0.395648>, <-1.133473, -3.523780, -0.280693>, <-1.123854, -3.359480, -0.192803>, <-1.131533, -3.265179, -0.107682>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.158886, -3.637522, -0.399366>, <-1.178107, -3.585673, -0.266952>, <-1.174375, -3.417291, -0.146513>, <-1.178418, -3.309972, -0.051342>, 
      <-1.177686, -3.625424, -0.401953>, <-1.196908, -3.573575, -0.269540>, <-1.194622, -3.415422, -0.160879>, <-1.198665, -3.308103, -0.065708>, 
      <-1.189599, -3.601125, -0.403931>, <-1.213862, -3.555544, -0.293874>, <-1.197471, -3.301738, -0.115185>, <-1.214144, -3.291912, -0.121797>, 
      <-1.177315, -3.582302, -0.402785>, <-1.201579, -3.536721, -0.292728>, <-1.195185, -3.299554, -0.117932>, <-1.211858, -3.289728, -0.124544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.158886, -3.637522, -0.399366>, <-1.177686, -3.625424, -0.401953>, <-1.189599, -3.601125, -0.403931>, <-1.177315, -3.582302, -0.402785>, 
      <-1.150947, -3.658936, -0.454055>, <-1.169748, -3.646838, -0.456642>, <-1.178581, -3.621824, -0.453908>, <-1.166297, -3.603001, -0.452762>, 
      <-1.122656, -3.533158, -0.484029>, <-1.136884, -3.523939, -0.485665>, <-1.144844, -3.504646, -0.488768>, <-1.136117, -3.490738, -0.484236>, 
      <-1.109083, -3.497001, -0.528983>, <-1.123312, -3.487782, -0.530619>, <-1.132328, -3.469434, -0.529401>, <-1.123601, -3.455526, -0.524868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.100600, -3.631668, -0.392227>, <-1.112965, -3.577096, -0.260941>, <-1.101944, -3.405415, -0.147091>, <-1.109849, -3.299144, -0.052166>, 
      <-1.113031, -3.650716, -0.393387>, <-1.125396, -3.596144, -0.262101>, <-1.113312, -3.416276, -0.133432>, <-1.121217, -3.310004, -0.038506>, 
      <-1.139860, -3.649765, -0.396748>, <-1.159082, -3.597916, -0.264334>, <-1.157437, -3.418854, -0.134495>, <-1.161480, -3.311536, -0.039324>, 
      <-1.158886, -3.637522, -0.399366>, <-1.178107, -3.585673, -0.266952>, <-1.174375, -3.417291, -0.146513>, <-1.178418, -3.309972, -0.051342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.100600, -3.631668, -0.392227>, <-1.113031, -3.650716, -0.393387>, <-1.139860, -3.649765, -0.396748>, <-1.158886, -3.637522, -0.399366>, 
      <-1.095645, -3.653537, -0.444838>, <-1.108076, -3.672586, -0.445998>, <-1.131922, -3.671179, -0.451436>, <-1.150947, -3.658936, -0.454055>, 
      <-1.079854, -3.528633, -0.475823>, <-1.088681, -3.542700, -0.480407>, <-1.108264, -3.542483, -0.482374>, <-1.122656, -3.533158, -0.484029>, 
      <-1.065953, -3.492879, -0.518239>, <-1.074780, -3.506946, -0.522824>, <-1.094692, -3.506326, -0.527328>, <-1.109083, -3.497001, -0.528983>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.100600, -3.631668, -0.392227>, <-1.095645, -3.653537, -0.444838>, <-1.079854, -3.528633, -0.475823>, <-1.065953, -3.492879, -0.518239>, 
      <-1.088317, -3.612846, -0.391081>, <-1.083362, -3.634715, -0.443692>, <-1.071127, -3.514725, -0.471290>, <-1.057226, -3.478971, -0.513706>, 
      <-1.100231, -3.588549, -0.393061>, <-1.094222, -3.610465, -0.440893>, <-1.079001, -3.495231, -0.474488>, <-1.066242, -3.460622, -0.512486>, 
      <-1.119031, -3.576451, -0.395648>, <-1.113022, -3.598367, -0.443481>, <-1.093230, -3.486012, -0.476124>, <-1.080471, -3.451403, -0.514122>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.100600, -3.631668, -0.392227>, <-1.088317, -3.612846, -0.391081>, <-1.100231, -3.588549, -0.393061>, <-1.119031, -3.576451, -0.395648>, 
      <-1.112965, -3.577096, -0.260941>, <-1.100681, -3.558274, -0.259795>, <-1.114673, -3.535878, -0.278106>, <-1.133473, -3.523780, -0.280693>, 
      <-1.101944, -3.405415, -0.147091>, <-1.090712, -3.394684, -0.160589>, <-1.107117, -3.361025, -0.180928>, <-1.123854, -3.359480, -0.192803>, 
      <-1.109849, -3.299144, -0.052166>, <-1.098616, -3.288413, -0.065664>, <-1.114796, -3.266724, -0.095807>, <-1.131533, -3.265179, -0.107682>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.375451, -3.032475, 0.633677>, <1.361592, -3.018557, 0.509203>, <1.312261, -2.996830, 0.345609>, <1.291306, -3.014098, 0.222555>, 
      <1.311169, -3.066284, 0.636240>, <1.297310, -3.052366, 0.511767>, <1.291236, -3.017787, 0.354663>, <1.270280, -3.035055, 0.231609>, 
      <1.231005, -3.028676, 0.632986>, <1.228039, -3.016378, 0.516818>, <1.234360, -3.009591, 0.358835>, <1.229591, -3.039444, 0.245959>, 
      <1.200543, -2.962712, 0.634590>, <1.197577, -2.950414, 0.518422>, <1.219982, -2.982203, 0.361367>, <1.215213, -3.012056, 0.248491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.433097, -2.840401, 0.625316>, <1.403615, -2.856412, 0.497013>, <1.338865, -2.881532, 0.332205>, <1.313715, -2.913876, 0.206076>, 
      <1.465565, -2.910710, 0.623606>, <1.436083, -2.926721, 0.495304>, <1.357461, -2.916955, 0.328930>, <1.332312, -2.949299, 0.202800>, 
      <1.443967, -2.996439, 0.630945>, <1.430108, -2.982521, 0.506471>, <1.339455, -2.969725, 0.333899>, <1.318500, -2.986993, 0.210845>, 
      <1.375451, -3.032475, 0.633677>, <1.361592, -3.018557, 0.509203>, <1.312261, -2.996830, 0.345609>, <1.291306, -3.014098, 0.222555>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.249881, -2.760558, 0.640289>, <1.243033, -2.790472, 0.513271>, <1.245604, -2.864945, 0.353719>, <1.237620, -2.911836, 0.232011>, 
      <1.318296, -2.724575, 0.637561>, <1.311448, -2.754489, 0.510543>, <1.266630, -2.843987, 0.344665>, <1.258646, -2.890879, 0.222957>, 
      <1.400677, -2.770195, 0.627023>, <1.371194, -2.786206, 0.498720>, <1.324486, -2.854144, 0.334738>, <1.299336, -2.886487, 0.208609>, 
      <1.433097, -2.840401, 0.625316>, <1.403615, -2.856412, 0.497013>, <1.338865, -2.881532, 0.332205>, <1.313715, -2.913876, 0.206076>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.249881, -2.760558, 0.640289>, <1.178821, -2.797932, 0.643123>, <1.166869, -2.889792, 0.636363>, <1.200543, -2.962712, 0.634590>, 
      <1.243033, -2.790472, 0.513271>, <1.171973, -2.827846, 0.516105>, <1.163903, -2.877494, 0.520195>, <1.197577, -2.950414, 0.518422>, 
      <1.245604, -2.864945, 0.353719>, <1.218410, -2.892050, 0.365429>, <1.201386, -2.946781, 0.364643>, <1.219982, -2.982203, 0.361367>, 
      <1.237620, -2.911836, 0.232011>, <1.210426, -2.938941, 0.243721>, <1.196617, -2.976634, 0.251767>, <1.215213, -3.012056, 0.248491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.393749, -3.116980, 1.142641>, <1.381071, -3.100785, 0.989136>, <1.392484, -3.049581, 0.786661>, <1.375451, -3.032475, 0.633677>, 
      <1.358836, -3.158114, 1.176503>, <1.346158, -3.141919, 1.022998>, <1.328202, -3.083390, 0.789224>, <1.311169, -3.066284, 0.636240>, 
      <1.253518, -3.150487, 1.131166>, <1.260480, -3.127682, 0.988769>, <1.234669, -3.043871, 0.776517>, <1.231005, -3.028676, 0.632986>, 
      <1.236797, -3.101560, 1.093962>, <1.243758, -3.078755, 0.951565>, <1.204207, -2.977907, 0.778121>, <1.200543, -2.962712, 0.634590>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.466537, -2.830884, 0.871141>, <1.457151, -2.823594, 0.797614>, <1.449655, -2.831409, 0.697375>, <1.433097, -2.840401, 0.625316>, 
      <1.507170, -2.949778, 0.961547>, <1.497784, -2.942488, 0.888020>, <1.482123, -2.901718, 0.695665>, <1.465565, -2.910710, 0.623606>, 
      <1.478589, -3.017023, 1.060356>, <1.465911, -3.000828, 0.906851>, <1.461000, -3.013546, 0.783929>, <1.443967, -2.996439, 0.630945>, 
      <1.393749, -3.116980, 1.142641>, <1.381071, -3.100785, 0.989136>, <1.392484, -3.049581, 0.786661>, <1.375451, -3.032475, 0.633677>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.272125, -2.761103, 0.872035>, <1.267933, -2.771068, 0.803033>, <1.253541, -2.744569, 0.708179>, <1.249881, -2.760558, 0.640289>, 
      <1.315818, -2.709624, 0.829658>, <1.311627, -2.719589, 0.760656>, <1.321956, -2.708586, 0.705451>, <1.318296, -2.724575, 0.637561>, 
      <1.445611, -2.769652, 0.824581>, <1.436225, -2.762363, 0.751054>, <1.417235, -2.761204, 0.699082>, <1.400677, -2.770195, 0.627023>, 
      <1.466537, -2.830884, 0.871141>, <1.457151, -2.823594, 0.797614>, <1.449655, -2.831409, 0.697375>, <1.433097, -2.840401, 0.625316>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.272125, -2.761103, 0.872035>, <1.185834, -2.862770, 0.955727>, <1.195469, -2.980633, 1.002010>, <1.236797, -3.101560, 1.093962>, 
      <1.267933, -2.771068, 0.803033>, <1.181642, -2.872735, 0.886725>, <1.202431, -2.957828, 0.859613>, <1.243758, -3.078755, 0.951565>, 
      <1.253541, -2.744569, 0.708179>, <1.182481, -2.781943, 0.711013>, <1.170533, -2.904987, 0.779894>, <1.204207, -2.977907, 0.778121>, 
      <1.249881, -2.760558, 0.640289>, <1.178821, -2.797932, 0.643123>, <1.166869, -2.889792, 0.636363>, <1.200543, -2.962712, 0.634590>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.432389, -3.105213, 1.323107>, <1.430598, -3.103436, 1.267685>, <1.398290, -3.122782, 1.197629>, <1.393749, -3.116980, 1.142641>, 
      <1.345300, -3.151000, 1.360988>, <1.343509, -3.149224, 1.305566>, <1.363377, -3.163916, 1.231491>, <1.358836, -3.158114, 1.176503>, 
      <1.197349, -3.180311, 1.381134>, <1.216924, -3.196464, 1.298863>, <1.249367, -3.164086, 1.216080>, <1.253518, -3.150487, 1.131166>, 
      <1.164546, -3.080634, 1.370916>, <1.184120, -3.096787, 1.288645>, <1.232646, -3.115159, 1.178876>, <1.236797, -3.101560, 1.093962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.509143, -2.899462, 1.221028>, <1.502602, -2.897481, 1.113521>, <1.480112, -2.841427, 0.977485>, <1.466537, -2.830884, 0.871141>, 
      <1.538222, -2.987822, 1.230086>, <1.531681, -2.985841, 1.122578>, <1.520745, -2.960321, 1.067891>, <1.507170, -2.949778, 0.961547>, 
      <1.509590, -3.064625, 1.289527>, <1.507799, -3.062848, 1.234105>, <1.483130, -3.022825, 1.115344>, <1.478589, -3.017023, 1.060356>, 
      <1.432389, -3.105213, 1.323107>, <1.430598, -3.103436, 1.267685>, <1.398290, -3.122782, 1.197629>, <1.393749, -3.116980, 1.142641>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.288641, -2.668414, 1.278331>, <1.295360, -2.672050, 1.153446>, <1.279634, -2.743252, 0.995646>, <1.272125, -2.761103, 0.872035>, 
      <1.392083, -2.614029, 1.233337>, <1.398803, -2.617666, 1.108452>, <1.323328, -2.691773, 0.953268>, <1.315818, -2.709624, 0.829658>, 
      <1.470180, -2.781068, 1.208892>, <1.463640, -2.779088, 1.101384>, <1.459186, -2.780196, 0.930925>, <1.445611, -2.769652, 0.824581>, 
      <1.509143, -2.899462, 1.221028>, <1.502602, -2.897481, 1.113521>, <1.480112, -2.841427, 0.977485>, <1.466537, -2.830884, 0.871141>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.288641, -2.668414, 1.278331>, <1.148265, -2.742217, 1.339390>, <1.111672, -2.919968, 1.354446>, <1.164546, -3.080634, 1.370916>, 
      <1.295360, -2.672050, 1.153446>, <1.154984, -2.745853, 1.214505>, <1.131246, -2.936121, 1.272175>, <1.184120, -3.096787, 1.288645>, 
      <1.279634, -2.743252, 0.995646>, <1.193343, -2.844918, 1.079338>, <1.191318, -2.994232, 1.086924>, <1.232646, -3.115159, 1.178876>, 
      <1.272125, -2.761103, 0.872035>, <1.185834, -2.862770, 0.955727>, <1.195469, -2.980633, 1.002010>, <1.236797, -3.101560, 1.093962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.406691, -3.129815, 1.543059>, <1.415737, -3.116750, 1.478132>, <1.434547, -3.107353, 1.389881>, <1.432389, -3.105213, 1.323107>, 
      <1.310618, -3.181651, 1.520673>, <1.319664, -3.168586, 1.455746>, <1.347458, -3.153141, 1.427762>, <1.345300, -3.151000, 1.360988>, 
      <1.197322, -3.133840, 1.462104>, <1.203238, -3.131467, 1.436882>, <1.191435, -3.175431, 1.405993>, <1.197349, -3.180311, 1.381134>, 
      <1.153835, -3.033100, 1.442648>, <1.159751, -3.030727, 1.417426>, <1.158631, -3.075753, 1.395775>, <1.164546, -3.080634, 1.370916>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.506304, -2.842927, 1.524778>, <1.515960, -2.840381, 1.432624>, <1.514771, -2.901166, 1.313535>, <1.509143, -2.899462, 1.221028>, 
      <1.552124, -2.949074, 1.545278>, <1.561781, -2.946527, 1.453123>, <1.543850, -2.989526, 1.322593>, <1.538222, -2.987822, 1.230086>, 
      <1.507920, -3.075197, 1.566647>, <1.516967, -3.062133, 1.501720>, <1.511748, -3.066765, 1.356301>, <1.509590, -3.064625, 1.289527>, 
      <1.406691, -3.129815, 1.543059>, <1.415737, -3.116750, 1.478132>, <1.434547, -3.107353, 1.389881>, <1.432389, -3.105213, 1.323107>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.240032, -2.743736, 1.468497>, <1.254677, -2.728002, 1.409202>, <1.285254, -2.666581, 1.341284>, <1.288641, -2.668414, 1.278331>, 
      <1.336413, -2.691734, 1.490955>, <1.351058, -2.676000, 1.431660>, <1.388696, -2.612196, 1.296290>, <1.392083, -2.614029, 1.233337>, 
      <1.462678, -2.741864, 1.505260>, <1.472334, -2.739318, 1.413106>, <1.475808, -2.782773, 1.301399>, <1.470180, -2.781068, 1.208892>, 
      <1.506304, -2.842927, 1.524778>, <1.515960, -2.840381, 1.432624>, <1.514771, -2.901166, 1.313535>, <1.509143, -2.899462, 1.221028>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.240032, -2.743736, 1.468497>, <1.139204, -2.798137, 1.445003>, <1.108196, -2.927374, 1.422230>, <1.153835, -3.033100, 1.442648>, 
      <1.254677, -2.728002, 1.409202>, <1.153849, -2.782403, 1.385708>, <1.114113, -2.925000, 1.397008>, <1.159751, -3.030727, 1.417426>, 
      <1.285254, -2.666581, 1.341284>, <1.144878, -2.740384, 1.402343>, <1.105757, -2.915087, 1.379305>, <1.158631, -3.075753, 1.395775>, 
      <1.288641, -2.668414, 1.278331>, <1.148265, -2.742217, 1.339390>, <1.111672, -2.919968, 1.354446>, <1.164546, -3.080634, 1.370916>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.358910, -3.211331, 1.850479>, <1.410267, -3.194062, 1.770645>, <1.393633, -3.148673, 1.636777>, <1.406691, -3.129815, 1.543059>, 
      <1.257618, -3.266475, 1.814936>, <1.308975, -3.249207, 1.735102>, <1.297560, -3.200509, 1.614390>, <1.310618, -3.181651, 1.520673>, 
      <1.123431, -3.225527, 1.792821>, <1.177607, -3.197440, 1.696293>, <1.171350, -3.144258, 1.572821>, <1.197322, -3.133840, 1.462104>, 
      <1.063475, -3.121176, 1.801789>, <1.117650, -3.093090, 1.705261>, <1.127864, -3.043518, 1.553366>, <1.153835, -3.033100, 1.442648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.434644, -2.919107, 1.932031>, <1.504876, -2.894636, 1.830149>, <1.493164, -2.846392, 1.650184>, <1.506304, -2.842927, 1.524778>, 
      <1.494600, -3.023458, 1.923063>, <1.564833, -2.998987, 1.821181>, <1.538984, -2.952539, 1.670684>, <1.552124, -2.949074, 1.545278>, 
      <1.460202, -3.156186, 1.886022>, <1.511559, -3.138918, 1.806188>, <1.494863, -3.094055, 1.660365>, <1.507920, -3.075197, 1.566647>, 
      <1.358910, -3.211331, 1.850479>, <1.410267, -3.194062, 1.770645>, <1.393633, -3.148673, 1.636777>, <1.406691, -3.129815, 1.543059>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.139209, -2.828953, 1.883341>, <1.207630, -2.794022, 1.777721>, <1.209706, -2.776317, 1.591281>, <1.240032, -2.743736, 1.468497>, 
      <1.240501, -2.773808, 1.918884>, <1.308921, -2.738878, 1.813264>, <1.306086, -2.724315, 1.613739>, <1.336413, -2.691734, 1.490955>, 
      <1.374688, -2.814756, 1.940999>, <1.444920, -2.790285, 1.839117>, <1.449538, -2.745329, 1.630667>, <1.462678, -2.741864, 1.505260>, 
      <1.434644, -2.919107, 1.932031>, <1.504876, -2.894636, 1.830149>, <1.493164, -2.846392, 1.650184>, <1.506304, -2.842927, 1.524778>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.139209, -2.828953, 1.883341>, <1.037917, -2.884098, 1.847798>, <1.003519, -3.016825, 1.810757>, <1.063475, -3.121176, 1.801789>, 
      <1.207630, -2.794022, 1.777721>, <1.106338, -2.849167, 1.742178>, <1.057694, -2.988739, 1.714229>, <1.117650, -3.093090, 1.705261>, 
      <1.209706, -2.776317, 1.591281>, <1.108877, -2.830718, 1.567787>, <1.082225, -2.937791, 1.532947>, <1.127864, -3.043518, 1.553366>, 
      <1.240032, -2.743736, 1.468497>, <1.139204, -2.798137, 1.445003>, <1.108196, -2.927374, 1.422230>, <1.153835, -3.033100, 1.442648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.939652, -3.286856, 2.269070>, <1.065429, -3.264198, 2.143493>, <1.263539, -3.243399, 1.998732>, <1.358910, -3.211331, 1.850479>, 
      <0.906692, -3.332721, 2.186093>, <1.032469, -3.310064, 2.060516>, <1.162248, -3.298543, 1.963189>, <1.257618, -3.266475, 1.814936>, 
      <0.847353, -3.298663, 2.089794>, <0.923693, -3.271454, 2.013215>, <1.070536, -3.252950, 1.887069>, <1.123431, -3.225527, 1.792821>, 
      <0.809006, -3.211872, 2.057053>, <0.885347, -3.184663, 1.980474>, <1.010579, -3.148599, 1.896037>, <1.063475, -3.121176, 1.801789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.929783, -3.043807, 2.361106>, <1.081241, -3.006397, 2.232383>, <1.322031, -2.958345, 2.095393>, <1.434644, -2.919107, 1.932031>, 
      <0.968129, -3.130597, 2.393847>, <1.119587, -3.093187, 2.265125>, <1.381987, -3.062696, 2.086425>, <1.494600, -3.023458, 1.923063>, 
      <0.972612, -3.240991, 2.352046>, <1.098389, -3.218333, 2.226469>, <1.364831, -3.188254, 2.034276>, <1.460202, -3.156186, 1.886022>, 
      <0.939652, -3.286856, 2.269070>, <1.065429, -3.264198, 2.143493>, <1.263539, -3.243399, 1.998732>, <1.358910, -3.211331, 1.850479>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.799138, -2.968826, 2.149095>, <0.901159, -2.926864, 2.069369>, <1.067904, -2.865356, 1.993413>, <1.139209, -2.828953, 1.883341>, 
      <0.832098, -2.922962, 2.232070>, <0.934119, -2.881000, 2.152344>, <1.169196, -2.810212, 2.028956>, <1.240501, -2.773808, 1.918884>, 
      <0.891437, -2.957018, 2.328365>, <1.042896, -2.919608, 2.199643>, <1.262075, -2.853995, 2.104361>, <1.374688, -2.814756, 1.940999>, 
      <0.929783, -3.043807, 2.361106>, <1.081241, -3.006397, 2.232383>, <1.322031, -2.958345, 2.095393>, <1.434644, -2.919107, 1.932031>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.799138, -2.968826, 2.149095>, <0.766178, -3.014691, 2.066119>, <0.770660, -3.125082, 2.024312>, <0.809006, -3.211872, 2.057053>, 
      <0.901159, -2.926864, 2.069369>, <0.868199, -2.972729, 1.986393>, <0.847001, -3.097873, 1.947733>, <0.885347, -3.184663, 1.980474>, 
      <1.067904, -2.865356, 1.993413>, <0.966612, -2.920501, 1.957870>, <0.950623, -3.044248, 1.905005>, <1.010579, -3.148599, 1.896037>, 
      <1.139209, -2.828953, 1.883341>, <1.037917, -2.884098, 1.847798>, <1.003519, -3.016825, 1.810757>, <1.063475, -3.121176, 1.801789>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.264123, -2.979461, -0.008650>, <1.254546, -2.947021, 0.055331>, <1.275454, -2.918307, 0.148347>, <1.280310, -2.892098, 0.215631>, 
      <1.271598, -2.979635, -0.010716>, <1.262021, -2.947196, 0.053265>, <1.281468, -2.918468, 0.146297>, <1.286324, -2.892260, 0.213581>, 
      <1.281974, -2.982233, -0.012795>, <1.270815, -2.952444, 0.051767>, <1.291206, -2.921098, 0.144115>, <1.294520, -2.894670, 0.210979>, 
      <1.288652, -2.986137, -0.013382>, <1.277493, -2.956348, 0.051180>, <1.296384, -2.924473, 0.142634>, <1.299698, -2.898046, 0.209498>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.236094, -2.984910, 0.001147>, <1.228474, -2.952188, 0.064897>, <1.251787, -2.923331, 0.156821>, <1.258512, -2.896940, 0.223538>, 
      <1.243927, -2.981766, -0.002136>, <1.236307, -2.949044, 0.061615>, <1.257878, -2.920515, 0.154483>, <1.264604, -2.894124, 0.221201>, 
      <1.255396, -2.979257, -0.006238>, <1.245819, -2.946818, 0.057744>, <1.268730, -2.918126, 0.150639>, <1.273586, -2.891917, 0.217923>, 
      <1.264123, -2.979461, -0.008650>, <1.254546, -2.947021, 0.055331>, <1.275454, -2.918307, 0.148347>, <1.280310, -2.892098, 0.215631>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.208831, -3.001652, 0.014521>, <1.204560, -2.967165, 0.076571>, <1.233275, -2.937356, 0.165772>, <1.237620, -2.911836, 0.232011>, 
      <1.216097, -2.995466, 0.010378>, <1.211826, -2.960980, 0.072428>, <1.238766, -2.931882, 0.163407>, <1.243112, -2.906362, 0.229646>, 
      <1.227096, -2.988521, 0.004918>, <1.219476, -2.955799, 0.068668>, <1.244838, -2.926544, 0.159487>, <1.251563, -2.900153, 0.226204>, 
      <1.236094, -2.984910, 0.001147>, <1.228474, -2.952188, 0.064897>, <1.251787, -2.923331, 0.156821>, <1.258512, -2.896940, 0.223538>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.186493, -3.027138, 0.029432>, <1.187840, -2.991197, 0.089151>, <1.210522, -2.962299, 0.176668>, <1.220820, -2.934511, 0.239769>, 
      <1.192048, -3.018608, 0.024987>, <1.193396, -2.982666, 0.084707>, <1.214593, -2.954797, 0.174612>, <1.224891, -2.927008, 0.237713>, 
      <1.201073, -3.008257, 0.018945>, <1.196803, -2.973770, 0.080995>, <1.227327, -2.943285, 0.168333>, <1.231672, -2.917765, 0.234572>, 
      <1.208831, -3.001652, 0.014521>, <1.204560, -2.967165, 0.076571>, <1.233275, -2.937356, 0.165772>, <1.237620, -2.911836, 0.232011>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.172469, -3.057485, 0.043612>, <1.178321, -3.020967, 0.100753>, <1.199201, -2.990311, 0.185021>, <1.210657, -2.961522, 0.245625>, 
      <1.175273, -3.047772, 0.039552>, <1.181124, -3.011254, 0.096693>, <1.201104, -2.981798, 0.183621>, <1.212561, -2.953010, 0.244225>, 
      <1.181045, -3.035504, 0.033791>, <1.182392, -2.999563, 0.093510>, <1.206425, -2.969848, 0.178736>, <1.216723, -2.942060, 0.241837>, 
      <1.186493, -3.027138, 0.029432>, <1.187840, -2.991197, 0.089151>, <1.210522, -2.962299, 0.176668>, <1.220820, -2.934511, 0.239769>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.168903, -3.088077, 0.054902>, <1.179926, -3.051949, 0.109522>, <1.196754, -3.018549, 0.190552>, <1.208690, -2.988752, 0.248687>, 
      <1.168266, -3.078715, 0.051939>, <1.179288, -3.042586, 0.106559>, <1.196015, -3.010354, 0.190087>, <1.207951, -2.980557, 0.248222>, 
      <1.169936, -3.066259, 0.047279>, <1.175788, -3.029741, 0.104420>, <1.197425, -2.998252, 0.186327>, <1.208881, -2.969463, 0.246931>, 
      <1.172469, -3.057485, 0.043612>, <1.178321, -3.020967, 0.100753>, <1.199201, -2.990311, 0.185021>, <1.210657, -2.961522, 0.245625>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.176335, -3.114259, 0.061581>, <1.192600, -3.076864, 0.112152>, <1.212562, -3.028652, 0.185739>, <1.215213, -3.012056, 0.248491>, 
      <1.172260, -3.107016, 0.060307>, <1.188525, -3.069622, 0.110878>, <1.209199, -3.022246, 0.186332>, <1.211850, -3.005649, 0.249084>, 
      <1.169448, -3.096076, 0.057433>, <1.180471, -3.059947, 0.112054>, <1.197405, -3.025769, 0.190961>, <1.209341, -2.995971, 0.249097>, 
      <1.168903, -3.088077, 0.054902>, <1.179926, -3.051949, 0.109522>, <1.196754, -3.018549, 0.190552>, <1.208690, -2.988752, 0.248687>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.193633, -3.132036, 0.062634>, <1.204549, -3.096836, 0.114859>, <1.218554, -3.059130, 0.190336>, <1.229234, -3.027885, 0.245066>, 
      <1.187222, -3.128288, 0.063198>, <1.198138, -3.093087, 0.115423>, <1.213319, -3.055717, 0.191834>, <1.223999, -3.024472, 0.246564>, 
      <1.179945, -3.120675, 0.062710>, <1.196209, -3.083281, 0.113281>, <1.215539, -3.034323, 0.185214>, <1.218190, -3.017727, 0.247966>, 
      <1.176335, -3.114259, 0.061581>, <1.192600, -3.076864, 0.112152>, <1.212562, -3.028652, 0.185739>, <1.215213, -3.012056, 0.248491>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.218163, -3.138713, 0.057904>, <1.223479, -3.104177, 0.110837>, <1.239481, -3.065299, 0.184626>, <1.248617, -3.033836, 0.238935>, 
      <1.210688, -3.138538, 0.059970>, <1.216003, -3.104002, 0.112903>, <1.233468, -3.065137, 0.186675>, <1.242604, -3.033674, 0.240984>, 
      <1.200311, -3.135940, 0.062047>, <1.211227, -3.100740, 0.114272>, <1.223730, -3.062505, 0.188856>, <1.234411, -3.031260, 0.243585>, 
      <1.193633, -3.132036, 0.062634>, <1.204549, -3.096836, 0.114859>, <1.218554, -3.059130, 0.190336>, <1.229234, -3.027885, 0.245066>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.246195, -3.133264, 0.048106>, <1.247092, -3.100593, 0.102647>, <1.263148, -3.060273, 0.176153>, <1.270413, -3.028991, 0.231031>, 
      <1.238361, -3.136408, 0.051389>, <1.239258, -3.103737, 0.105929>, <1.257057, -3.063089, 0.178491>, <1.264322, -3.031807, 0.233368>, 
      <1.226891, -3.138917, 0.055492>, <1.232206, -3.104381, 0.108425>, <1.246204, -3.065480, 0.182334>, <1.255341, -3.034016, 0.236643>, 
      <1.218163, -3.138713, 0.057904>, <1.223479, -3.104177, 0.110837>, <1.239481, -3.065299, 0.184626>, <1.248617, -3.033836, 0.238935>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.273455, -3.116522, 0.034734>, <1.266981, -3.085860, 0.090998>, <1.280596, -3.022923, 0.159665>, <1.291306, -3.014098, 0.222555>, 
      <1.266190, -3.122707, 0.038876>, <1.259716, -3.092045, 0.095141>, <1.275104, -3.028397, 0.162029>, <1.285814, -3.019572, 0.224919>, 
      <1.255192, -3.129653, 0.044336>, <1.256089, -3.096982, 0.098876>, <1.270096, -3.057060, 0.173487>, <1.277362, -3.025778, 0.228365>, 
      <1.246195, -3.133264, 0.048106>, <1.247092, -3.100593, 0.102647>, <1.263148, -3.060273, 0.176153>, <1.270413, -3.028991, 0.231031>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.295798, -3.091035, 0.019824>, <1.285940, -3.062037, 0.078049>, <1.304418, -3.021304, 0.156308>, <1.308112, -2.991419, 0.214801>, 
      <1.290242, -3.099566, 0.024269>, <1.280384, -3.070568, 0.082493>, <1.300345, -3.028808, 0.158363>, <1.304040, -2.998923, 0.216857>, 
      <1.281214, -3.109917, 0.030310>, <1.274739, -3.079254, 0.086574>, <1.286546, -3.016993, 0.157103>, <1.297256, -3.008168, 0.219994>, 
      <1.273455, -3.116522, 0.034734>, <1.266981, -3.085860, 0.090998>, <1.280596, -3.022923, 0.159665>, <1.291306, -3.014098, 0.222555>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.309819, -3.060686, 0.005643>, <1.298851, -3.031089, 0.065344>, <1.315735, -2.993293, 0.147954>, <1.318271, -2.964410, 0.208944>, 
      <1.307016, -3.070399, 0.009703>, <1.296048, -3.040802, 0.069404>, <1.313833, -3.001805, 0.149353>, <1.316368, -2.972922, 0.210343>, 
      <1.301247, -3.082669, 0.015465>, <1.291388, -3.053670, 0.073690>, <1.308514, -3.013756, 0.154240>, <1.312208, -2.983871, 0.212733>, 
      <1.295798, -3.091035, 0.019824>, <1.285940, -3.062037, 0.078049>, <1.304418, -3.021304, 0.156308>, <1.308112, -2.991419, 0.214801>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.313385, -3.030094, -0.005647>, <1.298951, -3.003075, 0.056561>, <1.318182, -2.965054, 0.142424>, <1.320238, -2.937180, 0.205883>, 
      <1.314022, -3.039456, -0.002684>, <1.299589, -3.012437, 0.059525>, <1.318921, -2.973249, 0.142889>, <1.320977, -2.945375, 0.206348>, 
      <1.312351, -3.051912, 0.001976>, <1.301383, -3.022315, 0.061677>, <1.317511, -2.985351, 0.146648>, <1.320046, -2.956469, 0.207638>, 
      <1.309819, -3.060686, 0.005643>, <1.298851, -3.031089, 0.065344>, <1.315735, -2.993293, 0.147954>, <1.318271, -2.964410, 0.208944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.305954, -3.003914, -0.012327>, <1.289912, -2.979470, 0.052273>, <1.300268, -2.931170, 0.138636>, <1.313715, -2.913876, 0.206076>, 
      <1.310029, -3.011156, -0.011053>, <1.293986, -2.986712, 0.053547>, <1.303631, -2.937577, 0.138044>, <1.317078, -2.920283, 0.205484>, 
      <1.312841, -3.022096, -0.008179>, <1.298407, -2.995077, 0.054030>, <1.317531, -2.957835, 0.142014>, <1.319587, -2.929961, 0.205473>, 
      <1.313385, -3.030094, -0.005647>, <1.298951, -3.003075, 0.056561>, <1.318182, -2.965054, 0.142424>, <1.320238, -2.937180, 0.205883>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.305954, -3.003914, -0.012327>, <1.302344, -2.997497, -0.013456>, <1.295064, -2.989885, -0.013946>, <1.288652, -2.986137, -0.013382>, 
      <1.289912, -2.979470, 0.052273>, <1.286301, -2.973053, 0.051144>, <1.283905, -2.960096, 0.050617>, <1.277493, -2.956348, 0.051180>, 
      <1.300268, -2.931170, 0.138636>, <1.297292, -2.925499, 0.139160>, <1.301619, -2.927886, 0.141137>, <1.296384, -2.924473, 0.142634>, 
      <1.313715, -2.913876, 0.206076>, <1.310739, -2.908205, 0.206600>, <1.304933, -2.901459, 0.208001>, <1.299698, -2.898046, 0.209498>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.331236, -3.064587, -0.124576>, <1.355429, -3.086321, -0.151082>, <1.409993, -3.106277, -0.218400>, <1.432988, -3.131164, -0.193659>, 
      <1.340102, -3.059903, -0.122561>, <1.364295, -3.081638, -0.149067>, <1.408286, -3.104646, -0.220451>, <1.431281, -3.129533, -0.195710>, 
      <1.346515, -3.050102, -0.112809>, <1.369003, -3.063224, -0.143140>, <1.398327, -3.059771, -0.199816>, <1.424454, -3.086594, -0.213809>, 
      <1.354820, -3.045192, -0.109415>, <1.377309, -3.058315, -0.139746>, <1.409645, -3.045162, -0.197810>, <1.435772, -3.071985, -0.211803>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.331236, -3.064587, -0.124576>, <1.303780, -3.039922, -0.094495>, <1.270424, -3.000803, -0.050744>, <1.264123, -2.979461, -0.008650>, 
      <1.340102, -3.059903, -0.122561>, <1.312646, -3.035238, -0.092481>, <1.277899, -3.000978, -0.052810>, <1.271598, -2.979635, -0.010716>, 
      <1.346515, -3.050102, -0.112809>, <1.324452, -3.037227, -0.083053>, <1.288054, -2.998464, -0.047973>, <1.281974, -2.982233, -0.012795>, 
      <1.354820, -3.045192, -0.109415>, <1.332757, -3.032318, -0.079659>, <1.294732, -3.002368, -0.048560>, <1.288652, -2.986137, -0.013382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.299804, -3.074257, -0.121917>, <1.315548, -3.097597, -0.151092>, <1.337471, -3.130960, -0.187710>, <1.352465, -3.157434, -0.214508>, 
      <1.308299, -3.069281, -0.122935>, <1.324043, -3.092621, -0.152110>, <1.355600, -3.112239, -0.190090>, <1.370594, -3.138713, -0.216888>, 
      <1.322656, -3.069120, -0.126526>, <1.346849, -3.090854, -0.153032>, <1.407590, -3.103982, -0.221288>, <1.430585, -3.128869, -0.196547>, 
      <1.331236, -3.064587, -0.124576>, <1.355429, -3.086321, -0.151082>, <1.409993, -3.106277, -0.218400>, <1.432988, -3.131164, -0.193659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.299804, -3.074257, -0.121917>, <1.280596, -3.045781, -0.086322>, <1.241324, -3.007371, -0.042613>, <1.236094, -2.984910, 0.001147>, 
      <1.308299, -3.069281, -0.122935>, <1.289092, -3.040805, -0.087340>, <1.249158, -3.004227, -0.045895>, <1.243927, -2.981766, -0.002136>, 
      <1.322656, -3.069120, -0.126526>, <1.295200, -3.044455, -0.096445>, <1.261697, -3.000599, -0.048331>, <1.255396, -2.979257, -0.006238>, 
      <1.331236, -3.064587, -0.124576>, <1.303780, -3.039922, -0.094495>, <1.270424, -3.000803, -0.050744>, <1.264123, -2.979461, -0.008650>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.261587, -3.105384, -0.116230>, <1.280704, -3.138382, -0.144855>, <1.311487, -3.199409, -0.207654>, <1.339681, -3.227516, -0.181410>, 
      <1.273354, -3.097223, -0.120291>, <1.292471, -3.130221, -0.148916>, <1.309323, -3.197341, -0.210254>, <1.337517, -3.225449, -0.184010>, 
      <1.287028, -3.081740, -0.120386>, <1.302772, -3.105080, -0.149561>, <1.321145, -3.147818, -0.185567>, <1.336139, -3.174293, -0.212365>, 
      <1.299804, -3.074257, -0.121917>, <1.315548, -3.097597, -0.151092>, <1.337471, -3.130960, -0.187710>, <1.352465, -3.157434, -0.214508>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.261587, -3.105384, -0.116230>, <1.240534, -3.069044, -0.084706>, <1.211984, -3.027116, -0.031296>, <1.208831, -3.001652, 0.014521>, 
      <1.273354, -3.097223, -0.120291>, <1.252302, -3.060884, -0.088767>, <1.219250, -3.020931, -0.035439>, <1.216097, -2.995466, 0.010378>, 
      <1.287028, -3.081740, -0.120386>, <1.267821, -3.053264, -0.084791>, <1.232327, -3.010982, -0.038842>, <1.227096, -2.988521, 0.004918>, 
      <1.299804, -3.074257, -0.121917>, <1.280596, -3.045781, -0.086322>, <1.241324, -3.007371, -0.042613>, <1.236094, -2.984910, 0.001147>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.213334, -3.134227, -0.092073>, <1.219986, -3.159900, -0.117596>, <1.232641, -3.200953, -0.143085>, <1.238180, -3.226619, -0.168880>, 
      <1.226994, -3.124995, -0.100142>, <1.233646, -3.150668, -0.125664>, <1.258256, -3.188487, -0.154481>, <1.263795, -3.214152, -0.180276>, 
      <1.247076, -3.115448, -0.111222>, <1.266193, -3.148446, -0.139847>, <1.308669, -3.196717, -0.211039>, <1.336864, -3.224824, -0.184796>, 
      <1.261587, -3.105384, -0.116230>, <1.280704, -3.138382, -0.144855>, <1.311487, -3.199409, -0.207654>, <1.339681, -3.227516, -0.181410>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.213334, -3.134227, -0.092073>, <1.204433, -3.099874, -0.057922>, <1.185541, -3.052530, -0.012758>, <1.186493, -3.027138, 0.029432>, 
      <1.226994, -3.124995, -0.100142>, <1.218093, -3.090642, -0.065990>, <1.191097, -3.044000, -0.017203>, <1.192048, -3.018608, 0.024987>, 
      <1.247076, -3.115448, -0.111222>, <1.226023, -3.079108, -0.079698>, <1.204226, -3.033721, -0.026872>, <1.201073, -3.008257, 0.018945>, 
      <1.261587, -3.105384, -0.116230>, <1.240534, -3.069044, -0.084706>, <1.211984, -3.027116, -0.031296>, <1.208831, -3.001652, 0.014521>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.178620, -3.161458, -0.067224>, <1.184514, -3.196213, -0.092388>, <1.186796, -3.263115, -0.147772>, <1.211858, -3.289728, -0.124544>, 
      <1.188546, -3.154792, -0.076595>, <1.194440, -3.189547, -0.101759>, <1.184551, -3.260970, -0.150470>, <1.209613, -3.287583, -0.127242>, 
      <1.202029, -3.141868, -0.085396>, <1.208681, -3.167541, -0.110918>, <1.212230, -3.210887, -0.134005>, <1.217770, -3.236553, -0.159800>, 
      <1.213334, -3.134227, -0.092073>, <1.219986, -3.159900, -0.117596>, <1.232641, -3.200953, -0.143085>, <1.238180, -3.226619, -0.168880>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.178620, -3.161458, -0.067224>, <1.172410, -3.124844, -0.040714>, <1.168546, -3.081965, 0.005307>, <1.172469, -3.057485, 0.043612>, 
      <1.188546, -3.154792, -0.076595>, <1.182336, -3.118178, -0.050084>, <1.171350, -3.072252, 0.001247>, <1.175273, -3.047772, 0.039552>, 
      <1.202029, -3.141868, -0.085396>, <1.193128, -3.107515, -0.051244>, <1.180093, -3.060896, -0.008399>, <1.181045, -3.035504, 0.033791>, 
      <1.213334, -3.134227, -0.092073>, <1.204433, -3.099874, -0.057922>, <1.185541, -3.052530, -0.012758>, <1.186493, -3.027138, 0.029432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.151670, -3.175640, -0.033856>, <1.146243, -3.201361, -0.057468>, <1.133665, -3.238997, -0.084049>, <1.131533, -3.265179, -0.107682>, 
      <1.159018, -3.169157, -0.043218>, <1.153591, -3.194877, -0.066830>, <1.154566, -3.237068, -0.098879>, <1.152434, -3.263250, -0.122512>, 
      <1.169765, -3.167405, -0.058864>, <1.175659, -3.202160, -0.084028>, <1.184436, -3.260860, -0.150608>, <1.209498, -3.287473, -0.127380>, 
      <1.178620, -3.161458, -0.067224>, <1.184514, -3.196213, -0.092388>, <1.186796, -3.263115, -0.147772>, <1.211858, -3.289728, -0.124544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.151670, -3.175640, -0.033856>, <1.157470, -3.148154, -0.008623>, <1.162635, -3.108620, 0.023845>, <1.168903, -3.088077, 0.054902>, 
      <1.159018, -3.169157, -0.043218>, <1.164818, -3.141671, -0.017985>, <1.161998, -3.099257, 0.020882>, <1.168266, -3.078715, 0.051939>, 
      <1.169765, -3.167405, -0.058864>, <1.163555, -3.130791, -0.032353>, <1.166014, -3.090739, 0.008974>, <1.169936, -3.066259, 0.047279>, 
      <1.178620, -3.161458, -0.067224>, <1.172410, -3.124844, -0.040714>, <1.168546, -3.081965, 0.005307>, <1.172469, -3.057485, 0.043612>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.132551, -3.202108, -0.008528>, <1.122993, -3.228687, -0.024880>, <1.111657, -3.274840, -0.030457>, <1.109849, -3.299144, -0.052166>, 
      <1.125402, -3.194193, -0.014848>, <1.115844, -3.220773, -0.031200>, <1.100424, -3.264109, -0.043955>, <1.098616, -3.288413, -0.065664>, 
      <1.144949, -3.181571, -0.025292>, <1.139521, -3.207292, -0.048905>, <1.116928, -3.240542, -0.072174>, <1.114796, -3.266724, -0.095807>, 
      <1.151670, -3.175640, -0.033856>, <1.146243, -3.201361, -0.057468>, <1.133665, -3.238997, -0.084049>, <1.131533, -3.265179, -0.107682>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.132551, -3.202108, -0.008528>, <1.143148, -3.172638, 0.009603>, <1.167275, -3.135089, 0.033412>, <1.176335, -3.114259, 0.061581>, 
      <1.125402, -3.194193, -0.014848>, <1.136000, -3.164724, 0.003283>, <1.163201, -3.127846, 0.032138>, <1.172260, -3.107016, 0.060307>, 
      <1.144949, -3.181571, -0.025292>, <1.150748, -3.154085, -0.000060>, <1.163180, -3.116618, 0.026377>, <1.169448, -3.096076, 0.057433>, 
      <1.151670, -3.175640, -0.033856>, <1.157470, -3.148154, -0.008623>, <1.162635, -3.108620, 0.023845>, <1.168903, -3.088077, 0.054902>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.175301, -3.201802, -0.012965>, <1.172827, -3.230732, -0.031496>, <1.179389, -3.284211, -0.028497>, <1.178418, -3.309972, -0.051342>, 
      <1.162698, -3.201053, -0.010344>, <1.160224, -3.229984, -0.028875>, <1.162451, -3.285774, -0.016479>, <1.161480, -3.311536, -0.039324>, 
      <1.139987, -3.210340, -0.001955>, <1.130428, -3.236919, -0.018307>, <1.123024, -3.285701, -0.016797>, <1.121217, -3.310004, -0.038506>, 
      <1.132551, -3.202108, -0.008528>, <1.122993, -3.228687, -0.024880>, <1.111657, -3.274840, -0.030457>, <1.109849, -3.299144, -0.052166>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.175301, -3.201802, -0.012965>, <1.177552, -3.175473, 0.003900>, <1.188279, -3.149299, 0.037022>, <1.193633, -3.132036, 0.062634>, 
      <1.162698, -3.201053, -0.010344>, <1.164949, -3.174725, 0.006521>, <1.181868, -3.145551, 0.037585>, <1.187222, -3.128288, 0.063198>, 
      <1.139987, -3.210340, -0.001955>, <1.150584, -3.180870, 0.016176>, <1.170885, -3.141505, 0.034540>, <1.179945, -3.120675, 0.062710>, 
      <1.132551, -3.202108, -0.008528>, <1.143148, -3.172638, 0.009603>, <1.167275, -3.135089, 0.033412>, <1.176335, -3.114259, 0.061581>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.221900, -3.207417, -0.027111>, <1.222773, -3.186503, -0.001844>, <1.215413, -3.156579, 0.030521>, <1.218163, -3.138713, 0.057904>, 
      <1.207721, -3.209671, -0.023925>, <1.208594, -3.188758, 0.001342>, <1.207938, -3.156404, 0.032587>, <1.210688, -3.138538, 0.059970>, 
      <1.189675, -3.202656, -0.015955>, <1.191926, -3.176327, 0.000910>, <1.194957, -3.153203, 0.036435>, <1.200311, -3.135940, 0.062047>, 
      <1.175301, -3.201802, -0.012965>, <1.177552, -3.175473, 0.003900>, <1.188279, -3.149299, 0.037022>, <1.193633, -3.132036, 0.062634>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.221900, -3.207417, -0.027111>, <1.220879, -3.231882, -0.056668>, <1.234068, -3.313312, -0.103960>, <1.211858, -3.289728, -0.124544>, 
      <1.207721, -3.209671, -0.023925>, <1.206700, -3.234137, -0.053482>, <1.236354, -3.315496, -0.101213>, <1.214144, -3.291912, -0.121797>, 
      <1.189675, -3.202656, -0.015955>, <1.187201, -3.231586, -0.034486>, <1.199635, -3.282342, -0.042862>, <1.198665, -3.308103, -0.065708>, 
      <1.175301, -3.201802, -0.012965>, <1.172827, -3.230732, -0.031496>, <1.179389, -3.284211, -0.028497>, <1.178418, -3.309972, -0.051342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.266064, -3.187370, -0.033362>, <1.259878, -3.167399, -0.011933>, <1.245772, -3.148648, 0.022425>, <1.246195, -3.133264, 0.048106>, 
      <1.252947, -3.192549, -0.029319>, <1.246760, -3.172578, -0.007890>, <1.237939, -3.151792, 0.025708>, <1.238361, -3.136408, 0.051389>, 
      <1.236044, -3.205168, -0.030290>, <1.236918, -3.184254, -0.005023>, <1.224141, -3.156783, 0.028109>, <1.226891, -3.138917, 0.055492>, 
      <1.221900, -3.207417, -0.027111>, <1.222773, -3.186503, -0.001844>, <1.215413, -3.156579, 0.030521>, <1.218163, -3.138713, 0.057904>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.266064, -3.187370, -0.033362>, <1.273358, -3.210916, -0.058627>, <1.286407, -3.253641, -0.079486>, <1.290638, -3.276736, -0.105842>, 
      <1.252947, -3.192549, -0.029319>, <1.260240, -3.216094, -0.054584>, <1.265869, -3.263637, -0.070349>, <1.270100, -3.286732, -0.096705>, 
      <1.236044, -3.205168, -0.030290>, <1.235023, -3.229633, -0.059847>, <1.236327, -3.315470, -0.101245>, <1.214117, -3.291886, -0.121829>, 
      <1.221900, -3.207417, -0.027111>, <1.220879, -3.231882, -0.056668>, <1.234068, -3.313312, -0.103960>, <1.211858, -3.289728, -0.124544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.323643, -3.167248, -0.058468>, <1.314383, -3.151728, -0.028245>, <1.276995, -3.133288, 0.003970>, <1.273455, -3.116522, 0.034734>, 
      <1.307613, -3.177038, -0.052243>, <1.298353, -3.161518, -0.022020>, <1.269730, -3.139473, 0.008112>, <1.266190, -3.122707, 0.038876>, 
      <1.283757, -3.180385, -0.038815>, <1.277570, -3.160414, -0.017385>, <1.254770, -3.145037, 0.018655>, <1.255192, -3.129653, 0.044336>, 
      <1.266064, -3.187370, -0.033362>, <1.259878, -3.167399, -0.011933>, <1.245772, -3.148648, 0.022425>, <1.246195, -3.133264, 0.048106>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.323643, -3.167248, -0.058468>, <1.334518, -3.185475, -0.093963>, <1.364135, -3.251894, -0.158648>, <1.339681, -3.227516, -0.181410>, 
      <1.307613, -3.177038, -0.052243>, <1.318489, -3.195265, -0.087738>, <1.366963, -3.254596, -0.155250>, <1.342509, -3.230217, -0.178012>, 
      <1.283757, -3.180385, -0.038815>, <1.291050, -3.203931, -0.064080>, <1.312118, -3.241127, -0.090924>, <1.316349, -3.264223, -0.117280>, 
      <1.266064, -3.187370, -0.033362>, <1.273358, -3.210916, -0.058627>, <1.286407, -3.253641, -0.079486>, <1.290638, -3.276736, -0.105842>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.356046, -3.132416, -0.068303>, <1.339363, -3.114683, -0.044075>, <1.300945, -3.106174, -0.010575>, <1.295798, -3.091035, 0.019824>, 
      <1.347242, -3.143255, -0.064131>, <1.330560, -3.125522, -0.039903>, <1.295389, -3.114705, -0.006130>, <1.290242, -3.099566, 0.024269>, 
      <1.335449, -3.160038, -0.063052>, <1.326189, -3.144518, -0.032829>, <1.284754, -3.126683, -0.000454>, <1.281214, -3.109917, 0.030310>, 
      <1.323643, -3.167248, -0.058468>, <1.314383, -3.151728, -0.028245>, <1.276995, -3.133288, 0.003970>, <1.273455, -3.116522, 0.034734>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.356046, -3.132416, -0.068303>, <1.374027, -3.151530, -0.094417>, <1.398013, -3.189138, -0.119158>, <1.409750, -3.212162, -0.145668>, 
      <1.347242, -3.143255, -0.064131>, <1.365223, -3.162369, -0.090245>, <1.381357, -3.206338, -0.116972>, <1.393094, -3.229362, -0.143481>, 
      <1.335449, -3.160038, -0.063052>, <1.346325, -3.178265, -0.098547>, <1.366343, -3.254003, -0.155995>, <1.341889, -3.229625, -0.178757>, 
      <1.323643, -3.167248, -0.058468>, <1.334518, -3.185475, -0.093963>, <1.364135, -3.251894, -0.158648>, <1.339681, -3.227516, -0.181410>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.371571, -3.108240, -0.081179>, <1.353950, -3.098157, -0.052666>, <1.315504, -3.076026, -0.025301>, <1.309819, -3.060686, 0.005643>, 
      <1.367441, -3.116098, -0.077952>, <1.349820, -3.106015, -0.049439>, <1.312701, -3.085740, -0.021241>, <1.307016, -3.070399, 0.009703>, 
      <1.361752, -3.125391, -0.071007>, <1.345069, -3.107658, -0.046779>, <1.306394, -3.097808, -0.014934>, <1.301247, -3.082669, 0.015465>, 
      <1.356046, -3.132416, -0.068303>, <1.339363, -3.114683, -0.044075>, <1.300945, -3.106174, -0.010575>, <1.295798, -3.091035, 0.019824>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.371571, -3.108240, -0.081179>, <1.391233, -3.119491, -0.112995>, <1.454395, -3.154332, -0.170627>, <1.432988, -3.131164, -0.193659>, 
      <1.367441, -3.116098, -0.077952>, <1.387103, -3.127349, -0.109768>, <1.457066, -3.156884, -0.167417>, <1.435659, -3.133716, -0.190449>, 
      <1.361752, -3.125391, -0.071007>, <1.379733, -3.144505, -0.097121>, <1.418168, -3.168326, -0.121804>, <1.429904, -3.191350, -0.148314>, 
      <1.356046, -3.132416, -0.068303>, <1.374027, -3.151530, -0.094417>, <1.398013, -3.189138, -0.119158>, <1.409750, -3.212162, -0.145668>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.390012, -3.067794, -0.094838>, <1.364335, -3.054769, -0.071527>, <1.321096, -3.044529, -0.038881>, <1.313385, -3.030094, -0.005647>, 
      <1.386926, -3.080999, -0.091561>, <1.361249, -3.067974, -0.068251>, <1.321733, -3.053891, -0.035917>, <1.314022, -3.039456, -0.002684>, 
      <1.377671, -3.096634, -0.085945>, <1.360050, -3.086551, -0.057432>, <1.318036, -3.067252, -0.028968>, <1.312351, -3.051912, 0.001976>, 
      <1.371571, -3.108240, -0.081179>, <1.353950, -3.098157, -0.052666>, <1.315504, -3.076026, -0.025301>, <1.309819, -3.060686, 0.005643>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.390012, -3.067794, -0.094838>, <1.414986, -3.080463, -0.117511>, <1.459054, -3.089551, -0.144434>, <1.480827, -3.115031, -0.157662>, 
      <1.386926, -3.080999, -0.091561>, <1.411900, -3.093667, -0.114235>, <1.447728, -3.104170, -0.146441>, <1.469501, -3.129650, -0.159669>, 
      <1.377671, -3.096634, -0.085945>, <1.397334, -3.107885, -0.117761>, <1.456103, -3.155963, -0.168575>, <1.434696, -3.132796, -0.191607>, 
      <1.371571, -3.108240, -0.081179>, <1.391233, -3.119491, -0.112995>, <1.454395, -3.154332, -0.170627>, <1.432988, -3.131164, -0.193659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.389876, -3.029923, -0.100613>, <1.363550, -3.021377, -0.075511>, <1.314408, -3.016795, -0.046369>, <1.305954, -3.003914, -0.012327>, 
      <1.399007, -3.035788, -0.096831>, <1.372681, -3.027241, -0.071728>, <1.318482, -3.024037, -0.045095>, <1.310029, -3.011156, -0.011053>, 
      <1.392554, -3.056916, -0.097537>, <1.366878, -3.043891, -0.074227>, <1.320552, -3.036531, -0.041413>, <1.312841, -3.022096, -0.008179>, 
      <1.390012, -3.067794, -0.094838>, <1.364335, -3.054769, -0.071527>, <1.321096, -3.044529, -0.038881>, <1.313385, -3.030094, -0.005647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.389876, -3.029923, -0.100613>, <1.417703, -3.038956, -0.127146>, <1.460538, -3.034580, -0.173104>, <1.486232, -3.062438, -0.184222>, 
      <1.399007, -3.035788, -0.096831>, <1.426834, -3.044821, -0.123363>, <1.473001, -3.046487, -0.158128>, <1.498695, -3.074346, -0.169245>, 
      <1.392554, -3.056916, -0.097537>, <1.417529, -3.069585, -0.120211>, <1.469861, -3.075601, -0.142518>, <1.491634, -3.101081, -0.155747>, 
      <1.390012, -3.067794, -0.094838>, <1.414986, -3.080463, -0.117511>, <1.459054, -3.089551, -0.144434>, <1.480827, -3.115031, -0.157662>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.389876, -3.029923, -0.100613>, <1.417703, -3.038956, -0.127146>, <1.460538, -3.034580, -0.173104>, <1.486232, -3.062438, -0.184222>, 
      <1.380523, -3.023916, -0.104487>, <1.408350, -3.032950, -0.131020>, <1.448258, -3.022848, -0.187860>, <1.473953, -3.050706, -0.198978>, 
      <1.364379, -3.039541, -0.105509>, <1.386867, -3.052664, -0.135839>, <1.420293, -3.031418, -0.195923>, <1.446420, -3.058241, -0.209916>, 
      <1.354820, -3.045192, -0.109415>, <1.377309, -3.058315, -0.139746>, <1.409645, -3.045162, -0.197810>, <1.435772, -3.071985, -0.211803>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.389876, -3.029923, -0.100613>, <1.380523, -3.023916, -0.104487>, <1.364379, -3.039541, -0.105509>, <1.354820, -3.045192, -0.109415>, 
      <1.363550, -3.021377, -0.075511>, <1.354197, -3.015370, -0.079385>, <1.342316, -3.026667, -0.075753>, <1.332757, -3.032318, -0.079659>, 
      <1.314408, -3.016795, -0.046369>, <1.310797, -3.010378, -0.047498>, <1.301144, -3.006116, -0.049124>, <1.294732, -3.002368, -0.048560>, 
      <1.305954, -3.003914, -0.012327>, <1.302344, -2.997497, -0.013456>, <1.295064, -2.989885, -0.013946>, <1.288652, -2.986137, -0.013382>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.718426, -3.293642, -0.450932>, <1.707606, -3.300736, -0.461943>, <1.703486, -3.315373, -0.474755>, <1.714279, -3.328075, -0.478045>, 
      <1.718426, -3.293642, -0.450932>, <1.715101, -3.300516, -0.467926>, <1.713228, -3.306535, -0.474948>, <1.724021, -3.319237, -0.478238>, 
      <1.718426, -3.293642, -0.450932>, <1.715101, -3.300516, -0.467926>, <1.732121, -3.300678, -0.469975>, <1.738215, -3.307850, -0.471833>, 
      <1.718426, -3.293642, -0.450932>, <1.725921, -3.293422, -0.456915>, <1.740499, -3.295185, -0.461449>, <1.746593, -3.302357, -0.463307>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.693069, -3.350912, -0.462246>, <1.697578, -3.345600, -0.470078>, <1.706516, -3.335118, -0.477891>, <1.714279, -3.328075, -0.478045>, 
      <1.678291, -3.333518, -0.457739>, <1.682800, -3.328206, -0.465571>, <1.695723, -3.322416, -0.474601>, <1.703486, -3.315373, -0.474755>, 
      <1.683936, -3.313475, -0.440199>, <1.688334, -3.308218, -0.447751>, <1.699637, -3.300970, -0.455583>, <1.707606, -3.300736, -0.461943>, 
      <1.698753, -3.303761, -0.425121>, <1.703151, -3.298504, -0.432673>, <1.710458, -3.293876, -0.444572>, <1.718426, -3.293642, -0.450932>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.757192, -3.299941, -0.434375>, <1.756407, -3.298438, -0.443491>, <1.752498, -3.298486, -0.457298>, <1.746593, -3.302357, -0.463307>, 
      <1.757192, -3.299941, -0.434375>, <1.745958, -3.286140, -0.440305>, <1.746404, -3.291314, -0.455440>, <1.740499, -3.295185, -0.461449>, 
      <1.757192, -3.299941, -0.434375>, <1.745958, -3.286140, -0.440305>, <1.736398, -3.286554, -0.446254>, <1.725921, -3.293422, -0.456915>, 
      <1.757192, -3.299941, -0.434375>, <1.746742, -3.287643, -0.431189>, <1.728902, -3.286774, -0.440271>, <1.718426, -3.293642, -0.450932>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.757192, -3.299941, -0.434375>, <1.758072, -3.301627, -0.424145>, <1.756417, -3.307044, -0.410108>, <1.751831, -3.312389, -0.402448>, 
      <1.746742, -3.287643, -0.431189>, <1.747623, -3.289330, -0.420959>, <1.742110, -3.290204, -0.405744>, <1.737525, -3.295549, -0.398085>, 
      <1.728902, -3.286774, -0.440271>, <1.720934, -3.287008, -0.433910>, <1.717495, -3.289100, -0.418076>, <1.713098, -3.294357, -0.410524>, 
      <1.718426, -3.293642, -0.450932>, <1.710458, -3.293876, -0.444572>, <1.703151, -3.298504, -0.432673>, <1.698753, -3.303761, -0.425121>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.757192, -3.299941, -0.434375>, <1.746742, -3.287643, -0.431189>, <1.728902, -3.286774, -0.440271>, <1.718426, -3.293642, -0.450932>, 
      <1.756407, -3.298438, -0.443491>, <1.745958, -3.286140, -0.440305>, <1.718082, -3.293868, -0.451282>, <1.707606, -3.300736, -0.461943>, 
      <1.752498, -3.298486, -0.457298>, <1.744120, -3.303978, -0.465824>, <1.713228, -3.306535, -0.474948>, <1.703486, -3.315373, -0.474755>, 
      <1.746593, -3.302357, -0.463307>, <1.738215, -3.307850, -0.471833>, <1.724021, -3.319237, -0.478238>, <1.714279, -3.328075, -0.478045>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.753037, -3.334375, -0.461484>, <1.752963, -3.343815, -0.457566>, <1.750636, -3.354378, -0.447166>, <1.746142, -3.359540, -0.439574>, 
      <1.763857, -3.327281, -0.450473>, <1.763783, -3.336722, -0.446555>, <1.765453, -3.344664, -0.432088>, <1.760959, -3.349826, -0.424496>, 
      <1.767985, -3.312643, -0.437665>, <1.768865, -3.314329, -0.427435>, <1.771195, -3.324438, -0.414615>, <1.766609, -3.329783, -0.406955>, 
      <1.757192, -3.299941, -0.434375>, <1.758072, -3.301627, -0.424145>, <1.756417, -3.307044, -0.410108>, <1.751831, -3.312389, -0.402448>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.753037, -3.334375, -0.461484>, <1.753109, -3.325311, -0.465246>, <1.752827, -3.309694, -0.465208>, <1.746593, -3.302357, -0.463307>, 
      <1.753037, -3.334375, -0.461484>, <1.763929, -3.318218, -0.454235>, <1.758732, -3.305822, -0.459198>, <1.752498, -3.298486, -0.457298>, 
      <1.753037, -3.334375, -0.461484>, <1.763929, -3.318218, -0.454235>, <1.767200, -3.311140, -0.446781>, <1.756407, -3.298438, -0.443491>, 
      <1.753037, -3.334375, -0.461484>, <1.763857, -3.327281, -0.450473>, <1.767985, -3.312643, -0.437665>, <1.757192, -3.299941, -0.434375>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.753037, -3.334375, -0.461484>, <1.753109, -3.325311, -0.465246>, <1.752827, -3.309694, -0.465208>, <1.746593, -3.302357, -0.463307>, 
      <1.763857, -3.327281, -0.450473>, <1.763929, -3.318218, -0.454235>, <1.746733, -3.302522, -0.463350>, <1.740499, -3.295185, -0.461449>, 
      <1.767985, -3.312643, -0.437665>, <1.757535, -3.300345, -0.434480>, <1.736398, -3.286554, -0.446254>, <1.725921, -3.293422, -0.456915>, 
      <1.757192, -3.299941, -0.434375>, <1.746742, -3.287643, -0.431189>, <1.728902, -3.286774, -0.440271>, <1.718426, -3.293642, -0.450932>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.753037, -3.334375, -0.461484>, <1.763857, -3.327281, -0.450473>, <1.767985, -3.312643, -0.437665>, <1.757192, -3.299941, -0.434375>, 
      <1.742562, -3.341242, -0.472144>, <1.753382, -3.334149, -0.461133>, <1.767200, -3.311140, -0.446781>, <1.756407, -3.298438, -0.443491>, 
      <1.724727, -3.340371, -0.481230>, <1.734469, -3.331533, -0.481424>, <1.744120, -3.303978, -0.465824>, <1.752498, -3.298486, -0.457298>, 
      <1.714279, -3.328075, -0.478045>, <1.724021, -3.319237, -0.478238>, <1.738215, -3.307850, -0.471833>, <1.746593, -3.302357, -0.463307>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.753037, -3.334375, -0.461484>, <1.753109, -3.325311, -0.465246>, <1.752827, -3.309694, -0.465208>, <1.746593, -3.302357, -0.463307>, 
      <1.753037, -3.334375, -0.461484>, <1.742634, -3.332179, -0.475905>, <1.744449, -3.315186, -0.473733>, <1.738215, -3.307850, -0.471833>, 
      <1.753037, -3.334375, -0.461484>, <1.742634, -3.332179, -0.475905>, <1.734469, -3.331533, -0.481424>, <1.724021, -3.319237, -0.478238>, 
      <1.753037, -3.334375, -0.461484>, <1.742562, -3.341242, -0.472144>, <1.724727, -3.340371, -0.481230>, <1.714279, -3.328075, -0.478045>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.753037, -3.334375, -0.461484>, <1.752963, -3.343815, -0.457566>, <1.750636, -3.354378, -0.447166>, <1.746142, -3.359540, -0.439574>, 
      <1.742562, -3.341242, -0.472144>, <1.742488, -3.350683, -0.468226>, <1.736292, -3.363781, -0.461762>, <1.731799, -3.368943, -0.454170>, 
      <1.724727, -3.340371, -0.481230>, <1.716964, -3.347414, -0.481077>, <1.711883, -3.362438, -0.474441>, <1.707374, -3.367750, -0.466609>, 
      <1.714279, -3.328075, -0.478045>, <1.706516, -3.335118, -0.477891>, <1.697578, -3.345600, -0.470078>, <1.693069, -3.350912, -0.462246>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.753037, -3.334375, -0.461484>, <1.742562, -3.341242, -0.472144>, <1.724727, -3.340371, -0.481230>, <1.714279, -3.328075, -0.478045>, 
      <1.753109, -3.325311, -0.465246>, <1.742634, -3.332179, -0.475905>, <1.713934, -3.327669, -0.477940>, <1.703486, -3.315373, -0.474755>, 
      <1.752827, -3.309694, -0.465208>, <1.746733, -3.302522, -0.463350>, <1.715101, -3.300516, -0.467926>, <1.707606, -3.300736, -0.461943>, 
      <1.746593, -3.302357, -0.463307>, <1.740499, -3.295185, -0.461449>, <1.725921, -3.293422, -0.456915>, <1.718426, -3.293642, -0.450932>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.727489, -3.334565, -0.384760>, <1.717215, -3.322473, -0.381627>, <1.699672, -3.321620, -0.390553>, <1.689371, -3.328373, -0.401035>, 
      <1.733387, -3.335722, -0.394227>, <1.723112, -3.323631, -0.391094>, <1.705184, -3.322863, -0.399648>, <1.694883, -3.329616, -0.410130>, 
      <1.746889, -3.318149, -0.394193>, <1.732583, -3.301310, -0.389830>, <1.708480, -3.299876, -0.402594>, <1.694136, -3.309280, -0.417192>, 
      <1.751831, -3.312389, -0.402448>, <1.737525, -3.295549, -0.398085>, <1.713098, -3.294357, -0.410524>, <1.698753, -3.303761, -0.425121>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.723400, -3.368422, -0.411411>, <1.734039, -3.361448, -0.400585>, <1.738100, -3.347053, -0.387995>, <1.727489, -3.334565, -0.384760>, 
      <1.729252, -3.369514, -0.420877>, <1.739891, -3.362539, -0.410051>, <1.743998, -3.348211, -0.397463>, <1.733387, -3.335722, -0.394227>, 
      <1.741226, -3.365187, -0.431269>, <1.756044, -3.355473, -0.416190>, <1.761667, -3.335544, -0.398700>, <1.746889, -3.318149, -0.394193>, 
      <1.746142, -3.359540, -0.439574>, <1.760959, -3.349826, -0.424496>, <1.766609, -3.329783, -0.406955>, <1.751831, -3.312389, -0.402448>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.685293, -3.362227, -0.427696>, <1.695566, -3.374317, -0.430828>, <1.713100, -3.375174, -0.421891>, <1.723400, -3.368422, -0.411411>, 
      <1.691009, -3.363454, -0.437194>, <1.701282, -3.375544, -0.440327>, <1.718952, -3.376266, -0.431357>, <1.729252, -3.369514, -0.420877>, 
      <1.688272, -3.356564, -0.453913>, <1.702577, -3.373402, -0.458276>, <1.726883, -3.374590, -0.445865>, <1.741226, -3.365187, -0.431269>, 
      <1.693069, -3.350912, -0.462246>, <1.707374, -3.367750, -0.466609>, <1.731799, -3.368943, -0.454170>, <1.746142, -3.359540, -0.439574>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.685293, -3.362227, -0.427696>, <1.691009, -3.363454, -0.437194>, <1.688272, -3.356564, -0.453913>, <1.693069, -3.350912, -0.462246>, 
      <1.674681, -3.349738, -0.424460>, <1.680397, -3.350965, -0.433959>, <1.673494, -3.339170, -0.449406>, <1.678291, -3.333518, -0.457739>, 
      <1.678731, -3.335348, -0.411861>, <1.684243, -3.336591, -0.420956>, <1.679319, -3.318994, -0.432270>, <1.683936, -3.313475, -0.440199>, 
      <1.689371, -3.328373, -0.401035>, <1.694883, -3.329616, -0.410130>, <1.694136, -3.309280, -0.417192>, <1.698753, -3.303761, -0.425121>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.627979, -3.288080, -0.203637>, <1.616313, -3.270204, -0.202548>, <1.594365, -3.268220, -0.216565>, <1.580753, -3.277145, -0.230417>, 
      <1.664895, -3.329719, -0.234322>, <1.653229, -3.311843, -0.233233>, <1.633342, -3.307626, -0.245649>, <1.619730, -3.316551, -0.259501>, 
      <1.694068, -3.328005, -0.331111>, <1.683794, -3.315914, -0.327979>, <1.667450, -3.314352, -0.337385>, <1.657149, -3.321105, -0.347867>, 
      <1.727489, -3.334565, -0.384760>, <1.717215, -3.322473, -0.381627>, <1.699672, -3.321620, -0.390553>, <1.689371, -3.328373, -0.401035>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.627979, -3.288080, -0.203637>, <1.581416, -3.235559, -0.164933>, <1.538377, -3.118975, -0.206784>, <1.486232, -3.062438, -0.184222>, 
      <1.616313, -3.270204, -0.202548>, <1.569751, -3.217683, -0.163844>, <1.526098, -3.107243, -0.221540>, <1.473953, -3.050706, -0.198978>, 
      <1.594365, -3.268220, -0.216565>, <1.547306, -3.220644, -0.181450>, <1.495814, -3.108951, -0.236370>, <1.446420, -3.058241, -0.209916>, 
      <1.580753, -3.277145, -0.230417>, <1.533694, -3.229568, -0.195302>, <1.485166, -3.122695, -0.238257>, <1.435772, -3.071985, -0.211803>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.619051, -3.335831, -0.233993>, <1.573424, -3.288169, -0.186264>, <1.530036, -3.172618, -0.187559>, <1.480827, -3.115031, -0.157662>, 
      <1.633131, -3.326600, -0.219665>, <1.587503, -3.278937, -0.171935>, <1.540843, -3.158669, -0.185644>, <1.491634, -3.101081, -0.155747>, 
      <1.640046, -3.306570, -0.204764>, <1.593483, -3.254049, -0.166060>, <1.550840, -3.130882, -0.191808>, <1.498695, -3.074346, -0.169245>, 
      <1.627979, -3.288080, -0.203637>, <1.581416, -3.235559, -0.164933>, <1.538377, -3.118975, -0.206784>, <1.486232, -3.062438, -0.184222>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.619051, -3.335831, -0.233993>, <1.633131, -3.326600, -0.219665>, <1.640046, -3.306570, -0.204764>, <1.627979, -3.288080, -0.203637>, 
      <1.654079, -3.372422, -0.270635>, <1.668159, -3.363190, -0.256307>, <1.676961, -3.348209, -0.235449>, <1.664895, -3.329719, -0.234322>, 
      <1.690683, -3.362318, -0.358488>, <1.701322, -3.355344, -0.347662>, <1.704679, -3.340494, -0.334347>, <1.694068, -3.328005, -0.331111>, 
      <1.723400, -3.368422, -0.411411>, <1.734039, -3.361448, -0.400585>, <1.738100, -3.347053, -0.387995>, <1.727489, -3.334565, -0.384760>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.571831, -3.324893, -0.260775>, <1.526616, -3.283484, -0.218834>, <1.436875, -3.127664, -0.182310>, <1.432988, -3.131164, -0.193659>, 
      <1.583496, -3.342768, -0.261864>, <1.538281, -3.301359, -0.219923>, <1.438583, -3.129296, -0.180257>, <1.434696, -3.132796, -0.191607>, 
      <1.605439, -3.344755, -0.247844>, <1.559812, -3.297093, -0.200115>, <1.518710, -3.187237, -0.189567>, <1.469501, -3.129650, -0.159669>, 
      <1.619051, -3.335831, -0.233993>, <1.573424, -3.288169, -0.186264>, <1.530036, -3.172618, -0.187559>, <1.480827, -3.115031, -0.157662>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.571831, -3.324893, -0.260775>, <1.583496, -3.342768, -0.261864>, <1.605439, -3.344755, -0.247844>, <1.619051, -3.335831, -0.233993>, 
      <1.609312, -3.359218, -0.295542>, <1.620977, -3.377093, -0.296631>, <1.640468, -3.381346, -0.284487>, <1.654079, -3.372422, -0.270635>, 
      <1.653736, -3.355454, -0.375256>, <1.664009, -3.367545, -0.378388>, <1.680383, -3.369070, -0.368968>, <1.690683, -3.362318, -0.358488>, 
      <1.685293, -3.362227, -0.427696>, <1.695566, -3.374317, -0.430828>, <1.713100, -3.375174, -0.421891>, <1.723400, -3.368422, -0.411411>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.571831, -3.324893, -0.260775>, <1.609312, -3.359218, -0.295542>, <1.653736, -3.355454, -0.375256>, <1.685293, -3.362227, -0.427696>, 
      <1.559765, -3.306404, -0.259648>, <1.597246, -3.340729, -0.294415>, <1.643124, -3.342965, -0.372020>, <1.674681, -3.349738, -0.424460>, 
      <1.566674, -3.286376, -0.244745>, <1.605651, -3.325782, -0.273829>, <1.646509, -3.328080, -0.358693>, <1.678731, -3.335348, -0.411861>, 
      <1.580753, -3.277145, -0.230417>, <1.619730, -3.316551, -0.259501>, <1.657149, -3.321105, -0.347867>, <1.689371, -3.328373, -0.401035>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.571831, -3.324893, -0.260775>, <1.559765, -3.306404, -0.259648>, <1.566674, -3.286376, -0.244745>, <1.580753, -3.277145, -0.230417>, 
      <1.526616, -3.283484, -0.218834>, <1.514550, -3.264995, -0.217707>, <1.519615, -3.238799, -0.209630>, <1.533694, -3.229568, -0.195302>, 
      <1.436875, -3.127664, -0.182310>, <1.435169, -3.126034, -0.184361>, <1.473848, -3.137304, -0.240263>, <1.485166, -3.122695, -0.238257>, 
      <1.432988, -3.131164, -0.193659>, <1.431281, -3.129533, -0.195710>, <1.424454, -3.086594, -0.213809>, <1.435772, -3.071985, -0.211803>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.541342, -3.121093, -0.627344>, <1.524507, -3.131761, -0.635250>, <1.515459, -3.152609, -0.646511>, <1.528043, -3.169095, -0.651949>, 
      <1.541342, -3.121093, -0.627344>, <1.531553, -3.132777, -0.645248>, <1.526957, -3.141800, -0.651969>, <1.539541, -3.158286, -0.657407>, 
      <1.541342, -3.121093, -0.627344>, <1.531553, -3.132777, -0.645248>, <1.551578, -3.133702, -0.653874>, <1.558781, -3.143139, -0.656987>, 
      <1.541342, -3.121093, -0.627344>, <1.548388, -3.122110, -0.637342>, <1.564689, -3.125394, -0.647717>, <1.571892, -3.134831, -0.650830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.508853, -3.194090, -0.620909>, <1.511273, -3.189079, -0.632955>, <1.518906, -3.177685, -0.647612>, <1.528043, -3.169095, -0.651949>, 
      <1.491620, -3.171516, -0.613464>, <1.494040, -3.166504, -0.625510>, <1.506321, -3.161199, -0.642174>, <1.515459, -3.152609, -0.646511>, 
      <1.504007, -3.142967, -0.598039>, <1.506406, -3.137947, -0.609749>, <1.517065, -3.130687, -0.624690>, <1.524507, -3.131761, -0.635250>, 
      <1.527060, -3.128360, -0.587213>, <1.529459, -3.123341, -0.598922>, <1.533900, -3.120019, -0.616784>, <1.541342, -3.121093, -0.627344>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.595363, -3.126437, -0.620334>, <1.590993, -3.126310, -0.631312>, <1.581170, -3.128952, -0.646473>, <1.571892, -3.134831, -0.650830>, 
      <1.595363, -3.126437, -0.620334>, <1.578594, -3.110067, -0.625954>, <1.573966, -3.119515, -0.643360>, <1.564689, -3.125394, -0.647717>, 
      <1.595363, -3.126437, -0.620334>, <1.578594, -3.110067, -0.625954>, <1.564974, -3.111600, -0.629552>, <1.548388, -3.122110, -0.637342>, 
      <1.595363, -3.126437, -0.620334>, <1.582965, -3.110194, -0.614977>, <1.557928, -3.110583, -0.619555>, <1.541342, -3.121093, -0.627344>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.595363, -3.126437, -0.620334>, <1.600253, -3.126580, -0.608050>, <1.603623, -3.130576, -0.589536>, <1.601038, -3.135680, -0.577616>, 
      <1.582965, -3.110194, -0.614977>, <1.587855, -3.110337, -0.602693>, <1.586643, -3.108334, -0.582200>, <1.584058, -3.113438, -0.570280>, 
      <1.557928, -3.110583, -0.619555>, <1.550486, -3.109509, -0.608994>, <1.552173, -3.108948, -0.588255>, <1.549774, -3.113968, -0.576546>, 
      <1.541342, -3.121093, -0.627344>, <1.533900, -3.120019, -0.616784>, <1.529459, -3.123341, -0.598922>, <1.527060, -3.128360, -0.587213>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.595363, -3.126437, -0.620334>, <1.582965, -3.110194, -0.614977>, <1.557928, -3.110583, -0.619555>, <1.541342, -3.121093, -0.627344>, 
      <1.590993, -3.126310, -0.631312>, <1.578594, -3.110067, -0.625954>, <1.541093, -3.121250, -0.627461>, <1.524507, -3.131761, -0.635250>, 
      <1.581170, -3.128952, -0.646473>, <1.568059, -3.137260, -0.652630>, <1.526957, -3.141800, -0.651969>, <1.515459, -3.152609, -0.646511>, 
      <1.571892, -3.134831, -0.650830>, <1.558781, -3.143139, -0.656987>, <1.539541, -3.158286, -0.657407>, <1.528043, -3.169095, -0.651949>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.582065, -3.174441, -0.644941>, <1.583874, -3.185455, -0.638403>, <1.585322, -3.196541, -0.623028>, <1.582827, -3.201411, -0.611307>, 
      <1.598901, -3.163773, -0.637035>, <1.600710, -3.174787, -0.630497>, <1.608375, -3.181934, -0.612202>, <1.605880, -3.186804, -0.600481>, 
      <1.607948, -3.142924, -0.625772>, <1.612838, -3.143066, -0.613488>, <1.620856, -3.153150, -0.596982>, <1.618271, -3.158254, -0.585062>, 
      <1.595363, -3.126437, -0.620334>, <1.600253, -3.126580, -0.608050>, <1.603623, -3.130576, -0.589536>, <1.601038, -3.135680, -0.577616>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.582065, -3.174441, -0.644941>, <1.580332, -3.163887, -0.651206>, <1.579167, -3.144361, -0.653974>, <1.571892, -3.134831, -0.650830>, 
      <1.582065, -3.174441, -0.644941>, <1.597167, -3.153219, -0.643300>, <1.588445, -3.138483, -0.649617>, <1.581170, -3.128952, -0.646473>, 
      <1.582065, -3.174441, -0.644941>, <1.597167, -3.153219, -0.643300>, <1.603578, -3.142796, -0.636750>, <1.590993, -3.126310, -0.631312>, 
      <1.582065, -3.174441, -0.644941>, <1.598901, -3.163773, -0.637035>, <1.607948, -3.142924, -0.625772>, <1.595363, -3.126437, -0.620334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.582065, -3.174441, -0.644941>, <1.580332, -3.163887, -0.651206>, <1.579167, -3.144361, -0.653974>, <1.571892, -3.134831, -0.650830>, 
      <1.598901, -3.163773, -0.637035>, <1.597167, -3.153219, -0.643300>, <1.571964, -3.134925, -0.650861>, <1.564689, -3.125394, -0.647717>, 
      <1.607948, -3.142924, -0.625772>, <1.595550, -3.126681, -0.620415>, <1.564974, -3.111600, -0.629552>, <1.548388, -3.122110, -0.637342>, 
      <1.595363, -3.126437, -0.620334>, <1.582965, -3.110194, -0.614977>, <1.557928, -3.110583, -0.619555>, <1.541342, -3.121093, -0.627344>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.582065, -3.174441, -0.644941>, <1.598901, -3.163773, -0.637035>, <1.607948, -3.142924, -0.625772>, <1.595363, -3.126437, -0.620334>, 
      <1.565478, -3.184951, -0.652730>, <1.582314, -3.174283, -0.644824>, <1.603578, -3.142796, -0.636750>, <1.590993, -3.126310, -0.631312>, 
      <1.540442, -3.185338, -0.657307>, <1.551940, -3.174529, -0.662764>, <1.568059, -3.137260, -0.652630>, <1.581170, -3.128952, -0.646473>, 
      <1.528043, -3.169095, -0.651949>, <1.539541, -3.158286, -0.657407>, <1.558781, -3.143139, -0.656987>, <1.571892, -3.134831, -0.650830>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.582065, -3.174441, -0.644941>, <1.580332, -3.163887, -0.651206>, <1.579167, -3.144361, -0.653974>, <1.571892, -3.134831, -0.650830>, 
      <1.582065, -3.174441, -0.644941>, <1.563745, -3.174397, -0.658995>, <1.566056, -3.152669, -0.660131>, <1.558781, -3.143139, -0.656987>, 
      <1.582065, -3.174441, -0.644941>, <1.563745, -3.174397, -0.658995>, <1.551940, -3.174529, -0.662764>, <1.539541, -3.158286, -0.657407>, 
      <1.582065, -3.174441, -0.644941>, <1.565478, -3.184951, -0.652730>, <1.540442, -3.185338, -0.657307>, <1.528043, -3.169095, -0.651949>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.582065, -3.174441, -0.644941>, <1.583874, -3.185455, -0.638403>, <1.585322, -3.196541, -0.623028>, <1.582827, -3.201411, -0.611307>, 
      <1.565478, -3.184951, -0.652730>, <1.567287, -3.195965, -0.646192>, <1.562609, -3.210932, -0.633695>, <1.560114, -3.215802, -0.621974>, 
      <1.540442, -3.185338, -0.657307>, <1.531304, -3.193927, -0.652970>, <1.528252, -3.211320, -0.640291>, <1.525832, -3.216331, -0.628245>, 
      <1.528043, -3.169095, -0.651949>, <1.518906, -3.177685, -0.647612>, <1.511273, -3.189079, -0.632955>, <1.508853, -3.194090, -0.620909>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.582065, -3.174441, -0.644941>, <1.565478, -3.184951, -0.652730>, <1.540442, -3.185338, -0.657307>, <1.528043, -3.169095, -0.651949>, 
      <1.580332, -3.163887, -0.651206>, <1.563745, -3.174397, -0.658995>, <1.527857, -3.168852, -0.651869>, <1.515459, -3.152609, -0.646511>, 
      <1.579167, -3.144361, -0.653974>, <1.571964, -3.134925, -0.650861>, <1.531553, -3.132777, -0.645248>, <1.524507, -3.131761, -0.635250>, 
      <1.571892, -3.134831, -0.650830>, <1.564689, -3.125394, -0.647717>, <1.548388, -3.122110, -0.637342>, <1.541342, -3.121093, -0.627344>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.578651, -3.159432, -0.543274>, <1.566460, -3.143461, -0.538007>, <1.541843, -3.143843, -0.542508>, <1.525533, -3.154177, -0.550167>, 
      <1.582066, -3.148770, -0.552031>, <1.569875, -3.132798, -0.546764>, <1.544923, -3.133495, -0.550702>, <1.528613, -3.143829, -0.558361>, 
      <1.598259, -3.141167, -0.564802>, <1.581279, -3.118924, -0.557466>, <1.547266, -3.119216, -0.564303>, <1.524552, -3.133608, -0.574970>, 
      <1.601038, -3.135680, -0.577616>, <1.584058, -3.113438, -0.570280>, <1.549774, -3.113968, -0.576546>, <1.527060, -3.128360, -0.587213>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.565572, -3.206631, -0.567465>, <1.582126, -3.196143, -0.559691>, <1.591025, -3.175642, -0.548620>, <1.578651, -3.159432, -0.543274>, 
      <1.568971, -3.196222, -0.576539>, <1.585524, -3.185734, -0.568766>, <1.594440, -3.164980, -0.557377>, <1.582066, -3.148770, -0.552031>, 
      <1.580084, -3.206765, -0.598421>, <1.603137, -3.192158, -0.587595>, <1.615492, -3.163741, -0.572248>, <1.598259, -3.141167, -0.564802>, 
      <1.582827, -3.201411, -0.611307>, <1.605880, -3.186804, -0.600481>, <1.618271, -3.158254, -0.585062>, <1.601038, -3.135680, -0.577616>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.512458, -3.201372, -0.574359>, <1.524648, -3.217342, -0.579626>, <1.549263, -3.216964, -0.575124>, <1.565572, -3.206631, -0.567465>, 
      <1.515668, -3.190813, -0.583257>, <1.527858, -3.206784, -0.588524>, <1.552662, -3.206555, -0.584198>, <1.568971, -3.196222, -0.576539>, 
      <1.506268, -3.199443, -0.608040>, <1.523247, -3.221685, -0.615375>, <1.557371, -3.221156, -0.609088>, <1.580084, -3.206765, -0.598421>, 
      <1.508853, -3.194090, -0.620909>, <1.525832, -3.216331, -0.628245>, <1.560114, -3.215802, -0.621974>, <1.582827, -3.201411, -0.611307>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.512458, -3.201372, -0.574359>, <1.515668, -3.190813, -0.583257>, <1.506268, -3.199443, -0.608040>, <1.508853, -3.194090, -0.620909>, 
      <1.500085, -3.185163, -0.569014>, <1.503295, -3.174604, -0.577912>, <1.489035, -3.176869, -0.600594>, <1.491620, -3.171516, -0.613464>, 
      <1.508981, -3.164665, -0.557940>, <1.512061, -3.154317, -0.566134>, <1.501499, -3.148215, -0.585797>, <1.504007, -3.142967, -0.598039>, 
      <1.525533, -3.154177, -0.550167>, <1.528613, -3.143829, -0.558361>, <1.524552, -3.133608, -0.574970>, <1.527060, -3.128360, -0.587213>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.527711, -3.364614, -0.389587>, <1.512733, -3.341662, -0.388189>, <1.480871, -3.341920, -0.397379>, <1.459324, -3.355918, -0.407016>, 
      <1.557784, -3.370450, -0.461766>, <1.542805, -3.347498, -0.460369>, <1.516076, -3.341258, -0.465657>, <1.494529, -3.355255, -0.475295>, 
      <1.559812, -3.218250, -0.494965>, <1.547620, -3.202279, -0.489698>, <1.524384, -3.202494, -0.496064>, <1.508075, -3.212828, -0.503723>, 
      <1.578651, -3.159432, -0.543274>, <1.566460, -3.143461, -0.538007>, <1.541843, -3.143843, -0.542508>, <1.525533, -3.154177, -0.550167>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.527711, -3.364614, -0.389587>, <1.490990, -3.357488, -0.301450>, <1.427978, -3.135675, -0.208287>, <1.432988, -3.131164, -0.193659>, 
      <1.512733, -3.341662, -0.388189>, <1.476012, -3.334535, -0.300052>, <1.425575, -3.133379, -0.211175>, <1.430585, -3.128869, -0.196547>, 
      <1.480871, -3.341920, -0.397379>, <1.440118, -3.342687, -0.318339>, <1.403482, -3.196783, -0.275666>, <1.370594, -3.138713, -0.216888>, 
      <1.459324, -3.355918, -0.407016>, <1.418571, -3.356685, -0.327977>, <1.385353, -3.215504, -0.273287>, <1.352465, -3.157434, -0.214508>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.508017, -3.430533, -0.411560>, <1.470820, -3.431853, -0.310871>, <1.443782, -3.278921, -0.222536>, <1.409750, -3.212162, -0.145668>, 
      <1.529902, -3.416316, -0.401772>, <1.492705, -3.417636, -0.301082>, <1.463936, -3.258109, -0.225182>, <1.429904, -3.191350, -0.148314>, 
      <1.542924, -3.387926, -0.391007>, <1.506203, -3.380800, -0.302870>, <1.430649, -3.138227, -0.205078>, <1.435659, -3.133716, -0.190449>, 
      <1.527711, -3.364614, -0.389587>, <1.490990, -3.357488, -0.301450>, <1.427978, -3.135675, -0.208287>, <1.432988, -3.131164, -0.193659>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.508017, -3.430533, -0.411560>, <1.529902, -3.416316, -0.401772>, <1.542924, -3.387926, -0.391007>, <1.527711, -3.364614, -0.389587>, 
      <1.537003, -3.429504, -0.490022>, <1.558888, -3.415287, -0.480234>, <1.572997, -3.393762, -0.463186>, <1.557784, -3.370450, -0.461766>, 
      <1.545581, -3.267858, -0.514088>, <1.562135, -3.257370, -0.506314>, <1.572185, -3.234461, -0.500311>, <1.559812, -3.218250, -0.494965>, 
      <1.565572, -3.206631, -0.567465>, <1.582126, -3.196143, -0.559691>, <1.591025, -3.175642, -0.548620>, <1.578651, -3.159432, -0.543274>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.439624, -3.421837, -0.428985>, <1.399824, -3.427860, -0.338467>, <1.353947, -3.218951, -0.182342>, <1.339681, -3.227516, -0.181410>, 
      <1.454603, -3.444791, -0.430383>, <1.414803, -3.450813, -0.339865>, <1.356155, -3.221061, -0.179689>, <1.341889, -3.229625, -0.178757>, 
      <1.486468, -3.444532, -0.421198>, <1.449271, -3.445852, -0.320509>, <1.427126, -3.296121, -0.220349>, <1.393094, -3.229362, -0.143481>, 
      <1.508017, -3.430533, -0.411560>, <1.470820, -3.431853, -0.310871>, <1.443782, -3.278921, -0.222536>, <1.409750, -3.212162, -0.145668>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.439624, -3.421837, -0.428985>, <1.454603, -3.444791, -0.430383>, <1.486468, -3.444532, -0.421198>, <1.508017, -3.430533, -0.411560>, 
      <1.472641, -3.416841, -0.504077>, <1.487621, -3.439795, -0.505475>, <1.515454, -3.443503, -0.499661>, <1.537003, -3.429504, -0.490022>, 
      <1.493851, -3.262583, -0.522776>, <1.506042, -3.278554, -0.528042>, <1.529272, -3.278191, -0.521746>, <1.545581, -3.267858, -0.514088>, 
      <1.512458, -3.201372, -0.574359>, <1.524648, -3.217342, -0.579626>, <1.549263, -3.216964, -0.575124>, <1.565572, -3.206631, -0.567465>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.439624, -3.421837, -0.428985>, <1.472641, -3.416841, -0.504077>, <1.493851, -3.262583, -0.522776>, <1.512458, -3.201372, -0.574359>, 
      <1.424411, -3.398525, -0.427565>, <1.457428, -3.393529, -0.502657>, <1.481479, -3.246374, -0.517430>, <1.500085, -3.185163, -0.569014>, 
      <1.437439, -3.370135, -0.416805>, <1.472643, -3.369472, -0.485083>, <1.491522, -3.223316, -0.511496>, <1.508981, -3.164665, -0.557940>, 
      <1.459324, -3.355918, -0.407016>, <1.494529, -3.355255, -0.475295>, <1.508075, -3.212828, -0.503723>, <1.525533, -3.154177, -0.550167>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.439624, -3.421837, -0.428985>, <1.424411, -3.398525, -0.427565>, <1.437439, -3.370135, -0.416805>, <1.459324, -3.355918, -0.407016>, 
      <1.399824, -3.427860, -0.338467>, <1.384610, -3.404547, -0.337047>, <1.396685, -3.370902, -0.337765>, <1.418571, -3.356685, -0.327977>, 
      <1.353947, -3.218951, -0.182342>, <1.351784, -3.216884, -0.184942>, <1.369027, -3.232363, -0.271143>, <1.385353, -3.215504, -0.273287>, 
      <1.339681, -3.227516, -0.181410>, <1.337517, -3.225449, -0.184010>, <1.336139, -3.174293, -0.212365>, <1.352465, -3.157434, -0.214508>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.300021, -3.282429, -0.643577>, <1.283791, -3.292823, -0.646685>, <1.274158, -3.313018, -0.653069>, <1.284956, -3.328441, -0.658232>, 
      <1.300021, -3.282429, -0.643577>, <1.288536, -3.294843, -0.656706>, <1.283427, -3.303857, -0.661026>, <1.294225, -3.319281, -0.666189>, 
      <1.300021, -3.282429, -0.643577>, <1.288536, -3.294843, -0.656706>, <1.305158, -3.296684, -0.667648>, <1.311391, -3.305587, -0.670629>, 
      <1.300021, -3.282429, -0.643577>, <1.304766, -3.284449, -0.653597>, <1.317852, -3.288555, -0.665217>, <1.324085, -3.297458, -0.668198>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.273317, -3.347631, -0.624615>, <1.273387, -3.344414, -0.636307>, <1.277595, -3.335716, -0.651913>, <1.284956, -3.328441, -0.658232>, 
      <1.258531, -3.326511, -0.617544>, <1.258601, -3.323294, -0.629235>, <1.266797, -3.320292, -0.646749>, <1.274158, -3.313018, -0.653069>, 
      <1.271717, -3.298859, -0.608800>, <1.271824, -3.295592, -0.620211>, <1.278793, -3.290695, -0.636132>, <1.283791, -3.292823, -0.646685>, 
      <1.293942, -3.284625, -0.604544>, <1.294048, -3.281358, -0.615954>, <1.295023, -3.280301, -0.633023>, <1.300021, -3.282429, -0.643577>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.350242, -3.286631, -0.645729>, <1.344449, -3.287693, -0.654833>, <1.333099, -3.291685, -0.666472>, <1.324085, -3.297458, -0.668198>, 
      <1.350242, -3.286631, -0.645729>, <1.333681, -3.272313, -0.649684>, <1.326866, -3.282782, -0.663491>, <1.317852, -3.288555, -0.665217>, 
      <1.350242, -3.286631, -0.645729>, <1.333681, -3.272313, -0.649684>, <1.320951, -3.274084, -0.650498>, <1.304766, -3.284449, -0.653597>, 
      <1.350242, -3.286631, -0.645729>, <1.339475, -3.271251, -0.640580>, <1.316206, -3.272064, -0.640477>, <1.300021, -3.282429, -0.643577>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.350242, -3.286631, -0.645729>, <1.356716, -3.285444, -0.635555>, <1.362954, -3.287053, -0.619145>, <1.362715, -3.290376, -0.607494>, 
      <1.339475, -3.271251, -0.640580>, <1.345949, -3.270064, -0.630406>, <1.348209, -3.265992, -0.612093>, <1.347970, -3.269315, -0.600442>, 
      <1.316206, -3.272064, -0.640477>, <1.311208, -3.269936, -0.629924>, <1.316212, -3.267164, -0.611710>, <1.316105, -3.270431, -0.600299>, 
      <1.300021, -3.282429, -0.643577>, <1.295023, -3.280301, -0.633023>, <1.294048, -3.281358, -0.615954>, <1.293942, -3.284625, -0.604544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.350242, -3.286631, -0.645729>, <1.339475, -3.271251, -0.640580>, <1.316206, -3.272064, -0.640477>, <1.300021, -3.282429, -0.643577>, 
      <1.344449, -3.287693, -0.654833>, <1.333681, -3.272313, -0.649684>, <1.299975, -3.282458, -0.643586>, <1.283791, -3.292823, -0.646685>, 
      <1.333099, -3.291685, -0.666472>, <1.320405, -3.299814, -0.668903>, <1.283427, -3.303857, -0.661026>, <1.274158, -3.313018, -0.653069>, 
      <1.324085, -3.297458, -0.668198>, <1.311391, -3.305587, -0.670629>, <1.294225, -3.319281, -0.666189>, <1.284956, -3.328441, -0.658232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.335176, -3.332643, -0.660388>, <1.338157, -3.341906, -0.653659>, <1.342277, -3.350259, -0.638975>, <1.342081, -3.353386, -0.627566>, 
      <1.351407, -3.322248, -0.657280>, <1.354387, -3.331511, -0.650550>, <1.364504, -3.336024, -0.634718>, <1.364308, -3.339151, -0.623309>, 
      <1.361040, -3.302055, -0.650893>, <1.367515, -3.300868, -0.640719>, <1.377741, -3.308175, -0.626216>, <1.377502, -3.311497, -0.614566>, 
      <1.350242, -3.286631, -0.645729>, <1.356716, -3.285444, -0.635555>, <1.362954, -3.287053, -0.619145>, <1.362715, -3.290376, -0.607494>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.335176, -3.332643, -0.660388>, <1.332326, -3.323786, -0.666823>, <1.330342, -3.306395, -0.671190>, <1.324085, -3.297458, -0.668198>, 
      <1.335176, -3.332643, -0.660388>, <1.348557, -3.313391, -0.663714>, <1.339356, -3.300622, -0.669464>, <1.333099, -3.291685, -0.666472>, 
      <1.335176, -3.332643, -0.660388>, <1.348557, -3.313391, -0.663714>, <1.355247, -3.303117, -0.659996>, <1.344449, -3.287693, -0.654833>, 
      <1.335176, -3.332643, -0.660388>, <1.351407, -3.322248, -0.657280>, <1.361040, -3.302055, -0.650893>, <1.350242, -3.286631, -0.645729>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.335176, -3.332643, -0.660388>, <1.332326, -3.323786, -0.666823>, <1.330342, -3.306395, -0.671190>, <1.324085, -3.297458, -0.668198>, 
      <1.351407, -3.322248, -0.657280>, <1.348557, -3.313391, -0.663714>, <1.324109, -3.297492, -0.668210>, <1.317852, -3.288555, -0.665217>, 
      <1.361040, -3.302055, -0.650893>, <1.350273, -3.286675, -0.645744>, <1.320951, -3.274084, -0.650498>, <1.304766, -3.284449, -0.653597>, 
      <1.350242, -3.286631, -0.645729>, <1.339475, -3.271251, -0.640580>, <1.316206, -3.272064, -0.640477>, <1.300021, -3.282429, -0.643577>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.335176, -3.332643, -0.660388>, <1.351407, -3.322248, -0.657280>, <1.361040, -3.302055, -0.650893>, <1.350242, -3.286631, -0.645729>, 
      <1.318991, -3.343008, -0.663488>, <1.335222, -3.332613, -0.660379>, <1.355247, -3.303117, -0.659996>, <1.344449, -3.287693, -0.654833>, 
      <1.295723, -3.343821, -0.663381>, <1.304992, -3.334660, -0.671338>, <1.320405, -3.299814, -0.668903>, <1.333099, -3.291685, -0.666472>, 
      <1.284956, -3.328441, -0.658232>, <1.294225, -3.319281, -0.666189>, <1.311391, -3.305587, -0.670629>, <1.324085, -3.297458, -0.668198>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.335176, -3.332643, -0.660388>, <1.332326, -3.323786, -0.666823>, <1.330342, -3.306395, -0.671190>, <1.324085, -3.297458, -0.668198>, 
      <1.335176, -3.332643, -0.660388>, <1.316141, -3.334151, -0.669922>, <1.317648, -3.314525, -0.673621>, <1.311391, -3.305587, -0.670629>, 
      <1.335176, -3.332643, -0.660388>, <1.316141, -3.334151, -0.669922>, <1.304992, -3.334660, -0.671338>, <1.294225, -3.319281, -0.666189>, 
      <1.335176, -3.332643, -0.660388>, <1.318991, -3.343008, -0.663488>, <1.295723, -3.343821, -0.663381>, <1.284956, -3.328441, -0.658232>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.335176, -3.332643, -0.660388>, <1.338157, -3.341906, -0.653659>, <1.342277, -3.350259, -0.638975>, <1.342081, -3.353386, -0.627566>, 
      <1.318991, -3.343008, -0.663488>, <1.321972, -3.352271, -0.656758>, <1.320116, -3.364452, -0.643219>, <1.319920, -3.367578, -0.631810>, 
      <1.295723, -3.343821, -0.663381>, <1.288362, -3.351095, -0.657061>, <1.288130, -3.365472, -0.643357>, <1.288060, -3.368690, -0.631666>, 
      <1.284956, -3.328441, -0.658232>, <1.277595, -3.335716, -0.651913>, <1.273387, -3.344414, -0.636307>, <1.273317, -3.347631, -0.624615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.335176, -3.332643, -0.660388>, <1.318991, -3.343008, -0.663488>, <1.295723, -3.343821, -0.663381>, <1.284956, -3.328441, -0.658232>, 
      <1.332326, -3.323786, -0.666823>, <1.316141, -3.334151, -0.669922>, <1.284925, -3.328397, -0.658217>, <1.274158, -3.313018, -0.653069>, 
      <1.330342, -3.306395, -0.671190>, <1.324109, -3.297492, -0.668210>, <1.288536, -3.294843, -0.656706>, <1.283791, -3.292823, -0.646685>, 
      <1.324085, -3.297458, -0.668198>, <1.317852, -3.288555, -0.665217>, <1.304766, -3.284449, -0.653597>, <1.300021, -3.282429, -0.643577>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.348699, -3.308079, -0.570524>, <1.338113, -3.292956, -0.565461>, <1.315233, -3.293757, -0.565359>, <1.299319, -3.303949, -0.568407>, 
      <1.349304, -3.298884, -0.579689>, <1.338718, -3.283762, -0.574626>, <1.315641, -3.284805, -0.573928>, <1.299728, -3.294996, -0.576975>, 
      <1.362459, -3.293939, -0.594999>, <1.347714, -3.272878, -0.587947>, <1.315994, -3.273843, -0.588380>, <1.293831, -3.288038, -0.592624>, 
      <1.362715, -3.290376, -0.607494>, <1.347970, -3.269315, -0.600442>, <1.316105, -3.270431, -0.600299>, <1.293942, -3.284625, -0.604544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.333881, -3.353322, -0.584935>, <1.349841, -3.343101, -0.581879>, <1.359316, -3.323246, -0.575601>, <1.348699, -3.308079, -0.570524>, 
      <1.334462, -3.344403, -0.594407>, <1.350421, -3.334182, -0.591351>, <1.359921, -3.314051, -0.584766>, <1.349304, -3.298884, -0.579689>, 
      <1.341865, -3.356828, -0.615007>, <1.364092, -3.342593, -0.610750>, <1.377246, -3.315061, -0.602070>, <1.362459, -3.293939, -0.594999>, 
      <1.342081, -3.353386, -0.627566>, <1.364308, -3.339151, -0.623309>, <1.377502, -3.311497, -0.614566>, <1.362715, -3.290376, -0.607494>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.284503, -3.349192, -0.582818>, <1.295089, -3.364314, -0.587880>, <1.317968, -3.363513, -0.587982>, <1.333881, -3.353322, -0.584935>, 
      <1.284910, -3.340114, -0.592099>, <1.295495, -3.355236, -0.597161>, <1.318548, -3.354594, -0.597455>, <1.334462, -3.344403, -0.594407>, 
      <1.273242, -3.351077, -0.612092>, <1.287985, -3.372136, -0.619143>, <1.319705, -3.371020, -0.619251>, <1.341865, -3.356828, -0.615007>, 
      <1.273317, -3.347631, -0.624615>, <1.288060, -3.368690, -0.631666>, <1.319920, -3.367578, -0.631810>, <1.342081, -3.353386, -0.627566>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.284503, -3.349192, -0.582818>, <1.284910, -3.340114, -0.592099>, <1.273242, -3.351077, -0.612092>, <1.273317, -3.347631, -0.624615>, 
      <1.273886, -3.334025, -0.577741>, <1.274293, -3.324947, -0.587022>, <1.258456, -3.329957, -0.605021>, <1.258531, -3.326511, -0.617544>, 
      <1.283360, -3.314170, -0.571463>, <1.283768, -3.305217, -0.580032>, <1.271606, -3.302271, -0.596881>, <1.271717, -3.298859, -0.608800>, 
      <1.299319, -3.303949, -0.568407>, <1.299728, -3.294996, -0.576975>, <1.293831, -3.288038, -0.592624>, <1.293942, -3.284625, -0.604544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.350550, -3.475310, -0.423165>, <1.336744, -3.454154, -0.421876>, <1.306567, -3.455172, -0.424748>, <1.285537, -3.468772, -0.428303>, 
      <1.352067, -3.488864, -0.488629>, <1.338261, -3.467708, -0.487340>, <1.316228, -3.467392, -0.487883>, <1.295198, -3.480992, -0.491438>, 
      <1.345587, -3.355389, -0.523369>, <1.335001, -3.340266, -0.518306>, <1.313090, -3.340711, -0.520421>, <1.297176, -3.350903, -0.523469>, 
      <1.348699, -3.308079, -0.570524>, <1.338113, -3.292956, -0.565461>, <1.315233, -3.293757, -0.565359>, <1.299319, -3.303949, -0.568407>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.350550, -3.475310, -0.423165>, <1.348193, -3.454249, -0.321441>, <1.324717, -3.236499, -0.180432>, <1.339681, -3.227516, -0.181410>, 
      <1.336744, -3.454154, -0.421876>, <1.334386, -3.433093, -0.320152>, <1.321900, -3.233808, -0.183818>, <1.336864, -3.224824, -0.184796>, 
      <1.306567, -3.455172, -0.424748>, <1.290609, -3.434988, -0.320468>, <1.279959, -3.289047, -0.255547>, <1.263795, -3.214152, -0.180276>, 
      <1.285537, -3.468772, -0.428303>, <1.269579, -3.448588, -0.324023>, <1.254344, -3.301513, -0.244152>, <1.238180, -3.226619, -0.168880>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.330127, -3.537099, -0.432467>, <1.318953, -3.517309, -0.308667>, <1.305724, -3.359092, -0.199825>, <1.290638, -3.276736, -0.105842>, 
      <1.351220, -3.523458, -0.428901>, <1.340045, -3.503668, -0.305101>, <1.331435, -3.346578, -0.211263>, <1.316349, -3.264223, -0.117280>, 
      <1.364398, -3.496529, -0.424458>, <1.362040, -3.475468, -0.322734>, <1.327545, -3.239201, -0.177034>, <1.342509, -3.230217, -0.178012>, 
      <1.350550, -3.475310, -0.423165>, <1.348193, -3.454249, -0.321441>, <1.324717, -3.236499, -0.180432>, <1.339681, -3.227516, -0.181410>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.330127, -3.537099, -0.432467>, <1.351220, -3.523458, -0.428901>, <1.364398, -3.496529, -0.424458>, <1.350550, -3.475310, -0.423165>, 
      <1.336488, -3.548364, -0.502935>, <1.357580, -3.534723, -0.499369>, <1.365915, -3.510083, -0.489922>, <1.352067, -3.488864, -0.488629>, 
      <1.330688, -3.402390, -0.532826>, <1.346648, -3.392168, -0.529770>, <1.356204, -3.370556, -0.528446>, <1.345587, -3.355389, -0.523369>, 
      <1.333881, -3.353322, -0.584935>, <1.349841, -3.343101, -0.581879>, <1.359316, -3.323246, -0.575601>, <1.348699, -3.308079, -0.570524>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.265123, -3.530556, -0.437607>, <1.246555, -3.515357, -0.320474>, <1.228257, -3.280064, -0.131047>, <1.211858, -3.289728, -0.124544>, 
      <1.278928, -3.551710, -0.438896>, <1.260360, -3.536511, -0.321763>, <1.230516, -3.282222, -0.128333>, <1.214117, -3.291886, -0.121829>, 
      <1.309100, -3.550697, -0.436022>, <1.297926, -3.530907, -0.312222>, <1.285186, -3.369088, -0.190688>, <1.270100, -3.286732, -0.096705>, 
      <1.330127, -3.537099, -0.432467>, <1.318953, -3.517309, -0.308667>, <1.305724, -3.359092, -0.199825>, <1.290638, -3.276736, -0.105842>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.265123, -3.530556, -0.437607>, <1.278928, -3.551710, -0.438896>, <1.309100, -3.550697, -0.436022>, <1.330127, -3.537099, -0.432467>, 
      <1.275985, -3.539447, -0.506126>, <1.289789, -3.560600, -0.507416>, <1.315460, -3.561962, -0.506490>, <1.336488, -3.548364, -0.502935>, 
      <1.282313, -3.398076, -0.532843>, <1.292899, -3.413198, -0.537905>, <1.314775, -3.412581, -0.535874>, <1.330688, -3.402390, -0.532826>, 
      <1.284503, -3.349192, -0.582818>, <1.295089, -3.364314, -0.587880>, <1.317968, -3.363513, -0.587982>, <1.333881, -3.353322, -0.584935>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.265123, -3.530556, -0.437607>, <1.275985, -3.539447, -0.506126>, <1.282313, -3.398076, -0.532843>, <1.284503, -3.349192, -0.582818>, 
      <1.251277, -3.509339, -0.436314>, <1.262139, -3.518230, -0.504833>, <1.271696, -3.382909, -0.527766>, <1.273886, -3.334025, -0.577741>, 
      <1.264447, -3.482411, -0.431868>, <1.274108, -3.494631, -0.495003>, <1.281216, -3.361124, -0.526525>, <1.283360, -3.314170, -0.571463>, 
      <1.285537, -3.468772, -0.428303>, <1.295198, -3.480992, -0.491438>, <1.297176, -3.350903, -0.523469>, <1.299319, -3.303949, -0.568407>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.265123, -3.530556, -0.437607>, <1.251277, -3.509339, -0.436314>, <1.264447, -3.482411, -0.431868>, <1.285537, -3.468772, -0.428303>, 
      <1.246555, -3.515357, -0.320474>, <1.232709, -3.494140, -0.319181>, <1.248489, -3.462227, -0.327589>, <1.269579, -3.448588, -0.324023>, 
      <1.228257, -3.280064, -0.131047>, <1.226012, -3.277920, -0.133745>, <1.233934, -3.311447, -0.235071>, <1.254344, -3.301513, -0.244152>, 
      <1.211858, -3.289728, -0.124544>, <1.209613, -3.287583, -0.127242>, <1.217770, -3.236553, -0.159800>, <1.238180, -3.226619, -0.168880>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.066140, -3.441805, -0.581876>, <1.051669, -3.451180, -0.580212>, <1.042503, -3.469841, -0.581452>, <1.051378, -3.483985, -0.586061>, 
      <1.066140, -3.441805, -0.581876>, <1.053988, -3.454223, -0.589546>, <1.048883, -3.462815, -0.591224>, <1.057759, -3.476960, -0.595833>, 
      <1.066140, -3.441805, -0.581876>, <1.053988, -3.454223, -0.589546>, <1.066472, -3.457308, -0.601924>, <1.071641, -3.465546, -0.604608>, 
      <1.066140, -3.441805, -0.581876>, <1.068459, -3.444848, -0.591211>, <1.077851, -3.449936, -0.603233>, <1.083020, -3.458173, -0.605917>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.048096, -3.496628, -0.552430>, <1.045840, -3.495252, -0.562926>, <1.046308, -3.489567, -0.578297>, <1.051378, -3.483985, -0.586061>, 
      <1.035944, -3.477260, -0.546118>, <1.033688, -3.475884, -0.556615>, <1.037433, -3.475423, -0.573687>, <1.042503, -3.469841, -0.581452>, 
      <1.048496, -3.451709, -0.544421>, <1.046322, -3.450252, -0.554702>, <1.049231, -3.447980, -0.570395>, <1.051669, -3.451180, -0.580212>, 
      <1.068311, -3.438871, -0.546701>, <1.066136, -3.437414, -0.556982>, <1.063702, -3.438605, -0.572059>, <1.066140, -3.441805, -0.581876>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.110003, -3.446003, -0.592804>, <1.103205, -3.448035, -0.599437>, <1.091134, -3.452916, -0.606850>, <1.083020, -3.458173, -0.605917>, 
      <1.110003, -3.446003, -0.592804>, <1.094228, -3.433729, -0.594775>, <1.085965, -3.444679, -0.604166>, <1.077851, -3.449936, -0.603233>, 
      <1.110003, -3.446003, -0.592804>, <1.094228, -3.433729, -0.594775>, <1.083095, -3.435365, -0.592894>, <1.068459, -3.444848, -0.591211>, 
      <1.110003, -3.446003, -0.592804>, <1.101026, -3.431697, -0.588142>, <1.080777, -3.432322, -0.583560>, <1.066140, -3.441805, -0.581876>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.110003, -3.446003, -0.592804>, <1.117600, -3.443732, -0.585392>, <1.126263, -3.443138, -0.572210>, <1.128373, -3.444616, -0.561666>, 
      <1.101026, -3.431697, -0.588142>, <1.108623, -3.429426, -0.580730>, <1.113971, -3.423548, -0.565826>, <1.116082, -3.425026, -0.555282>, 
      <1.080777, -3.432322, -0.583560>, <1.078338, -3.429122, -0.573743>, <1.086178, -3.424430, -0.559288>, <1.088353, -3.425886, -0.549007>, 
      <1.066140, -3.441805, -0.581876>, <1.063702, -3.438605, -0.572059>, <1.066136, -3.437414, -0.556982>, <1.068311, -3.438871, -0.546701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.110003, -3.446003, -0.592804>, <1.101026, -3.431697, -0.588142>, <1.080777, -3.432322, -0.583560>, <1.066140, -3.441805, -0.581876>, 
      <1.103205, -3.448035, -0.599437>, <1.094228, -3.433729, -0.594775>, <1.066306, -3.441698, -0.581895>, <1.051669, -3.451180, -0.580212>, 
      <1.091134, -3.452916, -0.606850>, <1.079754, -3.460289, -0.605541>, <1.048883, -3.462815, -0.591224>, <1.042503, -3.469841, -0.581452>, 
      <1.083020, -3.458173, -0.605917>, <1.071641, -3.465546, -0.604608>, <1.057759, -3.476960, -0.595833>, <1.051378, -3.483985, -0.586061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.095240, -3.488181, -0.596989>, <1.099409, -3.495513, -0.590599>, <1.106061, -3.501040, -0.577681>, <1.108155, -3.502374, -0.567395>, 
      <1.109710, -3.478806, -0.598653>, <1.113879, -3.486138, -0.592264>, <1.125876, -3.488202, -0.579961>, <1.127970, -3.489536, -0.569675>, 
      <1.118878, -3.460147, -0.597413>, <1.126475, -3.457876, -0.590001>, <1.138415, -3.462506, -0.578521>, <1.140526, -3.463984, -0.567978>, 
      <1.110003, -3.446003, -0.592804>, <1.117600, -3.443732, -0.585392>, <1.126263, -3.443138, -0.572210>, <1.128373, -3.444616, -0.561666>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.095240, -3.488181, -0.596989>, <1.091267, -3.481195, -0.603078>, <1.088186, -3.466406, -0.608600>, <1.083020, -3.458173, -0.605917>, 
      <1.095240, -3.488181, -0.596989>, <1.105738, -3.471820, -0.604742>, <1.096299, -3.461149, -0.609533>, <1.091134, -3.452916, -0.606850>, 
      <1.095240, -3.488181, -0.596989>, <1.105738, -3.471820, -0.604742>, <1.112080, -3.462179, -0.604046>, <1.103205, -3.448035, -0.599437>, 
      <1.095240, -3.488181, -0.596989>, <1.109710, -3.478806, -0.598653>, <1.118878, -3.460147, -0.597413>, <1.110003, -3.446003, -0.592804>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.095240, -3.488181, -0.596989>, <1.091267, -3.481195, -0.603078>, <1.088186, -3.466406, -0.608600>, <1.083020, -3.458173, -0.605917>, 
      <1.109710, -3.478806, -0.598653>, <1.105738, -3.471820, -0.604742>, <1.083017, -3.458168, -0.605916>, <1.077851, -3.449936, -0.603233>, 
      <1.118878, -3.460147, -0.597413>, <1.109901, -3.445840, -0.592751>, <1.083095, -3.435365, -0.592894>, <1.068459, -3.444848, -0.591211>, 
      <1.110003, -3.446003, -0.592804>, <1.101026, -3.431697, -0.588142>, <1.080777, -3.432322, -0.583560>, <1.066140, -3.441805, -0.581876>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.095240, -3.488181, -0.596989>, <1.109710, -3.478806, -0.598653>, <1.118878, -3.460147, -0.597413>, <1.110003, -3.446003, -0.592804>, 
      <1.080604, -3.497664, -0.595306>, <1.095074, -3.488288, -0.596970>, <1.112080, -3.462179, -0.604046>, <1.103205, -3.448035, -0.599437>, 
      <1.060355, -3.498291, -0.590723>, <1.066735, -3.491265, -0.600495>, <1.079754, -3.460289, -0.605541>, <1.091134, -3.452916, -0.606850>, 
      <1.051378, -3.483985, -0.586061>, <1.057759, -3.476960, -0.595833>, <1.071641, -3.465546, -0.604608>, <1.083020, -3.458173, -0.605917>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.095240, -3.488181, -0.596989>, <1.091267, -3.481195, -0.603078>, <1.088186, -3.466406, -0.608600>, <1.083020, -3.458173, -0.605917>, 
      <1.095240, -3.488181, -0.596989>, <1.076631, -3.490677, -0.601394>, <1.076806, -3.473778, -0.607291>, <1.071641, -3.465546, -0.604608>, 
      <1.095240, -3.488181, -0.596989>, <1.076631, -3.490677, -0.601394>, <1.066735, -3.491265, -0.600495>, <1.057759, -3.476960, -0.595833>, 
      <1.095240, -3.488181, -0.596989>, <1.080604, -3.497664, -0.595306>, <1.060355, -3.498291, -0.590723>, <1.051378, -3.483985, -0.586061>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.095240, -3.488181, -0.596989>, <1.099409, -3.495513, -0.590599>, <1.106061, -3.501040, -0.577681>, <1.108155, -3.502374, -0.567395>, 
      <1.080604, -3.497664, -0.595306>, <1.084773, -3.504995, -0.588916>, <1.086021, -3.514024, -0.575375>, <1.088114, -3.515358, -0.565089>, 
      <1.060355, -3.498291, -0.590723>, <1.055285, -3.503873, -0.582959>, <1.058131, -3.514841, -0.569310>, <1.060387, -3.516217, -0.558814>, 
      <1.051378, -3.483985, -0.586061>, <1.046308, -3.489567, -0.578297>, <1.045840, -3.495252, -0.562926>, <1.048096, -3.496628, -0.552430>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.095240, -3.488181, -0.596989>, <1.080604, -3.497664, -0.595306>, <1.060355, -3.498291, -0.590723>, <1.051378, -3.483985, -0.586061>, 
      <1.091267, -3.481195, -0.603078>, <1.076631, -3.490677, -0.601394>, <1.051479, -3.484146, -0.586114>, <1.042503, -3.469841, -0.581452>, 
      <1.088186, -3.466406, -0.608600>, <1.083017, -3.458168, -0.605916>, <1.053988, -3.454223, -0.589546>, <1.051669, -3.451180, -0.580212>, 
      <1.083020, -3.458173, -0.605917>, <1.077851, -3.449936, -0.603233>, <1.068459, -3.444848, -0.591211>, <1.066140, -3.441805, -0.581876>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.123601, -3.455526, -0.524868>, <1.114774, -3.441460, -0.520284>, <1.094863, -3.442078, -0.515777>, <1.080471, -3.451403, -0.514122>, 
      <1.120970, -3.448125, -0.533408>, <1.112144, -3.434058, -0.528824>, <1.092191, -3.434831, -0.523734>, <1.077799, -3.444156, -0.522079>, 
      <1.130629, -3.446196, -0.550395>, <1.118338, -3.426606, -0.544011>, <1.090626, -3.427408, -0.538261>, <1.070584, -3.440393, -0.535955>, 
      <1.128373, -3.444616, -0.561666>, <1.116082, -3.425026, -0.555282>, <1.088353, -3.425886, -0.549007>, <1.068311, -3.438871, -0.546701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.109083, -3.497001, -0.528983>, <1.123312, -3.487782, -0.530619>, <1.132328, -3.469434, -0.529401>, <1.123601, -3.455526, -0.524868>, 
      <1.106418, -3.489900, -0.537812>, <1.120646, -3.480681, -0.539448>, <1.129697, -3.462033, -0.537941>, <1.120970, -3.448125, -0.533408>, 
      <1.110458, -3.503842, -0.556081>, <1.130273, -3.491003, -0.558361>, <1.142782, -3.465564, -0.556706>, <1.130629, -3.446196, -0.550395>, 
      <1.108155, -3.502374, -0.567395>, <1.127970, -3.489536, -0.569675>, <1.140526, -3.463984, -0.567978>, <1.128373, -3.444616, -0.561666>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.065953, -3.492879, -0.518239>, <1.074780, -3.506946, -0.522824>, <1.094692, -3.506326, -0.527328>, <1.109083, -3.497001, -0.528983>, 
      <1.063127, -3.485610, -0.526862>, <1.071954, -3.499677, -0.531447>, <1.092026, -3.499225, -0.536157>, <1.106418, -3.489900, -0.537812>, 
      <1.050519, -3.498106, -0.541155>, <1.062810, -3.517696, -0.547539>, <1.090417, -3.516826, -0.553775>, <1.110458, -3.503842, -0.556081>, 
      <1.048096, -3.496628, -0.552430>, <1.060387, -3.516217, -0.558814>, <1.088114, -3.515358, -0.565089>, <1.108155, -3.502374, -0.567395>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.065953, -3.492879, -0.518239>, <1.063127, -3.485610, -0.526862>, <1.050519, -3.498106, -0.541155>, <1.048096, -3.496628, -0.552430>, 
      <1.057226, -3.478971, -0.513706>, <1.054400, -3.471702, -0.522329>, <1.038367, -3.478738, -0.534844>, <1.035944, -3.477260, -0.546118>, 
      <1.066242, -3.460622, -0.512486>, <1.063570, -3.453376, -0.520443>, <1.050769, -3.453231, -0.533675>, <1.048496, -3.451709, -0.544421>, 
      <1.080471, -3.451403, -0.514122>, <1.077799, -3.444156, -0.522079>, <1.070584, -3.440393, -0.535955>, <1.068311, -3.438871, -0.546701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.177315, -3.582302, -0.402785>, <1.164885, -3.563254, -0.401625>, <1.138056, -3.564209, -0.398266>, <1.119031, -3.576451, -0.395648>, 
      <1.166297, -3.603001, -0.452762>, <1.153866, -3.583953, -0.451603>, <1.132046, -3.586125, -0.446099>, <1.113022, -3.598367, -0.443481>, 
      <1.136117, -3.490738, -0.484236>, <1.127291, -3.476672, -0.479651>, <1.107621, -3.476687, -0.477779>, <1.093230, -3.486012, -0.476124>, 
      <1.123601, -3.455526, -0.524868>, <1.114774, -3.441460, -0.520284>, <1.094863, -3.442078, -0.515777>, <1.080471, -3.451403, -0.514122>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.177315, -3.582302, -0.402785>, <1.201579, -3.536721, -0.292728>, <1.195185, -3.299554, -0.117932>, <1.211858, -3.289728, -0.124544>, 
      <1.164885, -3.563254, -0.401625>, <1.189148, -3.517673, -0.291568>, <1.192825, -3.297299, -0.120768>, <1.209498, -3.287473, -0.127380>, 
      <1.138056, -3.564209, -0.398266>, <1.152498, -3.511538, -0.283311>, <1.144755, -3.357551, -0.207633>, <1.152434, -3.263250, -0.122512>, 
      <1.119031, -3.576451, -0.395648>, <1.133473, -3.523780, -0.280693>, <1.123854, -3.359480, -0.192803>, <1.131533, -3.265179, -0.107682>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.158886, -3.637522, -0.399366>, <1.178107, -3.585673, -0.266952>, <1.174375, -3.417291, -0.146513>, <1.178418, -3.309972, -0.051342>, 
      <1.177686, -3.625424, -0.401953>, <1.196908, -3.573575, -0.269540>, <1.194622, -3.415422, -0.160879>, <1.198665, -3.308103, -0.065708>, 
      <1.189599, -3.601125, -0.403931>, <1.213862, -3.555544, -0.293874>, <1.197471, -3.301738, -0.115185>, <1.214144, -3.291912, -0.121797>, 
      <1.177315, -3.582302, -0.402785>, <1.201579, -3.536721, -0.292728>, <1.195185, -3.299554, -0.117932>, <1.211858, -3.289728, -0.124544>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.158886, -3.637522, -0.399366>, <1.177686, -3.625424, -0.401953>, <1.189599, -3.601125, -0.403931>, <1.177315, -3.582302, -0.402785>, 
      <1.150947, -3.658936, -0.454055>, <1.169748, -3.646838, -0.456642>, <1.178581, -3.621824, -0.453908>, <1.166297, -3.603001, -0.452762>, 
      <1.122656, -3.533158, -0.484029>, <1.136884, -3.523939, -0.485665>, <1.144844, -3.504646, -0.488768>, <1.136117, -3.490738, -0.484236>, 
      <1.109083, -3.497001, -0.528983>, <1.123312, -3.487782, -0.530619>, <1.132328, -3.469434, -0.529401>, <1.123601, -3.455526, -0.524868>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.100600, -3.631668, -0.392227>, <1.112965, -3.577096, -0.260941>, <1.101944, -3.405415, -0.147091>, <1.109849, -3.299144, -0.052166>, 
      <1.113031, -3.650716, -0.393387>, <1.125396, -3.596144, -0.262101>, <1.113312, -3.416276, -0.133432>, <1.121217, -3.310004, -0.038506>, 
      <1.139860, -3.649765, -0.396748>, <1.159082, -3.597916, -0.264334>, <1.157437, -3.418854, -0.134495>, <1.161480, -3.311536, -0.039324>, 
      <1.158886, -3.637522, -0.399366>, <1.178107, -3.585673, -0.266952>, <1.174375, -3.417291, -0.146513>, <1.178418, -3.309972, -0.051342>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.100600, -3.631668, -0.392227>, <1.113031, -3.650716, -0.393387>, <1.139860, -3.649765, -0.396748>, <1.158886, -3.637522, -0.399366>, 
      <1.095645, -3.653537, -0.444838>, <1.108076, -3.672586, -0.445998>, <1.131922, -3.671179, -0.451436>, <1.150947, -3.658936, -0.454055>, 
      <1.079854, -3.528633, -0.475823>, <1.088681, -3.542700, -0.480407>, <1.108264, -3.542483, -0.482374>, <1.122656, -3.533158, -0.484029>, 
      <1.065953, -3.492879, -0.518239>, <1.074780, -3.506946, -0.522824>, <1.094692, -3.506326, -0.527328>, <1.109083, -3.497001, -0.528983>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.100600, -3.631668, -0.392227>, <1.095645, -3.653537, -0.444838>, <1.079854, -3.528633, -0.475823>, <1.065953, -3.492879, -0.518239>, 
      <1.088317, -3.612846, -0.391081>, <1.083362, -3.634715, -0.443692>, <1.071127, -3.514725, -0.471290>, <1.057226, -3.478971, -0.513706>, 
      <1.100231, -3.588549, -0.393061>, <1.094222, -3.610465, -0.440893>, <1.079001, -3.495231, -0.474488>, <1.066242, -3.460622, -0.512486>, 
      <1.119031, -3.576451, -0.395648>, <1.113022, -3.598367, -0.443481>, <1.093230, -3.486012, -0.476124>, <1.080471, -3.451403, -0.514122>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.100600, -3.631668, -0.392227>, <1.088317, -3.612846, -0.391081>, <1.100231, -3.588549, -0.393061>, <1.119031, -3.576451, -0.395648>, 
      <1.112965, -3.577096, -0.260941>, <1.100681, -3.558274, -0.259795>, <1.114673, -3.535878, -0.278106>, <1.133473, -3.523780, -0.280693>, 
      <1.101944, -3.405415, -0.147091>, <1.090712, -3.394684, -0.160589>, <1.107117, -3.361025, -0.180928>, <1.123854, -3.359480, -0.192803>, 
      <1.109849, -3.299144, -0.052166>, <1.098616, -3.288413, -0.065664>, <1.114796, -3.266724, -0.095807>, <1.131533, -3.265179, -0.107682>
    }
  }
  translate  0.1*z
}
#declare ojos = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.562154, -3.426885, 2.865750>, <-0.562154, -3.541867, 2.762220>, <-0.562154, -3.727803, 2.771962>, <-0.562154, -3.831333, 2.886944>, 
      <-0.562154, -3.311903, 2.969280>, <-0.562154, -3.426886, 2.865750>, <-0.716879, -3.727803, 2.771962>, <-0.716878, -3.831333, 2.886944>, 
      <-0.562153, -3.302159, 3.155214>, <-0.716877, -3.302159, 3.155214>, <-0.848535, -3.618510, 3.078571>, <-0.848535, -3.733493, 2.975040>, 
      <-0.562153, -3.405689, 3.270196>, <-0.716877, -3.405689, 3.270196>, <-0.848535, -3.503528, 3.182101>, <-0.848535, -3.618510, 3.078571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.562154, -3.426885, 2.865750>, <-0.562154, -3.541867, 2.762220>, <-0.562154, -3.727803, 2.771962>, <-0.562154, -3.831333, 2.886944>, 
      <-0.562154, -3.311903, 2.969280>, <-0.562154, -3.426886, 2.865750>, <-0.407430, -3.727803, 2.771962>, <-0.407430, -3.831333, 2.886944>, 
      <-0.562153, -3.302159, 3.155214>, <-0.407430, -3.302159, 3.155214>, <-0.275774, -3.618511, 3.078570>, <-0.275774, -3.733492, 2.975040>, 
      <-0.562153, -3.405689, 3.270196>, <-0.407430, -3.405689, 3.270196>, <-0.275774, -3.503528, 3.182101>, <-0.275774, -3.618510, 3.078571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.562154, -3.426885, 2.865750>, <-0.562154, -3.311903, 2.969280>, <-0.562153, -3.302159, 3.155214>, <-0.562153, -3.405689, 3.270196>, 
      <-0.562154, -3.426885, 2.865750>, <-0.407430, -3.311903, 2.969280>, <-0.407430, -3.302159, 3.155214>, <-0.407430, -3.405689, 3.270196>, 
      <-0.562154, -3.426885, 2.865750>, <-0.407430, -3.311903, 2.969280>, <-0.275774, -3.399999, 3.067119>, <-0.275774, -3.503528, 3.182101>, 
      <-0.562154, -3.426885, 2.865750>, <-0.407431, -3.426885, 2.865750>, <-0.275774, -3.514980, 2.963589>, <-0.275774, -3.618510, 3.078571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.562154, -3.426885, 2.865750>, <-0.562154, -3.541867, 2.762220>, <-0.562154, -3.727803, 2.771962>, <-0.562154, -3.831333, 2.886944>, 
      <-0.562154, -3.426885, 2.865750>, <-0.407431, -3.541867, 2.762220>, <-0.407430, -3.727803, 2.771962>, <-0.407430, -3.831333, 2.886944>, 
      <-0.562154, -3.426885, 2.865750>, <-0.407431, -3.541867, 2.762220>, <-0.275775, -3.629962, 2.860059>, <-0.275774, -3.733492, 2.975040>, 
      <-0.562154, -3.426885, 2.865750>, <-0.407431, -3.426885, 2.865750>, <-0.275774, -3.514980, 2.963589>, <-0.275774, -3.618510, 3.078571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.562154, -3.426885, 2.865750>, <-0.562154, -3.541867, 2.762220>, <-0.562154, -3.727803, 2.771962>, <-0.562154, -3.831333, 2.886944>, 
      <-0.562154, -3.426885, 2.865750>, <-0.716878, -3.541867, 2.762220>, <-0.716879, -3.727803, 2.771962>, <-0.716878, -3.831333, 2.886944>, 
      <-0.562154, -3.426885, 2.865750>, <-0.716878, -3.541867, 2.762220>, <-0.848536, -3.629962, 2.860058>, <-0.848535, -3.733493, 2.975040>, 
      <-0.562154, -3.426885, 2.865750>, <-0.716877, -3.426885, 2.865750>, <-0.848535, -3.514980, 2.963589>, <-0.848535, -3.618510, 3.078571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.562154, -3.426885, 2.865750>, <-0.716877, -3.426885, 2.865750>, <-0.848535, -3.514980, 2.963589>, <-0.848535, -3.618510, 3.078571>, 
      <-0.407431, -3.426885, 2.865750>, <-0.562154, -3.426885, 2.865750>, <-0.848536, -3.629962, 2.860058>, <-0.848535, -3.733493, 2.975040>, 
      <-0.275774, -3.514980, 2.963589>, <-0.275775, -3.629962, 2.860059>, <-0.562154, -3.831333, 2.886944>, <-0.716878, -3.831333, 2.886944>, 
      <-0.275774, -3.618510, 3.078571>, <-0.275774, -3.733492, 2.975040>, <-0.407430, -3.831333, 2.886944>, <-0.562154, -3.831333, 2.886944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.562154, -3.426885, 2.865750>, <-0.562154, -3.311903, 2.969280>, <-0.562153, -3.302159, 3.155214>, <-0.562153, -3.405689, 3.270196>, 
      <-0.562154, -3.426885, 2.865750>, <-0.716877, -3.311903, 2.969280>, <-0.716877, -3.302159, 3.155214>, <-0.716877, -3.405689, 3.270196>, 
      <-0.562154, -3.426885, 2.865750>, <-0.716877, -3.311903, 2.969280>, <-0.848535, -3.399998, 3.067119>, <-0.848535, -3.503528, 3.182101>, 
      <-0.562154, -3.426885, 2.865750>, <-0.716877, -3.426885, 2.865750>, <-0.848535, -3.514980, 2.963589>, <-0.848535, -3.618510, 3.078571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.562154, -3.426885, 2.865750>, <-0.407431, -3.426885, 2.865750>, <-0.275774, -3.514980, 2.963589>, <-0.275774, -3.618510, 3.078571>, 
      <-0.716877, -3.426885, 2.865750>, <-0.562154, -3.426885, 2.865750>, <-0.275774, -3.399999, 3.067119>, <-0.275774, -3.503528, 3.182101>, 
      <-0.848535, -3.514980, 2.963589>, <-0.848535, -3.399998, 3.067119>, <-0.562154, -3.405689, 3.270196>, <-0.407430, -3.405689, 3.270196>, 
      <-0.848535, -3.618510, 3.078571>, <-0.848535, -3.503528, 3.182101>, <-0.716877, -3.405689, 3.270196>, <-0.562153, -3.405689, 3.270196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.562153, -3.810136, 3.291395>, <-0.562153, -3.695154, 3.394925>, <-0.562153, -3.509219, 3.385178>, <-0.562153, -3.405689, 3.270196>, 
      <-0.562153, -3.925119, 3.187864>, <-0.562153, -3.810137, 3.291394>, <-0.407430, -3.509219, 3.385178>, <-0.407430, -3.405689, 3.270196>, 
      <-0.562154, -3.934864, 3.001927>, <-0.407430, -3.934864, 3.001927>, <-0.275774, -3.618511, 3.078570>, <-0.275774, -3.503528, 3.182101>, 
      <-0.562154, -3.831333, 2.886944>, <-0.407430, -3.831333, 2.886944>, <-0.275774, -3.733492, 2.975040>, <-0.275774, -3.618510, 3.078571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.562153, -3.810136, 3.291395>, <-0.562153, -3.695154, 3.394925>, <-0.562153, -3.509219, 3.385178>, <-0.562153, -3.405689, 3.270196>, 
      <-0.562153, -3.925119, 3.187864>, <-0.562153, -3.810137, 3.291394>, <-0.716877, -3.509219, 3.385178>, <-0.716877, -3.405689, 3.270196>, 
      <-0.562154, -3.934864, 3.001927>, <-0.716878, -3.934864, 3.001927>, <-0.848535, -3.618510, 3.078571>, <-0.848535, -3.503528, 3.182101>, 
      <-0.562154, -3.831333, 2.886944>, <-0.716878, -3.831333, 2.886944>, <-0.848535, -3.733493, 2.975040>, <-0.848535, -3.618510, 3.078571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.562153, -3.810136, 3.291395>, <-0.562153, -3.925119, 3.187864>, <-0.562154, -3.934864, 3.001927>, <-0.562154, -3.831333, 2.886944>, 
      <-0.716877, -3.810136, 3.291395>, <-0.716878, -3.925119, 3.187864>, <-0.562154, -3.831334, 2.886945>, <-0.562154, -3.727803, 2.771962>, 
      <-0.848535, -3.722041, 3.193554>, <-0.848535, -3.618510, 3.078572>, <-0.716878, -3.541867, 2.762220>, <-0.562154, -3.541867, 2.762220>, 
      <-0.848535, -3.618510, 3.078571>, <-0.848535, -3.514980, 2.963589>, <-0.716877, -3.426885, 2.865750>, <-0.562154, -3.426885, 2.865750>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.562153, -3.810136, 3.291395>, <-0.716877, -3.810136, 3.291395>, <-0.848535, -3.722041, 3.193554>, <-0.848535, -3.618510, 3.078571>, 
      <-0.562153, -3.695154, 3.394925>, <-0.716877, -3.695154, 3.394925>, <-0.848535, -3.618510, 3.078572>, <-0.848535, -3.514980, 2.963589>, 
      <-0.562153, -3.509219, 3.385178>, <-0.562153, -3.405689, 3.270196>, <-0.716877, -3.311903, 2.969280>, <-0.716877, -3.426885, 2.865750>, 
      <-0.562153, -3.405689, 3.270196>, <-0.562153, -3.302159, 3.155214>, <-0.562154, -3.311903, 2.969280>, <-0.562154, -3.426885, 2.865750>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.562153, -3.810136, 3.291395>, <-0.716877, -3.810136, 3.291395>, <-0.848535, -3.722041, 3.193554>, <-0.848535, -3.618510, 3.078571>, 
      <-0.562153, -3.810136, 3.291395>, <-0.716878, -3.925119, 3.187864>, <-0.848535, -3.837023, 3.090023>, <-0.848535, -3.733493, 2.975040>, 
      <-0.562153, -3.810136, 3.291395>, <-0.716878, -3.925119, 3.187864>, <-0.716878, -3.934864, 3.001927>, <-0.716878, -3.831333, 2.886944>, 
      <-0.562153, -3.810136, 3.291395>, <-0.562153, -3.925119, 3.187864>, <-0.562154, -3.934864, 3.001927>, <-0.562154, -3.831333, 2.886944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.562153, -3.810136, 3.291395>, <-0.562153, -3.695154, 3.394925>, <-0.562153, -3.509219, 3.385178>, <-0.562153, -3.405689, 3.270196>, 
      <-0.562153, -3.810136, 3.291395>, <-0.716877, -3.695154, 3.394925>, <-0.716877, -3.509219, 3.385178>, <-0.716877, -3.405689, 3.270196>, 
      <-0.562153, -3.810136, 3.291395>, <-0.716877, -3.695154, 3.394925>, <-0.848534, -3.607058, 3.297084>, <-0.848535, -3.503528, 3.182101>, 
      <-0.562153, -3.810136, 3.291395>, <-0.716877, -3.810136, 3.291395>, <-0.848535, -3.722041, 3.193554>, <-0.848535, -3.618510, 3.078571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.562153, -3.810136, 3.291395>, <-0.562153, -3.925119, 3.187864>, <-0.562154, -3.934864, 3.001927>, <-0.562154, -3.831333, 2.886944>, 
      <-0.407429, -3.810136, 3.291395>, <-0.407430, -3.925119, 3.187864>, <-0.562154, -3.831334, 2.886945>, <-0.562154, -3.727803, 2.771962>, 
      <-0.275774, -3.722040, 3.193553>, <-0.275774, -3.618510, 3.078572>, <-0.407431, -3.541867, 2.762220>, <-0.562154, -3.541867, 2.762220>, 
      <-0.275774, -3.618510, 3.078571>, <-0.275774, -3.514980, 2.963589>, <-0.407431, -3.426885, 2.865750>, <-0.562154, -3.426885, 2.865750>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.562153, -3.810136, 3.291395>, <-0.562153, -3.695154, 3.394925>, <-0.562153, -3.509219, 3.385178>, <-0.562153, -3.405689, 3.270196>, 
      <-0.407429, -3.810136, 3.291395>, <-0.407429, -3.695154, 3.394925>, <-0.562153, -3.405689, 3.270196>, <-0.562153, -3.302159, 3.155214>, 
      <-0.275774, -3.722040, 3.193553>, <-0.275774, -3.618510, 3.078572>, <-0.407430, -3.311903, 2.969280>, <-0.562154, -3.311903, 2.969280>, 
      <-0.275774, -3.618510, 3.078571>, <-0.275774, -3.514980, 2.963589>, <-0.407431, -3.426885, 2.865750>, <-0.562154, -3.426885, 2.865750>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.562153, -3.810136, 3.291395>, <-0.562153, -3.695154, 3.394925>, <-0.562153, -3.509219, 3.385178>, <-0.562153, -3.405689, 3.270196>, 
      <-0.562153, -3.810136, 3.291395>, <-0.407429, -3.695154, 3.394925>, <-0.407430, -3.509219, 3.385178>, <-0.407430, -3.405689, 3.270196>, 
      <-0.562153, -3.810136, 3.291395>, <-0.407429, -3.695154, 3.394925>, <-0.275774, -3.607059, 3.297083>, <-0.275774, -3.503528, 3.182101>, 
      <-0.562153, -3.810136, 3.291395>, <-0.407429, -3.810136, 3.291395>, <-0.275774, -3.722040, 3.193553>, <-0.275774, -3.618510, 3.078571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.562153, -3.810136, 3.291395>, <-0.716877, -3.810136, 3.291395>, <-0.848535, -3.722041, 3.193554>, <-0.848535, -3.618510, 3.078571>, 
      <-0.407429, -3.810136, 3.291395>, <-0.562154, -3.810136, 3.291395>, <-0.848534, -3.607058, 3.297084>, <-0.848535, -3.503528, 3.182101>, 
      <-0.275774, -3.722040, 3.193553>, <-0.275774, -3.607059, 3.297083>, <-0.562154, -3.405689, 3.270196>, <-0.716877, -3.405689, 3.270196>, 
      <-0.275774, -3.618510, 3.078571>, <-0.275774, -3.503528, 3.182101>, <-0.407430, -3.405689, 3.270196>, <-0.562153, -3.405689, 3.270196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.562153, -3.810136, 3.291395>, <-0.562153, -3.925119, 3.187864>, <-0.562154, -3.934864, 3.001927>, <-0.562154, -3.831333, 2.886944>, 
      <-0.562153, -3.810136, 3.291395>, <-0.407430, -3.925119, 3.187864>, <-0.407430, -3.934864, 3.001927>, <-0.407430, -3.831333, 2.886944>, 
      <-0.562153, -3.810136, 3.291395>, <-0.407430, -3.925119, 3.187864>, <-0.275774, -3.837022, 3.090023>, <-0.275774, -3.733492, 2.975040>, 
      <-0.562153, -3.810136, 3.291395>, <-0.407429, -3.810136, 3.291395>, <-0.275774, -3.722040, 3.193553>, <-0.275774, -3.618510, 3.078571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.562153, -3.810136, 3.291395>, <-0.407429, -3.810136, 3.291395>, <-0.275774, -3.722040, 3.193553>, <-0.275774, -3.618510, 3.078571>, 
      <-0.716877, -3.810136, 3.291395>, <-0.562154, -3.810136, 3.291395>, <-0.275774, -3.837022, 3.090023>, <-0.275774, -3.733492, 2.975040>, 
      <-0.848535, -3.722041, 3.193554>, <-0.848535, -3.837023, 3.090023>, <-0.562154, -3.831333, 2.886944>, <-0.407430, -3.831333, 2.886944>, 
      <-0.848535, -3.618510, 3.078571>, <-0.848535, -3.733493, 2.975040>, <-0.716878, -3.831333, 2.886944>, <-0.562154, -3.831333, 2.886944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.539504, -3.426885, 2.865750>, <0.539504, -3.541867, 2.762220>, <0.539504, -3.727803, 2.771962>, <0.539504, -3.831333, 2.886944>, 
      <0.539504, -3.311903, 2.969280>, <0.539504, -3.426886, 2.865750>, <0.384780, -3.727803, 2.771962>, <0.384780, -3.831333, 2.886944>, 
      <0.539505, -3.302159, 3.155214>, <0.384781, -3.302159, 3.155214>, <0.253123, -3.618510, 3.078571>, <0.253123, -3.733493, 2.975040>, 
      <0.539505, -3.405689, 3.270196>, <0.384781, -3.405689, 3.270196>, <0.253123, -3.503528, 3.182101>, <0.253123, -3.618510, 3.078571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.539504, -3.426885, 2.865750>, <0.539504, -3.541867, 2.762220>, <0.539504, -3.727803, 2.771962>, <0.539504, -3.831333, 2.886944>, 
      <0.539504, -3.311903, 2.969280>, <0.539504, -3.426886, 2.865750>, <0.694228, -3.727803, 2.771962>, <0.694228, -3.831333, 2.886944>, 
      <0.539505, -3.302159, 3.155214>, <0.694228, -3.302159, 3.155214>, <0.825884, -3.618511, 3.078570>, <0.825884, -3.733492, 2.975040>, 
      <0.539505, -3.405689, 3.270196>, <0.694228, -3.405689, 3.270196>, <0.825884, -3.503528, 3.182101>, <0.825884, -3.618510, 3.078571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.539504, -3.426885, 2.865750>, <0.539504, -3.311903, 2.969280>, <0.539505, -3.302159, 3.155214>, <0.539505, -3.405689, 3.270196>, 
      <0.539504, -3.426885, 2.865750>, <0.694228, -3.311903, 2.969280>, <0.694228, -3.302159, 3.155214>, <0.694228, -3.405689, 3.270196>, 
      <0.539504, -3.426885, 2.865750>, <0.694228, -3.311903, 2.969280>, <0.825884, -3.399999, 3.067119>, <0.825884, -3.503528, 3.182101>, 
      <0.539504, -3.426885, 2.865750>, <0.694227, -3.426885, 2.865750>, <0.825884, -3.514980, 2.963589>, <0.825884, -3.618510, 3.078571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.539504, -3.426885, 2.865750>, <0.539504, -3.541867, 2.762220>, <0.539504, -3.727803, 2.771962>, <0.539504, -3.831333, 2.886944>, 
      <0.539504, -3.426885, 2.865750>, <0.694227, -3.541867, 2.762220>, <0.694228, -3.727803, 2.771962>, <0.694228, -3.831333, 2.886944>, 
      <0.539504, -3.426885, 2.865750>, <0.694227, -3.541867, 2.762220>, <0.825883, -3.629962, 2.860059>, <0.825884, -3.733492, 2.975040>, 
      <0.539504, -3.426885, 2.865750>, <0.694227, -3.426885, 2.865750>, <0.825884, -3.514980, 2.963589>, <0.825884, -3.618510, 3.078571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.539504, -3.426885, 2.865750>, <0.539504, -3.541867, 2.762220>, <0.539504, -3.727803, 2.771962>, <0.539504, -3.831333, 2.886944>, 
      <0.539504, -3.426885, 2.865750>, <0.384780, -3.541867, 2.762220>, <0.384780, -3.727803, 2.771962>, <0.384780, -3.831333, 2.886944>, 
      <0.539504, -3.426885, 2.865750>, <0.384780, -3.541867, 2.762220>, <0.253122, -3.629962, 2.860058>, <0.253123, -3.733493, 2.975040>, 
      <0.539504, -3.426885, 2.865750>, <0.384781, -3.426885, 2.865750>, <0.253123, -3.514980, 2.963589>, <0.253123, -3.618510, 3.078571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.539504, -3.426885, 2.865750>, <0.384781, -3.426885, 2.865750>, <0.253123, -3.514980, 2.963589>, <0.253123, -3.618510, 3.078571>, 
      <0.694227, -3.426885, 2.865750>, <0.539504, -3.426885, 2.865750>, <0.253122, -3.629962, 2.860058>, <0.253123, -3.733493, 2.975040>, 
      <0.825884, -3.514980, 2.963589>, <0.825883, -3.629962, 2.860059>, <0.539504, -3.831333, 2.886944>, <0.384780, -3.831333, 2.886944>, 
      <0.825884, -3.618510, 3.078571>, <0.825884, -3.733492, 2.975040>, <0.694228, -3.831333, 2.886944>, <0.539504, -3.831333, 2.886944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.539504, -3.426885, 2.865750>, <0.539504, -3.311903, 2.969280>, <0.539505, -3.302159, 3.155214>, <0.539505, -3.405689, 3.270196>, 
      <0.539504, -3.426885, 2.865750>, <0.384781, -3.311903, 2.969280>, <0.384781, -3.302159, 3.155214>, <0.384781, -3.405689, 3.270196>, 
      <0.539504, -3.426885, 2.865750>, <0.384781, -3.311903, 2.969280>, <0.253123, -3.399998, 3.067119>, <0.253123, -3.503528, 3.182101>, 
      <0.539504, -3.426885, 2.865750>, <0.384781, -3.426885, 2.865750>, <0.253123, -3.514980, 2.963589>, <0.253123, -3.618510, 3.078571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.539504, -3.426885, 2.865750>, <0.694227, -3.426885, 2.865750>, <0.825884, -3.514980, 2.963589>, <0.825884, -3.618510, 3.078571>, 
      <0.384781, -3.426885, 2.865750>, <0.539504, -3.426885, 2.865750>, <0.825884, -3.399999, 3.067119>, <0.825884, -3.503528, 3.182101>, 
      <0.253123, -3.514980, 2.963589>, <0.253123, -3.399998, 3.067119>, <0.539504, -3.405689, 3.270196>, <0.694228, -3.405689, 3.270196>, 
      <0.253123, -3.618510, 3.078571>, <0.253123, -3.503528, 3.182101>, <0.384781, -3.405689, 3.270196>, <0.539505, -3.405689, 3.270196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.539505, -3.810136, 3.291395>, <0.539505, -3.695154, 3.394925>, <0.539505, -3.509219, 3.385178>, <0.539505, -3.405689, 3.270196>, 
      <0.539505, -3.925119, 3.187864>, <0.539505, -3.810137, 3.291394>, <0.694228, -3.509219, 3.385178>, <0.694228, -3.405689, 3.270196>, 
      <0.539504, -3.934864, 3.001927>, <0.694228, -3.934864, 3.001927>, <0.825884, -3.618511, 3.078570>, <0.825884, -3.503528, 3.182101>, 
      <0.539504, -3.831333, 2.886944>, <0.694228, -3.831333, 2.886944>, <0.825884, -3.733492, 2.975040>, <0.825884, -3.618510, 3.078571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.539505, -3.810136, 3.291395>, <0.539505, -3.695154, 3.394925>, <0.539505, -3.509219, 3.385178>, <0.539505, -3.405689, 3.270196>, 
      <0.539505, -3.925119, 3.187864>, <0.539505, -3.810137, 3.291394>, <0.384782, -3.509219, 3.385178>, <0.384781, -3.405689, 3.270196>, 
      <0.539504, -3.934864, 3.001927>, <0.384780, -3.934864, 3.001927>, <0.253123, -3.618510, 3.078571>, <0.253123, -3.503528, 3.182101>, 
      <0.539504, -3.831333, 2.886944>, <0.384780, -3.831333, 2.886944>, <0.253123, -3.733493, 2.975040>, <0.253123, -3.618510, 3.078571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.539505, -3.810136, 3.291395>, <0.539505, -3.925119, 3.187864>, <0.539504, -3.934864, 3.001927>, <0.539504, -3.831333, 2.886944>, 
      <0.384781, -3.810136, 3.291395>, <0.384780, -3.925119, 3.187864>, <0.539504, -3.831334, 2.886945>, <0.539504, -3.727803, 2.771962>, 
      <0.253123, -3.722041, 3.193554>, <0.253123, -3.618510, 3.078572>, <0.384780, -3.541867, 2.762220>, <0.539504, -3.541867, 2.762220>, 
      <0.253123, -3.618510, 3.078571>, <0.253123, -3.514980, 2.963589>, <0.384781, -3.426885, 2.865750>, <0.539504, -3.426885, 2.865750>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.539505, -3.810136, 3.291395>, <0.384781, -3.810136, 3.291395>, <0.253123, -3.722041, 3.193554>, <0.253123, -3.618510, 3.078571>, 
      <0.539505, -3.695154, 3.394925>, <0.384781, -3.695154, 3.394925>, <0.253123, -3.618510, 3.078572>, <0.253123, -3.514980, 2.963589>, 
      <0.539505, -3.509219, 3.385178>, <0.539505, -3.405689, 3.270196>, <0.384781, -3.311903, 2.969280>, <0.384781, -3.426885, 2.865750>, 
      <0.539505, -3.405689, 3.270196>, <0.539505, -3.302159, 3.155214>, <0.539504, -3.311903, 2.969280>, <0.539504, -3.426885, 2.865750>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.539505, -3.810136, 3.291395>, <0.384781, -3.810136, 3.291395>, <0.253123, -3.722041, 3.193554>, <0.253123, -3.618510, 3.078571>, 
      <0.539505, -3.810136, 3.291395>, <0.384780, -3.925119, 3.187864>, <0.253123, -3.837023, 3.090023>, <0.253123, -3.733493, 2.975040>, 
      <0.539505, -3.810136, 3.291395>, <0.384780, -3.925119, 3.187864>, <0.384780, -3.934864, 3.001927>, <0.384780, -3.831333, 2.886944>, 
      <0.539505, -3.810136, 3.291395>, <0.539505, -3.925119, 3.187864>, <0.539504, -3.934864, 3.001927>, <0.539504, -3.831333, 2.886944>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.539505, -3.810136, 3.291395>, <0.539505, -3.695154, 3.394925>, <0.539505, -3.509219, 3.385178>, <0.539505, -3.405689, 3.270196>, 
      <0.539505, -3.810136, 3.291395>, <0.384781, -3.695154, 3.394925>, <0.384782, -3.509219, 3.385178>, <0.384781, -3.405689, 3.270196>, 
      <0.539505, -3.810136, 3.291395>, <0.384781, -3.695154, 3.394925>, <0.253124, -3.607058, 3.297084>, <0.253123, -3.503528, 3.182101>, 
      <0.539505, -3.810136, 3.291395>, <0.384781, -3.810136, 3.291395>, <0.253123, -3.722041, 3.193554>, <0.253123, -3.618510, 3.078571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.539505, -3.810136, 3.291395>, <0.539505, -3.925119, 3.187864>, <0.539504, -3.934864, 3.001927>, <0.539504, -3.831333, 2.886944>, 
      <0.694229, -3.810136, 3.291395>, <0.694228, -3.925119, 3.187864>, <0.539504, -3.831334, 2.886945>, <0.539504, -3.727803, 2.771962>, 
      <0.825884, -3.722040, 3.193553>, <0.825884, -3.618510, 3.078572>, <0.694227, -3.541867, 2.762220>, <0.539504, -3.541867, 2.762220>, 
      <0.825884, -3.618510, 3.078571>, <0.825884, -3.514980, 2.963589>, <0.694227, -3.426885, 2.865750>, <0.539504, -3.426885, 2.865750>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.539505, -3.810136, 3.291395>, <0.539505, -3.695154, 3.394925>, <0.539505, -3.509219, 3.385178>, <0.539505, -3.405689, 3.270196>, 
      <0.694229, -3.810136, 3.291395>, <0.694229, -3.695154, 3.394925>, <0.539505, -3.405689, 3.270196>, <0.539505, -3.302159, 3.155214>, 
      <0.825884, -3.722040, 3.193553>, <0.825884, -3.618510, 3.078572>, <0.694228, -3.311903, 2.969280>, <0.539504, -3.311903, 2.969280>, 
      <0.825884, -3.618510, 3.078571>, <0.825884, -3.514980, 2.963589>, <0.694227, -3.426885, 2.865750>, <0.539504, -3.426885, 2.865750>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.539505, -3.810136, 3.291395>, <0.539505, -3.695154, 3.394925>, <0.539505, -3.509219, 3.385178>, <0.539505, -3.405689, 3.270196>, 
      <0.539505, -3.810136, 3.291395>, <0.694229, -3.695154, 3.394925>, <0.694228, -3.509219, 3.385178>, <0.694228, -3.405689, 3.270196>, 
      <0.539505, -3.810136, 3.291395>, <0.694229, -3.695154, 3.394925>, <0.825885, -3.607059, 3.297083>, <0.825884, -3.503528, 3.182101>, 
      <0.539505, -3.810136, 3.291395>, <0.694229, -3.810136, 3.291395>, <0.825884, -3.722040, 3.193553>, <0.825884, -3.618510, 3.078571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.539505, -3.810136, 3.291395>, <0.384781, -3.810136, 3.291395>, <0.253123, -3.722041, 3.193554>, <0.253123, -3.618510, 3.078571>, 
      <0.694229, -3.810136, 3.291395>, <0.539504, -3.810136, 3.291395>, <0.253124, -3.607058, 3.297084>, <0.253123, -3.503528, 3.182101>, 
      <0.825884, -3.722040, 3.193553>, <0.825885, -3.607059, 3.297083>, <0.539504, -3.405689, 3.270196>, <0.384781, -3.405689, 3.270196>, 
      <0.825884, -3.618510, 3.078571>, <0.825884, -3.503528, 3.182101>, <0.694228, -3.405689, 3.270196>, <0.539505, -3.405689, 3.270196>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.539505, -3.810136, 3.291395>, <0.539505, -3.925119, 3.187864>, <0.539504, -3.934864, 3.001927>, <0.539504, -3.831333, 2.886944>, 
      <0.539505, -3.810136, 3.291395>, <0.694228, -3.925119, 3.187864>, <0.694228, -3.934864, 3.001927>, <0.694228, -3.831333, 2.886944>, 
      <0.539505, -3.810136, 3.291395>, <0.694228, -3.925119, 3.187864>, <0.825884, -3.837022, 3.090023>, <0.825884, -3.733492, 2.975040>, 
      <0.539505, -3.810136, 3.291395>, <0.694229, -3.810136, 3.291395>, <0.825884, -3.722040, 3.193553>, <0.825884, -3.618510, 3.078571>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.539505, -3.810136, 3.291395>, <0.694229, -3.810136, 3.291395>, <0.825884, -3.722040, 3.193553>, <0.825884, -3.618510, 3.078571>, 
      <0.384781, -3.810136, 3.291395>, <0.539504, -3.810136, 3.291395>, <0.825884, -3.837022, 3.090023>, <0.825884, -3.733492, 2.975040>, 
      <0.253123, -3.722041, 3.193554>, <0.253123, -3.837023, 3.090023>, <0.539504, -3.831333, 2.886944>, <0.694228, -3.831333, 2.886944>, 
      <0.253123, -3.618510, 3.078571>, <0.253123, -3.733493, 2.975040>, <0.384780, -3.831333, 2.886944>, <0.539504, -3.831333, 2.886944>
    }
  }
  material {
    ojo
  }
}
#declare sPatchObj7 = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.271485, -1.058539, -0.194720>, <0.217565, -0.960602, -0.249521>, <0.125137, -0.805556, -0.224146>, <0.070779, -0.695387, -0.203893>, 
      <0.304737, -1.051625, -0.188494>, <0.250818, -0.953687, -0.243295>, <0.132838, -0.803522, -0.222315>, <0.078480, -0.693353, -0.202062>, 
      <0.337858, -1.023220, -0.162919>, <0.267033, -0.940375, -0.227524>, <0.159826, -0.788389, -0.202104>, <0.085499, -0.685997, -0.195439>, 
      <0.358827, -1.002833, -0.144563>, <0.288002, -0.919988, -0.209168>, <0.163909, -0.783127, -0.197366>, <0.089582, -0.680735, -0.190701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.020767, -1.073127, -0.207856>, <0.020902, -0.973335, -0.258610>, <0.018099, -0.809595, -0.230643>, <0.016807, -0.699958, -0.208008>, 
      <0.096213, -1.073127, -0.207856>, <0.096348, -0.973335, -0.258610>, <0.034396, -0.809595, -0.230643>, <0.033103, -0.699958, -0.208008>, 
      <0.198830, -1.073646, -0.208323>, <0.144910, -0.975709, -0.263124>, <0.109781, -0.809612, -0.227798>, <0.055424, -0.699443, -0.207545>, 
      <0.271485, -1.058539, -0.194720>, <0.217565, -0.960602, -0.249521>, <0.125137, -0.805556, -0.224146>, <0.070779, -0.695387, -0.203893>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.240510, -1.058539, -0.194720>, <-0.184522, -0.961438, -0.249053>, <-0.093888, -0.805570, -0.224149>, <-0.039438, -0.695387, -0.203893>, 
      <-0.164649, -1.073835, -0.208493>, <-0.108661, -0.976734, -0.262826>, <-0.077841, -0.809681, -0.227850>, <-0.023390, -0.699498, -0.207594>, 
      <-0.057837, -1.073127, -0.207856>, <-0.057702, -0.973335, -0.258610>, <0.001125, -0.809595, -0.230643>, <-0.000167, -0.699958, -0.208008>, 
      <0.020767, -1.073127, -0.207856>, <0.020902, -0.973335, -0.258610>, <0.018099, -0.809595, -0.230643>, <0.016807, -0.699958, -0.208008>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.327850, -1.002833, -0.144562>, <-0.255306, -0.920852, -0.208494>, <-0.132669, -0.783140, -0.197367>, <-0.058240, -0.680735, -0.190701>, 
      <-0.306881, -1.023219, -0.162918>, <-0.234337, -0.941238, -0.226850>, <-0.128586, -0.788402, -0.202104>, <-0.054157, -0.685997, -0.195439>, 
      <-0.273834, -1.051820, -0.188670>, <-0.217846, -0.954718, -0.243003>, <-0.101615, -0.803591, -0.222367>, <-0.047165, -0.693408, -0.202111>, 
      <-0.240510, -1.058539, -0.194720>, <-0.184522, -0.961438, -0.249053>, <-0.093888, -0.805570, -0.224149>, <-0.039438, -0.695387, -0.203893>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.089071, -0.641893, -0.155726>, <0.083981, -0.629028, -0.144143>, <0.076994, -0.611415, -0.128284>, <0.066700, -0.600402, -0.118368>, 
      <0.215243, -0.710879, -0.116994>, <0.210153, -0.698014, -0.105411>, <0.152364, -0.611193, -0.034058>, <0.142070, -0.600180, -0.024142>, 
      <0.427081, -0.808981, -0.133437>, <0.423369, -0.742391, -0.073480>, <0.375149, -0.691744, -0.001189>, <0.311384, -0.644880, 0.041008>, 
      <0.509645, -0.871845, -0.026620>, <0.505933, -0.805255, 0.033337>, <0.422804, -0.726806, 0.103972>, <0.359039, -0.679942, 0.146169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.092968, -0.666791, -0.178145>, <0.092869, -0.659272, -0.171374>, <0.091925, -0.649107, -0.162222>, <0.089071, -0.641893, -0.155726>, 
      <0.177444, -0.754253, -0.156049>, <0.177345, -0.746734, -0.149279>, <0.218098, -0.718093, -0.123490>, <0.215243, -0.710879, -0.116994>, 
      <0.302608, -0.888131, -0.176392>, <0.337385, -0.857926, -0.149195>, <0.429294, -0.848700, -0.169199>, <0.427081, -0.808981, -0.133437>, 
      <0.374556, -0.958332, -0.104493>, <0.409333, -0.928128, -0.077297>, <0.511859, -0.911563, -0.062382>, <0.509645, -0.871845, -0.026620>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.092968, -0.666791, -0.178145>, <0.177444, -0.754253, -0.156049>, <0.302608, -0.888131, -0.176392>, <0.374556, -0.958332, -0.104493>, 
      <0.093024, -0.671042, -0.181972>, <0.177500, -0.758504, -0.159877>, <0.290532, -0.898619, -0.185835>, <0.362480, -0.968820, -0.113937>, 
      <0.092439, -0.677052, -0.187385>, <0.166767, -0.779445, -0.194050>, <0.299282, -0.909022, -0.199294>, <0.370107, -0.991866, -0.134689>, 
      <0.089582, -0.680735, -0.190701>, <0.163909, -0.783127, -0.197366>, <0.288002, -0.919988, -0.209168>, <0.358827, -1.002833, -0.144563>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.092968, -0.666791, -0.178145>, <0.093024, -0.671042, -0.181972>, <0.092439, -0.677052, -0.187385>, <0.089582, -0.680735, -0.190701>, 
      <0.092869, -0.659272, -0.171374>, <0.092925, -0.663522, -0.175202>, <0.072994, -0.650264, -0.185641>, <0.070136, -0.653946, -0.188957>, 
      <0.091925, -0.649107, -0.162222>, <0.086835, -0.636243, -0.150639>, <0.056288, -0.611476, -0.154170>, <0.045994, -0.600463, -0.144254>, 
      <0.089071, -0.641893, -0.155726>, <0.083981, -0.629028, -0.144143>, <0.076994, -0.611415, -0.128284>, <0.066700, -0.600402, -0.118368>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.061627, -0.666791, -0.178145>, <-0.061683, -0.671042, -0.181973>, <-0.061097, -0.677052, -0.187385>, <-0.058240, -0.680735, -0.190701>, 
      <-0.146214, -0.754253, -0.156049>, <-0.146269, -0.758504, -0.159877>, <-0.135526, -0.779458, -0.194051>, <-0.132669, -0.783140, -0.197367>, 
      <-0.270023, -0.888885, -0.175619>, <-0.257947, -0.899373, -0.185062>, <-0.266586, -0.909885, -0.198620>, <-0.255306, -0.920852, -0.208494>, 
      <-0.343582, -0.958332, -0.104493>, <-0.331506, -0.968820, -0.113937>, <-0.339130, -0.991866, -0.134688>, <-0.327850, -1.002833, -0.144562>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.057730, -0.641893, -0.155726>, <-0.060584, -0.649107, -0.162222>, <-0.061528, -0.659272, -0.171374>, <-0.061627, -0.666791, -0.178145>, 
      <-0.184011, -0.710879, -0.116994>, <-0.186866, -0.718093, -0.123490>, <-0.146115, -0.746734, -0.149279>, <-0.146214, -0.754253, -0.156049>, 
      <-0.394065, -0.809626, -0.132342>, <-0.396278, -0.849343, -0.168104>, <-0.304799, -0.858681, -0.148423>, <-0.270023, -0.888885, -0.175619>, 
      <-0.478668, -0.871845, -0.026620>, <-0.480882, -0.911563, -0.062382>, <-0.378359, -0.928128, -0.077297>, <-0.343582, -0.958332, -0.104493>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.035360, -0.600402, -0.118368>, <-0.045654, -0.611415, -0.128284>, <-0.052640, -0.629028, -0.144143>, <-0.057730, -0.641893, -0.155726>, 
      <-0.110843, -0.600180, -0.024130>, <-0.121137, -0.611193, -0.034046>, <-0.178922, -0.698014, -0.105411>, <-0.184011, -0.710879, -0.116994>, 
      <-0.278345, -0.645140, 0.041790>, <-0.342110, -0.692004, -0.000406>, <-0.390354, -0.743036, -0.072385>, <-0.394065, -0.809626, -0.132342>, 
      <-0.328067, -0.679942, 0.146170>, <-0.391832, -0.726806, 0.103973>, <-0.474957, -0.805256, 0.033337>, <-0.478668, -0.871845, -0.026620>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.035360, -0.600402, -0.118368>, <-0.014637, -0.600463, -0.144240>, <-0.038778, -0.653958, -0.188958>, <-0.058240, -0.680735, -0.190701>, 
      <-0.045654, -0.611415, -0.128284>, <-0.024931, -0.611476, -0.154156>, <-0.041636, -0.650275, -0.185642>, <-0.061097, -0.677052, -0.187385>, 
      <-0.052640, -0.629028, -0.144143>, <-0.055495, -0.636243, -0.150639>, <-0.061584, -0.663522, -0.175202>, <-0.061683, -0.671042, -0.181973>, 
      <-0.057730, -0.641893, -0.155726>, <-0.060584, -0.649107, -0.162222>, <-0.061528, -0.659272, -0.171374>, <-0.061627, -0.666791, -0.178145>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.008680, -0.589417, -0.108478>, <0.002791, -0.596388, -0.150131>, <-0.020308, -0.656676, -0.196776>, <-0.039438, -0.695387, -0.203893>, 
      <-0.017415, -0.591441, -0.110301>, <-0.005944, -0.598413, -0.151954>, <-0.028035, -0.654697, -0.194994>, <-0.047165, -0.693408, -0.202111>, 
      <-0.030140, -0.594817, -0.113340>, <-0.009417, -0.594878, -0.139211>, <-0.034695, -0.659220, -0.193696>, <-0.054157, -0.685997, -0.195439>, 
      <-0.035360, -0.600402, -0.118368>, <-0.014637, -0.600463, -0.144240>, <-0.038778, -0.653958, -0.188958>, <-0.058240, -0.680735, -0.190701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.008680, -0.589417, -0.108478>, <-0.017415, -0.591441, -0.110301>, <-0.030140, -0.594817, -0.113340>, <-0.035360, -0.600402, -0.118368>, 
      <-0.034919, -0.573470, -0.013199>, <-0.043654, -0.575495, -0.015021>, <-0.105623, -0.594595, -0.019101>, <-0.110843, -0.600180, -0.024130>, 
      <-0.130357, -0.606796, 0.096022>, <-0.186736, -0.615772, 0.087940>, <-0.237349, -0.615010, 0.068920>, <-0.278345, -0.645140, 0.041790>, 
      <-0.148439, -0.629142, 0.191911>, <-0.204818, -0.638119, 0.183828>, <-0.287071, -0.649812, 0.173299>, <-0.328067, -0.679942, 0.146170>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.015057, -0.588717, -0.107847>, <0.015655, -0.596836, -0.152013>, <0.016289, -0.655979, -0.198928>, <0.016807, -0.699958, -0.208008>, 
      <0.007930, -0.588717, -0.107847>, <0.008529, -0.596836, -0.152013>, <-0.000686, -0.655979, -0.198928>, <-0.000167, -0.699958, -0.208008>, 
      <-0.001876, -0.587840, -0.107058>, <0.009595, -0.594812, -0.148712>, <-0.004260, -0.660786, -0.200477>, <-0.023390, -0.699498, -0.207594>, 
      <-0.008680, -0.589417, -0.108478>, <0.002791, -0.596388, -0.150131>, <-0.020308, -0.656676, -0.196776>, <-0.039438, -0.695387, -0.203893>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.015057, -0.588717, -0.107847>, <0.007930, -0.588717, -0.107847>, <-0.001876, -0.587840, -0.107058>, <-0.008680, -0.589417, -0.108478>, 
      <0.013838, -0.572176, -0.017871>, <0.006711, -0.572176, -0.017871>, <-0.028116, -0.571893, -0.011779>, <-0.034919, -0.573470, -0.013199>, 
      <0.012757, -0.607076, 0.105305>, <-0.035197, -0.607076, 0.105305>, <-0.083467, -0.599330, 0.102744>, <-0.130357, -0.606796, 0.096022>, 
      <0.011349, -0.625901, 0.194829>, <-0.036605, -0.625901, 0.194829>, <-0.101549, -0.621676, 0.198633>, <-0.148439, -0.629142, 0.191911>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.040020, -0.589417, -0.108478>, <0.028585, -0.596390, -0.150141>, <0.051673, -0.656664, -0.196774>, <0.070779, -0.695387, -0.203893>, 
      <0.032851, -0.587795, -0.107017>, <0.021416, -0.594768, -0.148680>, <0.036318, -0.660720, -0.200426>, <0.055424, -0.699443, -0.207545>, 
      <0.022551, -0.588717, -0.107847>, <0.023150, -0.596836, -0.152013>, <0.032585, -0.655979, -0.198928>, <0.033103, -0.699958, -0.208008>, 
      <0.015057, -0.588717, -0.107847>, <0.015655, -0.596836, -0.152013>, <0.016289, -0.655979, -0.198928>, <0.016807, -0.699958, -0.208008>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.040020, -0.589417, -0.108478>, <0.032851, -0.587795, -0.107017>, <0.022551, -0.588717, -0.107847>, <0.015057, -0.588717, -0.107847>, 
      <0.066165, -0.573474, -0.013220>, <0.058996, -0.571852, -0.011760>, <0.021332, -0.572176, -0.017871>, <0.013838, -0.572176, -0.017871>, 
      <0.163085, -0.606737, 0.095769>, <0.113717, -0.599064, 0.102679>, <0.063193, -0.607076, 0.105305>, <0.012757, -0.607076, 0.105305>, 
      <0.179413, -0.629142, 0.191911>, <0.130045, -0.621469, 0.198820>, <0.061785, -0.625901, 0.194829>, <0.011349, -0.625901, 0.194829>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.040020, -0.589417, -0.108478>, <0.048773, -0.591398, -0.110261>, <0.061480, -0.594817, -0.113340>, <0.066700, -0.600402, -0.118368>, 
      <0.028585, -0.596390, -0.150141>, <0.037339, -0.598371, -0.151924>, <0.040774, -0.594878, -0.139226>, <0.045994, -0.600463, -0.144254>, 
      <0.051673, -0.656664, -0.196774>, <0.059374, -0.654630, -0.194943>, <0.066053, -0.659208, -0.193695>, <0.070136, -0.653946, -0.188957>, 
      <0.070779, -0.695387, -0.203893>, <0.078480, -0.693353, -0.202062>, <0.085499, -0.685997, -0.195439>, <0.089582, -0.680735, -0.190701>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.040020, -0.589417, -0.108478>, <0.066165, -0.573474, -0.013220>, <0.163085, -0.606737, 0.095769>, <0.179413, -0.629142, 0.191911>, 
      <0.048773, -0.591398, -0.110261>, <0.074918, -0.575454, -0.015003>, <0.219522, -0.615509, 0.087871>, <0.235850, -0.637914, 0.184013>, 
      <0.061480, -0.594817, -0.113340>, <0.136850, -0.594595, -0.019114>, <0.270388, -0.614750, 0.068137>, <0.318043, -0.649812, 0.173298>, 
      <0.066700, -0.600402, -0.118368>, <0.142070, -0.600180, -0.024142>, <0.311384, -0.644880, 0.041008>, <0.359039, -0.679942, 0.146169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.034724, -1.361905, 1.067703>, <0.913064, -1.146163, 0.762972>, <0.727355, -1.037607, 0.255040>, <0.509645, -0.871845, -0.026620>, 
      <0.969333, -1.263292, 1.156495>, <0.847673, -1.047551, 0.851763>, <0.723643, -0.971018, 0.314997>, <0.505933, -0.805255, 0.033337>, 
      <0.822858, -1.133962, 1.230426>, <0.738261, -0.924314, 0.915388>, <0.575951, -0.839483, 0.441919>, <0.422804, -0.726806, 0.103972>, 
      <0.719060, -1.080375, 1.321194>, <0.634463, -0.870727, 1.006156>, <0.512185, -0.792619, 0.484116>, <0.359039, -0.679942, 0.146169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.089710, -1.639330, 0.817908>, <0.934723, -1.398530, 0.530964>, <0.610559, -1.188604, 0.131346>, <0.374556, -0.958332, -0.104493>, 
      <1.088310, -1.555211, 0.893649>, <0.933323, -1.314411, 0.606705>, <0.645335, -1.158400, 0.158543>, <0.409333, -0.928128, -0.077297>, 
      <1.084763, -1.437366, 0.999758>, <0.963103, -1.221624, 0.695026>, <0.729569, -1.077326, 0.219277>, <0.511859, -0.911563, -0.062382>, 
      <1.034724, -1.361905, 1.067703>, <0.913064, -1.146163, 0.762972>, <0.727355, -1.037607, 0.255040>, <0.509645, -0.871845, -0.026620>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.041925, -1.794705, 0.678009>, <0.895117, -1.542593, 0.405585>, <0.581953, -1.263827, 0.058968>, <0.358827, -1.002833, -0.144563>, 
      <1.078400, -1.755316, 0.713475>, <0.931592, -1.503205, 0.441050>, <0.593233, -1.252860, 0.068843>, <0.370107, -0.991866, -0.134689>, 
      <1.090505, -1.687141, 0.774859>, <0.935518, -1.446341, 0.487915>, <0.598483, -1.199092, 0.121903>, <0.362480, -0.968820, -0.113937>, 
      <1.089710, -1.639330, 0.817908>, <0.934723, -1.398530, 0.530964>, <0.610559, -1.188604, 0.131346>, <0.374556, -0.958332, -0.104493>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.776613, -1.977436, 0.513477>, <0.670404, -1.705802, 0.270514>, <0.435875, -1.357131, -0.027643>, <0.271485, -1.058539, -0.194720>, 
      <0.880378, -1.953825, 0.534736>, <0.774169, -1.682191, 0.291774>, <0.469128, -1.350217, -0.021417>, <0.304737, -1.051625, -0.188494>, 
      <0.980404, -1.861140, 0.618191>, <0.833596, -1.609028, 0.345767>, <0.560984, -1.284213, 0.040612>, <0.337858, -1.023220, -0.162919>, 
      <1.041925, -1.794705, 0.678009>, <0.895117, -1.542593, 0.405585>, <0.581953, -1.263827, 0.058968>, <0.358827, -1.002833, -0.144563>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.015012, -2.028370, 0.467615>, <0.015305, -1.763124, 0.237757>, <0.020344, -1.385974, -0.048744>, <0.020767, -1.073127, -0.207856>, 
      <0.244416, -2.028370, 0.467615>, <0.244708, -1.763124, 0.237757>, <0.095790, -1.385974, -0.048744>, <0.096213, -1.073127, -0.207856>, 
      <0.557261, -2.027348, 0.468536>, <0.451052, -1.755714, 0.225574>, <0.363220, -1.372238, -0.041246>, <0.198830, -1.073646, -0.208323>, 
      <0.776613, -1.977436, 0.513477>, <0.670404, -1.705802, 0.270514>, <0.435875, -1.357131, -0.027643>, <0.271485, -1.058539, -0.194720>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.778659, -1.977436, 0.513477>, <-0.666595, -1.703945, 0.268853>, <-0.412960, -1.357623, -0.027368>, <-0.240510, -1.058539, -0.194720>, 
      <-0.549557, -2.027987, 0.467960>, <-0.437493, -1.754496, 0.223336>, <-0.337099, -1.372919, -0.041141>, <-0.164649, -1.073835, -0.208493>, 
      <-0.223975, -2.028370, 0.467615>, <-0.223683, -1.763124, 0.237757>, <-0.058260, -1.385974, -0.048744>, <-0.057837, -1.073127, -0.207856>, 
      <0.015012, -2.028370, 0.467615>, <0.015305, -1.763124, 0.237757>, <0.020344, -1.385974, -0.048744>, <0.020767, -1.073127, -0.207856>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.043972, -1.794705, 0.678009>, <-0.890722, -1.540565, 0.403393>, <-0.559228, -1.264312, 0.059348>, <-0.327850, -1.002833, -0.144562>, 
      <-0.982451, -1.861140, 0.618191>, <-0.829201, -1.607000, 0.343575>, <-0.538259, -1.284698, 0.040992>, <-0.306881, -1.023219, -0.162918>, 
      <-0.882691, -1.954481, 0.534146>, <-0.770626, -1.680990, 0.289521>, <-0.446284, -1.350903, -0.021318>, <-0.273834, -1.051820, -0.188670>, 
      <-0.778659, -1.977436, 0.513477>, <-0.666595, -1.703945, 0.268853>, <-0.412960, -1.357623, -0.027368>, <-0.240510, -1.058539, -0.194720>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.091758, -1.639330, 0.817909>, <-0.930214, -1.396587, 0.528650>, <-0.587892, -1.188984, 0.131736>, <-0.343582, -0.958332, -0.104493>, 
      <-1.092554, -1.687141, 0.774860>, <-0.931009, -1.444398, 0.485601>, <-0.575817, -1.199472, 0.122292>, <-0.331506, -0.968820, -0.113937>, 
      <-1.080447, -1.755316, 0.713475>, <-0.927198, -1.501176, 0.438859>, <-0.570508, -1.253346, 0.069222>, <-0.339130, -0.991866, -0.134688>, 
      <-1.043972, -1.794705, 0.678009>, <-0.890722, -1.540565, 0.403393>, <-0.559228, -1.264312, 0.059348>, <-0.327850, -1.002833, -0.144562>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.036770, -1.361905, 1.067703>, <-0.909114, -1.144833, 0.761093>, <-0.703931, -1.037509, 0.254873>, <-0.478668, -0.871845, -0.026620>, 
      <-1.086809, -1.437366, 0.999758>, <-0.959152, -1.220294, 0.693148>, <-0.706144, -1.077227, 0.219111>, <-0.480882, -0.911563, -0.062382>, 
      <-1.090358, -1.555211, 0.893650>, <-0.928814, -1.312468, 0.604391>, <-0.622669, -1.158779, 0.158931>, <-0.378359, -0.928128, -0.077297>, 
      <-1.091758, -1.639330, 0.817909>, <-0.930214, -1.396587, 0.528650>, <-0.587892, -1.188984, 0.131736>, <-0.343582, -0.958332, -0.104493>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.721109, -1.080375, 1.321194>, <-0.630857, -0.869815, 1.004785>, <-0.488933, -0.792536, 0.483869>, <-0.328067, -0.679942, 0.146170>, 
      <-0.824907, -1.133962, 1.230427>, <-0.734655, -0.923401, 0.914017>, <-0.552698, -0.839400, 0.441672>, <-0.391832, -0.726806, 0.103973>, 
      <-0.971379, -1.263292, 1.156494>, <-0.843723, -1.046221, 0.849884>, <-0.700220, -0.970920, 0.314830>, <-0.474957, -0.805256, 0.033337>, 
      <-1.036770, -1.361905, 1.067703>, <-0.909114, -1.144833, 0.761093>, <-0.703931, -1.037509, 0.254873>, <-0.478668, -0.871845, -0.026620>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.344611, -1.004569, 1.672972>, <-0.295334, -0.768643, 1.278665>, <-0.231914, -0.732303, 0.634582>, <-0.148439, -0.629142, 0.191911>, 
      <-0.494099, -1.038344, 1.642561>, <-0.444822, -0.802417, 1.248255>, <-0.288293, -0.741279, 0.626499>, <-0.204818, -0.638119, 0.183828>, 
      <-0.611480, -1.023778, 1.417061>, <-0.521228, -0.813217, 1.100651>, <-0.447937, -0.762406, 0.510998>, <-0.287071, -0.649812, 0.173299>, 
      <-0.721109, -1.080375, 1.321194>, <-0.630857, -0.869815, 1.004785>, <-0.488933, -0.792536, 0.483869>, <-0.328067, -0.679942, 0.146170>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.009694, -0.919641, 1.465919>, <-0.005905, -0.712780, 1.133639>, <0.005325, -0.706438, 0.577835>, <0.011349, -0.625901, 0.194829>, 
      <-0.130536, -0.919641, 1.465919>, <-0.126746, -0.712780, 1.133639>, <-0.042629, -0.706438, 0.577835>, <-0.036605, -0.625901, 0.194829>, 
      <-0.228994, -0.978447, 1.696492>, <-0.179718, -0.742521, 1.302185>, <-0.185024, -0.724837, 0.641304>, <-0.101549, -0.621676, 0.198633>, 
      <-0.344611, -1.004569, 1.672972>, <-0.295334, -0.768643, 1.278665>, <-0.231914, -0.732303, 0.634582>, <-0.148439, -0.629142, 0.191911>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.342566, -1.004569, 1.672972>, <0.300361, -0.768878, 1.279059>, <0.254636, -0.732363, 0.634840>, <0.179413, -0.629142, 0.191911>, 
      <0.222539, -0.978096, 1.696808>, <0.180334, -0.742405, 1.302895>, <0.205268, -0.724690, 0.641749>, <0.130045, -0.621469, 0.198820>, 
      <0.115507, -0.919641, 1.465919>, <0.119297, -0.712780, 1.133639>, <0.055762, -0.706438, 0.577835>, <0.061785, -0.625901, 0.194829>, 
      <-0.009694, -0.919641, 1.465919>, <-0.005905, -0.712780, 1.133639>, <0.005325, -0.706438, 0.577835>, <0.011349, -0.625901, 0.194829>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.342566, -1.004569, 1.672972>, <0.492351, -1.037606, 1.643226>, <0.609432, -1.023778, 1.417060>, <0.719060, -1.080375, 1.321194>, 
      <0.300361, -0.768878, 1.279059>, <0.450146, -0.801914, 1.249312>, <0.524835, -0.814130, 1.102022>, <0.634463, -0.870727, 1.006156>, 
      <0.254636, -0.732363, 0.634840>, <0.311073, -0.741135, 0.626942>, <0.471189, -0.762489, 0.511245>, <0.512185, -0.792619, 0.484116>, 
      <0.179413, -0.629142, 0.191911>, <0.235850, -0.637914, 0.184013>, <0.318043, -0.649812, 0.173298>, <0.359039, -0.679942, 0.146169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.286587, -2.249609, 1.919450>, <1.288532, -1.981719, 1.654583>, <1.151438, -1.568876, 1.360046>, <1.034724, -1.361905, 1.067703>, 
      <1.196938, -2.157094, 2.002751>, <1.198883, -1.889204, 1.737884>, <1.086046, -1.470263, 1.448837>, <0.969333, -1.263292, 1.156495>, 
      <1.026931, -2.080346, 2.119647>, <1.042301, -1.802312, 1.869663>, <0.904498, -1.336283, 1.534453>, <0.822858, -1.133962, 1.230426>, 
      <0.894122, -2.005984, 2.138811>, <0.909492, -1.727951, 1.888827>, <0.800700, -1.282695, 1.625221>, <0.719060, -1.080375, 1.321194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.286587, -2.249609, 1.919450>, <1.196938, -2.157094, 2.002751>, <1.026931, -2.080346, 2.119647>, <0.894122, -2.005984, 2.138811>, 
      <1.285171, -2.444651, 2.112291>, <1.195522, -2.352135, 2.195592>, <1.017266, -2.255168, 2.276832>, <0.884458, -2.180806, 2.295996>, 
      <1.105694, -2.646032, 2.396203>, <1.011712, -2.541312, 2.451215>, <0.806818, -2.439323, 2.461544>, <0.672953, -2.374922, 2.489074>, 
      <1.023855, -2.859225, 2.548132>, <0.929873, -2.754505, 2.603144>, <0.771688, -2.614274, 2.614911>, <0.637823, -2.549873, 2.642441>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.354952, -2.481547, 1.710612>, <1.356936, -2.230365, 1.429902>, <1.233724, -1.863081, 1.084535>, <1.089710, -1.639330, 0.817908>, 
      <1.353189, -2.410328, 1.774738>, <1.355173, -2.159146, 1.494028>, <1.232324, -1.778961, 1.160276>, <1.088310, -1.555211, 0.893649>, 
      <1.342599, -2.307412, 1.867404>, <1.344544, -2.039523, 1.602536>, <1.201477, -1.644336, 1.292101>, <1.084763, -1.437366, 0.999758>, 
      <1.286587, -2.249609, 1.919450>, <1.288532, -1.981719, 1.654583>, <1.151438, -1.568876, 1.360046>, <1.034724, -1.361905, 1.067703>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.295542, -2.611444, 1.593652>, <1.301634, -2.363800, 1.310957>, <1.180169, -2.032109, 0.934541>, <1.041925, -1.794705, 0.678009>, 
      <1.330683, -2.579631, 1.622297>, <1.336774, -2.331987, 1.339602>, <1.216644, -1.992721, 0.970006>, <1.078400, -1.755316, 0.713475>, 
      <1.355970, -2.522699, 1.673559>, <1.357954, -2.271517, 1.392849>, <1.234519, -1.910891, 1.041486>, <1.090505, -1.687141, 0.774859>, 
      <1.354952, -2.481547, 1.710612>, <1.356936, -2.230365, 1.429902>, <1.233724, -1.863081, 1.084535>, <1.089710, -1.639330, 0.817908>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.965678, -2.833956, 1.393301>, <1.094396, -2.807230, 1.417365>, <1.210744, -2.688211, 1.524530>, <1.295542, -2.611444, 1.593652>, 
      <0.954204, -3.009507, 1.606057>, <1.082922, -2.982781, 1.630122>, <1.206895, -2.844706, 1.703175>, <1.291692, -2.767939, 1.772297>, 
      <0.796306, -3.166394, 1.920684>, <0.909713, -3.137590, 1.927059>, <1.024916, -2.998358, 1.946272>, <1.109720, -2.939482, 2.001709>, 
      <0.689434, -3.311262, 2.129985>, <0.802841, -3.282458, 2.136360>, <0.925264, -3.148618, 2.100904>, <1.010069, -3.089742, 2.156341>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.965678, -2.833956, 1.393301>, <0.981168, -2.596954, 1.106070>, <0.880894, -2.244138, 0.752029>, <0.776613, -1.977436, 0.513477>, 
      <1.094396, -2.807230, 1.417365>, <1.109886, -2.570228, 1.130134>, <0.984660, -2.220527, 0.773288>, <0.880378, -1.953825, 0.534736>, 
      <1.210744, -2.688211, 1.524530>, <1.216836, -2.440567, 1.241836>, <1.118648, -2.098545, 0.874723>, <0.980404, -1.861140, 0.618191>, 
      <1.295542, -2.611444, 1.593652>, <1.301634, -2.363800, 1.310957>, <1.180169, -2.032109, 0.934541>, <1.041925, -1.794705, 0.678009>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.018777, -2.876542, 1.354957>, <0.303367, -2.876542, 1.354957>, <0.691585, -2.890867, 1.342059>, <0.965678, -2.833956, 1.393301>, 
      <0.017699, -3.042243, 1.560443>, <0.302289, -3.042243, 1.560443>, <0.680111, -3.066418, 1.554815>, <0.954204, -3.009507, 1.606057>, 
      <0.010665, -3.198867, 1.879895>, <0.216003, -3.198868, 1.879895>, <0.597582, -3.216867, 1.909513>, <0.796306, -3.166394, 1.920684>, 
      <0.006451, -3.344646, 2.099925>, <0.211789, -3.344646, 2.099925>, <0.490710, -3.361735, 2.118814>, <0.689434, -3.311262, 2.129985>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.018777, -2.876542, 1.354957>, <0.020280, -2.645383, 1.068297>, <0.014705, -2.306666, 0.708783>, <0.015012, -2.028370, 0.467615>, 
      <0.303367, -2.876542, 1.354957>, <0.304870, -2.645383, 1.068297>, <0.244109, -2.306666, 0.708783>, <0.244416, -2.028370, 0.467615>, 
      <0.691585, -2.890867, 1.342059>, <0.707076, -2.653864, 1.054828>, <0.661543, -2.294050, 0.707088>, <0.557261, -2.027348, 0.468536>, 
      <0.965678, -2.833956, 1.393301>, <0.981168, -2.596954, 1.106070>, <0.880894, -2.244138, 0.752029>, <0.776613, -1.977436, 0.513477>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.967996, -2.833956, 1.393302>, <-0.681784, -2.891583, 1.341414>, <-0.277754, -2.876542, 1.354957>, <0.018777, -2.876542, 1.354957>, 
      <-0.958379, -3.008793, 1.605193>, <-0.672167, -3.066420, 1.553305>, <-0.278831, -3.042243, 1.560443>, <0.017699, -3.042243, 1.560443>, 
      <-0.808583, -3.166286, 1.920531>, <-0.601166, -3.217500, 1.909196>, <-0.203282, -3.198867, 1.879895>, <0.010665, -3.198867, 1.879895>, 
      <-0.705289, -3.311261, 2.129985>, <-0.497872, -3.362474, 2.118650>, <-0.207496, -3.344646, 2.099925>, <0.006451, -3.344646, 2.099925>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.967996, -2.833956, 1.393302>, <-0.981036, -2.596886, 1.105989>, <-0.887528, -2.243128, 0.751125>, <-0.778659, -1.977436, 0.513477>, 
      <-0.681784, -2.891583, 1.341414>, <-0.694825, -2.654513, 1.054101>, <-0.658425, -2.293679, 0.705608>, <-0.549557, -2.027987, 0.467960>, 
      <-0.277754, -2.876542, 1.354957>, <-0.276250, -2.645383, 1.068297>, <-0.224283, -2.306666, 0.708783>, <-0.223975, -2.028370, 0.467615>, 
      <0.018777, -2.876542, 1.354957>, <0.020280, -2.645383, 1.068297>, <0.014705, -2.306666, 0.708783>, <0.015012, -2.028370, 0.467615>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.297862, -2.611444, 1.593653>, <-1.213064, -2.688211, 1.524532>, <-1.096993, -2.807983, 1.416688>, <-0.967996, -2.833956, 1.393302>, 
      <-1.295694, -2.767008, 1.771235>, <-1.210895, -2.843776, 1.702114>, <-1.087376, -2.982820, 1.628579>, <-0.958379, -3.008793, 1.605193>, 
      <-1.122681, -2.939661, 2.001894>, <-1.037840, -2.998508, 1.946483>, <-0.922188, -3.138236, 1.926739>, <-0.808583, -3.166286, 1.920531>, 
      <-1.025923, -3.089742, 2.156341>, <-0.941081, -3.148589, 2.100930>, <-0.818894, -3.283211, 2.136193>, <-0.705289, -3.311261, 2.129985>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.297862, -2.611444, 1.593653>, <-1.301314, -2.363767, 1.310921>, <-1.186441, -2.030967, 0.933306>, <-1.043972, -1.794705, 0.678009>, 
      <-1.213064, -2.688211, 1.524532>, <-1.216515, -2.440534, 1.241799>, <-1.124919, -2.097402, 0.873488>, <-0.982451, -1.861140, 0.618191>, 
      <-1.096993, -2.807983, 1.416688>, <-1.110034, -2.570913, 1.129375>, <-0.991559, -2.220173, 0.771794>, <-0.882691, -1.954481, 0.534146>, 
      <-0.967996, -2.833956, 1.393302>, <-0.981036, -2.596886, 1.105989>, <-0.887528, -2.243128, 0.751125>, <-0.778659, -1.977436, 0.513477>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.357274, -2.481547, 1.710612>, <-1.358292, -2.522699, 1.673559>, <-1.333003, -2.579631, 1.622297>, <-1.297862, -2.611444, 1.593653>, 
      <-1.357678, -2.664448, 1.915014>, <-1.358696, -2.705599, 1.877961>, <-1.330835, -2.735196, 1.799879>, <-1.295694, -2.767008, 1.771235>, 
      <-1.195859, -2.852296, 2.212945>, <-1.193590, -2.889274, 2.150097>, <-1.175502, -2.903023, 2.036392>, <-1.122681, -2.939661, 2.001894>, 
      <-1.094854, -3.041055, 2.384412>, <-1.092585, -3.078033, 2.321564>, <-1.078744, -3.053105, 2.190839>, <-1.025923, -3.089742, 2.156341>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.357274, -2.481547, 1.710612>, <-1.356719, -2.230350, 1.429886>, <-1.239924, -1.861969, 1.083212>, <-1.091758, -1.639330, 0.817909>, 
      <-1.358292, -2.522699, 1.673559>, <-1.357737, -2.271502, 1.392833>, <-1.240719, -1.909780, 1.040163>, <-1.092554, -1.687141, 0.774860>, 
      <-1.333003, -2.579631, 1.622297>, <-1.336455, -2.331954, 1.339565>, <-1.222916, -1.991578, 0.968772>, <-1.080447, -1.755316, 0.713475>, 
      <-1.297862, -2.611444, 1.593653>, <-1.301314, -2.363767, 1.310921>, <-1.186441, -2.030967, 0.933306>, <-1.043972, -1.794705, 0.678009>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.288910, -2.249609, 1.919450>, <-1.344922, -2.307412, 1.867404>, <-1.355512, -2.410328, 1.774738>, <-1.357274, -2.481547, 1.710612>, 
      <-1.289338, -2.443822, 2.111472>, <-1.345351, -2.501625, 2.059426>, <-1.355916, -2.593229, 1.979139>, <-1.357678, -2.664448, 1.915014>, 
      <-1.118873, -2.646269, 2.396372>, <-1.165689, -2.698390, 2.368991>, <-1.198199, -2.814170, 2.277745>, <-1.195859, -2.852296, 2.212945>, 
      <-1.040071, -2.859225, 2.548132>, <-1.086886, -2.911347, 2.520751>, <-1.097194, -3.002929, 2.449212>, <-1.094854, -3.041055, 2.384412>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.288910, -2.249609, 1.919450>, <-1.288320, -1.981704, 1.654568>, <-1.157983, -1.568021, 1.358838>, <-1.036770, -1.361905, 1.067703>, 
      <-1.344922, -2.307412, 1.867404>, <-1.344332, -2.039507, 1.602521>, <-1.208022, -1.643481, 1.290893>, <-1.086809, -1.437366, 0.999758>, 
      <-1.355512, -2.410328, 1.774738>, <-1.354957, -2.159131, 1.494012>, <-1.238524, -1.777850, 1.158953>, <-1.090358, -1.555211, 0.893650>, 
      <-1.357274, -2.481547, 1.710612>, <-1.356719, -2.230350, 1.429886>, <-1.239924, -1.861969, 1.083212>, <-1.091758, -1.639330, 0.817909>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.896444, -2.005983, 2.138811>, <-1.029259, -2.080335, 2.119650>, <-1.199261, -2.157094, 2.002751>, <-1.288910, -2.249609, 1.919450>, 
      <-0.888464, -2.179888, 2.295172>, <-1.021279, -2.254240, 2.276011>, <-1.199689, -2.351307, 2.194773>, <-1.289338, -2.443822, 2.111472>, 
      <-0.686564, -2.375659, 2.489720>, <-0.820515, -2.440075, 2.462184>, <-1.024793, -2.541524, 2.451396>, <-1.118873, -2.646269, 2.396372>, 
      <-0.653678, -2.549873, 2.642441>, <-0.787628, -2.614289, 2.614904>, <-0.945990, -2.754481, 2.603157>, <-1.040071, -2.859225, 2.548132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.896444, -2.005983, 2.138811>, <-0.909206, -1.727868, 1.888754>, <-0.807568, -1.282086, 1.624306>, <-0.721109, -1.080375, 1.321194>, 
      <-1.029259, -2.080335, 2.119650>, <-1.042021, -1.802220, 1.869593>, <-0.911366, -1.335673, 1.533538>, <-0.824907, -1.133962, 1.230427>, 
      <-1.199261, -2.157094, 2.002751>, <-1.198670, -1.889189, 1.737869>, <-1.092593, -1.469408, 1.447629>, <-0.971379, -1.263292, 1.156494>, 
      <-1.288910, -2.249609, 1.919450>, <-1.288320, -1.981704, 1.654568>, <-1.157983, -1.568021, 1.358838>, <-1.036770, -1.361905, 1.067703>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.380705, -1.741184, 2.050479>, <-0.396522, -1.539027, 1.906744>, <-0.371114, -1.131458, 1.885043>, <-0.344611, -1.004569, 1.672972>, 
      <-0.554272, -1.762543, 2.031247>, <-0.570089, -1.560386, 1.887512>, <-0.520601, -1.165233, 1.854632>, <-0.494099, -1.038344, 1.642561>, 
      <-0.744133, -1.920717, 2.160785>, <-0.756895, -1.642603, 1.910728>, <-0.697939, -1.225489, 1.720172>, <-0.611480, -1.023778, 1.417061>, 
      <-0.896444, -2.005983, 2.138811>, <-0.909206, -1.727868, 1.888754>, <-0.807568, -1.282086, 1.624306>, <-0.721109, -1.080375, 1.321194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.380705, -1.741184, 2.050479>, <-0.554272, -1.762543, 2.031247>, <-0.744133, -1.920717, 2.160785>, <-0.896444, -2.005983, 2.138811>, 
      <-0.361666, -1.984520, 2.223493>, <-0.535234, -2.005878, 2.204261>, <-0.736153, -2.094623, 2.317146>, <-0.888464, -2.179888, 2.295172>, 
      <-0.252712, -2.237962, 2.526762>, <-0.381416, -2.242521, 2.501873>, <-0.570332, -2.319764, 2.513615>, <-0.686564, -2.375659, 2.489720>, 
      <-0.229982, -2.469661, 2.714665>, <-0.358687, -2.474220, 2.689776>, <-0.537446, -2.493978, 2.666335>, <-0.653678, -2.549873, 2.642441>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.011939, -1.897139, 2.236816>, <-0.012979, -1.606957, 2.001711>, <-0.013310, -1.117012, 1.782956>, <-0.009694, -0.919641, 1.465919>, 
      <-0.144426, -1.897139, 2.236816>, <-0.145467, -1.606957, 2.001711>, <-0.134152, -1.117012, 1.782956>, <-0.130536, -0.919641, 1.465919>, 
      <-0.249998, -1.725100, 2.064962>, <-0.265814, -1.522943, 1.921226>, <-0.255497, -1.105336, 1.908563>, <-0.228994, -0.978447, 1.696492>, 
      <-0.380705, -1.741184, 2.050479>, <-0.396522, -1.539027, 1.906744>, <-0.371114, -1.131458, 1.885043>, <-0.344611, -1.004569, 1.672972>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.011939, -1.897139, 2.236816>, <-0.144426, -1.897139, 2.236816>, <-0.249998, -1.725100, 2.064962>, <-0.380705, -1.741184, 2.050479>, 
      <-0.011251, -2.089194, 2.392419>, <-0.143738, -2.089194, 2.392419>, <-0.230959, -1.968435, 2.237975>, <-0.361666, -1.984520, 2.223493>, 
      <-0.006521, -2.328300, 2.620899>, <-0.078286, -2.328300, 2.620899>, <-0.182295, -2.235468, 2.540379>, <-0.252712, -2.237962, 2.526762>, 
      <-0.003932, -2.526860, 2.768089>, <-0.075697, -2.526860, 2.768089>, <-0.159565, -2.467167, 2.728282>, <-0.229982, -2.469661, 2.714665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.378547, -1.741184, 2.050479>, <0.396264, -1.539133, 1.906819>, <0.365322, -1.131649, 1.885362>, <0.342566, -1.004569, 1.672972>, 
      <0.242340, -1.724821, 2.065212>, <0.260057, -1.522770, 1.921552>, <0.245296, -1.105176, 1.909198>, <0.222539, -0.978096, 1.696808>, 
      <0.126036, -1.897139, 2.236816>, <0.124996, -1.606957, 2.001711>, <0.111892, -1.117012, 1.782956>, <0.115507, -0.919641, 1.465919>, 
      <-0.011939, -1.897139, 2.236816>, <-0.012979, -1.606957, 2.001711>, <-0.013310, -1.117012, 1.782956>, <-0.009694, -0.919641, 1.465919>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.378547, -1.741184, 2.050479>, <0.242340, -1.724821, 2.065212>, <0.126036, -1.897139, 2.236816>, <-0.011939, -1.897139, 2.236816>, 
      <0.357175, -1.984922, 2.223779>, <0.220968, -1.968560, 2.238512>, <0.126724, -2.089194, 2.392419>, <-0.011251, -2.089194, 2.392419>, 
      <0.239204, -2.237604, 2.526471>, <0.171045, -2.235160, 2.539815>, <0.062975, -2.328300, 2.620899>, <-0.006521, -2.328300, 2.620899>, 
      <0.214099, -2.469661, 2.714665>, <0.145940, -2.467217, 2.728010>, <0.065564, -2.526860, 2.768089>, <-0.003932, -2.526860, 2.768089>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.378547, -1.741184, 2.050479>, <0.552181, -1.762043, 2.031698>, <0.741855, -1.920728, 2.160783>, <0.894122, -2.005984, 2.138811>, 
      <0.396264, -1.539133, 1.906819>, <0.569898, -1.559992, 1.888038>, <0.757226, -1.642694, 1.910799>, <0.909492, -1.727951, 1.888827>, 
      <0.365322, -1.131649, 1.885362>, <0.515107, -1.164686, 1.855616>, <0.691072, -1.226098, 1.721087>, <0.800700, -1.282695, 1.625221>, 
      <0.342566, -1.004569, 1.672972>, <0.492351, -1.037606, 1.643226>, <0.609432, -1.023778, 1.417060>, <0.719060, -1.080375, 1.321194>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.378547, -1.741184, 2.050479>, <0.357175, -1.984922, 2.223779>, <0.239204, -2.237604, 2.526471>, <0.214099, -2.469661, 2.714665>, 
      <0.552181, -1.762043, 2.031698>, <0.530809, -2.005781, 2.204998>, <0.367857, -2.242217, 2.501282>, <0.342752, -2.474274, 2.689476>, 
      <0.741855, -1.920728, 2.160783>, <0.732191, -2.095550, 2.317968>, <0.556724, -2.319006, 2.512978>, <0.521594, -2.493957, 2.666345>, 
      <0.894122, -2.005984, 2.138811>, <0.884458, -2.180806, 2.295996>, <0.672953, -2.374922, 2.489074>, <0.637823, -2.549873, 2.642441>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.252730, -4.472810, 2.616211>, <-0.177886, -4.455658, 2.610890>, <-0.151216, -4.329665, 2.578028>, <-0.107710, -4.268317, 2.561664>, 
      <-0.232866, -4.403934, 2.608344>, <-0.158022, -4.386782, 2.603023>, <-0.130755, -4.316956, 2.594462>, <-0.087249, -4.255608, 2.578098>, 
      <-0.155527, -4.336551, 2.598957>, <-0.127065, -4.333411, 2.601900>, <-0.074072, -4.271016, 2.586517>, <-0.045610, -4.267877, 2.589461>, 
      <-0.113869, -4.278154, 2.591562>, <-0.085407, -4.275014, 2.594506>, <-0.047458, -4.270828, 2.598430>, <-0.018996, -4.267688, 2.601374>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.252730, -4.472810, 2.616211>, <-0.268793, -4.528504, 2.622572>, <-0.260198, -4.617859, 2.630599>, <-0.225222, -4.664242, 2.635661>, 
      <-0.177886, -4.455658, 2.610890>, <-0.193949, -4.511352, 2.617251>, <-0.170339, -4.540212, 2.634395>, <-0.135363, -4.586594, 2.639457>, 
      <-0.151216, -4.329665, 2.578028>, <-0.161181, -4.335855, 2.570024>, <-0.132108, -4.402095, 2.579790>, <-0.123329, -4.413032, 2.577551>, 
      <-0.107710, -4.268317, 2.561664>, <-0.117675, -4.274507, 2.553660>, <-0.088440, -4.294434, 2.554886>, <-0.079661, -4.305371, 2.552647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.003227, -4.812249, 2.653258>, <0.003667, -4.688507, 2.678641>, <0.004474, -4.529800, 2.569021>, <0.005008, -4.408750, 2.532920>, 
      <-0.078605, -4.812249, 2.653258>, <-0.078165, -4.688507, 2.678641>, <-0.020927, -4.498786, 2.574939>, <-0.020393, -4.377736, 2.538838>, 
      <-0.176140, -4.729333, 2.642765>, <-0.086281, -4.651686, 2.646561>, <-0.098281, -4.444239, 2.571164>, <-0.054613, -4.336578, 2.546260>, 
      <-0.225222, -4.664242, 2.635661>, <-0.135363, -4.586594, 2.639457>, <-0.123329, -4.413032, 2.577551>, <-0.079661, -4.305371, 2.552647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.075804, -4.546584, 2.672113>, <-0.053271, -4.553577, 2.670807>, <-0.022195, -4.561752, 2.669278>, <0.001434, -4.561752, 2.669278>, 
      <-0.096892, -4.604410, 2.678875>, <-0.074359, -4.611402, 2.677569>, <-0.021657, -4.634391, 2.686400>, <0.001972, -4.634391, 2.686400>, 
      <-0.115684, -4.716168, 2.645946>, <-0.074608, -4.742010, 2.656767>, <-0.046934, -4.777521, 2.656531>, <0.002787, -4.777521, 2.656531>, 
      <-0.146097, -4.739336, 2.694654>, <-0.105021, -4.765179, 2.705475>, <-0.046494, -4.803884, 2.726351>, <0.003227, -4.803884, 2.726351>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.107081, -4.528075, 2.675569>, <-0.103032, -4.537927, 2.678119>, <-0.086248, -4.543343, 2.672719>, <-0.075804, -4.546584, 2.672113>, 
      <-0.142989, -4.567405, 2.672626>, <-0.138940, -4.577257, 2.675176>, <-0.107336, -4.601169, 2.679481>, <-0.096892, -4.604410, 2.678875>, 
      <-0.182708, -4.648104, 2.637824>, <-0.161210, -4.675206, 2.644349>, <-0.144766, -4.697870, 2.638285>, <-0.115684, -4.716168, 2.645946>, 
      <-0.226776, -4.659176, 2.665759>, <-0.205278, -4.686278, 2.672284>, <-0.175179, -4.721039, 2.686993>, <-0.146097, -4.739336, 2.694654>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.133119, -4.407145, 2.636021>, <-0.145173, -4.442776, 2.646174>, <-0.121486, -4.493030, 2.666498>, <-0.107081, -4.528075, 2.675569>, 
      <-0.188942, -4.441336, 2.637850>, <-0.200996, -4.476967, 2.648003>, <-0.157394, -4.532360, 2.663555>, <-0.142989, -4.567405, 2.672626>, 
      <-0.253859, -4.518567, 2.638494>, <-0.267919, -4.566017, 2.647734>, <-0.213452, -4.609345, 2.628493>, <-0.182708, -4.648104, 2.637824>, 
      <-0.319196, -4.521114, 2.642117>, <-0.333257, -4.568564, 2.651357>, <-0.257520, -4.620417, 2.656428>, <-0.226776, -4.659176, 2.665759>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.133119, -4.407145, 2.636021>, <-0.188942, -4.441336, 2.637850>, <-0.253859, -4.518567, 2.638494>, <-0.319196, -4.521114, 2.642117>, 
      <-0.116088, -4.356799, 2.621675>, <-0.171911, -4.390990, 2.623504>, <-0.226872, -4.427494, 2.620759>, <-0.292209, -4.430041, 2.624382>, 
      <-0.053233, -4.309525, 2.611768>, <-0.081695, -4.312665, 2.608824>, <-0.147005, -4.347902, 2.609672>, <-0.175467, -4.351042, 2.606729>, 
      <-0.018996, -4.267688, 2.601374>, <-0.047458, -4.270828, 2.598430>, <-0.085407, -4.275014, 2.594506>, <-0.113869, -4.278154, 2.591562>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.198212, -4.639834, 2.868154>, <-0.179537, -4.690079, 2.836988>, <-0.176552, -4.762536, 2.743428>, <-0.146097, -4.739336, 2.694654>, 
      <-0.139964, -4.651927, 2.884623>, <-0.121288, -4.702172, 2.853456>, <-0.135476, -4.788379, 2.754250>, <-0.105021, -4.765179, 2.705475>, 
      <-0.058781, -4.652468, 2.909533>, <-0.058847, -4.715739, 2.876667>, <-0.046074, -4.829069, 2.793051>, <-0.046494, -4.803884, 2.726351>, 
      <0.002947, -4.652468, 2.909533>, <0.002880, -4.715739, 2.876667>, <0.003647, -4.829069, 2.793051>, <0.003227, -4.803884, 2.726351>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.328388, -4.583679, 2.815855>, <-0.298330, -4.608011, 2.839511>, <-0.240990, -4.630953, 2.856060>, <-0.198212, -4.639834, 2.868154>, 
      <-0.296464, -4.627282, 2.792415>, <-0.266406, -4.651614, 2.816071>, <-0.222315, -4.681198, 2.824893>, <-0.179537, -4.690079, 2.836988>, 
      <-0.275444, -4.671404, 2.696609>, <-0.253946, -4.698506, 2.703134>, <-0.205634, -4.744239, 2.735767>, <-0.176552, -4.762536, 2.743428>, 
      <-0.226776, -4.659176, 2.665759>, <-0.205278, -4.686278, 2.672284>, <-0.175179, -4.721039, 2.686993>, <-0.146097, -4.739336, 2.694654>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.469467, -4.420255, 2.654672>, <-0.433377, -4.460857, 2.657996>, <-0.373496, -4.523230, 2.645128>, <-0.319196, -4.521114, 2.642117>, 
      <-0.476868, -4.489128, 2.696325>, <-0.440778, -4.529729, 2.699649>, <-0.387557, -4.570680, 2.654368>, <-0.333257, -4.568564, 2.651357>, 
      <-0.381980, -4.540296, 2.773677>, <-0.350056, -4.583900, 2.750237>, <-0.306188, -4.632645, 2.687278>, <-0.257520, -4.620417, 2.656428>, 
      <-0.328388, -4.583679, 2.815855>, <-0.296464, -4.627282, 2.792415>, <-0.275444, -4.671404, 2.696609>, <-0.226776, -4.659176, 2.665759>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.284496, -4.175205, 2.568817>, <-0.233308, -4.206090, 2.575640>, <-0.165057, -4.247269, 2.584738>, <-0.113869, -4.278154, 2.591562>, 
      <-0.339987, -4.248720, 2.594573>, <-0.288799, -4.279605, 2.601397>, <-0.226655, -4.320157, 2.599905>, <-0.175467, -4.351042, 2.606729>, 
      <-0.460710, -4.338761, 2.605386>, <-0.424621, -4.379362, 2.608710>, <-0.346509, -4.432158, 2.627393>, <-0.292209, -4.430041, 2.624382>, 
      <-0.469467, -4.420255, 2.654672>, <-0.433377, -4.460857, 2.657996>, <-0.373496, -4.523230, 2.645128>, <-0.319196, -4.521114, 2.642117>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.431365, -4.342491, 2.584673>, <-0.381596, -4.386170, 2.594924>, <-0.317887, -4.487742, 2.620843>, <-0.252730, -4.472810, 2.616211>, 
      <-0.416599, -4.277368, 2.589529>, <-0.366830, -4.321048, 2.599780>, <-0.298023, -4.418867, 2.612976>, <-0.232866, -4.403934, 2.608344>, 
      <-0.328557, -4.225391, 2.573574>, <-0.277369, -4.256276, 2.580397>, <-0.206715, -4.305666, 2.592133>, <-0.155527, -4.336551, 2.598957>, 
      <-0.284496, -4.175205, 2.568817>, <-0.233308, -4.206090, 2.575640>, <-0.165057, -4.247269, 2.584738>, <-0.113869, -4.278154, 2.591562>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.431365, -4.342491, 2.584673>, <-0.446410, -4.408842, 2.579726>, <-0.423663, -4.515745, 2.553447>, <-0.371114, -4.557217, 2.540334>, 
      <-0.381596, -4.386170, 2.594924>, <-0.396641, -4.452522, 2.589977>, <-0.395026, -4.564640, 2.576974>, <-0.342477, -4.606112, 2.563861>, 
      <-0.317887, -4.487742, 2.620843>, <-0.333950, -4.543436, 2.627204>, <-0.306597, -4.657953, 2.628638>, <-0.271622, -4.704336, 2.633701>, 
      <-0.252730, -4.472810, 2.616211>, <-0.268793, -4.528504, 2.622572>, <-0.260198, -4.617859, 2.630599>, <-0.225222, -4.664242, 2.635661>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.004022, -4.686101, 2.476029>, <0.003966, -4.743640, 2.506826>, <0.003000, -4.876180, 2.640144>, <0.003227, -4.812249, 2.653258>, 
      <-0.116529, -4.686101, 2.476029>, <-0.116585, -4.743640, 2.506826>, <-0.078832, -4.876180, 2.640144>, <-0.078605, -4.812249, 2.653258>, 
      <-0.278248, -4.630508, 2.517161>, <-0.249611, -4.679402, 2.540688>, <-0.222539, -4.769427, 2.640805>, <-0.176140, -4.729333, 2.642765>, 
      <-0.371114, -4.557217, 2.540334>, <-0.342477, -4.606112, 2.563861>, <-0.271622, -4.704336, 2.633701>, <-0.225222, -4.664242, 2.635661>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.525022, -3.413928, 3.109541>, <-0.568030, -3.403883, 3.121716>, <-0.636370, -3.412694, 3.144291>, <-0.668381, -3.380444, 3.150126>, 
      <-0.542540, -3.402253, 3.022154>, <-0.585548, -3.392208, 3.034330>, <-0.654492, -3.400617, 3.053891>, <-0.686503, -3.368367, 3.059726>, 
      <-0.560383, -3.430490, 2.953879>, <-0.603391, -3.428618, 2.967203>, <-0.660208, -3.430137, 2.996799>, <-0.703825, -3.418821, 2.996386>, 
      <-0.565255, -3.499755, 2.896798>, <-0.608262, -3.497883, 2.910121>, <-0.664996, -3.504830, 2.941622>, <-0.708613, -3.493514, 2.941210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.491961, -3.548600, 3.262415>, <-0.534968, -3.546728, 3.275738>, <-0.597837, -3.548344, 3.282538>, <-0.635319, -3.542358, 3.306827>, 
      <-0.503352, -3.490018, 3.245909>, <-0.546359, -3.488146, 3.259232>, <-0.609610, -3.483407, 3.264862>, <-0.647092, -3.477421, 3.289151>, 
      <-0.509498, -3.424274, 3.186982>, <-0.552505, -3.414229, 3.199158>, <-0.619240, -3.424109, 3.229739>, <-0.651251, -3.391859, 3.235574>, 
      <-0.525022, -3.413928, 3.109541>, <-0.568030, -3.403883, 3.121716>, <-0.636370, -3.412694, 3.144291>, <-0.668381, -3.380444, 3.150126>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.451970, -3.789623, 3.215398>, <-0.494977, -3.787750, 3.228721>, <-0.556422, -3.772548, 3.239817>, <-0.595328, -3.783381, 3.259807>, 
      <-0.461068, -3.715757, 3.276071>, <-0.504076, -3.713884, 3.289394>, <-0.559326, -3.698382, 3.300736>, <-0.598232, -3.709214, 3.320726>, 
      <-0.478230, -3.619217, 3.282312>, <-0.521237, -3.617344, 3.295636>, <-0.584975, -3.619286, 3.301849>, <-0.622457, -3.613300, 3.326138>, 
      <-0.491961, -3.548600, 3.262415>, <-0.534968, -3.546728, 3.275738>, <-0.597837, -3.548344, 3.282538>, <-0.635319, -3.542358, 3.306827>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.454264, -3.854645, 3.011033>, <-0.504985, -3.852772, 3.024357>, <-0.580647, -3.818658, 3.062284>, <-0.623334, -3.848403, 3.055447>, 
      <-0.445738, -3.863400, 3.042001>, <-0.496459, -3.861527, 3.055325>, <-0.572049, -3.827487, 3.093512>, <-0.614736, -3.857231, 3.086675>, 
      <-0.444127, -3.853297, 3.163097>, <-0.487134, -3.851425, 3.176420>, <-0.553897, -3.837019, 3.186862>, <-0.592803, -3.847852, 3.206852>, 
      <-0.451970, -3.789623, 3.215398>, <-0.494977, -3.787750, 3.228721>, <-0.556422, -3.772548, 3.239817>, <-0.595328, -3.783381, 3.259807>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.544747, -3.694361, 2.878434>, <-0.587754, -3.692489, 2.891757>, <-0.643823, -3.680182, 2.925438>, <-0.688105, -3.688120, 2.922843>, 
      <-0.519767, -3.774235, 2.904145>, <-0.562774, -3.772363, 2.917467>, <-0.625073, -3.758209, 2.950554>, <-0.669355, -3.766147, 2.947959>, 
      <-0.463283, -3.845385, 2.978278>, <-0.514003, -3.843512, 2.991602>, <-0.589309, -3.809765, 3.030824>, <-0.631996, -3.839509, 3.023988>, 
      <-0.454264, -3.854645, 3.011033>, <-0.504985, -3.852772, 3.024357>, <-0.580647, -3.818658, 3.062284>, <-0.623334, -3.848403, 3.055447>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.544747, -3.694361, 2.878434>, <-0.566390, -3.625158, 2.856158>, <-0.569366, -3.558206, 2.848628>, <-0.565255, -3.499755, 2.896798>, 
      <-0.587754, -3.692489, 2.891757>, <-0.609398, -3.623285, 2.869481>, <-0.612374, -3.556334, 2.861952>, <-0.608262, -3.497883, 2.910121>, 
      <-0.643823, -3.680182, 2.925438>, <-0.660737, -3.609795, 2.902780>, <-0.668902, -3.565761, 2.896612>, <-0.664996, -3.504830, 2.941622>, 
      <-0.688105, -3.688120, 2.922843>, <-0.705019, -3.617733, 2.900186>, <-0.712519, -3.554445, 2.896200>, <-0.708613, -3.493514, 2.941210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.680604, -3.257187, 3.137901>, <-0.678493, -3.294394, 3.140224>, <-0.694471, -3.354159, 3.154882>, <-0.668381, -3.380444, 3.150126>, 
      <-0.692107, -3.248008, 3.075043>, <-0.689996, -3.285214, 3.077366>, <-0.712593, -3.342083, 3.064482>, <-0.686503, -3.368367, 3.059726>, 
      <-0.745097, -3.343334, 2.956001>, <-0.735019, -3.340880, 2.977899>, <-0.727278, -3.412737, 2.996165>, <-0.703825, -3.418821, 2.996386>, 
      <-0.758257, -3.449682, 2.894974>, <-0.748180, -3.447228, 2.916873>, <-0.732066, -3.487429, 2.940988>, <-0.708613, -3.493514, 2.941210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.669913, -3.520181, 3.377731>, <-0.682768, -3.527227, 3.357994>, <-0.655768, -3.539092, 3.320079>, <-0.635319, -3.542358, 3.306827>, 
      <-0.679056, -3.417938, 3.348155>, <-0.691911, -3.424984, 3.328418>, <-0.667541, -3.474156, 3.302403>, <-0.647092, -3.477421, 3.289151>, 
      <-0.667785, -3.267416, 3.207951>, <-0.665674, -3.304623, 3.210274>, <-0.677342, -3.365574, 3.240330>, <-0.651251, -3.391859, 3.235574>, 
      <-0.680604, -3.257187, 3.137901>, <-0.678493, -3.294394, 3.140224>, <-0.694471, -3.354159, 3.154882>, <-0.668381, -3.380444, 3.150126>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.628595, -3.838801, 3.306150>, <-0.639955, -3.834439, 3.285626>, <-0.615928, -3.789117, 3.270392>, <-0.595328, -3.783381, 3.259807>, 
      <-0.643609, -3.744769, 3.390240>, <-0.654969, -3.740407, 3.369716>, <-0.618833, -3.714950, 3.331311>, <-0.598232, -3.709214, 3.320726>, 
      <-0.661462, -3.614693, 3.405072>, <-0.674316, -3.621739, 3.385335>, <-0.642906, -3.610035, 3.339390>, <-0.622457, -3.613300, 3.326138>, 
      <-0.669913, -3.520181, 3.377731>, <-0.682768, -3.527227, 3.357994>, <-0.655768, -3.539092, 3.320079>, <-0.635319, -3.542358, 3.306827>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.600266, -3.956379, 2.987650>, <-0.587731, -3.968823, 3.037498>, <-0.613055, -3.936124, 3.219116>, <-0.628595, -3.838801, 3.306150>, 
      <-0.604742, -3.920471, 3.001842>, <-0.592207, -3.932915, 3.051690>, <-0.624415, -3.931762, 3.198591>, <-0.639955, -3.834439, 3.285626>, 
      <-0.654953, -3.870436, 3.050383>, <-0.646355, -3.879264, 3.081611>, <-0.613404, -3.853588, 3.217437>, <-0.615928, -3.789117, 3.270392>, 
      <-0.623334, -3.848403, 3.055447>, <-0.614736, -3.857231, 3.086675>, <-0.592803, -3.847852, 3.206852>, <-0.595328, -3.783381, 3.259807>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.739012, -3.729182, 2.867051>, <-0.705937, -3.835256, 2.886452>, <-0.611019, -3.945704, 2.944889>, <-0.600266, -3.956379, 2.987650>, 
      <-0.731088, -3.721378, 2.890320>, <-0.698013, -3.827452, 2.909721>, <-0.615494, -3.909796, 2.959081>, <-0.604742, -3.920471, 3.001842>, 
      <-0.713449, -3.692662, 2.921358>, <-0.694699, -3.770689, 2.946474>, <-0.663615, -3.861542, 3.018924>, <-0.654953, -3.870436, 3.050383>, 
      <-0.688105, -3.688120, 2.922843>, <-0.669355, -3.766147, 2.947959>, <-0.631996, -3.839509, 3.023988>, <-0.623334, -3.848403, 3.055447>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.739012, -3.729182, 2.867051>, <-0.731088, -3.721378, 2.890320>, <-0.713449, -3.692662, 2.921358>, <-0.688105, -3.688120, 2.922843>, 
      <-0.770875, -3.626993, 2.848360>, <-0.762951, -3.619189, 2.871629>, <-0.730362, -3.622275, 2.898700>, <-0.705019, -3.617733, 2.900186>, 
      <-0.769853, -3.543390, 2.841201>, <-0.759776, -3.540935, 2.863099>, <-0.735972, -3.548360, 2.895978>, <-0.712519, -3.554445, 2.896200>, 
      <-0.758257, -3.449682, 2.894974>, <-0.748180, -3.447228, 2.916873>, <-0.732066, -3.487429, 2.940988>, <-0.708613, -3.493514, 2.941210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.246146, -3.112834, 3.162863>, <-0.242751, -2.900645, 3.061385>, <-0.212111, -2.651834, 2.862404>, <-0.229982, -2.469661, 2.714665>, 
      <-0.377372, -3.115824, 3.160326>, <-0.373977, -2.903635, 3.058849>, <-0.340816, -2.656393, 2.837515>, <-0.358687, -2.474220, 2.689776>, 
      <-0.580218, -3.123882, 3.216212>, <-0.573006, -2.934418, 3.083496>, <-0.504920, -2.666283, 2.817382>, <-0.537446, -2.493978, 2.666335>, 
      <-0.681868, -3.142699, 3.135287>, <-0.674656, -2.953235, 3.002571>, <-0.621152, -2.722178, 2.793488>, <-0.653678, -2.549873, 2.642441>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.783414, -3.511732, 2.778667>, <-0.774625, -3.508799, 2.817847>, <-0.775001, -3.453760, 2.858588>, <-0.758257, -3.449682, 2.894974>, 
      <-0.768858, -3.380493, 2.863491>, <-0.760069, -3.377560, 2.902672>, <-0.761841, -3.347412, 2.919615>, <-0.745097, -3.343334, 2.956001>, 
      <-0.712332, -3.253409, 3.028301>, <-0.713403, -3.281536, 3.048003>, <-0.694049, -3.213772, 3.072906>, <-0.692107, -3.248008, 3.075043>, 
      <-0.681868, -3.142699, 3.135287>, <-0.682939, -3.170826, 3.154989>, <-0.682546, -3.222951, 3.135764>, <-0.680604, -3.257187, 3.137901>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.563370, -3.502923, 3.417294>, <-0.595871, -3.500791, 3.428628>, <-0.651881, -3.510298, 3.405416>, <-0.669913, -3.520181, 3.377731>, 
      <-0.592165, -3.371855, 3.371558>, <-0.624666, -3.369723, 3.382892>, <-0.661024, -3.408055, 3.375840>, <-0.679056, -3.417938, 3.348155>, 
      <-0.646319, -3.250766, 3.219889>, <-0.647389, -3.278893, 3.239591>, <-0.669727, -3.233181, 3.205814>, <-0.667785, -3.267416, 3.207951>, 
      <-0.681868, -3.142699, 3.135287>, <-0.682939, -3.170826, 3.154989>, <-0.682546, -3.222951, 3.135764>, <-0.680604, -3.257187, 3.137901>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.536118, -3.806117, 3.366784>, <-0.568666, -3.803718, 3.378254>, <-0.612125, -3.845125, 3.335907>, <-0.628595, -3.838801, 3.306150>, 
      <-0.540172, -3.945128, 3.265085>, <-0.572721, -3.942729, 3.276555>, <-0.596586, -3.942449, 3.248872>, <-0.613055, -3.936124, 3.219116>, 
      <-0.568870, -4.062769, 3.059108>, <-0.594941, -4.002616, 3.075581>, <-0.579948, -4.031271, 3.012816>, <-0.587731, -3.968823, 3.037498>, 
      <-0.582906, -4.172763, 2.927246>, <-0.608977, -4.112610, 2.943720>, <-0.592483, -4.018826, 2.962968>, <-0.600266, -3.956379, 2.987650>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.536118, -3.806117, 3.366784>, <-0.568666, -3.803718, 3.378254>, <-0.612125, -3.845125, 3.335907>, <-0.628595, -3.838801, 3.306150>, 
      <-0.533940, -3.731424, 3.421429>, <-0.566488, -3.729025, 3.432899>, <-0.627139, -3.751094, 3.419996>, <-0.643609, -3.744769, 3.390240>, 
      <-0.544568, -3.588506, 3.447158>, <-0.577068, -3.586374, 3.458492>, <-0.643430, -3.604810, 3.432757>, <-0.661462, -3.614693, 3.405072>, 
      <-0.563370, -3.502923, 3.417294>, <-0.595871, -3.500791, 3.428628>, <-0.651881, -3.510298, 3.405416>, <-0.669913, -3.520181, 3.377731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.749014, -3.748108, 2.743991>, <-0.707177, -3.886036, 2.774993>, <-0.632738, -4.045366, 2.872270>, <-0.582906, -4.172763, 2.927246>, 
      <-0.753521, -3.739932, 2.780282>, <-0.711684, -3.877860, 2.811284>, <-0.658809, -3.985213, 2.888743>, <-0.608977, -4.112610, 2.943720>, 
      <-0.750526, -3.740522, 2.833242>, <-0.717451, -3.846596, 2.852643>, <-0.603235, -4.008152, 2.920207>, <-0.592483, -4.018826, 2.962968>, 
      <-0.739012, -3.729182, 2.867051>, <-0.705937, -3.835256, 2.886452>, <-0.611019, -3.945704, 2.944889>, <-0.600266, -3.956379, 2.987650>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.749014, -3.748108, 2.743991>, <-0.753521, -3.739932, 2.780282>, <-0.750526, -3.740522, 2.833242>, <-0.739012, -3.729182, 2.867051>, 
      <-0.769563, -3.680364, 2.728764>, <-0.774069, -3.672188, 2.765055>, <-0.782389, -3.638333, 2.814552>, <-0.770875, -3.626993, 2.848360>, 
      <-0.790130, -3.572284, 2.739530>, <-0.781341, -3.569351, 2.778710>, <-0.786597, -3.547468, 2.804815>, <-0.769853, -3.543390, 2.841201>, 
      <-0.783414, -3.511732, 2.778667>, <-0.774625, -3.508799, 2.817847>, <-0.775001, -3.453760, 2.858588>, <-0.758257, -3.449682, 2.894974>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.004099, -3.127070, 3.148546>, <0.002581, -2.926269, 3.076906>, <-0.001699, -2.698127, 2.895047>, <-0.003932, -2.526860, 2.768089>, 
      <-0.071219, -3.127070, 3.148546>, <-0.072736, -2.926269, 3.076906>, <-0.073464, -2.698127, 2.895047>, <-0.075697, -2.526860, 2.768089>, 
      <-0.170862, -3.111119, 3.164318>, <-0.167467, -2.898930, 3.062840>, <-0.141694, -2.649340, 2.876021>, <-0.159565, -2.467167, 2.728282>, 
      <-0.246146, -3.112834, 3.162863>, <-0.242751, -2.900645, 3.061385>, <-0.212111, -2.651834, 2.862404>, <-0.229982, -2.469661, 2.714665>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.923109, -3.238154, 2.623922>, <-0.868072, -3.200314, 2.782451>, <-0.815061, -3.167356, 3.029250>, <-0.681868, -3.142699, 3.135287>, 
      <-0.963813, -3.124794, 2.611129>, <-0.908776, -3.086954, 2.769658>, <-0.807849, -2.977892, 2.896534>, <-0.674656, -2.953235, 3.002571>, 
      <-1.005123, -2.953670, 2.615436>, <-0.911042, -2.848925, 2.670461>, <-0.755103, -2.786593, 2.765951>, <-0.621152, -2.722178, 2.793488>, 
      <-1.040071, -2.859225, 2.548132>, <-0.945990, -2.754481, 2.603157>, <-0.787628, -2.614289, 2.614904>, <-0.653678, -2.549873, 2.642441>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.916989, -3.304355, 2.458041>, <-0.934737, -3.284707, 2.504659>, <-0.940261, -3.249947, 2.574516>, <-0.923109, -3.238154, 2.623922>, 
      <-0.967294, -3.221743, 2.443233>, <-0.985041, -3.202095, 2.489851>, <-0.980966, -3.136587, 2.561723>, <-0.963813, -3.124794, 2.611129>, 
      <-1.058821, -3.108393, 2.445582>, <-1.061161, -3.070267, 2.510381>, <-1.051938, -3.005791, 2.588056>, <-1.005123, -2.953670, 2.615436>, 
      <-1.094854, -3.041055, 2.384412>, <-1.097194, -3.002929, 2.449212>, <-1.086886, -2.911347, 2.520751>, <-1.040071, -2.859225, 2.548132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.820792, -3.351425, 2.355160>, <-0.854495, -3.344183, 2.383382>, <-0.902241, -3.320682, 2.419301>, <-0.916989, -3.304355, 2.458041>, 
      <-0.879725, -3.263395, 2.307356>, <-0.913428, -3.256153, 2.335578>, <-0.952545, -3.238070, 2.404493>, <-0.967294, -3.221743, 2.443233>, 
      <-0.978292, -3.163623, 2.232371>, <-1.031113, -3.126986, 2.266869>, <-1.056552, -3.145371, 2.382733>, <-1.058821, -3.108393, 2.445582>, 
      <-1.025923, -3.089742, 2.156341>, <-1.078744, -3.053105, 2.190839>, <-1.092585, -3.078033, 2.321564>, <-1.094854, -3.041055, 2.384412>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.820792, -3.351425, 2.355160>, <-0.879725, -3.263395, 2.307356>, <-0.978292, -3.163623, 2.232371>, <-1.025923, -3.089742, 2.156341>, 
      <-0.752854, -3.366024, 2.298270>, <-0.811787, -3.277993, 2.250465>, <-0.893450, -3.222470, 2.176960>, <-0.941081, -3.148589, 2.100930>, 
      <-0.667807, -3.373012, 2.201558>, <-0.689090, -3.336930, 2.187169>, <-0.802249, -3.306572, 2.169945>, <-0.818894, -3.283211, 2.136193>, 
      <-0.581468, -3.376452, 2.177083>, <-0.602751, -3.340369, 2.162694>, <-0.688644, -3.334622, 2.163737>, <-0.705289, -3.311261, 2.129985>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.004099, -3.384289, 2.121322>, <-0.172381, -3.384289, 2.121322>, <-0.411803, -3.383212, 2.128987>, <-0.581468, -3.376452, 2.177083>, 
      <0.004235, -3.371428, 2.117111>, <-0.172246, -3.371428, 2.117111>, <-0.433085, -3.347129, 2.114597>, <-0.602751, -3.340369, 2.162694>, 
      <0.006235, -3.352119, 2.111205>, <-0.207712, -3.352119, 2.111205>, <-0.481227, -3.385836, 2.152402>, <-0.688644, -3.334622, 2.163737>, 
      <0.006451, -3.344646, 2.099925>, <-0.207496, -3.344646, 2.099925>, <-0.497872, -3.362474, 2.118650>, <-0.705289, -3.311261, 2.129985>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.247232, -3.547909, 3.230331>, <-0.248962, -3.415840, 3.229451>, <-0.248052, -3.231979, 3.219843>, <-0.246146, -3.112834, 3.162863>, 
      <-0.175326, -3.558848, 3.196096>, <-0.177056, -3.426780, 3.195216>, <-0.172768, -3.230264, 3.221298>, <-0.170862, -3.111119, 3.164318>, 
      <-0.076288, -3.589254, 3.147118>, <-0.076288, -3.451241, 3.160456>, <-0.070231, -3.257660, 3.195137>, <-0.071219, -3.127070, 3.148546>, 
      <0.004099, -3.589254, 3.147118>, <0.004099, -3.451241, 3.160456>, <0.005086, -3.257660, 3.195137>, <0.004099, -3.127070, 3.148546>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.247232, -3.547909, 3.230331>, <-0.346529, -3.532803, 3.277607>, <-0.458752, -3.509786, 3.380811>, <-0.563370, -3.502923, 3.417294>, 
      <-0.248962, -3.415840, 3.229451>, <-0.348258, -3.400734, 3.276726>, <-0.487547, -3.378718, 3.335075>, <-0.592165, -3.371855, 3.371558>, 
      <-0.248052, -3.231979, 3.219843>, <-0.379278, -3.234969, 3.217307>, <-0.544669, -3.231949, 3.300814>, <-0.646319, -3.250766, 3.219889>, 
      <-0.246146, -3.112834, 3.162863>, <-0.377372, -3.115824, 3.160326>, <-0.580218, -3.123882, 3.216212>, <-0.681868, -3.142699, 3.135287>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.820587, -3.470482, 2.617113>, <-0.817840, -3.468212, 2.668238>, <-0.794602, -3.515466, 2.728793>, <-0.783414, -3.511732, 2.778667>, 
      <-0.848537, -3.399812, 2.622823>, <-0.845790, -3.397542, 2.673948>, <-0.780046, -3.384226, 2.813618>, <-0.768858, -3.380493, 2.863491>, 
      <-0.897498, -3.309479, 2.631971>, <-0.842461, -3.271639, 2.790500>, <-0.845525, -3.278066, 2.922264>, <-0.712332, -3.253409, 3.028301>, 
      <-0.923109, -3.238154, 2.623922>, <-0.868072, -3.200314, 2.782451>, <-0.815061, -3.167356, 3.029250>, <-0.681868, -3.142699, 3.135287>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.799932, -3.525387, 2.471230>, <-0.817765, -3.512920, 2.513083>, <-0.823115, -3.472572, 2.570057>, <-0.820587, -3.470482, 2.617113>, 
      <-0.840705, -3.462887, 2.462448>, <-0.858538, -3.450420, 2.504300>, <-0.851065, -3.401902, 2.575766>, <-0.848537, -3.399812, 2.622823>, 
      <-0.878360, -3.367793, 2.469412>, <-0.896108, -3.348145, 2.516031>, <-0.914651, -3.321272, 2.582565>, <-0.897498, -3.309479, 2.631971>, 
      <-0.916989, -3.304355, 2.458041>, <-0.934737, -3.284707, 2.504659>, <-0.940261, -3.249947, 2.574516>, <-0.923109, -3.238154, 2.623922>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.727428, -3.535612, 2.398469>, <-0.749249, -3.478317, 2.382730>, <-0.788696, -3.399368, 2.381195>, <-0.820792, -3.351425, 2.355160>, 
      <-0.676854, -3.542756, 2.347632>, <-0.698674, -3.485462, 2.331894>, <-0.720757, -3.413967, 2.324305>, <-0.752854, -3.366024, 2.298270>, 
      <-0.627711, -3.556454, 2.250176>, <-0.634398, -3.501369, 2.235261>, <-0.640199, -3.419819, 2.220224>, <-0.667807, -3.373012, 2.201558>, 
      <-0.558907, -3.559436, 2.228954>, <-0.565594, -3.504352, 2.214039>, <-0.553860, -3.423258, 2.195749>, <-0.581468, -3.376452, 2.177083>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.727428, -3.535612, 2.398469>, <-0.749161, -3.532542, 2.420315>, <-0.788225, -3.533572, 2.443753>, <-0.799932, -3.525387, 2.471230>, 
      <-0.749249, -3.478317, 2.382730>, <-0.770982, -3.475247, 2.404577>, <-0.828998, -3.471072, 2.434971>, <-0.840705, -3.462887, 2.462448>, 
      <-0.788696, -3.399368, 2.381195>, <-0.822399, -3.392126, 2.409418>, <-0.863612, -3.384120, 2.430672>, <-0.878360, -3.367793, 2.469412>, 
      <-0.820792, -3.351425, 2.355160>, <-0.854495, -3.344183, 2.383382>, <-0.902241, -3.320682, 2.419301>, <-0.916989, -3.304355, 2.458041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.004099, -3.567323, 2.172835>, <-0.165656, -3.567323, 2.172835>, <-0.396832, -3.566462, 2.178963>, <-0.558907, -3.559436, 2.228954>, 
      <0.004099, -3.512044, 2.158755>, <-0.165656, -3.512044, 2.158755>, <-0.403519, -3.511378, 2.164048>, <-0.565594, -3.504352, 2.214039>, 
      <0.003526, -3.438498, 2.139071>, <-0.172954, -3.438498, 2.139071>, <-0.384194, -3.430018, 2.147652>, <-0.553860, -3.423258, 2.195749>, 
      <0.004099, -3.384289, 2.121322>, <-0.172381, -3.384289, 2.121322>, <-0.411803, -3.383212, 2.128987>, <-0.581468, -3.376452, 2.177083>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.236260, -3.867719, 3.167894>, <-0.220349, -3.775200, 3.195349>, <-0.245951, -3.645708, 3.230983>, <-0.247232, -3.547909, 3.230331>, 
      <-0.168669, -3.877390, 3.131443>, <-0.152758, -3.784871, 3.158899>, <-0.174046, -3.656647, 3.196748>, <-0.175326, -3.558848, 3.196096>, 
      <-0.073301, -3.883416, 3.075453>, <-0.073264, -3.794214, 3.092570>, <-0.076288, -3.679662, 3.138381>, <-0.076288, -3.589254, 3.147118>, 
      <0.004099, -3.883416, 3.075453>, <0.004136, -3.794214, 3.092570>, <0.004099, -3.679662, 3.138381>, <0.004099, -3.589254, 3.147118>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.236260, -3.867719, 3.167894>, <-0.331898, -3.854034, 3.219470>, <-0.433075, -3.813712, 3.330472>, <-0.536118, -3.806117, 3.366784>, 
      <-0.220349, -3.775200, 3.195349>, <-0.315987, -3.761515, 3.246926>, <-0.430897, -3.739019, 3.385117>, <-0.533940, -3.731424, 3.421429>, 
      <-0.245951, -3.645708, 3.230983>, <-0.345248, -3.630602, 3.278259>, <-0.439950, -3.595369, 3.410675>, <-0.544568, -3.588506, 3.447158>, 
      <-0.247232, -3.547909, 3.230331>, <-0.346529, -3.532803, 3.277607>, <-0.458752, -3.509786, 3.380811>, <-0.563370, -3.502923, 3.417294>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.703241, -3.794073, 2.579007>, <-0.716961, -3.811338, 2.627403>, <-0.742618, -3.759712, 2.692484>, <-0.749014, -3.748108, 2.743991>, 
      <-0.728754, -3.693364, 2.579791>, <-0.742474, -3.710629, 2.628187>, <-0.763166, -3.691968, 2.677257>, <-0.769563, -3.680364, 2.728764>, 
      <-0.782484, -3.566823, 2.609329>, <-0.779737, -3.564552, 2.660454>, <-0.801318, -3.576017, 2.689656>, <-0.790130, -3.572284, 2.739530>, 
      <-0.820587, -3.470482, 2.617113>, <-0.817840, -3.468212, 2.668238>, <-0.794602, -3.515466, 2.728793>, <-0.783414, -3.511732, 2.778667>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.682282, -3.664130, 2.508596>, <-0.707780, -3.645482, 2.540337>, <-0.691689, -3.779535, 2.538257>, <-0.703241, -3.794073, 2.579007>, 
      <-0.719532, -3.623262, 2.501806>, <-0.745030, -3.604614, 2.533547>, <-0.717202, -3.678826, 2.539041>, <-0.728754, -3.693364, 2.579791>, 
      <-0.769700, -3.571728, 2.477742>, <-0.787533, -3.559261, 2.519595>, <-0.785012, -3.568913, 2.562273>, <-0.782484, -3.566823, 2.609329>, 
      <-0.799932, -3.525387, 2.471230>, <-0.817765, -3.512920, 2.513083>, <-0.823115, -3.472572, 2.570057>, <-0.820587, -3.470482, 2.617113>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.632511, -3.845801, 2.490960>, <-0.650972, -3.748861, 2.468552>, <-0.692543, -3.627210, 2.423630>, <-0.727428, -3.535612, 2.398469>, 
      <-0.601199, -3.886086, 2.452500>, <-0.619660, -3.789146, 2.430092>, <-0.641969, -3.634355, 2.372793>, <-0.676854, -3.542756, 2.347632>, 
      <-0.581028, -3.867888, 2.333802>, <-0.588595, -3.774442, 2.307636>, <-0.616383, -3.649767, 2.275442>, <-0.627711, -3.556454, 2.250176>, 
      <-0.521421, -3.871091, 2.311015>, <-0.528988, -3.777645, 2.284848>, <-0.547579, -3.652750, 2.254220>, <-0.558907, -3.559436, 2.228954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.632511, -3.845801, 2.490960>, <-0.660325, -3.810016, 2.525123>, <-0.649965, -3.687765, 2.468367>, <-0.682282, -3.664130, 2.508596>, 
      <-0.650972, -3.748861, 2.468552>, <-0.678786, -3.713076, 2.502715>, <-0.687215, -3.646897, 2.461577>, <-0.719532, -3.623262, 2.501806>, 
      <-0.692543, -3.627210, 2.423630>, <-0.714276, -3.624140, 2.445476>, <-0.757993, -3.579913, 2.450265>, <-0.769700, -3.571728, 2.477742>, 
      <-0.727428, -3.535612, 2.398469>, <-0.749161, -3.532542, 2.420315>, <-0.788225, -3.533572, 2.443753>, <-0.799932, -3.525387, 2.471230>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.004099, -3.880005, 2.247584>, <-0.154724, -3.880005, 2.247584>, <-0.373256, -3.879052, 2.254371>, <-0.521421, -3.871091, 2.311015>, 
      <0.004139, -3.786168, 2.225294>, <-0.154684, -3.786168, 2.225294>, <-0.380823, -3.785606, 2.228204>, <-0.528988, -3.777645, 2.284848>, 
      <0.004099, -3.660787, 2.196641>, <-0.165656, -3.660787, 2.196641>, <-0.385504, -3.659775, 2.204229>, <-0.547579, -3.652750, 2.254220>, 
      <0.004099, -3.567323, 2.172835>, <-0.165656, -3.567323, 2.172835>, <-0.396832, -3.566462, 2.178963>, <-0.558907, -3.559436, 2.228954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.355321, -4.176421, 3.043817>, <-0.360186, -4.077701, 3.082141>, <-0.253505, -3.967995, 3.138137>, <-0.236260, -3.867719, 3.167894>, 
      <-0.248147, -4.187036, 3.061490>, <-0.253011, -4.088316, 3.099814>, <-0.185914, -3.977666, 3.101686>, <-0.168669, -3.877390, 3.131443>, 
      <-0.105308, -4.230879, 3.024001>, <-0.105154, -4.127874, 3.046224>, <-0.073344, -3.986904, 3.055596>, <-0.073301, -3.883416, 3.075453>, 
      <0.003831, -4.230879, 3.024001>, <0.003985, -4.127874, 3.046224>, <0.004056, -3.986904, 3.055596>, <0.004099, -3.883416, 3.075453>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.355321, -4.176421, 3.043817>, <-0.348164, -4.321665, 2.987432>, <-0.245188, -4.513446, 2.946549>, <-0.198212, -4.639834, 2.868154>, 
      <-0.248147, -4.187036, 3.061490>, <-0.240989, -4.332281, 3.005106>, <-0.186939, -4.525539, 2.963018>, <-0.139964, -4.651927, 2.884623>, 
      <-0.105308, -4.230879, 3.024001>, <-0.105500, -4.358987, 2.996362>, <-0.058658, -4.536167, 2.969946>, <-0.058781, -4.652468, 2.909533>, 
      <0.003831, -4.230879, 3.024001>, <0.003639, -4.358987, 2.996362>, <0.003070, -4.536167, 2.969946>, <0.002947, -4.652468, 2.909533>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.355321, -4.176421, 3.043817>, <-0.348164, -4.321665, 2.987432>, <-0.245188, -4.513446, 2.946549>, <-0.198212, -4.639834, 2.868154>, 
      <-0.430658, -4.168959, 3.031394>, <-0.423501, -4.314203, 2.975009>, <-0.287965, -4.504565, 2.934455>, <-0.240990, -4.630953, 2.856060>, 
      <-0.539907, -4.176498, 2.990672>, <-0.482516, -4.308916, 2.954408>, <-0.378978, -4.497860, 2.898726>, <-0.298330, -4.608011, 2.839511>, 
      <-0.582906, -4.172763, 2.927246>, <-0.525515, -4.305182, 2.890981>, <-0.409035, -4.473528, 2.875070>, <-0.328388, -4.583679, 2.815855>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.355321, -4.176421, 3.043817>, <-0.430658, -4.168959, 3.031394>, <-0.539907, -4.176498, 2.990672>, <-0.582906, -4.172763, 2.927246>, 
      <-0.360186, -4.077701, 3.082141>, <-0.435523, -4.070238, 3.069717>, <-0.525871, -4.066504, 3.122534>, <-0.568870, -4.062769, 3.059108>, 
      <-0.253505, -3.967995, 3.138137>, <-0.349143, -3.954310, 3.189713>, <-0.437130, -3.952723, 3.228774>, <-0.540172, -3.945128, 3.265085>, 
      <-0.236260, -3.867719, 3.167894>, <-0.331898, -3.854034, 3.219470>, <-0.433075, -3.813712, 3.330472>, <-0.536118, -3.806117, 3.366784>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.648192, -4.150984, 2.611812>, <-0.614201, -4.242030, 2.622814>, <-0.534323, -4.347290, 2.648698>, <-0.469467, -4.420255, 2.654672>, 
      <-0.679002, -4.199386, 2.689845>, <-0.645012, -4.290432, 2.700846>, <-0.541723, -4.416163, 2.690351>, <-0.476868, -4.489128, 2.696325>, 
      <-0.637192, -4.168048, 2.847171>, <-0.579800, -4.300466, 2.810906>, <-0.462628, -4.430146, 2.832892>, <-0.381980, -4.540296, 2.773677>, 
      <-0.582906, -4.172763, 2.927246>, <-0.525515, -4.305182, 2.890981>, <-0.409035, -4.473528, 2.875070>, <-0.328388, -4.583679, 2.815855>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.648192, -4.150984, 2.611812>, <-0.679002, -4.199386, 2.689845>, <-0.637192, -4.168048, 2.847171>, <-0.582906, -4.172763, 2.927246>, 
      <-0.685999, -4.049716, 2.599575>, <-0.716809, -4.098118, 2.677608>, <-0.687024, -4.040651, 2.792195>, <-0.632738, -4.045366, 2.872270>, 
      <-0.676527, -3.899524, 2.578186>, <-0.690246, -3.916790, 2.626581>, <-0.700781, -3.897639, 2.723486>, <-0.707177, -3.886036, 2.774993>, 
      <-0.703241, -3.794073, 2.579007>, <-0.716961, -3.811338, 2.627403>, <-0.742618, -3.759712, 2.692484>, <-0.749014, -3.748108, 2.743991>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.429514, -3.931785, 2.538750>, <-0.386009, -4.004811, 2.547770>, <-0.328001, -4.102179, 2.559797>, <-0.284496, -4.175205, 2.568817>, 
      <-0.495117, -3.997545, 2.560668>, <-0.451612, -4.070571, 2.569689>, <-0.383493, -4.175694, 2.585553>, <-0.339987, -4.248720, 2.594573>, 
      <-0.617833, -4.103290, 2.534921>, <-0.583842, -4.194336, 2.545923>, <-0.525566, -4.265796, 2.599411>, <-0.460710, -4.338761, 2.605386>, 
      <-0.648192, -4.150984, 2.611812>, <-0.614201, -4.242030, 2.622814>, <-0.534323, -4.347290, 2.648698>, <-0.469467, -4.420255, 2.654672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.429514, -3.931785, 2.538750>, <-0.495117, -3.997545, 2.560668>, <-0.617833, -4.103290, 2.534921>, <-0.648192, -4.150984, 2.611812>, 
      <-0.505344, -3.851488, 2.529704>, <-0.570948, -3.917248, 2.551622>, <-0.655639, -4.002022, 2.522685>, <-0.685999, -4.049716, 2.599575>, 
      <-0.608191, -3.745418, 2.522101>, <-0.633689, -3.726770, 2.553842>, <-0.664974, -3.884986, 2.537435>, <-0.676527, -3.899524, 2.578186>, 
      <-0.682282, -3.664130, 2.508596>, <-0.707780, -3.645482, 2.540337>, <-0.691689, -3.779535, 2.538257>, <-0.703241, -3.794073, 2.579007>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.608398, -4.160663, 2.542952>, <-0.579870, -4.231107, 2.556243>, <-0.488671, -4.292197, 2.572869>, <-0.431365, -4.342491, 2.584673>, 
      <-0.584957, -4.087011, 2.583227>, <-0.556430, -4.157455, 2.596518>, <-0.473905, -4.227075, 2.577725>, <-0.416599, -4.277368, 2.589529>, 
      <-0.483179, -4.000449, 2.540010>, <-0.439674, -4.073475, 2.549031>, <-0.372062, -4.152365, 2.564553>, <-0.328557, -4.225391, 2.573574>, 
      <-0.429514, -3.931785, 2.538750>, <-0.386009, -4.004811, 2.547770>, <-0.328001, -4.102179, 2.559797>, <-0.284496, -4.175205, 2.568817>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.608398, -4.160663, 2.542952>, <-0.584957, -4.087011, 2.583227>, <-0.483179, -4.000449, 2.540010>, <-0.429514, -3.931785, 2.538750>, 
      <-0.643898, -4.073003, 2.526413>, <-0.620457, -3.999351, 2.566688>, <-0.559010, -3.920152, 2.530964>, <-0.505344, -3.851488, 2.529704>, 
      <-0.614996, -3.937775, 2.512220>, <-0.642810, -3.901990, 2.546383>, <-0.575874, -3.769052, 2.481872>, <-0.608191, -3.745418, 2.522101>, 
      <-0.632511, -3.845801, 2.490960>, <-0.660325, -3.810016, 2.525123>, <-0.649965, -3.687765, 2.468367>, <-0.682282, -3.664130, 2.508596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.608398, -4.160663, 2.542952>, <-0.622368, -4.204558, 2.518949>, <-0.557406, -4.177873, 2.420496>, <-0.508624, -4.180356, 2.402825>, 
      <-0.579870, -4.231107, 2.556243>, <-0.593840, -4.275002, 2.532240>, <-0.531525, -4.296012, 2.459980>, <-0.482744, -4.298495, 2.442310>, 
      <-0.488671, -4.292197, 2.572869>, <-0.503716, -4.358549, 2.567922>, <-0.483044, -4.414357, 2.504661>, <-0.430495, -4.455829, 2.491548>, 
      <-0.431365, -4.342491, 2.584673>, <-0.446410, -4.408842, 2.579726>, <-0.423663, -4.515745, 2.553447>, <-0.371114, -4.557217, 2.540334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.608398, -4.160663, 2.542952>, <-0.643898, -4.073003, 2.526413>, <-0.614996, -3.937775, 2.512220>, <-0.632511, -3.845801, 2.490960>, 
      <-0.622368, -4.204558, 2.518949>, <-0.657868, -4.116898, 2.502410>, <-0.583684, -3.978061, 2.473761>, <-0.601199, -3.886086, 2.452500>, 
      <-0.557406, -4.177873, 2.420496>, <-0.577109, -4.087931, 2.390435>, <-0.573497, -3.960876, 2.359841>, <-0.581028, -3.867888, 2.333802>, 
      <-0.508624, -4.180356, 2.402825>, <-0.528327, -4.090414, 2.372765>, <-0.513891, -3.964078, 2.337054>, <-0.521421, -3.871091, 2.311015>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.003831, -4.191830, 2.321182>, <0.003817, -4.341330, 2.363550>, <0.004155, -4.549103, 2.402702>, <0.004022, -4.686101, 2.476029>, 
      <-0.151882, -4.191830, 2.321182>, <-0.151897, -4.341330, 2.363550>, <-0.116396, -4.549103, 2.402701>, <-0.116529, -4.686101, 2.476029>, 
      <-0.362387, -4.187800, 2.349853>, <-0.336507, -4.305940, 2.389338>, <-0.337629, -4.529119, 2.468375>, <-0.278248, -4.630508, 2.517161>, 
      <-0.508624, -4.180356, 2.402825>, <-0.482744, -4.298495, 2.442310>, <-0.430495, -4.455829, 2.491548>, <-0.371114, -4.557217, 2.540334>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.003831, -4.191830, 2.321182>, <-0.151882, -4.191830, 2.321182>, <-0.362387, -4.187800, 2.349853>, <-0.508624, -4.180356, 2.402825>, 
      <0.003840, -4.099354, 2.294975>, <-0.151874, -4.099354, 2.294975>, <-0.382090, -4.097858, 2.319793>, <-0.528327, -4.090414, 2.372765>, 
      <0.004059, -3.973520, 2.269798>, <-0.154764, -3.973520, 2.269798>, <-0.365726, -3.972039, 2.280410>, <-0.513891, -3.964078, 2.337054>, 
      <0.004099, -3.880005, 2.247584>, <-0.154724, -3.880005, 2.247584>, <-0.373256, -3.879052, 2.254371>, <-0.521421, -3.871091, 2.311015>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.565469, -3.376452, 2.177082>, <0.403126, -3.383115, 2.129671>, <0.173355, -3.384289, 2.121322>, <0.004099, -3.384289, 2.121322>, 
      <0.586785, -3.340348, 2.162684>, <0.424442, -3.347011, 2.115273>, <0.173491, -3.371428, 2.117111>, <0.004235, -3.371428, 2.117111>, 
      <0.672273, -3.334524, 2.163594>, <0.473549, -3.384997, 2.152423>, <0.211573, -3.352120, 2.111205>, <0.006235, -3.352119, 2.111205>, 
      <0.689434, -3.311262, 2.129985>, <0.490710, -3.361735, 2.118814>, <0.211789, -3.344646, 2.099925>, <0.006451, -3.344646, 2.099925>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.542909, -3.559436, 2.228954>, <0.388203, -3.566372, 2.179604>, <0.166634, -3.567323, 2.172835>, <0.004099, -3.567323, 2.172835>, 
      <0.549596, -3.504352, 2.214039>, <0.394890, -3.511288, 2.164689>, <0.166634, -3.512044, 2.158755>, <0.004099, -3.512044, 2.158755>, 
      <0.537840, -3.423248, 2.195744>, <0.375497, -3.429911, 2.148332>, <0.172783, -3.438498, 2.139071>, <0.003526, -3.438498, 2.139071>, 
      <0.565469, -3.376452, 2.177082>, <0.403126, -3.383115, 2.129671>, <0.173355, -3.384289, 2.121322>, <0.004099, -3.384289, 2.121322>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.505422, -3.871091, 2.311014>, <0.364710, -3.878950, 2.255095>, <0.155719, -3.880005, 2.247584>, <0.004099, -3.880005, 2.247584>, 
      <0.513030, -3.777648, 2.284848>, <0.372319, -3.785507, 2.228929>, <0.155759, -3.786168, 2.225294>, <0.004139, -3.786168, 2.225294>, 
      <0.531581, -3.652750, 2.254220>, <0.376875, -3.659685, 2.204870>, <0.166634, -3.660787, 2.196641>, <0.004099, -3.660787, 2.196641>, 
      <0.542909, -3.559436, 2.228954>, <0.388203, -3.566372, 2.179604>, <0.166634, -3.567323, 2.172835>, <0.004099, -3.567323, 2.172835>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.492352, -4.180356, 2.402825>, <0.353448, -4.187715, 2.350462>, <0.152460, -4.191830, 2.321182>, <0.003831, -4.191830, 2.321182>, 
      <0.512047, -4.090409, 2.372763>, <0.373142, -4.097768, 2.320400>, <0.152469, -4.099354, 2.294975>, <0.003840, -4.099354, 2.294975>, 
      <0.497851, -3.964079, 2.337053>, <0.357139, -3.971938, 2.281133>, <0.155678, -3.973520, 2.269798>, <0.004059, -3.973520, 2.269798>, 
      <0.505422, -3.871091, 2.311014>, <0.364710, -3.878950, 2.255095>, <0.155719, -3.880005, 2.247584>, <0.004099, -3.880005, 2.247584>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.355186, -4.557217, 2.540335>, <0.269532, -4.628754, 2.517716>, <0.117889, -4.686101, 2.476029>, <0.004022, -4.686101, 2.476029>, 
      <0.414424, -4.455795, 2.491533>, <0.328771, -4.527331, 2.468914>, <0.118022, -4.549103, 2.402702>, <0.004155, -4.549103, 2.402702>, 
      <0.466490, -4.298467, 2.442301>, <0.327586, -4.305826, 2.389938>, <0.152446, -4.341330, 2.363550>, <0.003817, -4.341330, 2.363550>, 
      <0.492352, -4.180356, 2.402825>, <0.353448, -4.187715, 2.350462>, <0.152460, -4.191830, 2.321182>, <0.003831, -4.191830, 2.321182>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.209727, -4.664242, 2.635661>, <0.166591, -4.726929, 2.642503>, <0.079629, -4.812249, 2.653258>, <0.003227, -4.812249, 2.653258>, 
      <0.256179, -4.704131, 2.633652>, <0.213043, -4.766818, 2.640494>, <0.079402, -4.876180, 2.640144>, <0.003000, -4.876180, 2.640144>, 
      <0.326654, -4.606068, 2.563841>, <0.241000, -4.677604, 2.541222>, <0.117833, -4.743640, 2.506826>, <0.003966, -4.743640, 2.506826>, 
      <0.355186, -4.557217, 2.540335>, <0.269532, -4.628754, 2.517716>, <0.117889, -4.686101, 2.476029>, <0.004022, -4.686101, 2.476029>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.064163, -4.307313, 2.552920>, <0.045590, -4.337222, 2.546798>, <0.022755, -4.378319, 2.538920>, <0.005008, -4.408750, 2.532920>, 
      <0.107832, -4.414392, 2.577742>, <0.089259, -4.444301, 2.571620>, <0.022220, -4.499369, 2.575021>, <0.004474, -4.529800, 2.569021>, 
      <0.120044, -4.587230, 2.639539>, <0.076907, -4.649917, 2.646381>, <0.080069, -4.688507, 2.678641>, <0.003667, -4.688507, 2.678641>, 
      <0.209727, -4.664242, 2.635661>, <0.166591, -4.726929, 2.642503>, <0.079629, -4.812249, 2.653258>, <0.003227, -4.812249, 2.653258>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.236804, -4.472810, 2.616211>, <0.162037, -4.455652, 2.610889>, <0.135592, -4.329665, 2.578028>, <0.092215, -4.268317, 2.561664>, 
      <0.252892, -4.528478, 2.622569>, <0.178125, -4.511320, 2.617247>, <0.145786, -4.336324, 2.569886>, <0.102409, -4.274976, 2.553522>, 
      <0.242640, -4.616412, 2.630441>, <0.152957, -4.539400, 2.634319>, <0.115446, -4.402132, 2.580252>, <0.071776, -4.295053, 2.555429>, 
      <0.209727, -4.664242, 2.635661>, <0.120044, -4.587230, 2.639539>, <0.107832, -4.414392, 2.577742>, <0.064163, -4.307313, 2.552920>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.236804, -4.472810, 2.616211>, <0.216912, -4.403979, 2.608349>, <0.139744, -4.336551, 2.598957>, <0.098147, -4.278154, 2.591562>, 
      <0.162037, -4.455652, 2.610889>, <0.142145, -4.386821, 2.603027>, <0.111349, -4.333411, 2.601900>, <0.069752, -4.275014, 2.594506>, 
      <0.135592, -4.329665, 2.578028>, <0.115297, -4.316409, 2.594238>, <0.058508, -4.271016, 2.586517>, <0.031893, -4.270828, 2.598430>, 
      <0.092215, -4.268317, 2.561664>, <0.071921, -4.255061, 2.577873>, <0.030113, -4.267877, 2.589461>, <0.003498, -4.267688, 2.601374>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.061071, -4.546584, 2.672113>, <0.081929, -4.604410, 2.678875>, <0.100368, -4.716162, 2.645934>, <0.130599, -4.739336, 2.694654>, 
      <0.043778, -4.552990, 2.670916>, <0.064636, -4.610816, 2.677679>, <0.065331, -4.740530, 2.656138>, <0.095562, -4.763705, 2.704858>, 
      <0.019914, -4.561752, 2.669278>, <0.020452, -4.634391, 2.686400>, <0.046668, -4.777521, 2.656531>, <0.047108, -4.803884, 2.726351>, 
      <0.001434, -4.561752, 2.669278>, <0.001972, -4.634391, 2.686400>, <0.002787, -4.777521, 2.656531>, <0.003227, -4.803884, 2.726351>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.092345, -4.528075, 2.675569>, <0.128026, -4.567405, 2.672626>, <0.167387, -4.648110, 2.637839>, <0.211281, -4.659176, 2.665759>, 
      <0.088296, -4.537926, 2.678119>, <0.123977, -4.577256, 2.675176>, <0.145922, -4.675237, 2.644370>, <0.189816, -4.686304, 2.672290>, 
      <0.071319, -4.542788, 2.672822>, <0.092177, -4.600614, 2.679585>, <0.128476, -4.696612, 2.637748>, <0.158708, -4.719786, 2.686468>, 
      <0.061071, -4.546584, 2.672113>, <0.081929, -4.604410, 2.678875>, <0.100368, -4.716162, 2.645934>, <0.130599, -4.739336, 2.694654>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.118389, -4.407145, 2.636021>, <0.101180, -4.356710, 2.621650>, <0.037965, -4.309525, 2.611768>, <0.003498, -4.267688, 2.601374>, 
      <0.173853, -4.441336, 2.637850>, <0.156644, -4.390901, 2.623479>, <0.066360, -4.312665, 2.608824>, <0.031893, -4.270828, 2.598430>, 
      <0.238239, -4.518570, 2.638498>, <0.211213, -4.427548, 2.620773>, <0.131289, -4.347902, 2.609672>, <0.069752, -4.275014, 2.594506>, 
      <0.303270, -4.521114, 2.642117>, <0.276244, -4.430092, 2.624392>, <0.159684, -4.351042, 2.606729>, <0.098147, -4.278154, 2.591562>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.118389, -4.407145, 2.636021>, <0.173853, -4.441336, 2.637850>, <0.238239, -4.518570, 2.638498>, <0.303270, -4.521114, 2.642117>, 
      <0.130537, -4.442747, 2.646165>, <0.186001, -4.476938, 2.647994>, <0.252306, -4.565945, 2.647723>, <0.317337, -4.568489, 2.651342>, 
      <0.106751, -4.493030, 2.666498>, <0.142431, -4.532360, 2.663555>, <0.198041, -4.609370, 2.628512>, <0.241934, -4.620436, 2.656432>, 
      <0.092345, -4.528075, 2.675569>, <0.128026, -4.567405, 2.672626>, <0.167387, -4.648110, 2.637839>, <0.211281, -4.659176, 2.665759>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.182717, -4.639834, 2.868154>, <0.130778, -4.651362, 2.883852>, <0.058418, -4.652468, 2.909533>, <0.002947, -4.652468, 2.909533>, 
      <0.164060, -4.690084, 2.836985>, <0.112120, -4.701612, 2.852683>, <0.058351, -4.715739, 2.876667>, <0.002880, -4.715739, 2.876667>, 
      <0.160910, -4.762571, 2.743502>, <0.125873, -4.786940, 2.753706>, <0.047528, -4.829069, 2.793051>, <0.003647, -4.829069, 2.793051>, 
      <0.130599, -4.739336, 2.694654>, <0.095562, -4.763705, 2.704858>, <0.047108, -4.803884, 2.726351>, <0.003227, -4.803884, 2.726351>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.312890, -4.583679, 2.815855>, <0.282859, -4.608027, 2.839527>, <0.225163, -4.630414, 2.855325>, <0.182717, -4.639834, 2.868154>, 
      <0.281015, -4.627310, 2.792400>, <0.250985, -4.651658, 2.816072>, <0.206506, -4.680664, 2.824156>, <0.164060, -4.690084, 2.836985>, 
      <0.259895, -4.671432, 2.696682>, <0.238430, -4.698560, 2.703213>, <0.189018, -4.743021, 2.735316>, <0.160910, -4.762571, 2.743502>, 
      <0.211281, -4.659176, 2.665759>, <0.189816, -4.686304, 2.672290>, <0.158708, -4.719786, 2.686468>, <0.130599, -4.739336, 2.694654>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.453544, -4.420255, 2.654672>, <0.460976, -4.489068, 2.696289>, <0.366391, -4.540302, 2.773683>, <0.312890, -4.583679, 2.815855>, 
      <0.417475, -4.460876, 2.657998>, <0.424907, -4.529689, 2.699615>, <0.334516, -4.583933, 2.750227>, <0.281015, -4.627310, 2.792400>, 
      <0.357570, -4.523238, 2.645139>, <0.371637, -4.570613, 2.654364>, <0.290548, -4.632693, 2.687355>, <0.259895, -4.671432, 2.696682>, 
      <0.303270, -4.521114, 2.642117>, <0.317337, -4.568489, 2.651342>, <0.241934, -4.620436, 2.656432>, <0.211281, -4.659176, 2.665759>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.268773, -4.175205, 2.568817>, <0.324204, -4.248720, 2.594573>, <0.444746, -4.338794, 2.605406>, <0.453544, -4.420255, 2.654672>, 
      <0.217585, -4.206090, 2.575640>, <0.273017, -4.279605, 2.601397>, <0.408677, -4.379416, 2.608732>, <0.417475, -4.460876, 2.657998>, 
      <0.149335, -4.247269, 2.584738>, <0.210872, -4.320157, 2.599905>, <0.330544, -4.432216, 2.627414>, <0.357570, -4.523238, 2.645139>, 
      <0.098147, -4.278154, 2.591562>, <0.159684, -4.351042, 2.606729>, <0.276244, -4.430092, 2.624392>, <0.303270, -4.521114, 2.642117>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.415440, -4.342491, 2.584673>, <0.365692, -4.386194, 2.594930>, <0.301957, -4.487761, 2.620849>, <0.236804, -4.472810, 2.616211>, 
      <0.430451, -4.408850, 2.579725>, <0.380703, -4.452553, 2.589982>, <0.318045, -4.543429, 2.627207>, <0.252892, -4.528478, 2.622569>, 
      <0.406499, -4.514361, 2.553885>, <0.377967, -4.563212, 2.577391>, <0.289092, -4.656301, 2.628432>, <0.242640, -4.616412, 2.630441>, 
      <0.355186, -4.557217, 2.540335>, <0.326654, -4.606068, 2.563841>, <0.256179, -4.704131, 2.633652>, <0.209727, -4.664242, 2.635661>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.415440, -4.342491, 2.584673>, <0.400716, -4.277400, 2.589526>, <0.312773, -4.225391, 2.573574>, <0.268773, -4.175205, 2.568817>, 
      <0.365692, -4.386194, 2.594930>, <0.350969, -4.321103, 2.599783>, <0.261585, -4.256276, 2.580397>, <0.217585, -4.206090, 2.575640>, 
      <0.301957, -4.487761, 2.620849>, <0.282065, -4.418930, 2.612987>, <0.190932, -4.305666, 2.592133>, <0.149335, -4.247269, 2.584738>, 
      <0.236804, -4.472810, 2.616211>, <0.216912, -4.403979, 2.608349>, <0.139744, -4.336551, 2.598957>, <0.098147, -4.278154, 2.591562>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.509025, -3.413928, 3.109541>, <0.526543, -3.402253, 3.022154>, <0.544385, -3.430490, 2.953879>, <0.549256, -3.499755, 2.896798>, 
      <0.552033, -3.403883, 3.121716>, <0.569550, -3.392208, 3.034330>, <0.587392, -3.428618, 2.967203>, <0.592264, -3.497883, 2.910121>, 
      <0.620373, -3.412694, 3.144290>, <0.638494, -3.400617, 3.053891>, <0.644210, -3.430138, 2.996798>, <0.648998, -3.504830, 2.941622>, 
      <0.652384, -3.380444, 3.150125>, <0.670506, -3.368368, 3.059726>, <0.687827, -3.418822, 2.996386>, <0.692615, -3.493514, 2.941210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.475964, -3.548600, 3.262415>, <0.487355, -3.490018, 3.245909>, <0.493501, -3.424274, 3.186982>, <0.509025, -3.413928, 3.109541>, 
      <0.518971, -3.546728, 3.275738>, <0.530362, -3.488146, 3.259232>, <0.536509, -3.414229, 3.199158>, <0.552033, -3.403883, 3.121716>, 
      <0.581840, -3.548344, 3.282538>, <0.593613, -3.483407, 3.264862>, <0.603243, -3.424109, 3.229738>, <0.620373, -3.412694, 3.144290>, 
      <0.619322, -3.542358, 3.306827>, <0.631095, -3.477421, 3.289151>, <0.635255, -3.391859, 3.235574>, <0.652384, -3.380444, 3.150125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.435973, -3.789623, 3.215399>, <0.445072, -3.715757, 3.276072>, <0.462233, -3.619217, 3.282312>, <0.475964, -3.548600, 3.262415>, 
      <0.478981, -3.787750, 3.228721>, <0.488079, -3.713884, 3.289394>, <0.505240, -3.617344, 3.295636>, <0.518971, -3.546728, 3.275738>, 
      <0.540426, -3.772548, 3.239817>, <0.543330, -3.698382, 3.300736>, <0.568979, -3.619286, 3.301849>, <0.581840, -3.548344, 3.282538>, 
      <0.579332, -3.783381, 3.259807>, <0.582236, -3.709215, 3.320726>, <0.606460, -3.613300, 3.326138>, <0.619322, -3.542358, 3.306827>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.438267, -3.854645, 3.011033>, <0.429741, -3.863400, 3.042001>, <0.428130, -3.853298, 3.163098>, <0.435973, -3.789623, 3.215399>, 
      <0.488988, -3.852772, 3.024357>, <0.480462, -3.861528, 3.055326>, <0.471138, -3.851425, 3.176420>, <0.478981, -3.787750, 3.228721>, 
      <0.564513, -3.818680, 3.061476>, <0.555915, -3.827509, 3.092704>, <0.537901, -3.837019, 3.186862>, <0.540426, -3.772548, 3.239817>, 
      <0.607337, -3.848403, 3.055447>, <0.598739, -3.857231, 3.086676>, <0.576807, -3.847852, 3.206852>, <0.579332, -3.783381, 3.259807>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.528748, -3.694361, 2.878434>, <0.503768, -3.774235, 2.904145>, <0.447285, -3.845385, 2.978278>, <0.438267, -3.854645, 3.011033>, 
      <0.571756, -3.692489, 2.891757>, <0.546776, -3.772363, 2.917467>, <0.498006, -3.843512, 2.991602>, <0.488988, -3.852772, 3.024357>, 
      <0.627825, -3.680182, 2.925438>, <0.609075, -3.758209, 2.950554>, <0.573175, -3.809786, 3.030016>, <0.564513, -3.818680, 3.061476>, 
      <0.672107, -3.688120, 2.922843>, <0.653358, -3.766146, 2.947959>, <0.615999, -3.839509, 3.023988>, <0.607337, -3.848403, 3.055447>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.528748, -3.694361, 2.878434>, <0.571756, -3.692489, 2.891757>, <0.627825, -3.680182, 2.925438>, <0.672107, -3.688120, 2.922843>, 
      <0.550391, -3.625157, 2.856158>, <0.593399, -3.623285, 2.869481>, <0.644738, -3.609795, 2.902781>, <0.689021, -3.617733, 2.900186>, 
      <0.553367, -3.558206, 2.848628>, <0.596375, -3.556334, 2.861952>, <0.652904, -3.565761, 2.896612>, <0.696521, -3.554445, 2.896200>, 
      <0.549256, -3.499755, 2.896798>, <0.592264, -3.497883, 2.910121>, <0.648998, -3.504830, 2.941622>, <0.692615, -3.493514, 2.941210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.664608, -3.257187, 3.137900>, <0.662497, -3.294394, 3.140222>, <0.678474, -3.354159, 3.154881>, <0.652384, -3.380444, 3.150125>, 
      <0.676111, -3.248008, 3.075042>, <0.674000, -3.285214, 3.077365>, <0.696596, -3.342083, 3.064481>, <0.670506, -3.368368, 3.059726>, 
      <0.729099, -3.343335, 2.956000>, <0.719021, -3.340880, 2.977899>, <0.711280, -3.412737, 2.996164>, <0.687827, -3.418822, 2.996386>, 
      <0.742258, -3.449682, 2.894974>, <0.732181, -3.447228, 2.916872>, <0.716068, -3.487429, 2.940988>, <0.692615, -3.493514, 2.941210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.653916, -3.520181, 3.377731>, <0.666771, -3.527227, 3.357994>, <0.639771, -3.539092, 3.320078>, <0.619322, -3.542358, 3.306827>, 
      <0.663059, -3.417938, 3.348154>, <0.675914, -3.424984, 3.328418>, <0.651544, -3.474156, 3.302402>, <0.631095, -3.477421, 3.289151>, 
      <0.651789, -3.267417, 3.207950>, <0.649679, -3.304624, 3.210273>, <0.661345, -3.365574, 3.240329>, <0.635255, -3.391859, 3.235574>, 
      <0.664608, -3.257187, 3.137900>, <0.662497, -3.294394, 3.140222>, <0.678474, -3.354159, 3.154881>, <0.652384, -3.380444, 3.150125>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.612598, -3.838801, 3.306150>, <0.623958, -3.834439, 3.285626>, <0.599932, -3.789117, 3.270392>, <0.579332, -3.783381, 3.259807>, 
      <0.627667, -3.744509, 3.389938>, <0.639027, -3.740147, 3.369414>, <0.602837, -3.714950, 3.331311>, <0.582236, -3.709215, 3.320726>, 
      <0.645464, -3.614693, 3.405072>, <0.658319, -3.621739, 3.385335>, <0.626910, -3.610035, 3.339389>, <0.606460, -3.613300, 3.326138>, 
      <0.653916, -3.520181, 3.377731>, <0.666771, -3.527227, 3.357994>, <0.639771, -3.539092, 3.320078>, <0.619322, -3.542358, 3.306827>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.584269, -3.955981, 2.990479>, <0.588712, -3.920573, 3.004474>, <0.638619, -3.870115, 3.051043>, <0.607337, -3.848403, 3.055447>, 
      <0.571837, -3.968324, 3.039920>, <0.576280, -3.932916, 3.053915>, <0.630021, -3.878943, 3.082272>, <0.598739, -3.857231, 3.086676>, 
      <0.597129, -3.935598, 3.220137>, <0.608488, -3.931235, 3.199613>, <0.597408, -3.853587, 3.217437>, <0.576807, -3.847852, 3.206852>, 
      <0.612598, -3.838801, 3.306150>, <0.623958, -3.834439, 3.285626>, <0.599932, -3.789117, 3.270392>, <0.579332, -3.783381, 3.259807>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.723013, -3.729182, 2.867050>, <0.715089, -3.721378, 2.890319>, <0.697450, -3.692662, 2.921358>, <0.672107, -3.688120, 2.922843>, 
      <0.689848, -3.835465, 2.887099>, <0.681924, -3.827661, 2.910367>, <0.678701, -3.770689, 2.946474>, <0.653358, -3.766146, 2.947959>, 
      <0.595054, -3.945274, 2.947591>, <0.599497, -3.909866, 2.961586>, <0.647280, -3.861221, 3.019584>, <0.615999, -3.839509, 3.023988>, 
      <0.584269, -3.955981, 2.990479>, <0.588712, -3.920573, 3.004474>, <0.638619, -3.870115, 3.051043>, <0.607337, -3.848403, 3.055447>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.723013, -3.729182, 2.867050>, <0.754869, -3.627096, 2.847793>, <0.753853, -3.543390, 2.841201>, <0.742258, -3.449682, 2.894974>, 
      <0.715089, -3.721378, 2.890319>, <0.746945, -3.619292, 2.871062>, <0.743776, -3.540935, 2.863099>, <0.732181, -3.447228, 2.916872>, 
      <0.697450, -3.692662, 2.921358>, <0.714364, -3.622275, 2.898700>, <0.719974, -3.548360, 2.895978>, <0.716068, -3.487429, 2.940988>, 
      <0.672107, -3.688120, 2.922843>, <0.689021, -3.617733, 2.900186>, <0.696521, -3.554445, 2.896200>, <0.692615, -3.493514, 2.941210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.230157, -3.112834, 3.162863>, <0.361376, -3.115933, 3.160234>, <0.564224, -3.123882, 3.216211>, <0.665871, -3.142699, 3.135287>, 
      <0.226783, -2.900646, 3.061385>, <0.358001, -2.903745, 3.058756>, <0.557049, -2.934418, 3.083496>, <0.658696, -2.953235, 3.002572>, 
      <0.194403, -2.651720, 2.862312>, <0.323056, -2.656333, 2.837123>, <0.487040, -2.666037, 2.817195>, <0.603270, -2.721953, 2.793291>, 
      <0.214099, -2.469661, 2.714665>, <0.342752, -2.474274, 2.689476>, <0.521594, -2.493957, 2.666345>, <0.637823, -2.549873, 2.642441>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.230157, -3.112834, 3.162863>, <0.226783, -2.900646, 3.061385>, <0.194403, -2.651720, 2.862312>, <0.214099, -2.469661, 2.714665>, 
      <0.162102, -3.111227, 3.164227>, <0.158728, -2.899039, 3.062749>, <0.126244, -2.649276, 2.875656>, <0.145940, -2.467217, 2.728010>, 
      <0.072186, -3.127070, 3.148546>, <0.070668, -2.926269, 3.076906>, <0.067797, -2.698127, 2.895047>, <0.065564, -2.526860, 2.768089>, 
      <0.004099, -3.127070, 3.148546>, <0.002581, -2.926269, 3.076906>, <-0.001699, -2.698127, 2.895047>, <-0.003932, -2.526860, 2.768089>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.767415, -3.511733, 2.778667>, <0.752860, -3.380494, 2.863491>, <0.696334, -3.253409, 3.028301>, <0.665871, -3.142699, 3.135287>, 
      <0.758626, -3.508800, 2.817847>, <0.744071, -3.377561, 2.902672>, <0.697399, -3.281536, 3.048003>, <0.666936, -3.170826, 3.154989>, 
      <0.759002, -3.453760, 2.858588>, <0.745843, -3.347413, 2.919614>, <0.678053, -3.213772, 3.072906>, <0.666550, -3.222951, 3.135763>, 
      <0.742258, -3.449682, 2.894974>, <0.729099, -3.343335, 2.956000>, <0.676111, -3.248008, 3.075042>, <0.664608, -3.257187, 3.137900>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.547373, -3.502923, 3.417293>, <0.579874, -3.500791, 3.428627>, <0.635884, -3.510298, 3.405416>, <0.653916, -3.520181, 3.377731>, 
      <0.576168, -3.371855, 3.371558>, <0.608669, -3.369723, 3.382892>, <0.645027, -3.408055, 3.375840>, <0.663059, -3.417938, 3.348154>, 
      <0.630322, -3.250766, 3.219889>, <0.631387, -3.278893, 3.239591>, <0.653731, -3.233181, 3.205814>, <0.651789, -3.267417, 3.207950>, 
      <0.665871, -3.142699, 3.135287>, <0.666936, -3.170826, 3.154989>, <0.666550, -3.222951, 3.135763>, <0.664608, -3.257187, 3.137900>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.520121, -3.806117, 3.366784>, <0.524118, -3.945124, 3.265089>, <0.552679, -4.062769, 3.059108>, <0.566633, -4.172763, 2.927246>, 
      <0.552669, -3.803718, 3.378254>, <0.556666, -3.942724, 3.276559>, <0.578807, -4.002336, 3.075920>, <0.592760, -4.112330, 2.944058>, 
      <0.596128, -3.845125, 3.335907>, <0.580659, -3.941922, 3.249893>, <0.563960, -4.031092, 3.015111>, <0.576392, -4.018749, 2.965670>, 
      <0.612598, -3.838801, 3.306150>, <0.597129, -3.935598, 3.220137>, <0.571837, -3.968324, 3.039920>, <0.584269, -3.955981, 2.990479>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.520121, -3.806117, 3.366784>, <0.552669, -3.803718, 3.378254>, <0.596128, -3.845125, 3.335907>, <0.612598, -3.838801, 3.306150>, 
      <0.517973, -3.731423, 3.421429>, <0.550522, -3.729024, 3.432899>, <0.611197, -3.750833, 3.419694>, <0.627667, -3.744509, 3.389938>, 
      <0.528571, -3.588506, 3.447157>, <0.561071, -3.586374, 3.458491>, <0.627432, -3.604810, 3.432757>, <0.645464, -3.614693, 3.405072>, 
      <0.547373, -3.502923, 3.417293>, <0.579874, -3.500791, 3.428627>, <0.635884, -3.510298, 3.405416>, <0.653916, -3.520181, 3.377731>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.733015, -3.748108, 2.743991>, <0.737522, -3.739932, 2.780282>, <0.734526, -3.740522, 2.833241>, <0.723013, -3.729182, 2.867050>, 
      <0.691117, -3.886047, 2.774995>, <0.695624, -3.877871, 2.811286>, <0.701361, -3.846805, 2.853290>, <0.689848, -3.835465, 2.887099>, 
      <0.616548, -4.045366, 2.872270>, <0.642675, -3.984934, 2.889082>, <0.587177, -4.008042, 2.922782>, <0.595054, -3.945274, 2.947591>, 
      <0.566633, -4.172763, 2.927246>, <0.592760, -4.112330, 2.944058>, <0.576392, -4.018749, 2.965670>, <0.584269, -3.955981, 2.990479>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.733015, -3.748108, 2.743991>, <0.753589, -3.680372, 2.728766>, <0.774131, -3.572285, 2.739530>, <0.767415, -3.511733, 2.778667>, 
      <0.737522, -3.739932, 2.780282>, <0.758096, -3.672196, 2.765057>, <0.765342, -3.569352, 2.778711>, <0.758626, -3.508800, 2.817847>, 
      <0.734526, -3.740522, 2.833241>, <0.766382, -3.638436, 2.813985>, <0.770598, -3.547468, 2.804815>, <0.759002, -3.453760, 2.858588>, 
      <0.723013, -3.729182, 2.867050>, <0.754869, -3.627096, 2.847793>, <0.753853, -3.543390, 2.841201>, <0.742258, -3.449682, 2.894974>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.078641, -3.041055, 2.384412>, <1.076430, -3.078018, 2.321588>, <1.062845, -3.053102, 2.190841>, <1.010069, -3.089742, 2.156341>, 
      <1.182804, -2.852259, 2.212912>, <1.180594, -2.889222, 2.150088>, <1.162496, -2.902842, 2.036209>, <1.109720, -2.939482, 2.001709>, 
      <1.353501, -2.665262, 1.915924>, <1.354520, -2.706414, 1.878871>, <1.326833, -2.736126, 1.800941>, <1.291692, -2.767939, 1.772297>, 
      <1.354952, -2.481547, 1.710612>, <1.355970, -2.522699, 1.673559>, <1.330683, -2.579631, 1.622297>, <1.295542, -2.611444, 1.593652>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.078641, -3.041055, 2.384412>, <1.182804, -2.852259, 2.212912>, <1.353501, -2.665262, 1.915924>, <1.354952, -2.481547, 1.710612>, 
      <1.080921, -3.002928, 2.449214>, <1.185084, -2.814131, 2.277713>, <1.351739, -2.594043, 1.980050>, <1.353189, -2.410328, 1.774738>, 
      <1.070647, -2.911363, 2.520742>, <1.152486, -2.698171, 2.368814>, <1.341184, -2.502454, 2.060245>, <1.342599, -2.307412, 1.867404>, 
      <1.023855, -2.859225, 2.548132>, <1.105694, -2.646032, 2.396203>, <1.285171, -2.444651, 2.112291>, <1.286587, -2.249609, 1.919450>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.907111, -3.238154, 2.623922>, <0.947773, -3.124799, 2.611130>, <0.987720, -2.953357, 2.615214>, <1.023855, -2.859225, 2.548132>, 
      <0.852075, -3.200314, 2.782451>, <0.892737, -3.086959, 2.769659>, <0.893738, -2.848637, 2.670225>, <0.929873, -2.754505, 2.603144>, 
      <0.799063, -3.167356, 3.029249>, <0.791889, -2.977892, 2.896534>, <0.737134, -2.786354, 2.765761>, <0.771688, -2.614274, 2.614911>, 
      <0.665871, -3.142699, 3.135287>, <0.658696, -2.953235, 3.002572>, <0.603270, -2.721953, 2.793291>, <0.637823, -2.549873, 2.642441>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.900990, -3.304355, 2.458041>, <0.951233, -3.221904, 2.442382>, <1.041660, -3.108083, 2.445300>, <1.078641, -3.041055, 2.384412>, 
      <0.918738, -3.284707, 2.504659>, <0.968981, -3.202256, 2.489001>, <1.043940, -3.069956, 2.510101>, <1.080921, -3.002928, 2.449214>, 
      <0.924263, -3.249947, 2.574516>, <0.964926, -3.136592, 2.561723>, <1.034512, -3.005495, 2.587824>, <1.070647, -2.911363, 2.520742>, 
      <0.907111, -3.238154, 2.623922>, <0.947773, -3.124799, 2.611130>, <0.987720, -2.953357, 2.615214>, <1.023855, -2.859225, 2.548132>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.804793, -3.351425, 2.355160>, <0.736855, -3.366024, 2.298270>, <0.651608, -3.372916, 2.202239>, <0.565469, -3.376452, 2.177082>, 
      <0.863759, -3.263388, 2.307352>, <0.795821, -3.277987, 2.250462>, <0.672924, -3.336812, 2.187841>, <0.586785, -3.340348, 2.162684>, 
      <0.961300, -3.163279, 2.232018>, <0.876495, -3.222155, 2.176580>, <0.785680, -3.305720, 2.169969>, <0.672273, -3.334524, 2.163594>, 
      <1.010069, -3.089742, 2.156341>, <0.925264, -3.148618, 2.100904>, <0.802841, -3.282458, 2.136360>, <0.689434, -3.311262, 2.129985>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.804793, -3.351425, 2.355160>, <0.863759, -3.263388, 2.307352>, <0.961300, -3.163279, 2.232018>, <1.010069, -3.089742, 2.156341>, 
      <0.838496, -3.344183, 2.383382>, <0.897462, -3.256146, 2.335574>, <1.014076, -3.126639, 2.266517>, <1.062845, -3.053102, 2.190841>, 
      <0.886242, -3.320682, 2.419301>, <0.936485, -3.238231, 2.403642>, <1.039449, -3.145047, 2.382476>, <1.076430, -3.078018, 2.321588>, 
      <0.900990, -3.304355, 2.458041>, <0.951233, -3.221904, 2.442382>, <1.041660, -3.108083, 2.445300>, <1.078641, -3.041055, 2.384412>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.231246, -3.547909, 3.230331>, <0.329649, -3.532272, 3.279267>, <0.442758, -3.509786, 3.380810>, <0.547373, -3.502923, 3.417293>, 
      <0.232975, -3.415840, 3.229451>, <0.331378, -3.400204, 3.278387>, <0.471553, -3.378718, 3.335075>, <0.576168, -3.371855, 3.371558>, 
      <0.232052, -3.231979, 3.219843>, <0.363271, -3.235078, 3.217214>, <0.528675, -3.231949, 3.300813>, <0.630322, -3.250766, 3.219889>, 
      <0.230157, -3.112834, 3.162863>, <0.361376, -3.115933, 3.160234>, <0.564224, -3.123882, 3.216211>, <0.665871, -3.142699, 3.135287>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.231246, -3.547909, 3.230331>, <0.232975, -3.415840, 3.229451>, <0.232052, -3.231979, 3.219843>, <0.230157, -3.112834, 3.162863>, 
      <0.165980, -3.558280, 3.197874>, <0.167710, -3.426212, 3.196993>, <0.163997, -3.230372, 3.221207>, <0.162102, -3.111227, 3.164227>, 
      <0.077724, -3.589254, 3.147118>, <0.077724, -3.451241, 3.160456>, <0.073174, -3.257660, 3.195137>, <0.072186, -3.127070, 3.148546>, 
      <0.004099, -3.589254, 3.147118>, <0.004099, -3.451241, 3.160456>, <0.005086, -3.257660, 3.195137>, <0.004099, -3.127070, 3.148546>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.804588, -3.470482, 2.617113>, <0.832538, -3.399812, 2.622823>, <0.881523, -3.309487, 2.631972>, <0.907111, -3.238154, 2.623922>, 
      <0.801795, -3.468294, 2.668239>, <0.829745, -3.397624, 2.673949>, <0.826486, -3.271647, 2.790501>, <0.852075, -3.200314, 2.782451>, 
      <0.778603, -3.515466, 2.728793>, <0.764047, -3.384227, 2.813618>, <0.829527, -3.278066, 2.922263>, <0.799063, -3.167356, 3.029249>, 
      <0.767415, -3.511733, 2.778667>, <0.752860, -3.380494, 2.863491>, <0.696334, -3.253409, 3.028301>, <0.665871, -3.142699, 3.135287>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.783937, -3.524679, 2.476261>, <0.824660, -3.462256, 2.467489>, <0.862443, -3.367613, 2.470055>, <0.900990, -3.304355, 2.458041>, 
      <0.801212, -3.512601, 2.516807>, <0.841935, -3.450179, 2.508035>, <0.880190, -3.347965, 2.516673>, <0.918738, -3.284707, 2.504659>, 
      <0.807079, -3.472434, 2.571525>, <0.835029, -3.401764, 2.577235>, <0.898675, -3.321280, 2.582566>, <0.924263, -3.249947, 2.574516>, 
      <0.804588, -3.470482, 2.617113>, <0.832538, -3.399812, 2.622823>, <0.881523, -3.309487, 2.631972>, <0.907111, -3.238154, 2.623922>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.711430, -3.535612, 2.398469>, <0.733251, -3.478317, 2.382731>, <0.772685, -3.399362, 2.381192>, <0.804793, -3.351425, 2.355160>, 
      <0.733702, -3.532400, 2.421321>, <0.755522, -3.475105, 2.405583>, <0.806388, -3.392120, 2.409414>, <0.838496, -3.344183, 2.383382>, 
      <0.771813, -3.533155, 2.447805>, <0.812536, -3.470733, 2.439034>, <0.847694, -3.383940, 2.431315>, <0.886242, -3.320682, 2.419301>, 
      <0.783937, -3.524679, 2.476261>, <0.824660, -3.462256, 2.467489>, <0.862443, -3.367613, 2.470055>, <0.900990, -3.304355, 2.458041>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.711430, -3.535612, 2.398469>, <0.661385, -3.542829, 2.347121>, <0.611502, -3.556361, 2.250835>, <0.542909, -3.559436, 2.228954>, 
      <0.733251, -3.478317, 2.382731>, <0.683206, -3.485534, 2.331382>, <0.618189, -3.501277, 2.235920>, <0.549596, -3.504352, 2.214039>, 
      <0.772685, -3.399362, 2.381192>, <0.704747, -3.413961, 2.324301>, <0.623979, -3.419712, 2.220900>, <0.537840, -3.423248, 2.195744>, 
      <0.804793, -3.351425, 2.355160>, <0.736855, -3.366024, 2.298270>, <0.651608, -3.372916, 2.202239>, <0.565469, -3.376452, 2.177082>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.220272, -3.867719, 3.167894>, <0.314837, -3.853553, 3.221282>, <0.417081, -3.813712, 3.330472>, <0.520121, -3.806117, 3.366784>, 
      <0.204323, -3.775206, 3.195348>, <0.298888, -3.761040, 3.248736>, <0.414933, -3.739018, 3.385118>, <0.517973, -3.731423, 3.421429>, 
      <0.229965, -3.645708, 3.230983>, <0.328368, -3.630072, 3.279919>, <0.423956, -3.595369, 3.410674>, <0.528571, -3.588506, 3.447157>, 
      <0.231246, -3.547909, 3.230331>, <0.329649, -3.532272, 3.279267>, <0.442758, -3.509786, 3.380810>, <0.547373, -3.502923, 3.417293>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.220272, -3.867719, 3.167894>, <0.204323, -3.775206, 3.195348>, <0.229965, -3.645708, 3.230983>, <0.231246, -3.547909, 3.230331>, 
      <0.159232, -3.876862, 3.133433>, <0.143283, -3.784350, 3.160886>, <0.164700, -3.656080, 3.198525>, <0.165980, -3.558280, 3.197874>, 
      <0.074789, -3.883416, 3.075453>, <0.074826, -3.794214, 3.092570>, <0.077724, -3.679662, 3.138381>, <0.077724, -3.589254, 3.147118>, 
      <0.004099, -3.883416, 3.075453>, <0.004136, -3.794214, 3.092570>, <0.004099, -3.679662, 3.138381>, <0.004099, -3.589254, 3.147118>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.687242, -3.794073, 2.579007>, <0.712793, -3.693373, 2.579791>, <0.766485, -3.566823, 2.609329>, <0.804588, -3.470482, 2.617113>, 
      <0.700962, -3.811338, 2.627403>, <0.726513, -3.710638, 2.628187>, <0.763691, -3.564634, 2.660455>, <0.801795, -3.468294, 2.668239>, 
      <0.726619, -3.759712, 2.692484>, <0.747193, -3.691975, 2.677259>, <0.785318, -3.576018, 2.689657>, <0.778603, -3.515466, 2.728793>, 
      <0.733015, -3.748108, 2.743991>, <0.753589, -3.680372, 2.728766>, <0.774131, -3.572285, 2.739530>, <0.767415, -3.511733, 2.778667>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.666283, -3.664130, 2.508596>, <0.703455, -3.623276, 2.502325>, <0.753772, -3.570917, 2.482758>, <0.783937, -3.524679, 2.476261>, 
      <0.691781, -3.645482, 2.540337>, <0.728953, -3.604628, 2.534066>, <0.771048, -3.558840, 2.523304>, <0.801212, -3.512601, 2.516807>, 
      <0.675690, -3.779535, 2.538257>, <0.701241, -3.678835, 2.539041>, <0.768976, -3.568774, 2.563741>, <0.807079, -3.472434, 2.571525>, 
      <0.687242, -3.794073, 2.579007>, <0.712793, -3.693373, 2.579791>, <0.766485, -3.566823, 2.609329>, <0.804588, -3.470482, 2.617113>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.616512, -3.845801, 2.490960>, <0.635014, -3.748868, 2.468554>, <0.676545, -3.627211, 2.423630>, <0.711430, -3.535612, 2.398469>, 
      <0.644326, -3.810016, 2.525123>, <0.662828, -3.713083, 2.502717>, <0.698817, -3.623999, 2.446482>, <0.733702, -3.532400, 2.421321>, 
      <0.633966, -3.687765, 2.468367>, <0.671138, -3.646911, 2.462096>, <0.741648, -3.579394, 2.454303>, <0.771813, -3.533155, 2.447805>, 
      <0.666283, -3.664130, 2.508596>, <0.703455, -3.623276, 2.502325>, <0.753772, -3.570917, 2.482758>, <0.783937, -3.524679, 2.476261>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.616512, -3.845801, 2.490960>, <0.585200, -3.886086, 2.452500>, <0.564720, -3.867779, 2.334579>, <0.505422, -3.871091, 2.311014>, 
      <0.635014, -3.748868, 2.468554>, <0.603702, -3.789154, 2.430094>, <0.572328, -3.774336, 2.308413>, <0.513030, -3.777648, 2.284848>, 
      <0.676545, -3.627211, 2.423630>, <0.626501, -3.634427, 2.372282>, <0.600174, -3.649674, 2.276101>, <0.531581, -3.652750, 2.254220>, 
      <0.711430, -3.535612, 2.398469>, <0.661385, -3.542829, 2.347121>, <0.611502, -3.556361, 2.250835>, <0.542909, -3.559436, 2.228954>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.339601, -4.176421, 3.043817>, <0.332537, -4.321650, 2.987438>, <0.229641, -4.513451, 2.946547>, <0.182717, -4.639834, 2.868154>, 
      <0.414677, -4.168669, 3.030910>, <0.407613, -4.313898, 2.974531>, <0.272087, -4.504031, 2.933717>, <0.225163, -4.630414, 2.855325>, 
      <0.523772, -4.176493, 2.990588>, <0.466602, -4.308728, 2.953800>, <0.363318, -4.497894, 2.898732>, <0.282859, -4.608027, 2.839527>, 
      <0.566633, -4.172763, 2.927246>, <0.509462, -4.304998, 2.890458>, <0.393348, -4.473546, 2.875061>, <0.312890, -4.583679, 2.815855>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.339601, -4.176421, 3.043817>, <0.414677, -4.168669, 3.030910>, <0.523772, -4.176493, 2.990588>, <0.566633, -4.172763, 2.927246>, 
      <0.344404, -4.077673, 3.082152>, <0.419480, -4.069920, 3.069245>, <0.509819, -4.066499, 3.122449>, <0.552679, -4.062769, 3.059108>, 
      <0.237563, -3.968014, 3.138131>, <0.332128, -3.953848, 3.191519>, <0.421077, -3.952719, 3.228777>, <0.524118, -3.945124, 3.265089>, 
      <0.220272, -3.867719, 3.167894>, <0.314837, -3.853553, 3.221282>, <0.417081, -3.813712, 3.330472>, <0.520121, -3.806117, 3.366784>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.339601, -4.176421, 3.043817>, <0.344404, -4.077673, 3.082152>, <0.237563, -3.968014, 3.138131>, <0.220272, -3.867719, 3.167894>, 
      <0.239376, -4.186770, 3.061047>, <0.244179, -4.088022, 3.099382>, <0.176523, -3.977157, 3.103670>, <0.159232, -3.876862, 3.133433>, 
      <0.106051, -4.230879, 3.024001>, <0.106206, -4.127874, 3.046224>, <0.074745, -3.986904, 3.055596>, <0.074789, -3.883416, 3.075453>, 
      <0.003831, -4.230879, 3.024001>, <0.003985, -4.127874, 3.046224>, <0.004056, -3.986904, 3.055596>, <0.004099, -3.883416, 3.075453>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.339601, -4.176421, 3.043817>, <0.239376, -4.186770, 3.061047>, <0.106051, -4.230879, 3.024001>, <0.003831, -4.230879, 3.024001>, 
      <0.332537, -4.321650, 2.987438>, <0.232313, -4.331999, 3.004668>, <0.105859, -4.358987, 2.996362>, <0.003639, -4.358987, 2.996362>, 
      <0.229641, -4.513451, 2.946547>, <0.177702, -4.524979, 2.962245>, <0.058541, -4.536167, 2.969946>, <0.003070, -4.536167, 2.969946>, 
      <0.182717, -4.639834, 2.868154>, <0.130778, -4.651362, 2.883852>, <0.058418, -4.652468, 2.909533>, <0.002947, -4.652468, 2.909533>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.631919, -4.150984, 2.611812>, <0.662679, -4.199395, 2.689859>, <0.620848, -4.168045, 2.847124>, <0.566633, -4.172763, 2.927246>, 
      <0.597958, -4.241980, 2.622808>, <0.628718, -4.290392, 2.700855>, <0.563678, -4.300280, 2.810336>, <0.509462, -4.304998, 2.890458>, 
      <0.518323, -4.347300, 2.648699>, <0.525755, -4.416112, 2.690315>, <0.446849, -4.430169, 2.832888>, <0.393348, -4.473546, 2.875061>, 
      <0.453544, -4.420255, 2.654672>, <0.460976, -4.489068, 2.696289>, <0.366391, -4.540302, 2.773683>, <0.312890, -4.583679, 2.815855>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.631919, -4.150984, 2.611812>, <0.669719, -4.049700, 2.599573>, <0.660485, -3.899526, 2.578186>, <0.687242, -3.794073, 2.579007>, 
      <0.662679, -4.199395, 2.689859>, <0.700479, -4.098112, 2.677620>, <0.674204, -3.916792, 2.626581>, <0.700962, -3.811338, 2.627403>, 
      <0.620848, -4.168045, 2.847124>, <0.670763, -4.040648, 2.792147>, <0.684721, -3.897650, 2.723489>, <0.726619, -3.759712, 2.692484>, 
      <0.566633, -4.172763, 2.927246>, <0.616548, -4.045366, 2.872270>, <0.691117, -3.886047, 2.774995>, <0.733015, -3.748108, 2.743991>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.413518, -3.931785, 2.538750>, <0.479038, -3.997545, 2.560668>, <0.601627, -4.103310, 2.534953>, <0.631919, -4.150984, 2.611812>, 
      <0.370094, -4.004811, 2.547770>, <0.435615, -4.070571, 2.569689>, <0.567666, -4.194306, 2.545949>, <0.597958, -4.241980, 2.622808>, 
      <0.312196, -4.102179, 2.559797>, <0.367628, -4.175694, 2.585553>, <0.509525, -4.265839, 2.599432>, <0.518323, -4.347300, 2.648699>, 
      <0.268773, -4.175205, 2.568817>, <0.324204, -4.248720, 2.594573>, <0.444746, -4.338794, 2.605406>, <0.453544, -4.420255, 2.654672>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.413518, -3.931785, 2.538750>, <0.489347, -3.851488, 2.529704>, <0.592183, -3.745569, 2.521096>, <0.666283, -3.664130, 2.508596>, 
      <0.479038, -3.997545, 2.560668>, <0.554868, -3.917248, 2.551622>, <0.617681, -3.726921, 2.552837>, <0.691781, -3.645482, 2.540337>, 
      <0.601627, -4.103310, 2.534953>, <0.639427, -4.002026, 2.522715>, <0.648932, -3.884988, 2.537435>, <0.675690, -3.779535, 2.538257>, 
      <0.631919, -4.150984, 2.611812>, <0.669719, -4.049700, 2.599573>, <0.660485, -3.899526, 2.578186>, <0.687242, -3.794073, 2.579007>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.592125, -4.160662, 2.542952>, <0.563633, -4.231044, 2.556231>, <0.472668, -4.292217, 2.572874>, <0.415440, -4.342491, 2.584673>, 
      <0.606050, -4.204568, 2.518943>, <0.577557, -4.274950, 2.532223>, <0.487679, -4.358576, 2.567926>, <0.430451, -4.408850, 2.579725>, 
      <0.540896, -4.177784, 2.421125>, <0.515034, -4.295895, 2.460601>, <0.465738, -4.412938, 2.505083>, <0.406499, -4.514361, 2.553885>, 
      <0.492352, -4.180356, 2.402825>, <0.466490, -4.298467, 2.442301>, <0.414424, -4.455795, 2.491533>, <0.355186, -4.557217, 2.540335>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.592125, -4.160662, 2.542952>, <0.606050, -4.204568, 2.518943>, <0.540896, -4.177784, 2.421125>, <0.492352, -4.180356, 2.402825>, 
      <0.627616, -4.072992, 2.526411>, <0.641540, -4.116898, 2.502402>, <0.560591, -4.087837, 2.391062>, <0.512047, -4.090409, 2.372763>, 
      <0.598957, -3.937774, 2.512220>, <0.567645, -3.978059, 2.473760>, <0.557148, -3.960767, 2.360618>, <0.497851, -3.964079, 2.337053>, 
      <0.616512, -3.845801, 2.490960>, <0.585200, -3.886086, 2.452500>, <0.564720, -3.867779, 2.334579>, <0.505422, -3.871091, 2.311014>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.592125, -4.160662, 2.542952>, <0.627616, -4.072992, 2.526411>, <0.598957, -3.937774, 2.512220>, <0.616512, -3.845801, 2.490960>, 
      <0.568774, -4.087035, 2.583214>, <0.604265, -3.999365, 2.566672>, <0.626771, -3.901989, 2.546383>, <0.644326, -3.810016, 2.525123>, 
      <0.467100, -4.000448, 2.540010>, <0.542930, -3.920152, 2.530964>, <0.559866, -3.769204, 2.480868>, <0.633966, -3.687765, 2.468367>, 
      <0.413518, -3.931785, 2.538750>, <0.489347, -3.851488, 2.529704>, <0.592183, -3.745569, 2.521096>, <0.666283, -3.664130, 2.508596>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.592125, -4.160662, 2.542952>, <0.568774, -4.087035, 2.583214>, <0.467100, -4.000448, 2.540010>, <0.413518, -3.931785, 2.538750>, 
      <0.563633, -4.231044, 2.556231>, <0.540282, -4.157417, 2.596493>, <0.423677, -4.073474, 2.549031>, <0.370094, -4.004811, 2.547770>, 
      <0.472668, -4.292217, 2.572874>, <0.457944, -4.227125, 2.577727>, <0.356197, -4.152365, 2.564553>, <0.312196, -4.102179, 2.559797>, 
      <0.415440, -4.342491, 2.584673>, <0.400716, -4.277400, 2.589526>, <0.312773, -4.225391, 2.573574>, <0.268773, -4.175205, 2.568817>
    }
  }
}
#declare rana2 = union {
  object { sPatchObj4 }
  object { sPatchObj5 }
  object { ojos }
  object { sPatchObj7 }
  material {
    ranaskin_1
  }
  translate  <0.0, -0.1, -0.1>
}
#declare bote = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.801490, 3.120271, -10.033655>, <1.261876, 2.185632, -10.033655>, <0.542390, 0.939447, -10.033655>, <0.002776, 0.004808, -10.033655>, 
      <2.286041, 2.840515, -10.033655>, <1.746427, 1.905876, -10.033655>, <0.543137, 0.939016, -10.033655>, <0.003523, 0.004377, -10.033655>, 
      <2.840515, 2.286040, -10.033655>, <1.905876, 1.746426, -10.033655>, <0.939016, 0.543136, -10.033655>, <0.004377, 0.003523, -10.033655>, 
      <3.120271, 1.801488, -10.033655>, <2.185632, 1.261874, -10.033655>, <0.939447, 0.542390, -10.033655>, <0.004808, 0.002776, -10.033655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.602978, -10.033655>, <0.000000, 2.523750, -10.033655>, <0.000000, 1.084779, -10.033655>, <0.000000, 0.005551, -10.033655>, 
      <0.559512, 3.602978, -10.033655>, <0.559512, 2.523750, -10.033655>, <0.000862, 1.084779, -10.033655>, <0.000862, 0.005551, -10.033655>, 
      <1.316939, 3.400027, -10.033655>, <0.777324, 2.465388, -10.033655>, <0.541644, 0.939878, -10.033655>, <0.002029, 0.005239, -10.033655>, 
      <1.801490, 3.120271, -10.033655>, <1.261876, 2.185632, -10.033655>, <0.542390, 0.939447, -10.033655>, <0.002776, 0.004808, -10.033655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.801489, 3.120271, -10.033655>, <-1.261875, 2.185632, -10.033655>, <-0.542390, 0.939447, -10.033655>, <-0.002776, 0.004808, -10.033655>, 
      <-1.316938, 3.400026, -10.033655>, <-0.777324, 2.465388, -10.033655>, <-0.541643, 0.939878, -10.033655>, <-0.002029, 0.005239, -10.033655>, 
      <-0.559512, 3.602978, -10.033655>, <-0.559512, 2.523750, -10.033655>, <-0.000862, 1.084779, -10.033655>, <-0.000862, 0.005551, -10.033655>, 
      <0.000000, 3.602978, -10.033655>, <0.000000, 2.523750, -10.033655>, <0.000000, 1.084779, -10.033655>, <0.000000, 0.005551, -10.033655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.120270, 1.801490, -10.033655>, <-2.185631, 1.261876, -10.033655>, <-0.939447, 0.542390, -10.033655>, <-0.004808, 0.002776, -10.033655>, 
      <-2.840514, 2.286041, -10.033655>, <-1.905875, 1.746427, -10.033655>, <-0.939016, 0.543137, -10.033655>, <-0.004377, 0.003523, -10.033655>, 
      <-2.286040, 2.840515, -10.033655>, <-1.746426, 1.905876, -10.033655>, <-0.543137, 0.939016, -10.033655>, <-0.003523, 0.004377, -10.033655>, 
      <-1.801489, 3.120271, -10.033655>, <-1.261875, 2.185632, -10.033655>, <-0.542390, 0.939447, -10.033655>, <-0.002776, 0.004808, -10.033655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.602978, 0.000000, -10.033655>, <-2.523750, 0.000000, -10.033655>, <-1.084779, 0.000000, -10.033655>, <-0.005551, 0.000000, -10.033655>, 
      <-3.602978, 0.559512, -10.033655>, <-2.523750, 0.559512, -10.033655>, <-1.084779, 0.000862, -10.033655>, <-0.005551, 0.000862, -10.033655>, 
      <-3.400026, 1.316938, -10.033655>, <-2.465387, 0.777324, -10.033655>, <-0.939878, 0.541644, -10.033655>, <-0.005239, 0.002029, -10.033655>, 
      <-3.120270, 1.801490, -10.033655>, <-2.185631, 1.261876, -10.033655>, <-0.939447, 0.542390, -10.033655>, <-0.004808, 0.002776, -10.033655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.120271, -1.801489, -10.033655>, <-2.185632, -1.261875, -10.033655>, <-0.939447, -0.542390, -10.033655>, <-0.004808, -0.002776, -10.033655>, 
      <-3.400027, -1.316938, -10.033655>, <-2.465388, -0.777324, -10.033655>, <-0.939878, -0.541643, -10.033655>, <-0.005239, -0.002029, -10.033655>, 
      <-3.602978, -0.559512, -10.033655>, <-2.523750, -0.559512, -10.033655>, <-1.084779, -0.000862, -10.033655>, <-0.005551, -0.000862, -10.033655>, 
      <-3.602978, 0.000000, -10.033655>, <-2.523750, 0.000000, -10.033655>, <-1.084779, 0.000000, -10.033655>, <-0.005551, 0.000000, -10.033655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.801489, -3.120271, -10.033655>, <-1.261875, -2.185632, -10.033655>, <-0.542390, -0.939447, -10.033655>, <-0.002776, -0.004808, -10.033655>, 
      <-2.286041, -2.840515, -10.033655>, <-1.746427, -1.905876, -10.033655>, <-0.543137, -0.939016, -10.033655>, <-0.003523, -0.004377, -10.033655>, 
      <-2.840515, -2.286041, -10.033655>, <-1.905876, -1.746427, -10.033655>, <-0.939016, -0.543137, -10.033655>, <-0.004377, -0.003523, -10.033655>, 
      <-3.120271, -1.801489, -10.033655>, <-2.185632, -1.261875, -10.033655>, <-0.939447, -0.542390, -10.033655>, <-0.004808, -0.002776, -10.033655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.602978, -10.033655>, <0.000000, -2.523750, -10.033655>, <0.000000, -1.084779, -10.033655>, <0.000000, -0.005551, -10.033655>, 
      <-0.559512, -3.602978, -10.033655>, <-0.559512, -2.523750, -10.033655>, <-0.000862, -1.084779, -10.033655>, <-0.000862, -0.005551, -10.033655>, 
      <-1.316938, -3.400027, -10.033655>, <-0.777324, -2.465388, -10.033655>, <-0.541643, -0.939878, -10.033655>, <-0.002029, -0.005239, -10.033655>, 
      <-1.801489, -3.120271, -10.033655>, <-1.261875, -2.185632, -10.033655>, <-0.542390, -0.939447, -10.033655>, <-0.002776, -0.004808, -10.033655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.801489, -3.120271, -10.033655>, <1.261875, -2.185632, -10.033655>, <0.542390, -0.939447, -10.033655>, <0.002776, -0.004808, -10.033655>, 
      <1.316938, -3.400027, -10.033655>, <0.777324, -2.465388, -10.033655>, <0.541643, -0.939878, -10.033655>, <0.002029, -0.005239, -10.033655>, 
      <0.559512, -3.602978, -10.033655>, <0.559512, -2.523750, -10.033655>, <0.000862, -1.084779, -10.033655>, <0.000862, -0.005551, -10.033655>, 
      <0.000000, -3.602978, -10.033655>, <0.000000, -2.523750, -10.033655>, <0.000000, -1.084779, -10.033655>, <0.000000, -0.005551, -10.033655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.120271, -1.801489, -10.033655>, <2.185632, -1.261875, -10.033655>, <0.939447, -0.542390, -10.033655>, <0.004808, -0.002776, -10.033655>, 
      <2.840515, -2.286041, -10.033655>, <1.905876, -1.746427, -10.033655>, <0.939016, -0.543137, -10.033655>, <0.004377, -0.003523, -10.033655>, 
      <2.286041, -2.840515, -10.033655>, <1.746427, -1.905876, -10.033655>, <0.543137, -0.939016, -10.033655>, <0.003523, -0.004377, -10.033655>, 
      <1.801489, -3.120271, -10.033655>, <1.261875, -2.185632, -10.033655>, <0.542390, -0.939447, -10.033655>, <0.002776, -0.004808, -10.033655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.979133, 3.427958, -9.512637>, <1.952874, 3.382476, -9.694390>, <1.854783, 3.212577, -9.877350>, <1.801490, 3.120271, -10.033655>, 
      <2.511466, 3.120615, -9.512637>, <2.485206, 3.075133, -9.694390>, <2.339334, 2.932821, -9.877350>, <2.286041, 2.840515, -10.033655>, 
      <3.120616, 2.511464, -9.512637>, <3.075134, 2.485205, -9.694390>, <2.932821, 2.339333, -9.877350>, <2.840515, 2.286040, -10.033655>, 
      <3.427958, 1.979131, -9.512637>, <3.382476, 1.952872, -9.694390>, <3.212577, 1.854781, -9.877350>, <3.120271, 1.801488, -10.033655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000001, 3.958264, -9.512637>, <0.000001, 3.905746, -9.694390>, <0.000000, 3.709564, -9.877350>, <0.000000, 3.602978, -10.033655>, 
      <0.614686, 3.958264, -9.512637>, <0.614685, 3.905746, -9.694390>, <0.559512, 3.709564, -9.877350>, <0.559512, 3.602978, -10.033655>, 
      <1.446801, 3.735300, -9.512637>, <1.420541, 3.689818, -9.694390>, <1.370231, 3.492333, -9.877350>, <1.316939, 3.400027, -10.033655>, 
      <1.979133, 3.427958, -9.512637>, <1.952874, 3.382476, -9.694390>, <1.854783, 3.212577, -9.877350>, <1.801490, 3.120271, -10.033655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.979132, 3.427958, -9.512637>, <-1.952873, 3.382476, -9.694390>, <-1.854782, 3.212577, -9.877350>, <-1.801489, 3.120271, -10.033655>, 
      <-1.446799, 3.735300, -9.512637>, <-1.420540, 3.689818, -9.694390>, <-1.370231, 3.492333, -9.877350>, <-1.316938, 3.400026, -10.033655>, 
      <-0.614684, 3.958264, -9.512637>, <-0.614684, 3.905746, -9.694390>, <-0.559511, 3.709564, -9.877350>, <-0.559512, 3.602978, -10.033655>, 
      <0.000001, 3.958264, -9.512637>, <0.000001, 3.905746, -9.694390>, <0.000000, 3.709564, -9.877350>, <0.000000, 3.602978, -10.033655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.427957, 1.979133, -9.512637>, <-3.382475, 1.952874, -9.694390>, <-3.212576, 1.854783, -9.877350>, <-3.120270, 1.801490, -10.033655>, 
      <-3.120615, 2.511466, -9.512637>, <-3.075133, 2.485206, -9.694390>, <-2.932820, 2.339334, -9.877350>, <-2.840514, 2.286041, -10.033655>, 
      <-2.511465, 3.120616, -9.512637>, <-2.485205, 3.075134, -9.694390>, <-2.339333, 2.932822, -9.877350>, <-2.286040, 2.840515, -10.033655>, 
      <-1.979132, 3.427958, -9.512637>, <-1.952873, 3.382476, -9.694390>, <-1.854782, 3.212577, -9.877350>, <-1.801489, 3.120271, -10.033655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.958264, 0.000000, -9.512637>, <-3.905746, 0.000000, -9.694390>, <-3.709564, 0.000000, -9.877350>, <-3.602978, 0.000000, -10.033655>, 
      <-3.958264, 0.614685, -9.512637>, <-3.905746, 0.614685, -9.694390>, <-3.709564, 0.559512, -9.877350>, <-3.602978, 0.559512, -10.033655>, 
      <-3.735299, 1.446800, -9.512637>, <-3.689817, 1.420541, -9.694390>, <-3.492332, 1.370231, -9.877350>, <-3.400026, 1.316938, -10.033655>, 
      <-3.427957, 1.979133, -9.512637>, <-3.382475, 1.952874, -9.694390>, <-3.212576, 1.854783, -9.877350>, <-3.120270, 1.801490, -10.033655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.427958, -1.979132, -9.512637>, <-3.382476, -1.952873, -9.694390>, <-3.212577, -1.854782, -9.877350>, <-3.120271, -1.801489, -10.033655>, 
      <-3.735300, -1.446800, -9.512637>, <-3.689818, -1.420541, -9.694390>, <-3.492333, -1.370231, -9.877350>, <-3.400027, -1.316938, -10.033655>, 
      <-3.958264, -0.614684, -9.512637>, <-3.905746, -0.614684, -9.694390>, <-3.709564, -0.559512, -9.877350>, <-3.602978, -0.559512, -10.033655>, 
      <-3.958264, 0.000000, -9.512637>, <-3.905746, 0.000000, -9.694390>, <-3.709564, 0.000000, -9.877350>, <-3.602978, 0.000000, -10.033655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.979132, -3.427957, -9.512637>, <-1.952873, -3.382475, -9.694390>, <-1.854782, -3.212577, -9.877350>, <-1.801489, -3.120271, -10.033655>, 
      <-2.511465, -3.120615, -9.512637>, <-2.485205, -3.075133, -9.694390>, <-2.339334, -2.932821, -9.877350>, <-2.286041, -2.840515, -10.033655>, 
      <-3.120616, -2.511465, -9.512637>, <-3.075134, -2.485205, -9.694390>, <-2.932821, -2.339334, -9.877350>, <-2.840515, -2.286041, -10.033655>, 
      <-3.427958, -1.979132, -9.512637>, <-3.382476, -1.952873, -9.694390>, <-3.212577, -1.854782, -9.877350>, <-3.120271, -1.801489, -10.033655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.958264, -9.512637>, <0.000000, -3.905746, -9.694390>, <0.000000, -3.709564, -9.877350>, <0.000000, -3.602978, -10.033655>, 
      <-0.614684, -3.958264, -9.512637>, <-0.614684, -3.905746, -9.694390>, <-0.559512, -3.709564, -9.877350>, <-0.559512, -3.602978, -10.033655>, 
      <-1.446800, -3.735299, -9.512637>, <-1.420540, -3.689817, -9.694390>, <-1.370231, -3.492333, -9.877350>, <-1.316938, -3.400027, -10.033655>, 
      <-1.979132, -3.427957, -9.512637>, <-1.952873, -3.382475, -9.694390>, <-1.854782, -3.212577, -9.877350>, <-1.801489, -3.120271, -10.033655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.979132, -3.427958, -9.512637>, <1.952873, -3.382476, -9.694390>, <1.854782, -3.212577, -9.877350>, <1.801489, -3.120271, -10.033655>, 
      <1.446800, -3.735300, -9.512637>, <1.420541, -3.689818, -9.694390>, <1.370231, -3.492333, -9.877350>, <1.316938, -3.400027, -10.033655>, 
      <0.614684, -3.958264, -9.512637>, <0.614684, -3.905746, -9.694390>, <0.559512, -3.709564, -9.877350>, <0.559512, -3.602978, -10.033655>, 
      <0.000000, -3.958264, -9.512637>, <0.000000, -3.905746, -9.694390>, <0.000000, -3.709564, -9.877350>, <0.000000, -3.602978, -10.033655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.427957, -1.979132, -9.512637>, <3.382475, -1.952873, -9.694390>, <3.212577, -1.854782, -9.877350>, <3.120271, -1.801489, -10.033655>, 
      <3.120615, -2.511465, -9.512637>, <3.075133, -2.485205, -9.694390>, <2.932821, -2.339334, -9.877350>, <2.840515, -2.286041, -10.033655>, 
      <2.511465, -3.120616, -9.512637>, <2.485205, -3.075134, -9.694390>, <2.339334, -2.932821, -9.877350>, <2.286041, -2.840515, -10.033655>, 
      <1.979132, -3.427958, -9.512637>, <1.952873, -3.382476, -9.694390>, <1.854782, -3.212577, -9.877350>, <1.801489, -3.120271, -10.033655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.940701, 3.361392, -9.070110>, <1.941383, 3.362574, -9.204850>, <1.997836, 3.460352, -9.383187>, <1.979133, 3.427958, -9.512637>, 
      <2.462696, 3.060018, -9.070110>, <2.463379, 3.061200, -9.204850>, <2.530168, 3.153009, -9.383187>, <2.511466, 3.120615, -9.512637>, 
      <3.060018, 2.462696, -9.070110>, <3.061200, 2.463378, -9.204850>, <3.153010, 2.530167, -9.383187>, <3.120616, 2.511464, -9.512637>, 
      <3.361392, 1.940700, -9.070110>, <3.362574, 1.941383, -9.204850>, <3.460352, 1.997834, -9.383187>, <3.427958, 1.979131, -9.512637>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000001, 3.881401, -9.070110>, <0.000001, 3.882766, -9.204850>, <0.000001, 3.995670, -9.383187>, <0.000001, 3.958264, -9.512637>, 
      <0.602749, 3.881401, -9.070110>, <0.602749, 3.882766, -9.204850>, <0.614686, 3.995670, -9.383187>, <0.614686, 3.958264, -9.512637>, 
      <1.418706, 3.662766, -9.070110>, <1.419388, 3.663948, -9.204850>, <1.465503, 3.767694, -9.383187>, <1.446801, 3.735300, -9.512637>, 
      <1.940701, 3.361392, -9.070110>, <1.941383, 3.362574, -9.204850>, <1.997836, 3.460352, -9.383187>, <1.979133, 3.427958, -9.512637>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.940700, 3.361392, -9.070110>, <-1.941383, 3.362574, -9.204850>, <-1.997835, 3.460352, -9.383187>, <-1.979132, 3.427958, -9.512637>, 
      <-1.418705, 3.662766, -9.070110>, <-1.419387, 3.663948, -9.204850>, <-1.465502, 3.767694, -9.383187>, <-1.446799, 3.735300, -9.512637>, 
      <-0.602747, 3.881401, -9.070110>, <-0.602747, 3.882766, -9.204850>, <-0.614684, 3.995670, -9.383187>, <-0.614684, 3.958264, -9.512637>, 
      <0.000001, 3.881401, -9.070110>, <0.000001, 3.882766, -9.204850>, <0.000001, 3.995670, -9.383187>, <0.000001, 3.958264, -9.512637>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.361392, 1.940701, -9.070110>, <-3.362574, 1.941383, -9.204850>, <-3.460351, 1.997836, -9.383187>, <-3.427957, 1.979133, -9.512637>, 
      <-3.060018, 2.462697, -9.070110>, <-3.061200, 2.463379, -9.204850>, <-3.153009, 2.530168, -9.383187>, <-3.120615, 2.511466, -9.512637>, 
      <-2.462696, 3.060018, -9.070110>, <-2.463378, 3.061200, -9.204850>, <-2.530167, 3.153010, -9.383187>, <-2.511465, 3.120616, -9.512637>, 
      <-1.940700, 3.361392, -9.070110>, <-1.941383, 3.362574, -9.204850>, <-1.997835, 3.460352, -9.383187>, <-1.979132, 3.427958, -9.512637>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.881401, 0.000000, -9.070110>, <-3.882766, 0.000000, -9.204850>, <-3.995670, 0.000000, -9.383187>, <-3.958264, 0.000000, -9.512637>, 
      <-3.881401, 0.602749, -9.070110>, <-3.882766, 0.602749, -9.204850>, <-3.995669, 0.614685, -9.383187>, <-3.958264, 0.614685, -9.512637>, 
      <-3.662766, 1.418706, -9.070110>, <-3.663948, 1.419388, -9.204850>, <-3.767694, 1.465503, -9.383187>, <-3.735299, 1.446800, -9.512637>, 
      <-3.361392, 1.940701, -9.070110>, <-3.362574, 1.941383, -9.204850>, <-3.460351, 1.997836, -9.383187>, <-3.427957, 1.979133, -9.512637>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.361392, -1.940701, -9.070110>, <-3.362574, -1.941383, -9.204850>, <-3.460352, -1.997835, -9.383187>, <-3.427958, -1.979132, -9.512637>, 
      <-3.662766, -1.418706, -9.070110>, <-3.663948, -1.419388, -9.204850>, <-3.767694, -1.465502, -9.383187>, <-3.735300, -1.446800, -9.512637>, 
      <-3.881401, -0.602749, -9.070110>, <-3.882766, -0.602749, -9.204850>, <-3.995670, -0.614684, -9.383187>, <-3.958264, -0.614684, -9.512637>, 
      <-3.881401, 0.000000, -9.070110>, <-3.882766, 0.000000, -9.204850>, <-3.995670, 0.000000, -9.383187>, <-3.958264, 0.000000, -9.512637>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.940701, -3.361392, -9.070110>, <-1.941383, -3.362574, -9.204850>, <-1.997835, -3.460351, -9.383187>, <-1.979132, -3.427957, -9.512637>, 
      <-2.462696, -3.060018, -9.070110>, <-2.463379, -3.061200, -9.204850>, <-2.530167, -3.153009, -9.383187>, <-2.511465, -3.120615, -9.512637>, 
      <-3.060018, -2.462696, -9.070110>, <-3.061200, -2.463379, -9.204850>, <-3.153010, -2.530167, -9.383187>, <-3.120616, -2.511465, -9.512637>, 
      <-3.361392, -1.940701, -9.070110>, <-3.362574, -1.941383, -9.204850>, <-3.460352, -1.997835, -9.383187>, <-3.427958, -1.979132, -9.512637>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.881401, -9.070110>, <0.000000, -3.882766, -9.204850>, <0.000000, -3.995670, -9.383187>, <0.000000, -3.958264, -9.512637>, 
      <-0.602749, -3.881401, -9.070110>, <-0.602749, -3.882766, -9.204850>, <-0.614684, -3.995669, -9.383187>, <-0.614684, -3.958264, -9.512637>, 
      <-1.418706, -3.662766, -9.070110>, <-1.419388, -3.663948, -9.204850>, <-1.465502, -3.767693, -9.383187>, <-1.446800, -3.735299, -9.512637>, 
      <-1.940701, -3.361392, -9.070110>, <-1.941383, -3.362574, -9.204850>, <-1.997835, -3.460351, -9.383187>, <-1.979132, -3.427957, -9.512637>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.940700, -3.361392, -9.070110>, <1.941383, -3.362574, -9.204850>, <1.997835, -3.460352, -9.383187>, <1.979132, -3.427958, -9.512637>, 
      <1.418705, -3.662766, -9.070110>, <1.419387, -3.663948, -9.204850>, <1.465502, -3.767694, -9.383187>, <1.446800, -3.735300, -9.512637>, 
      <0.602748, -3.881401, -9.070110>, <0.602748, -3.882766, -9.204850>, <0.614684, -3.995670, -9.383187>, <0.614684, -3.958264, -9.512637>, 
      <0.000000, -3.881401, -9.070110>, <0.000000, -3.882766, -9.204850>, <0.000000, -3.995670, -9.383187>, <0.000000, -3.958264, -9.512637>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.361392, -1.940701, -9.070110>, <3.362574, -1.941383, -9.204850>, <3.460351, -1.997835, -9.383187>, <3.427957, -1.979132, -9.512637>, 
      <3.060018, -2.462697, -9.070110>, <3.061200, -2.463379, -9.204850>, <3.153009, -2.530167, -9.383187>, <3.120615, -2.511465, -9.512637>, 
      <2.462696, -3.060018, -9.070110>, <2.463378, -3.061200, -9.204850>, <2.530167, -3.153010, -9.383187>, <2.511465, -3.120616, -9.512637>, 
      <1.940700, -3.361392, -9.070110>, <1.941383, -3.362574, -9.204850>, <1.997835, -3.460352, -9.383187>, <1.979132, -3.427958, -9.512637>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.940679, 3.361354, -1.921214>, <1.970598, 3.413175, -4.065048>, <1.929838, 3.342577, -6.925551>, <1.940701, 3.361392, -9.070110>, 
      <2.462668, 3.059983, -1.921214>, <2.492587, 3.111804, -4.065048>, <2.451833, 3.041202, -6.925551>, <2.462696, 3.060018, -9.070110>, 
      <3.059983, 2.462668, -1.921214>, <3.111804, 2.492587, -4.065048>, <3.041202, 2.451833, -6.925551>, <3.060018, 2.462696, -9.070110>, 
      <3.361354, 1.940678, -1.921214>, <3.413175, 1.970597, -4.065048>, <3.342577, 1.929837, -6.925551>, <3.361392, 1.940700, -9.070110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000001, 3.881357, -1.921214>, <0.000001, 3.941195, -4.065048>, <0.000001, 3.859675, -6.925551>, <0.000001, 3.881401, -9.070110>, 
      <0.602742, 3.881357, -1.921214>, <0.602743, 3.941195, -4.065048>, <0.602749, 3.859675, -6.925551>, <0.602749, 3.881401, -9.070110>, 
      <1.418690, 3.662725, -1.921214>, <1.448609, 3.714546, -4.065048>, <1.407843, 3.643951, -6.925551>, <1.418706, 3.662766, -9.070110>, 
      <1.940679, 3.361354, -1.921214>, <1.970598, 3.413175, -4.065048>, <1.929838, 3.342577, -6.925551>, <1.940701, 3.361392, -9.070110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.940678, 3.361354, -1.921214>, <-1.970597, 3.413175, -4.065048>, <-1.929837, 3.342577, -6.925551>, <-1.940700, 3.361392, -9.070110>, 
      <-1.418688, 3.662725, -1.921214>, <-1.448607, 3.714546, -4.065048>, <-1.407841, 3.643950, -6.925551>, <-1.418705, 3.662766, -9.070110>, 
      <-0.602741, 3.881357, -1.921214>, <-0.602740, 3.941195, -4.065048>, <-0.602747, 3.859675, -6.925551>, <-0.602747, 3.881401, -9.070110>, 
      <0.000001, 3.881357, -1.921214>, <0.000001, 3.941195, -4.065048>, <0.000001, 3.859675, -6.925551>, <0.000001, 3.881401, -9.070110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.361354, 1.940679, -1.921214>, <-3.413175, 1.970598, -4.065048>, <-3.342577, 1.929838, -6.925551>, <-3.361392, 1.940701, -9.070110>, 
      <-3.059983, 2.462668, -1.921214>, <-3.111804, 2.492587, -4.065048>, <-3.041203, 2.451833, -6.925551>, <-3.060018, 2.462697, -9.070110>, 
      <-2.462668, 3.059983, -1.921214>, <-2.492587, 3.111805, -4.065048>, <-2.451832, 3.041203, -6.925551>, <-2.462696, 3.060018, -9.070110>, 
      <-1.940678, 3.361354, -1.921214>, <-1.970597, 3.413175, -4.065048>, <-1.929837, 3.342577, -6.925551>, <-1.940700, 3.361392, -9.070110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.881357, 0.000000, -1.921214>, <-3.941195, 0.000000, -4.065048>, <-3.859675, 0.000000, -6.925551>, <-3.881401, 0.000000, -9.070110>, 
      <-3.881357, 0.602742, -1.921214>, <-3.941195, 0.602742, -4.065048>, <-3.859675, 0.602749, -6.925551>, <-3.881401, 0.602749, -9.070110>, 
      <-3.662725, 1.418689, -1.921214>, <-3.714546, 1.448608, -4.065048>, <-3.643951, 1.407842, -6.925551>, <-3.662766, 1.418706, -9.070110>, 
      <-3.361354, 1.940679, -1.921214>, <-3.413175, 1.970598, -4.065048>, <-3.342577, 1.929838, -6.925551>, <-3.361392, 1.940701, -9.070110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.361354, -1.940679, -1.921214>, <-3.413175, -1.970598, -4.065048>, <-3.342577, -1.929838, -6.925551>, <-3.361392, -1.940701, -9.070110>, 
      <-3.662725, -1.418689, -1.921214>, <-3.714546, -1.448608, -4.065048>, <-3.643951, -1.407843, -6.925551>, <-3.662766, -1.418706, -9.070110>, 
      <-3.881357, -0.602742, -1.921214>, <-3.941195, -0.602742, -4.065048>, <-3.859675, -0.602749, -6.925551>, <-3.881401, -0.602749, -9.070110>, 
      <-3.881357, 0.000000, -1.921214>, <-3.941195, 0.000000, -4.065048>, <-3.859675, 0.000000, -6.925551>, <-3.881401, 0.000000, -9.070110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.940679, -3.361354, -1.921214>, <-1.970598, -3.413175, -4.065048>, <-1.929838, -3.342577, -6.925551>, <-1.940701, -3.361392, -9.070110>, 
      <-2.462668, -3.059983, -1.921214>, <-2.492587, -3.111805, -4.065048>, <-2.451833, -3.041203, -6.925551>, <-2.462696, -3.060018, -9.070110>, 
      <-3.059983, -2.462668, -1.921214>, <-3.111805, -2.492587, -4.065048>, <-3.041203, -2.451833, -6.925551>, <-3.060018, -2.462696, -9.070110>, 
      <-3.361354, -1.940679, -1.921214>, <-3.413175, -1.970598, -4.065048>, <-3.342577, -1.929838, -6.925551>, <-3.361392, -1.940701, -9.070110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.881357, -1.921214>, <0.000000, -3.941195, -4.065048>, <0.000000, -3.859675, -6.925551>, <0.000000, -3.881401, -9.070110>, 
      <-0.602742, -3.881357, -1.921214>, <-0.602742, -3.941195, -4.065048>, <-0.602749, -3.859675, -6.925551>, <-0.602749, -3.881401, -9.070110>, 
      <-1.418689, -3.662725, -1.921214>, <-1.448608, -3.714546, -4.065048>, <-1.407843, -3.643951, -6.925551>, <-1.418706, -3.662766, -9.070110>, 
      <-1.940679, -3.361354, -1.921214>, <-1.970598, -3.413175, -4.065048>, <-1.929838, -3.342577, -6.925551>, <-1.940701, -3.361392, -9.070110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.940678, -3.361354, -1.921214>, <1.970597, -3.413175, -4.065048>, <1.929837, -3.342577, -6.925551>, <1.940700, -3.361392, -9.070110>, 
      <1.418689, -3.662725, -1.921214>, <1.448608, -3.714546, -4.065048>, <1.407842, -3.643950, -6.925551>, <1.418705, -3.662766, -9.070110>, 
      <0.602741, -3.881357, -1.921214>, <0.602741, -3.941195, -4.065048>, <0.602748, -3.859675, -6.925551>, <0.602748, -3.881401, -9.070110>, 
      <0.000000, -3.881357, -1.921214>, <0.000000, -3.941195, -4.065048>, <0.000000, -3.859675, -6.925551>, <0.000000, -3.881401, -9.070110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.361354, -1.940679, -1.921214>, <3.413175, -1.970598, -4.065048>, <3.342577, -1.929838, -6.925551>, <3.361392, -1.940701, -9.070110>, 
      <3.059983, -2.462668, -1.921214>, <3.111804, -2.492588, -4.065048>, <3.041203, -2.451834, -6.925551>, <3.060018, -2.462697, -9.070110>, 
      <2.462668, -3.059983, -1.921214>, <2.492587, -3.111804, -4.065048>, <2.451832, -3.041202, -6.925551>, <2.462696, -3.060018, -9.070110>, 
      <1.940678, -3.361354, -1.921214>, <1.970597, -3.413175, -4.065048>, <1.929837, -3.342577, -6.925551>, <1.940700, -3.361392, -9.070110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.834481, 3.177413, -1.458946>, <1.878723, 3.254042, -1.583296>, <1.938550, 3.357666, -1.768655>, <1.940679, 3.361354, -1.921214>, 
      <2.327906, 2.892534, -1.458946>, <2.372148, 2.969163, -1.583296>, <2.460539, 3.056296, -1.768655>, <2.462668, 3.059983, -1.921214>, 
      <2.892534, 2.327904, -1.458946>, <2.969163, 2.372146, -1.583296>, <3.056296, 2.460539, -1.768655>, <3.059983, 2.462668, -1.921214>, 
      <3.177413, 1.834479, -1.458946>, <3.254042, 1.878721, -1.583296>, <3.357666, 1.938549, -1.768655>, <3.361354, 1.940678, -1.921214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.668961, -1.458946>, <0.000000, 3.757445, -1.583296>, <0.000001, 3.877099, -1.768655>, <0.000001, 3.881357, -1.921214>, 
      <0.569758, 3.668961, -1.458946>, <0.569759, 3.757445, -1.583296>, <0.602742, 3.877099, -1.768655>, <0.602742, 3.881357, -1.921214>, 
      <1.341056, 3.462292, -1.458946>, <1.385298, 3.538922, -1.583296>, <1.416561, 3.659037, -1.768655>, <1.418690, 3.662725, -1.921214>, 
      <1.834481, 3.177413, -1.458946>, <1.878723, 3.254042, -1.583296>, <1.938550, 3.357666, -1.768655>, <1.940679, 3.361354, -1.921214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.834480, 3.177413, -1.458946>, <-1.878722, 3.254042, -1.583296>, <-1.938549, 3.357666, -1.768655>, <-1.940678, 3.361354, -1.921214>, 
      <-1.341055, 3.462292, -1.458946>, <-1.385297, 3.538921, -1.583296>, <-1.416559, 3.659037, -1.768655>, <-1.418688, 3.662725, -1.921214>, 
      <-0.569758, 3.668961, -1.458946>, <-0.569758, 3.757445, -1.583296>, <-0.602741, 3.877099, -1.768655>, <-0.602741, 3.881357, -1.921214>, 
      <0.000000, 3.668961, -1.458946>, <0.000000, 3.757445, -1.583296>, <0.000001, 3.877099, -1.768655>, <0.000001, 3.881357, -1.921214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.177413, 1.834481, -1.458946>, <-3.254042, 1.878723, -1.583296>, <-3.357666, 1.938550, -1.768655>, <-3.361354, 1.940679, -1.921214>, 
      <-2.892534, 2.327906, -1.458946>, <-2.969163, 2.372148, -1.583296>, <-3.056296, 2.460539, -1.768655>, <-3.059983, 2.462668, -1.921214>, 
      <-2.327905, 2.892534, -1.458946>, <-2.372147, 2.969163, -1.583296>, <-2.460539, 3.056296, -1.768655>, <-2.462668, 3.059983, -1.921214>, 
      <-1.834480, 3.177413, -1.458946>, <-1.878722, 3.254042, -1.583296>, <-1.938549, 3.357666, -1.768655>, <-1.940678, 3.361354, -1.921214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.668961, 0.000000, -1.458946>, <-3.757445, 0.000000, -1.583296>, <-3.877099, 0.000000, -1.768655>, <-3.881357, 0.000000, -1.921214>, 
      <-3.668961, 0.569758, -1.458946>, <-3.757445, 0.569758, -1.583296>, <-3.877099, 0.602742, -1.768655>, <-3.881357, 0.602742, -1.921214>, 
      <-3.462292, 1.341056, -1.458946>, <-3.538922, 1.385298, -1.583296>, <-3.659037, 1.416560, -1.768655>, <-3.662725, 1.418689, -1.921214>, 
      <-3.177413, 1.834481, -1.458946>, <-3.254042, 1.878723, -1.583296>, <-3.357666, 1.938550, -1.768655>, <-3.361354, 1.940679, -1.921214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.177413, -1.834481, -1.458946>, <-3.254042, -1.878723, -1.583296>, <-3.357666, -1.938550, -1.768655>, <-3.361354, -1.940679, -1.921214>, 
      <-3.462292, -1.341056, -1.458946>, <-3.538922, -1.385298, -1.583296>, <-3.659037, -1.416560, -1.768655>, <-3.662725, -1.418689, -1.921214>, 
      <-3.668961, -0.569758, -1.458946>, <-3.757445, -0.569758, -1.583296>, <-3.877099, -0.602742, -1.768655>, <-3.881357, -0.602742, -1.921214>, 
      <-3.668961, 0.000000, -1.458946>, <-3.757445, 0.000000, -1.583296>, <-3.877099, 0.000000, -1.768655>, <-3.881357, 0.000000, -1.921214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.834481, -3.177413, -1.458946>, <-1.878723, -3.254042, -1.583296>, <-1.938550, -3.357666, -1.768655>, <-1.940679, -3.361354, -1.921214>, 
      <-2.327906, -2.892534, -1.458946>, <-2.372148, -2.969164, -1.583296>, <-2.460539, -3.056296, -1.768655>, <-2.462668, -3.059983, -1.921214>, 
      <-2.892534, -2.327906, -1.458946>, <-2.969164, -2.372148, -1.583296>, <-3.056296, -2.460539, -1.768655>, <-3.059983, -2.462668, -1.921214>, 
      <-3.177413, -1.834481, -1.458946>, <-3.254042, -1.878723, -1.583296>, <-3.357666, -1.938550, -1.768655>, <-3.361354, -1.940679, -1.921214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.668961, -1.458946>, <0.000000, -3.757445, -1.583296>, <0.000000, -3.877099, -1.768655>, <0.000000, -3.881357, -1.921214>, 
      <-0.569758, -3.668961, -1.458946>, <-0.569758, -3.757445, -1.583296>, <-0.602742, -3.877099, -1.768655>, <-0.602742, -3.881357, -1.921214>, 
      <-1.341056, -3.462292, -1.458946>, <-1.385298, -3.538922, -1.583296>, <-1.416560, -3.659037, -1.768655>, <-1.418689, -3.662725, -1.921214>, 
      <-1.834481, -3.177413, -1.458946>, <-1.878723, -3.254042, -1.583296>, <-1.938550, -3.357666, -1.768655>, <-1.940679, -3.361354, -1.921214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.834480, -3.177413, -1.458946>, <1.878722, -3.254042, -1.583296>, <1.938549, -3.357666, -1.768655>, <1.940678, -3.361354, -1.921214>, 
      <1.341055, -3.462292, -1.458946>, <1.385297, -3.538922, -1.583296>, <1.416560, -3.659037, -1.768655>, <1.418689, -3.662725, -1.921214>, 
      <0.569758, -3.668961, -1.458946>, <0.569758, -3.757445, -1.583296>, <0.602741, -3.877099, -1.768655>, <0.602741, -3.881357, -1.921214>, 
      <0.000000, -3.668961, -1.458946>, <0.000000, -3.757445, -1.583296>, <0.000000, -3.877099, -1.768655>, <0.000000, -3.881357, -1.921214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.177413, -1.834480, -1.458946>, <3.254042, -1.878722, -1.583296>, <3.357666, -1.938550, -1.768655>, <3.361354, -1.940679, -1.921214>, 
      <2.892534, -2.327905, -1.458946>, <2.969163, -2.372147, -1.583296>, <3.056296, -2.460539, -1.768655>, <3.059983, -2.462668, -1.921214>, 
      <2.327905, -2.892534, -1.458946>, <2.372147, -2.969163, -1.583296>, <2.460539, -3.056296, -1.768655>, <2.462668, -3.059983, -1.921214>, 
      <1.834480, -3.177413, -1.458946>, <1.878722, -3.254042, -1.583296>, <1.938549, -3.357666, -1.768655>, <1.940678, -3.361354, -1.921214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.680232, 2.910246, -1.189180>, <1.709069, 2.960192, -1.297756>, <1.798841, 3.115684, -1.358775>, <1.834481, 3.177413, -1.458946>, 
      <2.132168, 2.649320, -1.189180>, <2.161005, 2.699267, -1.297756>, <2.292266, 2.830804, -1.358775>, <2.327906, 2.892534, -1.458946>, 
      <2.649322, 2.132167, -1.189180>, <2.699268, 2.161004, -1.297756>, <2.830805, 2.292265, -1.358775>, <2.892534, 2.327904, -1.458946>, 
      <2.910247, 1.680231, -1.189180>, <2.960193, 1.709067, -1.297756>, <3.115684, 1.798840, -1.358775>, <3.177413, 1.834479, -1.458946>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.360463, -1.189180>, <0.000000, 3.418136, -1.297756>, <-0.000000, 3.597682, -1.358775>, <0.000000, 3.668961, -1.458946>, 
      <0.521851, 3.360463, -1.189180>, <0.521851, 3.418136, -1.297756>, <0.569758, 3.597682, -1.358775>, <0.569758, 3.668961, -1.458946>, 
      <1.228296, 3.171172, -1.189180>, <1.257132, 3.221118, -1.297756>, <1.305416, 3.400563, -1.358775>, <1.341056, 3.462292, -1.458946>, 
      <1.680232, 2.910246, -1.189180>, <1.709069, 2.960192, -1.297756>, <1.798841, 3.115684, -1.358775>, <1.834481, 3.177413, -1.458946>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.680231, 2.910246, -1.189180>, <-1.709068, 2.960192, -1.297756>, <-1.798841, 3.115684, -1.358775>, <-1.834480, 3.177413, -1.458946>, 
      <-1.228295, 3.171171, -1.189180>, <-1.257131, 3.221118, -1.297756>, <-1.305416, 3.400562, -1.358775>, <-1.341055, 3.462292, -1.458946>, 
      <-0.521851, 3.360463, -1.189180>, <-0.521851, 3.418136, -1.297756>, <-0.569758, 3.597682, -1.358775>, <-0.569758, 3.668961, -1.458946>, 
      <0.000000, 3.360463, -1.189180>, <0.000000, 3.418136, -1.297756>, <-0.000000, 3.597682, -1.358775>, <0.000000, 3.668961, -1.458946>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.910246, 1.680232, -1.189180>, <-2.960192, 1.709069, -1.297756>, <-3.115684, 1.798841, -1.358775>, <-3.177413, 1.834481, -1.458946>, 
      <-2.649320, 2.132168, -1.189180>, <-2.699267, 2.161005, -1.297756>, <-2.830804, 2.292266, -1.358775>, <-2.892534, 2.327906, -1.458946>, 
      <-2.132167, 2.649320, -1.189180>, <-2.161004, 2.699267, -1.297756>, <-2.292265, 2.830805, -1.358775>, <-2.327905, 2.892534, -1.458946>, 
      <-1.680231, 2.910246, -1.189180>, <-1.709068, 2.960192, -1.297756>, <-1.798841, 3.115684, -1.358775>, <-1.834480, 3.177413, -1.458946>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.360463, 0.000000, -1.189180>, <-3.418136, 0.000000, -1.297756>, <-3.597682, 0.000000, -1.358775>, <-3.668961, 0.000000, -1.458946>, 
      <-3.360463, 0.521851, -1.189180>, <-3.418136, 0.521851, -1.297756>, <-3.597682, 0.569758, -1.358775>, <-3.668961, 0.569758, -1.458946>, 
      <-3.171172, 1.228296, -1.189180>, <-3.221118, 1.257132, -1.297756>, <-3.400563, 1.305416, -1.358775>, <-3.462292, 1.341056, -1.458946>, 
      <-2.910246, 1.680232, -1.189180>, <-2.960192, 1.709069, -1.297756>, <-3.115684, 1.798841, -1.358775>, <-3.177413, 1.834481, -1.458946>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.910246, -1.680232, -1.189180>, <-2.960192, -1.709069, -1.297756>, <-3.115684, -1.798841, -1.358775>, <-3.177413, -1.834481, -1.458946>, 
      <-3.171171, -1.228296, -1.189180>, <-3.221118, -1.257132, -1.297756>, <-3.400563, -1.305416, -1.358775>, <-3.462292, -1.341056, -1.458946>, 
      <-3.360463, -0.521851, -1.189180>, <-3.418136, -0.521851, -1.297756>, <-3.597682, -0.569758, -1.358775>, <-3.668961, -0.569758, -1.458946>, 
      <-3.360463, 0.000000, -1.189180>, <-3.418136, 0.000000, -1.297756>, <-3.597682, 0.000000, -1.358775>, <-3.668961, 0.000000, -1.458946>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.680232, -2.910246, -1.189180>, <-1.709069, -2.960192, -1.297756>, <-1.798841, -3.115684, -1.358775>, <-1.834481, -3.177413, -1.458946>, 
      <-2.132168, -2.649321, -1.189180>, <-2.161005, -2.699267, -1.297756>, <-2.292266, -2.830805, -1.358775>, <-2.327906, -2.892534, -1.458946>, 
      <-2.649321, -2.132168, -1.189180>, <-2.699267, -2.161005, -1.297756>, <-2.830805, -2.292266, -1.358775>, <-2.892534, -2.327906, -1.458946>, 
      <-2.910246, -1.680232, -1.189180>, <-2.960192, -1.709069, -1.297756>, <-3.115684, -1.798841, -1.358775>, <-3.177413, -1.834481, -1.458946>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.360463, -1.189180>, <0.000000, -3.418136, -1.297756>, <0.000000, -3.597682, -1.358775>, <0.000000, -3.668961, -1.458946>, 
      <-0.521851, -3.360463, -1.189180>, <-0.521851, -3.418136, -1.297756>, <-0.569758, -3.597682, -1.358775>, <-0.569758, -3.668961, -1.458946>, 
      <-1.228296, -3.171171, -1.189180>, <-1.257132, -3.221118, -1.297756>, <-1.305416, -3.400563, -1.358775>, <-1.341056, -3.462292, -1.458946>, 
      <-1.680232, -2.910246, -1.189180>, <-1.709069, -2.960192, -1.297756>, <-1.798841, -3.115684, -1.358775>, <-1.834481, -3.177413, -1.458946>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.680231, -2.910246, -1.189180>, <1.709068, -2.960192, -1.297756>, <1.798841, -3.115684, -1.358775>, <1.834480, -3.177413, -1.458946>, 
      <1.228295, -3.171171, -1.189180>, <1.257132, -3.221118, -1.297756>, <1.305416, -3.400563, -1.358775>, <1.341055, -3.462292, -1.458946>, 
      <0.521851, -3.360463, -1.189180>, <0.521851, -3.418136, -1.297756>, <0.569758, -3.597682, -1.358775>, <0.569758, -3.668961, -1.458946>, 
      <0.000000, -3.360463, -1.189180>, <0.000000, -3.418136, -1.297756>, <0.000000, -3.597682, -1.358775>, <0.000000, -3.668961, -1.458946>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.910246, -1.680231, -1.189180>, <2.960192, -1.709068, -1.297756>, <3.115684, -1.798840, -1.358775>, <3.177413, -1.834480, -1.458946>, 
      <2.649320, -2.132167, -1.189180>, <2.699267, -2.161004, -1.297756>, <2.830804, -2.292265, -1.358775>, <2.892534, -2.327905, -1.458946>, 
      <2.132167, -2.649320, -1.189180>, <2.161004, -2.699267, -1.297756>, <2.292266, -2.830804, -1.358775>, <2.327905, -2.892534, -1.458946>, 
      <1.680231, -2.910246, -1.189180>, <1.709068, -2.960192, -1.297756>, <1.798841, -3.115684, -1.358775>, <1.834480, -3.177413, -1.458946>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.655356, 2.867160, -0.784499>, <1.649759, 2.857465, -0.906304>, <1.651542, 2.860554, -1.081155>, <1.680232, 2.910246, -1.189180>, 
      <2.100602, 2.610097, -0.784499>, <2.095004, 2.600402, -0.906304>, <2.103478, 2.599628, -1.081155>, <2.132168, 2.649320, -1.189180>, 
      <2.610097, 2.100600, -0.784499>, <2.600402, 2.095002, -0.906304>, <2.599629, 2.103477, -1.081155>, <2.649322, 2.132167, -1.189180>, 
      <2.867160, 1.655354, -0.784499>, <2.857465, 1.649757, -0.906304>, <2.860555, 1.651541, -1.081155>, <2.910247, 1.680231, -1.189180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.310711, -0.784499>, <0.000000, 3.299516, -0.906304>, <0.000000, 3.303083, -1.081155>, <0.000000, 3.360463, -1.189180>, 
      <0.514125, 3.310711, -0.784499>, <0.514125, 3.299516, -0.906304>, <0.521851, 3.303083, -1.081155>, <0.521851, 3.360463, -1.189180>, 
      <1.210111, 3.124223, -0.784499>, <1.204513, 3.114527, -0.906304>, <1.199606, 3.121479, -1.081155>, <1.228296, 3.171172, -1.189180>, 
      <1.655356, 2.867160, -0.784499>, <1.649759, 2.857465, -0.906304>, <1.651542, 2.860554, -1.081155>, <1.680232, 2.910246, -1.189180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.655355, 2.867160, -0.784499>, <-1.649757, 2.857465, -0.906304>, <-1.651541, 2.860554, -1.081155>, <-1.680231, 2.910246, -1.189180>, 
      <-1.210110, 3.124223, -0.784499>, <-1.204512, 3.114527, -0.906304>, <-1.199605, 3.121479, -1.081155>, <-1.228295, 3.171171, -1.189180>, 
      <-0.514125, 3.310711, -0.784499>, <-0.514125, 3.299516, -0.906304>, <-0.521851, 3.303083, -1.081155>, <-0.521851, 3.360463, -1.189180>, 
      <0.000000, 3.310711, -0.784499>, <0.000000, 3.299516, -0.906304>, <0.000000, 3.303083, -1.081155>, <0.000000, 3.360463, -1.189180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.867159, 1.655356, -0.784499>, <-2.857464, 1.649758, -0.906304>, <-2.860553, 1.651542, -1.081155>, <-2.910246, 1.680232, -1.189180>, 
      <-2.610096, 2.100601, -0.784499>, <-2.600401, 2.095004, -0.906304>, <-2.599628, 2.103478, -1.081155>, <-2.649320, 2.132168, -1.189180>, 
      <-2.100600, 2.610098, -0.784499>, <-2.095003, 2.600402, -0.906304>, <-2.103477, 2.599628, -1.081155>, <-2.132167, 2.649320, -1.189180>, 
      <-1.655355, 2.867160, -0.784499>, <-1.649757, 2.857465, -0.906304>, <-1.651541, 2.860554, -1.081155>, <-1.680231, 2.910246, -1.189180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.310711, 0.000000, -0.784499>, <-3.299516, 0.000000, -0.906304>, <-3.303083, 0.000000, -1.081155>, <-3.360463, 0.000000, -1.189180>, 
      <-3.310711, 0.514125, -0.784499>, <-3.299515, 0.514125, -0.906304>, <-3.303083, 0.521851, -1.081155>, <-3.360463, 0.521851, -1.189180>, 
      <-3.124222, 1.210111, -0.784499>, <-3.114526, 1.204513, -0.906304>, <-3.121479, 1.199606, -1.081155>, <-3.171172, 1.228296, -1.189180>, 
      <-2.867159, 1.655356, -0.784499>, <-2.857464, 1.649758, -0.906304>, <-2.860553, 1.651542, -1.081155>, <-2.910246, 1.680232, -1.189180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.867160, -1.655356, -0.784499>, <-2.857465, -1.649759, -0.906304>, <-2.860554, -1.651542, -1.081155>, <-2.910246, -1.680232, -1.189180>, 
      <-3.124223, -1.210111, -0.784499>, <-3.114527, -1.204513, -0.906304>, <-3.121479, -1.199606, -1.081155>, <-3.171171, -1.228296, -1.189180>, 
      <-3.310711, -0.514125, -0.784499>, <-3.299516, -0.514125, -0.906304>, <-3.303083, -0.521851, -1.081155>, <-3.360463, -0.521851, -1.189180>, 
      <-3.310711, 0.000000, -0.784499>, <-3.299516, 0.000000, -0.906304>, <-3.303083, 0.000000, -1.081155>, <-3.360463, 0.000000, -1.189180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.655356, -2.867160, -0.784499>, <-1.649759, -2.857465, -0.906304>, <-1.651542, -2.860554, -1.081155>, <-1.680232, -2.910246, -1.189180>, 
      <-2.100601, -2.610098, -0.784499>, <-2.095004, -2.600402, -0.906304>, <-2.103478, -2.599628, -1.081155>, <-2.132168, -2.649321, -1.189180>, 
      <-2.610098, -2.100601, -0.784499>, <-2.600402, -2.095004, -0.906304>, <-2.599628, -2.103478, -1.081155>, <-2.649321, -2.132168, -1.189180>, 
      <-2.867160, -1.655356, -0.784499>, <-2.857465, -1.649759, -0.906304>, <-2.860554, -1.651542, -1.081155>, <-2.910246, -1.680232, -1.189180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.310711, -0.784499>, <0.000000, -3.299516, -0.906304>, <0.000000, -3.303083, -1.081155>, <0.000000, -3.360463, -1.189180>, 
      <-0.514125, -3.310711, -0.784499>, <-0.514125, -3.299516, -0.906304>, <-0.521851, -3.303083, -1.081155>, <-0.521851, -3.360463, -1.189180>, 
      <-1.210111, -3.124223, -0.784499>, <-1.204513, -3.114527, -0.906304>, <-1.199606, -3.121479, -1.081155>, <-1.228296, -3.171171, -1.189180>, 
      <-1.655356, -2.867160, -0.784499>, <-1.649759, -2.857465, -0.906304>, <-1.651542, -2.860554, -1.081155>, <-1.680232, -2.910246, -1.189180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.655355, -2.867160, -0.784499>, <1.649757, -2.857465, -0.906304>, <1.651541, -2.860554, -1.081155>, <1.680231, -2.910246, -1.189180>, 
      <1.210110, -3.124223, -0.784499>, <1.204512, -3.114527, -0.906304>, <1.199605, -3.121479, -1.081155>, <1.228295, -3.171171, -1.189180>, 
      <0.514125, -3.310711, -0.784499>, <0.514125, -3.299516, -0.906304>, <0.521851, -3.303083, -1.081155>, <0.521851, -3.360463, -1.189180>, 
      <0.000000, -3.310711, -0.784499>, <0.000000, -3.299516, -0.906304>, <0.000000, -3.303083, -1.081155>, <0.000000, -3.360463, -1.189180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.867160, -1.655355, -0.784499>, <2.857465, -1.649757, -0.906304>, <2.860554, -1.651541, -1.081155>, <2.910246, -1.680231, -1.189180>, 
      <2.610097, -2.100601, -0.784499>, <2.600402, -2.095003, -0.906304>, <2.599628, -2.103477, -1.081155>, <2.649320, -2.132167, -1.189180>, 
      <2.100601, -2.610097, -0.784499>, <2.095003, -2.600402, -0.906304>, <2.103477, -2.599628, -1.081155>, <2.132167, -2.649320, -1.189180>, 
      <1.655355, -2.867160, -0.784499>, <1.649757, -2.857465, -0.906304>, <1.651541, -2.860554, -1.081155>, <1.680231, -2.910246, -1.189180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.704146, 2.951668, -0.668791>, <1.725694, 2.988989, -0.683100>, <1.657434, 2.870759, -0.739281>, <1.655356, 2.867160, -0.784499>, 
      <2.162515, 2.687028, -0.668791>, <2.184062, 2.724350, -0.683100>, <2.102680, 2.613697, -0.739281>, <2.100602, 2.610097, -0.784499>, 
      <2.687028, 2.162514, -0.668791>, <2.724350, 2.184062, -0.683100>, <2.613697, 2.102678, -0.739281>, <2.610097, 2.100600, -0.784499>, 
      <2.951668, 1.704145, -0.668791>, <2.988990, 1.725692, -0.683100>, <2.870759, 1.657432, -0.739281>, <2.867160, 1.655354, -0.784499>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.408292, -0.668791>, <0.000000, 3.451387, -0.683100>, <0.000000, 3.314867, -0.739281>, <0.000000, 3.310711, -0.784499>, 
      <0.529278, 3.408292, -0.668791>, <0.529278, 3.451387, -0.683100>, <0.514125, 3.314867, -0.739281>, <0.514125, 3.310711, -0.784499>, 
      <1.245778, 3.216307, -0.668791>, <1.267325, 3.253629, -0.683100>, <1.212189, 3.127822, -0.739281>, <1.210111, 3.124223, -0.784499>, 
      <1.704146, 2.951668, -0.668791>, <1.725694, 2.988989, -0.683100>, <1.657434, 2.870759, -0.739281>, <1.655356, 2.867160, -0.784499>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.704146, 2.951668, -0.668791>, <-1.725694, 2.988989, -0.683100>, <-1.657433, 2.870759, -0.739281>, <-1.655355, 2.867160, -0.784499>, 
      <-1.245777, 3.216307, -0.668791>, <-1.267325, 3.253628, -0.683100>, <-1.212188, 3.127822, -0.739281>, <-1.210110, 3.124223, -0.784499>, 
      <-0.529278, 3.408292, -0.668791>, <-0.529278, 3.451387, -0.683100>, <-0.514125, 3.314867, -0.739281>, <-0.514125, 3.310711, -0.784499>, 
      <0.000000, 3.408292, -0.668791>, <0.000000, 3.451387, -0.683100>, <0.000000, 3.314867, -0.739281>, <0.000000, 3.310711, -0.784499>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.951667, 1.704147, -0.668791>, <-2.988988, 1.725695, -0.683100>, <-2.870758, 1.657434, -0.739281>, <-2.867159, 1.655356, -0.784499>, 
      <-2.687028, 2.162515, -0.668791>, <-2.724349, 2.184063, -0.683100>, <-2.613696, 2.102679, -0.739281>, <-2.610096, 2.100601, -0.784499>, 
      <-2.162514, 2.687029, -0.668791>, <-2.184062, 2.724350, -0.683100>, <-2.102678, 2.613697, -0.739281>, <-2.100600, 2.610098, -0.784499>, 
      <-1.704146, 2.951668, -0.668791>, <-1.725694, 2.988989, -0.683100>, <-1.657433, 2.870759, -0.739281>, <-1.655355, 2.867160, -0.784499>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.408292, 0.000000, -0.668791>, <-3.451387, 0.000000, -0.683100>, <-3.314867, 0.000000, -0.739281>, <-3.310711, 0.000000, -0.784499>, 
      <-3.408292, 0.529279, -0.668791>, <-3.451387, 0.529279, -0.683100>, <-3.314867, 0.514125, -0.739281>, <-3.310711, 0.514125, -0.784499>, 
      <-3.216306, 1.245778, -0.668791>, <-3.253628, 1.267326, -0.683100>, <-3.127821, 1.212189, -0.739281>, <-3.124222, 1.210111, -0.784499>, 
      <-2.951667, 1.704147, -0.668791>, <-2.988988, 1.725695, -0.683100>, <-2.870758, 1.657434, -0.739281>, <-2.867159, 1.655356, -0.784499>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.951668, -1.704146, -0.668791>, <-2.988989, -1.725694, -0.683100>, <-2.870759, -1.657434, -0.739281>, <-2.867160, -1.655356, -0.784499>, 
      <-3.216307, -1.245777, -0.668791>, <-3.253629, -1.267325, -0.683100>, <-3.127822, -1.212188, -0.739281>, <-3.124223, -1.210111, -0.784499>, 
      <-3.408292, -0.529278, -0.668791>, <-3.451388, -0.529278, -0.683100>, <-3.314867, -0.514125, -0.739281>, <-3.310711, -0.514125, -0.784499>, 
      <-3.408292, 0.000000, -0.668791>, <-3.451387, 0.000000, -0.683100>, <-3.314867, 0.000000, -0.739281>, <-3.310711, 0.000000, -0.784499>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.704146, -2.951667, -0.668791>, <-1.725693, -2.988988, -0.683100>, <-1.657434, -2.870759, -0.739281>, <-1.655356, -2.867160, -0.784499>, 
      <-2.162515, -2.687028, -0.668791>, <-2.184062, -2.724349, -0.683100>, <-2.102679, -2.613697, -0.739281>, <-2.100601, -2.610098, -0.784499>, 
      <-2.687029, -2.162515, -0.668791>, <-2.724350, -2.184062, -0.683100>, <-2.613697, -2.102679, -0.739281>, <-2.610098, -2.100601, -0.784499>, 
      <-2.951668, -1.704146, -0.668791>, <-2.988989, -1.725694, -0.683100>, <-2.870759, -1.657434, -0.739281>, <-2.867160, -1.655356, -0.784499>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.408292, -0.668791>, <0.000000, -3.451387, -0.683100>, <0.000000, -3.314867, -0.739281>, <0.000000, -3.310711, -0.784499>, 
      <-0.529279, -3.408292, -0.668791>, <-0.529279, -3.451387, -0.683100>, <-0.514125, -3.314867, -0.739281>, <-0.514125, -3.310711, -0.784499>, 
      <-1.245777, -3.216306, -0.668791>, <-1.267325, -3.253628, -0.683100>, <-1.212188, -3.127822, -0.739281>, <-1.210111, -3.124223, -0.784499>, 
      <-1.704146, -2.951667, -0.668791>, <-1.725693, -2.988988, -0.683100>, <-1.657434, -2.870759, -0.739281>, <-1.655356, -2.867160, -0.784499>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.704146, -2.951668, -0.668791>, <1.725693, -2.988990, -0.683100>, <1.657433, -2.870759, -0.739281>, <1.655355, -2.867160, -0.784499>, 
      <1.245777, -3.216307, -0.668791>, <1.267325, -3.253629, -0.683100>, <1.212188, -3.127822, -0.739281>, <1.210110, -3.124223, -0.784499>, 
      <0.529278, -3.408292, -0.668791>, <0.529278, -3.451388, -0.683100>, <0.514125, -3.314867, -0.739281>, <0.514125, -3.310711, -0.784499>, 
      <0.000000, -3.408292, -0.668791>, <0.000000, -3.451387, -0.683100>, <0.000000, -3.314867, -0.739281>, <0.000000, -3.310711, -0.784499>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.951667, -1.704146, -0.668791>, <2.988989, -1.725693, -0.683100>, <2.870759, -1.657433, -0.739281>, <2.867160, -1.655355, -0.784499>, 
      <2.687028, -2.162515, -0.668791>, <2.724349, -2.184062, -0.683100>, <2.613697, -2.102679, -0.739281>, <2.610097, -2.100601, -0.784499>, 
      <2.162515, -2.687029, -0.668791>, <2.184062, -2.724350, -0.683100>, <2.102679, -2.613697, -0.739281>, <2.100601, -2.610097, -0.784499>, 
      <1.704146, -2.951668, -0.668791>, <1.725693, -2.988990, -0.683100>, <1.657433, -2.870759, -0.739281>, <1.655355, -2.867160, -0.784499>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.568308, 2.716389, -0.726692>, <1.582474, 2.740925, -0.648322>, <1.664602, 2.883176, -0.642531>, <1.704146, 2.951668, -0.668791>, 
      <1.990140, 2.472844, -0.726692>, <2.004306, 2.497380, -0.648322>, <2.122971, 2.618536, -0.642531>, <2.162515, 2.687028, -0.668791>, 
      <2.472844, 1.990139, -0.726692>, <2.497380, 2.004305, -0.648322>, <2.618536, 2.122971, -0.642531>, <2.687028, 2.162514, -0.668791>, 
      <2.716389, 1.568307, -0.726692>, <2.740925, 1.582473, -0.648322>, <2.883176, 1.664601, -0.642531>, <2.951668, 1.704145, -0.668791>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.136615, -0.726692>, <0.000000, 3.164947, -0.648322>, <0.000000, 3.329204, -0.642531>, <0.000000, 3.408292, -0.668791>, 
      <0.487090, 3.136615, -0.726692>, <0.487090, 3.164947, -0.648322>, <0.529278, 3.329204, -0.642531>, <0.529278, 3.408292, -0.668791>, 
      <1.146476, 2.959934, -0.726692>, <1.160642, 2.984470, -0.648322>, <1.206234, 3.147815, -0.642531>, <1.245778, 3.216307, -0.668791>, 
      <1.568308, 2.716389, -0.726692>, <1.582474, 2.740925, -0.648322>, <1.664602, 2.883176, -0.642531>, <1.704146, 2.951668, -0.668791>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.568307, 2.716389, -0.726692>, <-1.582473, 2.740925, -0.648322>, <-1.664602, 2.883176, -0.642531>, <-1.704146, 2.951668, -0.668791>, 
      <-1.146475, 2.959934, -0.726692>, <-1.160641, 2.984469, -0.648322>, <-1.206234, 3.147815, -0.642531>, <-1.245777, 3.216307, -0.668791>, 
      <-0.487089, 3.136615, -0.726692>, <-0.487089, 3.164947, -0.648322>, <-0.529278, 3.329204, -0.642531>, <-0.529278, 3.408292, -0.668791>, 
      <0.000000, 3.136615, -0.726692>, <0.000000, 3.164947, -0.648322>, <0.000000, 3.329204, -0.642531>, <0.000000, 3.408292, -0.668791>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.716388, 1.568308, -0.726692>, <-2.740924, 1.582474, -0.648322>, <-2.883175, 1.664603, -0.642531>, <-2.951667, 1.704147, -0.668791>, 
      <-2.472843, 1.990140, -0.726692>, <-2.497379, 2.004306, -0.648322>, <-2.618536, 2.122971, -0.642531>, <-2.687028, 2.162515, -0.668791>, 
      <-1.990139, 2.472844, -0.726692>, <-2.004305, 2.497380, -0.648322>, <-2.122971, 2.618537, -0.642531>, <-2.162514, 2.687029, -0.668791>, 
      <-1.568307, 2.716389, -0.726692>, <-1.582473, 2.740925, -0.648322>, <-1.664602, 2.883176, -0.642531>, <-1.704146, 2.951668, -0.668791>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.136615, 0.000000, -0.726692>, <-3.164947, 0.000000, -0.648322>, <-3.329204, 0.000000, -0.642531>, <-3.408292, 0.000000, -0.668791>, 
      <-3.136615, 0.487090, -0.726692>, <-3.164946, 0.487090, -0.648322>, <-3.329204, 0.529279, -0.642531>, <-3.408292, 0.529279, -0.668791>, 
      <-2.959933, 1.146476, -0.726692>, <-2.984468, 1.160642, -0.648322>, <-3.147815, 1.206234, -0.642531>, <-3.216306, 1.245778, -0.668791>, 
      <-2.716388, 1.568308, -0.726692>, <-2.740924, 1.582474, -0.648322>, <-2.883175, 1.664603, -0.642531>, <-2.951667, 1.704147, -0.668791>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.716389, -1.568308, -0.726692>, <-2.740925, -1.582474, -0.648322>, <-2.883176, -1.664602, -0.642531>, <-2.951668, -1.704146, -0.668791>, 
      <-2.959934, -1.146476, -0.726692>, <-2.984470, -1.160642, -0.648322>, <-3.147815, -1.206233, -0.642531>, <-3.216307, -1.245777, -0.668791>, 
      <-3.136615, -0.487090, -0.726692>, <-3.164947, -0.487090, -0.648322>, <-3.329205, -0.529278, -0.642531>, <-3.408292, -0.529278, -0.668791>, 
      <-3.136615, 0.000000, -0.726692>, <-3.164947, 0.000000, -0.648322>, <-3.329204, 0.000000, -0.642531>, <-3.408292, 0.000000, -0.668791>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.568308, -2.716388, -0.726692>, <-1.582474, -2.740924, -0.648322>, <-1.664602, -2.883175, -0.642531>, <-1.704146, -2.951667, -0.668791>, 
      <-1.990140, -2.472843, -0.726692>, <-2.004305, -2.497379, -0.648322>, <-2.122971, -2.618536, -0.642531>, <-2.162515, -2.687028, -0.668791>, 
      <-2.472844, -1.990140, -0.726692>, <-2.497380, -2.004305, -0.648322>, <-2.618537, -2.122971, -0.642531>, <-2.687029, -2.162515, -0.668791>, 
      <-2.716389, -1.568308, -0.726692>, <-2.740925, -1.582474, -0.648322>, <-2.883176, -1.664602, -0.642531>, <-2.951668, -1.704146, -0.668791>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.136615, -0.726692>, <0.000000, -3.164947, -0.648322>, <0.000000, -3.329204, -0.642531>, <0.000000, -3.408292, -0.668791>, 
      <-0.487090, -3.136615, -0.726692>, <-0.487090, -3.164946, -0.648322>, <-0.529279, -3.329204, -0.642531>, <-0.529279, -3.408292, -0.668791>, 
      <-1.146476, -2.959933, -0.726692>, <-1.160642, -2.984468, -0.648322>, <-1.206234, -3.147814, -0.642531>, <-1.245777, -3.216306, -0.668791>, 
      <-1.568308, -2.716388, -0.726692>, <-1.582474, -2.740924, -0.648322>, <-1.664602, -2.883175, -0.642531>, <-1.704146, -2.951667, -0.668791>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.568308, -2.716389, -0.726692>, <1.582474, -2.740925, -0.648322>, <1.664603, -2.883176, -0.642531>, <1.704146, -2.951668, -0.668791>, 
      <1.146476, -2.959934, -0.726692>, <1.160642, -2.984470, -0.648322>, <1.206234, -3.147815, -0.642531>, <1.245777, -3.216307, -0.668791>, 
      <0.487090, -3.136615, -0.726692>, <0.487090, -3.164947, -0.648322>, <0.529278, -3.329205, -0.642531>, <0.529278, -3.408292, -0.668791>, 
      <0.000000, -3.136615, -0.726692>, <0.000000, -3.164947, -0.648322>, <0.000000, -3.329204, -0.642531>, <0.000000, -3.408292, -0.668791>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.716388, -1.568308, -0.726692>, <2.740924, -1.582474, -0.648322>, <2.883175, -1.664603, -0.642531>, <2.951667, -1.704146, -0.668791>, 
      <2.472843, -1.990140, -0.726692>, <2.497379, -2.004305, -0.648322>, <2.618536, -2.122971, -0.642531>, <2.687028, -2.162515, -0.668791>, 
      <1.990140, -2.472844, -0.726692>, <2.004305, -2.497380, -0.648322>, <2.122971, -2.618536, -0.642531>, <2.162515, -2.687029, -0.668791>, 
      <1.568308, -2.716389, -0.726692>, <1.582474, -2.740925, -0.648322>, <1.664603, -2.883176, -0.642531>, <1.704146, -2.951668, -0.668791>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.606282, 2.782162, -1.210209>, <1.575267, 2.728442, -1.077121>, <1.543348, 2.673157, -0.864779>, <1.568308, 2.716389, -0.726692>, 
      <2.038328, 2.532720, -1.210209>, <2.007313, 2.479000, -1.077121>, <1.965180, 2.429612, -0.864779>, <1.990140, 2.472844, -0.726692>, 
      <2.532721, 2.038327, -1.210209>, <2.479001, 2.007312, -1.077121>, <2.429612, 1.965179, -0.864779>, <2.472844, 1.990139, -0.726692>, 
      <2.782163, 1.606281, -1.210209>, <2.728443, 1.575266, -1.077121>, <2.673157, 1.543347, -0.864779>, <2.716389, 1.568307, -0.726692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.212564, -1.210209>, <0.000000, 3.150534, -1.077121>, <0.000000, 3.086695, -0.864779>, <0.000000, 3.136615, -0.726692>, 
      <0.498884, 3.212564, -1.210209>, <0.498884, 3.150534, -1.077121>, <0.487090, 3.086695, -0.864779>, <0.487090, 3.136615, -0.726692>, 
      <1.174236, 3.031604, -1.210209>, <1.143221, 2.977884, -1.077121>, <1.121516, 2.916702, -0.864779>, <1.146476, 2.959934, -0.726692>, 
      <1.606282, 2.782162, -1.210209>, <1.575267, 2.728442, -1.077121>, <1.543348, 2.673157, -0.864779>, <1.568308, 2.716389, -0.726692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.606282, 2.782162, -1.210209>, <-1.575267, 2.728442, -1.077121>, <-1.543347, 2.673157, -0.864779>, <-1.568307, 2.716389, -0.726692>, 
      <-1.174236, 3.031604, -1.210209>, <-1.143221, 2.977884, -1.077121>, <-1.121515, 2.916701, -0.864779>, <-1.146475, 2.959934, -0.726692>, 
      <-0.498884, 3.212564, -1.210209>, <-0.498884, 3.150534, -1.077121>, <-0.487089, 3.086695, -0.864779>, <-0.487089, 3.136615, -0.726692>, 
      <0.000000, 3.212564, -1.210209>, <0.000000, 3.150534, -1.077121>, <0.000000, 3.086695, -0.864779>, <0.000000, 3.136615, -0.726692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.782162, 1.606283, -1.210209>, <-2.728442, 1.575268, -1.077121>, <-2.673156, 1.543348, -0.864779>, <-2.716388, 1.568308, -0.726692>, 
      <-2.532720, 2.038329, -1.210209>, <-2.479001, 2.007314, -1.077121>, <-2.429611, 1.965180, -0.864779>, <-2.472843, 1.990140, -0.726692>, 
      <-2.038328, 2.532720, -1.210209>, <-2.007313, 2.479001, -1.077121>, <-1.965179, 2.429612, -0.864779>, <-1.990139, 2.472844, -0.726692>, 
      <-1.606282, 2.782162, -1.210209>, <-1.575267, 2.728442, -1.077121>, <-1.543347, 2.673157, -0.864779>, <-1.568307, 2.716389, -0.726692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.212564, 0.000000, -1.210209>, <-3.150534, 0.000000, -1.077121>, <-3.086695, 0.000000, -0.864779>, <-3.136615, 0.000000, -0.726692>, 
      <-3.212564, 0.498884, -1.210209>, <-3.150534, 0.498884, -1.077121>, <-3.086695, 0.487090, -0.864779>, <-3.136615, 0.487090, -0.726692>, 
      <-3.031604, 1.174237, -1.210209>, <-2.977884, 1.143222, -1.077121>, <-2.916701, 1.121516, -0.864779>, <-2.959933, 1.146476, -0.726692>, 
      <-2.782162, 1.606283, -1.210209>, <-2.728442, 1.575268, -1.077121>, <-2.673156, 1.543348, -0.864779>, <-2.716388, 1.568308, -0.726692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.782162, -1.606282, -1.210209>, <-2.728442, -1.575267, -1.077121>, <-2.673157, -1.543348, -0.864779>, <-2.716389, -1.568308, -0.726692>, 
      <-3.031604, -1.174236, -1.210209>, <-2.977884, -1.143221, -1.077121>, <-2.916702, -1.121516, -0.864779>, <-2.959934, -1.146476, -0.726692>, 
      <-3.212564, -0.498884, -1.210209>, <-3.150534, -0.498884, -1.077121>, <-3.086695, -0.487090, -0.864779>, <-3.136615, -0.487090, -0.726692>, 
      <-3.212564, 0.000000, -1.210209>, <-3.150534, 0.000000, -1.077121>, <-3.086695, 0.000000, -0.864779>, <-3.136615, 0.000000, -0.726692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.606282, -2.782162, -1.210209>, <-1.575267, -2.728442, -1.077121>, <-1.543348, -2.673156, -0.864779>, <-1.568308, -2.716388, -0.726692>, 
      <-2.038328, -2.532720, -1.210209>, <-2.007313, -2.479000, -1.077121>, <-1.965180, -2.429611, -0.864779>, <-1.990140, -2.472843, -0.726692>, 
      <-2.532720, -2.038328, -1.210209>, <-2.479001, -2.007313, -1.077121>, <-2.429612, -1.965180, -0.864779>, <-2.472844, -1.990140, -0.726692>, 
      <-2.782162, -1.606282, -1.210209>, <-2.728442, -1.575267, -1.077121>, <-2.673157, -1.543348, -0.864779>, <-2.716389, -1.568308, -0.726692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.212564, -1.210209>, <0.000000, -3.150534, -1.077121>, <0.000000, -3.086695, -0.864779>, <0.000000, -3.136615, -0.726692>, 
      <-0.498884, -3.212564, -1.210209>, <-0.498884, -3.150534, -1.077121>, <-0.487090, -3.086695, -0.864779>, <-0.487090, -3.136615, -0.726692>, 
      <-1.174236, -3.031604, -1.210209>, <-1.143221, -2.977884, -1.077121>, <-1.121516, -2.916701, -0.864779>, <-1.146476, -2.959933, -0.726692>, 
      <-1.606282, -2.782162, -1.210209>, <-1.575267, -2.728442, -1.077121>, <-1.543348, -2.673156, -0.864779>, <-1.568308, -2.716388, -0.726692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.606282, -2.782162, -1.210209>, <1.575267, -2.728442, -1.077121>, <1.543348, -2.673157, -0.864779>, <1.568308, -2.716389, -0.726692>, 
      <1.174236, -3.031604, -1.210209>, <1.143221, -2.977884, -1.077121>, <1.121516, -2.916702, -0.864779>, <1.146476, -2.959934, -0.726692>, 
      <0.498884, -3.212564, -1.210209>, <0.498884, -3.150534, -1.077121>, <0.487090, -3.086695, -0.864779>, <0.487090, -3.136615, -0.726692>, 
      <0.000000, -3.212564, -1.210209>, <0.000000, -3.150534, -1.077121>, <0.000000, -3.086695, -0.864779>, <0.000000, -3.136615, -0.726692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.782162, -1.606282, -1.210209>, <2.728442, -1.575267, -1.077121>, <2.673156, -1.543348, -0.864779>, <2.716388, -1.568308, -0.726692>, 
      <2.532720, -2.038328, -1.210209>, <2.479000, -2.007313, -1.077121>, <2.429611, -1.965180, -0.864779>, <2.472843, -1.990140, -0.726692>, 
      <2.038328, -2.532720, -1.210209>, <2.007313, -2.479001, -1.077121>, <1.965180, -2.429612, -0.864779>, <1.990140, -2.472844, -0.726692>, 
      <1.606282, -2.782162, -1.210209>, <1.575267, -2.728442, -1.077121>, <1.543348, -2.673157, -0.864779>, <1.568308, -2.716389, -0.726692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.770651, 3.066856, -1.594960>, <1.726766, 2.990845, -1.471083>, <1.638350, 2.837705, -1.347816>, <1.606282, 2.782162, -1.210209>, 
      <2.246908, 2.791889, -1.594960>, <2.203022, 2.715878, -1.471083>, <2.070396, 2.588263, -1.347816>, <2.038328, 2.532720, -1.210209>, 
      <2.791890, 2.246906, -1.594960>, <2.715879, 2.203021, -1.471083>, <2.588264, 2.070395, -1.347816>, <2.532721, 2.038327, -1.210209>, 
      <3.066857, 1.770649, -1.594960>, <2.990846, 1.726764, -1.471083>, <2.837707, 1.638349, -1.347816>, <2.782163, 1.606281, -1.210209>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.541301, -1.594960>, <0.000000, 3.453531, -1.471083>, <0.000000, 3.276700, -1.347816>, <0.000000, 3.212564, -1.210209>, 
      <0.549934, 3.541301, -1.594960>, <0.549934, 3.453531, -1.471083>, <0.498884, 3.276700, -1.347816>, <0.498884, 3.212564, -1.210209>, 
      <1.294394, 3.341823, -1.594960>, <1.250509, 3.265812, -1.471083>, <1.206304, 3.087147, -1.347816>, <1.174236, 3.031604, -1.210209>, 
      <1.770651, 3.066856, -1.594960>, <1.726766, 2.990845, -1.471083>, <1.638350, 2.837705, -1.347816>, <1.606282, 2.782162, -1.210209>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.770650, 3.066856, -1.594960>, <-1.726765, 2.990845, -1.471083>, <-1.638350, 2.837705, -1.347816>, <-1.606282, 2.782162, -1.210209>, 
      <-1.294394, 3.341823, -1.594960>, <-1.250509, 3.265812, -1.471083>, <-1.206304, 3.087147, -1.347816>, <-1.174236, 3.031604, -1.210209>, 
      <-0.549934, 3.541301, -1.594960>, <-0.549934, 3.453531, -1.471083>, <-0.498884, 3.276700, -1.347816>, <-0.498884, 3.212564, -1.210209>, 
      <0.000000, 3.541301, -1.594960>, <0.000000, 3.453531, -1.471083>, <0.000000, 3.276700, -1.347816>, <0.000000, 3.212564, -1.210209>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.066856, 1.770651, -1.594960>, <-2.990845, 1.726766, -1.471083>, <-2.837706, 1.638351, -1.347816>, <-2.782162, 1.606283, -1.210209>, 
      <-2.791889, 2.246907, -1.594960>, <-2.715878, 2.203022, -1.471083>, <-2.588264, 2.070397, -1.347816>, <-2.532720, 2.038329, -1.210209>, 
      <-2.246906, 2.791889, -1.594960>, <-2.203022, 2.715878, -1.471083>, <-2.070396, 2.588264, -1.347816>, <-2.038328, 2.532720, -1.210209>, 
      <-1.770650, 3.066856, -1.594960>, <-1.726765, 2.990845, -1.471083>, <-1.638350, 2.837705, -1.347816>, <-1.606282, 2.782162, -1.210209>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.541301, 0.000000, -1.594960>, <-3.453531, 0.000000, -1.471083>, <-3.276700, 0.000000, -1.347816>, <-3.212564, 0.000000, -1.210209>, 
      <-3.541301, 0.549934, -1.594960>, <-3.453531, 0.549934, -1.471083>, <-3.276700, 0.498884, -1.347816>, <-3.212564, 0.498884, -1.210209>, 
      <-3.341823, 1.294394, -1.594960>, <-3.265812, 1.250509, -1.471083>, <-3.087148, 1.206305, -1.347816>, <-3.031604, 1.174237, -1.210209>, 
      <-3.066856, 1.770651, -1.594960>, <-2.990845, 1.726766, -1.471083>, <-2.837706, 1.638351, -1.347816>, <-2.782162, 1.606283, -1.210209>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.066856, -1.770651, -1.594960>, <-2.990845, -1.726766, -1.471083>, <-2.837705, -1.638350, -1.347816>, <-2.782162, -1.606282, -1.210209>, 
      <-3.341823, -1.294394, -1.594960>, <-3.265812, -1.250509, -1.471083>, <-3.087147, -1.206304, -1.347816>, <-3.031604, -1.174236, -1.210209>, 
      <-3.541301, -0.549934, -1.594960>, <-3.453531, -0.549934, -1.471083>, <-3.276700, -0.498884, -1.347816>, <-3.212564, -0.498884, -1.210209>, 
      <-3.541301, 0.000000, -1.594960>, <-3.453531, 0.000000, -1.471083>, <-3.276700, 0.000000, -1.347816>, <-3.212564, 0.000000, -1.210209>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.770651, -3.066856, -1.594960>, <-1.726766, -2.990845, -1.471083>, <-1.638350, -2.837706, -1.347816>, <-1.606282, -2.782162, -1.210209>, 
      <-2.246907, -2.791889, -1.594960>, <-2.203022, -2.715878, -1.471083>, <-2.070396, -2.588264, -1.347816>, <-2.038328, -2.532720, -1.210209>, 
      <-2.791889, -2.246907, -1.594960>, <-2.715878, -2.203022, -1.471083>, <-2.588264, -2.070396, -1.347816>, <-2.532720, -2.038328, -1.210209>, 
      <-3.066856, -1.770651, -1.594960>, <-2.990845, -1.726766, -1.471083>, <-2.837705, -1.638350, -1.347816>, <-2.782162, -1.606282, -1.210209>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.541301, -1.594960>, <0.000000, -3.453531, -1.471083>, <0.000000, -3.276700, -1.347816>, <0.000000, -3.212564, -1.210209>, 
      <-0.549934, -3.541301, -1.594960>, <-0.549934, -3.453531, -1.471083>, <-0.498884, -3.276700, -1.347816>, <-0.498884, -3.212564, -1.210209>, 
      <-1.294394, -3.341823, -1.594960>, <-1.250509, -3.265812, -1.471083>, <-1.206304, -3.087147, -1.347816>, <-1.174236, -3.031604, -1.210209>, 
      <-1.770651, -3.066856, -1.594960>, <-1.726766, -2.990845, -1.471083>, <-1.638350, -2.837706, -1.347816>, <-1.606282, -2.782162, -1.210209>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.770650, -3.066856, -1.594960>, <1.726765, -2.990845, -1.471083>, <1.638350, -2.837705, -1.347816>, <1.606282, -2.782162, -1.210209>, 
      <1.294394, -3.341823, -1.594960>, <1.250509, -3.265812, -1.471083>, <1.206304, -3.087147, -1.347816>, <1.174236, -3.031604, -1.210209>, 
      <0.549934, -3.541301, -1.594960>, <0.549934, -3.453531, -1.471083>, <0.498884, -3.276700, -1.347816>, <0.498884, -3.212564, -1.210209>, 
      <0.000000, -3.541301, -1.594960>, <0.000000, -3.453531, -1.471083>, <0.000000, -3.276700, -1.347816>, <0.000000, -3.212564, -1.210209>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.066856, -1.770650, -1.594960>, <2.990845, -1.726765, -1.471083>, <2.837706, -1.638350, -1.347816>, <2.782162, -1.606282, -1.210209>, 
      <2.791889, -2.246906, -1.594960>, <2.715878, -2.203021, -1.471083>, <2.588264, -2.070396, -1.347816>, <2.532720, -2.038328, -1.210209>, 
      <2.246906, -2.791889, -1.594960>, <2.203022, -2.715878, -1.471083>, <2.070396, -2.588264, -1.347816>, <2.038328, -2.532720, -1.210209>, 
      <1.770650, -3.066856, -1.594960>, <1.726765, -2.990845, -1.471083>, <1.638350, -2.837705, -1.347816>, <1.606282, -2.782162, -1.210209>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.838287, 3.184006, -1.865104>, <1.837611, 3.182834, -1.774478>, <1.796850, 3.112234, -1.668915>, <1.770651, 3.066856, -1.594960>, 
      <2.332736, 2.898536, -1.865104>, <2.332060, 2.897364, -1.774478>, <2.273107, 2.837267, -1.668915>, <2.246908, 2.791889, -1.594960>, 
      <2.898536, 2.332735, -1.865104>, <2.897364, 2.332059, -1.774478>, <2.837269, 2.273105, -1.668914>, <2.791890, 2.246906, -1.594960>, 
      <3.184006, 1.838286, -1.865104>, <3.182834, 1.837610, -1.774478>, <3.112236, 1.796848, -1.668914>, <3.066857, 1.770649, -1.594960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.676573, -1.865104>, <0.000000, 3.675220, -1.774478>, <0.000000, 3.593700, -1.668914>, <0.000000, 3.541301, -1.594960>, 
      <0.570940, 3.676573, -1.865104>, <0.570940, 3.675220, -1.774478>, <0.549934, 3.593700, -1.668914>, <0.549934, 3.541301, -1.594960>, 
      <1.343838, 3.469476, -1.865104>, <1.343162, 3.468305, -1.774478>, <1.320594, 3.387202, -1.668915>, <1.294394, 3.341823, -1.594960>, 
      <1.838287, 3.184006, -1.865104>, <1.837611, 3.182834, -1.774478>, <1.796850, 3.112234, -1.668915>, <1.770651, 3.066856, -1.594960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.838286, 3.184006, -1.865104>, <-1.837610, 3.182834, -1.774478>, <-1.796849, 3.112235, -1.668915>, <-1.770650, 3.066856, -1.594960>, 
      <-1.343837, 3.469476, -1.865104>, <-1.343161, 3.468304, -1.774478>, <-1.320593, 3.387201, -1.668915>, <-1.294394, 3.341823, -1.594960>, 
      <-0.570940, 3.676573, -1.865104>, <-0.570940, 3.675220, -1.774478>, <-0.549934, 3.593700, -1.668914>, <-0.549934, 3.541301, -1.594960>, 
      <0.000000, 3.676573, -1.865104>, <0.000000, 3.675220, -1.774478>, <0.000000, 3.593700, -1.668914>, <0.000000, 3.541301, -1.594960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.184005, 1.838287, -1.865104>, <-3.182833, 1.837611, -1.774478>, <-3.112234, 1.796850, -1.668914>, <-3.066856, 1.770651, -1.594960>, 
      <-2.898535, 2.332736, -1.865104>, <-2.897363, 2.332059, -1.774478>, <-2.837268, 2.273107, -1.668914>, <-2.791889, 2.246907, -1.594960>, 
      <-2.332735, 2.898536, -1.865104>, <-2.332058, 2.897364, -1.774478>, <-2.273106, 2.837268, -1.668915>, <-2.246906, 2.791889, -1.594960>, 
      <-1.838286, 3.184006, -1.865104>, <-1.837610, 3.182834, -1.774478>, <-1.796849, 3.112235, -1.668915>, <-1.770650, 3.066856, -1.594960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.676573, 0.000000, -1.865104>, <-3.675220, 0.000000, -1.774478>, <-3.593700, 0.000000, -1.668914>, <-3.541301, 0.000000, -1.594960>, 
      <-3.676573, 0.570940, -1.865104>, <-3.675220, 0.570940, -1.774478>, <-3.593700, 0.549934, -1.668914>, <-3.541301, 0.549934, -1.594960>, 
      <-3.469475, 1.343838, -1.865104>, <-3.468304, 1.343162, -1.774478>, <-3.387201, 1.320594, -1.668914>, <-3.341823, 1.294394, -1.594960>, 
      <-3.184005, 1.838287, -1.865104>, <-3.182833, 1.837611, -1.774478>, <-3.112234, 1.796850, -1.668914>, <-3.066856, 1.770651, -1.594960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.184006, -1.838287, -1.865104>, <-3.182834, -1.837611, -1.774478>, <-3.112234, -1.796850, -1.668915>, <-3.066856, -1.770651, -1.594960>, 
      <-3.469476, -1.343838, -1.865104>, <-3.468305, -1.343162, -1.774478>, <-3.387201, -1.320594, -1.668915>, <-3.341823, -1.294394, -1.594960>, 
      <-3.676573, -0.570940, -1.865104>, <-3.675220, -0.570940, -1.774478>, <-3.593700, -0.549934, -1.668914>, <-3.541301, -0.549934, -1.594960>, 
      <-3.676573, 0.000000, -1.865104>, <-3.675220, 0.000000, -1.774478>, <-3.593700, 0.000000, -1.668914>, <-3.541301, 0.000000, -1.594960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.838287, -3.184005, -1.865104>, <-1.837611, -3.182833, -1.774478>, <-1.796850, -3.112234, -1.668914>, <-1.770651, -3.066856, -1.594960>, 
      <-2.332736, -2.898535, -1.865104>, <-2.332059, -2.897363, -1.774478>, <-2.273106, -2.837268, -1.668914>, <-2.246907, -2.791889, -1.594960>, 
      <-2.898536, -2.332736, -1.865104>, <-2.897364, -2.332059, -1.774478>, <-2.837268, -2.273106, -1.668915>, <-2.791889, -2.246907, -1.594960>, 
      <-3.184006, -1.838287, -1.865104>, <-3.182834, -1.837611, -1.774478>, <-3.112234, -1.796850, -1.668915>, <-3.066856, -1.770651, -1.594960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.676573, -1.865104>, <0.000000, -3.675220, -1.774478>, <0.000000, -3.593700, -1.668914>, <0.000000, -3.541301, -1.594960>, 
      <-0.570940, -3.676573, -1.865104>, <-0.570940, -3.675220, -1.774478>, <-0.549934, -3.593700, -1.668914>, <-0.549934, -3.541301, -1.594960>, 
      <-1.343838, -3.469475, -1.865104>, <-1.343162, -3.468304, -1.774478>, <-1.320594, -3.387201, -1.668914>, <-1.294394, -3.341823, -1.594960>, 
      <-1.838287, -3.184005, -1.865104>, <-1.837611, -3.182833, -1.774478>, <-1.796850, -3.112234, -1.668914>, <-1.770651, -3.066856, -1.594960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.838286, -3.184006, -1.865104>, <1.837610, -3.182834, -1.774478>, <1.796849, -3.112235, -1.668915>, <1.770650, -3.066856, -1.594960>, 
      <1.343837, -3.469476, -1.865104>, <1.343161, -3.468304, -1.774478>, <1.320593, -3.387202, -1.668915>, <1.294394, -3.341823, -1.594960>, 
      <0.570940, -3.676573, -1.865104>, <0.570940, -3.675220, -1.774478>, <0.549934, -3.593700, -1.668914>, <0.549934, -3.541301, -1.594960>, 
      <0.000000, -3.676573, -1.865104>, <0.000000, -3.675220, -1.774478>, <0.000000, -3.593700, -1.668914>, <0.000000, -3.541301, -1.594960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.184005, -1.838287, -1.865104>, <3.182833, -1.837611, -1.774478>, <3.112234, -1.796849, -1.668915>, <3.066856, -1.770650, -1.594960>, 
      <2.898535, -2.332736, -1.865104>, <2.897363, -2.332059, -1.774478>, <2.837267, -2.273106, -1.668915>, <2.791889, -2.246906, -1.594960>, 
      <2.332735, -2.898536, -1.865104>, <2.332058, -2.897364, -1.774478>, <2.273106, -2.837268, -1.668915>, <2.246906, -2.791889, -1.594960>, 
      <1.838286, -3.184006, -1.865104>, <1.837610, -3.182834, -1.774478>, <1.796849, -3.112235, -1.668915>, <1.770650, -3.066856, -1.594960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.828451, 3.166969, -9.339626>, <1.856852, 3.216161, -7.097981>, <1.855020, 3.212989, -4.107219>, <1.838287, 3.184006, -1.865104>, 
      <2.320254, 2.883026, -9.339626>, <2.348655, 2.932218, -7.097981>, <2.349469, 2.927519, -4.107219>, <2.332736, 2.898536, -1.865104>, 
      <2.883026, 2.320252, -9.339626>, <2.932218, 2.348653, -7.097981>, <2.927519, 2.349468, -4.107219>, <2.898536, 2.332735, -1.865104>, 
      <3.166969, 1.828449, -9.339626>, <3.216161, 1.856850, -7.097981>, <3.212989, 1.855019, -4.107219>, <3.184006, 1.838286, -1.865104>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.656900, -9.339626>, <0.000000, 3.713702, -7.097981>, <0.000000, 3.710039, -4.107219>, <0.000000, 3.676573, -1.865104>, 
      <0.567886, 3.656900, -9.339626>, <0.567886, 3.713702, -7.097981>, <0.570940, 3.710039, -4.107219>, <0.570940, 3.676573, -1.865104>, 
      <1.336648, 3.450912, -9.339626>, <1.365049, 3.500104, -7.097981>, <1.360572, 3.498460, -4.107219>, <1.343838, 3.469476, -1.865104>, 
      <1.828451, 3.166969, -9.339626>, <1.856852, 3.216161, -7.097981>, <1.855020, 3.212989, -4.107219>, <1.838287, 3.184006, -1.865104>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.828450, 3.166969, -9.339626>, <-1.856851, 3.216161, -7.097981>, <-1.855019, 3.212989, -4.107219>, <-1.838286, 3.184006, -1.865104>, 
      <-1.336647, 3.450912, -9.339626>, <-1.365048, 3.500103, -7.097981>, <-1.360571, 3.498459, -4.107219>, <-1.343837, 3.469476, -1.865104>, 
      <-0.567885, 3.656900, -9.339626>, <-0.567885, 3.713702, -7.097981>, <-0.570940, 3.710039, -4.107219>, <-0.570940, 3.676573, -1.865104>, 
      <0.000000, 3.656900, -9.339626>, <0.000000, 3.713702, -7.097981>, <0.000000, 3.710039, -4.107219>, <0.000000, 3.676573, -1.865104>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.166968, 1.828451, -9.339626>, <-3.216160, 1.856852, -7.097981>, <-3.212988, 1.855020, -4.107219>, <-3.184005, 1.838287, -1.865104>, 
      <-2.883026, 2.320254, -9.339626>, <-2.932217, 2.348655, -7.097981>, <-2.927518, 2.349469, -4.107219>, <-2.898535, 2.332736, -1.865104>, 
      <-2.320253, 2.883027, -9.339626>, <-2.348654, 2.932218, -7.097981>, <-2.349468, 2.927519, -4.107219>, <-2.332735, 2.898536, -1.865104>, 
      <-1.828450, 3.166969, -9.339626>, <-1.856851, 3.216161, -7.097981>, <-1.855019, 3.212989, -4.107219>, <-1.838286, 3.184006, -1.865104>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.656900, 0.000000, -9.339626>, <-3.713702, 0.000000, -7.097981>, <-3.710039, 0.000000, -4.107219>, <-3.676573, 0.000000, -1.865104>, 
      <-3.656900, 0.567886, -9.339626>, <-3.713701, 0.567886, -7.097981>, <-3.710039, 0.570940, -4.107219>, <-3.676573, 0.570940, -1.865104>, 
      <-3.450911, 1.336648, -9.339626>, <-3.500102, 1.365048, -7.097981>, <-3.498458, 1.360572, -4.107219>, <-3.469475, 1.343838, -1.865104>, 
      <-3.166968, 1.828451, -9.339626>, <-3.216160, 1.856852, -7.097981>, <-3.212988, 1.855020, -4.107219>, <-3.184005, 1.838287, -1.865104>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.166969, -1.828450, -9.339626>, <-3.216161, -1.856851, -7.097981>, <-3.212989, -1.855020, -4.107219>, <-3.184006, -1.838287, -1.865104>, 
      <-3.450912, -1.336647, -9.339626>, <-3.500103, -1.365048, -7.097981>, <-3.498460, -1.360571, -4.107219>, <-3.469476, -1.343838, -1.865104>, 
      <-3.656900, -0.567885, -9.339626>, <-3.713702, -0.567885, -7.097981>, <-3.710040, -0.570940, -4.107219>, <-3.676573, -0.570940, -1.865104>, 
      <-3.656900, 0.000000, -9.339626>, <-3.713702, 0.000000, -7.097981>, <-3.710039, 0.000000, -4.107219>, <-3.676573, 0.000000, -1.865104>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.828450, -3.166969, -9.339626>, <-1.856851, -3.216161, -7.097981>, <-1.855020, -3.212988, -4.107219>, <-1.838287, -3.184005, -1.865104>, 
      <-2.320253, -2.883026, -9.339626>, <-2.348654, -2.932218, -7.097981>, <-2.349469, -2.927518, -4.107219>, <-2.332736, -2.898535, -1.865104>, 
      <-2.883026, -2.320253, -9.339626>, <-2.932218, -2.348654, -7.097981>, <-2.927519, -2.349469, -4.107219>, <-2.898536, -2.332736, -1.865104>, 
      <-3.166969, -1.828450, -9.339626>, <-3.216161, -1.856851, -7.097981>, <-3.212989, -1.855020, -4.107219>, <-3.184006, -1.838287, -1.865104>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.656900, -9.339626>, <0.000000, -3.713702, -7.097981>, <0.000000, -3.710039, -4.107219>, <0.000000, -3.676573, -1.865104>, 
      <-0.567885, -3.656900, -9.339626>, <-0.567885, -3.713702, -7.097981>, <-0.570940, -3.710039, -4.107219>, <-0.570940, -3.676573, -1.865104>, 
      <-1.336647, -3.450912, -9.339626>, <-1.365048, -3.500103, -7.097981>, <-1.360571, -3.498459, -4.107219>, <-1.343838, -3.469475, -1.865104>, 
      <-1.828450, -3.166969, -9.339626>, <-1.856851, -3.216161, -7.097981>, <-1.855020, -3.212988, -4.107219>, <-1.838287, -3.184005, -1.865104>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.828450, -3.166969, -9.339626>, <1.856851, -3.216161, -7.097981>, <1.855019, -3.212989, -4.107219>, <1.838286, -3.184006, -1.865104>, 
      <1.336647, -3.450912, -9.339626>, <1.365048, -3.500103, -7.097981>, <1.360571, -3.498459, -4.107219>, <1.343837, -3.469476, -1.865104>, 
      <0.567885, -3.656900, -9.339626>, <0.567885, -3.713702, -7.097981>, <0.570940, -3.710040, -4.107219>, <0.570940, -3.676573, -1.865104>, 
      <0.000000, -3.656900, -9.339626>, <0.000000, -3.713702, -7.097981>, <0.000000, -3.710039, -4.107219>, <0.000000, -3.676573, -1.865104>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.166969, -1.828450, -9.339626>, <3.216161, -1.856851, -7.097981>, <3.212988, -1.855020, -4.107219>, <3.184005, -1.838287, -1.865104>, 
      <2.883026, -2.320253, -9.339626>, <2.932218, -2.348654, -7.097981>, <2.927518, -2.349469, -4.107219>, <2.898535, -2.332736, -1.865104>, 
      <2.320253, -2.883026, -9.339626>, <2.348654, -2.932218, -7.097981>, <2.349468, -2.927519, -4.107219>, <2.332735, -2.898536, -1.865104>, 
      <1.828450, -3.166969, -9.339626>, <1.856851, -3.216161, -7.097981>, <1.855019, -3.212989, -4.107219>, <1.838286, -3.184006, -1.865104>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.741881, 3.017027, -9.474288>, <1.767852, 3.062010, -9.433890>, <1.827618, 3.165525, -9.405407>, <1.828451, 3.166969, -9.339626>, 
      <2.210400, 2.746527, -9.474288>, <2.236371, 2.791510, -9.433890>, <2.319421, 2.881582, -9.405407>, <2.320254, 2.883026, -9.339626>, 
      <2.746527, 2.210399, -9.474288>, <2.791510, 2.236369, -9.433890>, <2.881583, 2.319419, -9.405407>, <2.883026, 2.320252, -9.339626>, 
      <3.017027, 1.741880, -9.474288>, <3.062010, 1.767851, -9.433890>, <3.165525, 1.827616, -9.405407>, <3.166969, 1.828449, -9.339626>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.483762, -9.474288>, <0.000000, 3.535704, -9.433890>, <0.000000, 3.655233, -9.405407>, <0.000000, 3.656900, -9.339626>, 
      <0.540998, 3.483762, -9.474288>, <0.540998, 3.535704, -9.433890>, <0.567886, 3.655233, -9.405407>, <0.567886, 3.656900, -9.339626>, 
      <1.273363, 3.287526, -9.474288>, <1.299334, 3.332509, -9.433890>, <1.335814, 3.449468, -9.405407>, <1.336648, 3.450912, -9.339626>, 
      <1.741881, 3.017027, -9.474288>, <1.767852, 3.062010, -9.433890>, <1.827618, 3.165525, -9.405407>, <1.828451, 3.166969, -9.339626>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.741881, 3.017027, -9.474288>, <-1.767852, 3.062010, -9.433890>, <-1.827617, 3.165525, -9.405407>, <-1.828450, 3.166969, -9.339626>, 
      <-1.273363, 3.287526, -9.474288>, <-1.299333, 3.332509, -9.433890>, <-1.335813, 3.449468, -9.405407>, <-1.336647, 3.450912, -9.339626>, 
      <-0.540998, 3.483762, -9.474288>, <-0.540998, 3.535704, -9.433890>, <-0.567885, 3.655233, -9.405407>, <-0.567885, 3.656900, -9.339626>, 
      <0.000000, 3.483762, -9.474288>, <0.000000, 3.535704, -9.433890>, <0.000000, 3.655233, -9.405407>, <0.000000, 3.656900, -9.339626>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.017026, 1.741882, -9.474288>, <-3.062009, 1.767853, -9.433890>, <-3.165524, 1.827618, -9.405407>, <-3.166968, 1.828451, -9.339626>, 
      <-2.746527, 2.210400, -9.474288>, <-2.791510, 2.236371, -9.433890>, <-2.881582, 2.319421, -9.405407>, <-2.883026, 2.320254, -9.339626>, 
      <-2.210399, 2.746528, -9.474288>, <-2.236370, 2.791511, -9.433890>, <-2.319419, 2.881583, -9.405407>, <-2.320253, 2.883027, -9.339626>, 
      <-1.741881, 3.017027, -9.474288>, <-1.767852, 3.062010, -9.433890>, <-1.827617, 3.165525, -9.405407>, <-1.828450, 3.166969, -9.339626>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.483762, 0.000000, -9.474288>, <-3.535704, 0.000000, -9.433890>, <-3.655233, 0.000000, -9.405407>, <-3.656900, 0.000000, -9.339626>, 
      <-3.483762, 0.540999, -9.474288>, <-3.535703, 0.540999, -9.433890>, <-3.655233, 0.567886, -9.405407>, <-3.656900, 0.567886, -9.339626>, 
      <-3.287525, 1.273363, -9.474288>, <-3.332508, 1.299334, -9.433890>, <-3.449467, 1.335814, -9.405407>, <-3.450911, 1.336648, -9.339626>, 
      <-3.017026, 1.741882, -9.474288>, <-3.062009, 1.767853, -9.433890>, <-3.165524, 1.827618, -9.405407>, <-3.166968, 1.828451, -9.339626>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.017027, -1.741881, -9.474288>, <-3.062010, -1.767852, -9.433890>, <-3.165525, -1.827617, -9.405407>, <-3.166969, -1.828450, -9.339626>, 
      <-3.287526, -1.273363, -9.474288>, <-3.332509, -1.299333, -9.433890>, <-3.449468, -1.335814, -9.405407>, <-3.450912, -1.336647, -9.339626>, 
      <-3.483762, -0.540998, -9.474288>, <-3.535704, -0.540998, -9.433890>, <-3.655233, -0.567885, -9.405407>, <-3.656900, -0.567885, -9.339626>, 
      <-3.483762, 0.000000, -9.474288>, <-3.535704, 0.000000, -9.433890>, <-3.655233, 0.000000, -9.405407>, <-3.656900, 0.000000, -9.339626>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.741881, -3.017027, -9.474288>, <-1.767852, -3.062010, -9.433890>, <-1.827617, -3.165525, -9.405407>, <-1.828450, -3.166969, -9.339626>, 
      <-2.210400, -2.746528, -9.474288>, <-2.236370, -2.791510, -9.433890>, <-2.319420, -2.881583, -9.405407>, <-2.320253, -2.883026, -9.339626>, 
      <-2.746528, -2.210400, -9.474288>, <-2.791510, -2.236370, -9.433890>, <-2.881583, -2.319420, -9.405407>, <-2.883026, -2.320253, -9.339626>, 
      <-3.017027, -1.741881, -9.474288>, <-3.062010, -1.767852, -9.433890>, <-3.165525, -1.827617, -9.405407>, <-3.166969, -1.828450, -9.339626>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.483762, -9.474288>, <0.000000, -3.535704, -9.433890>, <0.000000, -3.655233, -9.405407>, <0.000000, -3.656900, -9.339626>, 
      <-0.540998, -3.483762, -9.474288>, <-0.540998, -3.535704, -9.433890>, <-0.567885, -3.655233, -9.405407>, <-0.567885, -3.656900, -9.339626>, 
      <-1.273363, -3.287526, -9.474288>, <-1.299333, -3.332509, -9.433890>, <-1.335814, -3.449468, -9.405407>, <-1.336647, -3.450912, -9.339626>, 
      <-1.741881, -3.017027, -9.474288>, <-1.767852, -3.062010, -9.433890>, <-1.827617, -3.165525, -9.405407>, <-1.828450, -3.166969, -9.339626>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.741881, -3.017027, -9.474288>, <1.767852, -3.062010, -9.433890>, <1.827617, -3.165525, -9.405407>, <1.828450, -3.166969, -9.339626>, 
      <1.273363, -3.287526, -9.474288>, <1.299333, -3.332509, -9.433890>, <1.335814, -3.449468, -9.405407>, <1.336647, -3.450912, -9.339626>, 
      <0.540998, -3.483762, -9.474288>, <0.540998, -3.535704, -9.433890>, <0.567885, -3.655233, -9.405407>, <0.567885, -3.656900, -9.339626>, 
      <0.000000, -3.483762, -9.474288>, <0.000000, -3.535704, -9.433890>, <0.000000, -3.655233, -9.405407>, <0.000000, -3.656900, -9.339626>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.017027, -1.741881, -9.474288>, <3.062010, -1.767852, -9.433890>, <3.165525, -1.827617, -9.405407>, <3.166969, -1.828450, -9.339626>, 
      <2.746528, -2.210400, -9.474288>, <2.791510, -2.236370, -9.433890>, <2.881583, -2.319420, -9.405407>, <2.883026, -2.320253, -9.339626>, 
      <2.210400, -2.746528, -9.474288>, <2.236370, -2.791510, -9.433890>, <2.319420, -2.881583, -9.405407>, <2.320253, -2.883026, -9.339626>, 
      <1.741881, -3.017027, -9.474288>, <1.767852, -3.062010, -9.433890>, <1.827617, -3.165525, -9.405407>, <1.828450, -3.166969, -9.339626>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.008171, 0.014152, -9.474635>, <0.010369, 0.012883, -9.474635>, <0.012883, 0.010369, -9.474635>, <0.014152, 0.008171, -9.474635>, 
      <0.528284, 0.915014, -9.474531>, <0.530482, 0.913746, -9.474531>, <0.913746, 0.530481, -9.474531>, <0.915014, 0.528284, -9.474531>, 
      <1.221768, 2.116164, -9.474392>, <1.690287, 1.845665, -9.474392>, <1.845665, 1.690286, -9.474392>, <2.116164, 1.221767, -9.474392>, 
      <1.741881, 3.017027, -9.474288>, <2.210400, 2.746527, -9.474288>, <2.746527, 2.210399, -9.474288>, <3.017027, 1.741880, -9.474288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.016341, -9.474635>, <0.002538, 0.016341, -9.474635>, <0.005973, 0.015421, -9.474635>, <0.008171, 0.014152, -9.474635>, 
      <0.000000, 1.056567, -9.474531>, <0.002538, 1.056567, -9.474531>, <0.526086, 0.916283, -9.474531>, <0.528284, 0.915014, -9.474531>, 
      <0.000000, 2.443536, -9.474392>, <0.540998, 2.443536, -9.474392>, <0.753250, 2.386664, -9.474392>, <1.221768, 2.116164, -9.474392>, 
      <0.000000, 3.483762, -9.474288>, <0.540998, 3.483762, -9.474288>, <1.273363, 3.287526, -9.474288>, <1.741881, 3.017027, -9.474288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.008171, 0.014152, -9.474635>, <-0.005973, 0.015421, -9.474635>, <-0.002538, 0.016341, -9.474635>, <0.000000, 0.016341, -9.474635>, 
      <-0.528284, 0.915014, -9.474531>, <-0.526086, 0.916283, -9.474531>, <-0.002538, 1.056567, -9.474531>, <0.000000, 1.056567, -9.474531>, 
      <-1.221768, 2.116164, -9.474392>, <-0.753250, 2.386663, -9.474392>, <-0.540998, 2.443536, -9.474392>, <0.000000, 2.443536, -9.474392>, 
      <-1.741881, 3.017027, -9.474288>, <-1.273363, 3.287526, -9.474288>, <-0.540998, 3.483762, -9.474288>, <0.000000, 3.483762, -9.474288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.014152, 0.008171, -9.474635>, <-0.012883, 0.010369, -9.474635>, <-0.010369, 0.012883, -9.474635>, <-0.008171, 0.014152, -9.474635>, 
      <-0.915014, 0.528284, -9.474531>, <-0.913745, 0.530482, -9.474531>, <-0.530482, 0.913746, -9.474531>, <-0.528284, 0.915014, -9.474531>, 
      <-2.116164, 1.221769, -9.474392>, <-1.845665, 1.690287, -9.474392>, <-1.690286, 1.845665, -9.474392>, <-1.221768, 2.116164, -9.474392>, 
      <-3.017026, 1.741882, -9.474288>, <-2.746527, 2.210400, -9.474288>, <-2.210399, 2.746528, -9.474288>, <-1.741881, 3.017027, -9.474288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.016341, 0.000000, -9.474635>, <-0.016341, 0.002538, -9.474635>, <-0.015421, 0.005973, -9.474635>, <-0.014152, 0.008171, -9.474635>, 
      <-1.056567, 0.000000, -9.474531>, <-1.056567, 0.002538, -9.474531>, <-0.916283, 0.526087, -9.474531>, <-0.915014, 0.528284, -9.474531>, 
      <-2.443536, 0.000000, -9.474392>, <-2.443536, 0.540999, -9.474392>, <-2.386663, 0.753250, -9.474392>, <-2.116164, 1.221769, -9.474392>, 
      <-3.483762, 0.000000, -9.474288>, <-3.483762, 0.540999, -9.474288>, <-3.287525, 1.273363, -9.474288>, <-3.017026, 1.741882, -9.474288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.014152, -0.008171, -9.474635>, <-0.015421, -0.005973, -9.474635>, <-0.016341, -0.002538, -9.474635>, <-0.016341, 0.000000, -9.474635>, 
      <-0.915014, -0.528284, -9.474531>, <-0.916283, -0.526086, -9.474531>, <-1.056567, -0.002538, -9.474531>, <-1.056567, 0.000000, -9.474531>, 
      <-2.116164, -1.221768, -9.474392>, <-2.386664, -0.753250, -9.474392>, <-2.443536, -0.540998, -9.474392>, <-2.443536, 0.000000, -9.474392>, 
      <-3.017027, -1.741881, -9.474288>, <-3.287526, -1.273363, -9.474288>, <-3.483762, -0.540998, -9.474288>, <-3.483762, 0.000000, -9.474288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.008171, -0.014152, -9.474635>, <-0.010369, -0.012883, -9.474635>, <-0.012883, -0.010369, -9.474635>, <-0.014152, -0.008171, -9.474635>, 
      <-0.528284, -0.915014, -9.474531>, <-0.530482, -0.913746, -9.474531>, <-0.913746, -0.530482, -9.474531>, <-0.915014, -0.528284, -9.474531>, 
      <-1.221768, -2.116164, -9.474392>, <-1.690287, -1.845665, -9.474392>, <-1.845665, -1.690287, -9.474392>, <-2.116164, -1.221768, -9.474392>, 
      <-1.741881, -3.017027, -9.474288>, <-2.210400, -2.746528, -9.474288>, <-2.746528, -2.210400, -9.474288>, <-3.017027, -1.741881, -9.474288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.016341, -9.474635>, <-0.002538, -0.016341, -9.474635>, <-0.005973, -0.015421, -9.474635>, <-0.008171, -0.014152, -9.474635>, 
      <0.000000, -1.056567, -9.474531>, <-0.002538, -1.056567, -9.474531>, <-0.526086, -0.916283, -9.474531>, <-0.528284, -0.915014, -9.474531>, 
      <0.000000, -2.443536, -9.474392>, <-0.540998, -2.443536, -9.474392>, <-0.753250, -2.386664, -9.474392>, <-1.221768, -2.116164, -9.474392>, 
      <0.000000, -3.483762, -9.474288>, <-0.540998, -3.483762, -9.474288>, <-1.273363, -3.287526, -9.474288>, <-1.741881, -3.017027, -9.474288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.008171, -0.014152, -9.474635>, <0.005973, -0.015421, -9.474635>, <0.002538, -0.016341, -9.474635>, <0.000000, -0.016341, -9.474635>, 
      <0.528284, -0.915014, -9.474531>, <0.526086, -0.916283, -9.474531>, <0.002538, -1.056567, -9.474531>, <0.000000, -1.056567, -9.474531>, 
      <1.221768, -2.116164, -9.474392>, <0.753250, -2.386664, -9.474392>, <0.540998, -2.443536, -9.474392>, <0.000000, -2.443536, -9.474392>, 
      <1.741881, -3.017027, -9.474288>, <1.273363, -3.287526, -9.474288>, <0.540998, -3.483762, -9.474288>, <0.000000, -3.483762, -9.474288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.014152, -0.008171, -9.474635>, <0.012883, -0.010369, -9.474635>, <0.010369, -0.012883, -9.474635>, <0.008171, -0.014152, -9.474635>, 
      <0.915014, -0.528284, -9.474531>, <0.913746, -0.530482, -9.474531>, <0.530482, -0.913746, -9.474531>, <0.528284, -0.915014, -9.474531>, 
      <2.116164, -1.221768, -9.474392>, <1.845665, -1.690287, -9.474392>, <1.690287, -1.845665, -9.474392>, <1.221768, -2.116164, -9.474392>, 
      <3.017027, -1.741881, -9.474288>, <2.746528, -2.210400, -9.474288>, <2.210400, -2.746528, -9.474288>, <1.741881, -3.017027, -9.474288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.656900, 0.000000, -9.339626>, <3.656900, -0.567885, -9.339626>, <3.450912, -1.336647, -9.339626>, <3.166969, -1.828450, -9.339626>, 
      <3.655233, 0.000000, -9.405407>, <3.655233, -0.567885, -9.405407>, <3.449468, -1.335814, -9.405407>, <3.165525, -1.827617, -9.405407>, 
      <3.535704, 0.000000, -9.433890>, <3.535704, -0.540998, -9.433890>, <3.332509, -1.299333, -9.433890>, <3.062010, -1.767852, -9.433890>, 
      <3.483762, 0.000000, -9.474288>, <3.483762, -0.540998, -9.474288>, <3.287526, -1.273363, -9.474288>, <3.017027, -1.741881, -9.474288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.656900, 0.000000, -9.339626>, <3.656900, 0.567885, -9.339626>, <3.450911, 1.336646, -9.339626>, <3.166969, 1.828449, -9.339626>, 
      <3.655233, 0.000000, -9.405407>, <3.655233, 0.567885, -9.405407>, <3.449468, 1.335813, -9.405407>, <3.165525, 1.827616, -9.405407>, 
      <3.535704, 0.000000, -9.433890>, <3.535704, 0.540998, -9.433890>, <3.332509, 1.299333, -9.433890>, <3.062010, 1.767851, -9.433890>, 
      <3.483762, 0.000000, -9.474288>, <3.483762, 0.540998, -9.474288>, <3.287526, 1.273362, -9.474288>, <3.017027, 1.741880, -9.474288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.016341, 0.000000, -9.474635>, <0.016341, -0.002538, -9.474635>, <0.015421, -0.005973, -9.474635>, <0.014152, -0.008171, -9.474635>, 
      <1.056567, 0.000000, -9.474531>, <1.056567, -0.002538, -9.474531>, <0.916283, -0.526086, -9.474531>, <0.915014, -0.528284, -9.474531>, 
      <2.443536, 0.000000, -9.474392>, <2.443536, -0.540998, -9.474392>, <2.386664, -0.753250, -9.474392>, <2.116164, -1.221768, -9.474392>, 
      <3.483762, 0.000000, -9.474288>, <3.483762, -0.540998, -9.474288>, <3.287526, -1.273363, -9.474288>, <3.017027, -1.741881, -9.474288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.016341, 0.000000, -9.474635>, <1.056567, 0.000000, -9.474531>, <2.443536, 0.000000, -9.474392>, <3.483762, 0.000000, -9.474288>, 
      <0.016341, 0.002538, -9.474635>, <1.056567, 0.002538, -9.474531>, <2.443536, 0.540998, -9.474392>, <3.483762, 0.540998, -9.474288>, 
      <0.015421, 0.005973, -9.474635>, <0.916283, 0.526086, -9.474531>, <2.386663, 0.753249, -9.474392>, <3.287526, 1.273362, -9.474288>, 
      <0.014152, 0.008171, -9.474635>, <0.915014, 0.528284, -9.474531>, <2.116164, 1.221767, -9.474392>, <3.017027, 1.741880, -9.474288>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.676573, 0.000000, -1.865104>, <3.676573, -0.570940, -1.865104>, <3.469475, -1.343838, -1.865104>, <3.184005, -1.838287, -1.865104>, 
      <3.710039, 0.000000, -4.107219>, <3.710039, -0.570940, -4.107219>, <3.498459, -1.360571, -4.107219>, <3.212988, -1.855020, -4.107219>, 
      <3.713702, 0.000000, -7.097981>, <3.713702, -0.567885, -7.097981>, <3.500103, -1.365048, -7.097981>, <3.216161, -1.856851, -7.097981>, 
      <3.656900, 0.000000, -9.339626>, <3.656900, -0.567885, -9.339626>, <3.450912, -1.336647, -9.339626>, <3.166969, -1.828450, -9.339626>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.676573, 0.000000, -1.865104>, <3.710039, 0.000000, -4.107219>, <3.713702, 0.000000, -7.097981>, <3.656900, 0.000000, -9.339626>, 
      <3.676573, 0.570940, -1.865104>, <3.710040, 0.570940, -4.107219>, <3.713702, 0.567885, -7.097981>, <3.656900, 0.567885, -9.339626>, 
      <3.469476, 1.343837, -1.865104>, <3.498459, 1.360571, -4.107219>, <3.500103, 1.365047, -7.097981>, <3.450911, 1.336646, -9.339626>, 
      <3.184006, 1.838286, -1.865104>, <3.212989, 1.855019, -4.107219>, <3.216161, 1.856850, -7.097981>, <3.166969, 1.828449, -9.339626>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.541301, 0.000000, -1.594960>, <3.541301, -0.549934, -1.594960>, <3.341823, -1.294394, -1.594960>, <3.066856, -1.770650, -1.594960>, 
      <3.593700, 0.000000, -1.668914>, <3.593699, -0.549934, -1.668914>, <3.387201, -1.320593, -1.668915>, <3.112234, -1.796849, -1.668915>, 
      <3.675220, 0.000000, -1.774478>, <3.675220, -0.570940, -1.774478>, <3.468304, -1.343162, -1.774478>, <3.182833, -1.837611, -1.774478>, 
      <3.676573, 0.000000, -1.865104>, <3.676573, -0.570940, -1.865104>, <3.469475, -1.343838, -1.865104>, <3.184005, -1.838287, -1.865104>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.541301, 0.000000, -1.594960>, <3.593700, 0.000000, -1.668914>, <3.675220, 0.000000, -1.774478>, <3.676573, 0.000000, -1.865104>, 
      <3.541301, 0.549933, -1.594960>, <3.593700, 0.549933, -1.668914>, <3.675220, 0.570940, -1.774478>, <3.676573, 0.570940, -1.865104>, 
      <3.341824, 1.294393, -1.594960>, <3.387202, 1.320592, -1.668914>, <3.468304, 1.343161, -1.774478>, <3.469476, 1.343837, -1.865104>, 
      <3.066857, 1.770649, -1.594960>, <3.112236, 1.796848, -1.668914>, <3.182834, 1.837610, -1.774478>, <3.184006, 1.838286, -1.865104>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.212564, 0.000000, -1.210209>, <3.212564, -0.498884, -1.210209>, <3.031604, -1.174236, -1.210209>, <2.782162, -1.606282, -1.210209>, 
      <3.276700, 0.000000, -1.347816>, <3.276700, -0.498884, -1.347816>, <3.087147, -1.206304, -1.347816>, <2.837706, -1.638350, -1.347816>, 
      <3.453531, 0.000000, -1.471083>, <3.453531, -0.549934, -1.471083>, <3.265812, -1.250508, -1.471083>, <2.990845, -1.726765, -1.471083>, 
      <3.541301, 0.000000, -1.594960>, <3.541301, -0.549934, -1.594960>, <3.341823, -1.294394, -1.594960>, <3.066856, -1.770650, -1.594960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.212564, 0.000000, -1.210209>, <3.276700, 0.000000, -1.347816>, <3.453531, 0.000000, -1.471083>, <3.541301, 0.000000, -1.594960>, 
      <3.212564, 0.498883, -1.210209>, <3.276700, 0.498883, -1.347816>, <3.453531, 0.549933, -1.471083>, <3.541301, 0.549933, -1.594960>, 
      <3.031605, 1.174235, -1.210209>, <3.087148, 1.206303, -1.347816>, <3.265813, 1.250508, -1.471083>, <3.341824, 1.294393, -1.594960>, 
      <2.782163, 1.606281, -1.210209>, <2.837707, 1.638349, -1.347816>, <2.990846, 1.726764, -1.471083>, <3.066857, 1.770649, -1.594960>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.136615, 0.000000, -0.726692>, <3.136615, -0.487090, -0.726692>, <2.959933, -1.146476, -0.726692>, <2.716388, -1.568308, -0.726692>, 
      <3.086695, 0.000000, -0.864779>, <3.086695, -0.487090, -0.864779>, <2.916701, -1.121516, -0.864779>, <2.673156, -1.543348, -0.864779>, 
      <3.150534, 0.000000, -1.077121>, <3.150534, -0.498884, -1.077121>, <2.977884, -1.143221, -1.077121>, <2.728442, -1.575267, -1.077121>, 
      <3.212564, 0.000000, -1.210209>, <3.212564, -0.498884, -1.210209>, <3.031604, -1.174236, -1.210209>, <2.782162, -1.606282, -1.210209>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.136615, 0.000000, -0.726692>, <3.086695, 0.000000, -0.864779>, <3.150534, 0.000000, -1.077121>, <3.212564, 0.000000, -1.210209>, 
      <3.136615, 0.487089, -0.726692>, <3.086695, 0.487089, -0.864779>, <3.150534, 0.498883, -1.077121>, <3.212564, 0.498883, -1.210209>, 
      <2.959934, 1.146475, -0.726692>, <2.916702, 1.121515, -0.864779>, <2.977885, 1.143220, -1.077121>, <3.031605, 1.174235, -1.210209>, 
      <2.716389, 1.568307, -0.726692>, <2.673157, 1.543347, -0.864779>, <2.728443, 1.575266, -1.077121>, <2.782163, 1.606281, -1.210209>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.408292, 0.000000, -0.668791>, <3.408292, -0.529279, -0.668791>, <3.216306, -1.245777, -0.668791>, <2.951667, -1.704146, -0.668791>, 
      <3.329204, 0.000000, -0.642531>, <3.329204, -0.529279, -0.642531>, <3.147814, -1.206234, -0.642531>, <2.883175, -1.664603, -0.642531>, 
      <3.164947, 0.000000, -0.648322>, <3.164946, -0.487090, -0.648322>, <2.984468, -1.160642, -0.648322>, <2.740924, -1.582474, -0.648322>, 
      <3.136615, 0.000000, -0.726692>, <3.136615, -0.487090, -0.726692>, <2.959933, -1.146476, -0.726692>, <2.716388, -1.568308, -0.726692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.408292, 0.000000, -0.668791>, <3.329204, 0.000000, -0.642531>, <3.164947, 0.000000, -0.648322>, <3.136615, 0.000000, -0.726692>, 
      <3.408292, 0.529278, -0.668791>, <3.329205, 0.529278, -0.642531>, <3.164947, 0.487089, -0.648322>, <3.136615, 0.487089, -0.726692>, 
      <3.216307, 1.245777, -0.668791>, <3.147815, 1.206233, -0.642531>, <2.984469, 1.160641, -0.648322>, <2.959934, 1.146475, -0.726692>, 
      <2.951668, 1.704145, -0.668791>, <2.883176, 1.664601, -0.642531>, <2.740925, 1.582473, -0.648322>, <2.716389, 1.568307, -0.726692>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.310711, 0.000000, -0.784499>, <3.310711, -0.514125, -0.784499>, <3.124223, -1.210110, -0.784499>, <2.867160, -1.655355, -0.784499>, 
      <3.314867, 0.000000, -0.739281>, <3.314867, -0.514125, -0.739281>, <3.127822, -1.212188, -0.739281>, <2.870759, -1.657433, -0.739281>, 
      <3.451387, 0.000000, -0.683100>, <3.451387, -0.529279, -0.683100>, <3.253628, -1.267324, -0.683100>, <2.988989, -1.725693, -0.683100>, 
      <3.408292, 0.000000, -0.668791>, <3.408292, -0.529279, -0.668791>, <3.216306, -1.245777, -0.668791>, <2.951667, -1.704146, -0.668791>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.310711, 0.000000, -0.784499>, <3.314867, 0.000000, -0.739281>, <3.451387, 0.000000, -0.683100>, <3.408292, 0.000000, -0.668791>, 
      <3.310711, 0.514125, -0.784499>, <3.314867, 0.514125, -0.739281>, <3.451388, 0.529278, -0.683100>, <3.408292, 0.529278, -0.668791>, 
      <3.124222, 1.210109, -0.784499>, <3.127821, 1.212187, -0.739281>, <3.253629, 1.267324, -0.683100>, <3.216307, 1.245777, -0.668791>, 
      <2.867160, 1.655354, -0.784499>, <2.870759, 1.657432, -0.739281>, <2.988990, 1.725692, -0.683100>, <2.951668, 1.704145, -0.668791>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.360463, 0.000000, -1.189180>, <3.360463, -0.521851, -1.189180>, <3.171171, -1.228295, -1.189180>, <2.910246, -1.680231, -1.189180>, 
      <3.303083, 0.000000, -1.081155>, <3.303083, -0.521851, -1.081155>, <3.121479, -1.199605, -1.081155>, <2.860554, -1.651541, -1.081155>, 
      <3.299516, 0.000000, -0.906304>, <3.299516, -0.514125, -0.906304>, <3.114527, -1.204512, -0.906304>, <2.857465, -1.649757, -0.906304>, 
      <3.310711, 0.000000, -0.784499>, <3.310711, -0.514125, -0.784499>, <3.124223, -1.210110, -0.784499>, <2.867160, -1.655355, -0.784499>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.360463, 0.000000, -1.189180>, <3.303083, 0.000000, -1.081155>, <3.299516, 0.000000, -0.906304>, <3.310711, 0.000000, -0.784499>, 
      <3.360463, 0.521851, -1.189180>, <3.303083, 0.521851, -1.081155>, <3.299516, 0.514125, -0.906304>, <3.310711, 0.514125, -0.784499>, 
      <3.171172, 1.228295, -1.189180>, <3.121480, 1.199605, -1.081155>, <3.114527, 1.204512, -0.906304>, <3.124222, 1.210109, -0.784499>, 
      <2.910247, 1.680231, -1.189180>, <2.860555, 1.651541, -1.081155>, <2.857465, 1.649757, -0.906304>, <2.867160, 1.655354, -0.784499>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.668961, 0.000000, -1.458946>, <3.668961, -0.569758, -1.458946>, <3.462292, -1.341055, -1.458946>, <3.177413, -1.834480, -1.458946>, 
      <3.597682, 0.000000, -1.358775>, <3.597682, -0.569758, -1.358775>, <3.400563, -1.305416, -1.358775>, <3.115684, -1.798840, -1.358775>, 
      <3.418136, 0.000000, -1.297756>, <3.418136, -0.521851, -1.297756>, <3.221118, -1.257132, -1.297756>, <2.960192, -1.709068, -1.297756>, 
      <3.360463, 0.000000, -1.189180>, <3.360463, -0.521851, -1.189180>, <3.171171, -1.228295, -1.189180>, <2.910246, -1.680231, -1.189180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.668961, 0.000000, -1.458946>, <3.597682, 0.000000, -1.358775>, <3.418136, 0.000000, -1.297756>, <3.360463, 0.000000, -1.189180>, 
      <3.668961, 0.569758, -1.458946>, <3.597682, 0.569758, -1.358775>, <3.418136, 0.521851, -1.297756>, <3.360463, 0.521851, -1.189180>, 
      <3.462292, 1.341054, -1.458946>, <3.400563, 1.305415, -1.358775>, <3.221119, 1.257131, -1.297756>, <3.171172, 1.228295, -1.189180>, 
      <3.177413, 1.834479, -1.458946>, <3.115684, 1.798840, -1.358775>, <2.960193, 1.709067, -1.297756>, <2.910247, 1.680231, -1.189180>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.881357, 0.000000, -1.921214>, <3.881357, -0.602742, -1.921214>, <3.662725, -1.418689, -1.921214>, <3.361354, -1.940679, -1.921214>, 
      <3.877099, 0.000000, -1.768655>, <3.877099, -0.602742, -1.768655>, <3.659037, -1.416560, -1.768655>, <3.357666, -1.938550, -1.768655>, 
      <3.757445, 0.000000, -1.583296>, <3.757445, -0.569758, -1.583296>, <3.538922, -1.385297, -1.583296>, <3.254042, -1.878722, -1.583296>, 
      <3.668961, 0.000000, -1.458946>, <3.668961, -0.569758, -1.458946>, <3.462292, -1.341055, -1.458946>, <3.177413, -1.834480, -1.458946>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.881357, 0.000000, -1.921214>, <3.877099, 0.000000, -1.768655>, <3.757445, 0.000000, -1.583296>, <3.668961, 0.000000, -1.458946>, 
      <3.881357, 0.602741, -1.921214>, <3.877099, 0.602741, -1.768655>, <3.757445, 0.569758, -1.583296>, <3.668961, 0.569758, -1.458946>, 
      <3.662725, 1.418689, -1.921214>, <3.659037, 1.416560, -1.768655>, <3.538921, 1.385296, -1.583296>, <3.462292, 1.341054, -1.458946>, 
      <3.361354, 1.940678, -1.921214>, <3.357666, 1.938549, -1.768655>, <3.254042, 1.878721, -1.583296>, <3.177413, 1.834479, -1.458946>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.881401, 0.000000, -9.070110>, <3.881401, -0.602749, -9.070110>, <3.662766, -1.418706, -9.070110>, <3.361392, -1.940701, -9.070110>, 
      <3.859675, 0.000000, -6.925551>, <3.859675, -0.602749, -6.925551>, <3.643951, -1.407843, -6.925551>, <3.342577, -1.929838, -6.925551>, 
      <3.941195, 0.000000, -4.065048>, <3.941195, -0.602742, -4.065048>, <3.714546, -1.448609, -4.065048>, <3.413175, -1.970598, -4.065048>, 
      <3.881357, 0.000000, -1.921214>, <3.881357, -0.602742, -1.921214>, <3.662725, -1.418689, -1.921214>, <3.361354, -1.940679, -1.921214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.881401, 0.000000, -9.070110>, <3.859675, 0.000000, -6.925551>, <3.941195, 0.000000, -4.065048>, <3.881357, 0.000000, -1.921214>, 
      <3.881401, 0.602748, -9.070110>, <3.859675, 0.602748, -6.925551>, <3.941195, 0.602741, -4.065048>, <3.881357, 0.602741, -1.921214>, 
      <3.662766, 1.418705, -9.070110>, <3.643950, 1.407842, -6.925551>, <3.714546, 1.448608, -4.065048>, <3.662725, 1.418689, -1.921214>, 
      <3.361392, 1.940700, -9.070110>, <3.342577, 1.929837, -6.925551>, <3.413175, 1.970597, -4.065048>, <3.361354, 1.940678, -1.921214>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.958264, 0.000000, -9.512637>, <3.958264, -0.614684, -9.512637>, <3.735299, -1.446800, -9.512637>, <3.427957, -1.979132, -9.512637>, 
      <3.995670, 0.000000, -9.383187>, <3.995669, -0.614684, -9.383187>, <3.767693, -1.465502, -9.383187>, <3.460351, -1.997835, -9.383187>, 
      <3.882766, 0.000000, -9.204850>, <3.882766, -0.602749, -9.204850>, <3.663948, -1.419388, -9.204850>, <3.362574, -1.941383, -9.204850>, 
      <3.881401, 0.000000, -9.070110>, <3.881401, -0.602749, -9.070110>, <3.662766, -1.418706, -9.070110>, <3.361392, -1.940701, -9.070110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.958264, 0.000000, -9.512637>, <3.995670, 0.000000, -9.383187>, <3.882766, 0.000000, -9.204850>, <3.881401, 0.000000, -9.070110>, 
      <3.958264, 0.614684, -9.512637>, <3.995670, 0.614684, -9.383187>, <3.882766, 0.602748, -9.204850>, <3.881401, 0.602748, -9.070110>, 
      <3.735300, 1.446799, -9.512637>, <3.767694, 1.465502, -9.383187>, <3.663948, 1.419387, -9.204850>, <3.662766, 1.418705, -9.070110>, 
      <3.427958, 1.979131, -9.512637>, <3.460352, 1.997834, -9.383187>, <3.362574, 1.941383, -9.204850>, <3.361392, 1.940700, -9.070110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.602978, 0.000000, -10.033655>, <3.602978, -0.559512, -10.033655>, <3.400027, -1.316938, -10.033655>, <3.120271, -1.801489, -10.033655>, 
      <3.709564, 0.000000, -9.877350>, <3.709564, -0.559512, -9.877350>, <3.492333, -1.370231, -9.877350>, <3.212577, -1.854782, -9.877350>, 
      <3.905746, 0.000000, -9.694390>, <3.905746, -0.614684, -9.694390>, <3.689817, -1.420540, -9.694390>, <3.382475, -1.952873, -9.694390>, 
      <3.958264, 0.000000, -9.512637>, <3.958264, -0.614684, -9.512637>, <3.735299, -1.446800, -9.512637>, <3.427957, -1.979132, -9.512637>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.602978, 0.000000, -10.033655>, <3.709564, 0.000000, -9.877350>, <3.905746, 0.000000, -9.694390>, <3.958264, 0.000000, -9.512637>, 
      <3.602978, 0.559511, -10.033655>, <3.709564, 0.559511, -9.877350>, <3.905746, 0.614684, -9.694390>, <3.958264, 0.614684, -9.512637>, 
      <3.400026, 1.316937, -10.033655>, <3.492332, 1.370230, -9.877350>, <3.689818, 1.420540, -9.694390>, <3.735300, 1.446799, -9.512637>, 
      <3.120271, 1.801488, -10.033655>, <3.212577, 1.854781, -9.877350>, <3.382476, 1.952872, -9.694390>, <3.427958, 1.979131, -9.512637>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.005551, 0.000000, -10.033655>, <0.005551, -0.000862, -10.033655>, <0.005239, -0.002029, -10.033655>, <0.004808, -0.002776, -10.033655>, 
      <1.084779, 0.000000, -10.033655>, <1.084779, -0.000862, -10.033655>, <0.939878, -0.541643, -10.033655>, <0.939447, -0.542390, -10.033655>, 
      <2.523750, 0.000000, -10.033655>, <2.523750, -0.559512, -10.033655>, <2.465388, -0.777324, -10.033655>, <2.185632, -1.261875, -10.033655>, 
      <3.602978, 0.000000, -10.033655>, <3.602978, -0.559512, -10.033655>, <3.400027, -1.316938, -10.033655>, <3.120271, -1.801489, -10.033655>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.005551, 0.000000, -10.033655>, <1.084779, 0.000000, -10.033655>, <2.523750, 0.000000, -10.033655>, <3.602978, 0.000000, -10.033655>, 
      <0.005551, 0.000862, -10.033655>, <1.084779, 0.000862, -10.033655>, <2.523750, 0.559511, -10.033655>, <3.602978, 0.559511, -10.033655>, 
      <0.005239, 0.002029, -10.033655>, <0.939878, 0.541643, -10.033655>, <2.465387, 0.777323, -10.033655>, <3.400026, 1.316937, -10.033655>, 
      <0.004808, 0.002776, -10.033655>, <0.939447, 0.542390, -10.033655>, <2.185632, 1.261874, -10.033655>, <3.120271, 1.801488, -10.033655>
    }
  }
  material {
    Glass_1
  }
}
#declare tapa = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.802447, 3.121929, -0.479432>, <1.265841, 2.192500, -0.479432>, <0.550367, 0.953263, -0.479432>, <0.013761, 0.023834, -0.479432>, 
      <2.287256, 2.842024, -0.479432>, <1.750650, 1.912596, -0.479432>, <0.554068, 0.951126, -0.479432>, <0.017462, 0.021697, -0.479432>, 
      <2.842024, 2.287254, -0.479432>, <1.912596, 1.750649, -0.479432>, <0.951126, 0.554067, -0.479432>, <0.021697, 0.017462, -0.479432>, 
      <3.121929, 1.802445, -0.479432>, <2.192500, 1.265840, -0.479432>, <0.953263, 0.550366, -0.479432>, <0.023834, 0.013761, -0.479432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.604892, -0.479432>, <0.000000, 2.531681, -0.479432>, <0.000000, 1.100733, -0.479432>, <0.000000, 0.027522, -0.479432>, 
      <0.559809, 3.604892, -0.479432>, <0.559809, 2.531681, -0.479432>, <0.004274, 1.100733, -0.479432>, <0.004274, 0.027522, -0.479432>, 
      <1.317638, 3.401834, -0.479432>, <0.781033, 2.472405, -0.479432>, <0.546666, 0.955400, -0.479432>, <0.010060, 0.025971, -0.479432>, 
      <1.802447, 3.121929, -0.479432>, <1.265841, 2.192500, -0.479432>, <0.550367, 0.953263, -0.479432>, <0.013761, 0.023834, -0.479432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.802446, 3.121929, -0.479432>, <-1.265840, 2.192500, -0.479432>, <-0.550366, 0.953263, -0.479432>, <-0.013761, 0.023834, -0.479432>, 
      <-1.317637, 3.401833, -0.479432>, <-0.781032, 2.472404, -0.479432>, <-0.546665, 0.955400, -0.479432>, <-0.010060, 0.025971, -0.479432>, 
      <-0.559809, 3.604892, -0.479432>, <-0.559809, 2.531681, -0.479432>, <-0.004274, 1.100733, -0.479432>, <-0.004274, 0.027522, -0.479432>, 
      <0.000000, 3.604892, -0.479432>, <0.000000, 2.531681, -0.479432>, <0.000000, 1.100733, -0.479432>, <0.000000, 0.027522, -0.479432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.121928, 1.802447, -0.479432>, <-2.192500, 1.265841, -0.479432>, <-0.953262, 0.550367, -0.479432>, <-0.023834, 0.013761, -0.479432>, 
      <-2.842024, 2.287256, -0.479432>, <-1.912595, 1.750650, -0.479432>, <-0.951125, 0.554068, -0.479432>, <-0.021697, 0.017462, -0.479432>, 
      <-2.287255, 2.842025, -0.479432>, <-1.750649, 1.912596, -0.479432>, <-0.554068, 0.951126, -0.479432>, <-0.017462, 0.021697, -0.479432>, 
      <-1.802446, 3.121929, -0.479432>, <-1.265840, 2.192500, -0.479432>, <-0.550366, 0.953263, -0.479432>, <-0.013761, 0.023834, -0.479432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.604892, 0.000000, -0.479432>, <-2.531681, 0.000000, -0.479432>, <-1.100733, 0.000000, -0.479432>, <-0.027522, 0.000000, -0.479432>, 
      <-3.604892, 0.559809, -0.479432>, <-2.531681, 0.559809, -0.479432>, <-1.100733, 0.004274, -0.479432>, <-0.027522, 0.004274, -0.479432>, 
      <-3.401832, 1.317638, -0.479432>, <-2.472404, 0.781032, -0.479432>, <-0.955399, 0.546666, -0.479432>, <-0.025971, 0.010060, -0.479432>, 
      <-3.121928, 1.802447, -0.479432>, <-2.192500, 1.265841, -0.479432>, <-0.953262, 0.550367, -0.479432>, <-0.023834, 0.013761, -0.479432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.121929, -1.802446, -0.479432>, <-2.192500, -1.265840, -0.479432>, <-0.953263, -0.550366, -0.479432>, <-0.023834, -0.013761, -0.479432>, 
      <-3.401429, -1.318338, -0.509508>, <-2.472001, -0.781732, -0.509508>, <-0.955400, -0.546665, -0.479432>, <-0.025971, -0.010060, -0.479432>, 
      <-3.604892, -0.559809, -0.479432>, <-2.531681, -0.559809, -0.479432>, <-1.100733, -0.004274, -0.479432>, <-0.027522, -0.004274, -0.479432>, 
      <-3.604892, 0.000000, -0.479432>, <-2.531681, 0.000000, -0.479432>, <-1.100733, 0.000000, -0.479432>, <-0.027522, 0.000000, -0.479432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.802446, -3.121928, -0.285477>, <-1.265840, -2.192500, -0.343664>, <-0.550366, -0.953262, -0.421245>, <-0.013761, -0.023834, -0.479432>, 
      <-2.287731, -2.841748, -0.338105>, <-1.751126, -1.912320, -0.396292>, <-0.554068, -0.951125, -0.421245>, <-0.017462, -0.021697, -0.479432>, 
      <-2.840923, -2.289163, -0.449194>, <-1.911494, -1.752557, -0.449194>, <-0.951126, -0.554068, -0.479432>, <-0.021697, -0.017462, -0.479432>, 
      <-3.121929, -1.802446, -0.479432>, <-2.192500, -1.265840, -0.479432>, <-0.953263, -0.550366, -0.479432>, <-0.023834, -0.013761, -0.479432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.604892, -0.140866>, <0.000000, -2.531681, -0.242436>, <0.000000, -1.100733, -0.377862>, <0.000000, -0.027522, -0.479432>, 
      <-0.561487, -3.604892, -0.140866>, <-0.561487, -2.531681, -0.242436>, <-0.004274, -1.100733, -0.377862>, <-0.004274, -0.027522, -0.479432>, 
      <-1.318314, -3.401442, -0.232974>, <-0.781709, -2.472013, -0.291160>, <-0.546665, -0.955399, -0.421245>, <-0.010060, -0.025971, -0.479432>, 
      <-1.802446, -3.121928, -0.285477>, <-1.265840, -2.192500, -0.343664>, <-0.550366, -0.953262, -0.421245>, <-0.013761, -0.023834, -0.479432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.802446, -3.121929, -0.285477>, <1.265840, -2.192500, -0.343664>, <0.550366, -0.953263, -0.421245>, <0.013761, -0.023834, -0.479432>, 
      <1.318314, -3.401442, -0.232974>, <0.781709, -2.472014, -0.291160>, <0.546665, -0.955400, -0.421245>, <0.010060, -0.025971, -0.479432>, 
      <0.561487, -3.604892, -0.140866>, <0.561487, -2.531681, -0.242436>, <0.004274, -1.100733, -0.377862>, <0.004274, -0.027522, -0.479432>, 
      <0.000000, -3.604892, -0.140866>, <0.000000, -2.531681, -0.242436>, <0.000000, -1.100733, -0.377862>, <0.000000, -0.027522, -0.479432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.121928, -1.802446, -0.479432>, <2.192500, -1.265840, -0.479432>, <0.953262, -0.550366, -0.479432>, <0.023834, -0.013761, -0.479432>, 
      <2.840922, -2.289163, -0.449194>, <1.911494, -1.752557, -0.449194>, <0.951125, -0.554068, -0.479432>, <0.021697, -0.017462, -0.479432>, 
      <2.287731, -2.841749, -0.338105>, <1.751126, -1.912321, -0.396292>, <0.554068, -0.951126, -0.421245>, <0.017462, -0.021697, -0.479432>, 
      <1.802446, -3.121929, -0.285477>, <1.265840, -2.192500, -0.343664>, <0.550366, -0.953263, -0.421245>, <0.013761, -0.023834, -0.479432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.788362, 3.097534, -0.794794>, <1.792588, 3.104852, -0.700185>, <1.798221, 3.114610, -0.574041>, <1.802447, 3.121929, -0.479432>, 
      <2.269383, 2.819817, -0.794794>, <2.273608, 2.827135, -0.700185>, <2.283031, 2.834706, -0.574041>, <2.287256, 2.842024, -0.479432>, 
      <2.819817, 2.269382, -0.794794>, <2.827135, 2.273607, -0.700185>, <2.834706, 2.283029, -0.574041>, <2.842024, 2.287254, -0.479432>, 
      <3.097534, 1.788361, -0.794794>, <3.104852, 1.792586, -0.700185>, <3.114610, 1.798220, -0.574041>, <3.121929, 1.802445, -0.479432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.576723, -0.794794>, <0.000000, 3.585174, -0.700185>, <0.000000, 3.596441, -0.574041>, <0.000000, 3.604892, -0.479432>, 
      <0.555435, 3.576723, -0.794794>, <0.555435, 3.585174, -0.700185>, <0.559809, 3.596441, -0.574041>, <0.559809, 3.604892, -0.479432>, 
      <1.307342, 3.375251, -0.794794>, <1.311567, 3.382570, -0.700185>, <1.313413, 3.394515, -0.574041>, <1.317638, 3.401834, -0.479432>, 
      <1.788362, 3.097534, -0.794794>, <1.792588, 3.104852, -0.700185>, <1.798221, 3.114610, -0.574041>, <1.802447, 3.121929, -0.479432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.788361, 3.097534, -0.794794>, <-1.792586, 3.104852, -0.700185>, <-1.798221, 3.114610, -0.574041>, <-1.802446, 3.121929, -0.479432>, 
      <-1.307341, 3.375251, -0.794794>, <-1.311566, 3.382570, -0.700185>, <-1.313412, 3.394514, -0.574041>, <-1.317637, 3.401833, -0.479432>, 
      <-0.555434, 3.576723, -0.794794>, <-0.555434, 3.585174, -0.700185>, <-0.559809, 3.596441, -0.574041>, <-0.559809, 3.604892, -0.479432>, 
      <0.000000, 3.576723, -0.794794>, <0.000000, 3.585174, -0.700185>, <0.000000, 3.596441, -0.574041>, <0.000000, 3.604892, -0.479432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.097533, 1.788362, -0.794794>, <-3.104851, 1.792588, -0.700185>, <-3.114609, 1.798221, -0.574041>, <-3.121928, 1.802447, -0.479432>, 
      <-2.819816, 2.269382, -0.794794>, <-2.827134, 2.273608, -0.700185>, <-2.834705, 2.283030, -0.574041>, <-2.842024, 2.287256, -0.479432>, 
      <-2.269382, 2.819817, -0.794794>, <-2.273607, 2.827135, -0.700185>, <-2.283029, 2.834706, -0.574041>, <-2.287255, 2.842025, -0.479432>, 
      <-1.788361, 3.097534, -0.794794>, <-1.792586, 3.104852, -0.700185>, <-1.798221, 3.114610, -0.574041>, <-1.802446, 3.121929, -0.479432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.576723, 0.000000, -0.794794>, <-3.585174, 0.000000, -0.700185>, <-3.596441, 0.000000, -0.574041>, <-3.604892, 0.000000, -0.479432>, 
      <-3.576723, 0.555435, -0.794794>, <-3.585174, 0.555435, -0.700185>, <-3.596441, 0.559809, -0.574041>, <-3.604892, 0.559809, -0.479432>, 
      <-3.375250, 1.307342, -0.794794>, <-3.382569, 1.311567, -0.700185>, <-3.394514, 1.313413, -0.574041>, <-3.401832, 1.317638, -0.479432>, 
      <-3.097533, 1.788362, -0.794794>, <-3.104851, 1.792588, -0.700185>, <-3.114609, 1.798221, -0.574041>, <-3.121928, 1.802447, -0.479432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.097534, -1.788362, -0.794794>, <-3.104852, -1.792587, -0.700185>, <-3.114610, -1.798221, -0.574041>, <-3.121929, -1.802446, -0.479432>, 
      <-3.374844, -1.308047, -0.824869>, <-3.382162, -1.312273, -0.730261>, <-3.394111, -1.314112, -0.604117>, <-3.401429, -1.318338, -0.509508>, 
      <-3.576723, -0.555435, -0.794794>, <-3.585174, -0.555435, -0.700185>, <-3.596442, -0.559809, -0.574041>, <-3.604892, -0.559809, -0.479432>, 
      <-3.576723, 0.000000, -0.794794>, <-3.585174, 0.000000, -0.700185>, <-3.596441, 0.000000, -0.574041>, <-3.604892, 0.000000, -0.479432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.788362, -3.097533, -0.600839>, <-1.792587, -3.104851, -0.506230>, <-1.798221, -3.114609, -0.380086>, <-1.802446, -3.121928, -0.285477>, 
      <-2.269862, -2.819539, -0.653468>, <-2.274087, -2.826857, -0.558859>, <-2.283506, -2.834430, -0.432714>, <-2.287731, -2.841748, -0.338105>, 
      <-2.818707, -2.271305, -0.764554>, <-2.826025, -2.275530, -0.669945>, <-2.833604, -2.284937, -0.543802>, <-2.840923, -2.289163, -0.449194>, 
      <-3.097534, -1.788362, -0.794794>, <-3.104852, -1.792587, -0.700185>, <-3.114610, -1.798221, -0.574041>, <-3.121929, -1.802446, -0.479432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.576723, -0.456228>, <0.000000, -3.585174, -0.361619>, <0.000000, -3.596441, -0.235475>, <0.000000, -3.604892, -0.140866>, 
      <-0.557126, -3.576723, -0.456228>, <-0.557126, -3.585174, -0.361619>, <-0.561487, -3.596441, -0.235475>, <-0.561487, -3.604892, -0.140866>, 
      <-1.308024, -3.374856, -0.548337>, <-1.312249, -3.382175, -0.453729>, <-1.314089, -3.394123, -0.327583>, <-1.318314, -3.401442, -0.232974>, 
      <-1.788362, -3.097533, -0.600839>, <-1.792587, -3.104851, -0.506230>, <-1.798221, -3.114609, -0.380086>, <-1.802446, -3.121928, -0.285477>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.788361, -3.097534, -0.600839>, <1.792586, -3.104852, -0.506230>, <1.798221, -3.114610, -0.380086>, <1.802446, -3.121929, -0.285477>, 
      <1.308023, -3.374857, -0.548337>, <1.312248, -3.382176, -0.453729>, <1.314089, -3.394124, -0.327583>, <1.318314, -3.401442, -0.232974>, 
      <0.557126, -3.576723, -0.456228>, <0.557126, -3.585174, -0.361619>, <0.561487, -3.596442, -0.235475>, <0.561487, -3.604892, -0.140866>, 
      <0.000000, -3.576723, -0.456228>, <0.000000, -3.585174, -0.361619>, <0.000000, -3.596441, -0.235475>, <0.000000, -3.604892, -0.140866>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.097533, -1.788362, -0.794794>, <3.104851, -1.792587, -0.700185>, <3.114609, -1.798221, -0.574041>, <3.121928, -1.802446, -0.479432>, 
      <2.818706, -2.271305, -0.764554>, <2.826024, -2.275531, -0.669945>, <2.833604, -2.284937, -0.543802>, <2.840922, -2.289163, -0.449194>, 
      <2.269861, -2.819540, -0.653468>, <2.274087, -2.826858, -0.558859>, <2.283506, -2.834431, -0.432714>, <2.287731, -2.841749, -0.338105>, 
      <1.788361, -3.097534, -0.600839>, <1.792586, -3.104852, -0.506230>, <1.798221, -3.114610, -0.380086>, <1.802446, -3.121929, -0.285477>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.659026, 2.873517, -0.794774>, <1.697827, 2.940722, -0.794780>, <1.749561, 3.030329, -0.794788>, <1.788362, 3.097534, -0.794794>, 
      <2.105259, 2.615884, -0.794774>, <2.144060, 2.683089, -0.794780>, <2.230582, 2.752611, -0.794788>, <2.269383, 2.819817, -0.794794>, 
      <2.615885, 2.105258, -0.794774>, <2.683090, 2.144059, -0.794780>, <2.752612, 2.230581, -0.794788>, <2.819817, 2.269382, -0.794794>, 
      <2.873518, 1.659025, -0.794774>, <2.940723, 1.697826, -0.794780>, <3.030329, 1.749560, -0.794788>, <3.097534, 1.788361, -0.794794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.318052, -0.794774>, <0.000000, 3.395653, -0.794780>, <0.000000, 3.499122, -0.794788>, <0.000000, 3.576723, -0.794794>, 
      <0.515265, 3.318052, -0.794774>, <0.515265, 3.395653, -0.794780>, <0.555435, 3.499122, -0.794788>, <0.555435, 3.576723, -0.794794>, 
      <1.212794, 3.131150, -0.794774>, <1.251594, 3.198354, -0.794780>, <1.268541, 3.308046, -0.794788>, <1.307342, 3.375251, -0.794794>, 
      <1.659026, 2.873517, -0.794774>, <1.697827, 2.940722, -0.794780>, <1.749561, 3.030329, -0.794788>, <1.788362, 3.097534, -0.794794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.659026, 2.873517, -0.794774>, <-1.697827, 2.940722, -0.794780>, <-1.749560, 3.030329, -0.794788>, <-1.788361, 3.097534, -0.794794>, 
      <-1.212793, 3.131150, -0.794774>, <-1.251594, 3.198354, -0.794780>, <-1.268540, 3.308046, -0.794788>, <-1.307341, 3.375251, -0.794794>, 
      <-0.515265, 3.318052, -0.794774>, <-0.515265, 3.395653, -0.794780>, <-0.555434, 3.499122, -0.794788>, <-0.555434, 3.576723, -0.794794>, 
      <0.000000, 3.318052, -0.794774>, <0.000000, 3.395653, -0.794780>, <0.000000, 3.499122, -0.794788>, <0.000000, 3.576723, -0.794794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.873517, 1.659027, -0.794774>, <-2.940722, 1.697827, -0.794780>, <-3.030328, 1.749562, -0.794788>, <-3.097533, 1.788362, -0.794794>, 
      <-2.615885, 2.105259, -0.794774>, <-2.683089, 2.144060, -0.794780>, <-2.752611, 2.230582, -0.794788>, <-2.819816, 2.269382, -0.794794>, 
      <-2.105258, 2.615885, -0.794774>, <-2.144059, 2.683090, -0.794780>, <-2.230581, 2.752611, -0.794788>, <-2.269382, 2.819817, -0.794794>, 
      <-1.659026, 2.873517, -0.794774>, <-1.697827, 2.940722, -0.794780>, <-1.749560, 3.030329, -0.794788>, <-1.788361, 3.097534, -0.794794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.318052, 0.000000, -0.794774>, <-3.395653, 0.000000, -0.794780>, <-3.499122, 0.000000, -0.794788>, <-3.576723, 0.000000, -0.794794>, 
      <-3.318052, 0.515265, -0.794774>, <-3.395653, 0.515265, -0.794780>, <-3.499122, 0.555435, -0.794788>, <-3.576723, 0.555435, -0.794794>, 
      <-3.131150, 1.212794, -0.794774>, <-3.198354, 1.251594, -0.794780>, <-3.308046, 1.268541, -0.794788>, <-3.375250, 1.307342, -0.794794>, 
      <-2.873517, 1.659027, -0.794774>, <-2.940722, 1.697827, -0.794780>, <-3.030328, 1.749562, -0.794788>, <-3.097533, 1.788362, -0.794794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.873517, -1.659026, -0.794774>, <-2.940722, -1.697827, -0.794780>, <-3.030329, -1.749561, -0.794788>, <-3.097534, -1.788362, -0.794794>, 
      <-3.130711, -1.213554, -0.824842>, <-3.197916, -1.252355, -0.824848>, <-3.307638, -1.269246, -0.824863>, <-3.374844, -1.308047, -0.824869>, 
      <-3.318052, -0.515265, -0.794774>, <-3.395653, -0.515265, -0.794780>, <-3.499122, -0.555435, -0.794788>, <-3.576723, -0.555435, -0.794794>, 
      <-3.318052, 0.000000, -0.794774>, <-3.395653, 0.000000, -0.794780>, <-3.499122, 0.000000, -0.794788>, <-3.576723, 0.000000, -0.794794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.659026, -2.873517, -0.600819>, <-1.697827, -2.940722, -0.600825>, <-1.749561, -3.030328, -0.600833>, <-1.788362, -3.097533, -0.600839>, 
      <-2.105775, -2.615586, -0.653456>, <-2.144576, -2.682791, -0.653462>, <-2.231061, -2.752334, -0.653462>, <-2.269862, -2.819539, -0.653468>, 
      <-2.614689, -2.107329, -0.764515>, <-2.681894, -2.146130, -0.764521>, <-2.751502, -2.232504, -0.764548>, <-2.818707, -2.271305, -0.764554>, 
      <-2.873517, -1.659026, -0.794774>, <-2.940722, -1.697827, -0.794780>, <-3.030329, -1.749561, -0.794788>, <-3.097534, -1.788362, -0.794794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.318052, -0.456208>, <0.000000, -3.395653, -0.456214>, <0.000000, -3.499122, -0.456222>, <0.000000, -3.576723, -0.456228>, 
      <-0.517088, -3.318052, -0.456208>, <-0.517088, -3.395653, -0.456214>, <-0.557126, -3.499122, -0.456222>, <-0.557126, -3.576723, -0.456228>, 
      <-1.213528, -3.130726, -0.548329>, <-1.252329, -3.197930, -0.548335>, <-1.269223, -3.307652, -0.548331>, <-1.308024, -3.374856, -0.548337>, 
      <-1.659026, -2.873517, -0.600819>, <-1.697827, -2.940722, -0.600825>, <-1.749561, -3.030328, -0.600833>, <-1.788362, -3.097533, -0.600839>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.659026, -2.873517, -0.600819>, <1.697827, -2.940722, -0.600825>, <1.749560, -3.030329, -0.600833>, <1.788361, -3.097534, -0.600839>, 
      <1.213528, -3.130726, -0.548329>, <1.252328, -3.197931, -0.548335>, <1.269222, -3.307652, -0.548331>, <1.308023, -3.374857, -0.548337>, 
      <0.517088, -3.318052, -0.456208>, <0.517088, -3.395653, -0.456214>, <0.557126, -3.499122, -0.456222>, <0.557126, -3.576723, -0.456228>, 
      <0.000000, -3.318052, -0.456208>, <0.000000, -3.395653, -0.456214>, <0.000000, -3.499122, -0.456222>, <0.000000, -3.576723, -0.456228>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.873517, -1.659026, -0.794774>, <2.940722, -1.697827, -0.794780>, <3.030328, -1.749561, -0.794788>, <3.097533, -1.788362, -0.794794>, 
      <2.614689, -2.107329, -0.764515>, <2.681894, -2.146130, -0.764521>, <2.751501, -2.232504, -0.764548>, <2.818706, -2.271305, -0.764554>, 
      <2.105775, -2.615586, -0.653456>, <2.144576, -2.682791, -0.653462>, <2.231061, -2.752334, -0.653462>, <2.269861, -2.819540, -0.653468>, 
      <1.659026, -2.873517, -0.600819>, <1.697827, -2.940722, -0.600825>, <1.749560, -3.030329, -0.600833>, <1.788361, -3.097534, -0.600839>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.702380, 2.948608, -0.584788>, <1.689374, 2.926081, -0.647784>, <1.672032, 2.896044, -0.731778>, <1.659026, 2.873517, -0.794774>, 
      <2.160274, 2.684243, -0.584788>, <2.147267, 2.661716, -0.647784>, <2.118265, 2.638412, -0.731778>, <2.105259, 2.615884, -0.794774>, 
      <2.684243, 2.160273, -0.584788>, <2.661716, 2.147266, -0.647784>, <2.638412, 2.118264, -0.731778>, <2.615885, 2.105258, -0.794774>, 
      <2.948608, 1.702379, -0.584788>, <2.926081, 1.689373, -0.647784>, <2.896045, 1.672031, -0.731778>, <2.873518, 1.659025, -0.794774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 3.404760, -0.584788>, <0.000000, 3.378748, -0.647784>, <0.000000, 3.344064, -0.731778>, <0.000000, 3.318052, -0.794774>, 
      <0.528730, 3.404760, -0.584788>, <0.528730, 3.378748, -0.647784>, <0.515265, 3.344064, -0.731778>, <0.515265, 3.318052, -0.794774>, 
      <1.244486, 3.212973, -0.584788>, <1.231480, 3.190446, -0.647784>, <1.225800, 3.153677, -0.731778>, <1.212794, 3.131150, -0.794774>, 
      <1.702380, 2.948608, -0.584788>, <1.689374, 2.926081, -0.647784>, <1.672032, 2.896044, -0.731778>, <1.659026, 2.873517, -0.794774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.702379, 2.948608, -0.584788>, <-1.689373, 2.926081, -0.647784>, <-1.672032, 2.896044, -0.731778>, <-1.659026, 2.873517, -0.794774>, 
      <-1.244486, 3.212973, -0.584788>, <-1.231480, 3.190446, -0.647784>, <-1.225799, 3.153677, -0.731778>, <-1.212793, 3.131150, -0.794774>, 
      <-0.528730, 3.404760, -0.584788>, <-0.528730, 3.378748, -0.647784>, <-0.515265, 3.344064, -0.731778>, <-0.515265, 3.318052, -0.794774>, 
      <0.000000, 3.404760, -0.584788>, <0.000000, 3.378748, -0.647784>, <0.000000, 3.344064, -0.731778>, <0.000000, 3.318052, -0.794774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.948608, 1.702380, -0.584788>, <-2.926081, 1.689374, -0.647784>, <-2.896044, 1.672033, -0.731778>, <-2.873517, 1.659027, -0.794774>, 
      <-2.684243, 2.160274, -0.584788>, <-2.661716, 2.147268, -0.647784>, <-2.638412, 2.118265, -0.731778>, <-2.615885, 2.105259, -0.794774>, 
      <-2.160273, 2.684243, -0.584788>, <-2.147267, 2.661716, -0.647784>, <-2.118264, 2.638412, -0.731778>, <-2.105258, 2.615885, -0.794774>, 
      <-1.702379, 2.948608, -0.584788>, <-1.689373, 2.926081, -0.647784>, <-1.672032, 2.896044, -0.731778>, <-1.659026, 2.873517, -0.794774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.404760, 0.000000, -0.584788>, <-3.378748, 0.000000, -0.647784>, <-3.344064, 0.000000, -0.731778>, <-3.318052, 0.000000, -0.794774>, 
      <-3.404760, 0.528730, -0.584788>, <-3.378748, 0.528730, -0.647784>, <-3.344064, 0.515265, -0.731778>, <-3.318052, 0.515265, -0.794774>, 
      <-3.212973, 1.244486, -0.584788>, <-3.190446, 1.231481, -0.647784>, <-3.153677, 1.225800, -0.731778>, <-3.131150, 1.212794, -0.794774>, 
      <-2.948608, 1.702380, -0.584788>, <-2.926081, 1.689374, -0.647784>, <-2.896044, 1.672033, -0.731778>, <-2.873517, 1.659027, -0.794774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.948608, -1.702380, -0.584788>, <-2.926081, -1.689374, -0.647784>, <-2.896044, -1.672032, -0.731778>, <-2.873517, -1.659026, -0.794774>, 
      <-3.212545, -1.245227, -0.614859>, <-3.190018, -1.232221, -0.677855>, <-3.153238, -1.226560, -0.761846>, <-3.130711, -1.213554, -0.824842>, 
      <-3.404760, -0.528730, -0.584788>, <-3.378748, -0.528730, -0.647784>, <-3.344064, -0.515265, -0.731778>, <-3.318052, -0.515265, -0.794774>, 
      <-3.404760, 0.000000, -0.584788>, <-3.378748, 0.000000, -0.647784>, <-3.344064, 0.000000, -0.731778>, <-3.318052, 0.000000, -0.794774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.702380, -2.948608, -0.390834>, <-1.689374, -2.926081, -0.453830>, <-1.672032, -2.896044, -0.537824>, <-1.659026, -2.873517, -0.600819>, 
      <-2.160777, -2.683952, -0.443468>, <-2.147771, -2.661425, -0.506464>, <-2.118781, -2.638113, -0.590461>, <-2.105775, -2.615586, -0.653456>, 
      <-2.683078, -2.162292, -0.554536>, <-2.660550, -2.149286, -0.617532>, <-2.637216, -2.120336, -0.701519>, <-2.614689, -2.107329, -0.764515>, 
      <-2.948608, -1.702380, -0.584788>, <-2.926081, -1.689374, -0.647784>, <-2.896044, -1.672032, -0.731778>, <-2.873517, -1.659026, -0.794774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -3.404760, -0.246223>, <0.000000, -3.378748, -0.309219>, <0.000000, -3.344064, -0.393213>, <0.000000, -3.318052, -0.456208>, 
      <-0.530507, -3.404760, -0.246223>, <-0.530507, -3.378748, -0.309219>, <-0.517088, -3.344064, -0.393213>, <-0.517088, -3.318052, -0.456208>, 
      <-1.245202, -3.212560, -0.338340>, <-1.232196, -3.190032, -0.401336>, <-1.226534, -3.153253, -0.485334>, <-1.213528, -3.130726, -0.548329>, 
      <-1.702380, -2.948608, -0.390834>, <-1.689374, -2.926081, -0.453830>, <-1.672032, -2.896044, -0.537824>, <-1.659026, -2.873517, -0.600819>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <1.702380, -2.948608, -0.390834>, <1.689374, -2.926081, -0.453830>, <1.672032, -2.896044, -0.537824>, <1.659026, -2.873517, -0.600819>, 
      <1.245202, -3.212560, -0.338340>, <1.232196, -3.190032, -0.401336>, <1.226534, -3.153253, -0.485334>, <1.213528, -3.130726, -0.548329>, 
      <0.530507, -3.404760, -0.246223>, <0.530507, -3.378748, -0.309219>, <0.517088, -3.344064, -0.393213>, <0.517088, -3.318052, -0.456208>, 
      <0.000000, -3.404760, -0.246223>, <0.000000, -3.378748, -0.309219>, <0.000000, -3.344064, -0.393213>, <0.000000, -3.318052, -0.456208>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.948608, -1.702380, -0.584788>, <2.926081, -1.689374, -0.647784>, <2.896044, -1.672032, -0.731778>, <2.873517, -1.659026, -0.794774>, 
      <2.683078, -2.162292, -0.554536>, <2.660550, -2.149286, -0.617532>, <2.637216, -2.120336, -0.701519>, <2.614689, -2.107329, -0.764515>, 
      <2.160777, -2.683952, -0.443468>, <2.147771, -2.661425, -0.506464>, <2.118781, -2.638113, -0.590461>, <2.105775, -2.615586, -0.653456>, 
      <1.702380, -2.948608, -0.390834>, <1.689374, -2.926081, -0.453830>, <1.672032, -2.896044, -0.537824>, <1.659026, -2.873517, -0.600819>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.001253, 0.002169, -0.584703>, <0.511591, 0.886101, -0.584729>, <1.192042, 2.064676, -0.584762>, <1.702380, 2.948608, -0.584788>, 
      <0.001590, 0.001975, -0.584703>, <0.511928, 0.885907, -0.584729>, <1.649936, 1.800311, -0.584762>, <2.160274, 2.684243, -0.584788>, 
      <0.001975, 0.001590, -0.584703>, <0.885907, 0.511927, -0.584729>, <1.800311, 1.649935, -0.584762>, <2.684243, 2.160273, -0.584788>, 
      <0.002169, 0.001253, -0.584703>, <0.886101, 0.511591, -0.584729>, <2.064676, 1.192041, -0.584762>, <2.948608, 1.702379, -0.584788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, 0.002505, -0.584703>, <0.000000, 1.023181, -0.584729>, <0.000000, 2.384083, -0.584762>, <0.000000, 3.404760, -0.584788>, 
      <0.000389, 0.002505, -0.584703>, <0.000389, 1.023181, -0.584729>, <0.528730, 2.384083, -0.584762>, <0.528730, 3.404760, -0.584788>, 
      <0.000916, 0.002364, -0.584703>, <0.511254, 0.886295, -0.584729>, <0.734148, 2.329041, -0.584762>, <1.244486, 3.212973, -0.584788>, 
      <0.001253, 0.002169, -0.584703>, <0.511591, 0.886101, -0.584729>, <1.192042, 2.064676, -0.584762>, <1.702380, 2.948608, -0.584788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.001253, 0.002169, -0.584703>, <-0.511591, 0.886101, -0.584729>, <-1.192041, 2.064676, -0.584762>, <-1.702379, 2.948608, -0.584788>, 
      <-0.000916, 0.002364, -0.584703>, <-0.511254, 0.886295, -0.584729>, <-0.734148, 2.329041, -0.584762>, <-1.244486, 3.212973, -0.584788>, 
      <-0.000389, 0.002505, -0.584703>, <-0.000389, 1.023181, -0.584729>, <-0.528730, 2.384083, -0.584762>, <-0.528730, 3.404760, -0.584788>, 
      <0.000000, 0.002505, -0.584703>, <0.000000, 1.023181, -0.584729>, <0.000000, 2.384083, -0.584762>, <0.000000, 3.404760, -0.584788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.002169, 0.001253, -0.584703>, <-0.886101, 0.511591, -0.584729>, <-2.064676, 1.192042, -0.584762>, <-2.948608, 1.702380, -0.584788>, 
      <-0.001975, 0.001590, -0.584703>, <-0.885907, 0.511928, -0.584729>, <-1.800311, 1.649936, -0.584762>, <-2.684243, 2.160274, -0.584788>, 
      <-0.001590, 0.001975, -0.584703>, <-0.511927, 0.885907, -0.584729>, <-1.649935, 1.800311, -0.584762>, <-2.160273, 2.684243, -0.584788>, 
      <-0.001253, 0.002169, -0.584703>, <-0.511591, 0.886101, -0.584729>, <-1.192041, 2.064676, -0.584762>, <-1.702379, 2.948608, -0.584788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.002505, 0.000000, -0.584703>, <-1.023181, 0.000000, -0.584729>, <-2.384083, 0.000000, -0.584762>, <-3.404760, 0.000000, -0.584788>, 
      <-0.002505, 0.000389, -0.584703>, <-1.023181, 0.000389, -0.584729>, <-2.384083, 0.528730, -0.584762>, <-3.404760, 0.528730, -0.584788>, 
      <-0.002364, 0.000916, -0.584703>, <-0.886295, 0.511254, -0.584729>, <-2.329041, 0.734148, -0.584762>, <-3.212973, 1.244486, -0.584788>, 
      <-0.002169, 0.001253, -0.584703>, <-0.886101, 0.511591, -0.584729>, <-2.064676, 1.192042, -0.584762>, <-2.948608, 1.702380, -0.584788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.002169, -0.001253, -0.584703>, <-0.886101, -0.511591, -0.584729>, <-2.064676, -1.192042, -0.584762>, <-2.948608, -1.702380, -0.584788>, 
      <-0.002364, -0.000916, -0.584703>, <-0.886295, -0.511254, -0.584729>, <-2.328614, -0.734889, -0.614833>, <-3.212545, -1.245227, -0.614859>, 
      <-0.002505, -0.000389, -0.584703>, <-1.023181, -0.000389, -0.584729>, <-2.384083, -0.528730, -0.584762>, <-3.404760, -0.528730, -0.584788>, 
      <-0.002505, 0.000000, -0.584703>, <-1.023181, 0.000000, -0.584729>, <-2.384083, 0.000000, -0.584762>, <-3.404760, 0.000000, -0.584788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.001253, -0.002169, -0.584703>, <-0.511591, -0.886101, -0.526542>, <-1.192042, -2.064676, -0.448995>, <-1.702380, -2.948608, -0.390834>, 
      <-0.001590, -0.001975, -0.584703>, <-0.511928, -0.885907, -0.526542>, <-1.650439, -1.800021, -0.501629>, <-2.160777, -2.683952, -0.443468>, 
      <-0.001975, -0.001590, -0.584703>, <-0.885907, -0.511928, -0.584729>, <-1.799146, -1.651954, -0.554510>, <-2.683078, -2.162292, -0.554536>, 
      <-0.002169, -0.001253, -0.584703>, <-0.886101, -0.511591, -0.584729>, <-2.064676, -1.192042, -0.584762>, <-2.948608, -1.702380, -0.584788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.000000, -0.002505, -0.584703>, <0.000000, -1.023181, -0.483159>, <0.000000, -2.384083, -0.347767>, <0.000000, -3.404760, -0.246223>, 
      <-0.000389, -0.002505, -0.584703>, <-0.000389, -1.023181, -0.483159>, <-0.530507, -2.384083, -0.347767>, <-0.530507, -3.404760, -0.246223>, 
      <-0.000916, -0.002364, -0.584703>, <-0.511254, -0.886295, -0.526542>, <-0.734864, -2.328628, -0.396501>, <-1.245202, -3.212560, -0.338340>, 
      <-0.001253, -0.002169, -0.584703>, <-0.511591, -0.886101, -0.526542>, <-1.192042, -2.064676, -0.448995>, <-1.702380, -2.948608, -0.390834>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.001253, -0.002169, -0.584703>, <0.511591, -0.886101, -0.526542>, <1.192042, -2.064676, -0.448995>, <1.702380, -2.948608, -0.390834>, 
      <0.000916, -0.002364, -0.584703>, <0.511254, -0.886295, -0.526542>, <0.734864, -2.328628, -0.396501>, <1.245202, -3.212560, -0.338340>, 
      <0.000389, -0.002505, -0.584703>, <0.000389, -1.023181, -0.483159>, <0.530507, -2.384083, -0.347767>, <0.530507, -3.404760, -0.246223>, 
      <0.000000, -0.002505, -0.584703>, <0.000000, -1.023181, -0.483159>, <0.000000, -2.384083, -0.347767>, <0.000000, -3.404760, -0.246223>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.002169, -0.001253, -0.584703>, <0.886101, -0.511591, -0.584729>, <2.064676, -1.192042, -0.584762>, <2.948608, -1.702380, -0.584788>, 
      <0.001975, -0.001590, -0.584703>, <0.885907, -0.511928, -0.584729>, <1.799146, -1.651954, -0.554510>, <2.683078, -2.162292, -0.554536>, 
      <0.001590, -0.001975, -0.584703>, <0.511928, -0.885907, -0.526542>, <1.650439, -1.800021, -0.501629>, <2.160777, -2.683952, -0.443468>, 
      <0.001253, -0.002169, -0.584703>, <0.511591, -0.886101, -0.526542>, <1.192042, -2.064676, -0.448995>, <1.702380, -2.948608, -0.390834>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.002505, 0.000000, -0.584703>, <1.023181, 0.000000, -0.584729>, <2.384083, 0.000000, -0.584762>, <3.404760, 0.000000, -0.584788>, 
      <0.002505, -0.000389, -0.584703>, <1.023181, -0.000389, -0.584729>, <2.384083, -0.528730, -0.584762>, <3.404760, -0.528730, -0.584788>, 
      <0.002364, -0.000916, -0.584703>, <0.886295, -0.511254, -0.584729>, <2.328614, -0.734889, -0.614833>, <3.212545, -1.245227, -0.614859>, 
      <0.002169, -0.001253, -0.584703>, <0.886101, -0.511591, -0.584729>, <2.064676, -1.192042, -0.584762>, <2.948608, -1.702380, -0.584788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.002505, 0.000000, -0.584703>, <0.002505, 0.000389, -0.584703>, <0.002364, 0.000916, -0.584703>, <0.002169, 0.001253, -0.584703>, 
      <1.023181, 0.000000, -0.584729>, <1.023181, 0.000389, -0.584729>, <0.886295, 0.511254, -0.584729>, <0.886101, 0.511591, -0.584729>, 
      <2.384083, 0.000000, -0.584762>, <2.384083, 0.528730, -0.584762>, <2.329041, 0.734148, -0.584762>, <2.064676, 1.192041, -0.584762>, 
      <3.404760, 0.000000, -0.584788>, <3.404760, 0.528730, -0.584788>, <3.212973, 1.244486, -0.584788>, <2.948608, 1.702379, -0.584788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.318052, 0.000000, -0.794774>, <3.318052, -0.515265, -0.794774>, <3.130711, -1.213554, -0.824842>, <2.873517, -1.659026, -0.794774>, 
      <3.344064, 0.000000, -0.731778>, <3.344064, -0.515265, -0.731778>, <3.153238, -1.226560, -0.761846>, <2.896044, -1.672032, -0.731778>, 
      <3.378748, 0.000000, -0.647784>, <3.378748, -0.528730, -0.647784>, <3.190018, -1.232221, -0.677855>, <2.926081, -1.689374, -0.647784>, 
      <3.404760, 0.000000, -0.584788>, <3.404760, -0.528730, -0.584788>, <3.212545, -1.245227, -0.614859>, <2.948608, -1.702380, -0.584788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.318052, 0.000000, -0.794774>, <3.344064, 0.000000, -0.731778>, <3.378748, 0.000000, -0.647784>, <3.404760, 0.000000, -0.584788>, 
      <3.318052, 0.515265, -0.794774>, <3.344065, 0.515265, -0.731778>, <3.378748, 0.528730, -0.647784>, <3.404760, 0.528730, -0.584788>, 
      <3.131150, 1.212793, -0.794774>, <3.153677, 1.225799, -0.731778>, <3.190446, 1.231479, -0.647784>, <3.212973, 1.244486, -0.584788>, 
      <2.873518, 1.659025, -0.794774>, <2.896045, 1.672031, -0.731778>, <2.926081, 1.689373, -0.647784>, <2.948608, 1.702379, -0.584788>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.576723, 0.000000, -0.794794>, <3.576723, -0.555435, -0.794794>, <3.374843, -1.308047, -0.824869>, <3.097533, -1.788362, -0.794794>, 
      <3.499122, 0.000000, -0.794788>, <3.499122, -0.555435, -0.794788>, <3.307638, -1.269246, -0.824863>, <3.030328, -1.749561, -0.794788>, 
      <3.395653, 0.000000, -0.794780>, <3.395653, -0.515265, -0.794780>, <3.197915, -1.252355, -0.824848>, <2.940722, -1.697827, -0.794780>, 
      <3.318052, 0.000000, -0.794774>, <3.318052, -0.515265, -0.794774>, <3.130711, -1.213554, -0.824842>, <2.873517, -1.659026, -0.794774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.576723, 0.000000, -0.794794>, <3.499122, 0.000000, -0.794788>, <3.395653, 0.000000, -0.794780>, <3.318052, 0.000000, -0.794774>, 
      <3.576723, 0.555434, -0.794794>, <3.499122, 0.555434, -0.794788>, <3.395654, 0.515265, -0.794780>, <3.318052, 0.515265, -0.794774>, 
      <3.375251, 1.307341, -0.794794>, <3.308046, 1.268540, -0.794788>, <3.198355, 1.251594, -0.794780>, <3.131150, 1.212793, -0.794774>, 
      <3.097534, 1.788361, -0.794794>, <3.030329, 1.749560, -0.794788>, <2.940723, 1.697826, -0.794780>, <2.873518, 1.659025, -0.794774>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.604892, 0.000000, -0.479432>, <3.604892, -0.559809, -0.479432>, <3.401428, -1.318337, -0.509508>, <3.121928, -1.802446, -0.479432>, 
      <3.596441, 0.000000, -0.574041>, <3.596441, -0.559809, -0.574041>, <3.394110, -1.314112, -0.604117>, <3.114609, -1.798221, -0.574041>, 
      <3.585174, 0.000000, -0.700185>, <3.585174, -0.555435, -0.700185>, <3.382161, -1.312273, -0.730261>, <3.104851, -1.792587, -0.700185>, 
      <3.576723, 0.000000, -0.794794>, <3.576723, -0.555435, -0.794794>, <3.374843, -1.308047, -0.824869>, <3.097533, -1.788362, -0.794794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.604892, 0.000000, -0.479432>, <3.596441, 0.000000, -0.574041>, <3.585174, 0.000000, -0.700185>, <3.576723, 0.000000, -0.794794>, 
      <3.604892, 0.559809, -0.479432>, <3.596442, 0.559809, -0.574041>, <3.585174, 0.555434, -0.700185>, <3.576723, 0.555434, -0.794794>, 
      <3.401833, 1.317637, -0.479432>, <3.394514, 1.313411, -0.574041>, <3.382569, 1.311566, -0.700185>, <3.375251, 1.307341, -0.794794>, 
      <3.121929, 1.802445, -0.479432>, <3.114610, 1.798220, -0.574041>, <3.104852, 1.792586, -0.700185>, <3.097534, 1.788361, -0.794794>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.027522, 0.000000, -0.479432>, <0.027522, -0.004274, -0.479432>, <0.025971, -0.010060, -0.479432>, <0.023834, -0.013761, -0.479432>, 
      <1.100733, 0.000000, -0.479432>, <1.100733, -0.004274, -0.479432>, <0.955399, -0.546665, -0.479432>, <0.953262, -0.550366, -0.479432>, 
      <2.531681, 0.000000, -0.479432>, <2.531681, -0.559809, -0.479432>, <2.472000, -0.781732, -0.509508>, <2.192500, -1.265840, -0.479432>, 
      <3.604892, 0.000000, -0.479432>, <3.604892, -0.559809, -0.479432>, <3.401428, -1.318337, -0.509508>, <3.121928, -1.802446, -0.479432>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <0.027522, 0.000000, -0.479432>, <1.100733, 0.000000, -0.479432>, <2.531681, 0.000000, -0.479432>, <3.604892, 0.000000, -0.479432>, 
      <0.027522, 0.004274, -0.479432>, <1.100733, 0.004274, -0.479432>, <2.531681, 0.559809, -0.479432>, <3.604892, 0.559809, -0.479432>, 
      <0.025971, 0.010060, -0.479432>, <0.955400, 0.546665, -0.479432>, <2.472404, 0.781031, -0.479432>, <3.401833, 1.317637, -0.479432>, 
      <0.023834, 0.013761, -0.479432>, <0.953263, 0.550366, -0.479432>, <2.192500, 1.265840, -0.479432>, <3.121929, 1.802445, -0.479432>
    }
  }
  material {
    tapa_txt
  }
}
#declare boterana = union {
  object { bote }
  object { tapa }
  material {
    tapa_txt
  }
}
#declare sPatchObj = union { 
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.353822, 2.011065, -0.325852>, <-2.292490, 1.967564, -0.343437>, <-2.234977, 1.987969, -0.416230>, <-2.216604, 2.042120, -0.468126>, 
      <-2.419594, 1.933873, -0.405165>, <-2.358262, 1.890372, -0.422751>, <-2.305589, 1.903501, -0.477007>, <-2.287216, 1.957652, -0.528903>, 
      <-2.517503, 1.828865, -0.501569>, <-2.486812, 1.806931, -0.497761>, <-2.430748, 1.807810, -0.526945>, <-2.417895, 1.839110, -0.544054>, 
      <-2.576846, 1.736580, -0.568927>, <-2.546154, 1.714646, -0.565118>, <-2.493986, 1.709603, -0.573538>, <-2.481133, 1.740902, -0.590647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.437931, 2.199102, -0.404666>, <-2.458184, 2.139412, -0.347462>, <-2.421427, 2.059016, -0.306468>, <-2.353822, 2.011065, -0.325852>, 
      <-2.494434, 2.098314, -0.474629>, <-2.514687, 2.038624, -0.417424>, <-2.487198, 1.981824, -0.385781>, <-2.419594, 1.933873, -0.405165>, 
      <-2.568841, 1.949610, -0.545986>, <-2.585248, 1.909659, -0.524147>, <-2.556679, 1.856862, -0.506431>, <-2.517503, 1.828865, -0.501569>, 
      <-2.626384, 1.844707, -0.608673>, <-2.642791, 1.804755, -0.586835>, <-2.616022, 1.764578, -0.573789>, <-2.576846, 1.736580, -0.568927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.275494, 2.241921, -0.547094>, <-2.343002, 2.289803, -0.527738>, <-2.417707, 2.258707, -0.461789>, <-2.437931, 2.199102, -0.404666>, 
      <-2.353003, 2.135322, -0.601926>, <-2.420511, 2.183204, -0.582570>, <-2.474211, 2.157919, -0.531752>, <-2.494434, 2.098314, -0.474629>, 
      <-2.462107, 1.966259, -0.586417>, <-2.492799, 1.988194, -0.590226>, <-2.555988, 1.980911, -0.563095>, <-2.568841, 1.949610, -0.545986>, 
      <-2.530668, 1.849029, -0.630394>, <-2.561360, 1.870964, -0.634203>, <-2.613530, 1.876007, -0.625782>, <-2.626384, 1.844707, -0.608673>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.275494, 2.241921, -0.547094>, <-2.353003, 2.135322, -0.601926>, <-2.462107, 1.966259, -0.586417>, <-2.530668, 1.849029, -0.630394>, 
      <-2.207211, 2.193490, -0.566672>, <-2.284720, 2.086891, -0.621505>, <-2.422931, 1.938262, -0.581555>, <-2.491493, 1.821032, -0.625532>, 
      <-2.196148, 2.102409, -0.525904>, <-2.266761, 2.017941, -0.586681>, <-2.401489, 1.879061, -0.565892>, <-2.464727, 1.780854, -0.612485>, 
      <-2.216604, 2.042120, -0.468126>, <-2.287216, 1.957652, -0.528903>, <-2.417895, 1.839110, -0.544054>, <-2.481133, 1.740902, -0.590647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.705132, 1.658754, -0.770648>, <-2.659896, 1.723100, -0.741370>, <-2.623691, 1.806110, -0.670631>, <-2.588787, 1.869263, -0.627766>, 
      <-2.714033, 1.658598, -0.768215>, <-2.668797, 1.722944, -0.738937>, <-2.631160, 1.805773, -0.668936>, <-2.596256, 1.868926, -0.626071>, 
      <-2.725784, 1.656207, -0.763321>, <-2.677962, 1.718024, -0.733283>, <-2.642316, 1.803155, -0.664392>, <-2.606117, 1.866131, -0.622748>, 
      <-2.732686, 1.652351, -0.758561>, <-2.684864, 1.714168, -0.728522>, <-2.648223, 1.799296, -0.661392>, <-2.612024, 1.862273, -0.619748>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.668760, 1.653473, -0.776035>, <-2.625692, 1.718264, -0.746036>, <-2.592779, 1.801272, -0.674863>, <-2.560216, 1.864614, -0.631503>, 
      <-2.679476, 1.656496, -0.775576>, <-2.636408, 1.721287, -0.745577>, <-2.601041, 1.804148, -0.674489>, <-2.568478, 1.867490, -0.631129>, 
      <-2.694384, 1.658943, -0.773586>, <-2.649148, 1.723288, -0.744308>, <-2.615160, 1.806496, -0.672566>, <-2.580256, 1.869649, -0.629702>, 
      <-2.705132, 1.658754, -0.770648>, <-2.659896, 1.723100, -0.741370>, <-2.623691, 1.806110, -0.670631>, <-2.588787, 1.869263, -0.627766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.629098, 1.637307, -0.773906>, <-2.590748, 1.703646, -0.744102>, <-2.570157, 1.781509, -0.655723>, <-2.530668, 1.849029, -0.630394>, 
      <-2.640357, 1.643300, -0.775591>, <-2.602006, 1.709639, -0.745786>, <-2.578273, 1.787310, -0.656731>, <-2.538785, 1.854830, -0.631401>, 
      <-2.656389, 1.649983, -0.776565>, <-2.613321, 1.714774, -0.746566>, <-2.583318, 1.797978, -0.675290>, <-2.550755, 1.861320, -0.631931>, 
      <-2.668760, 1.653473, -0.776035>, <-2.625692, 1.718264, -0.746036>, <-2.592779, 1.801272, -0.674863>, <-2.560216, 1.864614, -0.631503>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.592200, 1.612723, -0.764580>, <-2.561065, 1.680558, -0.734023>, <-2.530905, 1.761239, -0.666597>, <-2.504636, 1.824889, -0.624604>, 
      <-2.602285, 1.621023, -0.768344>, <-2.571150, 1.688858, -0.737788>, <-2.537676, 1.769312, -0.668931>, <-2.511406, 1.832961, -0.626938>, 
      <-2.617203, 1.630976, -0.772126>, <-2.578852, 1.697315, -0.742322>, <-2.561422, 1.775265, -0.654639>, <-2.521933, 1.842786, -0.629310>, 
      <-2.629098, 1.637307, -0.773906>, <-2.590748, 1.703646, -0.744102>, <-2.570157, 1.781509, -0.655723>, <-2.530668, 1.849029, -0.630394>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.563672, 1.583463, -0.749483>, <-2.538680, 1.651642, -0.718557>, <-2.509355, 1.732142, -0.655358>, <-2.486076, 1.795862, -0.615018>, 
      <-2.570832, 1.592949, -0.754920>, <-2.545840, 1.661128, -0.723994>, <-2.513593, 1.741393, -0.658758>, <-2.490314, 1.805113, -0.618418>, 
      <-2.582503, 1.604743, -0.760960>, <-2.551368, 1.672578, -0.730403>, <-2.524174, 1.753214, -0.664276>, <-2.497905, 1.816863, -0.622283>, 
      <-2.592200, 1.612723, -0.764580>, <-2.561065, 1.680558, -0.734023>, <-2.530905, 1.761239, -0.666597>, <-2.504636, 1.824889, -0.624604>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.547859, 1.553976, -0.730909>, <-2.529499, 1.621796, -0.698737>, <-2.498834, 1.702651, -0.641439>, <-2.477824, 1.766369, -0.603094>, 
      <-2.550624, 1.563144, -0.737243>, <-2.532263, 1.630964, -0.705070>, <-2.499642, 1.711634, -0.645422>, <-2.478632, 1.775352, -0.607077>, 
      <-2.557383, 1.575130, -0.744707>, <-2.532390, 1.643309, -0.713781>, <-2.505460, 1.723641, -0.652233>, <-2.482181, 1.787361, -0.611893>, 
      <-2.563672, 1.583463, -0.749483>, <-2.538680, 1.651642, -0.718557>, <-2.509355, 1.732142, -0.655358>, <-2.486076, 1.795862, -0.615018>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.547173, 1.528752, -0.711686>, <-2.536919, 1.597022, -0.680130>, <-2.519303, 1.681624, -0.618770>, <-2.481133, 1.740902, -0.590647>, 
      <-2.544875, 1.535774, -0.717684>, <-2.534621, 1.604044, -0.686128>, <-2.516401, 1.688692, -0.622633>, <-2.478230, 1.747970, -0.594510>, 
      <-2.545567, 1.546377, -0.725659>, <-2.527207, 1.614197, -0.693487>, <-2.498133, 1.694851, -0.637980>, <-2.477123, 1.758569, -0.599635>, 
      <-2.547859, 1.553976, -0.730909>, <-2.529499, 1.621796, -0.698737>, <-2.498834, 1.702651, -0.641439>, <-2.477824, 1.766369, -0.603094>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.561713, 1.511641, -0.694744>, <-2.544518, 1.577743, -0.663815>, <-2.515362, 1.659828, -0.614125>, <-2.495497, 1.723336, -0.579574>, 
      <-2.555402, 1.515167, -0.699097>, <-2.538207, 1.581269, -0.668168>, <-2.509526, 1.663640, -0.617089>, <-2.489661, 1.727148, -0.582538>, 
      <-2.549211, 1.522526, -0.706367>, <-2.538956, 1.590796, -0.674811>, <-2.521871, 1.675371, -0.615353>, <-2.483701, 1.734649, -0.587229>, 
      <-2.547173, 1.528752, -0.711686>, <-2.536919, 1.597022, -0.680130>, <-2.519303, 1.681624, -0.618770>, <-2.481133, 1.740902, -0.590647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.589266, 1.505236, -0.682657>, <-2.565806, 1.570009, -0.653956>, <-2.539890, 1.653011, -0.604886>, <-2.518729, 1.716343, -0.571555>, 
      <-2.580365, 1.505393, -0.685090>, <-2.556906, 1.570166, -0.656389>, <-2.532422, 1.653348, -0.606581>, <-2.511261, 1.716681, -0.573250>, 
      <-2.568615, 1.507785, -0.689984>, <-2.551420, 1.573887, -0.659055>, <-2.521268, 1.655969, -0.611126>, <-2.501403, 1.719478, -0.576575>, 
      <-2.561713, 1.511641, -0.694744>, <-2.544518, 1.577743, -0.663815>, <-2.515362, 1.659828, -0.614125>, <-2.495497, 1.723336, -0.579574>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.625641, 1.510516, -0.677267>, <-2.596309, 1.573410, -0.648953>, <-2.570799, 1.657851, -0.600653>, <-2.547295, 1.720995, -0.567818>, 
      <-2.614924, 1.507493, -0.677727>, <-2.585592, 1.570387, -0.649413>, <-2.562539, 1.654975, -0.601026>, <-2.539035, 1.718119, -0.568192>, 
      <-2.600015, 1.505047, -0.679719>, <-2.576555, 1.569820, -0.651017>, <-2.548419, 1.652625, -0.602950>, <-2.527258, 1.715958, -0.569619>, 
      <-2.589266, 1.505236, -0.682657>, <-2.565806, 1.570009, -0.653956>, <-2.539890, 1.653011, -0.604886>, <-2.518729, 1.716343, -0.571555>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.665297, 1.526683, -0.679397>, <-2.627174, 1.586841, -0.653030>, <-2.611851, 1.682142, -0.608660>, <-2.576846, 1.736580, -0.568927>, 
      <-2.654040, 1.520691, -0.677713>, <-2.615917, 1.580848, -0.651346>, <-2.603734, 1.676341, -0.607653>, <-2.568729, 1.730778, -0.567920>, 
      <-2.638011, 1.514005, -0.676737>, <-2.608678, 1.576899, -0.648423>, <-2.580261, 1.661146, -0.600225>, <-2.556757, 1.724290, -0.567390>, 
      <-2.625641, 1.510516, -0.677267>, <-2.596309, 1.573410, -0.648953>, <-2.570799, 1.657851, -0.600653>, <-2.547295, 1.720995, -0.567818>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.702198, 1.551269, -0.688720>, <-2.659174, 1.609962, -0.662074>, <-2.632675, 1.697887, -0.608915>, <-2.602880, 1.760723, -0.574713>, 
      <-2.692113, 1.542969, -0.684955>, <-2.649089, 1.601662, -0.658309>, <-2.625904, 1.689814, -0.606581>, <-2.596109, 1.752650, -0.572379>, 
      <-2.677193, 1.533015, -0.681177>, <-2.639070, 1.593173, -0.654810>, <-2.620587, 1.688386, -0.609744>, <-2.585582, 1.742824, -0.570011>, 
      <-2.665297, 1.526683, -0.679397>, <-2.627174, 1.586841, -0.653030>, <-2.611851, 1.682142, -0.608660>, <-2.576846, 1.736580, -0.568927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.730726, 1.580532, -0.703820>, <-2.685858, 1.640252, -0.676980>, <-2.654224, 1.726982, -0.620157>, <-2.621438, 1.789747, -0.584301>, 
      <-2.723566, 1.571045, -0.698382>, <-2.678698, 1.630765, -0.671542>, <-2.649986, 1.717733, -0.616756>, <-2.617200, 1.780497, -0.580901>, 
      <-2.711895, 1.559250, -0.692340>, <-2.668871, 1.617943, -0.665694>, <-2.639406, 1.705912, -0.611236>, <-2.609611, 1.768748, -0.577033>, 
      <-2.702198, 1.551269, -0.688720>, <-2.659174, 1.609962, -0.662074>, <-2.632675, 1.697887, -0.608915>, <-2.602880, 1.760723, -0.574713>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.746539, 1.610016, -0.722394>, <-2.696277, 1.667478, -0.694590>, <-2.664746, 1.756473, -0.634075>, <-2.629692, 1.819240, -0.596224>, 
      <-2.743774, 1.600849, -0.716060>, <-2.693511, 1.658311, -0.688257>, <-2.663938, 1.747490, -0.630092>, <-2.628884, 1.810257, -0.592241>, 
      <-2.737015, 1.588864, -0.708596>, <-2.692147, 1.648584, -0.681756>, <-2.658120, 1.735484, -0.623282>, <-2.625333, 1.798248, -0.587426>, 
      <-2.730726, 1.580532, -0.703820>, <-2.685858, 1.640252, -0.676980>, <-2.654224, 1.726982, -0.620157>, <-2.621438, 1.789747, -0.584301>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.747229, 1.635237, -0.741616>, <-2.693458, 1.690746, -0.711928>, <-2.661652, 1.780411, -0.647094>, <-2.626384, 1.844707, -0.608673>, 
      <-2.749527, 1.628216, -0.735618>, <-2.695755, 1.683725, -0.705930>, <-2.664554, 1.773344, -0.643231>, <-2.629286, 1.837639, -0.604809>, 
      <-2.748831, 1.617614, -0.727644>, <-2.698569, 1.675076, -0.699840>, <-2.665448, 1.764273, -0.637534>, <-2.630394, 1.827040, -0.599683>, 
      <-2.746539, 1.610016, -0.722394>, <-2.696277, 1.667478, -0.694590>, <-2.664746, 1.756473, -0.634075>, <-2.629692, 1.819240, -0.596224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.747229, 1.635237, -0.741616>, <-2.745191, 1.641465, -0.746936>, <-2.738999, 1.648825, -0.754208>, <-2.732686, 1.652351, -0.758561>, 
      <-2.693458, 1.690746, -0.711928>, <-2.691420, 1.696973, -0.717248>, <-2.691176, 1.710641, -0.724169>, <-2.684864, 1.714168, -0.728522>, 
      <-2.661652, 1.780411, -0.647094>, <-2.659085, 1.786664, -0.650512>, <-2.654058, 1.795485, -0.658428>, <-2.648223, 1.799296, -0.661392>, 
      <-2.626384, 1.844707, -0.608673>, <-2.623817, 1.850960, -0.612091>, <-2.617860, 1.858461, -0.616784>, <-2.612024, 1.862273, -0.619748>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.837528, 1.515442, -0.788759>, <-2.876375, 1.481587, -0.787322>, <-2.973475, 1.436214, -0.809521>, <-2.978154, 1.420818, -0.760548>, 
      <-2.846075, 1.522891, -0.784409>, <-2.884921, 1.489036, -0.782972>, <-2.973265, 1.436905, -0.813093>, <-2.977945, 1.421509, -0.764120>, 
      <-2.847930, 1.539657, -0.777492>, <-2.889029, 1.513221, -0.783187>, <-2.949121, 1.488272, -0.794993>, <-2.990063, 1.461117, -0.797579>, 
      <-2.855118, 1.548041, -0.772442>, <-2.896216, 1.521605, -0.778137>, <-2.961106, 1.506240, -0.793301>, <-3.002048, 1.479084, -0.795887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.837528, 1.515442, -0.788759>, <-2.793229, 1.554048, -0.790398>, <-2.736816, 1.613686, -0.791155>, <-2.705132, 1.658754, -0.770648>, 
      <-2.846075, 1.522891, -0.784409>, <-2.801775, 1.561497, -0.786048>, <-2.745717, 1.613529, -0.788722>, <-2.714033, 1.658598, -0.768215>, 
      <-2.847930, 1.539657, -0.777492>, <-2.807471, 1.565683, -0.771885>, <-2.753446, 1.620450, -0.780697>, <-2.725784, 1.656207, -0.763321>, 
      <-2.855118, 1.548041, -0.772442>, <-2.814659, 1.574066, -0.766836>, <-2.760348, 1.616594, -0.775936>, <-2.732686, 1.652351, -0.758561>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.801635, 1.501429, -0.799663>, <-2.833508, 1.462990, -0.804085>, <-2.876091, 1.411288, -0.807328>, <-2.904055, 1.369704, -0.808681>, 
      <-2.811759, 1.507650, -0.797890>, <-2.843632, 1.469210, -0.802313>, <-2.898114, 1.432561, -0.806851>, <-2.926078, 1.390978, -0.808204>, 
      <-2.829072, 1.508073, -0.793063>, <-2.867919, 1.474218, -0.791625>, <-2.973179, 1.437191, -0.814571>, <-2.977859, 1.421795, -0.765598>, 
      <-2.837528, 1.515442, -0.788759>, <-2.876375, 1.481587, -0.787322>, <-2.973475, 1.436214, -0.809521>, <-2.978154, 1.420818, -0.760548>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.801635, 1.501429, -0.799663>, <-2.762857, 1.548196, -0.794283>, <-2.700262, 1.606082, -0.797978>, <-2.668760, 1.653473, -0.776035>, 
      <-2.811759, 1.507650, -0.797890>, <-2.772980, 1.554416, -0.792510>, <-2.710979, 1.609104, -0.797519>, <-2.679476, 1.656496, -0.775576>, 
      <-2.829072, 1.508073, -0.793063>, <-2.784773, 1.546679, -0.794701>, <-2.726068, 1.613874, -0.794093>, <-2.694384, 1.658943, -0.773586>, 
      <-2.837528, 1.515442, -0.788759>, <-2.793229, 1.554048, -0.790398>, <-2.736816, 1.613686, -0.791155>, <-2.705132, 1.658754, -0.770648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.753398, 1.463746, -0.803490>, <-2.786515, 1.415741, -0.801935>, <-2.848969, 1.322919, -0.817890>, <-2.858307, 1.305049, -0.763144>, 
      <-2.769524, 1.472605, -0.803490>, <-2.802641, 1.424599, -0.801935>, <-2.848704, 1.323793, -0.822410>, <-2.858042, 1.305923, -0.767664>, 
      <-2.786130, 1.491902, -0.802378>, <-2.818004, 1.453462, -0.806800>, <-2.856380, 1.392248, -0.807755>, <-2.884344, 1.350664, -0.809108>, 
      <-2.801635, 1.501429, -0.799663>, <-2.833508, 1.462990, -0.804085>, <-2.876091, 1.411288, -0.807328>, <-2.904055, 1.369704, -0.808681>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.753398, 1.463746, -0.803490>, <-2.716697, 1.516948, -0.805213>, <-2.659256, 1.585138, -0.797344>, <-2.629098, 1.637307, -0.773906>, 
      <-2.769524, 1.472605, -0.803490>, <-2.732823, 1.525807, -0.805213>, <-2.670515, 1.591131, -0.799028>, <-2.640357, 1.643300, -0.775591>, 
      <-2.786130, 1.491902, -0.802378>, <-2.747352, 1.538669, -0.796998>, <-2.687891, 1.602592, -0.798508>, <-2.656389, 1.649983, -0.776565>, 
      <-2.801635, 1.501429, -0.799663>, <-2.762857, 1.548196, -0.794283>, <-2.700262, 1.606082, -0.797978>, <-2.668760, 1.653473, -0.776035>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.683007, 1.436262, -0.799663>, <-2.656835, 1.490252, -0.792219>, <-2.615540, 1.561871, -0.787486>, <-2.592200, 1.612723, -0.764580>, 
      <-2.703953, 1.444664, -0.802094>, <-2.677781, 1.498654, -0.794650>, <-2.625624, 1.570171, -0.791251>, <-2.602285, 1.621023, -0.768344>, 
      <-2.733503, 1.452817, -0.803490>, <-2.696802, 1.506019, -0.805213>, <-2.647361, 1.578807, -0.795564>, <-2.617203, 1.630976, -0.772126>, 
      <-2.753398, 1.463746, -0.803490>, <-2.716697, 1.516948, -0.805213>, <-2.659256, 1.585138, -0.797344>, <-2.629098, 1.637307, -0.773906>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.683007, 1.436262, -0.799663>, <-2.702707, 1.395623, -0.805267>, <-2.728439, 1.340417, -0.806654>, <-2.744781, 1.297965, -0.807981>, 
      <-2.703953, 1.444664, -0.802094>, <-2.723653, 1.404025, -0.807698>, <-2.763212, 1.352086, -0.806504>, <-2.779554, 1.309634, -0.807830>, 
      <-2.733503, 1.452817, -0.803490>, <-2.766620, 1.404812, -0.801935>, <-2.848614, 1.324089, -0.823938>, <-2.857953, 1.306219, -0.769192>, 
      <-2.753398, 1.463746, -0.803490>, <-2.786515, 1.415741, -0.801935>, <-2.848969, 1.322919, -0.817890>, <-2.858307, 1.305049, -0.763144>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.626481, 1.412836, -0.788759>, <-2.643613, 1.362390, -0.790910>, <-2.670594, 1.262964, -0.813383>, <-2.678693, 1.244775, -0.763922>, 
      <-2.644066, 1.417191, -0.793169>, <-2.661198, 1.366746, -0.795320>, <-2.670317, 1.263879, -0.818112>, <-2.678416, 1.245690, -0.768651>, 
      <-2.665801, 1.429360, -0.797666>, <-2.685501, 1.388721, -0.803270>, <-2.701252, 1.331294, -0.806772>, <-2.717593, 1.288842, -0.808099>, 
      <-2.683007, 1.436262, -0.799663>, <-2.702707, 1.395623, -0.805267>, <-2.728439, 1.340417, -0.806654>, <-2.744781, 1.297965, -0.807981>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.626481, 1.412836, -0.788759>, <-2.608551, 1.465633, -0.786508>, <-2.581342, 1.535258, -0.771349>, <-2.563672, 1.583463, -0.749483>, 
      <-2.644066, 1.417191, -0.793169>, <-2.626136, 1.469988, -0.790918>, <-2.588502, 1.544744, -0.776786>, <-2.570832, 1.592949, -0.754920>, 
      <-2.665801, 1.429360, -0.797666>, <-2.639629, 1.483351, -0.790222>, <-2.605843, 1.553891, -0.783867>, <-2.582503, 1.604743, -0.760960>, 
      <-2.683007, 1.436262, -0.799663>, <-2.656835, 1.490252, -0.792219>, <-2.615540, 1.561871, -0.787486>, <-2.592200, 1.612723, -0.764580>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.574469, 1.409381, -0.772442>, <-2.580318, 1.367916, -0.783025>, <-2.584061, 1.312330, -0.800106>, <-2.587991, 1.269453, -0.803526>, 
      <-2.589349, 1.413176, -0.778161>, <-2.595197, 1.371711, -0.788744>, <-2.614582, 1.310264, -0.800875>, <-2.618512, 1.267387, -0.804295>, 
      <-2.611027, 1.409009, -0.784883>, <-2.628159, 1.358563, -0.787034>, <-2.670298, 1.263940, -0.818429>, <-2.678398, 1.245751, -0.768968>, 
      <-2.626481, 1.412836, -0.788759>, <-2.643613, 1.362390, -0.790910>, <-2.670594, 1.262964, -0.813383>, <-2.678693, 1.244775, -0.763922>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.574469, 1.409381, -0.772442>, <-2.568263, 1.453382, -0.761212>, <-2.558749, 1.513752, -0.749991>, <-2.547859, 1.553976, -0.730909>, 
      <-2.589349, 1.413176, -0.778161>, <-2.583142, 1.457177, -0.766931>, <-2.561513, 1.522920, -0.756324>, <-2.550624, 1.563144, -0.737243>, 
      <-2.611027, 1.409009, -0.784883>, <-2.593096, 1.461806, -0.782632>, <-2.575053, 1.526925, -0.766573>, <-2.557383, 1.575130, -0.744707>, 
      <-2.626481, 1.412836, -0.788759>, <-2.608551, 1.465633, -0.786508>, <-2.581342, 1.535258, -0.771349>, <-2.563672, 1.583463, -0.749483>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.533953, 1.389234, -0.753196>, <-2.530585, 1.349630, -0.760195>, <-2.521415, 1.295500, -0.758350>, <-2.523914, 1.255254, -0.760022>, 
      <-2.531559, 1.394814, -0.766640>, <-2.528192, 1.355210, -0.773639>, <-2.520059, 1.299978, -0.781504>, <-2.522559, 1.259732, -0.783176>, 
      <-2.561074, 1.405964, -0.767294>, <-2.566923, 1.364499, -0.777877>, <-2.560501, 1.313926, -0.799512>, <-2.564430, 1.271048, -0.802932>, 
      <-2.574469, 1.409381, -0.772442>, <-2.580318, 1.367916, -0.783025>, <-2.584061, 1.312330, -0.800106>, <-2.587991, 1.269453, -0.803526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.533953, 1.389234, -0.753196>, <-2.537612, 1.432263, -0.745591>, <-2.553097, 1.489315, -0.729915>, <-2.547173, 1.528752, -0.711686>, 
      <-2.531559, 1.394814, -0.766640>, <-2.535219, 1.437843, -0.759035>, <-2.550799, 1.496336, -0.735913>, <-2.544875, 1.535774, -0.717684>, 
      <-2.561074, 1.405964, -0.767294>, <-2.554868, 1.449965, -0.756064>, <-2.556457, 1.506153, -0.744741>, <-2.545567, 1.546377, -0.725659>, 
      <-2.574469, 1.409381, -0.772442>, <-2.568263, 1.453382, -0.761212>, <-2.558749, 1.513752, -0.749991>, <-2.547859, 1.553976, -0.730909>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.581322, 1.393403, -0.733948>, <-2.586397, 1.351394, -0.737848>, <-2.589302, 1.295393, -0.718492>, <-2.592953, 1.253057, -0.718748>, 
      <-2.566761, 1.393760, -0.738919>, <-2.571836, 1.351751, -0.742819>, <-2.565225, 1.297023, -0.717885>, <-2.568876, 1.254687, -0.718141>, 
      <-2.536450, 1.383412, -0.739170>, <-2.533082, 1.343808, -0.746170>, <-2.522799, 1.290924, -0.734688>, <-2.525299, 1.250678, -0.736360>, 
      <-2.533953, 1.389234, -0.753196>, <-2.530585, 1.349630, -0.760195>, <-2.521415, 1.295500, -0.758350>, <-2.523914, 1.255254, -0.760022>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.581322, 1.393403, -0.733948>, <-2.576804, 1.430802, -0.730476>, <-2.570389, 1.478289, -0.710349>, <-2.561713, 1.511641, -0.694744>, 
      <-2.566761, 1.393760, -0.738919>, <-2.562243, 1.431159, -0.735447>, <-2.564077, 1.481815, -0.714702>, <-2.555402, 1.515167, -0.699097>, 
      <-2.536450, 1.383412, -0.739170>, <-2.540109, 1.426441, -0.731566>, <-2.555134, 1.483088, -0.724596>, <-2.549211, 1.522526, -0.706367>, 
      <-2.533953, 1.389234, -0.753196>, <-2.537612, 1.432263, -0.745591>, <-2.553097, 1.489315, -0.729915>, <-2.547173, 1.528752, -0.711686>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.638128, 1.386679, -0.717631>, <-2.625709, 1.422851, -0.706345>, <-2.601800, 1.470628, -0.697992>, <-2.589266, 1.505236, -0.682657>, 
      <-2.621046, 1.383722, -0.721862>, <-2.608627, 1.419893, -0.710577>, <-2.592900, 1.470785, -0.700425>, <-2.580365, 1.505393, -0.685090>, 
      <-2.598206, 1.392989, -0.728184>, <-2.593687, 1.430388, -0.724712>, <-2.577291, 1.474433, -0.705589>, <-2.568615, 1.507785, -0.689984>, 
      <-2.581322, 1.393403, -0.733948>, <-2.576804, 1.430802, -0.730476>, <-2.570389, 1.478289, -0.710349>, <-2.561713, 1.511641, -0.694744>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.638128, 1.386679, -0.717631>, <-2.652581, 1.344585, -0.730765>, <-2.685742, 1.228945, -0.720876>, <-2.678693, 1.244775, -0.763922>, 
      <-2.621046, 1.383722, -0.721862>, <-2.635499, 1.341628, -0.734996>, <-2.686023, 1.228015, -0.716064>, <-2.678975, 1.243845, -0.759110>, 
      <-2.598206, 1.392989, -0.728184>, <-2.603281, 1.350980, -0.732084>, <-2.618406, 1.293422, -0.719225>, <-2.622057, 1.251087, -0.719481>, 
      <-2.581322, 1.393403, -0.733948>, <-2.586397, 1.351394, -0.737848>, <-2.589302, 1.295393, -0.718492>, <-2.592953, 1.253057, -0.718748>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.691205, 1.412426, -0.706730>, <-2.674030, 1.444231, -0.701791>, <-2.639919, 1.479903, -0.691049>, <-2.625641, 1.510516, -0.677267>, 
      <-2.674229, 1.406756, -0.708618>, <-2.657054, 1.438561, -0.703679>, <-2.629201, 1.476880, -0.691508>, <-2.614924, 1.507493, -0.677727>, 
      <-2.655356, 1.389662, -0.713364>, <-2.642937, 1.425833, -0.702078>, <-2.612549, 1.470439, -0.695053>, <-2.600015, 1.505047, -0.679719>, 
      <-2.638128, 1.386679, -0.717631>, <-2.625709, 1.422851, -0.706345>, <-2.601800, 1.470628, -0.697992>, <-2.589266, 1.505236, -0.682657>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.691205, 1.412426, -0.706730>, <-2.711757, 1.374368, -0.712641>, <-2.734696, 1.320307, -0.710751>, <-2.750332, 1.279618, -0.713126>, 
      <-2.674229, 1.406756, -0.708618>, <-2.694782, 1.368698, -0.714529>, <-2.707825, 1.311290, -0.710868>, <-2.723461, 1.270601, -0.713242>, 
      <-2.655356, 1.389662, -0.713364>, <-2.669809, 1.347568, -0.726497>, <-2.686015, 1.228041, -0.716202>, <-2.678967, 1.243871, -0.759248>, 
      <-2.638128, 1.386679, -0.717631>, <-2.652581, 1.344585, -0.730765>, <-2.685742, 1.228945, -0.720876>, <-2.678693, 1.244775, -0.763922>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.770556, 1.430912, -0.702901>, <-2.743227, 1.462294, -0.691043>, <-2.687019, 1.492407, -0.694420>, <-2.665297, 1.526683, -0.679397>, 
      <-2.748331, 1.420674, -0.702901>, <-2.721002, 1.452056, -0.691043>, <-2.675762, 1.486415, -0.692736>, <-2.654040, 1.520691, -0.677713>, 
      <-2.714286, 1.420135, -0.704163>, <-2.697111, 1.451940, -0.699223>, <-2.652288, 1.483392, -0.690518>, <-2.638011, 1.514005, -0.676737>, 
      <-2.691205, 1.412426, -0.706730>, <-2.674030, 1.444231, -0.701791>, <-2.639919, 1.479903, -0.691049>, <-2.625641, 1.510516, -0.677267>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.770556, 1.430912, -0.702901>, <-2.801789, 1.395048, -0.716453>, <-2.866222, 1.289902, -0.716740>, <-2.858307, 1.305049, -0.763144>, 
      <-2.748331, 1.420674, -0.702901>, <-2.779564, 1.384809, -0.716453>, <-2.866575, 1.288738, -0.710721>, <-2.858659, 1.303885, -0.757124>, 
      <-2.714286, 1.420135, -0.704163>, <-2.734838, 1.382078, -0.710073>, <-2.769304, 1.331921, -0.710601>, <-2.784940, 1.291232, -0.712976>, 
      <-2.691205, 1.412426, -0.706730>, <-2.711757, 1.374368, -0.712641>, <-2.734696, 1.320307, -0.710751>, <-2.750332, 1.279618, -0.713126>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.816039, 1.469933, -0.706730>, <-2.848874, 1.438096, -0.709316>, <-2.884542, 1.387638, -0.703404>, <-2.910116, 1.349670, -0.705097>, 
      <-2.802422, 1.458457, -0.704011>, <-2.835257, 1.426619, -0.706597>, <-2.865191, 1.368946, -0.703824>, <-2.890765, 1.330978, -0.705516>, 
      <-2.786918, 1.438450, -0.702901>, <-2.818151, 1.402585, -0.716453>, <-2.866482, 1.289044, -0.712303>, <-2.858567, 1.304191, -0.758707>, 
      <-2.770556, 1.430912, -0.702901>, <-2.801789, 1.395048, -0.716453>, <-2.866222, 1.289902, -0.716740>, <-2.858307, 1.305049, -0.763144>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.816039, 1.469933, -0.706730>, <-2.785705, 1.499345, -0.704341>, <-2.725693, 1.519218, -0.703271>, <-2.702198, 1.551269, -0.688720>, 
      <-2.802422, 1.458457, -0.704011>, <-2.772087, 1.487869, -0.701622>, <-2.715607, 1.510918, -0.699506>, <-2.692113, 1.542969, -0.684955>, 
      <-2.786918, 1.438450, -0.702901>, <-2.759589, 1.469832, -0.691043>, <-2.698915, 1.498739, -0.696200>, <-2.677193, 1.533015, -0.681177>, 
      <-2.770556, 1.430912, -0.702901>, <-2.743227, 1.462294, -0.691043>, <-2.687019, 1.492407, -0.694420>, <-2.665297, 1.526683, -0.679397>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.844324, 1.493081, -0.717631>, <-2.808678, 1.516090, -0.709458>, <-2.755150, 1.548023, -0.718431>, <-2.730726, 1.580532, -0.703820>, 
      <-2.836705, 1.485213, -0.714320>, <-2.801059, 1.508222, -0.706147>, <-2.747990, 1.538536, -0.712993>, <-2.723566, 1.571045, -0.698382>, 
      <-2.824688, 1.477222, -0.708457>, <-2.794354, 1.506635, -0.706068>, <-2.735390, 1.527199, -0.706891>, <-2.711895, 1.559250, -0.692340>, 
      <-2.816039, 1.469933, -0.706730>, <-2.785705, 1.499345, -0.704341>, <-2.725693, 1.519218, -0.703271>, <-2.702198, 1.551269, -0.688720>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.844324, 1.493081, -0.717631>, <-2.883437, 1.467834, -0.726599>, <-2.982457, 1.406658, -0.715507>, <-2.978154, 1.420818, -0.760548>, 
      <-2.836705, 1.485213, -0.714320>, <-2.875818, 1.459965, -0.723287>, <-2.982785, 1.405577, -0.709918>, <-2.978481, 1.419737, -0.754959>, 
      <-2.824688, 1.477222, -0.708457>, <-2.857523, 1.445385, -0.711043>, <-2.908918, 1.411185, -0.702877>, <-2.934492, 1.373217, -0.704569>, 
      <-2.816039, 1.469933, -0.706730>, <-2.848874, 1.438096, -0.709316>, <-2.884542, 1.387638, -0.703404>, <-2.910116, 1.349670, -0.705097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.878663, 1.534606, -0.733948>, <-2.838804, 1.557070, -0.735169>, <-2.774854, 1.577645, -0.738057>, <-2.746539, 1.610016, -0.722394>, 
      <-2.871190, 1.520726, -0.727884>, <-2.831331, 1.543190, -0.729105>, <-2.772089, 1.568479, -0.731723>, <-2.743774, 1.600849, -0.716060>, 
      <-2.855571, 1.504696, -0.722519>, <-2.819925, 1.527705, -0.714347>, <-2.761439, 1.556355, -0.723207>, <-2.737015, 1.588864, -0.708596>, 
      <-2.844324, 1.493081, -0.717631>, <-2.808678, 1.516090, -0.709458>, <-2.755150, 1.548023, -0.718431>, <-2.730726, 1.580532, -0.703820>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.878663, 1.534606, -0.733948>, <-2.917312, 1.512824, -0.732764>, <-2.970433, 1.488736, -0.715047>, <-3.006815, 1.463328, -0.714419>, 
      <-2.871190, 1.520726, -0.727884>, <-2.909840, 1.498944, -0.726700>, <-2.958986, 1.471577, -0.716663>, <-2.995368, 1.446169, -0.716035>, 
      <-2.855571, 1.504696, -0.722519>, <-2.894684, 1.479448, -0.731487>, <-2.982657, 1.405998, -0.712096>, <-2.978354, 1.420158, -0.757136>, 
      <-2.844324, 1.493081, -0.717631>, <-2.883437, 1.467834, -0.726599>, <-2.982457, 1.406658, -0.715507>, <-2.978154, 1.420818, -0.760548>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.888149, 1.574484, -0.753196>, <-2.845750, 1.592690, -0.751665>, <-2.777215, 1.604282, -0.758172>, <-2.747229, 1.635237, -0.741616>, 
      <-2.894943, 1.570607, -0.742089>, <-2.852544, 1.588813, -0.740558>, <-2.779513, 1.597261, -0.752174>, <-2.749527, 1.628216, -0.735618>, 
      <-2.884674, 1.545770, -0.738826>, <-2.844814, 1.568235, -0.740047>, <-2.777146, 1.585244, -0.743307>, <-2.748831, 1.617614, -0.727644>, 
      <-2.878663, 1.534606, -0.733948>, <-2.838804, 1.557070, -0.735169>, <-2.774854, 1.577645, -0.738057>, <-2.746539, 1.610016, -0.722394>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.888149, 1.574484, -0.753196>, <-2.933031, 1.555212, -0.754816>, <-2.996648, 1.536578, -0.751426>, <-3.037921, 1.510416, -0.752110>, 
      <-2.894943, 1.570607, -0.742089>, <-2.939825, 1.551336, -0.743709>, <-2.998150, 1.531613, -0.725753>, <-3.039423, 1.505451, -0.726438>, 
      <-2.884674, 1.545770, -0.738826>, <-2.923323, 1.523988, -0.737641>, <-2.981696, 1.505621, -0.713457>, <-3.018078, 1.480213, -0.712829>, 
      <-2.878663, 1.534606, -0.733948>, <-2.917312, 1.512824, -0.732764>, <-2.970433, 1.488736, -0.715047>, <-3.006815, 1.463328, -0.714419>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.888149, 1.574484, -0.753196>, <-2.933031, 1.555212, -0.754816>, <-2.996648, 1.536578, -0.751426>, <-3.037921, 1.510416, -0.752110>, 
      <-2.881175, 1.578463, -0.764598>, <-2.926057, 1.559192, -0.766218>, <-2.995216, 1.541311, -0.775898>, <-3.036489, 1.515149, -0.776582>, 
      <-2.863373, 1.557669, -0.766643>, <-2.904471, 1.531232, -0.772338>, <-2.971842, 1.522335, -0.791785>, <-3.012785, 1.495180, -0.794371>, 
      <-2.855118, 1.548041, -0.772442>, <-2.896216, 1.521605, -0.778137>, <-2.961106, 1.506240, -0.793301>, <-3.002048, 1.479084, -0.795887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.888149, 1.574484, -0.753196>, <-2.881175, 1.578463, -0.764598>, <-2.863373, 1.557669, -0.766643>, <-2.855118, 1.548041, -0.772442>, 
      <-2.845750, 1.592690, -0.751665>, <-2.838776, 1.596669, -0.763067>, <-2.822914, 1.583694, -0.761036>, <-2.814659, 1.574066, -0.766836>, 
      <-2.777215, 1.604282, -0.758172>, <-2.775178, 1.610509, -0.763492>, <-2.766661, 1.613068, -0.771583>, <-2.760348, 1.616594, -0.775936>, 
      <-2.747229, 1.635237, -0.741616>, <-2.745191, 1.641465, -0.746936>, <-2.738999, 1.648825, -0.754208>, <-2.732686, 1.652351, -0.758561>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.525670, 1.079258, -0.863860>, <-3.513397, 1.063577, -0.864807>, <-3.501922, 1.043901, -0.858419>, <-3.506604, 1.037535, -0.840117>, 
      <-3.525670, 1.079258, -0.863860>, <-3.522248, 1.057839, -0.861857>, <-3.517681, 1.047226, -0.860702>, <-3.522363, 1.040860, -0.842400>, 
      <-3.525670, 1.079258, -0.863860>, <-3.522248, 1.057839, -0.861857>, <-3.539985, 1.056856, -0.853770>, <-3.542558, 1.053358, -0.843714>, 
      <-3.525670, 1.079258, -0.863860>, <-3.534521, 1.073520, -0.860910>, <-3.550000, 1.069651, -0.852998>, <-3.552572, 1.066153, -0.842942>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.466382, 1.047969, -0.830454>, <-3.476333, 1.040473, -0.833386>, <-3.494205, 1.034919, -0.838321>, <-3.506604, 1.037535, -0.840117>, 
      <-3.459972, 1.056688, -0.855515>, <-3.469923, 1.049192, -0.858447>, <-3.489523, 1.041285, -0.856622>, <-3.501922, 1.043901, -0.858419>, 
      <-3.475692, 1.083627, -0.864261>, <-3.485559, 1.076338, -0.867215>, <-3.503201, 1.070188, -0.868205>, <-3.513397, 1.063577, -0.864807>, 
      <-3.492497, 1.105099, -0.862965>, <-3.502364, 1.097811, -0.865919>, <-3.515474, 1.085868, -0.867259>, <-3.525670, 1.079258, -0.863860>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.557908, 1.103085, -0.836160>, <-3.560312, 1.092296, -0.838859>, <-3.559577, 1.075103, -0.842402>, <-3.552572, 1.066153, -0.842942>, 
      <-3.557908, 1.103085, -0.836160>, <-3.555895, 1.098302, -0.856124>, <-3.557004, 1.078601, -0.852457>, <-3.550000, 1.069651, -0.852998>, 
      <-3.557908, 1.103085, -0.836160>, <-3.555895, 1.098302, -0.856124>, <-3.546098, 1.088312, -0.860017>, <-3.534521, 1.073520, -0.860910>, 
      <-3.557908, 1.103085, -0.836160>, <-3.553491, 1.109090, -0.853425>, <-3.537248, 1.094050, -0.862967>, <-3.525670, 1.079258, -0.863860>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.557908, 1.103085, -0.836160>, <-3.555237, 1.115074, -0.833161>, <-3.546588, 1.130489, -0.827923>, <-3.536627, 1.137723, -0.825037>, 
      <-3.553491, 1.109090, -0.853425>, <-3.550820, 1.121080, -0.850425>, <-3.540542, 1.138712, -0.851559>, <-3.530581, 1.145946, -0.848674>, 
      <-3.537248, 1.094050, -0.862967>, <-3.527051, 1.100661, -0.866366>, <-3.518214, 1.118063, -0.864696>, <-3.508347, 1.125351, -0.861743>, 
      <-3.525670, 1.079258, -0.863860>, <-3.515474, 1.085868, -0.867259>, <-3.502364, 1.097811, -0.865919>, <-3.492497, 1.105099, -0.862965>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.557908, 1.103085, -0.836160>, <-3.553491, 1.109090, -0.853425>, <-3.537248, 1.094050, -0.862967>, <-3.525670, 1.079258, -0.863860>, 
      <-3.560312, 1.092296, -0.838859>, <-3.555895, 1.098302, -0.856124>, <-3.524974, 1.078370, -0.863914>, <-3.513397, 1.063577, -0.864807>, 
      <-3.559577, 1.075103, -0.842402>, <-3.549562, 1.062308, -0.843174>, <-3.517681, 1.047226, -0.860702>, <-3.501922, 1.043901, -0.858419>, 
      <-3.552572, 1.066153, -0.842942>, <-3.542558, 1.053358, -0.843714>, <-3.522363, 1.040860, -0.842400>, <-3.506604, 1.037535, -0.840117>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.538830, 1.061365, -0.812420>, <-3.531400, 1.063916, -0.803513>, <-3.519817, 1.073702, -0.795177>, <-3.510514, 1.080593, -0.792526>, 
      <-3.551103, 1.077046, -0.811473>, <-3.543672, 1.079597, -0.802566>, <-3.536622, 1.095174, -0.793881>, <-3.527319, 1.102065, -0.791230>, 
      <-3.562590, 1.096719, -0.817858>, <-3.559919, 1.108708, -0.814859>, <-3.552998, 1.121770, -0.802862>, <-3.543037, 1.129004, -0.799976>, 
      <-3.557908, 1.103085, -0.836160>, <-3.555237, 1.115074, -0.833161>, <-3.546588, 1.130489, -0.827923>, <-3.536627, 1.137723, -0.825037>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.538830, 1.061365, -0.812420>, <-3.545176, 1.059186, -0.820028>, <-3.554954, 1.062914, -0.833629>, <-3.552572, 1.066153, -0.842942>, 
      <-3.538830, 1.061365, -0.812420>, <-3.557449, 1.074867, -0.819081>, <-3.561959, 1.071863, -0.833089>, <-3.559577, 1.075103, -0.842402>, 
      <-3.538830, 1.061365, -0.812420>, <-3.557449, 1.074867, -0.819081>, <-3.564994, 1.085930, -0.820557>, <-3.560312, 1.092296, -0.838859>, 
      <-3.538830, 1.061365, -0.812420>, <-3.551103, 1.077046, -0.811473>, <-3.562590, 1.096719, -0.817858>, <-3.557908, 1.103085, -0.836160>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.538830, 1.061365, -0.812420>, <-3.545176, 1.059186, -0.820028>, <-3.554954, 1.062914, -0.833629>, <-3.552572, 1.066153, -0.842942>, 
      <-3.551103, 1.077046, -0.811473>, <-3.557449, 1.074867, -0.819081>, <-3.552382, 1.066411, -0.843685>, <-3.550000, 1.069651, -0.852998>, 
      <-3.562590, 1.096719, -0.817858>, <-3.558174, 1.102724, -0.835123>, <-3.546098, 1.088312, -0.860017>, <-3.534521, 1.073520, -0.860910>, 
      <-3.557908, 1.103085, -0.836160>, <-3.553491, 1.109090, -0.853425>, <-3.537248, 1.094050, -0.862967>, <-3.525670, 1.079258, -0.863860>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.538830, 1.061365, -0.812420>, <-3.551103, 1.077046, -0.811473>, <-3.562590, 1.096719, -0.817858>, <-3.557908, 1.103085, -0.836160>, 
      <-3.527254, 1.046575, -0.813313>, <-3.539527, 1.062256, -0.812366>, <-3.564994, 1.085930, -0.820557>, <-3.560312, 1.092296, -0.838859>, 
      <-3.511020, 1.031530, -0.822855>, <-3.526779, 1.034855, -0.825138>, <-3.549562, 1.062308, -0.843174>, <-3.559577, 1.075103, -0.842402>, 
      <-3.506604, 1.037535, -0.840117>, <-3.522363, 1.040860, -0.842400>, <-3.542558, 1.053358, -0.843714>, <-3.552572, 1.066153, -0.842942>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.538830, 1.061365, -0.812420>, <-3.545176, 1.059186, -0.820028>, <-3.554954, 1.062914, -0.833629>, <-3.552572, 1.066153, -0.842942>, 
      <-3.538830, 1.061365, -0.812420>, <-3.533601, 1.044396, -0.820921>, <-3.544940, 1.050118, -0.834402>, <-3.542558, 1.053358, -0.843714>, 
      <-3.538830, 1.061365, -0.812420>, <-3.533601, 1.044396, -0.820921>, <-3.526779, 1.034855, -0.825138>, <-3.522363, 1.040860, -0.842400>, 
      <-3.538830, 1.061365, -0.812420>, <-3.527254, 1.046575, -0.813313>, <-3.511020, 1.031530, -0.822855>, <-3.506604, 1.037535, -0.840117>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.538830, 1.061365, -0.812420>, <-3.531400, 1.063916, -0.803513>, <-3.519817, 1.073702, -0.795177>, <-3.510514, 1.080593, -0.792526>, 
      <-3.527254, 1.046575, -0.813313>, <-3.519824, 1.049126, -0.804406>, <-3.503966, 1.053450, -0.796399>, <-3.494664, 1.060340, -0.793748>, 
      <-3.511020, 1.031530, -0.822855>, <-3.498621, 1.028915, -0.821059>, <-3.482379, 1.032250, -0.809749>, <-3.472428, 1.039746, -0.806817>, 
      <-3.506604, 1.037535, -0.840117>, <-3.494205, 1.034919, -0.838321>, <-3.476333, 1.040473, -0.833386>, <-3.466382, 1.047969, -0.830454>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.538830, 1.061365, -0.812420>, <-3.527254, 1.046575, -0.813313>, <-3.511020, 1.031530, -0.822855>, <-3.506604, 1.037535, -0.840117>, 
      <-3.545176, 1.059186, -0.820028>, <-3.533601, 1.044396, -0.820921>, <-3.506338, 1.037897, -0.841157>, <-3.501922, 1.043901, -0.858419>, 
      <-3.554954, 1.062914, -0.833629>, <-3.552382, 1.066411, -0.843685>, <-3.522248, 1.057839, -0.861857>, <-3.513397, 1.063577, -0.864807>, 
      <-3.552572, 1.066153, -0.842942>, <-3.550000, 1.069651, -0.852998>, <-3.534521, 1.073520, -0.860910>, <-3.525670, 1.079258, -0.863860>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.493096, 1.150154, -0.817384>, <-3.488753, 1.156059, -0.834359>, <-3.472779, 1.141276, -0.843742>, <-3.461395, 1.126732, -0.844620>, 
      <-3.503982, 1.142174, -0.820129>, <-3.499639, 1.148079, -0.837104>, <-3.482692, 1.133902, -0.846355>, <-3.471308, 1.119359, -0.847233>, 
      <-3.525776, 1.145603, -0.821894>, <-3.519730, 1.153827, -0.845530>, <-3.498472, 1.132645, -0.858787>, <-3.482622, 1.112393, -0.860009>, 
      <-3.536627, 1.137723, -0.825037>, <-3.530581, 1.145946, -0.848674>, <-3.508347, 1.125351, -0.861743>, <-3.492497, 1.105099, -0.862965>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.474335, 1.109138, -0.794042>, <-3.486402, 1.124555, -0.793111>, <-3.497700, 1.143895, -0.799390>, <-3.493096, 1.150154, -0.817384>, 
      <-3.485212, 1.101018, -0.796709>, <-3.497279, 1.116435, -0.795778>, <-3.508586, 1.135915, -0.802135>, <-3.503982, 1.142174, -0.820129>, 
      <-3.499679, 1.088619, -0.789439>, <-3.516484, 1.110091, -0.788143>, <-3.532186, 1.136885, -0.796833>, <-3.525776, 1.145603, -0.821894>, 
      <-3.510514, 1.080593, -0.792526>, <-3.527319, 1.102065, -0.791230>, <-3.543037, 1.129004, -0.799976>, <-3.536627, 1.137723, -0.825037>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.442652, 1.085708, -0.821275>, <-3.446994, 1.079804, -0.804303>, <-3.462953, 1.094597, -0.794920>, <-3.474335, 1.109138, -0.794042>, 
      <-3.453316, 1.077630, -0.824007>, <-3.457658, 1.071726, -0.807035>, <-3.473830, 1.086478, -0.797587>, <-3.485212, 1.101018, -0.796709>, 
      <-3.455766, 1.055966, -0.827326>, <-3.461812, 1.047743, -0.803689>, <-3.483828, 1.068366, -0.790661>, <-3.499679, 1.088619, -0.789439>, 
      <-3.466382, 1.047969, -0.830454>, <-3.472428, 1.039746, -0.806817>, <-3.494664, 1.060340, -0.793748>, <-3.510514, 1.080593, -0.792526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.442652, 1.085708, -0.821275>, <-3.453316, 1.077630, -0.824007>, <-3.455766, 1.055966, -0.827326>, <-3.466382, 1.047969, -0.830454>, 
      <-3.438048, 1.091968, -0.839269>, <-3.448712, 1.083889, -0.842001>, <-3.449356, 1.064685, -0.852387>, <-3.459972, 1.056688, -0.855515>, 
      <-3.449328, 1.111315, -0.845551>, <-3.459241, 1.103942, -0.848164>, <-3.465816, 1.090921, -0.861305>, <-3.475692, 1.083627, -0.864261>, 
      <-3.461395, 1.126732, -0.844620>, <-3.471308, 1.119359, -0.847233>, <-3.482622, 1.112393, -0.860009>, <-3.492497, 1.105099, -0.862965>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.277324, 1.327796, -0.759650>, <-3.275931, 1.332401, -0.783457>, <-3.256688, 1.310717, -0.795710>, <-3.241735, 1.291612, -0.796862>, 
      <-3.344037, 1.274994, -0.769217>, <-3.342644, 1.279599, -0.793024>, <-3.322813, 1.259994, -0.802725>, <-3.307860, 1.240889, -0.803877>, 
      <-3.425429, 1.199755, -0.800321>, <-3.421086, 1.205660, -0.817296>, <-3.407126, 1.190108, -0.826435>, <-3.395742, 1.175564, -0.827313>, 
      <-3.493096, 1.150154, -0.817384>, <-3.488753, 1.156059, -0.834359>, <-3.472779, 1.141276, -0.843742>, <-3.461395, 1.126732, -0.844620>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.277324, 1.327796, -0.759650>, <-3.206915, 1.383523, -0.749553>, <-3.114232, 1.462044, -0.753376>, <-3.037921, 1.510416, -0.752110>, 
      <-3.275931, 1.332401, -0.783457>, <-3.205522, 1.388128, -0.773360>, <-3.112800, 1.466777, -0.777848>, <-3.036489, 1.515149, -0.776582>, 
      <-3.256688, 1.310717, -0.795710>, <-3.184510, 1.366083, -0.788052>, <-3.088756, 1.444791, -0.799170>, <-3.012785, 1.495180, -0.794371>, 
      <-3.241735, 1.291612, -0.796862>, <-3.169557, 1.346978, -0.789204>, <-3.078019, 1.428695, -0.800686>, <-3.002048, 1.479084, -0.795887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.245788, 1.278216, -0.727611>, <-3.174093, 1.332532, -0.715401>, <-3.081227, 1.411361, -0.713135>, <-3.006815, 1.463328, -0.714419>, 
      <-3.261690, 1.298533, -0.726386>, <-3.189995, 1.352849, -0.714175>, <-3.092490, 1.428246, -0.711544>, <-3.018078, 1.480213, -0.712829>, 
      <-3.278806, 1.322899, -0.734332>, <-3.208397, 1.378626, -0.724235>, <-3.115735, 1.457079, -0.727703>, <-3.039423, 1.505451, -0.726438>, 
      <-3.277324, 1.327796, -0.759650>, <-3.206915, 1.383523, -0.749553>, <-3.114232, 1.462044, -0.753376>, <-3.037921, 1.510416, -0.752110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.245788, 1.278216, -0.727611>, <-3.261690, 1.298533, -0.726386>, <-3.278806, 1.322899, -0.734332>, <-3.277324, 1.327796, -0.759650>, 
      <-3.314966, 1.225807, -0.739393>, <-3.330868, 1.246125, -0.738167>, <-3.345519, 1.270096, -0.743899>, <-3.344037, 1.274994, -0.769217>, 
      <-3.405467, 1.160549, -0.777154>, <-3.417534, 1.175966, -0.776224>, <-3.430032, 1.193496, -0.782327>, <-3.425429, 1.199755, -0.800321>, 
      <-3.474335, 1.109138, -0.794042>, <-3.486402, 1.124555, -0.793111>, <-3.497700, 1.143895, -0.799390>, <-3.493096, 1.150154, -0.817384>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.210202, 1.242035, -0.764823>, <-3.139323, 1.293170, -0.755556>, <-2.981408, 1.435237, -0.760192>, <-2.978154, 1.420818, -0.760548>, 
      <-3.211595, 1.237430, -0.741017>, <-3.140716, 1.288565, -0.731751>, <-2.981607, 1.434577, -0.756780>, <-2.978354, 1.420158, -0.757136>, 
      <-3.230836, 1.259112, -0.728763>, <-3.159141, 1.313427, -0.716553>, <-3.069780, 1.394201, -0.714751>, <-2.995368, 1.446169, -0.716035>, 
      <-3.245788, 1.278216, -0.727611>, <-3.174093, 1.332532, -0.715401>, <-3.081227, 1.411361, -0.713135>, <-3.006815, 1.463328, -0.714419>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.210202, 1.242035, -0.764823>, <-3.211595, 1.237430, -0.741017>, <-3.230836, 1.259112, -0.728763>, <-3.245788, 1.278216, -0.727611>, 
      <-3.279338, 1.192157, -0.773862>, <-3.280731, 1.187552, -0.750056>, <-3.300014, 1.206703, -0.740545>, <-3.314966, 1.225807, -0.739393>, 
      <-3.375700, 1.136427, -0.804122>, <-3.380042, 1.130523, -0.787151>, <-3.394086, 1.146008, -0.778032>, <-3.405467, 1.160549, -0.777154>, 
      <-3.442652, 1.085708, -0.821275>, <-3.446994, 1.079804, -0.804303>, <-3.462953, 1.094597, -0.794920>, <-3.474335, 1.109138, -0.794042>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.210202, 1.242035, -0.764823>, <-3.279338, 1.192157, -0.773862>, <-3.375700, 1.136427, -0.804122>, <-3.442652, 1.085708, -0.821275>, 
      <-3.208720, 1.246932, -0.790139>, <-3.277856, 1.197055, -0.799178>, <-3.371096, 1.142686, -0.822117>, <-3.438048, 1.091968, -0.839269>, 
      <-3.225834, 1.271296, -0.798087>, <-3.291959, 1.220573, -0.805103>, <-3.383674, 1.160147, -0.828244>, <-3.449328, 1.111315, -0.845551>, 
      <-3.241735, 1.291612, -0.796862>, <-3.307860, 1.240889, -0.803877>, <-3.395742, 1.175564, -0.827313>, <-3.461395, 1.126732, -0.844620>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.210202, 1.242035, -0.764823>, <-3.208720, 1.246932, -0.790139>, <-3.225834, 1.271296, -0.798087>, <-3.241735, 1.291612, -0.796862>, 
      <-3.139323, 1.293170, -0.755556>, <-3.137841, 1.298068, -0.780873>, <-3.153656, 1.326661, -0.790430>, <-3.169557, 1.346978, -0.789204>, 
      <-2.981408, 1.435237, -0.760192>, <-2.981199, 1.435928, -0.763764>, <-3.066034, 1.410728, -0.802378>, <-3.078019, 1.428695, -0.800686>, 
      <-2.978154, 1.420818, -0.760548>, <-2.977945, 1.421509, -0.764120>, <-2.990063, 1.461117, -0.797579>, <-3.002048, 1.479084, -0.795887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.352988, 0.665778, -0.905378>, <-3.331820, 0.652462, -0.905924>, <-3.309989, 0.633562, -0.896746>, <-3.314382, 0.624285, -0.873935>, 
      <-3.352988, 0.665778, -0.905378>, <-3.340258, 0.641762, -0.902345>, <-3.330126, 0.630747, -0.900217>, <-3.334519, 0.621470, -0.877407>, 
      <-3.352988, 0.665778, -0.905378>, <-3.340258, 0.641762, -0.902345>, <-3.361434, 0.633026, -0.892761>, <-3.363909, 0.627801, -0.879912>, 
      <-3.352988, 0.665778, -0.905378>, <-3.361426, 0.655077, -0.901799>, <-3.378890, 0.644006, -0.892311>, <-3.381364, 0.638781, -0.879462>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.271599, 0.654125, -0.860538>, <-3.280006, 0.640894, -0.864448>, <-3.298609, 0.626490, -0.871216>, <-3.314382, 0.624285, -0.873935>, 
      <-3.265581, 0.666826, -0.891774>, <-3.273988, 0.653596, -0.895684>, <-3.294216, 0.635767, -0.894027>, <-3.309989, 0.633562, -0.896746>, 
      <-3.295470, 0.692713, -0.904346>, <-3.303922, 0.679674, -0.908312>, <-3.322216, 0.664642, -0.909997>, <-3.331820, 0.652462, -0.905924>, 
      <-3.324455, 0.710947, -0.903597>, <-3.332907, 0.697909, -0.907563>, <-3.343384, 0.677957, -0.909451>, <-3.352988, 0.665778, -0.905378>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.404155, 0.680758, -0.871619>, <-3.402168, 0.666766, -0.874956>, <-3.393653, 0.646511, -0.879145>, <-3.381364, 0.638781, -0.879462>, 
      <-3.404155, 0.680758, -0.871619>, <-3.397891, 0.675798, -0.897165>, <-3.391178, 0.651737, -0.891993>, <-3.378890, 0.644006, -0.892311>, 
      <-3.404155, 0.680758, -0.871619>, <-3.397891, 0.675798, -0.897165>, <-3.382036, 0.668042, -0.901268>, <-3.361426, 0.655077, -0.901799>, 
      <-3.404155, 0.680758, -0.871619>, <-3.399878, 0.689790, -0.893828>, <-3.373598, 0.678743, -0.904846>, <-3.352988, 0.665778, -0.905378>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.404155, 0.680758, -0.871619>, <-3.406352, 0.696234, -0.867929>, <-3.403109, 0.718449, -0.861244>, <-3.394521, 0.731454, -0.857363>, 
      <-3.399878, 0.689790, -0.893828>, <-3.402074, 0.705266, -0.890138>, <-3.397250, 0.730816, -0.891657>, <-3.388661, 0.743821, -0.887776>, 
      <-3.373598, 0.678743, -0.904846>, <-3.363993, 0.690922, -0.908920>, <-3.361130, 0.715663, -0.906834>, <-3.352677, 0.728701, -0.902868>, 
      <-3.352988, 0.665778, -0.905378>, <-3.343384, 0.677957, -0.909451>, <-3.332907, 0.697909, -0.907563>, <-3.324455, 0.710947, -0.903597>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.404155, 0.680758, -0.871619>, <-3.399878, 0.689790, -0.893828>, <-3.373598, 0.678743, -0.904846>, <-3.352988, 0.665778, -0.905378>, 
      <-3.402168, 0.666766, -0.874956>, <-3.397891, 0.675798, -0.897165>, <-3.352430, 0.665427, -0.905392>, <-3.331820, 0.652462, -0.905924>, 
      <-3.393653, 0.646511, -0.879145>, <-3.376198, 0.635531, -0.879595>, <-3.330126, 0.630747, -0.900217>, <-3.309989, 0.633562, -0.896746>, 
      <-3.381364, 0.638781, -0.879462>, <-3.363909, 0.627801, -0.879912>, <-3.334519, 0.621470, -0.877407>, <-3.314382, 0.624285, -0.873935>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.365546, 0.639260, -0.840173>, <-3.358494, 0.645629, -0.828600>, <-3.349566, 0.662424, -0.817845>, <-3.341659, 0.674638, -0.814306>, 
      <-3.386716, 0.652577, -0.839627>, <-3.379664, 0.658946, -0.828054>, <-3.378550, 0.680658, -0.817096>, <-3.370644, 0.692872, -0.813557>, 
      <-3.408548, 0.671480, -0.848806>, <-3.410746, 0.686956, -0.845116>, <-3.409128, 0.705748, -0.830009>, <-3.400539, 0.718753, -0.826128>, 
      <-3.404155, 0.680758, -0.871619>, <-3.406352, 0.696234, -0.867929>, <-3.403109, 0.718449, -0.861244>, <-3.394521, 0.731454, -0.857363>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.365546, 0.639260, -0.840173>, <-3.371530, 0.633856, -0.849994>, <-3.383596, 0.634069, -0.867874>, <-3.381364, 0.638781, -0.879462>, 
      <-3.365546, 0.639260, -0.840173>, <-3.392700, 0.647173, -0.849447>, <-3.395884, 0.641799, -0.867557>, <-3.393653, 0.646511, -0.879145>, 
      <-3.365546, 0.639260, -0.840173>, <-3.392700, 0.647173, -0.849447>, <-3.406562, 0.657488, -0.852143>, <-3.402168, 0.666766, -0.874956>, 
      <-3.365546, 0.639260, -0.840173>, <-3.386716, 0.652577, -0.839627>, <-3.408548, 0.671480, -0.848806>, <-3.404155, 0.680758, -0.871619>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.365546, 0.639260, -0.840173>, <-3.371530, 0.633856, -0.849994>, <-3.383596, 0.634069, -0.867874>, <-3.381364, 0.638781, -0.879462>, 
      <-3.386716, 0.652577, -0.839627>, <-3.392700, 0.647173, -0.849447>, <-3.381121, 0.639294, -0.880723>, <-3.378890, 0.644006, -0.892311>, 
      <-3.408548, 0.671480, -0.848806>, <-3.404271, 0.680512, -0.871015>, <-3.382036, 0.668042, -0.901268>, <-3.361426, 0.655077, -0.901799>, 
      <-3.404155, 0.680758, -0.871619>, <-3.399878, 0.689790, -0.893828>, <-3.373598, 0.678743, -0.904846>, <-3.352988, 0.665778, -0.905378>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.365546, 0.639260, -0.840173>, <-3.386716, 0.652577, -0.839627>, <-3.408548, 0.671480, -0.848806>, <-3.404155, 0.680758, -0.871619>, 
      <-3.344937, 0.626296, -0.840705>, <-3.366107, 0.639613, -0.840159>, <-3.406562, 0.657488, -0.852143>, <-3.402168, 0.666766, -0.874956>, 
      <-3.318659, 0.615253, -0.851726>, <-3.338796, 0.612438, -0.855198>, <-3.376198, 0.635531, -0.879595>, <-3.393653, 0.646511, -0.879145>, 
      <-3.314382, 0.624285, -0.873935>, <-3.334519, 0.621470, -0.877407>, <-3.363909, 0.627801, -0.879912>, <-3.381364, 0.638781, -0.879462>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.365546, 0.639260, -0.840173>, <-3.371530, 0.633856, -0.849994>, <-3.383596, 0.634069, -0.867874>, <-3.381364, 0.638781, -0.879462>, 
      <-3.365546, 0.639260, -0.840173>, <-3.350921, 0.620891, -0.850525>, <-3.366141, 0.623088, -0.868325>, <-3.363909, 0.627801, -0.879912>, 
      <-3.365546, 0.639260, -0.840173>, <-3.350921, 0.620891, -0.850525>, <-3.338796, 0.612438, -0.855198>, <-3.334519, 0.621470, -0.877407>, 
      <-3.365546, 0.639260, -0.840173>, <-3.344937, 0.626296, -0.840705>, <-3.318659, 0.615253, -0.851726>, <-3.314382, 0.624285, -0.873935>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.365546, 0.639260, -0.840173>, <-3.358494, 0.645629, -0.828600>, <-3.349566, 0.662424, -0.817845>, <-3.341659, 0.674638, -0.814306>, 
      <-3.344937, 0.626296, -0.840705>, <-3.337885, 0.632664, -0.829132>, <-3.321345, 0.644671, -0.818574>, <-3.313438, 0.656884, -0.815035>, 
      <-3.318659, 0.615253, -0.851726>, <-3.302887, 0.617458, -0.849007>, <-3.285866, 0.628528, -0.834037>, <-3.277459, 0.641759, -0.830126>, 
      <-3.314382, 0.624285, -0.873935>, <-3.298609, 0.626490, -0.871216>, <-3.280006, 0.640894, -0.864448>, <-3.271599, 0.654125, -0.860538>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.365546, 0.639260, -0.840173>, <-3.344937, 0.626296, -0.840705>, <-3.318659, 0.615253, -0.851726>, <-3.314382, 0.624285, -0.873935>, 
      <-3.371530, 0.633856, -0.849994>, <-3.350921, 0.620891, -0.850525>, <-3.314266, 0.624530, -0.874537>, <-3.309989, 0.633562, -0.896746>, 
      <-3.383596, 0.634069, -0.867874>, <-3.381121, 0.639294, -0.880723>, <-3.340258, 0.641762, -0.902345>, <-3.331820, 0.652462, -0.905924>, 
      <-3.381364, 0.638781, -0.879462>, <-3.378890, 0.644006, -0.892311>, <-3.361426, 0.655077, -0.901799>, <-3.352988, 0.665778, -0.905378>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.348452, 0.765106, -0.846447>, <-3.344246, 0.773986, -0.868284>, <-3.318408, 0.763126, -0.879119>, <-3.298144, 0.750378, -0.879642>, 
      <-3.357800, 0.750873, -0.850150>, <-3.353594, 0.759753, -0.871987>, <-3.326843, 0.750070, -0.882624>, <-3.306579, 0.737322, -0.883147>, 
      <-3.385203, 0.745564, -0.853152>, <-3.379343, 0.757931, -0.883565>, <-3.344279, 0.741656, -0.898927>, <-3.316057, 0.723902, -0.899656>, 
      <-3.394521, 0.731454, -0.857363>, <-3.388661, 0.743821, -0.887776>, <-3.352677, 0.728701, -0.902868>, <-3.324455, 0.710947, -0.903597>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.310492, 0.724309, -0.815531>, <-3.331305, 0.737402, -0.814993>, <-3.352772, 0.755986, -0.824018>, <-3.348452, 0.765106, -0.846447>, 
      <-3.319824, 0.709838, -0.819151>, <-3.340637, 0.722931, -0.818614>, <-3.362120, 0.741753, -0.827721>, <-3.357800, 0.750873, -0.850150>, 
      <-3.332368, 0.688991, -0.810148>, <-3.361353, 0.707225, -0.809399>, <-3.391221, 0.732863, -0.821917>, <-3.385203, 0.745564, -0.853152>, 
      <-3.341659, 0.674638, -0.814306>, <-3.370644, 0.692872, -0.813557>, <-3.400539, 0.718753, -0.826128>, <-3.394521, 0.731454, -0.857363>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.260185, 0.709578, -0.848727>, <-3.264391, 0.700698, -0.826890>, <-3.290228, 0.711561, -0.816055>, <-3.310492, 0.724309, -0.815531>, 
      <-3.269265, 0.695262, -0.852420>, <-3.273471, 0.686382, -0.830583>, <-3.299560, 0.697090, -0.819675>, <-3.319824, 0.709838, -0.819151>, 
      <-3.262571, 0.668334, -0.856339>, <-3.268430, 0.655967, -0.825927>, <-3.304147, 0.671237, -0.810877>, <-3.332368, 0.688991, -0.810148>, 
      <-3.271599, 0.654125, -0.860538>, <-3.277459, 0.641759, -0.830126>, <-3.313438, 0.656884, -0.815035>, <-3.341659, 0.674638, -0.814306>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.260185, 0.709578, -0.848727>, <-3.269265, 0.695262, -0.852420>, <-3.262571, 0.668334, -0.856339>, <-3.271599, 0.654125, -0.860538>, 
      <-3.255865, 0.718698, -0.871156>, <-3.264945, 0.704382, -0.874849>, <-3.256552, 0.681035, -0.887574>, <-3.265581, 0.666826, -0.891774>, 
      <-3.277331, 0.737285, -0.880180>, <-3.285765, 0.724229, -0.883685>, <-3.287072, 0.705667, -0.900405>, <-3.295470, 0.692713, -0.904346>, 
      <-3.298144, 0.750378, -0.879642>, <-3.306579, 0.737322, -0.883147>, <-3.316057, 0.723902, -0.899656>, <-3.324455, 0.710947, -0.903597>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.171582, 1.070910, -0.769051>, <-3.169777, 1.076872, -0.799879>, <-3.136891, 1.059216, -0.813905>, <-3.110277, 1.042472, -0.814592>, 
      <-3.224589, 0.977048, -0.781347>, <-3.222784, 0.983010, -0.812175>, <-3.193533, 0.970201, -0.824104>, <-3.166919, 0.953457, -0.824791>, 
      <-3.290254, 0.853721, -0.823393>, <-3.286048, 0.862600, -0.845231>, <-3.262296, 0.849981, -0.855800>, <-3.242033, 0.837233, -0.856324>, 
      <-3.348452, 0.765106, -0.846447>, <-3.344246, 0.773986, -0.868284>, <-3.318408, 0.763126, -0.879119>, <-3.298144, 0.750378, -0.879642>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.171582, 1.070910, -0.769051>, <-3.112968, 1.174701, -0.755454>, <-2.973712, 1.401136, -0.761034>, <-2.978154, 1.420818, -0.760548>, 
      <-3.169777, 1.076872, -0.799879>, <-3.111164, 1.180663, -0.786282>, <-2.973417, 1.402113, -0.766084>, <-2.977859, 1.421795, -0.765598>, 
      <-3.136891, 1.059216, -0.813905>, <-3.074878, 1.156672, -0.802738>, <-2.990816, 1.294712, -0.811335>, <-2.926078, 1.390978, -0.808204>, 
      <-3.110277, 1.042472, -0.814592>, <-3.048264, 1.139928, -0.803426>, <-2.968793, 1.273438, -0.811812>, <-2.904055, 1.369704, -0.808681>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.115432, 1.025444, -0.726544>, <-3.053934, 1.121499, -0.709581>, <-2.974490, 1.254098, -0.709357>, <-2.910116, 1.349670, -0.705097>, 
      <-3.142809, 1.042668, -0.725837>, <-3.081311, 1.138723, -0.708874>, <-2.998867, 1.277644, -0.708829>, <-2.934492, 1.373217, -0.704569>, 
      <-3.173439, 1.064777, -0.737340>, <-3.114825, 1.168568, -0.723743>, <-2.974039, 1.400055, -0.755445>, <-2.978481, 1.419737, -0.754959>, 
      <-3.171582, 1.070910, -0.769051>, <-3.112968, 1.174701, -0.755454>, <-2.973712, 1.401136, -0.761034>, <-2.978154, 1.420818, -0.760548>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.115432, 1.025444, -0.726544>, <-3.142809, 1.042668, -0.725837>, <-3.173439, 1.064777, -0.737340>, <-3.171582, 1.070910, -0.769051>, 
      <-3.174577, 0.933063, -0.742858>, <-3.201954, 0.950287, -0.742151>, <-3.226445, 0.970915, -0.749636>, <-3.224589, 0.977048, -0.781347>, 
      <-3.251676, 0.815515, -0.792714>, <-3.272489, 0.828608, -0.792176>, <-3.294574, 0.844600, -0.800964>, <-3.290254, 0.853721, -0.823393>, 
      <-3.310492, 0.724309, -0.815531>, <-3.331305, 0.737402, -0.814993>, <-3.352772, 0.755986, -0.824018>, <-3.348452, 0.765106, -0.846447>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.054124, 0.997013, -0.772085>, <-2.993279, 1.087168, -0.759128>, <-2.876538, 1.307718, -0.762896>, <-2.858307, 1.305049, -0.763144>, 
      <-3.055929, 0.991051, -0.741257>, <-2.995084, 1.081206, -0.728300>, <-2.876798, 1.306860, -0.758459>, <-2.858567, 1.304191, -0.758707>, 
      <-3.088818, 1.008700, -0.727232>, <-3.027320, 1.104755, -0.710269>, <-2.955140, 1.235405, -0.709777>, <-2.890765, 1.330978, -0.705516>, 
      <-3.115432, 1.025444, -0.726544>, <-3.053934, 1.121499, -0.709581>, <-2.974490, 1.254098, -0.709357>, <-2.910116, 1.349670, -0.705097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.054124, 0.997013, -0.772085>, <-3.055929, 0.991051, -0.741257>, <-3.088818, 1.008700, -0.727232>, <-3.115432, 1.025444, -0.726544>, 
      <-3.114429, 0.907658, -0.784927>, <-3.116234, 0.901696, -0.754100>, <-3.147963, 0.916319, -0.743545>, <-3.174577, 0.933063, -0.742858>, 
      <-3.203371, 0.799155, -0.825619>, <-3.207577, 0.790276, -0.803782>, <-3.231411, 0.802767, -0.793237>, <-3.251676, 0.815515, -0.792714>, 
      <-3.260185, 0.709578, -0.848727>, <-3.264391, 0.700698, -0.826890>, <-3.290228, 0.711561, -0.816055>, <-3.310492, 0.724309, -0.815531>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.054124, 0.997013, -0.772085>, <-3.114429, 0.907658, -0.784927>, <-3.203371, 0.799155, -0.825619>, <-3.260185, 0.709578, -0.848727>, 
      <-3.052268, 1.003146, -0.803795>, <-3.112572, 0.913791, -0.816638>, <-3.199051, 0.808276, -0.848049>, <-3.255865, 0.718698, -0.871156>, 
      <-3.082901, 1.025249, -0.815299>, <-3.139543, 0.936234, -0.825498>, <-3.221219, 0.824139, -0.856862>, <-3.277331, 0.737285, -0.880180>, 
      <-3.110277, 1.042472, -0.814592>, <-3.166919, 0.953457, -0.824791>, <-3.242033, 0.837233, -0.856324>, <-3.298144, 0.750378, -0.879642>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.054124, 0.997013, -0.772085>, <-3.052268, 1.003146, -0.803795>, <-3.082901, 1.025249, -0.815299>, <-3.110277, 1.042472, -0.814592>, 
      <-2.993279, 1.087168, -0.759128>, <-2.991423, 1.093301, -0.790838>, <-3.020888, 1.122704, -0.804133>, <-3.048264, 1.139928, -0.803426>, 
      <-2.876538, 1.307718, -0.762896>, <-2.876274, 1.308592, -0.767415>, <-2.949082, 1.254398, -0.812239>, <-2.968793, 1.273438, -0.811812>, 
      <-2.858307, 1.305049, -0.763144>, <-2.858042, 1.305923, -0.767664>, <-2.884344, 1.350664, -0.809108>, <-2.904055, 1.369704, -0.808681>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.003860, 0.579338, -0.898746>, <-2.982520, 0.571675, -0.898842>, <-2.959454, 0.558960, -0.889762>, <-2.962423, 0.550067, -0.869117>, 
      <-3.003860, 0.579338, -0.898746>, <-2.988118, 0.560433, -0.895614>, <-2.976793, 0.552441, -0.893230>, <-2.979762, 0.543548, -0.872585>, 
      <-3.003860, 0.579338, -0.898746>, <-2.988118, 0.560433, -0.895614>, <-3.005505, 0.548509, -0.887161>, <-3.007202, 0.543424, -0.875355>, 
      <-3.003860, 0.579338, -0.898746>, <-3.009458, 0.568097, -0.895518>, <-3.023241, 0.554879, -0.887081>, <-3.024939, 0.549793, -0.875275>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.930573, 0.585273, -0.856400>, <-2.935322, 0.571790, -0.860013>, <-2.948857, 0.555168, -0.866404>, <-2.962423, 0.550067, -0.869117>, 
      <-2.926508, 0.597452, -0.884669>, <-2.931257, 0.583969, -0.888282>, <-2.945889, 0.564061, -0.887049>, <-2.959454, 0.558960, -0.889762>, 
      <-2.958087, 0.614865, -0.897105>, <-2.962928, 0.601500, -0.900782>, <-2.976181, 0.584404, -0.902497>, <-2.982520, 0.571675, -0.898842>, 
      <-2.987308, 0.625360, -0.896974>, <-2.992148, 0.611996, -0.900652>, <-2.997521, 0.592067, -0.902401>, <-3.003860, 0.579338, -0.898746>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.053878, 0.582909, -0.868706>, <-3.049218, 0.570759, -0.871641>, <-3.037494, 0.554302, -0.875219>, <-3.024939, 0.549793, -0.875275>, 
      <-3.053878, 0.582909, -0.868706>, <-3.046264, 0.579607, -0.892182>, <-3.035796, 0.559387, -0.887025>, <-3.023241, 0.554879, -0.887081>, 
      <-3.053878, 0.582909, -0.868706>, <-3.046264, 0.579607, -0.892182>, <-3.030690, 0.575721, -0.895423>, <-3.009458, 0.568097, -0.895518>, 
      <-3.053878, 0.582909, -0.868706>, <-3.050924, 0.591757, -0.889247>, <-3.025092, 0.586963, -0.898651>, <-3.003860, 0.579338, -0.898746>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.053878, 0.582909, -0.868706>, <-3.059023, 0.596324, -0.865466>, <-3.060779, 0.616866, -0.859447>, <-3.055799, 0.630250, -0.855840>, 
      <-3.050924, 0.591757, -0.889247>, <-3.056070, 0.605172, -0.886007>, <-3.056735, 0.628984, -0.887574>, <-3.051755, 0.642367, -0.883967>, 
      <-3.025092, 0.586963, -0.898651>, <-3.018753, 0.599691, -0.902306>, <-3.021222, 0.622438, -0.900521>, <-3.016381, 0.635802, -0.896844>, 
      <-3.003860, 0.579338, -0.898746>, <-2.997521, 0.592067, -0.902401>, <-2.992148, 0.611996, -0.900652>, <-2.987308, 0.625360, -0.896974>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.053878, 0.582909, -0.868706>, <-3.050924, 0.591757, -0.889247>, <-3.025092, 0.586963, -0.898651>, <-3.003860, 0.579338, -0.898746>, 
      <-3.049218, 0.570759, -0.871641>, <-3.046264, 0.579607, -0.892182>, <-3.003752, 0.579299, -0.898747>, <-2.982520, 0.571675, -0.898842>, 
      <-3.037494, 0.554302, -0.875219>, <-3.019757, 0.547932, -0.875298>, <-2.976793, 0.552441, -0.893230>, <-2.959454, 0.558960, -0.889762>, 
      <-3.024939, 0.549793, -0.875275>, <-3.007202, 0.543424, -0.875355>, <-2.979762, 0.543548, -0.872585>, <-2.962423, 0.550067, -0.869117>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.012440, 0.553635, -0.839077>, <-3.007829, 0.560825, -0.828388>, <-3.003578, 0.577669, -0.818544>, <-2.999056, 0.590160, -0.815268>, 
      <-3.033781, 0.561299, -0.838981>, <-3.029170, 0.568489, -0.828292>, <-3.032801, 0.588165, -0.818414>, <-3.028279, 0.600656, -0.815137>, 
      <-3.056847, 0.574016, -0.848060>, <-3.061992, 0.587430, -0.844819>, <-3.064844, 0.604687, -0.831176>, <-3.059864, 0.618070, -0.827569>, 
      <-3.053878, 0.582909, -0.868706>, <-3.059023, 0.596324, -0.865466>, <-3.060779, 0.616866, -0.859447>, <-3.055799, 0.630250, -0.855840>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.012440, 0.553635, -0.839077>, <-3.016330, 0.547567, -0.848097>, <-3.026451, 0.545264, -0.864762>, <-3.024939, 0.549793, -0.875275>, 
      <-3.012440, 0.553635, -0.839077>, <-3.037671, 0.555231, -0.848001>, <-3.039006, 0.549773, -0.864706>, <-3.037494, 0.554302, -0.875219>, 
      <-3.012440, 0.553635, -0.839077>, <-3.037671, 0.555231, -0.848001>, <-3.052186, 0.561866, -0.850995>, <-3.049218, 0.570759, -0.871641>, 
      <-3.012440, 0.553635, -0.839077>, <-3.033781, 0.561299, -0.838981>, <-3.056847, 0.574016, -0.848060>, <-3.053878, 0.582909, -0.868706>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.012440, 0.553635, -0.839077>, <-3.016330, 0.547567, -0.848097>, <-3.026451, 0.545264, -0.864762>, <-3.024939, 0.549793, -0.875275>, 
      <-3.033781, 0.561299, -0.838981>, <-3.037671, 0.555231, -0.848001>, <-3.024753, 0.550350, -0.876568>, <-3.023241, 0.554879, -0.887081>, 
      <-3.056847, 0.574016, -0.848060>, <-3.053893, 0.582864, -0.868601>, <-3.030690, 0.575721, -0.895423>, <-3.009458, 0.568097, -0.895518>, 
      <-3.053878, 0.582909, -0.868706>, <-3.050924, 0.591757, -0.889247>, <-3.025092, 0.586963, -0.898651>, <-3.003860, 0.579338, -0.898746>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.012440, 0.553635, -0.839077>, <-3.033781, 0.561299, -0.838981>, <-3.056847, 0.574016, -0.848060>, <-3.053878, 0.582909, -0.868706>, 
      <-2.991208, 0.546011, -0.839172>, <-3.012549, 0.553674, -0.839077>, <-3.052186, 0.561866, -0.850995>, <-3.049218, 0.570759, -0.871641>, 
      <-2.965377, 0.541219, -0.848576>, <-2.982715, 0.534700, -0.852044>, <-3.019757, 0.547932, -0.875298>, <-3.037494, 0.554302, -0.875219>, 
      <-2.962423, 0.550067, -0.869117>, <-2.979762, 0.543548, -0.872585>, <-3.007202, 0.543424, -0.875355>, <-3.024939, 0.549793, -0.875275>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.012440, 0.553635, -0.839077>, <-3.016330, 0.547567, -0.848097>, <-3.026451, 0.545264, -0.864762>, <-3.024939, 0.549793, -0.875275>, 
      <-3.012440, 0.553635, -0.839077>, <-2.995099, 0.539943, -0.848193>, <-3.008714, 0.538895, -0.864842>, <-3.007202, 0.543424, -0.875355>, 
      <-3.012440, 0.553635, -0.839077>, <-2.995099, 0.539943, -0.848193>, <-2.982715, 0.534700, -0.852044>, <-2.979762, 0.543548, -0.872585>, 
      <-3.012440, 0.553635, -0.839077>, <-2.991208, 0.546011, -0.839172>, <-2.965377, 0.541219, -0.848576>, <-2.962423, 0.550067, -0.869117>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.012440, 0.553635, -0.839077>, <-3.007829, 0.560825, -0.828388>, <-3.003578, 0.577669, -0.818544>, <-2.999056, 0.590160, -0.815268>, 
      <-2.991208, 0.546011, -0.839172>, <-2.986598, 0.553201, -0.828484>, <-2.974508, 0.567228, -0.818674>, <-2.969986, 0.579719, -0.815398>, 
      <-2.965377, 0.541219, -0.848576>, <-2.951811, 0.546319, -0.845863>, <-2.939366, 0.559674, -0.831889>, <-2.934617, 0.573157, -0.828276>, 
      <-2.962423, 0.550067, -0.869117>, <-2.948857, 0.555168, -0.866404>, <-2.935322, 0.571790, -0.860013>, <-2.930573, 0.585273, -0.856400>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.012440, 0.553635, -0.839077>, <-2.991208, 0.546011, -0.839172>, <-2.965377, 0.541219, -0.848576>, <-2.962423, 0.550067, -0.869117>, 
      <-3.016330, 0.547567, -0.848097>, <-2.995099, 0.539943, -0.848193>, <-2.962408, 0.550112, -0.869221>, <-2.959454, 0.558960, -0.889762>, 
      <-3.026451, 0.545264, -0.864762>, <-3.024753, 0.550350, -0.876568>, <-2.988118, 0.560433, -0.895614>, <-2.982520, 0.571675, -0.898842>, 
      <-3.024939, 0.549793, -0.875275>, <-3.023241, 0.554879, -0.887081>, <-3.009458, 0.568097, -0.895518>, <-3.003860, 0.579338, -0.898746>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-3.021661, 0.669493, -0.845369>, <-3.018758, 0.678193, -0.865566>, <-2.993356, 0.673478, -0.874811>, <-2.972480, 0.665980, -0.874905>, 
      <-3.027064, 0.654920, -0.848803>, <-3.024160, 0.663620, -0.869000>, <-2.998187, 0.660127, -0.878060>, <-2.977310, 0.652630, -0.878154>, 
      <-3.050417, 0.644714, -0.851942>, <-3.046373, 0.656831, -0.880068>, <-3.011580, 0.649059, -0.893196>, <-2.982507, 0.638617, -0.893326>, 
      <-3.055799, 0.630250, -0.855840>, <-3.051755, 0.642367, -0.883967>, <-3.016381, 0.635802, -0.896844>, <-2.987308, 0.625360, -0.896974>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.980914, 0.640709, -0.816237>, <-3.001898, 0.648245, -0.816143>, <-3.024580, 0.660748, -0.825068>, <-3.021661, 0.669493, -0.845369>, 
      <-2.986273, 0.625889, -0.819602>, <-3.007257, 0.633425, -0.819508>, <-3.029982, 0.646175, -0.828502>, <-3.027064, 0.654920, -0.848803>, 
      <-2.993730, 0.604871, -0.811409>, <-3.022953, 0.615367, -0.811279>, <-3.054482, 0.632534, -0.823670>, <-3.050417, 0.644714, -0.851942>, 
      <-2.999056, 0.590160, -0.815268>, <-3.028279, 0.600656, -0.815137>, <-3.059864, 0.618070, -0.827569>, <-3.055799, 0.630250, -0.855840>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.931736, 0.637196, -0.845772>, <-2.934639, 0.628497, -0.825576>, <-2.960039, 0.633212, -0.816331>, <-2.980914, 0.640709, -0.816237>, 
      <-2.936902, 0.622551, -0.849204>, <-2.939805, 0.613852, -0.829008>, <-2.965398, 0.618392, -0.819696>, <-2.986273, 0.625889, -0.819602>, 
      <-2.925451, 0.599816, -0.852503>, <-2.929495, 0.587700, -0.824379>, <-2.964660, 0.594430, -0.811539>, <-2.993730, 0.604871, -0.811409>, 
      <-2.930573, 0.585273, -0.856400>, <-2.934617, 0.573157, -0.828276>, <-2.969986, 0.579719, -0.815398>, <-2.999056, 0.590160, -0.815268>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.931736, 0.637196, -0.845772>, <-2.936902, 0.622551, -0.849204>, <-2.925451, 0.599816, -0.852503>, <-2.930573, 0.585273, -0.856400>, 
      <-2.928818, 0.645940, -0.866073>, <-2.933983, 0.631296, -0.869504>, <-2.921386, 0.611995, -0.880773>, <-2.926508, 0.597452, -0.884669>, 
      <-2.951497, 0.658444, -0.874999>, <-2.956327, 0.645093, -0.878248>, <-2.953286, 0.628122, -0.893457>, <-2.958087, 0.614865, -0.897105>, 
      <-2.972480, 0.665980, -0.874905>, <-2.977310, 0.652630, -0.878154>, <-2.982507, 0.638617, -0.893326>, <-2.987308, 0.625360, -0.896974>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.926741, 0.978364, -0.773820>, <-2.925069, 0.983889, -0.802387>, <-2.891972, 0.974525, -0.814278>, <-2.864543, 0.964674, -0.814400>, 
      <-2.951265, 0.882950, -0.786164>, <-2.949593, 0.888475, -0.814731>, <-2.924687, 0.883724, -0.823893>, <-2.897258, 0.873873, -0.824016>, 
      <-2.987960, 0.760396, -0.823951>, <-2.985057, 0.769095, -0.844148>, <-2.961189, 0.762387, -0.853175>, <-2.940313, 0.754889, -0.853269>, 
      <-3.021661, 0.669493, -0.845369>, <-3.018758, 0.678193, -0.865566>, <-2.993356, 0.673478, -0.874811>, <-2.972480, 0.665980, -0.874905>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.926741, 0.978364, -0.773820>, <-2.901995, 1.074641, -0.761364>, <-2.841632, 1.302608, -0.763371>, <-2.858307, 1.305049, -0.763144>, 
      <-2.925069, 0.983889, -0.802387>, <-2.900323, 1.080167, -0.789931>, <-2.841278, 1.303778, -0.769420>, <-2.857953, 1.306219, -0.769192>, 
      <-2.891972, 0.974525, -0.814278>, <-2.856130, 1.074006, -0.803743>, <-2.817713, 1.210506, -0.810928>, <-2.779554, 1.309634, -0.807830>, 
      <-2.864543, 0.964674, -0.814400>, <-2.828701, 1.064155, -0.803866>, <-2.782940, 1.198837, -0.811079>, <-2.744781, 1.297965, -0.807981>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.869262, 0.949079, -0.733773>, <-2.833831, 1.047252, -0.717929>, <-2.788144, 1.181222, -0.718869>, <-2.750332, 1.279618, -0.713126>, 
      <-2.896841, 0.958984, -0.733650>, <-2.861410, 1.057158, -0.717806>, <-2.822752, 1.192836, -0.718719>, <-2.784940, 1.291232, -0.712976>, 
      <-2.928422, 0.972808, -0.745097>, <-2.903677, 1.069086, -0.732641>, <-2.841985, 1.301444, -0.757351>, <-2.858659, 1.303885, -0.757124>, 
      <-2.926741, 0.978364, -0.773820>, <-2.901995, 1.074641, -0.761364>, <-2.841632, 1.302608, -0.763371>, <-2.858307, 1.305049, -0.763144>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.869262, 0.949079, -0.733773>, <-2.896841, 0.958984, -0.733650>, <-2.928422, 0.972808, -0.745097>, <-2.926741, 0.978364, -0.773820>, 
      <-2.903311, 0.854733, -0.748999>, <-2.930890, 0.864638, -0.748876>, <-2.952946, 0.877394, -0.757441>, <-2.951265, 0.882950, -0.786164>, 
      <-2.947174, 0.734010, -0.795052>, <-2.968158, 0.741546, -0.794958>, <-2.990879, 0.751651, -0.803650>, <-2.987960, 0.760396, -0.823951>, 
      <-2.980914, 0.640709, -0.816237>, <-3.001898, 0.648245, -0.816143>, <-3.024580, 0.660748, -0.825068>, <-3.021661, 0.669493, -0.845369>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.807076, 0.935386, -0.774354>, <-2.768718, 1.027488, -0.761946>, <-2.695470, 1.242631, -0.764008>, <-2.678693, 1.244775, -0.763922>, 
      <-2.808748, 0.929861, -0.745790>, <-2.770389, 1.021963, -0.733383>, <-2.695744, 1.241727, -0.759334>, <-2.678967, 1.243871, -0.759248>, 
      <-2.841836, 0.939229, -0.733895>, <-2.806406, 1.037403, -0.718052>, <-2.761273, 1.172205, -0.718985>, <-2.723461, 1.270601, -0.713242>, 
      <-2.869262, 0.949079, -0.733773>, <-2.833831, 1.047252, -0.717929>, <-2.788144, 1.181222, -0.718869>, <-2.750332, 1.279618, -0.713126>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.807076, 0.935386, -0.774354>, <-2.808748, 0.929861, -0.745790>, <-2.841836, 0.939229, -0.733895>, <-2.869262, 0.949079, -0.733773>, 
      <-2.844961, 0.844420, -0.786609>, <-2.846633, 0.838895, -0.758045>, <-2.875885, 0.844883, -0.749122>, <-2.903311, 0.854733, -0.748999>, 
      <-2.899483, 0.728634, -0.824345>, <-2.902386, 0.719934, -0.804148>, <-2.926299, 0.726513, -0.795146>, <-2.947174, 0.734010, -0.795052>, 
      <-2.931736, 0.637196, -0.845772>, <-2.934639, 0.628497, -0.825576>, <-2.960039, 0.633212, -0.816331>, <-2.980914, 0.640709, -0.816237>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.807076, 0.935386, -0.774354>, <-2.844961, 0.844420, -0.786609>, <-2.899483, 0.728634, -0.824345>, <-2.931736, 0.637196, -0.845772>, 
      <-2.805395, 0.940941, -0.803074>, <-2.843280, 0.849975, -0.815329>, <-2.896564, 0.737378, -0.844645>, <-2.928818, 0.645940, -0.866073>, 
      <-2.836967, 0.954770, -0.814523>, <-2.869682, 0.863969, -0.824139>, <-2.919330, 0.747353, -0.853363>, <-2.951497, 0.658444, -0.874999>, 
      <-2.864543, 0.964674, -0.814400>, <-2.897258, 0.873873, -0.824016>, <-2.940313, 0.754889, -0.853269>, <-2.972480, 0.665980, -0.874905>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.807076, 0.935386, -0.774354>, <-2.805395, 0.940941, -0.803074>, <-2.836967, 0.954770, -0.814523>, <-2.864543, 0.964674, -0.814400>, 
      <-2.768718, 1.027488, -0.761946>, <-2.767037, 1.033043, -0.790667>, <-2.801125, 1.054251, -0.803989>, <-2.828701, 1.064155, -0.803866>, 
      <-2.695470, 1.242631, -0.764008>, <-2.695193, 1.243546, -0.768737>, <-2.755752, 1.189714, -0.811196>, <-2.782940, 1.198837, -0.811079>, 
      <-2.678693, 1.244775, -0.763922>, <-2.678416, 1.245690, -0.768651>, <-2.717593, 1.288842, -0.808099>, <-2.744781, 1.297965, -0.807981>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.646040, 0.588827, -0.883531>, <-2.626122, 0.587031, -0.883197>, <-2.603490, 0.581174, -0.874355>, <-2.604970, 0.573074, -0.856128>, 
      <-2.646040, 0.588827, -0.883531>, <-2.628582, 0.576044, -0.880316>, <-2.616868, 0.571591, -0.877704>, <-2.618348, 0.563491, -0.859477>, 
      <-2.646040, 0.588827, -0.883531>, <-2.628582, 0.576044, -0.880316>, <-2.641090, 0.561904, -0.873011>, <-2.641950, 0.557197, -0.862419>, 
      <-2.646040, 0.588827, -0.883531>, <-2.648500, 0.577839, -0.880650>, <-2.657814, 0.563412, -0.873292>, <-2.658674, 0.558705, -0.862700>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.585942, 0.610806, -0.844494>, <-2.586844, 0.598083, -0.847690>, <-2.594495, 0.580578, -0.853506>, <-2.604970, 0.573074, -0.856128>, 
      <-2.583917, 0.621898, -0.869454>, <-2.584820, 0.609175, -0.872650>, <-2.593015, 0.588678, -0.871734>, <-2.603490, 0.581174, -0.874355>, 
      <-2.614908, 0.629917, -0.881559>, <-2.615916, 0.617245, -0.884822>, <-2.623345, 0.599438, -0.886450>, <-2.626122, 0.587031, -0.883197>, 
      <-2.642182, 0.632375, -0.882017>, <-2.643190, 0.619704, -0.885281>, <-2.643263, 0.601234, -0.886784>, <-2.646040, 0.588827, -0.883531>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.691446, 0.580870, -0.857579>, <-2.684553, 0.571397, -0.860026>, <-2.670592, 0.559779, -0.862900>, <-2.658674, 0.558705, -0.862700>, 
      <-2.691446, 0.580870, -0.857579>, <-2.683042, 0.579665, -0.878632>, <-2.669732, 0.564486, -0.873492>, <-2.657814, 0.563412, -0.873292>, 
      <-2.691446, 0.580870, -0.857579>, <-2.683042, 0.579665, -0.878632>, <-2.668831, 0.579672, -0.880991>, <-2.648500, 0.577839, -0.880650>, 
      <-2.691446, 0.580870, -0.857579>, <-2.689935, 0.589139, -0.876185>, <-2.666371, 0.590660, -0.883872>, <-2.646040, 0.588827, -0.883531>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.691446, 0.580870, -0.857579>, <-2.699053, 0.591325, -0.854878>, <-2.705479, 0.608717, -0.849697>, <-2.704348, 0.621479, -0.846483>, 
      <-2.689935, 0.589139, -0.876185>, <-2.697542, 0.599594, -0.873484>, <-2.703413, 0.620038, -0.875171>, <-2.702282, 0.632800, -0.871958>, 
      <-2.666371, 0.590660, -0.883872>, <-2.663594, 0.603067, -0.887125>, <-2.671026, 0.622213, -0.885748>, <-2.670018, 0.634884, -0.882485>, 
      <-2.646040, 0.588827, -0.883531>, <-2.643263, 0.601234, -0.886784>, <-2.643190, 0.619704, -0.885281>, <-2.642182, 0.632375, -0.882017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.691446, 0.580870, -0.857579>, <-2.689935, 0.589139, -0.876185>, <-2.666371, 0.590660, -0.883872>, <-2.646040, 0.588827, -0.883531>, 
      <-2.684553, 0.571397, -0.860026>, <-2.683042, 0.579665, -0.878632>, <-2.646454, 0.588864, -0.883538>, <-2.626122, 0.587031, -0.883197>, 
      <-2.670592, 0.559779, -0.862900>, <-2.653868, 0.558272, -0.862619>, <-2.616868, 0.571591, -0.877704>, <-2.603490, 0.581174, -0.874355>, 
      <-2.658674, 0.558705, -0.862700>, <-2.641950, 0.557197, -0.862419>, <-2.618348, 0.563491, -0.859477>, <-2.604970, 0.573074, -0.856128>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.650373, 0.565117, -0.830178>, <-2.648485, 0.572478, -0.820578>, <-2.649057, 0.588055, -0.811872>, <-2.648108, 0.599910, -0.808962>, 
      <-2.670291, 0.566913, -0.830512>, <-2.668404, 0.574274, -0.820912>, <-2.676330, 0.590513, -0.812330>, <-2.675382, 0.602368, -0.809420>, 
      <-2.692926, 0.572770, -0.839351>, <-2.700534, 0.583225, -0.836650>, <-2.707504, 0.597625, -0.824738>, <-2.706373, 0.610387, -0.821524>, 
      <-2.691446, 0.580870, -0.857579>, <-2.699053, 0.591325, -0.854878>, <-2.705479, 0.608717, -0.849697>, <-2.704348, 0.621479, -0.846483>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.650373, 0.565117, -0.830178>, <-2.651953, 0.558954, -0.838216>, <-2.659433, 0.554553, -0.853358>, <-2.658674, 0.558705, -0.862700>, 
      <-2.650373, 0.565117, -0.830178>, <-2.671872, 0.560749, -0.838550>, <-2.671351, 0.555628, -0.853558>, <-2.670592, 0.559779, -0.862900>, 
      <-2.650373, 0.565117, -0.830178>, <-2.671872, 0.560749, -0.838550>, <-2.686034, 0.563296, -0.841798>, <-2.684553, 0.571397, -0.860026>, 
      <-2.650373, 0.565117, -0.830178>, <-2.670291, 0.566913, -0.830512>, <-2.692926, 0.572770, -0.839351>, <-2.691446, 0.580870, -0.857579>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.650373, 0.565117, -0.830178>, <-2.651953, 0.558954, -0.838216>, <-2.659433, 0.554553, -0.853358>, <-2.658674, 0.558705, -0.862700>, 
      <-2.670291, 0.566913, -0.830512>, <-2.671872, 0.560749, -0.838550>, <-2.658572, 0.559260, -0.863949>, <-2.657814, 0.563412, -0.873292>, 
      <-2.692926, 0.572770, -0.839351>, <-2.691415, 0.581038, -0.857957>, <-2.668831, 0.579672, -0.880991>, <-2.648500, 0.577839, -0.880650>, 
      <-2.691446, 0.580870, -0.857579>, <-2.689935, 0.589139, -0.876185>, <-2.666371, 0.590660, -0.883872>, <-2.646040, 0.588827, -0.883531>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.650373, 0.565117, -0.830178>, <-2.670291, 0.566913, -0.830512>, <-2.692926, 0.572770, -0.839351>, <-2.691446, 0.580870, -0.857579>, 
      <-2.630043, 0.563284, -0.829837>, <-2.649961, 0.565080, -0.830171>, <-2.686034, 0.563296, -0.841798>, <-2.684553, 0.571397, -0.860026>, 
      <-2.606481, 0.564806, -0.837523>, <-2.619859, 0.555222, -0.840872>, <-2.653868, 0.558272, -0.862619>, <-2.670592, 0.559779, -0.862900>, 
      <-2.604970, 0.573074, -0.856128>, <-2.618348, 0.563491, -0.859477>, <-2.641950, 0.557197, -0.862419>, <-2.658674, 0.558705, -0.862700>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.650373, 0.565117, -0.830178>, <-2.651953, 0.558954, -0.838216>, <-2.659433, 0.554553, -0.853358>, <-2.658674, 0.558705, -0.862700>, 
      <-2.650373, 0.565117, -0.830178>, <-2.631624, 0.557121, -0.837875>, <-2.642709, 0.553045, -0.853077>, <-2.641950, 0.557197, -0.862419>, 
      <-2.650373, 0.565117, -0.830178>, <-2.631624, 0.557121, -0.837875>, <-2.619859, 0.555222, -0.840872>, <-2.618348, 0.563491, -0.859477>, 
      <-2.650373, 0.565117, -0.830178>, <-2.630043, 0.563284, -0.829837>, <-2.606481, 0.564806, -0.837523>, <-2.604970, 0.573074, -0.856128>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.650373, 0.565117, -0.830178>, <-2.648485, 0.572478, -0.820578>, <-2.649057, 0.588055, -0.811872>, <-2.648108, 0.599910, -0.808962>, 
      <-2.630043, 0.563284, -0.829837>, <-2.628155, 0.570646, -0.820237>, <-2.621221, 0.585545, -0.811405>, <-2.620272, 0.597401, -0.808494>, 
      <-2.606481, 0.564806, -0.837523>, <-2.596006, 0.572310, -0.834901>, <-2.588911, 0.586762, -0.822215>, <-2.588008, 0.599486, -0.819020>, 
      <-2.604970, 0.573074, -0.856128>, <-2.594495, 0.580578, -0.853506>, <-2.586844, 0.598083, -0.847690>, <-2.585942, 0.610806, -0.844494>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.650373, 0.565117, -0.830178>, <-2.630043, 0.563284, -0.829837>, <-2.606481, 0.564806, -0.837523>, <-2.604970, 0.573074, -0.856128>, 
      <-2.651953, 0.558954, -0.838216>, <-2.631624, 0.557121, -0.837875>, <-2.605000, 0.572906, -0.855751>, <-2.603490, 0.581174, -0.874355>, 
      <-2.659433, 0.554553, -0.853358>, <-2.658572, 0.559260, -0.863949>, <-2.628582, 0.576044, -0.880316>, <-2.626122, 0.587031, -0.883197>, 
      <-2.658674, 0.558705, -0.862700>, <-2.657814, 0.563412, -0.873292>, <-2.648500, 0.577839, -0.880650>, <-2.646040, 0.588827, -0.883531>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.684150, 0.663195, -0.836847>, <-2.682664, 0.671326, -0.855141>, <-2.659494, 0.672823, -0.862698>, <-2.639504, 0.671020, -0.862362>, 
      <-2.685381, 0.649377, -0.839888>, <-2.683896, 0.657508, -0.858182>, <-2.660518, 0.660156, -0.865582>, <-2.640527, 0.658353, -0.865246>, 
      <-2.703132, 0.635200, -0.843028>, <-2.701066, 0.646521, -0.868502>, <-2.669018, 0.647467, -0.879244>, <-2.641181, 0.644958, -0.878776>, 
      <-2.704348, 0.621479, -0.846483>, <-2.702282, 0.632800, -0.871958>, <-2.670018, 0.634884, -0.882485>, <-2.642182, 0.632375, -0.882017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.643764, 0.647705, -0.809904>, <-2.663349, 0.649471, -0.810233>, <-2.685606, 0.655229, -0.818924>, <-2.684150, 0.663195, -0.836847>, 
      <-2.644907, 0.633663, -0.812886>, <-2.664492, 0.635430, -0.813215>, <-2.686837, 0.641412, -0.821965>, <-2.685381, 0.649377, -0.839888>, 
      <-2.646992, 0.613853, -0.805539>, <-2.674266, 0.616312, -0.805997>, <-2.705157, 0.624109, -0.818068>, <-2.703132, 0.635200, -0.843028>, 
      <-2.648108, 0.599910, -0.808962>, <-2.675382, 0.602368, -0.809420>, <-2.706373, 0.610387, -0.821524>, <-2.704348, 0.621479, -0.846483>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.599121, 0.655526, -0.835418>, <-2.600607, 0.647396, -0.817125>, <-2.623775, 0.645902, -0.809568>, <-2.643764, 0.647705, -0.809904>, 
      <-2.600136, 0.641644, -0.838465>, <-2.601622, 0.633514, -0.820173>, <-2.624918, 0.631860, -0.812550>, <-2.644907, 0.633663, -0.812886>, 
      <-2.584964, 0.624593, -0.841031>, <-2.587030, 0.613273, -0.815557>, <-2.619156, 0.611344, -0.805072>, <-2.646992, 0.613853, -0.805539>, 
      <-2.585942, 0.610806, -0.844494>, <-2.588008, 0.599486, -0.819020>, <-2.620272, 0.597401, -0.808494>, <-2.648108, 0.599910, -0.808962>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.599121, 0.655526, -0.835418>, <-2.600136, 0.641644, -0.838465>, <-2.584964, 0.624593, -0.841031>, <-2.585942, 0.610806, -0.844494>, 
      <-2.597666, 0.663492, -0.853341>, <-2.598680, 0.649609, -0.856388>, <-2.582939, 0.635685, -0.865991>, <-2.583917, 0.621898, -0.869454>, 
      <-2.619919, 0.669254, -0.862033>, <-2.620943, 0.656586, -0.864917>, <-2.613908, 0.642499, -0.878318>, <-2.614908, 0.629917, -0.881559>, 
      <-2.639504, 0.671020, -0.862362>, <-2.640527, 0.658353, -0.865246>, <-2.641181, 0.644958, -0.878776>, <-2.642182, 0.632375, -0.882017>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.674876, 0.952279, -0.773676>, <-2.673361, 0.957283, -0.799550>, <-2.642477, 0.956515, -0.809198>, <-2.616190, 0.954146, -0.808756>, 
      <-2.675703, 0.864158, -0.784726>, <-2.674188, 0.869161, -0.810600>, <-2.649879, 0.870517, -0.817653>, <-2.623593, 0.868148, -0.817211>, 
      <-2.676451, 0.749608, -0.817828>, <-2.674966, 0.757738, -0.836122>, <-2.652684, 0.757127, -0.843503>, <-2.632694, 0.755324, -0.843168>, 
      <-2.684150, 0.663195, -0.836847>, <-2.682664, 0.671326, -0.855141>, <-2.659494, 0.672823, -0.862698>, <-2.639504, 0.671020, -0.862362>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.674876, 0.952279, -0.773676>, <-2.674058, 1.039398, -0.762752>, <-2.664041, 1.246647, -0.763847>, <-2.678693, 1.244775, -0.763922>, 
      <-2.673361, 0.957283, -0.799550>, <-2.672544, 1.044402, -0.788626>, <-2.663746, 1.247623, -0.768893>, <-2.678398, 1.245751, -0.768968>, 
      <-2.642477, 0.956515, -0.809198>, <-2.634370, 1.050697, -0.799938>, <-2.627153, 1.173097, -0.811817>, <-2.618512, 1.267387, -0.804295>, 
      <-2.616190, 0.954146, -0.808756>, <-2.608083, 1.048328, -0.799496>, <-2.596632, 1.175164, -0.811048>, <-2.587991, 1.269453, -0.803526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.620409, 0.940210, -0.736691>, <-2.612603, 1.033207, -0.722687>, <-2.601062, 1.159039, -0.719317>, <-2.592953, 1.253057, -0.718748>, 
      <-2.646134, 0.942528, -0.737123>, <-2.638328, 1.035525, -0.723120>, <-2.630166, 1.157069, -0.720050>, <-2.622057, 1.251087, -0.719481>, 
      <-2.676358, 0.947382, -0.748355>, <-2.675541, 1.034502, -0.737431>, <-2.664323, 1.245717, -0.759035>, <-2.678975, 1.243845, -0.759110>, 
      <-2.674876, 0.952279, -0.773676>, <-2.674058, 1.039398, -0.762752>, <-2.664041, 1.246647, -0.763847>, <-2.678693, 1.244775, -0.763922>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.620409, 0.940210, -0.736691>, <-2.646134, 0.942528, -0.737123>, <-2.676358, 0.947382, -0.748355>, <-2.674876, 0.952279, -0.773676>, 
      <-2.627914, 0.850800, -0.750155>, <-2.653638, 0.853117, -0.750587>, <-2.677185, 0.859261, -0.759405>, <-2.675703, 0.864158, -0.784726>, 
      <-2.636563, 0.736175, -0.791115>, <-2.656148, 0.737942, -0.791444>, <-2.677907, 0.741642, -0.799905>, <-2.676451, 0.749608, -0.817828>, 
      <-2.643764, 0.647705, -0.809904>, <-2.663349, 0.649471, -0.810233>, <-2.685606, 0.655229, -0.818924>, <-2.684150, 0.663195, -0.836847>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.561723, 0.942083, -0.771775>, <-2.550030, 1.035324, -0.760053>, <-2.529779, 1.160818, -0.763946>, <-2.523914, 1.255254, -0.760022>, 
      <-2.563238, 0.937079, -0.745900>, <-2.551545, 1.030320, -0.734178>, <-2.531164, 1.156242, -0.740284>, <-2.525299, 1.250678, -0.736360>, 
      <-2.594121, 0.937841, -0.736249>, <-2.586316, 1.030838, -0.722246>, <-2.576985, 1.160669, -0.718710>, <-2.568876, 1.254687, -0.718141>, 
      <-2.620409, 0.940210, -0.736691>, <-2.612603, 1.033207, -0.722687>, <-2.601062, 1.159039, -0.719317>, <-2.592953, 1.253057, -0.718748>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.561723, 0.942083, -0.771775>, <-2.563238, 0.937079, -0.745900>, <-2.594121, 0.937841, -0.736249>, <-2.620409, 0.940210, -0.736691>, 
      <-2.572684, 0.854677, -0.782763>, <-2.574199, 0.849673, -0.756888>, <-2.601626, 0.848431, -0.749713>, <-2.627914, 0.850800, -0.750155>, 
      <-2.592798, 0.742015, -0.816433>, <-2.594284, 0.733885, -0.798140>, <-2.616574, 0.734372, -0.790779>, <-2.636563, 0.736175, -0.791115>, 
      <-2.599121, 0.655526, -0.835418>, <-2.600607, 0.647396, -0.817125>, <-2.623775, 0.645902, -0.809568>, <-2.643764, 0.647705, -0.809904>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.561723, 0.942083, -0.771775>, <-2.572684, 0.854677, -0.782763>, <-2.592798, 0.742015, -0.816433>, <-2.599121, 0.655526, -0.835418>, 
      <-2.560241, 0.946979, -0.797095>, <-2.571202, 0.859573, -0.808083>, <-2.591342, 0.749981, -0.834355>, <-2.597666, 0.663492, -0.853341>, 
      <-2.590466, 0.951828, -0.808324>, <-2.597869, 0.865830, -0.816779>, <-2.613109, 0.753558, -0.842839>, <-2.619919, 0.669254, -0.862033>, 
      <-2.616190, 0.954146, -0.808756>, <-2.623593, 0.868148, -0.817211>, <-2.632694, 0.755324, -0.843168>, <-2.639504, 0.671020, -0.862362>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.561723, 0.942083, -0.771775>, <-2.560241, 0.946979, -0.797095>, <-2.590466, 0.951828, -0.808324>, <-2.616190, 0.954146, -0.808756>, 
      <-2.550030, 1.035324, -0.760053>, <-2.548548, 1.040220, -0.785373>, <-2.582359, 1.046010, -0.799064>, <-2.608083, 1.048328, -0.799496>, 
      <-2.529779, 1.160818, -0.763946>, <-2.528424, 1.165296, -0.787100>, <-2.573071, 1.176759, -0.810454>, <-2.596632, 1.175164, -0.811048>, 
      <-2.523914, 1.255254, -0.760022>, <-2.522559, 1.259732, -0.783176>, <-2.564430, 1.271048, -0.802932>, <-2.587991, 1.269453, -0.803526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.342483, 1.996156, 0.019320>, <-0.344123, 1.972140, -0.115517>, <-0.318392, 2.049263, -0.258013>, <-0.293817, 2.182389, -0.278845>, 
      <-0.540673, 1.850071, 0.032165>, <-0.542312, 1.826056, -0.102672>, <-0.552988, 2.011302, -0.252110>, <-0.528413, 2.144428, -0.272942>, 
      <-0.806513, 1.645617, 0.121506>, <-0.714708, 1.659854, -0.106622>, <-0.770419, 1.948964, -0.162562>, <-0.876013, 2.168790, -0.197200>, 
      <-1.003116, 1.509207, 0.062138>, <-0.911311, 1.523444, -0.165990>, <-0.970210, 1.836028, -0.224531>, <-1.075804, 2.055854, -0.259169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.287633, 2.272971, 0.229732>, <-0.312008, 2.140930, 0.250395>, <-0.340857, 2.019976, 0.153058>, <-0.342483, 1.996156, 0.019320>, 
      <-0.587533, 2.197996, 0.240726>, <-0.611908, 2.065955, 0.261388>, <-0.539047, 1.873891, 0.165904>, <-0.540673, 1.850071, 0.032165>, 
      <-1.023391, 2.173822, 0.323858>, <-0.920533, 1.959690, 0.357599>, <-0.895941, 1.631749, 0.343724>, <-0.806513, 1.645617, 0.121506>, 
      <-1.287300, 2.023056, 0.266378>, <-1.184442, 1.808924, 0.300119>, <-1.092544, 1.495339, 0.284357>, <-1.003116, 1.509207, 0.062138>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.238968, 2.556909, -0.068430>, <-0.237053, 2.584964, 0.089088>, <-0.258924, 2.428490, 0.205395>, <-0.287633, 2.272971, 0.229732>, 
      <-0.575273, 2.465478, -0.064379>, <-0.573357, 2.493533, 0.093139>, <-0.558824, 2.353515, 0.216389>, <-0.587533, 2.197996, 0.240726>, 
      <-1.060348, 2.416096, 0.014454>, <-1.118065, 2.407145, 0.157874>, <-1.089776, 2.312022, 0.302082>, <-1.023391, 2.173822, 0.323858>, 
      <-1.359984, 2.252139, -0.054926>, <-1.417700, 2.243189, 0.088493>, <-1.353685, 2.161256, 0.244602>, <-1.287300, 2.023056, 0.266378>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-0.238968, 2.556909, -0.068430>, <-0.575273, 2.465478, -0.064379>, <-1.060348, 2.416096, 0.014454>, <-1.359984, 2.252139, -0.054926>, 
      <-0.240969, 2.527604, -0.232966>, <-0.577273, 2.436173, -0.228915>, <-1.002631, 2.425046, -0.128966>, <-1.302267, 2.261090, -0.198347>, 
      <-0.263829, 2.344837, -0.304266>, <-0.498425, 2.306877, -0.298363>, <-0.942398, 2.306991, -0.218976>, <-1.142189, 2.194056, -0.280946>, 
      <-0.293817, 2.182389, -0.278845>, <-0.528413, 2.144428, -0.272942>, <-0.876013, 2.168790, -0.197200>, <-1.075804, 2.055854, -0.259169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.391123, 1.268572, -0.297336>, <-1.273229, 1.364030, -0.211431>, <-1.142132, 1.412753, 0.020160>, <-1.003116, 1.509207, 0.062138>, 
      <-1.326198, 1.283858, -0.451616>, <-1.208305, 1.379316, -0.365711>, <-1.050326, 1.426990, -0.207968>, <-0.911311, 1.523444, -0.165990>, 
      <-1.368293, 1.393392, -0.610861>, <-1.241672, 1.579105, -0.540826>, <-1.168076, 1.724181, -0.285903>, <-0.970210, 1.836028, -0.224531>, 
      <-1.483799, 1.509729, -0.647943>, <-1.357178, 1.695442, -0.577908>, <-1.273670, 1.944007, -0.320541>, <-1.075804, 2.055854, -0.259169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.721704, 1.453716, -0.082613>, <-1.607187, 1.620710, 0.044341>, <-1.491205, 1.906570, 0.221967>, <-1.287300, 2.023056, 0.266378>, 
      <-1.606199, 1.337379, -0.045532>, <-1.491681, 1.504373, 0.081422>, <-1.388346, 1.692438, 0.255708>, <-1.184442, 1.808924, 0.300119>, 
      <-1.456047, 1.253286, -0.143057>, <-1.338154, 1.348744, -0.057153>, <-1.231559, 1.398885, 0.242378>, <-1.092544, 1.495339, 0.284357>, 
      <-1.391123, 1.268572, -0.297336>, <-1.273229, 1.364030, -0.211431>, <-1.142132, 1.412753, 0.020160>, <-1.003116, 1.509207, 0.062138>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.814373, 1.694868, -0.433214>, <-1.703680, 1.882951, -0.324664>, <-1.569530, 2.137478, -0.103446>, <-1.359984, 2.252139, -0.054926>, 
      <-1.879296, 1.679582, -0.278938>, <-1.768603, 1.867665, -0.170388>, <-1.627247, 2.128528, 0.039973>, <-1.417700, 2.243189, 0.088493>, 
      <-1.837208, 1.570051, -0.119694>, <-1.722690, 1.737045, 0.007260>, <-1.557589, 2.044770, 0.200191>, <-1.353685, 2.161256, 0.244602>, 
      <-1.721704, 1.453716, -0.082613>, <-1.607187, 1.620710, 0.044341>, <-1.491205, 1.906570, 0.221967>, <-1.287300, 2.023056, 0.266378>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.814373, 1.694868, -0.433214>, <-1.749449, 1.710154, -0.587491>, <-1.599303, 1.626064, -0.685024>, <-1.483799, 1.509729, -0.647943>, 
      <-1.703680, 1.882951, -0.324664>, <-1.638756, 1.898236, -0.478941>, <-1.472683, 1.811778, -0.614989>, <-1.357178, 1.695442, -0.577908>, 
      <-1.569530, 2.137478, -0.103446>, <-1.511813, 2.146429, -0.246867>, <-1.340055, 2.082208, -0.342318>, <-1.273670, 1.944007, -0.320541>, 
      <-1.359984, 2.252139, -0.054926>, <-1.302267, 2.261090, -0.198347>, <-1.142189, 2.194056, -0.280946>, <-1.075804, 2.055854, -0.259169>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.742184, 0.910784, -0.476394>, <-1.611266, 0.991234, -0.432954>, <-1.499111, 1.181134, -0.376023>, <-1.391123, 1.268572, -0.297336>, 
      <-1.730442, 0.841809, -0.557547>, <-1.599524, 0.922258, -0.514107>, <-1.434187, 1.196420, -0.530303>, <-1.326198, 1.283858, -0.451616>, 
      <-1.823743, 0.795645, -0.657491>, <-1.642806, 0.929829, -0.616333>, <-1.491451, 1.212756, -0.678982>, <-1.368293, 1.393392, -0.610861>, 
      <-1.887794, 0.864914, -0.708290>, <-1.706857, 0.999098, -0.667131>, <-1.606957, 1.329093, -0.716063>, <-1.483799, 1.509729, -0.647943>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.926319, 1.091213, -0.442038>, <-1.846120, 1.195152, -0.342106>, <-1.800761, 1.338432, -0.170256>, <-1.721704, 1.453716, -0.082613>, 
      <-1.866319, 1.026324, -0.394452>, <-1.786120, 1.130264, -0.294520>, <-1.685256, 1.222096, -0.133174>, <-1.606199, 1.337379, -0.045532>, 
      <-1.753184, 0.975397, -0.400374>, <-1.622266, 1.055847, -0.356934>, <-1.564036, 1.165848, -0.221745>, <-1.456047, 1.253286, -0.143057>, 
      <-1.742184, 0.910784, -0.476394>, <-1.611266, 0.991234, -0.432954>, <-1.499111, 1.181134, -0.376023>, <-1.391123, 1.268572, -0.297336>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.991030, 1.179905, -0.673754>, <-1.929796, 1.320425, -0.582171>, <-1.895463, 1.557086, -0.512734>, <-1.814373, 1.694868, -0.433214>, 
      <-2.001874, 1.243607, -0.598806>, <-1.940640, 1.384126, -0.507222>, <-1.960386, 1.541800, -0.358457>, <-1.879296, 1.679582, -0.278938>, 
      <-1.985473, 1.155186, -0.488953>, <-1.905274, 1.259126, -0.389021>, <-1.916265, 1.454767, -0.207336>, <-1.837208, 1.570051, -0.119694>, 
      <-1.926319, 1.091213, -0.442038>, <-1.846120, 1.195152, -0.342106>, <-1.800761, 1.338432, -0.170256>, <-1.721704, 1.453716, -0.082613>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.991030, 1.179905, -0.673754>, <-1.976935, 1.097108, -0.771169>, <-1.964680, 0.948064, -0.769268>, <-1.887794, 0.864914, -0.708290>, 
      <-1.929796, 1.320425, -0.582171>, <-1.915701, 1.237628, -0.679585>, <-1.783743, 1.082248, -0.728109>, <-1.706857, 0.999098, -0.667131>, 
      <-1.895463, 1.557086, -0.512734>, <-1.830539, 1.572371, -0.667011>, <-1.722462, 1.445429, -0.753144>, <-1.606957, 1.329093, -0.716063>, 
      <-1.814373, 1.694868, -0.433214>, <-1.749449, 1.710154, -0.587491>, <-1.599303, 1.626064, -0.685024>, <-1.483799, 1.509729, -0.647943>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.281748, 0.721278, -0.592855>, <-2.126887, 0.639600, -0.591806>, <-1.885729, 0.822575, -0.524024>, <-1.742184, 0.910784, -0.476394>, 
      <-2.345513, 0.708191, -0.693140>, <-2.190652, 0.626513, -0.692091>, <-1.873986, 0.753600, -0.605176>, <-1.730442, 0.841809, -0.557547>, 
      <-2.327319, 0.825804, -0.781774>, <-2.247519, 0.732426, -0.780574>, <-1.920802, 0.723665, -0.679570>, <-1.823743, 0.795645, -0.657491>, 
      <-2.275059, 0.922924, -0.827935>, <-2.195259, 0.829546, -0.826735>, <-1.984853, 0.792935, -0.730368>, <-1.887794, 0.864914, -0.708290>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.104203, 0.957989, -0.559227>, <-2.033460, 0.931978, -0.558892>, <-1.962957, 1.043729, -0.487691>, <-1.926319, 1.091213, -0.442038>, 
      <-2.154440, 0.864626, -0.514852>, <-2.083698, 0.838615, -0.514517>, <-1.902957, 0.978841, -0.440105>, <-1.866319, 1.026324, -0.394452>, 
      <-2.220450, 0.733858, -0.496451>, <-2.065589, 0.652180, -0.495402>, <-1.896728, 0.887188, -0.448003>, <-1.753184, 0.975397, -0.400374>, 
      <-2.281748, 0.721278, -0.592855>, <-2.126887, 0.639600, -0.591806>, <-1.885729, 0.822575, -0.524024>, <-1.742184, 0.910784, -0.476394>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.055017, 1.142640, -0.793128>, <-2.031979, 1.107381, -0.791706>, <-2.005482, 1.146740, -0.695369>, <-1.991030, 1.179905, -0.673754>, 
      <-1.992847, 1.155399, -0.695353>, <-1.969809, 1.120140, -0.693931>, <-2.016327, 1.210442, -0.620421>, <-2.001874, 1.243607, -0.598806>, 
      <-2.053251, 1.052679, -0.604233>, <-1.982509, 1.026668, -0.603898>, <-2.022111, 1.107703, -0.534606>, <-1.985473, 1.155186, -0.488953>, 
      <-2.104203, 0.957989, -0.559227>, <-2.033460, 0.931978, -0.558892>, <-1.962957, 1.043729, -0.487691>, <-1.926319, 1.091213, -0.442038>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.055017, 1.142640, -0.793128>, <-2.119422, 1.129422, -0.894420>, <-2.222275, 1.021020, -0.874560>, <-2.275059, 0.922924, -0.827935>, 
      <-2.031979, 1.107381, -0.791706>, <-2.096384, 1.094163, -0.892998>, <-2.142474, 0.927642, -0.873360>, <-2.195259, 0.829546, -0.826735>, 
      <-2.005482, 1.146740, -0.695369>, <-1.991387, 1.063943, -0.792784>, <-2.061738, 0.876084, -0.791346>, <-1.984853, 0.792935, -0.730368>, 
      <-1.991030, 1.179905, -0.673754>, <-1.976935, 1.097108, -0.771169>, <-1.964680, 0.948064, -0.769268>, <-1.887794, 0.864914, -0.708290>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.359684, 1.236472, -0.480577>, <-2.361738, 1.085942, -0.534484>, <-2.423183, 0.795875, -0.593813>, <-2.281748, 0.721278, -0.592855>, 
      <-2.409301, 1.283372, -0.555191>, <-2.411355, 1.132842, -0.609098>, <-2.486948, 0.782788, -0.694098>, <-2.345513, 0.708191, -0.693140>, 
      <-2.368456, 1.322765, -0.661814>, <-2.379913, 1.204305, -0.702341>, <-2.408994, 0.921375, -0.783001>, <-2.327319, 0.825804, -0.781774>, 
      <-2.282022, 1.326217, -0.714216>, <-2.293479, 1.207758, -0.754743>, <-2.356734, 1.018496, -0.829163>, <-2.275059, 0.922924, -0.827935>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.101578, 1.155654, -0.442867>, <-2.113719, 1.096589, -0.476027>, <-2.168791, 0.981737, -0.559532>, <-2.104203, 0.957989, -0.559227>, 
      <-2.191648, 1.152057, -0.388261>, <-2.203789, 1.092992, -0.421421>, <-2.219028, 0.888375, -0.515158>, <-2.154440, 0.864626, -0.514852>, 
      <-2.307979, 1.187599, -0.402824>, <-2.310034, 1.037069, -0.456732>, <-2.361885, 0.808455, -0.497409>, <-2.220450, 0.733858, -0.496451>, 
      <-2.359684, 1.236472, -0.480577>, <-2.361738, 1.085942, -0.534484>, <-2.423183, 0.795875, -0.593813>, <-2.281748, 0.721278, -0.592855>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.036426, 1.249383, -0.676556>, <-2.047931, 1.208774, -0.698875>, <-2.081118, 1.182587, -0.794739>, <-2.055017, 1.142640, -0.793128>, 
      <-1.987183, 1.202837, -0.602505>, <-1.998688, 1.162228, -0.624824>, <-2.018948, 1.195346, -0.696964>, <-1.992847, 1.155399, -0.695353>, 
      <-2.015796, 1.159080, -0.494873>, <-2.027937, 1.100015, -0.528033>, <-2.117839, 1.076427, -0.604538>, <-2.053251, 1.052679, -0.604233>, 
      <-2.101578, 1.155654, -0.442867>, <-2.113719, 1.096589, -0.476027>, <-2.168791, 0.981737, -0.559532>, <-2.104203, 0.957989, -0.559227>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.036426, 1.249383, -0.676556>, <-2.085668, 1.295929, -0.750606>, <-2.196241, 1.329643, -0.766222>, <-2.282022, 1.326217, -0.714216>, 
      <-2.047931, 1.208774, -0.698875>, <-2.097173, 1.255320, -0.772925>, <-2.207698, 1.211184, -0.806748>, <-2.293479, 1.207758, -0.754743>, 
      <-2.081118, 1.182587, -0.794739>, <-2.145523, 1.169369, -0.896031>, <-2.303950, 1.116591, -0.875787>, <-2.356734, 1.018496, -0.829163>, 
      <-2.055017, 1.142640, -0.793128>, <-2.119422, 1.129422, -0.894420>, <-2.222275, 1.021020, -0.874560>, <-2.275059, 0.922924, -0.827935>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.228126, 2.145848, -0.148410>, <-2.192726, 2.092328, -0.164900>, <-2.146680, 2.113377, -0.244685>, <-2.130917, 2.159837, -0.289210>, 
      <-2.270189, 2.110044, -0.201697>, <-2.234789, 2.056524, -0.218186>, <-2.177587, 2.081252, -0.297616>, <-2.161825, 2.127712, -0.342141>, 
      <-2.314612, 2.057083, -0.278570>, <-2.253281, 2.013582, -0.296155>, <-2.196120, 2.034450, -0.382785>, <-2.177747, 2.088601, -0.434681>, 
      <-2.353822, 2.011065, -0.325852>, <-2.292490, 1.967564, -0.343437>, <-2.234977, 1.987969, -0.416230>, <-2.216604, 2.042120, -0.468126>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.303468, 2.420710, -0.208835>, <-2.330219, 2.341863, -0.133272>, <-2.288203, 2.236677, -0.120426>, <-2.228126, 2.145848, -0.148410>, 
      <-2.369550, 2.380916, -0.268402>, <-2.396301, 2.302069, -0.192839>, <-2.330266, 2.200873, -0.173712>, <-2.270189, 2.110044, -0.201697>, 
      <-2.397163, 2.271823, -0.354186>, <-2.417415, 2.212133, -0.296982>, <-2.382217, 2.105033, -0.259186>, <-2.314612, 2.057083, -0.278570>, 
      <-2.437931, 2.199102, -0.404666>, <-2.458184, 2.139412, -0.347462>, <-2.421427, 2.059016, -0.306468>, <-2.353822, 2.011065, -0.325852>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.152264, 2.369451, -0.362700>, <-2.197988, 2.438579, -0.341402>, <-2.283109, 2.480719, -0.266345>, <-2.303468, 2.420710, -0.208835>, 
      <-2.207584, 2.345705, -0.410306>, <-2.253308, 2.414833, -0.389008>, <-2.349191, 2.440925, -0.325911>, <-2.369550, 2.380916, -0.268402>, 
      <-2.233821, 2.299234, -0.517613>, <-2.301329, 2.347116, -0.498257>, <-2.376939, 2.331428, -0.411309>, <-2.397163, 2.271823, -0.354186>, 
      <-2.275494, 2.241921, -0.547094>, <-2.343002, 2.289803, -0.527738>, <-2.417707, 2.258707, -0.461789>, <-2.437931, 2.199102, -0.404666>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.152264, 2.369451, -0.362700>, <-2.207584, 2.345705, -0.410306>, <-2.233821, 2.299234, -0.517613>, <-2.275494, 2.241921, -0.547094>, 
      <-2.106248, 2.299881, -0.384134>, <-2.161568, 2.276135, -0.431741>, <-2.165538, 2.250803, -0.537192>, <-2.207211, 2.193490, -0.566672>, 
      <-2.110428, 2.220229, -0.347087>, <-2.141335, 2.188105, -0.400018>, <-2.157291, 2.148890, -0.492459>, <-2.196148, 2.102409, -0.525904>, 
      <-2.130917, 2.159837, -0.289210>, <-2.161825, 2.127712, -0.342141>, <-2.177747, 2.088601, -0.434681>, <-2.216604, 2.042120, -0.468126>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.105953, 2.222048, -0.011844>, <-2.137842, 2.148285, -0.079520>, <-2.172894, 2.101761, -0.220115>, <-2.104721, 2.158407, -0.276522>, 
      <-2.124220, 2.278577, -0.015747>, <-2.156110, 2.204814, -0.083423>, <-2.176008, 2.104563, -0.212442>, <-2.107835, 2.161209, -0.268848>, 
      <-2.195498, 2.173621, -0.107076>, <-2.160098, 2.120100, -0.123565>, <-2.142775, 2.117435, -0.237998>, <-2.127012, 2.163895, -0.282523>, 
      <-2.228126, 2.145848, -0.148410>, <-2.192726, 2.092328, -0.164900>, <-2.146680, 2.113377, -0.244685>, <-2.130917, 2.159837, -0.289210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.963655, 2.484705, 0.022847>, <-2.038967, 2.422126, 0.085161>, <-2.070724, 2.303536, 0.062919>, <-2.105953, 2.222048, -0.011844>, 
      <-2.045280, 2.573402, -0.009746>, <-2.120592, 2.510823, 0.052568>, <-2.088991, 2.360065, 0.059016>, <-2.124220, 2.278577, -0.015747>, 
      <-2.218802, 2.471694, -0.132518>, <-2.245553, 2.392848, -0.056954>, <-2.255575, 2.264449, -0.079091>, <-2.195498, 2.173621, -0.107076>, 
      <-2.303468, 2.420710, -0.208835>, <-2.330219, 2.341863, -0.133272>, <-2.288203, 2.236677, -0.120426>, <-2.228126, 2.145848, -0.148410>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.875291, 2.413711, -0.202696>, <-1.845721, 2.482109, -0.139943>, <-1.900441, 2.537231, -0.029457>, <-1.963655, 2.484705, 0.022847>, 
      <-1.949933, 2.473819, -0.216846>, <-1.920363, 2.542217, -0.154093>, <-1.982066, 2.625928, -0.062050>, <-2.045280, 2.573402, -0.009746>, 
      <-2.082438, 2.399424, -0.302611>, <-2.128162, 2.468552, -0.281313>, <-2.198443, 2.531704, -0.190027>, <-2.218802, 2.471694, -0.132518>, 
      <-2.152264, 2.369451, -0.362700>, <-2.197988, 2.438579, -0.341402>, <-2.283109, 2.480719, -0.266345>, <-2.303468, 2.420710, -0.208835>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.875291, 2.413711, -0.202696>, <-1.949933, 2.473819, -0.216846>, <-2.082438, 2.399424, -0.302611>, <-2.152264, 2.369451, -0.362700>, 
      <-1.916420, 2.318576, -0.289979>, <-1.991062, 2.378685, -0.304130>, <-2.036423, 2.329855, -0.324045>, <-2.106248, 2.299881, -0.384134>, 
      <-2.016797, 2.231465, -0.349271>, <-2.019911, 2.234268, -0.341598>, <-2.106523, 2.224288, -0.340400>, <-2.110428, 2.220229, -0.347087>, 
      <-2.104721, 2.158407, -0.276522>, <-2.107835, 2.161209, -0.268848>, <-2.127012, 2.163895, -0.282523>, <-2.130917, 2.159837, -0.289210>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.172483, 1.973656, -0.136520>, <-2.227857, 2.015483, -0.223023>, <-2.197447, 2.100638, -0.322152>, <-2.100148, 2.132148, -0.365030>, 
      <-2.149488, 2.049265, -0.103283>, <-2.204862, 2.091093, -0.189786>, <-2.192130, 2.122920, -0.306524>, <-2.094831, 2.154430, -0.349402>, 
      <-2.079648, 2.140644, -0.006223>, <-2.111537, 2.066880, -0.073899>, <-2.163016, 2.092872, -0.244455>, <-2.094844, 2.149518, -0.300861>, 
      <-2.105953, 2.222048, -0.011844>, <-2.137842, 2.148285, -0.079520>, <-2.172894, 2.101761, -0.220115>, <-2.104721, 2.158407, -0.276522>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.896011, 1.977950, -0.046135>, <-1.994514, 1.946050, -0.002727>, <-2.116424, 1.931311, -0.048947>, <-2.172483, 1.973656, -0.136520>, 
      <-1.894390, 2.128005, -0.008280>, <-1.992893, 2.096105, 0.035129>, <-2.093429, 2.006920, -0.015710>, <-2.149488, 2.049265, -0.103283>, 
      <-1.862487, 2.374772, 0.063244>, <-1.937799, 2.312193, 0.125558>, <-2.044418, 2.222132, 0.068540>, <-2.079648, 2.140644, -0.006223>, 
      <-1.963655, 2.484705, 0.022847>, <-2.038967, 2.422126, 0.085161>, <-2.070724, 2.303536, 0.062919>, <-2.105953, 2.222048, -0.011844>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.807534, 2.091844, -0.297347>, <-1.751713, 2.049679, -0.210146>, <-1.797927, 2.009714, -0.089359>, <-1.896011, 1.977950, -0.046135>, 
      <-1.804879, 2.187266, -0.259520>, <-1.749059, 2.145101, -0.172319>, <-1.796306, 2.159770, -0.051504>, <-1.894390, 2.128005, -0.008280>, 
      <-1.796175, 2.350000, -0.187697>, <-1.766605, 2.418398, -0.124944>, <-1.799273, 2.427298, 0.010940>, <-1.862487, 2.374772, 0.063244>, 
      <-1.875291, 2.413711, -0.202696>, <-1.845721, 2.482109, -0.139943>, <-1.900441, 2.537231, -0.029457>, <-1.963655, 2.484705, 0.022847>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.807534, 2.091844, -0.297347>, <-1.804879, 2.187266, -0.259520>, <-1.796175, 2.350000, -0.187697>, <-1.875291, 2.413711, -0.202696>, 
      <-1.865930, 2.135954, -0.388571>, <-1.863275, 2.231377, -0.350744>, <-1.837304, 2.254865, -0.274981>, <-1.916420, 2.318576, -0.289979>, 
      <-1.997538, 2.165378, -0.410248>, <-1.992222, 2.187660, -0.394621>, <-2.006920, 2.222577, -0.373611>, <-2.016797, 2.231465, -0.349271>, 
      <-2.100148, 2.132148, -0.365030>, <-2.094831, 2.154430, -0.349402>, <-2.094844, 2.149518, -0.300861>, <-2.104721, 2.158407, -0.276522>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.268562, 1.687374, -0.246881>, <-2.327770, 1.743338, -0.335914>, <-2.292186, 1.794522, -0.463531>, <-2.190223, 1.800065, -0.527852>, 
      <-2.246933, 1.772550, -0.207128>, <-2.306140, 1.828514, -0.296160>, <-2.269030, 1.897131, -0.419074>, <-2.167067, 1.902674, -0.483395>, 
      <-2.198353, 1.888593, -0.173913>, <-2.253726, 1.930421, -0.260415>, <-2.219341, 2.008877, -0.386510>, <-2.122042, 2.040387, -0.429388>, 
      <-2.172483, 1.973656, -0.136520>, <-2.227857, 2.015483, -0.223023>, <-2.197447, 2.100638, -0.322152>, <-2.100148, 2.132148, -0.365030>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-2.268562, 1.687374, -0.246881>, <-2.303274, 1.550679, -0.310679>, <-2.357695, 1.382190, -0.428393>, <-2.359684, 1.236472, -0.480577>, 
      <-2.327770, 1.743338, -0.335914>, <-2.362482, 1.606643, -0.399712>, <-2.407312, 1.429090, -0.503007>, <-2.409301, 1.283372, -0.555191>, 
      <-2.292186, 1.794522, -0.463531>, <-2.323659, 1.655058, -0.523957>, <-2.354311, 1.469014, -0.611780>, <-2.368456, 1.322765, -0.661814>, 
      <-2.190223, 1.800065, -0.527852>, <-2.221696, 1.660601, -0.588278>, <-2.267877, 1.472466, -0.664182>, <-2.282022, 1.326217, -0.714216>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.973266, 1.594994, -0.201605>, <-2.075230, 1.589451, -0.137284>, <-2.209354, 1.631409, -0.157847>, <-2.268562, 1.687374, -0.246881>, 
      <-1.945558, 1.705829, -0.148131>, <-2.047523, 1.700286, -0.083809>, <-2.187724, 1.716586, -0.118094>, <-2.246933, 1.772550, -0.207128>, 
      <-1.897332, 1.855648, -0.076989>, <-1.995835, 1.823748, -0.033580>, <-2.142294, 1.846249, -0.086340>, <-2.198353, 1.888593, -0.173913>, 
      <-1.896011, 1.977950, -0.046135>, <-1.994514, 1.946050, -0.002727>, <-2.116424, 1.931311, -0.048947>, <-2.172483, 1.973656, -0.136520>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.973266, 1.594994, -0.201605>, <-2.007360, 1.458612, -0.267405>, <-2.074194, 1.288877, -0.368074>, <-2.101578, 1.155654, -0.442867>, 
      <-2.075230, 1.589451, -0.137284>, <-2.109325, 1.453069, -0.203084>, <-2.164264, 1.285279, -0.313468>, <-2.191648, 1.152057, -0.388261>, 
      <-2.209354, 1.631409, -0.157847>, <-2.244066, 1.494714, -0.221645>, <-2.305990, 1.333316, -0.350641>, <-2.307979, 1.187599, -0.402824>, 
      <-2.268562, 1.687374, -0.246881>, <-2.303274, 1.550679, -0.310679>, <-2.357695, 1.382190, -0.428393>, <-2.359684, 1.236472, -0.480577>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.894932, 1.707685, -0.482575>, <-1.932259, 1.570300, -0.544415>, <-1.999024, 1.381400, -0.603998>, <-2.036426, 1.249383, -0.676556>, 
      <-1.835725, 1.651722, -0.393543>, <-1.873052, 1.514337, -0.455383>, <-1.949781, 1.334854, -0.529948>, <-1.987183, 1.202837, -0.602505>, 
      <-1.871304, 1.600537, -0.265925>, <-1.905398, 1.464155, -0.331725>, <-1.988412, 1.292303, -0.420081>, <-2.015796, 1.159080, -0.494873>, 
      <-1.973266, 1.594994, -0.201605>, <-2.007360, 1.458612, -0.267405>, <-2.074194, 1.288877, -0.368074>, <-2.101578, 1.155654, -0.442867>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.894932, 1.707685, -0.482575>, <-1.835725, 1.651722, -0.393543>, <-1.871304, 1.600537, -0.265925>, <-1.973266, 1.594994, -0.201605>, 
      <-1.863524, 1.823285, -0.430541>, <-1.804317, 1.767321, -0.341509>, <-1.843596, 1.711371, -0.212451>, <-1.945558, 1.705829, -0.148131>, 
      <-1.810910, 1.970473, -0.345461>, <-1.755090, 1.928308, -0.258259>, <-1.799248, 1.887412, -0.120213>, <-1.897332, 1.855648, -0.076989>, 
      <-1.807534, 2.091844, -0.297347>, <-1.751713, 2.049679, -0.210146>, <-1.797927, 2.009714, -0.089359>, <-1.896011, 1.977950, -0.046135>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.894932, 1.707685, -0.482575>, <-1.863524, 1.823285, -0.430541>, <-1.810910, 1.970473, -0.345461>, <-1.807534, 2.091844, -0.297347>, 
      <-1.954139, 1.763649, -0.571608>, <-1.922732, 1.879249, -0.519574>, <-1.869306, 2.014583, -0.436685>, <-1.865930, 2.135954, -0.388571>, 
      <-2.088260, 1.805608, -0.592172>, <-2.065104, 1.908217, -0.547715>, <-2.019433, 2.073617, -0.474606>, <-1.997538, 2.165378, -0.410248>, 
      <-2.190223, 1.800065, -0.527852>, <-2.167067, 1.902674, -0.483395>, <-2.122042, 2.040387, -0.429388>, <-2.100148, 2.132148, -0.365030>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <-1.894932, 1.707685, -0.482575>, <-1.954139, 1.763649, -0.571608>, <-2.088260, 1.805608, -0.592172>, <-2.190223, 1.800065, -0.527852>, 
      <-1.932259, 1.570300, -0.544415>, <-1.991466, 1.626264, -0.633447>, <-2.119733, 1.666143, -0.652598>, <-2.221696, 1.660601, -0.588278>, 
      <-1.999024, 1.381400, -0.603998>, <-2.048266, 1.427946, -0.678048>, <-2.182096, 1.475892, -0.716188>, <-2.267877, 1.472466, -0.664182>, 
      <-2.036426, 1.249383, -0.676556>, <-2.085668, 1.295929, -0.750606>, <-2.196241, 1.329643, -0.766222>, <-2.282022, 1.326217, -0.714216>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.353821, 2.011065, -0.325852>, <2.292490, 1.967564, -0.343437>, <2.234977, 1.987969, -0.416230>, <2.216604, 2.042120, -0.468126>, 
      <2.419593, 1.933874, -0.405165>, <2.358261, 1.890373, -0.422750>, <2.305590, 1.903501, -0.477007>, <2.287216, 1.957652, -0.528903>, 
      <2.517502, 1.828865, -0.501569>, <2.486811, 1.806931, -0.497761>, <2.430748, 1.807811, -0.526945>, <2.417895, 1.839110, -0.544054>, 
      <2.576844, 1.736580, -0.568927>, <2.546153, 1.714647, -0.565118>, <2.493985, 1.709603, -0.573538>, <2.481133, 1.740902, -0.590647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.437931, 2.199102, -0.404666>, <2.458184, 2.139412, -0.347462>, <2.421426, 2.059016, -0.306468>, <2.353821, 2.011065, -0.325852>, 
      <2.494434, 2.098314, -0.474629>, <2.514687, 2.038624, -0.417424>, <2.487198, 1.981824, -0.385781>, <2.419593, 1.933874, -0.405165>, 
      <2.568841, 1.949611, -0.545986>, <2.585248, 1.909658, -0.524147>, <2.556678, 1.856862, -0.506431>, <2.517502, 1.828865, -0.501569>, 
      <2.626384, 1.844707, -0.608673>, <2.642790, 1.804755, -0.586834>, <2.616020, 1.764578, -0.573789>, <2.576844, 1.736580, -0.568927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.275493, 2.241921, -0.547094>, <2.343001, 2.289803, -0.527738>, <2.417707, 2.258707, -0.461789>, <2.437931, 2.199102, -0.404666>, 
      <2.353002, 2.135322, -0.601926>, <2.420511, 2.183204, -0.582570>, <2.474211, 2.157919, -0.531752>, <2.494434, 2.098314, -0.474629>, 
      <2.462107, 1.966259, -0.586417>, <2.492799, 1.988194, -0.590226>, <2.555988, 1.980911, -0.563095>, <2.568841, 1.949611, -0.545986>, 
      <2.530668, 1.849029, -0.630394>, <2.561360, 1.870964, -0.634203>, <2.613531, 1.876007, -0.625783>, <2.626384, 1.844707, -0.608673>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.275493, 2.241921, -0.547094>, <2.353002, 2.135322, -0.601926>, <2.462107, 1.966259, -0.586417>, <2.530668, 1.849029, -0.630394>, 
      <2.207210, 2.193490, -0.566672>, <2.284719, 2.086891, -0.621505>, <2.422931, 1.938262, -0.581555>, <2.491493, 1.821032, -0.625532>, 
      <2.196148, 2.102409, -0.525904>, <2.266761, 2.017941, -0.586681>, <2.401489, 1.879061, -0.565892>, <2.464727, 1.780854, -0.612485>, 
      <2.216604, 2.042120, -0.468126>, <2.287216, 1.957652, -0.528903>, <2.417895, 1.839110, -0.544054>, <2.481133, 1.740902, -0.590647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.705132, 1.658754, -0.770648>, <2.659896, 1.723100, -0.741370>, <2.623690, 1.806110, -0.670631>, <2.588786, 1.869263, -0.627766>, 
      <2.714032, 1.658598, -0.768215>, <2.668796, 1.722944, -0.738937>, <2.631159, 1.805773, -0.668936>, <2.596256, 1.868926, -0.626071>, 
      <2.725782, 1.656207, -0.763321>, <2.677960, 1.718023, -0.733283>, <2.642314, 1.803155, -0.664392>, <2.606116, 1.866131, -0.622748>, 
      <2.732684, 1.652351, -0.758561>, <2.684862, 1.714168, -0.728523>, <2.648221, 1.799296, -0.661392>, <2.612023, 1.862273, -0.619748>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.668760, 1.653473, -0.776035>, <2.625692, 1.718264, -0.746036>, <2.592778, 1.801272, -0.674863>, <2.560215, 1.864614, -0.631503>, 
      <2.679476, 1.656496, -0.775576>, <2.636408, 1.721287, -0.745577>, <2.601040, 1.804148, -0.674489>, <2.568477, 1.867490, -0.631129>, 
      <2.694384, 1.658943, -0.773586>, <2.649148, 1.723289, -0.744308>, <2.615159, 1.806496, -0.672566>, <2.580255, 1.869649, -0.629702>, 
      <2.705132, 1.658754, -0.770648>, <2.659896, 1.723100, -0.741370>, <2.623690, 1.806110, -0.670631>, <2.588786, 1.869263, -0.627766>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.629098, 1.637307, -0.773906>, <2.590748, 1.703646, -0.744102>, <2.570157, 1.781509, -0.655723>, <2.530668, 1.849029, -0.630394>, 
      <2.640357, 1.643300, -0.775591>, <2.602006, 1.709639, -0.745786>, <2.578273, 1.787310, -0.656731>, <2.538784, 1.854830, -0.631401>, 
      <2.656389, 1.649983, -0.776565>, <2.613321, 1.714774, -0.746566>, <2.583318, 1.797978, -0.675290>, <2.550754, 1.861320, -0.631931>, 
      <2.668760, 1.653473, -0.776035>, <2.625692, 1.718264, -0.746036>, <2.592778, 1.801272, -0.674863>, <2.560215, 1.864614, -0.631503>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.592200, 1.612723, -0.764580>, <2.561065, 1.680559, -0.734023>, <2.530905, 1.761239, -0.666597>, <2.504636, 1.824889, -0.624604>, 
      <2.602285, 1.621022, -0.768344>, <2.571150, 1.688858, -0.737788>, <2.537676, 1.769311, -0.668931>, <2.511407, 1.832961, -0.626938>, 
      <2.617203, 1.630976, -0.772126>, <2.578853, 1.697315, -0.742322>, <2.561422, 1.775265, -0.654639>, <2.521933, 1.842786, -0.629310>, 
      <2.629098, 1.637307, -0.773906>, <2.590748, 1.703646, -0.744102>, <2.570157, 1.781509, -0.655723>, <2.530668, 1.849029, -0.630394>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.563670, 1.583463, -0.749483>, <2.538677, 1.651642, -0.718557>, <2.509353, 1.732142, -0.655358>, <2.486074, 1.795862, -0.615018>, 
      <2.570830, 1.592949, -0.754920>, <2.545838, 1.661128, -0.723994>, <2.513591, 1.741393, -0.658758>, <2.490313, 1.805113, -0.618418>, 
      <2.582503, 1.604743, -0.760960>, <2.551368, 1.672578, -0.730403>, <2.524174, 1.753214, -0.664276>, <2.497905, 1.816863, -0.622283>, 
      <2.592200, 1.612723, -0.764580>, <2.561065, 1.680559, -0.734023>, <2.530905, 1.761239, -0.666597>, <2.504636, 1.824889, -0.624604>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.547859, 1.553976, -0.730909>, <2.529499, 1.621796, -0.698737>, <2.498834, 1.702651, -0.641439>, <2.477824, 1.766369, -0.603094>, 
      <2.550624, 1.563144, -0.737243>, <2.532264, 1.630964, -0.705070>, <2.499642, 1.711634, -0.645422>, <2.478631, 1.775352, -0.607077>, 
      <2.557380, 1.575130, -0.744707>, <2.532388, 1.643309, -0.713781>, <2.505458, 1.723641, -0.652233>, <2.482179, 1.787361, -0.611893>, 
      <2.563670, 1.583463, -0.749483>, <2.538677, 1.651642, -0.718557>, <2.509353, 1.732142, -0.655358>, <2.486074, 1.795862, -0.615018>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.547171, 1.528752, -0.711686>, <2.536917, 1.597022, -0.680130>, <2.519303, 1.681624, -0.618770>, <2.481133, 1.740902, -0.590647>, 
      <2.544873, 1.535774, -0.717684>, <2.534619, 1.604044, -0.686128>, <2.516401, 1.688692, -0.622633>, <2.478230, 1.747970, -0.594510>, 
      <2.545567, 1.546377, -0.725659>, <2.527207, 1.614197, -0.693487>, <2.498133, 1.694851, -0.637980>, <2.477123, 1.758569, -0.599635>, 
      <2.547859, 1.553976, -0.730909>, <2.529499, 1.621796, -0.698737>, <2.498834, 1.702651, -0.641439>, <2.477824, 1.766369, -0.603094>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.561713, 1.511641, -0.694744>, <2.544518, 1.577743, -0.663815>, <2.515362, 1.659828, -0.614125>, <2.495497, 1.723336, -0.579574>, 
      <2.555401, 1.515167, -0.699097>, <2.538206, 1.581269, -0.668168>, <2.509526, 1.663640, -0.617089>, <2.489661, 1.727148, -0.582538>, 
      <2.549209, 1.522525, -0.706367>, <2.538954, 1.590795, -0.674811>, <2.521871, 1.675371, -0.615353>, <2.483701, 1.734649, -0.587229>, 
      <2.547171, 1.528752, -0.711686>, <2.536917, 1.597022, -0.680130>, <2.519303, 1.681624, -0.618770>, <2.481133, 1.740902, -0.590647>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.589266, 1.505236, -0.682657>, <2.565806, 1.570009, -0.653956>, <2.539889, 1.653011, -0.604886>, <2.518728, 1.716343, -0.571555>, 
      <2.580365, 1.505393, -0.685090>, <2.556906, 1.570166, -0.656389>, <2.532421, 1.653348, -0.606581>, <2.511260, 1.716681, -0.573250>, 
      <2.568615, 1.507785, -0.689984>, <2.551420, 1.573887, -0.659055>, <2.521268, 1.655970, -0.611126>, <2.501403, 1.719478, -0.576575>, 
      <2.561713, 1.511641, -0.694744>, <2.544518, 1.577743, -0.663815>, <2.515362, 1.659828, -0.614125>, <2.495497, 1.723336, -0.579574>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.625640, 1.510516, -0.677267>, <2.596308, 1.573410, -0.648953>, <2.570797, 1.657851, -0.600653>, <2.547293, 1.720995, -0.567818>, 
      <2.614923, 1.507493, -0.677727>, <2.585591, 1.570387, -0.649413>, <2.562537, 1.654975, -0.601026>, <2.539033, 1.718119, -0.568192>, 
      <2.600014, 1.505047, -0.679719>, <2.576555, 1.569820, -0.651017>, <2.548418, 1.652625, -0.602950>, <2.527257, 1.715958, -0.569619>, 
      <2.589266, 1.505236, -0.682657>, <2.565806, 1.570009, -0.653956>, <2.539889, 1.653011, -0.604886>, <2.518728, 1.716343, -0.571555>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.665295, 1.526683, -0.679397>, <2.627171, 1.586840, -0.653030>, <2.611849, 1.682142, -0.608660>, <2.576844, 1.736580, -0.568927>, 
      <2.654038, 1.520691, -0.677713>, <2.615914, 1.580848, -0.651346>, <2.603732, 1.676341, -0.607653>, <2.568727, 1.730778, -0.567920>, 
      <2.638009, 1.514005, -0.676737>, <2.608677, 1.576899, -0.648423>, <2.580259, 1.661146, -0.600225>, <2.556755, 1.724290, -0.567390>, 
      <2.625640, 1.510516, -0.677267>, <2.596308, 1.573410, -0.648953>, <2.570797, 1.657851, -0.600653>, <2.547293, 1.720995, -0.567818>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.702198, 1.551269, -0.688720>, <2.659174, 1.609962, -0.662074>, <2.632675, 1.697887, -0.608915>, <2.602880, 1.760723, -0.574713>, 
      <2.692112, 1.542969, -0.684955>, <2.649088, 1.601662, -0.658309>, <2.625904, 1.689813, -0.606581>, <2.596108, 1.752650, -0.572379>, 
      <2.677191, 1.533016, -0.681177>, <2.639067, 1.593173, -0.654810>, <2.620585, 1.688386, -0.609744>, <2.585580, 1.742824, -0.570011>, 
      <2.665295, 1.526683, -0.679397>, <2.627171, 1.586840, -0.653030>, <2.611849, 1.682142, -0.608660>, <2.576844, 1.736580, -0.568927>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.730726, 1.580532, -0.703820>, <2.685858, 1.640252, -0.676980>, <2.654224, 1.726982, -0.620157>, <2.621438, 1.789747, -0.584301>, 
      <2.723566, 1.571045, -0.698382>, <2.678698, 1.630765, -0.671542>, <2.649986, 1.717733, -0.616756>, <2.617200, 1.780497, -0.580901>, 
      <2.711895, 1.559250, -0.692340>, <2.668872, 1.617943, -0.665693>, <2.639406, 1.705912, -0.611236>, <2.609611, 1.768748, -0.577033>, 
      <2.702198, 1.551269, -0.688720>, <2.659174, 1.609962, -0.662074>, <2.632675, 1.697887, -0.608915>, <2.602880, 1.760723, -0.574713>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.746537, 1.610016, -0.722394>, <2.696275, 1.667478, -0.694590>, <2.664745, 1.756473, -0.634075>, <2.629691, 1.819240, -0.596224>, 
      <2.743772, 1.600849, -0.716061>, <2.693510, 1.658311, -0.688257>, <2.663936, 1.747490, -0.630092>, <2.628883, 1.810257, -0.592241>, 
      <2.737015, 1.588864, -0.708596>, <2.692147, 1.648584, -0.681756>, <2.658119, 1.735484, -0.623282>, <2.625333, 1.798248, -0.587426>, 
      <2.730726, 1.580532, -0.703820>, <2.685858, 1.640252, -0.676980>, <2.654224, 1.726982, -0.620157>, <2.621438, 1.789747, -0.584301>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.747227, 1.635237, -0.741616>, <2.693456, 1.690746, -0.711928>, <2.661652, 1.780412, -0.647094>, <2.626384, 1.844707, -0.608673>, 
      <2.749524, 1.628216, -0.735618>, <2.695753, 1.683725, -0.705930>, <2.664554, 1.773344, -0.643231>, <2.629286, 1.837639, -0.604809>, 
      <2.748829, 1.617614, -0.727644>, <2.698567, 1.675076, -0.699840>, <2.665447, 1.764273, -0.637534>, <2.630393, 1.827040, -0.599683>, 
      <2.746537, 1.610016, -0.722394>, <2.696275, 1.667478, -0.694590>, <2.664745, 1.756473, -0.634075>, <2.629691, 1.819240, -0.596224>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.747227, 1.635237, -0.741616>, <2.745189, 1.641465, -0.746936>, <2.738996, 1.648824, -0.754208>, <2.732684, 1.652351, -0.758561>, 
      <2.693456, 1.690746, -0.711928>, <2.691418, 1.696973, -0.717248>, <2.691174, 1.710641, -0.724169>, <2.684862, 1.714168, -0.728523>, 
      <2.661652, 1.780412, -0.647094>, <2.659085, 1.786664, -0.650512>, <2.654057, 1.795485, -0.658428>, <2.648221, 1.799296, -0.661392>, 
      <2.626384, 1.844707, -0.608673>, <2.623817, 1.850960, -0.612091>, <2.617859, 1.858461, -0.616784>, <2.612023, 1.862273, -0.619748>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.837527, 1.515442, -0.788759>, <2.876374, 1.481587, -0.787322>, <2.973475, 1.436214, -0.809521>, <2.978153, 1.420818, -0.760548>, 
      <2.846074, 1.522891, -0.784409>, <2.884921, 1.489036, -0.782972>, <2.973265, 1.436905, -0.813093>, <2.977944, 1.421509, -0.764120>, 
      <2.847930, 1.539657, -0.777492>, <2.889028, 1.513221, -0.783187>, <2.949121, 1.488272, -0.794993>, <2.990063, 1.461117, -0.797579>, 
      <2.855118, 1.548041, -0.772442>, <2.896216, 1.521605, -0.778137>, <2.961106, 1.506240, -0.793301>, <3.002048, 1.479084, -0.795887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.837527, 1.515442, -0.788759>, <2.793228, 1.554048, -0.790398>, <2.736816, 1.613686, -0.791155>, <2.705132, 1.658754, -0.770648>, 
      <2.846074, 1.522891, -0.784409>, <2.801775, 1.561497, -0.786048>, <2.745716, 1.613530, -0.788722>, <2.714032, 1.658598, -0.768215>, 
      <2.847930, 1.539657, -0.777492>, <2.807471, 1.565683, -0.771885>, <2.753445, 1.620449, -0.780697>, <2.725782, 1.656207, -0.763321>, 
      <2.855118, 1.548041, -0.772442>, <2.814659, 1.574066, -0.766836>, <2.760346, 1.616594, -0.775937>, <2.732684, 1.652351, -0.758561>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.801633, 1.501429, -0.799663>, <2.833506, 1.462989, -0.804085>, <2.876088, 1.411288, -0.807328>, <2.904053, 1.369704, -0.808681>, 
      <2.811757, 1.507650, -0.797890>, <2.843630, 1.469210, -0.802313>, <2.898112, 1.432561, -0.806851>, <2.926076, 1.390978, -0.808204>, 
      <2.829071, 1.508073, -0.793063>, <2.867918, 1.474218, -0.791625>, <2.973179, 1.437191, -0.814571>, <2.977857, 1.421795, -0.765598>, 
      <2.837527, 1.515442, -0.788759>, <2.876374, 1.481587, -0.787322>, <2.973475, 1.436214, -0.809521>, <2.978153, 1.420818, -0.760548>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.801633, 1.501429, -0.799663>, <2.762855, 1.548196, -0.794283>, <2.700262, 1.606082, -0.797978>, <2.668760, 1.653473, -0.776035>, 
      <2.811757, 1.507650, -0.797890>, <2.772979, 1.554417, -0.792510>, <2.710978, 1.609105, -0.797519>, <2.679476, 1.656496, -0.775576>, 
      <2.829071, 1.508073, -0.793063>, <2.784772, 1.546679, -0.794701>, <2.726068, 1.613874, -0.794093>, <2.694384, 1.658943, -0.773586>, 
      <2.837527, 1.515442, -0.788759>, <2.793228, 1.554048, -0.790398>, <2.736816, 1.613686, -0.791155>, <2.705132, 1.658754, -0.770648>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.753397, 1.463746, -0.803490>, <2.786513, 1.415741, -0.801935>, <2.848966, 1.322919, -0.817890>, <2.858305, 1.305049, -0.763144>, 
      <2.769523, 1.472605, -0.803490>, <2.802639, 1.424599, -0.801935>, <2.848702, 1.323793, -0.822409>, <2.858041, 1.305923, -0.767664>, 
      <2.786129, 1.491902, -0.802378>, <2.818002, 1.453462, -0.806800>, <2.856378, 1.392248, -0.807755>, <2.884342, 1.350664, -0.809108>, 
      <2.801633, 1.501429, -0.799663>, <2.833506, 1.462989, -0.804085>, <2.876088, 1.411288, -0.807328>, <2.904053, 1.369704, -0.808681>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.753397, 1.463746, -0.803490>, <2.716696, 1.516948, -0.805213>, <2.659256, 1.585138, -0.797344>, <2.629098, 1.637307, -0.773906>, 
      <2.769523, 1.472605, -0.803490>, <2.732822, 1.525807, -0.805213>, <2.670515, 1.591131, -0.799028>, <2.640357, 1.643300, -0.775591>, 
      <2.786129, 1.491902, -0.802378>, <2.747351, 1.538669, -0.796998>, <2.687891, 1.602592, -0.798508>, <2.656389, 1.649983, -0.776565>, 
      <2.801633, 1.501429, -0.799663>, <2.762855, 1.548196, -0.794283>, <2.700262, 1.606082, -0.797978>, <2.668760, 1.653473, -0.776035>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.683006, 1.436262, -0.799663>, <2.656834, 1.490252, -0.792219>, <2.615540, 1.561871, -0.787486>, <2.592200, 1.612723, -0.764580>, 
      <2.703952, 1.444664, -0.802094>, <2.677780, 1.498654, -0.794650>, <2.625625, 1.570170, -0.791251>, <2.602285, 1.621022, -0.768344>, 
      <2.733502, 1.452817, -0.803490>, <2.696801, 1.506019, -0.805213>, <2.647361, 1.578807, -0.795564>, <2.617203, 1.630976, -0.772126>, 
      <2.753397, 1.463746, -0.803490>, <2.716696, 1.516948, -0.805213>, <2.659256, 1.585138, -0.797344>, <2.629098, 1.637307, -0.773906>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.683006, 1.436262, -0.799663>, <2.702706, 1.395623, -0.805267>, <2.728439, 1.340418, -0.806654>, <2.744781, 1.297965, -0.807981>, 
      <2.703952, 1.444664, -0.802094>, <2.723652, 1.404025, -0.807698>, <2.763212, 1.352086, -0.806504>, <2.779554, 1.309634, -0.807830>, 
      <2.733502, 1.452817, -0.803490>, <2.766619, 1.404812, -0.801935>, <2.848612, 1.324089, -0.823938>, <2.857951, 1.306219, -0.769192>, 
      <2.753397, 1.463746, -0.803490>, <2.786513, 1.415741, -0.801935>, <2.848966, 1.322919, -0.817890>, <2.858305, 1.305049, -0.763144>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.626481, 1.412836, -0.788759>, <2.643613, 1.362391, -0.790910>, <2.670592, 1.262964, -0.813383>, <2.678691, 1.244775, -0.763922>, 
      <2.644066, 1.417191, -0.793169>, <2.661198, 1.366746, -0.795320>, <2.670315, 1.263879, -0.818112>, <2.678414, 1.245690, -0.768651>, 
      <2.665801, 1.429360, -0.797666>, <2.685501, 1.388721, -0.803270>, <2.701251, 1.331294, -0.806772>, <2.717593, 1.288842, -0.808099>, 
      <2.683006, 1.436262, -0.799663>, <2.702706, 1.395623, -0.805267>, <2.728439, 1.340418, -0.806654>, <2.744781, 1.297965, -0.807981>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.626481, 1.412836, -0.788759>, <2.608551, 1.465633, -0.786508>, <2.581341, 1.535258, -0.771349>, <2.563670, 1.583463, -0.749483>, 
      <2.644066, 1.417191, -0.793169>, <2.626136, 1.469988, -0.790918>, <2.588501, 1.544744, -0.776786>, <2.570830, 1.592949, -0.754920>, 
      <2.665801, 1.429360, -0.797666>, <2.639628, 1.483351, -0.790222>, <2.605843, 1.553891, -0.783867>, <2.582503, 1.604743, -0.760960>, 
      <2.683006, 1.436262, -0.799663>, <2.656834, 1.490252, -0.792219>, <2.615540, 1.561871, -0.787486>, <2.592200, 1.612723, -0.764580>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.574467, 1.409381, -0.772442>, <2.580316, 1.367915, -0.783025>, <2.584061, 1.312330, -0.800106>, <2.587991, 1.269453, -0.803526>, 
      <2.589347, 1.413177, -0.778161>, <2.595196, 1.371711, -0.788744>, <2.614582, 1.310264, -0.800875>, <2.618511, 1.267387, -0.804295>, 
      <2.611026, 1.409008, -0.784883>, <2.628158, 1.358563, -0.787034>, <2.670296, 1.263940, -0.818429>, <2.678396, 1.245751, -0.768968>, 
      <2.626481, 1.412836, -0.788759>, <2.643613, 1.362391, -0.790910>, <2.670592, 1.262964, -0.813383>, <2.678691, 1.244775, -0.763922>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.574467, 1.409381, -0.772442>, <2.568261, 1.453381, -0.761212>, <2.558748, 1.513752, -0.749991>, <2.547859, 1.553976, -0.730909>, 
      <2.589347, 1.413177, -0.778161>, <2.583141, 1.457177, -0.766931>, <2.561513, 1.522920, -0.756324>, <2.550624, 1.563144, -0.737243>, 
      <2.611026, 1.409008, -0.784883>, <2.593096, 1.461806, -0.782632>, <2.575051, 1.526925, -0.766573>, <2.557380, 1.575130, -0.744707>, 
      <2.626481, 1.412836, -0.788759>, <2.608551, 1.465633, -0.786508>, <2.581341, 1.535258, -0.771349>, <2.563670, 1.583463, -0.749483>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.533953, 1.389234, -0.753196>, <2.530585, 1.349630, -0.760195>, <2.521412, 1.295500, -0.758350>, <2.523912, 1.255254, -0.760022>, 
      <2.531559, 1.394814, -0.766639>, <2.528191, 1.355210, -0.773639>, <2.520057, 1.299979, -0.781505>, <2.522557, 1.259732, -0.783177>, 
      <2.561072, 1.405964, -0.767294>, <2.566921, 1.364499, -0.777877>, <2.560500, 1.313926, -0.799512>, <2.564430, 1.271048, -0.802932>, 
      <2.574467, 1.409381, -0.772442>, <2.580316, 1.367915, -0.783025>, <2.584061, 1.312330, -0.800106>, <2.587991, 1.269453, -0.803526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.533953, 1.389234, -0.753196>, <2.537612, 1.432263, -0.745591>, <2.553095, 1.489315, -0.729915>, <2.547171, 1.528752, -0.711686>, 
      <2.531559, 1.394814, -0.766639>, <2.535218, 1.437843, -0.759035>, <2.550797, 1.496336, -0.735913>, <2.544873, 1.535774, -0.717684>, 
      <2.561072, 1.405964, -0.767294>, <2.554866, 1.449965, -0.756064>, <2.556457, 1.506153, -0.744741>, <2.545567, 1.546377, -0.725659>, 
      <2.574467, 1.409381, -0.772442>, <2.568261, 1.453381, -0.761212>, <2.558748, 1.513752, -0.749991>, <2.547859, 1.553976, -0.730909>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.581322, 1.393403, -0.733948>, <2.586397, 1.351394, -0.737848>, <2.589302, 1.295393, -0.718492>, <2.592953, 1.253057, -0.718748>, 
      <2.566761, 1.393760, -0.738919>, <2.571836, 1.351751, -0.742819>, <2.565224, 1.297023, -0.717885>, <2.568875, 1.254687, -0.718141>, 
      <2.536451, 1.383412, -0.739170>, <2.533082, 1.343808, -0.746170>, <2.522797, 1.290924, -0.734688>, <2.525297, 1.250678, -0.736360>, 
      <2.533953, 1.389234, -0.753196>, <2.530585, 1.349630, -0.760195>, <2.521412, 1.295500, -0.758350>, <2.523912, 1.255254, -0.760022>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.581322, 1.393403, -0.733948>, <2.576804, 1.430802, -0.730476>, <2.570389, 1.478289, -0.710349>, <2.561713, 1.511641, -0.694744>, 
      <2.566761, 1.393760, -0.738919>, <2.562243, 1.431159, -0.735447>, <2.564077, 1.481815, -0.714702>, <2.555401, 1.515167, -0.699097>, 
      <2.536451, 1.383412, -0.739170>, <2.540110, 1.426441, -0.731566>, <2.555132, 1.483088, -0.724596>, <2.549209, 1.522525, -0.706367>, 
      <2.533953, 1.389234, -0.753196>, <2.537612, 1.432263, -0.745591>, <2.553095, 1.489315, -0.729915>, <2.547171, 1.528752, -0.711686>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.638128, 1.386679, -0.717631>, <2.625709, 1.422851, -0.706345>, <2.601801, 1.470628, -0.697992>, <2.589266, 1.505236, -0.682657>, 
      <2.621046, 1.383722, -0.721862>, <2.608627, 1.419893, -0.710577>, <2.592900, 1.470785, -0.700425>, <2.580365, 1.505393, -0.685090>, 
      <2.598206, 1.392989, -0.728184>, <2.593687, 1.430388, -0.724712>, <2.577291, 1.474433, -0.705589>, <2.568615, 1.507785, -0.689984>, 
      <2.581322, 1.393403, -0.733948>, <2.576804, 1.430802, -0.730476>, <2.570389, 1.478289, -0.710349>, <2.561713, 1.511641, -0.694744>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.638128, 1.386679, -0.717631>, <2.652580, 1.344585, -0.730765>, <2.685740, 1.228945, -0.720876>, <2.678691, 1.244775, -0.763922>, 
      <2.621046, 1.383722, -0.721862>, <2.635498, 1.341628, -0.734996>, <2.686021, 1.228015, -0.716064>, <2.678972, 1.243845, -0.759110>, 
      <2.598206, 1.392989, -0.728184>, <2.603281, 1.350980, -0.732084>, <2.618405, 1.293422, -0.719225>, <2.622056, 1.251087, -0.719481>, 
      <2.581322, 1.393403, -0.733948>, <2.586397, 1.351394, -0.737848>, <2.589302, 1.295393, -0.718492>, <2.592953, 1.253057, -0.718748>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.691203, 1.412426, -0.706730>, <2.674028, 1.444231, -0.701791>, <2.639917, 1.479903, -0.691048>, <2.625640, 1.510516, -0.677267>, 
      <2.674228, 1.406756, -0.708618>, <2.657052, 1.438561, -0.703679>, <2.629201, 1.476880, -0.691508>, <2.614923, 1.507493, -0.677727>, 
      <2.655355, 1.389661, -0.713364>, <2.642936, 1.425833, -0.702078>, <2.612549, 1.470439, -0.695053>, <2.600014, 1.505047, -0.679719>, 
      <2.638128, 1.386679, -0.717631>, <2.625709, 1.422851, -0.706345>, <2.601801, 1.470628, -0.697992>, <2.589266, 1.505236, -0.682657>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.691203, 1.412426, -0.706730>, <2.711755, 1.374368, -0.712641>, <2.734694, 1.320307, -0.710751>, <2.750330, 1.279618, -0.713126>, 
      <2.674228, 1.406756, -0.708618>, <2.694780, 1.368698, -0.714529>, <2.707823, 1.311290, -0.710868>, <2.723459, 1.270601, -0.713242>, 
      <2.655355, 1.389661, -0.713364>, <2.669807, 1.347568, -0.726497>, <2.686013, 1.228041, -0.716202>, <2.678964, 1.243871, -0.759248>, 
      <2.638128, 1.386679, -0.717631>, <2.652580, 1.344585, -0.730765>, <2.685740, 1.228945, -0.720876>, <2.678691, 1.244775, -0.763922>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.770556, 1.430912, -0.702901>, <2.743226, 1.462295, -0.691043>, <2.687017, 1.492407, -0.694420>, <2.665295, 1.526683, -0.679397>, 
      <2.748331, 1.420674, -0.702901>, <2.721001, 1.452056, -0.691043>, <2.675760, 1.486415, -0.692736>, <2.654038, 1.520691, -0.677713>, 
      <2.714285, 1.420136, -0.704163>, <2.697109, 1.451941, -0.699223>, <2.652287, 1.483392, -0.690518>, <2.638009, 1.514005, -0.676737>, 
      <2.691203, 1.412426, -0.706730>, <2.674028, 1.444231, -0.701791>, <2.639917, 1.479903, -0.691048>, <2.625640, 1.510516, -0.677267>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.770556, 1.430912, -0.702901>, <2.801788, 1.395048, -0.716453>, <2.866221, 1.289902, -0.716741>, <2.858305, 1.305049, -0.763144>, 
      <2.748331, 1.420674, -0.702901>, <2.779563, 1.384809, -0.716453>, <2.866573, 1.288738, -0.710721>, <2.858657, 1.303885, -0.757124>, 
      <2.714285, 1.420136, -0.704163>, <2.734837, 1.382078, -0.710073>, <2.769302, 1.331921, -0.710601>, <2.784938, 1.291232, -0.712976>, 
      <2.691203, 1.412426, -0.706730>, <2.711755, 1.374368, -0.712641>, <2.734694, 1.320307, -0.710751>, <2.750330, 1.279618, -0.713126>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.816038, 1.469933, -0.706730>, <2.848873, 1.438096, -0.709316>, <2.884541, 1.387638, -0.703404>, <2.910115, 1.349670, -0.705097>, 
      <2.802421, 1.458457, -0.704011>, <2.835256, 1.426619, -0.706597>, <2.865190, 1.368946, -0.703824>, <2.890764, 1.330978, -0.705516>, 
      <2.786918, 1.438449, -0.702901>, <2.818151, 1.402585, -0.716453>, <2.866480, 1.289044, -0.712304>, <2.858565, 1.304191, -0.758707>, 
      <2.770556, 1.430912, -0.702901>, <2.801788, 1.395048, -0.716453>, <2.866221, 1.289902, -0.716741>, <2.858305, 1.305049, -0.763144>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.816038, 1.469933, -0.706730>, <2.785704, 1.499345, -0.704341>, <2.725692, 1.519218, -0.703271>, <2.702198, 1.551269, -0.688720>, 
      <2.802421, 1.458457, -0.704011>, <2.772087, 1.487869, -0.701622>, <2.715606, 1.510918, -0.699506>, <2.692112, 1.542969, -0.684955>, 
      <2.786918, 1.438449, -0.702901>, <2.759588, 1.469832, -0.691043>, <2.698913, 1.498739, -0.696200>, <2.677191, 1.533016, -0.681177>, 
      <2.770556, 1.430912, -0.702901>, <2.743226, 1.462295, -0.691043>, <2.687017, 1.492407, -0.694420>, <2.665295, 1.526683, -0.679397>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.844322, 1.493081, -0.717631>, <2.808676, 1.516090, -0.709458>, <2.755150, 1.548023, -0.718430>, <2.730726, 1.580532, -0.703820>, 
      <2.836703, 1.485213, -0.714320>, <2.801058, 1.508222, -0.706147>, <2.747990, 1.538536, -0.712993>, <2.723566, 1.571045, -0.698382>, 
      <2.824687, 1.477222, -0.708457>, <2.794353, 1.506635, -0.706068>, <2.735390, 1.527199, -0.706890>, <2.711895, 1.559250, -0.692340>, 
      <2.816038, 1.469933, -0.706730>, <2.785704, 1.499345, -0.704341>, <2.725692, 1.519218, -0.703271>, <2.702198, 1.551269, -0.688720>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.844322, 1.493081, -0.717631>, <2.883435, 1.467833, -0.726599>, <2.982456, 1.406658, -0.715507>, <2.978153, 1.420818, -0.760548>, 
      <2.836703, 1.485213, -0.714320>, <2.875817, 1.459965, -0.723287>, <2.982783, 1.405577, -0.709918>, <2.978480, 1.419737, -0.754959>, 
      <2.824687, 1.477222, -0.708457>, <2.857522, 1.445385, -0.711043>, <2.908917, 1.411185, -0.702877>, <2.934491, 1.373217, -0.704569>, 
      <2.816038, 1.469933, -0.706730>, <2.848873, 1.438096, -0.709316>, <2.884541, 1.387638, -0.703404>, <2.910115, 1.349670, -0.705097>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.878661, 1.534606, -0.733948>, <2.838801, 1.557070, -0.735169>, <2.774852, 1.577645, -0.738057>, <2.746537, 1.610016, -0.722394>, 
      <2.871188, 1.520726, -0.727884>, <2.831328, 1.543190, -0.729105>, <2.772087, 1.568479, -0.731724>, <2.743772, 1.600849, -0.716061>, 
      <2.855568, 1.504696, -0.722519>, <2.819923, 1.527705, -0.714347>, <2.761439, 1.556355, -0.723207>, <2.737015, 1.588864, -0.708596>, 
      <2.844322, 1.493081, -0.717631>, <2.808676, 1.516090, -0.709458>, <2.755150, 1.548023, -0.718430>, <2.730726, 1.580532, -0.703820>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.878661, 1.534606, -0.733948>, <2.917310, 1.512824, -0.732764>, <2.970432, 1.488736, -0.715047>, <3.006814, 1.463328, -0.714419>, 
      <2.871188, 1.520726, -0.727884>, <2.909837, 1.498944, -0.726700>, <2.958985, 1.471577, -0.716663>, <2.995368, 1.446169, -0.716035>, 
      <2.855568, 1.504696, -0.722519>, <2.894682, 1.479448, -0.731487>, <2.982655, 1.405998, -0.712095>, <2.978353, 1.420158, -0.757136>, 
      <2.844322, 1.493081, -0.717631>, <2.883435, 1.467833, -0.726599>, <2.982456, 1.406658, -0.715507>, <2.978153, 1.420818, -0.760548>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.888149, 1.574484, -0.753196>, <2.845749, 1.592690, -0.751665>, <2.777214, 1.604281, -0.758172>, <2.747227, 1.635237, -0.741616>, 
      <2.894943, 1.570607, -0.742088>, <2.852543, 1.588813, -0.740557>, <2.779511, 1.597261, -0.752174>, <2.749524, 1.628216, -0.735618>, 
      <2.884672, 1.545770, -0.738826>, <2.844812, 1.568235, -0.740047>, <2.777144, 1.585244, -0.743307>, <2.748829, 1.617614, -0.727644>, 
      <2.878661, 1.534606, -0.733948>, <2.838801, 1.557070, -0.735169>, <2.774852, 1.577645, -0.738057>, <2.746537, 1.610016, -0.722394>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.888149, 1.574484, -0.753196>, <2.933030, 1.555212, -0.754816>, <2.996647, 1.536578, -0.751426>, <3.037920, 1.510416, -0.752110>, 
      <2.894943, 1.570607, -0.742088>, <2.939824, 1.551336, -0.743708>, <2.998149, 1.531613, -0.725753>, <3.039422, 1.505451, -0.726438>, 
      <2.884672, 1.545770, -0.738826>, <2.923321, 1.523988, -0.737641>, <2.981695, 1.505622, -0.713457>, <3.018077, 1.480213, -0.712829>, 
      <2.878661, 1.534606, -0.733948>, <2.917310, 1.512824, -0.732764>, <2.970432, 1.488736, -0.715047>, <3.006814, 1.463328, -0.714419>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.888149, 1.574484, -0.753196>, <2.933030, 1.555212, -0.754816>, <2.996647, 1.536578, -0.751426>, <3.037920, 1.510416, -0.752110>, 
      <2.881176, 1.578463, -0.764598>, <2.926057, 1.559192, -0.766218>, <2.995215, 1.541311, -0.775898>, <3.036488, 1.515149, -0.776582>, 
      <2.863373, 1.557669, -0.766643>, <2.904471, 1.531233, -0.772338>, <2.971843, 1.522335, -0.791785>, <3.012785, 1.495180, -0.794371>, 
      <2.855118, 1.548041, -0.772442>, <2.896216, 1.521605, -0.778137>, <2.961106, 1.506240, -0.793301>, <3.002048, 1.479084, -0.795887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <2.888149, 1.574484, -0.753196>, <2.881176, 1.578463, -0.764598>, <2.863373, 1.557669, -0.766643>, <2.855118, 1.548041, -0.772442>, 
      <2.845749, 1.592690, -0.751665>, <2.838776, 1.596670, -0.763067>, <2.822913, 1.583694, -0.761036>, <2.814659, 1.574066, -0.766836>, 
      <2.777214, 1.604281, -0.758172>, <2.775176, 1.610509, -0.763492>, <2.766659, 1.613067, -0.771583>, <2.760346, 1.616594, -0.775937>, 
      <2.747227, 1.635237, -0.741616>, <2.745189, 1.641465, -0.746936>, <2.738996, 1.648824, -0.754208>, <2.732684, 1.652351, -0.758561>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.525668, 1.079258, -0.863860>, <3.513395, 1.063578, -0.864807>, <3.501921, 1.043901, -0.858418>, <3.506604, 1.037535, -0.840117>, 
      <3.525668, 1.079258, -0.863860>, <3.522247, 1.057839, -0.861856>, <3.517680, 1.047225, -0.860701>, <3.522363, 1.040860, -0.842400>, 
      <3.525668, 1.079258, -0.863860>, <3.522247, 1.057839, -0.861856>, <3.539984, 1.056856, -0.853771>, <3.542558, 1.053358, -0.843714>, 
      <3.525668, 1.079258, -0.863860>, <3.534520, 1.073520, -0.860910>, <3.549999, 1.069651, -0.852998>, <3.552572, 1.066153, -0.842942>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.466380, 1.047969, -0.830454>, <3.476331, 1.040473, -0.833386>, <3.494204, 1.034919, -0.838321>, <3.506604, 1.037535, -0.840117>, 
      <3.459970, 1.056688, -0.855515>, <3.469921, 1.049192, -0.858447>, <3.489522, 1.041285, -0.856622>, <3.501921, 1.043901, -0.858418>, 
      <3.475690, 1.083627, -0.864261>, <3.485558, 1.076339, -0.867215>, <3.503199, 1.070188, -0.868205>, <3.513395, 1.063578, -0.864807>, 
      <3.492496, 1.105099, -0.862965>, <3.502363, 1.097811, -0.865919>, <3.515472, 1.085868, -0.867258>, <3.525668, 1.079258, -0.863860>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.557908, 1.103085, -0.836160>, <3.560312, 1.092296, -0.838859>, <3.559577, 1.075103, -0.842402>, <3.552572, 1.066153, -0.842942>, 
      <3.557908, 1.103085, -0.836160>, <3.555894, 1.098302, -0.856124>, <3.557004, 1.078601, -0.852458>, <3.549999, 1.069651, -0.852998>, 
      <3.557908, 1.103085, -0.836160>, <3.555894, 1.098302, -0.856124>, <3.546097, 1.088313, -0.860017>, <3.534520, 1.073520, -0.860910>, 
      <3.557908, 1.103085, -0.836160>, <3.553490, 1.109091, -0.853425>, <3.537246, 1.094051, -0.862967>, <3.525668, 1.079258, -0.863860>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.557908, 1.103085, -0.836160>, <3.555237, 1.115074, -0.833161>, <3.546588, 1.130489, -0.827923>, <3.536627, 1.137723, -0.825037>, 
      <3.553490, 1.109091, -0.853425>, <3.550819, 1.121080, -0.850426>, <3.540542, 1.138713, -0.851559>, <3.530581, 1.145946, -0.848674>, 
      <3.537246, 1.094051, -0.862967>, <3.527050, 1.100661, -0.866365>, <3.518214, 1.118063, -0.864696>, <3.508346, 1.125351, -0.861743>, 
      <3.525668, 1.079258, -0.863860>, <3.515472, 1.085868, -0.867258>, <3.502363, 1.097811, -0.865919>, <3.492496, 1.105099, -0.862965>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.557908, 1.103085, -0.836160>, <3.553490, 1.109091, -0.853425>, <3.537246, 1.094051, -0.862967>, <3.525668, 1.079258, -0.863860>, 
      <3.560312, 1.092296, -0.838859>, <3.555894, 1.098302, -0.856124>, <3.524973, 1.078370, -0.863914>, <3.513395, 1.063578, -0.864807>, 
      <3.559577, 1.075103, -0.842402>, <3.549562, 1.062308, -0.843174>, <3.517680, 1.047225, -0.860701>, <3.501921, 1.043901, -0.858418>, 
      <3.552572, 1.066153, -0.842942>, <3.542558, 1.053358, -0.843714>, <3.522363, 1.040860, -0.842400>, <3.506604, 1.037535, -0.840117>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.538830, 1.061365, -0.812420>, <3.531400, 1.063916, -0.803513>, <3.519817, 1.073702, -0.795177>, <3.510514, 1.080593, -0.792526>, 
      <3.551103, 1.077046, -0.811473>, <3.543672, 1.079597, -0.802566>, <3.536622, 1.095174, -0.793881>, <3.527319, 1.102065, -0.791230>, 
      <3.562591, 1.096719, -0.817858>, <3.559920, 1.108708, -0.814859>, <3.552998, 1.121771, -0.802862>, <3.543038, 1.129004, -0.799976>, 
      <3.557908, 1.103085, -0.836160>, <3.555237, 1.115074, -0.833161>, <3.546588, 1.130489, -0.827923>, <3.536627, 1.137723, -0.825037>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.538830, 1.061365, -0.812420>, <3.545176, 1.059186, -0.820028>, <3.554955, 1.062914, -0.833629>, <3.552572, 1.066153, -0.842942>, 
      <3.538830, 1.061365, -0.812420>, <3.557449, 1.074867, -0.819081>, <3.561960, 1.071864, -0.833089>, <3.559577, 1.075103, -0.842402>, 
      <3.538830, 1.061365, -0.812420>, <3.557449, 1.074867, -0.819081>, <3.564994, 1.085930, -0.820557>, <3.560312, 1.092296, -0.838859>, 
      <3.538830, 1.061365, -0.812420>, <3.551103, 1.077046, -0.811473>, <3.562591, 1.096719, -0.817858>, <3.557908, 1.103085, -0.836160>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.538830, 1.061365, -0.812420>, <3.545176, 1.059186, -0.820028>, <3.554955, 1.062914, -0.833629>, <3.552572, 1.066153, -0.842942>, 
      <3.551103, 1.077046, -0.811473>, <3.557449, 1.074867, -0.819081>, <3.552382, 1.066412, -0.843685>, <3.549999, 1.069651, -0.852998>, 
      <3.562591, 1.096719, -0.817858>, <3.558174, 1.102724, -0.835124>, <3.546097, 1.088313, -0.860017>, <3.534520, 1.073520, -0.860910>, 
      <3.557908, 1.103085, -0.836160>, <3.553490, 1.109091, -0.853425>, <3.537246, 1.094051, -0.862967>, <3.525668, 1.079258, -0.863860>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.538830, 1.061365, -0.812420>, <3.551103, 1.077046, -0.811473>, <3.562591, 1.096719, -0.817858>, <3.557908, 1.103085, -0.836160>, 
      <3.527254, 1.046575, -0.813313>, <3.539527, 1.062256, -0.812366>, <3.564994, 1.085930, -0.820557>, <3.560312, 1.092296, -0.838859>, 
      <3.511021, 1.031530, -0.822855>, <3.526780, 1.034855, -0.825138>, <3.549562, 1.062308, -0.843174>, <3.559577, 1.075103, -0.842402>, 
      <3.506604, 1.037535, -0.840117>, <3.522363, 1.040860, -0.842400>, <3.542558, 1.053358, -0.843714>, <3.552572, 1.066153, -0.842942>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.538830, 1.061365, -0.812420>, <3.545176, 1.059186, -0.820028>, <3.554955, 1.062914, -0.833629>, <3.552572, 1.066153, -0.842942>, 
      <3.538830, 1.061365, -0.812420>, <3.533601, 1.044396, -0.820921>, <3.544940, 1.050118, -0.834402>, <3.542558, 1.053358, -0.843714>, 
      <3.538830, 1.061365, -0.812420>, <3.533601, 1.044396, -0.820921>, <3.526780, 1.034855, -0.825138>, <3.522363, 1.040860, -0.842400>, 
      <3.538830, 1.061365, -0.812420>, <3.527254, 1.046575, -0.813313>, <3.511021, 1.031530, -0.822855>, <3.506604, 1.037535, -0.840117>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.538830, 1.061365, -0.812420>, <3.531400, 1.063916, -0.803513>, <3.519817, 1.073702, -0.795177>, <3.510514, 1.080593, -0.792526>, 
      <3.527254, 1.046575, -0.813313>, <3.519824, 1.049126, -0.804406>, <3.503966, 1.053449, -0.796399>, <3.494663, 1.060340, -0.793748>, 
      <3.511021, 1.031530, -0.822855>, <3.498621, 1.028915, -0.821059>, <3.482378, 1.032249, -0.809748>, <3.472426, 1.039746, -0.806817>, 
      <3.506604, 1.037535, -0.840117>, <3.494204, 1.034919, -0.838321>, <3.476331, 1.040473, -0.833386>, <3.466380, 1.047969, -0.830454>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.538830, 1.061365, -0.812420>, <3.527254, 1.046575, -0.813313>, <3.511021, 1.031530, -0.822855>, <3.506604, 1.037535, -0.840117>, 
      <3.545176, 1.059186, -0.820028>, <3.533601, 1.044396, -0.820921>, <3.506338, 1.037896, -0.841156>, <3.501921, 1.043901, -0.858418>, 
      <3.554955, 1.062914, -0.833629>, <3.552382, 1.066412, -0.843685>, <3.522247, 1.057839, -0.861856>, <3.513395, 1.063578, -0.864807>, 
      <3.552572, 1.066153, -0.842942>, <3.549999, 1.069651, -0.852998>, <3.534520, 1.073520, -0.860910>, <3.525668, 1.079258, -0.863860>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.493094, 1.150154, -0.817384>, <3.488750, 1.156059, -0.834359>, <3.472777, 1.141276, -0.843742>, <3.461393, 1.126732, -0.844620>, 
      <3.503981, 1.142174, -0.820129>, <3.499637, 1.148079, -0.837104>, <3.482690, 1.133903, -0.846355>, <3.471306, 1.119358, -0.847233>, 
      <3.525776, 1.145604, -0.821894>, <3.519729, 1.153827, -0.845530>, <3.498471, 1.132645, -0.858787>, <3.482620, 1.112393, -0.860009>, 
      <3.536627, 1.137723, -0.825037>, <3.530581, 1.145946, -0.848674>, <3.508346, 1.125351, -0.861743>, <3.492496, 1.105099, -0.862965>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.474335, 1.109138, -0.794042>, <3.486402, 1.124555, -0.793111>, <3.497698, 1.143895, -0.799390>, <3.493094, 1.150154, -0.817384>, 
      <3.485212, 1.101018, -0.796709>, <3.497278, 1.116435, -0.795778>, <3.508585, 1.135915, -0.802136>, <3.503981, 1.142174, -0.820129>, 
      <3.499679, 1.088619, -0.789439>, <3.516484, 1.110091, -0.788143>, <3.532186, 1.136885, -0.796833>, <3.525776, 1.145604, -0.821894>, 
      <3.510514, 1.080593, -0.792526>, <3.527319, 1.102065, -0.791230>, <3.543038, 1.129004, -0.799976>, <3.536627, 1.137723, -0.825037>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.442652, 1.085708, -0.821275>, <3.446995, 1.079804, -0.804303>, <3.462954, 1.094597, -0.794920>, <3.474335, 1.109138, -0.794042>, 
      <3.453316, 1.077630, -0.824007>, <3.457658, 1.071726, -0.807035>, <3.473830, 1.086477, -0.797587>, <3.485212, 1.101018, -0.796709>, 
      <3.455764, 1.055966, -0.827326>, <3.461810, 1.047742, -0.803689>, <3.483828, 1.068366, -0.790661>, <3.499679, 1.088619, -0.789439>, 
      <3.466380, 1.047969, -0.830454>, <3.472426, 1.039746, -0.806817>, <3.494663, 1.060340, -0.793748>, <3.510514, 1.080593, -0.792526>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.442652, 1.085708, -0.821275>, <3.453316, 1.077630, -0.824007>, <3.455764, 1.055966, -0.827326>, <3.466380, 1.047969, -0.830454>, 
      <3.438048, 1.091968, -0.839269>, <3.448711, 1.083889, -0.842001>, <3.449354, 1.064685, -0.852387>, <3.459970, 1.056688, -0.855515>, 
      <3.449326, 1.111315, -0.845551>, <3.459240, 1.103941, -0.848164>, <3.465815, 1.090921, -0.861305>, <3.475690, 1.083627, -0.864261>, 
      <3.461393, 1.126732, -0.844620>, <3.471306, 1.119358, -0.847233>, <3.482620, 1.112393, -0.860009>, <3.492496, 1.105099, -0.862965>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.277324, 1.327796, -0.759650>, <3.275931, 1.332401, -0.783457>, <3.256687, 1.310717, -0.795710>, <3.241734, 1.291612, -0.796862>, 
      <3.344037, 1.274994, -0.769217>, <3.342644, 1.279599, -0.793024>, <3.322812, 1.259995, -0.802725>, <3.307859, 1.240889, -0.803877>, 
      <3.425427, 1.199755, -0.800321>, <3.421084, 1.205660, -0.817296>, <3.407123, 1.190108, -0.826435>, <3.395740, 1.175564, -0.827313>, 
      <3.493094, 1.150154, -0.817384>, <3.488750, 1.156059, -0.834359>, <3.472777, 1.141276, -0.843742>, <3.461393, 1.126732, -0.844620>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.277324, 1.327796, -0.759650>, <3.206915, 1.383523, -0.749553>, <3.114232, 1.462044, -0.753376>, <3.037920, 1.510416, -0.752110>, 
      <3.275931, 1.332401, -0.783457>, <3.205522, 1.388129, -0.773360>, <3.112800, 1.466777, -0.777848>, <3.036488, 1.515149, -0.776582>, 
      <3.256687, 1.310717, -0.795710>, <3.184509, 1.366083, -0.788052>, <3.088756, 1.444791, -0.799170>, <3.012785, 1.495180, -0.794371>, 
      <3.241734, 1.291612, -0.796862>, <3.169556, 1.346978, -0.789204>, <3.078019, 1.428695, -0.800686>, <3.002048, 1.479084, -0.795887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.245786, 1.278216, -0.727611>, <3.174092, 1.332531, -0.715401>, <3.081226, 1.411361, -0.713135>, <3.006814, 1.463328, -0.714419>, 
      <3.261688, 1.298534, -0.726386>, <3.189994, 1.352849, -0.714175>, <3.092489, 1.428246, -0.711544>, <3.018077, 1.480213, -0.712829>, 
      <3.278805, 1.322898, -0.734332>, <3.208396, 1.378626, -0.724235>, <3.115733, 1.457079, -0.727703>, <3.039422, 1.505451, -0.726438>, 
      <3.277324, 1.327796, -0.759650>, <3.206915, 1.383523, -0.749553>, <3.114232, 1.462044, -0.753376>, <3.037920, 1.510416, -0.752110>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.245786, 1.278216, -0.727611>, <3.261688, 1.298534, -0.726386>, <3.278805, 1.322898, -0.734332>, <3.277324, 1.327796, -0.759650>, 
      <3.314964, 1.225807, -0.739393>, <3.330866, 1.246125, -0.738167>, <3.345518, 1.270096, -0.743899>, <3.344037, 1.274994, -0.769217>, 
      <3.405466, 1.160549, -0.777154>, <3.417533, 1.175966, -0.776224>, <3.430031, 1.193496, -0.782327>, <3.425427, 1.199755, -0.800321>, 
      <3.474335, 1.109138, -0.794042>, <3.486402, 1.124555, -0.793111>, <3.497698, 1.143895, -0.799390>, <3.493094, 1.150154, -0.817384>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.210202, 1.242035, -0.764823>, <3.139323, 1.293170, -0.755556>, <2.981407, 1.435237, -0.760192>, <2.978153, 1.420818, -0.760548>, 
      <3.211595, 1.237430, -0.741018>, <3.140716, 1.288565, -0.731751>, <2.981606, 1.434577, -0.756780>, <2.978353, 1.420158, -0.757136>, 
      <3.230834, 1.259112, -0.728763>, <3.159140, 1.313427, -0.716553>, <3.069779, 1.394202, -0.714751>, <2.995368, 1.446169, -0.716035>, 
      <3.245786, 1.278216, -0.727611>, <3.174092, 1.332531, -0.715401>, <3.081226, 1.411361, -0.713135>, <3.006814, 1.463328, -0.714419>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.210202, 1.242035, -0.764823>, <3.211595, 1.237430, -0.741018>, <3.230834, 1.259112, -0.728763>, <3.245786, 1.278216, -0.727611>, 
      <3.279338, 1.192158, -0.773862>, <3.280730, 1.187553, -0.750056>, <3.300013, 1.206703, -0.740545>, <3.314964, 1.225807, -0.739393>, 
      <3.375700, 1.136427, -0.804122>, <3.380043, 1.130523, -0.787151>, <3.394085, 1.146008, -0.778032>, <3.405466, 1.160549, -0.777154>, 
      <3.442652, 1.085708, -0.821275>, <3.446995, 1.079804, -0.804303>, <3.462954, 1.094597, -0.794920>, <3.474335, 1.109138, -0.794042>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.210202, 1.242035, -0.764823>, <3.279338, 1.192158, -0.773862>, <3.375700, 1.136427, -0.804122>, <3.442652, 1.085708, -0.821275>, 
      <3.208721, 1.246932, -0.790139>, <3.277856, 1.197055, -0.799178>, <3.371096, 1.142687, -0.822116>, <3.438048, 1.091968, -0.839269>, 
      <3.225833, 1.271296, -0.798087>, <3.291958, 1.220573, -0.805103>, <3.383672, 1.160147, -0.828244>, <3.449326, 1.111315, -0.845551>, 
      <3.241734, 1.291612, -0.796862>, <3.307859, 1.240889, -0.803877>, <3.395740, 1.175564, -0.827313>, <3.461393, 1.126732, -0.844620>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.210202, 1.242035, -0.764823>, <3.208721, 1.246932, -0.790139>, <3.225833, 1.271296, -0.798087>, <3.241734, 1.291612, -0.796862>, 
      <3.139323, 1.293170, -0.755556>, <3.137841, 1.298068, -0.780873>, <3.153655, 1.326662, -0.790430>, <3.169556, 1.346978, -0.789204>, 
      <2.981407, 1.435237, -0.760192>, <2.981198, 1.435928, -0.763764>, <3.066034, 1.410728, -0.802378>, <3.078019, 1.428695, -0.800686>, 
      <2.978153, 1.420818, -0.760548>, <2.977944, 1.421509, -0.764120>, <2.990063, 1.461117, -0.797579>, <3.002048, 1.479084, -0.795887>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.352987, 0.665778, -0.905378>, <3.331819, 0.652462, -0.905924>, <3.309986, 0.633562, -0.896746>, <3.314380, 0.624285, -0.873935>, 
      <3.352987, 0.665778, -0.905378>, <3.340257, 0.641761, -0.902345>, <3.330123, 0.630747, -0.900218>, <3.334517, 0.621470, -0.877407>, 
      <3.352987, 0.665778, -0.905378>, <3.340257, 0.641761, -0.902345>, <3.361432, 0.633026, -0.892761>, <3.363907, 0.627801, -0.879912>, 
      <3.352987, 0.665778, -0.905378>, <3.361425, 0.655077, -0.901799>, <3.378887, 0.644006, -0.892310>, <3.381362, 0.638781, -0.879462>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.271597, 0.654125, -0.860538>, <3.280004, 0.640894, -0.864448>, <3.298607, 0.626490, -0.871216>, <3.314380, 0.624285, -0.873935>, 
      <3.265579, 0.666827, -0.891774>, <3.273986, 0.653596, -0.895684>, <3.294214, 0.635767, -0.894027>, <3.309986, 0.633562, -0.896746>, 
      <3.295469, 0.692713, -0.904346>, <3.303922, 0.679674, -0.908312>, <3.322215, 0.664642, -0.909997>, <3.331819, 0.652462, -0.905924>, 
      <3.324455, 0.710947, -0.903597>, <3.332908, 0.697909, -0.907563>, <3.343383, 0.677957, -0.909451>, <3.352987, 0.665778, -0.905378>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.404154, 0.680758, -0.871619>, <3.402167, 0.666765, -0.874956>, <3.393651, 0.646511, -0.879145>, <3.381362, 0.638781, -0.879462>, 
      <3.404154, 0.680758, -0.871619>, <3.397890, 0.675798, -0.897165>, <3.391176, 0.651737, -0.891993>, <3.378887, 0.644006, -0.892310>, 
      <3.404154, 0.680758, -0.871619>, <3.397890, 0.675798, -0.897165>, <3.382035, 0.668042, -0.901268>, <3.361425, 0.655077, -0.901799>, 
      <3.404154, 0.680758, -0.871619>, <3.399876, 0.689790, -0.893828>, <3.373597, 0.678743, -0.904846>, <3.352987, 0.665778, -0.905378>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.404154, 0.680758, -0.871619>, <3.406352, 0.696234, -0.867929>, <3.403110, 0.718449, -0.861244>, <3.394521, 0.731454, -0.857363>, 
      <3.399876, 0.689790, -0.893828>, <3.402074, 0.705266, -0.890138>, <3.397250, 0.730816, -0.891657>, <3.388662, 0.743821, -0.887776>, 
      <3.373597, 0.678743, -0.904846>, <3.363993, 0.690922, -0.908920>, <3.361130, 0.715663, -0.906834>, <3.352678, 0.728701, -0.902868>, 
      <3.352987, 0.665778, -0.905378>, <3.343383, 0.677957, -0.909451>, <3.332908, 0.697909, -0.907563>, <3.324455, 0.710947, -0.903597>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.404154, 0.680758, -0.871619>, <3.399876, 0.689790, -0.893828>, <3.373597, 0.678743, -0.904846>, <3.352987, 0.665778, -0.905378>, 
      <3.402167, 0.666765, -0.874956>, <3.397890, 0.675798, -0.897165>, <3.352429, 0.665427, -0.905392>, <3.331819, 0.652462, -0.905924>, 
      <3.393651, 0.646511, -0.879145>, <3.376196, 0.635531, -0.879595>, <3.330123, 0.630747, -0.900218>, <3.309986, 0.633562, -0.896746>, 
      <3.381362, 0.638781, -0.879462>, <3.363907, 0.627801, -0.879912>, <3.334517, 0.621470, -0.877407>, <3.314380, 0.624285, -0.873935>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.365546, 0.639260, -0.840173>, <3.358494, 0.645629, -0.828600>, <3.349563, 0.662424, -0.817845>, <3.341657, 0.674638, -0.814306>, 
      <3.386716, 0.652577, -0.839627>, <3.379664, 0.658946, -0.828054>, <3.378549, 0.680658, -0.817096>, <3.370642, 0.692872, -0.813557>, 
      <3.408548, 0.671480, -0.848806>, <3.410745, 0.686956, -0.845116>, <3.409127, 0.705748, -0.830009>, <3.400538, 0.718753, -0.826127>, 
      <3.404154, 0.680758, -0.871619>, <3.406352, 0.696234, -0.867929>, <3.403110, 0.718449, -0.861244>, <3.394521, 0.731454, -0.857363>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.365546, 0.639260, -0.840173>, <3.371530, 0.633856, -0.849993>, <3.383594, 0.634069, -0.867874>, <3.381362, 0.638781, -0.879462>, 
      <3.365546, 0.639260, -0.840173>, <3.392700, 0.647173, -0.849447>, <3.395883, 0.641799, -0.867557>, <3.393651, 0.646511, -0.879145>, 
      <3.365546, 0.639260, -0.840173>, <3.392700, 0.647173, -0.849447>, <3.406561, 0.657488, -0.852143>, <3.402167, 0.666765, -0.874956>, 
      <3.365546, 0.639260, -0.840173>, <3.386716, 0.652577, -0.839627>, <3.408548, 0.671480, -0.848806>, <3.404154, 0.680758, -0.871619>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.365546, 0.639260, -0.840173>, <3.371530, 0.633856, -0.849993>, <3.383594, 0.634069, -0.867874>, <3.381362, 0.638781, -0.879462>, 
      <3.386716, 0.652577, -0.839627>, <3.392700, 0.647173, -0.849447>, <3.381119, 0.639294, -0.880723>, <3.378887, 0.644006, -0.892310>, 
      <3.408548, 0.671480, -0.848806>, <3.404270, 0.680512, -0.871015>, <3.382035, 0.668042, -0.901268>, <3.361425, 0.655077, -0.901799>, 
      <3.404154, 0.680758, -0.871619>, <3.399876, 0.689790, -0.893828>, <3.373597, 0.678743, -0.904846>, <3.352987, 0.665778, -0.905378>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.365546, 0.639260, -0.840173>, <3.386716, 0.652577, -0.839627>, <3.408548, 0.671480, -0.848806>, <3.404154, 0.680758, -0.871619>, 
      <3.344936, 0.626295, -0.840705>, <3.366106, 0.639612, -0.840159>, <3.406561, 0.657488, -0.852143>, <3.402167, 0.666765, -0.874956>, 
      <3.318658, 0.615253, -0.851726>, <3.338794, 0.612438, -0.855197>, <3.376196, 0.635531, -0.879595>, <3.393651, 0.646511, -0.879145>, 
      <3.314380, 0.624285, -0.873935>, <3.334517, 0.621470, -0.877407>, <3.363907, 0.627801, -0.879912>, <3.381362, 0.638781, -0.879462>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.365546, 0.639260, -0.840173>, <3.371530, 0.633856, -0.849993>, <3.383594, 0.634069, -0.867874>, <3.381362, 0.638781, -0.879462>, 
      <3.365546, 0.639260, -0.840173>, <3.350921, 0.620891, -0.850525>, <3.366139, 0.623088, -0.868325>, <3.363907, 0.627801, -0.879912>, 
      <3.365546, 0.639260, -0.840173>, <3.350921, 0.620891, -0.850525>, <3.338794, 0.612438, -0.855197>, <3.334517, 0.621470, -0.877407>, 
      <3.365546, 0.639260, -0.840173>, <3.344936, 0.626295, -0.840705>, <3.318658, 0.615253, -0.851726>, <3.314380, 0.624285, -0.873935>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.365546, 0.639260, -0.840173>, <3.358494, 0.645629, -0.828600>, <3.349563, 0.662424, -0.817845>, <3.341657, 0.674638, -0.814306>, 
      <3.344936, 0.626295, -0.840705>, <3.337884, 0.632664, -0.829132>, <3.321342, 0.644671, -0.818574>, <3.313436, 0.656885, -0.815035>, 
      <3.318658, 0.615253, -0.851726>, <3.302885, 0.617458, -0.849007>, <3.285863, 0.628528, -0.834037>, <3.277456, 0.641759, -0.830126>, 
      <3.314380, 0.624285, -0.873935>, <3.298607, 0.626490, -0.871216>, <3.280004, 0.640894, -0.864448>, <3.271597, 0.654125, -0.860538>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.365546, 0.639260, -0.840173>, <3.344936, 0.626295, -0.840705>, <3.318658, 0.615253, -0.851726>, <3.314380, 0.624285, -0.873935>, 
      <3.371530, 0.633856, -0.849993>, <3.350921, 0.620891, -0.850525>, <3.314264, 0.624530, -0.874537>, <3.309986, 0.633562, -0.896746>, 
      <3.383594, 0.634069, -0.867874>, <3.381119, 0.639294, -0.880723>, <3.340257, 0.641761, -0.902345>, <3.331819, 0.652462, -0.905924>, 
      <3.381362, 0.638781, -0.879462>, <3.378887, 0.644006, -0.892310>, <3.361425, 0.655077, -0.901799>, <3.352987, 0.665778, -0.905378>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.348450, 0.765106, -0.846447>, <3.344243, 0.773985, -0.868284>, <3.318406, 0.763126, -0.879119>, <3.298142, 0.750378, -0.879642>, 
      <3.357798, 0.750873, -0.850150>, <3.353591, 0.759752, -0.871987>, <3.326840, 0.750070, -0.882624>, <3.306577, 0.737322, -0.883147>, 
      <3.385202, 0.745564, -0.853152>, <3.379343, 0.757932, -0.883565>, <3.344279, 0.741656, -0.898927>, <3.316056, 0.723902, -0.899656>, 
      <3.394521, 0.731454, -0.857363>, <3.388662, 0.743821, -0.887776>, <3.352678, 0.728701, -0.902868>, <3.324455, 0.710947, -0.903597>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0010 u_steps 3 v_steps 3,
      <3.310492, 0.724309, -0.815531>, <3.331305, 0.737402, -0.814993>, <3.352771, 0.755986, -0.824018>, <3.348450, 0.765106, -0.846447>, 
      <3.319824, 0.709838, -0.819151>, <3.340636, 0.722931, -0.818614>, <3.362118, 0.741753, -0.827721>, <3.357798, 0.750873, -0.850150>, 
      <3.332366, 0.688990, -0.810148>, <3.361352, 0.707225, -0.809399>, <3.391220, 0.732863, -0.821916>, <3.3852