/* chemLab.pov */
/* Date: Sat 23 Sep 2000 */
/* Author: Adrian Koh */
/* Purpose:
        IRTC, 1 Sep - 31 Oct 2000 Stills Round
        Topic: The Laboratory
*/

/* ========================================================================== */

#include "puddles1.0.mcr"
#include "crucible.inc"
#include "bunsenBurner.inc"
#include "testTube.inc"
#include "tripod.inc"

global_settings { assumed_gamma 1.0 }

/* ========================================================================== */
// Camera definition

#declare CameraLocation = <0, 4*5, -18>;
#declare CameraLookAt = <0, 5, 0>;
camera {
    #if (1)
    location CameraLocation
    //location <0, 5, -18>
    look_at CameraLookAt
    #end

    // view under floor
    #if (0)
    location <0, -5, -18>
    look_at <0, -5, 0>
    #end
    
    // aerial view
    #if (0)
    location <0, 30, 0>
    look_at <0, 0, 0>
    #end

    rotate <5, 0, 0>
    rotate <0, -30, 0>
}

/* ========================================================================== */
// light Sources

// light above floor
light_source { <1000, 1000, -1000> color rgb <1, 1, 1> }

// light below floor
//light_source { <1000, -1000, -1000> color rgb <1, 1, 1> }

/* ========================================================================== */
/* Parameters for controlling the inclusion of objects */
/* Useful for debugging */

#declare I_TestTubeObj = 1;
#declare I_TestTubeLiquidObj = 1;
#declare I_GasFromFloorObj = 1;

#declare I_FloorObj = 1;
#declare I_WallObj = 1;

#declare I_LiquidPuddleObj = 1;

#declare I_CrucibleSteamObj = 1;

#declare I_BunsenBurnerObj = 1;
#declare I_BunsenBurnerTubeObj = 1;
#declare I_TripodObj = 1;
#declare I_GauzeMatObj = 1;

#declare I_CrucibleObj = 1;
#declare I_CrucibleLiquidObj = 1;
#declare I_BunsenFlameObj = 1;
#declare I_BunsenFlameFlareObj = 1;

/* ========================================================================== */
#ifdef (I_FloorObj)
difference {
    plane {
        y, 0
    }
    object {
        #declare localScale = 0.75;
        Puddle(localScale*0.5, localScale*0.5, localScale*0.125, 
               localScale*0.125, localScale*0.5, 0.1) 
        pigment { 
            color rgbt <1, 1, 1, 1> // need transparent pigment so that you
                                    // can't see the Puddle. This shouldn't
                                    // really be needed but if it isn't used,
                                    // the difference renders incorrectly.
        }
        translate HoleLocation
        #undef localScale
    }
    // bottom most texture layer: tiled floor
    texture {
        pigment { 
            color rgb <0.4, 0.1, 0> 
            quick_color rgb <0.4, 0.1, 0> 
        }
        //normal { granite 0.2 }
        normal { 
            //quilted 0.2 
            quilted 0.4
            control0 1.0
            control1 1.0
            scale 4
        }
    }
    // top most texture layer: dirty marks
    texture {
        pigment { 
            //color rgb <0.4, 0.1, 0> 
            wrinkles
            color_map {
                [0.0 color rgb <0.4, 0.1, 0>]
                [1.0 color rgbt <0.4, 0.1, 0, 1.0>]
            }
            quick_color rgb <0.4, 0.1, 0> 
        }
        normal { 
            wrinkles 5.0
            scale <5, 1, 5>
        }
    }
}
#end

/* -------------------------------------------------------------------------- */
#ifdef ( I_LiquidPuddleObj )
object{
    Puddle(2, 2, 0.5, 0.5, 2, 0.6) 
    texture {
        pigment {
            color rgbt <1, 0.3, 0.8, 0.5>
            //quick_color rgbt <1, 0.3, 0.8, 0.5>
            quick_color rgbt (2*<1, 0.3, 0.8, 0> + <0, 0, 0, 0.5>)
        }
        finish {
            specular 0.1 roughness 0.05
            reflection 0.2
        }
    }
    interior {
        ior 1.33
    }
    scale <0.8, 1, 0.8>
    translate <13, 0, 1>
}
#end

/* -------------------------------------------------------------------------- */
#ifdef (I_GasFromFloorObj)
object {
    GasFromFloorObj
    texture {
        pigment  {
            color rgbt <1, 1, 1, 1>
            quick_color rgb <1, 0, 0>
        }
    }
    interior {
        media {
            emission 1.0
            samples 2, 20
            density {
                spherical
                color_map {
                    [0.0 color rgb <0, 0, 0>]
                    [0.4 color rgb 0.5*<0, 1, 0>]
                    [0.4 color rgb <0, 0, 0>]
                    [1.0 color rgb <0, 0, 0>]
                }
                turbulence 1.2
            }
            scale <1.5, 4, 1.5>
        }
    }
    translate HoleLocation + 0.2*<1, 0, -1>
}
#end

/* -------------------------------------------------------------------------- */
#ifdef (I_WallObj)
    #declare currX = -60;
    #declare parity = true;
    #declare WallObj_R = seed(0);
    #declare PlankWidth = 3;
    #declare PlankDividerWidth = 0.2;
    #while ( currX < 20 )
        #if ( parity )
            polygon {
                5,
                <currX, 0, 8>,
                <currX + PlankWidth, 0, 8>,
                <currX + PlankWidth, 20, 8>,
                <currX, 20, 8>,
                <currX, 0, 8>
                texture {
                    pigment { 
                        wood
                        color_map {
                            [0.0 color rgb <1, 0.3, 0.1>]
                            [1.0 color rgb <0.4, 0.1, 0>]
                        }
                        quick_color rgb 0.5 
                        rotate <70, 0, 0> - rand(WallObj_R)*<15, 0, 0>
                        translate <30, 30, 0> - rand(WallObj_R)*<5, 5, 0>
                        frequency 2
                        turbulence 0.05*rand(WallObj_R)
                    }
                    normal {
                        wrinkles 5.0
                        scale <5, 5, 1>
                    }
                }
            }
        #else
            polygon {
                5,
                <currX, 0, 8>,
                <currX + PlankDividerWidth, 0, 8>,
                <currX + PlankDividerWidth, 20, 8>,
                <currX, 20, 8>,
                <currX, 0, 8>
                pigment { 
                    color rgb <0.05, 0.02, 0>
                }
            }
        #end
        #if ( parity ) 
            #declare parity = false;
            #declare currX = currX + PlankWidth;
        #else
            #declare parity = true;
            #declare currX = currX + PlankDividerWidth;
        #end
    #end
#end

/* -------------------------------------------------------------------------- */
#ifdef (I_TestTubeObj)
object {
    TestTubeObj
    texture {
        pigment { 
            color rgbt <1, 1, 1, 0.98>
            quick_color rgb <0, 1, 0>
        }
        finish {
            specular 1.0 roughness 0.008
            reflection 0.2
        }
    }
    interior {
        ior 1.5
    }
    scale 1.2
    rotate <-90, -60, 0>
    translate <-20, 1.2*TestTubeRadius, 0>
}
#end

/* -------------------------------------------------------------------------- */
#ifdef (I_TestTubeLiquidObj)
object {
    TestTubeLiquidObj
    texture {
        pigment {
            //color rgbt <0, 1, 0, 0.8>
            color rgbt <0, 1, 0, 0.4>
            quick_color rgbt <0, 1, 0, 0.8>
        }
        finish {
            specular 0.3 roughness 0.05
            ambient 0.5
            //reflection 0.2
            reflection 0.4
        }
    }
    interior {
        ior 1.33
    }
    rotate <-90, -60, 0>
    translate <-20, 1.2*TestTubeRadius, 0>
}
#end

/* -------------------------------------------------------------------------- */
#ifdef (I_CrucibleObj)
object {
    CrucibleObj

    texture {
        pigment {
            crackle
            color_map {
                [0.0 color rgb 0.1]
                [1.0 color rgb 0.6]
            }
            turbulence 0.7
            quick_color color rgb 0.8
        }
        finish {
            specular 0.3 roughness 0.05
        }
    }

    translate <0, TripodHeight, 0>
}
#end

/* -------------------------------------------------------------------------- */
// liquid inside Crucible
#ifdef (I_CrucibleLiquidObj)
object {
    CrucibleLiquidObj
}
#end

/* -------------------------------------------------------------------------- */
// steam coming from liquid inside Crucible
#ifdef (I_CrucibleSteamObj)
object {
    CrucibleSteamObj
}
#end

/* -------------------------------------------------------------------------- */
#ifdef (I_BunsenBurnerObj)
object {
    BunsenBurnerObj
    texture {
        pigment { 
            color rgb 0.8
            quick_color color rgb 0.8
        }
        finish {
            specular 0.8 roughness 0.01
            reflection 0.2
            metallic
            brilliance 6
        }
    }
}
#end

/* -------------------------------------------------------------------------- */
#ifdef (I_BunsenFlameObj)
object {
    BunsenFlameObj
    //scale <1, 4, 1>
    scale <1, 5, 1>
    translate <0, BunsenHeight, 0>
}
#end

/* -------------------------------------------------------------------------- */
#ifdef (I_BunsenFlameFlareObj)
object {
    BunsenFlameFlareObj
    /* For upside down Flare
    scale <1.7, 1.0, 1.7>
    translate <0, BunsenHeight + 5, 0>
    */
    scale <2, 1.5, 2>
    translate <0, BunsenHeight + 6, 0>
}
#end

/* -------------------------------------------------------------------------- */
#ifdef (I_TripodObj)
object {
    TripodObj
    // dull, rusty metal
    texture {
        pigment { 
            //color rgb 0.8
            crackle
            color_map {
                [0.0 color rgb <0.2, 0.2, 0.2>]
                [1.0 color rgb <0.3, 0.1, 0.05>]
            }
            scale 4
            frequency 4
            quick_color color rgb 0.8
        }
        finish {
            metallic
            brilliance 6
        }
    }
}
#end

/* -------------------------------------------------------------------------- */
#ifdef (I_GauzeMatObj)
object {
    GauzeMatObj
}
#end

/* -------------------------------------------------------------------------- */

#ifdef (I_BunsenBurnerTubeObj)
difference {
    torus {
        10, 0.5
    }
    box {
        <-12, -1, -12>, 
        <12, 1, 0>
    }
    pigment { color rgb 0.8*<1, 0.1, 0> }
    scale <1, 1, 0.5>
    translate <10, 0.45*BunsenBaseRadius, 0>
}
#end

/* -------------------------------------------------------------------------- */
