/* testTube.inc*/
/* Date: Sat 23 Sep 2000 */
/* Author: Adrian Koh */
/* Purpos:
        IRTC, 1 Sep - 31 Oct 2000 Stills Round
        Topic: The Laboratory

        This file stores definitions for the following objects:
            GasFromFloorObj
            TestTubeObj
            TestTubeLiquidObj

*/

#include "globalVars.inc"

/* ========================================================================== */
/* TestTubeObj:
 *      A test tube object without default texture.
 */
#declare TestTubeObj = union {
    difference {
        cylinder {
            0, <0, TestTubeHeight, 0>, TestTubeRadius
        }
        cylinder {
            <0, -0.01, 0>, 
            <0, TestTubeHeight + 0.01, 0>, 
            TestTubeRadius - TestTubeThickness
        }
    }
    difference {
        sphere {
            0, TestTubeRadius
        }
        box {
            <-TestTubeRadius - 0.1, 0, -TestTubeRadius - 0.1>, 
            <TestTubeRadius + 0.1, TestTubeRadius + 0.1, TestTubeRadius + 0.1> 
        }
        sphere {
            0, TestTubeRadius - TestTubeThickness
        }
    }
    translate <0, TestTubeRadius, 0>

    hollow
}

/* -------------------------------------------------------------------------- */
#declare TestTubeLiquidObj = blob {
    threshold 0.4
    #local currBlobComp = 0;
    #local currYBlobCompPos = 3;
    #local currBlobCompRadius = 1.2;
    #local Blob_R = seed(0);
    #local TestTubeLiquidScale = <1.0, 1.0, 0.5>;
    #local maxBlobCompDisp = 0.3;

    // liquid leading to opening of test tube
    #while ( currBlobComp < 10 )
        sphere {
            <0, 0, 0>,
            currBlobCompRadius, 1.0
            scale TestTubeLiquidScale
            scale <rand(Blob_R)*0.6 + 0.6, 1, 1>
            translate <-0.1, currYBlobCompPos, 
                -(TestTubeRadius + TestTubeThickness) + 
                TestTubeLiquidScale.z*currBlobCompRadius>
            translate <rand(Blob_R)*maxBlobCompDisp, 0, 0>
        }
        #local currBlobComp = currBlobComp + 1;
        #local currYBlobCompPos = currYBlobCompPos + 1;
    #end

    // liquid from testtube mouth to floor
    #local currBlobComp = 0;
    #while ( currBlobComp < 1 )
        sphere {
            <0, 0, 0>,
            currBlobCompRadius, 1.0
            scale TestTubeLiquidScale
            scale <0.5, 1.5, 1>
            translate <-0.1, currYBlobCompPos, 
                -(TestTubeRadius + TestTubeThickness) + 
                TestTubeLiquidScale.z*currBlobCompRadius>
            translate <rand(Blob_R)*maxBlobCompDisp, 0, -TestTubeThickness>
        }
        #local currBlobComp = currBlobComp + 1;
        #local currYBlobCompPos = currYBlobCompPos + 1;
    #end

    // drop through hole in floor
    sphere {
        <0, 0, 0>,
        currBlobCompRadius, 1.0
        scale 0.35*<0.75, 0.125, 2>
        translate <-0.1, currYBlobCompPos, -TestTubeRadius - 0.5> 
    }
}

/* -------------------------------------------------------------------------- */
// gas rising from hole in floor
#declare GasFromFloorObj = difference {
    sphere {
        0, CrucibleRadius - CrucibleEdgeWidth
        hollow
    }
    box {
        <-CrucibleRadius, -CrucibleRadius, -CrucibleRadius>,
        <CrucibleRadius, 0, CrucibleRadius>
    }
}

/* ========================================================================== */
