/* tripod.inc*/
/* Date: Sat 23 Sep 2000 */
/* Author: Adrian Koh */
/* Purpos:
        IRTC, 1 Sep - 31 Oct 2000 Stills Round
        Topic: The Laboratory

        This file stores definitions for the following objects:
            GauzeMatObj
            TripodLegObj
            TripodObj
*/

#include "globalVars.inc"

/* ========================================================================== */
#declare TripodLegObj = difference {
    cylinder {
        <0, -2, 0>, <0, TripodHeight, 0>, TripodLegRadius
        translate <0, -TripodHeight, 0>
        rotate <0, 0, 10>
        translate <0, TripodHeight, 0>
        translate <TripodRadius - ( TripodEdgeWidth / 2 ), 0, 0>
    }
    // trim bottom to make it parallel to the floor
    box {
        <-0.5*3 - 0.001, -2 - 0.001, -0.5*3 - 0.001>,
        <0.5*3 + 0.001, 0, 0.5*3 + 0.001>
        translate <TripodRadius + 1 , 0, 0>
    }
    // trim top to remove intrusion beyond top of tripod
    box {
        <-0.5*3 - 0.001, TripodHeight + 1, -0.5*3 - 0.001>,
        <0.5*3 + 0.001, TripodHeight - 0.001, 0.5*3 + 0.001>
        translate <TripodRadius - TripodEdgeWidth , 0, 0>
    }
    //translate <0.15, 0, 0> // original
    translate <0.1 * TripodEdgeWidth, 0, 0>
}


#declare TripodObj = union {
    // top
    difference {
        cylinder {
            <0, TripodHeight - TripodTopThickness, 0>, 
            <0, TripodHeight, 0>, 
            TripodRadius
        }
        cylinder {
            <0, TripodHeight - TripodTopThickness -0.001, 0>, 
            <0, TripodHeight + 0.001, 0>, 
            TripodRadius - TripodEdgeWidth
        }
        //scale <1, 0.45, 1>
    }
    object {
        TripodLegObj
    }
    object {
        TripodLegObj
        rotate <0, -120, 0>
    }
    object {
        TripodLegObj
        rotate <0, -240, 0>
    }
}

#declare GauzeMatObj = union {
    #local R1 = seed(0);
    #local maxLenDev = 1.0; // maximum length deviation of wire length
    #local maxCoord = 0.9*TripodRadius;

    // wires parallel to z-axis
    #local currWire = -maxCoord;
    #while ( currWire <= maxCoord )
        cylinder {
            <currWire, 0, -maxCoord - rand(R1)*maxLenDev>, 
            <currWire, 0, maxCoord + rand(R1)*maxLenDev>, 
            GauzeMatWireThickness
            pigment { color rgb 0.2 }
        }
        #local currWire = currWire + 1.0;
    #end

    // wires parallel to x-axis
    #local currWire = -maxCoord;
    #while ( currWire <= maxCoord )
        cylinder {
            <-maxCoord - rand(R1)*maxLenDev, 0, currWire>, 
            <maxCoord + rand(R1)*maxLenDev, 0, currWire>, 
            GauzeMatWireThickness
            pigment { color rgb 0.2 }
        }
        #local currWire = currWire + 1.0;
    #end
    translate <0, TripodHeight + 0.001, 0>
}

/* ========================================================================== */
