#version unofficial megapov 0.5;

#ifndef (test_cage_inc)

#declare test_cage_inc = off;

#ifndef (test_grilles_inc)
#include "grilles.inc"
#end

#declare BasCage = union {
	box { <-.30,   0, -.20>, < .30, .01,  .20> }
	box { <-.31, .01, -.20>, <-.30, .10,  .20> }
	box { < .31, .01, -.20>, < .30, .10,  .20> }
	box { <-.30, .01, -.21>, < .30, .10, -.20> }
	box { <-.30, .01,  .21>, < .30, .10,  .20> }
	cylinder { <-.30, .01, -.20>, <-.30, .10, -.20>, .01 }
	cylinder { <-.30, .01,  .20>, <-.30, .10,  .20>, .01 }
	cylinder { < .30, .01, -.20>, < .30, .10, -.20>, .01 }
	cylinder { < .30, .01,  .20>, < .30, .10,  .20>, .01 }
	cylinder { <-.30, .01, -.20>, < .30, .01, -.20>, .01 }
	cylinder { <-.30, .01,  .20>, < .30, .01,  .20>, .01 }
	cylinder { <-.30, .01, -.20>, <-.30, .01,  .20>, .01 }
	cylinder { < .30, .01, -.20>, < .30, .01,  .20>, .01 }
	sphere { <-.30, .01, -.20>, .01 }
	sphere { < .30, .01, -.20>, .01 }
	sphere { <-.30, .01,  .20>, .01 }
	sphere { < .30, .01,  .20>, .01 }
	texture {
		pigment { color rgb<1, .8, .7> }
		normal { dents .5 scale .005 }
		finish { phong .4 phong_size 20 }
	}
}


#declare GrillesCage = union {
	intersection {
		box { <-.303, .10, -.003>, < .303, .302, .003> }
		Grille(-.3,.3,.102,.3,12,8,.0019,.0019)
		translate -.20*z
	}
	intersection {
		box { <-.303, .10, -.003>, < .303, .302, .003> }
		Grille(-.3,.3,.102,.3,12,8,.0019,.0019)
		rotate y*180
		translate  .20*z
	}
	intersection {
		box { <-.203, .10, -.003>, < .203, .302, .003> }
		Grille(-.20,.20,.102,.3,8,8,.0019,.0019)
		rotate y*90
		translate -.30*x
	}
	intersection {
		box { <-.203, .10, -.003>, < .203, .302, .003> }
		Grille(-.20,.20,.102,.3,8,8,.0019,.0019)
		rotate -y*90
		translate  .30*x
	}
}

#declare haccroch = (.3-.102)/8;

#declare HautCage = union {
	box { <-.302,   .005, -.203>, < .302, .01,  .203> }
	box { <-.297,    0, -.198>, < .297, .005,  .198> }
	cylinder { <-.297, .005, -.198>, < .297, .005, -.198>, .005 }
	cylinder { <-.297, .005,  .198>, < .297, .005,  .198>, .005 }
	cylinder { <-.297, .005, -.198>, <-.297, .005,  .198>, .005 }
	cylinder { < .297, .005, -.198>, < .297, .005,  .198>, .005 }
	sphere { <-.297, .005, -.198>, .005 }
	sphere { <-.297, .005,  .198>, .005 }
	sphere { < .297, .005, -.198>, .005 }
	sphere { < .297, .005,  .198>, .005 }
	difference {
		box { <-.235, .01, -.2025>, <-.225, (.01+haccroch+.005), -.200> }
		cylinder { <-.236, (0.1+haccroch+.002), -.200>, <-.224, (0.1+haccroch+.002), -.200>, .0016 }
	}
	difference {
		box { < .235, .01, -.2025>, < .225, (.01+haccroch+.005), -.200> }
		cylinder { < .236, (0.1+haccroch+.002), -.200>, < .224, (0.1+haccroch+.002), -.200>, .0016 }
	}
	difference {
		box { <-.235, .01,  .2025>, <-.225, (.01+haccroch+.005),  .200> }
		cylinder { <-.236, (0.1+haccroch+.002),  .200>, <-.224, (0.1+haccroch+.002),  .200>, .0016 }
	}
	difference {
		box { < .235, .01,  .2025>, < .225, (.01+haccroch+.005),  .200> }
		cylinder { < .236, (0.1+haccroch+.002),  .200>, < .224, (.01+haccroch+.002),  .200>, .0016 }
	}
	texture {
		pigment { color rgb<1, .8, .7> }
		normal { dents .5 scale .005 }
		finish { phong .4 phong_size 20 }
	}
}


#if (test_cage_inc)

#include "paille.inc"


#declare Use_Rad = on;

#if (Use_Rad)

global_settings {
	assumed_gamma 1.0
	ini_option "+QR"
	radiosity{
		count 150
		nearest_count 5
		error_bound .1
		recursion_limit 1
		brightness 1.0

		pretrace_start  .1
		pretrace_end  .01

		low_error_factor .5
		gray_threshold 0.0
		minimum_reuse 0.015
		normal on

		max_sample 1
		adc_bailout 0.05
	}
}

#default { texture { finish { diffuse 1 ambient 0 } } }

sky_sphere {
	pigment {
		gradient y
		color_map {
			[0.5 rgb <.8, .9, 1>*.95]
			[0.0 rgb <.8, .9, 1>*.75]
		}
	}
}

#else

light_source {
	< 15, 15, -15>*100, color rgb 1
}

#end


camera {
	location <.6, .4, -1.2>*2
	angle 40
	look_at <0,.1,-.2>
}


plane {
	y, 0
	pigment { rgb .90 }
	normal { dents -2 scale .02 }
}

union {
	object {
		BasCage
		pigment { color rgb<1, .9, .8> }
		normal { dents .5 scale .005 }
		finish { phong .4 phong_size 20 }
	}
	object {
		GrillesCage
		pigment { color rgb.95 }
		finish { brilliance 3 specular .8 roughness .002 }
	}
	translate .21*z
	rotate -90*x
	translate .1*z
	rotate -atan2(.01-.0015,.2)*x
}

object {
	HautCage
	rotate y*30
	translate -.1*x - .7*z
	pigment { color rgb<1, .9, .8> }
	normal { dents .5 scale .005 }
	finish { phong .4 phong_size 20 }
}

#declare sr=seed(3521);
// Paille_mesh(coin1, coin2, nbb, larg, turb, sturb, nbs, st)
#declare m_paille = Paille_mesh(<-.1, 0, -.1>, <.1, .02, .1>, 100, .003, .03, 10, 5, sr)

union {
#local i=-.2;
#while (i<.21)
	object { m_paille rotate 360*y*rand(sr) translate i*x +.01*y }
	#local i=i+.05;
#end
#local i=-.15;
#while (i<.11)
	object { m_paille rotate 360*y*rand(sr) translate i*x -.1*z +.01*y }
	#local i=i+.05;
#end
#local i=-.15;
#while (i<.16)
	object { m_paille rotate 360*y*rand(sr) translate i*x -.2*z +.005*y }
	#local i=i+.05;
#end
#local i=-.25;
#while (i<.26)
	object { m_paille rotate 360*y*rand(sr) translate i*x -.28*z +.002*y }
	#local i=i+.1;
#end
#local i=-.35;
#while (i<.36)
	object { m_paille rotate 360*y*rand(sr) translate i*x -.35*z +.000*y }
	#local i=i+.15;
#end
	texture {
		pigment {
			spotted
			turbulence .4 octaves 2
			scale <.2,.005,.2>
			color_map {
				[.2 color rgb<1,.9,.3>]
				[.5 color rgb<.9,.7,.4>]
				[.8 color rgb<.9,.5,.1>]
			}
		}
	}
}


#end
// demo scene

#end
// (test_cage_inc)
