#version unofficial megapov 0.5;

//=========================================================================
//=========================================================================
//      GLOBAL SETTINGS
//=========================================================================
//=========================================================================

#declare Use_Rad=on;
#declare Rad_rec = 1;
#declare Rad_norm = on;
#declare Rad_bright = 1.5;
#declare Rad_error = 0.1;
#declare Rad_count = 100;

#declare Use_Spot_light = on;
#declare Use_Area_light = on;
#declare Simulate_Area_light = off;
#declare Area_light_samples1 = 10;
#declare Area_light_samples2 = 4;
#declare Area_light_adap = 3;

#declare Place_Paille = on;

#declare Place_Scientist = off;
#declare Place_Chien_Mechant = off;
#declare Use_Souris = off;
#declare Use_Chat1 = off;
#declare Use_Chat2 = off;
#declare Use_Chat3 = off;
#declare Use_Chat4 = off;


global_settings {
	assumed_gamma 1.0
	max_trace_level 10
	adc_bailout 0.1
#if (Use_Rad)
	ini_option "+QR"
	radiosity{
		count Rad_count
		nearest_count 5
		error_bound Rad_error
		recursion_limit Rad_rec
		brightness Rad_bright

		pretrace_start  .1
		pretrace_end  .01

		low_error_factor .5
		gray_threshold 0.0
		minimum_reuse 0.015
		normal Rad_norm

		max_sample 1
		adc_bailout 0.05
	}
#end
}


//=========================================================================
//=========================================================================
//      ECLAIRAGE, ENVIRONNEMENT
//=========================================================================
//=========================================================================
#include "mytext.inc"

//=========================================================================
//          CAMERA
//=========================================================================


camera {
	location <.45, .55, -1.5>
	right x*5/3
	up y
	angle 55
	look_at <.45,.75,10>
//	angle 10
//	look_at .75*x + 4.9*z +1.35*y
}

//=========================================================================
//          LUMIERES
//=========================================================================

#if (Use_Rad)
union {
	box { <-.1, 2.45, -1>, <.1, 2.49, 1> texture { T_Neon scale <.1, 1, 1> } }
	box { <-.1, 2.45, 3>,  <.1, 2.49, 5> texture { T_Neon scale <.1, 1, 1> translate 4*z } }
	no_shadow
	hollow
}

union {
	box { <-.101, 2.49, -1>, <.101, 2.5, 1> }
	box { <-.101, 2.49, 3>,  <.101, 2.5, 5> }
	pigment { rgb .7 }
}

#if (Simulate_Area_light)

// rien

#else

light_source {
	<0,2.45,4>, rgb <1,1,.9>*.3
#if (Use_Spot_light)
	spotlight
	point_at <0,-10,4>
	radius 80
	falloff 90
	tightness 0
#end
#if (Use_Area_light)
	area_light 2*z, .2*x, Area_light_samples1, Area_light_samples2
	adaptive Area_light_adap
	jitter
#end
}
light_source {
	<0,2.45,0>, rgb <1,1,.9>*.3
#if (Use_Spot_light)
	spotlight
	point_at <0,-10,0>
	radius 80
	falloff 90
	tightness 0
#end
#if (Use_Area_light)
	area_light 2*z, .2*x, Area_light_samples1, Area_light_samples2
	adaptive Area_light_adap
	jitter
#end
}

#end  /* (Simulate_Area_light) */



#else

light_source {
	<0,2.45,4>, rgb <1,1,.9>*.3
#if (Use_Spot_light)
	spotlight
	radius 89
	falloff 90
	tightness 0
	point_at <0,-10,4>
#end
#if (Use_Area_light)
	area_light 2*z, .2*x, Area_light_samples1, Area_light_samples2
	adaptive Area_light_adap
	jitter
#end
	looks_like { box {<-.1, 0, -1>, <.1, .04, 1>} texture { T_Neon scale <.1, 1, 1> } }
}
light_source {
	<0,2.45,0>, rgb <1,1,.9>*.3
#if (Use_Spot_light)
	spotlight
	radius 89
	falloff 90
	tightness 0
	point_at <0,-10,0>
#end
#if (Use_Area_light)
	area_light 2*z, .2*x, Area_light_samples1, Area_light_samples2
	adaptive Area_light_adap
	jitter
#end
	looks_like { box {<-.1, 0, -1>, <.1, .04, 1>} texture { T_Neon scale <.1, 1, 1> } }
}
#end

//=========================================================================
//=========================================================================
//      PIECE
//=========================================================================
//=========================================================================

//=========================================================================
//      LES MURS, SOL, PLAFOND
//=========================================================================

// sol
box { <-2, -.1, -2>, <2, -.01, 6> texture { T_Mur finish {diffuse .4}} }
union{

#declare Bloc1 = union {
	box { <-1, 0, -1>, <1, .1, 1> }
	sphere { 0, .1 translate -x-z }
	sphere { 0, .1 translate -x+z }
	sphere { 0, .1 translate x-z }
	sphere { 0, .1 translate x+z }
	cylinder { -x-z, x-z, .1 }
	cylinder { -x-z, -x+z, .1 }
	cylinder { x-z, x+z, .1 }
	cylinder { -x+z, x+z, .1 }
	scale <.505/1.1, 1, .505/1.1>
	scale <.4,.1,.4>
}

#local st=seed(3521);

#local i=-2;
#while (i<2)
	#local j=-2;
	#while (j<6)
		object { Bloc1 rotate <.5*(-1+2*rand(st)), 1*(-1+2*rand(st)), .5*(-1+2*rand(st))> translate <(i+.1), -.01, (j+.1)> }
		#local j=j+.4;
	#end
	#local i=i+.4;
#end
	texture { T_Carrelage }
}


// plafond

box { <-2, 2.5, -2>, <2, 2.6, 6> texture { T_Plafond } }

union {
#local inc=(1.975*2)/6;
#local i=-1.975;
#while (i<2)
	box { <i-.025, 2.498, -2>, <i+.025, 2.4999, 6> }
	#local i=i+inc;
#end
#local i=-1.975;
#while (i<6)
	box { <-2, 2.496, i-.025>, <2, 2.498, i+.025> }
	#local i=i+inc;
#end
	texture { T_Plastique_Beige }
}

// mur du fond
box { <-2, -.1, 6>, <2, 2.5, 7> texture { T_Mur finish {diffuse .8}} }
// mur de derriere
box { <-2, -.1, -2.1>, <2, 2.5, -2> texture { T_Mur } }
// mur gauche
box { <-2.1, -.1, -2>, <-2, 2.5, 6> texture { T_Mur } }
// mur droit
box { <2, -.1, -2>, <2.1, 2.5, 6> texture { T_Mur } }


//=========================================================================
//      LES PLANCHES
//=========================================================================

#declare Planche1 = union {
	intersection {
		sphere { 0, 80 translate 79.99*z }
		box { <-.75, -.5, -.02>, <.75, .5, 0> }
		texture {
			pigment {
				image_map {
					png "images/planche1.png"
					interpolate 2
					once
				}
				translate -.5*x -.5*y
				scale <1.5,1,1>
			}
			normal {
				wrinkles .1
				slope_map {
					[0.5 <0,0>]
					[0.5 <0,.5>]
					[1.0 <.1,0>]
				}
				scale .05
			}
			finish {
				diffuse .9
				phong .4 phong_size 30
			}
		}
	}
	// cadre
	box { <-.78, -.53, -.02>, <-.75,  .53, 0> }
	box { < .75, -.53, -.02>, < .78,  .53, 0> }
	box { <-.78, -.53, -.02>, < .78, -.50, 0> }
	box { <-.78,  .50, -.02>, < .78,  .53, 0> }
	texture { T_Wood23 }
}

object {
	Planche1
	rotate z*.5
	translate -.4*x + 1.8*y + 6*z
}

//=========================================================================
//=========================================================================
//      CAGES
//=========================================================================
//=========================================================================

box { <-2,0,-1>, <-1.2,0.05,4> texture {T_Montants_Cage} }
box { <-2,.95,-1>, <-1.2,1,4> texture {T_Montants_Cage} }
box { <-2,1.45,-1>, <-1.2,1.50,4> texture {T_Montants_Cage} }
box { <-2,1.95,-1>, <-1.2,2,4> texture {T_Montants_Cage} }
#declare i=-1;
#while (i<=4)
	box { <-2, 0, i-.025>, <-1.202,2,i+.025> texture {T_Montants_Cage} }
	#declare i=i+1;
#end

box { <1.2,0,-1>, <2,0.05,4> texture {T_Montants_Cage} }
box { <1.2,.95,-1>, <2,1,4> texture {T_Montants_Cage} }
box { <1.2,1.45,-1>, <2,1.50,4> texture {T_Montants_Cage} }
box { <1.2,1.95,-1>, <2,2,4> texture {T_Montants_Cage} }
#declare i=-1;
#while (i<=4)
	box { <1.202, 0, i-.025>, <2,2,i+.025> texture {T_Montants_Cage} }
	#declare i=i+1;
#end


//=========================================================================
//      PAILLE
//=========================================================================
#if (Place_Paille)

#include "paille.inc"

#local st_paille = seed(352);

// Paille_mesh(coin1, coin2, nbb, larg, turb, sturb, nbs, st)
#local Paille_m = Paille_mesh(<-.2, 0, -.2>, <.2, .03, .2>, 100, .003, .03, 40, 4, st_paille)


// Paille_tapis(coin1, coin2, nbx, nbz, m_paille, st)
object {
	Paille_tapis(<1.35, 0.05, -0.50>, <1.80, 0.05, 3.90>,8, 20, Paille_m, st_paille)
	texture {T_Paille}
}
object {
	Paille_tapis(<-1.80, 0.05, -0.50>, <-1.35, 0.05, 3.90>,8, 20, Paille_m, st_paille)
	texture {T_Paille}
}

object {
	Paille_tapis(<1.38, 1.00, -0.50>, <1.80, 1.00, 3.90>, 8, 20, Paille_m, st_paille)
	texture {T_Paille}
}
object {
	Paille_tapis(<-1.80, 1.00, -0.50>, <-1.38, 1.00, 3.90>, 8, 20, Paille_m, st_paille)
	texture {T_Paille}
}

object {
	Paille_tapis(<1.38, 1.50,  0.90>, <1.80, 1.50, 3.90>, 8, 15, Paille_m, st_paille)
	texture {T_Paille}
}
object {
	Paille_tapis(<-1.80, 1.50,  0.90>, <-1.38, 1.50, 3.90>, 8, 15, Paille_m, st_paille)
	texture {T_Paille}
}


// et de la paille aussi par terre

object {
	mesh {
	#local i=0;
	#while (i<700)
		#local dep = <-1.18,.001, 0> + <rand(st_paille), rand(st_paille), rand(st_paille)>*<2.36, .001, 4.05>;
		//#debug concat("dep=<",str(dep.x,0,2),", ",str(dep.y,0,3),", ",str(dep.z,0,2),">\n")
		#local dir = vrotate(x*(.05+.20*rand(st_paille)),<0, 3625*rand(st_paille),0>);
		#local fin = dep+dir;
		// Paille_brin(dep, fin, larg, turb, sturb, nbs, st)
		Paille_brin(dep, fin, .01, <.02, .003, .02>, 4, 4, st_paille)
		#local i = i+1;
	#end
	}
	texture { T_Paille }
}

#end

//=========================================================================
//      GRILLES
//=========================================================================
#include "grilles.inc"

#declare Grille1 = Grille(.05, .95, 0.06, 0.94, 4, 8, .004, .004)
#declare Grille2 = Grille(.05, .95, 1.01, 1.44, 5, 5,  .004, .004)
#declare Grille3 = Grille(.05, .95, 1.51, 1.94, 5, 5,  .004, .004)

#declare hautloq1 = .5;
#declare hautloq2 = 1.01 + (1.44-1.01)*3/5;
#declare hautloq3 = 1.51 + (1.94-1.51)*3/5;

#declare Grille_Tordue1 = Grille_Tordue(.05, .95, 0.06, 0.94, 4, 8, .004, .004, <.1, .1, .4>, <1.2,.8,1>)


object {
	Grille_Tordue1
	texture {T_Grille}
	translate -.45*x
	rotate x*76
	translate -.149*y
	rotate y*30
	translate <-.55,0,0.90>
}

#local st=seed(741);


union {
#declare i=0;
#while (i<=4)
	union {
		object {Grille1}
		object {
			#if ((i=1) | (i=4))
			Loquet(off)
			#else
			Loquet(on)
			#end
			scale 2
			translate <.95-2*.022, hautloq1, -.010>
		}
		#if (i=1)
			translate -x*.05
			rotate y*10
			translate x*.05
		#end
		#if (i=4)
			translate -x*.05
			rotate y*20
			translate x*.05
		#end
		/*
		#if (i=3)
			translate -x*.05
			rotate y*40
			translate x*.05
		#end
		*/
		rotate y*90 translate <1.23, 0, i>
	}
	union {
		object {Grille2}
		object{
			#if (i=3)
			Loquet(off)
			#else
			Loquet(on)
			#end
			scale 1.5
			translate <.95-1.5*.022, hautloq2, -.0075>
		}
		#if (i=3)
			translate -x*.05
			rotate y*15
			translate x*.05
		#end
		rotate y*90 translate <1.23, 0, i>
	}
	union {
		object {Grille3}
		object {
			Loquet(on)
			scale 1.5
			translate <.95-1.5*.022, hautloq3, -.0075>
		}
		rotate y*90 translate <1.23, 0, i>
	}
	#declare i=i+1;
#end
	texture { T_Grille }
}

// je ne met que celles qui sont visibles...

union {
#declare i=1;
#while (i<=3)
	#if ((i>2.1) | (i<1.9))
	union {
		object {Grille1}
		object {
			Loquet(on)
			scale 2
			translate <.95-2*.022, hautloq1, -.0010>
		}
		rotate -y*90 translate <-1.23, 0, i>
	}
	#end
	union {
		object {Grille2}
		object{
			#if (i=3)
			Loquet(off)
			#else
			Loquet(on)
			#end
			scale 1.5
			translate <.95-1.5*.022, hautloq2, -.0075>
		}
		#if (i=3)
			translate -x*.05
			rotate y*25
			translate x*.05
		#end
		rotate -y*90 translate <-1.23, 0, i>
	}
	union {
		object {Grille3}
		object {
			Loquet(on)
			scale 1.5
			translate <.95-1.5*.022, hautloq3, -.0075>
		}
		rotate -y*90 translate <-1.23, 0, i>
	}
	#declare i=i+1;
#end
	texture { T_Grille }
}


//=========================================================================
//=========================================================================
//      LE MATERIEL D'EXPERIMENTATION
//=========================================================================
//=========================================================================


//=========================================================================
//      LA TABLE
//=========================================================================

#include "matos.inc"

#declare Tr_Table = transform { rotate -y*30 translate .05*x + 3.5*z }

object { Table
	transform {Tr_Table}
}

//=========================================================================
//      LA PERFUSION
//=========================================================================


#include "poche.inc"

union {
	object { Perf }
	#local haut=(1.645 - .2*1.6)+.01;
	object { Poche_Liquide rotate y*90 scale .2 translate .12*x +  haut*y }
	sphere_sweep {
		catmull_rom_spline_sphere_sweep, 7
		<.12, haut+.05, 0>, .012
		<.12, haut, 0>, .012
		<.10, haut-.3, -.03>, .012
		<.11, haut-.6, .01>, .012
		<.13, haut-.9, -.02>, .012
		<.11, haut-1.2, .05>, .012
		<.12, haut-1.3, .07>, .012
		pigment { rgbf<.95,.95,.95,.8> }
		finish { phong .4 phong_size 30 }
	}
	sphere_sweep {
		catmull_rom_spline_sphere_sweep, 7
		<.12, haut+.05, 0>, .011
		<.12, haut, 0>, .011
		<.10, haut-.3, -.03>, .011
		<.11, haut-.6, .01>, .011
		<.13, haut-.9, -.02>, .011
		<.11, haut-1.2, .05>, .011
		<.12, haut-1.3, .07>, .011
		pigment { rgbf<.95,.85,.45,.9> }
	}
	rotate y*20 translate .7*x + 4.9*z
}

//=========================================================================
//      BORDEL DIVERS
//=========================================================================

#include "flaque.inc"

object { Flaque
	translate .7*x + 4.6*z
}


#include "lunettes.inc"

object { Lunettes
	scale .011
	rotate -70*y
	translate .3*x + .5*z
}

#include "cage.inc"

#declare Tr_Cage = transform { scale .80 rotate y*60 translate .95*x + 1.9*z }

union {
	object { BasCage }
	object { GrillesCage texture {T_Grille} }
	translate .21*z
	rotate -90*x
	translate .1*z
	rotate -atan2(.01-.0015,.2)*x
	transform { Tr_Cage }
}

object {
	HautCage
	scale .80
	rotate -40*y
	translate .4*x + 1.3*z
}

#if (Place_Paille)

#declare spc=seed(3521);
// Paille_mesh(coin1, coin2, nbb, larg, turb, sturb, nbs, st)
#declare m_paille2 = Paille_mesh(<-.1, 0, -.1>, <.1, .02, .1>, 50, .003, .03, 10, 5, spc)

union {
#local i=-.2;
#while (i<.21)
	object { m_paille2 rotate 360*y*rand(spc) translate i*x +.01*y }
	#local i=i+.05;
#end
#local i=-.15;
#while (i<.11)
	object { m_paille2 rotate 360*y*rand(spc) translate i*x -.1*z +.005*y }
	#local i=i+.06;
#end
#local i=-.15;
#while (i<.16)
	object { m_paille2 rotate 360*y*rand(spc) translate i*x -.2*z +.002*y }
	#local i=i+.08;
#end
#local i=-.25;
#while (i<.26)
	object { m_paille2 rotate 360*y*rand(spc) translate i*x -.3*z +.000*y }
	#local i=i+.1;
#end
#local i=-.35;
#while (i<.36)
	object { m_paille2 rotate 360*y*rand(spc) translate i*x -.4*z +.000*y }
	#local i=i+.15;
#end
	texture { T_Paille }
	transform { Tr_Cage }
}

#end

//=========================================================================
//      LE MONITORING
//=========================================================================


//=========================================================================
//      LES CASIERS
//=========================================================================

#include "casiers.inc"

object { Casiers_2
	translate <2, 0, 4.2>
}
object { Casiers_2
	translate <2, 0, 4.62>
}
object { Casiers_2
	translate <2, 0, 5.04>
}


object { Casiers_2
	rotate -90*y
	translate <-1.8, 0, 6.0>
}
object { Casiers_2
	rotate -90*y
	translate <-1.38, 0, 5.97>
}
object { Casiers_1
	rotate -90.5*y
	translate <-0.96, 0, 5.99>
}


//=========================================================================
//      LES DOSSIERS SUR LES CASIERS
//=========================================================================
#include "dossier.inc"

#declare st_d = seed(3621);

object {
	Pile_Dossiers(<.21, .08, .297>, <.23, .08, .32>, .3, 15, st_d)
	translate 1.081*y
	rotate -y*60
	translate -1*x + 5.70*z
}

object {
	Pile_Dossiers(<.21, .08, .297>, <.23, .08, .32>, .3, 15, st_d)
	translate 1.081*y
	rotate -y*90
	translate -1.45*x + 5.60*z
}
/*
object {
	Pile_Dossiers(<.21, .08, .297>, <.23, .08, .32>, .3, 15, st_d)
	translate 1.081*y
	rotate -y*90
	translate -1.9*x + 5.65*z
}
*/

//=========================================================================
//      DES FEUILLES EN VRAC DANS LE CASIER OUVERT
//=========================================================================

#local feuille =  mesh {
	triangle{ 0, x, x+z }
	triangle{ 0, z, x+z }
	pigment { image_map { gif "images/texte2.gif" map_type 0 once } rotate x*90 }
	translate <-.5,0,-.5>
	scale  <.21, 1, .297>
	rotate -y*90
	rotate -x*90
}

#local stf = seed(6521);
#local i=0;
#while (i<5)
	object {
		feuille
		#if (rand(stf)>0.5)
			rotate -(20-40*rand(stf))*z
		#else
			rotate -(120-60*rand(stf))*z
			translate .1*y
		#end
		translate 464*.0012*y -(.85-.001*i)*z
		translate .2*y
		translate <-0.96, 0, 5.99>
	}
	#local i=i+1;
#end

object {
	// Feuilles_Vrac(nbf, taillef, taillev, st)
	Feuilles_Vrac(10, <.21, 1, .297>, <.8, .005, .5>, stf)
	translate <-0.96, .001, 4.80>
}


//=========================================================================
//=========================================================================
//      LE TORTIONNAIRE OU LE SCIENTIFIQUE (suivant les points de vue)
//=========================================================================
//=========================================================================

#if (Place_Scientist)

#debug "Including scientist\n"
#include "scientist3.inc"
#debug "Scientist included\n"

object { Scientist
	rotate -90*y
	translate  2.5*z -1.20*x
}

#end


//=========================================================================
//=========================================================================
//      LES CHIENS PAS CONTENTS...
//=========================================================================
//=========================================================================

#if (Place_Chien_Mechant)

#debug "Including dog\n"
#include "chien1.inc"
#debug "Dog included\n"

object { Chien1
	rotate y*80
	translate  2.6*z - .1*x
}

#end

//=========================================================================
//=========================================================================
//      DES SOURIS ET DES... CHATS
//=========================================================================
//=========================================================================

#if (Use_Chat4)

#debug "Including Cat4\n"
#include "chat4.inc"
#debug "Cat4 included\n"

object { Chat4
	translate - 0.96*x + 464*.0012*y + 4.8*z
}

#end


#if (Use_Chat3)

#debug "Including Cat3\n"
#include "chat3.inc"
#debug "Cat3 included\n"

object { Chat3
	rotate y*20
	translate 1.1*x + 5.4*z
}

#end


#if (Use_Chat2)

#debug "Including Cat2\n"
#include "chat2.inc"
#debug "Cat2 included\n"

object { Chat2
	translate  -.3*z + 0.15*x + 0.70*y
	// transformation de la table
	transform {Tr_Table}
}

#end


#if (Use_Chat1)

#debug "Including Cat1\n"
#include "chat1.inc"
#debug "Cat1 included\n"

object { Chat1
	rotate -80*y
	translate - 1.47*x + 1.0*y + 2.5*z
}

#end


#if (Use_Souris)

#debug "Including mouse\n"
#include "souris.inc"
#debug "Mouse included\n"

object { Souris
	translate  -.4*z + 0.15*x
	// transformation de la table
	transform {Tr_Table}
}
object { Souris
	rotate y*10
	translate  -.43*z + 0.06*x
	// transformation de la table
	transform {Tr_Table}
}
object { Souris
	rotate -y*7
	translate  -.45*z + 0.24*x
	// transformation de la table
	transform {Tr_Table}
}




#end
