

//=========================================================================
//      LA TABLE
//=========================================================================

// roulette haut: .082 unites
#declare Roulette = union {
	union {
		box { <0, 0, -.01>, < .025, .025, .01> }
		intersection {
			cylinder { -.01*z, .01*z, .025 }
			box { <-.026, 0, -.011>, < .001, .026, .011> }
		}
		translate -.004*y
	}
	union {
		cylinder { -.006*z, .006*z, .012 }
		cylinder { -.011*z, .011*z, .002 }
		texture {T_Grille}
	}
	torus { .012, .008 rotate x*90 }
	translate .02*y -.01*x
	scale <2, 2, 1.5>
	texture {T_Plastique_Noir} 
}


//=========================================================================
//      LA TABLE
//=========================================================================


#declare Table = union {
	// top
	box { <-.5, .63, -.3>, <.5, .70, .3> }
	// tablette bas
	box { <-.45, .11, -.25>, <.45, .115, .25> }
	box { <-.45, .11, -.25>, <.45, .14, -.247> }
	box { <-.45, .11,  .25>, <.45, .14,  .247> }
	box { <-.45, .11, -.25>, <-.447, .14, .25> }
	box { < .45, .11, -.25>, < .447, .14, .25> }
	// pieds
	box { <-.45, .082, -.25>, <-.40, .70, -.20> }
	box { <-.45, .082, .20>, <-.40, .70, .25> }
	box { <.40, .082, -.25>, <.45, .70, -.20> }
	box { <.40, .082, .20>, <.45, .70, .25> }
	// roulettes
	object { Roulette rotate -y*30 translate <-.425, 0, -.225> }
	object { Roulette rotate -y*40 translate <.425, 0, -.225> }
	object { Roulette rotate -y*25 translate <-.425, 0, .225> }
	object { Roulette rotate -y*35 translate <.425, 0, .225> }
	texture { T_Grille }
}

//=========================================================================
//      LA PERFUSION
//=========================================================================

#declare Perf = union {
	cylinder { .15*y, 1.8*y, .02 }
	// pied
	union {
		cylinder { .15*y, <0, .082, -.20>, .02 }
		sphere { <0, .082, -.20>, .02 }
	}
	union {
		cylinder { .15*y, <0, .082, -.20>, .02 }
		sphere { <0, .082, -.20>, .02 }
		rotate y*120
	}
	union {
		cylinder { .15*y, <0, .082, -.20>, .02 }
		sphere { <0, .082, -.20>, .02 }
		rotate -y*120
	}
	// roulettes
	object { Roulette translate <0, 0, -.20> }
	object { Roulette translate <0, 0, -.20> rotate y*120 }
	object { Roulette translate <0, 0, -.20> rotate -y*120 }
	// haut
	sphere { 1.80*y, .02 }
	cylinder { 1.80*y, <.12, 1.80, 0>, .02 }
	sphere { <.12, 1.80, 0>, .02 }
	cylinder { 1.72*y, <.08, 1.80,0>, .02 }
	cylinder { <.12, 1.80, 0>, <.12, 1.73, 0>, .02 }
	sphere { <.12, 1.73, 0>, .02 }
	union {
		cylinder { <.12, 1.73, 0>, <.12, 1.68, 0>, .005 }
		sphere { <.12, 1.68, 0>, .005 }
		difference {
			torus { .02, .005 }
			box { <-.026, -.006, 0>, <0, .006, .026> }
			rotate -90*x
			translate <.12, 1.66, 0>
		}
	}
	texture { T_Grille }
}

//=========================================================================
//      DES CARTONS
//=========================================================================

#macro Carton(taille, angmin, angdev, st)
#local long2=.5*taille.x;
#local larg2=.5*taille.z;
#local haut=taille.y;
union {
	intersection {
		box { <-.5, 0, -.5>, <.5, 1, .5> }
		box { <-.49, .01, -.49>, <.49, 1.01, .49> }
		scale taille
	}
	box { <-long2, 0, 0>, <long2, -.01, -larg2> rotate -(angmin + angdev*rand(st))*x translate haut*y - larg2*z }
	box { <-long2, 0, 0>, <long2, -.01, larg2> rotate (angmin + angdev*rand(st))*x translate haut*y + larg2*z }
	box { <-long2, 0, -larg2>, <0, -.01, larg2> rotate (angmin + angdev*rand(st))*z translate haut*y - long2*x }
	box { <0, 0, -larg2>, <long2, -.01, larg2> rotate (angmin + angdev*rand(st))*z translate haut*y + long2*x }
}
#end
