// dmlab.pov

// development switches
#declare Fog = 0;
#declare Glass = 1;
#declare Refract = 1;
#declare TTrack = 1;
#declare BigFlask = 1;
#declare StuffInside = 1;
#declare AreaLights = 1;
#declare WindowGlass = 1;

// Parameters
#declare Light = <1.5, 1.5, 1.5>;
#declare FillLight = <0.3, 0.3, 0.3>;
#declare FogColour = <1.4, 0.7, 0.4>;
#if (Glass)
	#declare GlassTrans = 0.95;
#else
	#declare GlassTrans = 0;
#end
#if (Refract)
	#declare GlassIor = 1.4;
#else
	#declare GlassIor = 1;
#end
#declare scale1 = 20;
#declare angle1 = 25;
#declare seed1 = seed(3942);

// glass texture
#declare T_glass = texture {
	pigment { rgbt <0.97,1,1,GlassTrans> }
	finish {
		reflection 0.05
		phong 0.9
		phong_size 150
	}
}
#declare I_glass = interior {
	ior GlassIor
	caustics 0.7
}

// debug texture
#declare T_debug = texture { pigment { rgb <0,1,0> } }

// includes
#include "testtube.inc"
#include "flask.inc"
#include "table.inc"
#include "beaker.inc"
#include "tripod.inc"
#include "ttholder.inc"
#include "retort.inc"

global_settings {
	max_trace_level 20
}

#declare Camera1 = camera {
	location <0, 0.08, -0.1>*scale1
	look_at <0,0.03,0.1>*scale1
}

#declare Camera2 = camera {
	location <0, 0.15, -0.2>*scale1
	look_at <0,0.07,0>*scale1
}

#declare Camera3 = camera {
	location <0, 0.15, -0.25>
	look_at <0,0.07,0>
}

#declare Camera4 = camera {
	location <0, 0.1, -0.3>
	look_at <0,0.1,0>
	orthographic
}

camera { Camera1
	rotate <0,-angle1,0>
}

// positional constants
#declare roomHeight = 2.5;
#declare floorLevel = -legLength-tableThick-0.0001;
#declare lightHeight = (floorLevel + roomHeight)*scale1;

#declare LightObject = box { <-0.5,-0.010,-0.3>, <0.5,0.01,0.3>
	scale scale1
	texture {
		pigment { rgb <1,1,0.95> }
		finish { ambient 1 }
	}
}

// ***** LIGHTS *****
#if (AreaLights)

	#declare x1 = -4 * scale1;
	#while (x1 <= 4*scale1)
		#declare z1 = -4*scale1;
		#while (z1 <= 2*scale1)
			light_source { <x1, lightHeight, z1>, rgb Light/4
				area_light 1*scale1*x, 0.6*scale1*z, 2, 2
				jitter
				looks_like { LightObject }
			}
			#declare z1 = z1 + 4*scale1;
		#end
		#declare x1 = x1 + 3*scale1;
	#end
#else
	light_source { <-40, 30, -50>, rgb Light
		rotate <0,-angle1,0>
	}
	light_source { <40, 20, -10>, rgb FillLight
		rotate <0,-angle1,0>
		shadowless
	}
#end
// ***** END LIGHTS *****

// ***** OBJECTS *****

#declare winSill = 1.0;
#declare winTop = 1.8;
#declare winStart = -4;
#declare winStop = 4;
#declare winWidth = 0.9;
#declare winSep = 1;

// room
difference {
	box { <-5.1,-0.1,-5.1>, <5.1,roomHeight+0.1,3.1> }
	box { <-5,0,-5>, <5,roomHeight,3> }
	#declare x1 = winStart;
	#while (x1 < winStop)
		box { <x1,winSill,-6>, <x1+winWidth,winTop,4> }
		#declare x1 = x1 + winSep;
	#end
	translate <0,floorLevel,0>
	scale scale1
	hollow
	inverse
	texture {
		pigment { bozo
			colour_map {
				[0.0 rgb <1,0.95,0.9>]
				[0.6 rgb <1,0.95,0.9>]
				[1.0 rgb <0.7,0.7,0.6>]
			}
			turbulence 1
		}
		scale 0.4
		#if (AreaLights)
		finish { diffuse 0.5 }
		#end
	}
}

// windows
#declare T_Pane = texture {
	pigment { rgb <0.6,0.65,0.7> }
	normal { gradient y 0.2
		scale 0.002
	}
	finish { reflection 0.2 }
}
texture {
	pigment { bozo
		colour_map {
			[0.0 rgb <0.7,0.5,0.4>]
			[0.1 rgb <0.8,0.6,0.5>]
			[0.15 rgbt <0.9,0.7,0.6,1>]
			[0.2 rgbt <1,1,1,1>]
			[1.0 rgbt <1,1,1,1>]
		}
		turbulence 0.7
		omega 0.7
		scale <2,5,2>
	}
} // end T_Pane

#declare P_dirt = pigment { crackle
	colour_map {
		[0.0 rgbt <1,1,1,1>]
		[0.1 rgbt <0.3,0.2,0.2,1>]
		[0.3 rgbt <0.3,0.2,0.2,0.3>]
		[1.0 rgbt <0.3,0.2,0.2,0>]
	}
	scale 0.1
	turbulence 0.8
	omega 0.7
}

#declare Pane = union {
	difference {
		box { <0.03,0,0>, <0.87,0.34,0.03> }
		box { <0.06,0.03,-0.1>, <0.84,0.31,0.1> }
	}
	superellipsoid { <0.6,0.6>
		scale <0.04,0.015,0.015>
		translate <0.45,0.33,0>
	}
	superellipsoid { <0.6,0.6>
		scale <0.04,0.015,0.015>
		rotate <0,0,90>
		translate <0.42,0.33,0>
	}
	#if (WindowGlass)
	box { <0.05,0.02,0.01>, <0.85,0.32,0.02>
		texture { T_glass }
		texture {
			pigment { quilted
				pigment_map {
					[0.0 rgbt <1,1,1,1> ]
					//[0.5 rgbt <1,1,1,1> ]
					[0.7 P_dirt translate <rand(seed1)*50,0,0> ]
					[1.0 P_dirt translate <rand(seed1)*50,0,0> ]
				}
				control1 1
				control0 0.5
				translate <0.06,0.03,0.01>
				scale <0.8,0.3,1>
				turbulence 0.2
				omega 0.3
			}
		}
		//interior { I_glass }
	}
	#end
}

#declare x1 = winStart;
#while (x1 < winStop)
	union {
		difference {
			box { <x1,1,3.03>, <x1+0.9,1.8,3.06> }
			box { <x1+0.03,1.03,3>, <x1+0.87,1.37,3.1> }
			box { <x1+0.03,1.4,3>, <x1+0.87,1.77,3.1> }
		}
		#if (WindowGlass)
		box { <x1+0.02,1.39,3.04>, <x1+0.88,1.78,3.05>
			texture { T_glass }
			texture {
				pigment { quilted
					pigment_map {
						[0.0 rgbt <1,1,1,1> ]
						[0.7 P_dirt translate <rand(seed1)*50,0,0> ]
						[1.0 P_dirt translate <rand(seed1)*50,0,0> ]
					}
					control1 1
					control0 0.5
					scale <0.84,0.37,1>
					translate <x1+0.03,1.4,0.04>
					turbulence 0.2
					omega 0.3
				}
			}
			//interior { I_glass }
		}
		#end
		object { Pane
			rotate <-10*floor(rand(seed1)*5),0,0>
			translate <x1,1.03,3.03>
		}
		translate <0,floorLevel,0>
		scale scale1
		texture { T_Pane }
	}
	#declare x1 = x1 + winSep;
#end

// trees outside
box { <0,0,0>, <1,1,0.0001>
	texture {
		pigment {
			image_map { png "tree1.png"
				transmit 255, 1.0
			}
		}
		finish { ambient 0.9 }
	}
	translate <-6,-0.2,5>
	scale 6*scale1
}
box { <0,0,0>, <1,1,0.0001>
	texture {
		pigment {
			image_map { png "tree3.png"
				transmit 255, 1.0
			}
		}
		finish { ambient 0.9 }
	}
	translate <-5,-0.2,5>
	scale 6*scale1
}
box { <0,0,0>, <1,1,0.0001>
	texture {
		pigment {
			image_map { png "tree5.png"
				transmit 255, 1.0
			}
		}
		finish { ambient 0.9 }
	}
	translate <-4,-0.2,5>
	scale 6*scale1
}
box { <0,0,0>, <1,1,0.0001>
	texture {
		pigment {
			image_map { png "tree1.png"
				transmit 255, 1.0
			}
		}
		finish { ambient 0.9 }
	}
	translate <-3,-0.2,5>
	scale 6*scale1
}
box { <0,0,0>, <1,1,0.0001>
	texture {
		pigment {
			image_map { png "tree2.png"
				transmit 255, 1.0
			}
		}
		finish { ambient 0.9 }
	}
	translate <-2,-0.2,5>
	scale 6*scale1
}
box { <0,0,0>, <1,1,0.0001>
	texture {
		pigment {
			image_map { png "tree3.png"
				transmit 255, 1.0
			}
		}
		finish { ambient 0.9 }
	}
	translate <-1,-0.2,5>
	scale 6*scale1
}
box { <0,0,0>, <1,1,0.0001>
	texture {
		pigment {
			image_map { png "tree4.png"
				transmit 255, 1.0
			}
		}
		finish { ambient 0.9 }
	}
	translate <0,-0.2,5>
	scale 6*scale1
}
// trees row 2
box { <0,0,0>, <1,1,0.0001>
	texture {
		pigment {
			image_map { png "tree4.png"
				transmit 255, 1.0
			}
		}
		finish { ambient 0.9 }
	}
	translate <-6,-0.2,7>
	scale 6*scale1
}
box { <0,0,0>, <1,1,0.0001>
	texture {
		pigment {
			image_map { png "tree2.png"
				transmit 255, 1.0
			}
		}
		finish { ambient 0.9 }
	}
	translate <-5,-0.2,7>
	scale 6*scale1
}
box { <0,0,0>, <1,1,0.0001>
	texture {
		pigment {
			image_map { png "tree3.png"
				transmit 255, 1.0
			}
		}
		finish { ambient 0.9 }
	}
	translate <-4,-0.2,7>
	scale 6*scale1
}
box { <0,0,0>, <1,1,0.0001>
	texture {
		pigment {
			image_map { png "tree5.png"
				transmit 255, 1.0
			}
		}
		finish { ambient 0.9 }
	}
	translate <-3,-0.2,7>
	scale 6*scale1
}
box { <0,0,0>, <1,1,0.0001>
	texture {
		pigment {
			image_map { png "tree1.png"
				transmit 255, 1.0
			}
		}
		finish { ambient 0.9 }
	}
	translate <-2,-0.2,7>
	scale 6*scale1
}
box { <0,0,0>, <1,1,0.0001>
	texture {
		pigment {
			image_map { png "tree4.png"
				transmit 255, 1.0
			}
		}
		finish { ambient 0.9 }
	}
	translate <-1,-0.2,7>
	scale 6*scale1
}
box { <0,0,0>, <1,1,0.0001>
	texture {
		pigment {
			image_map { png "tree2.png"
				transmit 255, 1.0
			}
		}
		finish { ambient 0.9 }
	}
	translate <0,-0.2,7>
	scale 6*scale1
}
// trees row 3
box { <0,0,0>, <1,1,0.0001>
	texture {
		pigment {
			image_map { png "tree5.png"
				transmit 255, 1.0
			}
		}
		finish { ambient 0.9 }
	}
	translate <-6,-0.2,9>
	scale 6*scale1
}
box { <0,0,0>, <1,1,0.0001>
	texture {
		pigment {
			image_map { png "tree1.png"
				transmit 255, 1.0
			}
		}
		finish { ambient 0.9 }
	}
	translate <-5,-0.2,9>
	scale 6*scale1
}
box { <0,0,0>, <1,1,0.0001>
	texture {
		pigment {
			image_map { png "tree4.png"
				transmit 255, 1.0
			}
		}
		finish { ambient 0.9 }
	}
	translate <-4,-0.2,9>
	scale 6*scale1
}
box { <0,0,0>, <1,1,0.0001>
	texture {
		pigment {
			image_map { png "tree2.png"
				transmit 255, 1.0
			}
		}
		finish { ambient 0.9 }
	}
	translate <-3,-0.2,9>
	scale 6*scale1
}
box { <0,0,0>, <1,1,0.0001>
	texture {
		pigment {
			image_map { png "tree3.png"
				transmit 255, 1.0
			}
		}
		finish { ambient 0.9 }
	}
	translate <-2,-0.2,9>
	scale 6*scale1
}
box { <0,0,0>, <1,1,0.0001>
	texture {
		pigment {
			image_map { png "tree1.png"
				transmit 255, 1.0
			}
		}
		finish { ambient 0.9 }
	}
	translate <-1,-0.2,9>
	scale 6*scale1
}
box { <0,0,0>, <1,1,0.0001>
	texture {
		pigment {
			image_map { png "tree5.png"
				transmit 255, 1.0
			}
		}
		finish { ambient 0.9 }
	}
	translate <0,-0.2,9>
	scale 6*scale1
}

// the stuff in the room
#declare Stuff = union {
	// ***** SCALE LEVEL 1 *****
	// Objects at this scale  are scaled up by scale1
	// The tabletop is at 0 height

	// table1 - big table
	object { Table
		translate <0,floorLevel,0>
		scale scale1
	}
	
	// flask 1 on table1
	#if (BigFlask)
		object { ConicalFlask
			scale scale1
		}
	#end
	
	// test tubes on table1
	#if (TTrack)
		object { Rack
			rotate <0,30,0>
			translate <-0.18,0,0.35>
			scale scale1
			rotate <0,-angle1,0>
		}
	#end // if (TTrack)
	
	// beaker on table1
	object { Beaker
		translate <-0.12,0,0.05>
		scale scale1
		rotate <0,-angle1,0>
	}
	
	// tripod on table1
	object { Tripod
		translate <0.3,0,0>
		scale scale1
		rotate <0,2*angle1,0>
	}
	// beaker on tripod on table1
	object { Beaker
		translate <0.3,tripodHeight,0>
		scale scale1
		rotate <0,2*angle1,0>
	}
	// beaker liquid on tripod on table1
	object { BeakerLiquid
		translate <0.3,tripodHeight,0>
		scale scale1
		rotate <0,2*angle1,0>
	}

	// test tube holder on table1
	object { TTholder
		translate <-0.3,0,-0.5>
		scale scale1
		rotate <0,2*angle1,0>
	}

	// retort stand on table1
	object { Retort
		translate <0.1,0,-0.5>
		scale scale1
		rotate <0,2*angle1,0>
	}

	#if (StuffInside)
		// ***** SCALE LEVEL 2 *****
		// Objects at this scale do not require scaling
		// The tabletop is at height tableTop2
		
		#declare tableTop2 = scale1*flaskThick+legLength+tableThick+0.00001;
		
		// table2 inside flask1
		object { Table
			rotate <0,-2*angle1,0>
			translate <0,scale1*flaskThick,0>
		}
		
		// flask2 on table2
		object { ConicalFlask
			translate <0,tableTop2,0>
		}
		
		// test tubes on table2
		#if (TTrack)
			object { Rack
				rotate <0,30,0>
				translate <-0.18,tableTop2,0.35>
				rotate <0,-3*angle1,0>
			}
		#end // if (TTrack)
		
		// beaker on table2
		object { Beaker
			translate <-0.12,tableTop2,0.05>
			rotate <0,-3*angle1,0>
		}
		
		// tripod on table2
		object { Tripod
			translate <0.3,tableTop2,0>
		}
		// beaker on tripod on table2
		object { Beaker
			translate <0.3,tableTop2+tripodHeight,0>
		}
		// beaker liquid on tripod on table2
		object { BeakerLiquid
			translate <0.3,tableTop2+tripodHeight,0>
		}

		// test tube holder on table2
		object { TTholder
			translate <-0.3,tableTop2,-0.5>
		}

		// retort stand on table2
		object { Retort
			translate <0.1,tableTop2,-0.5>
		}

		// ***** SCALE LEVEL 3 *****
		// Objects at this scale are scaled down by scale1

		#declare tableTop3 = tableTop2+flaskThick+(legLength+tableThick)/scale1+0.00001;

		// table3 inside flask2
		object { Table
			scale 1/scale1
			rotate <0,-4*angle1,0>
			translate <0,tableTop2+flaskThick,0>
		}

		// beaker on table3
		object { Beaker
			translate <-0.12,0,0.05>
			scale 1/scale1
			translate <0,tableTop3,0>
			rotate <0,-5*angle1,0>
		}
		
		// retort stand on table3
		object { Retort
		//sphere { <0,0,0>, 0.1 texture {T_debug}}
			translate <0.1,0,-0.5>
			scale 1/scale1
			translate <0,tableTop3,0>
			rotate <0,-2*angle1,0>
		}

	#end // ***** if (StuffInside) *****
}

object { Stuff }

object { Stuff
	translate <0,0,2*scale1>
}

sky_sphere {
	pigment { gradient y
		colour_map {
			[0.0 rgb <0.7,0.8,1>]
			[0.5 rgb <0.7,0.8,1>]
			[0.6 rgb <0.3,0.5,0.8>]
			[1.0 rgb <0.3,0.4,0.8>]
		}
		scale 2
		translate <0,-1,0>
	}
}

// simple cloud plane
plane { y, 100
	hollow
	texture {
		pigment { bozo
			colour_map {
				[0.0 rgbt <1,1,1,1>]
				[0.6 rgbt <1,1,1,1>]
				[0.7 rgbf <1,0.9,0.8,0.5>]
				[1.0 rgbf <1,1,1,0>]
			}
			turbulence 0.5
			omega 0.2
			scale 200
		}
		finish {
			ambient 0.9
		}
	}
}

#if (Fog)
// fog layer
fog {
	fog_type 2
	rgb FogColour
	distance 3000
	fog_offset 30
	fog_alt 20
}
#end
