// testtube.inc

#declare SeedTube = seed(73823);

#local rad = 0.008;
#local thick = 0.001;
#local length = 0.12;

#macro TestTube()
union {
	merge {
		difference {
			sphere { <0,rad,0>, rad }
			sphere { <0,rad,0>, rad-thick }
			plane { -y, -rad }
		}
		difference {
			cylinder { <0,rad-0.00001,0>, <0,rad+length,0>, rad }
			cylinder { <0,0,0>, <0,rad+length+1,0>, rad-thick }
		}
		torus { rad, thick
			translate <0,rad+length,0>
		}
		// glass texture
		texture { T_glass }
		interior { I_glass }
	}
	// liquid
	#if (rand(SeedTube) > 0.3)
		merge {
			sphere { <0,rad,0>, rad-thick-0.0001 }
			cylinder { <0,rad-thick,0>, <0,rad+rand(SeedTube)*length,0>, rad-thick-0.0001 }
			texture {
				pigment { rgbf <rand(SeedTube),rand(SeedTube),rand(SeedTube),0.95> }
			}
			interior {
				ior 1.33
				caustics 0.7
			}
		}
	#else
		sphere { <0,0,0>, 0
			texture { pigment { rgbt <1,1,1,1> } }
		}
	#end
}
#end

#local rwidth = 0.04;
#local rlength = 0.2;
#local rheight = 0.1;
#local rthick = 0.005;
#local rw = rwidth / 2;
#local rl = rlength / 2;
#local holepad = 0.002;
#local holespacing = 0.03;
#local dentrad = 0.015;

#local T_rack = texture {
	pigment { wood
		colour_map {
			[0.0 rgb <1,0.7,0.4> ]
			[0.8 rgb <0.9,0.7,0.3> ]
			[1.0 rgb <0.6,0.2,0.1> ]
		}
		turbulence 0.1
		scale 0.01
	}
}

#declare Rack = union {
	// the wooden rack
	difference {
		box { <-rl,0,-rw>, <rl,rthick,rw> }
		#local x1 = holespacing/2;
		#while (x1 < rl)
			sphere { <x1,dentrad+thick/2,0>, dentrad }
			sphere { <-x1,dentrad+thick/2,0>, dentrad }
			#local x1 = x1 + holespacing;
		#end
		texture { T_rack
			rotate <3,90,2>
		}
	}
	difference {
		box { <-rl,rheight,-rw>, <rl,rheight+rthick,rw> }
		#local x1 = holespacing/2;
		#while (x1 < rl)
			cylinder { <x1,0,0>, <x1,rheight+rthick+0.1,0>, rad+thick+holepad }
			cylinder { <-x1,0,0>, <-x1,rheight+rthick+0.1,0>, rad+thick+holepad }
			#local x1 = x1 + holespacing;
		#end
		texture { T_rack
			rotate <-3,90,4>
		}
	}
	box { <-rl,rthick,-rw>, <-rl+rthick,rheight,rw>
		texture { T_rack
			rotate <90,-2,4>
		}
	}
	box { <rl,rthick,-rw>, <rl-rthick,rheight,rw>
		texture { T_rack
			rotate <90,4,-2>
		}
	}
	
	// the test tubes
	#local x1 = holespacing/2;
	#while (x1 < rl)
		object { TestTube()
			rotate <1.5,rand(SeedTube)*360,0>
			translate <x1,thick/2,0>
		}
		object { TestTube()
			rotate <1.5,rand(SeedTube)*360,0>
			translate <-x1,thick/2,0>
		}
		#local x1 = x1 + holespacing;
	#end
}