// tripod.inc

#local length = 0.14;
#local inlength = 0.11;
#local thick = 0.006;
#local legheight = 0.20;
#local legradius = 0.004;
#local meshradius = 0.0005;
#local meshsize = 0.16;
#local meshgap = 0.006;
#local meshheight = legheight + thick + meshradius;
#declare tripodHeight = legheight + thick + 2*meshradius + 0.00001;

#local x1 = length / 2;
#local z1 = -x1 * tan(radians(30));
#local z2 = x1 / cos(radians(30));
#local x10 = inlength / 2;
#local z10 = -x10 * tan(radians(30));
#local z20 = x10 / cos(radians(30));

#declare Tripod = union {
	// triangular top
	prism {
		linear_spline
		linear_sweep
		legheight, legheight+thick, 8
		<-x1, z1>, <x1, z1>, <0, z2>, <-x1, z1>,
		<-x10, z10>, <x10, z10>, <0, z20>, <-x10, z10>
	}
	// legs
	#local r = 0;
	#while (r < 360)
		cylinder { <0,legheight,(z2+z20)/2>, <0,0,z2*1.1>, legradius
			rotate <0,r,0>
		}
		#local r = r + 120;
	#end
	// mesh
	union {
		#local x1 = -meshsize/2;
		#local y1 = -meshsize/2;
		#while (x1 <= meshsize/2)
			cylinder { <x1,meshheight,-y1>, <x1,meshheight,y1>, meshradius }
			cylinder { <x1,meshheight,-y1>, <x1,meshheight,y1>, meshradius rotate <0,90,0> }
			#local x1 = x1 + meshgap;
		#end
	}
	// texture
	texture {
		pigment { rgb <0.3,0.4,0.4>
		}
		finish {
			phong 0.8
			phong_size 100
		}
	}
	texture {
		pigment { wood
			colour_map {
				[0.0 rgbt <1,1,1,1>]
				[0.8 rgbt <1,1,1,1>]
				[0.9 rgbt <1,0.5,0.4,0.5>]
				[1.0 rgb <0.8,0.4,0.3>]
			}
			turbulence 0.9
			omega 0.2
			scale <0.01,0.03,0.01>
		}
	}
}