//LABORATORY TABLE
//by Dan S Allsop
//panthus@xtra.co.nz   
//for POV-Ray competition September-October 2000: 'Laboratory'.
//******************************************************************************************
//										    ELEMENTS
//******************************************************************************************
#declare Room_Switch=		on;	#declare Cobweb_Switch=		on;     
#declare Scrolls_Switch=	on;	#declare Dice_Switch=		on;
#declare Morphus_Switch=	on;	#declare Shelf_Switch=		on;
#declare Table_Switch=		on;	#declare Caddy_Switch=		on;
#declare Mug_Switch=		on;	#declare Lamp_Switch=		on;
#declare TubeRack_Switch=	on;	#declare TestTubes_Switch=	on;	
#declare Bottles_Switch=	on;	#declare Scales_Switch=		on;
#declare Hourglass_Switch=	on;	#declare Book_Switch=		on;
#declare BookPages_Switch=	on;	#declare PinceNez_Switch=	on; 
#declare Weights_Switch=	on;	#declare SpoonSpatula_Switch=	on;
#declare Microscope_Switch=	on;	#declare Vial_Switch=		on;
#declare Slides_Switch=		on;	#declare Pottle_Switch=		on;
#declare Pencil_Switch=		on;	#declare Pestle_Switch=		on;
#declare LampLight_Switch=	on;	#declare MoonLight_Switch=	on;
//******************************************************************************************
//										      PAINTS
//******************************************************************************************
#declare RoomTex = texture { 
        pigment { rgb <0.6, 0.6, 0.6> }
        normal { granite 1 scale 1 }
}
#declare RoomRoofTex = texture { 
        pigment { rgb <0.6, 0.6, 0.7> }
        finish { specular 1 roughness 0.01 }
        normal { checker 1 scale 2 }
}
#declare CobwebTex = texture {
	pigment { rgb 0.7 }
	finish { specular 0.6 roughness 0.001 ambient 0.3 }
}
#declare ScrollTex = texture {
        pigment { gradient z color_map { [ 0.0 rgb <0.9, 0.9, 0.7> ]  
        	[ 0.5 rgb <0.4, 0.4, 0.2> ] [ 0.0 rgb <0.9, 0.9, 0.7> ] } 
        	scale 20 turbulence 1 }
        finish { specular 0.4 roughness 0.4 }
}
#declare RibbonTex = texture {
        pigment { rgb <0.9, 0.1, 0.1> } 
        finish { specular 0.8 roughness 0.2 }
}
#declare DiceTex = texture {
	pigment { rgb 1 }
	finish { specular 0.7 roughness 0.01 }
}
#declare DiceHoleTex = texture {
	pigment { rgb 0 }
	finish { specular 0.7 roughness 0.01 }
}
#declare MorphusJuiceTex = texture {
	pigment { gradient y color_map { [ 0.0 rgbf <0.6, 0.5, 0.45, 0.7> ] 
		[ 0.5 rgbf <0.9, 0.9, 0.9, 0.5> ] [ 1.0 rgbf <0.6, 0.5, 0.45, 0.7> ] } 
		scale 1 turbulence 1 }
	finish { specular 0.2 roughness 0.01 reflection 0.1 ambient 0.2 }
}
#declare MorphusTex = texture {
	pigment { rgb <0.6, 0.5, 0.45> }
	finish { specular 1 roughness 0.7 ambient 0.5 }
	normal { radial 1 frequency 10 turbulence 1 }
}
#declare MorphusFlaskTex = texture {
        pigment { rgbf <1, 1, 1, 0.7> }
        finish { specular 0.6 roughness 0.001 reflection 0.2 }
}
#declare Wood=seed(43876);
#declare TopTableTex = texture { 
        pigment { gradient z color_map { 
        	[ 0.5 rgb <0.6, 0.45, 0.3> ] [ 0.5 rgb <0.7, 0.5, 0.35> ] } scale 0.01
	        #declare WoodWarps=0;
        	#while (WoodWarps<500)
			warp { black_hole <(rand(Wood)*30)-15, 0, (rand(Wood)*20)-5>,
				rand(Wood)+1 falloff 5 strength 1 }
			#declare WoodWarps=WoodWarps+1;
		#end
	}
        normal { gradient z 0.01 scale 0.05 turbulence 0.5 }
        finish { specular 0.8 roughness 0.01 reflection 0.1 }
}
#declare FrontTableTex = texture { 
        pigment { gradient y color_map { 
        	[ 0.5 rgb <0.6, 0.45, 0.3> ] [ 0.5 rgb <0.7, 0.5, 0.35> ] } scale 0.01
	        #declare WoodWarps=0;
        	#while (WoodWarps<500)
			warp { black_hole <(rand(Wood)*30)-15, rand(Wood)*7, 0>,
				rand(Wood)+1 falloff 5 strength 1 }
			#declare WoodWarps=WoodWarps+1;
		#end
	}
        normal { gradient y 0.01 scale 0.05 turbulence 0.5 }
        finish { specular 0.8 roughness 0.01 reflection 0.1 }
}
#declare SideTableTex = texture { 
        pigment { gradient y color_map { 
        	[ 0.5 rgb <0.6, 0.45, 0.3> ] [ 0.5 rgb <0.7, 0.5, 0.35> ] } scale 0.01
	        #declare WoodWarps=0;
        	#while (WoodWarps<500)
			warp { black_hole <0, rand(Wood)*7, (rand(Wood)*20)-5>,
				rand(Wood)+1 falloff 5 strength 1 }
			#declare WoodWarps=WoodWarps+1;
		#end
	}
        normal { gradient y 0.01 scale 0.05 turbulence 0.5 }
        finish { specular 0.8 roughness 0.01 reflection 0.1 }
}
#declare Stain1TableTex = texture {
	pigment { leopard color_map { [ 0.2 rgbf 1 ] [ 0.8 rgb <0.2, 0.5, 0.2> ] }
		scale 2 turbulence 1 }
}
#declare Stain2TableTex = texture {
	pigment { leopard color_map { [ 0.2 rgbf 1 ] [ 0.8 rgb <0.5, 0.2, 0.2> ] }
		scale 2 turbulence 1 translate <30, 0, 0> }
}
#declare MetalTex = texture {
        pigment { rgb 0.7 }
        finish { metallic ambient 0.15
        	brilliance 6 specular 1 roughness 0.001 reflection 0.1 } 
}
#declare GoldenTex = texture {
        pigment { rgb <0.95, 0.85, 0.1> } 
        finish { metallic ambient 0.15 brilliance 6 
        	reflection 0.15 specular 1 roughness 0.0001 } 
}
#declare DrawerPearlTex = texture {
        pigment { gradient x color_map { [ 0.5 rgb <1, 0.975, 0.925> ] 
        	[ 0.5 rgb <0.9, 0.9, 1> ] [ 0.75 rgb <1, 0.9, 0.9> ] 
        	[ 1.0 rgb <0.9, 1, 0.9> ] } scale 0.05 turbulence 1 }
        finish { specular 0.2 roughness 0.001 reflection 0.2 } 
}
#declare CaddyTex = texture {
	pigment { radial color_map { [ 0.0 rgb <0.2, 0.1, 0.0> ] 
		[ 0.95 rgb <0.4, 0.4, 0.1> ] [ 0.95 rgb 0.8 ] } 
		frequency 40 turbulence 0.7 } 
	finish { specular 0.2 roughness 0.4 }
}
#declare MugTex = 
	texture { 
        	pigment { rgb <0.9, 0.9, 0.85> }
        	finish { ambient 0.3 specular 0.8 roughness 0.01 }
        	normal { radial 0.01 frequency 20 turbulence 0.2 }
	}
	texture {
	        pigment { gradient y color_map { [ 0.6 rgbf 1 ]
	        [ 0.65 rgbf <0.8, 0.6, 0.4, 0.5> ] } scale 3 turbulence 0.5 }     	
}
#declare LampTex = texture { 
        pigment { rgb <0.9, 0.8, 0.2> }
        finish { metallic ambient 0.15 brilliance 2 
        	specular 0.8 roughness 0.01 reflection 0.1 }
}
#declare LampCoverTex = texture { 
        pigment { gradient y color_map { [ 0.0 rgbf <1, 1, 1, 0.6> ] 
        	[ 0.3 rgbf <1, 1, 1, 0.8> ] [ 1.0 rgbf 0.4 ] }
        	scale 8.5 turbulence 0.6 }
        finish { specular 0.3 roughness 0.001 reflection 0.2 }
}
#declare LampBurntTex = texture { 
        pigment { gradient y color_map { [ 0.0 rgb <0.9, 0.8, 0.2> ] 
        	[ 1.0 rgb 0 ] } scale 0.7 turbulence 0.5 translate <0, 3.3, 0> }
        finish { metallic ambient 0.15 brilliance 2 
        	specular 0.8 roughness 0.01 reflection 0.1 }
}
#declare WickTex = texture { 
        pigment { gradient y color_map { [ 0.5 rgb <0.9, 0.9, 0.7> ] [ 1.0 rgb 0 ] }
        	turbulence 0.4 translate <0, 3.3, 0> }
        normal { quilted 1 scale <1, 2, 1> scale 0.1 }
}
#declare LampFlameTex = texture { 
        pigment { onion color_map { [ 0.375 rgbft 1 ] [ 0.45 rgbft <0.5, 0.7, 1, 0.9, 0.9> ]
        	[ 0.5 rgbft <1, 1, 0, 0.75, 0.75> ] [ 0.7 rgbft <1, 1, 1, 0.6, 0.6> ] } 
        	rotate <90, 0, 0> scale <3, 5, 3> turbulence 0.1 }
	finish { specular 1 roughness 0.0001 ambient 0.5 }
}
#declare TestTubeTex = texture { 
        pigment { rgbf 0.9 }
        finish { specular 0.5 roughness 0.02 reflection 0.2 }
        normal { radial 0.01 frequency 8 }
}
#declare BottleTex = texture { 
        pigment { rgbf <0.95, 0.95, 1, 0.7> }
        finish { specular 0.6 roughness 0.01 reflection 0.2 }
        normal { radial 0.01 frequency 50 }
}
#declare BottleContentsTex = texture { 
	pigment { rgb 0.9 }
	finish { specular 0.2 roughness 0.2 ambient 0.3 }
}
#declare ScalesTex = texture {
        pigment { rgb <1.0, 0.8, 0.2> }
        finish { metallic ambient 0.15 brilliance 2 
        	specular 0.8 roughness 0.01 reflection 0.1 }
        normal { onion 0.025 scale 0.2 rotate <90, 0, 0> }
}
#declare ScalesChainTex = texture {
        pigment { rgb <1.0, 0.8, 0.2> }
        finish { metallic ambient 0.15 brilliance 2 
        	specular 0.8 roughness 0.01 reflection 0.1 }
}
#declare ScalesDishTex = texture {
        pigment { rgb <1.0, 0.8, 0.2> }
        finish { metallic ambient 0.15 brilliance 2 
        	specular 0.8 roughness 0.01 reflection 0.1 }
        normal { onion 0.025 scale 0.15 }
}
#declare ScalesWoodTex = texture {
        pigment { gradient z color_map { [ 0.5 rgb <0.3, 0.15, 0.0> ] 
        	[ 0.5 rgb <0.4, 0.3, 0.1> ] } scale 0.2 turbulence 0.4 }
        finish { specular 0.9 roughness 0.01 reflection 0.2 }
}
#declare ScalesGrainTex = texture {
        pigment { rgb 0.9 }
        finish { specular 0.2 roughness 0.8 }
        normal { granite 0.5 scale 0.05 }
}
#declare HourglassWoodTex = texture { 
        pigment { rgb <0.7, 0.55, 0.4> }
        finish { specular 0.5 roughness 0.01 }
}
#declare HourglassGrainTex = texture { 
        pigment { rgb 1 }
        finish { specular 0.2 roughness 0.8 ambient 0.3 }
        normal { granite 0.1 scale 0.1 }
}
#declare BookCoverTex = texture { 
        pigment { rgb <0.4, 0, 0.05> }
        finish { specular 0.2 roughness 0.1 }
        normal { gradient x 0.05 scale 0.05 }
}
#declare WeightLensTex = texture { 
	pigment { rgbf <1, 1, 1, 0.7> }
	finish { specular 1 roughness 0.001 reflection 0.3 }
}
#declare PinceNezLensTex = texture { 
        pigment { rgbf <1, 1, 1, 0.8> }
        finish { specular 0.9 roughness 0.001 reflection 0.2 }
}
#declare PinceNezFrameTex = texture { 
        pigment { rgb <0.6, 0.4, 0.0> }
        finish { metallic ambient 0.15 brilliance 2 
        	specular 0.8 roughness 0.01 reflection 0.1 }
}
#declare SpoonSpatulaTex = texture {
       	pigment { rgb 0.7 }
       	finish { metallic ambient 0.15 brilliance 2 specular 1 
       		roughness 0.001 reflection 0.1 }
}
#declare MicroscopeMetalTex = texture {
        pigment { rgb 0.4 } 
        finish { metallic brilliance 3 specular 1.0 roughness 0.01 reflection 0.1 
        	ambient 0.15 }
}
#declare MicroscopeMirrorTex = texture {
        pigment { rgb 0.9 }
        finish { specular 0.2 roughness 0.1 reflection 1.0 }
}
#declare FrostedSlideTex = texture {
        pigment { rgbf <0.9, 0.9, 0.9, 0.7> }
        normal { bumps 0.05 scale 0.025 }
        finish { specular 0.9 roughness 0.01 reflection 0.2 }
}
#declare SlideTex = texture {
        pigment { rgbf 0.9 }
        finish { specular 0.9 roughness 0.01 reflection 0.2 }
}
#declare SlideSmudge1Tex = texture {
	pigment { rgbf <1, 0.7, 1, 0.5> }
	finish { specular 0.7 roughness 0.001 ambient 0.2 }
}
#declare SlideSmudge2Tex = texture {
	pigment { rgbf <0.7, 0.7, 1, 0.5> }
	finish { specular 0.7 roughness 0.001 ambient 0.2 }
}
#declare PottleTex = texture {
	pigment { rgbf <0.6, 0.6, 1.0, 0.6> }
	finish { specular 1 roughness 0.001 reflection 0.2 }
}
#declare PottleTopTex = texture {
	pigment { rgb 0.1 } 
	finish { specular 0.2 roughness 0.8 }
}
#declare PencilTex = texture {
	pigment { rgb <0.8, 0.5, 0.4> }
	normal { radial 0.01 frequency 15 turbulence 0.2 }
}
#declare PencilLeadTex = texture {
	pigment { rgb 0.1 }
	finish { specular 0.2 roughness 0.1 ambient 0.4 }
}
#declare PencilCutTex = texture {
	pigment { rgb <1, 0.8, 0.6> }
	normal { checker 0.05 scale <0.1, 0.3, 0.1> }
}
#declare PestleTex = texture {
        pigment { agate color_map { [ 0.0 rgb <0.8, 0.8, 0.7> ] 
        	[ 0.9 rgb <0.75, 0.75, 0.65> ] [ 0.95 rgb <0.7, 0.75, 0.6> ] 
        	[ 1.0 rgb <0.65, 0.75, 0.55> ] } scale 0.2 }
        finish { specular 0.3 roughness 0.5 ambient 0.15 }
        normal { gradient y 0.01 scale 0.1 }
}
//******************************************************************************************
//											ROOM
//******************************************************************************************
#if(Room_Switch=on)
#declare RoomWindow = union {
	intersection {
		cylinder { <1, 0, 0>, <1, 0, 2>, 2 }
		cylinder { <-1, 0, -1>, <-1, 0, 3>, 2 }
	}
	box { <-1, -2, 0>, <1, 0, 2> }
	scale 3 translate <0, 14, 0>
}	
#declare Chair = union {
	box { <-3, 2, 0>, <3, 6, 1> }
	box { <-3.5, -5, -0.5>, <-3, 7, 1> }
	box { <3, -5, -0.5>, <3.5, 7, 1> }      
	scale 1.2
	texture { FrontTableTex }
}
#declare Wall=seed(85437);
#declare WindowPlace=seed(43875);
#declare Room = union {
	height_field { gif "wall.gif" smooth 
        	pigment { gradient y color_map { [ 0.0 rgb 0.3 ] [ 1.0 rgb 0.5 ] } }
        	finish { specular 0.2 roughness 0.01 }
        	scale <30, 0.4, 15> rotate <-90, 0, 0>
        	translate <-15, 0, 15> 
	}
	difference {
		cylinder { <0, -11, 0>, <0, 20, 0>, 31 }
		cylinder { <0, -10, 0>, <0, 21, 0>, 30 } 
		#declare WindowCount=0;
		#while (WindowCount<6)
			#declare WindowRotate=rand(WindowPlace)*20+(WindowCount*30)+90;
			object { RoomWindow translate <0, 0, 29> 
				rotate <0, WindowRotate, 0> }
				#if(WindowCount=2)
					#declare LightRotate=WindowRotate;
				#end
			#declare WindowCount=WindowCount+1;
		#end
		texture { RoomTex }
	}
	#if(MoonLight_Switch=on)
		light_source { <0.9, 21.5, 40> color rgb 1 
			area_light <0.2, 0, 0>, <0, 0.2, 0>, 4, 4 adaptive 1 jitter
			looks_like { sphere { <0.1, 0.1, 0>, 1 
				pigment { rgb 1 } } }
			rotate <0, LightRotate, 0>
		}
	#else
		light_source { <1, 21.5, 40> color rgb 1 rotate <0, LightRotate, 0> }
	#end
	difference {
		cone { <0, 20, 0>, 31, <0, 36, 0>, 0 }
		cone { <0, 19.9, 0>, 30, <0, 35, 0>, 0 }
		texture { RoomRoofTex }
	}
	object { Chair rotate <0, 180, 0> translate <0, -3, -16> }
}
#end
//******************************************************************************************
//										      COBWEB
//******************************************************************************************
#if(Cobweb_Switch=on)
#declare Strand=seed(43287);
#declare Cobweb = merge {
	#declare Strand_X=0;
	#declare Strand_Y=0;
	#declare Strand_Z=0;
	#declare StrandCount=0;
	#while(StrandCount<150)
		cylinder { <Strand_X, Strand_Y, Strand_Z>,
			#declare Strand_X_New=Strand_X+((rand(Strand)*3)-1.5);
			#while(Strand_X_New<-5|Strand_X_New>0)
				#declare Strand_X_New=Strand_X+((rand(Strand)*3)-1.5);
			#end
			#declare Strand_Y_New=Strand_Y+((rand(Strand)*3)-1.5);
			#while(Strand_Y_New<-5|Strand_Y_New>0|Strand_Y_New>Strand_X_New)
				#declare Strand_Y_New=Strand_Y+((rand(Strand)*3)-1.5);
			#end
			#declare Strand_Z_New=Strand_Z+((rand(Strand)*3)-1.5);
			#while(Strand_Z_New<-5|Strand_Z_New>0|Strand_Z_New>Strand_X_New)
				#declare Strand_Z_New=Strand_Z+((rand(Strand)*3)-1.5);
			#end
			#declare Strand_X=Strand_X_New;
			#declare Strand_Y=Strand_Y_New;
			#declare Strand_Z=Strand_Z_New;
                	<Strand_X, Strand_Y, Strand_Z>, 0.005 
		}
		#declare StrandCount=StrandCount+1;
	#end
	rotate <0, 0, 90> rotate <0, -90, 0> translate <-5, 0, -5>
	texture { CobwebTex }
	scale <1.5, 1, 1> 
}
#end		
//******************************************************************************************
//										 SCROLL CASE
//******************************************************************************************
#if(Scrolls_Switch=on)
#declare ScrollCut=seed(54354);
#macro ScrollMake (ScrollWidth, ScrollCentreWidth, ScrollLength)
#declare ScrollMove=ScrollWidth;
#declare ScrollCount=1;
#declare Scroll = difference {
	union {
		intersection {
			prism { linear_sweep cubic_spline 0, ScrollLength, 
				((ScrollWidth-1)*16)+4, <0, 0>, <0, 0>, 
				#while(ScrollCount<ScrollWidth)
					<ScrollCount/5, 0>, 
						#declare ScrollCount=ScrollCount+0.125;
					<(ScrollCount/5)/1.4, (ScrollCount/5)/1.4>, 
						#declare ScrollCount=ScrollCount+0.125;
					<0, ScrollCount/5>, 
						#declare ScrollCount=ScrollCount+0.125;
					<-((ScrollCount/5)/1.4), (ScrollCount/5)/1.4>, 
						#declare ScrollCount=ScrollCount+0.125;
					<-(ScrollCount/5), 0>, 
						#declare ScrollCount=ScrollCount+0.125;
					<-((ScrollCount/5)/1.4), -((ScrollCount/5)/1.4)>, 
						#declare ScrollCount=ScrollCount+0.125;
					<0, -(ScrollCount/5)>, 
						#declare ScrollCount=ScrollCount+0.125;
					<(ScrollCount/5)/1.4, -((ScrollCount/5)/1.4)>,
						#declare ScrollCount=ScrollCount+0.125;
				#end
				#declare ScrollCount=ScrollCount-0.75;
				#while(ScrollCount>0.25)
					<(ScrollCount/5)/1.4, -((ScrollCount/5)/1.4)>,
						#declare ScrollCount=ScrollCount-0.125;
					<0, -(ScrollCount/5)>, 
						#declare ScrollCount=ScrollCount-0.125;
					<-((ScrollCount/5)/1.4), -((ScrollCount/5)/1.4)>,
						#declare ScrollCount=ScrollCount-0.125;
					<-(ScrollCount/5), 0>,                     
						#declare ScrollCount=ScrollCount-0.125;
					<-((ScrollCount/5)/1.4), (ScrollCount/5)/1.4>,
						#declare ScrollCount=ScrollCount-0.125;
					<0, ScrollCount/5>, 
						#declare ScrollCount=ScrollCount-0.125;
					<(ScrollCount/5)/1.4, (ScrollCount/5)/1.4>, 
						#declare ScrollCount=ScrollCount-0.125;
					<ScrollCount/5, 0>, 
						#declare ScrollCount=ScrollCount-0.125;
				#end
				<0, 0>, <0, 0> sturm
			}
			lathe { linear_spline 49, <-1, 0>, <0, 0>, 
				#declare ScrollCutCount=0;
				#declare ScrollCut_X=0;
				#declare ScrollCut_Y=0;
				#while(ScrollCutCount<20)
				  	#declare ScrollCut_X=((rand(ScrollCut)
				  		*(ScrollWidth/5))/10)+ScrollCut_X;
		  			#declare ScrollCut_Y=((rand(ScrollCut)-0.5)
		  				*(ScrollLength/20));
					<ScrollCut_X, 0.5-ScrollCut_Y>		  	
			  		#declare ScrollCutCount=ScrollCutCount+1;
				#end
				<(ScrollWidth/5)+(ScrollWidth/20), 0>, 
				<(ScrollWidth/5)/1.25, (ScrollLength/10)*2>, 
				<(ScrollWidth/5)/1.5, (ScrollLength/10)*5>, 
				<(ScrollWidth/5)/1.25, (ScrollLength/10)*8>, 
				<(ScrollWidth/5)+(ScrollWidth/20), ScrollLength>,
				#declare ScrollCutCount=0;
				#declare ScrollCut_X=0;
				#declare ScrollCut_Y=0;
				#while(ScrollCutCount<20)
			  		#declare ScrollCut_X=((rand(ScrollCut)
			  			*(ScrollWidth/5))/10)+ScrollCut_X;
			  		#if(ScrollCut_X>(ScrollWidth/5))
			  			#declare ScrollCut_X=(ScrollWidth/5);
			  		#end
			  		#declare ScrollCut_Y=((rand(ScrollCut)-0.5)
			  			*(ScrollLength/20));
					<(ScrollWidth/5)-ScrollCut_X, 
						ScrollLength-ScrollCut_Y>		  	
			  		#declare ScrollCutCount=ScrollCutCount+1;
				#end
				<0, ScrollLength>, <-1, ScrollLength> sturm
	       			pigment { rgb <0.95, 0.95, 0.8-(rand(ScrollCut)/10)> }
				finish { specular 0.2 roughness 0.2 }
				normal { checker 0.05 scale <1, 2, 1> scale 0.1 }
			}
		}
		cylinder { <0, (ScrollLength/2)-(ScrollLength/8), 0>, 
			<0, (ScrollLength/2)+(ScrollLength/8), 0>, ((ScrollWidth/5)/1.5)+0.1 
			pigment { rgb <(rand(ScrollCut)/2)+0.5, 0, 0> }
			finish { specular 0.6 roughness 0.2 }
			normal { gradient y 0.05 scale 0.2 }
		}
	}
	lathe { linear_spline 9, <-1, -1>, <0, -1>, 
		<(ScrollCentreWidth/5), -1>, 
		<(ScrollCentreWidth/5)/1.25, (ScrollLength/10)*2>, 
		<(ScrollCentreWidth/5)/1.5, (ScrollLength/10)*5>, 
		<(ScrollCentreWidth/5)/1.25, (ScrollLength/10)*8>, 
		<(ScrollCentreWidth/5), ScrollLength+1>,
		<0, ScrollLength+1>, <-1, ScrollLength+1> sturm
		texture {
			pigment { rgb <0.95, 0.95, 0.8-(rand(ScrollCut)/10)> }
			finish { specular 0.2 roughness 0.2 }
			normal { checker 0.05 scale <1, 2, 1> scale 0.1 }
		}
		texture {
			pigment { image_map { gif "scrltab.gif" map_type 2 once 
				interpolate 2 filter 20, 1 } scale ScrollLength }
		}
	}
       	pigment { rgb <0.95, 0.95, 0.8-(rand(ScrollCut)/10)> }
	finish { specular 0.2 roughness 0.2 }
	normal { checker 0.05 scale <1, 2, 1> scale 0.1 }
	rotate <90, 0, 0> 
}
#end
#declare Scrolls=seed(43289);
#declare ScrollCase = union {
	difference {
		box { <1.1, 6.5, 11>, <6.4, 10.9, 15> }
		box { <1.3, 6.7, 10>, <6.2, 7.95, 14> }
		box { <1.3, 8.1, 10>, <6.2, 9.35, 14> }
		box { <1.3, 9.5, 10>, <6.2, 10.7, 14> }
		box { <1.3, 6.8, 10>, <1.35, 10.6, 14> }
		box { <6.15, 6.8, 10>, <6.2, 10.6, 14> }		
	}
	difference {
		intersection {
			prism { linear_sweep cubic_spline 0, 5.5, 9, <-1, -1>, <0, -1>, 
				<0.5, 0>, <0, 2.2>, <0.5, 4.4>, <0, 5.4>, <0, 5.4>, <0, -1>,
				<0, -2> sturm rotate <-90, 0, 0> rotate <0, 90, 0> 
				translate <6.5, 6.5, 11>
			}
			box { <1.1, 6.5, 10>, <6.4, 10.9, 11> }
		}
		box { <1.3, 6, 10>, <6.2, 10.7, 11> }
	}
	union {
		sphere { 0, 0.1 scale <0.1, 1, 1> translate <1.1, 6.7, 11.3> }
		sphere { 0, 0.1 scale <0.1, 1, 1> translate <1.1, 6.7, 14.7> }
		sphere { 0, 0.1 scale <0.1, 1, 1> translate <1.1, 8, 11.3> }
		sphere { 0, 0.1 scale <0.1, 1, 1> translate <1.1, 8, 14.7> }
		sphere { 0, 0.1 scale <0.1, 1, 1> translate <1.1, 9.4, 11.3> }
		sphere { 0, 0.1 scale <0.1, 1, 1> translate <1.1, 9.4, 14.7> }
		sphere { 0, 0.1 scale <0.1, 1, 1> translate <1.1, 10.7, 11.3> }
		sphere { 0, 0.1 scale <0.1, 1, 1> translate <1.1, 10.7, 14.7> }
		sphere { 0, 0.1 scale <0.1, 1, 1> translate <6.4, 6.7, 11.3> }
		sphere { 0, 0.1 scale <0.1, 1, 1> translate <6.4, 6.7, 14.7> }
		sphere { 0, 0.1 scale <0.1, 1, 1> translate <6.4, 8, 11.3> }
		sphere { 0, 0.1 scale <0.1, 1, 1> translate <6.4, 8, 14.7> }
		sphere { 0, 0.1 scale <0.1, 1, 1> translate <6.4, 9.4, 11.3> }
		sphere { 0, 0.1 scale <0.1, 1, 1> translate <6.4, 9.4, 14.7> }
		sphere { 0, 0.1 scale <0.1, 1, 1> translate <6.4, 10.7, 11.3> }
		sphere { 0, 0.1 scale <0.1, 1, 1> translate <6.4, 10.7, 14.7> }
		texture { MetalTex } 
	}
	#declare ScrollsCount=0;
	#while(ScrollsCount<12)
		ScrollMake ( (floor((rand(Scrolls)*10)/4))+10, (rand(Scrolls)*3)+4, 16 )
		object { Scroll rotate <0, 0, rand(Scrolls)*360> 
			translate <0, (ScrollMove/5)/1.25, 0> 
			scale 0.25 rotate <0, (rand(Scrolls)*6)-183, 0> 
			translate <(ScrollsCount*1.25)+2, 6.7, rand(Scrolls)+13>
			#if(ScrollsCount>3)
				translate <-5, 1.4, 0>
			#end
			#if(ScrollsCount>7)
				translate <-5, 1.4, 0>
			#end
		}
		#declare ScrollsCount=ScrollsCount+1;
	#end
	texture { FrontTableTex translate <0, 0, 11> }
}
#end
//******************************************************************************************
//											DICE
//******************************************************************************************
#if(Dice_Switch=on)
#declare Dice = difference {
	superellipsoid { <0.2, 0.2> texture { DiceTex } }
	sphere { <0, 1, 0>, 0.2 }		sphere { <1, 0.5, -0.5>, 0.2 } 
	sphere { <1, -0.5, 0.5>, 0.2 }		sphere { <0.5, -0.5, 1>, 0.2 } 
	sphere { <0, 0, 1>, 0.2 }		sphere { <-0.5, 0.5, 1>, 0.2 }
	sphere { <0.5, 0.5, -1>, 0.2 }		sphere { <0.5, -0.5, -1>, 0.2 } 
	sphere { <-0.5, 0.5, -1>, 0.2 }		sphere { <-0.5, -0.5, -1>, 0.2 }
	sphere { <-1, 0.5, 0.5>, 0.2 }		sphere { <-1, -0.5, 0.5>, 0.2 }
	sphere { <-1, 0, 0>, 0.2 }		sphere { <-1, 0.5, -0.5>, 0.2 }
	sphere { <-1, -0.5, -0.5>, 0.2 }	sphere { <0.5, -1, 0.5>, 0.2 } 
	sphere { <0.5, -1, 0>, 0.2 }		sphere { <0.5, -1, -0.5>, 0.2 } 
	sphere { <-0.5, -1, 0.5>, 0.2 }		sphere { <-0.5, -1, 0>, 0.2 } 
	sphere { <-0.5, -1, -0.5>, 0.2 }
	texture { DiceHoleTex }
	translate <0, 1, 0> scale 0.25
}
#end
//******************************************************************************************
//									       MORPHUS FLASK
//******************************************************************************************
#if(Morphus_Switch=on)
#declare Morphus=seed(47538);
#declare MorphusFlask = union {
	difference {
		sphere { 0, 3 }
		box { <-4, -4, -4>, <4, -2.5, 4> }
		difference {
			sphere { 0, 2.9 }
			box { <-3, -3, -3>, <3, -2.4, 3> }
		}
		box { <-4, 2, -4>, <4, 4, 4> }
		texture { MorphusFlaskTex }
	}
	difference {
		sphere { 0, 2.8999 }
		box { <-3, -3, -3>, <3, -2.3999, 3> }
		box { <-3, 0.7, -3>, <3, 3, 3> }
		texture { MorphusJuiceTex }
	}
	#declare MorphusCount=0;
	blob { threshold 0.5
		#while(MorphusCount<100)
			sphere { 0, rand(Morphus)+1, rand(Morphus)+1
				scale <1, (rand(Morphus)*2)+2, 1>
				rotate <rand(Morphus)*360, rand(Morphus)*360, 
					rand(Morphus)*360>
				translate <(rand(Morphus)*4)-2, (rand(Morphus)*4)-2, 
					(rand(Morphus)*4)-2>
			}
			#declare MorphusCount=MorphusCount+1;
		#end
		scale 0.4
		texture { MorphusTex }
	}
	translate <0, 2.5, 0>
}     
#end
//******************************************************************************************
//										       SHELF
//******************************************************************************************
#if(Shelf_Switch=on)
#declare ShelfSupport = union {
	difference {
		prism { linear_sweep cubic_spline 0, 1, 10,
			<-1, 0>, <0, -2>, <1, 1>, <3, 2>, <3, 3>, <5, 4>, <5, 4>, <0, 4>, 
			<0, -2>, <0, -3> sturm rotate <-90, 0, 0>
		}
		box { <-1, 4, -2>, <6, 5, 2> }
		box { <-1, -4, -2>, <0, 5, 2> }
		rotate <0, 90, 0> translate <1, -4, 0> scale <0.5, 0.5, 1>
	}
	sphere { 0, 0.1 scale <1, 0.1, 1> rotate <10, 0, 0> translate <0.25, -0.15, -4.5> 
		texture { MetalTex } }
	sphere { 0, 0.1 scale <1, 0.1, 1> rotate <65, 0, 0> translate <0.25, -2.3, -0.5> 
		texture { MetalTex } }
}	
#declare ShelfEdge = intersection {
	prism { linear_sweep cubic_spline 0, 0.4, 20, <-2, 0>, <-1, 0>, <0, 0>, <1, 0.5>, 
		<0.75, 1>, <2, 1.5>, <1.5, 1>, <2.5, 0.5>, <3, 0>, <3.5, 0.5>, <4.5, 1>, 
		<4, 1.5>, <5.25, 1>, <5, 0.5>, <6, 0>, <7, 0>, <7, 3>, <-1, 3>, <-1, 0>, 
		<-1, -1> sturm rotate <-90, 0, 0> translate <0, 0, 0.4> 
	}
	box { <0, -0.1, -1>, <6, 1.5, 1> }
}
#declare Shelf = union {
	box { <1, 6.1, 9.5>, <15, 6.5, 15> texture { TopTableTex translate <0, 6.5, 0> } }
	box { <0.9, 6.1, 9.5>, <1, 6.5, 15> texture { SideTableTex translate <1, 0, 0> } }
	union {
		sphere { 0, 0.1 scale <0.1, 1, 1> translate <0.9, 6.3, 9.75> }
		sphere { 0, 0.1 scale <0.1, 1, 1> translate <0.9, 6.3, 14.75> }
		sphere { 0, 0.1 scale <1, 1, 0.1> translate <1.25, 6.3, 9.4> }
		sphere { 0, 0.1 scale <1, 1, 0.1> translate <7.75, 6.3, 9.4> }
		sphere { 0, 0.1 scale <1, 1, 0.1> translate <14.25, 6.3, 9.4> }
		texture { MetalTex } 
	}
	box { <1, 6.1, 9.4>, <15, 6.5, 9.5> 
		texture { FrontTableTex translate <0, 0, 9.5> } }
	difference {
		box { <1, 3.1, 14.6>, <15, 6.1, 15> }
		box { <1.5, 3, 14>, <7.5, 4.6, 16> }
		box { <8, 3, 14>, <14, 4.6, 16> }
		texture { FrontTableTex translate <0, 0, 14.6> } 
	} 
	object { ShelfEdge translate <1.5, 3.1, 14.6> 
		texture { FrontTableTex translate <0, 0, 14.6> } }
	object { ShelfEdge translate <8, 3.1, 14.6> 
		texture { FrontTableTex translate <0, 0, 14.6> } }
	union {
		sphere { 0, 0.1 scale <1, 1, 0.1> translate <2, 3.7, 14.6> }
		sphere { 0, 0.1 scale <1, 1, 0.1> translate <4.5, 3.7, 14.6> }
		sphere { 0, 0.1 scale <1, 1, 0.1> translate <7, 3.7, 14.6> }
		sphere { 0, 0.1 scale <1, 1, 0.1> translate <8.5, 3.7, 14.6> }
		sphere { 0, 0.1 scale <1, 1, 0.1> translate <11, 3.7, 14.6> }
		sphere { 0, 0.1 scale <1, 1, 0.1> translate <13.5, 3.7, 14.6> } 
		texture { MetalTex } 
	}
	object { ShelfSupport translate <1, 6.1, 14.6> 
		texture { SideTableTex translate <1, 0, 0> } }
	object { ShelfSupport translate <7.5, 6.1, 14.6> 
		texture { SideTableTex translate <7.5, 0, 0> } }
	object { ShelfSupport translate <14, 6.1, 14.6> 
		texture { SideTableTex translate <14, 0, 0> } }
}
#end
//******************************************************************************************
//										       TABLE
//******************************************************************************************
#if(Table_Switch=on)
#declare HandleLeaf = difference {
	prism { conic_sweep cubic_spline
		0, 1, 15,
		<1, 0>, <0, 0>, <-0.5, 0>, <-1, 2>, <-0.75, 2.5>, <-0.5, 2.5>, <-0.25, 3>, 
		<0, 3.5>, <0.25, 3>, <0.5, 2.5>, <0.75, 2.5>, <1, 2>, <0.5, 0>, <0, 0>, 
		<-1, 0>
		sturm rotate <-90, 0, 0> rotate <0, 180, 0>
	}
	box { <-2, -1, -2>, <2, 4, 0.8> }
}
#declare DrawerHandle = union {
	object { HandleLeaf rotate <0, 0, 0> }
	object { HandleLeaf rotate <0, 0, 90> }
	object { HandleLeaf rotate <0, 0, 180> }
	object { HandleLeaf rotate <0, 0, -90> }
	sphere { <0, 0, -0.5>, 1.5 }
	object { HandleLeaf scale 0.8 rotate <0, 0, 45> translate <11, -3, 0> }
	object { HandleLeaf scale 0.8 rotate <0, 0, 135> translate <11, 3, 0> }
	object { HandleLeaf scale 0.8 rotate <0, 0, 225> translate <-11, 3, 0> }
	object { HandleLeaf scale 0.8 rotate <0, 0, 315> translate <-11, -3, 0> }
	texture { GoldenTex }
}	
#declare Drawer = union {
	difference {
		box { <0.05, 0.05, 0>, <2.6, 0.95, 5> }
		box { <0.1, 0.1, 0.1>, <2.55, 1, 4.9> }
	}
	cylinder { <0.05, 0.05, 0.05>, <0.05, 0.95, 0.05>, 0.05 }
	cylinder { <2.6, 0.05, 0.05>, <2.6, 0.95, 0.05>, 0.05 }
	cylinder { <0.05, 0.05, 0.05>, <2.6, 0.05, 0.05>, 0.05 }
	cylinder { <0.05, 0.95, 0.05>, <2.6, 0.95, 0.05>, 0.05 }
	sphere { <0.05, 0.05, 0.05>, 0.05 }
	sphere { <2.6, 0.05, 0.05>, 0.05 }
	sphere { <0.05, 0.95, 0.05>, 0.05 }
	sphere { <2.6, 0.95, 0.05>, 0.05 }
	cylinder { <0.05, 0.05, 0.05>, <0.05, 0.05, 5>, 0.05 }
	cylinder { <2.6, 0.05, 0.05>, <2.6, 0.05, 5>, 0.05 }
	cylinder { <0.05, 0.95, 0.05>, <0.05, 0.95, 5>, 0.05 }
	cylinder { <2.6, 0.95, 0.05>, <2.6, 0.95, 5>, 0.05 }
	box { <0.15, 0.15, -0.05>, <2.5, 0.85, 0.05> texture { DrawerPearlTex } }
	union {
		cylinder { <0.15, 0.15, 0>, <0.15, 0.85, 0>, 0.05 }
		cylinder { <2.5, 0.15, 0>, <2.5, 0.85, 0>, 0.05 }
		cylinder { <0.15, 0.15, 0>, <2.5, 0.15, 0>, 0.05 }
		cylinder { <0.15, 0.85, 0>, <2.5, 0.85, 0>, 0.05 }
		sphere { <0.15, 0.15, 0>, 0.05 }
		sphere { <2.5, 0.15, 0>, 0.05 }
		sphere { <0.15, 0.85, 0>, 0.05 }
		sphere { <2.5, 0.85, 0>, 0.05 }
		texture { GoldenTex }
	}
	object { DrawerHandle scale 0.1 translate <1.325, 0.5, -0.15> }
	translate <0.05, 0, 0>
}
#declare Table = union {
	difference {
		box { <-15, -15, -5>, <15, 0, 15> }
		text { ttf "cyrvetic.ttf", "Dan Allsop", 0.5, 0 scale 0.3
			rotate <90, 0, 0> translate <-4.5, 0.1, -1.5>
			texture { DiceHoleTex } }
		texture { TopTableTex }
		texture { Stain1TableTex }
		texture { Stain2TableTex }
	}
	difference {
		box { <-15, -15, 9>, <-5, 3, 15> }
		box { <-8, 0.5, 8>, <-5.25, 1.5, 14> }
		box { <-8, 1.75, 8>, <-5.25, 2.75, 14> }
		box { <-11, 0.5, 8>, <-8.25, 1.5, 14> }
		box { <-11, 1.75, 8>, <-8.25, 2.75, 14> }
		texture { TopTableTex translate <0, 3, 0> } 
	}
	difference {
		box { <-15, -15, 8.9>, <-5, 3, 9> }
		box { <-8, 0.5, 8>, <-5.25, 1.5, 14> }
		box { <-8, 1.75, 8>, <-5.25, 2.75, 14> }
		box { <-11, 0.5, 8>, <-8.25, 1.5, 14> }
		box { <-11, 1.75, 8>, <-8.25, 2.75, 14> }
		texture { FrontTableTex translate <0, 0, 9> }
	}
	union {
		sphere { 0, 0.1 scale <0.1, 1, 1> translate <-4.9, 0.2, 9.15> }
		sphere { 0, 0.1 scale <0.1, 1, 1> translate <-4.9, 2.8, 9.15> }
		sphere { 0, 0.1 scale <0.1, 1, 1> translate <-4.9, 0.2, 14.75> }
		sphere { 0, 0.1 scale <0.1, 1, 1> translate <-4.9, 2.8, 14.75> }
		sphere { 0, 0.1 scale <1, 1, 0.1> translate <-5.15, 0.2, 8.9> }
		sphere { 0, 0.1 scale <1, 1, 0.1> translate <-5.15, 2.8, 8.9> }
		texture { MetalTex } 
	}
	box { <-5, -15, 9>, <-4.9, 3, 15> texture { SideTableTex translate <-5, 0, 0> } }
	object { Drawer rotate <0, 2, 0> translate <-8, 0.5, 8.9> 
		texture { FrontTableTex translate <0, 0, 8.9> } }
	object { Drawer rotate <0, 1, 0> translate <-8, 1.75, 8.5> 
		texture { FrontTableTex translate <0, 0, 8.5> } }
	object { Drawer rotate <0, -1, 0> translate <-11, 0.5, 8.7> 
		texture { FrontTableTex translate <0, 0, 8.7> } }
	object { Drawer rotate <0, -2, 0> translate <-11, 1.75, 9> 
		texture { FrontTableTex translate <0, 0, 9> } }	
}
#end
//******************************************************************************************
//										       CADDY
//******************************************************************************************
#if(Caddy_Switch=on)
#declare CaddyFrame = prism { linear_sweep linear_spline
	0, 4, 9,
	<-0.5, 0>, <2.5, 0>, <3.5, 1>, <3.5, 3>, <2.5, 4>, <-0.5, 4>, <-1.5, 3>, 
	<-1.5, 1>, <-0.5, 0>
	sturm translate <-1, -2, -2>
}
#declare KeyHoleFrame = prism { conic_sweep linear_spline
	0, 1, 5, <1, 0>, <0, 2>, <-1, 0>, <0, -2>, <1, 0>
	sturm rotate <90, 0, 0> 
}
#declare KeyHole = prism { linear_sweep linear_spline
	0, 2, 5, <-1, 0>, <1, 0>, <0.5, 3>, <-0.5, 3>, <-1, 0> 
	sturm rotate <90, 0, 0> rotate <0, 0, 180>
}
#declare Caddy = union {
	difference {
		object { CaddyFrame scale 0.975 }
		object { CaddyFrame scale 0.9 translate <0, 0.2, 0> }
		union {
			cylinder { <0, 0.5, -1>, <0, 0.5, 2>, 0.25 }
			object { KeyHole scale 0.3 translate <0, -0.5, 0.1> }
			scale 0.3 translate <0, 1.2, -2>
		}
		texture { CaddyTex } 
	}
	difference {
		object { CaddyFrame }
		box { <-1.4, -1.9, -3>, <1.4, 1.9, 3> }
		box { <-3.1, -1.9, -0.9>, <3.1, 1.9, 0.9> }
		box { <-3.1, -1.9, 1.05>, <3.1, 1.9, 1.95> }
		box { <-3.1, -1.9, -1.95>, <3.1, 1.9, -1.05> }
		object { CaddyFrame scale 0.91 translate <0, 0.2, 0> }
	}
	union {
		difference {
			object { CaddyFrame scale 0.975 scale <1, 0.25, 1> }
			object { CaddyFrame scale 0.9 scale <1, 0.25, 1> 
				translate <0, -0.2, 0> }
			texture { CaddyTex } 
		}
		difference {
			object { CaddyFrame scale <1, 0.25, 1> }
			box { <-1.4, -0.4, -3>, <1.4, 0.4, 3> }
			box { <-3.1, -0.4, -0.9>, <3.1, 0.4, 0.9> }
			box { <-3.1, -0.4, 1.05>, <3.1, 0.4, 1.95> }
			box { <-3.1, -0.4, -1.95>, <3.1, 0.4, -1.05> }
			object { CaddyFrame scale 0.9 translate <0, 0.2, 0> }
		}
		translate <0, 0.5, -1.5> rotate <1, 0, 0> translate <0, 2, 1.5>
	}
	difference {
		object { KeyHoleFrame }
		box { <-2, -3, -1>, <2, 3, 0.7> }
		cylinder { <0, 0.5, -1>, <0, 0.5, 2>, 0.25 }
		object { KeyHole scale 0.3 translate <0, -0.5, 0.6> }
		scale 0.3 translate <0, 1.2, -2.25>
	}
	cylinder { <-1.2, -2.2, 1.3>, <-1.2, -2, 1.3>, 0.5 }
	cylinder { <1.2, -2.2, 1.3>, <1.2, -2, 1.3>, 0.5 }
	cylinder { <-1.2, -2.2, -1.3>, <-1.2, -2, -1.3>, 0.5 }
	cylinder { <1.2, -2.2, -1.3>, <1.2, -2, -1.3>, 0.5 }
	texture { GoldenTex }
	translate <0, 2.2, 0> scale 0.6
}
#end
//******************************************************************************************
//											 MUG
//******************************************************************************************
#if(Mug_Switch=on)
#declare Mug = union {
	difference {
		union {
			cylinder { <0, 0.15, 0>, <0, 2, 0>, 0.8 }
			torus { 0.75, 0.05 sturm translate <0, 2, 0> }
			torus { 0.75, 0.05 sturm translate <0, 0.15, 0> }
		}
		cylinder { <0, 0.3, 0>, <0, 3, 0>, 0.7 }
		prism { linear_sweep linear_spline 0, 2, 10,
			<0, 1>, <0.2, -0.1>, <0.4, -0.3>, <0.6, -1>, <0.5, -1.1>, 
			<0.7, -1.2>, <0.6, -0.3>, <1, 0.1>, <1, 1>, <0, 1>
			scale 0.5 rotate <-90, 0, 0> translate <-0.3, 2, 0>
		}
	}
	cylinder { <0, 0, 0>, <0, 0.2, 0>, 0.6 }
	difference {
		torus { 0.45, 0.08 sturm rotate <90, 0, 0> scale <1, 1.5, 2> 
			rotate <0, 0, -30> translate <0.9, 1.2, 0> }
		cylinder { <0, 0.3, 0>, <0, 3, 0>, 0.75 }
		rotate <0, 10, 0>
	}
	texture { MugTex }
}
#end
//******************************************************************************************
//											LAMP
//******************************************************************************************
#if(Lamp_Switch=on)
#declare LampFlame = merge {
	prism { conic_sweep cubic_spline 0, 1, 10, <-1, -1>, <-1, 0>, <-1.5, 1>, <-0.5, 3>, 
		<0, 4>, <0.5, 2>, <1.5, 1> <1, 0>, <-1, 0>, <-2, 0> sturm 
		rotate <-90, 0, 0> rotate <0, 180, 0> translate <0, 0, -1>
	}
	prism { conic_sweep cubic_spline 0, 1, 10, <2, 0>, <1, 0>, <-1, 0>, <-1.5, 1>, 
		<-0.5, 2>, <0, 4>, <0.5, 3>, <1.5, 1>, <1, 0>, <1, -1> sturm 
		rotate <-90, 0, 0> translate <0, 0, 0.999>
	}
	texture { LampFlameTex }
	scale <1, 1, 0.5> 
}
#declare LampCover = lathe { cubic_spline 7, <-1, 0>, <0, 0>, <1.5, 0>, <2, 2>, <0.75, 4>, 
	<0.75, 10>, <0.75, 10> sturm 
	translate <0, -2, 0> scale 1.2 
	texture { LampCoverTex } 
}
#declare Lamp = union {
	box { <-0.2, 0, -0.05>, <0.2, 4.2, 0.05> texture { WickTex } rotate <0, 40, 0> }
	difference {
		object { LampCover translate <0, 5.5, 0> }
		object { LampCover scale 0.95 translate <0, 5.5, 0> }		
		box { <-3, 0, -3>, <3, 3.35, 3> }
		box { <-3, 17, -3>, <3, 18, 3> }
	}
	#if(LampLight_Switch=on)
		light_source { 0 color rgb <1.0, 1.0, 0.3> 
			area_light <1, 0, 0>, <0, 1, 0>, 3, 3 adaptive 1 jitter
			fade_distance 8 fade_power 2 
			looks_like { object { LampFlame translate <0, -1, 0> scale 0.3 
				translate <0.5, 0.3, 0> } }
			translate <-0.5, 4.2, 0> rotate <0, 40, 0>  
		}
		light_source { 0 color rgb <0.7, 0.7, 0.3> fade_distance 8 fade_power 2
			translate <0.025, 4.7, 0> rotate <0, 40, 0> }
		light_source { 0 color rgb <0.7, 0.7, 0.3> fade_distance 8 fade_power 2
			translate <-0.025, 4.7, 0> rotate <0, 40, 0> }
	#else
		light_source { 0 color rgb <1.0, 1.0, 0.3> 
			looks_like { object { LampFlame translate <0, -1, 0> scale 0.3 
				translate <0, -0.2, 0> } }
			translate <0, 4.7, 0> rotate <0, 40, 0>  
		}	
	#end
	box { <-0.25, 0, -0.1>, <0.25, 3.9, 0.1> texture { LampBurntTex } }
	difference {
		sphere { <0, 3.6, 0>, 0.5 }
		sphere { <0, 3.6, 0>, 0.45 }
		cylinder { <-1, 0, 0>, <1, 0, 0>, 0.2 scale <1, 2, 1> translate <0, 4.1, 0> }
		box { <-1, 0, -1>, <1, 3.6, 1> }
		rotate <0, 40, 0>
		texture { LampBurntTex }
	}
	cylinder { <0, 3.3, 0>, <0, 3.6, 0>, 0.6 texture { LampBurntTex 
		normal { radial 0.1 frequency 25 } } }
	difference {
		union {
			torus { 1.1, 0.7 sturm }
			cylinder { <0, -0.7, 0>, <0, 0.7, 0>, 0.7 }
		}
		difference {
			torus { 1.1, 0.6 sturm }
			cylinder { <0, -3, 0>, <0, 3, 0>, 0.7 }
		}
		box { <-3, 0, -3>, <3, 3, 3> }
		#declare LampHoleCounter=0;
		#while (LampHoleCounter<15)
			cylinder { <0, -2, 0>, <0, 0, 0>, 0.1 rotate <20, 0, 0> 
				translate <0, 0, -1.2> rotate <0, LampHoleCounter*24, 0> }
			#declare LampHoleCounter=LampHoleCounter+1;
		#end
		scale <1, 0.2, 1> translate <0, 3.34, 0>
	}
	difference {
		cylinder { <0, 0, 0>, <0, 3.25, 0>, 0.7 }
		cylinder { <0, 0, 1.4>, <0, 0, 2>, 0.2 scale 0.9 rotate <0, 0, 30> 
			translate <0, 2.8, -2> rotate <0, -50, 0> }
		texture { LampTex normal { radial 0.1 frequency 25 } } 
	}
	difference {
		cylinder { <0, 0, 0>, <0, 0.3, 0>, 2 }
		torus { 2, 0.1 sturm translate <0, 0.15, 0> }
		texture { LampTex }
	}
	difference {
		lathe { cubic_spline 8, <3, 0>, <2, 0.3>, <1.5, 1>, <1.3, 1.8>, <1, 2>, 
			<0.7, 2.5>, <0.6, 2.5>, <0, 3> }
		box { <-3, 2.4, -3>, <3, 3, 3> }
	}
	union {
		torus { 0.4, 0.05 sturm rotate <90, 0, 0> }
		cylinder { <0, -0.4, 0>, <0, 0.4, 0>, 0.05 }
		cylinder { <-0.4, 0, 0>, <0.4, 0, 0>, 0.05 }
		sphere { <0.45, 0, 0>, 0.05 }
		sphere { <-0.45, 0, 0>, 0.05 }
		sphere { <0, 0.45, 0>, 0.05 }
		sphere { <0, -0.45, 0>, 0.05 }
		sphere { <0, 0, 0>, 0.1 }
		cylinder { <0, 0, 0>, <0, 0, 2>, 0.1 }
		cylinder { <0, 0, 1.4>, <0, 0, 2>, 0.15 }
		scale 0.9 rotate <0, 0, 30> translate <0, 2.8, -2> rotate <0, -50, 0>
	}
	texture { LampTex }
	scale 0.7 
}
#end
//******************************************************************************************
//										  TEST TUBES
//******************************************************************************************
#if(TubeRack_Switch=on)
#declare TestTubeWobble=seed(85400);
#declare TestTubeHeight=seed(48738);
#declare TestTubeColour=seed(46555);
#declare TestTubeRack = union {
	#if(TestTubes_Switch=on)
	#declare TestTubeCounter=0;
	#while (TestTubeCounter<22)
		union {
			difference {
				merge {
					sphere { <0, 0, 0>, 1 }
					cylinder { <0, -0.001, 0>, <0, 10.001, 0>, 1 }
					intersection {
						cylinder { <0, 0, 0>, <0, 0.5001, 0>, 1.5 }
						torus { 1.5, 0.6 sturm }
						scale <1, 2, 1>
						translate <0, 10, 0>
					}
					torus { 1.35, 0.15 sturm translate <0, 11, 0> }
				}
				merge {
					sphere { <0, 0, 0>, 0.9 }
					cylinder { <0, -0.001, 0>, <0, 12, 0>, 0.9 }
				}
				torus { 1.5, 0.5 sturm scale <1, 2, 1> translate <0, 10, 0> }
				texture { TestTubeTex }
			}
			merge {
				sphere { <0, 0, 0>, 0.899 }
				#declare LiquidHeight=(rand(TestTubeHeight)*7)+1;
				cylinder { <0, -0.001, 0>, 
					<0, LiquidHeight, 0>, 0.899 }
				pigment { rgbf <(rand(TestTubeColour)/2)+0.5,
					(rand(TestTubeColour)/2)+0.5, 
					(rand(TestTubeColour)/2)+0.5,
					(rand(TestTubeColour)/2)+0.5> }
				finish { ambient 0.2 specular 0.2 
					roughness 0.001 reflection 0.1 }
	        	}
       			cylinder { <0, 0, 0>, <0, rand(TestTubeHeight)+1.5, 0>, 0.9
				rotate <(rand(TestTubeWobble)*5)-2.5, 
					(rand(TestTubeWobble)*5)-2.5, 
					(rand(TestTubeWobble)*5)-2.5>
        			translate <0, rand(TestTubeHeight)+9.5, 0> 
        			#declare CorkColour=rand(TestTubeColour)/5;
        			pigment { checker 
	        			pigment { rgb <0.8, 0.75, 0.65> + CorkColour }
	        			pigment { rgb <0.6, 0.55, 0.45> + CorkColour }
        				scale 0.2 turbulence 0.8 }
        			normal { granite 0.2 scale 0.2 }
	       		}
			scale 0.3
			rotate <(rand(TestTubeWobble)*5)-2.5, 
				(rand(TestTubeWobble)*5)-2.5, 
				(rand(TestTubeWobble)*5)-2.5>
			translate <-2.5+TestTubeCounter, 0.4, 12>
			#if (TestTubeCounter>10)
				translate <-11, 0, 2>
			#end
		}
		#declare TestTubeCounter=TestTubeCounter+1;
	#end
	#end
	difference {
		box { <-3.5, 0, 11.5>, <8.5, 0.4, 14.5> }
		#declare RackHoleCounter=0;
		#while (RackHoleCounter<22)
			sphere { 0, 0.4
				translate <-2.5+RackHoleCounter, 0.5, 12>
				#if (RackHoleCounter>10)
					translate <-11, 0, 2>
				#end
			}
			#declare RackHoleCounter=RackHoleCounter+1;
		#end
		texture { FrontTableTex translate <0, 0, 11.5> }
	}
	difference {
		box { <-3.5, 2.6, 11.5>, <8.5, 2.8, 14.5> }
		#declare RackHoleCounter=0;
		#while (RackHoleCounter<22)
			cylinder { <0, 2, 0>, <0, 4, 0> 0.4
				translate <-2.5+RackHoleCounter, 0, 12>
				#if (RackHoleCounter>10)
					translate <-11, 0, 2>
				#end
			}
			#declare RackHoleCounter=RackHoleCounter+1;
		#end
		texture { FrontTableTex translate <0, 0, 11.5> }
	}
	union {
		cylinder { <-3.3, 0.3, 11.7>, <-3.3, 3, 11.7>, 0.1 }
		cylinder { <-3.3, 0.3, 13>, <-3.3, 3, 13>, 0.1 }
		cylinder { <-3.3, 0.3, 14.3>, <-3.3, 3, 14.3>, 0.1 }
		cylinder { <8.3, 0.3, 11.7>, <8.3, 3, 11.7>, 0.1 }
		cylinder { <8.3, 0.3, 13>, <8.3, 3, 13>, 0.1 }
		cylinder { <8.3, 0.3, 14.3>, <8.3, 3, 14.3>, 0.1 }
		texture { MetalTex }
	}
	translate <0, -0.1, 0> 
}
#end
//******************************************************************************************
//										     BOTTLES
//******************************************************************************************
#if(Bottles_Switch=on)
#declare Bottle = merge {
	difference {
		cylinder { <0, -0.001, 0>, <0, 1.601, 0>, 1 }
		cylinder { <0, -1, 0>, <0, 3, 0>, 0.95 }
	}
	difference {
		sphere { <0, 0, 0>, 1 scale <1, 0.7, 1> }
		sphere { <0, 0, 0>, 0.95 scale <1, 0.7, 1> }
		box { <-2, 0, -2>, <2, 2, 2> }
		box { <-2, -2, -2>, <2, -0.4, 2> }
	}
	intersection {
		cylinder { <0, -0.4, 0>, <0, -0.35, 0>, 1 }
		sphere { <0, 0, 0>, 1 scale <1, 0.7, 1> }
	}			
	difference {
		sphere { <0, 0, 0>, 1 }
		sphere { <0, 0, 0>, 0.95 }
		box { <-2, -2, -2>, <2, 0, 2> }
		cylinder { <0, 0, 0>, <0, 2, 0>, 0.55 }
		scale <1, 0.7, 1> translate <0, 1.6, 0>
	}
	difference {
		cylinder { <0, 2.1, 0>, <0, 2.5, 0>, 0.6 }
		cylinder { <0, 2, 0>, <0, 3, 0>, 0.55 }
		sphere { <0, 0, 0>, 0.95 scale <1, 0.7, 1> translate <0, 1.6, 0> }
	}
	difference {
		cylinder { <0, 2.5, 0>, <0, 2.7, 0>, 0.625 }
		cylinder { <0, 2, 0>, <0, 3, 0>, 0.575 }
	}		
	torus { 0.6, 0.025 sturm translate <0, 2.5, 0> }
	torus { 0.6, 0.025 sturm translate <0, 2.7, 0> }
	texture { BottleTex }
}
#declare Granules=seed(38654);
#declare Contents = union {
	#declare GranulesCounter=0;
	#while(GranulesCounter<500)
		box { -((rand(Granules)/50)+0.03), (rand(Granules)/50)+0.03
			rotate <rand(Granules)*360, 0, 0> 
			rotate <0, rand(Granules)*360, 0> 
			rotate <0, 0, rand(Granules)*360> 
			translate <0, (rand(Granules)/20)+0.7, rand(Granules)-0.12>
			rotate <0, rand(Granules)*360, 0> 
		}
		#declare GranulesCounter=GranulesCounter+1;
	#end
	#while(GranulesCounter<2500)
		box { -((rand(Granules)/50)+0.03), (rand(Granules)/50)+0.03
			rotate <rand(Granules)*360, 0, 0> 
			rotate <0, rand(Granules)*360, 0> 
			rotate <0, 0, rand(Granules)*360> 
			translate <0, (rand(Granules)*1.05)-0.35,
				(rand(Granules)/50)+0.88> 
			rotate <0, rand(Granules)*360, 0> 
		}
		#declare GranulesCounter=GranulesCounter+1;
	#end
	cylinder { <0, -0.35, 0>, <0, 0.65, 0>, 0.83 }
}
#declare Contents1 = intersection {
	object { Contents }
	merge {
		difference {
			sphere { <0, 0, 0>, 0.95 scale <1, 0.7, 1> }
			box { <-2, -2, -2>, <2, -0.35, 2> }
		}
		sphere { <0, 0, 0>, 0.95 scale <1, 0.7, 1> translate <0, 1.6, 0> }
		cylinder { <0, -0.001, 0>, <0, 1.601, 0>, 0.95 }
		scale 0.999
	}
	texture { BottleContentsTex }
}	
#declare Contents2 = intersection {
	object { Contents translate <0, -0.6, 0> rotate <0, 180, 0> }
	merge {
		difference {
			sphere { <0, 0, 0>, 0.95 scale <1, 0.7, 1> }
			box { <-2, -2, -2>, <2, -0.35, 2> }
		}
		sphere { <0, 0, 0>, 0.95 scale <1, 0.7, 1> translate <0, 1.6, 0> }
		cylinder { <0, -0.001, 0>, <0, 1.601, 0>, 0.95 }
		scale 0.999
	}
	texture { BottleContentsTex }
}	
#declare Bottle1 = union {
	object { Bottle }
	object { Contents1 }
	translate <0, 0.4, 0> scale 1.6
}
#declare Bottle2 = union {
	object { Bottle }
	object { Contents2 }
	translate <0, 0.4, 0> scale 1.6
}
#end
//******************************************************************************************
//										      SCALES
//******************************************************************************************
#if(Scales_Switch=on)
#declare ScalesBalance = -3;

#declare ChainSpin=seed(54860);
#declare ChainLink = union {
	difference {
		union {
			torus { 0.3, 0.1 sturm rotate <90, 0, 0> translate <0, 0.2, 0> }
			torus { 0.3, 0.1 sturm rotate <90, 0, 0> translate <0, -0.2, 0> }
		}
		box { <-1, -0.2, -1>, <1, 0.2, 1> }
	}
	cylinder { <0.3, -0.2, 0>, <0.3, 0.2, 0>, 0.1 }
	cylinder { <-0.3, -0.2, 0>, <-0.3, 0.2, 0>, 0.1 }
	translate <0, -0.4, 0>
}
#declare Chain_X = union {
	#declare ChainCount=0;
	#while(ChainCount<28)
		object { ChainLink translate <0, -(ChainCount*1.6), 0> 
			rotate <0, (rand(ChainSpin)*60)-30, 0> }
		#declare ChainCount=ChainCount+1;
	#end
}
#declare Chain_Z = union {
	#declare ChainCount=0;
	#while(ChainCount<27)
		object { ChainLink translate <0, (-0.8)-(ChainCount*1.6), 0> 
			rotate <0, 90+((rand(ChainSpin)*60)-30), 0> }
		#declare ChainCount=ChainCount+1;
	#end
}
#declare Chain = union {
	object { Chain_X }
	object { Chain_Z }
	texture { ScalesChainTex }
	scale 0.25 
}
#declare ScalesKey = union {
	difference {
		prism { linear_sweep cubic_spline 0, 1.2, 10, <-1, 0.7>, <0, 0.7>, <0.5, 0>,
			<0.2, -0.7>, <0.1, -1.3>, <-0.1, -1.3>, <-0.2, -0.7>, <-0.5, 0>, 
			<0, 0.7>, <1, 0.7> sturm rotate <-90, 0, 0> translate <0, 0, 0.6> 
		}
		cylinder { <0, 0, -1>, <0, 0, 1>, 0.175 }
		box { <-1, -2, -0.4>, <1, 1, 0.4> }
	}
	union {
		difference {
			box { <-0.1, 0.3, -0.6>, <0.1, 3.2, 0.6> }
			box { <-1, 0, -0.4>, <1, 3, 0.4> }
		}
		intersection {
			cone { <0, 2.6, 0>, 0.05, <0, 3, 0>, 0.2 }
			box { <-0.1, 0, -1>, <0.1, 4, 1> }
		}
	}
	difference {
		intersection {
			prism { linear_sweep cubic_spline 0, 0.2, 16, <1, -0.2>, <0, -0.2>, 
				<-0.6, 0>, <-0.6, 0>, <-0.4, 0.4>, <-0.25, 0.5>, 
				<-0.25, 0.8>, <-0.1, 1>, <0.1, 1>, <0.25, 0.8>, <0.25, 0.5>, 
				<0.4, 0.4>, <0.6, 0>, <0.6, 0>, <0, -0.2>, <-1, -0.2> sturm 
				rotate <-90, 0, 0> rotate <0, 90, 0> translate <0.1, 3.2, 0> 
			}
			box { <-1, 0, -0.6>, <1, 5, 0.6> }
		}
		cylinder { <-1, 3.9, 0>, <1, 3.9, 0>, 0.125 }
	}
	torus { 0.7, 0.075 sturm rotate <90, 0, 0> translate <0, 4.62, 0> 
		texture { ScalesChainTex } }
	texture { ScalesTex }
}
#declare ScalesCrossbar = union {
	box { <-0.5, 0, -0.15>, <0.5, 0.6, 0.15> }
	intersection {
		cone { <0, 0.6, 0>, 0.2, <0, 2.5, 0>, 0.05 }
		box { <-1, 0, -0.15>, <1, 3, 0.15> }
	}
	difference {
		prism { linear_sweep cubic_spline 0, 0.3, 14, <-1, 0>, <0, 0>, <5.9, -0.1>, 
			<5.9, -0.5>, <1.5, -0.7>, <0.8, -0.8>, <0.2, -1.1>, <-0.2, -1.1>, 
			<-0.8, -0.8>, <-1.5, -0.7>, <-5.9, -0.5>, <-5.9, -0.1>, <0, 0>, 
			<1, 0> sturm rotate <-90, 0, 0> translate <0, 0.1, 0.15> 
		}
		cylinder { <0, 0, -1>, <0, 0, 1>, 0.4 scale <1, 1.5, 1> rotate <0, 0, 50> 
			translate <7, -0.3, 0> }
		cylinder { <0, 0, -1>, <0, 0, 1>, 0.4 scale <1, 1.5, 1> rotate <0, 0, -50> 
			translate <-7, -0.3, 0> }
	}
	difference {
		cylinder { <0, 0, 0>, <0, 0, 0.3>, 0.5 scale <1, 2, 1> rotate <0, 0, 60> }
		cylinder { <0, 0, -1>, <0, 0, 1>, 0.4 scale <1, 1.5, 1> rotate <0, 0, 50> 
			translate <0, -0.1, 0> }
		box { <-1, -1, -1>, <0, 0, 1> }
		box { <-1, -1, -1>, <0.525, -0.2, 1> }
		cylinder { <-1, -0.3, 0.15>, <1, -0.3, 0.15>, 0.1 }
		translate <7, -0.2, -0.15> 
	}
	difference {
		cylinder { <0, 0, 0>, <0, 0, 0.3>, 0.5 scale <1, 2, 1> rotate <0, 0, -60> }
		cylinder { <0, 0, -1>, <0, 0, 1>, 0.4 scale <1, 1.5, 1> rotate <0, 0, -50> 
			translate <0, -0.1, 0> }
		box { <0, -1, -1>, <1, 0, 1> }
		box { <-0.525, -1, -1>, <1, -0.2, 1> }
		cylinder { <-1, -0.3, 0.15>, <1, -0.3, 0.15>, 0.1 }
		translate <-7, -0.2, -0.15> 
	}
	cylinder { <0, 0, -0.6>, <0, 0, 0.6>, 0.15 }
	torus { 0.7, 0.075 sturm rotate <90, 0, 0> translate <7.6, -1.2, 0> 
		texture { ScalesChainTex } }
	torus { 0.7, 0.075 sturm rotate <90, 0, 0> translate <-7.6, -1.2, 0> 
		texture { ScalesChainTex } }
	texture { ScalesTex }
}
#declare ScalesDish = union {
	difference {
		superellipsoid { <1, 0.2> rotate <90, 0, 0> scale 4 }
		superellipsoid { <1, 0.2> rotate <90, 0, 0> scale 0.975 scale 4 }
		box { <-2, -0.7, -2>, <2, 2, 2> scale 4 }
		cylinder { <0, -3, 0>, <0, -3, 5>, 0.1 }
		cylinder { <0, -3, 0>, <0, -3, 5>, 0.1 rotate <0, 120, 0> }
		cylinder { <0, -3, 0>, <0, -3, 5>, 0.1 rotate <0, 240, 0> }
	}
	torus { 0.55, 0.075 sturm scale <1, 1, 0.5> rotate <0, 0, 90> 
		rotate <-20, 0, 0> translate <0, -2.45, 3.8> texture { ScalesChainTex } }
	torus { 0.55, 0.075 sturm scale <1, 1, 0.5> rotate <0, 0, 90> 
		rotate <-20, 0, 0> translate <0, -2.45, 3.8> rotate <0, 120, 0> 
		texture { ScalesChainTex } }
	torus { 0.55, 0.075 sturm scale <1, 1, 0.5> rotate <0, 0, 90> 
		rotate <-20, 0, 0> translate <0, -2.45, 3.8> rotate <0, 240, 0> 
		texture { ScalesChainTex } }
	object { Chain rotate <-20, 0, 0> translate <0, -1.825, 0> translate <0, 10, 0> }
	object { Chain rotate <-20, 0, 0> translate <0, -1.825, 0> translate <0, 10, 0> 
		rotate <0, 120, 0> }
	object { Chain rotate <-20, 0, 0> translate <0, -1.825, 0> translate <0, 10, 0> 
		rotate <0, 240, 0> }
	texture { ScalesDishTex }
}
#declare ScalesStand = union {
	cone { <0, -16, 1.3>, 0.5, <0, 5.2, 1.3>, 0.2 }
	sphere { <0, 5.2, 1.3>, 0.2 }
	difference {
		cylinder { <0, 5.2, -0.5>, <0, 5.2, 1.3>, 0.2 }
		torus { 0.7, 0.1 sturm rotate <90, 0, 0> translate <0, 4.7, 0> }
	}
	sphere { <0, 5.2, -0.5>, 0.2 }
	cone { <0, 5.2, -0.5>, 0.2, <0, 6, -0.5>, 0.1 }
	difference {
		cylinder { <0, -17, 0>, <0, -15.7, 0>, 1.5 }
		cone { <0, -16, -1>, 0, <0, -15.6, -1>, 0.4 }
		cone { <0, -16, -1>, 0, <0, -15.6, -1>, 0.4 rotate <0, 120, 0> }
		cone { <0, -16, -1>, 0, <0, -15.6, -1>, 0.4 rotate <0, 240, 0> }
		translate <0, 0, 1.3>
	}
	union {
		sphere { 0, 0.3 scale <1, 0.5, 1> translate <0, -15.8, -1> }
		sphere { 0, 0.3 scale <1, 0.5, 1> translate <0, -15.8, -1> 
			rotate <0, 120, 0> }
		sphere { 0, 0.3 scale <1, 0.5, 1> translate <0, -15.8, -1> 
			rotate <0, 240, 0> }
		translate <0, 0, 1.3>
	}
	texture { ScalesDishTex }
}
#declare BaseCut = prism { linear_sweep cubic_spline 0, 1, 8, <0, 1>, <0, 0>, <0, -1>, 
	<0.3, -0.55>, <0.7, -0.45>, <1, 0>, <0, 0>, <-1, 0> sturm 
	rotate <-90, 0, 0> scale <2, 2, 30> 
}
#declare ScalesBase = union {
	difference {
		box { <-14, -18, -7>, <14, -16.3, 7> }
		object { BaseCut rotate <0, -90, 0> translate <-15, -16, -7> }
		object { BaseCut rotate <0, 90, 0> translate <15, -16, 7> }
		object { BaseCut translate <-14, -16, 8> }
		object { BaseCut rotate <0, 180, 0> translate <14, -16, -8> }
	}
	box { <-11.5, -17, -4.75>, <11.5, -16.15, 4.75> } 
	box { <-11.25, -17, -4.5>, <11.25, -16, 4.5> }  
	texture { ScalesWoodTex } 
}
#declare ScalesPowder =	intersection {
	superellipsoid { 0.4 rotate <0, 0, 45> rotate <45, 0, 0> 
		scale <3, 1, 3> translate <0, -4.9, 0> }
	superellipsoid { <1, 0.2> rotate <90, 0, 0> scale 0.975 scale 4 }
	texture { ScalesGrainTex }
}
#declare ScalesPowderDish = union {
	object { ScalesDish }
	object { ScalesPowder }
}
#declare Scales = union {
	object { ScalesKey }
	object { ScalesCrossbar rotate <0, 0, ScalesBalance> }
	object { ScalesPowderDish rotate <0, -30, 0> translate <0, -10, 0> 
		rotate <0, 0, -(ScalesBalance)> translate <7.6, -1.2, 0> 
		rotate <0, 0, ScalesBalance> translate <0, 1.2, 0> }
	object { ScalesDish rotate <0, -10, 0> translate <0, -10, 0> 
		rotate <0, 0, -(ScalesBalance)> translate <-7.6, -1.2, 0> 
		rotate <0, 0, ScalesBalance> translate <0, 1.2, 0> }
	object { ScalesStand }
	object { ScalesBase }
	translate <0, 18, 0> scale 0.25
}
#end
//******************************************************************************************
//										   HOURGLASS
//******************************************************************************************
#if(Hourglass_Switch=on)
#declare HourglassLeg = union {
	lathe { cubic_spline 11, <-1, 0>, <0, -0.7>, <0.2, 0>, <0.4, 2>, <0.2, 4>, <0.4, 5>,
		<0.2, 6>, <0.4, 8>, <0.2, 10>, <0, 10.7>, <-1, 10.7> sturm
		translate <0, 0, 3>
	}
	difference {
		sphere { <0, -0.7, 3>, 0.4 }
		box { <-1, -2, 2>, <1, -1, 4> }
	}
	difference {
		sphere { <0, 10.7, 3>, 0.4 }
		box { <-1, 11, 2>, <1, 12, 4> }
	}
	texture { HourglassWoodTex normal { radial 0.05 frequency 20 } 
		translate <0, 0, 3> }
}
#declare HourglassStand = union {
	difference {
		cylinder { <0, 9.75, 0>, <0, 10.25, 0>, 1.7 }
		sphere { <0, 8.5, 0>, 2 }
	}
	difference {
		torus { 0.75, 0.25 sturm scale <3.4, 2, 3.4> translate <0, 10.25, 0> }
		box { <-4, 10.25, -4>, <4, 12, 4> }
	}
	cylinder { <0, 10.25, 0>, <0, 10.5, 0>, 3.4 }
	texture { HourglassWoodTex normal { radial 0.1 frequency 150 } }
}
#declare Hourglass = union {
	difference {
		lathe { cubic_spline 9, <-1, 0>, <0, 0>, <1, 0>, <2, 2>, <0.2, 5>, <2, 8>, 
			<1, 10>, <0, 10>, <-1, 10> sturm }
		lathe { cubic_spline 9, <-1, 0.2>, <0, 0.2>, <0.8, 0.2>, <1.8, 2>, <0.1, 5>, 
			<1.8, 8>, <0.8, 9.8>, <0, 9.8>, <-1, 9.8> sturm }
		texture { MorphusFlaskTex }
	}
	intersection {
		superellipsoid { 0.4 scale 2 rotate <0, 0, 45> rotate <45, 0, 0> 
			translate <0, 0, 0> }
		lathe { cubic_spline 9, <-1, 0.2>, <0, 0.2>, <0.8, 0.2>, <1.8, 2>, <0.1, 5>,
			<1.8, 8>, <0.8, 9.8>, <0, 9.8>, <-1, 9.8> sturm scale 0.999 }
		texture { HourglassGrainTex }
	}
	object { HourglassStand }
	object { HourglassStand rotate <180, 0, 0> translate <0, 10, 0> }
	object { HourglassLeg rotate <0, 45, 0> }
	object { HourglassLeg rotate <0, 135, 0> }
	object { HourglassLeg rotate <0, 225, 0> }
	object { HourglassLeg rotate <0, 315, 0> }
	translate <0, 1, 0> scale 0.3 
}
#end
//******************************************************************************************
//											BOOK
//******************************************************************************************
#if(Book_Switch=on)
#declare Pages=			360; 
#declare PagesSplitLeft=	160;

#if(BookPages_Switch=on)
#declare PageBleach=seed(38284);
#declare PageZigZag=seed(43297);
#declare PageShuffle=seed(65654);
#declare RightPages = union {
	#declare RightPageDensity=Pages-PagesSplitLeft;
	#declare PageCounter=0;
	#while (PageCounter<RightPageDensity) 
		difference {
			prism { linear_sweep cubic_spline 0, 5, 11, <0, 0>, <0, 0>, 
				<1, -(PageCounter/200)>, <2, -(PageCounter/200)>, 
				<3, -(PageCounter/230)>, <4, -(PageCounter/270)>, 
				<3, -(PageCounter/230)>, <2, -(PageCounter/200)>, 
				<1, -(PageCounter/200)>, <0, 0>, <0, 0> sturm
				translate <0.75-(PageCounter*(2/Pages)),
					(rand(PageShuffle)/10)-0.05, 0>
			}
			cylinder { <0, -1, 0>, <0, 6, 0>, 1 scale <1, 1, 0.35> 
				translate <0, 0, 0.1> }
	        	pigment { rgb <0.95, 0.95, 0.8-(rand(PageBleach)/10)> }
        		finish { specular 0.2 roughness 0.5 }
        		normal { checker 0.01 scale <0.05, 0.1, 1> }
		}
		#declare PageCounter=PageCounter+1;
	#end
}
#declare LeftPages = union {
	#declare LeftPageDensity=PagesSplitLeft;
	#declare PageCounter=0;
	#while (PageCounter<LeftPageDensity)
		difference {
			prism { linear_sweep cubic_spline 0, 5, 11, <0, 0>, <0, 0>, 
				<-1, -(PageCounter/200)>, <-2, -(PageCounter/200)>, 
				<-3, -(PageCounter/230)>, <-4, -(PageCounter/270)>,
				<-3, -(PageCounter/230)>, <-2, -(PageCounter/200)>, 
				<-1, -(PageCounter/200)>, <0, 0>, <0, 0> sturm
				translate <-0.75+(PageCounter*(2/Pages)),
					(rand(PageShuffle)/10)-0.05, 0> 
			}
			cylinder { <0, -1, 0>, <0, 6, 0>, 1 scale <1, 1, 0.35> 
				translate <0, 0, 0.1> }
	        	pigment { rgb <0.95, 0.95, 0.8-(rand(PageBleach)/10)> }
       			finish { specular 0.2 roughness 0.5 }
        		normal { checker 0.01 scale <0.05, 0.1, 1> }
       		}
		#declare PageCounter=PageCounter+1;
	#end
}
#declare LeftPageImage = difference {
	prism { linear_sweep cubic_spline 0, 5, 11, <0, 0>, <0, 0>, 
		<-1, -(LeftPageDensity/200)>, <-2, -(LeftPageDensity/200)>, 
		<-3, -(LeftPageDensity/230)>, <-4, -(LeftPageDensity/270)>,
		<-3, -(LeftPageDensity/230)>, <-2, -(LeftPageDensity/200)>, 
		<-1, -(LeftPageDensity/200)>, <0, 0>, <0, 0> sturm
	}
	cylinder { <0, -1, 0>, <0, 6, 0>, 1 scale <1, 1, 0.35> translate <0, 0, 0.1> }
	pigment { image_map { gif "pag1tab.gif" once interpolate 2 filter 20, 1 } 
		scale <3.8, 4.6, 1> translate <-3.9, 0.2, 0> }
	translate <-0.75+(LeftPageDensity*(2/Pages)), 0, 0>
}
#declare RightPageImage = difference {
	prism { linear_sweep cubic_spline 0, 5, 11, <0, 0>, <0, 0>, 
		<1, -(RightPageDensity/200)>, <2, -(RightPageDensity/200)>, 
		<3, -(RightPageDensity/230)>, <4, -(RightPageDensity/270)>,
		<3, -(RightPageDensity/230)>, <2, -(RightPageDensity/200)>, 
		<1, -(RightPageDensity/200)>, <0, 0>, <0, 0> sturm
	}
	cylinder { <0, -1, 0>, <0, 6, 0>, 1 scale <1, 1, 0.35> translate <0, 0, 0.1> }
	pigment { image_map { gif "pag2tab.gif" once interpolate 2 filter 20, 1 } 
		scale <3.8, 4.6, 1> translate <0.2, 0.2, 0> }
	translate <0.75-(RightPageDensity*(2/Pages)), 0, 0>
}
#end
#declare Cover = union {
	difference {
		union {
			box { <-4.9, -0.1, 0.01>, <4.9, 5.1, 0.1> }
			cylinder { <-4.9, -0.1, 0.05>, <4.9, -0.1, 0.05>, 0.05 }
			cylinder { <-4.9, 5.1, 0.05>, <4.9, 5.1, 0.05>, 0.05 }
		}
		box { <-1, -1, -1>, <1, 6, 1> }
	}
	cylinder { <-4.9, -0.1, 0.05>, <-4.9, 5.1, 0.05>, 0.05 }
	cylinder { <4.9, -0.1, 0.05>, <4.9, 5.1, 0.05>, 0.05 }
	sphere { <-4.9, -0.1, 0.05>, 0.05 }	
	sphere { <4.9, -0.1, 0.05>, 0.05 }	
	sphere { <-4.9, 5.1, 0.05>, 0.05 }	
	sphere { <4.9, 5.1, 0.05>, 0.05 }
	difference {
		cylinder { <0, -0.1, 0>, <0, 5.1, 0>, 1 }
		cylinder { <0, -1, 0>, <0, 6, 0>, 0.9 }
		box { <-2, -1, -2>, <2, 6, -0.2> }
		scale <1, 1, 0.1> translate <0, 0, 0>
	}
	difference {
		cylinder { <0, -0.05, 0>, <0, 5.05, 0>, 1 scale <1, 1, 0.35> }
		cylinder { <0, -1, 0>, <0, 6, 0>, 0.95 scale <1, 1, 0.35> }
		box { <-2, -1, -0.1>, <2, 6, 2> }
		translate <0, 0, 0.1>
		pigment { rgbf <1, 1, 1, 0.5> }
		finish { specular 0.8 roughness 0.01 }
	}
	texture { BookCoverTex }
}
#declare Book = union {
	#if(BookPages_Switch=on)
		object { RightPages }
		object { LeftPages }
		object { LeftPageImage }
		object { RightPageImage }
	#end
	object { Cover }
	translate <0, 0, -0.1> rotate <90, 0, 0>
	scale 1.3
}
#end
//******************************************************************************************
//										   PINCE NEZ
//******************************************************************************************
#if(PinceNez_Switch=on)
#declare PinceNez = union {
	difference {
		sphere { 0, 1 scale <1, 1, 0.05> }
		sphere { 0, 1 scale <1, 1, 0.05> translate <0, 0, 0.05> }
		translate <1.5, 0, 0> 
		texture { PinceNezLensTex } 
	}
	difference {
		torus { 1, 0.05 sturm rotate <90, 0, 0> }
		torus { 0.95, 0.025 sturm rotate <90, 0, 0> }
		torus { 1, 0.025 sturm rotate <90, 0, 0> translate <0, 0, 0.05> }
		torus { 1, 0.025 sturm rotate <90, 0, 0> translate <0, 0, -0.05> }
		translate <1.5, 0, 0>
	}
	difference {
		sphere { 0, 1 scale <1, 1, 0.05> }
		sphere { 0, 1 scale <1, 1, 0.05> translate <0, 0, 0.05> }
		texture { PinceNezLensTex } 
		translate <-1.5, 0, 0> 
	}
	difference {
		torus { 1, 0.05 sturm rotate <90, 0, 0> }
		torus { 0.95, 0.025 sturm rotate <90, 0, 0> }
		torus { 1, 0.025 sturm rotate <90, 0, 0> translate <0, 0, 0.05> }
		torus { 1, 0.025 sturm rotate <90, 0, 0> translate <0, 0, -0.05> }
		translate <-1.5, 0, 0>
	}
	difference {
		torus { 0.5, 0.05 sturm rotate <90, 0, 0> translate <0, -0.3, 0> }
		box { <-1, -2, -1>, <1, -0.3, 1> }
		torus { 0.5, 0.025 sturm rotate <90, 0, 0> translate <0, -0.3, 0.05> }
		torus { 0.5, 0.025 sturm rotate <90, 0, 0> translate <0, -0.3, -0.05> }
	}
	difference {
		torus { 0.5, 0.05 sturm rotate <90, 0, 0> }
		box { <-1, 0.3, -1>, <1, 2, 1> }
		box { <-1, -2, -1>, <1, -0.25, 1> }
		torus { 0.5, 0.025 sturm rotate <90, 0, 0> translate <0, 0, 0.05> }
		torus { 0.5, 0.025 sturm rotate <90, 0, 0> translate <0, 0, -0.05> }
		scale <1, 2, 1> translate <0, -0.6, 0> 
	}
	sphere { 0, 0.5 scale <0.2, 1, 0.5> rotate <0, 0, 15> translate <0.45, -1.2, 0> }
	sphere { 0, 0.5 scale <0.2, 1, 0.5> rotate <0, 0, -15> translate <-0.45, -1.2, 0> }
	texture { PinceNezFrameTex }
	scale 0.8 rotate <95, 0, 0> 
}
#end
//******************************************************************************************
//										     WEIGHTS
//******************************************************************************************
#if(Weights_Switch=on)
#declare Weight = difference {
	cone { <0, 0, 0>, 1.1, <0, 0.7, 0>, 1.2 texture { ScalesDishTex scale 0.5 } }
	cone { <0, 0.6, 0>, 0.9, <0, 0.8, 0>, 1 }
	sphere { 0, 0.9 scale <1, 0.1, 1> translate <0, 0.6, 0> }
	text { ttf "cyrvetic.ttf", "G.M", 0.8, 0 scale 0.8 rotate <90, 0, 0> 
		translate <-0.7, 0.7, -0.6> }
	texture { ScalesChainTex }
}
#declare Weight1 = difference {
	object { Weight }
	text { ttf "cyrvetic.ttf", "1", 0.8, 0 scale 0.9 rotate <90, 0, 0> 
		translate <-0.15, 0.7, 0.1> }
	texture { ScalesChainTex }
	scale 0.15 
}
#declare Weight2 = difference {
	object { Weight }
	text { ttf "cyrvetic.ttf", "2", 0.8, 0 scale 0.9 rotate <90, 0, 0> 
		translate <-0.2, 0.7, 0.1> }
	texture { ScalesChainTex }
	scale 0.2  
}
#declare Weight5 = difference {
	object { Weight }
	text { ttf "cyrvetic.ttf", "5", 0.8, 0 scale 0.9 rotate <90, 0, 0> 
		translate <-0.2, 0.7, 0.1> }
	texture { ScalesChainTex }
	scale 0.25  
}
#declare Weight10 = difference {
	object { Weight }
	text { ttf "cyrvetic.ttf", "10", 0.8, 0 scale 0.9 rotate <90, 0, 0> 
		translate <-0.4, 0.7, 0.1> }
	texture { ScalesChainTex }
	scale 0.3  
}
#declare Weight20 = difference {
	object { Weight }
	text { ttf "cyrvetic.ttf", "20", 0.8, 0 scale 0.9 rotate <90, 0, 0> 
		translate <-0.45, 0.7, 0.1> }
	texture { ScalesChainTex }
	scale 0.35
}
#end
//******************************************************************************************
//										SPOONSPATULA
//******************************************************************************************
#if(SpoonSpatula_Switch=on)
#declare Spatula = union {
	intersection {
		prism { linear_sweep linear_spline 0, 0.25, 8, <0, 0>, <-1, 0>, 
			<-1.2, 3.95>, <-1.15, 4>, <1.15, 4>, <1.2, 3.95>, <1, 0>, <0, 0> 
			sturm rotate <-90, 0, 0> translate <0, 4, 0.125> 
		}
		union {
			box { <-2, -1, -1>, <2, 5, 1> }
			cylinder { <-2, 0, 0>, <2, 0, 0>, 1 scale <1, 3, 0.1> 
				translate <0, 5, 0> }
		}
	}
	prism { linear_sweep cubic_spline 0, 0.25, 12, <-1, -3>, <0, -3>, <0.75, -3>,
		<0.3, -1.5>, <0.5, -0.5>, <0.95, 0.1>, <-0.95, 0.1>, <-0.5, -0.5>,
		<-0.3, -1.5>, <-0.75, -3>, <0, -3>, <1, -3> sturm rotate <-90, 0, 0>
		translate <0, 4, 0.125>
	}
}
#declare Spoon = union {
	difference {
		sphere { 0, 1.5 scale <1, 1.5, 0.5> }
		sphere { 0, 1.5 scale <1, 1.5, 0.5> translate <0, 0, -0.125> }
		box { <-3, 0, -2>, <3, 4, 2> }
		box { <-3, -4, -2>, <3, 4, 0> }
		translate <0, 6, -0.125>
	}
	difference {
		sphere { 0, 1.5 scale <1, 1, 0.5> }
		sphere { 0, 1.5 scale <1, 1, 0.5> translate <0, 0, -0.125> }
		box { <-3, -4, -2>, <3, 0, 2> }
		box { <-3, -4, -2>, <3, 4, 0> }
		translate <0, 6, -0.125>
	}
	difference {
		prism { linear_sweep cubic_spline 0, 0.25, 12, <-1, -3>, <0, -3>, 
			<0.75, -3>, <0.3, -1.5>, <0.5, -0.5>, <1, 1>, <-1, 1>, <-0.5, -0.5>, 
			<-0.3, -1.5>, <-0.75, -3>, <0, -3>, <1, -3> sturm 
			rotate <-90, 0, 0> translate <0, 4, 0.125> 
		}
		sphere { 0, 1.5 scale <1, 1.5, 0.5> translate <0, 6, -0.125> }
	}
}
#declare SpoonSpatula = union {
	object { Spoon translate <0, 9, 0> }
	object { Spatula rotate <0, 0, 180> translate <0, -9, 0> }
	prism { linear_sweep cubic_spline 0, 0.25, 9, <-1, 10>, <-0.8, 10>, <0.8, 10>, 
		<1.2, 0>, <0.8, -10>, <-0.8, -10>, <-1.2, 0>, <-0.8, 10>, <1, 10> sturm 
		rotate <-90, 0, 0> translate <0, 0, 0.125>  
	}
	rotate <90, 0, 0> rotate <0, 90, 0> rotate <0, 0, 1> translate <0, 0.35, 0>
	scale 0.2
	texture { SpoonSpatulaTex }
}
#end
//******************************************************************************************
//										  MICROSCOPE
//******************************************************************************************
#if(Microscope_Switch=on)
#declare Mirror_Y_Rotation=	10;
#declare Mirror_X_Rotation=	-10;
#declare Mirror_Z_Rotation=	0;

#declare ScrewAngle=seed(43278);
#declare MicroscopeColour=seed(43897);
#macro ColourVariance ()
texture {
        pigment { rgb <(rand(MicroscopeColour)/20)+0.95, (rand(MicroscopeColour)/20)+0.75,
        	(rand(MicroscopeColour)/20)+0.25> -(rand(MicroscopeColour)/5) }
        normal { gradient x 0.01 scale 0.005 }
        finish { metallic brilliance 3 specular 1.0 roughness 0.01 
        	reflection (rand(MicroscopeColour)/20)+0.15 
        	ambient (rand(MicroscopeColour)/20)+0.15 }
}
#end
#macro ScrewMake (ScrewSize)
#declare Screw = difference {
	sphere { 0, ScrewSize scale <1, 1, 0.5> }
	box { <-0.01, -1, -1>, <0.01, 1, -0.005> }
	box { <1, -0.01, -1>, <1, 0.01, -0.005> }
	rotate <0, 0, rand(ScrewAngle)*360> 
}
#end
#declare Control = union { 
	cylinder { <0, 0, 0>, <0, 0, 0.025>, 0.09 texture { MicroscopeMetalTex } }
	intersection {
		sphere { <0, 0, 0.125>, 0.15 }
		box { <-1, -1, 0.025>, <1, 1, 0.125> }
	}
	cylinder { <0, 0, 0.125>, <0, 0, 0.15>, 0.175 texture { MicroscopeMetalTex } }
	difference {
		cylinder { <0, 0, 0.15>, <0, 0, 0.225>, 0.355 }
		lathe { cubic_spline 7, <1, 0>, <0.33, 0>, <0.33, 0.01>, <0.23, 0.05>, 
			<0.05, 0.025>, <0, 0.035>, <-1, 0.035> sturm 
			rotate <-90, 0, 0> translate <0, 0, 0.235>
		}
		#declare CutCounter=0;
		#while(CutCounter<120)
			cylinder { <0.355, 0, -1>, <0.355, 0, 1>, 0.005
				rotate <0, 0, CutCounter*3> }
			#declare CutCounter=CutCounter+1;
		#end
	}
	torus { 0.34, 0.01 sturm rotate <90, 0, 0> translate <0, 0, 0.225> }
}
#declare Microscope = union {
	difference {
		intersection {
			box { <-1.2, 0, -1.3>, <1.3, 0.3, 1.3> }
			union {
				cylinder { <0, -1, 0>, <0, 1, 0>, 0.7 scale <3, 1, 1> 
					rotate <0, 20, 0> translate <0, 0, -1.2> }
				cylinder { <0, -1, 0>, <0, 1, 0>, 0.7 scale <3, 1, 1> 
					rotate <0, -20, 0> translate <0, 0, 1.2> }
				difference {
					box { <-2, -1, -2>, <1, 1, 2> }
					cylinder { <0, -2, 0>, <0, 2, 0>, 0.5 
						scale <1, 1, 1.8> translate <1, 0, 0> }
				}
			}
		}
		cylinder { <-0.9, -1, -0.6>, <-0.9, 1, -0.6>, 0.5 }
		box { <-2, -1, -2>, <-0.9, 1, -0.1> }
		cylinder { <-0.9, -1, 0.6>, <-0.9, 1, 0.6>, 0.5 }
		box { <-2, -1, 0.1>, <-0.9, 1, 2> }
		cylinder { <0, -1, 0>, <0, 1, 0>, 0.5 scale <3, 1, 1> rotate <0, 20, 0>
			translate <0, 0, -1.2> }
		box { <-1, -1, -1>, <1, 1, 1> rotate <0, 45, 0> translate <2, 0, -1.7> }
		cylinder { <0, -1, 0>, <0, 1, 0>, 0.5 scale <3, 1, 1> rotate <0, -20, 0>
			translate <0, 0, 1.2> }
		box { <-1, -1, -1>, <1, 1, 1> rotate <0, 45, 0> translate <2, 0, 1.7> }
		box { <-1, -1, -1>, <1, 1, 1> rotate <0, 0, 30> translate <-1.1, 1.3, 0> }
		box { <-1, -1, -1>, <1, 1, 1> rotate <0, 0, -30> rotate <0, 40, 0> 
			translate <1.1, 1.3, -1> }
		box { <-1, -1, -1>, <1, 1, 1> rotate <0, 0, -30> rotate <0, -40, 0> 
			translate <1.1, 1.3, 1> }
		ColourVariance ()
	}
	prism { linear_sweep cubic_spline 0, 0.1, 11,
		<0, -0.1>, <0, -0.1>, <0.1, 0.4>, <0.4, 0.7>, <0.4, 1.5>, <0.55, 1.7>,
		<0.7, 1.5>, <0.7, 0.3>, <0.9, 0>, <0, -0.1>, <-1, -0.1> 
		sturm rotate <-90, 0, 0> translate <-0.4, 0.3, -0.45>
		ColourVariance ()
	}
	prism { linear_sweep cubic_spline 0, 0.1, 11,
		<0, 0>, <0, 0>, <0.1, 0.4>, <0.4, 0.7>, <0.4, 1.5>, <0.55, 1.7>,
		<0.7, 1.5>, <0.7, 0.3>, <0.9, 0>, <0, 0>, <0, 0> 
		sturm rotate <-90, 0, 0> translate <-0.4, 0.3, 0.55>
		ColourVariance ()
	}
	intersection {
		union {
			cone { <0.15, 1.85, -0.45>, 0.13, <0.15, 1.85, -0.25>, 0.2 }
			cone { <0.15, 1.85, 0.25>, 0.2, <0.15, 1.85, 0.45>, 0.13 }
		}
		cylinder { <0.15, 1.85, -0.5>, <0.15, 1.85, 0.5>, 0.18 }
		ColourVariance ()
	}
	difference {
		cylinder { <0.15, 1.85, -0.6>, <0.15, 1.85, 0.6>, 0.13 }
		box { <-1, 1, -0.45>, <1, 3, 0.45> }
		sphere { <0.15, 1.85, 0>, 0.11 scale <1, 1, 0.5> translate <0, 0, -0.6> }
		sphere { <0.15, 1.85, 0>, 0.11 scale <1, 1, 0.5> translate <0, 0, 0.6> }
		ColourVariance ()
	}
	torus { 0.12, 0.01 sturm rotate <90, 0, 0> translate <0.15, 1.85, -0.6> 
		ColourVariance () }
	torus { 0.12, 0.01 sturm rotate <90, 0, 0> translate <0.15, 1.85, 0.6> 
		ColourVariance () }
	cone { <0.15, 1.85, -0.55>, 0.085, <0.15, 1.85, -0.61>, 0.065 
		ColourVariance () }
	cone { <0.15, 1.85, -0.55>, 0.085, <0.15, 1.85, 0.61>, 0.065 
		ColourVariance () }
	ScrewMake (0.06)
	object { Screw translate <0.15, 1.85, -0.61> ColourVariance () }
	ScrewMake (0.06)
	object { Screw rotate <0, 180, 0> translate <0.15, 1.85, 0.61> ColourVariance () }
	box { <-0.05, 1.55, -0.25>, <0.45, 2.05, 0.25> ColourVariance () }
	difference {
		box { <-0.05, 2.05, -0.25>, <0.45, 2.2, 0.25> }
		cylinder { <-1, 0, 0>, <1, 0, 0>, 0.1 scale <1, 1.6, 1> 
			translate <0, 2.2, -0.25> }
		cylinder { <-1, 0, 0>, <1, 0, 0>, 0.1 scale <1, 1.6, 1> 
			translate <0, 2.2, 0.25> }
		cylinder { <0, 0, -1>, <0, 0, 1>, 0.1 scale <1, 1.6, 1> 
			translate <0.45, 2.2, 0> }
		cylinder { <0, 0, -1>, <0, 0, 1>, 0.1 scale <1, 1.6, 1> 
			translate <-0.05, 2.2, 0> }
		ColourVariance ()
	}
	difference {
		prism { linear_sweep cubic_spline 0, 0.25, 9,
			<0, 0>, <0, 0>, <-0.3, 0.7>, <-0.1, 1.0>, <0.4, 1.4>, <0.6, 2.0>,
			<0.5, 0>, <0, 0>, <0, 0>
			sturm rotate <-90, 0, 0> translate <0.125, 2.1, 0.125>
		}
		box { <0.65, 2, -1>, <1, 5, 1> }
		prism { linear_sweep cubic_spline 0, 1, 7,
			<0, 0>, <0, 0>, <-0.2, 0.7>, <0.6, 1.0>, <0.6, 0>, <0, 0>, <0, 0>
			sturm rotate <-90, 0, 0> translate <0.35, 2.15, 0.5>
		}
		box { <0.35, 1, -1>, <1, 2.5, 1> }
		ColourVariance ()
	}
	difference {
		box { <0.65, 3.15, -0.2>, <0.85, 4.3, 0.2> }
		box { <0.75, 3, -0.15>, <1, 5, 0.15> }
		box { <0.7, 3, 0>, <1, 5, 0.1> }
		sphere { <0.71, 3.3, -0.2>, 0.04 }
		sphere { <0.71, 4.2, -0.2>, 0.04 }
		sphere { <0.71, 4.08, -0.2>, 0.04 }
		sphere { <0.71, 3.3, 0.2>, 0.04 }
		sphere { <0.71, 4.2, 0.2>, 0.04 }
		sphere { <0.71, 4.08, 0.2>, 0.04 }
		ColourVariance ()
	}
	ScrewMake (0.03)
	object { Screw rotate <0, 180, 0> translate <0.71, 4.2, 0.2> ColourVariance () }
	ScrewMake (0.03)
	object { Screw translate <0.71, 4.2, -0.2> ColourVariance () }
	ScrewMake (0.03)
	object { Screw rotate <0, 180, 0> translate <0.71, 4.08, 0.2> ColourVariance () }
	ScrewMake (0.03)
	object { Screw translate <0.71, 4.08, -0.2> ColourVariance () }
	ScrewMake (0.03)      
	object { Screw rotate <0, 180, 0> translate <0.71, 3.3, 0.2> ColourVariance () }
	ScrewMake (0.03)
	object { Screw translate <0.71, 3.3, -0.2> ColourVariance () }
	difference {
		box { <0.55, 3.5, -0.19>, <0.65, 4.3, 0.19> }
		box { <-1, 0, -1>, <0, 1, 1> rotate <0, 0, -50> translate <0.55, 4.2, 0> }
		box { <-1, -1, -1>, <0, 0, 1> rotate <0, 0, 50> translate <0.55, 3.6, 0> }
		sphere { <0.55, 4.125, -0.09>, 0.04 }
		sphere { <0.55, 3.675, -0.09>, 0.04 }
		sphere { <0.55, 4.125, 0.09>, 0.04 }
		sphere { <0.55, 3.675, 0.09>, 0.04 }
		ColourVariance ()
	}
	ScrewMake (0.03)
	object { Screw rotate <0, 90, 0> translate <0.55, 4.125, -0.09> ColourVariance () }
	ScrewMake (0.03)
	object { Screw rotate <0, 90, 0> translate <0.55, 4.125, 0.09> ColourVariance () }
	ScrewMake (0.03)
	object { Screw rotate <0, 90, 0> translate <0.55, 3.675, -0.09> ColourVariance () }
	ScrewMake (0.03)
	object { Screw rotate <0, 90, 0> translate <0.55, 3.675, 0.09> ColourVariance () }
	box { <0.76, 2.8, -0.14>, <0.9, 4.7, 0.14> ColourVariance () }
	difference {
		box { <0.71, 2.9, 0.01>, <0.8, 4.5, 0.09> }
		box { <0, 4.39, 0>, <0.73, 5, 1> }
		#declare CutCounter=0;
		#while(CutCounter<30)
			box { <-0.02, -0.02, 0>, <0.02, 0.02, 1> rotate <0, 0, 45>
				translate <0.71, (CutCounter/20)+2.9, 0> }
			#declare CutCounter=CutCounter+1;
		#end
		box { <0, 2, 0>, <0.73, 3.025, 1> }
		texture { MicroscopeMetalTex }
	}
	difference {
		box { <0.86, 3.1, -0.2>, <1.2, 4.7, 0.2> }
		cylinder { <1.17, 2, 0>, <1.17, 6, 0>, 0.21 }
		ColourVariance ()
	}		
	difference {
		box { <0.7, 4.7, -0.2>, <0.92, 4.74, 0.2> }
		sphere { <0.82, 4.74, 0>, 0.04 }
		ColourVariance ()
	}
	ScrewMake (0.03)
	object { Screw rotate <90, 0, 0> translate <0.82, 4.74, 0> ColourVariance () }
	difference {
		cylinder { <0.65, 3.9, -0.5>, <0.65, 3.9, 0.5>, 0.085 }
		box { <0, 3, -0.225>, <1, 5, 0.225> }
		sphere { <0.085, 0, 0>, 0.04 rotate <0, 0, 30> translate <0.65, 3.9, -0.3> }
		sphere { <0.085, 0, 0>, 0.04 rotate <0, 0, -60> translate <0.65, 3.9, 0.3> }
		ColourVariance ()
	}
	ScrewMake (0.03)
	object { Screw rotate <0, -90, 0> translate <0.085, 0, 0> rotate <0, 0, 30>
		translate <0.65, 3.9, -0.3> ColourVariance () }
	ScrewMake (0.03)
	object { Screw rotate <0, -90, 0> translate <0.085, 0, 0> rotate <0, 0, -60>
		translate <0.65, 3.9, 0.3> ColourVariance () }
	torus { 0.07, 0.015 sturm rotate <90, 0, 0> translate <0.65, 3.9, -0.225> 
		ColourVariance () }
	torus { 0.07, 0.015 sturm rotate <90, 0, 0> translate <0.65, 3.9, 0.225> 
		ColourVariance () }
	torus { 0.07, 0.015 sturm rotate <90, 0, 0> translate <0.65, 3.9, -0.5> 
		ColourVariance () }
	torus { 0.07, 0.015 sturm rotate <90, 0, 0> translate <0.65, 3.9, 0.5> 
		ColourVariance () }
	cylinder { <0.65, 3.9, -0.525>, <0.65, 3.9, 0.525>, 0.07 ColourVariance () }
	object { Control translate <0.65, 3.9, 0.525> ColourVariance () }
	object { Control rotate <0, 180, 0> translate <0.65, 3.9, -0.525> 
		ColourVariance () }
	difference {
		union {
			box { <1.2, 4.6, -0.15>, <1.55, 4.8, 0.15> }
			cylinder { <0, 0, -0.1>, <0, 0, 0.1>, 0.2 scale <1, 1.5, 1> 
				translate <1.3, 4.7, 0> }
		}
		cylinder { <1.17, 4, 0>, <1.17, 5, 0>, 0.21 }
		sphere { <1.55, 4.7, 0>, 0.04 }
		ColourVariance ()
	}
	ScrewMake (0.03)
	object { Screw rotate <0, -90, 0> translate <1.55, 4.7, 0> ColourVariance () }
	cylinder { <1.47, 4.7, -0.24>, <1.47, 4.7, 0>, 0.03 ColourVariance () }
	object { Control scale 0.5 rotate <0, 180, 0> translate <1.47, 4.7, -0.23> 
		ColourVariance () }
	sphere { <1.47, 4.7, 0.15>, 0.03 ColourVariance () }
	difference {
		union {
			cylinder { <0.45, 2.8, 0>, <0.45, 2.875, 0>, 0.07 }
			box { <0, 2.8, -0.07>, <0.45, 2.875, 0.07> }
		}
		cylinder { <0.45, 2, 0>, <0.45, 3, 0>, 0.05 }
		cylinder { <0, 2, 0>, <0, 6, 0>, 0.21 }
		rotate <0, 20, 0> translate <1.17, 0, 0>
		texture { MicroscopeMetalTex }
	}
	difference {
		union {
			cylinder { <0.45, 2.95, 0>, <0.45, 3.05, 0>, 0.07 }
			box { <0, 2.95, -0.07>, <0.45, 3.4, 0.07> }
			cylinder { <0.225, 3.4, -0.07>, <0.225, 3.4, 0.07>, 0.05 }
		}
		cylinder { <0.45, 3.225, -1>, <0.45, 3.225, 1>, 0.175 }
		box { <0.275, 3.225, -1>, <1, 4, 1> }
		sphere { <0.275, 3.3, 0>, 0.04 }
		cylinder { <0, 2, 0>, <0, 6, 0>, 0.21 }
		rotate <0, 20, 0> translate <1.17, 0, 0>
		texture { MicroscopeMetalTex }
	}
	ScrewMake (0.03)
	object { Screw rotate <0, -90, 0> translate <0.275, 3.3, 0> rotate <0, 20, 0> 
		translate <1.17, 0, 0> ColourVariance () }
	cylinder { <0.45, 2.75, 0>, <0.45, 3, 0>, 0.03 rotate <0, 20, 0> 
		translate <1.17, 0, 0> texture { MetalTex } }		
	object { Control scale 0.5 rotate <90, 0, 0> translate <0.45, 2.75, 0> 
		rotate <0, 20, 0> translate <1.17, 0, 0> ColourVariance () }
	difference {
		cylinder { <1.17, 2.6, 0>, <1.17, 5.1, 0>, 0.25 }
		cylinder { <1.17, 2, 0>, <1.17, 6, 0>, 0.2 }
		cylinder { <0, 2, -0.25>, <0, 6, -0.25>, 0.01 rotate <0, 20, 0>
			translate <1.17, 0, 0> }
		cylinder { <0, 2, -0.25>, <0, 6, -0.25>, 0.01 rotate <0, 200, 0>
			translate <1.17, 0, 0> }
		sphere { <1.17, 4.8, -0.25>, 0.04 }
		sphere { <1.17, 2.9, -0.25>, 0.04 }
		sphere { <0, 0, -0.25>, 0.04 rotate <0, 40, 0> translate <1.17, 2.8, 0> }
		sphere { <0, 0, -0.25>, 0.04 rotate <0, 40, 0> translate <1.17, 4.9, 0> }
		sphere { <1.17, 4.8, 0.25>, 0.04 }
		sphere { <1.17, 2.9, 0.25>, 0.04 }
		sphere { <0, 0, 0.25>, 0.04 rotate <0, 40, 0> translate <1.17, 2.8, 0> }
		sphere { <0, 0, 0.25>, 0.04 rotate <0, 40, 0> translate <1.17, 4.9, 0> }
		ColourVariance ()
	}
	ScrewMake (0.03)
	object { Screw translate <0, 0, -0.25> rotate <0, 40, 0> translate <1.17, 4.9, 0> 
		ColourVariance () }
	ScrewMake (0.03)
	object { Screw translate <0, 0, -0.25> rotate <0, 40, 0> translate <1.17, 2.8, 0> 
		ColourVariance () }
	ScrewMake (0.03)
	object { Screw translate <1.17, 4.8, -0.25> ColourVariance () }
	ScrewMake (0.03)
	object { Screw translate <1.17, 2.9, -0.25> ColourVariance () }
	ScrewMake (0.03)
	object { Screw translate <0, 0, 0.25> rotate <0, 40, 0> translate <1.17, 4.9, 0> 
		ColourVariance () }
	ScrewMake (0.03)
	object { Screw translate <0, 0, 0.25> rotate <0, 40, 0> translate <1.17, 2.8, 0> 
		ColourVariance () }
	ScrewMake (0.03)
	object { Screw translate <1.17, 4.8, 0.25> ColourVariance () }
	ScrewMake (0.03)
	object { Screw translate <1.17, 2.9, 0.25> ColourVariance () }
	torus { 0.23, 0.02 sturm translate <1.17, 2.58, 0> ColourVariance () }
	difference {
		cylinder { <1.17, 2.56, 0>, <1.17, 2.6, 0>, 0.23 }
		cylinder { <1.17, 2, 0>, <1.17, 3, 0>, 0.2 }
		ColourVariance ()
	}
	difference {
		cylinder { <1.17, 2.35, 0>, <1.17, 2.6, 0>, 0.2 }
		cone { <1.17, 2.34, 0>, 0.15, <1.17, 2.61, 0>, 0.19 }
		box { <1.07, 2.4, -1>, <1.27, 2.5, 0> }
		ColourVariance ()
	}
	difference {
		cylinder { <1.17, 2.39, 0>, <1.17, 2.51, 0>, 0.19 }
		cone { <1.17, 2.34, 0>, 0.14, <1.17, 2.61, 0>, 0.18 }
		texture { MicroscopeMetalTex }
	}
	difference {
		cone { <1.17, 2.45, -0.22>, 0.03, <1.17, 2.45, -0.1>, 0.02 }
		cone { <1.17, 2.34, 0>, 0.15, <1.17, 2.61, 0>, 0.19 }
		ColourVariance ()
	}
	cylinder { <1.17, 2.45, -0.26>, <1.17, 2.45, -0.22>, 0.05 ColourVariance () }
	difference {
		cylinder { <1.17, 2.1, 0>, <1.17, 2.35, 0>, 0.17 }
		cone { <1.17, 2.09, 0>, 0.1, <1.17, 2.36, 0>, 0.15 }
		ColourVariance ()
	}
	torus { 0.17, 0.03 sturm translate <1.17, 2.14, 0> ColourVariance () }
	torus { 0.17, 0.03 sturm translate <1.17, 2.2, 0> ColourVariance () }
	difference {
		cone { <1.17, 1.7, 0>, 0.13, <1.17, 2.1, 0>, 0.15 }
		cylinder { <1.17, 1, 0>, <1.17, 3, 0>, 0.1 }
		ColourVariance ()
	}
	torus { 0.115, 0.015 sturm translate <1.17, 1.7, 0> ColourVariance () }
	difference {
		cylinder { <1.17, 5.0, 0>, <1.17, 5.2, 0>, 0.23 }
		cylinder { <1.17, 4, 0>, <1.17, 6, 0>, 0.2 }
		ColourVariance ()
	}
	difference {
		cylinder { <1.17, 5.1, 0>, <1.17, 5.4, 0>, 0.21 }
		cone { <1.17, 5.09, 0>, 0.2, <1.17, 5.41, 0>, 0.1 }
		ColourVariance ()
	}
	torus { 0.23, 0.02 sturm translate <1.17, 5.165, 0> ColourVariance () }
	difference {
		cylinder { <1.17, 5.4, 0>, <1.17, 5.44, 0>, 0.23 }
		cylinder { <1.17, 5, 0>, <1.17, 6, 0>, 0.1 }
		ColourVariance ()
	}
	torus { 0.23, 0.02 sturm translate <1.17, 5.42, 0> ColourVariance () }
	difference {
		cylinder { <1.17, 5.4, 0>, <1.17, 5.74, 0>, 0.14 }
		cylinder { <1.17, 5, 0>, <1.17, 6, 0>, 0.1 }
		ColourVariance ()
	}
	difference {
		union {
			cylinder { <1.17, 5.74, 0>, <1.17, 5.8, 0>, 0.18 }
			torus { 0.18, 0.01 sturm translate <1.17, 5.79, 0> }
		}
		torus { 0.18, 0.018 sturm scale <1, 1.2, 1> translate <1.17, 5.75, 0> }
		sphere { 0, 0.18 scale <1, 0.5, 1> translate <1.17, 5.8, 0> }
		ColourVariance ()
	}
	difference {
		box { <-0.1, 1.5, -0.55>, <0.6, 1.55, 0.55> }
		box { <-1, 1, -1>, <0.3, 2, -0.25> }
		box { <-1, 1, 0.25>, <0.3, 2, 1> }
		cylinder { <0, 1, 0>, <0, 2, 0>, 0.3 scale <0.5, 1, 1> 
			translate <0.3, 0, -0.55> }
		cylinder { <0, 1, 0>, <0, 2, 0>, 0.3 scale <0.5, 1, 1> 
			translate <0.3, 0, 0.55> }
		ColourVariance ()
	}
	difference {
		box { <0.5, 1.49, -0.6>, <1.9, 1.65, 0.6> }
		box { <-1, -1, -1>, <0, 1, 1> rotate <0, 0, -40> translate <0.5, 1.5, 0> }
		box { <0, -1, -1>, <1, 1, 1> rotate <0, 0, 40> translate <1.9, 1.5, 0> }
		box { <0, -1, -0.56>, <0.7, 1.56, 0.56> }
		cylinder { <1.17, -1, 0>, <1.17, 2, 0>, 0.3 }
		cylinder { <1.17, 1.6, 0>, <1.17, 2, 0>, 0.35 }
		sphere { <0, 0.125, -0.5>, 0.04 rotate <0, 0, -40> translate <0.5, 1.5, 0> } 
		sphere { <0, 0.125, -0.2>, 0.04 rotate <0, 0, -40> translate <0.5, 1.5, 0> } 
		sphere { <0, 0.125, 0.2>, 0.04 rotate <0, 0, -40> translate <0.5, 1.5, 0> } 
		sphere { <0, 0.125, 0.5>, 0.04 rotate <0, 0, -40> translate <0.5, 1.5, 0> } 
		sphere { <0, 0.125, -0.5>, 0.04 rotate <0, 0, 40> translate <1.9, 1.5, 0> } 
		sphere { <0, 0.125, -0.2>, 0.04 rotate <0, 0, 40> translate <1.9, 1.5, 0> } 
		sphere { <0, 0.125, 0.2>, 0.04 rotate <0, 0, 40> translate <1.9, 1.5, 0> } 
		sphere { <0, 0.125, 0.5>, 0.04 rotate <0, 0, 40> translate <1.9, 1.5, 0> } 
		ColourVariance ()
	}
	ScrewMake (0.03)
	object { Screw rotate <0, 90, 0> translate <0, 0.125, -0.5> rotate <0, 0, -40> 
		translate <0.5, 1.5, 0> ColourVariance () }
	ScrewMake (0.03)
	object { Screw rotate <0, 90, 0> translate <0, 0.125, -0.2> rotate <0, 0, -40> 
		translate <0.5, 1.5, 0> ColourVariance () }
	ScrewMake (0.03)
	object { Screw rotate <0, 90, 0> translate <0, 0.125, 0.2> rotate <0, 0, -40> 
		translate <0.5, 1.5, 0> ColourVariance () }
	ScrewMake (0.03)
	object { Screw rotate <0, 90, 0> translate <0, 0.125, 0.5> rotate <0, 0, -40> 
		translate <0.5, 1.5, 0> ColourVariance () }
	ScrewMake (0.03)
	object { Screw rotate <0, -90, 0> translate <0, 0.125, -0.5> rotate <0, 0, 40> 
		translate <1.9, 1.5, 0> ColourVariance () }
	ScrewMake (0.03)
	object { Screw rotate <0, -90, 0> translate <0, 0.125, -0.2> rotate <0, 0, 40> 
		translate <1.9, 1.5, 0> ColourVariance () }
	ScrewMake (0.03)
	object { Screw rotate <0, -90, 0> translate <0, 0.125, 0.2> rotate <0, 0, 40> 
		translate <1.9, 1.5, 0> ColourVariance () }
	ScrewMake (0.03)
	object { Screw rotate <0, -90, 0> translate <0, 0.125, 0.5> rotate <0, 0, 40> 
		translate <1.9, 1.5, 0> ColourVariance () }
	object { Control rotate <0, 180, 0> scale 0.6 translate <0.8, 1.575, -0.6> 
		ColourVariance () }
	object { Control rotate <0, 180, 0> scale 0.6 translate <1.6, 1.575, -0.6> 
		ColourVariance () }
	difference {
		box { <0.6, 1.68, -0.5>, <1.7, 1.7, -0.3> }
		sphere { <1.2, 1.7, -0.4>, 0.04 }
		ColourVariance ()
	}
	cylinder { <1.7, 1.68, -0.4>, <1.7, 1.7, -0.4>, 0.1 ColourVariance () }
	cylinder { <1.72, 1.7, -0.4>, <1.72, 1.8, -0.4>, 0.05 ColourVariance () }
	torus { 0.04, 0.01 sturm translate <1.72, 1.8, -0.4> ColourVariance () }
	difference {
		box { <0.6, 1.68, 0.3>, <1.7, 1.7, 0.5> }
		sphere { <1.2, 1.7, 0.4>, 0.04 }
		ColourVariance ()
	}
	cylinder { <1.7, 1.68, 0.4>, <1.7, 1.7, 0.4>, 0.1 ColourVariance () }
	cylinder { <1.72, 1.7, 0.4>, <1.72, 1.8, 0.4>, 0.05 ColourVariance () }
	torus { 0.04, 0.01 sturm translate <1.72, 1.8, 0.4> ColourVariance () }
	ScrewMake (0.03)
	object { Screw rotate <90, 0, 0> translate <1.2, 1.7, -0.4> ColourVariance () }
	ScrewMake (0.03)
	object { Screw rotate <90, 0, 0> translate <1.2, 1.7, 0.4> ColourVariance () }
	difference {
		cylinder { <1.2, 1.7, -0.5>, <1.2, 1.7, 0.5>, 0.05 }
		box { <1, 1.7, -1>, <2, 2, 1> }
		box { <1, 1, -0.3>, <2, 2, 0.3> }
		ColourVariance ()
	}
	box { <0.65, 1.7, -0.45>, <0.75, 1.72, 0.45> texture { MicroscopeMetalTex } }
	intersection {
		box { <1.5, 1.65, -0.55>, <1.65, 2, 0.55> }
		prism { linear_sweep cubic_spline 0, 1, 10, <-2, -1>, <-1, -0.1>, 
			<-0.5, 0.07>, <-0.3, 0.07>, <0, 0.03>, <0.3, 0.07>, <0.5, 0.07>, 
			<1, -0.1>, <-1, -0.1>, <-2, -1> sturm 
			rotate <0, 90, 0> rotate <0, 0, 90> translate <1.7, 1.65, 0> 
		}
		texture { MicroscopeMetalTex }
	}
	cylinder { <0.2, 1.2, 0>, <0.2, 1.6, 0>, 0.12 ColourVariance () }
	torus { 0.12, 0.01 sturm translate <0.2, 1.19, 0> ColourVariance () }
	cylinder { <0.2, 0.5, 0>, <0.2, 0.7, 0>, 0.12 ColourVariance () }
	torus { 0.12, 0.01 sturm translate <0.2, 0.71, 0> ColourVariance () }
	torus { 0.1, 0.02 sturm translate <0.2, 0.5, 0> ColourVariance () }
	cylinder { <0.2, 0.48, 0>, <0.2, 0.6, 0>, 0.1 ColourVariance () }
	union {
		difference {
			union {
				torus { 0.11, 0.03 sturm translate <0, 1.15, 0> }
				cylinder { <0, 0.75, 0>, <0, 1.15, 0>, 0.14 }
				torus { 0.11, 0.03 sturm translate <0, 0.75, 0> }
			}
			cylinder { <-0.14, 0, 0>, <-0.14, 2, 0>, 0.01 }
			sphere { <0, 0.95, -0.14>, 0.04 }
			sphere { <0, 0.95, 0.14>, 0.04 }
		}
		ScrewMake (0.03)
		object { Screw translate <0, 0.95, -0.14> }
		ScrewMake (0.03)
		object { Screw translate <0, 0.95, 0.14> }
		cylinder { <0, 0.95, 0>, <0.15, 0.95, 0>, 0.07 }
		union {
			cylinder { <0, 0, 0>, <0.15, 0, 0>, 0.07 }
			intersection {
				torus { 0.09, 0.04 sturm rotate <90, 0, 0> }
				box { <0, 0, -1>, <1, 1, 1> }
				translate <0.15, -0.09, 0>
			}
			cylinder { <0.24, -0.2475, 0>, <0.24, -0.09, 0>, 0.04 }
			intersection {
				torus { 0.09, 0.04 sturm rotate <90, 0, 0> }
				box { <-1, -1, -1>, <0, 0, 1> }
				translate <0.33, -0.2475, 0>
			}
			cylinder { <0.33, -0.3375, 0>, <0.37, -0.3375, 0>, 0.05 }
			difference {
				cylinder { <0.9, -0.4, 0>, <0.9, -0.275, 0>, 0.55 }
				cylinder { <0.9, -1, 0>, <0.9, 0, 0>, 0.53 }
				box { <0.95, -1, -1>, <2, 0, 1> }
			}
			cylinder { <0.9, -0.325, -0.6>, <0.9, -0.325, 0.6>, 0.015 
				ColourVariance () }
			prism { linear_sweep linear_spline 0, 1.15, 7, <-0.4, -0.8>, 
				<0.4, -0.8>, <1, 0>, <0.4, 0.8>, <-0.4, 0.8>, <-1, 0>, 
				<-0.4, -0.8> rotate <90, 0, 0> scale <0.04, 0.04, 1> 
				translate <0.9, -0.325, -0.575> ColourVariance ()
			}
			union {
				difference {
					torus { 0.4, 0.1 sturm }
					sphere { 0, 0.5 scale <1, 0.2, 1> }
					cylinder { <0, -1, 0>, <0, 1, 0>, 0.4 }
					box { <-1, 0, -1>, <1, 1, 1> }
					translate <0, 0.075, 0>
				}
				torus { 0.5, 0.02 sturm translate <0, 0.025, 0> }
				cylinder { <0, -0.055, 0>, <0, 0.025, 0>, 0.52 }
				torus { 0.5, 0.02 sturm translate <0, -0.055, 0> }
				cylinder { <0, 0.025, 0>, <0, 0.045, 0>, 0.4 
					texture { MicroscopeMirrorTex } }
				rotate <0, 0, Mirror_Z_Rotation> translate <0.9, -0.325, 0>
				ColourVariance ()
			}
			rotate <Mirror_X_Rotation, 0, 0> translate <0, 0.95, 0> 
		}
		rotate <0, Mirror_Y_Rotation, 0> translate <0.2, 0, 0> 
		texture { MicroscopeMetalTex }
	}
	scale 1.3
}
#end
//******************************************************************************************
//											VIAL
//******************************************************************************************
#if(Vial_Switch=on)
#declare Vial = lathe { cubic_spline 17, <-1, 0>, <0, 0>, <1.5, 0>, <2, 0>, <3, 1>, 
	<3, 2>, <2, 4>, <1, 6>, <1.5, 7>, <1.4, 7>, <0.9, 6>, <1.9, 4>, <2.9, 2>, 
	<2.9, 1>, <1.9, 0.1>, <0, 0.1>, <-1, 0.1> translate <0, 0.08, 0> scale 0.3 
	texture { MorphusFlaskTex } 
}
#end
//******************************************************************************************
//										      SLIDES
//******************************************************************************************
#if(Slides_Switch=on)
#declare Smudge=seed(89432);
#declare Slide = merge {
	difference {
		box { <-0.8, 0, -0.4>, <0.8, 0.02, 0.4> }
		cylinder { <0, -1, 0>, <0, 1, 0>, 0.35 }
		cylinder { <-1, 0, 0>, <1, 0, 0>, 0.05 scale <1, 0.05, 1> 
			translate <0, 0.02, 0> }
		texture { FrostedSlideTex }
	}
	cylinder { <0, 0.005, 0>, <0, 0.015, 0>, 0.35 texture { SlideTex } }
	intersection {
		sphere { 0, 0.1 translate <0, 0.015, 0> }
		box { <-0.35, 0.0151, -0.35>, <0.35, 0.1, 0.35> }
		scale <1, 0.1, 1>
		pigment { rgb 1 }
		finish { specular 0.7 roughness 0.1 ambient 0.2 }
	} 
}
#declare SlideSmudge1 = intersection {
	#declare SmudgeCount=0;
	blob { threshold 0.5
		#while(SmudgeCount<25)
			sphere { 0, rand(Smudge)+1, rand(Smudge)+1
				scale <1, 0.1, (rand(Smudge)*2)+2>
				rotate <0, rand(Smudge)*360, 0>
				translate <(rand(Smudge)*3)-1.5, 0, 
					(rand(Smudge)*3)-1.5>
			}
			#declare SmudgeCount=SmudgeCount+1;
		#end
		scale 0.05 translate <0, 0.015, 0>
	}
	box { <-0.35, 0.0151, -0.35>, <0.35, 0.1, 0.35> }
	texture { SlideSmudge1Tex } 
}
#declare SlideSmudge2 = intersection {
	#declare SmudgeCount=0;
	blob { threshold 0.5
		#while(SmudgeCount<25)
			sphere { 0, rand(Smudge)+1, rand(Smudge)+1
				scale <1, 0.1, (rand(Smudge)*2)+2>
				rotate <0, rand(Smudge)*360, 0>
				translate <(rand(Smudge)*3)-1.5, 0, 
					(rand(Smudge)*3)-1.5>
			}
			#declare SmudgeCount=SmudgeCount+1;
		#end
		scale 0.05 translate <0, 0.015, 0>
	}
	box { <-0.35, 0.0151, -0.35>, <0.35, 0.1, 0.35> }
	texture { SlideSmudge2Tex } 
}
#declare Slide1 = union {
	object { Slide }
	object { SlideSmudge1 }
	scale 1.2
}
#declare Slide2 = union {
	object { Slide }
	object { SlideSmudge2 }
	scale 1.2
}
#end	
//******************************************************************************************
//										      POTTLE
//******************************************************************************************
#if(Pottle_Switch=on)
#declare PottleBasic = merge {
	box { <-2, -4, -4>, <2, 4, 4> }           box { <-4, -4, -2>, <4, 4, 2> }
	box { <-2, -6, -2>, <2, 6, 2> }
	cylinder { <2, -4, 2>, <2, 4, 2>, 2 }	  cylinder { <2, -4, -2>, <2, 4, -2>, 2 }
	cylinder { <-2, -4, 2>, <-2, 4, 2>, 2 }   cylinder { <-2, -4, -2>, <-2, 4, -2>, 2 }
	sphere { <2, -4, 2>, 2 }                  sphere { <2, -4, -2>, 2 }
	sphere { <-2, -4, 2>, 2 }                 sphere { <-2, -4, -2>, 2 }
	cylinder { <-2, -4, 2>, <2, -4, 2>, 2 }   cylinder { <-2, -4, -2>, <2, -4, -2>, 2 }
	cylinder { <-2, -4, -2>, <-2, -4, 2>, 2 } cylinder { <2, -4, -2>, <2, -4, 2>, 2 }
	sphere { <2, 4, 2>, 2 }                   sphere { <2, 4, -2>, 2 }
	sphere { <-2, 4, 2>, 2 }                  sphere { <-2, 4, -2>, 2 }
	cylinder { <-2, 4, 2>, <2, 4, 2>, 2 }     cylinder { <-2, 4, -2>, <2, 4, -2>, 2 }
	cylinder { <-2, 4, -2>, <-2, 4, 2>, 2 }   cylinder { <2, 4, -2>, <2, 4, 2>, 2 }
}
#declare Pottle = difference {
	merge {
		object { PottleBasic }
		cone { <0, 5, 0>, 2, <0, 9, 0>, 3 }
		torus { 2.5, 0.5 sturm translate <0, 9, 0> }
	}
	object { PottleBasic scale 0.8 }
	cone { <0, 5, 0>, 1, <0, 9.1, 0>, 2 }
	translate <0, 6, 0>
}
#declare PottleStopper = difference {
	cylinder { <0, 15, 0>, <0, 18, 0>, 2 }
	sphere { 0, 1.5 scale <1, 0.7, 1> translate <0, 18, 0> }
	texture { PottleTopTex }
}
#declare Pottle = union {
	object { Pottle texture { PottleTex } }
	object { PottleStopper }
	scale 0.07
}
#end
//******************************************************************************************
//										      PENCIL
//******************************************************************************************
#if(Pencil_Switch=on)
#declare PencilCutAngle=seed(43784);
#declare PencilCuts = union {
	#declare PencilCutCount=0;
	#while(PencilCutCount<20)
		box { <-2, -1, -1>, <2, 10, 0> rotate <-10-(rand(PencilCutAngle)*10), 0, 0>
			rotate <0, PencilCutCount*36+(rand(PencilCutAngle)*10), 0>
		}
		#declare PencilCutCount=PencilCutCount+1;
	#end
} 
#declare Pencil = union {
	difference {
		prism { linear_sweep linear_spline 0, 40.1, 7, <0, 0>, <1, 0>, <2, 1>, 
			<1, 2>, <0, 2>, <-1, 1>, <0, 0> sturm translate <-0.5, 0, -1>
			texture { PencilTex } }
		box { <-2, 40, -2>, <2, 41, 2> texture { PencilCutTex } }
		object { PencilCuts texture { PencilCutTex } }
	}
	difference {
		cylinder { <0, 0, 0>, <0, 40.1, 0>, 0.5 }
		object { PencilCuts translate <0, -0.1, 0> }
		texture { PencilLeadTex }
	}
	rotate <90, 0, 0> translate <0, 1, 0> scale 0.1
}
#end
//******************************************************************************************
//									     PESTLE & MORTAR
//******************************************************************************************
#if(Pestle_Switch=on)
#declare Pestle = union {
	lathe { cubic_spline 9, <-1, 0>, <0, 0>, <2, 1>, <1.8, 4>, <1, 12>, <1.2, 15>, 
		<2, 16>, <0, 17>, <-1, 17> sturm scale 0.2 
		texture { PestleTex translate <7, 0, 0> } 
		rotate <0, 0, -35> translate <0, 0.65, 0>
	}
	torus { 0.75, 0.25 sturm translate <0, 0.25, 0> }
	lathe { cubic_spline 9, 
		<-1, 0>, <0, 0>, <0.9, 0>, <1.5, 0.7>, <1.6, 1.5>, <1.2, 1.5>, 
		<1.2, 0.9>, <0, 0.4>, <-1, 0.4> sturm 
		scale 1 translate <0, 0.25, 0> 
		texture { PestleTex }
	}
	texture { PestleTex }
	scale 0.8
}
#end
//******************************************************************************************
//										    ASSEMBLE
//******************************************************************************************
#declare Lab = union {
	#if(Room_Switch=on)
		object { Room }
	#end
	#if(Cobweb_Switch=on)
		object { Cobweb translate <1.4, 11, 15.1> }
	#end
	#if(Scrolls_Switch=on)
		object { ScrollCase translate <0.2, 0, 0.5> }
	#end
	#if(Dice_Switch=on)
		object { Dice rotate <0, -40, 0> translate <7.4, 6.5, 11.5> }
	#end
	#if(Morphus_Switch=on)
		object { MorphusFlask translate <10, 6.5, 11.8> }
	#end
	#if(Shelf_Switch=on)
		object { Shelf }
	#end
	#if(Table_Switch=on)
		object { Table }
	#end
	#if(Caddy_Switch=on)
		object { Caddy rotate <0, -5, 0> translate <-11, 3, 13.2> } 
	#end
	#if(Mug_Switch=on)
		object { Mug rotate <0, 10, 0> translate <-9.5, 3, 11> }
	#end
	#if(Lamp_Switch=on)
		object { Lamp translate <-7, 3, 12> }
	#end
	#if(TubeRack_Switch=on)
		object { TestTubeRack translate <-1, 0, 0> }
	#end
	#if(Bottles_Switch=on)
		object { Bottle1 translate <9.6, 0, 12.2> }
		object { Bottle2 translate <12.3, 0, 14> }
	#end
	#if(Scales_Switch=on)
		object { Scales rotate <0, 5, 0> translate <-6.1, 0, 4.5> }
	#end
	#if(Hourglass_Switch=on)
		object { Hourglass rotate <0, -10, 0> translate <-3.4, 0, 8> }
	#end
	#if(Book_Switch=on)
		object { Book rotate <0, 15, 0> translate <3.8, 0, 3.3> }
	#end
	#if(PinceNez_Switch=on)
		object { PinceNez rotate <0, 30, 0> rotate <0, 0, 7> 
			translate <-2, 1.3, 2>	rotate <0, 15, 0> translate <3.8, 0, 3.3> }
	#end
	#if(Weights_Switch=on)
		object { Weight1 rotate <0, 70, 0> translate <-6.2, 0, 0.9> }
		object { Weight2 rotate <0, 130, 0> translate <-5.2, 0, 0.9> }
		object { Weight2 rotate <0, -30, 0> translate <-6.4, 0, 0.3> }
		object { Weight5 rotate <0, 50, 0> translate <-5.2, 0, 1.9> }
		object { Weight10 rotate <0, -50, 0> translate <-7.1, 0, 1.0> }
		object { Weight10 rotate <0, 140, 0> translate <-6.1, 0, 1.6> }
		object { Weight20 rotate <0, 0, 0> translate <-7, 0, 1.8> }
	#end
	#if(SpoonSpatula_Switch=on) 
		object { SpoonSpatula rotate <0, -20, 0> translate <-1, 0, 1.5> }
	#end
	#if(Microscope_Switch=on)
		object { Microscope rotate <0, -40, 0> translate <-1, 0, -1> }
	#end
	#if(Vial_Switch=on)
		object { Vial translate <-6, 0, -2> }
	#end
	#if(Slides_Switch=on)
		object { Slide1 rotate <0, 10, 0> translate <2, 0, 0> }
		object { Slide2 rotate <0, 40, 0> translate <2.5, 0, 1.5> }
	#end
	#if(Pottle_Switch=on)
		object { Pottle rotate <0, 20, 0> translate <3.5, 0, 0> }
	#end
	#if(Pencil_Switch=on)
		object { Pencil rotate <0, 75, 0> translate <1, 0, -1.7> }
	#end
	#if(Pestle_Switch=on)
		object { Pestle rotate <0, -30, 0> translate <6, 0, -1> }
	#end
}
//******************************************************************************************
//										     DISPLAY
//******************************************************************************************
object { Lab }
sky_sphere { pigment { gradient y color_map { [ 0.0 rgb <0.2, 0.25, 0.3> ] 
	[ 1.0 rgb <0.0, 0.05, 0.1> ] } scale 0.5 }
        pigment { bozo color_map { [ 0.001 rgbf <1, 1, 1, 0.2> ]
        [ 0.01 rgbf <1, 1, 1, 1> ] } scale 0.005 } 
}
camera { location <0, 0, -15> look_at <0, 0, 0> direction 1.5*z rotate <15, 0, 0> 
	translate <0, 4.5, 0> }
