#include "colors.inc"

#declare STEPS=3;
#declare T=150;
#declare H=200;
#declare D=40;
#declare R=3;

#declare SeitenT=texture {pigment {gradient y triangle_wave color_map {[0 White][1 0.5*White]}} scale 2}
#declare BindungT=texture {pigment {checker Black, Red turbulence 1}}
#declare HuellenT=texture {pigment {rgb <1, 0.2, 0.2>} finish {ambient 0.4}}

#declare DeckelRandO=bicubic_patch {type 1 u_steps STEPS v_steps STEPS
	<0, 2, 0>, <T/2, 2, 0>, <T/2, 2, 0>, <T, 2, 0>,
	<0, 2, R>, <T/2, 2, R>, <T/2, 2, R>, <T+R, 2, R>,
	<0, 0, R>, <T/2, 0, R>, <T/2, 0, R>, <T+R, 0, R>,
	<0, 0, 0>, <T/2, 0, 0>, <T/2, 0, 0>, <T, 0, 0>}
#declare DeckelRandS=bicubic_patch {type 1 u_steps STEPS v_steps STEPS
	<0, 2,  0>, <0, 2, H/2>, <0, 2, H/2>, <0, 2, H>,
	<R, 2, -R>, <R, 2, H/2>, <R, 2, H/2>, <R, 2, H+R>,
	<R, 0, -R>, <R, 0, H/2>, <R, 0, H/2>, <R, 0, H+R>,
	<0, 0,  0>, <0, 0, H/2>, <0, 0, H/2>, <0, 0, H>}
#declare Deckel=union {box {0, <T, 2, H>} object {DeckelRandO scale <1, 1, -1>}
	object {DeckelRandS translate T*x} object {DeckelRandO translate H*z}}

#declare HRueckenRand=union {bicubic_patch {type 1 u_steps STEPS v_steps STEPS
		<0, 2, 0>, <1, 2, 0>, <1, 2, 0>, <2, 2, 0>,
		<0, 2, R>, <1, 2, R>, <1, 2, R>, <2, 2, R>,
		<0, 0, R>, <1, 0, R>, <1, 1, R>, <2, 1, R>,
		<0, 0, 0>, <1, 0, 0>, <1, 1, 0>, <2, 1, 0>}
	bicubic_patch {type 1 u_steps STEPS v_steps STEPS
		<2, 2, 0>, <3, 2, 0>, <3, 1, 0>, <4, 1, 0>,
		<2, 2, R>, <3, 2, R>, <3, 1, R>, <4, 1, R>,
		<2, 1, R>, <3, 1, R>, <3, 0, R>, <4, 0, R>,
		<2, 1, 0>, <3, 1, 0>, <3, 0, 0>, <4, 0, 0>}
	bicubic_patch {type 1 u_steps STEPS v_steps STEPS
		<4, 1, 0>, <5, 1, 0>, <3+D/5, 0, 0>, <3+D/5, D/2, 0>,
		<4, 1, R>, <5, 1, R>, <3+D/5, 0, R>, <3+D/5, D/2, R>,
		<4, 0, R>, <5, 0, R>, <4+D/5, 0, R>, <4+D/5, D/2, R>,
		<4, 0, 0>, <5, 0, 0>, <4+D/5, 0, 0>, <4+D/5, D/2, 0>}
}
#declare HRueckenI=union {bicubic_patch {type 1 u_steps STEPS v_steps STEPS
		<0, 0, 0>, <0, 0, H/2>, <0, 0, H/2>, <0, 0, H>,
		<1, 0, 0>, <1, 0, H/2>, <1, 0, H/2>, <1, 0, H>,
		<1, 1, 0>, <1, 1, H/2>, <1, 1, H/2>, <1, 1, H>,
		<2, 1, 0>, <2, 1, H/2>, <2, 1, H/2>, <2, 1, H>}
	bicubic_patch {type 1 u_steps STEPS v_steps STEPS
		<2, 1, 0>, <2, 1, H/2>, <2, 1, H/2>, <2, 1, H>,
		<3, 1, 0>, <3, 1, H/2>, <3, 1, H/2>, <3, 1, H>,
		<3, 0, 0>, <3, 0, H/2>, <3, 0, H/2>, <3, 0, H>,
		<4, 0, 0>, <4, 0, H/2>, <4, 0, H/2>, <4, 0, H>}
	bicubic_patch {type 1 u_steps STEPS v_steps STEPS
		<4, 0, 0>, <4, 0, H/2>, <4, 0, H/2>, <4, 0, H>,
		<5, 0, 0>, <5, 0, H/2>, <5, 0, H/2>, <5, 0, H>,
		<4+D/5, 0, 0>, <4+D/5, 0, H/2>, <4+D/5, 0, H/2>, <4+D/5, 0, H>,
		<4+D/5, D/2, 0>, <4+D/5, D/2, H/2>, <4+D/5, D/2, H/2>, <4+D/5, D/2, H>}}
#declare HRueckenA=union {bicubic_patch {type 1 u_steps STEPS v_steps STEPS
		<0, 2, 0>, <0, 2, H/2>, <0, 2, H/2>, <0, 2, H>,
		<1, 2, 0>, <1, 2, H/2>, <1, 2, H/2>, <1, 2, H>,
		<1, 2, 0>, <1, 2, H/2>, <1, 2, H/2>, <1, 2, H>,
		<2, 2, 0>, <2, 2, H/2>, <2, 2, H/2>, <2, 2, H>}
	bicubic_patch {type 1 u_steps STEPS v_steps STEPS
		<2, 2, 0>, <2, 2, H/2>, <2, 2, H/2>, <2, 2, H>,
		<3, 2, 0>, <3, 2, H/2>, <3, 2, H/2>, <3, 2, H>,
		<3, 1, 0>, <3, 1, H/2>, <3, 1, H/2>, <3, 1, H>,
		<4, 1, 0>, <4, 1, H/2>, <4, 1, H/2>, <4, 1, H>}
	bicubic_patch {type 1 u_steps STEPS v_steps STEPS
		<4, 1, 0>, <4, 1, H/2>, <4, 1, H/2>, <4, 1, H>,
		<5, 1, 0>, <5, 1, H/2>, <5, 1, H/2>, <5, 1, H>,
		<3+D/5, 0, 0>, <3+D/5, 0, H/2>, <3+D/5, 0, H/2>, <3+D/5, 0, H>,
		<3+D/5, D/2, 0>, <3+D/5, D/2, H/2>, <3+D/5, D/2, H/2>, <3+D/5, D/2, H>}}
#declare HRuecken=union {object {HRueckenI} object {HRueckenA}
	object {HRueckenRand scale <1, 1, -1>}
	object {HRueckenRand translate H*z}
	scale <-1, 1, 1>}
#declare HHuelle=union {object {Deckel}	object {HRuecken}}
#declare Huelle=union {object {HHuelle}
	object {HHuelle scale <1, -1, 1> translate D*y}
	texture {HuellenT}}
#declare HSeitenO=bicubic_patch {type 1 u_steps STEPS v_steps STEPS
	<-4-D/8, D/2, 0>, <T/2 , D/2, 0>, <T/2 , D/2, 0>, <T-D/8 , D/2, 0>,
	<-4-D/8, D/3, 0>, <T/2-D/8, D/3, 0>, <T/2-D/8, D/3, 0>, <T-D/8, D/3, 0>,
	<-4-D/8, D/6, 0>, <T/2-D/2, D/6, 0>, <T/2-D/8, D/6, 0>, <T-D/8, D/6, 0>,
	<-4, 2, 0>, <T/2, 2, 0>, <T/2, 2, 0>, <T, 2, 0>}
#declare HSeitenS=bicubic_patch {type 1 u_steps STEPS v_steps STEPS
	<-D/8, D/2, 0>, <-D/8, D/2, H/2>, <-D/8, D/2, H/2>, <-D/8, D/2, H>,
	<-D/8, D/3, 0>, <-D/8, D/3, H/2>, <-D/8, D/3, H/2>, <-D/8, D/3, H>,
	<-D/8, D/6, 0>, <-D/8, D/6, H/2>, <-D/8, D/6, H/2>, <-D/8, D/6, H>,
	<0, 2, 0>, <0, 2, H/2>, <0, 2, H/2>, <0, 2, H>}
#declare HSeiten=union {object {HSeitenO} object {HSeitenO translate H*z}
	object {HSeitenS translate T*x}}
#declare Seiten=union {object {HSeiten}
	object {HSeiten scale <1, -1, 1> translate D*y} texture {SeitenT}}
#declare HBindungRand=bicubic_patch {type 1 u_steps STEPS v_steps STEPS
		<4+D/8, D/2, 0>, <4+D/8, D/2, 1>, <5+D/8, D/2, 1>, <5+D/8, D/2, 0>,
		<4+D/8, D/3, 0>, <4+D/8, D/3, 1>, <5+D/8, D/3, 1>, <5+D/8, D/3, 0>,
		<4+D/8, D/6, 0>, <4+D/8, D/6, 1>, <5+D/8, D/6, 1>, <5+D/8, D/6, 0>,
		<3, 2, 0>, <3, 2, 1>, <4, 1, 1>, <4, 1, 0> scale <-1, 1, 1>}

#declare HBindung=union {bicubic_patch {type 1 u_steps STEPS v_steps STEPS
		<5+D/8, D/2, 0>, <5+D/8, D/2, H/2>, <5+D/8, D/2, H/2>, <5+D/8, D/2, H>,
		<5+D/8, D/3, 0>, <5+D/8, D/3, H/2>, <5+D/8, D/3, H/2>, <5+D/8, D/3, H>,
		<5+D/8, D/6, 0>, <5+D/8, D/6, H/2>, <5+D/8, D/6, H/2>, <5+D/8, D/6, H>,
		<4    , 1  , 0>, <4    , 1  , H/2>, <4    , 1  , H/2>, <4    , 1  , H>
		scale <-1, 1, 1>}
	object {HBindungRand scale <1, 1, -1>}
	object {HBindungRand translate H*z}}
#declare Bindung=union {object {HBindung}
	object {HBindung scale <1, -1, 1> translate D*y} texture {BindungT}}
#declare Titelbild=union {
	union {
		difference {box {<3, 3, 0>, <T-3, H-3, 1>}
			box {<6, 6, -1>, <T-6, H-6, 2>}}
		difference {box {<7, 7, 0>, <T-7, H-7, 1>}
			box {<8, 8, -1>, <T-8, H-8, 2>}}
		pigment {Black}}
	box {<-0.5, -0.5, 0>, <0.5, 0.5, 1> texture {pigment {White} finish {ambient 0.4}}
		texture {pigment {image_map {gif "saturn.gif" once}
			translate <-0.5, -0.5, 0> scale 0.97} finish {ambient 0.4}}
		scale 120*<1, 732/959, 1> translate <75, 138, 0>}
	text {ttf "timrom.ttf" "Creating" 1, 0 scale 30 translate <23, 65, 0>}
	text {ttf "timrom.ttf" "Worlds" 1, 0 scale 30 translate <31, 35, 0>}
//	text {ttf "timrom.ttf" "A starters guide" 1, 0 scale 15 translate <26, 20, 0>}
	text {ttf "timrom.ttf" "A starters guide" 1, 0 scale 20 translate <10, 15, 0>}
	pigment {Black}}
#declare Buch=union {object {Huelle} object {Seiten} object {Bindung}
	object {Titelbild rotate 90*x translate (D+0.001)*y}}

/*
//camera {location <300, 600, -1000> look_at <T, D, H>/2 angle 20}
camera {location <T, D, H>/2+1000*y look_at <T, D, H>/2 angle 20}
light_source {<200, 1000, -100> color White}
background {Black}

object {Buch}
*/