#include "colors.inc" /* Only needed because woods.inc is buggy */
#include "metals.inc"
#include "woods.inc"

#declare RErd=200;   /* Erdradius */
#declare EarthImage="earthcolorlarge.png"
#declare EarthBumps="earthlandelevation.png"
#declare AchsNeigung=23+27/60; /* Neigung der Erdachse gegen die Ekliptik */
#declare HFrame=10;  /* Hhe des Rahmens ber der Erde */
#declare RFrame=10;  /* Dicke des Rahmens in radialer Richtung */
#declare DFrame=5;   /* Dicke des Rahmens in der anderen Richtung */
#declare RJunct=30;  /* Radius der Ausrundungen in den Rahmenverbindungen */
#declare DJunct=2;   /* Dicke der Rahmenverbindungen */
#declare RKante=0.6; /* Radius der Kantenausrundungen */
#declare RSkala=5;   /* Hhe (in radialer Richtung) der Skala. Beschriftung
	braucht zustzlich fest 4, sollte auf den Rahmen passen */
#declare DSkala=0.5; /* Dicke der Skala */
#declare HFuss=100;  /* Hhe des Fues */
#declare RFuss=10;   /* Radius des Fues (unten wird er aber dicker!) */
#declare HFussJoint=50; /* Hhe des Verbindungsstckes Fu-Rahmen */
#declare DBoden=15;  /* Dicke der Bodenplatte */
#declare RBoden=150; /* Radius der Bodenplatte */
#declare RahmenT=texture {T_Chrome_4A}
#declare SkalaT=texture {pigment {rgb <0, 0, 0>}}
#declare BodenT1=texture {pigment {P_WoodGrain12A color_map {M_Wood12A}}
	normal {bozo turbulence 0.04 lambda 2.5 omega 0.1  octaves 7
	scale <0.5, 0.05, 0.05>}
	finish {specular 0.3}}
#declare BodenT2=texture {pigment{P_WoodGrain12B color_map {M_Wood12B}}
	normal {wood turbulence <0.1, 0.04, 1>	scale <0.15, 0.5, 1>
	rotate x*2}
	finish {specular 0.3}}
#declare BodenT=texture {BodenT1 scale 100} texture {BodenT1 scale 100}
	


/* Ring wie Torus, aber rechteckiger Querschnitt mit abgerundeten Ecken.
   Liegt wie Torus zentrisch in der xz-Ebene um den Ursprung
   Ra - Auenradius, 0 < Ra
   Ri - Innenradius, 0 < Ri < Ra
   D - Dicke, 0 < D
   Re - Abrundungsradius der Kanten, 0 < Re < D/2 */
#macro Ring(Ra, Ri, D, Re) union {
/* Both versions work, the latter is a little faster
	lathe {linear_spline 9, <Ri, -D/2+Re>, <Ri+Re, -D/2>, <Ra-Re, -D/2>,
		<Ra, -D/2+Re>, <Ra, D/2-Re>, <Ra-Re, D/2>, <Ri-Re, D/2>,
		<Ri, D/2-Re>, <Ri, -D/2+Re>}
*/
	difference {cylinder {-D/2*y, D/2*y, Ra-Re}
		cylinder {-D*y, D*y, Ri+Re}}
	difference {cylinder {-(D/2-Re)*y, (D/2-Re)*y, Ra}
		cylinder {-D*y, D*y, Ri}}
	torus {Ri+Re, Re translate (-D/2+Re)*y}
	torus {Ri+Re, Re translate (D/2-Re)*y}
	torus {Ra-Re, Re translate (-D/2+Re)*y}
	torus {Ra-Re, Re translate (D/2-Re)*y}}
#end

/* Hilfsmacro fr Joint() */
#macro JointKegel(Ra, Ri, Rc, Re) difference {
	#local Phi=degrees(asin(Rc/Ra));
	#local P1=vrotate(<Re, sqrt(pow(Ra-Re, 2)-Re*Re), 0>, -Phi*z);
	#local P2=vrotate(<Re, sqrt(pow(Ri+Re, 2)-Re*Re), 0>, -Phi*z);
	lathe {linear_spline 7, <0, Ra>,
		vrotate(<0, Ra/sqrt(1-pow(Rc/Ra, 2)), 0>, -Phi*z), 
		vrotate(<Re*Ra/(Ra-Re), Ra*sqrt(1-pow(Re/(Ra-Re), 2)), 0>, -Phi*z),
		vrotate(<0, sqrt(pow((Ra-Re), 2)-Re*Re), 0>, -Phi*z),
		vrotate(<0, sqrt(pow((Ri+Re), 2)-Re*Re), 0>, -Phi*z),
		vrotate(<Re*Ri/(Ri+Re), Ri*sqrt(1-pow(Re/(Ri+Re), 2)), 0>, -Phi*z),
		<0, Ri*sqrt(1-pow(Rc/Ra, 2))>}
	torus {P1.x, Re translate P1.y*y} torus {P2.x, Re translate P2.y*y}}
#end

/* Element zur Verbindung von 2 rechtwinklig aufeinanderstehenden Ringen.
   Liegt an der Y-Achse, zeigt in die Richtungen +X und +Z
   Ra - Auenradius, 0 < Ra
   Ri - Innenradius, 0 <= Ri < Ra
   Rc - Radius der Ausrundung, 0 < Rc < Ra/sqrt(2)
   Re - Abrundungsradius der Kanten, 0 <= Re < (Ra-Ri)/2 */
#macro Joint(Ra, Ri, Rc, Re) difference {
	#local Alpha=asin(sqrt(2)*Rc/Ra);
	#local Beta=asin(1/sqrt(pow(Ra/Rc, 2)-1));
	sphere {0, Ra} sphere {0, Ri} plane {x, 0} plane {y, 0} plane {z, 0}
	object {JointKegel(Ra, Ri, Rc, Re) rotate <degrees(Alpha), 45, 0>}
	plane {-x, 0 rotate -degrees(Beta)*z}
	plane {-z, 0 rotate degrees(Beta)*x}
	bounded_by {box {<0, Ri*cos(2*Alpha), 0>,
		<Ra*sin(Beta), Ra, Ra*sin(Beta)>}}}
#end
#macro Joint4(Ra, Ri, Rc, Re) union {
	object {Joint(Ra, Ri, Rc, Re)}
	object {Joint(Ra, Ri, Rc, Re) scale <-1, 1, 1>}
	object {Joint(Ra, Ri, Rc, Re) scale <1, 1, -1>}
	object {Joint(Ra, Ri, Rc, Re) scale <-1, 1, -1>}}
#end	 
#macro Joint8(Ra, Ri, Rc, Re) union {
	object {Joint4(Ra, Ri, Rc, Re)}
	object {Joint4(Ra, Ri, Rc, Re) scale <1, -1, 1>}}
#end	 

/* Die Skalenteilung fr eine Seite eines Rings */
#declare Teilung=union {difference {
		cylinder {-0.001*y, 0.001*y, RErd+HFrame+RSkala*0.75+DSkala/2}
		cylinder {-0.002*y, 0.002*y, RErd+HFrame+RSkala*0.75-DSkala/2}}
	#declare I=0;
	#while (I<360)
		box {<RErd+HFrame+RKante, -0.001, -DSkala/2>,
			<RErd+HFrame+RSkala, 0.001, DSkala/2> rotate I*y}
		box {<RErd+HFrame+RKante, -0.001, -DSkala/2>,
			<RErd+HFrame+RSkala*0.75, 0.001, DSkala/2>
			rotate (I+5)*y}
		#declare I=I+10;
	#end}
/* Gradangabe mit der Oberseite in Richtung Globus */
#macro ZahlO(Z, W) union {
		text {ttf "timrom.ttf" str(Z, 3, 0) 0.002/5, 0
			translate <-0.8, -0.8, -0.001/5> scale 5
			rotate <90, -90, 0>
			translate <RErd+HFrame+RSkala, DFrame/2, 0> rotate W*y}
		text {ttf "timrom.ttf" str(Z, 3, 0) 0.002/5, 0
			translate <-0.8, -0.8, -0.001/5> scale 5
			rotate <-90, 90, 0>
			translate <RErd+HFrame+RSkala, -DFrame/2, 0>
			rotate W*y}}
#end
/* Gradangabe mit der Unterseite in Richtung Globus */
#macro ZahlU(Z, W) union {
		text {ttf "timrom.ttf" str(Z, 3, 0) 0.002/5, 0
			translate <-0.8, 0.1, -0.001/5> scale 5
			rotate <90, 90, 0>
			translate <RErd+HFrame+RSkala, DFrame/2, 0> rotate W*y}
		text {ttf "timrom.ttf" str(Z, 3, 0) 0.002/5, 0
			translate <-0.8, 0.1, -0.001/5> scale 5
			rotate <-90, -90, 0>
			translate <RErd+HFrame+RSkala, -DFrame/2, 0>
			rotate W*y}}
#end
/* Ring mit Breitengradeinteilung */
#declare RahmenLaenge=union {
	object {Ring(RErd+HFrame+RFrame, RErd+HFrame, DFrame, RKante)
		texture {RahmenT}}
	object {Teilung translate DFrame/2*y texture {SkalaT}}
	object {Teilung translate -DFrame/2*y texture {SkalaT}}
	#declare I=10;
	#while (I<90)
		ZahlO(I, I)
		ZahlU(I, -I)
		ZahlU(I, 180+I)
		ZahlO(I, 180-I)
		#declare I=I+10;
	#end
	texture {SkalaT} rotate -90*x}
/* Ring mit Lngengradeinteilung */
#declare RahmenBreite=union {
	object {Ring(RErd+HFrame+RFrame, RErd+HFrame, DFrame, RKante)
		texture {RahmenT}}
	object {Teilung translate DFrame/2*y texture {SkalaT}}
	object {Teilung translate -DFrame/2*y texture {SkalaT}}
	#declare I=10;
	#while (I<90)
		ZahlO(I, I)
		ZahlO(I, -I)
		ZahlO(I+90, 90+I)
		ZahlO(I+90, -90-I)
		#declare I=I+10;
	#end
	texture {SkalaT}}
/* Vollstndiger Rahmen aus drei Ringen und den Verbindungsstcken */
#declare Rahmen=union {
	object {RahmenBreite}
	object {RahmenLaenge} object {RahmenLaenge rotate 90*y}
	object {Joint8(RErd+HFrame+DJunct, RErd+HFrame, RJunct, RKante)
		texture {RahmenT}}
	object {Joint8(RErd+HFrame+DJunct, RErd+HFrame, RJunct, RKante)
		texture {RahmenT} rotate 90*x}
	object {Joint8(RErd+HFrame+DJunct, RErd+HFrame, RJunct, RKante)
		texture {RahmenT} rotate 90*z}}
/* Aufhngung des Globus */
#declare Achse=union {
	sphere {0.9*5*y, 5 scale <1, 0.6, 1> translate (HFrame+RFrame)*y}
	lathe {cubic_spline 5, <0, HFrame+0.3>, <2, HFrame>, <3, 0.75*HFrame>,
	<0, 0>, <3, -0.75*HFrame>} texture {T_Brass_4B} translate RErd*y}
#declare FussJoint=difference {
	#local R2=RErd+HFrame+RFrame;
	#local R1=R2-RKante;
	#local R3=HFussJoint;
	box {<0, -sqrt(pow(R2+R3, 2)-R3*R3), -DFrame/2>,
		<R1*R3/(R2+R3), -R1*sqrt(1-pow(R3/(R2+R3), 2)), DFrame/2>}
	cylinder {-DFrame*z, DFrame*z, R1}
	difference {lathe {linear_spline 6, <0, -DFrame>,
			<R2+RKante, -DFrame/2>,	<R3, -DFrame/2+RKante>,
			<R3, DFrame/2-RKante>, <R3+RKante, DFrame/2>,
			<0, DFrame>}
		torus {R3+RKante, RKante translate -(DFrame/2-RKante)*y}
		torus {R3+RKante, RKante translate -(DFrame/2-RKante)*y}
		scale <1, 0.5, 1> rotate 90*x translate <R3, -sqrt(pow(R2+R3, 2)-R3*R3), 0>}
	translate (RErd+HFrame+RFrame+HFuss)*y}
#declare FussJoint=difference {
	#local R3=(2*(RErd+HFrame+RFrame)*HFussJoint+pow(HFussJoint, 2)+
		RFuss*RFuss)/2/(RErd+HFrame+RFrame-RFuss);
	box {<0, 0, -DFrame/2>, <(R3+RFuss)*(RErd+HFrame+RFrame)/(RErd+HFrame+RFrame+R3), R3, DFrame/2>}
	cylinder {-DFrame*z, DFrame*z, RErd+HFrame+RFrame-RKante
		translate sqrt(pow(RErd+HFrame+RFrame+R3, 2)-pow(R3+RFuss, 2))*y}
	difference {lathe {linear_spline 6, <0, -DFrame>,
			<R3+RKante, -DFrame/2>,	<R3, -DFrame/2+RKante>,
			<R3, DFrame/2-RKante>, <R3+RKante, DFrame/2>,
			<0, DFrame>}
		torus {R3+RKante, RKante translate -(DFrame/2-RKante)*y}
		torus {R3+RKante, RKante translate (DFrame/2-RKante)*y}
		rotate 90*x translate (R3+RFuss)*x}
	translate (HFuss-HFussJoint)*y}
#declare Fuss=union {
	lathe {cubic_spline 4, <RFuss, 1>, <DFrame/2, 0>, <RFuss, -1>,
		<DFrame/2, -2> scale <1, HFussJoint, 1> translate HFuss*y}
	object {FussJoint} object {FussJoint scale <-1, 1, 1>}
	cylinder {y, 0.5*y, RFuss scale <1, HFuss-HFussJoint, 1>}
	lathe {cubic_spline 4, <3*RFuss, 2.5>, <RFuss, 0.5>, <3*RFuss, 0>,
		<RFuss, -0.2> scale <1, HFuss-HFussJoint, 1>}
	texture {RahmenT}}
#declare Boden=union {cylinder {0, 0.4*DBoden*y, RBoden}
	cylinder {0.4*DBoden*y, DBoden*y, RBoden-0.6*DBoden}
	torus {RBoden-0.3*DBoden, 0.3*DBoden translate 0.4*DBoden*y}
	torus {RBoden-0.6*DBoden, 0.3*DBoden translate 0.7*DBoden*y}
	texture {BodenT}}
#declare Erde=union {sphere {0, 1
		pigment {image_map {png EarthImage map_type 1}}
			normal {bump_map {png EarthBumps map_type 1
				bump_size 70}}
			finish {diffuse 0.9 specular 0}}
	sphere {0, 1.00001
		texture {granite turbulence 0.5 frequency 1
			texture_map {
				[0.4 pigment {Clear} finish {diffuse 0.9
					specular 0}]
				[0.7 pigment {granite turbulence 3 frequency 1
					color_map {[0 Clear][0.5 White]}
						scale 0.07}
					finish {diffuse 0.9 specular 0}]
			} scale 3/2} rotate 130*y}
	scale RErd rotate -55*y}

#declare Globus=union {union {object {Erde} object {Rahmen}
		object {Achse} object {Achse scale <1, -1, 1>}
		rotate -AchsNeigung*z
		translate (RErd+HFrame+RFrame+HFuss+DBoden)*y}
	object {Fuss translate DBoden*y} object {Boden}}
