#include "colors.inc"
#include "metals.inc"
#include "glass.inc"

#declare TGummi=texture {pigment {Gray10} finish {specular 0}}
#declare TChromatiert=texture {pigment {rgb <0, 0, 0.03>}
	finish {ambient 0.35 brilliance 2 diffuse 0.3 metallic specular 0.80
	roughness 1/20 reflection 0.1}}
#declare TMessing=texture {T_Brass_4C}
#declare TGlas=texture {T_Glass1} /* Taugt nichts */

#declare Fernglas=union {
	torus {11.5, 0.5}
	lathe {cubic_spline 4, <8, -20>, <12, 0>, <8, 35.5> <12, 55>}
	lathe {cubic_spline 4, <7, -20>, <11, 0>, <7, 35.5> <11, 55>}
	lathe {linear_spline 10, <8, 35.5>, <9.5, 36>, <9.5, 37.5>, <11, 38>,
		<10, 38>, <10, 49>, <11, 49>, <11, 50>,	<9.5, 50>, <9.5, 52>}
	cylinder {38*y, 49*y, 11
		texture {TChromatiert normal {radial frequency 50
			slope_map {[0.3 <0, 0>][0.5 <2, 0>][0.8 <2, 0>]
				[1.0 <0, 0>]}}}}
	torus {8.5, 1 translate 52*y}
	difference {cylinder {52*y, 57*y, 8.5} cylinder {51*y, 58*y, 7.5}}
	union {torus {10, 2 translate 55*y}
		difference {cylinder {53*y, 56*y, 10} cylinder {52*y, 57*y, 9}}
		difference {cylinder {55*y, 61*y, 12} cylinder {54*y, 62*y, 9}}
		lathe {cubic_spline 6, <16, 55>, <12, 61>, <16, 64>, <15, 65>,
			<9, 61>, <15, 53>}
		texture {TGummi}}
	texture {TChromatiert}}
#macro Segment(Phi1, Phi2, D) #if (Phi2-Phi1<180)
		intersection {plane {-x, D rotate Phi1*z}
			plane {x, D rotate Phi2*z}}
	#else
		union {plane {-x, D rotate Phi1*z} plane {x, D rotate Phi2*z}}
	#end
#end
#declare Skalierung=union {
	#declare I=-5;
	#while (I<=95)
		#if (mod(I, 5)!=0)
			box {<-0.15, -87, 0>,<0.15, -85, 1> rotate -I/2*z}
		#else
			box {<-0.2, -87, 0>,<0.2, -84, 1> rotate -I/2*z}
		#end
		#if (mod(I, 10)=0)
			text {ttf "timrom.ttf" str(I, 3, 0) 1, 0
				translate <-0.7, 0.05, 0> scale <2.5, 2.5, 1>
				translate -83.5*y rotate -I/2*z}
		#end
		#declare I=I+1;
	#end rotate 45/2*z}
#declare Skala=union {difference {cylinder {0.00001*z, 0.9999*z, 87.5}
		cylinder {0, z, 80.5} Segment(84, 351, 0)
		texture {TMessing}}
	object {Skalierung pigment {Black} rotate 75/2*z}
	scale <1, 1, -0.001>}
#declare Marke=union {box {<-5, 0, -1>, <5, 5, 1> texture {TMessing}}
	box {<-0.2, -1, 1>, <0.2, 4, 1.01> pigment {Black}}
	scale <1, 1, 0.1> translate -2*z}
/* Phi1 Anfangswinkel
   Phi2 Endwinkel     Phi1<Phi2
   D	Stegdicke
   Ri	Innenradius
   Ra	Auenradius   Ri<Ra
   Rc	Eckenradius */
#macro Rahmenloch(Phi1, Phi2, D, Ri, Ra, Rc) union {
	difference {cylinder {0, z, Ra} cylinder {-z, 2*z, Ri}
		Segment(Phi2, 360+Phi1, D/2+Rc)}
	difference {cylinder {0, z, sqrt(Ra*Ra-2*Ra*Rc-D*Rc)}
		cylinder {-z, 2*z, sqrt(Ri*Ri+2*Ri*Rc-D*Rc)}
		Segment(Phi2, 360+Phi1, D/2)}
	cylinder {0, z, Rc
		translate <D/2+Rc, -sqrt(pow(Ri+Rc, 2)-pow(D/2+Rc, 2)), 0>
		rotate Phi1*z}
	cylinder {0, z, Rc
		translate <D/2+Rc, -sqrt(pow(Ra-Rc, 2)-pow(D/2+Rc, 2)), 0>
		rotate Phi1*z}
	cylinder {0, z, Rc
		translate <-D/2-Rc, -sqrt(pow(Ri+Rc, 2)-pow(D/2+Rc, 2)), 0>
		rotate Phi2*z}
	cylinder {0, z, Rc
		translate <-D/2-Rc, -sqrt(pow(Ra-Rc, 2)-pow(D/2+Rc, 2)), 0>
		rotate Phi2*z}
	bounded_by {box {<-Ra*sin(radians(Phi2-Phi1)/2), -Ra, 0>,
		<Ra*sin(radians(Phi2-Phi1)/2), -Ri*cos(radians(Phi2-Phi1)/2),
			1>
		rotate (Phi2+Phi1)/2*z}}}     
#end
#declare Rahmen=union {
	difference {cylinder {0.0001*z, 0.9999*z, 80}
		Rahmenloch( 0, 37.5, 3, 16, 32, 2)
		Rahmenloch(37.5, 75, 3, 16, 32, 2)
		Rahmenloch( 0, 25, 3, 35, 48, 2)
		Rahmenloch( 0, 25, 3, 51, 64, 2)
		Rahmenloch(25, 50, 3, 35, 64, 2)
		Rahmenloch(50, 75, 3, 35, 48, 2)
		Rahmenloch(50, 75, 3, 51, 64, 2)
		Rahmenloch( 0, 15, 3, 67, 80, 2)
		Rahmenloch(15, 30, 3, 67, 80, 2)
		Rahmenloch(30, 45, 3, 67, 80, 2)
		Rahmenloch(45, 60, 3, 67, 80, 2)
		Rahmenloch(60, 75, 3, 67, 80, 2)
		Rahmenloch(75, 360, 6, 16, 80.0001, 2)}
	difference {cylinder {0.0001*z, 0.9999*z, 88}
		cylinder {0, z, 80} Segment(85, 350, 0)}
	object {Skala}
	scale <1, 1, 3> texture {TChromatiert}
	/*bounded_by {box {<-16, -88, 0>, <88, 16, 3>}}*/}
#declare SpiegelRund=union {
	difference {/*union {*/cylinder {-2.5*x, 2.5*x, 18}
		/*cylinder {0, 18*z, 2.5 translate 10*y}
		cylinder {0, 18*z, 2.5 translate -10*y}}*/
	cylinder {-3*x, 3*x, 17}}
//	cylinder {0.02*x, 2*x, 17 texture {TGlas} interior {I_Glass}}
	cylinder {-0.01*x, 0.01*x, 17 pigment {transmit 0.9}
		finish {reflection 0.4 ambient 0 diffuse 0} interior {I_Glass}}
//	cylinder {-2*x, -0.02*x, 17 texture {TGlas} interior {I_Glass}}
	translate -18.5*z texture {TChromatiert}}
#declare SpiegelEckig=union {
	difference {box {<-2.5, -16, -16>, <2.5, 16, 16>}
		box {<-1.5, -15, -15>, <3, 15, 15>}}
	lathe {linear_spline 3, <2, 2.5>, <1.5, 7>, <0, 7> rotate 90*z}
	box {<-1.5, -15, -15>, <-1.49, 15, 15> pigment {Black}
		finish {reflection 1.0 ambient 0 diffuse 0}}
//	box {<-1.48, -15, -15>, <2, 15, 15> texture {TGlas}
//		interior {I_Glass}}
	texture {TChromatiert}}
#macro FilterRund(F) union {union {
		difference {union {cylinder {-x, x, 18}
				box {<-1, -2.5, 0>, <1, 2.5, 18.5>}}
			cylinder {-2*x, 2*x, 17}}
		cylinder {-x, x, 17 pigment {transmit F}}
		scale <0.75, 1, 1>}
	cylinder {-0.9*x, 0.9*x, 2.5 translate (18.5)*z}
	cylinder {-18*z, -23*z, 0.75 texture {TMessing}}
	texture {TChromatiert}}
#end
#macro FilterEckig(F) union {union {
		difference {union {box {<-1, -16, -16>, <1, 16, 16>}
				box {<-1, -2.5, 18.5>, <1, 2.5, 0>}}
			box {<-2, -15, -15>, <2, 15, 15>}}
		box {<-1, -15, -15>, <1, 15, 15> pigment {transmit F}}
		scale <0.75, 1, 1>}
	cylinder {-0.9*x, 0.9*x, 2.5 translate 18.5*z}
	cylinder {<0, 15, -16>, <0, 15, -21>, 0.75 texture {TMessing}}
	texture {TChromatiert}}
#end
#declare FilterSetRund=union {union {object {FilterRund(0.8) translate -1*x}
		object {FilterRund(0.6) translate -3*x}
		object {FilterRund(0.4) translate -5*x}
		object {FilterRund(0.2) translate -7*x}
		translate <-12, 0, -18.5>}
	union {sphere {0, 2.5 scale <0.5, 1, 1>	translate -(8+12)*x}
		cylinder {-(8+12)*x, -12*x, 1 texture {TMessing}}
		cylinder {-12*x, 0, 2.5} cone {0, 2.5, 3*x, 1.5}
		texture {TChromatiert}}}
#declare FilterSetEckig=union {union {object {FilterEckig(0.8) translate 3*x}
		object {FilterEckig(0.6) translate 1*x}
		object {FilterEckig(0.4) translate -1*x}
		object {FilterEckig(0.2) translate -3*x}
		translate -18.5*z}
	union {cone {6*x, 2.5, 9*x, 1.5} cylinder {6*x, 4*x, 2.5}
		cylinder {4*x, -4*x, 1 texture {TMessing}}
		cylinder {-4*x, -6*x, 2.5} cone {-6*x, 2.5, -9*x, 1.5}
		texture {TChromatiert}}}
#declare Hebel=union {difference {
	prism {bezier_spline linear_sweep 3, 0, 32,
		<5, -70>, <5, -75>, <22, -77>, <22, -82>,
		<22, -82>, <22, -83>, <22, -93>, <22, -94>,
		<22, -94>, <22, -95.5>, <20.5, -97>, <19, -97>,
		<19, -97>, <18, -97>, <-18, -97>, <-19, -97>,
		<-19, -97>, <-20.5, -97>, <-22, -95.5>, <-22, -94>,
		<-22, -94>, <-22, -93>, <-22, -83>, <-22, -82>,
		<-22, -82>, <-22, -77>, <-5, -75>, <-5, -70>,
		<-5, -70>, <-4, -70>, <4, -70>, <5, -70>}
	cylinder {4*y, -y, 2 translate -82*z rotate 5*y}
	cylinder {4*y, -y, 2 translate -82*z rotate -5*y}
	cylinder {8*y, -2*y, 2 rotate -45*x translate -84*z rotate 5*y}
	cylinder {8*y, -2*y, 2 rotate -45*x translate -84*z rotate -5*y}
	intersection {lathe {linear_spline 5, <80, 5>, <80, -1>,
		<83+2*sqrt(2), -1>, <89+2*sqrt(2), 5>, <80, 5>}
		object {Segment(-5, 5, 0) rotate 90*x}}
	intersection {lathe {linear_spline 5, <82, 5>, <82, -1>, <83, -1>,
		<89, 5>, <82, 5>}
	object {Segment(-5, 5, 2) rotate 90*x}}}
	prism {bezier_spline linear_sweep 0, -3, 32,
		<19, -79>, <20.5, -79>, <22, -80.5>, <22, -82>,
		<22, -82>, <22, -83>, <22, -93>, <22, -94>,
		<22, -94>, <22, -95.5>, <20.5, -97>, <19, -97>,
		<19, -97>, <18, -97>, <-18, -97>, <-19, -97>,
		<-19, -97>, <-20.5, -97>, <-22, -95.5>, <-22, -94>,
		<-22, -94>, <-22, -93>, <-22, -83>, <-22, -82>,
		<-22, -82>, <-22, -80.5>, <-20.5, -79>, <-19, -79>,
		<-19, -79>, <-18, -79>, <18, -79>, <19, -79>}
	object {Marke rotate -45*x translate -84*z}}
#declare Raendel=union {
	cylinder {-x, 7*x, 2.9}
	lathe {linear_spline 6, <3, 7>, <3, 2>, <3.2, 2>, <4.5, 6>,
		<5, 6>, <5, 7> rotate -90*z}
	cylinder {7*x, 15*x, 6
		texture {TChromatiert normal {radial frequency 25
			slope_map {[0.3 <0, 0>][0.5 <2, 0>][0.8 <2, 0>]
				[1.0 <0, 0>]}}}}
	sphere {0, 6 scale <0.3, 1, 1> translate 15*x}
	rotate 185*z translate <-22, -90, 0> texture {TChromatiert}}
#declare Alhidade=union {union {cylinder {0, -z, 16}
		box {<-5, -70, -2>, <5, 0, 0>} object {Hebel rotate -90*x}
		object {Raendel}
		rotate 45/2*z texture {TChromatiert}}
	object {SpiegelEckig translate -17*z rotate (180+(90-75/2)/2)*z}}
#declare Sextant=union {
	object {Rahmen rotate -(75/2)*z}
	union {object {FilterSetRund}
		object {SpiegelRund rotate ((90-75/2)/2)*z}
		translate <0, -2.5, 1.5>+vrotate(<-3, -60, 0>, -(75/2)*z)}
	object {FilterSetEckig translate 1.5*z rotate (90-75/2)*z
		translate vrotate(<-1.5, -30, 0>, -(75/2)*z)}
	object {Fernglas rotate -90*z
		translate <0, 0, -17>+vrotate(<-1.5, -60, 0>, (75/2)*z)}
	union {cone {-3*x, 1.5, 0, 2.5} cylinder {0, 20*x, 2.5}
		sphere {20*x, 2.5} cylinder {0, -17*z, 2.5 translate 5*x}
		cylinder {0, -17*z, 2.5 translate 20*x}	scale <1, 2, 1>
		texture {TChromatiert}
		translate 1.5*z+vrotate(<1.5, -60, 0>, (75/2)*z)}
	object {Alhidade}}

/*
//camera {location <-44, -44, -300> look_at <-44, -44, 0> angle 30}
camera {location <0, 0, -600> look_at <0, -24, 0> angle 30}
light_source {<1000, 1000, -1000> White}
light_source {<-1000, 1000, -1000> White}
background {Gray90}

object {Sextant}
object {Sextant rotate -90*y translate -x*120}
object {Sextant rotate 90*y translate x*120}
object {Sextant rotate -90*x translate y*70}
*/
