//  Persistence of Vision Raytracer V3.1
//  World definition file.
//  
//  Jillian Howell
//
//  Title:  "An Evil Experiment"
//
//  Notes:  To render this image, ensure that the following files are in the
//          same directory:  "canLabel.bmp"
//                           "beans.bmp"
//                           "beansHeight.gif" 
//                           "f2rt.bmp"  
//                
//
//  



global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 20 
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.425,0.5,0.425> } // institution green at twice this intensity

camera {  location  <-60,-10,-1000> // -60,-10,-1000 for final run  //17.24,0.5,0.425bb
          sky       < 0,1,0>  
          up        < 0,1,0>  
          right    <1.37664,0,0> // Right Vector adjusted to harmonise with Moray spherical universe
          angle         21     //21 for final run
          look_at   <-60,-75,-50>    //-60,-75,-50 for final run
       }


// *******  L I G H T S *******




light_source { <0,0,0>
               color rgb <0.8,0.8,0.8>
               area_light <2,0,0>, <0,2,0>, 3, 3
               adaptive 1
               jitter
               fade_distance 2500 
               fade_power 1
               media_attenuation on
               scale <30,1,120>
               rotate <-45,-30,0>
               translate <400,300,-600>
             }



light_source {   <0,0,0> 
                 color <1,1,1>
                 area_light <2,0,0>, <0,2,0>, 3, 3     
                 adaptive 1    // doesn't need to be higher with a 3x3 array
                 jitter
                 fade_distance 2500 
                 fade_power 1
                 media_attenuation on
                 scale <30,1,120>   
                 rotate -90.0*y
                 translate <50,700,-100>
             }
             

 
light_source {   <-160,-109,-10>      // spotlight on drop
                 color <1,1,1>   
                 spotlight
                 radius 25
                 falloff 25
                 point_at <-185,-115,0> 
             } 
 
 


// ********  MATERIALS  *******


#include "glass.inc"
#include "metals.inc"
#include "colors.inc"
#include "woods.inc"
#include "finish.inc"


 
 
 
// Quickfit glass : used T_Glass3 as a starting point & adjusted slightly 
#declare T_qfGlass = texture { pigment { color rgbf <0.98,0.97,0.98,0.9> }  
                               finish  { ambient 0.15  
                                         diffuse 0.1
                                         reflection 0.1
                                         specular 1   // 0.8 in T_Glass3
                                         roughness 0.003
                                         phong 1
                                         phong_size 180 // smaller than T_Glass3
                                       }
                             }
                             

// water droplet  
#declare T_Droplet = texture { pigment { color rgbft <1,0.8,0.7,0.3,0.2> }  
                               finish  { ambient 0  
                                         diffuse 0
                                         reflection 0.4
                                         specular 1   
                                         roughness 0.001
                                         phong 1
                                         phong_size 50
                                       }
                             }



                             
#declare T_Flame = texture { pigment { color rgbft <0.04,0,0.45,0.95,0.8> }                                  finish { ambient 0.1     //.7 v solid looking
                             finish { ambient 0.8
                                      roughness 0.001
                                    }
                               }



// this glass looks slightly yellowed & slightly thick - designed for 
// usefulness not looks, not brand new
#declare T_ClearLabGlass = texture { pigment { color rgbf <0.98,0.98,0.97,0.88> }
                                     finish { // F_Glass 1:
                                              specular 1
                                              roughness 0.001
                                              ambient 0
                                              diffuse 0
                                              reflection 0.1
                                            }
                                   }  



#declare T_BrownLabGlass = texture { pigment { color rgbf <0.7,0.5,0.1,0.6> }
                                     finish { // F_Glass 1 :
                                              specular 1
                                              roughness 0.001
                                              ambient 0
                                              diffuse 0
                                              reflection 0.1
                                            }  
                                   }



#declare T_Slightly_Rusty_Iron = // just a variation of Rusty_Iron (less rust)
texture { pigment { granite
                    color_map { [0.01 rgb <0.42, 0.20, 0.20>]
                                [0.05 rgb <0.50, 0.50, 0.02>]     
                                [0.1 rgb <0.50, 0.20, 0.20>]       
                                [0.2 rgb <0.25, 0.20, 0.20>]    
                              }
                  }
                  finish { ambient 0.2 diffuse 0.6 }
                  normal { wrinkles 1 scale 0.1 }
        }



#declare T_Orange_Rubber = texture { pigment { color <0.5,0.25,0> }}
                                                                               
                                                                               
#declare T_Water_Tubing = texture { pigment {color rgbft <0.6,0.6,0.55,0.3,0.2>}   
                                    finish {  ambient 0.5
                                              specular 0.2 
                                              diffuse 0.1
                                           }
                                  }  
                                                                                        

// copied the following from shapesq.inc rather than including whole file
/* Lemniscate of Gerono
  This figure looks like two teardrops with their pointed ends connected.
  It is formed by rotating the Lemniscate of Gerono about the x-axis.
  The formula is:
     x^4 - x^2 + y^2 + z^2 = 0. */
#declare Lemniscate =
 quartic 
  {< 1,   0,   0,   0,   0,   0,   0,   0,   0, -1,
     0,   0,   0,   0,   0,   0,   0,   0,   0,  0,
     0,   0,   0,   0,   0,   1,   0,   0,   0,  0,
     0,   0,   1,   0,   0>
  }




// ********  DEFINE OBJECTS  ********************************************************
                                                                                    
// Bench ============================================================================
// origin rests on top surface
// declared bench as seperate planks to allow grain pattern to be offset if required 
// (didn't want it to be too perfectly continuous across bench)
#declare woodenPlank = box { <-500, -0.2, -30>, <500, 0.0, 30>
                             texture { T_Wood1 scale 20
                                       rotate 90*y
                                     }
                           }
                     
                     

// Can of beans ======================================================================
          
          

#declare can = 
  object
  {
    difference
    {
      cylinder { <0,0,0>, <0,40,0>, 13 }
      cylinder { <0,38.2,0>, <0,45,0>, 12 }
    }  
    texture { T_Silver_1B }    
  }                            
      
      

#declare bakedBeansLabel = cylinder { <0,2,0>, <0,38,0>, 13.1
                                      pigment { image_map { sys "canLabel.bmp"  
                                                            map_type 2
                                                            once
                                                           }         
                                                           scale 38*y    
                                                           rotate -80*y                                                               
                                               }                           
                                       finish { ambient 0.1 }     
                                     }                                                                          
                                                            
                               
                                 
#declare beanCan =
  union
  {
    object { can }
    object { bakedBeansLabel }  
  } 
      
                                                                                          

// Wall behind bench ===============================================================



#declare wallBehind = plane {  z,110  
                               hollow
                               pigment { rgb <0.435,0.56,0.435> }  
                               finish { reflection 0 
                                        diffuse 0.3
                                        ambient 0.2
                                      }                           
                            }    
// media don't render properly if hollow not turned on for this plane                              



// Gas tap on wall ==================================================================
                       
                                                   
                                                   
#declare baseCone = cone { <0,0,0>, 3.5
                           <0,10,0>, 2.5 
                           open
                         }                           
                                                   
                                                   
                           
#declare hoseConnection =
  union                           
  {            
    cylinder { <0,5,0>, <0,5,12.5>, 1.5 }
    object { baseCone }
    object { baseCone
             scale 0.8
             translate 6*y
           }  
    object { baseCone
             scale 0.7
             translate 10.2*y
           }  
  }
  
  

#declare hoseConnectionOn =
  union
  {
    object { hoseConnection }
    superellipsoid { <0.2, 0.2> 
                     scale <0.75,8,2.5>
                     translate <0,12.9,10>
                   }    
    cylinder { <0,13,0>, <0,17,0>, 1.95 
               texture { T_Orange_Rubber }
              } // start of gas hose       
    sphere { <0,0,0>, 1.95     
             scale 2*y
             translate 17*y
             texture { T_Orange_Rubber }
           }            
  }
  
  
  
#declare hoseConnectionOff =
  union
  {
    object { hoseConnection }
    superellipsoid { <0.2, 0.2>  
                     scale <0.75,8,2.5>   
                     translate 12.9*y 
                     rotate -85*z
                     translate 10*z
                   }    
  }      


             
#declare gasTap = 
  object
  {
    union 
    {
      cylinder { <0,0,0>, <0,0.5,0>, 7 }
      cylinder { <0,0,0>, <0,10,0>, 3.5 }
      object { hoseConnectionOn 
               rotate 45*z
               translate 7*y
             }
      object { hoseConnectionOff 
               rotate -45*z
               translate 7*y
             }
    }        
    texture { T_Chrome_1D }
  }         
                                 


// Gas line =========================================================================



#declare gasLine =
union { 
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-1.105848, 0.486473, 0.466938>, <-1.105848, -0.846859, 0.466938>, <-0.204606, -0.846859, -0.790997>, <-0.204606, 0.486474, -0.790997>, 
      <0.269671, 0.801338, 1.199960>, <0.269671, -0.531994, 1.199960>, <1.581803, -0.378771, -0.143355>, <1.581803, 0.954562, -0.143355>, 
      <2.662703, -1.015312, 2.913132>, <2.662703, -2.348644, 2.913132>, <4.573283, -2.348644, 2.018937>, <4.573283, -1.015311, 2.018937>, 
      <2.946832, -0.736750, 4.443776>, <2.946832, -2.070082, 4.443776>, <4.902122, -2.070082, 3.996678>, <4.902122, -0.736749, 3.996678>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.204606, 0.486474, -0.790997>, <-0.204606, 1.819808, -0.790997>, <-1.105848, 1.819805, 0.466938>, <-1.105848, 0.486473, 0.466938>, 
      <1.581803, 0.954562, -0.143355>, <1.581803, 2.287895, -0.143355>, <0.269671, 2.134670, 1.199960>, <0.269671, 0.801338, 1.199960>, 
      <4.573283, -1.015311, 2.018937>, <4.573283, 0.318022, 2.018937>, <2.662703, 0.318019, 2.913132>, <2.662703, -1.015312, 2.913132>, 
      <4.902122, -0.736749, 3.996678>, <4.902122, 0.596584, 3.996678>, <2.946832, 0.596581, 4.443776>, <2.946832, -0.736750, 4.443776>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <2.946832, -0.736750, 4.443776>, <2.946832, -2.070082, 4.443776>, <4.902122, -2.070082, 3.996678>, <4.902122, -0.736749, 3.996678>, 
      <3.230961, -0.458189, 5.974420>, <3.230961, -1.791520, 5.974420>, <5.230961, -1.791520, 5.974420>, <5.230961, -0.458187, 5.974420>, 
      <3.857150, -0.128346, 8.890099>, <3.857150, -1.461678, 8.890099>, <5.857150, -1.461678, 8.890099>, <5.857150, -0.128345, 8.890099>, 
      <4.037622, 0.386030, 10.023486>, <4.037622, -0.947302, 10.023486>, <6.037622, -0.947301, 10.023486>, <6.037622, 0.386032, 10.023486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.902122, -0.736749, 3.996678>, <4.902122, 0.596584, 3.996678>, <2.946832, 0.596581, 4.443776>, <2.946832, -0.736750, 4.443776>, 
      <5.230961, -0.458187, 5.974420>, <5.230961, 0.875146, 5.974420>, <3.230961, 0.875143, 5.974420>, <3.230961, -0.458189, 5.974420>, 
      <5.857150, -0.128345, 8.890099>, <5.857150, 1.204988, 8.890099>, <3.857150, 1.204985, 8.890099>, <3.857150, -0.128346, 8.890099>, 
      <6.037622, 0.386032, 10.023486>, <6.037622, 1.719365, 10.023486>, <4.037622, 1.719362, 10.023486>, <4.037622, 0.386030, 10.023486>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.037622, 0.386030, 10.023486>, <4.037622, -0.947302, 10.023486>, <6.037622, -0.947301, 10.023486>, <6.037622, 0.386032, 10.023486>, 
      <4.218095, 0.900406, 11.156874>, <4.218095, -0.432925, 11.156874>, <6.218095, -0.432925, 11.156874>, <6.218095, 0.900408, 11.156874>, 
      <4.616671, 1.603774, 14.065109>, <4.616671, 0.270443, 14.065109>, <6.616671, 0.270443, 14.065109>, <6.616671, 1.603776, 14.065109>, 
      <4.792394, 2.136723, 15.930879>, <4.792394, 0.803392, 15.930879>, <6.792394, 0.803392, 15.930879>, <6.792394, 2.136725, 15.930879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.037622, 0.386032, 10.023486>, <6.037622, 1.719365, 10.023486>, <4.037622, 1.719362, 10.023486>, <4.037622, 0.386030, 10.023486>, 
      <6.218095, 0.900408, 11.156874>, <6.218095, 2.233741, 11.156874>, <4.218095, 2.233738, 11.156874>, <4.218095, 0.900406, 11.156874>, 
      <6.616671, 1.603776, 14.065109>, <6.616671, 2.937109, 14.065109>, <4.616671, 2.937106, 14.065109>, <4.616671, 1.603774, 14.065109>, 
      <6.792394, 2.136725, 15.930879>, <6.792394, 3.470058, 15.930879>, <4.792394, 3.470055, 15.930879>, <4.792394, 2.136723, 15.930879>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <4.792394, 2.136723, 15.930879>, <4.792394, 0.803392, 15.930879>, <6.792394, 0.803392, 15.930879>, <6.792394, 2.136725, 15.930879>, 
      <4.968116, 2.669672, 17.796649>, <4.968116, 1.336341, 17.796649>, <6.968116, 1.336341, 17.796649>, <6.968116, 2.669674, 17.796649>, 
      <5.957351, 3.441302, 21.414193>, <5.957351, 2.073500, 21.414193>, <8.620939, 2.073500, 21.042584>, <8.620939, 3.441303, 21.042584>, 
      <9.660681, 3.737013, 23.582741>, <9.600095, 2.369211, 23.461569>, <11.587391, 1.957072, 22.526878>, <11.466218, 3.492639, 22.461627>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <6.792394, 2.136725, 15.930879>, <6.792394, 3.470058, 15.930879>, <4.792394, 3.470055, 15.930879>, <4.792394, 2.136723, 15.930879>, 
      <6.968116, 2.669674, 17.796649>, <6.968116, 4.003007, 17.796649>, <4.968116, 4.003004, 17.796649>, <4.968116, 2.669672, 17.796649>, 
      <8.620939, 3.441303, 21.042584>, <8.620939, 4.809107, 21.042584>, <5.957351, 4.809104, 21.414193>, <5.957351, 3.441302, 21.414193>, 
      <11.466218, 3.492639, 22.461627>, <11.345046, 5.028206, 22.396376>, <9.721267, 5.104815, 23.703914>, <9.660681, 3.737013, 23.582741>
    }
  }
  texture { T_Orange_Rubber }
  scale <1.95, 1.95, 2.8>
  translate -24*x  
  rotate <0,9,1>  
  translate 24*x
  translate  <3,-191.5,35>
}

   

// Bunsen burner =====================================================================
   
   

#declare bunsenBase = 
  union 
  {
    torus 
    { 23,8  
      scale 0.3*y
    }
    torus 
    { 18, 6  
      scale 0.4*y
      translate  <0.0, 2.0, 0.0> 
    }                                    
    cylinder { <0,0,0>, <0,4.4,0>, 18 }                
    cylinder { <0,0,0>, <0,11,0>, 6 }
    cylinder { <0,0,0>, <0,19,0>, 4.91 }
    cylinder { <0,9,0>, <10,9,0>, 1.3 
               rotate -32*y
             } // gas hose attatchment
  }

   
   
#declare trimmedBase =
  difference 
  {
    object { bunsenBase } 
    cylinder { <0,0.5,0>, <0,50,0>, 4.51 } // cut this to stop green showing where adjustable ring is turned
    cylinder { <0,0,0,>, <0,18,0>, 5.0 } 
    plane { y,0 }  // flatten base ('though it won't show if bunsen positioned properly on solid surface)
  }


                   
#declare bunsenMainTube =
  difference
  {
    cylinder { <0,0.5,0>, <0,50,0>, 4.5 }     
    cylinder { <0,0.5,0>, <0,51,0>, 4.2 } // hollow tube so shadows better at end 
    cylinder { <0,15,0>, <0,15,-8>, 2.5 } // air vent                         
  }  


       
#declare adjustableRing =
  difference
  {
    cylinder { <0,0,0,>, <0,19,0>, 5.5 } 
    cylinder { <0,-0.1,0>, <0,19.1,0>, 4.9 }
    cylinder { <0,15,0>, <0,15,-8>, 2.5 } // air vent            
  }
       
           
    
#declare bunsenBurner = 
  object
  {
    union
    {
      object { trimmedBase 
               texture { pigment { color rgb <0.0,0.3,0.3> }}
               normal { dents scale 0.8 }
               finish { Dull }
             }        
      object { bunsenMainTube 
               texture { T_Chrome_5A }
             }
      object { adjustableRing
               texture { T_Chrome_5A } 
               rotate 25*y
             }                 
      cylinder { <0,0.5,0>, <0,19,0>, 4.2
                 texture { pigment { color Black }} // so inside air hole shows black
               }         
      cylinder { <8,9,0>, <12,9,0>, 1.95 // Start of gas hose   
                 rotate -32*y
                 texture { T_Orange_Rubber }
               }  
    }
  }    
    

// Bunsen flames ===================================================================




#declare innerFlame = 
  object
  {
    difference 
    { 
      cone {  <0,8,0>, 0.0, 
              <0,0,0>, 4.5
           }
      cone {  <0,7.5,0>, 0.0, 
              <0,0,0>, 4.5
           }              
    }
    hollow      
    texture { T_Glass1 }
    interior { media {  absorption <0,0,0> 
                        emission <0.01,0,0.75>   
                     }
             }    
    bounded_by { box { <-5,-0.5,-5>, <5,7.5,5> }}                        
  }   


 
 
#declare outerFlame =     
  object
  {
    difference 
    { 
      cone { <0,18,0>, 0.0, 
             <0,0,0>, 4.5
           }
      cone { <0,8,0>, 0.0, 
             <0,0,0>, 4.5
           }         
    }
    hollow   
    texture { T_Flame }    
    interior { media {  absorption <0,0,0> 
                        emission  <0.06,0,1>    
                      } 
              }  
    bounded_by { box { <-5,-0.5,-5>, <5,18.5,5> }}              
  }     
                              







 
// 3 legged ring stand =========================================================



#declare ringOfStand = 
  difference 
  {
    cylinder { <0,0,0>, <0,-3,0>, 39 }
    cylinder { <0,0.1,0>, <0,-3.1,0>, 35 } 
  }


  
#declare standLeg = box { <-3,-105,-2> <0,0,0> rotate 15*z translate 38*x} 



#declare ringStand =    
  object
  {
    union
    {
      object {ringOfStand} 
      object {standLeg}
      object {standLeg  rotate 120*y }
      object {standLeg  rotate -120*y }
    }
    texture { T_Slightly_Rusty_Iron } 
  }    
    


// miscellaneous Quickfit glass tubing ===========================================

// Straight tubing for central sections:
// untransformed, glass is 0.5 thick. Tubing is vertical, starting at origin & 40 long
#declare qfGlassTubing =
  difference
  {
    cylinder { <0,0,0>, <0,40,0>, 7.8 }
    cylinder { <0,-0.01,0>, <0,40.01,0>, 7.3 }
  }                        

                                                                                 
                                                                                 

// Rounded end tubing for joining to other fittings:
// untransformed glass is 0.5 thick. Tubing is vertical, rounded end at origin & 40 long


#declare endGlassTubingSolid =
  merge
  {
    torus { 6.8, 1 
            sturm
            scale 2*y   
            translate -2*y
          } 
    cylinder { <0,0,0>, <0,-40,0>, 6.8 } // flatten inside end to highest part of torus
    cylinder { <0,-2,0>, <0,-40,0>, 7.8 } // widen tube once widest part of torus reached
  }
  
  
  
#declare endGlassTubing =
  difference
  {
    object { endGlassTubingSolid }           
    object { endGlassTubingSolid 
             scale <0.934,1,0.934> // reduce radius by 0.5 units   
           } 
    cylinder { <0,0.1,0>, <0,-10,0> 6.3 }
  }

 

// Quickfit female fitting ================================================
// untransformed original lies with centre of rounded lip at origin.  
// bottom of a cone inserted into fitting should lie just above -25.2, tubing
// below reaches max width at -26.2y & attatched tubing stops at -65.2y.  
    

 
#declare femaleCone = 
  object
  {
    difference
    {
      cone { <0,0,0>, 8.7, 
             <0,-22.5,0>, 6.8      
           }    
 
      cone { <0,0.01,0>, 8.2, 
             <0,-22.51,0>, 6.3
           }
     }       
     hollow    
     interior { ior 1.5
                media 
                {  absorption rgb <0.9,0.9,0.9>  
                   emission <.6,.6,.6>  
                }          
              }        
   }


  
#declare femaleJoint =
  union  
  {    
    torus { 8.85, 0.65  
            scale 4.15*y  
            translate -2.7*y
          } 
//    object { endGlassTubing      // changed this & added tubing to objects seperately so merge could
//             translate -25.19*y  // be used to remove reflective internal joins, but femalejoint
//          }                       // could be added seperately last - can't use merge on femalejoint
    object { femaleCone            // if want to preserve seperate hollow section, but join will occur
             translate -2.7*y      // at a location in the object where it looks OK
           }               
  }  
             


// Quickfit male fitting ====================================================
// tip of cone at origin, open tube points in +y direction. 
// glass thickness 0.5 as in untransformed female fitting & tubing. 
// total fitting is 62.7 long
          
        
  
#declare maleCone =  // closed end as in stoppers etc.
  difference
  {
    cone { <0,22.7,0>, 8, 
           <0,0,0>, 6.1     
         }    
    cone { <0,22.8,0>, 7.5, 
           <0,0.5,0>, 5.6 
         }
   }                         

   
   
#declare groundMaleCone = // used for fittings that are not inside a ground female fitting
  object { maleCone
           hollow
           interior { ior 1.5
                      media { absorption rgb <0.9,0.9,0.9>
                              emission <0.9,0.9,0.9>   
                              scattering {1 <1,1,1>}
                            }
                    }
         }                   
     
   
#declare openMaleCone =  // open end to allow passage of fluid
  difference
  {
    object { maleCone }
    cylinder { <0,-0.5,0>, <0,1,0>, 5.6 }
  }     
   
   
     
#declare maleJoint =
  merge // use union if doing ground fitting
  {
     object { openMaleCone }
     object { qfGlassTubing 
              translate 22.7*y 
             }
  }            
                                               

                                               
                                           
// distillation flask ================================================================ 
// Untransformed flask: centre of sphere at origin, diameter 39, female fittings on yaxis &
// at rotation -40*z. fittings protrude by 13.35, stoppers inserted should rest just above
// 41.1 from centre



#declare flasksolid = 
  merge 
  {
    sphere { <0,0,0>,39 }
    object { endGlassTubing
             translate -25.19*y
             scale 0.5
             translate (39+13.1)*y
           }
    object { endGlassTubing
             translate -25.19*y          
             scale 0.5 
             translate (39+13.1)*y  
             rotate -40*z    
           }
  }



#declare flaskShell =
  difference 
  { 
    object { flasksolid }
    cylinder { <0,0,0>, <0,10,0>, 3.2 
               translate  37.0*y
             }
    cylinder { <0,0,0>, <0,10,0>, 3.2    
               translate 37*y
               rotate -40*z
             }
    sphere { <0,0,0>,38.5 } // make glass twice as thick on a big item that's heated
  }


#declare roundBottomFlask =
  object
  {
    union 
    { 
      object { flaskShell 
               hollow off
             }
    object { femaleJoint 
             scale 0.5 
             translate (39+13.1)*y  
           }
    object { femaleJoint 
             scale 0.5 
             translate (39+13.1)*y  
             rotate -40*z             
           }
    }
    texture { T_qfGlass } 
    interior { I_Glass }
    bounded_by { box { <-39.5,-39.5,-39.5>, <39.5,52.5,39.5> }}
  }   





#declare beanSurface =
    height_field { gif "beansHeight.gif" // wouldn't accept bmp here
                   scale  <233,6,233>   
                   translate <-116.5,4,-116.5>
                  }


               
               
#declare flaskContentsSide =
  intersection
  {
    sphere { <0,0,0>, 38.4          
              pigment { image_map { sys "beans.bmp"  
                                     map_type 1
                                   }
                       }
            } 
    object { beanSurface }        
  }                    




#declare sauceSolid = 
  object
  {
    difference  
    {
      sphere { <0,0,0>, 38.4 }
      plane { y, 0
               rotate 180*x
               translate 10*y
            }   
      object { beanSurface }
    }                                                     
    texture { pigment { color rgbt <0.8,0.4,0.1,0.2> }   
              finish { Shiny } 
              normal { ripples 
                       scale 4   
                       scale 30*y
                     }          
            }
}

#declare bubbles =    
  object
  {
    union
    {
      sphere { <-17,10,-12> 3}
      sphere { <15,10,10> 2.3}
      sphere { <30,10,-5> 1.8}
      sphere { <-20,10,-32> 2}   
      sphere { <-25,10,-20> 2.5}
      sphere { <-15,10,0.8> 2.3}
      sphere { <5,10,-31> 2.8}
      sphere { <20,10,13> 4.4}             
      sphere { <-36,10,2> 2.5}
      sphere { <-15,10,-25> 2.6}
      sphere { <30,10,-10> 1.8}
      sphere { <-10,10,-31> 2}   
      sphere { <-18,10,-13> 2.5}
      sphere { <12,10,-0.8> 2.3}
      sphere { <-2,10,35> 2.8}
      sphere { <23,10,13> 2}    
    }
    texture { T_Glass3 }
  }
                
                
#declare sauce =
  union
  {
    object { sauceSolid }
    object { bubbles }
  }  
                   


#declare flaskContents =
  union
  {
    object { flaskContentsSide }
    object { sauce }
  }  


                   

// Indented Quickfit stopper =========================================================
// tip of stopper at origin



#declare stopperSolid = 
  difference 
  {
    cylinder { <0,0,0>, <0,31,0>, 7 }   
    superellipsoid { <0.1, 0.1> 
                     scale 9
                     translate  <14.0, 16, 0>
                   }
    superellipsoid { <0.1, 0.1>
                     scale 9
                     translate  <-14.0, 16, 0>
                    }
  }
  
  
  
#declare stopperInside = 
  difference 
  {
    cylinder { <0,-0.1,0>, <0,30.5,0>, 6.5 }
    superellipsoid { <0.1, 0.1>
                     scale 11                     
                     translate  <13.5, 20.5, 0>
                    }
    superellipsoid { <0.1, 0.1>
                     scale 11 
                     translate  <-13.5, 20.5, 0>
                   }
  }
   
   
   
#declare hollowStopper =
  object
  {
    difference
    {
      object { stopperSolid }  
      object { stopperInside }
    }  
  }  
    
   
   
#declare indentedStopper =        
  object
  {
    merge 
    {
      object { maleCone } // previously defined in male fitting
      object { hollowStopper 
               translate 22.6*y
             }
    }
    bounded_by { box { <-31.5,-0.5,-31.5>, <31.5,51.5,31.5> }}
    texture { T_qfGlass } 
    interior { I_Glass }
  }

       
   
// QuickFit Branch Fitting ==========================================================
// opening of female branch is at origin, tip of male cones are at <0,-124,0> & <-58.91,-61.44,0>
// do some slightly complicated trimming here - designed to try and avoid cut marks & seams showing
// inside the branch fitting from where the trimming shapes have overcut slightly - catches the light
// in glass objects
                                         
                                         
                                         
#declare trimmedSideArm =
  difference
  {
    object { maleJoint      
             translate -62.69*y // attatchment end of fitting to origin ( not tip of cone )
             rotate -70*z
             translate -0.2*x  
           }      
    cylinder { <0,20,0>, <0,-20,0>, 7.81 }
  }                                                
   

#declare trimmingCylinder =
  difference
  {
    cylinder { <0,0.2,0>, <0,-10,0>, 7.29 
               rotate -70*z
               translate -40*y
               translate -0.2*x
             }
    cylinder { <0,-20,0>, <0,-61,0>, 7.4 }
  }               

                                         
                             
#declare trimmedVertical =
  difference
  {
    object { endGlassTubing
             translate -25.19*y
           }  
    object { trimmingCylinder 
             translate 0.2*x
           }
  }                                            
   
                                         
 
#declare BranchFitting =   
  merge
  {
    object { trimmedVertical }
    object { maleJoint 
             translate -124*y
           }
    object { trimmedSideArm   
                 translate -40*y
             translate 0.2*x
           }
  }             


     
#declare qfBranchFitting =   
  object
  {
    union 
    {
      object { BranchFitting
               hollow off
             }
      object { femaleJoint }
    }  
    texture { T_qfGlass }   
    interior { I_Glass }  
  }    
   

// knurled knob stopper ============================================  
  


#declare indentedKnob = 
  cylinder { <0,0,0>, <0,20,0>, 12 }  
    
#declare loopCounter = 0
#while (loopCounter < 16 )
  #declare indentedKnob = 
    difference
    {
      object { indentedKnob 
               rotate (loopCounter*22.5)*y
             }
      cylinder { <12.9,-5,0>, <12.9,25,0>, 2 } 
    }
  #declare loopCounter = loopCounter + 1
#end
         


#declare groovedStopperSolid = 
  object
  {
    merge 
    {
      cylinder { <0,22.6,0>, <0,46.6,0>, 7.8 }
      object { maleCone }
    }
    texture { T_qfGlass } 
    interior { I_Glass }
  }
  


#declare knurledKnob =
  object
  {
    union 
    { 
      object { indentedKnob 
               translate 26.7*y
               texture { pigment { rgb <0.7,0.8,1> } 
                         finish { ambient 0.3 }    
                        }      
             }
      object { groovedStopperSolid }
    }
  }

            
                    
// thermometer ========================================
  

     
#declare thermometerMercury = 
  object
  {
    union 
    {
      sphere { <0,0,0>,2.5 }
      cylinder { <0,10,0>, <0,0,0>, 2.5 }
      cone { <0,5,0>, 0.0, 
             <0,0,0>, 2.5
             translate  9.98*y
           }
      cylinder { <0,0,0>, <0,110,0>, 0.8 }  
    }  
    texture { T_Chrome_5E } // was 5e
  } 
  
           

#declare thermometerGlass = 
  object 
  {
    merge 
    {
      torus { 2.6, 0.4  
              rotate -90*x  
              scale 4*y                        
              translate  149*y
            }
      sphere { <0,150,0>,3 }
      cylinder { <0,9.9,0>, <0,150,0>, 3 }
    }
    texture { T_Glass3 }    
    interior { I_Glass }    
    bounded_by { box { <-3.5,9.4,-3.5>, <3.5,161.5,3.5> }}
  }                     



#declare thermometerBack = 
  object
  {
    difference 
    {
      cylinder { <0,9.9,0>, <0,149.8,0>, 3 }
      plane { z,0 }
    }
    texture { pigment { gradient y color_map { [ 0.0  rgb <1,1,1> ]
                                               [ 0.50 rgb <1,1,1> ]
                                               [ 0.50 rgb <0,0,0> ] 
                                               [ 0.65 rgb <0,0,0> ]                                                
                                               [ 0.65 rgb <1,1,1> ]
                                               [ 1.0  rgb <1,1,1> ]                                                                                                                                                                                         
                                             }   
                        scale 3*y                     
                                             
                      }                      
            }                              
  }
  
  
  
#declare thermometer =   
  union 
  {
    object { thermometerBack }
    object { thermometerGlass }
    object { thermometerMercury }
  }
  
  
  


// Water hose to condenser inlet =====================================================================          



// work in co-ordinates for final scene then scale to fit condenser when attatching it
#declare inletHose =
  object
  {
    merge
    { 
      // cylinder at outlet, torus sliver splices to vertical
      cylinder { <0,3,0>, <0,-2,0>,2.5 }
      object { difference { torus { 24, 2.5      
                            rotate 90*x 
                                  }
                            plane { y,0
                                    rotate 180*z
                                  }             
                            plane { y,0
                                    rotate -20*z
                                  }
                          }
                translate <-24,-2,0>            
             }                            
      // rest is merged as one & offset by 20 degrees
      object { merge { // main descending cylinder
                       cylinder { <0,-10,0>, <0,-93,0>, 2.5 }  
                       // bend from vertical to flat on bench top
                       difference { torus { 40, 2.5
                                            rotate 90*z
                                           }  
                                     plane { y,0
                                             rotate 180*x 
                                           }  
                                     plane { z,0
                                             rotate 180*y
                                           }             
                                     translate <0,-90.5,40> 
                                   }                                                            
                       // curve flat on bench:
                       difference { torus { 25.5, 2.5 }       
                                    plane { x,0
                                            rotate 16*y  
                                          }
                                    plane { z,-0.01 }  
                                    translate <-25.5,-130.5,40>  
                                  }          
                       // exit along wall at back of bench:                     
                       cylinder { <25.5,0,-0.01>, <25.5,0,560>, 2.5   
                                  rotate -74*y     
                                  translate <-25.5,-130.5,40>  
                                }                                                      
                     }
                     translate <8,5,0>
                     rotate -20*z
                     translate <-7,-2,0>  
               }    
          }
          texture { T_Water_Tubing }  
      }
   
   
    
// water hose from condenser outlet =========================================================================
                           
                           
 
// work in co-ordinates for final scene then scale to fit condenser when attatching it
#declare outletHoseSolid =
  object
  {
    merge
    {  
      // attatchment to top of condenser:
      cylinder { <0,-3,0>, <0,3,0>, 2.5 }                   
      // hook over to top of main vertical:
      difference { torus { 6.5, 2.5  
                           rotate 90*z  
                           translate <0,3,6.5>
                         }
                   plane { y, 2.99 }
                 }                       
      // main vertical:           
      cylinder { <0,3,13>, <0,-143.879,13>, 2.5 }
      // curve from main vertical to flat on bench: 
      difference { torus { 40, 2.5     
                           rotate 90*z
                          }  
                   plane { y,0
                           rotate 180*x 
                         }  
                   plane { z,0
                           rotate 180*y
                          }             
                   translate <0,-143,53>  
                 }       
     // curve flat on bench:
     difference { torus { 36.987, 2.5 }
                   plane { x,0
                           rotate 15*y
                         }
                   plane { z,-0.01 }  
                   translate <-36.987,-183.378,53>  
                 }          
      // exit along wall at back of bench:                     
      cylinder { <36.987,0,-0.01>, <36.987,0,560>, 2.5
                 rotate -75*y
                 translate <-36.987,-183.378,53>
                }        
    } 
  }  
  
  
#declare outletHose =  
  object
  {
    merge
    {          
      // from condenser to top of hook ( perpendicular to condenser body )
      difference { object { outletHoseSolid }
                   plane { z,0
                           rotate 180*x 
                           translate 6.501*z
                         }   
                   texture { T_Water_Tubing }                   
                  }
      // rest of hose after hook ( offset by rotation so vertical is parallell to Y axis )
      object { difference { object { outletHoseSolid }
                            plane { z,6.499 } 
                          }        
               // rotate around joining point at top of hook           
               translate <0,-9.5,-6.5>
               rotate -20*z
               translate <0,9.5,6.5>              
             }                           
    }            
    texture { T_Water_Tubing }
  }
   
  
// Condenser ================================================================== 
 
 
 
#declare condenserOuterSolid = 
  merge 
  {  
    cylinder { <-104,0,0>, <104,0,0>, 20 }  
    sphere { <0,0,0>,20
             scale 0.95*x 
             translate -104*x
           }     
    sphere { <0,0,0>,20
             scale 0.95*x 
             translate 104*x
           }     
    object { maleJoint
             rotate -90*z
             translate -150*x  
           }                
    object { endGlassTubing
             translate -25.19*y             
             rotate -90*z
             translate 150*x 
           }    
    cylinder { <72,0,0>, <72,31,0>, 4.5 } // hose outlet
    cylinder { <-72,0,0>, <-72,-31,0>, 4.5 } // hose inlet
  }                                 



#declare condenserOuter = 
  difference 
  {
    object { condenserOuterSolid }
    cylinder { <-104,0,0>, <104,0,0>, 19.5 }
    sphere { <0,0,0>,19.5
             scale 0.95*x 
             translate -104*x                   
           }
    sphere { <0,0,0>, 19.5
             scale 0.95*x  
             translate 104*x
           }
    cylinder { <72,0,0>, <72,32,0>, 3.8 } // hollow hose outlet
    cylinder { <-72,0,0>, <-72,-32,0>, 3.8 } // hollow hose inlet
    cylinder { <-123.01,0,0>, <123.01,0,0>, 6.3 } // punch hole through ends
}                                                                  



#declare condenserBody =   
  merge 
  { 
    object { condenserOuter }
    object { qfGlassTubing 
             scale  6.13*y
             rotate 90*z
             translate  122.6*x
           }
  }                    



#declare waterSolid =  
// similar to condenser outer solid but a bit smaller in dimensions so it fits inside
  merge 
  {  
    cylinder { <-104,0,0>, <104,0,0>, 19.6 }  
    sphere { <0,0,0>,19.6
             scale 0.95*x 
             translate -104*x
           }     
    sphere { <0,0,0>,19.6
             scale 0.95*x 
             translate 104*x
           }                   
    cylinder { <-72,0,0>, <-72,-31,0>, 4 } // hose inlet
                                          // hose outlet added after trimming
  }                                 



#declare trimmedWater =
  difference {
               object { waterSolid }
               object { condenserOuter }  
               cylinder { <-122.7,0,0>, <122.7,0,0>, 7.8 }
               plane { y,0   
                       rotate 180*x
                       rotate -20*z
                       translate 131*x   
                     }  
             }



#declare water =
  object
  {
    merge
    {
      object { trimmedWater }
      cylinder { <72,8,0>, <72,31,0>, 3.8 } // hollow hose outlet      
    }  
    texture { T_Glass3 }
    interior { ior 1.33 }
  }  
     


#declare condenser =
  object
  {
    union
    {
      object { condenserBody 
               hollow off
             }
      object { femaleJoint
               rotate -90*z
               translate 150*x 
             }      
      object { inletHose
               scale 2  
               translate <-72,-31,0>
             }
      object { outletHose        
               scale 2
               translate <72,31,0>
             }     
      object { water }         
    }
    texture { T_qfGlass }   
    interior { I_Glass }
  }  



// Retort Stand ===========================================================
// in the local co-ordinates of the retort stand, the centre of the gripping claws
// is at <-8,159.14,-20.5>                                    
                                    

                                    
#declare retortBase =
  difference
  { 
    superellipsoid { <0.1, 0.1> 
                     scale <20,5,40>
                   }
    plane { y,0 }
  }         
  


#declare bossHead =
  difference
  {
    superellipsoid { <0.1, 0.1>
                     scale <8,5,5>
                   }
    box { <-6,0,-30>, <-2,30,30> }  
    box { <2,-30,-30>, <6,30,0> }
  }                                     

           

#declare upperClampMetal =
  difference
  {
    torus { 70, 0.8  
            sturm 
            rotate -90*x
            translate -58.5*y 
          }
    plane { x, 0
            rotate 15*z
            translate -13*x
          }  
    plane { x, 0
            rotate <0,180,-15>
            translate 21*x
          }                                                           
  }



#declare upperClampRubber =
  object
  {
    difference
    {
      torus { 70, 1 
              sturm
              rotate -90*x 
              translate -58.5*y  
            }   
      plane { x, 0
              rotate 15*z
              translate -12.5*x
            }              
      plane { x, 0
              rotate <0,180,-15>  
              translate 9*x
            }                     
    }
    texture { T_Orange_Rubber }
  }  
                       

                                              
#declare upperClamp =
  union
  {
    object { upperClampMetal }
    object { upperClampRubber }
  }  



#declare lowerClampCurveMetal =
  difference
  {
    torus { 30, 0.8 
            sturm    
            rotate -90*x 
            translate 19*y
          }
    plane { x, 0
            rotate -35*z
            translate -10*x
          }
   plane { x, 0
            rotate 180*y
            rotate 12*z
            translate 4*x
          }             
  }
  


#declare lowerClampCurveRubber =
  difference
  {
    torus { 30, 1     
            sturm  
            rotate -90*x           
            translate 19*y
          }  
    plane { x, 0
            rotate -35*z
            translate -9.5*x
          }
    plane { x, 0
            rotate 180*y
            rotate 12*z
            translate 4*x
          }                      
  }  



#declare lowerClampMetal =
  union
  {
    object { lowerClampCurveMetal }
    cylinder { <0,0,0>, <0,-23,0>, 0.8
               rotate 135*z 
               translate <6.2,-10,0>
             }
  }  
                         


#declare lowerClampRubber =
  object
  {
    union
    {
      object { lowerClampCurveRubber }
      cylinder { <0,0,0>, <0,-8,0>, 1   
                 rotate 135*z  
                 translate <6.2,-10,0>
               }
    }                           
    texture { T_Orange_Rubber }
  }  
                         

           
#declare lowerClamp =
  union
  {
    object { lowerClampMetal }
    object { lowerClampRubber }
  }           
           

  
#declare gripper  =
  union
  {

    object { upperClamp
             translate -3*z
           }
    object { upperClamp        
             translate 3*z            
           }    
    cylinder { <13.5,10.5,-3.45>, <13.5,10.5,3.45>, 1 } // crossbar between upper claws                      
    object { lowerClamp }
    cylinder { <13.5,17,0>, <13.5,-11,0>, 0.5 } // screw from upper claws to lower claws    
    box { <-2,15.5,0>, <2,16.5,0>              
          rotate 30*y 
          translate 13.5*x        
        }  
  }  


  
#declare horizontalArm =
  union
  {
    object { gripper     
             translate <-22.5,-6.5,0> 
             rotate -90*y    
//            rotate 90*y   // to check alignments from side
             translate -15*z
           }
    cylinder { <0,0,-15>, <0,0,0>, 2 }             
  }                 


                
//cylinder { <-5,0,0>, <5,0,0>, 10  // this cylinder aligns correctly with retort stand gripper
//           rotate 20*z
//         //  rotate 90*y   // to check alignments from side decrease x & increase z by 22.5
//           translate <-88.1,-40.86,0> 
//           texture { T_qfGlass}
//           interior { I_Glass }
//         }                  
  
  
                 
#declare retortStand =
  object
  {
    union
    {
      object { retortBase      
               translate -35*z  // want vertical over origin while building stand
             }
      cylinder { <0,0,0>, <0,220,0>, 2.5 } // main vertical
      object { bossHead
               translate <-4,164.94,0>
               texture { pigment { rgb <0.1,0.1,0.1> }}
             }                
      object { horizontalArm
               rotate 20*z  // ready to match angle of condenser
               translate <-8,164.948>
             }         
    }                       
    texture { T_Slightly_Rusty_Iron }   
  }                         
                           
                           
                                        
// Quickfit receiver nozzle ===========================================================
// oriented with center of female connector opening at origin, fitting curves down in -ve y
// direction then bends towards -x
           
           
           
#declare nozzleTubingBend = 
  difference 
  {
    torus { 18.75, 7.8  
            rotate -x*90
          }              
    torus { 18.75, 7.3 
            rotate -x*90
          }            
    plane { x,0 
            rotate -20*z
          }
    plane { y,0 }
  }
         
         
           
#declare nozzleCone =
  difference
  {
    cone { <0,0,0>, 7.8, 
           <0,-40,0>, 3.8
         }
    cone { <0,0.01,0>, 7.3,
           <0,-40.01,0>, 3.3
         }                    
  }
                           
                                                         
                 

#declare receiverNozzleBody =    
  merge 
  {       
    object { nozzleTubingBend }
    object { nozzleCone 
             translate 18.75*x
           }  
    object { endGlassTubing
             translate <18.75,39.999,0> 
             rotate 70*z
           }
  }



#declare receiverNozzle =
  object
  {
    union
    {
      object { receiverNozzleBody 
               hollow off
             }
      object { femaleJoint
               translate <18.75,65.2,0> 
               rotate 70*z
             }
    }
    rotate -70*z
    translate <-18.75,-65.2,0>
    texture { T_qfGlass } 
    interior { I_Glass }
  }    
 
                     

// droplet =========================================================================
 
   
   
#declare droplet =
  object
  {
    difference
    {
      object { Lemniscate
               rotate 90*z  
               scale <4,10,4>
             }  
      plane { y, 0 
              rotate 180*z
            }
     }                              
     texture { T_Droplet }
     interior { ior 1.33 }
   }    
 
                 
 
// Funnel =================================================================
// untransformed funnel base of cone & top of stem join at origin or just below. To sit nicely
// on top of a quickfit female joint of same scaling factor, needs to be 5*y lower than the 
// joint translation position

        
        
#declare funnelsolid = 
  merge 
  {
    cone { <0,24,0>, 30, 
           <0,-6,0>, 0
         }   
    cone { <0,0,0>, 3.5, 
           <0,-40,0>, 2.8
         }         
  }
        
        
        
#declare funnel =
  object
  { 
    difference 
    { 
      object { funnelsolid }
      cone { <0,0.1,0>, 3.3, 
             <0,-40.1,0>, 2.6
            }
      cone { <0,26,0>, 30, 
             <0,-4,0>, 0.0
             translate  0.25*y
           }
      plane { y,-35
              rotate 45*z
            }
    }
    texture { T_ClearLabGlass }
    interior { I_Glass }
  }

        
            
// Quickfit stopper bottle =====================================================



#declare bottleBody = 
  merge 
  {
    torus { 7.5, 2.5  // base of bottle is slightly rounded
            scale 0.4*y
            translate  1*y
          }
    sphere { <0,0,0>,10
             scale 0.6*y
             translate 27*y
            }
    cylinder { <0,1,0>, <0,27,0>, 10 }
  }



#declare bottleSolid = 
  merge
  {
    object { bottleBody }
    object { endGlassTubing
             translate -25.19*y 
             scale 0.5 
             translate 40.2*y 
           } 
  }



#declare bottleNeckless = 
  difference 
  { 
    object { bottleSolid }
    object { bottleBody 
             scale 0.7 
             translate 1.5*y
           }
    cylinder { <0,25,0>, <0,60,0>, 3.65 }
  }         
 

#declare bottle = 
  object
  {
    union
    {
      object { bottleNeckless 
               hollow off
             }
      object { femaleJoint
               scale 0.5 
               translate 40.2*y       
             }
    }
    texture { T_BrownLabGlass }    
    interior { I_Glass }
  }
 
    
#declare label =  
  intersection
  {
    cylinder { <0,1,0>, <0,27,0>, 10.1 
               pigment { image_map { sys "f2rt.bmp"  
                                     map_type 2
                                     once
                                   }         
                                   scale 15*y    
                                   rotate -90*y 
                                   translate 9*y
                        }              
             }  
     superellipsoid { <0.1, 0.1> 
                     scale <8,6,6>  
                     translate -6*z
                     rotate -20*y  
                     translate 17*y   
                   }   
  } 
    
    
    
       
// Bottle stopper =========================================================================       
           
          

#declare bottleStopper =
  object
  {
    merge 
    {
      object { groundMaleCone }
      cylinder { <0,19,0>, <0,24.5,0> 12.7 }
    }
    texture { T_BrownLabGlass }
    interior { I_Glass }                                        
  }
  
 
        
// Assemble Scene *********************************************************************       
       

// the following two values are used to adjust the orientation of the distillation assembly
// as a group since the objects involved must stay in alignment with each other
// used on all the objects which are connected except the hoses which would have to change
// shape if the other items were moved

#declare axisRotation = -120 // x value where I want distillation assembly to cross x axis
#declare rotationAngle = -15 // angle away from paralell with x axis
 
 
 

// 4 planks in bench
object  // near 
{ 
  woodenPlank
  translate  <0.0, -200, -100>
}       
object  
{ 
  woodenPlank
  translate  <0.0, -200, -40>    
}
object   
{ 
  woodenPlank
  translate  <0.0, -200, 20>
}
object  // far 
{ 
  woodenPlank
  translate  <0.0, -200, 80>
}



object { beanCan  
         translate <80,-200,80>
       }
                                    
object { beanCan  
         rotate 30*y
         translate <105,-200,70>
       }
                       
object { beanCan 
         rotate 5*y
         translate <112,-200,96.5>
       }
                     
object { beanCan
         rotate -15*y
         translate <95,-160,80>
       }
                        
               
                           
object { wallBehind }
                     
                     
               

object { gasTap               
         rotate -90*x
         translate <38,-185,110>
       }                           





object { gasLine }
     


object { bunsenBurner 
         translate -200*y
         translate (-1*axisRotation)*x rotate rotationAngle*y translate axisRotation*x // position group 
        }
                                                           
 
         
light_source { <0,-150,0>
               color <0.01,.1,0.7>
               looks_like { innerFlame }
               fade_distance 15   
               fade_power 2  
               translate (-1*axisRotation)*x rotate rotationAngle*y translate axisRotation*x // position group                
             }     


       
object { outerFlame  
         translate -150*y
         translate (-1*axisRotation)*x rotate rotationAngle*y translate axisRotation*x // position group  
       } 
            
                
                 
object { ringStand  
         translate -105*y 
         rotate 5*y  
         translate (-1*axisRotation)*x rotate rotationAngle*y translate axisRotation*x // position group 
       }   
      

  
object { roundBottomFlask  
         translate  -90*y   
         translate (-1*axisRotation)*x rotate rotationAngle*y translate axisRotation*x // position group 
       }    
            
 
object { flaskContents
          translate -90*y
         translate (-1*axisRotation)*x rotate rotationAngle*y translate axisRotation*x // position group 
       } 
       
      
     
object { indentedStopper
         scale 0.5
         rotate 53*y  // was50 
         translate 39*y
         rotate -40*z
         translate -90*y  
         translate (-1*axisRotation)*x rotate rotationAngle*y translate axisRotation*x // position group                                    
       }
       

       
object { qfBranchFitting
         scale 0.5
         translate 11.2*y   
         translate (-1*axisRotation)*x rotate rotationAngle*y translate axisRotation*x // position group 
       }  
              
   
              
object { knurledKnob 
         scale 0.5
         translate -1.2*y 
         translate (-1*axisRotation)*x rotate rotationAngle*y translate axisRotation*x // position group 
       }            
            
      

object { thermometer  
         scale 0.5
         translate <0,-9,0>   
         translate (-1*axisRotation)*x rotate rotationAngle*y translate axisRotation*x // position group 
       }
 

         
object { condenser 
         scale 0.5
         translate -62.4*x
         rotate 20*z
         translate <-29.46,-19.52,0>
         translate (-1*axisRotation)*x rotate rotationAngle*y translate axisRotation*x // position group   
       }  
 
     

object { retortStand 
         translate <-82,-200,29.5>
         translate (-1*axisRotation)*x rotate rotationAngle*y translate axisRotation*x // position group
       }
       
      
               
object { receiverNozzle 
         scale 0.5
         rotate 180*y
         translate 11.25*y
         rotate -70*z
         translate <-158.76,-66.58,0>    
         translate (-1*axisRotation)*x rotate rotationAngle*y translate axisRotation*x // position group 
      }
   
      
      
object { droplet 
         translate <-185,-110,0>
       } 
                 

      
object { funnel 
         scale 0.5
         translate <-187,-140.5,0>     
         translate (-1*axisRotation)*x rotate rotationAngle*y translate axisRotation*x // position group 
       }
 
  
       
object { bottle 
         scale 1.5
         translate <-187,-200,0>   
         translate (-1*axisRotation)*x rotate rotationAngle*y translate axisRotation*x // position group 
       }                
          


object { label  
         rotate (-1*rotationAngle)*y // keep label text facing viewer
         scale 1.5
         translate <-187,-200,0>             
         translate (-1*axisRotation)*x rotate rotationAngle*y translate axisRotation*x // position group 
        }  

 
       
object { bottleStopper 
         scale 0.75
         rotate 180*z
         translate <-160,-181.625,30>
       }    
       
      

                                                                