#version unofficial MegaPov 0.6;
	
#local cr=seed(complightsseed);
#local compblue = texture {
	pigment { rgb <1/3,2/3,1> }
	finish { diffuse 0.8 ambient 0 phong 0.2 specular 0.2}
}
texture {
	pigment {
		granite
		scale 20
		colour_map {
			[ 0 rgbt <0,0,0,5/6> ]
			[ 0.95 rgbt <0,0,0,1/3> ]
		}
	}
	finish {
		ambient 0
		diffuse 0
	}
}
#local compred = texture {
	pigment { rgb <1,2/3,1/3> }
	finish { diffuse 0.8 ambient 0 phong 0.2 specular 0.2}
}
texture {
	pigment {
		granite
		scale 20
		colour_map {
			[ 0 rgbt <0,0,0,5/6> ]
			[ 0.95 rgbt <0,0,0,1/3> ]
		}
	}
	finish {
		ambient 0
		diffuse 0
	}
}
#local compblack = texture {
	pigment {
		rgb 1
	}
	normal {
		granite 1
		scale 0.2
	}
	finish {
		ambient 0
		diffuse 0.05
		specular 0.85
		phong 0.1
		brilliance 20
	}
}
#macro rcomputer(yrot,pos)
	union {
		#local yc=0.5;
		#while (yc<15)
			#local yr=0;
			#while (yr<360)
				#local gvec=vrotate(x*4+y*(5+yc),y*yr);
				#local gcol=<floor(rand(cr)+0.5)/2+0.5,floor(rand(cr)+0.5)/2+0.5,0>;
				sphere { gvec 0.2 pigment { rgb gcol } finish { diffuse 0 ambient 1 } }
				#local yr=yr+90;
			#end
			#local yc=yc+0.5;
		#end
		cylinder { 5*y 20*y 4 texture { compblack } }
		box { -5,5 texture { compblack } }
		cylinder { <3,5,3> <3,20,3> 1.5 }
		cylinder { <-3,5,3> <-3,20,3> 1.5 }
		cylinder { <3,5,-3> <3,20,-3> 1.5 }
		cylinder { <-3,5,-3> <-3,20,-3> 1.5 }
		sphere { <3,20,3> 1.5 }
		sphere { <-3,20,3> 1.5 }
		sphere { <3,20,-3> 1.5 }
		sphere { <-3,20,-3> 1.5 }
		box { -1,1 scale <5.1,0.5,5.1> translate y*4.499 }
		box { -1,1 scale <5.1,1,5.1> }
		#local lr=0;
		#while (lr<360)
			box { 0,1
				texture {
					pigment {
						image_map {
							png "povtel_within.png"
							interpolate 2
						}
					}
					finish {
						ambient 0
						diffuse 1
					}
				}
				scale <6,1.5,0.1>
				translate <-1.5,1.5,-5.1>
				rotate y*lr
			}
			#local lr=lr+90;
		#end
		rotate y*yrot
		translate pos
		texture { compblue }
	}
#end
#macro scomputer(yrot,pos)
	union {
		#local yc=0.5;
		#while (yc<15)
			#local yr=0;
			#while (yr<360)
				#local gvec=vrotate(x*4+y*(5+yc),y*yr);
				#local gcol=<floor(rand(cr)+0.5)/2+0.5,floor(rand(cr)+0.5)/2+0.5,0>;
				sphere { gvec 0.2 pigment { rgb gcol } finish { diffuse 0 ambient 1 } }
				#local yr=yr+90;
			#end
			#local yc=yc+0.5;
		#end
		box { -1,1 scale <4,15,4> translate y*5 texture { compblack } }
		box { -5,5 texture { compblack } }
		cylinder { <3,5,3> <3,20,3> 1.5 }
		cylinder { <-3,5,3> <-3,20,3> 1.5 }
		cylinder { <3,5,-3> <3,20,-3> 1.5 }
		cylinder { <-3,5,-3> <-3,20,-3> 1.5 }
		sphere { <3,20,3> 1.5 }
		sphere { <-3,20,3> 1.5 }
		sphere { <3,20,-3> 1.5 }
		sphere { <-3,20,-3> 1.5 }
		box { -1,1 scale <5.1,0.5,5.1> translate y*4.499 }
		box { -1,1 scale <5.1,1,5.1> }
		#local lr=0;
		#while (lr<360)
			box { 0,1
				texture {
					pigment {
						image_map {
							png "povtel_within.png"
							interpolate 2
						}
					}
					finish {
						ambient 0
						diffuse 1
					}
				}
				scale <6,1.5,0.1>
				translate <-1.5,1.5,-5.1>
				rotate y*lr
			}
			#local lr=lr+90;
		#end
		rotate y*yrot
		translate pos
		texture { compred }
	}
#end

#local crot=90;
#while (crot<=315)
	#local xc=-10;
	#while (xc<=20)
		#local cvec=vrotate(<xc,0,60>,crot*y);
		#if (rand(cr)<0.5)
			scomputer(crot,cvec)
		#else
			rcomputer(crot,cvec)
		#end
		#local xc= xc+15;
	#end
	#local crot=crot+45;
#end

#local crot=90;
#while (crot<=225)
	#local xc=-2.5;
	#while (xc<=15)
		#local cvec=vrotate(<xc,0,40>,crot*y);
		#if (rand(cr)<0.5)
			scomputer(crot,cvec)
		#else
			rcomputer(crot,cvec)
		#end
		#local xc= xc+15;
	#end
	#local crot=crot+45;
#end
