// Worm hole stand
#version unofficial MegaPov 0.6;

union {
	#local src = 0;
	#while (src<360)
		#local ssc = 0;
		#while (ssc<=10)
			cylinder { <11+ssc,10-ssc,0> <21-ssc*2,0,0> 1 rotate y*src }
			torus { 0.9 0.1 rotate z*45 translate <11+ssc,10.1-ssc,0> rotate y*src
				texture {
					pigment {
						rgb 1
					}
					finish {
						ambient 0
						reflection 1
						diffuse 0
					}
				}
			}
			#local ssc=ssc+1;
		#end
		sphere { <21,0,0> 1 rotate y*src }
		sphere { <11,10,0> 1 rotate y*src }
		sphere { <1,0,0> 1 rotate y*src }
		#local src = src + 30;
	#end
	texture {
		pigment {
			rgb <0.4,0.2,0.1>
		}
		finish {
			ambient 0
			diffuse 0.2
			reflection 0.2
			specular 0.6
			phong 0.2
			metallic
		}
	}
}      

intersection {
	torus { 10 1 }
	cylinder { -1.01*y 1.01*y 10 inverse } 
	texture {
		pigment { rgb <0.9,1,1> }
		normal {
			facets 1 coords 0.1
		}
		finish {
			diffuse 0.2
			specular 0.4
			phong 0.4
			metallic
		}
	}
	translate y*10
}

union {
	#local src = 15;
	#while (src<360)
		union {
			cylinder { 10.5*x+y*10 12*x+y*10.8 0.2 }
			sphere { <12,10.8,0> 0.2 }
			#local epoi=<12,10.8,0>;
			#local erot=10;
			#local sec=3.25;
			#while (sec>0)
				union {
					cylinder { 0 sec*x sec*0.1 }
					sphere { sec*x sec*0.1 } 
					box { -1,1 scale <sec*0.4,0.1,sec> translate <sec/2,sec*0.1,0>
					        texture {
					                pigment { rgb 1 }
					                finish {
					                        ambient 0
					                        diffuse 0.1
					                        reflection 0.9
					                        specular 0.1
					                }
					        }
					}       
					rotate z*erot
					translate epoi
				}
				#local epoi=epoi+vrotate(sec*x,z*erot);
				#local erot=erot*1.5;
				#local sec=sec-0.5;
			#end
			rotate y*src
			texture { darkmetal }
		}
		glow { location vrotate(epoi,y*src) size 0.1 colour rgb y+z type 0 fade_power 2 }
		#local src=src+30;
	#end
}
