/*      Laboratory.pov
        
        Script-File for MegaPov 0.5a or PovRay 3.1g
        Renderer used: WinMegaPov 0.5a
        
         2000 by Markus Gohs - LIM
*/

#version 3.1;

default {texture {pigment { rgb <1,0,0> }}}
background { color 0 }

global_settings {
ambient_light <1.0,1.0,1.0>*4
max_trace_level 15
}

camera {  
//  location  <-.0,-.0001,.2>          
  location  <0.15,-.5,.2>           //  Renderlokalisation  <0.15,-.5,.2>
  sky       <0,0,1> 
  up        <0,0,1> 
  right     <1.333,0,0> 
  angle      40
//  look_at   <0,0,.0>             
  look_at   <0,0,.08>               //  Renderlokalisation   <0,0,.08>
}

light_source{<2,-1.5,2.4>color .65 fade_power 100 fade_distance 5}     // ****3.72

//      Objektschalter

#declare wand=          1;
#declare tisch=         1;
#declare notizblock=    1;
#declare bleistifte=    1;
#declare kugelschreiber=1;
#declare halbschalen=   1;
#declare objekttrager=  1;
#declare reagenzglaser= 1;
#declare pipette=       1;
#declare glaskolben=    1;

//      Texturen
#include "Texturen.inc"

//*************************************************************************************************
//      Objekte
//*************************************************************************************************

//*********************************************** Reagenzglas
#if(reagenzglaser)
#declare Reagenzglas=difference{
        merge{
        sphere{<0,0,0>.0075}
        cylinder{<0,0,0><0,0,.12>.0075}
        torus{.007,.001 rotate 90*x translate .12*z}
        }
        merge{sphere{<0,0,0>.0065}
        cylinder{<0,0,0><0,0,.13>.0065}
        }
material{Glas}
translate .0075*z}

//*********************************************** Reagenzglasinhalt
#declare xwert=seed(400);
#declare Reagenzinhalt=array[8]
#declare Count=0;
#while(Count<8)
#declare Reagenzinhalt[Count]=merge{
sphere{<0,0,0>.00649}
cylinder{<0,0,0><0,0,((.073*rand(xwert))+.04)>.00649}      
material{Blut}translate .0075*z}
#declare Count=Count+1;
#end

//*********************************************** Korken
#declare Korken=cylinder{<0,0,.12><0,0,.14>.00649}
#end  // Ende Reagenzglser

//*********************************************** Halbschale
#if(halbschalen)
#declare Halbschale=merge{
        difference{
        superellipsoid{<1,.08> scale .5 scale<.08,.08,.025> translate .0125*z}
        superellipsoid{<1,.08> scale .5 scale<.076,.076,.025> translate .0145*z}
        box{<1,1,.0205><-1,-1,.03>}
        }
        torus{.039,.001 rotate 90*x translate .0205*z}                
material{Glas}
}
#end

//*********************************************** Objekttrger
#declare Objekttrager=box{<-.025,-.01,0><.025,.01,.001>material{Glas}}

//*********************************************** Pipette
#if(pipette)
#declare Pipette=union{
difference{  // Pipettenkrper
  merge{
  cylinder{<-.03,0,0><.03,0,0>.004}
  sphere{<-.03,0,0>.004}
  cone{<-.0325,0,0>.003<-.038,0,0>.002}
  sphere{<-.038,0,0>.0025} 
  }
  merge{
  cylinder{<-.0295,0,0><.035,0,0>.0035}
  sphere{<-.0295,0,0>.0035}
  cylinder{<-.03,0,0><-.05,0,0>.0008}
  }
material{Glas}}  // Ende - Krper
  union{
  torus{.005,.0005 rotate 90*z translate .03*x}
  cylinder{<.03,0,0><.033,0,0>.005}
  cone{<.033,0,0>.005<.035,0,0>.004}
  cylinder{<.035,0,0><.045,0,0>.004}
  sphere{<.045,0,0>.004}
  material{Pipette_T}}
rotate -1.5*y translate .0049*z}
#end

//*********************************************** Bleistift
#if(bleistifte)
#declare Korper=prism {
  linear_sweep
  linear_spline
  0.1,0.0
  7 
  <-0.002, -0.0035>,
  <0.002, -0.0035>,
  <0.004, 0.0>,
  <0.002, 0.0035>,
  <-0.002, 0.0035>,
  <-0.004, 0.0>,
  <-0.002, -0.0035>
}
#declare Bleistift=union{   // union 1
difference{    // difference 1
  object{Korper}
  object{Korper scale<.98,.04,.98>translate -.001*y}    // Vorderteil
  union{ #declare Count=0;
    #while (Count<3)
    cylinder{<0,0,.1><0,0,-.1>.0014 scale <.8,2,1> rotate (Count*120)*y}
    #declare Count=Count+1;
    #end
    rotate 90*y}
  cylinder{<0,-.1,0><0,.00077,0>.005}
material{Bleistift_Korper}} // difference 1
union{ #declare Count=0;
    #while(Count<6)
    difference{ // difference 2
    cylinder{<0,0,0,><0,0,.00007>.000775}
    box{<-.1,0,-.1><.1,.1,.00008>}
    material{Bleistift_Korper}translate <0,.00077,.00343> rotate(Count*60)*y} // difference 2 
    #declare Count=Count+1;
    #end
} // union 2
union{  // union 4
difference{  // difference 3
  cone{<0,.003,0>.00385<0,0,0>.00343}
  union{ // union 3
  #declare Count=0;
  #while (Count<6)
  box{<-.1,-.1,.00343><.1,.1,.1> rotate (Count*60)*y}
  #declare Count=Count+1;
  #end
  } // union 3 
} // difference 3 
cone{<0,0,0>.00343<0,-.01,0>.001}    // Vorderteil - Spitze
material{Bleistift_Holz scale .005}} // union 4
cone{<0,-.01,0>.001<0,-.013,0>.00001 material{Bleistift_Mine}}    // Vorderteil - Spitze - Mine
union{  // Hinterteil
  cylinder{<0,.1,0><0,.113,0>.004}
  torus{.004,.0003 translate .1025*y}
  torus{.004,.0003 translate .1045*y}
  torus{.004,.0003 translate .1085*y}
  torus{.004,.0003 translate .1105*y}
material{Bleistift_Gold}}
superellipsoid{<1,.6> scale .5 scale<.00799,.00799,.0085>rotate 90*x translate .114*y material{Bleistift_Radiergummi}}  //  Radiergummi
translate <0,-.057,.0035>} // union 1
#end

//*********************************************** Kugelschreiber
#if(kugelschreiber)
#declare Kugelschreiber=union{
cone{<-.041,0,0>.0045<.041,0,0>.005 material{Kugelschreiber_Korper}}
cylinder{<.041,0,0><.044,0,0>.005 material{Kugelschreiber_Gold}}     // Hinterteil
difference{
  cylinder{<.044,0,0><.065,0,0>.005}
  box{<0,.01,0><.01,-.01,.02> rotate -35*y translate <.065,0,-.0075>}
material{Kugelschreiber_Korper}}
union{   // Drucker
  cylinder{<.05,0,0><.068,0,0>.004}
  sphere{<.068,0,0>.004}
  union{       //  Hemdhalter
       superellipsoid{<1,.1> scale .5 scale<.008,.008,.0015>translate -.016*x}
       superellipsoid{<.1,.1> scale .5 scale<.032,.008,.0015>}
       superellipsoid{<1,.1> scale .5 scale<.008,.008,.0015>translate .016*x}
       translate <.032,0,.0049>}
  material{Kugelschreiber_Gold}}
cylinder{<-.041,0,0><-.056,0,0>.00425 material{Kugelschreiber_Korper}}//   Vorderteil
union{ #declare Count=0;
     #while(Count<8)
     box{<-.0075,-.0005,0><.0075,.0005,.0045> rotate (Count*45)*x translate -.0485*x}
     #declare Count=Count+1;
     #end
     material{Kugelschreiber_Korper}}
cone{<-.056,0,0>.00425<-.069,0,0>.002 material{Kugelschreiber_Gold}}
union{  // Mine
     cylinder{<-.068,0,0><-.0705,0,0>.001}
     cone{<-.0705,0,0>.001<-.072,0,0>.0005}
     sphere{<-.072,0,0>.0005}
     material{Kugelschreiber_Mine}}
rotate 90*x translate .005*z}
#end

//*********************************************** Notizblock
#if(notizblock)
#declare Notizblock=union{
difference{
  box{<-.0525,-.075,0><.0525,.075,.003>}
  union{ #declare Count=0; #declare Abstand=0;
       #while(Count<13)
       superellipsoid{<.4,.3> scale .5 scale<.004,.004,.0032> translate <Abstand,0,.0015>}
       #declare Count=Count+1; #declare Abstand=Abstand+.008;
       #end
       translate <-.048,.07,0>}
  texture{Karos scale 1.001}
  texture{Block_T scale .999}
}
union{
     #declare Count=0; #declare Abstand=0;
     #while(Count<13)
     torus{.0033,.0007 rotate 90*z translate Abstand*x}
     #declare Count=Count+1; #declare Abstand=Abstand+.008;
     #end
     translate <-.048,.0735,0>material{Kugelschreiber_Mine}}
}
#end

//*********************************************** Kachelwand  -  used from my lamp.pov scene
#if(wand)
#declare Stein=superellipsoid{<.2,.2> scale <1,1,.05> scale .05 translate <.05,-.05,0>}
#declare Stein_1=union{
        #declare Count=0; #declare Anzahl=10; #declare Abstand=0;
        #while(Count<Anzahl)
        object{Stein translate Abstand*x}
        #declare Count=Count+1; #declare Abstand=Abstand+.205;
        #end
        translate -((Anzahl*.205)/2)*x  translate .1025*x
}
#declare Stein_2=union{
object{Stein_1}
object{Stein_1 translate <-.1025,-.1025,0>}}
#declare Stein_3=union{
        #declare Count=0; #declare Anzahl=10; #declare Abstand=0;
        #while(Count<Anzahl)
        object{Stein_2 translate -Abstand*y}
        #declare Count=Count+1; #declare Abstand=Abstand+.205;
        #end
        translate ((Anzahl*.205)/2)*y
}
#declare Kachelwand=union{
object{Stein_3 material{Wand rotate 45*y scale .5} translate -.0024*z}
object{Stein_3 material{Wand scale .5} rotate 180*y translate <-.0025,0,-.0024>}
box{<-3,-3,-.002><1,1,-.009> material{Zement scale .05}}
}
#end

//*********************************************** Kacheltisch
#if(tisch)
#declare Kachel=superellipsoid{<.08,.08> scale .5 scale<.1,.1,.02> translate <0,0,-.01>}
#declare Kachel_1=union{ #declare Count=0; #declare Abstand=0; #declare Anzahl=20;
#while (Count<Anzahl)
  object{Kachel translate Abstand*x}
  #declare Count=Count+1; #declare Abstand=Abstand+.1025;
  #end
  translate -((Anzahl*.1025)/2)*x
}
#declare Tisch=union{ #declare Count=0; #declare Anzahl=4; #declare Abstand=0;
  #while(Count<Anzahl)
  object{Kachel_1 translate -Abstand*y}
  #declare Count=Count+1; #declare Abstand=Abstand+.1025;
  #end
box{<-1,-.3555,-.0008><1,.1,-.018>material{Zement scale .25}}
material{Tisch_Stein scale .005}
}     
#end

//*********************************************** Steckdose
#if(wand)
#declare Steckdose=union{
difference{
  union{
  superellipsoid{<.1,1,> scale .5 scale<.08,.08,.01>}
  box{<-.03,-.03,0><.03,.03,-.025>}
  }
  cylinder{<0,0,-.01,><0,0,.01>.02}
  cylinder{<-.01,0,-.0245,><-.01,0,.01>.0025 pigment{color .2}}
  cylinder{<.01,0,-.0245,><.01,0,.01>.0025 pigment{color .2}}
  box{<-.0015,.022,-.0245><.0015,.017,.003>}
  box{<-.0015,-.022,-.0245><.0015,-.017,.003>}
}
box{<-.018,.0025,-.01><-.022,.0125,.003>}
box{<.018,.0025,-.01><.022,.0125,.003>}
box{<-.018,-.0025,-.01><-.022,-.0125,.003>}
box{<.018,-.0025,-.01><.022,-.0125,.003>}
cylinder{<0,0,-.011><0,0,-.009>.0015 material{Bleistift_Mine}}  // Schraube
torus{.003,.001 rotate 90*z translate <0,.02,-.00125> material{Bleistift_Mine}}
torus{.003,.001 rotate 90*z translate <0,-.02,-.00125> material{Bleistift_Mine}}
material{Steckdose_T}}
#end

//*********************************************** Glaskolben
#if(glaskolben)
#declare Kolben=lathe { 
  cubic_spline
  8  
  <0.0, 0.0>,
  <0.0, 0.0>,
  <0.04, 0.003>,
  <0.0475, 0.03>,
  <0.040402, 0.055488>,
  <0.015, 0.085>,
  <0.012, 0.15>,
  <0.012, 0.15>
  rotate <90,0,90>}
#declare Glaskolben=
union{
merge{
difference{
object{Kolben}
object{Kolben scale .968421 translate .0005*z}
box{<-1,-1,.145><1,1,.16>}
}
torus{.0115,.002 rotate 90*x translate .145*z}  
material{Glas}}
// Inhalt
intersection{
object{Kolben scale .966 translate .0005*z}
plane {z,.06}
material{Substanz}}
translate .0005*z}
#end

//*************************************************************************************************
//      Szene
//*************************************************************************************************

//*********************************************** Objekttrger
#if(objekttrager)
union{
object{Objekttrager}
object{Objekttrager rotate 10*z translate .001*z}
object{Objekttrager rotate 12*z translate .002*z}
object{Objekttrager rotate -5*z translate .003*z}
object{Objekttrager rotate -2*z translate .004*z}
object{Objekttrager rotate -12*z translate .005*z}
object{Objekttrager rotate 8*z translate .006*z}
object{Objekttrager rotate 5*z translate .007*z}
object{Objekttrager rotate 20*z translate .008*z}
object{Objekttrager rotate -15*z translate .009*z}
translate <0,.15,0>}
union{
object{Objekttrager}
object{Objekttrager rotate -10*z translate .001*z}
object{Objekttrager rotate 5*z translate .002*z}
object{Objekttrager rotate -5*z translate .003*z}
object{Objekttrager rotate -12*z translate .004*z}
object{Objekttrager rotate -8*z translate .005*z}
object{Objekttrager rotate 18*z translate .006*z}
object{Objekttrager rotate 12*z translate .007*z}
object{Objekttrager rotate -10*z translate .008*z}
object{Objekttrager rotate -15*z translate .009*z}
object{Objekttrager rotate 25*z translate .010*z}
object{Objekttrager rotate 8*z translate .011*z}
object{Objekttrager rotate -12*z translate .012*z}
object{Objekttrager rotate -9*z translate .013*z}
rotate 55*z translate <-.05,.22,0>}
object{Objekttrager rotate -40*z translate <0,.09,.0001>}
object{Objekttrager rotate 28*z translate <-.07,.14,.0001>}
#end

//*********************************************** Reagenzglser
#if(reagenzglaser)
#declare Locher=union{ #declare Count=0; #declare Abstand=0;
#while(Count<4)
cylinder{<0,0,.02><0,0,.11>.0075 translate Abstand*x}
#declare Count=Count+1; #declare Abstand=Abstand+.03;
#end}
union{
 union{
  difference{
    union{
    box{<-.02,-.01,.0975><.11,.05,.1>}
    box{<-.02,-.01,.04><.11,.05,.0425>}
    box{<-.028,-.01,0><.118,.05,.01>}
    }
  object{Locher}
  object{Locher translate .04*y}
  }
box{<-.02,.0175,.1025><-.028,.025,0>}
box{<.11,.0175,.1025><.118,.025,0>}
cylinder{<-.018,.048,0><-.018,.048,.1>.001}
cylinder{<.108,.048,0><.108,.048,.1>.001}
cylinder{<-.018,-.008,0><-.018,-.008,.1>.001}
cylinder{<.108,-.008,0><.108,-.008,.1>.001}
material{Holz rotate 45*y scale .015}}
union{ // vordere Reihe
object{Reagenzglas texture{R_1}}
object{Korken material{Korken_T}}
object{Reagenzinhalt[0]} 
//object{Reagenzglas      translate<.03,0,0>}
//object{Reagenzinhalt[1] translate<.03,0,0>}
object{Reagenzglas  texture{R_3}   translate<.06,0,0>}
object{Korken translate <.06,0,0> material{Korken_T}}
object{Reagenzinhalt[2] translate<.06,0,0>}
object{Reagenzglas texture{R_4}    translate<.09,0,0>}
object{Korken translate <.09,0,0> material{Korken_T}}
object{Reagenzinhalt[3] translate<.09,0,0>}
// hintere Reihe
object{Reagenzglas texture {R_5}  translate<0,.04,0>}
object{Korken translate <0,.04,0> material{Korken_T}}
object{Reagenzinhalt[4] translate<0,.04,0>}
object{Reagenzglas texture {R_6}    translate<.03,.04,0>}
object{Korken translate <.03,.04,0> material{Korken_T}}
object{Reagenzinhalt[5] translate<.03,.04,0>}
object{Reagenzglas texture {R_7}  translate<.06,.04,0>}
object{Korken translate <.06,.04,0> material{Korken_T}}
object{Reagenzinhalt[6] translate<.06,.04,0>}
object{Reagenzglas texture {R_8} translate<.09,.04,0>}
object{Korken translate <.09,.04,0> material{Korken_T}}
object{Reagenzinhalt[7] translate<.09,.04,0>}
translate .01*z}
translate -.045*x rotate 40*z translate<-.16,.08,0>}
cylinder{<-.01,0,0><.01,0,0>.00649 rotate 80*z translate <-.14,.01,.00649> material{Korken_T}}
//  Blutfleck
height_field {
    tga "Fleck.tga"
    water_level 0.001
    smooth on
  rotate    -90*x 
  scale     <  1, 1,-1>     // Hight_Field spiegeln
  translate -.5  // Nullpunkt in die Mitte setzen
  scale <.15,.15,.0022>
  translate .0007*z
material{Blut}
}

// gebrochenes Reagenzglas
union{    
difference{
object{Reagenzglas}
plane{z,.07 rotate 35*y material{Glas}}
rotate 90*z rotate 90*y translate .0076*z translate -.1*x rotate 65*z}

difference{
object{Reagenzglas texture {R_2} rotate 180*x}
plane{z,-.07 rotate -35*y material{Glas}}
translate .13*z rotate -90*y rotate -25*z translate -.03*y translate .015*x translate .0076*z}
translate <.01,.01,0>}
#end

//*********************************************** Pipette
#if(pipette)
object{Pipette rotate 215*z translate<-.12,-.06,0>}
#end

//*********************************************** Halbschalen
#if(halbschalen)
union{
object{Halbschale}
object{Halbschale translate .0215*z}
object{Halbschale translate .043*z}
object{Halbschale translate <-.085,0,0>}
object{Halbschale translate <-.085,0,.0215>}
object{Halbschale translate <.1,0,0>}
object{Halbschale translate <.1,0,.0215>}
object{Halbschale translate <.1,0,.043>}
object{Halbschale translate <.1,0,.0645>}
object{Halbschale translate <.1,0,.086>}
translate <.11,.22,.0001>}
#end

//*********************************************** Glaskolben
#if(glaskolben)
object{Glaskolben translate <-.33,.18,0>}
#end

//*********************************************** Bleistifte
#if(bleistifte)
object{Bleistift rotate 60*z translate<.04,-.08,0>}
object{Bleistift rotate -90*z translate<.21,.10,0>}
#end

//*********************************************** Kugelschreiber
#if(kugelschreiber)
object{Kugelschreiber rotate 70*z translate<.13,.01,.003>}
#end

//*********************************************** Notizblock
#if (notizblock)
object{Notizblock rotate 35*z translate<.14,-.02,0>}
#end

//*********************************************** Wand
#if (wand)
difference{
object{Kachelwand scale .8 rotate 90*x translate <0,.3,-.0025>}
box{<-.025,-.03,-.025><.025,.03,.025> translate <.082,.3,.165>}
box{<-.025,-.03,-.025><.025,.03,.025> translate <-.246,.3,.165>}
}
object{Steckdose rotate 90*x translate <.082,.3,.165>}
object{Steckdose rotate 90*x translate <-.246,.3,.165>}
#end

//*********************************************** Tisch
#if (tisch)
object{Tisch translate .25*y}
box{<-1,-.1,-.01><1,0,-1> material{Wand scale .2}}
#end

#if (tisch=0)
box {<-.5,-.11,0,><.5,.3,-.00001>pigment{color rgb<0,0,1>}}
#end


