// Persistence of Vision Ray Tracer Scene Description File
// File: mglab_2.inc
// Vers: 3.1


#version 3.1;

#include "colors.inc"
#include "textures.inc"

// >>>Flame_Tex  (from file "povlab.inc",) <<<
#declare Flame_Tex = texture {
  pigment {
    gradient < 0.0 0.0 1.0 >
    turbulence < 0.150, 0.150, 0.150 >
    colour_map {
      [ 0.000 rgb < 1.000, 1.000, 1.000 > ]
      [ 0.200 colour red .8 green .4 blue 0 ]
      [ 0.200 rgb < 0.800, 0.400, 0.000 > ]
      [ 0.600 colour red 1.0 green 1.0 blue 1.0 filter 1 ]
      [ 0.600 rgbf < 1.000, 1.000, 1.000, 1.000 > ]
      [ 1.000 rgbf < 1.000, 1.000, 1.000, 1.000 > ]
    }
  }
  finish {
    ambient < 1.000, 1.000, 1.000 >
    phong 0
  }
}
// >>> Flare_Texture (from file "povlab.inc", line 15078) <<<
#declare Flare_Texture = texture {
  pigment {
    color rgbf < 1.000, 1.000, 1.000, 1.000 >
  }
  finish {
    ambient 0.5
    
    specular .8
    roughness 0.025
  }
}
// >>> Fire (from file "povlab.inc", line 5687) <<<
#declare Fire = texture {
  pigment {
    gradient y
    turbulence 0.20
    omega 0.80
    color_map {
      [0.00 color rgbf <1.00, 1.00, 1.00, 0.5>]
      [0.08 color rgbf <0.98, 1.00, 0.02, 0.08>]
      [0.29 color rgbf <1.00, 0.74, 0.01, 0.40>]
      [0.53 color rgbf <1.00, 0.16, 0.01, 0.67>]
      [0.79 color rgbf <1.00, 1.00, 1.00, 1.00>]
      [1.00 color rgbf <1.00, 1.00, 1.00, 1.00>]
    }
    scale <3.00, 7.50, 3.00>
  }
  finish {
    ambient 0.3
  }
  translate <0.00, -3.25, 0.00>
}

#declare candela=
texture{
pigment{wrinkles 
    frequency 3
    turbulence 0.9
    octaves 4
    omega 0.8
    lambda  00.5
    color_map {         
                [0.3 color Clear]
                [0.5 color Firebrick filter 0.5  transmit 0.5 ]//0.6 Orange
                [0.7 color Clear] 
                [1.0 color OldGold filter 0.5  transmit 0.5] }   //MandarinOrange 
     //translate -15*y
    
    }
  finish {
    
    ambient 0.5
    diffuse 0.5
    
    
}
  
}





#declare flama=  
light_source
{
  0*x // light's position (translated below)
  color IndianRed  filter 0.2 // transmit 0.5light's color 
  fade_power 1
  fade_distance 10
  translate <0,0,0>
  looks_like { sphere{<0.05,0,0.05> 0.002

} }


}  
  
  
//horno destilador
#declare Oldcan3 = texture {
  pigment {
    granite
    color_map {
      [ 0.5 color Gray20 ]
      [ 0.7 color Gray35]
      [ 1.0 color Gray50 ]
      
      
                }
    scale < 0.060, 0.060, 0.060 >
  }
  
  normal {
    agate 0.8
    turbulence 0.6
    scale 0.43
  }
  
  finish {
    
    ambient 0.25
    
  }
  
}

// >>> Stone28 (from file "povlab.inc", line 7492) <<<
#declare Stone28 = texture {
  pigment {
    agate
    agate_turb 0.75
    frequency 6
    scale 0.5
    rotate <0, -45, 5>
    color_map {
      [0.02 color rgbf <0.65, 0.45, 0.25, 0.0> ]
      [0.06 color rgbf <0.55, 0.40, 0.20, 0.0> ]
      [0.10 color rgbf <0.15, 0.10, 0.05, 0.0> ]
      [1.00 color rgbf <0.75, 0.60, 0.40, 0.0> ]
    }
  }
}
texture {
  pigment {
    crackle
    turbulence 0.1
    lambda 2.5
    omega 0.75
    octaves 5
    scale 0.75
    frequency 1
    phase 0.25
    rotate <0, 45, 60>
    color_map {
      [0.00 color rgbf <1,1,1,1> ]
      [0.25 color rgbf <0.40, 0.25, 0.15, 0.50> ]
      [0.30 color rgbf <0.00, 0.00, 0.00, 0.00> ]
      [0.35 color rgbf <0.40, 0.25, 0.15, 0.50> ]
      [0.40 color rgbf <0.45, 0.55, 0.35, 0.60> ]
      [0.65 color rgbf <1,1,1,1> ]
    }
  }
}
texture {
  pigment {
    crackle
    turbulence 0.1
    lambda 2.5
    omega 0.75
    octaves 5
    scale 0.45
    frequency 2
    phase 0.25
    rotate <0, 5, 60>
    color_map {
      [0.00 color rgbf <1,1,1,1> ]
      [0.25 color rgbf <0.65, 0.25, 0.40, 0.50> ]
      [0.30 color rgbf <0.00, 0.00, 0.00, 0.00> ]
      [0.45 color rgbf <0.50, 0.60, 0.35, 0.25> ]
      [0.50 color rgbf <0.65, 0.25, 0.40, 0.50> ]
      [0.65 color rgbf <1,1,1,1> ]
    }
  }
}

//otra

// >>> Fire_Map (from file "povlab.inc", line 5941) <<<
#declare Fire_Map = texture {
  pigment {
    wood
    turbulence 0.20
    omega 0.80
    color_map {
      [0.00 color rgb <1.00, 1.00, 1.00>]
      [0.08 color rgbf <0.98, 1.00, 0.02, 0.08>]
      [0.29 color rgbf <1.00, 0.74, 0.01, 0.40>]
      [0.53 color rgbf <1.00, 0.16, 0.01, 0.67>]
      [0.79 color rgbf <1.00, 1.00, 1.00, 1.00>]
      [1.00 color rgbf <1.00, 1.00, 1.00, 1.00>]
    }
    scale <3.00, 7.50, 3.00>
  }
  finish {
    ambient 0.45//1.00
  }
  translate <0.00, -3.25, 0.00>
}






#declare horno=
union{
difference{

cylinder
{
  0*y,  4*y,  1
  
}

cylinder
{
  0.25*y,  3.90*y,  0.80
   open
  
}

cylinder
{
  0*x,  2*x,  0.25
  
  rotate 70*y
  translate <0,3,0>
  
}




}

cylinder
{
  0.25*y,  0.50*y,  0.60
  
  translate <0,3.75,0>
} texture {
        Oldcan3


        }

}

#declare horno2=
union{
object {horno rotate 40*y}


sphere {<0,-0.09,0> 0.40

texture {Fire_Map scale 0.15}
translate <0,3,0>
}

}





// >>> Candelar_Texture (from file "povlab.inc", line 15007) <<<
#declare Candelar_Texture = texture {
  pigment {
    color rgb < 1.000, 0.800, 0.460 >
  }
  finish {
    ambient < 0.110, 0.110, 0.110 >
    diffuse 0.43
    brilliance 2
    reflection < 0.300, 0.300, 0.300 >
    specular 0.2
    roughness 0.02
    phong 0.53
    phong_size 5
    metallic
  }
  normal {
    dents .9
    scale < 0.030, 0.030, 0.030 >
  }
}


// >>> tela (from file "mg_tut1.inc", line 1354) <<<
#declare tela2 = texture {
  pigment {
    gradient y
    frequency 150//50
    color_map {
      [0.25 rgbf <1.0, 1.0, 1.0, 0.0>]
      [0.25 rgbf <1.0, 1.0, 1.0, 1.0>]
      [0.75 rgbf <1.0, 1.0, 1.0, 1.0>]
      [0.75 rgbf <1.0, 1.0, 1.0, 0.0>]
    }
  }
}
texture {
  pigment {
    gradient x
    frequency 150//50
    color_map {
      [0.25 rgbf <1.0, 1.0, 1.0, 0.0>]
      [0.25 rgbf <1.0, 1.0, 1.0, 1.0>]
      [0.75 rgbf <1.0, 1.0, 1.0, 1.0>]
      [0.75 rgbf <1.0, 1.0, 1.0, 0.0>]
    }
  }
  normal {
    bumps 0.6
  }
  finish {
    ambient 0.2
  }
}


#declare tela3 = texture {
  pigment {
    gradient y
    frequency 150
    color_map {
      [0.25 Black]
      [0.25 rgbf <1.0, 1.0, 1.0, 1.0>]
      [0.75 rgbf <1.0, 1.0, 1.0, 1.0>]
      [0.75 IndianRed]
    }
  }
}
texture {
  pigment {
    gradient x
    frequency 150
    color_map {
      [0.25 Black]
      [0.25 rgbf <1.0, 1.0, 1.0, 1.0>]
      [0.75 rgbf <1.0, 1.0, 1.0, 1.0>]
      [0.75 IndianRed]
    }
  }
  normal {
    bumps 0.6
  }
  finish {
    ambient 0.2
  }
}

#declare malla = texture {
  pigment { 
  spiral1 20
    turbulence 0.4
    frequency 7
    scale 0.50
    color_map { 
    [0.225 color Clear] 
    [0.25 rgbf <0.451,0.075,0.000,0.500>]  
    [0.275 color Clear]
    [0.725 rgbf <0.451,0.075,0.000,0.500>]
    [0.75 color Clear]
    [0.775 rgbf <0.451,0.075,0.000,0.500>]
  }
    rotate <45,0,0>
  }
  normal{agate  agate_turb  0.6 scale 0.25} 
  finish{phong 1 ambient 0.4 diffuse 0.3 specular 1.0 }
  
}
  



#declare velas=
texture{
        pigment{
                gradient x
                color_map{
                        [0.0 color rgbft <0.835,0.275,0.000,0.500,0.500>]
                        [0.300 color Clear]
                        [0.400 color rgbft <0.973,0.984,0.835,0.500,0.500>]
                       [0.700 color Clear]
                        [1.0 color rgbft <0.471,0.549,0.643,0.500,0.500>]
                }        
                scale 0.01
		turbulence 0.5
		octaves 3
		omega 0.2
                }
        
        finish{ambient 0.3 crand 0.2}


}


#declare metal2=
texture {
  pigment {
    agate
    color_map {
      [0.0 0.5 color rgbf <1.00, 1.00, 1.00, 1.0>
      color rgbf <1.00, 1.00, 1.00, 1.0>]
      [0.5 1.0 color rgb <0.80, 0.53, 0.46>
      color rgb <0.85, 0.75, 0.35>]
    }
  }
  finish { specular 1.0  }
  scale <0.02 200 0.02>
  rotate <0 30 0>
}

// >>> LimogesOpakGlossTex (from file "povlab.inc", line 13673) <<<
#declare LimogesOpakGlossTex = texture {
  pigment {
    color rgb < 0.978, 0.980, 1.000 >
  }
  finish {
    ambient < 0.550, 0.550, 0.550 >
    diffuse 0.45
    specular 1
    brilliance 3
    reflection < 0.125, 0.125, 0.125 >
    roughness 0.001
  }
}


#declare WrinkleGray = texture {
  pigment {
    color rgb <0.45, 0.4, 0.4>
  }
  finish {
    roughness 0.9
    ambient 0.3
    diffuse 0.7
    phong 0.5
    phong_size 10
  }
  normal {
    wrinkles 0.5
  }
  scale <0.1 0.1 0.1>
}

// >>> LimogesOpakSemiTex (from file "povlab.inc", line 13688) <<<
#declare LimogesOpakSemiTex = texture {
  pigment {
    color rgb < 0.978, 0.980, 1.000 >
  }
  finish {
    specular 1
    roughness 0.001
    reflection < 0.061, 0.061, 0.061 >
    roughness 0.003
  }
  normal {
    bumps 0.7
  }
  scale < 2.000, 2.000, 2.000 >
}



#declare envase=
sor
{
    7, 
    <0.000000, -0.0> 
    <0.40,0.0 >
    <0.57,0.25 >
    <0.60,0.50 >
    <0.70,0.80 >
    <0.85,0.90 >
    <0.70,1.0 >
    open
    texture{
    pigment{VLightGray}
    finish {Dull}
    
    }
}

//object{envase} 


#declare envase2=
sor
{
    7, 
    <0.000000, -0.0> 
    <0.05,0.0 >
    <0.47,0.10 >
    <0.60,0.15 >
    <0.62,0.25 >
    <0.50,0.35 >
    <0.25,0.5 >
    open
    texture{
    pigment{VLightGray}
    finish {Dull}
    
    }
} 



#declare envase3=
sor
{
    7, 
    <0.000000, -0.0> 
    <0.05,0.0 >
    <0.47,0.10 >
    <0.50,0.15 >
    <0.50,0.25 >
    <0.50,0.35 >
    <0.51,2.5 >
    
    open
    
    pigment{Silver}
    
    normal {bumps 0.5 scale 0.05  bump_size 0.10}
    finish {
        metallic
        ambient 0.0
        diffuse 0.0
        brilliance 6.0
        reflection 0.9
        phong 0.8
        phong_size 120
   }
}       
//object{envase2}


// >>> Pierre14 (from file "povlab.inc", line 14684) <<<
#declare piedras1=
texture {
  pigment {
    bozo
    color_map {
      [ 0.00 rgb < 0.235, 0.035, 0.027 > ]
      [ 0.12 rgb < 0.545, 0.255, 0.184 > ]
      [ 0.43 rgb < 0.816, 0.537, 0.027 > ]
      [ 0.63 rgb < 1.000, 1.000, 0.588 > ]
      [ 0.91 rgb < 0.839, 0.604, 0.071 > ]
    }
    rotate < -25.000, 0.000, 0.000 >
    scale < 3.800, 1.800, 2.100 >
    lambda 6
    octaves 4
    turbulence < 0.500, 0.500, 0.500 >
    omega .55
  }
  finish {
    ambient < 0.200, 0.200, 0.200 >
    diffuse .90
  }
}
texture {
  pigment {
    granite
    color_map {
      [ 0.00 rgbf < 0.235, 0.035, 0.027, 0.000 > ]
      [ 0.19 rgbf < 0.465, 0.275, 0.184, 0.400 > ]
      [ 0.25 rgbf < 0.716, 0.537, 0.027, 0.700 > ]
      [ 0.65 rgbf < 1.000, 1.000, 1.000, 1.000 > ]
      [ 1.00 rgbf < 1.000, 1.000, 1.000, 1.000 > ]
    }
    rotate < 25.000, 0.000, 0.000 >
    scale < 4.200, 2.200, 2.300 >
  }
  finish {
    ambient < 0.200, 0.200, 0.200 >
    diffuse .90
    phong .5
    phong_size 20
  }
}

#declare piedras2=
texture {
  pigment {
    bozo
    color_map {
      [ 0.00 rgb <0.471,0.635,0.620>]
      [ 0.12  rgb <0.271,0.271,0.369> ]
      [ 0.43  rgb <0.741,0.624,0.482> ]
      [ 0.63  rgb <0.086,0.851,0.843> ]
      [ 0.91  rgb <0.012,0.325,0.388>]
    }
    rotate < -25.000, 0.000, 0.000 >
    scale < 3.800, 1.800, 2.100 >
    lambda 6
    octaves 4
    turbulence < 0.500, 0.500, 0.500 >
    omega .55
  }
  finish {
    ambient < 0.200, 0.200, 0.200 >
    diffuse .90
  }
}
texture {
  pigment {
    granite
    color_map {
      [ 0.00 rgbf < 0.235, 0.035, 0.027, 0.000 > ]
      [ 0.19 rgbf < 0.465, 0.275, 0.184, 0.400 > ]
      [ 0.25 rgbf < 0.716, 0.537, 0.027, 0.700 > ]
      [ 0.65 rgbf < 1.000, 1.000, 1.000, 1.000 > ]
      [ 1.00 rgbf < 1.000, 1.000, 1.000, 1.000 > ]
    }
    rotate < 25.000, 0.000, 0.000 >
    scale < 4.200, 2.200, 2.300 >
  }
  finish {
    ambient < 0.200, 0.200, 0.200 >
    diffuse .90
    phong .5
    phong_size 20
  }
}


#declare metal3=
texture {
        pigment {
                colour rgb <0.64, 0.51, 0.05>
                }
        finish {
                ambient 0.3
                diffuse 0.5
                reflection 0.9
                brilliance 8
                specular 0.5
                }
        }
        
        
#declare metal4=
texture{
    pigment{CoolCopper}
    normal {bumps 0.5 scale 0.05  bump_size 0.20}
    finish {
            metallic
            ambient 0.2
            diffuse 0.2
            brilliance 6.0
            reflection 0.9
            phong 0.9
            phong_size 120
            }
   
    }