// Persistence of Vision Ray Tracer Scene			
// Megapov0.6 and Megapov0.5aPlusMod0.3.2 based on Pov-Ray for Windows 3.1g
// Fichier        : mrlabo.pov by  Martial Rameaux
// Date           : 09 to 10/2k
// Description    : The Labotory    
//                  Topic
//                  Glassware, boiling stuff in funny beakers, electric arcs, 
//                  vague organic shapes floating in cloudy liquid, telescopes, 
//                  microscopes, oscilloscopes, proctoscopes, the Mad,  Scientist! 
//                  Any area or equipment used mainly for scientific research.   
//
// Tools Used     : Poser3  http://
//                  3DWin convector by Thomas Baier 3DWin homepage http://www.stmuc.com\thbaier 
//                  Dos Meshcompres by Warp http://
//                  PSP6 for Autemps.png
// 
// 
// PageWeb   -> http://martial.rameaux.free.fr/
// Emile ;-) -> martial.rameaux@free.fr
//==========================================
// 13h12m26s
//=============================
#version unofficial megapov 0.5;   
//==============================
#debug "\nStar parsing.... \n"
// ==== Standard POV-Ray Includes ====
#include "colors.inc"	   // Standard Color definitions
#include "textures.inc"	   // Standard Texture definitions

//***********
//FOR_WORKS *   
//***********

#declare Caro   = on;    // Carrelage 
#declare Wom1   = on;    // Woman off pailliasse     
#declare Cag    = on;    // Cage  
#declare Baro   = on;    // Barreau 
#declare Pail   = on;    // Paille off paillasse
#declare Scal   = on;    // Scapel 
#declare atpm   = on;    // Au temps pour moi :))

#declare Fnsh   = on;    // Finish Brillance and reflection

#declare Rad    = on;    // Mise en route de la radiosit


//*****************
//GLOBAL_SETTINGS *
//*****************
global_settings {
      //  assumed_gamma 1.0 
      
        ini_option "+Qr +AA.1 "//"+AA.001 +AM2 +R4//
        max_trace_level 40 //30
        // RADIOSITE
        #if(Rad)
         radiosity{
        pretrace_start 0.16
        pretrace_end   0.01
        //count 300             
        count 100
        //count 30     
        nearest_count 4      
        error_bound 0.1      
        recursion_limit 1    
        low_error_factor 1  
        gray_threshold 0.5  
        minimum_reuse 0.015 
        brightness 1.2      
        adc_bailout 0.01/2  
        }
        #end
}  
//*********   
//LUMIERE *
//*********
#if (Rad = off)
light_source {<100,500, -500> rgb <.98,.99,.98>}     
#end
//*********
//CAMERA  *
//*********  
camera {location <-10,15,-20> 
        right x*image_width/image_height
        up y    
        angle 40
        look_at <0,1.2,0> 
} 
  
//*******************************
//DEFAUT AND GLOBAL DECLARATION *  
//*******************************
#default { texture {pigment { Red } finish { diffuse 1 ambient 0 } } }
//RANDOM  
#declare sd=seed(312); 
#declare SD=seed(520);  
//*******************
// SKY               
//*******************
sky_sphere {pigment {rgb <.95, .95, 1> } } //*.2   *1.8

//*********
//TEXTURE_*
//********* 
               
#declare T_Crasse = texture { // by Bouf from JV Picqueres
        pigment {
                wrinkles
                color_map {
                        [0.0 Clear]
                        [1.0 DarkBrown*.5 filter 0.5]
                }
        }
}
#declare T_Alu = texture {
	pigment { color rgb <.8, .8, .8> }
	normal { bumps .2 scallop_wave scale .5 }
	finish { ambient .0 diffuse 1// ambient .3 diffuse .6
		specular .5 roughness .05
		metallic
	}
}  

#declare T_Chrom = texture {
	pigment { color rgb <.99, .99, .99> }
	//normal { bumps .2 scallop_wave scale .5 }
	finish { ambient .0 diffuse .6
		specular .5 roughness .05
		reflection 1
		reflection_min .3 reflection_max .6  reflect_metallic .6 reflection_exponent .8
		//metallic
	}
}  

#declare T_Miroire = texture {
            pigment {rgb 1}
            finish {ambient 0.1 diffuse 0 reflection 1   }
            }
            
               
#declare T_Fonte = texture {
	pigment { color rgb <.1, .1, .1> }
	normal { bumps .2 scallop_wave scale .5 }
	finish { ambient .3 diffuse .6
		//specular .5 roughness .05
		reflection_min .3 reflection_max .6  reflect_metallic .6 reflection_exponent .8
		//metallic
	}
}  
#declare T_Gold = texture {
	pigment {color <1.00, 0.875, 0.575> }//gold original
	normal { bumps .2 scallop_wave scale .5 } 
	#if (Fnsh)
	finish { ambient 0 diffuse 1//ambient .3 diffuse .6
		specular .5 roughness .05
		reflection <0.1,0.1,.2> metallic
	}          
	#end
}
#declare T_Cage_Alu = texture {
	pigment {color rgb <0.855,0.925,0.933>}//color <1.00, 0.875, 0.575> }//gold original
	normal { bumps .2 scallop_wave scale .5 } 
	#if (Fnsh)
	finish { ambient .3 diffuse .6
		specular .5 roughness .05
		reflection <0.1,0.1,.2> metallic
	}          
	#end
}

#declare T_Rouille = texture {
	pigment {
		granite
		color_map {
			[0 DarkTan*.5]
			[0.7 DarkBrown*.5]
			[1 Orange*.5]
		}
	}
	normal{ granite .6 scale .1 }  
	#if(Fnsh)
	finish{ ambient .4 diffuse .6
		specular .3 roughness .5
	}        
	#end
}
#declare T_Alu_Rouille = texture {
	bozo
	scale 3
	texture_map {
		[0.0 T_Alu ]
		[1.0 T_Rouille scale 5 ]
	}
	warp { reset_children }
	warp { turbulence 1 lambda 2 octaves 3 }
}
#declare T_Gold_Rouille = texture {
	bozo
	scale 3
	texture_map {
		[0.0 T_Cage_Alu ]
		[1.0 T_Rouille scale 5 ]
	}
	warp { reset_children }
	warp { turbulence 1 lambda 2 octaves 3 }
}
#declare M_Verre = material {
                    texture {
                     pigment { rgbt <0.0,1,.0,.9> }
                     finish  { ambient .3 diffuse .6  }
                    }
                    interior {ior 1.5   
                        dispersion 1.2
                        disp_nelems 10
         }
}

#declare M_Verre = material {
                    texture {
                     pigment { rgbt <0.0,1,.0,.9> }
                     finish  { ambient .3 diffuse .6  }
                    }
                    interior {ior 1.5   
                        dispersion 1.2
                        disp_nelems 10
         }
}
//*****************
// MAKE_CARRELAGE *
//*****************
#if(Caro)
#debug "Carrelage in parse... \n"
#declare F_Carreau = 
              #if (Fnsh)  
                finish {
                        ambient 0//.4
                        diffuse 1//.6
                        brilliance .6
                        reflection_min 0
                        reflection_max .3
                        reflection_falloff 2     
                        specular .2 roughness .01    
                        phong 1 phong_size 5
                }          
                #else
                finish { ambient 0 diffuse 1}
              #end
              
#declare F_Wall =
                #if (Fnsh)
                finish {  
                         ambient 0//0.4 
                         diffuse 1//.7
                         brilliance 6 
                         specular .6 
                         roughness .05 //metallic .6
                         reflection_min .3 
                         reflection_max .6  
                         reflect_metallic .6 
                         reflection_exponent .8
                }            
                #else 
                finish { ambient 0.0 diffuse 1}
                #end    
                 
  

union {  

box { <-20.8,-8.8,0>,<20.8,-.09,-.1095>  pigment {color rgb 1.2} translate z*-4.9 }  // Joint  Devant sous_pailliasse
box { <-20.8,-.1,-5.08>,<20.8,-.03,5> pigment {color rgb 1.2 }   }  // Joint Paillliasse Dessus
box { <-20.8,-8.5,0>,<20.8,8,-.055 >   pigment {color rgb 1.2 } translate z*3.8}  // Joint Mur
difference {
        cylinder {<-20.8,0,3.6><20,0,3.6>.1 }
        plane { z,0 rotate x*45 translate z*3.6}
      //  cylinder {<-20.8,0,3.6><20,0,3.6>.2 translate z*-.15}
        pigment {color rgb 1.2 }   
        normal {average
                  normal_map {
                        [1 bozo .1 scale .1 turbulence .1 octaves 3]
                        [1 marble .5 scale .05 ]
                            } 
                }      
}   
                
                                                                                                             
#declare Carreau =   
        union {
                box { <-1, 0, -1>, <1, .1, 1> }
                sphere { 0, .1 translate -x-z }
                sphere { 0, .1 translate -x+z }
                sphere { 0, .1 translate x-z }
                sphere { 0, .1 translate x+z }
                cylinder { -x-z, x-z, .1 }
                cylinder { -x-z, -x+z, .1 }
                cylinder { x-z, x+z, .1 }
                cylinder { -x+z, x+z, .1 } 
       }      


#declare Carreauy =  
        union {
                box { <-1, -1, 0>, <1, 1, -.1> }
                sphere { 0, .1 translate -x-y }
                sphere { 0, .1 translate -x+y }
                sphere { 0, .1 translate x-y }
                sphere { 0, .1 translate x+y }
                cylinder { -x-y, x-y, .1 }
                cylinder { -x-y, -x+y, .1 }
                cylinder { x-y, x+y, .1 }
                cylinder { -x+y, x+y, .1 }     
        }      

#declare Carro_Casse1 =
        difference {
                    object {Carreau} 
                    height_field {png "hf_oct.png" smooth scale <2,1.5,2> rotate x*160 translate <0,1.6,-0.8*1.1>
                    texture {
                                         pigment {color 1 }
                                         normal {average
                                                 normal_map {
                                                        [1 bozo rand(SD)*.1 scale .1 turbulence rand(SD)*.1 octaves 3]
                                                        [1 dents rand(SD)*.5 scale .05 ]
                                                } 
                                        }      
                                         finish {F_Carreau }  
                        }   
                    }    
        }
        
#declare Fct_iso1 = function{pigment{ripples turbulence .3 scale 0.5}}  
#declare N_iso1   = normal { function {Fct_iso1(x,y,z)*.2}}

#declare Fct_iso2=function{pigment{crackle  turbulence 0.8 scale .5}}
#declare N_iso2= normal { function {Fct_iso2(x,y,z)} scale <1,1.2,1>}
      
//**************
// PAILLIASSE  *
//**************

#local i=-20; //20
#while (i<20)           
               // #debug concat ("I : ",str(i,1,3),"\n")
                #local j=-4;
                #while (j<4)   
                      #local rd = rand(sd);
                        #while (rd < .95)
                        #local rd = rand(sd);
                        #end             
                       //#debug concat (str(rd,1,5),"\n")
                        #local C_Car =  color rgb rd;
                                         
                        #local T_Car =  texture {
                                         pigment {color C_Car }
                                         normal {average
                                                 normal_map {
                                                        [1 bozo rand(SD)*.1 scale .1 turbulence rand(SD)*.1 octaves 3]
                                                        [1 dents rand(SD)*.5 scale .05 ]
                                                } 
                                        }      
                                         finish {F_Carreau }  
                        }   

                        #if ((i = 4.2) & j = -4 ) // Place Break_Tile 
                        object { Carro_Casse1 texture {T_Car}
                        #else 
                        object {Carreau texture { T_Car }
                        #end 
                        translate <i, -.1, j>
                        }                      
                       // #debug concat ("J : ",str(j,1,3),"\n")
                        #local j=j+2.2;
                #end
        #local i=i+2.2;
#end         

// BOTTOM PAILLIASSE
#local i=-20;
#while (i<20)
        #local j=-8;
        #while (j<0)
                object { Carreauy
                      #local rd = rand(sd);
                        #while (rd <.90)
                        #local rd = rand(sd);
                        #end                  
                        texture { pigment {rgb rd}   
                                  normal {average
                                         normal_map {
                                                [1 bozo rand(SD)*.1 scale .1 turbulence rand(SD)*.1 octaves 3]
                                                [1 dents rand(SD)*.5 scale .05 ]
                                        } 
                                }        
                                  finish {F_Carreau}
                        }             
                       translate <i, j+.25,-4.95 > 
                       
                }
          #local j=j+2.2;
        #end
        #local i=i+2.2;
#end
       // scale <.2,.3,.2>  
// End_union_Carreau_pailliasse

//WALL  *******

#local i=-20; 
#while (i<20)
        #local j=.8;
        #while (j<10)     
                #local rd = rand(sd);
                #while (rd <0.95)
                #local rd = rand(sd);
                #end          
             // #debug concat ("\nmur :",str(rd,1,5))
                object { Carreauy    
                        texture {
                                pigment {rgb rd}     
                                normal {average
                                         normal_map {
                                                [1 bozo rand(SD)*.1 scale .1 turbulence rand(SD)*.1 octaves 3]
                                                [1 dents rand(SD)*.5 scale .05 ]
                                        } 
                                }         
                                finish { F_Wall }
                                }      
                       translate <i, j+.25,3.8 >
                }      
                #local j=j+2.2;
       #end   
        #local i=i+2.2;
#end  
translate y*1.2
}// End_union_Carreaux

#end //IF_CARO

//**********
// SOL     *
//**********
#if(Caro)
#local i=-30; //20
union {
#while (i<30)           
                #local j=-30;
                #while (j<30)   
                      #local rd = rand(sd);
                        #while (rd < .95)
                        #local rd = rand(sd);
                        #end             
                        #local C_Car =  color rgb rd;
                        #local T_Car =  texture {
                                         pigment {color C_Car }
                                         normal {average
                                                 normal_map {
                                                        [1 granite rand(SD)*.1 scale .1 turbulence rand(SD)*.1 octaves 3]
                                                        [1 marble rand(SD)*.5 scale .05 ]
                                                } 
                                        }      
                                         finish {F_Carreau }  
                        }   

                        object {Carreau texture { T_Car }
                        translate <i, -8,j+.2>
                        }                      
                        #local j=j+2.2;
                #end
        #local i=i+2.2;
#end         
plane {y,-8.1 texture { T_Car }}
translate <0,.25,1.2>
}
#end
//*******************
//CAGE  and Pailler *
//*******************
#declare Cage = 
union {   
        #local Ray = 2.5;   // Rayon de la cage       
        #local Eps = 0.020; // Epaisseur des bareaux
        #local Hau = 3.0;   // Hauteur de la cage
        #local k = 0;      // counter
        #local Nb= 40;     // Nombre de bareaux

#if (Cag) 
#debug "Cage in parse... \n"

union {   
// anneau
torus {.25,Eps  rotate <90,20,0>  translate y*(Hau+Ray+.25) }   
sphere { 0,.05   translate y*(Hau+Ray)}    
cylinder { <-.3,0,0><.3,0,0>Eps translate  y*(Hau+Ray-Eps)}  
torus {.35,Eps  translate y*(Hau+Ray-Eps)}   


// barreau 
#if (Baro)  
#declare Barre=union {
torus {Ray-Eps,Eps  translate y*.12 }
torus {Ray-Eps,Eps  translate y*(Hau)} 
torus {sqrt( (Ray-Eps)^2 - ((Ray-Eps)-1.5)^2 ),Eps  translate y*(Hau+Ray-1.5)}   
torus {sqrt( (Ray-Eps)^2 - ((Ray-Eps)-1)^2 ),Eps  translate y*(Hau+Ray-1)}   
torus {sqrt( (Ray-Eps)^2 - ((Ray-Eps)-0.5)^2 ),Eps  translate y*(Hau+Ray-.5)}   
torus {sqrt( (Ray-Eps)^2 - ((Ray-Eps)-0.25)^2 ),Eps  translate y*(Hau+Ray-.25)}   

#while (k < Nb ) 
        difference { 
                union {
                cylinder {<Ray-.05,0.1,0><Ray-.05,Hau,0>Eps rotate y*k*(360/Nb) }
                torus { Ray-.05,Eps clipped_by {box {<-(Ray+1),-1,-(Ray+1)><0,1,0>}} rotate x*90  translate y*Hau rotate y*k*(360/Nb)}
                }
        sphere { 0,.3 translate  y*(Hau+Ray)}
        box { <-1,-1,-1.3><3,1.83,.7> translate <0,1.2,0> }// MAKE DOOR
        }
        #local k = k +1;        
#end    
}        
  
object { Barre rotate y*9}
#end //IF_BARO
// textures
texture {T_Gold_Rouille}
//pigment {color rgb <0.949,0.957,0.486>}    
//finish {F_Wall}   
rotate y*-13
translate y*1.17    
}  
#end // If_Cage

//*********
// PAILLE *  
//*********   
#if (Pail)    
#debug "Paille in parse... \n"
#include "paille.inc"  //author Bouffartigue
#declare sr = seed(136258);  
// Paille_mesh(coin1, coin2, nbb, larg, turb, sturb, nbs, st)
#declare m_paille = Paille_mesh(<-1, 0, -1>, <1, .15, 1>, 50 .01, .91, 5, 5, sr)  
object {
        //Paille_tapis(coin1, coin2, nbx, nbz, m_paille, st)
        Paille_tapis(<-2.9, .01, -1.9>, <2.9, .01, 1.9>, 7, 7, m_paille, sr)
        clipped_by { cylinder { <0,0.1,0><0,1.,0>Ray }  }
        texture {
                pigment {
                        spotted
                        turbulence .4 octaves 2
                        scale <.2,.005,.2>
                        color_map {
                                [.2 color rgb<1,.9,.3>]
                                [.5 color rgb<.9,.7,.4>]
                                [.8 color rgb<.9,.9,.1>]
                        }
                }
                finish {ambient 0.3 diffuse .8}         
        }
        translate y*1.2
}
#end                   
} // End_union_cage   

//**********
//  PORTE  *
//**********
#declare k = 0;
#declare Nb = 6 ;
#declare Porte = 
union {
union {
torus {Ray-Eps,Eps  translate y*.7 }
torus {Ray-Eps,Eps  translate y*3}
clipped_by {box {<-1,.695,-1.5><8,3,0> }}
}
#while (k < Nb ) 
                cylinder {<Ray-.05,0.7,0><Ray-.05,Hau,0>Eps rotate y*k*(45/Nb) }
        #local k = k +1;        
#end    
}

//****************
// CAGE_PAILLE
//****************
#declare Cage =  
union {
object {  Porte texture {T_Gold_Rouille}
  translate <-2.5,1.2,0> 
  rotate y*-90 translate x*2.5
  }
// fond
union {
        cylinder { <0,0,0><0,.1,0>2 }     
                difference {
                        cylinder { <0,.1,0><0,.7,0>Ray+.1 }     
                        cylinder { <0,.1,0><0,1.,0>Ray-.1}            
                }   
        torus {Ray+.1,.05 scale <1,.5,1> translate y*.7 }   
        texture {T_Alu_Rouille}
        translate y*1.17
}   

object { Cage }  

rotate y*45
}

//*********
// SCAPEL *
//*********
#if (Scal)
#declare Scapel = 
union {
cylinder{ <0,-.1,0><0,1,0>.02 	}
cone {<0,1,0>.02<0,1.3,0>.01}
sphere {<0,-.1,0>0.02}
prism{
	cubic_spline
	0,
	0.01,
	7,
	<0.000000,1.001297>,
	<0.194584,0.539160>,
	<0.170261,0.081077>,
	<0.000000,0.093238>,
	<0.000000,1.001297>,
	<0.194584,0.539160>,
	<0.170261,0.081077>
	texture {T_Chrom}
	scale .6
	rotate x*-90
	translate <-.0,.9,0>
} 
texture {
pigment {rgb <.98,.98,.98>}
normal { gradient y scale 5 }
finish { ambient 0 diffuse 1  reflection .01}
        }
}

#end

//****************************************************
// WOMAN 
// Poser3 convert by 3dwin and meshcompress pcm => inc 
//****************************************************
 

#if (Wom1)  
//#debug "Woman in parse \n"  
#declare T_Hair  = texture {pigment {average  pigment_map { [1.0 IndianRed] [1.0 Scarlet]} } 
                            finish { diffuse 1 ambient 0 phong .1 } }   
#declare T_Woman = texture {pigment { Flesh } finish { diffuse 1 ambient 0} }
#include "woman3.inc"     
#declare Woman =
object {Woman texture {T_Woman} } 
#end  

//*******
//AUTEMPS
//*******
#if (atpm)
#declare Au_temps_pour_moi=
box{<0,0,0><1,1,0.0001> 
        texture {
                pigment {
                        image_map { png"autemps.png" once }
                }
        }
        scale <1.5,1.5,1>
}
#end // END_IF
         

//************
// AFFICHAGE *
//************

#if(Cag)  object {Cage translate x*-6.0 }#end // x*-6.5}  // x*-8    light_group "PointTubes"
#if (Scal)object {Scapel  scale 3 rotate x*90 rotate z*180 rotate y*45 translate <2,1.24,-2>} #end
#if(atpm) object {Au_temps_pour_moi  rotate x*90 rotate y*-20 translate <-2.8,1.21,-4.6>}#end
#if (Wom1) object { Woman rotate y*-40 translate x*.8  }#end      // light_group "PointTubes"

//*********************  
#debug "End parsing \n"
//End_of_File





