//#include "colors.inc"
//#include "textures.inc"
//#include "metals.inc"
#version unofficial MegaPov 0.5;


#declare Glass2 = 
texture {
    pigment { rgbf <1,1,1,.9> }
    finish {
        ambient 0
        diffuse 0
        reflection 0.24
        refraction 0.85
        phong 0.3
        phong_size 60
    }
}

#declare T_Black_Metal = 
texture { 
  pigment {color rgb <.30,.50,.50 > }    
  normal { 
    granite 0.1
    turbulence 0.5
    scale 7
  }
  finish {
    diffuse 0.7
    specular 0.450
    roughness 1/50
  }
}


#declare T_Cage = 
texture { 
  pigment { 
    crackle
    colour_map {
      [ 0.0  rgb <.20,.20,.30 > ]
      [ 0.1  rgb <.20,.20,.30 > ]
      [ 0.1  rgb <.90,.90,.05 > ]
      [ 1.0  rgb <.90,.90,.05 > ]
    }
    turbulence 0.1
    scale 0.003
  }
  normal { 
    granite 0.1
    turbulence 0.5
    scale 7
  }
  finish {
    diffuse 0.8
    specular 0.150
    roughness 1/20
  }
}


#declare T_Cockpit =
texture {
  pigment {rgb 0} 
  finish{Metal} 
  normal {bumps scale .3}
} 


#declare M_Water = 
  material 
  {
    interior 
    { 
       ior 1.42 
       fade_power 1000 
       fade_distance 5 
       caustics 0.2
       media 
       { 
         absorption <0.1,0.02,0.05> 
         intervals 1 
         samples 2,2 
       }
    }
    texture { 
      pigment { rgbt <0.01,0.01,0.01,0.95> } 
      finish 
      {   
        ambient 0 diffuse 0 
        reflection_type 1 
        reflection_min 0 
        reflection_max 1 
        reflection_falloff 2
        conserve_energy blinn 1 
        facets 0.1        
      } 
    }
  }

#declare N_Granite = 
  normal 
  { 
    granite 0.5 
    scale 11
  }

#declare N_Waves   = 
  normal 
  { 
    waves 0.05 
    frequency 5000 
    scale 700 
  }

#declare N_Ocean = 
  normal 
  { 
    average 
    normal_map { 
      [0.3 granite 1 scale 10] 
      [0.7 N_Waves] 
    } 
  }


#declare T_Submarine = 
texture {
  pigment {
    image_map {
      tga "subpaint.tga" 
      map_type 0 
      interpolate 2
    }
    scale <1.5,.7,.5>
    translate <.7,0,0>
  }
  finish {
    diffuse 0.8
    specular 0.150
    roughness 1/20
  }
}


#declare T_White_Metal = 
texture { 
  pigment {color rgb <.90,.90,.90 > }    
  finish {
    diffuse 0.8
    specular 0.150
    roughness 1/20
  }
}


#declare T_Base_Building = 
texture { 
  pigment {color rgb <.30,.50,.50 > }    
  normal { 
    granite 0.2
    turbulence 0.4
    scale .1
  }
  finish {
    diffuse 0.7
    specular 0.450
    roughness 1/50
  }
}


#declare T_Rust = 
texture { 
  pigment { 
    ripples
    color_map {
      [0.0  rgbt <1,1,1,1>] 
      [0.1  rgbt <0.8,0.3,0.0,0.7> ] 
      [0.45 rgbt <1,1,1,1>] 
      [0.5  rgbt <0.8,0.3,0.0,0.7> ] 
      [0.65 rgbt <1,1,1,1>] 
      [0.9  rgbt <0.8,0.3,0.0,0.7> ] 
      [1.0  rgbt <1,1,1,1>] 
    }
    turbulence 0.7
    omega 0.8
    scale 0.05
    rotate 90*y
  }
  normal { 
    dents .2 
    turbulence 0.7
    scale .05
  }
}


#declare T_Heavy_Rust = 
texture { 
  pigment { 
    ripples
    color_map {
      [0.0  rgbt <1,1,1,.8>] 
      [0.1  rgbt <.8,.3,0,.3> ] 
      [0.5  rgbt <.8,.3,0,.4> ] 
      [0.65 rgbt <1,1,1,.8>] 
      [0.9  rgbt <.8,.3,0,.5> ] 
      [1.0  rgbt <1,1,1,.8>] 
    }
    turbulence 0.6
    omega 0.8
    scale 0.05
    rotate 90*y
  }
  normal { 
    dents .2 
    turbulence 0.7
    scale .05
  }
}


#declare T_Building_Rust = 
texture { 
  pigment { 
    ripples
    color_map {
      [0.0  rgbt <1,1,1,1>] 
      [0.1  rgbt <0.8,0.3,0.0,0.7> ] 
      [0.45 rgbt <1,1,1,1>] 
      [0.5  rgbt <0.8,0.3,0.0,0.7> ] 
      [0.65 rgbt <1,1,1,1>] 
      [0.9  rgbt <0.8,0.3,0.0,0.7> ] 
      [1.0  rgbt <1,1,1,1>] 
    }
    turbulence 0.7
    omega 0.8
    scale 0.1
    rotate 90*y
  }
  normal { 
    dents .2 
    turbulence 0.7
    scale .2
  }
}
     
#declare T_Dirt = 
texture {
  pigment { 
    bozo
    colour_map {
      [ 0.0 rgbt <1,1,1,1> ]
      [ 1.0 rgbt <0.4,0.3,0.1,.4> ]
    }
    turbulence 0.7
    omega 0.8
    scale 0.2
  }
  normal { 
    granite .1 //wrinkles 0.8
    turbulence 0.3
    omega .3
    scale <.25,2,.25>
  }
}

#declare T_Grass = 
texture {
  pigment { 
    crackle
    colour_map {
      [ 0.0  rgbt <.9, 0.8, 0.4, 1.0> ]
      [ 0.28 rgbt <.0, 0.7, 0.5, 0.2> ]
      [ 0.3  rgbt <.1, 0.5, 0.4, 0.4> ]
      [ 0.32 rgbt <.2, 0.7, 0.6, 0.2> ]
      [ 1.0  rgbt <.9, 0.8, 0.4, 1.0> ]
    }
    turbulence 0.5
    omega 0.8
    scale 0.3
  }
  normal { 
    crackle 0.5
    turbulence 0.5
    omega 0.8
    scale 1.7
  }
}

#declare T_Moss = 
texture {
  pigment { crackle
    colour_map {
      [ 0.0  rgbt <1,1,1,1> ]
      [ 0.95 rgbt <1,1,1,1> ]
      [ 0.1  rgbt <0,1,0,.6> ]
      [ 0.15 rgbt <0,1,0,.6> ]
      [ 0.2  rgbt <1,1,1,1> ]
      [ 1.0  rgbt <1,1,1, 1> ]
    }
    turbulence 0.7
    omega 0.8
    scale 0.3
  }
  normal { 
    granite 0.3
    turbulence 0.3
  }
}


#declare T_Liquid =
texture {
  pigment { agate
    colour_map {
      [ 0.0 rgbt <0.309804, 0.309804, 0.184314, .3>] //< .7, .3, .1, .1> ]
      [ 0.8 rgbt < 1, 1, 1, 1> ]
      [ 1.0 rgbt < 1, 1, 1, 1> ]
    }
    turbulence 0.3
    scale .09
  }
  finish { ambient .99 specular 0.2 roughness 1/600 reflection 0.55 }
}    


#declare T_Base =
texture {
  pigment { granite
    colour_map {
      [ 0.0 rgb <.9,0.6, 0.2>*.8 ]
      [ 0.6 rgb <.9,0.65,0.35>*.9 ]
      [ 1.0 rgb <.9,0.7, 0.4> ]
    }
    turbulence 0.1
    scale .05
  }
  
  normal { wrinkles 0.8
    turbulence 0.3
    omega .3
    scale <.25,.1,.25>
  }
}    

#declare T_Base_Rock =
texture {
  pigment { 
    crackle //bozo
    colour_map {
      [ 0.0 rgb <.1, 0.4, 0.1> ]
      [ 0.1 rgb <.1, 0.4, 0.1>*.2 ]
      [ 1.0 rgb <.1, 0.4, 0.1>*.1 ]
    }
    turbulence 0.7
    scale .3
  }
  
  normal { 
    wrinkles 0.8
    turbulence 0.3
    scale .3
  }
}    


#declare T_Rocks =
texture {
  pigment { 
    crackle
    colour_map {
      [ 0.0  rgb <0.1, 0.4, 0.1>*.7  ]
      [ 0.02 rgb <0.1, 0.4, 0.1>*.6  ]
      [ 0.04 rgb <0.1, 0.4, 0.1>*.2 ]
      [ 1.0  rgb <0.1, 0.4, 0.1>*.1 ]
    }
    turbulence 0.1
    omega 0.7
    scale 0.30  
  }
  normal { 
    wrinkles 0.3
    turbulence 0.3
    scale .3
  }
}    


#declare T_Sand =
texture {
  pigment { 
    crackle
    colour_map {
      [ 0.0 rgb <.8,0.8, 0.6> ]
      [ 0.6 rgb <.9,0.75,0.45> ]
      [ 1.0 rgb <.9,0.8, 0.5> ]
    }
    turbulence 0.5
    scale .3
  }
  
  normal { wrinkles 0.8
    turbulence 0.2
    omega .3
    scale .1
  }
}    


#declare T_Water03 =
texture{ 
  pigment { 
    crackle
    colour_map {
      [ 0.0 rgb < 0.7, 0.72, 0.7>  ]
      [ 0.01 rgb < 0.7, 0.72, 0.7>  ]
      [ 0.05 rgb < 0.2, 0.5, 0.3>  ]
      [ 1.0 rgb < 0.05, 0.05, 0.05>  ]
    }
    turbulence 0.1
    omega 0.65
    scale 0.4
  }
  normal { 
    wrinkles 0.3
    turbulence 0.3
    scale .3
  }
  finish { ambient .2 }            
}
                               

#declare T_Water01 = 
texture{
  pigment { color rgbt <0.3,0.3,0.8,.22> }

  normal { 
    gradient x 0.5
    sine_wave
    scale <.9,4,.9>
    rotate <0,30,0>
  }            
  finish { diffuse 0.6 specular 0.6 roughness 1/199 reflection 0.2 }
}


#declare T_Water01 =
texture {
  pigment { 
    crackle
    colour_map {
      [ 0.0 rgbt <.4, .5, 0.8, .20> ]
      [ 1.0 rgbt <.2, .3, 0.7, .30> ]
    }
    turbulence 0.7
    omega 0.8
    scale 1.3
  }
  normal { 
    gradient x 0.99
    sine_wave
    scale <1,100,1>
    rotate <0,30,0>
  }            
  normal { 
    wrinkles 1 //gradient x 0.5 sine_wave
    turbulence .4
    scale <.9,100,.9>
    rotate <0,50,0>
  }
            
  finish { diffuse 0.4 specular 0.6 roughness 1/1500 reflection 0.2 }
}



#declare T_Water00 =
texture {
  pigment { 
    crackle
    colour_map {
      [ 0.0 rgbt <.4, .5, 0.8, .30> ]
      [ 1.0 rgbt <.2, .3, 0.7, .30> ]
    }
    turbulence 0.7
    omega 0.8
    scale 1.3
  }
  normal { 
    bumps
    bump_size 5
    scale <3,2,2>
  }
            
  finish { diffuse 0.5 specular 0.6 roughness 1/1500 reflection 0.2 }
}


#declare T_Bubbles =
texture {
  pigment { rgbt <.4, .5, 0.8, .20> }
  finish { diffuse 1 reflection .5 phong .5 }
}



#declare S_Clouds =
sky_sphere {
  pigment { rgb <0.158, 0.158, 1> }
  pigment {
    bozo
    turbulence 1.5
    octaves 10
    omega .5
    lambda 2.5
    color_map {
      [0.0, 0.5 color rgbf<.75, .75, .75, 0>
                color rgbf<.9, .9, 1, .9> ]
      [0.5, 0.7 color rgbf<.9, .9, 1, .9>
                color rgbf<1, 1, 1, 1> ]
      [0.7, 1.0 color rgbf<1, 1, 1, 1>
                color rgbf<1, 1, 1, 1> ]
    }
    scale <1, 0.2, 6>
  }
  pigment {
    bozo
    turbulence 0.6
    octaves 10
    omega .5
    lambda 2.5
    color_map {
      [0.0, 0.4 color rgbf<.75, .75, .75, 0>
                color rgbf<.9, .9, 1, .9> ]
      [0.4, 0.7 color rgbf<.9, .9, 1, .9>
                color rgbf<1, 1, 1, 1> ]
      [0.7, 1.0 color rgbf<1, 1, 1, 1>
                color rgbf<1, 1, 1, 1> ]
    }
    scale <1, 0.2, 6>
  }
  pigment {
    bozo
    turbulence 0.8
    octaves 10
    omega .5
    lambda 2.5
    color_map {
      [0.0, 0.4 color rgbf<.75, .75, .75, 0>
                color rgbf<.9, .9, 1, .9> ]
      [0.4, 0.6 color rgbf<.9, .9, 1, .9>
                color rgbf<1, 1, 1, 1> ]
      [0.6, 1.0 color rgbf<1, 1, 1, 1>
                color rgbf<1, 1, 1, 1> ]
    }
  scale <1, 0.2, 6>
  }
}
