// Rail Support macro
//
#macro Rail_Support (Height, Base, Top, Sections)

#local Thick1 = 0.02;
#local Thick2 = 0.01;
#local CableThick = .01;

union {
    // main supports
    cylinder { <-Base, 0,-Base>,<-Top, Height,-Top>, Thick1)
    cylinder { < Base, 0,-Base>,< Top, Height,-Top>, Thick1)
    cylinder { <-Base, 0, Base>,<-Top, Height, Top>, Thick1)
    cylinder { < Base, 0, Base>,< Top, Height, Top>, Thick1)
    
    // box around top
    cylinder { <-Top, Height,-Top>,< Top, Height,-Top>, Thick1)
    cylinder { < Top, Height,-Top>,< Top, Height, Top>, Thick1)
    cylinder { < Top, Height, Top>,<-Top, Height, Top>, Thick1)
    cylinder { <-Top, Height, Top>,<-Top, Height,-Top>, Thick1)

    // struts
    #local i = 1;

    #while (i <= Sections)

        #local h  = (Height     / Sections) * i;
        #local h0 = (Height     / Sections) * (i - 1);
        #local b  = (i - 0) * Top/Sections + Base/Sections * (Sections - i);
        #local b0 = (i - 1) * Top/Sections + Base/Sections * (Sections - i + 1);

        // horizontal boxes
        cylinder { <-b,h,-b>,<-b,h, b>, Thick2)
        cylinder { <-b,h, b>,< b,h, b>, Thick2)
        cylinder { < b,h, b>,< b,h,-b>, Thick2)
        cylinder { < b,h,-b>,<-b,h,-b>, Thick2)

        // diagonal struts
        cylinder { <-b, h, -b>,  <-b0,h0, b0>,  CableThick }
        cylinder { <-b, h,  b>,  < b0,h0, b0>,  CableThick }
        cylinder { < b, h,  b>,  < b0,h0,-b0>,  CableThick }
        cylinder { < b, h, -b>,  <-b0,h0,-b0>,  CableThick }
        #local i = i + 1;

    #end
}
#end // macro