 
glassware.inc   
B@ 8"
B D  PDX   
B@TEXTMPS   @         J="h                         // Persistence Of Vision INCLUDE file
// File:        glassware.inc
// Vers:        3.1g.r1 Mac PPC
// Desc:        Laboratory equipment etc
// Auth:        Peter Murray
// Date:        8 September 2000

#debug "\r  glassware.inc - Laboratory equipment etc\r"

/* Build a glass tank, like an aquarium tank
	 interior{} is defined for each part in case it's made of glass.
	plocn, protn: Usual location and rotation; origin at centre of base
	psize: external dimensions of tank.  Walls are 1/8 inch thick.
	ptexture: array[4] of textures:
		0 glass 1 base 2 lid 3 backdrop (default=0 if missing)
*/
#macro GlassTank(plocn,protn,psize,ptexture)
	union{
		#local Wide=psize.x/2;#local WideIn=Wide-0.125*in;
		#local Thick=psize.z/2;#local ThickIn=Thick-0.125*in;
		#local HighIn=psize.y-0.125*in;
		box{<-Wide,0,-Thick>,<Wide,0.125*in,Thick> interior{I_Glass} texture{ptexture[1]}}//base
		box{<-Wide,0.125*in,-Thick>,<Wide,HighIn,-ThickIn> interior{I_Glass} texture{ptexture[0]}}//front
		box{<-Wide,0.125*in,Thick>,<Wide,HighIn,ThickIn> interior{I_Glass} texture{ptexture[3]}}//backdrop
		box{<-Wide,0.125*in,ThickIn>,<-WideIn,HighIn,-ThickIn> interior{I_Glass} texture{ptexture[0]}}//left
		box{<Wide,0.125*in,ThickIn>,<WideIn,HighIn,-ThickIn> interior{I_Glass} texture{ptexture[0]}}//right
		box{<-Wide,HighIn,-Thick>,<Wide,psize.y,Thick> interior{I_Glass} texture{ptexture[2]}}//lid
		rotate protn
		translate plocn
	}
#end

/* Produce a liquid that fills a test tube.
	Union this with the test tube before translating or rotating it,
	and it'll fit.
	percent:  Percentage full.
	tilt:     0 means the top's flat... work it out.
*/
#macro TubeFill(percent,tilt)
	merge{
		cylinder{<0,0-(5.825*((100-percent)/105)),0>*in,<0,-5.825,0>*in,0.4*in}
		sphere{<0,-5.825,0>*in,0.4*in}
	}
#end

// Since it can't stand on anything, the origin is at the _top_ centre.
#declare TestTube=
merge{
	torus{0.425*in,0.125*in scale <1,0.5,1>}
	cylinder{<0,0,0>*in,<0,-5.825,0>*in,0.425*in hollow}
	difference{
		sphere{<0,-5.825,0>*in,0.425*in hollow}
		box{<-0.5,-5.825,-0.5>*in,<0.5,-5.3,0.5>*in}
	}
	interior{I_Glass}
	texture{T_Glass4}
}

#declare TubeRack=
union{
	box{<-4.5,0.25,-0.75>*in,<4.5,0.5,0.75>*in}
	difference{
		box{<-4.5,5.75,-0.625>*in,<4.5,6,0.625>*in}
		cylinder{<-3.75,5.6,0>*in,<-3.75,6.1,0>*in,0.5*in}
		cylinder{<-2.25,5.6,0>*in,<-2.25,6.1,0>*in,0.5*in}
		cylinder{<-0.75,5.6,0>*in,<-0.75,6.1,0>*in,0.5*in}
		cylinder{< 0.75,5.6,0>*in,< 0.75,6.1,0>*in,0.5*in}
		cylinder{< 2.25,5.6,0>*in,< 2.25,6.1,0>*in,0.5*in}
		cylinder{< 3.75,5.6,0>*in,< 3.75,6.1,0>*in,0.5*in}
	}	
	box{<-4.75,0,-0.75>*in,<-4.5,6.5,0.75>*in}
	box{<4.5,0,-0.75>*in,<4.75,6.5,0.75>*in}
	texture{pigment{Brown}}
}

#declare RoundBottle=
difference{
	merge{
		sphere{<0,0,0>*in,3*in}
		cylinder{<0,2.75,0>*in,<0,5.75,0>*in,0.425*in}
		torus{0.425*in,0.125*in scale <1,0.5,1> translate <0,5.75,0>*in}
	}
	merge{
		sphere{<0,0,0>*in,2.9*in}
		cylinder{<0,2.5,0>*in,<0,6,0>*in,0.325*in}
	}
	interior{I_Glass}
	texture{T_Glass4}
}

#macro RoundBottleFill(percent,tilt)
	difference{
		merge{
			sphere{<0,0,0>*in,2.89*in}
			cylinder{<0,2.5,0>*in,<0,5.5,0>*in,0.32*in}
		}
		box{<-4,6-0.09*(100-percent),-4>*in,<4,6,4>*in}
		interior{I_Glass}
		texture{T_Glass4}
	}
#end

#declare Bung=
cone{<0,-0.5,0>*in,0.3*in,<0,0.5,0>*in,0.35*in}

#declare Bung2=
difference{
	cone{<0,-0.5,0>*in,0.3*in,<0,0.5,0>*in,0.35*in}
	cylinder{<0,-0.6,0>*in,<0,0.6,0>*in,0.125*in}
}

#declare CapillaryTube=
cylinder{
	<0,-1,0>*in,<0,2,0>*in,0.125*in
	interior{I_Glass} texture{T_Glass4} hollow
}

// I can't remember what these are called
#declare BoilingTube=
merge{
	difference{
		cylinder{<-9,0,0>*in,<9,0,0>*in,0.5*in}
		cylinder{<-10,0,0>*in,<10,0,0>*in,0.45*in}
	}
	difference{
		merge{
			cylinder{<-4.5,-2.25,0>*in,<-4.5,-4,0>*in,0.425*in}
			sphere{<-4.5,0,0>*in,2.5*in}
			cylinder{<-4.5,0,0>*in,<4.5,0,0>*in,2.5*in}
			sphere{<4.5,0,0>*in,2.5*in}
			cylinder{<4.5,2.25,0>*in,<4.5,4,0>*in,0.425*in}
		}
		merge{
			cylinder{<-4.5,-2,0>*in,<-4.5,-5,0>*in,0.325*in}
			sphere{<-4.5,0,0>*in,2.4*in}
			cylinder{<-4.5,0,0>*in,<4.5,0,0>*in,2.4*in}
			sphere{<4.5,0,0>*in,2.4*in}
			cylinder{<4.5,2,0>*in,<4.5,5,0>*in,0.325*in}
			cylinder{<-9,0,0>*in,<9,0,0>*in,0.5*in}
		}
	}
	interior{I_Glass} texture{T_Glass4} hollow
}

#declare Beaker5=
difference{
	merge{
		cone{<0,0,0>*in,2*in,<0,0.5,0>*in,2.5*in}
		cylinder{<0,0.499,0>*in,<0,7.75,0>*in,2.5*in}
		cone{<0,7.5,0>*in,2.5*in,<0,8,0>*in,2.75*in}
		cone{<0,7.5,-2.5>*in,0*in,<0,8,-2.75>*in,0.5*in}
	}
	merge{
		cone{<0,0.1,0>*in,1.9*in,<0,0.5,0>*in,2.4*in}
		cylinder{<0,0.499,0>*in,<0,8,0>*in,2.4*in}
		cone{<0,7.5,0>*in,2.4*in,<0,8.1,0>*in,2.7*in}
		cone{<0,7.6,-2.5>*in,0*in,<0,8.1,-2.75>*in,0.45*in}
	}
	interior{I_Glass} texture{T_Glass4} hollow
}

#declare PlateMid=
lathe{
	linear_spline //quadratic_spline //cubic_spline
	16,
	<0,0.125>*in, <1.25,0.125>*in, <1.25,0>*in, <1.375,0>*in,
	<1.375,0.125>*in, <3,0.125>*in, <3,0>*in, <3.125,0>*in,
	<3.125,0.125>*in, <3.5,0.25>*in, <3.875,0.5>*in, <4.25,0.625>*in,
	<4.25,0.75>*in, <3.625,0.625>*in, <3.125,0.25>*in, <0,0.25>*in
	texture{WhitePt finish{specular 1 roughness 0.1}}
}

// Neither glassware nor ceramic, but anyway....
#declare HalfSandwich=
union{
	intersection{
		superellipsoid{
			<0.25,0.25> scale <2,1,2.5>
		}
		box{<0,-0.25,-3>*in,<2.5,0.25,3>*in}
	}
	box{<0,0.25,-2.55>*in,<2.05,0.35,2.55>*in texture{PinkPt}}
	intersection{
		superellipsoid{
			<0.25,0.25> scale <2,1,2.5>
		}
		box{<0,-0.25,-3>*in,<2.5,0.25,3>*in}
		translate <0,0.6,0>*in
	}
	texture{WhitePt}
	translate <0,0.25,0>*in
}

#debug "\r----\rend of glassware.inc\r----\r"
              n   n   >  QIcon
           @         
glassware.incEX) Apr 2000leesnd  TEXTMPS   J !                  J=         Q
lamppost.pict   PICTJVWR         $                                                  x                Q   H 	Monaco sswinc
// Vers:         < $9 < $9"h           < $9 < $9                 n   n   >z$RB    >  MPSR  
           L|&(                                                                                    