 madhouse.inc    
B@ 8"
B D  PDX   
B@TEXTMPS   @       {  J=%(                       ]  // Persistence Of Vision INCLUDE file
// File:        madhouse.inc
// Vers:        3.1g.r1 Mac PPC
// Desc:        Herbert Montelimar's house
// Auth:        Peter Murray
// Date:        10 September - 8 October 2000

#debug "\r  madhouse.inc - Herbert Montelimar's house\r"

#declare Brickstuff=
texture{
	brick
	texture{pigment{colour rgb <1.0,1.0,1.0>}},
	texture{
		pigment{
			granite turbulence 0.8 octaves 4 scale 3
			colour_map{
				[0.00 colour rgb <0.9,0.7,0.3>]
				[0.75 colour rgb <0.9,0.7,0.3>]
				[0.76 colour rgb <0.6,0.6,0.1>]
				[1.00 colour rgb <0.5,0.5,0.1>]
			}
			rotate <45,-30,60>
		}
		normal{
			brick normal{bumps -0.2*in}, normal{granite 0.3}
			brick_size <8,3,4.5>*in mortar 0.5*in
		}
	}
	brick_size <8,3,4.5>*in mortar 0.5*in
}

#declare StoneFloor=
texture{
	brick
	texture{pigment{colour rgb <0.2,0.2,0.2>}},
	texture{
		pigment{
			granite turbulence 0.8 octaves 4 scale 3
			colour_map{
				[0.00 colour rgb <0.9,0.8,0.5>]
				[0.75 colour rgb <0.9,0.8,0.5>]
				[0.76 colour rgb <0.6,0.6,0.1>]
				[1.00 colour rgb <0.5,0.5,0.1>]
			}
			rotate <45,-30,60>
		}
		normal{
			brick normal{bumps -0.2*in}, normal{granite 0.3}
			brick_size <9,5,9>*in mortar 0.1*in
		}
	}
	brick_size <9,5,9>*in mortar 0.1*in
}

#declare Paper=
texture{
	pigment{colour rgb <1.0,1.0,0.9>}
}

#declare MyGlass=
#if (GoodGlass=1)
	texture{T_Glass4}
#else
	texture{pigment{Gray20}}
#end

// 1 8 13 21 23 24-furniture 25 28-old furniture
#declare Floorboard=
texture{
	pigment{
		P_WoodGrain1A  colour_map{M_Wood1A} //rotate y*0.25
		warp{repeat <9,0,0>*in offset <0,0.25,0>*in flip <0,0,1>}
	}
	rotate y*90
}
texture{pigment{P_WoodGrain1B  colour_map{M_Wood1B}}}

#declare TableWood=
texture{pigment{P_WoodGrain1A  colour_map{M_Wood14A}}}
texture{pigment{P_WoodGrain1B  colour_map{M_Wood14B}}}


#declare CeilingPt=
texture{
	pigment{colour rgb <1.0,1.0,0.9>}
	normal{wrinkles turbulence 0.4 octaves 3 scale <8,0.25,8>}
	finish{ambient .5 brilliance .1 diffuse .1}
}

#declare Lab2Pt=
texture{
	pigment{colour rgb <0.9,1.0,0.6>}
	normal{wrinkles turbulence 0.8 octaves 4 scale 3}
	finish{ambient .3 brilliance .3 diffuse .3 specular .2 roughness .3 reflection .2}
}
texture{
  pigment{
    spotted turbulence 0.8 octaves 4 scale 5
    colour_map{
      [0.00 colour rgbt <0.74, 0.74, 0.31, 0.25>]
      [0.20 colour rgbt <0.74, 0.74, 0.31, 0.25>]
      [0.21 colour rgbt <0.62, 0.62, 0.26, 0.80>]
      [1.00 colour rgbt <1.00, 1.00, 1.00, 1.00>]
    }
  }
}

#declare Lounge1Pt=
texture{pigment{colour rgb <1.0,0.8,0.7>}}

#declare Lounge2Pt=Lounge1Pt

#declare Dining1Pt=
texture{pigment{colour rgb <0.8,1.0,0.7>}}

#declare Hall1Pt=
texture{pigment{colour rgb <1.0,1.0,0.8>}}

#declare Hall2Pt=Hall1Pt

#declare Cloaks1Pt=
texture{pigment{colour rgb <1.0,1.0,0.8>}}

#declare Cloaks2Pt=Cloaks1Pt

#declare Kitchen1Pt=
texture{pigment{colour rgb <1.0,1.0,1.0>}}

#declare Kitchen2Pt=Kitchen1Pt

#declare Garage1Pt=
texture{Brickstuff}

#declare Garage2Pt=Garage1Pt

#declare BedA1Pt=
texture{pigment{colour rgb <0.7,1.0,0.7>}}

#declare BedA2Pt=BedA1Pt

#declare BedB1Pt=
texture{pigment{colour rgb <0.7,0.7,1.0>}}

#declare BedB2Pt=BedB1Pt

#declare BedC1Pt=
texture{pigment{colour rgb <1.0,0.9,0.9>}}

#declare BedC2Pt=BedC1Pt

#declare BedD1Pt=
texture{pigment{colour rgb <1.0,1.0,0.7>}}

#declare BedD2Pt=BedD1Pt
//================================================================================
#declare FluoFitting=
union{
  cylinder{//tube
    <-1.5*ft,0,0>,<1.5*ft,0,0>,1*in
    texture{
      pigment{colour rgb <.8,.8,.8>}
      finish{ambient 1.5}
    }
  }
  cylinder{//end fittings
    <-1.5*ft,0,0>,<-1.75*ft,0,0>,1.2*in
  }
  box{
    <-1.5*ft,0,-1.2*in>,<-1.75*ft,1.2*in,1.2*in>
  }
  cylinder{
    <1.5*ft,0,0>,<1.75*ft,0,0>,1.2*in
  }
  box{
    <1.5*ft,0,-1.2*in>,<1.75*ft,1.2*in,1.2*in>
  }
  box{
    <-1.75*ft,1.2*in,-1.2*in>,<1.75*ft,2*in,1.2*in>
  }
  texture{
    pigment{colour rgb <.7,.73,.7>}
  }
}

#declare FluoLight=
light_source{
  <0,8*ft,0> colour rgb <.75,.8,.75>*3 looks_like{FluoFitting}
}

// Laboratory fittings and equipment are collected together in this macro to make
// it easier to "change the use" of that room.
// box{<147,0,-276>*in,<3,96,-156>*in}
// box{<273,0,-276>*in,<153,96,-156>*in}
// object{Archspace30 scale <2,1,1> rotate y*90 translate <150,0,-211>*in}//halfway
// object{Archspace30 scale <2,1,1> rotate y*90 translate <276,0,-211>*in}//workshop
// object{Doorspace30 translate <171,0,-153>*in}//-hall
// object{Windowspace10 scale <3,1,1> translate <30,0,-279>*in}
// object{Windowspace10 scale <3,1,1> translate <60,0,-279>*in}
// object{Windowspace10 scale <3,1,1> translate <90,0,-279>*in}
// object{Windowspace10 scale <3,1,1> translate <120,0,-279>*in}
// object{Windowspace10 scale <3,1,1> translate <233,0,-279>*in}
// object{Windowspace10 scale <3,1,1> translate <197,0,-279>
#macro LabFittings()
union{
	//Skirting board
	union{
		box{<3,-0.1,-276>*in,<147,2.5,-275.75>*in}
		box{<3,-0.1,-156>*in,<3.25,2.5,-276>*in}
		box{<3,-0.1,-156>*in,<147,2.5,-156.25>*in}
		box{<147,-0.1,-156>*in,<146.75,2.5,-181.25>*in}
		box{<146.75,-0.1,-181>*in,<153.25,2.5,-181.25>*in}
		box{<146.75,-0.1,-240.75>*in,<153.25,2.5,-241>*in}
		box{<147,-0.1,-240.75>*in,<146.75,2.5,-276>*in}
		box{<153,-0.1,-276>*in,<273,2.5,-275.75>*in}
		box{<153,-0.1,-156>*in,<153.25,2.5,-181.25>*in}
		box{<153,-0.1,-240.75>*in,<153.25,2.5,-276>*in}
		box{<153,-0.1,-156>*in,<273,2.5,-156.25>*in}
		box{<273,-0.1,-156>*in,<272.75,2.5,-181.25>*in}
		box{<273,-0.1,-240.75>*in,<272.75,2.5,-276>*in}
		box{<272.75,-0.1,-181>*in,<279.25,2.5,-181.25>*in}
		box{<272.75,-0.1,-240.75>*in,<279.25,2.5,-241>*in}
		texture{WhitePt}
	}
	//Sockets
	object{PowerSocket rotate y*180 translate <30,25,-276>*in}
	object{Conduit12 rotate <0,0,90> scale <1,2,1> translate <30,14.5,-275>*in}
	object{PowerSocket rotate y*180 translate <60,25,-276>*in}
	object{Conduit12 rotate <0,0,90> scale <1,2,1> translate <60,14.5,-275>*in}
	object{PowerSocket rotate y*180 translate <90,25,-276>*in}
	object{Conduit12 rotate <0,0,90> scale <1,2,1> translate <90,14.5,-275>*in}
	object{PowerSocket rotate y*180 translate <233,25,-276>*in}
	object{Conduit12 rotate <0,0,90> scale <1,2,1> translate <233,14.5,-275>*in}
	object{PowerSocket rotate y*180 translate <197,25,-276>*in}
	object{Conduit12 rotate <0,0,90> scale <1,2,1> translate <197,14.5,-275>*in}
	object{TelecomSocket rotate y*180 translate <40,25.25,-276>*in}
	object{Conduit12 rotate <0,0,90> scale <1,2,1> translate <40,14.5,-275>*in}
	//Stool
	object{Stool rotate <0,15,0> translate <60,0,-226>*in}
	//Lights
	object{FluoLight translate <75,0,216>*in}
	object{FluoLight translate <213,0,216>*in}
	//Workbench 23.5-24 inches + Sink
	union{
		difference{
			box{<3,23.5,-246>*in,<147,24,-276>*in texture{TableWood rotate <10,30,0>}}
			box{<114,-23,-265>*in,<126,24.5,-275>*in}
		}
		object{SinkUnit rotate y*180 translate <120,24.5,-275>*in}
	}
	box{<153,23.5,-246>*in,<273,24,-276>*in texture{TableWood rotate <30,15,-5>}}
	//Bookshelves
	object{Unit5a rotate <0,-90,0> translate <13.25,0,-178.25>*in}
	object{Unit6a rotate <0,-90,0> translate <13.25,0,-211.25>*in}
	object{Unit4a rotate <0,-90,0> translate <13.25,0,-233.25>*in}
	//
	object{Unit1 translate <124.75,0,-167.25>*in}
	object{Unit2 translate <102.75,0,-167.25>*in}
	object{Unit3 rotate <0,90,0> translate <92.75,0,-157.25>*in}
	//
	object{Unit4 translate <250.75,0,-167.25>*in}
	object{Unit6 translate <217.75,0,-167.25>*in}
	object{Unit5 translate <195.75,0,-167.25>*in}
	//Herbert
	#include "Herbert.cst"
	object{
		RTDH3(<66,-12,-226>*in,<0,180,0>,
			array[7]{<1.1,1.1,1.25>,<1.4,1.43,1.1>,<1.6,1.3,1.6>,<1.6,1.3,1.6>,
				<1.1,0.62,1.15>,<1.25,1.067,1.0>,<1.25,1.067,1.0>},
			array[13]{<0,-15,0>,<-10,0,-5>,<0,0,0>,<-15,0,10>,<40,10,0>,
				<40,0,0>,<-40,0,0>,<90,0,0>,<-15,0,0>,<0,0,0>,<-5,0,0>,
				<0,0,0>,<-25,0,0>},
			array[1]{0},<0,0,0>,<0,-10,0>,<0,0,0>,<-5,0.45,0.4>,<0,0,0>)
	}
	//Efgor
	#include "Efgor.cst"
	object{
		RTDH3(<120,0,-216>*in,<0,90,0>,
			array[7]{<1.4,1.1,1.3>,<1.7,1.58,2>,<1.6,1.6,1.6>,<1.6,1.6,1.6>,
				<1.4,0.8,1.5>,<1.3,1.175,1.09>,<1.3,1.175,1.09>},
			array[13]{<0,-20,0>,<0,0,-10>,<0,0,0>,<-30,0,10>,<30,10,0>,
				<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>,
				<0,0,0>,<0,0,0>,<0,0,0>,<0,0,0>},
			array[1]{0},<0,0,0>,<0,0,0>,<0,0,0>,<-5,0.2,0.4>,<0,0,0>)
	}
	//workbench clutter
	Page(<60+-3,24.05,2-270>*in,<270,50,0>,<8.25,11,0.05>*in,"todo.pict")
	union{
		object{RoundBottle}
		object{RoundBottleFill(60,<0,0,0>) texture{CyanPt}}
		object{Bung translate <0,5.75,0>*in interior{I_Glass} texture{T_Glass4}}
		translate <60+24,33.5,26-270>*in
	}
	object{Beaker5 rotate y*100 translate <60+24,0,26-270>*in}
	union{
		object{RoundBottle}
		object{
			RoundBottleFill(25,<0,0,0>)
			rotate <0,0,-45> rotate <0,-45,0>
			texture{BrownPt}
		}
		object{Bung2 translate <0,5.75,0>*in texture{PinkPt}}
		object{CapillaryTube translate <0,5.75,0>*in}
		rotate <0,45,45> translate <60+-4,27,10-270>*in
	}
	union{
		object{TubeRack translate <0,0,0>*in}
		union{
			object{TestTube}
			object{TubeFill(20,0) texture{pigment{colour rgbf <0.8,0.4,0.5,0.9>}}}
			rotate x*-2 translate <-3.75,6.75,-270>*in
		}
		union{
			object{TestTube}
			object{TubeFill(60,0) texture{pigment{colour rgb <0.55,0.5,0.3>}}}
			rotate z*3 translate <-0.75,6.75,0>*in
		}
		object{TestTube translate <0.75,6.75,0>*in}
		object{TestTube rotate x*3 translate <2.25,6.75,0>*in}
		union{
			object{TestTube}
			object{TubeFill(70,0) texture{pigment{colour rgbt <0.4,0.5,0.8,0.6>}}}
			rotate z*-2 translate < 3.75,6.75,0>*in
		}
		translate <72,24,260>*in
	}
	object{BoilingTube rotate x*60 rotate y*-15 translate <68,26.5,6-270>*in}
	object{PlateMid translate <60-4,24,2-270>*in}
	object{HalfSandwich rotate y*30 translate <60-5,24.25,2.2-270>*in}
	object{Book(0,<0,0,0>,<7.5,9.5,2>,"mads1.pict") rotate y*40 translate <100+2.25,24,2-260>*in}
	object{Book(0,<0,0,0>,<7.5,9.5,2>,"mads2.pict") rotate y*-40 translate <100+-2,24,2.5-260>*in}
	object{Book(0,<0,0,0>,<7.5,9.5,2>,"mads3.pict") rotate y*-60 translate <100+-7,24,3-260>*in}
	GlassTank(<20,24,-266>*in,<0,0,0>,<8,4,4>*in,
		array[4]{MyGlass,BlackPt,GreenPt,CyanPt}
	)
	Wiwaxia(<20,24.125,-267>*in,<0,0,0>)
	Wiwaxia(<18,24.125,-266>*in,<0,-90,0>)
	Wiwaxia(<22,24.125,-266>*in,<0,45,0>)
	GlassTank(<180,24,-266>*in,<0,0,0>,<8,4,4>*in,
		array[4]{MyGlass,BlackPt,GreenPt,CyanPt}
	)
	//Anomalocaris(plocn,protn,pose)
	GlassTank(<190,24,-266>*in,<0,0,0>,<8,4,4>*in,
		array[4]{MyGlass,BlackPt,GreenPt,CyanPt}
	)
	//Dinomischus(plocn,protn)
	GlassTank(<200,24,-266>*in,<0,0,0>,<8,4,4>*in,
		array[4]{MyGlass,BlackPt,GreenPt,CyanPt}
	)
	//Nectocaris(plocn,protn,pose)
	union{
		object{HumanBrain(<6,9,7>*in,HBrain) translate <0,7,0>*in}
		object{Beaker5 scale <2,2,2>}
		cylinder{<0,0.1,0>*in,<0,10,0>*in,4.8*in
			texture{pigment{colour rgbt <0.8,0.8,0.5,0.9>}}
		}
		translate <60,24,-252>*in
	}
	object{HumanSkull(<6,9,7>*in,HBone) rotate y*225 translate <42,30,-264>*in}
	HeadSculpture(<140,24,-260>*in,<0,90,0>)
}
#end

//================================================================================

#declare RoomHt=96;
#declare FloorSep=RoomHt+8;
#declare DoorHt=84;#declare DoorSill=0.1;
#declare WindowHt=84;#declare WindowSill=28;

#declare Doorspace30=
box{<-15,DoorSill,-4>*in,<15,DoorHt,4>*in}

#declare Windowspace10=
box{<-5,WindowSill,-4>*in,<5,WindowHt,4>*in}

#declare Archspace30=
union{
	box{<-15,0,-4>*in,<15,RoomHt-24,4>*in}
	cylinder{<0,RoomHt-24,-4>*in,<0,RoomHt-24,4>*in,15*in}
}

#declare ArchWspace30=
union{
	box{<-15,WindowSill,-4>*in,<15,RoomHt-24,4>*in}
	cylinder{<0,RoomHt-24,-4>*in,<0,RoomHt-24,4>*in,15*in}
}

#declare DoorFrame30=
union{
	box{<-17,DoorHt,-3.5>*in,<17,DoorHt+2,3.5>*in}
	box{<-17,DoorSill,-3.5>*in,<-14.99,DoorHt,3.5>*in}
	box{<17,DoorSill,-3.5>*in,<14.99,DoorHt,3.5>*in}
	texture{pigment{White}}
}

#macro WindowFrame(plocn,protn,psize)
	union{
		#local XX=psize.x/2;
		box{<-XX-2,WindowHt-0.01,-3.5>*in,<XX+2,WindowHt+2,3.5>*in}
		box{<-XX-2,WindowSill-2,-3.5>*in,<XX+2,WindowSill+0.01,3.5>*in}
		box{<-XX-2,WindowSill,-3.5>*in,<-XX+0.01,WindowHt,3.5>*in}
		box{<XX+2,WindowSill,-3.5>*in,<XX-0.01,WindowHt,3.5>*in}
		texture{pigment{White}}
		rotate protn
		translate plocn
	}
#end

/* Parameters when making a door for a DoorFrame30
	plocn: Same as the DoorFrame30 position - centred at base
	protn: Same rotation as the DoorFrame30
	psize: Door width,height,thickness
	pstyle:Style of door:
		0 none, 1 basic, 2 pre-60s interior
	pdirn: direction: 0/1 left/right hinges
	popen: how many degrees open the door is
	ptexture: array[?] of textures - not all needed by all styles:
		0 door basic, 1 "outside" face, 2 "inside" face, 3 handle,
		4 contrast, 5 glass, 6 letterslot, 7 hinges
*/
#macro MakeDoor(plocn,protn,psize,pstyle,pdirn,popen,ptexture)
	union{
		#write(DebugFile,"\nMakeDoor(plocn=",plocn,",protn=",protn,",psize=",psize,",pstyle=",pstyle,",pdirn=",pdirn,",popen=",popen,",ptexture)\n")
		#write(DebugFile,"  pdirn=",pdirn,"\n")
		#local popen=abs(popen);
		#local XX=psize.x/2;
		#write(DebugFile,"  popen=",popen,"\n")
		#if ((pdirn=2)|(pdirn=3))
			#local YRot=1;
		#else
			#local YRot=-1;
		#end
		#write(DebugFile,"  YRot=",YRot,"\n")
		#local ZOff=-YRot*(7*in-psize.z)/2;
		#write(DebugFile,"  ZOff=",ZOff,"\n")
		#switch (pdirn)
			#case (0)
				#write(DebugFile,"  Direction 0 selected.\n")
			#break
			#case (1)
				#write(DebugFile,"  Direction 1 selected.\n")
			#break
			#case (2)
				#write(DebugFile,"  Direction 2 selected.\n")
			#break
			#case (3)
				#write(DebugFile,"  Direction 3 selected.\n")
			#break
		#end
		#if (pstyle>0)
			difference{
				union{//basic door for all styles bar 0
					box{<0,0,0>*in,psize*<1,1,0>+<0,0,0.1>*in texture{ptexture[1]}}
					box{<0,0,0.1>*in,psize+<0,0,-0.1>*in texture{ptexture[0]}}
					box{<0,0,psize.z>,psize+<0,0,-0.1>*in texture{ptexture[2]}}
					//doorhandle - 37.25 to 39.5 high, 1 to 3 in.
					cylinder{<psize.x-2*in,38.5*in,-4*in>,<psize.x-2*in,38.5*in,4*in>,1*in texture{ptexture[3]}}
				}
				#switch (pstyle)
					#case (0)
						#write(DebugFile,"  Style 0 selected.\n")
					#break
					#case (1)//60s cliche door
						#write(DebugFile,"  Style 1 selected.\n")
					#break
					#case (2)//pre-60s cliche door
						#write(DebugFile,"  Style 2 selected.\n")
						box{<6,6,-0.1>*in,<XX-3*in,35.5*in,0.25*in> texture{ptexture[4]}}
						box{<psize.x-6*in,6*in,-0.1*in>,<XX+3*in,35.5*in,0.25*in> texture{ptexture[4]}}
						box{<6*in,6*in,psize.z+0.1*in>,<XX-3*in,35.5*in,psize.z-0.25*in> texture{ptexture[4]}}
						box{<psize.x-6*in,6*in,psize.z+0.1*in>,<XX+3*in,35.5*in,psize.z-0.25*in> texture{ptexture[4]}}
						//
						#local YY=41.5*in+(psize.y-41.5*in)/2;
						box{<6,41.5,-0.1>*in,<XX-3*in,YY-3*in,0.25*in> texture{ptexture[4]}}
						box{<psize.x-6*in,41.5*in,-0.1*in>,<XX+3*in,YY-3*in,0.25*in> texture{ptexture[4]}}
						box{<6*in,41.5*in,psize.z+0.1*in>,<XX-3*in,YY-3*in,psize.z-0.25*in> texture{ptexture[4]}}
						box{<psize.x-6*in,41.5*in,psize.z+0.1*in>,<XX+3*in,YY-3*in,psize.z-0.25*in> texture{ptexture[4]}}
						//
						box{<6*in,YY+3*in,-0.1*in>,<XX-3*in,psize.y-6*in,0.25*in> texture{ptexture[4]}}
						box{<psize.x-6*in,YY+3*in,-0.1*in>,<XX+3*in,psize.y-6*in,0.25*in> texture{ptexture[4]}}
						box{<6*in,YY+3*in,psize.z+0.1*in>,<XX-3*in,psize.y-6*in,psize.z-0.25*in> texture{ptexture[4]}}
						box{<psize.x-6*in,YY+3*in,psize.z+0.1*in>,<XX+3*in,psize.y-6*in,psize.z-0.25*in> texture{ptexture[4]}}
					#break
					#case (3)
						#write(DebugFile,"  Style 3 selected.\n")
					#break
					#case (4)
						#write(DebugFile,"  Style 4 selected.\n")
					#break
					#case (5)
						#write(DebugFile,"  Style 5 selected.\n")
					#break
					#case (6)
						#write(DebugFile,"  Style 6 selected.\n")
					#break
				#end
			}
		#end
		//hinges
		union{
			cylinder{<0,9,0>*in,<0,12,0>*in,0.125*in texture{ptexture[7]}}
			cylinder{<0,psize.y-9*in,0>,<0,psize.y-6*in,0>,0.125*in texture{ptexture[7]}}
			translate <0,0,-YRot*psize.z/2>
		}
		//#translate YRot*psize.z/2
		//#translate -YRot*psize.z/2
		rotate y*popen //*YRot
		#write(DebugFile,"  rotate ",y*popen*YRot,"\n")
		#if ((pdirn=1)|(pdirn=3))
			#local XOff=0.5;
			scale <-1,1,1>
		#else
			#local XOff=-0.5;
		#end
		translate <XOff,0,0>*psize+<0,0,ZOff>
		rotate protn
		translate plocn
		#write(DebugFile,"  0=",0," 1=",1," 2=",2," 3=",3," 4=",4," 5=",5,"\n")
		#write(DebugFile,"  0=",0+0," 1=",0+1," 2=",0+2," 3=",0+3," 4=",0+4," 5=",0+5,"\n")
	}
#end

/* Parameters when making a window for a WindowFrame or WindowSpace10
	- note that -Z values are toward the outside of the window.
	plocn: Same as the WindowFrame position - centred at base
	protn: Same rotation as the WindowFrame30 (or 180 degrees offset)
	psize: Window width,height,thickness
	pstyle:Style of window:
		0 none, 1 sash
	pvalue: Integer array depending on pstyle:
		sash: 0 top open 1 bottom open
		"open" values mean a range from 0 closed to 1 open.
	ptexture: array[?] of textures - not all needed by all styles:
		0 basic glass
		sash: 1 upper frame, 2 lower frame
*/
#macro MakeWindow(plocn,protn,psize,pstyle,pvalue,ptexture)
	union{
		#switch (pstyle)
			#case (1)//Sash windows
				#local Thick=psize.z/2;#local High=psize.y/2;#local Wide=psize.x/2;
				#local GThick=psize.z/4;
				union{//upper section
					box{<-Wide,psize.y-2*in,-Thick>,<Wide,psize.y,-0.01*in>}
					box{<-Wide,High+1*in,-Thick>,<-Wide+2*in,psize.y-2*in,-0.01*in>}
					box{<Wide,High+1*in,-Thick>,<Wide-2*in,psize.y-2*in,-0.01*in>}
					box{<-Wide,High-1*in,-Thick>,<Wide,High+1*in,-0.01*in>}
					//
					box{
						<-Wide+1*in,High+1*in,-GThick/2>,<Wide-1*in,psize.y-1*in,-GThick*3/2>
						interior{ I_Glass} texture{ptexture[0]}
					}
					//glazing bars
					#local Temp=psize.y*3/4;
					box{<-Wide,Temp-0.5*in,-Thick*7/8>,<Wide,Temp+0.5*in,-Thick/8>}
					#local Temp2=psize.x/6;
					box{<-Temp2-0.5*in,High+1*in,-Thick*7/8>,<-Temp2+0.5*in,psize.y-2*in,-Thick/8>}
					box{<Temp2-0.5*in,High+1*in,-Thick*7/8>,<Temp2+0.5*in,psize.y-2*in,-Thick/8>}
					texture{ptexture[1]}
					translate -y*High*pvalue[0]
				}
				union{//lower section
					box{<-Wide,High+1*in,Thick>,<Wide,High-1*in,0.01*in>}
					box{<-Wide,2*in,Thick>,<-Wide+2*in,High-1*in,0.01*in>}
					box{<Wide,2*in,Thick>,<Wide-2*in,High-1*in,0.01*in>}
					box{<-Wide,0,Thick>,<Wide,2*in,0.01*in>}
					//
					box{
						<-Wide+1*in,1*in,GThick/2>,<Wide-1*in,High,GThick*3/2>
						interior{ I_Glass} texture{ptexture[0]}
					}
					//glazing bars
					#local Temp=psize.y*1/4;
					box{<-Wide,Temp-0.5*in,Thick*7/8>,<Wide,Temp+0.5*in,Thick/8>}
					box{<-Temp2-0.5*in,2*in,Thick*7/8>,<-Temp2+0.5*in,High-1*in,Thick/8>}
					box{<Temp2-0.5*in,2*in,Thick*7/8>,<Temp2+0.5*in,High-1*in,Thick/8>}
					texture{ptexture[2]}
					translate y*High*pvalue[1]
				}
			#break
		#end
		rotate protn
		translate plocn+<0,WindowSill,0>*in
	}
#end

#declare TestWallD=
union{
	//Wall with gaps in
	#declare HouseHt=92;
	difference{
		box{<-108,-3,-3>*in,<108,HouseHt,3>*in}
		//object{Windowspace10 scale <3,1,1> translate <-72,0,0>*in}
		object{Doorspace30 translate <-72,0,0>*in}
		object{Doorspace30 translate <-24,0,0>*in}
		object{Doorspace30 translate <24,0,0>*in}
		object{Doorspace30 translate <72,0,0>*in}
	}
	//WindowFrame(<-72,0,0>*in,0,<30,0,0>)
	object{DoorFrame30 translate <-72,0,0>*in}
	MakeDoor(<-72,0,0>*in,0,<30,DoorHt-DoorSill,1.5>*in,2,0,30,
		array[8]{WhitePt,WhitePt,WhitePt,T_Brass_3D,
			GreenPt,T_Glass4,T_Brass_3D,WhitePt
		}
	)
	object{DoorFrame30 translate <-24,0,0>*in}
	MakeDoor(<-24,0,0>*in,0,<30,DoorHt-DoorSill,1.5>*in,2,1,30,
		array[8]{WhitePt,WhitePt,WhitePt,T_Brass_3D,
			GreenPt,T_Glass4,T_Brass_3D,WhitePt
		}
	)
	object{DoorFrame30 translate <24,0,0>*in}
	MakeDoor(<24,0,0>*in,<0,180,0>,<30,DoorHt-DoorSill,1.5>*in,2,0,30,
		array[8]{WhitePt,WhitePt,WhitePt,T_Brass_3D,
			GreenPt,T_Glass4,T_Brass_3D,WhitePt
		}
	)
	object{DoorFrame30 translate <72,0,0>*in}
	MakeDoor(<72,0,0>*in,<0,180,0>,<30,DoorHt-DoorSill,1.5>*in,2,1,30,
		array[8]{WhitePt,WhitePt,WhitePt,T_Brass_3D,
			GreenPt,T_Glass4,T_Brass_3D,WhitePt
		}
	)
	texture{Brickstuff}
}

#declare TestWallW=
union{
	//Wall with gaps in
	#declare HouseHt=92;
	difference{
		box{<-108,-3,-3>*in,<108,HouseHt,3>*in}
		object{Windowspace10 scale <3,1,1> translate <-72,0,0>*in}
		object{Windowspace10 scale <7.2,1,1> translate <  0,0,0>*in}
		object{Windowspace10 scale <3,1,1> translate < 72,0,0>*in}
	}
	WindowFrame(<-72,0,0>*in,0,<30,0,0>*in)
	MakeWindow (<-72,0,0>*in,0,<30,WindowHt-WindowSill,4>*in,1,array[2]{0.25,0},
		array[3]{MyGlass,WhitePt,WhitePt}
	)
	WindowFrame(<-19,0,0>*in,0,<34,0,0>*in)
	MakeWindow (<-19,0,0>*in,0,<34,WindowHt-WindowSill,4>*in,1,array[2]{0,0},
		array[3]{MyGlass,WhitePt,WhitePt}
	)
	WindowFrame(< 19,0,0>*in,0,<34,0,0>*in)
	MakeWindow (< 19,0,0>*in,0,<34,WindowHt-WindowSill,4>*in,1,array[2]{0,0},
		array[3]{MyGlass,WhitePt,WhitePt}
	)
	WindowFrame(< 72,0,0>*in,0,<30,0,0>*in)
	MakeWindow (< 72,0,0>*in,0,<30,WindowHt-WindowSill,4>*in,1,array[2]{0,0.25},
		array[3]{MyGlass,WhitePt,WhitePt}
	)
	texture{Brickstuff}
}

#declare TextureTest=
union{
	//Textured stripes of wall
	box{<-108,0,-3>*in,<108,32,3>*in texture{Brickstuff}}
	box{<-108,32,-3>*in,<108,64,3>*in texture{Floorboard rotate x*-90}}
	box{<-108,64,-3>*in,<108,96,3>*in texture{Lab2Pt}}
	box{<-108,96,-3>*in,<108,128,3>*in texture{CeilingPt rotate x*90}}
}


#declare InteriorDoorTextures=array[8]{
	WhitePt,WhitePt,WhitePt,T_Brass_3D,
	WhitePt,T_Glass4,T_Brass_3D,WhitePt
}

#declare InteriorDoorSize=<30,DoorHt-DoorSill,1.5>*in;

/*
	This building is a semi-detached house, knocked through into one.
	The origin is at the join of the houses, on their front wall.
	Parameters:
	nfloors: for cut-away plans of the house.  0-2
*/
#macro Madhouse(nfloors)
union{
	//Main block
	#switch (nfloors)
		#case (0) #declare HouseHt=92; #break
		#case (1) #declare HouseHt=FloorSep+92; #break
		#case (2) #declare HouseHt=2.5*FloorSep+92; #break
	#end
	#write(DebugFile,"HouseHt =",HouseHt,"\n")
	difference{
		union{
			#if (nfloors>=0)
				#if (nfloors=0)
					#local Temp=HouseHt;
				#else
					#local Temp=FloorSep;
				#end
				box{<-429,-3,-282>*in,<429,Temp,0>*in}//Ground floor
				cylinder{<354,-3,-282>*in,<354,Temp,-282>*in,75*in}//tower
				box{<-429,-3,-282>*in,<-423,Temp,-357>*in}//patio walls
				box{<-429,-3,-351>*in,<354,Temp,-357>*in}
				box{<-429,-3,-282>*in,<354,0,-357>*in texture{StoneFloor}}
				box{<-429,-3,-1>*in,<-423,FloorSep,60>*in}//walls of colonnade
				box{<-279,-3,-1>*in,<-273,FloorSep,60>*in}
				box{<279,-3,-1>*in,<273,FloorSep,60>*in}
				box{<429,-3,-1>*in,<423,FloorSep,60>*in}
				//garden walls
				box{<-477,-3,-722>*in,<-483,36,192>*in}//side
				box{<477,-3,-722>*in,<483,36,192>*in}//side
				box{<-411,-3,0>*in,<-291,0,192>*in}//- driveway
				box{<-411,-3,192>*in,<-291,0,240>*in}
				box{<-204,-3,0>*in,<-174,0,192>*in}//- path
				box{<-291,-3,12>*in,<291,0,42>*in}//front path
				box{<204,-3,0>*in,<174,0,192>*in}//+ path
				box{<411,-3,0>*in,<291,0,192>*in}//+ driveway
				box{<411,-3,192>*in,<291,0,240>*in}
				box{<-483,-3,186>*in,<483,36,192>*in}//front wall
				box{<-483,-3,-722>*in,<483,36,-716>*in}//back wall
				//colonnade 4-52 60-108 116-164
				box{<-279,-3,54>*in,<279,FloorSep,60>*in}//outer wall
				box{<-280,-3,53>*in,<-272,FloorSep,61>*in}//series of pillars
				box{<-212,-3,53>*in,<-204,FloorSep,61>*in}
				box{<-174,-3,53>*in,<-162,FloorSep,61>*in}
				box{<-4,-3,53>*in,<4,FloorSep,61>*in}
				box{<174,-3,53>*in,<162,FloorSep,61>*in}
				box{<212,-3,53>*in,<204,FloorSep,61>*in}
				box{<280,-3,53>*in,<272,FloorSep,61>*in}
			#end
			#if (nfloors>0)
				box{<-279,FloorSep,-282>*in,<279,HouseHt,0>*in}//upstairs and loft
				cylinder{<354,FloorSep,-282>*in,<354,FloorSep+92,-282>*in,75*in}//tower
				box{<278,RoomHt,-282>*in,<354,FloorSep+92,-207>*in}
				box{<-429,RoomHt,-282>*in,<354,FloorSep,-357>*in}//top of patio
				box{<-429,RoomHt,-1>*in,<429,FloorSep,60>*in}//top of colonnade
			#end
			#if (nfloors>1)
				cylinder{<354,FloorSep+92,-282>*in,<354,2*FloorSep,-282>*in,75*in}//tower
				box{<278,FloorSep+92,-282>*in,<354,2*FloorSep,-207>*in}
			#end
		}
		//Cut the roof line if nfloors is high enough
		#if (nfloors>1)
			box{<-120,0,12>*in,<0,2*FloorSep,-290>*in rotate z*-45 translate <-279,2*FloorSep,0>*in texture{RedPt}}
			box{<120,0,12>*in,<0,2*FloorSep,-290>*in rotate z*45 translate <279,2*FloorSep,0>*in texture{RedPt}}
			box{<-280,0,0>*in,<280,2*FloorSep,120>*in rotate x*-45 translate <0,2*FloorSep,0>*in texture{RedPt}}
			box{<-280,0,0>*in,<280,2*FloorSep,-120>*in rotate x*45 translate <0,2*FloorSep,-282>*in texture{RedPt}}
		#end
		//Cut gates into front wall
		box{<-411,0,185>*in,<-291,38,193>*in}
		box{<-204,0,185>*in,<-174,38,193>*in}
		box{<204,0,185>*in,<174,38,193>*in}
		box{<411,0,185>*in,<291,38,193>*in}
		//Cut rooms, doorways and windows for -X house
		//Lounge
		box{<-147,-1,-150>*in,<-3,RoomHt,-6>*in texture{Lounge1Pt}}
		object{Doorspace30 rotate y*90 translate <-150,0,-36>*in}//-hall
		object{Archspace30 scale <2,1,1> translate <-75,0,-153>*in}
		object{Windowspace10 scale <7.2,1,1> translate <-75,0,-3>*in}
		//Dining room
		box{<-147,-1,-276>*in,<-3,RoomHt,-156>*in texture{Dining1Pt}}
		object{Doorspace30 rotate y*90 translate <-150,0,-196>*in}//-kitchen
		object{Doorspace30 translate <-60,0,-279>*in}//-french
		object{Doorspace30 translate <-90,0,-279>*in}//-windows
		object{Windowspace10 scale <3,1,1> translate <-30,0,-279>*in}
		object{Windowspace10 scale <3,1,1> translate <-120,0,-279>*in}
		object{Windowspace10 scale <3,1,1> rotate y*90 translate <-150,0,-232>*in}
		//Doorstep
		box{<-273,0,-12>*in,<-153,RoomHt,1>*in}
		//Cloaks
		box{<-273,-1,-84>*in,<-225,RoomHt,-18>*in texture{Cloaks1Pt}}
		object{Doorspace30 rotate y*90 translate <-222,0,-66>*in}//-hall
		//Stairwell
		#if (nfloors=0)
			box{<-273,-1,-150>*in,<-195,RoomHt,-90>*in texture{Hall1Pt}}
		#end
		#if (nfloors>0)
			box{<-273,-1,-150>*in,<-195,RoomHt+FloorSep,-90>*in texture{Hall1Pt}}
		#end
		//Hall
		box{<-219,-1,-150>*in,<-153,RoomHt,-18>*in texture{Hall1Pt}}
		box{<-226,-1,-150>*in,<-218,RoomHt,-90>*in texture{Hall1Pt}}//Hall-Stairwell
		object{Doorspace30 translate <-189,0,-15>*in}//-front
		//Kitchen
		box{<-273,-1,-276>*in,<-153,RoomHt,-156>*in texture{Kitchen1Pt}}
		object{Doorspace30 translate <-171,0,-153>*in}//-hall
		object{Doorspace30 translate <-233,0,-279>*in}//-garden
		object{Windowspace10 scale <3,1,1> translate <-197,0,-279>*in}
		//Garage
		box{<-423,0,-276>*in,<-279,RoomHt,-6>*in texture{Garage1Pt}}
		object{Doorspace30 scale <4,1,1> translate <-351,0,-3>*in}//-front
		object{Doorspace30 translate <-297,0,-279>*in}//-garden
		object{Windowspace10 scale <3,1,1> translate <-333,0,-279>*in}
		object{Windowspace10 scale <3,1,1> translate <-369,0,-279>*in}
		//Patio
		object{Windowspace10 scale <3,1,1> translate <-403,0,-354>*in}
		object{Windowspace10 scale <3,1,1> translate <-365,0,-354>*in}
		object{Windowspace10 scale <3,1,1> translate <-327,0,-354>*in}
		object{Archspace30 scale <2,1,1> translate <-272,0,-354>*in}
		object{Archspace30 scale <2,1,1> translate <-204,0,-354>*in}//-kitchen
		object{Archspace30 scale <2,1,1> translate <-136,0,-354>*in}
		object{Archspace30 scale <2,1,1> translate <-68,0,-354>*in}
		object{Archspace30 scale <2,1,1> translate <0,0,-354>*in}
		object{Archspace30 scale <2,1,1> translate <68,0,-354>*in}
		object{Archspace30 scale <2,1,1> translate <136,0,-354>*in}
		object{Archspace30 scale <2,1,1> translate <204,0,-354>*in}//-lab
		object{Archspace30 scale <2,1,1> translate <272,0,-354>*in}
		//Colonnade
		object{Archspace30 scale <1.6,1,1> rotate y*90 translate <-426,0,30>*in}
		object{Archspace30 scale <1.6,1,1> rotate y*90 translate <-276,0,30>*in}
		object{ArchWspace30 scale <1.6,1,1> translate <-242,0,57>*in}
		object{Archspace30 translate <-189,0,57>*in}
		object{ArchWspace30 scale <1.6,1,1> translate <-140,0,57>*in}
		object{ArchWspace30 scale <1.6,1,1> translate <-84,0,57>*in}
		object{ArchWspace30 scale <1.6,1,1> translate <-28,0,57>*in}
		object{ArchWspace30 scale <1.6,1,1> translate <28,0,57>*in}
		object{ArchWspace30 scale <1.6,1,1> translate <84,0,57>*in}
		object{ArchWspace30 scale <1.6,1,1> translate <140,0,57>*in}
		object{Archspace30 translate <189,0,57>*in}
		object{ArchWspace30 scale <1.6,1,1> translate <242,0,57>*in}
		object{Archspace30 scale <1.6,1,1> rotate y*90 translate <276,0,30>*in}
		object{Archspace30 scale <1.6,1,1> rotate y*90 translate <426,0,30>*in}
		#if (nfloors>0)
			//Bedroom1
			box{<-147,-1,-136>*in,<-3,RoomHt,-6>*in texture{BedA1Pt} translate y*FloorSep}
			object{Doorspace30 rotate y*90 translate <-150,FloorSep,-118>*in}//-landing
			object{Windowspace10 scale <7.2,1,1> translate <-75,FloorSep,-3>*in}
			//Bedroom2
			box{<-109,-1,-276>*in,<-3,RoomHt,-142>*in texture{BedB1Pt} translate y*FloorSep}
			box{<-147,-1,-186>*in,<-108,RoomHt,-142>*in texture{BedB1Pt} translate y*FloorSep}
			object{Doorspace30 rotate y*90 translate <-150,FloorSep,-160>*in}//-landing
			object{Windowspace10 scale <6,1,1> translate <-45,FloorSep,-279>*in}
			//Bedroom3
			box{<-273,-1,-276>*in,<-195,RoomHt,-156>*in texture{BedC1Pt} translate y*FloorSep}
			object{Doorspace30 rotate y*90 translate <-192,FloorSep,-174>*in}//-landing
			object{Windowspace10 scale <3,1,1> translate <-249,FloorSep,-279>*in}
			//Bedroom4
			box{<-273,-1,-84>*in,<-153,RoomHt,-6>*in texture{BedD1Pt} translate y*FloorSep}
			object{Doorspace30 translate <-171,FloorSep,-87>*in}//-landing
			object{Windowspace10 scale <4.8,1,1> translate <-213,FloorSep,-3>*in}
			//Bathroom
			box{<-189,-1,-276>*in,<-115,RoomHt,-192>*in texture{Kitchen1Pt} translate y*FloorSep}
			object{Doorspace30 translate <-171,FloorSep,-189>*in}//-landing
			object{Windowspace10 scale <3,1,1> translate <-171,FloorSep,-279>*in}
			//Landing
			box{<-189,-1,-186>*in,<-153,RoomHt,-90>*in texture{Hall1Pt} translate y*FloorSep}
			box{<-226,-1,-150>*in,<-188,RoomHt,-90>*in texture{Hall1Pt} translate y*FloorSep}//Landing-Stairwell
		#end
		//Cut rooms, doorways and windows for +X house
		//Lounge
		box{<147,0,-150>*in,<3,RoomHt,-6>*in texture{Lounge2Pt}}
		object{Archspace30 scale <2,1,1> rotate y*90 translate <0,0,-78>*in}
		object{Doorspace30 rotate y*90 translate <150,0,-36>*in}//-hall
		object{Doorspace30 translate <75,0,-153>*in}//-dining
		object{Windowspace10 scale <7.2,1,1> translate <75,0,-3>*in}
		//Doorstep
		box{<273,0,-12>*in,<153,RoomHt,1>*in}
		//Cloaks
		box{<273,0,-84>*in,<225,RoomHt,-18>*in texture{Cloaks2Pt}}
		object{Doorspace30 rotate y*90 translate <222,0,-66>*in}//-hall
		//Stairwell
		#if (nfloors=0)
			box{<273,-1,-150>*in,<195,RoomHt,-90>*in texture{Hall2Pt}}
		#end
		#if (nfloors>0)
			box{<273,-1,-150>*in,<195,RoomHt+FloorSep,-90>*in texture{Hall2Pt}}
		#end
		//Hall
		box{<219,0,-150>*in,<153,RoomHt,-18>*in texture{Hall2Pt}}
		box{<226,0,-150>*in,<218,RoomHt,-90>*in texture{Hall2Pt}}//Hall-Stairwell
		object{Doorspace30 translate <189,0,-15>*in}//-front
		//Laboratory
		box{<147,0,-276>*in,<3,RoomHt,-156>*in texture{Lab2Pt}}
		box{<273,0,-276>*in,<153,RoomHt,-156>*in texture{Lab2Pt}}
		object{Archspace30 scale <2,1,1> rotate y*90 translate <150,0,-211>*in texture{Lab2Pt}}
		object{Archspace30 scale <2,1,1> rotate y*90 translate <276,0,-211>*in texture{Lab2Pt}}
		object{Windowspace10 scale <3,1,1> translate <30,0,-279>*in}
		object{Windowspace10 scale <3,1,1> translate <60,0,-279>*in}
		object{Windowspace10 scale <3,1,1> translate <90,0,-279>*in}
		object{Windowspace10 scale <3,1,1> translate <120,0,-279>*in}
		object{Doorspace30 translate <171,0,-153>*in}//-hall
		// xxx object{Doorspace30 translate <233,0,-279>*in}//-garden
		object{Windowspace10 scale <3,1,1> translate <233,0,-279>*in}
		object{Windowspace10 scale <3,1,1> translate <197,0,-279>*in}
		//Workshop
		box{<423,0,-276>*in,<279,RoomHt,-6>*in texture{Garage2Pt}}
		cylinder{<354,0,-282>*in,<354,RoomHt,-282>*in,69*in}//tower
		object{Doorspace30 scale <4,1,1> translate <351,0,-3>*in}//-front
		object{Doorspace30 translate <0,0,-72> rotate y*45 translate <354,0,-282>*in}//patio
		object{Windowspace10 scale <2,1,1> translate <354,0,-354>*in}
		object{Windowspace10 scale <2,1,1> rotate y*-90 translate <426,0,-282>*in}
		#if (nfloors>0)
			//Bedroom1
			box{<147,-1,-136>*in,<3,RoomHt,-6>*in texture{BedA2Pt} translate y*FloorSep}
			object{Archspace30 scale <2,1,1> rotate y*90 translate <0,FloorSep,-78>*in}
			object{Doorspace30 rotate y*90 translate <150,FloorSep,-118>*in}//-landing
			object{Windowspace10 scale <7.2,1,1> translate <75,FloorSep,-3>*in}
			//Bedroom2
			box{<109,-1,-276>*in,<3,RoomHt,-142>*in texture{BedB2Pt} translate y*FloorSep}
			box{<147,-1,-186>*in,<108,RoomHt,-142>*in texture{BedB2Pt} translate y*FloorSep}
			object{Doorspace30 rotate y*90 translate <150,FloorSep,-160>*in}//-landing
			object{Windowspace10 scale <6,1,1> translate <45,FloorSep,-279>*in}
			//Bedroom3
			box{<273,-1,-276>*in,<195,RoomHt,-156>*in texture{BedC2Pt} translate y*FloorSep}
			object{Doorspace30 rotate y*90 translate <192,FloorSep,-174>*in}//-landing
			object{Windowspace10 scale <3,1,1> translate <249,FloorSep,-279>*in}
			//Bedroom4
			box{<273,-1,-84>*in,<153,RoomHt,-6>*in texture{BedD2Pt} translate y*FloorSep}
			object{Doorspace30 translate <171,FloorSep,-87>*in}//-landing
			object{Windowspace10 scale <4.8,1,1> translate <213,FloorSep,-3>*in}
			//Bathroom
			box{<189,-1,-276>*in,<115,RoomHt,-192>*in texture{Kitchen2Pt} translate y*FloorSep}
			object{Doorspace30 translate <171,FloorSep,-189>*in}//-landing
			object{Windowspace10 scale <3,1,1> translate <171,FloorSep,-279>*in}
			//Landing
			box{<189,-1,-186>*in,<153,RoomHt,-90>*in texture{Hall2Pt} translate y*FloorSep}
			box{<226,-1,-150>*in,<188,RoomHt,-90>*in texture{Hall2Pt} translate y*FloorSep}//Landing-Stairwell
			//Garret
			cylinder{<354,-1,-282>*in,<354,RoomHt,-282>*in,69*in texture{BedD2Pt} translate y*FloorSep}
			box{<278,-1,-279>*in,<354,RoomHt,-213>*in texture{BedD2Pt} translate y*FloorSep}
			object{Doorspace30 rotate y*90 translate <275,FloorSep,-261>*in}//-bedroom4
			object{Windowspace10 scale <2,1,1> translate <354,FloorSep,-354>*in}
			object{Windowspace10 scale <2,1,1> rotate y*-90 translate <426,FloorSep,-282>*in}
			object{Windowspace10 scale <2,1,1> translate <354,FloorSep,-210>*in}
		#end
	}
	//Add fittings such as doors and windows
	box{<-427,-1,-280>*in,<428,0.1,2>*in texture{Floorboard}}
	cylinder{<354,-1,-282>*in,<354,0.1,-282>*in,73*in texture{Floorboard}}//tower
	#if (nfloors>0)
		difference{
			box{<-276,FloorSep-1,-279>*in,<276,FloorSep+0.1,-3>*in}
			box{<-280,FloorSep-2,-150>*in,<-195,FloorSep+1,-90>*in}
			box{<280,FloorSep-2,-150>*in,<195,FloorSep+1,-90>*in}
			texture{Floorboard}
		}
		cylinder{<354,FloorSep-1,-282>*in,<354,FloorSep+0.1,-282>*in,73*in texture{Floorboard}}
		box{<276,FloorSep-1,-280>*in,<352,FloorSep+0.1,-209>*in texture{Floorboard}}
	#end
	#if (nfloors>1)
		difference{
			box{<-276,2*FloorSep-1,-279>*in,<276,2*FloorSep+0.1,-3>*in}
			box{<-280,2*FloorSep-2,-150>*in,<-195,2*FloorSep+1,-90>*in}
			box{<280,2*FloorSep-2,-150>*in,<195,2*FloorSep+1,-90>*in}
			texture{Floorboard}
		}
		cylinder{<354,2*FloorSep-1,-282>*in,<354,2*FloorSep+0.1,-282>*in,73*in texture{Floorboard}}
	#end
	//front wall pillars
	box{<-162,0,183>*in,<-174,48,195>*in}
	box{<-204,0,183>*in,<-216,48,195>*in}
	box{<-279,0,183>*in,<-291,48,195>*in}
	box{<-411,0,183>*in,<-423,48,195>*in}
	box{<411,0,183>*in,<423,48,195>*in}
	box{<279,0,183>*in,<291,48,195>*in}
	box{<204,0,183>*in,<216,48,195>*in}
	box{<162,0,183>*in,<174,48,195>*in}
	#if (nfloors>1)
		//roof on tower
		difference{
			cone{<354,2*FloorSep,-282>*in,75*in<354,HouseHt,-282>*in,0*in}
			cone{<354,2*FloorSep,-282>*in,69*in<354,HouseHt-6,-282>*in,0*in}
			texture{RedPt}
		}
	#end
	//-X house
	//Lounge
		object{DoorFrame30 rotate y*90 translate <-150,0,-36>*in}//-hall
		MakeDoor(<-150,0,-36>*in,y*-90,InteriorDoorSize,2,0,45,InteriorDoorTextures)
		WindowFrame(<-51,0,-3>*in,0,<24,0,0>)
		MakeWindow (<-50,0,0>*in,0,<22,WindowHt-WindowSill,4>*in,1,array[2]{0,0},
			array[3]{MyGlass,WhitePt,WhitePt}
		)
		WindowFrame(<-75,0,-3>*in,0,<24,0,0>)
		MakeWindow (<-75,0,0>*in,0,<22,WindowHt-WindowSill,4>*in,1,array[2]{0,0},
			array[3]{MyGlass,WhitePt,WhitePt}
		)
		WindowFrame(<-99,0,-3>*in,0,<24,0,0>)
		MakeWindow (<-100,0,0>*in,0,<22,WindowHt-WindowSill,4>*in,1,array[2]{0,0},
			array[3]{MyGlass,WhitePt,WhitePt}
		)
	//Doorstep
	//Cloaks
		object{DoorFrame30 rotate y*90 translate <-222,0,-66>*in}//-hall
		MakeDoor(<-222,0,-66>*in,y*90,InteriorDoorSize,2,0,45,InteriorDoorTextures)
	//Stairwell
	//Hall
		object{DoorFrame30 translate <-189,0,-15>*in}//-front
		MakeDoor(<-189,0,-15>*in,0,InteriorDoorSize,1,1,45,array[8]{
			WhitePt,WhitePt,RedPt,T_Brass_3D,
			WhitePt,T_Glass4,T_Brass_3D,WhitePt
		})
	//Dining room
		object{DoorFrame30 rotate y*90 translate <-150,0,-196>*in}//-kitchen
		MakeDoor(<-150,0,-196>*in,y*-90,InteriorDoorSize,2,0,45,InteriorDoorTextures)
		object{DoorFrame30 translate <-60,0,-279>*in}//-french
		object{DoorFrame30 translate <-90,0,-279>*in}//-windows
		MakeDoor(<-60,0,-279>*in,0,InteriorDoorSize,1,1,45,InteriorDoorTextures)
		MakeDoor(<-90,0,-279>*in,0,InteriorDoorSize,1,0,45,InteriorDoorTextures)
		WindowFrame(<-30,0,-279>*in,0,<30,0,0>)
		MakeWindow (<-30,0,-279>*in,y*180,<30,WindowHt-WindowSill,4>*in,1,
			array[2]{0,0},array[3]{MyGlass,WhitePt,WhitePt}
		)
		WindowFrame(<-120,0,-279>*in,0,<30,0,0>)
		MakeWindow (<-120,0,-279>*in,y*180,<30,WindowHt-WindowSill,4>*in,1,
			array[2]{0,0},array[3]{MyGlass,WhitePt,WhitePt}
		)
		WindowFrame(<-150,0,-232>*in,y*90,<30,0,0>)
	//Kitchen
		object{DoorFrame30 translate <-171,0,-153>*in}//-hall
		MakeDoor(<-171,0,-153>*in,0,InteriorDoorSize,2,1,45,InteriorDoorTextures)
		object{DoorFrame30 translate <-233,0,-279>*in}//-garden
		MakeDoor(<-233,0,-279>*in,y*180,InteriorDoorSize,1,1,45,InteriorDoorTextures)
		WindowFrame(<-197,0,-279>*in,0,<30,0,0>)
		MakeWindow (<-197,0,-279>*in,y*180,<30,WindowHt-WindowSill,4>*in,1,
			array[2]{0,0.6},array[3]{MyGlass,WhitePt,WhitePt}
		)
	//Garage
		//<30,DoorHt-DoorSill,1.5>*in
		object{
			MakeDoor(<0,0,0>,0,InteriorDoorSize,1,0,0,
				array[8]{
					WhitePt,WhitePt,WhitePt,T_Brass_3D,
					WhitePt,T_Glass4,T_Brass_3D,WhitePt
				}
			)
			scale <2,1,1>
			rotate y*60
			translate <-321,0,-3>*in
		}
		object{
			MakeDoor(<0,0,0>,0,InteriorDoorSize,1,1,0,
				array[8]{
					WhitePt,WhitePt,WhitePt,T_Brass_3D,
					WhitePt,T_Glass4,T_Brass_3D,WhitePt
				}
			)
			scale <2,1,1>
			rotate y*-5
			translate <-381,0,-3>*in
		}
		object{DoorFrame30 translate <-297,0,-279>*in}//-garden
		MakeDoor(<-297,0,-279>*in,y*180,InteriorDoorSize,1,0,45,InteriorDoorTextures)
		WindowFrame(<-333,0,-279>*in,0,<30,0,0>)
		MakeWindow (<-333,0,-279>*in,y*180,<30,WindowHt-WindowSill,4>*in,1,
			array[2]{0,0},array[3]{MyGlass,WhitePt,WhitePt}
		)
		WindowFrame(<-369,0,-279>*in,0,<30,0,0>)
		MakeWindow (<-369,0,-279>*in,y*180,<30,WindowHt-WindowSill,4>*in,1,
			array[2]{0,0},array[3]{MyGlass,WhitePt,WhitePt}
		)
	#if (nfloors>0)
		//Bedroom1
		object{DoorFrame30 rotate y*90 translate <-150,FloorSep,-118>*in}//-landing
		MakeDoor(<-150,FloorSep,-118>*in,y*-90,InteriorDoorSize,2,0,45,InteriorDoorTextures)
		WindowFrame(<-51,FloorSep,-3>*in,0,<24,0,0>)
		MakeWindow (<-50,FloorSep,0>*in,0,<22,WindowHt-WindowSill,4>*in,1,array[2]{0,0},
			array[3]{MyGlass,WhitePt,WhitePt}
		)
		WindowFrame(<-75,FloorSep,-3>*in,0,<24,0,0>)
		MakeWindow (<-75,FloorSep,0>*in,0,<22,WindowHt-WindowSill,4>*in,1,array[2]{0,0},
			array[3]{MyGlass,WhitePt,WhitePt}
		)
		WindowFrame(<-99,FloorSep,-3>*in,0,<24,0,0>)
		MakeWindow (<-100,FloorSep,0>*in,0,<22,WindowHt-WindowSill,4>*in,1,array[2]{0,0.5},
			array[3]{MyGlass,WhitePt,WhitePt}
		)
		//Bedroom2
		object{DoorFrame30 rotate y*90 translate <-150,FloorSep,-160>*in}//-landing
		MakeDoor(<-150,FloorSep,-160>*in,y*-90,InteriorDoorSize,2,1,45,InteriorDoorTextures)
		WindowFrame(<-30,FloorSep,-279>*in,0,<30,0,0>)
		MakeWindow (<-31,FloorSep,-279>*in,y*180,<28,WindowHt-WindowSill,4>*in,1,array[2]{0,0},
			array[3]{MyGlass,WhitePt,WhitePt}
		)
		WindowFrame(<-60,FloorSep,-279>*in,0,<30,0,0>)
		MakeWindow (<-59,FloorSep,-279>*in,y*180,<28,WindowHt-WindowSill,4>*in,1,array[2]{0.25,0},
			array[3]{MyGlass,WhitePt,WhitePt}
		)
		//Bedroom3
		object{DoorFrame30 rotate y*90 translate <-192,FloorSep,-174>*in}//-landing
		MakeDoor(<-192,FloorSep,-174>*in,y*90,InteriorDoorSize,2,0,45,InteriorDoorTextures)
		WindowFrame(<-249,FloorSep,-279>*in,0,<30,0,0>)
		MakeWindow (<-249,FloorSep,-279>*in,y*180,<30,WindowHt-WindowSill,4>*in,1,
			array[2]{0.1,0},array[3]{MyGlass,WhitePt,WhitePt}
		)
		//Bedroom4
		object{DoorFrame30 translate <-171,FloorSep,-87>*in}//-landing
		MakeDoor(<-171,FloorSep,-87>*in,y*180,InteriorDoorSize,2,0,45,InteriorDoorTextures)
		WindowFrame(<-201,FloorSep,-3>*in,0,<24,0,0>)
		MakeWindow (<-200,FloorSep,0>*in,0,<22,WindowHt-WindowSill,4>*in,1,array[2]{0.6,0.5},
			array[3]{MyGlass,WhitePt,WhitePt}
		)
		WindowFrame(<-225,FloorSep,-3>*in,0,<24,0,0>)
		MakeWindow (<-226,FloorSep,0>*in,0,<22,WindowHt-WindowSill,4>*in,1,array[2]{0,0},
			array[3]{MyGlass,WhitePt,WhitePt}
		)
		//Bathroom
		object{DoorFrame30 translate <-171,FloorSep,-189>*in}//-landing
		MakeDoor(<-171,FloorSep,-189>*in,0,InteriorDoorSize,2,1,45,InteriorDoorTextures)
		WindowFrame(<-171,FloorSep,-279>*in,0,<30,0,0>)
		MakeWindow (<-171,FloorSep,-279>*in,y*180,<30,WindowHt-WindowSill,4>*in,1,
			array[2]{0.1,0},array[3]{MyGlass,WhitePt,WhitePt}
		)
		//Landing
	#end
	//+X house
	//Lounge
		object{DoorFrame30 rotate y*90 translate <150,0,-36>*in}//-hall
		MakeDoor(<150,0,-36>*in,y*90,InteriorDoorSize,2,1,45,InteriorDoorTextures)
		object{DoorFrame30 translate <75,0,-153>*in}//-dining
		MakeDoor(<75,0,-153>*in,y*180,InteriorDoorSize,2,0,45,InteriorDoorTextures)
		WindowFrame(<51,0,-3>*in,0,<24,0,0>)
		MakeWindow (<50,0,0>*in,0,<22,WindowHt-WindowSill,4>*in,1,array[2]{0,1},
			array[3]{MyGlass,WhitePt,WhitePt}
		)
		WindowFrame(<75,0,-3>*in,0,<24,0,0>)
		MakeWindow (<75,0,0>*in,0,<22,WindowHt-WindowSill,4>*in,1,array[2]{0,1},
			array[3]{MyGlass,WhitePt,WhitePt}
		)
		WindowFrame(<99,0,-3>*in,0,<24,0,0>)
		MakeWindow (<100,0,0>*in,0,<22,WindowHt-WindowSill,4>*in,1,array[2]{0.2,0.75},
			array[3]{MyGlass,WhitePt,WhitePt}
		)
	//Doorstep
	//Cloaks
		object{DoorFrame30 rotate y*90 translate <222,0,-66>*in}//-hall
		MakeDoor(<222,0,-66>*in,y*-90,InteriorDoorSize,2,1,45,InteriorDoorTextures)
	//Stairwell
	//Hall
		object{DoorFrame30 translate <189,0,-15>*in}//-front
		MakeDoor(<189,0,-15>*in,0,InteriorDoorSize,1,0,45,array[8]{
			WhitePt,WhitePt,GreenPt,T_Brass_3D,
			WhitePt,T_Glass4,T_Brass_3D,WhitePt
		})
	//Laboratory
		WindowFrame(<30,0,-279>*in,0,<30,0,0>)
		MakeWindow (<30,0,-279>*in,y*180,<30,WindowHt-WindowSill,4>*in,1,
			array[2]{0.8,0},array[3]{MyGlass,WhitePt,WhitePt}
		)
		WindowFrame(<60,0,-279>*in,0,<30,0,0>)
		MakeWindow (<60,0,-279>*in,y*180,<30,WindowHt-WindowSill,4>*in,1,
			array[2]{0,0},array[3]{MyGlass,WhitePt,WhitePt}
		)
		WindowFrame(<90,0,-279>*in,0,<30,0,0>)
		MakeWindow (<90,0,-279>*in,y*180,<30,WindowHt-WindowSill,4>*in,1,
			array[2]{0,0},array[3]{MyGlass,WhitePt,WhitePt}
		)
		WindowFrame(<120,0,-279>*in,0,<30,0,0>)
		MakeWindow (<120,0,-279>*in,y*180,<30,WindowHt-WindowSill,4>*in,1,
			array[2]{0,0},array[3]{MyGlass,WhitePt,WhitePt}
		)
		object{DoorFrame30 translate <171,0,-153>*in}//-hall
		MakeDoor(<171,0,-153>*in,y*180,InteriorDoorSize,2,1,45,InteriorDoorTextures)
		// xxx object{DoorFrame30 translate <233,0,-279>*in}//-garden
		// xxx MakeDoor(<233,0,-279>*in,y*180,InteriorDoorSize,1,0,45,InteriorDoorTextures)
		WindowFrame(<233,0,-279>*in,0,<30,0,0>)
		MakeWindow (<233,0,-279>*in,y*180,<30,WindowHt-WindowSill,4>*in,1,
			array[2]{0,1},array[3]{MyGlass,WhitePt,WhitePt}
		)
		WindowFrame(<197,0,-279>*in,0,<30,0,0>)
		MakeWindow (<197,0,-279>*in,y*180,<30,WindowHt-WindowSill,4>*in,1,
			array[2]{0.3,0},array[3]{MyGlass,WhitePt,WhitePt}
		)
		object{LabFittings()}// This is just to keep the code shorter in this part
		#if (nfloors>0)
			box{<276,RoomHt-0.25,-277>*in,<0,RoomHt,-157>*in texture{CeilingPt}}
		#end
	//Workshop
		object{
			MakeDoor(<0,0,0>,0,InteriorDoorSize,1,0,0,
				array[8]{
					WhitePt,WhitePt,WhitePt,T_Brass_3D,
					WhitePt,T_Glass4,T_Brass_3D,WhitePt
				}
			)
			scale <2,1,1>
			rotate y*10
			translate <381,0,-3>*in
		}
		object{
			MakeDoor(<0,0,0>,0,InteriorDoorSize,1,1,0,
				array[8]{
					WhitePt,WhitePt,WhitePt,T_Brass_3D,
					WhitePt,T_Glass4,T_Brass_3D,WhitePt
				}
			)
			scale <2,1,1>
			rotate y*-10
			translate <321,0,-3>*in
		}
		object{DoorFrame30 translate <0,0,-72> rotate y*45 translate <354,0,-282>*in}//-patio
		object{
			MakeDoor(<0,0,-72>*in,y*45,InteriorDoorSize,1,1,45,InteriorDoorTextures)
			translate <354,0,-282>*in
		}
		WindowFrame(<354,0,-354>*in,0,<20,0,0>)
		MakeWindow (<354,0,-354>*in,y*180,<20,WindowHt-WindowSill,4>*in,1,
			array[2]{0,0},array[3]{MyGlass,WhitePt,WhitePt}
		)
		WindowFrame(<426,0,-282>*in,y*90,<20,0,0>)
		MakeWindow (<426,0,-282>*in,y*90,<20,WindowHt-WindowSill,4>*in,1,
			array[2]{0.1,0},array[3]{MyGlass,WhitePt,WhitePt}
		)
	#if (nfloors>0)
		//Bedroom1
		object{DoorFrame30 rotate y*90 translate <150,FloorSep,-118>*in}//-landing
		MakeDoor(<150,FloorSep,-118>*in,y*90,InteriorDoorSize,2,1,45,InteriorDoorTextures)
		WindowFrame(<51,FloorSep,-3>*in,0,<24,0,0>)
		MakeWindow (<50,FloorSep,0>*in,0,<22,WindowHt-WindowSill,4>*in,1,array[2]{0,0},
			array[3]{MyGlass,WhitePt,WhitePt}
		)
		WindowFrame(<75,FloorSep,-3>*in,0,<24,0,0>)
		MakeWindow (<75,FloorSep,0>*in,0,<22,WindowHt-WindowSill,4>*in,1,array[2]{0.6,0},
			array[3]{MyGlass,WhitePt,WhitePt}
		)
		WindowFrame(<99,FloorSep,-3>*in,0,<24,0,0>)
		MakeWindow (<100,FloorSep,0>*in,0,<22,WindowHt-WindowSill,4>*in,1,array[2]{0,0},
			array[3]{MyGlass,WhitePt,WhitePt}
		)
		//Bedroom2
		object{DoorFrame30 rotate y*90 translate <150,FloorSep,-160>*in}//-landing
		MakeDoor(<150,FloorSep,-160>*in,y*90,InteriorDoorSize,2,0,45,InteriorDoorTextures)
		WindowFrame(<30,FloorSep,-279>*in,0,<30,0,0>)
		MakeWindow (<31,FloorSep,-279>*in,y*180,<28,WindowHt-WindowSill,4>*in,1,array[2]{0,0.35},
			array[3]{MyGlass,WhitePt,WhitePt}
		)
		WindowFrame(<60,FloorSep,-279>*in,0,<30,0,0>)
		MakeWindow (<59,FloorSep,-279>*in,y*180,<28,WindowHt-WindowSill,4>*in,1,array[2]{0,0.42},
			array[3]{MyGlass,WhitePt,WhitePt}
		)
		//Bedroom3
		object{DoorFrame30 rotate y*90 translate <192,FloorSep,-174>*in}//-landing
		MakeDoor(<192,FloorSep,-174>*in,y*-90,InteriorDoorSize,2,1,45,InteriorDoorTextures)
		WindowFrame(<249,FloorSep,-279>*in,0,<30,0,0>)
		MakeWindow (<249,FloorSep,-279>*in,y*180,<30,WindowHt-WindowSill,4>*in,1,
			array[2]{0,0},array[3]{MyGlass,WhitePt,WhitePt}
		)
		//Bedroom4
		object{DoorFrame30 translate <171,FloorSep,-87>*in}//-landing
		MakeDoor(<171,FloorSep,-87>*in,y*180,InteriorDoorSize,2,1,45,InteriorDoorTextures)
		WindowFrame(<201,FloorSep,-3>*in,0,<24,0,0>)
		MakeWindow (<200,FloorSep,0>*in,0,<22,WindowHt-WindowSill,4>*in,1,array[2]{0.2,0.2},
			array[3]{MyGlass,WhitePt,WhitePt}
		)
		WindowFrame(<225,FloorSep,-3>*in,0,<24,0,0>)
		MakeWindow (<226,FloorSep,0>*in,0,<22,WindowHt-WindowSill,4>*in,1,array[2]{0,0},
			array[3]{MyGlass,WhitePt,WhitePt}
		)
		//Bathroom
		object{DoorFrame30 translate <171,FloorSep,-189>*in}//-landing
		MakeDoor(<171,FloorSep,-189>*in,0,InteriorDoorSize,2,0,45,InteriorDoorTextures)
		WindowFrame(<171,FloorSep,-279>*in,0,<30,0,0>)
		MakeWindow (<171,FloorSep,-279>*in,y*180,<30,WindowHt-WindowSill,4>*in,1,
			array[2]{0,0.2},array[3]{MyGlass,WhitePt,WhitePt}
		)
		//Garret
		object{DoorFrame30 rotate y*90 translate <275,FloorSep,-261>*in}//-bed4
		MakeDoor(<275,FloorSep,-261>*in,y*90,InteriorDoorSize,2,1,45,InteriorDoorTextures)
		WindowFrame(<354,FloorSep,-354>*in,0,<20,0,0>)
		MakeWindow (<354,FloorSep,-354>*in,y*180,<20,WindowHt-WindowSill,4>*in,1,
			array[2]{0,0},array[3]{MyGlass,WhitePt,WhitePt}
		)
		WindowFrame(<426,FloorSep,-282>*in,y*-90,<20,0,0>)
		MakeWindow (<426,FloorSep,-282>*in,y*-90,<20,WindowHt-WindowSill,4>*in,1,
			array[2]{0,0},array[3]{MyGlass,WhitePt,WhitePt}
		)
		WindowFrame(<354,FloorSep,-210>*in,0,<20,0,0>)
		MakeWindow (<354,FloorSep,-210>*in,y*0,<20,WindowHt-WindowSill,4>*in,1,
			array[2]{0,0},array[3]{MyGlass,WhitePt,WhitePt}
		)
	#end
	//Add furniture, room by room
	texture{Brickstuff}
}
#end

#debug "\r----\rend of madhouse.inc\r----\r"
                J  QIcon
           @         madhouse.inc(EX) Apr 2000leesnd  TEXTMPS    t                  J=  {       Q
lamppost.pict   PICTJVWR         $                                                  x                Q   H 	Monaco sswΐinc
// Vers:        ! .Z9! .Z9%(  *  *  (    2   
\  Labfill  yG  yGLabcut   
  
Labdoor   ! .Z9! .Z9  (                     Jz%Pl    J  MPSR  
           L       |$                  