 pdmmads.pov , L
B@ 8"
B DXCh   
B@TEXTPOV3   @        ~v%N                           // POV-Ray file
// Standard pre-defined colors
#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "metals.inc"
#include "woods.inc"

/* Without anti-aliasing:
Time For Parse:    0 hours  0 minutes   8.0 seconds (8 seconds)
Time For Trace:    2 hours 38 minutes  36.0 seconds (9516 seconds)
    Total Time:    2 hours 38 minutes  44.0 seconds (9524 seconds)
*/

//global_settings{max_trace_level 10}

// Units
#declare in = 1;// Redefine only this to change scale.
#declare ft = 12*in;
#declare yd = 36*in;
#declare mi = 5280*ft;
#declare mm = in/25.4;

//========================================================================
#fopen DebugFile "madhouse.debug" write

//#declare LookAt    = <0,72,0>*in;//whole house
//#declare LookAt    = <-216,48,0>*in;//first half house
//#declare LookAt    = <30,48,-141>*in;//house plan
//#declare LookAt    = <-216,48,-141>*in;//first half house plan
//#declare LookAt    = <216,48,-141>*in;//second half house plan
//#declare LookAt    = <216,48,0>*in;//second half house
//#declare LookAt    = <150,48,-211>*in;//Laboratory arch 1
//#declare LookAt    = <150,48,-159>*in;//Corner near lab arch 1
//#declare LookAt    = <138,48,-216>*in;//Laboratory overview
#declare LookAt    = <75,36,-250>*in;//Laboratory windows group 1
//#declare LookAt    = <0,64,0>*in;//test overall
//#declare LookAt    = <0,16,0>*in;//test #1
//#declare LookAt    = <0,48,0>*in;//test #2
//#declare LookAt    = <0,80,0>*in;//test #3
//#declare LookAt    = <0,112,0>*in;//test #4
//#declare ViewPoint = LookAt+<0,0,24>*in;//test from closeup front
//#declare ViewPoint = LookAt+<0,0,45>*in;//test from front
//#declare ViewPoint = LookAt+<0,0,90>*in;//test from not so close front
//#declare ViewPoint = LookAt+<0,0,135>*in;//test from further front
//#declare ViewPoint = <0,55,-80>*ft;//from back
//#declare ViewPoint = <0,40,50>*ft;//from front
//#declare ViewPoint = <2.5,57,-12>*ft;//plan of downstairs (nfloors=0)
//#declare ViewPoint = <2.5,66.5,-12>*ft;//plan of upstairs (nfloors=1)
//#declare ViewPoint = <0,75,-12>*ft;//plan including roof (nfloors=2)
//#declare ViewPoint = <0,40,60>*ft;//from front - whole site
//#declare ViewPoint = <0,55,-110>*ft;//from back - whole site
//#declare ViewPoint = <0,5.75,-110>*ft;//human VP from back
//#declare ViewPoint = <0,5.75,12.5>*ft;//close-up from front
//#declare ViewPoint = <-18,25,35>*ft;//first half from front
//#declare ViewPoint = <-18,40,-12>*ft;//first half plan
//#declare ViewPoint = <18,25,35>*ft;//second half from front
//#declare ViewPoint = <18,40,-12>*ft;//second half plan
//#declare ViewPoint = <138,300,-216>*in;//Laboratory plan
//#declare ViewPoint = <75,69,-153>*in;//View from lab door to lounge
//#declare ViewPoint = <6,69,-211>*in;//from lab wall
#declare ViewPoint = <24,69,-159>*in;//from lab corner
//#declare ViewPoint = <6,69,-273>*in;//from next lab corner ***
//#declare ViewPoint = <276,69,-211>*in;//from workshop doorway
//#declare ViewPoint = <30,69,-285>*in;//from window

//development values
#declare CameraLight=0.6;
#declare GeneralLight=0.4;
#declare Detailed=1;
#declare GoodGlass=1;

//========================================================================
#declare BlackPt=texture{pigment{Black}}
#declare BluePt=texture{pigment{Blue}}
#declare BrassPt=texture{pigment{Brass}}
#declare BronzePt=texture{pigment{Bronze}}
#declare BrownPt=texture{pigment{Brown}}
#declare ClearPt=texture{pigment{Clear}}
#declare CopperPt=texture{pigment{Copper}}
#declare CoralPt=texture{pigment{Coral}}
#declare CyanPt=texture{pigment{Cyan}}
#declare FleshPt=texture{pigment{Flesh}}
#declare GoldPt=texture{pigment{Gold}}
#declare GreenPt=texture{pigment{Green}}
#declare Grey25Pt=texture{pigment{Gray25}}
#declare Grey50Pt=texture{pigment{Gray50}}
#declare Grey75Pt=texture{pigment{Gray75}}
#declare KhakiPt=texture{pigment{Khaki}}
#declare MagentaPt=texture{pigment{Magenta}}
#declare MaroonPt=texture{pigment{Maroon}}
#declare NavyPt=texture{pigment{Navy}}
#declare OrangePt=texture{pigment{Orange}}
#declare OrchidPt=texture{pigment{Orchid}}
#declare PinkPt=texture{pigment{Pink}}
#declare PlumPt=texture{pigment{Plum}}
#declare RedPt=texture{pigment{Red}}
#declare SalmonPt=texture{pigment{Salmon}}
#declare ScarletPt=texture{pigment{Scarlet}}
#declare SiennaPt=texture{pigment{Sienna}}
#declare SilverPt=texture{pigment{Silver}}
#declare TanPt=texture{pigment{Tan}}
#declare TurquoisePt=texture{pigment{Turquoise}}
#declare VioletPt=texture{pigment{Violet}}
#declare WhitePt=texture{pigment{White}}
#declare YellowPt=texture{pigment{Yellow}}
//#declare FeldsparPt=texture{pigment{Feldspar}}
//#declare QuartzPt=texture{pigment{Quartz}}

//========================================================================
/*
	plocn: origin - bottom left front corner of piece of paper
	protn: rotation about book origin
	psize: size of paper - all values should be positive
	pageimage: map of page contents - shows through on back.
*/
#macro Page(plocn,protn,psize,pageimage)
box{<0,0,0>,psize
	texture{
		pigment{
			image_map{
				sys pageimage
				map_type 0 interpolate 2 //once
			}
			scale <psize.x,psize.y,1>
			translate <0,psize.y,0>
		}
	}
	rotate protn
	translate plocn
}
#end

#macro UpTo(Vector1,Vector2,Seed)
	#local TempVector=
		<Vector1.x+(Vector2.x-Vector1.x)*rand(Seed),
		 Vector1.y+(Vector2.y-Vector1.y)*rand(Seed),
		 Vector1.z+(Vector2.z-Vector1.z)*rand(Seed)>;
	#if (Vector1.x=Vector2.x)
		#local TempVector=<Vector1.x,TempVector.y,TempVector.z>;
	#end
	#if (Vector1.y=Vector2.y)
		#local TempVector=<TempVector.x,Vector1.y,TempVector.z>;
	#end
	#if (Vector1.z=Vector2.z)
		#local TempVector=<TempVector.x,TempVector.y,Vector1.z>;
	#end
	TempVector
#end

//========================================================================
// sketchy environment
difference{
	plane{y,-0.1*in hollow texture{pigment{colour rgb <0.50,0.80,0.50>}}}//ground
	box{<-1500,-6,240>*in,<1500,0,400>*in}//road
}
box{<-1500,-6,192>*in,<1500,0,240>*in texture{pigment{Gray60}}}//pavement
box{<-1500,-6,240>*in,<1500,-2.9,400>*in texture{pigment{Gray20}}}//road
box{<-1500,-3,319>*in,<1500,-2.85,321>*in texture{pigment{Gray90}}}//road marking
box{<-1500,-6,400>*in,<1500,0,448>*in texture{pigment{Gray60}}}//pavement
background{colour rgb <0.6,0.6,0.8>}//sky
//========================================================================
#include "matrix.mcr"
#include "rtd3.inc"
#include "BandT.inc"
#include "furnish.inc"
#include "glassware.inc"
#include "creatures.inc"
#include "madhouse.inc"
//object{Madhouse(0)}
object{Madhouse(2)}
//object{TestWallD}
//object{TestWallW}
//object{TextureTest}
//========================================================================

//========================================================================
#if (CameraLight>0)
  light_source {
    ViewPoint
    colour rgb <1,1,1>*CameraLight
  }
#end

camera{
  //right x
  location  ViewPoint // position of camera <X Y Z>
  look_at   LookAt // point center of view at this point <X Y Z>
}

#if (GeneralLight>0)
	light_source {
	  <0,60,-10>*ft
	  colour rgb <1,1,1>*GeneralLight
	}
#end

#fclose DebugFile

                                     6  6   e?N   _VD HXOL Nu    pdmmads.povmsEX) Apr 2000leesnd TEXTPOV3 @                   ~v    YO o "o ,/ X X X *t `D@ gHHԀ`(X @ @g0H@HԀ`X X $ݱ( SJnXOL `NuH $@ , ^&
g@    X   w   JVWR8BIMGKONGKONTVOD     	                          >                               ?  rpza                  , 	  B ,A{     d     F     H 	Monaco L|=      !      p te   < $ < $%N              < $ < $                   6  6   ez%I    R MPSR  FPRF   *         |#6          POV-Ray File Prefs                                                                                                     