// This is a Persistence of Vision Ray Tracer (POV-Ray) Version 2.2 Scene file
//             POV-Ray is (Copyrighted) 1994-95, POV-Ray Team
//
// This file was generated using "Mid Night Modeller" Version 2.10
//             MNM is (Copyright) 1994-95, David R.Taylor
//
//
//******************************** HEADER *************************************
#default {
  pigment {rgb <1,1,1>}
 }
// *** STANDARD INCLUDES ***
#include "colors.inc"
#include "textures.inc"
#include "stones.inc"
#include "woods.inc"
 
#version unofficial megapov 0.5;

#declare lumi=0;//2,1,0 2 > fast ; 0 > slow


#if (lumi=0) 
 cone { <0.0, 0.0, 0.0>, 2.5, <0.0, 0.5, 0.0>, 2.5  
        translate <-3, 4.5, -4>
        pigment { color rgb 50}
    }
global_settings {
  max_trace_level 8//4
  //ambient_light 1.3
  
  ini_option "+QR +F +AA0.3"
 
  radiosity{
        pretrace_start 0.16
        pretrace_end   0.01
        count 300             
//        count 30          //plus rapide, moins joli    
        nearest_count 4      
        error_bound 0.1      
        recursion_limit 1    
        low_error_factor 1  
        gray_threshold 0.5  
        minimum_reuse 0.015 
        brightness 1.2      
        adc_bailout 0.01/2  
        }
}

light_source {  0*x//<-3, 4, -4>
        color rgb 1
        area_light <-2.5,0,-2.5><2.5,0,2.5> 6,6 //<-5.4,4,-6.5>,<-.5,4,-1.5> 2,2
        circular
        orient
       fade_distance 1       // dcimal
       fade_power    1.15       // dcimal
       translate <-3,4,-4> 
    } 
#end
#if (lumi=1)
light_source {  0*x//<-3, 4, -4>
        color rgb 2
        area_light <-2.5,0,-2.5><2.5,0,2.5> 6,6 //<-5.4,4,-6.5>,<-.5,4,-1.5> 2,2
        circular
        orient
       fade_distance 1       // dcimal
       fade_power    1.15       // dcimal
       translate <-3,4,-4> 
    }
    
global_settings {
  max_trace_level 10
}      
#end
    
#if (lumi=2)
light_source {  0*x//<-3, 4, -4>
        color rgb 1
        //area_light <-2.5,0,-2.5><2.5,0,2.5> 6,6 //<-5.4,4,-6.5>,<-.5,4,-1.5> 2,2
        //circular
        //orient
       //fade_distance 1       // dcimal
       //fade_power    1.15       // dcimal
       translate <-3,4,-4> 
    }
    
global_settings {
  max_trace_level 2
}      
#end    
//****************** CAMERA **********************

//origine

camera {
    location <-5, 2, -9>
   direction <0, 0, 800/600>//1.20711>
         sky <0, 1, 0>
          up <0, 1, 0>
       right <1.33333, 0, 0>
     look_at <-4, 1.1, -4>
}


/*
camera {
    location <-3, 1, -1>
   direction <0, 0, 1.20711>
         sky <0, 1, 0>
          up <0, 1, 0>
       right <1.33333, 0, 0>
     look_at <-2.4,0.7,-.1>
}
*/



//texture
#declare Glass = 
   material  {		// Glass
      texture {      
         pigment {
            color rgbf <1.0, 1.0, 1.0, 0.7>
         }      
         finish {
            ambient 0.0
            diffuse 0.0
            specular 1.0
            roughness 0.001
            reflection 0.5
         }
      }   
      interior { ior 1.2 }
   }




#include "batcave.pov" //ok
object {batcave}
#include "batatomi.pov"//ok



#include "bat1.pov" //ok
object {bat1 scale .1 translate <-5,0,-6.5>}
 


#include "bat2.pov"//ok
object {bat2  scale .1 translate <-6,0,-5.9>}


#include "batepr2.pov"
object { batepr2 scale .05 translate <-4.75,.93,-5.5>}



#include "batpot.pov"
object {batpot
scale .04 
translate  <-5.3,.94,-5.7>
material {Glass}
}


#include "intbatpot.pov"
object {intbatpot
scale .04 
translate  <-5.3,.94,-5.7>
}


#include "bat3.pov"//ok
object {bat3  scale .1 translate <-.2,0,-.6>}
#include "potrond.inc"
#include "bateprou.pov"
object {bateprou  rotate -15*y scale .01 translate <-3.5,.32,-6.115> } 
#include "batepr1.pov"
object {batepr1  rotate -3*y scale .01 translate <-4.2,1.12,-6.32> } 




object {potrond material {Glass} scale .03 translate <-4.5,.32,-6.25> } 
object {potrond material {Glass} scale .03 translate <-4.7,.72,-6.1> }          
object {potrond material {Glass} scale .03 translate <-3.7,.72,-6.18> }
object {potrond material {Glass} scale .03 translate <-4.48,1.12,-6.4> }
#include "potrond1.inc"
object {potrond1 material {Glass} scale .02 translate <-3.5,.72,-6.12> } 








#include "bat4.pov"//ok
object {bat4 scale .1 translate <-5.5,0,-.5>}

#include "bat5.pov"//ok
object {bat5 scale .1 rotate -30*y translate <-5,0,-.8>}
object {bat5 scale .1 rotate -120*y translate <-6.75,0,-3>} 
object {bat5 scale .1 rotate -70*y translate <-2,0,-.25>}

#include "bat6.pov"//ok
object {bat6 scale .1 rotate -42*y translate <-7.25,0,-3.25>}

#include "bat7.pov"//ok
object {bat7 scale .1 rotate 90*y translate <-.7,0,.5>}

#include "bat8.pov"
object {bat8 scale .1  translate <-2.75,0,-.1>} 
object {bat8 scale .1  rotate 20*y translate <-8.2,0,-.3>}


#include "feuille.pov"
object {feuille1 scale .008 translate <-6.8,.72,-2.5> }
object {feuille3 rotate -33*y translate .1*y scale .008 translate <-6.6,.72,-2.7> }   

object {feuille3 rotate -28*y translate .0*y scale .008 translate <-7.2,0.72,-.45> }
object {feuille1 rotate 8*y translate .0*y scale .008 translate <-7,0.72,-.75> }
object {feuille2 rotate -15*y translate .1*y scale .008 translate <-7.1,0.72,-.53> }
object {feuille1 rotate 180*y translate .0*y scale .008 translate <-6.9,0.72,-.21> }


object {feuille3 rotate 180*y translate .0*y scale .008 translate <-2.4,0.72,.2> }
object {feuille3 rotate 178*y translate .1*y scale .008 translate <-2.4,0.72,.2> }
object {feuille3 rotate 175*y translate .2*y scale .008 translate <-2.4,0.72,.2> }
object {feuille3 rotate 183*y translate .3*y scale .008 translate <-2.4,0.72,.2> }
object {feuille3 rotate 187*y translate .4*y scale .008 translate <-2.4,0.72,.2> }
object {feuille3 rotate 178*y translate .5*y scale .008 translate <-2.4,0.72,.2> }
object {feuille3 rotate 181*y translate .6*y scale .008 translate <-2.4,0.72,.2> }
object {feuille3 rotate 183*y translate .7*y scale .008 translate <-2.4,0.72,.2> }
object {feuille3 rotate 179*y translate .8*y scale .008 translate <-2.4,0.72,.2> }
object {feuille3 rotate 176*y translate .9*y scale .008 translate <-2.4,0.72,.2> }
object {feuille3 rotate 180*y translate 1.*y scale .008 translate <-2.4,0.72,.2> }
object {feuille3 rotate 175*y translate 1.10*y scale .008 translate <-2.4,0.72,.2> }
object {feuille3 rotate 180*y translate 1.20*y scale .008 translate <-2.4,0.72,.2> }
object {feuille3 rotate 176*y translate 1.30*y scale .008 translate <-2.4,0.72,.2> } 
object {feuille2 rotate 182*y translate 1.30*y scale .008 translate <-2.4,0.72,.2> } 

object {feuille1 rotate 0*y translate 0*y scale .008 translate <-2.,0.72, 0> }
object {feuille2 rotate 20*y translate 0*y scale .008 translate <-2.2,0.72, .07> } 

object {feuille3 rotate 40*y translate 0*y scale .008 translate <-1.75,0.72, .07> }