// *** THAT'S MEGAPOV CODE ***
#version unofficial MegaPov 0.5;

// *** CRISOL ***
#declare crisol=
union{
 intersection{
  difference{
   sphere{0,1}
   sphere{0,.8}
  }
  plane{y,-.1}
  plane{y,-.6 inverse}
 }
 cylinder{<0,-.1,0>,<0,0,0>,.8 translate -.5*y}
 texture{
  pigment{DkGreenCopper}
  normal{facets coords .2 scale 8}
  finish{F_MetalA}
 }
 scale <3,7,3>
 scale .8
}
#declare tapa_crisol=
union{
 cylinder{<0,0,-.1>,<0,0,.1>,.1 scale <2,1,1>}
 cylinder{<0,-.1,0>,<0,0,0>,.99}
 texture{
  pigment{DkGreenCopper}
  normal{wrinkles scale .1}
  finish{F_MetalA}
 }
 scale <3,7,3>
 scale .8
}
// *** SOPORTE TRIANGULAR ***
#declare alt_sop=4.4;
#declare rst=.4;
#declare pata_tr=
intersection{
 difference{
  cylinder{<0,0,-.5>,<0,0,.5>,.5}
  cylinder{<0,0,-.51>,<0,0,.51>,.1}
 }
 plane{y,0}
 plane{x,0 inverse}
 plane{y,-.4 inverse}
 translate -.5*x
 scale <1,10,.8>
}
#declare soporte_triangulo=
union{
 intersection{
  union{
   cylinder{<-2.5,4,-2>,<0,4,2>,rst}
   cylinder{<0,4,2>,<2.5,4,-2>,rst}
   cylinder{<2.5,4,-2>,<-2.5,4,-2>,rst}
   sphere{<-2.5,4,-2>,rst}
   sphere{<0,4,2>,rst}
   sphere{<2.5,4,-2>,rst}
  }
  plane{y,4.25}
  plane{y,3.75 inverse}
 }
 object{pata_tr rotate 60*y translate <-2.5,4,-2>}
 object{pata_tr rotate 120*y translate <0,4,2>}
 object{pata_tr rotate -60*y translate <2.5,4,-2>}
 texture{T_Chrome_2B}
}
// *** REJILLA PROTECCION ***
#declare rejilla_alambre=
height_field{
 png "hf_rejilla.png"
 water_level .2
 translate -.5
 scale <5,.1,5>
 texture{
  pigment{DarkTan*.5}
  finish{F_MetalA}
 }
}
// *** FULGOR EXPLOSION ***
#declare fulgor=
 intersection{
  sphere{0,1}
  plane{y,0 inverse}
  hollow
  material{
   texture{ pigment{ color rgbt <1.0, 1.0, 1.0, 1.0> } }
   interior{
    media{
     emission .2
     density{
      spherical
      color_map{
       [ 0.00 Black]
       [ 0.10 Orange]
       [ 0.50 Yellow]
       [ 0.90 Red]
       [ 1.00 Black]
      }
      turbulence 0.2
      omega 0.9
      triangle_wave
      frequency 3
     }
     scale .5
    }
   }
  }
  scale <4,6,4>
 }
// *** PARTICULAS DE EXPLOSION ***
#declare r_smk=seed(143);
#declare cnt_part=1;
#declare num_part=8;
#declare particulas=
union{
#while (cnt_part<=num_part)
 #declare res=8+10*rand(r_smk);
 #declare tmp_path=int(res*.3+res*.2*rand(r_smk));
 #declare cnt_path=tmp_path;
 #declare py=(2+2*rand(r_smk));
 #declare pz=(4+rand(r_smk));
 #declare ry=int(res*.9+res*.1*rand(r_smk));
 #declare y_ant=0;
 #declare z_ant=0;
 union{
 #while (cnt_path<=ry)
  #declare y_act=py*sin(pi*cnt_path/res);
  #declare z_act=-.5+pz*cos(.5*pi*(1-(cnt_path/res)));
  #if (y_ant>0 & y_act>0)
  cylinder{
   <0,y_ant,z_ant>,<0,y_act,z_act>,.2+(.3*(1-(cnt_path/ry)))
   hollow
   material{
    texture{ pigment{Clear} }
    interior{
     media{
      emission sin(cnt_path/ry)
      intervals 12
      samples 1, 10
      confidence 0.9999
      variance 1/1000
      density {
       cylindrical
       turbulence 1
       lambda 4
       color_map {
        [0.0 White*.5*(1-sin(pi*cnt_path/ry))+White*.5]
        [1.0 Black]
       }
      }
      scale 5
     }
     media{
      absorption (1-sin(cnt_path/ry))
      intervals 12
      samples 1, 10
      confidence 0.9999
      variance 1/1000
      density {
       cylindrical
       turbulence 1
       lambda 4
       color_map {
        [0.0 White*.5*(sin(pi*cnt_path/ry))+White*.5]
        [1.0 Black]
       }
      }
      scale 5
     }
    }
   }
  }
  #end
  #declare y_ant=y_act;
  #declare z_ant=z_act;
  #declare cnt_path=cnt_path+1;
 #end
  sphere{0,1
   hollow
   material{
    texture{ pigment{ Clear} }
    interior{
     media{
      emission 1
      intervals 12
      samples 1, 10
      confidence 0.9999
      variance 1/1000
      density {
       spherical
       turbulence .3
       lambda 4
       color_map {
        [0.0 Black]
        [1.0 Orange*2+Gold]
       }
       frequency 1
      }
      scale .5
     }
    }
   }
   scale .5
   translate <0,y_act,z_act>
  }
  sphere{0,1
   hollow
   material{
    texture{pigment{Red*4}}
   }
   scale .05
   translate <0,y_act,z_act>
  }
  rotate <0,360*rand(r_smk),0>
 }
 #declare cnt_part=cnt_part+1;
#end
}
